/*
* Copyright 2018 - Present Okta, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
 */

// Code generated by okta openapi generator. DO NOT EDIT.

package okta

import (
	"time"
)

type Org2OrgApplication struct {
	Settings      *Org2OrgApplicationSettings `json:"settings,omitempty"`
	Embedded      interface{}                 `json:"_embedded,omitempty"`
	Links         interface{}                 `json:"_links,omitempty"`
	Accessibility *ApplicationAccessibility   `json:"accessibility,omitempty"`
	Created       *time.Time                  `json:"created,omitempty"`
	Credentials   *ApplicationCredentials     `json:"credentials,omitempty"`
	Features      []string                    `json:"features,omitempty"`
	Id            string                      `json:"id,omitempty"`
	Label         string                      `json:"label,omitempty"`
	LastUpdated   *time.Time                  `json:"lastUpdated,omitempty"`
	Licensing     *ApplicationLicensing       `json:"licensing,omitempty"`
	Name          string                      `json:"name,omitempty"`
	Profile       interface{}                 `json:"profile,omitempty"`
	SignOnMode    string                      `json:"signOnMode,omitempty"`
	Status        string                      `json:"status,omitempty"`
	Visibility    *ApplicationVisibility      `json:"visibility,omitempty"`
}

func NewOrg2OrgApplication() *Org2OrgApplication {
	return &Org2OrgApplication{
		Name: "okta_org2org",
	}
}

func (a *Org2OrgApplication) IsApplicationInstance() bool {
	return true
}
