/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.create.table.ColDataType;

public class ArrayConstructor
extends ASTNodeAccessImpl
implements Expression {
    private ExpressionList<?> expressions;
    private boolean arrayKeyword;
    private ColDataType dataType;

    public ArrayConstructor(ExpressionList<?> expressions, boolean arrayKeyword) {
        this.expressions = expressions;
        this.arrayKeyword = arrayKeyword;
    }

    public ArrayConstructor(Expression ... expressions) {
        this(new ExpressionList(expressions), false);
    }

    public ExpressionList<?> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ExpressionList<?> expressions) {
        this.expressions = expressions;
    }

    public boolean isArrayKeyword() {
        return this.arrayKeyword;
    }

    public void setArrayKeyword(boolean arrayKeyword) {
        this.arrayKeyword = arrayKeyword;
    }

    public ColDataType getDataType() {
        return this.dataType;
    }

    public ArrayConstructor setDataType(ColDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.arrayKeyword) {
            sb.append("ARRAY");
            if (this.dataType != null) {
                sb.append("<").append(this.dataType).append(">");
            }
        }
        sb.append("[");
        sb.append(this.expressions.toString());
        sb.append("]");
        return sb.toString();
    }
}

