------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                        S Y S T E M . U T F _ 3 2                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--          Copyright (C) 2005-2013, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

pragma Compiler_Unit_Warning;

pragma Style_Checks (Off);
--  Allow long lines in this unit. Note this could be more specific, but we
--  keep this simple form because of bootstrap constraints ???

--  pragma Warnings (Off, "non-static constant in preelaborated unit");
--  We need this to be pure, and the three constants in question are not a
--  real problem, they are completely known at compile time. This pragma
--  is commented out for now, because we still want to be able to bootstrap
--  with old versions of the compiler that did not support this form. We
--  have added additional pragma Warnings (Off/On) for now ???

package body System.UTF_32 is

   ----------------------
   -- Character Tables --
   ----------------------

   --  Note these tables are derived from those given in AI-285. For details
   --  see //www.ada-auth.org/cgi-bin/cvsweb.cgi/AIs/AI-00285.TXT?rev=1.22.

   type UTF_32_Range is record
      Lo : UTF_32;
      Hi : UTF_32;
   end record;

   type UTF_32_Ranges is array (Positive range <>) of UTF_32_Range;

   --  The following array includes ranges for all codes with defined unicode
   --  categories (a group of characters is in the same range if and only if
   --  they share the same category, indicated in the comment).

   --  Note that we do not try to take care of FFFE/FFFF cases in this table

   Unicode_Ranges : constant UTF_32_Ranges := (
     (16#00000#, 16#0001F#),  -- (Cc)  <control> .. <control>
     (16#00020#, 16#00020#),  -- (Zs)  SPACE .. SPACE
     (16#00021#, 16#00023#),  -- (Po)  EXCLAMATION MARK .. NUMBER SIGN
     (16#00024#, 16#00024#),  -- (Sc)  DOLLAR SIGN .. DOLLAR SIGN
     (16#00025#, 16#00027#),  -- (Po)  PERCENT SIGN .. APOSTROPHE
     (16#00028#, 16#00028#),  -- (Ps)  LEFT PARENTHESIS .. LEFT PARENTHESIS
     (16#00029#, 16#00029#),  -- (Pe)  RIGHT PARENTHESIS .. RIGHT PARENTHESIS
     (16#0002A#, 16#0002A#),  -- (Po)  ASTERISK .. ASTERISK
     (16#0002B#, 16#0002B#),  -- (Sm)  PLUS SIGN .. PLUS SIGN
     (16#0002C#, 16#0002C#),  -- (Po)  COMMA .. COMMA
     (16#0002D#, 16#0002D#),  -- (Pd)  HYPHEN-MINUS .. HYPHEN-MINUS
     (16#0002E#, 16#0002F#),  -- (Po)  FULL STOP .. SOLIDUS
     (16#00030#, 16#00039#),  -- (Nd)  DIGIT ZERO .. DIGIT NINE
     (16#0003A#, 16#0003B#),  -- (Po)  COLON .. SEMICOLON
     (16#0003C#, 16#0003E#),  -- (Sm)  LESS-THAN SIGN .. GREATER-THAN SIGN
     (16#0003F#, 16#00040#),  -- (Po)  QUESTION MARK .. COMMERCIAL AT
     (16#00041#, 16#0005A#),  -- (Lu)  LATIN CAPITAL LETTER A .. LATIN CAPITAL LETTER Z
     (16#0005B#, 16#0005B#),  -- (Ps)  LEFT SQUARE BRACKET .. LEFT SQUARE BRACKET
     (16#0005C#, 16#0005C#),  -- (Po)  REVERSE SOLIDUS .. REVERSE SOLIDUS
     (16#0005D#, 16#0005D#),  -- (Pe)  RIGHT SQUARE BRACKET .. RIGHT SQUARE BRACKET
     (16#0005E#, 16#0005E#),  -- (Sk)  CIRCUMFLEX ACCENT .. CIRCUMFLEX ACCENT
     (16#0005F#, 16#0005F#),  -- (Pc)  LOW LINE .. LOW LINE
     (16#00060#, 16#00060#),  -- (Sk)  GRAVE ACCENT .. GRAVE ACCENT
     (16#00061#, 16#0007A#),  -- (Ll)  LATIN SMALL LETTER A .. LATIN SMALL LETTER Z
     (16#0007B#, 16#0007B#),  -- (Ps)  LEFT CURLY BRACKET .. LEFT CURLY BRACKET
     (16#0007C#, 16#0007C#),  -- (Sm)  VERTICAL LINE .. VERTICAL LINE
     (16#0007D#, 16#0007D#),  -- (Pe)  RIGHT CURLY BRACKET .. RIGHT CURLY BRACKET
     (16#0007E#, 16#0007E#),  -- (Sm)  TILDE .. TILDE
     (16#0007F#, 16#0009F#),  -- (Cc)  <control> .. <control>
     (16#000A0#, 16#000A0#),  -- (Zs)  NO-BREAK SPACE .. NO-BREAK SPACE
     (16#000A1#, 16#000A1#),  -- (Po)  INVERTED EXCLAMATION MARK .. INVERTED EXCLAMATION MARK
     (16#000A2#, 16#000A5#),  -- (Sc)  CENT SIGN .. YEN SIGN
     (16#000A6#, 16#000A7#),  -- (So)  BROKEN BAR .. SECTION SIGN
     (16#000A8#, 16#000A8#),  -- (Sk)  DIAERESIS .. DIAERESIS
     (16#000A9#, 16#000A9#),  -- (So)  COPYRIGHT SIGN .. COPYRIGHT SIGN
     (16#000AA#, 16#000AA#),  -- (Ll)  FEMININE ORDINAL INDICATOR .. FEMININE ORDINAL INDICATOR
     (16#000AB#, 16#000AB#),  -- (Pi)  LEFT-POINTING DOUBLE ANGLE QUOTATION MARK .. LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
     (16#000AC#, 16#000AC#),  -- (Sm)  NOT SIGN .. NOT SIGN
     (16#000AD#, 16#000AD#),  -- (Cf)  SOFT HYPHEN .. SOFT HYPHEN
     (16#000AE#, 16#000AE#),  -- (So)  REGISTERED SIGN .. REGISTERED SIGN
     (16#000AF#, 16#000AF#),  -- (Sk)  MACRON .. MACRON
     (16#000B0#, 16#000B0#),  -- (So)  DEGREE SIGN .. DEGREE SIGN
     (16#000B1#, 16#000B1#),  -- (Sm)  PLUS-MINUS SIGN .. PLUS-MINUS SIGN
     (16#000B2#, 16#000B3#),  -- (No)  SUPERSCRIPT TWO .. SUPERSCRIPT THREE
     (16#000B4#, 16#000B4#),  -- (Sk)  ACUTE ACCENT .. ACUTE ACCENT
     (16#000B5#, 16#000B5#),  -- (Ll)  MICRO SIGN .. MICRO SIGN
     (16#000B6#, 16#000B6#),  -- (So)  PILCROW SIGN .. PILCROW SIGN
     (16#000B7#, 16#000B7#),  -- (Po)  MIDDLE DOT .. MIDDLE DOT
     (16#000B8#, 16#000B8#),  -- (Sk)  CEDILLA .. CEDILLA
     (16#000B9#, 16#000B9#),  -- (No)  SUPERSCRIPT ONE .. SUPERSCRIPT ONE
     (16#000BA#, 16#000BA#),  -- (Ll)  MASCULINE ORDINAL INDICATOR .. MASCULINE ORDINAL INDICATOR
     (16#000BB#, 16#000BB#),  -- (Pf)  RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK .. RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
     (16#000BC#, 16#000BE#),  -- (No)  VULGAR FRACTION ONE QUARTER .. VULGAR FRACTION THREE QUARTERS
     (16#000BF#, 16#000BF#),  -- (Po)  INVERTED QUESTION MARK .. INVERTED QUESTION MARK
     (16#000C0#, 16#000D6#),  -- (Lu)  LATIN CAPITAL LETTER A WITH GRAVE .. LATIN CAPITAL LETTER O WITH DIAERESIS
     (16#000D7#, 16#000D7#),  -- (Sm)  MULTIPLICATION SIGN .. MULTIPLICATION SIGN
     (16#000D8#, 16#000DE#),  -- (Lu)  LATIN CAPITAL LETTER O WITH STROKE .. LATIN CAPITAL LETTER THORN
     (16#000DF#, 16#000F6#),  -- (Ll)  LATIN SMALL LETTER SHARP S .. LATIN SMALL LETTER O WITH DIAERESIS
     (16#000F7#, 16#000F7#),  -- (Sm)  DIVISION SIGN .. DIVISION SIGN
     (16#000F8#, 16#000FF#),  -- (Ll)  LATIN SMALL LETTER O WITH STROKE .. LATIN SMALL LETTER Y WITH DIAERESIS
     (16#00100#, 16#00100#),  -- (Lu)  LATIN CAPITAL LETTER A WITH MACRON .. LATIN CAPITAL LETTER A WITH MACRON
     (16#00101#, 16#00101#),  -- (Ll)  LATIN SMALL LETTER A WITH MACRON .. LATIN SMALL LETTER A WITH MACRON
     (16#00102#, 16#00102#),  -- (Lu)  LATIN CAPITAL LETTER A WITH BREVE .. LATIN CAPITAL LETTER A WITH BREVE
     (16#00103#, 16#00103#),  -- (Ll)  LATIN SMALL LETTER A WITH BREVE .. LATIN SMALL LETTER A WITH BREVE
     (16#00104#, 16#00104#),  -- (Lu)  LATIN CAPITAL LETTER A WITH OGONEK .. LATIN CAPITAL LETTER A WITH OGONEK
     (16#00105#, 16#00105#),  -- (Ll)  LATIN SMALL LETTER A WITH OGONEK .. LATIN SMALL LETTER A WITH OGONEK
     (16#00106#, 16#00106#),  -- (Lu)  LATIN CAPITAL LETTER C WITH ACUTE .. LATIN CAPITAL LETTER C WITH ACUTE
     (16#00107#, 16#00107#),  -- (Ll)  LATIN SMALL LETTER C WITH ACUTE .. LATIN SMALL LETTER C WITH ACUTE
     (16#00108#, 16#00108#),  -- (Lu)  LATIN CAPITAL LETTER C WITH CIRCUMFLEX .. LATIN CAPITAL LETTER C WITH CIRCUMFLEX
     (16#00109#, 16#00109#),  -- (Ll)  LATIN SMALL LETTER C WITH CIRCUMFLEX .. LATIN SMALL LETTER C WITH CIRCUMFLEX
     (16#0010A#, 16#0010A#),  -- (Lu)  LATIN CAPITAL LETTER C WITH DOT ABOVE .. LATIN CAPITAL LETTER C WITH DOT ABOVE
     (16#0010B#, 16#0010B#),  -- (Ll)  LATIN SMALL LETTER C WITH DOT ABOVE .. LATIN SMALL LETTER C WITH DOT ABOVE
     (16#0010C#, 16#0010C#),  -- (Lu)  LATIN CAPITAL LETTER C WITH CARON .. LATIN CAPITAL LETTER C WITH CARON
     (16#0010D#, 16#0010D#),  -- (Ll)  LATIN SMALL LETTER C WITH CARON .. LATIN SMALL LETTER C WITH CARON
     (16#0010E#, 16#0010E#),  -- (Lu)  LATIN CAPITAL LETTER D WITH CARON .. LATIN CAPITAL LETTER D WITH CARON
     (16#0010F#, 16#0010F#),  -- (Ll)  LATIN SMALL LETTER D WITH CARON .. LATIN SMALL LETTER D WITH CARON
     (16#00110#, 16#00110#),  -- (Lu)  LATIN CAPITAL LETTER D WITH STROKE .. LATIN CAPITAL LETTER D WITH STROKE
     (16#00111#, 16#00111#),  -- (Ll)  LATIN SMALL LETTER D WITH STROKE .. LATIN SMALL LETTER D WITH STROKE
     (16#00112#, 16#00112#),  -- (Lu)  LATIN CAPITAL LETTER E WITH MACRON .. LATIN CAPITAL LETTER E WITH MACRON
     (16#00113#, 16#00113#),  -- (Ll)  LATIN SMALL LETTER E WITH MACRON .. LATIN SMALL LETTER E WITH MACRON
     (16#00114#, 16#00114#),  -- (Lu)  LATIN CAPITAL LETTER E WITH BREVE .. LATIN CAPITAL LETTER E WITH BREVE
     (16#00115#, 16#00115#),  -- (Ll)  LATIN SMALL LETTER E WITH BREVE .. LATIN SMALL LETTER E WITH BREVE
     (16#00116#, 16#00116#),  -- (Lu)  LATIN CAPITAL LETTER E WITH DOT ABOVE .. LATIN CAPITAL LETTER E WITH DOT ABOVE
     (16#00117#, 16#00117#),  -- (Ll)  LATIN SMALL LETTER E WITH DOT ABOVE .. LATIN SMALL LETTER E WITH DOT ABOVE
     (16#00118#, 16#00118#),  -- (Lu)  LATIN CAPITAL LETTER E WITH OGONEK .. LATIN CAPITAL LETTER E WITH OGONEK
     (16#00119#, 16#00119#),  -- (Ll)  LATIN SMALL LETTER E WITH OGONEK .. LATIN SMALL LETTER E WITH OGONEK
     (16#0011A#, 16#0011A#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CARON .. LATIN CAPITAL LETTER E WITH CARON
     (16#0011B#, 16#0011B#),  -- (Ll)  LATIN SMALL LETTER E WITH CARON .. LATIN SMALL LETTER E WITH CARON
     (16#0011C#, 16#0011C#),  -- (Lu)  LATIN CAPITAL LETTER G WITH CIRCUMFLEX .. LATIN CAPITAL LETTER G WITH CIRCUMFLEX
     (16#0011D#, 16#0011D#),  -- (Ll)  LATIN SMALL LETTER G WITH CIRCUMFLEX .. LATIN SMALL LETTER G WITH CIRCUMFLEX
     (16#0011E#, 16#0011E#),  -- (Lu)  LATIN CAPITAL LETTER G WITH BREVE .. LATIN CAPITAL LETTER G WITH BREVE
     (16#0011F#, 16#0011F#),  -- (Ll)  LATIN SMALL LETTER G WITH BREVE .. LATIN SMALL LETTER G WITH BREVE
     (16#00120#, 16#00120#),  -- (Lu)  LATIN CAPITAL LETTER G WITH DOT ABOVE .. LATIN CAPITAL LETTER G WITH DOT ABOVE
     (16#00121#, 16#00121#),  -- (Ll)  LATIN SMALL LETTER G WITH DOT ABOVE .. LATIN SMALL LETTER G WITH DOT ABOVE
     (16#00122#, 16#00122#),  -- (Lu)  LATIN CAPITAL LETTER G WITH CEDILLA .. LATIN CAPITAL LETTER G WITH CEDILLA
     (16#00123#, 16#00123#),  -- (Ll)  LATIN SMALL LETTER G WITH CEDILLA .. LATIN SMALL LETTER G WITH CEDILLA
     (16#00124#, 16#00124#),  -- (Lu)  LATIN CAPITAL LETTER H WITH CIRCUMFLEX .. LATIN CAPITAL LETTER H WITH CIRCUMFLEX
     (16#00125#, 16#00125#),  -- (Ll)  LATIN SMALL LETTER H WITH CIRCUMFLEX .. LATIN SMALL LETTER H WITH CIRCUMFLEX
     (16#00126#, 16#00126#),  -- (Lu)  LATIN CAPITAL LETTER H WITH STROKE .. LATIN CAPITAL LETTER H WITH STROKE
     (16#00127#, 16#00127#),  -- (Ll)  LATIN SMALL LETTER H WITH STROKE .. LATIN SMALL LETTER H WITH STROKE
     (16#00128#, 16#00128#),  -- (Lu)  LATIN CAPITAL LETTER I WITH TILDE .. LATIN CAPITAL LETTER I WITH TILDE
     (16#00129#, 16#00129#),  -- (Ll)  LATIN SMALL LETTER I WITH TILDE .. LATIN SMALL LETTER I WITH TILDE
     (16#0012A#, 16#0012A#),  -- (Lu)  LATIN CAPITAL LETTER I WITH MACRON .. LATIN CAPITAL LETTER I WITH MACRON
     (16#0012B#, 16#0012B#),  -- (Ll)  LATIN SMALL LETTER I WITH MACRON .. LATIN SMALL LETTER I WITH MACRON
     (16#0012C#, 16#0012C#),  -- (Lu)  LATIN CAPITAL LETTER I WITH BREVE .. LATIN CAPITAL LETTER I WITH BREVE
     (16#0012D#, 16#0012D#),  -- (Ll)  LATIN SMALL LETTER I WITH BREVE .. LATIN SMALL LETTER I WITH BREVE
     (16#0012E#, 16#0012E#),  -- (Lu)  LATIN CAPITAL LETTER I WITH OGONEK .. LATIN CAPITAL LETTER I WITH OGONEK
     (16#0012F#, 16#0012F#),  -- (Ll)  LATIN SMALL LETTER I WITH OGONEK .. LATIN SMALL LETTER I WITH OGONEK
     (16#00130#, 16#00130#),  -- (Lu)  LATIN CAPITAL LETTER I WITH DOT ABOVE .. LATIN CAPITAL LETTER I WITH DOT ABOVE
     (16#00131#, 16#00131#),  -- (Ll)  LATIN SMALL LETTER DOTLESS I .. LATIN SMALL LETTER DOTLESS I
     (16#00132#, 16#00132#),  -- (Lu)  LATIN CAPITAL LIGATURE IJ .. LATIN CAPITAL LIGATURE IJ
     (16#00133#, 16#00133#),  -- (Ll)  LATIN SMALL LIGATURE IJ .. LATIN SMALL LIGATURE IJ
     (16#00134#, 16#00134#),  -- (Lu)  LATIN CAPITAL LETTER J WITH CIRCUMFLEX .. LATIN CAPITAL LETTER J WITH CIRCUMFLEX
     (16#00135#, 16#00135#),  -- (Ll)  LATIN SMALL LETTER J WITH CIRCUMFLEX .. LATIN SMALL LETTER J WITH CIRCUMFLEX
     (16#00136#, 16#00136#),  -- (Lu)  LATIN CAPITAL LETTER K WITH CEDILLA .. LATIN CAPITAL LETTER K WITH CEDILLA
     (16#00137#, 16#00138#),  -- (Ll)  LATIN SMALL LETTER K WITH CEDILLA .. LATIN SMALL LETTER KRA
     (16#00139#, 16#00139#),  -- (Lu)  LATIN CAPITAL LETTER L WITH ACUTE .. LATIN CAPITAL LETTER L WITH ACUTE
     (16#0013A#, 16#0013A#),  -- (Ll)  LATIN SMALL LETTER L WITH ACUTE .. LATIN SMALL LETTER L WITH ACUTE
     (16#0013B#, 16#0013B#),  -- (Lu)  LATIN CAPITAL LETTER L WITH CEDILLA .. LATIN CAPITAL LETTER L WITH CEDILLA
     (16#0013C#, 16#0013C#),  -- (Ll)  LATIN SMALL LETTER L WITH CEDILLA .. LATIN SMALL LETTER L WITH CEDILLA
     (16#0013D#, 16#0013D#),  -- (Lu)  LATIN CAPITAL LETTER L WITH CARON .. LATIN CAPITAL LETTER L WITH CARON
     (16#0013E#, 16#0013E#),  -- (Ll)  LATIN SMALL LETTER L WITH CARON .. LATIN SMALL LETTER L WITH CARON
     (16#0013F#, 16#0013F#),  -- (Lu)  LATIN CAPITAL LETTER L WITH MIDDLE DOT .. LATIN CAPITAL LETTER L WITH MIDDLE DOT
     (16#00140#, 16#00140#),  -- (Ll)  LATIN SMALL LETTER L WITH MIDDLE DOT .. LATIN SMALL LETTER L WITH MIDDLE DOT
     (16#00141#, 16#00141#),  -- (Lu)  LATIN CAPITAL LETTER L WITH STROKE .. LATIN CAPITAL LETTER L WITH STROKE
     (16#00142#, 16#00142#),  -- (Ll)  LATIN SMALL LETTER L WITH STROKE .. LATIN SMALL LETTER L WITH STROKE
     (16#00143#, 16#00143#),  -- (Lu)  LATIN CAPITAL LETTER N WITH ACUTE .. LATIN CAPITAL LETTER N WITH ACUTE
     (16#00144#, 16#00144#),  -- (Ll)  LATIN SMALL LETTER N WITH ACUTE .. LATIN SMALL LETTER N WITH ACUTE
     (16#00145#, 16#00145#),  -- (Lu)  LATIN CAPITAL LETTER N WITH CEDILLA .. LATIN CAPITAL LETTER N WITH CEDILLA
     (16#00146#, 16#00146#),  -- (Ll)  LATIN SMALL LETTER N WITH CEDILLA .. LATIN SMALL LETTER N WITH CEDILLA
     (16#00147#, 16#00147#),  -- (Lu)  LATIN CAPITAL LETTER N WITH CARON .. LATIN CAPITAL LETTER N WITH CARON
     (16#00148#, 16#00149#),  -- (Ll)  LATIN SMALL LETTER N WITH CARON .. LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
     (16#0014A#, 16#0014A#),  -- (Lu)  LATIN CAPITAL LETTER ENG .. LATIN CAPITAL LETTER ENG
     (16#0014B#, 16#0014B#),  -- (Ll)  LATIN SMALL LETTER ENG .. LATIN SMALL LETTER ENG
     (16#0014C#, 16#0014C#),  -- (Lu)  LATIN CAPITAL LETTER O WITH MACRON .. LATIN CAPITAL LETTER O WITH MACRON
     (16#0014D#, 16#0014D#),  -- (Ll)  LATIN SMALL LETTER O WITH MACRON .. LATIN SMALL LETTER O WITH MACRON
     (16#0014E#, 16#0014E#),  -- (Lu)  LATIN CAPITAL LETTER O WITH BREVE .. LATIN CAPITAL LETTER O WITH BREVE
     (16#0014F#, 16#0014F#),  -- (Ll)  LATIN SMALL LETTER O WITH BREVE .. LATIN SMALL LETTER O WITH BREVE
     (16#00150#, 16#00150#),  -- (Lu)  LATIN CAPITAL LETTER O WITH DOUBLE ACUTE .. LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
     (16#00151#, 16#00151#),  -- (Ll)  LATIN SMALL LETTER O WITH DOUBLE ACUTE .. LATIN SMALL LETTER O WITH DOUBLE ACUTE
     (16#00152#, 16#00152#),  -- (Lu)  LATIN CAPITAL LIGATURE OE .. LATIN CAPITAL LIGATURE OE
     (16#00153#, 16#00153#),  -- (Ll)  LATIN SMALL LIGATURE OE .. LATIN SMALL LIGATURE OE
     (16#00154#, 16#00154#),  -- (Lu)  LATIN CAPITAL LETTER R WITH ACUTE .. LATIN CAPITAL LETTER R WITH ACUTE
     (16#00155#, 16#00155#),  -- (Ll)  LATIN SMALL LETTER R WITH ACUTE .. LATIN SMALL LETTER R WITH ACUTE
     (16#00156#, 16#00156#),  -- (Lu)  LATIN CAPITAL LETTER R WITH CEDILLA .. LATIN CAPITAL LETTER R WITH CEDILLA
     (16#00157#, 16#00157#),  -- (Ll)  LATIN SMALL LETTER R WITH CEDILLA .. LATIN SMALL LETTER R WITH CEDILLA
     (16#00158#, 16#00158#),  -- (Lu)  LATIN CAPITAL LETTER R WITH CARON .. LATIN CAPITAL LETTER R WITH CARON
     (16#00159#, 16#00159#),  -- (Ll)  LATIN SMALL LETTER R WITH CARON .. LATIN SMALL LETTER R WITH CARON
     (16#0015A#, 16#0015A#),  -- (Lu)  LATIN CAPITAL LETTER S WITH ACUTE .. LATIN CAPITAL LETTER S WITH ACUTE
     (16#0015B#, 16#0015B#),  -- (Ll)  LATIN SMALL LETTER S WITH ACUTE .. LATIN SMALL LETTER S WITH ACUTE
     (16#0015C#, 16#0015C#),  -- (Lu)  LATIN CAPITAL LETTER S WITH CIRCUMFLEX .. LATIN CAPITAL LETTER S WITH CIRCUMFLEX
     (16#0015D#, 16#0015D#),  -- (Ll)  LATIN SMALL LETTER S WITH CIRCUMFLEX .. LATIN SMALL LETTER S WITH CIRCUMFLEX
     (16#0015E#, 16#0015E#),  -- (Lu)  LATIN CAPITAL LETTER S WITH CEDILLA .. LATIN CAPITAL LETTER S WITH CEDILLA
     (16#0015F#, 16#0015F#),  -- (Ll)  LATIN SMALL LETTER S WITH CEDILLA .. LATIN SMALL LETTER S WITH CEDILLA
     (16#00160#, 16#00160#),  -- (Lu)  LATIN CAPITAL LETTER S WITH CARON .. LATIN CAPITAL LETTER S WITH CARON
     (16#00161#, 16#00161#),  -- (Ll)  LATIN SMALL LETTER S WITH CARON .. LATIN SMALL LETTER S WITH CARON
     (16#00162#, 16#00162#),  -- (Lu)  LATIN CAPITAL LETTER T WITH CEDILLA .. LATIN CAPITAL LETTER T WITH CEDILLA
     (16#00163#, 16#00163#),  -- (Ll)  LATIN SMALL LETTER T WITH CEDILLA .. LATIN SMALL LETTER T WITH CEDILLA
     (16#00164#, 16#00164#),  -- (Lu)  LATIN CAPITAL LETTER T WITH CARON .. LATIN CAPITAL LETTER T WITH CARON
     (16#00165#, 16#00165#),  -- (Ll)  LATIN SMALL LETTER T WITH CARON .. LATIN SMALL LETTER T WITH CARON
     (16#00166#, 16#00166#),  -- (Lu)  LATIN CAPITAL LETTER T WITH STROKE .. LATIN CAPITAL LETTER T WITH STROKE
     (16#00167#, 16#00167#),  -- (Ll)  LATIN SMALL LETTER T WITH STROKE .. LATIN SMALL LETTER T WITH STROKE
     (16#00168#, 16#00168#),  -- (Lu)  LATIN CAPITAL LETTER U WITH TILDE .. LATIN CAPITAL LETTER U WITH TILDE
     (16#00169#, 16#00169#),  -- (Ll)  LATIN SMALL LETTER U WITH TILDE .. LATIN SMALL LETTER U WITH TILDE
     (16#0016A#, 16#0016A#),  -- (Lu)  LATIN CAPITAL LETTER U WITH MACRON .. LATIN CAPITAL LETTER U WITH MACRON
     (16#0016B#, 16#0016B#),  -- (Ll)  LATIN SMALL LETTER U WITH MACRON .. LATIN SMALL LETTER U WITH MACRON
     (16#0016C#, 16#0016C#),  -- (Lu)  LATIN CAPITAL LETTER U WITH BREVE .. LATIN CAPITAL LETTER U WITH BREVE
     (16#0016D#, 16#0016D#),  -- (Ll)  LATIN SMALL LETTER U WITH BREVE .. LATIN SMALL LETTER U WITH BREVE
     (16#0016E#, 16#0016E#),  -- (Lu)  LATIN CAPITAL LETTER U WITH RING ABOVE .. LATIN CAPITAL LETTER U WITH RING ABOVE
     (16#0016F#, 16#0016F#),  -- (Ll)  LATIN SMALL LETTER U WITH RING ABOVE .. LATIN SMALL LETTER U WITH RING ABOVE
     (16#00170#, 16#00170#),  -- (Lu)  LATIN CAPITAL LETTER U WITH DOUBLE ACUTE .. LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
     (16#00171#, 16#00171#),  -- (Ll)  LATIN SMALL LETTER U WITH DOUBLE ACUTE .. LATIN SMALL LETTER U WITH DOUBLE ACUTE
     (16#00172#, 16#00172#),  -- (Lu)  LATIN CAPITAL LETTER U WITH OGONEK .. LATIN CAPITAL LETTER U WITH OGONEK
     (16#00173#, 16#00173#),  -- (Ll)  LATIN SMALL LETTER U WITH OGONEK .. LATIN SMALL LETTER U WITH OGONEK
     (16#00174#, 16#00174#),  -- (Lu)  LATIN CAPITAL LETTER W WITH CIRCUMFLEX .. LATIN CAPITAL LETTER W WITH CIRCUMFLEX
     (16#00175#, 16#00175#),  -- (Ll)  LATIN SMALL LETTER W WITH CIRCUMFLEX .. LATIN SMALL LETTER W WITH CIRCUMFLEX
     (16#00176#, 16#00176#),  -- (Lu)  LATIN CAPITAL LETTER Y WITH CIRCUMFLEX .. LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
     (16#00177#, 16#00177#),  -- (Ll)  LATIN SMALL LETTER Y WITH CIRCUMFLEX .. LATIN SMALL LETTER Y WITH CIRCUMFLEX
     (16#00178#, 16#00179#),  -- (Lu)  LATIN CAPITAL LETTER Y WITH DIAERESIS .. LATIN CAPITAL LETTER Z WITH ACUTE
     (16#0017A#, 16#0017A#),  -- (Ll)  LATIN SMALL LETTER Z WITH ACUTE .. LATIN SMALL LETTER Z WITH ACUTE
     (16#0017B#, 16#0017B#),  -- (Lu)  LATIN CAPITAL LETTER Z WITH DOT ABOVE .. LATIN CAPITAL LETTER Z WITH DOT ABOVE
     (16#0017C#, 16#0017C#),  -- (Ll)  LATIN SMALL LETTER Z WITH DOT ABOVE .. LATIN SMALL LETTER Z WITH DOT ABOVE
     (16#0017D#, 16#0017D#),  -- (Lu)  LATIN CAPITAL LETTER Z WITH CARON .. LATIN CAPITAL LETTER Z WITH CARON
     (16#0017E#, 16#00180#),  -- (Ll)  LATIN SMALL LETTER Z WITH CARON .. LATIN SMALL LETTER B WITH STROKE
     (16#00181#, 16#00182#),  -- (Lu)  LATIN CAPITAL LETTER B WITH HOOK .. LATIN CAPITAL LETTER B WITH TOPBAR
     (16#00183#, 16#00183#),  -- (Ll)  LATIN SMALL LETTER B WITH TOPBAR .. LATIN SMALL LETTER B WITH TOPBAR
     (16#00184#, 16#00184#),  -- (Lu)  LATIN CAPITAL LETTER TONE SIX .. LATIN CAPITAL LETTER TONE SIX
     (16#00185#, 16#00185#),  -- (Ll)  LATIN SMALL LETTER TONE SIX .. LATIN SMALL LETTER TONE SIX
     (16#00186#, 16#00187#),  -- (Lu)  LATIN CAPITAL LETTER OPEN O .. LATIN CAPITAL LETTER C WITH HOOK
     (16#00188#, 16#00188#),  -- (Ll)  LATIN SMALL LETTER C WITH HOOK .. LATIN SMALL LETTER C WITH HOOK
     (16#00189#, 16#0018B#),  -- (Lu)  LATIN CAPITAL LETTER AFRICAN D .. LATIN CAPITAL LETTER D WITH TOPBAR
     (16#0018C#, 16#0018D#),  -- (Ll)  LATIN SMALL LETTER D WITH TOPBAR .. LATIN SMALL LETTER TURNED DELTA
     (16#0018E#, 16#00191#),  -- (Lu)  LATIN CAPITAL LETTER REVERSED E .. LATIN CAPITAL LETTER F WITH HOOK
     (16#00192#, 16#00192#),  -- (Ll)  LATIN SMALL LETTER F WITH HOOK .. LATIN SMALL LETTER F WITH HOOK
     (16#00193#, 16#00194#),  -- (Lu)  LATIN CAPITAL LETTER G WITH HOOK .. LATIN CAPITAL LETTER GAMMA
     (16#00195#, 16#00195#),  -- (Ll)  LATIN SMALL LETTER HV .. LATIN SMALL LETTER HV
     (16#00196#, 16#00198#),  -- (Lu)  LATIN CAPITAL LETTER IOTA .. LATIN CAPITAL LETTER K WITH HOOK
     (16#00199#, 16#0019B#),  -- (Ll)  LATIN SMALL LETTER K WITH HOOK .. LATIN SMALL LETTER LAMBDA WITH STROKE
     (16#0019C#, 16#0019D#),  -- (Lu)  LATIN CAPITAL LETTER TURNED M .. LATIN CAPITAL LETTER N WITH LEFT HOOK
     (16#0019E#, 16#0019E#),  -- (Ll)  LATIN SMALL LETTER N WITH LONG RIGHT LEG .. LATIN SMALL LETTER N WITH LONG RIGHT LEG
     (16#0019F#, 16#001A0#),  -- (Lu)  LATIN CAPITAL LETTER O WITH MIDDLE TILDE .. LATIN CAPITAL LETTER O WITH HORN
     (16#001A1#, 16#001A1#),  -- (Ll)  LATIN SMALL LETTER O WITH HORN .. LATIN SMALL LETTER O WITH HORN
     (16#001A2#, 16#001A2#),  -- (Lu)  LATIN CAPITAL LETTER OI .. LATIN CAPITAL LETTER OI
     (16#001A3#, 16#001A3#),  -- (Ll)  LATIN SMALL LETTER OI .. LATIN SMALL LETTER OI
     (16#001A4#, 16#001A4#),  -- (Lu)  LATIN CAPITAL LETTER P WITH HOOK .. LATIN CAPITAL LETTER P WITH HOOK
     (16#001A5#, 16#001A5#),  -- (Ll)  LATIN SMALL LETTER P WITH HOOK .. LATIN SMALL LETTER P WITH HOOK
     (16#001A6#, 16#001A7#),  -- (Lu)  LATIN LETTER YR .. LATIN CAPITAL LETTER TONE TWO
     (16#001A8#, 16#001A8#),  -- (Ll)  LATIN SMALL LETTER TONE TWO .. LATIN SMALL LETTER TONE TWO
     (16#001A9#, 16#001A9#),  -- (Lu)  LATIN CAPITAL LETTER ESH .. LATIN CAPITAL LETTER ESH
     (16#001AA#, 16#001AB#),  -- (Ll)  LATIN LETTER REVERSED ESH LOOP .. LATIN SMALL LETTER T WITH PALATAL HOOK
     (16#001AC#, 16#001AC#),  -- (Lu)  LATIN CAPITAL LETTER T WITH HOOK .. LATIN CAPITAL LETTER T WITH HOOK
     (16#001AD#, 16#001AD#),  -- (Ll)  LATIN SMALL LETTER T WITH HOOK .. LATIN SMALL LETTER T WITH HOOK
     (16#001AE#, 16#001AF#),  -- (Lu)  LATIN CAPITAL LETTER T WITH RETROFLEX HOOK .. LATIN CAPITAL LETTER U WITH HORN
     (16#001B0#, 16#001B0#),  -- (Ll)  LATIN SMALL LETTER U WITH HORN .. LATIN SMALL LETTER U WITH HORN
     (16#001B1#, 16#001B3#),  -- (Lu)  LATIN CAPITAL LETTER UPSILON .. LATIN CAPITAL LETTER Y WITH HOOK
     (16#001B4#, 16#001B4#),  -- (Ll)  LATIN SMALL LETTER Y WITH HOOK .. LATIN SMALL LETTER Y WITH HOOK
     (16#001B5#, 16#001B5#),  -- (Lu)  LATIN CAPITAL LETTER Z WITH STROKE .. LATIN CAPITAL LETTER Z WITH STROKE
     (16#001B6#, 16#001B6#),  -- (Ll)  LATIN SMALL LETTER Z WITH STROKE .. LATIN SMALL LETTER Z WITH STROKE
     (16#001B7#, 16#001B8#),  -- (Lu)  LATIN CAPITAL LETTER EZH .. LATIN CAPITAL LETTER EZH REVERSED
     (16#001B9#, 16#001BA#),  -- (Ll)  LATIN SMALL LETTER EZH REVERSED .. LATIN SMALL LETTER EZH WITH TAIL
     (16#001BB#, 16#001BB#),  -- (Lo)  LATIN LETTER TWO WITH STROKE .. LATIN LETTER TWO WITH STROKE
     (16#001BC#, 16#001BC#),  -- (Lu)  LATIN CAPITAL LETTER TONE FIVE .. LATIN CAPITAL LETTER TONE FIVE
     (16#001BD#, 16#001BF#),  -- (Ll)  LATIN SMALL LETTER TONE FIVE .. LATIN LETTER WYNN
     (16#001C0#, 16#001C3#),  -- (Lo)  LATIN LETTER DENTAL CLICK .. LATIN LETTER RETROFLEX CLICK
     (16#001C4#, 16#001C4#),  -- (Lu)  LATIN CAPITAL LETTER DZ WITH CARON .. LATIN CAPITAL LETTER DZ WITH CARON
     (16#001C5#, 16#001C5#),  -- (Lt)  LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON .. LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
     (16#001C6#, 16#001C6#),  -- (Ll)  LATIN SMALL LETTER DZ WITH CARON .. LATIN SMALL LETTER DZ WITH CARON
     (16#001C7#, 16#001C7#),  -- (Lu)  LATIN CAPITAL LETTER LJ .. LATIN CAPITAL LETTER LJ
     (16#001C8#, 16#001C8#),  -- (Lt)  LATIN CAPITAL LETTER L WITH SMALL LETTER J .. LATIN CAPITAL LETTER L WITH SMALL LETTER J
     (16#001C9#, 16#001C9#),  -- (Ll)  LATIN SMALL LETTER LJ .. LATIN SMALL LETTER LJ
     (16#001CA#, 16#001CA#),  -- (Lu)  LATIN CAPITAL LETTER NJ .. LATIN CAPITAL LETTER NJ
     (16#001CB#, 16#001CB#),  -- (Lt)  LATIN CAPITAL LETTER N WITH SMALL LETTER J .. LATIN CAPITAL LETTER N WITH SMALL LETTER J
     (16#001CC#, 16#001CC#),  -- (Ll)  LATIN SMALL LETTER NJ .. LATIN SMALL LETTER NJ
     (16#001CD#, 16#001CD#),  -- (Lu)  LATIN CAPITAL LETTER A WITH CARON .. LATIN CAPITAL LETTER A WITH CARON
     (16#001CE#, 16#001CE#),  -- (Ll)  LATIN SMALL LETTER A WITH CARON .. LATIN SMALL LETTER A WITH CARON
     (16#001CF#, 16#001CF#),  -- (Lu)  LATIN CAPITAL LETTER I WITH CARON .. LATIN CAPITAL LETTER I WITH CARON
     (16#001D0#, 16#001D0#),  -- (Ll)  LATIN SMALL LETTER I WITH CARON .. LATIN SMALL LETTER I WITH CARON
     (16#001D1#, 16#001D1#),  -- (Lu)  LATIN CAPITAL LETTER O WITH CARON .. LATIN CAPITAL LETTER O WITH CARON
     (16#001D2#, 16#001D2#),  -- (Ll)  LATIN SMALL LETTER O WITH CARON .. LATIN SMALL LETTER O WITH CARON
     (16#001D3#, 16#001D3#),  -- (Lu)  LATIN CAPITAL LETTER U WITH CARON .. LATIN CAPITAL LETTER U WITH CARON
     (16#001D4#, 16#001D4#),  -- (Ll)  LATIN SMALL LETTER U WITH CARON .. LATIN SMALL LETTER U WITH CARON
     (16#001D5#, 16#001D5#),  -- (Lu)  LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
     (16#001D6#, 16#001D6#),  -- (Ll)  LATIN SMALL LETTER U WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
     (16#001D7#, 16#001D7#),  -- (Lu)  LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE .. LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
     (16#001D8#, 16#001D8#),  -- (Ll)  LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
     (16#001D9#, 16#001D9#),  -- (Lu)  LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON .. LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
     (16#001DA#, 16#001DA#),  -- (Ll)  LATIN SMALL LETTER U WITH DIAERESIS AND CARON .. LATIN SMALL LETTER U WITH DIAERESIS AND CARON
     (16#001DB#, 16#001DB#),  -- (Lu)  LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE .. LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
     (16#001DC#, 16#001DD#),  -- (Ll)  LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE .. LATIN SMALL LETTER TURNED E
     (16#001DE#, 16#001DE#),  -- (Lu)  LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
     (16#001DF#, 16#001DF#),  -- (Ll)  LATIN SMALL LETTER A WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
     (16#001E0#, 16#001E0#),  -- (Lu)  LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON .. LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
     (16#001E1#, 16#001E1#),  -- (Ll)  LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
     (16#001E2#, 16#001E2#),  -- (Lu)  LATIN CAPITAL LETTER AE WITH MACRON .. LATIN CAPITAL LETTER AE WITH MACRON
     (16#001E3#, 16#001E3#),  -- (Ll)  LATIN SMALL LETTER AE WITH MACRON .. LATIN SMALL LETTER AE WITH MACRON
     (16#001E4#, 16#001E4#),  -- (Lu)  LATIN CAPITAL LETTER G WITH STROKE .. LATIN CAPITAL LETTER G WITH STROKE
     (16#001E5#, 16#001E5#),  -- (Ll)  LATIN SMALL LETTER G WITH STROKE .. LATIN SMALL LETTER G WITH STROKE
     (16#001E6#, 16#001E6#),  -- (Lu)  LATIN CAPITAL LETTER G WITH CARON .. LATIN CAPITAL LETTER G WITH CARON
     (16#001E7#, 16#001E7#),  -- (Ll)  LATIN SMALL LETTER G WITH CARON .. LATIN SMALL LETTER G WITH CARON
     (16#001E8#, 16#001E8#),  -- (Lu)  LATIN CAPITAL LETTER K WITH CARON .. LATIN CAPITAL LETTER K WITH CARON
     (16#001E9#, 16#001E9#),  -- (Ll)  LATIN SMALL LETTER K WITH CARON .. LATIN SMALL LETTER K WITH CARON
     (16#001EA#, 16#001EA#),  -- (Lu)  LATIN CAPITAL LETTER O WITH OGONEK .. LATIN CAPITAL LETTER O WITH OGONEK
     (16#001EB#, 16#001EB#),  -- (Ll)  LATIN SMALL LETTER O WITH OGONEK .. LATIN SMALL LETTER O WITH OGONEK
     (16#001EC#, 16#001EC#),  -- (Lu)  LATIN CAPITAL LETTER O WITH OGONEK AND MACRON .. LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
     (16#001ED#, 16#001ED#),  -- (Ll)  LATIN SMALL LETTER O WITH OGONEK AND MACRON .. LATIN SMALL LETTER O WITH OGONEK AND MACRON
     (16#001EE#, 16#001EE#),  -- (Lu)  LATIN CAPITAL LETTER EZH WITH CARON .. LATIN CAPITAL LETTER EZH WITH CARON
     (16#001EF#, 16#001F0#),  -- (Ll)  LATIN SMALL LETTER EZH WITH CARON .. LATIN SMALL LETTER J WITH CARON
     (16#001F1#, 16#001F1#),  -- (Lu)  LATIN CAPITAL LETTER DZ .. LATIN CAPITAL LETTER DZ
     (16#001F2#, 16#001F2#),  -- (Lt)  LATIN CAPITAL LETTER D WITH SMALL LETTER Z .. LATIN CAPITAL LETTER D WITH SMALL LETTER Z
     (16#001F3#, 16#001F3#),  -- (Ll)  LATIN SMALL LETTER DZ .. LATIN SMALL LETTER DZ
     (16#001F4#, 16#001F4#),  -- (Lu)  LATIN CAPITAL LETTER G WITH ACUTE .. LATIN CAPITAL LETTER G WITH ACUTE
     (16#001F5#, 16#001F5#),  -- (Ll)  LATIN SMALL LETTER G WITH ACUTE .. LATIN SMALL LETTER G WITH ACUTE
     (16#001F6#, 16#001F8#),  -- (Lu)  LATIN CAPITAL LETTER HWAIR .. LATIN CAPITAL LETTER N WITH GRAVE
     (16#001F9#, 16#001F9#),  -- (Ll)  LATIN SMALL LETTER N WITH GRAVE .. LATIN SMALL LETTER N WITH GRAVE
     (16#001FA#, 16#001FA#),  -- (Lu)  LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE .. LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
     (16#001FB#, 16#001FB#),  -- (Ll)  LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE .. LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
     (16#001FC#, 16#001FC#),  -- (Lu)  LATIN CAPITAL LETTER AE WITH ACUTE .. LATIN CAPITAL LETTER AE WITH ACUTE
     (16#001FD#, 16#001FD#),  -- (Ll)  LATIN SMALL LETTER AE WITH ACUTE .. LATIN SMALL LETTER AE WITH ACUTE
     (16#001FE#, 16#001FE#),  -- (Lu)  LATIN CAPITAL LETTER O WITH STROKE AND ACUTE .. LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
     (16#001FF#, 16#001FF#),  -- (Ll)  LATIN SMALL LETTER O WITH STROKE AND ACUTE .. LATIN SMALL LETTER O WITH STROKE AND ACUTE
     (16#00200#, 16#00200#),  -- (Lu)  LATIN CAPITAL LETTER A WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
     (16#00201#, 16#00201#),  -- (Ll)  LATIN SMALL LETTER A WITH DOUBLE GRAVE .. LATIN SMALL LETTER A WITH DOUBLE GRAVE
     (16#00202#, 16#00202#),  -- (Lu)  LATIN CAPITAL LETTER A WITH INVERTED BREVE .. LATIN CAPITAL LETTER A WITH INVERTED BREVE
     (16#00203#, 16#00203#),  -- (Ll)  LATIN SMALL LETTER A WITH INVERTED BREVE .. LATIN SMALL LETTER A WITH INVERTED BREVE
     (16#00204#, 16#00204#),  -- (Lu)  LATIN CAPITAL LETTER E WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
     (16#00205#, 16#00205#),  -- (Ll)  LATIN SMALL LETTER E WITH DOUBLE GRAVE .. LATIN SMALL LETTER E WITH DOUBLE GRAVE
     (16#00206#, 16#00206#),  -- (Lu)  LATIN CAPITAL LETTER E WITH INVERTED BREVE .. LATIN CAPITAL LETTER E WITH INVERTED BREVE
     (16#00207#, 16#00207#),  -- (Ll)  LATIN SMALL LETTER E WITH INVERTED BREVE .. LATIN SMALL LETTER E WITH INVERTED BREVE
     (16#00208#, 16#00208#),  -- (Lu)  LATIN CAPITAL LETTER I WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
     (16#00209#, 16#00209#),  -- (Ll)  LATIN SMALL LETTER I WITH DOUBLE GRAVE .. LATIN SMALL LETTER I WITH DOUBLE GRAVE
     (16#0020A#, 16#0020A#),  -- (Lu)  LATIN CAPITAL LETTER I WITH INVERTED BREVE .. LATIN CAPITAL LETTER I WITH INVERTED BREVE
     (16#0020B#, 16#0020B#),  -- (Ll)  LATIN SMALL LETTER I WITH INVERTED BREVE .. LATIN SMALL LETTER I WITH INVERTED BREVE
     (16#0020C#, 16#0020C#),  -- (Lu)  LATIN CAPITAL LETTER O WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
     (16#0020D#, 16#0020D#),  -- (Ll)  LATIN SMALL LETTER O WITH DOUBLE GRAVE .. LATIN SMALL LETTER O WITH DOUBLE GRAVE
     (16#0020E#, 16#0020E#),  -- (Lu)  LATIN CAPITAL LETTER O WITH INVERTED BREVE .. LATIN CAPITAL LETTER O WITH INVERTED BREVE
     (16#0020F#, 16#0020F#),  -- (Ll)  LATIN SMALL LETTER O WITH INVERTED BREVE .. LATIN SMALL LETTER O WITH INVERTED BREVE
     (16#00210#, 16#00210#),  -- (Lu)  LATIN CAPITAL LETTER R WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
     (16#00211#, 16#00211#),  -- (Ll)  LATIN SMALL LETTER R WITH DOUBLE GRAVE .. LATIN SMALL LETTER R WITH DOUBLE GRAVE
     (16#00212#, 16#00212#),  -- (Lu)  LATIN CAPITAL LETTER R WITH INVERTED BREVE .. LATIN CAPITAL LETTER R WITH INVERTED BREVE
     (16#00213#, 16#00213#),  -- (Ll)  LATIN SMALL LETTER R WITH INVERTED BREVE .. LATIN SMALL LETTER R WITH INVERTED BREVE
     (16#00214#, 16#00214#),  -- (Lu)  LATIN CAPITAL LETTER U WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
     (16#00215#, 16#00215#),  -- (Ll)  LATIN SMALL LETTER U WITH DOUBLE GRAVE .. LATIN SMALL LETTER U WITH DOUBLE GRAVE
     (16#00216#, 16#00216#),  -- (Lu)  LATIN CAPITAL LETTER U WITH INVERTED BREVE .. LATIN CAPITAL LETTER U WITH INVERTED BREVE
     (16#00217#, 16#00217#),  -- (Ll)  LATIN SMALL LETTER U WITH INVERTED BREVE .. LATIN SMALL LETTER U WITH INVERTED BREVE
     (16#00218#, 16#00218#),  -- (Lu)  LATIN CAPITAL LETTER S WITH COMMA BELOW .. LATIN CAPITAL LETTER S WITH COMMA BELOW
     (16#00219#, 16#00219#),  -- (Ll)  LATIN SMALL LETTER S WITH COMMA BELOW .. LATIN SMALL LETTER S WITH COMMA BELOW
     (16#0021A#, 16#0021A#),  -- (Lu)  LATIN CAPITAL LETTER T WITH COMMA BELOW .. LATIN CAPITAL LETTER T WITH COMMA BELOW
     (16#0021B#, 16#0021B#),  -- (Ll)  LATIN SMALL LETTER T WITH COMMA BELOW .. LATIN SMALL LETTER T WITH COMMA BELOW
     (16#0021C#, 16#0021C#),  -- (Lu)  LATIN CAPITAL LETTER YOGH .. LATIN CAPITAL LETTER YOGH
     (16#0021D#, 16#0021D#),  -- (Ll)  LATIN SMALL LETTER YOGH .. LATIN SMALL LETTER YOGH
     (16#0021E#, 16#0021E#),  -- (Lu)  LATIN CAPITAL LETTER H WITH CARON .. LATIN CAPITAL LETTER H WITH CARON
     (16#0021F#, 16#0021F#),  -- (Ll)  LATIN SMALL LETTER H WITH CARON .. LATIN SMALL LETTER H WITH CARON
     (16#00220#, 16#00220#),  -- (Lu)  LATIN CAPITAL LETTER N WITH LONG RIGHT LEG .. LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
     (16#00221#, 16#00221#),  -- (Ll)  LATIN SMALL LETTER D WITH CURL .. LATIN SMALL LETTER D WITH CURL
     (16#00222#, 16#00222#),  -- (Lu)  LATIN CAPITAL LETTER OU .. LATIN CAPITAL LETTER OU
     (16#00223#, 16#00223#),  -- (Ll)  LATIN SMALL LETTER OU .. LATIN SMALL LETTER OU
     (16#00224#, 16#00224#),  -- (Lu)  LATIN CAPITAL LETTER Z WITH HOOK .. LATIN CAPITAL LETTER Z WITH HOOK
     (16#00225#, 16#00225#),  -- (Ll)  LATIN SMALL LETTER Z WITH HOOK .. LATIN SMALL LETTER Z WITH HOOK
     (16#00226#, 16#00226#),  -- (Lu)  LATIN CAPITAL LETTER A WITH DOT ABOVE .. LATIN CAPITAL LETTER A WITH DOT ABOVE
     (16#00227#, 16#00227#),  -- (Ll)  LATIN SMALL LETTER A WITH DOT ABOVE .. LATIN SMALL LETTER A WITH DOT ABOVE
     (16#00228#, 16#00228#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CEDILLA .. LATIN CAPITAL LETTER E WITH CEDILLA
     (16#00229#, 16#00229#),  -- (Ll)  LATIN SMALL LETTER E WITH CEDILLA .. LATIN SMALL LETTER E WITH CEDILLA
     (16#0022A#, 16#0022A#),  -- (Lu)  LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
     (16#0022B#, 16#0022B#),  -- (Ll)  LATIN SMALL LETTER O WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
     (16#0022C#, 16#0022C#),  -- (Lu)  LATIN CAPITAL LETTER O WITH TILDE AND MACRON .. LATIN CAPITAL LETTER O WITH TILDE AND MACRON
     (16#0022D#, 16#0022D#),  -- (Ll)  LATIN SMALL LETTER O WITH TILDE AND MACRON .. LATIN SMALL LETTER O WITH TILDE AND MACRON
     (16#0022E#, 16#0022E#),  -- (Lu)  LATIN CAPITAL LETTER O WITH DOT ABOVE .. LATIN CAPITAL LETTER O WITH DOT ABOVE
     (16#0022F#, 16#0022F#),  -- (Ll)  LATIN SMALL LETTER O WITH DOT ABOVE .. LATIN SMALL LETTER O WITH DOT ABOVE
     (16#00230#, 16#00230#),  -- (Lu)  LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON .. LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
     (16#00231#, 16#00231#),  -- (Ll)  LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
     (16#00232#, 16#00232#),  -- (Lu)  LATIN CAPITAL LETTER Y WITH MACRON .. LATIN CAPITAL LETTER Y WITH MACRON
     (16#00233#, 16#00236#),  -- (Ll)  LATIN SMALL LETTER Y WITH MACRON .. LATIN SMALL LETTER T WITH CURL
     (16#00250#, 16#002AF#),  -- (Ll)  LATIN SMALL LETTER TURNED A .. LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
     (16#002B0#, 16#002C1#),  -- (Lm)  MODIFIER LETTER SMALL H .. MODIFIER LETTER REVERSED GLOTTAL STOP
     (16#002C2#, 16#002C5#),  -- (Sk)  MODIFIER LETTER LEFT ARROWHEAD .. MODIFIER LETTER DOWN ARROWHEAD
     (16#002C6#, 16#002D1#),  -- (Lm)  MODIFIER LETTER CIRCUMFLEX ACCENT .. MODIFIER LETTER HALF TRIANGULAR COLON
     (16#002D2#, 16#002DF#),  -- (Sk)  MODIFIER LETTER CENTRED RIGHT HALF RING .. MODIFIER LETTER CROSS ACCENT
     (16#002E0#, 16#002E4#),  -- (Lm)  MODIFIER LETTER SMALL GAMMA .. MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
     (16#002E5#, 16#002ED#),  -- (Sk)  MODIFIER LETTER EXTRA-HIGH TONE BAR .. MODIFIER LETTER UNASPIRATED
     (16#002EE#, 16#002EE#),  -- (Lm)  MODIFIER LETTER DOUBLE APOSTROPHE .. MODIFIER LETTER DOUBLE APOSTROPHE
     (16#002EF#, 16#002FF#),  -- (Sk)  MODIFIER LETTER LOW DOWN ARROWHEAD .. MODIFIER LETTER LOW LEFT ARROW
     (16#00300#, 16#00357#),  -- (Mn)  COMBINING GRAVE ACCENT .. COMBINING RIGHT HALF RING ABOVE
     (16#0035D#, 16#0036F#),  -- (Mn)  COMBINING DOUBLE BREVE .. COMBINING LATIN SMALL LETTER X
     (16#00374#, 16#00375#),  -- (Sk)  GREEK NUMERAL SIGN .. GREEK LOWER NUMERAL SIGN
     (16#0037A#, 16#0037A#),  -- (Lm)  GREEK YPOGEGRAMMENI .. GREEK YPOGEGRAMMENI
     (16#0037E#, 16#0037E#),  -- (Po)  GREEK QUESTION MARK .. GREEK QUESTION MARK
     (16#00384#, 16#00385#),  -- (Sk)  GREEK TONOS .. GREEK DIALYTIKA TONOS
     (16#00386#, 16#00386#),  -- (Lu)  GREEK CAPITAL LETTER ALPHA WITH TONOS .. GREEK CAPITAL LETTER ALPHA WITH TONOS
     (16#00387#, 16#00387#),  -- (Po)  GREEK ANO TELEIA .. GREEK ANO TELEIA
     (16#00388#, 16#0038A#),  -- (Lu)  GREEK CAPITAL LETTER EPSILON WITH TONOS .. GREEK CAPITAL LETTER IOTA WITH TONOS
     (16#0038C#, 16#0038C#),  -- (Lu)  GREEK CAPITAL LETTER OMICRON WITH TONOS .. GREEK CAPITAL LETTER OMICRON WITH TONOS
     (16#0038E#, 16#0038F#),  -- (Lu)  GREEK CAPITAL LETTER UPSILON WITH TONOS .. GREEK CAPITAL LETTER OMEGA WITH TONOS
     (16#00390#, 16#00390#),  -- (Ll)  GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS .. GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
     (16#00391#, 16#003A1#),  -- (Lu)  GREEK CAPITAL LETTER ALPHA .. GREEK CAPITAL LETTER RHO
     (16#003A3#, 16#003AB#),  -- (Lu)  GREEK CAPITAL LETTER SIGMA .. GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
     (16#003AC#, 16#003CE#),  -- (Ll)  GREEK SMALL LETTER ALPHA WITH TONOS .. GREEK SMALL LETTER OMEGA WITH TONOS
     (16#003D0#, 16#003D1#),  -- (Ll)  GREEK BETA SYMBOL .. GREEK THETA SYMBOL
     (16#003D2#, 16#003D4#),  -- (Lu)  GREEK UPSILON WITH HOOK SYMBOL .. GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
     (16#003D5#, 16#003D7#),  -- (Ll)  GREEK PHI SYMBOL .. GREEK KAI SYMBOL
     (16#003D8#, 16#003D8#),  -- (Lu)  GREEK LETTER ARCHAIC KOPPA .. GREEK LETTER ARCHAIC KOPPA
     (16#003D9#, 16#003D9#),  -- (Ll)  GREEK SMALL LETTER ARCHAIC KOPPA .. GREEK SMALL LETTER ARCHAIC KOPPA
     (16#003DA#, 16#003DA#),  -- (Lu)  GREEK LETTER STIGMA .. GREEK LETTER STIGMA
     (16#003DB#, 16#003DB#),  -- (Ll)  GREEK SMALL LETTER STIGMA .. GREEK SMALL LETTER STIGMA
     (16#003DC#, 16#003DC#),  -- (Lu)  GREEK LETTER DIGAMMA .. GREEK LETTER DIGAMMA
     (16#003DD#, 16#003DD#),  -- (Ll)  GREEK SMALL LETTER DIGAMMA .. GREEK SMALL LETTER DIGAMMA
     (16#003DE#, 16#003DE#),  -- (Lu)  GREEK LETTER KOPPA .. GREEK LETTER KOPPA
     (16#003DF#, 16#003DF#),  -- (Ll)  GREEK SMALL LETTER KOPPA .. GREEK SMALL LETTER KOPPA
     (16#003E0#, 16#003E0#),  -- (Lu)  GREEK LETTER SAMPI .. GREEK LETTER SAMPI
     (16#003E1#, 16#003E1#),  -- (Ll)  GREEK SMALL LETTER SAMPI .. GREEK SMALL LETTER SAMPI
     (16#003E2#, 16#003E2#),  -- (Lu)  COPTIC CAPITAL LETTER SHEI .. COPTIC CAPITAL LETTER SHEI
     (16#003E3#, 16#003E3#),  -- (Ll)  COPTIC SMALL LETTER SHEI .. COPTIC SMALL LETTER SHEI
     (16#003E4#, 16#003E4#),  -- (Lu)  COPTIC CAPITAL LETTER FEI .. COPTIC CAPITAL LETTER FEI
     (16#003E5#, 16#003E5#),  -- (Ll)  COPTIC SMALL LETTER FEI .. COPTIC SMALL LETTER FEI
     (16#003E6#, 16#003E6#),  -- (Lu)  COPTIC CAPITAL LETTER KHEI .. COPTIC CAPITAL LETTER KHEI
     (16#003E7#, 16#003E7#),  -- (Ll)  COPTIC SMALL LETTER KHEI .. COPTIC SMALL LETTER KHEI
     (16#003E8#, 16#003E8#),  -- (Lu)  COPTIC CAPITAL LETTER HORI .. COPTIC CAPITAL LETTER HORI
     (16#003E9#, 16#003E9#),  -- (Ll)  COPTIC SMALL LETTER HORI .. COPTIC SMALL LETTER HORI
     (16#003EA#, 16#003EA#),  -- (Lu)  COPTIC CAPITAL LETTER GANGIA .. COPTIC CAPITAL LETTER GANGIA
     (16#003EB#, 16#003EB#),  -- (Ll)  COPTIC SMALL LETTER GANGIA .. COPTIC SMALL LETTER GANGIA
     (16#003EC#, 16#003EC#),  -- (Lu)  COPTIC CAPITAL LETTER SHIMA .. COPTIC CAPITAL LETTER SHIMA
     (16#003ED#, 16#003ED#),  -- (Ll)  COPTIC SMALL LETTER SHIMA .. COPTIC SMALL LETTER SHIMA
     (16#003EE#, 16#003EE#),  -- (Lu)  COPTIC CAPITAL LETTER DEI .. COPTIC CAPITAL LETTER DEI
     (16#003EF#, 16#003F3#),  -- (Ll)  COPTIC SMALL LETTER DEI .. GREEK LETTER YOT
     (16#003F4#, 16#003F4#),  -- (Lu)  GREEK CAPITAL THETA SYMBOL .. GREEK CAPITAL THETA SYMBOL
     (16#003F5#, 16#003F5#),  -- (Ll)  GREEK LUNATE EPSILON SYMBOL .. GREEK LUNATE EPSILON SYMBOL
     (16#003F6#, 16#003F6#),  -- (Sm)  GREEK REVERSED LUNATE EPSILON SYMBOL .. GREEK REVERSED LUNATE EPSILON SYMBOL
     (16#003F7#, 16#003F7#),  -- (Lu)  GREEK CAPITAL LETTER SHO .. GREEK CAPITAL LETTER SHO
     (16#003F8#, 16#003F8#),  -- (Ll)  GREEK SMALL LETTER SHO .. GREEK SMALL LETTER SHO
     (16#003F9#, 16#003FA#),  -- (Lu)  GREEK CAPITAL LUNATE SIGMA SYMBOL .. GREEK CAPITAL LETTER SAN
     (16#003FB#, 16#003FB#),  -- (Ll)  GREEK SMALL LETTER SAN .. GREEK SMALL LETTER SAN
     (16#00400#, 16#0042F#),  -- (Lu)  CYRILLIC CAPITAL LETTER IE WITH GRAVE .. CYRILLIC CAPITAL LETTER YA
     (16#00430#, 16#0045F#),  -- (Ll)  CYRILLIC SMALL LETTER A .. CYRILLIC SMALL LETTER DZHE
     (16#00460#, 16#00460#),  -- (Lu)  CYRILLIC CAPITAL LETTER OMEGA .. CYRILLIC CAPITAL LETTER OMEGA
     (16#00461#, 16#00461#),  -- (Ll)  CYRILLIC SMALL LETTER OMEGA .. CYRILLIC SMALL LETTER OMEGA
     (16#00462#, 16#00462#),  -- (Lu)  CYRILLIC CAPITAL LETTER YAT .. CYRILLIC CAPITAL LETTER YAT
     (16#00463#, 16#00463#),  -- (Ll)  CYRILLIC SMALL LETTER YAT .. CYRILLIC SMALL LETTER YAT
     (16#00464#, 16#00464#),  -- (Lu)  CYRILLIC CAPITAL LETTER IOTIFIED E .. CYRILLIC CAPITAL LETTER IOTIFIED E
     (16#00465#, 16#00465#),  -- (Ll)  CYRILLIC SMALL LETTER IOTIFIED E .. CYRILLIC SMALL LETTER IOTIFIED E
     (16#00466#, 16#00466#),  -- (Lu)  CYRILLIC CAPITAL LETTER LITTLE YUS .. CYRILLIC CAPITAL LETTER LITTLE YUS
     (16#00467#, 16#00467#),  -- (Ll)  CYRILLIC SMALL LETTER LITTLE YUS .. CYRILLIC SMALL LETTER LITTLE YUS
     (16#00468#, 16#00468#),  -- (Lu)  CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS .. CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
     (16#00469#, 16#00469#),  -- (Ll)  CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS .. CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
     (16#0046A#, 16#0046A#),  -- (Lu)  CYRILLIC CAPITAL LETTER BIG YUS .. CYRILLIC CAPITAL LETTER BIG YUS
     (16#0046B#, 16#0046B#),  -- (Ll)  CYRILLIC SMALL LETTER BIG YUS .. CYRILLIC SMALL LETTER BIG YUS
     (16#0046C#, 16#0046C#),  -- (Lu)  CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS .. CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
     (16#0046D#, 16#0046D#),  -- (Ll)  CYRILLIC SMALL LETTER IOTIFIED BIG YUS .. CYRILLIC SMALL LETTER IOTIFIED BIG YUS
     (16#0046E#, 16#0046E#),  -- (Lu)  CYRILLIC CAPITAL LETTER KSI .. CYRILLIC CAPITAL LETTER KSI
     (16#0046F#, 16#0046F#),  -- (Ll)  CYRILLIC SMALL LETTER KSI .. CYRILLIC SMALL LETTER KSI
     (16#00470#, 16#00470#),  -- (Lu)  CYRILLIC CAPITAL LETTER PSI .. CYRILLIC CAPITAL LETTER PSI
     (16#00471#, 16#00471#),  -- (Ll)  CYRILLIC SMALL LETTER PSI .. CYRILLIC SMALL LETTER PSI
     (16#00472#, 16#00472#),  -- (Lu)  CYRILLIC CAPITAL LETTER FITA .. CYRILLIC CAPITAL LETTER FITA
     (16#00473#, 16#00473#),  -- (Ll)  CYRILLIC SMALL LETTER FITA .. CYRILLIC SMALL LETTER FITA
     (16#00474#, 16#00474#),  -- (Lu)  CYRILLIC CAPITAL LETTER IZHITSA .. CYRILLIC CAPITAL LETTER IZHITSA
     (16#00475#, 16#00475#),  -- (Ll)  CYRILLIC SMALL LETTER IZHITSA .. CYRILLIC SMALL LETTER IZHITSA
     (16#00476#, 16#00476#),  -- (Lu)  CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
     (16#00477#, 16#00477#),  -- (Ll)  CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
     (16#00478#, 16#00478#),  -- (Lu)  CYRILLIC CAPITAL LETTER UK .. CYRILLIC CAPITAL LETTER UK
     (16#00479#, 16#00479#),  -- (Ll)  CYRILLIC SMALL LETTER UK .. CYRILLIC SMALL LETTER UK
     (16#0047A#, 16#0047A#),  -- (Lu)  CYRILLIC CAPITAL LETTER ROUND OMEGA .. CYRILLIC CAPITAL LETTER ROUND OMEGA
     (16#0047B#, 16#0047B#),  -- (Ll)  CYRILLIC SMALL LETTER ROUND OMEGA .. CYRILLIC SMALL LETTER ROUND OMEGA
     (16#0047C#, 16#0047C#),  -- (Lu)  CYRILLIC CAPITAL LETTER OMEGA WITH TITLO .. CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
     (16#0047D#, 16#0047D#),  -- (Ll)  CYRILLIC SMALL LETTER OMEGA WITH TITLO .. CYRILLIC SMALL LETTER OMEGA WITH TITLO
     (16#0047E#, 16#0047E#),  -- (Lu)  CYRILLIC CAPITAL LETTER OT .. CYRILLIC CAPITAL LETTER OT
     (16#0047F#, 16#0047F#),  -- (Ll)  CYRILLIC SMALL LETTER OT .. CYRILLIC SMALL LETTER OT
     (16#00480#, 16#00480#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOPPA .. CYRILLIC CAPITAL LETTER KOPPA
     (16#00481#, 16#00481#),  -- (Ll)  CYRILLIC SMALL LETTER KOPPA .. CYRILLIC SMALL LETTER KOPPA
     (16#00482#, 16#00482#),  -- (So)  CYRILLIC THOUSANDS SIGN .. CYRILLIC THOUSANDS SIGN
     (16#00483#, 16#00486#),  -- (Mn)  COMBINING CYRILLIC TITLO .. COMBINING CYRILLIC PSILI PNEUMATA
     (16#00488#, 16#00489#),  -- (Me)  COMBINING CYRILLIC HUNDRED THOUSANDS SIGN .. COMBINING CYRILLIC MILLIONS SIGN
     (16#0048A#, 16#0048A#),  -- (Lu)  CYRILLIC CAPITAL LETTER SHORT I WITH TAIL .. CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
     (16#0048B#, 16#0048B#),  -- (Ll)  CYRILLIC SMALL LETTER SHORT I WITH TAIL .. CYRILLIC SMALL LETTER SHORT I WITH TAIL
     (16#0048C#, 16#0048C#),  -- (Lu)  CYRILLIC CAPITAL LETTER SEMISOFT SIGN .. CYRILLIC CAPITAL LETTER SEMISOFT SIGN
     (16#0048D#, 16#0048D#),  -- (Ll)  CYRILLIC SMALL LETTER SEMISOFT SIGN .. CYRILLIC SMALL LETTER SEMISOFT SIGN
     (16#0048E#, 16#0048E#),  -- (Lu)  CYRILLIC CAPITAL LETTER ER WITH TICK .. CYRILLIC CAPITAL LETTER ER WITH TICK
     (16#0048F#, 16#0048F#),  -- (Ll)  CYRILLIC SMALL LETTER ER WITH TICK .. CYRILLIC SMALL LETTER ER WITH TICK
     (16#00490#, 16#00490#),  -- (Lu)  CYRILLIC CAPITAL LETTER GHE WITH UPTURN .. CYRILLIC CAPITAL LETTER GHE WITH UPTURN
     (16#00491#, 16#00491#),  -- (Ll)  CYRILLIC SMALL LETTER GHE WITH UPTURN .. CYRILLIC SMALL LETTER GHE WITH UPTURN
     (16#00492#, 16#00492#),  -- (Lu)  CYRILLIC CAPITAL LETTER GHE WITH STROKE .. CYRILLIC CAPITAL LETTER GHE WITH STROKE
     (16#00493#, 16#00493#),  -- (Ll)  CYRILLIC SMALL LETTER GHE WITH STROKE .. CYRILLIC SMALL LETTER GHE WITH STROKE
     (16#00494#, 16#00494#),  -- (Lu)  CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
     (16#00495#, 16#00495#),  -- (Ll)  CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
     (16#00496#, 16#00496#),  -- (Lu)  CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
     (16#00497#, 16#00497#),  -- (Ll)  CYRILLIC SMALL LETTER ZHE WITH DESCENDER .. CYRILLIC SMALL LETTER ZHE WITH DESCENDER
     (16#00498#, 16#00498#),  -- (Lu)  CYRILLIC CAPITAL LETTER ZE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
     (16#00499#, 16#00499#),  -- (Ll)  CYRILLIC SMALL LETTER ZE WITH DESCENDER .. CYRILLIC SMALL LETTER ZE WITH DESCENDER
     (16#0049A#, 16#0049A#),  -- (Lu)  CYRILLIC CAPITAL LETTER KA WITH DESCENDER .. CYRILLIC CAPITAL LETTER KA WITH DESCENDER
     (16#0049B#, 16#0049B#),  -- (Ll)  CYRILLIC SMALL LETTER KA WITH DESCENDER .. CYRILLIC SMALL LETTER KA WITH DESCENDER
     (16#0049C#, 16#0049C#),  -- (Lu)  CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE .. CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
     (16#0049D#, 16#0049D#),  -- (Ll)  CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
     (16#0049E#, 16#0049E#),  -- (Lu)  CYRILLIC CAPITAL LETTER KA WITH STROKE .. CYRILLIC CAPITAL LETTER KA WITH STROKE
     (16#0049F#, 16#0049F#),  -- (Ll)  CYRILLIC SMALL LETTER KA WITH STROKE .. CYRILLIC SMALL LETTER KA WITH STROKE
     (16#004A0#, 16#004A0#),  -- (Lu)  CYRILLIC CAPITAL LETTER BASHKIR KA .. CYRILLIC CAPITAL LETTER BASHKIR KA
     (16#004A1#, 16#004A1#),  -- (Ll)  CYRILLIC SMALL LETTER BASHKIR KA .. CYRILLIC SMALL LETTER BASHKIR KA
     (16#004A2#, 16#004A2#),  -- (Lu)  CYRILLIC CAPITAL LETTER EN WITH DESCENDER .. CYRILLIC CAPITAL LETTER EN WITH DESCENDER
     (16#004A3#, 16#004A3#),  -- (Ll)  CYRILLIC SMALL LETTER EN WITH DESCENDER .. CYRILLIC SMALL LETTER EN WITH DESCENDER
     (16#004A4#, 16#004A4#),  -- (Lu)  CYRILLIC CAPITAL LIGATURE EN GHE .. CYRILLIC CAPITAL LIGATURE EN GHE
     (16#004A5#, 16#004A5#),  -- (Ll)  CYRILLIC SMALL LIGATURE EN GHE .. CYRILLIC SMALL LIGATURE EN GHE
     (16#004A6#, 16#004A6#),  -- (Lu)  CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK .. CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
     (16#004A7#, 16#004A7#),  -- (Ll)  CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
     (16#004A8#, 16#004A8#),  -- (Lu)  CYRILLIC CAPITAL LETTER ABKHASIAN HA .. CYRILLIC CAPITAL LETTER ABKHASIAN HA
     (16#004A9#, 16#004A9#),  -- (Ll)  CYRILLIC SMALL LETTER ABKHASIAN HA .. CYRILLIC SMALL LETTER ABKHASIAN HA
     (16#004AA#, 16#004AA#),  -- (Lu)  CYRILLIC CAPITAL LETTER ES WITH DESCENDER .. CYRILLIC CAPITAL LETTER ES WITH DESCENDER
     (16#004AB#, 16#004AB#),  -- (Ll)  CYRILLIC SMALL LETTER ES WITH DESCENDER .. CYRILLIC SMALL LETTER ES WITH DESCENDER
     (16#004AC#, 16#004AC#),  -- (Lu)  CYRILLIC CAPITAL LETTER TE WITH DESCENDER .. CYRILLIC CAPITAL LETTER TE WITH DESCENDER
     (16#004AD#, 16#004AD#),  -- (Ll)  CYRILLIC SMALL LETTER TE WITH DESCENDER .. CYRILLIC SMALL LETTER TE WITH DESCENDER
     (16#004AE#, 16#004AE#),  -- (Lu)  CYRILLIC CAPITAL LETTER STRAIGHT U .. CYRILLIC CAPITAL LETTER STRAIGHT U
     (16#004AF#, 16#004AF#),  -- (Ll)  CYRILLIC SMALL LETTER STRAIGHT U .. CYRILLIC SMALL LETTER STRAIGHT U
     (16#004B0#, 16#004B0#),  -- (Lu)  CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE .. CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
     (16#004B1#, 16#004B1#),  -- (Ll)  CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE .. CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
     (16#004B2#, 16#004B2#),  -- (Lu)  CYRILLIC CAPITAL LETTER HA WITH DESCENDER .. CYRILLIC CAPITAL LETTER HA WITH DESCENDER
     (16#004B3#, 16#004B3#),  -- (Ll)  CYRILLIC SMALL LETTER HA WITH DESCENDER .. CYRILLIC SMALL LETTER HA WITH DESCENDER
     (16#004B4#, 16#004B4#),  -- (Lu)  CYRILLIC CAPITAL LIGATURE TE TSE .. CYRILLIC CAPITAL LIGATURE TE TSE
     (16#004B5#, 16#004B5#),  -- (Ll)  CYRILLIC SMALL LIGATURE TE TSE .. CYRILLIC SMALL LIGATURE TE TSE
     (16#004B6#, 16#004B6#),  -- (Lu)  CYRILLIC CAPITAL LETTER CHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
     (16#004B7#, 16#004B7#),  -- (Ll)  CYRILLIC SMALL LETTER CHE WITH DESCENDER .. CYRILLIC SMALL LETTER CHE WITH DESCENDER
     (16#004B8#, 16#004B8#),  -- (Lu)  CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
     (16#004B9#, 16#004B9#),  -- (Ll)  CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
     (16#004BA#, 16#004BA#),  -- (Lu)  CYRILLIC CAPITAL LETTER SHHA .. CYRILLIC CAPITAL LETTER SHHA
     (16#004BB#, 16#004BB#),  -- (Ll)  CYRILLIC SMALL LETTER SHHA .. CYRILLIC SMALL LETTER SHHA
     (16#004BC#, 16#004BC#),  -- (Lu)  CYRILLIC CAPITAL LETTER ABKHASIAN CHE .. CYRILLIC CAPITAL LETTER ABKHASIAN CHE
     (16#004BD#, 16#004BD#),  -- (Ll)  CYRILLIC SMALL LETTER ABKHASIAN CHE .. CYRILLIC SMALL LETTER ABKHASIAN CHE
     (16#004BE#, 16#004BE#),  -- (Lu)  CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
     (16#004BF#, 16#004BF#),  -- (Ll)  CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
     (16#004C0#, 16#004C1#),  -- (Lu)  CYRILLIC LETTER PALOCHKA .. CYRILLIC CAPITAL LETTER ZHE WITH BREVE
     (16#004C2#, 16#004C2#),  -- (Ll)  CYRILLIC SMALL LETTER ZHE WITH BREVE .. CYRILLIC SMALL LETTER ZHE WITH BREVE
     (16#004C3#, 16#004C3#),  -- (Lu)  CYRILLIC CAPITAL LETTER KA WITH HOOK .. CYRILLIC CAPITAL LETTER KA WITH HOOK
     (16#004C4#, 16#004C4#),  -- (Ll)  CYRILLIC SMALL LETTER KA WITH HOOK .. CYRILLIC SMALL LETTER KA WITH HOOK
     (16#004C5#, 16#004C5#),  -- (Lu)  CYRILLIC CAPITAL LETTER EL WITH TAIL .. CYRILLIC CAPITAL LETTER EL WITH TAIL
     (16#004C6#, 16#004C6#),  -- (Ll)  CYRILLIC SMALL LETTER EL WITH TAIL .. CYRILLIC SMALL LETTER EL WITH TAIL
     (16#004C7#, 16#004C7#),  -- (Lu)  CYRILLIC CAPITAL LETTER EN WITH HOOK .. CYRILLIC CAPITAL LETTER EN WITH HOOK
     (16#004C8#, 16#004C8#),  -- (Ll)  CYRILLIC SMALL LETTER EN WITH HOOK .. CYRILLIC SMALL LETTER EN WITH HOOK
     (16#004C9#, 16#004C9#),  -- (Lu)  CYRILLIC CAPITAL LETTER EN WITH TAIL .. CYRILLIC CAPITAL LETTER EN WITH TAIL
     (16#004CA#, 16#004CA#),  -- (Ll)  CYRILLIC SMALL LETTER EN WITH TAIL .. CYRILLIC SMALL LETTER EN WITH TAIL
     (16#004CB#, 16#004CB#),  -- (Lu)  CYRILLIC CAPITAL LETTER KHAKASSIAN CHE .. CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
     (16#004CC#, 16#004CC#),  -- (Ll)  CYRILLIC SMALL LETTER KHAKASSIAN CHE .. CYRILLIC SMALL LETTER KHAKASSIAN CHE
     (16#004CD#, 16#004CD#),  -- (Lu)  CYRILLIC CAPITAL LETTER EM WITH TAIL .. CYRILLIC CAPITAL LETTER EM WITH TAIL
     (16#004CE#, 16#004CE#),  -- (Ll)  CYRILLIC SMALL LETTER EM WITH TAIL .. CYRILLIC SMALL LETTER EM WITH TAIL
     (16#004D0#, 16#004D0#),  -- (Lu)  CYRILLIC CAPITAL LETTER A WITH BREVE .. CYRILLIC CAPITAL LETTER A WITH BREVE
     (16#004D1#, 16#004D1#),  -- (Ll)  CYRILLIC SMALL LETTER A WITH BREVE .. CYRILLIC SMALL LETTER A WITH BREVE
     (16#004D2#, 16#004D2#),  -- (Lu)  CYRILLIC CAPITAL LETTER A WITH DIAERESIS .. CYRILLIC CAPITAL LETTER A WITH DIAERESIS
     (16#004D3#, 16#004D3#),  -- (Ll)  CYRILLIC SMALL LETTER A WITH DIAERESIS .. CYRILLIC SMALL LETTER A WITH DIAERESIS
     (16#004D4#, 16#004D4#),  -- (Lu)  CYRILLIC CAPITAL LIGATURE A IE .. CYRILLIC CAPITAL LIGATURE A IE
     (16#004D5#, 16#004D5#),  -- (Ll)  CYRILLIC SMALL LIGATURE A IE .. CYRILLIC SMALL LIGATURE A IE
     (16#004D6#, 16#004D6#),  -- (Lu)  CYRILLIC CAPITAL LETTER IE WITH BREVE .. CYRILLIC CAPITAL LETTER IE WITH BREVE
     (16#004D7#, 16#004D7#),  -- (Ll)  CYRILLIC SMALL LETTER IE WITH BREVE .. CYRILLIC SMALL LETTER IE WITH BREVE
     (16#004D8#, 16#004D8#),  -- (Lu)  CYRILLIC CAPITAL LETTER SCHWA .. CYRILLIC CAPITAL LETTER SCHWA
     (16#004D9#, 16#004D9#),  -- (Ll)  CYRILLIC SMALL LETTER SCHWA .. CYRILLIC SMALL LETTER SCHWA
     (16#004DA#, 16#004DA#),  -- (Lu)  CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS .. CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
     (16#004DB#, 16#004DB#),  -- (Ll)  CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS .. CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
     (16#004DC#, 16#004DC#),  -- (Lu)  CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
     (16#004DD#, 16#004DD#),  -- (Ll)  CYRILLIC SMALL LETTER ZHE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
     (16#004DE#, 16#004DE#),  -- (Lu)  CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
     (16#004DF#, 16#004DF#),  -- (Ll)  CYRILLIC SMALL LETTER ZE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZE WITH DIAERESIS
     (16#004E0#, 16#004E0#),  -- (Lu)  CYRILLIC CAPITAL LETTER ABKHASIAN DZE .. CYRILLIC CAPITAL LETTER ABKHASIAN DZE
     (16#004E1#, 16#004E1#),  -- (Ll)  CYRILLIC SMALL LETTER ABKHASIAN DZE .. CYRILLIC SMALL LETTER ABKHASIAN DZE
     (16#004E2#, 16#004E2#),  -- (Lu)  CYRILLIC CAPITAL LETTER I WITH MACRON .. CYRILLIC CAPITAL LETTER I WITH MACRON
     (16#004E3#, 16#004E3#),  -- (Ll)  CYRILLIC SMALL LETTER I WITH MACRON .. CYRILLIC SMALL LETTER I WITH MACRON
     (16#004E4#, 16#004E4#),  -- (Lu)  CYRILLIC CAPITAL LETTER I WITH DIAERESIS .. CYRILLIC CAPITAL LETTER I WITH DIAERESIS
     (16#004E5#, 16#004E5#),  -- (Ll)  CYRILLIC SMALL LETTER I WITH DIAERESIS .. CYRILLIC SMALL LETTER I WITH DIAERESIS
     (16#004E6#, 16#004E6#),  -- (Lu)  CYRILLIC CAPITAL LETTER O WITH DIAERESIS .. CYRILLIC CAPITAL LETTER O WITH DIAERESIS
     (16#004E7#, 16#004E7#),  -- (Ll)  CYRILLIC SMALL LETTER O WITH DIAERESIS .. CYRILLIC SMALL LETTER O WITH DIAERESIS
     (16#004E8#, 16#004E8#),  -- (Lu)  CYRILLIC CAPITAL LETTER BARRED O .. CYRILLIC CAPITAL LETTER BARRED O
     (16#004E9#, 16#004E9#),  -- (Ll)  CYRILLIC SMALL LETTER BARRED O .. CYRILLIC SMALL LETTER BARRED O
     (16#004EA#, 16#004EA#),  -- (Lu)  CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS .. CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
     (16#004EB#, 16#004EB#),  -- (Ll)  CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS .. CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
     (16#004EC#, 16#004EC#),  -- (Lu)  CYRILLIC CAPITAL LETTER E WITH DIAERESIS .. CYRILLIC CAPITAL LETTER E WITH DIAERESIS
     (16#004ED#, 16#004ED#),  -- (Ll)  CYRILLIC SMALL LETTER E WITH DIAERESIS .. CYRILLIC SMALL LETTER E WITH DIAERESIS
     (16#004EE#, 16#004EE#),  -- (Lu)  CYRILLIC CAPITAL LETTER U WITH MACRON .. CYRILLIC CAPITAL LETTER U WITH MACRON
     (16#004EF#, 16#004EF#),  -- (Ll)  CYRILLIC SMALL LETTER U WITH MACRON .. CYRILLIC SMALL LETTER U WITH MACRON
     (16#004F0#, 16#004F0#),  -- (Lu)  CYRILLIC CAPITAL LETTER U WITH DIAERESIS .. CYRILLIC CAPITAL LETTER U WITH DIAERESIS
     (16#004F1#, 16#004F1#),  -- (Ll)  CYRILLIC SMALL LETTER U WITH DIAERESIS .. CYRILLIC SMALL LETTER U WITH DIAERESIS
     (16#004F2#, 16#004F2#),  -- (Lu)  CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE .. CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
     (16#004F3#, 16#004F3#),  -- (Ll)  CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE .. CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
     (16#004F4#, 16#004F4#),  -- (Lu)  CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
     (16#004F5#, 16#004F5#),  -- (Ll)  CYRILLIC SMALL LETTER CHE WITH DIAERESIS .. CYRILLIC SMALL LETTER CHE WITH DIAERESIS
     (16#004F8#, 16#004F8#),  -- (Lu)  CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS .. CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
     (16#004F9#, 16#004F9#),  -- (Ll)  CYRILLIC SMALL LETTER YERU WITH DIAERESIS .. CYRILLIC SMALL LETTER YERU WITH DIAERESIS
     (16#00500#, 16#00500#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOMI DE .. CYRILLIC CAPITAL LETTER KOMI DE
     (16#00501#, 16#00501#),  -- (Ll)  CYRILLIC SMALL LETTER KOMI DE .. CYRILLIC SMALL LETTER KOMI DE
     (16#00502#, 16#00502#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOMI DJE .. CYRILLIC CAPITAL LETTER KOMI DJE
     (16#00503#, 16#00503#),  -- (Ll)  CYRILLIC SMALL LETTER KOMI DJE .. CYRILLIC SMALL LETTER KOMI DJE
     (16#00504#, 16#00504#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOMI ZJE .. CYRILLIC CAPITAL LETTER KOMI ZJE
     (16#00505#, 16#00505#),  -- (Ll)  CYRILLIC SMALL LETTER KOMI ZJE .. CYRILLIC SMALL LETTER KOMI ZJE
     (16#00506#, 16#00506#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOMI DZJE .. CYRILLIC CAPITAL LETTER KOMI DZJE
     (16#00507#, 16#00507#),  -- (Ll)  CYRILLIC SMALL LETTER KOMI DZJE .. CYRILLIC SMALL LETTER KOMI DZJE
     (16#00508#, 16#00508#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOMI LJE .. CYRILLIC CAPITAL LETTER KOMI LJE
     (16#00509#, 16#00509#),  -- (Ll)  CYRILLIC SMALL LETTER KOMI LJE .. CYRILLIC SMALL LETTER KOMI LJE
     (16#0050A#, 16#0050A#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOMI NJE .. CYRILLIC CAPITAL LETTER KOMI NJE
     (16#0050B#, 16#0050B#),  -- (Ll)  CYRILLIC SMALL LETTER KOMI NJE .. CYRILLIC SMALL LETTER KOMI NJE
     (16#0050C#, 16#0050C#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOMI SJE .. CYRILLIC CAPITAL LETTER KOMI SJE
     (16#0050D#, 16#0050D#),  -- (Ll)  CYRILLIC SMALL LETTER KOMI SJE .. CYRILLIC SMALL LETTER KOMI SJE
     (16#0050E#, 16#0050E#),  -- (Lu)  CYRILLIC CAPITAL LETTER KOMI TJE .. CYRILLIC CAPITAL LETTER KOMI TJE
     (16#0050F#, 16#0050F#),  -- (Ll)  CYRILLIC SMALL LETTER KOMI TJE .. CYRILLIC SMALL LETTER KOMI TJE
     (16#00531#, 16#00556#),  -- (Lu)  ARMENIAN CAPITAL LETTER AYB .. ARMENIAN CAPITAL LETTER FEH
     (16#00559#, 16#00559#),  -- (Lm)  ARMENIAN MODIFIER LETTER LEFT HALF RING .. ARMENIAN MODIFIER LETTER LEFT HALF RING
     (16#0055A#, 16#0055F#),  -- (Po)  ARMENIAN APOSTROPHE .. ARMENIAN ABBREVIATION MARK
     (16#00561#, 16#00587#),  -- (Ll)  ARMENIAN SMALL LETTER AYB .. ARMENIAN SMALL LIGATURE ECH YIWN
     (16#00589#, 16#00589#),  -- (Po)  ARMENIAN FULL STOP .. ARMENIAN FULL STOP
     (16#0058A#, 16#0058A#),  -- (Pd)  ARMENIAN HYPHEN .. ARMENIAN HYPHEN
     (16#00591#, 16#005A1#),  -- (Mn)  HEBREW ACCENT ETNAHTA .. HEBREW ACCENT PAZER
     (16#005A3#, 16#005B9#),  -- (Mn)  HEBREW ACCENT MUNAH .. HEBREW POINT HOLAM
     (16#005BB#, 16#005BD#),  -- (Mn)  HEBREW POINT QUBUTS .. HEBREW POINT METEG
     (16#005BE#, 16#005BE#),  -- (Po)  HEBREW PUNCTUATION MAQAF .. HEBREW PUNCTUATION MAQAF
     (16#005BF#, 16#005BF#),  -- (Mn)  HEBREW POINT RAFE .. HEBREW POINT RAFE
     (16#005C0#, 16#005C0#),  -- (Po)  HEBREW PUNCTUATION PASEQ .. HEBREW PUNCTUATION PASEQ
     (16#005C1#, 16#005C2#),  -- (Mn)  HEBREW POINT SHIN DOT .. HEBREW POINT SIN DOT
     (16#005C3#, 16#005C3#),  -- (Po)  HEBREW PUNCTUATION SOF PASUQ .. HEBREW PUNCTUATION SOF PASUQ
     (16#005C4#, 16#005C4#),  -- (Mn)  HEBREW MARK UPPER DOT .. HEBREW MARK UPPER DOT
     (16#005D0#, 16#005EA#),  -- (Lo)  HEBREW LETTER ALEF .. HEBREW LETTER TAV
     (16#005F0#, 16#005F2#),  -- (Lo)  HEBREW LIGATURE YIDDISH DOUBLE VAV .. HEBREW LIGATURE YIDDISH DOUBLE YOD
     (16#005F3#, 16#005F4#),  -- (Po)  HEBREW PUNCTUATION GERESH .. HEBREW PUNCTUATION GERSHAYIM
     (16#00600#, 16#00603#),  -- (Cf)  ARABIC NUMBER SIGN .. ARABIC SIGN SAFHA
     (16#0060C#, 16#0060D#),  -- (Po)  ARABIC COMMA .. ARABIC DATE SEPARATOR
     (16#0060E#, 16#0060F#),  -- (So)  ARABIC POETIC VERSE SIGN .. ARABIC SIGN MISRA
     (16#00610#, 16#00615#),  -- (Mn)  ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM .. ARABIC SMALL HIGH TAH
     (16#0061B#, 16#0061B#),  -- (Po)  ARABIC SEMICOLON .. ARABIC SEMICOLON
     (16#0061F#, 16#0061F#),  -- (Po)  ARABIC QUESTION MARK .. ARABIC QUESTION MARK
     (16#00621#, 16#0063A#),  -- (Lo)  ARABIC LETTER HAMZA .. ARABIC LETTER GHAIN
     (16#00640#, 16#00640#),  -- (Lm)  ARABIC TATWEEL .. ARABIC TATWEEL
     (16#00641#, 16#0064A#),  -- (Lo)  ARABIC LETTER FEH .. ARABIC LETTER YEH
     (16#0064B#, 16#00658#),  -- (Mn)  ARABIC FATHATAN .. ARABIC MARK NOON GHUNNA
     (16#00660#, 16#00669#),  -- (Nd)  ARABIC-INDIC DIGIT ZERO .. ARABIC-INDIC DIGIT NINE
     (16#0066A#, 16#0066D#),  -- (Po)  ARABIC PERCENT SIGN .. ARABIC FIVE POINTED STAR
     (16#0066E#, 16#0066F#),  -- (Lo)  ARABIC LETTER DOTLESS BEH .. ARABIC LETTER DOTLESS QAF
     (16#00670#, 16#00670#),  -- (Mn)  ARABIC LETTER SUPERSCRIPT ALEF .. ARABIC LETTER SUPERSCRIPT ALEF
     (16#00671#, 16#006D3#),  -- (Lo)  ARABIC LETTER ALEF WASLA .. ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
     (16#006D4#, 16#006D4#),  -- (Po)  ARABIC FULL STOP .. ARABIC FULL STOP
     (16#006D5#, 16#006D5#),  -- (Lo)  ARABIC LETTER AE .. ARABIC LETTER AE
     (16#006D6#, 16#006DC#),  -- (Mn)  ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA .. ARABIC SMALL HIGH SEEN
     (16#006DD#, 16#006DD#),  -- (Cf)  ARABIC END OF AYAH .. ARABIC END OF AYAH
     (16#006DE#, 16#006DE#),  -- (Me)  ARABIC START OF RUB EL HIZB .. ARABIC START OF RUB EL HIZB
     (16#006DF#, 16#006E4#),  -- (Mn)  ARABIC SMALL HIGH ROUNDED ZERO .. ARABIC SMALL HIGH MADDA
     (16#006E5#, 16#006E6#),  -- (Lm)  ARABIC SMALL WAW .. ARABIC SMALL YEH
     (16#006E7#, 16#006E8#),  -- (Mn)  ARABIC SMALL HIGH YEH .. ARABIC SMALL HIGH NOON
     (16#006E9#, 16#006E9#),  -- (So)  ARABIC PLACE OF SAJDAH .. ARABIC PLACE OF SAJDAH
     (16#006EA#, 16#006ED#),  -- (Mn)  ARABIC EMPTY CENTRE LOW STOP .. ARABIC SMALL LOW MEEM
     (16#006EE#, 16#006EF#),  -- (Lo)  ARABIC LETTER DAL WITH INVERTED V .. ARABIC LETTER REH WITH INVERTED V
     (16#006F0#, 16#006F9#),  -- (Nd)  EXTENDED ARABIC-INDIC DIGIT ZERO .. EXTENDED ARABIC-INDIC DIGIT NINE
     (16#006FA#, 16#006FC#),  -- (Lo)  ARABIC LETTER SHEEN WITH DOT BELOW .. ARABIC LETTER GHAIN WITH DOT BELOW
     (16#006FD#, 16#006FE#),  -- (So)  ARABIC SIGN SINDHI AMPERSAND .. ARABIC SIGN SINDHI POSTPOSITION MEN
     (16#006FF#, 16#006FF#),  -- (Lo)  ARABIC LETTER HEH WITH INVERTED V .. ARABIC LETTER HEH WITH INVERTED V
     (16#00700#, 16#0070D#),  -- (Po)  SYRIAC END OF PARAGRAPH .. SYRIAC HARKLEAN ASTERISCUS
     (16#0070F#, 16#0070F#),  -- (Cf)  SYRIAC ABBREVIATION MARK .. SYRIAC ABBREVIATION MARK
     (16#00710#, 16#00710#),  -- (Lo)  SYRIAC LETTER ALAPH .. SYRIAC LETTER ALAPH
     (16#00711#, 16#00711#),  -- (Mn)  SYRIAC LETTER SUPERSCRIPT ALAPH .. SYRIAC LETTER SUPERSCRIPT ALAPH
     (16#00712#, 16#0072F#),  -- (Lo)  SYRIAC LETTER BETH .. SYRIAC LETTER PERSIAN DHALATH
     (16#00730#, 16#0074A#),  -- (Mn)  SYRIAC PTHAHA ABOVE .. SYRIAC BARREKH
     (16#0074D#, 16#0074F#),  -- (Lo)  SYRIAC LETTER SOGDIAN ZHAIN .. SYRIAC LETTER SOGDIAN FE
     (16#00780#, 16#007A5#),  -- (Lo)  THAANA LETTER HAA .. THAANA LETTER WAAVU
     (16#007A6#, 16#007B0#),  -- (Mn)  THAANA ABAFILI .. THAANA SUKUN
     (16#007B1#, 16#007B1#),  -- (Lo)  THAANA LETTER NAA .. THAANA LETTER NAA
     (16#00901#, 16#00902#),  -- (Mn)  DEVANAGARI SIGN CANDRABINDU .. DEVANAGARI SIGN ANUSVARA
     (16#00903#, 16#00903#),  -- (Mc)  DEVANAGARI SIGN VISARGA .. DEVANAGARI SIGN VISARGA
     (16#00904#, 16#00939#),  -- (Lo)  DEVANAGARI LETTER SHORT A .. DEVANAGARI LETTER HA
     (16#0093C#, 16#0093C#),  -- (Mn)  DEVANAGARI SIGN NUKTA .. DEVANAGARI SIGN NUKTA
     (16#0093D#, 16#0093D#),  -- (Lo)  DEVANAGARI SIGN AVAGRAHA .. DEVANAGARI SIGN AVAGRAHA
     (16#0093E#, 16#00940#),  -- (Mc)  DEVANAGARI VOWEL SIGN AA .. DEVANAGARI VOWEL SIGN II
     (16#00941#, 16#00948#),  -- (Mn)  DEVANAGARI VOWEL SIGN U .. DEVANAGARI VOWEL SIGN AI
     (16#00949#, 16#0094C#),  -- (Mc)  DEVANAGARI VOWEL SIGN CANDRA O .. DEVANAGARI VOWEL SIGN AU
     (16#0094D#, 16#0094D#),  -- (Mn)  DEVANAGARI SIGN VIRAMA .. DEVANAGARI SIGN VIRAMA
     (16#00950#, 16#00950#),  -- (Lo)  DEVANAGARI OM .. DEVANAGARI OM
     (16#00951#, 16#00954#),  -- (Mn)  DEVANAGARI STRESS SIGN UDATTA .. DEVANAGARI ACUTE ACCENT
     (16#00958#, 16#00961#),  -- (Lo)  DEVANAGARI LETTER QA .. DEVANAGARI LETTER VOCALIC LL
     (16#00962#, 16#00963#),  -- (Mn)  DEVANAGARI VOWEL SIGN VOCALIC L .. DEVANAGARI VOWEL SIGN VOCALIC LL
     (16#00964#, 16#00965#),  -- (Po)  DEVANAGARI DANDA .. DEVANAGARI DOUBLE DANDA
     (16#00966#, 16#0096F#),  -- (Nd)  DEVANAGARI DIGIT ZERO .. DEVANAGARI DIGIT NINE
     (16#00970#, 16#00970#),  -- (Po)  DEVANAGARI ABBREVIATION SIGN .. DEVANAGARI ABBREVIATION SIGN
     (16#00981#, 16#00981#),  -- (Mn)  BENGALI SIGN CANDRABINDU .. BENGALI SIGN CANDRABINDU
     (16#00982#, 16#00983#),  -- (Mc)  BENGALI SIGN ANUSVARA .. BENGALI SIGN VISARGA
     (16#00985#, 16#0098C#),  -- (Lo)  BENGALI LETTER A .. BENGALI LETTER VOCALIC L
     (16#0098F#, 16#00990#),  -- (Lo)  BENGALI LETTER E .. BENGALI LETTER AI
     (16#00993#, 16#009A8#),  -- (Lo)  BENGALI LETTER O .. BENGALI LETTER NA
     (16#009AA#, 16#009B0#),  -- (Lo)  BENGALI LETTER PA .. BENGALI LETTER RA
     (16#009B2#, 16#009B2#),  -- (Lo)  BENGALI LETTER LA .. BENGALI LETTER LA
     (16#009B6#, 16#009B9#),  -- (Lo)  BENGALI LETTER SHA .. BENGALI LETTER HA
     (16#009BC#, 16#009BC#),  -- (Mn)  BENGALI SIGN NUKTA .. BENGALI SIGN NUKTA
     (16#009BD#, 16#009BD#),  -- (Lo)  BENGALI SIGN AVAGRAHA .. BENGALI SIGN AVAGRAHA
     (16#009BE#, 16#009C0#),  -- (Mc)  BENGALI VOWEL SIGN AA .. BENGALI VOWEL SIGN II
     (16#009C1#, 16#009C4#),  -- (Mn)  BENGALI VOWEL SIGN U .. BENGALI VOWEL SIGN VOCALIC RR
     (16#009C7#, 16#009C8#),  -- (Mc)  BENGALI VOWEL SIGN E .. BENGALI VOWEL SIGN AI
     (16#009CB#, 16#009CC#),  -- (Mc)  BENGALI VOWEL SIGN O .. BENGALI VOWEL SIGN AU
     (16#009CD#, 16#009CD#),  -- (Mn)  BENGALI SIGN VIRAMA .. BENGALI SIGN VIRAMA
     (16#009D7#, 16#009D7#),  -- (Mc)  BENGALI AU LENGTH MARK .. BENGALI AU LENGTH MARK
     (16#009DC#, 16#009DD#),  -- (Lo)  BENGALI LETTER RRA .. BENGALI LETTER RHA
     (16#009DF#, 16#009E1#),  -- (Lo)  BENGALI LETTER YYA .. BENGALI LETTER VOCALIC LL
     (16#009E2#, 16#009E3#),  -- (Mn)  BENGALI VOWEL SIGN VOCALIC L .. BENGALI VOWEL SIGN VOCALIC LL
     (16#009E6#, 16#009EF#),  -- (Nd)  BENGALI DIGIT ZERO .. BENGALI DIGIT NINE
     (16#009F0#, 16#009F1#),  -- (Lo)  BENGALI LETTER RA WITH MIDDLE DIAGONAL .. BENGALI LETTER RA WITH LOWER DIAGONAL
     (16#009F2#, 16#009F3#),  -- (Sc)  BENGALI RUPEE MARK .. BENGALI RUPEE SIGN
     (16#009F4#, 16#009F9#),  -- (No)  BENGALI CURRENCY NUMERATOR ONE .. BENGALI CURRENCY DENOMINATOR SIXTEEN
     (16#009FA#, 16#009FA#),  -- (So)  BENGALI ISSHAR .. BENGALI ISSHAR
     (16#00A01#, 16#00A02#),  -- (Mn)  GURMUKHI SIGN ADAK BINDI .. GURMUKHI SIGN BINDI
     (16#00A03#, 16#00A03#),  -- (Mc)  GURMUKHI SIGN VISARGA .. GURMUKHI SIGN VISARGA
     (16#00A05#, 16#00A0A#),  -- (Lo)  GURMUKHI LETTER A .. GURMUKHI LETTER UU
     (16#00A0F#, 16#00A10#),  -- (Lo)  GURMUKHI LETTER EE .. GURMUKHI LETTER AI
     (16#00A13#, 16#00A28#),  -- (Lo)  GURMUKHI LETTER OO .. GURMUKHI LETTER NA
     (16#00A2A#, 16#00A30#),  -- (Lo)  GURMUKHI LETTER PA .. GURMUKHI LETTER RA
     (16#00A32#, 16#00A33#),  -- (Lo)  GURMUKHI LETTER LA .. GURMUKHI LETTER LLA
     (16#00A35#, 16#00A36#),  -- (Lo)  GURMUKHI LETTER VA .. GURMUKHI LETTER SHA
     (16#00A38#, 16#00A39#),  -- (Lo)  GURMUKHI LETTER SA .. GURMUKHI LETTER HA
     (16#00A3C#, 16#00A3C#),  -- (Mn)  GURMUKHI SIGN NUKTA .. GURMUKHI SIGN NUKTA
     (16#00A3E#, 16#00A40#),  -- (Mc)  GURMUKHI VOWEL SIGN AA .. GURMUKHI VOWEL SIGN II
     (16#00A41#, 16#00A42#),  -- (Mn)  GURMUKHI VOWEL SIGN U .. GURMUKHI VOWEL SIGN UU
     (16#00A47#, 16#00A48#),  -- (Mn)  GURMUKHI VOWEL SIGN EE .. GURMUKHI VOWEL SIGN AI
     (16#00A4B#, 16#00A4D#),  -- (Mn)  GURMUKHI VOWEL SIGN OO .. GURMUKHI SIGN VIRAMA
     (16#00A59#, 16#00A5C#),  -- (Lo)  GURMUKHI LETTER KHHA .. GURMUKHI LETTER RRA
     (16#00A5E#, 16#00A5E#),  -- (Lo)  GURMUKHI LETTER FA .. GURMUKHI LETTER FA
     (16#00A66#, 16#00A6F#),  -- (Nd)  GURMUKHI DIGIT ZERO .. GURMUKHI DIGIT NINE
     (16#00A70#, 16#00A71#),  -- (Mn)  GURMUKHI TIPPI .. GURMUKHI ADDAK
     (16#00A72#, 16#00A74#),  -- (Lo)  GURMUKHI IRI .. GURMUKHI EK ONKAR
     (16#00A81#, 16#00A82#),  -- (Mn)  GUJARATI SIGN CANDRABINDU .. GUJARATI SIGN ANUSVARA
     (16#00A83#, 16#00A83#),  -- (Mc)  GUJARATI SIGN VISARGA .. GUJARATI SIGN VISARGA
     (16#00A85#, 16#00A8D#),  -- (Lo)  GUJARATI LETTER A .. GUJARATI VOWEL CANDRA E
     (16#00A8F#, 16#00A91#),  -- (Lo)  GUJARATI LETTER E .. GUJARATI VOWEL CANDRA O
     (16#00A93#, 16#00AA8#),  -- (Lo)  GUJARATI LETTER O .. GUJARATI LETTER NA
     (16#00AAA#, 16#00AB0#),  -- (Lo)  GUJARATI LETTER PA .. GUJARATI LETTER RA
     (16#00AB2#, 16#00AB3#),  -- (Lo)  GUJARATI LETTER LA .. GUJARATI LETTER LLA
     (16#00AB5#, 16#00AB9#),  -- (Lo)  GUJARATI LETTER VA .. GUJARATI LETTER HA
     (16#00ABC#, 16#00ABC#),  -- (Mn)  GUJARATI SIGN NUKTA .. GUJARATI SIGN NUKTA
     (16#00ABD#, 16#00ABD#),  -- (Lo)  GUJARATI SIGN AVAGRAHA .. GUJARATI SIGN AVAGRAHA
     (16#00ABE#, 16#00AC0#),  -- (Mc)  GUJARATI VOWEL SIGN AA .. GUJARATI VOWEL SIGN II
     (16#00AC1#, 16#00AC5#),  -- (Mn)  GUJARATI VOWEL SIGN U .. GUJARATI VOWEL SIGN CANDRA E
     (16#00AC7#, 16#00AC8#),  -- (Mn)  GUJARATI VOWEL SIGN E .. GUJARATI VOWEL SIGN AI
     (16#00AC9#, 16#00AC9#),  -- (Mc)  GUJARATI VOWEL SIGN CANDRA O .. GUJARATI VOWEL SIGN CANDRA O
     (16#00ACB#, 16#00ACC#),  -- (Mc)  GUJARATI VOWEL SIGN O .. GUJARATI VOWEL SIGN AU
     (16#00ACD#, 16#00ACD#),  -- (Mn)  GUJARATI SIGN VIRAMA .. GUJARATI SIGN VIRAMA
     (16#00AD0#, 16#00AD0#),  -- (Lo)  GUJARATI OM .. GUJARATI OM
     (16#00AE0#, 16#00AE1#),  -- (Lo)  GUJARATI LETTER VOCALIC RR .. GUJARATI LETTER VOCALIC LL
     (16#00AE2#, 16#00AE3#),  -- (Mn)  GUJARATI VOWEL SIGN VOCALIC L .. GUJARATI VOWEL SIGN VOCALIC LL
     (16#00AE6#, 16#00AEF#),  -- (Nd)  GUJARATI DIGIT ZERO .. GUJARATI DIGIT NINE
     (16#00AF1#, 16#00AF1#),  -- (Sc)  GUJARATI RUPEE SIGN .. GUJARATI RUPEE SIGN
     (16#00B01#, 16#00B01#),  -- (Mn)  ORIYA SIGN CANDRABINDU .. ORIYA SIGN CANDRABINDU
     (16#00B02#, 16#00B03#),  -- (Mc)  ORIYA SIGN ANUSVARA .. ORIYA SIGN VISARGA
     (16#00B05#, 16#00B0C#),  -- (Lo)  ORIYA LETTER A .. ORIYA LETTER VOCALIC L
     (16#00B0F#, 16#00B10#),  -- (Lo)  ORIYA LETTER E .. ORIYA LETTER AI
     (16#00B13#, 16#00B28#),  -- (Lo)  ORIYA LETTER O .. ORIYA LETTER NA
     (16#00B2A#, 16#00B30#),  -- (Lo)  ORIYA LETTER PA .. ORIYA LETTER RA
     (16#00B32#, 16#00B33#),  -- (Lo)  ORIYA LETTER LA .. ORIYA LETTER LLA
     (16#00B35#, 16#00B39#),  -- (Lo)  ORIYA LETTER VA .. ORIYA LETTER HA
     (16#00B3C#, 16#00B3C#),  -- (Mn)  ORIYA SIGN NUKTA .. ORIYA SIGN NUKTA
     (16#00B3D#, 16#00B3D#),  -- (Lo)  ORIYA SIGN AVAGRAHA .. ORIYA SIGN AVAGRAHA
     (16#00B3E#, 16#00B3E#),  -- (Mc)  ORIYA VOWEL SIGN AA .. ORIYA VOWEL SIGN AA
     (16#00B3F#, 16#00B3F#),  -- (Mn)  ORIYA VOWEL SIGN I .. ORIYA VOWEL SIGN I
     (16#00B40#, 16#00B40#),  -- (Mc)  ORIYA VOWEL SIGN II .. ORIYA VOWEL SIGN II
     (16#00B41#, 16#00B43#),  -- (Mn)  ORIYA VOWEL SIGN U .. ORIYA VOWEL SIGN VOCALIC R
     (16#00B47#, 16#00B48#),  -- (Mc)  ORIYA VOWEL SIGN E .. ORIYA VOWEL SIGN AI
     (16#00B4B#, 16#00B4C#),  -- (Mc)  ORIYA VOWEL SIGN O .. ORIYA VOWEL SIGN AU
     (16#00B4D#, 16#00B4D#),  -- (Mn)  ORIYA SIGN VIRAMA .. ORIYA SIGN VIRAMA
     (16#00B56#, 16#00B56#),  -- (Mn)  ORIYA AI LENGTH MARK .. ORIYA AI LENGTH MARK
     (16#00B57#, 16#00B57#),  -- (Mc)  ORIYA AU LENGTH MARK .. ORIYA AU LENGTH MARK
     (16#00B5C#, 16#00B5D#),  -- (Lo)  ORIYA LETTER RRA .. ORIYA LETTER RHA
     (16#00B5F#, 16#00B61#),  -- (Lo)  ORIYA LETTER YYA .. ORIYA LETTER VOCALIC LL
     (16#00B66#, 16#00B6F#),  -- (Nd)  ORIYA DIGIT ZERO .. ORIYA DIGIT NINE
     (16#00B70#, 16#00B70#),  -- (So)  ORIYA ISSHAR .. ORIYA ISSHAR
     (16#00B71#, 16#00B71#),  -- (Lo)  ORIYA LETTER WA .. ORIYA LETTER WA
     (16#00B82#, 16#00B82#),  -- (Mn)  TAMIL SIGN ANUSVARA .. TAMIL SIGN ANUSVARA
     (16#00B83#, 16#00B83#),  -- (Lo)  TAMIL SIGN VISARGA .. TAMIL SIGN VISARGA
     (16#00B85#, 16#00B8A#),  -- (Lo)  TAMIL LETTER A .. TAMIL LETTER UU
     (16#00B8E#, 16#00B90#),  -- (Lo)  TAMIL LETTER E .. TAMIL LETTER AI
     (16#00B92#, 16#00B95#),  -- (Lo)  TAMIL LETTER O .. TAMIL LETTER KA
     (16#00B99#, 16#00B9A#),  -- (Lo)  TAMIL LETTER NGA .. TAMIL LETTER CA
     (16#00B9C#, 16#00B9C#),  -- (Lo)  TAMIL LETTER JA .. TAMIL LETTER JA
     (16#00B9E#, 16#00B9F#),  -- (Lo)  TAMIL LETTER NYA .. TAMIL LETTER TTA
     (16#00BA3#, 16#00BA4#),  -- (Lo)  TAMIL LETTER NNA .. TAMIL LETTER TA
     (16#00BA8#, 16#00BAA#),  -- (Lo)  TAMIL LETTER NA .. TAMIL LETTER PA
     (16#00BAE#, 16#00BB5#),  -- (Lo)  TAMIL LETTER MA .. TAMIL LETTER VA
     (16#00BB7#, 16#00BB9#),  -- (Lo)  TAMIL LETTER SSA .. TAMIL LETTER HA
     (16#00BBE#, 16#00BBF#),  -- (Mc)  TAMIL VOWEL SIGN AA .. TAMIL VOWEL SIGN I
     (16#00BC0#, 16#00BC0#),  -- (Mn)  TAMIL VOWEL SIGN II .. TAMIL VOWEL SIGN II
     (16#00BC1#, 16#00BC2#),  -- (Mc)  TAMIL VOWEL SIGN U .. TAMIL VOWEL SIGN UU
     (16#00BC6#, 16#00BC8#),  -- (Mc)  TAMIL VOWEL SIGN E .. TAMIL VOWEL SIGN AI
     (16#00BCA#, 16#00BCC#),  -- (Mc)  TAMIL VOWEL SIGN O .. TAMIL VOWEL SIGN AU
     (16#00BCD#, 16#00BCD#),  -- (Mn)  TAMIL SIGN VIRAMA .. TAMIL SIGN VIRAMA
     (16#00BD7#, 16#00BD7#),  -- (Mc)  TAMIL AU LENGTH MARK .. TAMIL AU LENGTH MARK
     (16#00BE7#, 16#00BEF#),  -- (Nd)  TAMIL DIGIT ONE .. TAMIL DIGIT NINE
     (16#00BF0#, 16#00BF2#),  -- (No)  TAMIL NUMBER TEN .. TAMIL NUMBER ONE THOUSAND
     (16#00BF3#, 16#00BF8#),  -- (So)  TAMIL DAY SIGN .. TAMIL AS ABOVE SIGN
     (16#00BF9#, 16#00BF9#),  -- (Sc)  TAMIL RUPEE SIGN .. TAMIL RUPEE SIGN
     (16#00BFA#, 16#00BFA#),  -- (So)  TAMIL NUMBER SIGN .. TAMIL NUMBER SIGN
     (16#00C01#, 16#00C03#),  -- (Mc)  TELUGU SIGN CANDRABINDU .. TELUGU SIGN VISARGA
     (16#00C05#, 16#00C0C#),  -- (Lo)  TELUGU LETTER A .. TELUGU LETTER VOCALIC L
     (16#00C0E#, 16#00C10#),  -- (Lo)  TELUGU LETTER E .. TELUGU LETTER AI
     (16#00C12#, 16#00C28#),  -- (Lo)  TELUGU LETTER O .. TELUGU LETTER NA
     (16#00C2A#, 16#00C33#),  -- (Lo)  TELUGU LETTER PA .. TELUGU LETTER LLA
     (16#00C35#, 16#00C39#),  -- (Lo)  TELUGU LETTER VA .. TELUGU LETTER HA
     (16#00C3E#, 16#00C40#),  -- (Mn)  TELUGU VOWEL SIGN AA .. TELUGU VOWEL SIGN II
     (16#00C41#, 16#00C44#),  -- (Mc)  TELUGU VOWEL SIGN U .. TELUGU VOWEL SIGN VOCALIC RR
     (16#00C46#, 16#00C48#),  -- (Mn)  TELUGU VOWEL SIGN E .. TELUGU VOWEL SIGN AI
     (16#00C4A#, 16#00C4D#),  -- (Mn)  TELUGU VOWEL SIGN O .. TELUGU SIGN VIRAMA
     (16#00C55#, 16#00C56#),  -- (Mn)  TELUGU LENGTH MARK .. TELUGU AI LENGTH MARK
     (16#00C60#, 16#00C61#),  -- (Lo)  TELUGU LETTER VOCALIC RR .. TELUGU LETTER VOCALIC LL
     (16#00C66#, 16#00C6F#),  -- (Nd)  TELUGU DIGIT ZERO .. TELUGU DIGIT NINE
     (16#00C82#, 16#00C83#),  -- (Mc)  KANNADA SIGN ANUSVARA .. KANNADA SIGN VISARGA
     (16#00C85#, 16#00C8C#),  -- (Lo)  KANNADA LETTER A .. KANNADA LETTER VOCALIC L
     (16#00C8E#, 16#00C90#),  -- (Lo)  KANNADA LETTER E .. KANNADA LETTER AI
     (16#00C92#, 16#00CA8#),  -- (Lo)  KANNADA LETTER O .. KANNADA LETTER NA
     (16#00CAA#, 16#00CB3#),  -- (Lo)  KANNADA LETTER PA .. KANNADA LETTER LLA
     (16#00CB5#, 16#00CB9#),  -- (Lo)  KANNADA LETTER VA .. KANNADA LETTER HA
     (16#00CBC#, 16#00CBC#),  -- (Mn)  KANNADA SIGN NUKTA .. KANNADA SIGN NUKTA
     (16#00CBD#, 16#00CBD#),  -- (Lo)  KANNADA SIGN AVAGRAHA .. KANNADA SIGN AVAGRAHA
     (16#00CBE#, 16#00CBE#),  -- (Mc)  KANNADA VOWEL SIGN AA .. KANNADA VOWEL SIGN AA
     (16#00CBF#, 16#00CBF#),  -- (Mn)  KANNADA VOWEL SIGN I .. KANNADA VOWEL SIGN I
     (16#00CC0#, 16#00CC4#),  -- (Mc)  KANNADA VOWEL SIGN II .. KANNADA VOWEL SIGN VOCALIC RR
     (16#00CC6#, 16#00CC6#),  -- (Mn)  KANNADA VOWEL SIGN E .. KANNADA VOWEL SIGN E
     (16#00CC7#, 16#00CC8#),  -- (Mc)  KANNADA VOWEL SIGN EE .. KANNADA VOWEL SIGN AI
     (16#00CCA#, 16#00CCB#),  -- (Mc)  KANNADA VOWEL SIGN O .. KANNADA VOWEL SIGN OO
     (16#00CCC#, 16#00CCD#),  -- (Mn)  KANNADA VOWEL SIGN AU .. KANNADA SIGN VIRAMA
     (16#00CD5#, 16#00CD6#),  -- (Mc)  KANNADA LENGTH MARK .. KANNADA AI LENGTH MARK
     (16#00CDE#, 16#00CDE#),  -- (Lo)  KANNADA LETTER FA .. KANNADA LETTER FA
     (16#00CE0#, 16#00CE1#),  -- (Lo)  KANNADA LETTER VOCALIC RR .. KANNADA LETTER VOCALIC LL
     (16#00CE6#, 16#00CEF#),  -- (Nd)  KANNADA DIGIT ZERO .. KANNADA DIGIT NINE
     (16#00D02#, 16#00D03#),  -- (Mc)  MALAYALAM SIGN ANUSVARA .. MALAYALAM SIGN VISARGA
     (16#00D05#, 16#00D0C#),  -- (Lo)  MALAYALAM LETTER A .. MALAYALAM LETTER VOCALIC L
     (16#00D0E#, 16#00D10#),  -- (Lo)  MALAYALAM LETTER E .. MALAYALAM LETTER AI
     (16#00D12#, 16#00D28#),  -- (Lo)  MALAYALAM LETTER O .. MALAYALAM LETTER NA
     (16#00D2A#, 16#00D39#),  -- (Lo)  MALAYALAM LETTER PA .. MALAYALAM LETTER HA
     (16#00D3E#, 16#00D40#),  -- (Mc)  MALAYALAM VOWEL SIGN AA .. MALAYALAM VOWEL SIGN II
     (16#00D41#, 16#00D43#),  -- (Mn)  MALAYALAM VOWEL SIGN U .. MALAYALAM VOWEL SIGN VOCALIC R
     (16#00D46#, 16#00D48#),  -- (Mc)  MALAYALAM VOWEL SIGN E .. MALAYALAM VOWEL SIGN AI
     (16#00D4A#, 16#00D4C#),  -- (Mc)  MALAYALAM VOWEL SIGN O .. MALAYALAM VOWEL SIGN AU
     (16#00D4D#, 16#00D4D#),  -- (Mn)  MALAYALAM SIGN VIRAMA .. MALAYALAM SIGN VIRAMA
     (16#00D57#, 16#00D57#),  -- (Mc)  MALAYALAM AU LENGTH MARK .. MALAYALAM AU LENGTH MARK
     (16#00D60#, 16#00D61#),  -- (Lo)  MALAYALAM LETTER VOCALIC RR .. MALAYALAM LETTER VOCALIC LL
     (16#00D66#, 16#00D6F#),  -- (Nd)  MALAYALAM DIGIT ZERO .. MALAYALAM DIGIT NINE
     (16#00D82#, 16#00D83#),  -- (Mc)  SINHALA SIGN ANUSVARAYA .. SINHALA SIGN VISARGAYA
     (16#00D85#, 16#00D96#),  -- (Lo)  SINHALA LETTER AYANNA .. SINHALA LETTER AUYANNA
     (16#00D9A#, 16#00DB1#),  -- (Lo)  SINHALA LETTER ALPAPRAANA KAYANNA .. SINHALA LETTER DANTAJA NAYANNA
     (16#00DB3#, 16#00DBB#),  -- (Lo)  SINHALA LETTER SANYAKA DAYANNA .. SINHALA LETTER RAYANNA
     (16#00DBD#, 16#00DBD#),  -- (Lo)  SINHALA LETTER DANTAJA LAYANNA .. SINHALA LETTER DANTAJA LAYANNA
     (16#00DC0#, 16#00DC6#),  -- (Lo)  SINHALA LETTER VAYANNA .. SINHALA LETTER FAYANNA
     (16#00DCA#, 16#00DCA#),  -- (Mn)  SINHALA SIGN AL-LAKUNA .. SINHALA SIGN AL-LAKUNA
     (16#00DCF#, 16#00DD1#),  -- (Mc)  SINHALA VOWEL SIGN AELA-PILLA .. SINHALA VOWEL SIGN DIGA AEDA-PILLA
     (16#00DD2#, 16#00DD4#),  -- (Mn)  SINHALA VOWEL SIGN KETTI IS-PILLA .. SINHALA VOWEL SIGN KETTI PAA-PILLA
     (16#00DD6#, 16#00DD6#),  -- (Mn)  SINHALA VOWEL SIGN DIGA PAA-PILLA .. SINHALA VOWEL SIGN DIGA PAA-PILLA
     (16#00DD8#, 16#00DDF#),  -- (Mc)  SINHALA VOWEL SIGN GAETTA-PILLA .. SINHALA VOWEL SIGN GAYANUKITTA
     (16#00DF2#, 16#00DF3#),  -- (Mc)  SINHALA VOWEL SIGN DIGA GAETTA-PILLA .. SINHALA VOWEL SIGN DIGA GAYANUKITTA
     (16#00DF4#, 16#00DF4#),  -- (Po)  SINHALA PUNCTUATION KUNDDALIYA .. SINHALA PUNCTUATION KUNDDALIYA
     (16#00E01#, 16#00E30#),  -- (Lo)  THAI CHARACTER KO KAI .. THAI CHARACTER SARA A
     (16#00E31#, 16#00E31#),  -- (Mn)  THAI CHARACTER MAI HAN-AKAT .. THAI CHARACTER MAI HAN-AKAT
     (16#00E32#, 16#00E33#),  -- (Lo)  THAI CHARACTER SARA AA .. THAI CHARACTER SARA AM
     (16#00E34#, 16#00E3A#),  -- (Mn)  THAI CHARACTER SARA I .. THAI CHARACTER PHINTHU
     (16#00E3F#, 16#00E3F#),  -- (Sc)  THAI CURRENCY SYMBOL BAHT .. THAI CURRENCY SYMBOL BAHT
     (16#00E40#, 16#00E45#),  -- (Lo)  THAI CHARACTER SARA E .. THAI CHARACTER LAKKHANGYAO
     (16#00E46#, 16#00E46#),  -- (Lm)  THAI CHARACTER MAIYAMOK .. THAI CHARACTER MAIYAMOK
     (16#00E47#, 16#00E4E#),  -- (Mn)  THAI CHARACTER MAITAIKHU .. THAI CHARACTER YAMAKKAN
     (16#00E4F#, 16#00E4F#),  -- (Po)  THAI CHARACTER FONGMAN .. THAI CHARACTER FONGMAN
     (16#00E50#, 16#00E59#),  -- (Nd)  THAI DIGIT ZERO .. THAI DIGIT NINE
     (16#00E5A#, 16#00E5B#),  -- (Po)  THAI CHARACTER ANGKHANKHU .. THAI CHARACTER KHOMUT
     (16#00E81#, 16#00E82#),  -- (Lo)  LAO LETTER KO .. LAO LETTER KHO SUNG
     (16#00E84#, 16#00E84#),  -- (Lo)  LAO LETTER KHO TAM .. LAO LETTER KHO TAM
     (16#00E87#, 16#00E88#),  -- (Lo)  LAO LETTER NGO .. LAO LETTER CO
     (16#00E8A#, 16#00E8A#),  -- (Lo)  LAO LETTER SO TAM .. LAO LETTER SO TAM
     (16#00E8D#, 16#00E8D#),  -- (Lo)  LAO LETTER NYO .. LAO LETTER NYO
     (16#00E94#, 16#00E97#),  -- (Lo)  LAO LETTER DO .. LAO LETTER THO TAM
     (16#00E99#, 16#00E9F#),  -- (Lo)  LAO LETTER NO .. LAO LETTER FO SUNG
     (16#00EA1#, 16#00EA3#),  -- (Lo)  LAO LETTER MO .. LAO LETTER LO LING
     (16#00EA5#, 16#00EA5#),  -- (Lo)  LAO LETTER LO LOOT .. LAO LETTER LO LOOT
     (16#00EA7#, 16#00EA7#),  -- (Lo)  LAO LETTER WO .. LAO LETTER WO
     (16#00EAA#, 16#00EAB#),  -- (Lo)  LAO LETTER SO SUNG .. LAO LETTER HO SUNG
     (16#00EAD#, 16#00EB0#),  -- (Lo)  LAO LETTER O .. LAO VOWEL SIGN A
     (16#00EB1#, 16#00EB1#),  -- (Mn)  LAO VOWEL SIGN MAI KAN .. LAO VOWEL SIGN MAI KAN
     (16#00EB2#, 16#00EB3#),  -- (Lo)  LAO VOWEL SIGN AA .. LAO VOWEL SIGN AM
     (16#00EB4#, 16#00EB9#),  -- (Mn)  LAO VOWEL SIGN I .. LAO VOWEL SIGN UU
     (16#00EBB#, 16#00EBC#),  -- (Mn)  LAO VOWEL SIGN MAI KON .. LAO SEMIVOWEL SIGN LO
     (16#00EBD#, 16#00EBD#),  -- (Lo)  LAO SEMIVOWEL SIGN NYO .. LAO SEMIVOWEL SIGN NYO
     (16#00EC0#, 16#00EC4#),  -- (Lo)  LAO VOWEL SIGN E .. LAO VOWEL SIGN AI
     (16#00EC6#, 16#00EC6#),  -- (Lm)  LAO KO LA .. LAO KO LA
     (16#00EC8#, 16#00ECD#),  -- (Mn)  LAO TONE MAI EK .. LAO NIGGAHITA
     (16#00ED0#, 16#00ED9#),  -- (Nd)  LAO DIGIT ZERO .. LAO DIGIT NINE
     (16#00EDC#, 16#00EDD#),  -- (Lo)  LAO HO NO .. LAO HO MO
     (16#00F00#, 16#00F00#),  -- (Lo)  TIBETAN SYLLABLE OM .. TIBETAN SYLLABLE OM
     (16#00F01#, 16#00F03#),  -- (So)  TIBETAN MARK GTER YIG MGO TRUNCATED A .. TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA
     (16#00F04#, 16#00F12#),  -- (Po)  TIBETAN MARK INITIAL YIG MGO MDUN MA .. TIBETAN MARK RGYA GRAM SHAD
     (16#00F13#, 16#00F17#),  -- (So)  TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN .. TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS
     (16#00F18#, 16#00F19#),  -- (Mn)  TIBETAN ASTROLOGICAL SIGN -KHYUD PA .. TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
     (16#00F1A#, 16#00F1F#),  -- (So)  TIBETAN SIGN RDEL DKAR GCIG .. TIBETAN SIGN RDEL DKAR RDEL NAG
     (16#00F20#, 16#00F29#),  -- (Nd)  TIBETAN DIGIT ZERO .. TIBETAN DIGIT NINE
     (16#00F2A#, 16#00F33#),  -- (No)  TIBETAN DIGIT HALF ONE .. TIBETAN DIGIT HALF ZERO
     (16#00F34#, 16#00F34#),  -- (So)  TIBETAN MARK BSDUS RTAGS .. TIBETAN MARK BSDUS RTAGS
     (16#00F35#, 16#00F35#),  -- (Mn)  TIBETAN MARK NGAS BZUNG NYI ZLA .. TIBETAN MARK NGAS BZUNG NYI ZLA
     (16#00F36#, 16#00F36#),  -- (So)  TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN .. TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN
     (16#00F37#, 16#00F37#),  -- (Mn)  TIBETAN MARK NGAS BZUNG SGOR RTAGS .. TIBETAN MARK NGAS BZUNG SGOR RTAGS
     (16#00F38#, 16#00F38#),  -- (So)  TIBETAN MARK CHE MGO .. TIBETAN MARK CHE MGO
     (16#00F39#, 16#00F39#),  -- (Mn)  TIBETAN MARK TSA -PHRU .. TIBETAN MARK TSA -PHRU
     (16#00F3A#, 16#00F3A#),  -- (Ps)  TIBETAN MARK GUG RTAGS GYON .. TIBETAN MARK GUG RTAGS GYON
     (16#00F3B#, 16#00F3B#),  -- (Pe)  TIBETAN MARK GUG RTAGS GYAS .. TIBETAN MARK GUG RTAGS GYAS
     (16#00F3C#, 16#00F3C#),  -- (Ps)  TIBETAN MARK ANG KHANG GYON .. TIBETAN MARK ANG KHANG GYON
     (16#00F3D#, 16#00F3D#),  -- (Pe)  TIBETAN MARK ANG KHANG GYAS .. TIBETAN MARK ANG KHANG GYAS
     (16#00F3E#, 16#00F3F#),  -- (Mc)  TIBETAN SIGN YAR TSHES .. TIBETAN SIGN MAR TSHES
     (16#00F40#, 16#00F47#),  -- (Lo)  TIBETAN LETTER KA .. TIBETAN LETTER JA
     (16#00F49#, 16#00F6A#),  -- (Lo)  TIBETAN LETTER NYA .. TIBETAN LETTER FIXED-FORM RA
     (16#00F71#, 16#00F7E#),  -- (Mn)  TIBETAN VOWEL SIGN AA .. TIBETAN SIGN RJES SU NGA RO
     (16#00F7F#, 16#00F7F#),  -- (Mc)  TIBETAN SIGN RNAM BCAD .. TIBETAN SIGN RNAM BCAD
     (16#00F80#, 16#00F84#),  -- (Mn)  TIBETAN VOWEL SIGN REVERSED I .. TIBETAN MARK HALANTA
     (16#00F85#, 16#00F85#),  -- (Po)  TIBETAN MARK PALUTA .. TIBETAN MARK PALUTA
     (16#00F86#, 16#00F87#),  -- (Mn)  TIBETAN SIGN LCI RTAGS .. TIBETAN SIGN YANG RTAGS
     (16#00F88#, 16#00F8B#),  -- (Lo)  TIBETAN SIGN LCE TSA CAN .. TIBETAN SIGN GRU MED RGYINGS
     (16#00F90#, 16#00F97#),  -- (Mn)  TIBETAN SUBJOINED LETTER KA .. TIBETAN SUBJOINED LETTER JA
     (16#00F99#, 16#00FBC#),  -- (Mn)  TIBETAN SUBJOINED LETTER NYA .. TIBETAN SUBJOINED LETTER FIXED-FORM RA
     (16#00FBE#, 16#00FC5#),  -- (So)  TIBETAN KU RU KHA .. TIBETAN SYMBOL RDO RJE
     (16#00FC6#, 16#00FC6#),  -- (Mn)  TIBETAN SYMBOL PADMA GDAN .. TIBETAN SYMBOL PADMA GDAN
     (16#00FC7#, 16#00FCC#),  -- (So)  TIBETAN SYMBOL RDO RJE RGYA GRAM .. TIBETAN SYMBOL NOR BU BZHI -KHYIL
     (16#00FCF#, 16#00FCF#),  -- (So)  TIBETAN SIGN RDEL NAG GSUM .. TIBETAN SIGN RDEL NAG GSUM
     (16#01000#, 16#01021#),  -- (Lo)  MYANMAR LETTER KA .. MYANMAR LETTER A
     (16#01023#, 16#01027#),  -- (Lo)  MYANMAR LETTER I .. MYANMAR LETTER E
     (16#01029#, 16#0102A#),  -- (Lo)  MYANMAR LETTER O .. MYANMAR LETTER AU
     (16#0102C#, 16#0102C#),  -- (Mc)  MYANMAR VOWEL SIGN AA .. MYANMAR VOWEL SIGN AA
     (16#0102D#, 16#01030#),  -- (Mn)  MYANMAR VOWEL SIGN I .. MYANMAR VOWEL SIGN UU
     (16#01031#, 16#01031#),  -- (Mc)  MYANMAR VOWEL SIGN E .. MYANMAR VOWEL SIGN E
     (16#01032#, 16#01032#),  -- (Mn)  MYANMAR VOWEL SIGN AI .. MYANMAR VOWEL SIGN AI
     (16#01036#, 16#01037#),  -- (Mn)  MYANMAR SIGN ANUSVARA .. MYANMAR SIGN DOT BELOW
     (16#01038#, 16#01038#),  -- (Mc)  MYANMAR SIGN VISARGA .. MYANMAR SIGN VISARGA
     (16#01039#, 16#01039#),  -- (Mn)  MYANMAR SIGN VIRAMA .. MYANMAR SIGN VIRAMA
     (16#01040#, 16#01049#),  -- (Nd)  MYANMAR DIGIT ZERO .. MYANMAR DIGIT NINE
     (16#0104A#, 16#0104F#),  -- (Po)  MYANMAR SIGN LITTLE SECTION .. MYANMAR SYMBOL GENITIVE
     (16#01050#, 16#01055#),  -- (Lo)  MYANMAR LETTER SHA .. MYANMAR LETTER VOCALIC LL
     (16#01056#, 16#01057#),  -- (Mc)  MYANMAR VOWEL SIGN VOCALIC R .. MYANMAR VOWEL SIGN VOCALIC RR
     (16#01058#, 16#01059#),  -- (Mn)  MYANMAR VOWEL SIGN VOCALIC L .. MYANMAR VOWEL SIGN VOCALIC LL
     (16#010A0#, 16#010C5#),  -- (Lu)  GEORGIAN CAPITAL LETTER AN .. GEORGIAN CAPITAL LETTER HOE
     (16#010D0#, 16#010F8#),  -- (Lo)  GEORGIAN LETTER AN .. GEORGIAN LETTER ELIFI
     (16#010FB#, 16#010FB#),  -- (Po)  GEORGIAN PARAGRAPH SEPARATOR .. GEORGIAN PARAGRAPH SEPARATOR
     (16#01100#, 16#01159#),  -- (Lo)  HANGUL CHOSEONG KIYEOK .. HANGUL CHOSEONG YEORINHIEUH
     (16#0115F#, 16#011A2#),  -- (Lo)  HANGUL CHOSEONG FILLER .. HANGUL JUNGSEONG SSANGARAEA
     (16#011A8#, 16#011F9#),  -- (Lo)  HANGUL JONGSEONG KIYEOK .. HANGUL JONGSEONG YEORINHIEUH
     (16#01200#, 16#01206#),  -- (Lo)  ETHIOPIC SYLLABLE HA .. ETHIOPIC SYLLABLE HO
     (16#01208#, 16#01246#),  -- (Lo)  ETHIOPIC SYLLABLE LA .. ETHIOPIC SYLLABLE QO
     (16#01248#, 16#01248#),  -- (Lo)  ETHIOPIC SYLLABLE QWA .. ETHIOPIC SYLLABLE QWA
     (16#0124A#, 16#0124D#),  -- (Lo)  ETHIOPIC SYLLABLE QWI .. ETHIOPIC SYLLABLE QWE
     (16#01250#, 16#01256#),  -- (Lo)  ETHIOPIC SYLLABLE QHA .. ETHIOPIC SYLLABLE QHO
     (16#01258#, 16#01258#),  -- (Lo)  ETHIOPIC SYLLABLE QHWA .. ETHIOPIC SYLLABLE QHWA
     (16#0125A#, 16#0125D#),  -- (Lo)  ETHIOPIC SYLLABLE QHWI .. ETHIOPIC SYLLABLE QHWE
     (16#01260#, 16#01286#),  -- (Lo)  ETHIOPIC SYLLABLE BA .. ETHIOPIC SYLLABLE XO
     (16#01288#, 16#01288#),  -- (Lo)  ETHIOPIC SYLLABLE XWA .. ETHIOPIC SYLLABLE XWA
     (16#0128A#, 16#0128D#),  -- (Lo)  ETHIOPIC SYLLABLE XWI .. ETHIOPIC SYLLABLE XWE
     (16#01290#, 16#012AE#),  -- (Lo)  ETHIOPIC SYLLABLE NA .. ETHIOPIC SYLLABLE KO
     (16#012B0#, 16#012B0#),  -- (Lo)  ETHIOPIC SYLLABLE KWA .. ETHIOPIC SYLLABLE KWA
     (16#012B2#, 16#012B5#),  -- (Lo)  ETHIOPIC SYLLABLE KWI .. ETHIOPIC SYLLABLE KWE
     (16#012B8#, 16#012BE#),  -- (Lo)  ETHIOPIC SYLLABLE KXA .. ETHIOPIC SYLLABLE KXO
     (16#012C0#, 16#012C0#),  -- (Lo)  ETHIOPIC SYLLABLE KXWA .. ETHIOPIC SYLLABLE KXWA
     (16#012C2#, 16#012C5#),  -- (Lo)  ETHIOPIC SYLLABLE KXWI .. ETHIOPIC SYLLABLE KXWE
     (16#012C8#, 16#012CE#),  -- (Lo)  ETHIOPIC SYLLABLE WA .. ETHIOPIC SYLLABLE WO
     (16#012D0#, 16#012D6#),  -- (Lo)  ETHIOPIC SYLLABLE PHARYNGEAL A .. ETHIOPIC SYLLABLE PHARYNGEAL O
     (16#012D8#, 16#012EE#),  -- (Lo)  ETHIOPIC SYLLABLE ZA .. ETHIOPIC SYLLABLE YO
     (16#012F0#, 16#0130E#),  -- (Lo)  ETHIOPIC SYLLABLE DA .. ETHIOPIC SYLLABLE GO
     (16#01310#, 16#01310#),  -- (Lo)  ETHIOPIC SYLLABLE GWA .. ETHIOPIC SYLLABLE GWA
     (16#01312#, 16#01315#),  -- (Lo)  ETHIOPIC SYLLABLE GWI .. ETHIOPIC SYLLABLE GWE
     (16#01318#, 16#0131E#),  -- (Lo)  ETHIOPIC SYLLABLE GGA .. ETHIOPIC SYLLABLE GGO
     (16#01320#, 16#01346#),  -- (Lo)  ETHIOPIC SYLLABLE THA .. ETHIOPIC SYLLABLE TZO
     (16#01348#, 16#0135A#),  -- (Lo)  ETHIOPIC SYLLABLE FA .. ETHIOPIC SYLLABLE FYA
     (16#01361#, 16#01368#),  -- (Po)  ETHIOPIC WORDSPACE .. ETHIOPIC PARAGRAPH SEPARATOR
     (16#01369#, 16#01371#),  -- (Nd)  ETHIOPIC DIGIT ONE .. ETHIOPIC DIGIT NINE
     (16#01372#, 16#0137C#),  -- (No)  ETHIOPIC NUMBER TEN .. ETHIOPIC NUMBER TEN THOUSAND
     (16#013A0#, 16#013F4#),  -- (Lo)  CHEROKEE LETTER A .. CHEROKEE LETTER YV
     (16#01401#, 16#0166C#),  -- (Lo)  CANADIAN SYLLABICS E .. CANADIAN SYLLABICS CARRIER TTSA
     (16#0166D#, 16#0166E#),  -- (Po)  CANADIAN SYLLABICS CHI SIGN .. CANADIAN SYLLABICS FULL STOP
     (16#0166F#, 16#01676#),  -- (Lo)  CANADIAN SYLLABICS QAI .. CANADIAN SYLLABICS NNGAA
     (16#01680#, 16#01680#),  -- (Zs)  OGHAM SPACE MARK .. OGHAM SPACE MARK
     (16#01681#, 16#0169A#),  -- (Lo)  OGHAM LETTER BEITH .. OGHAM LETTER PEITH
     (16#0169B#, 16#0169B#),  -- (Ps)  OGHAM FEATHER MARK .. OGHAM FEATHER MARK
     (16#0169C#, 16#0169C#),  -- (Pe)  OGHAM REVERSED FEATHER MARK .. OGHAM REVERSED FEATHER MARK
     (16#016A0#, 16#016EA#),  -- (Lo)  RUNIC LETTER FEHU FEOH FE F .. RUNIC LETTER X
     (16#016EB#, 16#016ED#),  -- (Po)  RUNIC SINGLE PUNCTUATION .. RUNIC CROSS PUNCTUATION
     (16#016EE#, 16#016F0#),  -- (Nl)  RUNIC ARLAUG SYMBOL .. RUNIC BELGTHOR SYMBOL
     (16#01700#, 16#0170C#),  -- (Lo)  TAGALOG LETTER A .. TAGALOG LETTER YA
     (16#0170E#, 16#01711#),  -- (Lo)  TAGALOG LETTER LA .. TAGALOG LETTER HA
     (16#01712#, 16#01714#),  -- (Mn)  TAGALOG VOWEL SIGN I .. TAGALOG SIGN VIRAMA
     (16#01720#, 16#01731#),  -- (Lo)  HANUNOO LETTER A .. HANUNOO LETTER HA
     (16#01732#, 16#01734#),  -- (Mn)  HANUNOO VOWEL SIGN I .. HANUNOO SIGN PAMUDPOD
     (16#01735#, 16#01736#),  -- (Po)  PHILIPPINE SINGLE PUNCTUATION .. PHILIPPINE DOUBLE PUNCTUATION
     (16#01740#, 16#01751#),  -- (Lo)  BUHID LETTER A .. BUHID LETTER HA
     (16#01752#, 16#01753#),  -- (Mn)  BUHID VOWEL SIGN I .. BUHID VOWEL SIGN U
     (16#01760#, 16#0176C#),  -- (Lo)  TAGBANWA LETTER A .. TAGBANWA LETTER YA
     (16#0176E#, 16#01770#),  -- (Lo)  TAGBANWA LETTER LA .. TAGBANWA LETTER SA
     (16#01772#, 16#01773#),  -- (Mn)  TAGBANWA VOWEL SIGN I .. TAGBANWA VOWEL SIGN U
     (16#01780#, 16#017B3#),  -- (Lo)  KHMER LETTER KA .. KHMER INDEPENDENT VOWEL QAU
     (16#017B4#, 16#017B5#),  -- (Cf)  KHMER VOWEL INHERENT AQ .. KHMER VOWEL INHERENT AA
     (16#017B6#, 16#017B6#),  -- (Mc)  KHMER VOWEL SIGN AA .. KHMER VOWEL SIGN AA
     (16#017B7#, 16#017BD#),  -- (Mn)  KHMER VOWEL SIGN I .. KHMER VOWEL SIGN UA
     (16#017BE#, 16#017C5#),  -- (Mc)  KHMER VOWEL SIGN OE .. KHMER VOWEL SIGN AU
     (16#017C6#, 16#017C6#),  -- (Mn)  KHMER SIGN NIKAHIT .. KHMER SIGN NIKAHIT
     (16#017C7#, 16#017C8#),  -- (Mc)  KHMER SIGN REAHMUK .. KHMER SIGN YUUKALEAPINTU
     (16#017C9#, 16#017D3#),  -- (Mn)  KHMER SIGN MUUSIKATOAN .. KHMER SIGN BATHAMASAT
     (16#017D4#, 16#017D6#),  -- (Po)  KHMER SIGN KHAN .. KHMER SIGN CAMNUC PII KUUH
     (16#017D7#, 16#017D7#),  -- (Lm)  KHMER SIGN LEK TOO .. KHMER SIGN LEK TOO
     (16#017D8#, 16#017DA#),  -- (Po)  KHMER SIGN BEYYAL .. KHMER SIGN KOOMUUT
     (16#017DB#, 16#017DB#),  -- (Sc)  KHMER CURRENCY SYMBOL RIEL .. KHMER CURRENCY SYMBOL RIEL
     (16#017DC#, 16#017DC#),  -- (Lo)  KHMER SIGN AVAKRAHASANYA .. KHMER SIGN AVAKRAHASANYA
     (16#017DD#, 16#017DD#),  -- (Mn)  KHMER SIGN ATTHACAN .. KHMER SIGN ATTHACAN
     (16#017E0#, 16#017E9#),  -- (Nd)  KHMER DIGIT ZERO .. KHMER DIGIT NINE
     (16#017F0#, 16#017F9#),  -- (No)  KHMER SYMBOL LEK ATTAK SON .. KHMER SYMBOL LEK ATTAK PRAM-BUON
     (16#01800#, 16#01805#),  -- (Po)  MONGOLIAN BIRGA .. MONGOLIAN FOUR DOTS
     (16#01806#, 16#01806#),  -- (Pd)  MONGOLIAN TODO SOFT HYPHEN .. MONGOLIAN TODO SOFT HYPHEN
     (16#01807#, 16#0180A#),  -- (Po)  MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER .. MONGOLIAN NIRUGU
     (16#0180B#, 16#0180D#),  -- (Mn)  MONGOLIAN FREE VARIATION SELECTOR ONE .. MONGOLIAN FREE VARIATION SELECTOR THREE
     (16#0180E#, 16#0180E#),  -- (Zs)  MONGOLIAN VOWEL SEPARATOR .. MONGOLIAN VOWEL SEPARATOR
     (16#01810#, 16#01819#),  -- (Nd)  MONGOLIAN DIGIT ZERO .. MONGOLIAN DIGIT NINE
     (16#01820#, 16#01842#),  -- (Lo)  MONGOLIAN LETTER A .. MONGOLIAN LETTER CHI
     (16#01843#, 16#01843#),  -- (Lm)  MONGOLIAN LETTER TODO LONG VOWEL SIGN .. MONGOLIAN LETTER TODO LONG VOWEL SIGN
     (16#01844#, 16#01877#),  -- (Lo)  MONGOLIAN LETTER TODO E .. MONGOLIAN LETTER MANCHU ZHA
     (16#01880#, 16#018A8#),  -- (Lo)  MONGOLIAN LETTER ALI GALI ANUSVARA ONE .. MONGOLIAN LETTER MANCHU ALI GALI BHA
     (16#018A9#, 16#018A9#),  -- (Mn)  MONGOLIAN LETTER ALI GALI DAGALGA .. MONGOLIAN LETTER ALI GALI DAGALGA
     (16#01900#, 16#0191C#),  -- (Lo)  LIMBU VOWEL-CARRIER LETTER .. LIMBU LETTER HA
     (16#01920#, 16#01922#),  -- (Mn)  LIMBU VOWEL SIGN A .. LIMBU VOWEL SIGN U
     (16#01923#, 16#01926#),  -- (Mc)  LIMBU VOWEL SIGN EE .. LIMBU VOWEL SIGN AU
     (16#01927#, 16#01928#),  -- (Mn)  LIMBU VOWEL SIGN E .. LIMBU VOWEL SIGN O
     (16#01929#, 16#0192B#),  -- (Mc)  LIMBU SUBJOINED LETTER YA .. LIMBU SUBJOINED LETTER WA
     (16#01930#, 16#01931#),  -- (Mc)  LIMBU SMALL LETTER KA .. LIMBU SMALL LETTER NGA
     (16#01932#, 16#01932#),  -- (Mn)  LIMBU SMALL LETTER ANUSVARA .. LIMBU SMALL LETTER ANUSVARA
     (16#01933#, 16#01938#),  -- (Mc)  LIMBU SMALL LETTER TA .. LIMBU SMALL LETTER LA
     (16#01939#, 16#0193B#),  -- (Mn)  LIMBU SIGN MUKPHRENG .. LIMBU SIGN SA-I
     (16#01940#, 16#01940#),  -- (So)  LIMBU SIGN LOO .. LIMBU SIGN LOO
     (16#01944#, 16#01945#),  -- (Po)  LIMBU EXCLAMATION MARK .. LIMBU QUESTION MARK
     (16#01946#, 16#0194F#),  -- (Nd)  LIMBU DIGIT ZERO .. LIMBU DIGIT NINE
     (16#01950#, 16#0196D#),  -- (Lo)  TAI LE LETTER KA .. TAI LE LETTER AI
     (16#01970#, 16#01974#),  -- (Lo)  TAI LE LETTER TONE-2 .. TAI LE LETTER TONE-6
     (16#019E0#, 16#019FF#),  -- (So)  KHMER SYMBOL PATHAMASAT .. KHMER SYMBOL DAP-PRAM ROC
     (16#01D00#, 16#01D2B#),  -- (Ll)  LATIN LETTER SMALL CAPITAL A .. CYRILLIC LETTER SMALL CAPITAL EL
     (16#01D2C#, 16#01D61#),  -- (Lm)  MODIFIER LETTER CAPITAL A .. MODIFIER LETTER SMALL CHI
     (16#01D62#, 16#01D6B#),  -- (Ll)  LATIN SUBSCRIPT SMALL LETTER I .. LATIN SMALL LETTER UE
     (16#01E00#, 16#01E00#),  -- (Lu)  LATIN CAPITAL LETTER A WITH RING BELOW .. LATIN CAPITAL LETTER A WITH RING BELOW
     (16#01E01#, 16#01E01#),  -- (Ll)  LATIN SMALL LETTER A WITH RING BELOW .. LATIN SMALL LETTER A WITH RING BELOW
     (16#01E02#, 16#01E02#),  -- (Lu)  LATIN CAPITAL LETTER B WITH DOT ABOVE .. LATIN CAPITAL LETTER B WITH DOT ABOVE
     (16#01E03#, 16#01E03#),  -- (Ll)  LATIN SMALL LETTER B WITH DOT ABOVE .. LATIN SMALL LETTER B WITH DOT ABOVE
     (16#01E04#, 16#01E04#),  -- (Lu)  LATIN CAPITAL LETTER B WITH DOT BELOW .. LATIN CAPITAL LETTER B WITH DOT BELOW
     (16#01E05#, 16#01E05#),  -- (Ll)  LATIN SMALL LETTER B WITH DOT BELOW .. LATIN SMALL LETTER B WITH DOT BELOW
     (16#01E06#, 16#01E06#),  -- (Lu)  LATIN CAPITAL LETTER B WITH LINE BELOW .. LATIN CAPITAL LETTER B WITH LINE BELOW
     (16#01E07#, 16#01E07#),  -- (Ll)  LATIN SMALL LETTER B WITH LINE BELOW .. LATIN SMALL LETTER B WITH LINE BELOW
     (16#01E08#, 16#01E08#),  -- (Lu)  LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE .. LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
     (16#01E09#, 16#01E09#),  -- (Ll)  LATIN SMALL LETTER C WITH CEDILLA AND ACUTE .. LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
     (16#01E0A#, 16#01E0A#),  -- (Lu)  LATIN CAPITAL LETTER D WITH DOT ABOVE .. LATIN CAPITAL LETTER D WITH DOT ABOVE
     (16#01E0B#, 16#01E0B#),  -- (Ll)  LATIN SMALL LETTER D WITH DOT ABOVE .. LATIN SMALL LETTER D WITH DOT ABOVE
     (16#01E0C#, 16#01E0C#),  -- (Lu)  LATIN CAPITAL LETTER D WITH DOT BELOW .. LATIN CAPITAL LETTER D WITH DOT BELOW
     (16#01E0D#, 16#01E0D#),  -- (Ll)  LATIN SMALL LETTER D WITH DOT BELOW .. LATIN SMALL LETTER D WITH DOT BELOW
     (16#01E0E#, 16#01E0E#),  -- (Lu)  LATIN CAPITAL LETTER D WITH LINE BELOW .. LATIN CAPITAL LETTER D WITH LINE BELOW
     (16#01E0F#, 16#01E0F#),  -- (Ll)  LATIN SMALL LETTER D WITH LINE BELOW .. LATIN SMALL LETTER D WITH LINE BELOW
     (16#01E10#, 16#01E10#),  -- (Lu)  LATIN CAPITAL LETTER D WITH CEDILLA .. LATIN CAPITAL LETTER D WITH CEDILLA
     (16#01E11#, 16#01E11#),  -- (Ll)  LATIN SMALL LETTER D WITH CEDILLA .. LATIN SMALL LETTER D WITH CEDILLA
     (16#01E12#, 16#01E12#),  -- (Lu)  LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
     (16#01E13#, 16#01E13#),  -- (Ll)  LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
     (16#01E14#, 16#01E14#),  -- (Lu)  LATIN CAPITAL LETTER E WITH MACRON AND GRAVE .. LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
     (16#01E15#, 16#01E15#),  -- (Ll)  LATIN SMALL LETTER E WITH MACRON AND GRAVE .. LATIN SMALL LETTER E WITH MACRON AND GRAVE
     (16#01E16#, 16#01E16#),  -- (Lu)  LATIN CAPITAL LETTER E WITH MACRON AND ACUTE .. LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
     (16#01E17#, 16#01E17#),  -- (Ll)  LATIN SMALL LETTER E WITH MACRON AND ACUTE .. LATIN SMALL LETTER E WITH MACRON AND ACUTE
     (16#01E18#, 16#01E18#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
     (16#01E19#, 16#01E19#),  -- (Ll)  LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
     (16#01E1A#, 16#01E1A#),  -- (Lu)  LATIN CAPITAL LETTER E WITH TILDE BELOW .. LATIN CAPITAL LETTER E WITH TILDE BELOW
     (16#01E1B#, 16#01E1B#),  -- (Ll)  LATIN SMALL LETTER E WITH TILDE BELOW .. LATIN SMALL LETTER E WITH TILDE BELOW
     (16#01E1C#, 16#01E1C#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE .. LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
     (16#01E1D#, 16#01E1D#),  -- (Ll)  LATIN SMALL LETTER E WITH CEDILLA AND BREVE .. LATIN SMALL LETTER E WITH CEDILLA AND BREVE
     (16#01E1E#, 16#01E1E#),  -- (Lu)  LATIN CAPITAL LETTER F WITH DOT ABOVE .. LATIN CAPITAL LETTER F WITH DOT ABOVE
     (16#01E1F#, 16#01E1F#),  -- (Ll)  LATIN SMALL LETTER F WITH DOT ABOVE .. LATIN SMALL LETTER F WITH DOT ABOVE
     (16#01E20#, 16#01E20#),  -- (Lu)  LATIN CAPITAL LETTER G WITH MACRON .. LATIN CAPITAL LETTER G WITH MACRON
     (16#01E21#, 16#01E21#),  -- (Ll)  LATIN SMALL LETTER G WITH MACRON .. LATIN SMALL LETTER G WITH MACRON
     (16#01E22#, 16#01E22#),  -- (Lu)  LATIN CAPITAL LETTER H WITH DOT ABOVE .. LATIN CAPITAL LETTER H WITH DOT ABOVE
     (16#01E23#, 16#01E23#),  -- (Ll)  LATIN SMALL LETTER H WITH DOT ABOVE .. LATIN SMALL LETTER H WITH DOT ABOVE
     (16#01E24#, 16#01E24#),  -- (Lu)  LATIN CAPITAL LETTER H WITH DOT BELOW .. LATIN CAPITAL LETTER H WITH DOT BELOW
     (16#01E25#, 16#01E25#),  -- (Ll)  LATIN SMALL LETTER H WITH DOT BELOW .. LATIN SMALL LETTER H WITH DOT BELOW
     (16#01E26#, 16#01E26#),  -- (Lu)  LATIN CAPITAL LETTER H WITH DIAERESIS .. LATIN CAPITAL LETTER H WITH DIAERESIS
     (16#01E27#, 16#01E27#),  -- (Ll)  LATIN SMALL LETTER H WITH DIAERESIS .. LATIN SMALL LETTER H WITH DIAERESIS
     (16#01E28#, 16#01E28#),  -- (Lu)  LATIN CAPITAL LETTER H WITH CEDILLA .. LATIN CAPITAL LETTER H WITH CEDILLA
     (16#01E29#, 16#01E29#),  -- (Ll)  LATIN SMALL LETTER H WITH CEDILLA .. LATIN SMALL LETTER H WITH CEDILLA
     (16#01E2A#, 16#01E2A#),  -- (Lu)  LATIN CAPITAL LETTER H WITH BREVE BELOW .. LATIN CAPITAL LETTER H WITH BREVE BELOW
     (16#01E2B#, 16#01E2B#),  -- (Ll)  LATIN SMALL LETTER H WITH BREVE BELOW .. LATIN SMALL LETTER H WITH BREVE BELOW
     (16#01E2C#, 16#01E2C#),  -- (Lu)  LATIN CAPITAL LETTER I WITH TILDE BELOW .. LATIN CAPITAL LETTER I WITH TILDE BELOW
     (16#01E2D#, 16#01E2D#),  -- (Ll)  LATIN SMALL LETTER I WITH TILDE BELOW .. LATIN SMALL LETTER I WITH TILDE BELOW
     (16#01E2E#, 16#01E2E#),  -- (Lu)  LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE .. LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
     (16#01E2F#, 16#01E2F#),  -- (Ll)  LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
     (16#01E30#, 16#01E30#),  -- (Lu)  LATIN CAPITAL LETTER K WITH ACUTE .. LATIN CAPITAL LETTER K WITH ACUTE
     (16#01E31#, 16#01E31#),  -- (Ll)  LATIN SMALL LETTER K WITH ACUTE .. LATIN SMALL LETTER K WITH ACUTE
     (16#01E32#, 16#01E32#),  -- (Lu)  LATIN CAPITAL LETTER K WITH DOT BELOW .. LATIN CAPITAL LETTER K WITH DOT BELOW
     (16#01E33#, 16#01E33#),  -- (Ll)  LATIN SMALL LETTER K WITH DOT BELOW .. LATIN SMALL LETTER K WITH DOT BELOW
     (16#01E34#, 16#01E34#),  -- (Lu)  LATIN CAPITAL LETTER K WITH LINE BELOW .. LATIN CAPITAL LETTER K WITH LINE BELOW
     (16#01E35#, 16#01E35#),  -- (Ll)  LATIN SMALL LETTER K WITH LINE BELOW .. LATIN SMALL LETTER K WITH LINE BELOW
     (16#01E36#, 16#01E36#),  -- (Lu)  LATIN CAPITAL LETTER L WITH DOT BELOW .. LATIN CAPITAL LETTER L WITH DOT BELOW
     (16#01E37#, 16#01E37#),  -- (Ll)  LATIN SMALL LETTER L WITH DOT BELOW .. LATIN SMALL LETTER L WITH DOT BELOW
     (16#01E38#, 16#01E38#),  -- (Lu)  LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON .. LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
     (16#01E39#, 16#01E39#),  -- (Ll)  LATIN SMALL LETTER L WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
     (16#01E3A#, 16#01E3A#),  -- (Lu)  LATIN CAPITAL LETTER L WITH LINE BELOW .. LATIN CAPITAL LETTER L WITH LINE BELOW
     (16#01E3B#, 16#01E3B#),  -- (Ll)  LATIN SMALL LETTER L WITH LINE BELOW .. LATIN SMALL LETTER L WITH LINE BELOW
     (16#01E3C#, 16#01E3C#),  -- (Lu)  LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
     (16#01E3D#, 16#01E3D#),  -- (Ll)  LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
     (16#01E3E#, 16#01E3E#),  -- (Lu)  LATIN CAPITAL LETTER M WITH ACUTE .. LATIN CAPITAL LETTER M WITH ACUTE
     (16#01E3F#, 16#01E3F#),  -- (Ll)  LATIN SMALL LETTER M WITH ACUTE .. LATIN SMALL LETTER M WITH ACUTE
     (16#01E40#, 16#01E40#),  -- (Lu)  LATIN CAPITAL LETTER M WITH DOT ABOVE .. LATIN CAPITAL LETTER M WITH DOT ABOVE
     (16#01E41#, 16#01E41#),  -- (Ll)  LATIN SMALL LETTER M WITH DOT ABOVE .. LATIN SMALL LETTER M WITH DOT ABOVE
     (16#01E42#, 16#01E42#),  -- (Lu)  LATIN CAPITAL LETTER M WITH DOT BELOW .. LATIN CAPITAL LETTER M WITH DOT BELOW
     (16#01E43#, 16#01E43#),  -- (Ll)  LATIN SMALL LETTER M WITH DOT BELOW .. LATIN SMALL LETTER M WITH DOT BELOW
     (16#01E44#, 16#01E44#),  -- (Lu)  LATIN CAPITAL LETTER N WITH DOT ABOVE .. LATIN CAPITAL LETTER N WITH DOT ABOVE
     (16#01E45#, 16#01E45#),  -- (Ll)  LATIN SMALL LETTER N WITH DOT ABOVE .. LATIN SMALL LETTER N WITH DOT ABOVE
     (16#01E46#, 16#01E46#),  -- (Lu)  LATIN CAPITAL LETTER N WITH DOT BELOW .. LATIN CAPITAL LETTER N WITH DOT BELOW
     (16#01E47#, 16#01E47#),  -- (Ll)  LATIN SMALL LETTER N WITH DOT BELOW .. LATIN SMALL LETTER N WITH DOT BELOW
     (16#01E48#, 16#01E48#),  -- (Lu)  LATIN CAPITAL LETTER N WITH LINE BELOW .. LATIN CAPITAL LETTER N WITH LINE BELOW
     (16#01E49#, 16#01E49#),  -- (Ll)  LATIN SMALL LETTER N WITH LINE BELOW .. LATIN SMALL LETTER N WITH LINE BELOW
     (16#01E4A#, 16#01E4A#),  -- (Lu)  LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
     (16#01E4B#, 16#01E4B#),  -- (Ll)  LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
     (16#01E4C#, 16#01E4C#),  -- (Lu)  LATIN CAPITAL LETTER O WITH TILDE AND ACUTE .. LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
     (16#01E4D#, 16#01E4D#),  -- (Ll)  LATIN SMALL LETTER O WITH TILDE AND ACUTE .. LATIN SMALL LETTER O WITH TILDE AND ACUTE
     (16#01E4E#, 16#01E4E#),  -- (Lu)  LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS .. LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
     (16#01E4F#, 16#01E4F#),  -- (Ll)  LATIN SMALL LETTER O WITH TILDE AND DIAERESIS .. LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
     (16#01E50#, 16#01E50#),  -- (Lu)  LATIN CAPITAL LETTER O WITH MACRON AND GRAVE .. LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
     (16#01E51#, 16#01E51#),  -- (Ll)  LATIN SMALL LETTER O WITH MACRON AND GRAVE .. LATIN SMALL LETTER O WITH MACRON AND GRAVE
     (16#01E52#, 16#01E52#),  -- (Lu)  LATIN CAPITAL LETTER O WITH MACRON AND ACUTE .. LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
     (16#01E53#, 16#01E53#),  -- (Ll)  LATIN SMALL LETTER O WITH MACRON AND ACUTE .. LATIN SMALL LETTER O WITH MACRON AND ACUTE
     (16#01E54#, 16#01E54#),  -- (Lu)  LATIN CAPITAL LETTER P WITH ACUTE .. LATIN CAPITAL LETTER P WITH ACUTE
     (16#01E55#, 16#01E55#),  -- (Ll)  LATIN SMALL LETTER P WITH ACUTE .. LATIN SMALL LETTER P WITH ACUTE
     (16#01E56#, 16#01E56#),  -- (Lu)  LATIN CAPITAL LETTER P WITH DOT ABOVE .. LATIN CAPITAL LETTER P WITH DOT ABOVE
     (16#01E57#, 16#01E57#),  -- (Ll)  LATIN SMALL LETTER P WITH DOT ABOVE .. LATIN SMALL LETTER P WITH DOT ABOVE
     (16#01E58#, 16#01E58#),  -- (Lu)  LATIN CAPITAL LETTER R WITH DOT ABOVE .. LATIN CAPITAL LETTER R WITH DOT ABOVE
     (16#01E59#, 16#01E59#),  -- (Ll)  LATIN SMALL LETTER R WITH DOT ABOVE .. LATIN SMALL LETTER R WITH DOT ABOVE
     (16#01E5A#, 16#01E5A#),  -- (Lu)  LATIN CAPITAL LETTER R WITH DOT BELOW .. LATIN CAPITAL LETTER R WITH DOT BELOW
     (16#01E5B#, 16#01E5B#),  -- (Ll)  LATIN SMALL LETTER R WITH DOT BELOW .. LATIN SMALL LETTER R WITH DOT BELOW
     (16#01E5C#, 16#01E5C#),  -- (Lu)  LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON .. LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
     (16#01E5D#, 16#01E5D#),  -- (Ll)  LATIN SMALL LETTER R WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
     (16#01E5E#, 16#01E5E#),  -- (Lu)  LATIN CAPITAL LETTER R WITH LINE BELOW .. LATIN CAPITAL LETTER R WITH LINE BELOW
     (16#01E5F#, 16#01E5F#),  -- (Ll)  LATIN SMALL LETTER R WITH LINE BELOW .. LATIN SMALL LETTER R WITH LINE BELOW
     (16#01E60#, 16#01E60#),  -- (Lu)  LATIN CAPITAL LETTER S WITH DOT ABOVE .. LATIN CAPITAL LETTER S WITH DOT ABOVE
     (16#01E61#, 16#01E61#),  -- (Ll)  LATIN SMALL LETTER S WITH DOT ABOVE .. LATIN SMALL LETTER S WITH DOT ABOVE
     (16#01E62#, 16#01E62#),  -- (Lu)  LATIN CAPITAL LETTER S WITH DOT BELOW .. LATIN CAPITAL LETTER S WITH DOT BELOW
     (16#01E63#, 16#01E63#),  -- (Ll)  LATIN SMALL LETTER S WITH DOT BELOW .. LATIN SMALL LETTER S WITH DOT BELOW
     (16#01E64#, 16#01E64#),  -- (Lu)  LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
     (16#01E65#, 16#01E65#),  -- (Ll)  LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
     (16#01E66#, 16#01E66#),  -- (Lu)  LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
     (16#01E67#, 16#01E67#),  -- (Ll)  LATIN SMALL LETTER S WITH CARON AND DOT ABOVE .. LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
     (16#01E68#, 16#01E68#),  -- (Lu)  LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
     (16#01E69#, 16#01E69#),  -- (Ll)  LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
     (16#01E6A#, 16#01E6A#),  -- (Lu)  LATIN CAPITAL LETTER T WITH DOT ABOVE .. LATIN CAPITAL LETTER T WITH DOT ABOVE
     (16#01E6B#, 16#01E6B#),  -- (Ll)  LATIN SMALL LETTER T WITH DOT ABOVE .. LATIN SMALL LETTER T WITH DOT ABOVE
     (16#01E6C#, 16#01E6C#),  -- (Lu)  LATIN CAPITAL LETTER T WITH DOT BELOW .. LATIN CAPITAL LETTER T WITH DOT BELOW
     (16#01E6D#, 16#01E6D#),  -- (Ll)  LATIN SMALL LETTER T WITH DOT BELOW .. LATIN SMALL LETTER T WITH DOT BELOW
     (16#01E6E#, 16#01E6E#),  -- (Lu)  LATIN CAPITAL LETTER T WITH LINE BELOW .. LATIN CAPITAL LETTER T WITH LINE BELOW
     (16#01E6F#, 16#01E6F#),  -- (Ll)  LATIN SMALL LETTER T WITH LINE BELOW .. LATIN SMALL LETTER T WITH LINE BELOW
     (16#01E70#, 16#01E70#),  -- (Lu)  LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
     (16#01E71#, 16#01E71#),  -- (Ll)  LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
     (16#01E72#, 16#01E72#),  -- (Lu)  LATIN CAPITAL LETTER U WITH DIAERESIS BELOW .. LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
     (16#01E73#, 16#01E73#),  -- (Ll)  LATIN SMALL LETTER U WITH DIAERESIS BELOW .. LATIN SMALL LETTER U WITH DIAERESIS BELOW
     (16#01E74#, 16#01E74#),  -- (Lu)  LATIN CAPITAL LETTER U WITH TILDE BELOW .. LATIN CAPITAL LETTER U WITH TILDE BELOW
     (16#01E75#, 16#01E75#),  -- (Ll)  LATIN SMALL LETTER U WITH TILDE BELOW .. LATIN SMALL LETTER U WITH TILDE BELOW
     (16#01E76#, 16#01E76#),  -- (Lu)  LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
     (16#01E77#, 16#01E77#),  -- (Ll)  LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
     (16#01E78#, 16#01E78#),  -- (Lu)  LATIN CAPITAL LETTER U WITH TILDE AND ACUTE .. LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
     (16#01E79#, 16#01E79#),  -- (Ll)  LATIN SMALL LETTER U WITH TILDE AND ACUTE .. LATIN SMALL LETTER U WITH TILDE AND ACUTE
     (16#01E7A#, 16#01E7A#),  -- (Lu)  LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS .. LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
     (16#01E7B#, 16#01E7B#),  -- (Ll)  LATIN SMALL LETTER U WITH MACRON AND DIAERESIS .. LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
     (16#01E7C#, 16#01E7C#),  -- (Lu)  LATIN CAPITAL LETTER V WITH TILDE .. LATIN CAPITAL LETTER V WITH TILDE
     (16#01E7D#, 16#01E7D#),  -- (Ll)  LATIN SMALL LETTER V WITH TILDE .. LATIN SMALL LETTER V WITH TILDE
     (16#01E7E#, 16#01E7E#),  -- (Lu)  LATIN CAPITAL LETTER V WITH DOT BELOW .. LATIN CAPITAL LETTER V WITH DOT BELOW
     (16#01E7F#, 16#01E7F#),  -- (Ll)  LATIN SMALL LETTER V WITH DOT BELOW .. LATIN SMALL LETTER V WITH DOT BELOW
     (16#01E80#, 16#01E80#),  -- (Lu)  LATIN CAPITAL LETTER W WITH GRAVE .. LATIN CAPITAL LETTER W WITH GRAVE
     (16#01E81#, 16#01E81#),  -- (Ll)  LATIN SMALL LETTER W WITH GRAVE .. LATIN SMALL LETTER W WITH GRAVE
     (16#01E82#, 16#01E82#),  -- (Lu)  LATIN CAPITAL LETTER W WITH ACUTE .. LATIN CAPITAL LETTER W WITH ACUTE
     (16#01E83#, 16#01E83#),  -- (Ll)  LATIN SMALL LETTER W WITH ACUTE .. LATIN SMALL LETTER W WITH ACUTE
     (16#01E84#, 16#01E84#),  -- (Lu)  LATIN CAPITAL LETTER W WITH DIAERESIS .. LATIN CAPITAL LETTER W WITH DIAERESIS
     (16#01E85#, 16#01E85#),  -- (Ll)  LATIN SMALL LETTER W WITH DIAERESIS .. LATIN SMALL LETTER W WITH DIAERESIS
     (16#01E86#, 16#01E86#),  -- (Lu)  LATIN CAPITAL LETTER W WITH DOT ABOVE .. LATIN CAPITAL LETTER W WITH DOT ABOVE
     (16#01E87#, 16#01E87#),  -- (Ll)  LATIN SMALL LETTER W WITH DOT ABOVE .. LATIN SMALL LETTER W WITH DOT ABOVE
     (16#01E88#, 16#01E88#),  -- (Lu)  LATIN CAPITAL LETTER W WITH DOT BELOW .. LATIN CAPITAL LETTER W WITH DOT BELOW
     (16#01E89#, 16#01E89#),  -- (Ll)  LATIN SMALL LETTER W WITH DOT BELOW .. LATIN SMALL LETTER W WITH DOT BELOW
     (16#01E8A#, 16#01E8A#),  -- (Lu)  LATIN CAPITAL LETTER X WITH DOT ABOVE .. LATIN CAPITAL LETTER X WITH DOT ABOVE
     (16#01E8B#, 16#01E8B#),  -- (Ll)  LATIN SMALL LETTER X WITH DOT ABOVE .. LATIN SMALL LETTER X WITH DOT ABOVE
     (16#01E8C#, 16#01E8C#),  -- (Lu)  LATIN CAPITAL LETTER X WITH DIAERESIS .. LATIN CAPITAL LETTER X WITH DIAERESIS
     (16#01E8D#, 16#01E8D#),  -- (Ll)  LATIN SMALL LETTER X WITH DIAERESIS .. LATIN SMALL LETTER X WITH DIAERESIS
     (16#01E8E#, 16#01E8E#),  -- (Lu)  LATIN CAPITAL LETTER Y WITH DOT ABOVE .. LATIN CAPITAL LETTER Y WITH DOT ABOVE
     (16#01E8F#, 16#01E8F#),  -- (Ll)  LATIN SMALL LETTER Y WITH DOT ABOVE .. LATIN SMALL LETTER Y WITH DOT ABOVE
     (16#01E90#, 16#01E90#),  -- (Lu)  LATIN CAPITAL LETTER Z WITH CIRCUMFLEX .. LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
     (16#01E91#, 16#01E91#),  -- (Ll)  LATIN SMALL LETTER Z WITH CIRCUMFLEX .. LATIN SMALL LETTER Z WITH CIRCUMFLEX
     (16#01E92#, 16#01E92#),  -- (Lu)  LATIN CAPITAL LETTER Z WITH DOT BELOW .. LATIN CAPITAL LETTER Z WITH DOT BELOW
     (16#01E93#, 16#01E93#),  -- (Ll)  LATIN SMALL LETTER Z WITH DOT BELOW .. LATIN SMALL LETTER Z WITH DOT BELOW
     (16#01E94#, 16#01E94#),  -- (Lu)  LATIN CAPITAL LETTER Z WITH LINE BELOW .. LATIN CAPITAL LETTER Z WITH LINE BELOW
     (16#01E95#, 16#01E9B#),  -- (Ll)  LATIN SMALL LETTER Z WITH LINE BELOW .. LATIN SMALL LETTER LONG S WITH DOT ABOVE
     (16#01EA0#, 16#01EA0#),  -- (Lu)  LATIN CAPITAL LETTER A WITH DOT BELOW .. LATIN CAPITAL LETTER A WITH DOT BELOW
     (16#01EA1#, 16#01EA1#),  -- (Ll)  LATIN SMALL LETTER A WITH DOT BELOW .. LATIN SMALL LETTER A WITH DOT BELOW
     (16#01EA2#, 16#01EA2#),  -- (Lu)  LATIN CAPITAL LETTER A WITH HOOK ABOVE .. LATIN CAPITAL LETTER A WITH HOOK ABOVE
     (16#01EA3#, 16#01EA3#),  -- (Ll)  LATIN SMALL LETTER A WITH HOOK ABOVE .. LATIN SMALL LETTER A WITH HOOK ABOVE
     (16#01EA4#, 16#01EA4#),  -- (Lu)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
     (16#01EA5#, 16#01EA5#),  -- (Ll)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
     (16#01EA6#, 16#01EA6#),  -- (Lu)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
     (16#01EA7#, 16#01EA7#),  -- (Ll)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
     (16#01EA8#, 16#01EA8#),  -- (Lu)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EA9#, 16#01EA9#),  -- (Ll)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EAA#, 16#01EAA#),  -- (Lu)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
     (16#01EAB#, 16#01EAB#),  -- (Ll)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
     (16#01EAC#, 16#01EAC#),  -- (Lu)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     (16#01EAD#, 16#01EAD#),  -- (Ll)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     (16#01EAE#, 16#01EAE#),  -- (Lu)  LATIN CAPITAL LETTER A WITH BREVE AND ACUTE .. LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
     (16#01EAF#, 16#01EAF#),  -- (Ll)  LATIN SMALL LETTER A WITH BREVE AND ACUTE .. LATIN SMALL LETTER A WITH BREVE AND ACUTE
     (16#01EB0#, 16#01EB0#),  -- (Lu)  LATIN CAPITAL LETTER A WITH BREVE AND GRAVE .. LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
     (16#01EB1#, 16#01EB1#),  -- (Ll)  LATIN SMALL LETTER A WITH BREVE AND GRAVE .. LATIN SMALL LETTER A WITH BREVE AND GRAVE
     (16#01EB2#, 16#01EB2#),  -- (Lu)  LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
     (16#01EB3#, 16#01EB3#),  -- (Ll)  LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
     (16#01EB4#, 16#01EB4#),  -- (Lu)  LATIN CAPITAL LETTER A WITH BREVE AND TILDE .. LATIN CAPITAL LETTER A WITH BREVE AND TILDE
     (16#01EB5#, 16#01EB5#),  -- (Ll)  LATIN SMALL LETTER A WITH BREVE AND TILDE .. LATIN SMALL LETTER A WITH BREVE AND TILDE
     (16#01EB6#, 16#01EB6#),  -- (Lu)  LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW .. LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
     (16#01EB7#, 16#01EB7#),  -- (Ll)  LATIN SMALL LETTER A WITH BREVE AND DOT BELOW .. LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
     (16#01EB8#, 16#01EB8#),  -- (Lu)  LATIN CAPITAL LETTER E WITH DOT BELOW .. LATIN CAPITAL LETTER E WITH DOT BELOW
     (16#01EB9#, 16#01EB9#),  -- (Ll)  LATIN SMALL LETTER E WITH DOT BELOW .. LATIN SMALL LETTER E WITH DOT BELOW
     (16#01EBA#, 16#01EBA#),  -- (Lu)  LATIN CAPITAL LETTER E WITH HOOK ABOVE .. LATIN CAPITAL LETTER E WITH HOOK ABOVE
     (16#01EBB#, 16#01EBB#),  -- (Ll)  LATIN SMALL LETTER E WITH HOOK ABOVE .. LATIN SMALL LETTER E WITH HOOK ABOVE
     (16#01EBC#, 16#01EBC#),  -- (Lu)  LATIN CAPITAL LETTER E WITH TILDE .. LATIN CAPITAL LETTER E WITH TILDE
     (16#01EBD#, 16#01EBD#),  -- (Ll)  LATIN SMALL LETTER E WITH TILDE .. LATIN SMALL LETTER E WITH TILDE
     (16#01EBE#, 16#01EBE#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
     (16#01EBF#, 16#01EBF#),  -- (Ll)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
     (16#01EC0#, 16#01EC0#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
     (16#01EC1#, 16#01EC1#),  -- (Ll)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
     (16#01EC2#, 16#01EC2#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EC3#, 16#01EC3#),  -- (Ll)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EC4#, 16#01EC4#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
     (16#01EC5#, 16#01EC5#),  -- (Ll)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
     (16#01EC6#, 16#01EC6#),  -- (Lu)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     (16#01EC7#, 16#01EC7#),  -- (Ll)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     (16#01EC8#, 16#01EC8#),  -- (Lu)  LATIN CAPITAL LETTER I WITH HOOK ABOVE .. LATIN CAPITAL LETTER I WITH HOOK ABOVE
     (16#01EC9#, 16#01EC9#),  -- (Ll)  LATIN SMALL LETTER I WITH HOOK ABOVE .. LATIN SMALL LETTER I WITH HOOK ABOVE
     (16#01ECA#, 16#01ECA#),  -- (Lu)  LATIN CAPITAL LETTER I WITH DOT BELOW .. LATIN CAPITAL LETTER I WITH DOT BELOW
     (16#01ECB#, 16#01ECB#),  -- (Ll)  LATIN SMALL LETTER I WITH DOT BELOW .. LATIN SMALL LETTER I WITH DOT BELOW
     (16#01ECC#, 16#01ECC#),  -- (Lu)  LATIN CAPITAL LETTER O WITH DOT BELOW .. LATIN CAPITAL LETTER O WITH DOT BELOW
     (16#01ECD#, 16#01ECD#),  -- (Ll)  LATIN SMALL LETTER O WITH DOT BELOW .. LATIN SMALL LETTER O WITH DOT BELOW
     (16#01ECE#, 16#01ECE#),  -- (Lu)  LATIN CAPITAL LETTER O WITH HOOK ABOVE .. LATIN CAPITAL LETTER O WITH HOOK ABOVE
     (16#01ECF#, 16#01ECF#),  -- (Ll)  LATIN SMALL LETTER O WITH HOOK ABOVE .. LATIN SMALL LETTER O WITH HOOK ABOVE
     (16#01ED0#, 16#01ED0#),  -- (Lu)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
     (16#01ED1#, 16#01ED1#),  -- (Ll)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
     (16#01ED2#, 16#01ED2#),  -- (Lu)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
     (16#01ED3#, 16#01ED3#),  -- (Ll)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
     (16#01ED4#, 16#01ED4#),  -- (Lu)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01ED5#, 16#01ED5#),  -- (Ll)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01ED6#, 16#01ED6#),  -- (Lu)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
     (16#01ED7#, 16#01ED7#),  -- (Ll)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
     (16#01ED8#, 16#01ED8#),  -- (Lu)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     (16#01ED9#, 16#01ED9#),  -- (Ll)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     (16#01EDA#, 16#01EDA#),  -- (Lu)  LATIN CAPITAL LETTER O WITH HORN AND ACUTE .. LATIN CAPITAL LETTER O WITH HORN AND ACUTE
     (16#01EDB#, 16#01EDB#),  -- (Ll)  LATIN SMALL LETTER O WITH HORN AND ACUTE .. LATIN SMALL LETTER O WITH HORN AND ACUTE
     (16#01EDC#, 16#01EDC#),  -- (Lu)  LATIN CAPITAL LETTER O WITH HORN AND GRAVE .. LATIN CAPITAL LETTER O WITH HORN AND GRAVE
     (16#01EDD#, 16#01EDD#),  -- (Ll)  LATIN SMALL LETTER O WITH HORN AND GRAVE .. LATIN SMALL LETTER O WITH HORN AND GRAVE
     (16#01EDE#, 16#01EDE#),  -- (Lu)  LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE .. LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
     (16#01EDF#, 16#01EDF#),  -- (Ll)  LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
     (16#01EE0#, 16#01EE0#),  -- (Lu)  LATIN CAPITAL LETTER O WITH HORN AND TILDE .. LATIN CAPITAL LETTER O WITH HORN AND TILDE
     (16#01EE1#, 16#01EE1#),  -- (Ll)  LATIN SMALL LETTER O WITH HORN AND TILDE .. LATIN SMALL LETTER O WITH HORN AND TILDE
     (16#01EE2#, 16#01EE2#),  -- (Lu)  LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW .. LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
     (16#01EE3#, 16#01EE3#),  -- (Ll)  LATIN SMALL LETTER O WITH HORN AND DOT BELOW .. LATIN SMALL LETTER O WITH HORN AND DOT BELOW
     (16#01EE4#, 16#01EE4#),  -- (Lu)  LATIN CAPITAL LETTER U WITH DOT BELOW .. LATIN CAPITAL LETTER U WITH DOT BELOW
     (16#01EE5#, 16#01EE5#),  -- (Ll)  LATIN SMALL LETTER U WITH DOT BELOW .. LATIN SMALL LETTER U WITH DOT BELOW
     (16#01EE6#, 16#01EE6#),  -- (Lu)  LATIN CAPITAL LETTER U WITH HOOK ABOVE .. LATIN CAPITAL LETTER U WITH HOOK ABOVE
     (16#01EE7#, 16#01EE7#),  -- (Ll)  LATIN SMALL LETTER U WITH HOOK ABOVE .. LATIN SMALL LETTER U WITH HOOK ABOVE
     (16#01EE8#, 16#01EE8#),  -- (Lu)  LATIN CAPITAL LETTER U WITH HORN AND ACUTE .. LATIN CAPITAL LETTER U WITH HORN AND ACUTE
     (16#01EE9#, 16#01EE9#),  -- (Ll)  LATIN SMALL LETTER U WITH HORN AND ACUTE .. LATIN SMALL LETTER U WITH HORN AND ACUTE
     (16#01EEA#, 16#01EEA#),  -- (Lu)  LATIN CAPITAL LETTER U WITH HORN AND GRAVE .. LATIN CAPITAL LETTER U WITH HORN AND GRAVE
     (16#01EEB#, 16#01EEB#),  -- (Ll)  LATIN SMALL LETTER U WITH HORN AND GRAVE .. LATIN SMALL LETTER U WITH HORN AND GRAVE
     (16#01EEC#, 16#01EEC#),  -- (Lu)  LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE .. LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
     (16#01EED#, 16#01EED#),  -- (Ll)  LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
     (16#01EEE#, 16#01EEE#),  -- (Lu)  LATIN CAPITAL LETTER U WITH HORN AND TILDE .. LATIN CAPITAL LETTER U WITH HORN AND TILDE
     (16#01EEF#, 16#01EEF#),  -- (Ll)  LATIN SMALL LETTER U WITH HORN AND TILDE .. LATIN SMALL LETTER U WITH HORN AND TILDE
     (16#01EF0#, 16#01EF0#),  -- (Lu)  LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW .. LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
     (16#01EF1#, 16#01EF1#),  -- (Ll)  LATIN SMALL LETTER U WITH HORN AND DOT BELOW .. LATIN SMALL LETTER U WITH HORN AND DOT BELOW
     (16#01EF2#, 16#01EF2#),  -- (Lu)  LATIN CAPITAL LETTER Y WITH GRAVE .. LATIN CAPITAL LETTER Y WITH GRAVE
     (16#01EF3#, 16#01EF3#),  -- (Ll)  LATIN SMALL LETTER Y WITH GRAVE .. LATIN SMALL LETTER Y WITH GRAVE
     (16#01EF4#, 16#01EF4#),  -- (Lu)  LATIN CAPITAL LETTER Y WITH DOT BELOW .. LATIN CAPITAL LETTER Y WITH DOT BELOW
     (16#01EF5#, 16#01EF5#),  -- (Ll)  LATIN SMALL LETTER Y WITH DOT BELOW .. LATIN SMALL LETTER Y WITH DOT BELOW
     (16#01EF6#, 16#01EF6#),  -- (Lu)  LATIN CAPITAL LETTER Y WITH HOOK ABOVE .. LATIN CAPITAL LETTER Y WITH HOOK ABOVE
     (16#01EF7#, 16#01EF7#),  -- (Ll)  LATIN SMALL LETTER Y WITH HOOK ABOVE .. LATIN SMALL LETTER Y WITH HOOK ABOVE
     (16#01EF8#, 16#01EF8#),  -- (Lu)  LATIN CAPITAL LETTER Y WITH TILDE .. LATIN CAPITAL LETTER Y WITH TILDE
     (16#01EF9#, 16#01EF9#),  -- (Ll)  LATIN SMALL LETTER Y WITH TILDE .. LATIN SMALL LETTER Y WITH TILDE
     (16#01F00#, 16#01F07#),  -- (Ll)  GREEK SMALL LETTER ALPHA WITH PSILI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
     (16#01F08#, 16#01F0F#),  -- (Lu)  GREEK CAPITAL LETTER ALPHA WITH PSILI .. GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
     (16#01F10#, 16#01F15#),  -- (Ll)  GREEK SMALL LETTER EPSILON WITH PSILI .. GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F18#, 16#01F1D#),  -- (Lu)  GREEK CAPITAL LETTER EPSILON WITH PSILI .. GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F20#, 16#01F27#),  -- (Ll)  GREEK SMALL LETTER ETA WITH PSILI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
     (16#01F28#, 16#01F2F#),  -- (Lu)  GREEK CAPITAL LETTER ETA WITH PSILI .. GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
     (16#01F30#, 16#01F37#),  -- (Ll)  GREEK SMALL LETTER IOTA WITH PSILI .. GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
     (16#01F38#, 16#01F3F#),  -- (Lu)  GREEK CAPITAL LETTER IOTA WITH PSILI .. GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
     (16#01F40#, 16#01F45#),  -- (Ll)  GREEK SMALL LETTER OMICRON WITH PSILI .. GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F48#, 16#01F4D#),  -- (Lu)  GREEK CAPITAL LETTER OMICRON WITH PSILI .. GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F50#, 16#01F57#),  -- (Ll)  GREEK SMALL LETTER UPSILON WITH PSILI .. GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
     (16#01F59#, 16#01F59#),  -- (Lu)  GREEK CAPITAL LETTER UPSILON WITH DASIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA
     (16#01F5B#, 16#01F5B#),  -- (Lu)  GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
     (16#01F5D#, 16#01F5D#),  -- (Lu)  GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
     (16#01F5F#, 16#01F5F#),  -- (Lu)  GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
     (16#01F60#, 16#01F67#),  -- (Ll)  GREEK SMALL LETTER OMEGA WITH PSILI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
     (16#01F68#, 16#01F6F#),  -- (Lu)  GREEK CAPITAL LETTER OMEGA WITH PSILI .. GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
     (16#01F70#, 16#01F7D#),  -- (Ll)  GREEK SMALL LETTER ALPHA WITH VARIA .. GREEK SMALL LETTER OMEGA WITH OXIA
     (16#01F80#, 16#01F87#),  -- (Ll)  GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     (16#01F88#, 16#01F8F#),  -- (Lt)  GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI .. GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
     (16#01F90#, 16#01F97#),  -- (Ll)  GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     (16#01F98#, 16#01F9F#),  -- (Lt)  GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI .. GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
     (16#01FA0#, 16#01FA7#),  -- (Ll)  GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     (16#01FA8#, 16#01FAF#),  -- (Lt)  GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI .. GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
     (16#01FB0#, 16#01FB4#),  -- (Ll)  GREEK SMALL LETTER ALPHA WITH VRACHY .. GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
     (16#01FB6#, 16#01FB7#),  -- (Ll)  GREEK SMALL LETTER ALPHA WITH PERISPOMENI .. GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
     (16#01FB8#, 16#01FBB#),  -- (Lu)  GREEK CAPITAL LETTER ALPHA WITH VRACHY .. GREEK CAPITAL LETTER ALPHA WITH OXIA
     (16#01FBC#, 16#01FBC#),  -- (Lt)  GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI .. GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
     (16#01FBD#, 16#01FBD#),  -- (Sk)  GREEK KORONIS .. GREEK KORONIS
     (16#01FBE#, 16#01FBE#),  -- (Ll)  GREEK PROSGEGRAMMENI .. GREEK PROSGEGRAMMENI
     (16#01FBF#, 16#01FC1#),  -- (Sk)  GREEK PSILI .. GREEK DIALYTIKA AND PERISPOMENI
     (16#01FC2#, 16#01FC4#),  -- (Ll)  GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
     (16#01FC6#, 16#01FC7#),  -- (Ll)  GREEK SMALL LETTER ETA WITH PERISPOMENI .. GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
     (16#01FC8#, 16#01FCB#),  -- (Lu)  GREEK CAPITAL LETTER EPSILON WITH VARIA .. GREEK CAPITAL LETTER ETA WITH OXIA
     (16#01FCC#, 16#01FCC#),  -- (Lt)  GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI .. GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
     (16#01FCD#, 16#01FCF#),  -- (Sk)  GREEK PSILI AND VARIA .. GREEK PSILI AND PERISPOMENI
     (16#01FD0#, 16#01FD3#),  -- (Ll)  GREEK SMALL LETTER IOTA WITH VRACHY .. GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
     (16#01FD6#, 16#01FD7#),  -- (Ll)  GREEK SMALL LETTER IOTA WITH PERISPOMENI .. GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
     (16#01FD8#, 16#01FDB#),  -- (Lu)  GREEK CAPITAL LETTER IOTA WITH VRACHY .. GREEK CAPITAL LETTER IOTA WITH OXIA
     (16#01FDD#, 16#01FDF#),  -- (Sk)  GREEK DASIA AND VARIA .. GREEK DASIA AND PERISPOMENI
     (16#01FE0#, 16#01FE7#),  -- (Ll)  GREEK SMALL LETTER UPSILON WITH VRACHY .. GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
     (16#01FE8#, 16#01FEC#),  -- (Lu)  GREEK CAPITAL LETTER UPSILON WITH VRACHY .. GREEK CAPITAL LETTER RHO WITH DASIA
     (16#01FED#, 16#01FEF#),  -- (Sk)  GREEK DIALYTIKA AND VARIA .. GREEK VARIA
     (16#01FF2#, 16#01FF4#),  -- (Ll)  GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
     (16#01FF6#, 16#01FF7#),  -- (Ll)  GREEK SMALL LETTER OMEGA WITH PERISPOMENI .. GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
     (16#01FF8#, 16#01FFB#),  -- (Lu)  GREEK CAPITAL LETTER OMICRON WITH VARIA .. GREEK CAPITAL LETTER OMEGA WITH OXIA
     (16#01FFC#, 16#01FFC#),  -- (Lt)  GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI .. GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
     (16#01FFD#, 16#01FFE#),  -- (Sk)  GREEK OXIA .. GREEK DASIA
     (16#02000#, 16#0200B#),  -- (Zs)  EN QUAD .. ZERO WIDTH SPACE
     (16#0200C#, 16#0200F#),  -- (Cf)  ZERO WIDTH NON-JOINER .. RIGHT-TO-LEFT MARK
     (16#02010#, 16#02015#),  -- (Pd)  HYPHEN .. HORIZONTAL BAR
     (16#02016#, 16#02017#),  -- (Po)  DOUBLE VERTICAL LINE .. DOUBLE LOW LINE
     (16#02018#, 16#02018#),  -- (Pi)  LEFT SINGLE QUOTATION MARK .. LEFT SINGLE QUOTATION MARK
     (16#02019#, 16#02019#),  -- (Pf)  RIGHT SINGLE QUOTATION MARK .. RIGHT SINGLE QUOTATION MARK
     (16#0201A#, 16#0201A#),  -- (Ps)  SINGLE LOW-9 QUOTATION MARK .. SINGLE LOW-9 QUOTATION MARK
     (16#0201B#, 16#0201C#),  -- (Pi)  SINGLE HIGH-REVERSED-9 QUOTATION MARK .. LEFT DOUBLE QUOTATION MARK
     (16#0201D#, 16#0201D#),  -- (Pf)  RIGHT DOUBLE QUOTATION MARK .. RIGHT DOUBLE QUOTATION MARK
     (16#0201E#, 16#0201E#),  -- (Ps)  DOUBLE LOW-9 QUOTATION MARK .. DOUBLE LOW-9 QUOTATION MARK
     (16#0201F#, 16#0201F#),  -- (Pi)  DOUBLE HIGH-REVERSED-9 QUOTATION MARK .. DOUBLE HIGH-REVERSED-9 QUOTATION MARK
     (16#02020#, 16#02027#),  -- (Po)  DAGGER .. HYPHENATION POINT
     (16#02028#, 16#02028#),  -- (Zl)  LINE SEPARATOR .. LINE SEPARATOR
     (16#02029#, 16#02029#),  -- (Zp)  PARAGRAPH SEPARATOR .. PARAGRAPH SEPARATOR
     (16#0202A#, 16#0202E#),  -- (Cf)  LEFT-TO-RIGHT EMBEDDING .. RIGHT-TO-LEFT OVERRIDE
     (16#0202F#, 16#0202F#),  -- (Zs)  NARROW NO-BREAK SPACE .. NARROW NO-BREAK SPACE
     (16#02030#, 16#02038#),  -- (Po)  PER MILLE SIGN .. CARET
     (16#02039#, 16#02039#),  -- (Pi)  SINGLE LEFT-POINTING ANGLE QUOTATION MARK .. SINGLE LEFT-POINTING ANGLE QUOTATION MARK
     (16#0203A#, 16#0203A#),  -- (Pf)  SINGLE RIGHT-POINTING ANGLE QUOTATION MARK .. SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
     (16#0203B#, 16#0203E#),  -- (Po)  REFERENCE MARK .. OVERLINE
     (16#0203F#, 16#02040#),  -- (Pc)  UNDERTIE .. CHARACTER TIE
     (16#02041#, 16#02043#),  -- (Po)  CARET INSERTION POINT .. HYPHEN BULLET
     (16#02044#, 16#02044#),  -- (Sm)  FRACTION SLASH .. FRACTION SLASH
     (16#02045#, 16#02045#),  -- (Ps)  LEFT SQUARE BRACKET WITH QUILL .. LEFT SQUARE BRACKET WITH QUILL
     (16#02046#, 16#02046#),  -- (Pe)  RIGHT SQUARE BRACKET WITH QUILL .. RIGHT SQUARE BRACKET WITH QUILL
     (16#02047#, 16#02051#),  -- (Po)  DOUBLE QUESTION MARK .. TWO ASTERISKS ALIGNED VERTICALLY
     (16#02052#, 16#02052#),  -- (Sm)  COMMERCIAL MINUS SIGN .. COMMERCIAL MINUS SIGN
     (16#02053#, 16#02053#),  -- (Po)  SWUNG DASH .. SWUNG DASH
     (16#02054#, 16#02054#),  -- (Pc)  INVERTED UNDERTIE .. INVERTED UNDERTIE
     (16#02057#, 16#02057#),  -- (Po)  QUADRUPLE PRIME .. QUADRUPLE PRIME
     (16#0205F#, 16#0205F#),  -- (Zs)  MEDIUM MATHEMATICAL SPACE .. MEDIUM MATHEMATICAL SPACE
     (16#02060#, 16#02063#),  -- (Cf)  WORD JOINER .. INVISIBLE SEPARATOR
     (16#0206A#, 16#0206F#),  -- (Cf)  INHIBIT SYMMETRIC SWAPPING .. NOMINAL DIGIT SHAPES
     (16#02070#, 16#02070#),  -- (No)  SUPERSCRIPT ZERO .. SUPERSCRIPT ZERO
     (16#02071#, 16#02071#),  -- (Ll)  SUPERSCRIPT LATIN SMALL LETTER I .. SUPERSCRIPT LATIN SMALL LETTER I
     (16#02074#, 16#02079#),  -- (No)  SUPERSCRIPT FOUR .. SUPERSCRIPT NINE
     (16#0207A#, 16#0207C#),  -- (Sm)  SUPERSCRIPT PLUS SIGN .. SUPERSCRIPT EQUALS SIGN
     (16#0207D#, 16#0207D#),  -- (Ps)  SUPERSCRIPT LEFT PARENTHESIS .. SUPERSCRIPT LEFT PARENTHESIS
     (16#0207E#, 16#0207E#),  -- (Pe)  SUPERSCRIPT RIGHT PARENTHESIS .. SUPERSCRIPT RIGHT PARENTHESIS
     (16#0207F#, 16#0207F#),  -- (Ll)  SUPERSCRIPT LATIN SMALL LETTER N .. SUPERSCRIPT LATIN SMALL LETTER N
     (16#02080#, 16#02089#),  -- (No)  SUBSCRIPT ZERO .. SUBSCRIPT NINE
     (16#0208A#, 16#0208C#),  -- (Sm)  SUBSCRIPT PLUS SIGN .. SUBSCRIPT EQUALS SIGN
     (16#0208D#, 16#0208D#),  -- (Ps)  SUBSCRIPT LEFT PARENTHESIS .. SUBSCRIPT LEFT PARENTHESIS
     (16#0208E#, 16#0208E#),  -- (Pe)  SUBSCRIPT RIGHT PARENTHESIS .. SUBSCRIPT RIGHT PARENTHESIS
     (16#020A0#, 16#020B1#),  -- (Sc)  EURO-CURRENCY SIGN .. PESO SIGN
     (16#020D0#, 16#020DC#),  -- (Mn)  COMBINING LEFT HARPOON ABOVE .. COMBINING FOUR DOTS ABOVE
     (16#020DD#, 16#020E0#),  -- (Me)  COMBINING ENCLOSING CIRCLE .. COMBINING ENCLOSING CIRCLE BACKSLASH
     (16#020E1#, 16#020E1#),  -- (Mn)  COMBINING LEFT RIGHT ARROW ABOVE .. COMBINING LEFT RIGHT ARROW ABOVE
     (16#020E2#, 16#020E4#),  -- (Me)  COMBINING ENCLOSING SCREEN .. COMBINING ENCLOSING UPWARD POINTING TRIANGLE
     (16#020E5#, 16#020EA#),  -- (Mn)  COMBINING REVERSE SOLIDUS OVERLAY .. COMBINING LEFTWARDS ARROW OVERLAY
     (16#02100#, 16#02101#),  -- (So)  ACCOUNT OF .. ADDRESSED TO THE SUBJECT
     (16#02102#, 16#02102#),  -- (Lu)  DOUBLE-STRUCK CAPITAL C .. DOUBLE-STRUCK CAPITAL C
     (16#02103#, 16#02106#),  -- (So)  DEGREE CELSIUS .. CADA UNA
     (16#02107#, 16#02107#),  -- (Lu)  EULER CONSTANT .. EULER CONSTANT
     (16#02108#, 16#02109#),  -- (So)  SCRUPLE .. DEGREE FAHRENHEIT
     (16#0210A#, 16#0210A#),  -- (Ll)  SCRIPT SMALL G .. SCRIPT SMALL G
     (16#0210B#, 16#0210D#),  -- (Lu)  SCRIPT CAPITAL H .. DOUBLE-STRUCK CAPITAL H
     (16#0210E#, 16#0210F#),  -- (Ll)  PLANCK CONSTANT .. PLANCK CONSTANT OVER TWO PI
     (16#02110#, 16#02112#),  -- (Lu)  SCRIPT CAPITAL I .. SCRIPT CAPITAL L
     (16#02113#, 16#02113#),  -- (Ll)  SCRIPT SMALL L .. SCRIPT SMALL L
     (16#02114#, 16#02114#),  -- (So)  L B BAR SYMBOL .. L B BAR SYMBOL
     (16#02115#, 16#02115#),  -- (Lu)  DOUBLE-STRUCK CAPITAL N .. DOUBLE-STRUCK CAPITAL N
     (16#02116#, 16#02118#),  -- (So)  NUMERO SIGN .. SCRIPT CAPITAL P
     (16#02119#, 16#0211D#),  -- (Lu)  DOUBLE-STRUCK CAPITAL P .. DOUBLE-STRUCK CAPITAL R
     (16#0211E#, 16#02123#),  -- (So)  PRESCRIPTION TAKE .. VERSICLE
     (16#02124#, 16#02124#),  -- (Lu)  DOUBLE-STRUCK CAPITAL Z .. DOUBLE-STRUCK CAPITAL Z
     (16#02125#, 16#02125#),  -- (So)  OUNCE SIGN .. OUNCE SIGN
     (16#02126#, 16#02126#),  -- (Lu)  OHM SIGN .. OHM SIGN
     (16#02127#, 16#02127#),  -- (So)  INVERTED OHM SIGN .. INVERTED OHM SIGN
     (16#02128#, 16#02128#),  -- (Lu)  BLACK-LETTER CAPITAL Z .. BLACK-LETTER CAPITAL Z
     (16#02129#, 16#02129#),  -- (So)  TURNED GREEK SMALL LETTER IOTA .. TURNED GREEK SMALL LETTER IOTA
     (16#0212A#, 16#0212D#),  -- (Lu)  KELVIN SIGN .. BLACK-LETTER CAPITAL C
     (16#0212E#, 16#0212E#),  -- (So)  ESTIMATED SYMBOL .. ESTIMATED SYMBOL
     (16#0212F#, 16#0212F#),  -- (Ll)  SCRIPT SMALL E .. SCRIPT SMALL E
     (16#02130#, 16#02131#),  -- (Lu)  SCRIPT CAPITAL E .. SCRIPT CAPITAL F
     (16#02132#, 16#02132#),  -- (So)  TURNED CAPITAL F .. TURNED CAPITAL F
     (16#02133#, 16#02133#),  -- (Lu)  SCRIPT CAPITAL M .. SCRIPT CAPITAL M
     (16#02134#, 16#02134#),  -- (Ll)  SCRIPT SMALL O .. SCRIPT SMALL O
     (16#02135#, 16#02138#),  -- (Lo)  ALEF SYMBOL .. DALET SYMBOL
     (16#02139#, 16#02139#),  -- (Ll)  INFORMATION SOURCE .. INFORMATION SOURCE
     (16#0213A#, 16#0213B#),  -- (So)  ROTATED CAPITAL Q .. FACSIMILE SIGN
     (16#0213D#, 16#0213D#),  -- (Ll)  DOUBLE-STRUCK SMALL GAMMA .. DOUBLE-STRUCK SMALL GAMMA
     (16#0213E#, 16#0213F#),  -- (Lu)  DOUBLE-STRUCK CAPITAL GAMMA .. DOUBLE-STRUCK CAPITAL PI
     (16#02140#, 16#02144#),  -- (Sm)  DOUBLE-STRUCK N-ARY SUMMATION .. TURNED SANS-SERIF CAPITAL Y
     (16#02145#, 16#02145#),  -- (Lu)  DOUBLE-STRUCK ITALIC CAPITAL D .. DOUBLE-STRUCK ITALIC CAPITAL D
     (16#02146#, 16#02149#),  -- (Ll)  DOUBLE-STRUCK ITALIC SMALL D .. DOUBLE-STRUCK ITALIC SMALL J
     (16#0214A#, 16#0214A#),  -- (So)  PROPERTY LINE .. PROPERTY LINE
     (16#0214B#, 16#0214B#),  -- (Sm)  TURNED AMPERSAND .. TURNED AMPERSAND
     (16#02153#, 16#0215F#),  -- (No)  VULGAR FRACTION ONE THIRD .. FRACTION NUMERATOR ONE
     (16#02160#, 16#02183#),  -- (Nl)  ROMAN NUMERAL ONE .. ROMAN NUMERAL REVERSED ONE HUNDRED
     (16#02190#, 16#02194#),  -- (Sm)  LEFTWARDS ARROW .. LEFT RIGHT ARROW
     (16#02195#, 16#02199#),  -- (So)  UP DOWN ARROW .. SOUTH WEST ARROW
     (16#0219A#, 16#0219B#),  -- (Sm)  LEFTWARDS ARROW WITH STROKE .. RIGHTWARDS ARROW WITH STROKE
     (16#0219C#, 16#0219F#),  -- (So)  LEFTWARDS WAVE ARROW .. UPWARDS TWO HEADED ARROW
     (16#021A0#, 16#021A0#),  -- (Sm)  RIGHTWARDS TWO HEADED ARROW .. RIGHTWARDS TWO HEADED ARROW
     (16#021A1#, 16#021A2#),  -- (So)  DOWNWARDS TWO HEADED ARROW .. LEFTWARDS ARROW WITH TAIL
     (16#021A3#, 16#021A3#),  -- (Sm)  RIGHTWARDS ARROW WITH TAIL .. RIGHTWARDS ARROW WITH TAIL
     (16#021A4#, 16#021A5#),  -- (So)  LEFTWARDS ARROW FROM BAR .. UPWARDS ARROW FROM BAR
     (16#021A6#, 16#021A6#),  -- (Sm)  RIGHTWARDS ARROW FROM BAR .. RIGHTWARDS ARROW FROM BAR
     (16#021A7#, 16#021AD#),  -- (So)  DOWNWARDS ARROW FROM BAR .. LEFT RIGHT WAVE ARROW
     (16#021AE#, 16#021AE#),  -- (Sm)  LEFT RIGHT ARROW WITH STROKE .. LEFT RIGHT ARROW WITH STROKE
     (16#021AF#, 16#021CD#),  -- (So)  DOWNWARDS ZIGZAG ARROW .. LEFTWARDS DOUBLE ARROW WITH STROKE
     (16#021CE#, 16#021CF#),  -- (Sm)  LEFT RIGHT DOUBLE ARROW WITH STROKE .. RIGHTWARDS DOUBLE ARROW WITH STROKE
     (16#021D0#, 16#021D1#),  -- (So)  LEFTWARDS DOUBLE ARROW .. UPWARDS DOUBLE ARROW
     (16#021D2#, 16#021D2#),  -- (Sm)  RIGHTWARDS DOUBLE ARROW .. RIGHTWARDS DOUBLE ARROW
     (16#021D3#, 16#021D3#),  -- (So)  DOWNWARDS DOUBLE ARROW .. DOWNWARDS DOUBLE ARROW
     (16#021D4#, 16#021D4#),  -- (Sm)  LEFT RIGHT DOUBLE ARROW .. LEFT RIGHT DOUBLE ARROW
     (16#021D5#, 16#021F3#),  -- (So)  UP DOWN DOUBLE ARROW .. UP DOWN WHITE ARROW
     (16#021F4#, 16#022FF#),  -- (Sm)  RIGHT ARROW WITH SMALL CIRCLE .. Z NOTATION BAG MEMBERSHIP
     (16#02300#, 16#02307#),  -- (So)  DIAMETER SIGN .. WAVY LINE
     (16#02308#, 16#0230B#),  -- (Sm)  LEFT CEILING .. RIGHT FLOOR
     (16#0230C#, 16#0231F#),  -- (So)  BOTTOM RIGHT CROP .. BOTTOM RIGHT CORNER
     (16#02320#, 16#02321#),  -- (Sm)  TOP HALF INTEGRAL .. BOTTOM HALF INTEGRAL
     (16#02322#, 16#02328#),  -- (So)  FROWN .. KEYBOARD
     (16#02329#, 16#02329#),  -- (Ps)  LEFT-POINTING ANGLE BRACKET .. LEFT-POINTING ANGLE BRACKET
     (16#0232A#, 16#0232A#),  -- (Pe)  RIGHT-POINTING ANGLE BRACKET .. RIGHT-POINTING ANGLE BRACKET
     (16#0232B#, 16#0237B#),  -- (So)  ERASE TO THE LEFT .. NOT CHECK MARK
     (16#0237C#, 16#0237C#),  -- (Sm)  RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW .. RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
     (16#0237D#, 16#0239A#),  -- (So)  SHOULDERED OPEN BOX .. CLEAR SCREEN SYMBOL
     (16#0239B#, 16#023B3#),  -- (Sm)  LEFT PARENTHESIS UPPER HOOK .. SUMMATION BOTTOM
     (16#023B4#, 16#023B4#),  -- (Ps)  TOP SQUARE BRACKET .. TOP SQUARE BRACKET
     (16#023B5#, 16#023B5#),  -- (Pe)  BOTTOM SQUARE BRACKET .. BOTTOM SQUARE BRACKET
     (16#023B6#, 16#023B6#),  -- (Po)  BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET .. BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET
     (16#023B7#, 16#023D0#),  -- (So)  RADICAL SYMBOL BOTTOM .. VERTICAL LINE EXTENSION
     (16#02400#, 16#02426#),  -- (So)  SYMBOL FOR NULL .. SYMBOL FOR SUBSTITUTE FORM TWO
     (16#02440#, 16#0244A#),  -- (So)  OCR HOOK .. OCR DOUBLE BACKSLASH
     (16#02460#, 16#0249B#),  -- (No)  CIRCLED DIGIT ONE .. NUMBER TWENTY FULL STOP
     (16#0249C#, 16#024E9#),  -- (So)  PARENTHESIZED LATIN SMALL LETTER A .. CIRCLED LATIN SMALL LETTER Z
     (16#024EA#, 16#024FF#),  -- (No)  CIRCLED DIGIT ZERO .. NEGATIVE CIRCLED DIGIT ZERO
     (16#02500#, 16#025B6#),  -- (So)  BOX DRAWINGS LIGHT HORIZONTAL .. BLACK RIGHT-POINTING TRIANGLE
     (16#025B7#, 16#025B7#),  -- (Sm)  WHITE RIGHT-POINTING TRIANGLE .. WHITE RIGHT-POINTING TRIANGLE
     (16#025B8#, 16#025C0#),  -- (So)  BLACK RIGHT-POINTING SMALL TRIANGLE .. BLACK LEFT-POINTING TRIANGLE
     (16#025C1#, 16#025C1#),  -- (Sm)  WHITE LEFT-POINTING TRIANGLE .. WHITE LEFT-POINTING TRIANGLE
     (16#025C2#, 16#025F7#),  -- (So)  BLACK LEFT-POINTING SMALL TRIANGLE .. WHITE CIRCLE WITH UPPER RIGHT QUADRANT
     (16#025F8#, 16#025FF#),  -- (Sm)  UPPER LEFT TRIANGLE .. LOWER RIGHT TRIANGLE
     (16#02600#, 16#02617#),  -- (So)  BLACK SUN WITH RAYS .. BLACK SHOGI PIECE
     (16#02619#, 16#0266E#),  -- (So)  REVERSED ROTATED FLORAL HEART BULLET .. MUSIC NATURAL SIGN
     (16#0266F#, 16#0266F#),  -- (Sm)  MUSIC SHARP SIGN .. MUSIC SHARP SIGN
     (16#02670#, 16#0267D#),  -- (So)  WEST SYRIAC CROSS .. PARTIALLY-RECYCLED PAPER SYMBOL
     (16#02680#, 16#02691#),  -- (So)  DIE FACE-1 .. BLACK FLAG
     (16#026A0#, 16#026A1#),  -- (So)  WARNING SIGN .. HIGH VOLTAGE SIGN
     (16#02701#, 16#02704#),  -- (So)  UPPER BLADE SCISSORS .. WHITE SCISSORS
     (16#02706#, 16#02709#),  -- (So)  TELEPHONE LOCATION SIGN .. ENVELOPE
     (16#0270C#, 16#02727#),  -- (So)  VICTORY HAND .. WHITE FOUR POINTED STAR
     (16#02729#, 16#0274B#),  -- (So)  STRESS OUTLINED WHITE STAR .. HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
     (16#0274D#, 16#0274D#),  -- (So)  SHADOWED WHITE CIRCLE .. SHADOWED WHITE CIRCLE
     (16#0274F#, 16#02752#),  -- (So)  LOWER RIGHT DROP-SHADOWED WHITE SQUARE .. UPPER RIGHT SHADOWED WHITE SQUARE
     (16#02756#, 16#02756#),  -- (So)  BLACK DIAMOND MINUS WHITE X .. BLACK DIAMOND MINUS WHITE X
     (16#02758#, 16#0275E#),  -- (So)  LIGHT VERTICAL BAR .. HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT
     (16#02761#, 16#02767#),  -- (So)  CURVED STEM PARAGRAPH SIGN ORNAMENT .. ROTATED FLORAL HEART BULLET
     (16#02768#, 16#02768#),  -- (Ps)  MEDIUM LEFT PARENTHESIS ORNAMENT .. MEDIUM LEFT PARENTHESIS ORNAMENT
     (16#02769#, 16#02769#),  -- (Pe)  MEDIUM RIGHT PARENTHESIS ORNAMENT .. MEDIUM RIGHT PARENTHESIS ORNAMENT
     (16#0276A#, 16#0276A#),  -- (Ps)  MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT .. MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
     (16#0276B#, 16#0276B#),  -- (Pe)  MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT .. MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
     (16#0276C#, 16#0276C#),  -- (Ps)  MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT .. MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
     (16#0276D#, 16#0276D#),  -- (Pe)  MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT .. MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
     (16#0276E#, 16#0276E#),  -- (Ps)  HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT .. HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
     (16#0276F#, 16#0276F#),  -- (Pe)  HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT .. HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
     (16#02770#, 16#02770#),  -- (Ps)  HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT .. HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
     (16#02771#, 16#02771#),  -- (Pe)  HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT .. HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
     (16#02772#, 16#02772#),  -- (Ps)  LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT .. LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
     (16#02773#, 16#02773#),  -- (Pe)  LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT .. LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
     (16#02774#, 16#02774#),  -- (Ps)  MEDIUM LEFT CURLY BRACKET ORNAMENT .. MEDIUM LEFT CURLY BRACKET ORNAMENT
     (16#02775#, 16#02775#),  -- (Pe)  MEDIUM RIGHT CURLY BRACKET ORNAMENT .. MEDIUM RIGHT CURLY BRACKET ORNAMENT
     (16#02776#, 16#02793#),  -- (No)  DINGBAT NEGATIVE CIRCLED DIGIT ONE .. DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN
     (16#02794#, 16#02794#),  -- (So)  HEAVY WIDE-HEADED RIGHTWARDS ARROW .. HEAVY WIDE-HEADED RIGHTWARDS ARROW
     (16#02798#, 16#027AF#),  -- (So)  HEAVY SOUTH EAST ARROW .. NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
     (16#027B1#, 16#027BE#),  -- (So)  NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW .. OPEN-OUTLINED RIGHTWARDS ARROW
     (16#027D0#, 16#027E5#),  -- (Sm)  WHITE DIAMOND WITH CENTRED DOT .. WHITE SQUARE WITH RIGHTWARDS TICK
     (16#027E6#, 16#027E6#),  -- (Ps)  MATHEMATICAL LEFT WHITE SQUARE BRACKET .. MATHEMATICAL LEFT WHITE SQUARE BRACKET
     (16#027E7#, 16#027E7#),  -- (Pe)  MATHEMATICAL RIGHT WHITE SQUARE BRACKET .. MATHEMATICAL RIGHT WHITE SQUARE BRACKET
     (16#027E8#, 16#027E8#),  -- (Ps)  MATHEMATICAL LEFT ANGLE BRACKET .. MATHEMATICAL LEFT ANGLE BRACKET
     (16#027E9#, 16#027E9#),  -- (Pe)  MATHEMATICAL RIGHT ANGLE BRACKET .. MATHEMATICAL RIGHT ANGLE BRACKET
     (16#027EA#, 16#027EA#),  -- (Ps)  MATHEMATICAL LEFT DOUBLE ANGLE BRACKET .. MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
     (16#027EB#, 16#027EB#),  -- (Pe)  MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET .. MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
     (16#027F0#, 16#027FF#),  -- (Sm)  UPWARDS QUADRUPLE ARROW .. LONG RIGHTWARDS SQUIGGLE ARROW
     (16#02800#, 16#028FF#),  -- (So)  BRAILLE PATTERN BLANK .. BRAILLE PATTERN DOTS-12345678
     (16#02900#, 16#02982#),  -- (Sm)  RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE .. Z NOTATION TYPE COLON
     (16#02983#, 16#02983#),  -- (Ps)  LEFT WHITE CURLY BRACKET .. LEFT WHITE CURLY BRACKET
     (16#02984#, 16#02984#),  -- (Pe)  RIGHT WHITE CURLY BRACKET .. RIGHT WHITE CURLY BRACKET
     (16#02985#, 16#02985#),  -- (Ps)  LEFT WHITE PARENTHESIS .. LEFT WHITE PARENTHESIS
     (16#02986#, 16#02986#),  -- (Pe)  RIGHT WHITE PARENTHESIS .. RIGHT WHITE PARENTHESIS
     (16#02987#, 16#02987#),  -- (Ps)  Z NOTATION LEFT IMAGE BRACKET .. Z NOTATION LEFT IMAGE BRACKET
     (16#02988#, 16#02988#),  -- (Pe)  Z NOTATION RIGHT IMAGE BRACKET .. Z NOTATION RIGHT IMAGE BRACKET
     (16#02989#, 16#02989#),  -- (Ps)  Z NOTATION LEFT BINDING BRACKET .. Z NOTATION LEFT BINDING BRACKET
     (16#0298A#, 16#0298A#),  -- (Pe)  Z NOTATION RIGHT BINDING BRACKET .. Z NOTATION RIGHT BINDING BRACKET
     (16#0298B#, 16#0298B#),  -- (Ps)  LEFT SQUARE BRACKET WITH UNDERBAR .. LEFT SQUARE BRACKET WITH UNDERBAR
     (16#0298C#, 16#0298C#),  -- (Pe)  RIGHT SQUARE BRACKET WITH UNDERBAR .. RIGHT SQUARE BRACKET WITH UNDERBAR
     (16#0298D#, 16#0298D#),  -- (Ps)  LEFT SQUARE BRACKET WITH TICK IN TOP CORNER .. LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
     (16#0298E#, 16#0298E#),  -- (Pe)  RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER .. RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
     (16#0298F#, 16#0298F#),  -- (Ps)  LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER .. LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
     (16#02990#, 16#02990#),  -- (Pe)  RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER .. RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
     (16#02991#, 16#02991#),  -- (Ps)  LEFT ANGLE BRACKET WITH DOT .. LEFT ANGLE BRACKET WITH DOT
     (16#02992#, 16#02992#),  -- (Pe)  RIGHT ANGLE BRACKET WITH DOT .. RIGHT ANGLE BRACKET WITH DOT
     (16#02993#, 16#02993#),  -- (Ps)  LEFT ARC LESS-THAN BRACKET .. LEFT ARC LESS-THAN BRACKET
     (16#02994#, 16#02994#),  -- (Pe)  RIGHT ARC GREATER-THAN BRACKET .. RIGHT ARC GREATER-THAN BRACKET
     (16#02995#, 16#02995#),  -- (Ps)  DOUBLE LEFT ARC GREATER-THAN BRACKET .. DOUBLE LEFT ARC GREATER-THAN BRACKET
     (16#02996#, 16#02996#),  -- (Pe)  DOUBLE RIGHT ARC LESS-THAN BRACKET .. DOUBLE RIGHT ARC LESS-THAN BRACKET
     (16#02997#, 16#02997#),  -- (Ps)  LEFT BLACK TORTOISE SHELL BRACKET .. LEFT BLACK TORTOISE SHELL BRACKET
     (16#02998#, 16#02998#),  -- (Pe)  RIGHT BLACK TORTOISE SHELL BRACKET .. RIGHT BLACK TORTOISE SHELL BRACKET
     (16#02999#, 16#029D7#),  -- (Sm)  DOTTED FENCE .. BLACK HOURGLASS
     (16#029D8#, 16#029D8#),  -- (Ps)  LEFT WIGGLY FENCE .. LEFT WIGGLY FENCE
     (16#029D9#, 16#029D9#),  -- (Pe)  RIGHT WIGGLY FENCE .. RIGHT WIGGLY FENCE
     (16#029DA#, 16#029DA#),  -- (Ps)  LEFT DOUBLE WIGGLY FENCE .. LEFT DOUBLE WIGGLY FENCE
     (16#029DB#, 16#029DB#),  -- (Pe)  RIGHT DOUBLE WIGGLY FENCE .. RIGHT DOUBLE WIGGLY FENCE
     (16#029DC#, 16#029FB#),  -- (Sm)  INCOMPLETE INFINITY .. TRIPLE PLUS
     (16#029FC#, 16#029FC#),  -- (Ps)  LEFT-POINTING CURVED ANGLE BRACKET .. LEFT-POINTING CURVED ANGLE BRACKET
     (16#029FD#, 16#029FD#),  -- (Pe)  RIGHT-POINTING CURVED ANGLE BRACKET .. RIGHT-POINTING CURVED ANGLE BRACKET
     (16#029FE#, 16#02AFF#),  -- (Sm)  TINY .. N-ARY WHITE VERTICAL BAR
     (16#02B00#, 16#02B0D#),  -- (So)  NORTH EAST WHITE ARROW .. UP DOWN BLACK ARROW
     (16#02E80#, 16#02E99#),  -- (So)  CJK RADICAL REPEAT .. CJK RADICAL RAP
     (16#02E9B#, 16#02EF3#),  -- (So)  CJK RADICAL CHOKE .. CJK RADICAL C-SIMPLIFIED TURTLE
     (16#02F00#, 16#02FD5#),  -- (So)  KANGXI RADICAL ONE .. KANGXI RADICAL FLUTE
     (16#02FF0#, 16#02FFB#),  -- (So)  IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT .. IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID
     (16#03000#, 16#03000#),  -- (Zs)  IDEOGRAPHIC SPACE .. IDEOGRAPHIC SPACE
     (16#03001#, 16#03003#),  -- (Po)  IDEOGRAPHIC COMMA .. DITTO MARK
     (16#03004#, 16#03004#),  -- (So)  JAPANESE INDUSTRIAL STANDARD SYMBOL .. JAPANESE INDUSTRIAL STANDARD SYMBOL
     (16#03005#, 16#03005#),  -- (Lm)  IDEOGRAPHIC ITERATION MARK .. IDEOGRAPHIC ITERATION MARK
     (16#03006#, 16#03006#),  -- (Lo)  IDEOGRAPHIC CLOSING MARK .. IDEOGRAPHIC CLOSING MARK
     (16#03007#, 16#03007#),  -- (Nl)  IDEOGRAPHIC NUMBER ZERO .. IDEOGRAPHIC NUMBER ZERO
     (16#03008#, 16#03008#),  -- (Ps)  LEFT ANGLE BRACKET .. LEFT ANGLE BRACKET
     (16#03009#, 16#03009#),  -- (Pe)  RIGHT ANGLE BRACKET .. RIGHT ANGLE BRACKET
     (16#0300A#, 16#0300A#),  -- (Ps)  LEFT DOUBLE ANGLE BRACKET .. LEFT DOUBLE ANGLE BRACKET
     (16#0300B#, 16#0300B#),  -- (Pe)  RIGHT DOUBLE ANGLE BRACKET .. RIGHT DOUBLE ANGLE BRACKET
     (16#0300C#, 16#0300C#),  -- (Ps)  LEFT CORNER BRACKET .. LEFT CORNER BRACKET
     (16#0300D#, 16#0300D#),  -- (Pe)  RIGHT CORNER BRACKET .. RIGHT CORNER BRACKET
     (16#0300E#, 16#0300E#),  -- (Ps)  LEFT WHITE CORNER BRACKET .. LEFT WHITE CORNER BRACKET
     (16#0300F#, 16#0300F#),  -- (Pe)  RIGHT WHITE CORNER BRACKET .. RIGHT WHITE CORNER BRACKET
     (16#03010#, 16#03010#),  -- (Ps)  LEFT BLACK LENTICULAR BRACKET .. LEFT BLACK LENTICULAR BRACKET
     (16#03011#, 16#03011#),  -- (Pe)  RIGHT BLACK LENTICULAR BRACKET .. RIGHT BLACK LENTICULAR BRACKET
     (16#03012#, 16#03013#),  -- (So)  POSTAL MARK .. GETA MARK
     (16#03014#, 16#03014#),  -- (Ps)  LEFT TORTOISE SHELL BRACKET .. LEFT TORTOISE SHELL BRACKET
     (16#03015#, 16#03015#),  -- (Pe)  RIGHT TORTOISE SHELL BRACKET .. RIGHT TORTOISE SHELL BRACKET
     (16#03016#, 16#03016#),  -- (Ps)  LEFT WHITE LENTICULAR BRACKET .. LEFT WHITE LENTICULAR BRACKET
     (16#03017#, 16#03017#),  -- (Pe)  RIGHT WHITE LENTICULAR BRACKET .. RIGHT WHITE LENTICULAR BRACKET
     (16#03018#, 16#03018#),  -- (Ps)  LEFT WHITE TORTOISE SHELL BRACKET .. LEFT WHITE TORTOISE SHELL BRACKET
     (16#03019#, 16#03019#),  -- (Pe)  RIGHT WHITE TORTOISE SHELL BRACKET .. RIGHT WHITE TORTOISE SHELL BRACKET
     (16#0301A#, 16#0301A#),  -- (Ps)  LEFT WHITE SQUARE BRACKET .. LEFT WHITE SQUARE BRACKET
     (16#0301B#, 16#0301B#),  -- (Pe)  RIGHT WHITE SQUARE BRACKET .. RIGHT WHITE SQUARE BRACKET
     (16#0301C#, 16#0301C#),  -- (Pd)  WAVE DASH .. WAVE DASH
     (16#0301D#, 16#0301D#),  -- (Ps)  REVERSED DOUBLE PRIME QUOTATION MARK .. REVERSED DOUBLE PRIME QUOTATION MARK
     (16#0301E#, 16#0301F#),  -- (Pe)  DOUBLE PRIME QUOTATION MARK .. LOW DOUBLE PRIME QUOTATION MARK
     (16#03020#, 16#03020#),  -- (So)  POSTAL MARK FACE .. POSTAL MARK FACE
     (16#03021#, 16#03029#),  -- (Nl)  HANGZHOU NUMERAL ONE .. HANGZHOU NUMERAL NINE
     (16#0302A#, 16#0302F#),  -- (Mn)  IDEOGRAPHIC LEVEL TONE MARK .. HANGUL DOUBLE DOT TONE MARK
     (16#03030#, 16#03030#),  -- (Pd)  WAVY DASH .. WAVY DASH
     (16#03031#, 16#03035#),  -- (Lm)  VERTICAL KANA REPEAT MARK .. VERTICAL KANA REPEAT MARK LOWER HALF
     (16#03036#, 16#03037#),  -- (So)  CIRCLED POSTAL MARK .. IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL
     (16#03038#, 16#0303A#),  -- (Nl)  HANGZHOU NUMERAL TEN .. HANGZHOU NUMERAL THIRTY
     (16#0303B#, 16#0303B#),  -- (Lm)  VERTICAL IDEOGRAPHIC ITERATION MARK .. VERTICAL IDEOGRAPHIC ITERATION MARK
     (16#0303C#, 16#0303C#),  -- (Lo)  MASU MARK .. MASU MARK
     (16#0303D#, 16#0303D#),  -- (Po)  PART ALTERNATION MARK .. PART ALTERNATION MARK
     (16#0303E#, 16#0303F#),  -- (So)  IDEOGRAPHIC VARIATION INDICATOR .. IDEOGRAPHIC HALF FILL SPACE
     (16#03041#, 16#03096#),  -- (Lo)  HIRAGANA LETTER SMALL A .. HIRAGANA LETTER SMALL KE
     (16#03099#, 16#0309A#),  -- (Mn)  COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK .. COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
     (16#0309B#, 16#0309C#),  -- (Sk)  KATAKANA-HIRAGANA VOICED SOUND MARK .. KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
     (16#0309D#, 16#0309E#),  -- (Lm)  HIRAGANA ITERATION MARK .. HIRAGANA VOICED ITERATION MARK
     (16#0309F#, 16#0309F#),  -- (Lo)  HIRAGANA DIGRAPH YORI .. HIRAGANA DIGRAPH YORI
     (16#030A0#, 16#030A0#),  -- (Pd)  KATAKANA-HIRAGANA DOUBLE HYPHEN .. KATAKANA-HIRAGANA DOUBLE HYPHEN
     (16#030A1#, 16#030FA#),  -- (Lo)  KATAKANA LETTER SMALL A .. KATAKANA LETTER VO
     (16#030FB#, 16#030FB#),  -- (Pc)  KATAKANA MIDDLE DOT .. KATAKANA MIDDLE DOT
     (16#030FC#, 16#030FE#),  -- (Lm)  KATAKANA-HIRAGANA PROLONGED SOUND MARK .. KATAKANA VOICED ITERATION MARK
     (16#030FF#, 16#030FF#),  -- (Lo)  KATAKANA DIGRAPH KOTO .. KATAKANA DIGRAPH KOTO
     (16#03105#, 16#0312C#),  -- (Lo)  BOPOMOFO LETTER B .. BOPOMOFO LETTER GN
     (16#03131#, 16#0318E#),  -- (Lo)  HANGUL LETTER KIYEOK .. HANGUL LETTER ARAEAE
     (16#03190#, 16#03191#),  -- (So)  IDEOGRAPHIC ANNOTATION LINKING MARK .. IDEOGRAPHIC ANNOTATION REVERSE MARK
     (16#03192#, 16#03195#),  -- (No)  IDEOGRAPHIC ANNOTATION ONE MARK .. IDEOGRAPHIC ANNOTATION FOUR MARK
     (16#03196#, 16#0319F#),  -- (So)  IDEOGRAPHIC ANNOTATION TOP MARK .. IDEOGRAPHIC ANNOTATION MAN MARK
     (16#031A0#, 16#031B7#),  -- (Lo)  BOPOMOFO LETTER BU .. BOPOMOFO FINAL LETTER H
     (16#031F0#, 16#031FF#),  -- (Lo)  KATAKANA LETTER SMALL KU .. KATAKANA LETTER SMALL RO
     (16#03200#, 16#0321E#),  -- (So)  PARENTHESIZED HANGUL KIYEOK .. PARENTHESIZED KOREAN CHARACTER O HU
     (16#03220#, 16#03229#),  -- (No)  PARENTHESIZED IDEOGRAPH ONE .. PARENTHESIZED IDEOGRAPH TEN
     (16#0322A#, 16#03243#),  -- (So)  PARENTHESIZED IDEOGRAPH MOON .. PARENTHESIZED IDEOGRAPH REACH
     (16#03250#, 16#03250#),  -- (So)  PARTNERSHIP SIGN .. PARTNERSHIP SIGN
     (16#03251#, 16#0325F#),  -- (No)  CIRCLED NUMBER TWENTY ONE .. CIRCLED NUMBER THIRTY FIVE
     (16#03260#, 16#0327D#),  -- (So)  CIRCLED HANGUL KIYEOK .. CIRCLED KOREAN CHARACTER JUEUI
     (16#0327F#, 16#0327F#),  -- (So)  KOREAN STANDARD SYMBOL .. KOREAN STANDARD SYMBOL
     (16#03280#, 16#03289#),  -- (No)  CIRCLED IDEOGRAPH ONE .. CIRCLED IDEOGRAPH TEN
     (16#0328A#, 16#032B0#),  -- (So)  CIRCLED IDEOGRAPH MOON .. CIRCLED IDEOGRAPH NIGHT
     (16#032B1#, 16#032BF#),  -- (No)  CIRCLED NUMBER THIRTY SIX .. CIRCLED NUMBER FIFTY
     (16#032C0#, 16#032FE#),  -- (So)  IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY .. CIRCLED KATAKANA WO
     (16#03300#, 16#033FF#),  -- (So)  SQUARE APAATO .. SQUARE GAL
     (16#03400#, 16#04DB5#),  -- (Lo)  <CJK Ideograph Extension A, First> .. <CJK Ideograph Extension A, Last>
     (16#04DC0#, 16#04DFF#),  -- (So)  HEXAGRAM FOR THE CREATIVE HEAVEN .. HEXAGRAM FOR BEFORE COMPLETION
     (16#04E00#, 16#09FA5#),  -- (Lo)  <CJK Ideograph, First> .. <CJK Ideograph, Last>
     (16#0A000#, 16#0A48C#),  -- (Lo)  YI SYLLABLE IT .. YI SYLLABLE YYR
     (16#0A490#, 16#0A4C6#),  -- (So)  YI RADICAL QOT .. YI RADICAL KE
     (16#0AC00#, 16#0D7A3#),  -- (Lo)  <Hangul Syllable, First> .. <Hangul Syllable, Last>
     (16#0D800#, 16#0F8FF#),  -- (Cs)  <Non Private Use High Surrogate, First> .. <Private Use, Last>
     (16#0F900#, 16#0FA2D#),  -- (Lo)  CJK COMPATIBILITY IDEOGRAPH-F900 .. CJK COMPATIBILITY IDEOGRAPH-FA2D
     (16#0FA30#, 16#0FA6A#),  -- (Lo)  CJK COMPATIBILITY IDEOGRAPH-FA30 .. CJK COMPATIBILITY IDEOGRAPH-FA6A
     (16#0FB00#, 16#0FB06#),  -- (Ll)  LATIN SMALL LIGATURE FF .. LATIN SMALL LIGATURE ST
     (16#0FB13#, 16#0FB17#),  -- (Ll)  ARMENIAN SMALL LIGATURE MEN NOW .. ARMENIAN SMALL LIGATURE MEN XEH
     (16#0FB1D#, 16#0FB1D#),  -- (Lo)  HEBREW LETTER YOD WITH HIRIQ .. HEBREW LETTER YOD WITH HIRIQ
     (16#0FB1E#, 16#0FB1E#),  -- (Mn)  HEBREW POINT JUDEO-SPANISH VARIKA .. HEBREW POINT JUDEO-SPANISH VARIKA
     (16#0FB1F#, 16#0FB28#),  -- (Lo)  HEBREW LIGATURE YIDDISH YOD YOD PATAH .. HEBREW LETTER WIDE TAV
     (16#0FB29#, 16#0FB29#),  -- (Sm)  HEBREW LETTER ALTERNATIVE PLUS SIGN .. HEBREW LETTER ALTERNATIVE PLUS SIGN
     (16#0FB2A#, 16#0FB36#),  -- (Lo)  HEBREW LETTER SHIN WITH SHIN DOT .. HEBREW LETTER ZAYIN WITH DAGESH
     (16#0FB38#, 16#0FB3C#),  -- (Lo)  HEBREW LETTER TET WITH DAGESH .. HEBREW LETTER LAMED WITH DAGESH
     (16#0FB3E#, 16#0FB3E#),  -- (Lo)  HEBREW LETTER MEM WITH DAGESH .. HEBREW LETTER MEM WITH DAGESH
     (16#0FB40#, 16#0FB41#),  -- (Lo)  HEBREW LETTER NUN WITH DAGESH .. HEBREW LETTER SAMEKH WITH DAGESH
     (16#0FB43#, 16#0FB44#),  -- (Lo)  HEBREW LETTER FINAL PE WITH DAGESH .. HEBREW LETTER PE WITH DAGESH
     (16#0FB46#, 16#0FBB1#),  -- (Lo)  HEBREW LETTER TSADI WITH DAGESH .. ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
     (16#0FBD3#, 16#0FD3D#),  -- (Lo)  ARABIC LETTER NG ISOLATED FORM .. ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
     (16#0FD3E#, 16#0FD3E#),  -- (Ps)  ORNATE LEFT PARENTHESIS .. ORNATE LEFT PARENTHESIS
     (16#0FD3F#, 16#0FD3F#),  -- (Pe)  ORNATE RIGHT PARENTHESIS .. ORNATE RIGHT PARENTHESIS
     (16#0FD50#, 16#0FD8F#),  -- (Lo)  ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM .. ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
     (16#0FD92#, 16#0FDC7#),  -- (Lo)  ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM .. ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
     (16#0FDF0#, 16#0FDFB#),  -- (Lo)  ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM .. ARABIC LIGATURE JALLAJALALOUHOU
     (16#0FDFC#, 16#0FDFC#),  -- (Sc)  RIAL SIGN .. RIAL SIGN
     (16#0FDFD#, 16#0FDFD#),  -- (So)  ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM .. ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM
     (16#0FE00#, 16#0FE0F#),  -- (Mn)  VARIATION SELECTOR-1 .. VARIATION SELECTOR-16
     (16#0FE20#, 16#0FE23#),  -- (Mn)  COMBINING LIGATURE LEFT HALF .. COMBINING DOUBLE TILDE RIGHT HALF
     (16#0FE30#, 16#0FE30#),  -- (Po)  PRESENTATION FORM FOR VERTICAL TWO DOT LEADER .. PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
     (16#0FE31#, 16#0FE32#),  -- (Pd)  PRESENTATION FORM FOR VERTICAL EM DASH .. PRESENTATION FORM FOR VERTICAL EN DASH
     (16#0FE33#, 16#0FE34#),  -- (Pc)  PRESENTATION FORM FOR VERTICAL LOW LINE .. PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
     (16#0FE35#, 16#0FE35#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS .. PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
     (16#0FE36#, 16#0FE36#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS .. PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
     (16#0FE37#, 16#0FE37#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
     (16#0FE38#, 16#0FE38#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
     (16#0FE39#, 16#0FE39#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
     (16#0FE3A#, 16#0FE3A#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
     (16#0FE3B#, 16#0FE3B#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
     (16#0FE3C#, 16#0FE3C#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
     (16#0FE3D#, 16#0FE3D#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
     (16#0FE3E#, 16#0FE3E#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
     (16#0FE3F#, 16#0FE3F#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
     (16#0FE40#, 16#0FE40#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
     (16#0FE41#, 16#0FE41#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
     (16#0FE42#, 16#0FE42#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
     (16#0FE43#, 16#0FE43#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
     (16#0FE44#, 16#0FE44#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
     (16#0FE45#, 16#0FE46#),  -- (Po)  SESAME DOT .. WHITE SESAME DOT
     (16#0FE47#, 16#0FE47#),  -- (Ps)  PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
     (16#0FE48#, 16#0FE48#),  -- (Pe)  PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
     (16#0FE49#, 16#0FE4C#),  -- (Po)  DASHED OVERLINE .. DOUBLE WAVY OVERLINE
     (16#0FE4D#, 16#0FE4F#),  -- (Pc)  DASHED LOW LINE .. WAVY LOW LINE
     (16#0FE50#, 16#0FE52#),  -- (Po)  SMALL COMMA .. SMALL FULL STOP
     (16#0FE54#, 16#0FE57#),  -- (Po)  SMALL SEMICOLON .. SMALL EXCLAMATION MARK
     (16#0FE58#, 16#0FE58#),  -- (Pd)  SMALL EM DASH .. SMALL EM DASH
     (16#0FE59#, 16#0FE59#),  -- (Ps)  SMALL LEFT PARENTHESIS .. SMALL LEFT PARENTHESIS
     (16#0FE5A#, 16#0FE5A#),  -- (Pe)  SMALL RIGHT PARENTHESIS .. SMALL RIGHT PARENTHESIS
     (16#0FE5B#, 16#0FE5B#),  -- (Ps)  SMALL LEFT CURLY BRACKET .. SMALL LEFT CURLY BRACKET
     (16#0FE5C#, 16#0FE5C#),  -- (Pe)  SMALL RIGHT CURLY BRACKET .. SMALL RIGHT CURLY BRACKET
     (16#0FE5D#, 16#0FE5D#),  -- (Ps)  SMALL LEFT TORTOISE SHELL BRACKET .. SMALL LEFT TORTOISE SHELL BRACKET
     (16#0FE5E#, 16#0FE5E#),  -- (Pe)  SMALL RIGHT TORTOISE SHELL BRACKET .. SMALL RIGHT TORTOISE SHELL BRACKET
     (16#0FE5F#, 16#0FE61#),  -- (Po)  SMALL NUMBER SIGN .. SMALL ASTERISK
     (16#0FE62#, 16#0FE62#),  -- (Sm)  SMALL PLUS SIGN .. SMALL PLUS SIGN
     (16#0FE63#, 16#0FE63#),  -- (Pd)  SMALL HYPHEN-MINUS .. SMALL HYPHEN-MINUS
     (16#0FE64#, 16#0FE66#),  -- (Sm)  SMALL LESS-THAN SIGN .. SMALL EQUALS SIGN
     (16#0FE68#, 16#0FE68#),  -- (Po)  SMALL REVERSE SOLIDUS .. SMALL REVERSE SOLIDUS
     (16#0FE69#, 16#0FE69#),  -- (Sc)  SMALL DOLLAR SIGN .. SMALL DOLLAR SIGN
     (16#0FE6A#, 16#0FE6B#),  -- (Po)  SMALL PERCENT SIGN .. SMALL COMMERCIAL AT
     (16#0FE70#, 16#0FE74#),  -- (Lo)  ARABIC FATHATAN ISOLATED FORM .. ARABIC KASRATAN ISOLATED FORM
     (16#0FE76#, 16#0FEFC#),  -- (Lo)  ARABIC FATHA ISOLATED FORM .. ARABIC LIGATURE LAM WITH ALEF FINAL FORM
     (16#0FEFF#, 16#0FEFF#),  -- (Cf)  ZERO WIDTH NO-BREAK SPACE .. ZERO WIDTH NO-BREAK SPACE
     (16#0FF01#, 16#0FF03#),  -- (Po)  FULLWIDTH EXCLAMATION MARK .. FULLWIDTH NUMBER SIGN
     (16#0FF04#, 16#0FF04#),  -- (Sc)  FULLWIDTH DOLLAR SIGN .. FULLWIDTH DOLLAR SIGN
     (16#0FF05#, 16#0FF07#),  -- (Po)  FULLWIDTH PERCENT SIGN .. FULLWIDTH APOSTROPHE
     (16#0FF08#, 16#0FF08#),  -- (Ps)  FULLWIDTH LEFT PARENTHESIS .. FULLWIDTH LEFT PARENTHESIS
     (16#0FF09#, 16#0FF09#),  -- (Pe)  FULLWIDTH RIGHT PARENTHESIS .. FULLWIDTH RIGHT PARENTHESIS
     (16#0FF0A#, 16#0FF0A#),  -- (Po)  FULLWIDTH ASTERISK .. FULLWIDTH ASTERISK
     (16#0FF0B#, 16#0FF0B#),  -- (Sm)  FULLWIDTH PLUS SIGN .. FULLWIDTH PLUS SIGN
     (16#0FF0C#, 16#0FF0C#),  -- (Po)  FULLWIDTH COMMA .. FULLWIDTH COMMA
     (16#0FF0D#, 16#0FF0D#),  -- (Pd)  FULLWIDTH HYPHEN-MINUS .. FULLWIDTH HYPHEN-MINUS
     (16#0FF0E#, 16#0FF0F#),  -- (Po)  FULLWIDTH FULL STOP .. FULLWIDTH SOLIDUS
     (16#0FF10#, 16#0FF19#),  -- (Nd)  FULLWIDTH DIGIT ZERO .. FULLWIDTH DIGIT NINE
     (16#0FF1A#, 16#0FF1B#),  -- (Po)  FULLWIDTH COLON .. FULLWIDTH SEMICOLON
     (16#0FF1C#, 16#0FF1E#),  -- (Sm)  FULLWIDTH LESS-THAN SIGN .. FULLWIDTH GREATER-THAN SIGN
     (16#0FF1F#, 16#0FF20#),  -- (Po)  FULLWIDTH QUESTION MARK .. FULLWIDTH COMMERCIAL AT
     (16#0FF21#, 16#0FF3A#),  -- (Lu)  FULLWIDTH LATIN CAPITAL LETTER A .. FULLWIDTH LATIN CAPITAL LETTER Z
     (16#0FF3B#, 16#0FF3B#),  -- (Ps)  FULLWIDTH LEFT SQUARE BRACKET .. FULLWIDTH LEFT SQUARE BRACKET
     (16#0FF3C#, 16#0FF3C#),  -- (Po)  FULLWIDTH REVERSE SOLIDUS .. FULLWIDTH REVERSE SOLIDUS
     (16#0FF3D#, 16#0FF3D#),  -- (Pe)  FULLWIDTH RIGHT SQUARE BRACKET .. FULLWIDTH RIGHT SQUARE BRACKET
     (16#0FF3E#, 16#0FF3E#),  -- (Sk)  FULLWIDTH CIRCUMFLEX ACCENT .. FULLWIDTH CIRCUMFLEX ACCENT
     (16#0FF3F#, 16#0FF3F#),  -- (Pc)  FULLWIDTH LOW LINE .. FULLWIDTH LOW LINE
     (16#0FF40#, 16#0FF40#),  -- (Sk)  FULLWIDTH GRAVE ACCENT .. FULLWIDTH GRAVE ACCENT
     (16#0FF41#, 16#0FF5A#),  -- (Ll)  FULLWIDTH LATIN SMALL LETTER A .. FULLWIDTH LATIN SMALL LETTER Z
     (16#0FF5B#, 16#0FF5B#),  -- (Ps)  FULLWIDTH LEFT CURLY BRACKET .. FULLWIDTH LEFT CURLY BRACKET
     (16#0FF5C#, 16#0FF5C#),  -- (Sm)  FULLWIDTH VERTICAL LINE .. FULLWIDTH VERTICAL LINE
     (16#0FF5D#, 16#0FF5D#),  -- (Pe)  FULLWIDTH RIGHT CURLY BRACKET .. FULLWIDTH RIGHT CURLY BRACKET
     (16#0FF5E#, 16#0FF5E#),  -- (Sm)  FULLWIDTH TILDE .. FULLWIDTH TILDE
     (16#0FF5F#, 16#0FF5F#),  -- (Ps)  FULLWIDTH LEFT WHITE PARENTHESIS .. FULLWIDTH LEFT WHITE PARENTHESIS
     (16#0FF60#, 16#0FF60#),  -- (Pe)  FULLWIDTH RIGHT WHITE PARENTHESIS .. FULLWIDTH RIGHT WHITE PARENTHESIS
     (16#0FF61#, 16#0FF61#),  -- (Po)  HALFWIDTH IDEOGRAPHIC FULL STOP .. HALFWIDTH IDEOGRAPHIC FULL STOP
     (16#0FF62#, 16#0FF62#),  -- (Ps)  HALFWIDTH LEFT CORNER BRACKET .. HALFWIDTH LEFT CORNER BRACKET
     (16#0FF63#, 16#0FF63#),  -- (Pe)  HALFWIDTH RIGHT CORNER BRACKET .. HALFWIDTH RIGHT CORNER BRACKET
     (16#0FF64#, 16#0FF64#),  -- (Po)  HALFWIDTH IDEOGRAPHIC COMMA .. HALFWIDTH IDEOGRAPHIC COMMA
     (16#0FF65#, 16#0FF65#),  -- (Pc)  HALFWIDTH KATAKANA MIDDLE DOT .. HALFWIDTH KATAKANA MIDDLE DOT
     (16#0FF66#, 16#0FF6F#),  -- (Lo)  HALFWIDTH KATAKANA LETTER WO .. HALFWIDTH KATAKANA LETTER SMALL TU
     (16#0FF70#, 16#0FF70#),  -- (Lm)  HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK .. HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
     (16#0FF71#, 16#0FF9D#),  -- (Lo)  HALFWIDTH KATAKANA LETTER A .. HALFWIDTH KATAKANA LETTER N
     (16#0FF9E#, 16#0FF9F#),  -- (Lm)  HALFWIDTH KATAKANA VOICED SOUND MARK .. HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
     (16#0FFA0#, 16#0FFBE#),  -- (Lo)  HALFWIDTH HANGUL FILLER .. HALFWIDTH HANGUL LETTER HIEUH
     (16#0FFC2#, 16#0FFC7#),  -- (Lo)  HALFWIDTH HANGUL LETTER A .. HALFWIDTH HANGUL LETTER E
     (16#0FFCA#, 16#0FFCF#),  -- (Lo)  HALFWIDTH HANGUL LETTER YEO .. HALFWIDTH HANGUL LETTER OE
     (16#0FFD2#, 16#0FFD7#),  -- (Lo)  HALFWIDTH HANGUL LETTER YO .. HALFWIDTH HANGUL LETTER YU
     (16#0FFDA#, 16#0FFDC#),  -- (Lo)  HALFWIDTH HANGUL LETTER EU .. HALFWIDTH HANGUL LETTER I
     (16#0FFE0#, 16#0FFE1#),  -- (Sc)  FULLWIDTH CENT SIGN .. FULLWIDTH POUND SIGN
     (16#0FFE2#, 16#0FFE2#),  -- (Sm)  FULLWIDTH NOT SIGN .. FULLWIDTH NOT SIGN
     (16#0FFE3#, 16#0FFE3#),  -- (Sk)  FULLWIDTH MACRON .. FULLWIDTH MACRON
     (16#0FFE4#, 16#0FFE4#),  -- (So)  FULLWIDTH BROKEN BAR .. FULLWIDTH BROKEN BAR
     (16#0FFE5#, 16#0FFE6#),  -- (Sc)  FULLWIDTH YEN SIGN .. FULLWIDTH WON SIGN
     (16#0FFE8#, 16#0FFE8#),  -- (So)  HALFWIDTH FORMS LIGHT VERTICAL .. HALFWIDTH FORMS LIGHT VERTICAL
     (16#0FFE9#, 16#0FFEC#),  -- (Sm)  HALFWIDTH LEFTWARDS ARROW .. HALFWIDTH DOWNWARDS ARROW
     (16#0FFED#, 16#0FFEE#),  -- (So)  HALFWIDTH BLACK SQUARE .. HALFWIDTH WHITE CIRCLE
     (16#0FFF9#, 16#0FFFB#),  -- (Cf)  INTERLINEAR ANNOTATION ANCHOR .. INTERLINEAR ANNOTATION TERMINATOR
     (16#0FFFC#, 16#0FFFD#),  -- (So)  OBJECT REPLACEMENT CHARACTER .. REPLACEMENT CHARACTER
     (16#10000#, 16#1000B#),  -- (Lo)  LINEAR B SYLLABLE B008 A .. LINEAR B SYLLABLE B046 JE
     (16#1000D#, 16#10026#),  -- (Lo)  LINEAR B SYLLABLE B036 JO .. LINEAR B SYLLABLE B032 QO
     (16#10028#, 16#1003A#),  -- (Lo)  LINEAR B SYLLABLE B060 RA .. LINEAR B SYLLABLE B042 WO
     (16#1003C#, 16#1003D#),  -- (Lo)  LINEAR B SYLLABLE B017 ZA .. LINEAR B SYLLABLE B074 ZE
     (16#1003F#, 16#1004D#),  -- (Lo)  LINEAR B SYLLABLE B020 ZO .. LINEAR B SYLLABLE B091 TWO
     (16#10050#, 16#1005D#),  -- (Lo)  LINEAR B SYMBOL B018 .. LINEAR B SYMBOL B089
     (16#10080#, 16#100FA#),  -- (Lo)  LINEAR B IDEOGRAM B100 MAN .. LINEAR B IDEOGRAM VESSEL B305
     (16#10100#, 16#10101#),  -- (Po)  AEGEAN WORD SEPARATOR LINE .. AEGEAN WORD SEPARATOR DOT
     (16#10102#, 16#10102#),  -- (So)  AEGEAN CHECK MARK .. AEGEAN CHECK MARK
     (16#10107#, 16#10133#),  -- (No)  AEGEAN NUMBER ONE .. AEGEAN NUMBER NINETY THOUSAND
     (16#10137#, 16#1013F#),  -- (So)  AEGEAN WEIGHT BASE UNIT .. AEGEAN MEASURE THIRD SUBUNIT
     (16#10300#, 16#1031E#),  -- (Lo)  OLD ITALIC LETTER A .. OLD ITALIC LETTER UU
     (16#10320#, 16#10323#),  -- (No)  OLD ITALIC NUMERAL ONE .. OLD ITALIC NUMERAL FIFTY
     (16#10330#, 16#10349#),  -- (Lo)  GOTHIC LETTER AHSA .. GOTHIC LETTER OTHAL
     (16#1034A#, 16#1034A#),  -- (Nl)  GOTHIC LETTER NINE HUNDRED .. GOTHIC LETTER NINE HUNDRED
     (16#10380#, 16#1039D#),  -- (Lo)  UGARITIC LETTER ALPA .. UGARITIC LETTER SSU
     (16#1039F#, 16#1039F#),  -- (Po)  UGARITIC WORD DIVIDER .. UGARITIC WORD DIVIDER
     (16#10400#, 16#10427#),  -- (Lu)  DESERET CAPITAL LETTER LONG I .. DESERET CAPITAL LETTER EW
     (16#10428#, 16#1044F#),  -- (Ll)  DESERET SMALL LETTER LONG I .. DESERET SMALL LETTER EW
     (16#10450#, 16#1049D#),  -- (Lo)  SHAVIAN LETTER PEEP .. OSMANYA LETTER OO
     (16#104A0#, 16#104A9#),  -- (Nd)  OSMANYA DIGIT ZERO .. OSMANYA DIGIT NINE
     (16#10800#, 16#10805#),  -- (Lo)  CYPRIOT SYLLABLE A .. CYPRIOT SYLLABLE JA
     (16#10808#, 16#10808#),  -- (Lo)  CYPRIOT SYLLABLE JO .. CYPRIOT SYLLABLE JO
     (16#1080A#, 16#10835#),  -- (Lo)  CYPRIOT SYLLABLE KA .. CYPRIOT SYLLABLE WO
     (16#10837#, 16#10838#),  -- (Lo)  CYPRIOT SYLLABLE XA .. CYPRIOT SYLLABLE XE
     (16#1083C#, 16#1083C#),  -- (Lo)  CYPRIOT SYLLABLE ZA .. CYPRIOT SYLLABLE ZA
     (16#1083F#, 16#1083F#),  -- (Lo)  CYPRIOT SYLLABLE ZO .. CYPRIOT SYLLABLE ZO
     (16#1D000#, 16#1D0F5#),  -- (So)  BYZANTINE MUSICAL SYMBOL PSILI .. BYZANTINE MUSICAL SYMBOL GORGON NEO KATO
     (16#1D100#, 16#1D126#),  -- (So)  MUSICAL SYMBOL SINGLE BARLINE .. MUSICAL SYMBOL DRUM CLEF-2
     (16#1D12A#, 16#1D164#),  -- (So)  MUSICAL SYMBOL DOUBLE SHARP .. MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
     (16#1D165#, 16#1D166#),  -- (Mc)  MUSICAL SYMBOL COMBINING STEM .. MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
     (16#1D167#, 16#1D169#),  -- (Mn)  MUSICAL SYMBOL COMBINING TREMOLO-1 .. MUSICAL SYMBOL COMBINING TREMOLO-3
     (16#1D16A#, 16#1D16C#),  -- (So)  MUSICAL SYMBOL FINGERED TREMOLO-1 .. MUSICAL SYMBOL FINGERED TREMOLO-3
     (16#1D16D#, 16#1D172#),  -- (Mc)  MUSICAL SYMBOL COMBINING AUGMENTATION DOT .. MUSICAL SYMBOL COMBINING FLAG-5
     (16#1D173#, 16#1D17A#),  -- (Cf)  MUSICAL SYMBOL BEGIN BEAM .. MUSICAL SYMBOL END PHRASE
     (16#1D17B#, 16#1D182#),  -- (Mn)  MUSICAL SYMBOL COMBINING ACCENT .. MUSICAL SYMBOL COMBINING LOURE
     (16#1D183#, 16#1D184#),  -- (So)  MUSICAL SYMBOL ARPEGGIATO UP .. MUSICAL SYMBOL ARPEGGIATO DOWN
     (16#1D185#, 16#1D18B#),  -- (Mn)  MUSICAL SYMBOL COMBINING DOIT .. MUSICAL SYMBOL COMBINING TRIPLE TONGUE
     (16#1D18C#, 16#1D1A9#),  -- (So)  MUSICAL SYMBOL RINFORZANDO .. MUSICAL SYMBOL DEGREE SLASH
     (16#1D1AA#, 16#1D1AD#),  -- (Mn)  MUSICAL SYMBOL COMBINING DOWN BOW .. MUSICAL SYMBOL COMBINING SNAP PIZZICATO
     (16#1D1AE#, 16#1D1DD#),  -- (So)  MUSICAL SYMBOL PEDAL MARK .. MUSICAL SYMBOL PES SUBPUNCTIS
     (16#1D300#, 16#1D356#),  -- (So)  MONOGRAM FOR EARTH .. TETRAGRAM FOR FOSTERING
     (16#1D400#, 16#1D419#),  -- (Lu)  MATHEMATICAL BOLD CAPITAL A .. MATHEMATICAL BOLD CAPITAL Z
     (16#1D41A#, 16#1D433#),  -- (Ll)  MATHEMATICAL BOLD SMALL A .. MATHEMATICAL BOLD SMALL Z
     (16#1D434#, 16#1D44D#),  -- (Lu)  MATHEMATICAL ITALIC CAPITAL A .. MATHEMATICAL ITALIC CAPITAL Z
     (16#1D44E#, 16#1D454#),  -- (Ll)  MATHEMATICAL ITALIC SMALL A .. MATHEMATICAL ITALIC SMALL G
     (16#1D456#, 16#1D467#),  -- (Ll)  MATHEMATICAL ITALIC SMALL I .. MATHEMATICAL ITALIC SMALL Z
     (16#1D468#, 16#1D481#),  -- (Lu)  MATHEMATICAL BOLD ITALIC CAPITAL A .. MATHEMATICAL BOLD ITALIC CAPITAL Z
     (16#1D482#, 16#1D49B#),  -- (Ll)  MATHEMATICAL BOLD ITALIC SMALL A .. MATHEMATICAL BOLD ITALIC SMALL Z
     (16#1D49C#, 16#1D49C#),  -- (Lu)  MATHEMATICAL SCRIPT CAPITAL A .. MATHEMATICAL SCRIPT CAPITAL A
     (16#1D49E#, 16#1D49F#),  -- (Lu)  MATHEMATICAL SCRIPT CAPITAL C .. MATHEMATICAL SCRIPT CAPITAL D
     (16#1D4A2#, 16#1D4A2#),  -- (Lu)  MATHEMATICAL SCRIPT CAPITAL G .. MATHEMATICAL SCRIPT CAPITAL G
     (16#1D4A5#, 16#1D4A6#),  -- (Lu)  MATHEMATICAL SCRIPT CAPITAL J .. MATHEMATICAL SCRIPT CAPITAL K
     (16#1D4A9#, 16#1D4AC#),  -- (Lu)  MATHEMATICAL SCRIPT CAPITAL N .. MATHEMATICAL SCRIPT CAPITAL Q
     (16#1D4AE#, 16#1D4B5#),  -- (Lu)  MATHEMATICAL SCRIPT CAPITAL S .. MATHEMATICAL SCRIPT CAPITAL Z
     (16#1D4B6#, 16#1D4B9#),  -- (Ll)  MATHEMATICAL SCRIPT SMALL A .. MATHEMATICAL SCRIPT SMALL D
     (16#1D4BB#, 16#1D4BB#),  -- (Ll)  MATHEMATICAL SCRIPT SMALL F .. MATHEMATICAL SCRIPT SMALL F
     (16#1D4BD#, 16#1D4C3#),  -- (Ll)  MATHEMATICAL SCRIPT SMALL H .. MATHEMATICAL SCRIPT SMALL N
     (16#1D4C5#, 16#1D4CF#),  -- (Ll)  MATHEMATICAL SCRIPT SMALL P .. MATHEMATICAL SCRIPT SMALL Z
     (16#1D4D0#, 16#1D4E9#),  -- (Lu)  MATHEMATICAL BOLD SCRIPT CAPITAL A .. MATHEMATICAL BOLD SCRIPT CAPITAL Z
     (16#1D4EA#, 16#1D503#),  -- (Ll)  MATHEMATICAL BOLD SCRIPT SMALL A .. MATHEMATICAL BOLD SCRIPT SMALL Z
     (16#1D504#, 16#1D505#),  -- (Lu)  MATHEMATICAL FRAKTUR CAPITAL A .. MATHEMATICAL FRAKTUR CAPITAL B
     (16#1D507#, 16#1D50A#),  -- (Lu)  MATHEMATICAL FRAKTUR CAPITAL D .. MATHEMATICAL FRAKTUR CAPITAL G
     (16#1D50D#, 16#1D514#),  -- (Lu)  MATHEMATICAL FRAKTUR CAPITAL J .. MATHEMATICAL FRAKTUR CAPITAL Q
     (16#1D516#, 16#1D51C#),  -- (Lu)  MATHEMATICAL FRAKTUR CAPITAL S .. MATHEMATICAL FRAKTUR CAPITAL Y
     (16#1D51E#, 16#1D537#),  -- (Ll)  MATHEMATICAL FRAKTUR SMALL A .. MATHEMATICAL FRAKTUR SMALL Z
     (16#1D538#, 16#1D539#),  -- (Lu)  MATHEMATICAL DOUBLE-STRUCK CAPITAL A .. MATHEMATICAL DOUBLE-STRUCK CAPITAL B
     (16#1D53B#, 16#1D53E#),  -- (Lu)  MATHEMATICAL DOUBLE-STRUCK CAPITAL D .. MATHEMATICAL DOUBLE-STRUCK CAPITAL G
     (16#1D540#, 16#1D544#),  -- (Lu)  MATHEMATICAL DOUBLE-STRUCK CAPITAL I .. MATHEMATICAL DOUBLE-STRUCK CAPITAL M
     (16#1D546#, 16#1D546#),  -- (Lu)  MATHEMATICAL DOUBLE-STRUCK CAPITAL O .. MATHEMATICAL DOUBLE-STRUCK CAPITAL O
     (16#1D54A#, 16#1D550#),  -- (Lu)  MATHEMATICAL DOUBLE-STRUCK CAPITAL S .. MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
     (16#1D552#, 16#1D56B#),  -- (Ll)  MATHEMATICAL DOUBLE-STRUCK SMALL A .. MATHEMATICAL DOUBLE-STRUCK SMALL Z
     (16#1D56C#, 16#1D585#),  -- (Lu)  MATHEMATICAL BOLD FRAKTUR CAPITAL A .. MATHEMATICAL BOLD FRAKTUR CAPITAL Z
     (16#1D586#, 16#1D59F#),  -- (Ll)  MATHEMATICAL BOLD FRAKTUR SMALL A .. MATHEMATICAL BOLD FRAKTUR SMALL Z
     (16#1D5A0#, 16#1D5B9#),  -- (Lu)  MATHEMATICAL SANS-SERIF CAPITAL A .. MATHEMATICAL SANS-SERIF CAPITAL Z
     (16#1D5BA#, 16#1D5D3#),  -- (Ll)  MATHEMATICAL SANS-SERIF SMALL A .. MATHEMATICAL SANS-SERIF SMALL Z
     (16#1D5D4#, 16#1D5ED#),  -- (Lu)  MATHEMATICAL SANS-SERIF BOLD CAPITAL A .. MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
     (16#1D5EE#, 16#1D607#),  -- (Ll)  MATHEMATICAL SANS-SERIF BOLD SMALL A .. MATHEMATICAL SANS-SERIF BOLD SMALL Z
     (16#1D608#, 16#1D621#),  -- (Lu)  MATHEMATICAL SANS-SERIF ITALIC CAPITAL A .. MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
     (16#1D622#, 16#1D63B#),  -- (Ll)  MATHEMATICAL SANS-SERIF ITALIC SMALL A .. MATHEMATICAL SANS-SERIF ITALIC SMALL Z
     (16#1D63C#, 16#1D655#),  -- (Lu)  MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A .. MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
     (16#1D656#, 16#1D66F#),  -- (Ll)  MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A .. MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
     (16#1D670#, 16#1D689#),  -- (Lu)  MATHEMATICAL MONOSPACE CAPITAL A .. MATHEMATICAL MONOSPACE CAPITAL Z
     (16#1D68A#, 16#1D6A3#),  -- (Ll)  MATHEMATICAL MONOSPACE SMALL A .. MATHEMATICAL MONOSPACE SMALL Z
     (16#1D6A8#, 16#1D6C0#),  -- (Lu)  MATHEMATICAL BOLD CAPITAL ALPHA .. MATHEMATICAL BOLD CAPITAL OMEGA
     (16#1D6C1#, 16#1D6C1#),  -- (Sm)  MATHEMATICAL BOLD NABLA .. MATHEMATICAL BOLD NABLA
     (16#1D6C2#, 16#1D6DA#),  -- (Ll)  MATHEMATICAL BOLD SMALL ALPHA .. MATHEMATICAL BOLD SMALL OMEGA
     (16#1D6DB#, 16#1D6DB#),  -- (Sm)  MATHEMATICAL BOLD PARTIAL DIFFERENTIAL .. MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
     (16#1D6DC#, 16#1D6E1#),  -- (Ll)  MATHEMATICAL BOLD EPSILON SYMBOL .. MATHEMATICAL BOLD PI SYMBOL
     (16#1D6E2#, 16#1D6FA#),  -- (Lu)  MATHEMATICAL ITALIC CAPITAL ALPHA .. MATHEMATICAL ITALIC CAPITAL OMEGA
     (16#1D6FB#, 16#1D6FB#),  -- (Sm)  MATHEMATICAL ITALIC NABLA .. MATHEMATICAL ITALIC NABLA
     (16#1D6FC#, 16#1D714#),  -- (Ll)  MATHEMATICAL ITALIC SMALL ALPHA .. MATHEMATICAL ITALIC SMALL OMEGA
     (16#1D715#, 16#1D715#),  -- (Sm)  MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL .. MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
     (16#1D716#, 16#1D71B#),  -- (Ll)  MATHEMATICAL ITALIC EPSILON SYMBOL .. MATHEMATICAL ITALIC PI SYMBOL
     (16#1D71C#, 16#1D734#),  -- (Lu)  MATHEMATICAL BOLD ITALIC CAPITAL ALPHA .. MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
     (16#1D735#, 16#1D735#),  -- (Sm)  MATHEMATICAL BOLD ITALIC NABLA .. MATHEMATICAL BOLD ITALIC NABLA
     (16#1D736#, 16#1D74E#),  -- (Ll)  MATHEMATICAL BOLD ITALIC SMALL ALPHA .. MATHEMATICAL BOLD ITALIC SMALL OMEGA
     (16#1D74F#, 16#1D74F#),  -- (Sm)  MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL .. MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
     (16#1D750#, 16#1D755#),  -- (Ll)  MATHEMATICAL BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL BOLD ITALIC PI SYMBOL
     (16#1D756#, 16#1D76E#),  -- (Lu)  MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA .. MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
     (16#1D76F#, 16#1D76F#),  -- (Sm)  MATHEMATICAL SANS-SERIF BOLD NABLA .. MATHEMATICAL SANS-SERIF BOLD NABLA
     (16#1D770#, 16#1D788#),  -- (Ll)  MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
     (16#1D789#, 16#1D789#),  -- (Sm)  MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL .. MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
     (16#1D78A#, 16#1D78F#),  -- (Ll)  MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
     (16#1D790#, 16#1D7A8#),  -- (Lu)  MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA .. MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
     (16#1D7A9#, 16#1D7A9#),  -- (Sm)  MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA .. MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
     (16#1D7AA#, 16#1D7C2#),  -- (Ll)  MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
     (16#1D7C3#, 16#1D7C3#),  -- (Sm)  MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL .. MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
     (16#1D7C4#, 16#1D7C9#),  -- (Ll)  MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
     (16#1D7CE#, 16#1D7FF#),  -- (Nd)  MATHEMATICAL BOLD DIGIT ZERO .. MATHEMATICAL MONOSPACE DIGIT NINE
     (16#20000#, 16#2A6D6#),  -- (Lo)  <CJK Ideograph Extension B, First> .. <CJK Ideograph Extension B, Last>
     (16#2F800#, 16#2FA1D#),  -- (Lo)  CJK COMPATIBILITY IDEOGRAPH-2F800 .. CJK COMPATIBILITY IDEOGRAPH-2FA1D
     (16#E0001#, 16#E0001#),  -- (Cf)  LANGUAGE TAG .. LANGUAGE TAG
     (16#E0020#, 16#E007F#),  -- (Cf)  TAG SPACE .. CANCEL TAG
     (16#E0100#, 16#E01EF#),  -- (Mn)  VARIATION SELECTOR-17 .. VARIATION SELECTOR-256
     (16#F0000#, 16#FFFFD#),  -- (Co)  <Plane 15 Private Use, First> .. <Plane 15 Private Use, Last>
     (16#100000#, 16#10FFFD#));  -- (Co)  <Plane 16 Private Use, First> .. <Plane 16 Private Use, Last>

   pragma Warnings (Off);
   --  Temporary, until pragma at start can be activated ???

   --  The following array is parallel to the Unicode_Ranges table above. For
   --  each entry in the Unicode_Ranges table, there is a corresponding entry
   --  in the following table indicating the corresponding unicode category.

   Unicode_Categories : constant array (Unicode_Ranges'Range) of Category := (
     Cc,  -- (16#00000#, 16#0001F#)  <control> .. <control>
     Zs,  -- (16#00020#, 16#00020#)  SPACE .. SPACE
     Po,  -- (16#00021#, 16#00023#)  EXCLAMATION MARK .. NUMBER SIGN
     Sc,  -- (16#00024#, 16#00024#)  DOLLAR SIGN .. DOLLAR SIGN
     Po,  -- (16#00025#, 16#00027#)  PERCENT SIGN .. APOSTROPHE
     Ps,  -- (16#00028#, 16#00028#)  LEFT PARENTHESIS .. LEFT PARENTHESIS
     Pe,  -- (16#00029#, 16#00029#)  RIGHT PARENTHESIS .. RIGHT PARENTHESIS
     Po,  -- (16#0002A#, 16#0002A#)  ASTERISK .. ASTERISK
     Sm,  -- (16#0002B#, 16#0002B#)  PLUS SIGN .. PLUS SIGN
     Po,  -- (16#0002C#, 16#0002C#)  COMMA .. COMMA
     Pd,  -- (16#0002D#, 16#0002D#)  HYPHEN-MINUS .. HYPHEN-MINUS
     Po,  -- (16#0002E#, 16#0002F#)  FULL STOP .. SOLIDUS
     Nd,  -- (16#00030#, 16#00039#)  DIGIT ZERO .. DIGIT NINE
     Po,  -- (16#0003A#, 16#0003B#)  COLON .. SEMICOLON
     Sm,  -- (16#0003C#, 16#0003E#)  LESS-THAN SIGN .. GREATER-THAN SIGN
     Po,  -- (16#0003F#, 16#00040#)  QUESTION MARK .. COMMERCIAL AT
     Lu,  -- (16#00041#, 16#0005A#)  LATIN CAPITAL LETTER A .. LATIN CAPITAL LETTER Z
     Ps,  -- (16#0005B#, 16#0005B#)  LEFT SQUARE BRACKET .. LEFT SQUARE BRACKET
     Po,  -- (16#0005C#, 16#0005C#)  REVERSE SOLIDUS .. REVERSE SOLIDUS
     Pe,  -- (16#0005D#, 16#0005D#)  RIGHT SQUARE BRACKET .. RIGHT SQUARE BRACKET
     Sk,  -- (16#0005E#, 16#0005E#)  CIRCUMFLEX ACCENT .. CIRCUMFLEX ACCENT
     Pc,  -- (16#0005F#, 16#0005F#)  LOW LINE .. LOW LINE
     Sk,  -- (16#00060#, 16#00060#)  GRAVE ACCENT .. GRAVE ACCENT
     Ll,  -- (16#00061#, 16#0007A#)  LATIN SMALL LETTER A .. LATIN SMALL LETTER Z
     Ps,  -- (16#0007B#, 16#0007B#)  LEFT CURLY BRACKET .. LEFT CURLY BRACKET
     Sm,  -- (16#0007C#, 16#0007C#)  VERTICAL LINE .. VERTICAL LINE
     Pe,  -- (16#0007D#, 16#0007D#)  RIGHT CURLY BRACKET .. RIGHT CURLY BRACKET
     Sm,  -- (16#0007E#, 16#0007E#)  TILDE .. TILDE
     Cc,  -- (16#0007F#, 16#0009F#)  <control> .. <control>
     Zs,  -- (16#000A0#, 16#000A0#)  NO-BREAK SPACE .. NO-BREAK SPACE
     Po,  -- (16#000A1#, 16#000A1#)  INVERTED EXCLAMATION MARK .. INVERTED EXCLAMATION MARK
     Sc,  -- (16#000A2#, 16#000A5#)  CENT SIGN .. YEN SIGN
     So,  -- (16#000A6#, 16#000A7#)  BROKEN BAR .. SECTION SIGN
     Sk,  -- (16#000A8#, 16#000A8#)  DIAERESIS .. DIAERESIS
     So,  -- (16#000A9#, 16#000A9#)  COPYRIGHT SIGN .. COPYRIGHT SIGN
     Ll,  -- (16#000AA#, 16#000AA#)  FEMININE ORDINAL INDICATOR .. FEMININE ORDINAL INDICATOR
     Pi,  -- (16#000AB#, 16#000AB#)  LEFT-POINTING DOUBLE ANGLE QUOTATION MARK .. LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
     Sm,  -- (16#000AC#, 16#000AC#)  NOT SIGN .. NOT SIGN
     Cf,  -- (16#000AD#, 16#000AD#)  SOFT HYPHEN .. SOFT HYPHEN
     So,  -- (16#000AE#, 16#000AE#)  REGISTERED SIGN .. REGISTERED SIGN
     Sk,  -- (16#000AF#, 16#000AF#)  MACRON .. MACRON
     So,  -- (16#000B0#, 16#000B0#)  DEGREE SIGN .. DEGREE SIGN
     Sm,  -- (16#000B1#, 16#000B1#)  PLUS-MINUS SIGN .. PLUS-MINUS SIGN
     No,  -- (16#000B2#, 16#000B3#)  SUPERSCRIPT TWO .. SUPERSCRIPT THREE
     Sk,  -- (16#000B4#, 16#000B4#)  ACUTE ACCENT .. ACUTE ACCENT
     Ll,  -- (16#000B5#, 16#000B5#)  MICRO SIGN .. MICRO SIGN
     So,  -- (16#000B6#, 16#000B6#)  PILCROW SIGN .. PILCROW SIGN
     Po,  -- (16#000B7#, 16#000B7#)  MIDDLE DOT .. MIDDLE DOT
     Sk,  -- (16#000B8#, 16#000B8#)  CEDILLA .. CEDILLA
     No,  -- (16#000B9#, 16#000B9#)  SUPERSCRIPT ONE .. SUPERSCRIPT ONE
     Ll,  -- (16#000BA#, 16#000BA#)  MASCULINE ORDINAL INDICATOR .. MASCULINE ORDINAL INDICATOR
     Pf,  -- (16#000BB#, 16#000BB#)  RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK .. RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
     No,  -- (16#000BC#, 16#000BE#)  VULGAR FRACTION ONE QUARTER .. VULGAR FRACTION THREE QUARTERS
     Po,  -- (16#000BF#, 16#000BF#)  INVERTED QUESTION MARK .. INVERTED QUESTION MARK
     Lu,  -- (16#000C0#, 16#000D6#)  LATIN CAPITAL LETTER A WITH GRAVE .. LATIN CAPITAL LETTER O WITH DIAERESIS
     Sm,  -- (16#000D7#, 16#000D7#)  MULTIPLICATION SIGN .. MULTIPLICATION SIGN
     Lu,  -- (16#000D8#, 16#000DE#)  LATIN CAPITAL LETTER O WITH STROKE .. LATIN CAPITAL LETTER THORN
     Ll,  -- (16#000DF#, 16#000F6#)  LATIN SMALL LETTER SHARP S .. LATIN SMALL LETTER O WITH DIAERESIS
     Sm,  -- (16#000F7#, 16#000F7#)  DIVISION SIGN .. DIVISION SIGN
     Ll,  -- (16#000F8#, 16#000FF#)  LATIN SMALL LETTER O WITH STROKE .. LATIN SMALL LETTER Y WITH DIAERESIS
     Lu,  -- (16#00100#, 16#00100#)  LATIN CAPITAL LETTER A WITH MACRON .. LATIN CAPITAL LETTER A WITH MACRON
     Ll,  -- (16#00101#, 16#00101#)  LATIN SMALL LETTER A WITH MACRON .. LATIN SMALL LETTER A WITH MACRON
     Lu,  -- (16#00102#, 16#00102#)  LATIN CAPITAL LETTER A WITH BREVE .. LATIN CAPITAL LETTER A WITH BREVE
     Ll,  -- (16#00103#, 16#00103#)  LATIN SMALL LETTER A WITH BREVE .. LATIN SMALL LETTER A WITH BREVE
     Lu,  -- (16#00104#, 16#00104#)  LATIN CAPITAL LETTER A WITH OGONEK .. LATIN CAPITAL LETTER A WITH OGONEK
     Ll,  -- (16#00105#, 16#00105#)  LATIN SMALL LETTER A WITH OGONEK .. LATIN SMALL LETTER A WITH OGONEK
     Lu,  -- (16#00106#, 16#00106#)  LATIN CAPITAL LETTER C WITH ACUTE .. LATIN CAPITAL LETTER C WITH ACUTE
     Ll,  -- (16#00107#, 16#00107#)  LATIN SMALL LETTER C WITH ACUTE .. LATIN SMALL LETTER C WITH ACUTE
     Lu,  -- (16#00108#, 16#00108#)  LATIN CAPITAL LETTER C WITH CIRCUMFLEX .. LATIN CAPITAL LETTER C WITH CIRCUMFLEX
     Ll,  -- (16#00109#, 16#00109#)  LATIN SMALL LETTER C WITH CIRCUMFLEX .. LATIN SMALL LETTER C WITH CIRCUMFLEX
     Lu,  -- (16#0010A#, 16#0010A#)  LATIN CAPITAL LETTER C WITH DOT ABOVE .. LATIN CAPITAL LETTER C WITH DOT ABOVE
     Ll,  -- (16#0010B#, 16#0010B#)  LATIN SMALL LETTER C WITH DOT ABOVE .. LATIN SMALL LETTER C WITH DOT ABOVE
     Lu,  -- (16#0010C#, 16#0010C#)  LATIN CAPITAL LETTER C WITH CARON .. LATIN CAPITAL LETTER C WITH CARON
     Ll,  -- (16#0010D#, 16#0010D#)  LATIN SMALL LETTER C WITH CARON .. LATIN SMALL LETTER C WITH CARON
     Lu,  -- (16#0010E#, 16#0010E#)  LATIN CAPITAL LETTER D WITH CARON .. LATIN CAPITAL LETTER D WITH CARON
     Ll,  -- (16#0010F#, 16#0010F#)  LATIN SMALL LETTER D WITH CARON .. LATIN SMALL LETTER D WITH CARON
     Lu,  -- (16#00110#, 16#00110#)  LATIN CAPITAL LETTER D WITH STROKE .. LATIN CAPITAL LETTER D WITH STROKE
     Ll,  -- (16#00111#, 16#00111#)  LATIN SMALL LETTER D WITH STROKE .. LATIN SMALL LETTER D WITH STROKE
     Lu,  -- (16#00112#, 16#00112#)  LATIN CAPITAL LETTER E WITH MACRON .. LATIN CAPITAL LETTER E WITH MACRON
     Ll,  -- (16#00113#, 16#00113#)  LATIN SMALL LETTER E WITH MACRON .. LATIN SMALL LETTER E WITH MACRON
     Lu,  -- (16#00114#, 16#00114#)  LATIN CAPITAL LETTER E WITH BREVE .. LATIN CAPITAL LETTER E WITH BREVE
     Ll,  -- (16#00115#, 16#00115#)  LATIN SMALL LETTER E WITH BREVE .. LATIN SMALL LETTER E WITH BREVE
     Lu,  -- (16#00116#, 16#00116#)  LATIN CAPITAL LETTER E WITH DOT ABOVE .. LATIN CAPITAL LETTER E WITH DOT ABOVE
     Ll,  -- (16#00117#, 16#00117#)  LATIN SMALL LETTER E WITH DOT ABOVE .. LATIN SMALL LETTER E WITH DOT ABOVE
     Lu,  -- (16#00118#, 16#00118#)  LATIN CAPITAL LETTER E WITH OGONEK .. LATIN CAPITAL LETTER E WITH OGONEK
     Ll,  -- (16#00119#, 16#00119#)  LATIN SMALL LETTER E WITH OGONEK .. LATIN SMALL LETTER E WITH OGONEK
     Lu,  -- (16#0011A#, 16#0011A#)  LATIN CAPITAL LETTER E WITH CARON .. LATIN CAPITAL LETTER E WITH CARON
     Ll,  -- (16#0011B#, 16#0011B#)  LATIN SMALL LETTER E WITH CARON .. LATIN SMALL LETTER E WITH CARON
     Lu,  -- (16#0011C#, 16#0011C#)  LATIN CAPITAL LETTER G WITH CIRCUMFLEX .. LATIN CAPITAL LETTER G WITH CIRCUMFLEX
     Ll,  -- (16#0011D#, 16#0011D#)  LATIN SMALL LETTER G WITH CIRCUMFLEX .. LATIN SMALL LETTER G WITH CIRCUMFLEX
     Lu,  -- (16#0011E#, 16#0011E#)  LATIN CAPITAL LETTER G WITH BREVE .. LATIN CAPITAL LETTER G WITH BREVE
     Ll,  -- (16#0011F#, 16#0011F#)  LATIN SMALL LETTER G WITH BREVE .. LATIN SMALL LETTER G WITH BREVE
     Lu,  -- (16#00120#, 16#00120#)  LATIN CAPITAL LETTER G WITH DOT ABOVE .. LATIN CAPITAL LETTER G WITH DOT ABOVE
     Ll,  -- (16#00121#, 16#00121#)  LATIN SMALL LETTER G WITH DOT ABOVE .. LATIN SMALL LETTER G WITH DOT ABOVE
     Lu,  -- (16#00122#, 16#00122#)  LATIN CAPITAL LETTER G WITH CEDILLA .. LATIN CAPITAL LETTER G WITH CEDILLA
     Ll,  -- (16#00123#, 16#00123#)  LATIN SMALL LETTER G WITH CEDILLA .. LATIN SMALL LETTER G WITH CEDILLA
     Lu,  -- (16#00124#, 16#00124#)  LATIN CAPITAL LETTER H WITH CIRCUMFLEX .. LATIN CAPITAL LETTER H WITH CIRCUMFLEX
     Ll,  -- (16#00125#, 16#00125#)  LATIN SMALL LETTER H WITH CIRCUMFLEX .. LATIN SMALL LETTER H WITH CIRCUMFLEX
     Lu,  -- (16#00126#, 16#00126#)  LATIN CAPITAL LETTER H WITH STROKE .. LATIN CAPITAL LETTER H WITH STROKE
     Ll,  -- (16#00127#, 16#00127#)  LATIN SMALL LETTER H WITH STROKE .. LATIN SMALL LETTER H WITH STROKE
     Lu,  -- (16#00128#, 16#00128#)  LATIN CAPITAL LETTER I WITH TILDE .. LATIN CAPITAL LETTER I WITH TILDE
     Ll,  -- (16#00129#, 16#00129#)  LATIN SMALL LETTER I WITH TILDE .. LATIN SMALL LETTER I WITH TILDE
     Lu,  -- (16#0012A#, 16#0012A#)  LATIN CAPITAL LETTER I WITH MACRON .. LATIN CAPITAL LETTER I WITH MACRON
     Ll,  -- (16#0012B#, 16#0012B#)  LATIN SMALL LETTER I WITH MACRON .. LATIN SMALL LETTER I WITH MACRON
     Lu,  -- (16#0012C#, 16#0012C#)  LATIN CAPITAL LETTER I WITH BREVE .. LATIN CAPITAL LETTER I WITH BREVE
     Ll,  -- (16#0012D#, 16#0012D#)  LATIN SMALL LETTER I WITH BREVE .. LATIN SMALL LETTER I WITH BREVE
     Lu,  -- (16#0012E#, 16#0012E#)  LATIN CAPITAL LETTER I WITH OGONEK .. LATIN CAPITAL LETTER I WITH OGONEK
     Ll,  -- (16#0012F#, 16#0012F#)  LATIN SMALL LETTER I WITH OGONEK .. LATIN SMALL LETTER I WITH OGONEK
     Lu,  -- (16#00130#, 16#00130#)  LATIN CAPITAL LETTER I WITH DOT ABOVE .. LATIN CAPITAL LETTER I WITH DOT ABOVE
     Ll,  -- (16#00131#, 16#00131#)  LATIN SMALL LETTER DOTLESS I .. LATIN SMALL LETTER DOTLESS I
     Lu,  -- (16#00132#, 16#00132#)  LATIN CAPITAL LIGATURE IJ .. LATIN CAPITAL LIGATURE IJ
     Ll,  -- (16#00133#, 16#00133#)  LATIN SMALL LIGATURE IJ .. LATIN SMALL LIGATURE IJ
     Lu,  -- (16#00134#, 16#00134#)  LATIN CAPITAL LETTER J WITH CIRCUMFLEX .. LATIN CAPITAL LETTER J WITH CIRCUMFLEX
     Ll,  -- (16#00135#, 16#00135#)  LATIN SMALL LETTER J WITH CIRCUMFLEX .. LATIN SMALL LETTER J WITH CIRCUMFLEX
     Lu,  -- (16#00136#, 16#00136#)  LATIN CAPITAL LETTER K WITH CEDILLA .. LATIN CAPITAL LETTER K WITH CEDILLA
     Ll,  -- (16#00137#, 16#00138#)  LATIN SMALL LETTER K WITH CEDILLA .. LATIN SMALL LETTER KRA
     Lu,  -- (16#00139#, 16#00139#)  LATIN CAPITAL LETTER L WITH ACUTE .. LATIN CAPITAL LETTER L WITH ACUTE
     Ll,  -- (16#0013A#, 16#0013A#)  LATIN SMALL LETTER L WITH ACUTE .. LATIN SMALL LETTER L WITH ACUTE
     Lu,  -- (16#0013B#, 16#0013B#)  LATIN CAPITAL LETTER L WITH CEDILLA .. LATIN CAPITAL LETTER L WITH CEDILLA
     Ll,  -- (16#0013C#, 16#0013C#)  LATIN SMALL LETTER L WITH CEDILLA .. LATIN SMALL LETTER L WITH CEDILLA
     Lu,  -- (16#0013D#, 16#0013D#)  LATIN CAPITAL LETTER L WITH CARON .. LATIN CAPITAL LETTER L WITH CARON
     Ll,  -- (16#0013E#, 16#0013E#)  LATIN SMALL LETTER L WITH CARON .. LATIN SMALL LETTER L WITH CARON
     Lu,  -- (16#0013F#, 16#0013F#)  LATIN CAPITAL LETTER L WITH MIDDLE DOT .. LATIN CAPITAL LETTER L WITH MIDDLE DOT
     Ll,  -- (16#00140#, 16#00140#)  LATIN SMALL LETTER L WITH MIDDLE DOT .. LATIN SMALL LETTER L WITH MIDDLE DOT
     Lu,  -- (16#00141#, 16#00141#)  LATIN CAPITAL LETTER L WITH STROKE .. LATIN CAPITAL LETTER L WITH STROKE
     Ll,  -- (16#00142#, 16#00142#)  LATIN SMALL LETTER L WITH STROKE .. LATIN SMALL LETTER L WITH STROKE
     Lu,  -- (16#00143#, 16#00143#)  LATIN CAPITAL LETTER N WITH ACUTE .. LATIN CAPITAL LETTER N WITH ACUTE
     Ll,  -- (16#00144#, 16#00144#)  LATIN SMALL LETTER N WITH ACUTE .. LATIN SMALL LETTER N WITH ACUTE
     Lu,  -- (16#00145#, 16#00145#)  LATIN CAPITAL LETTER N WITH CEDILLA .. LATIN CAPITAL LETTER N WITH CEDILLA
     Ll,  -- (16#00146#, 16#00146#)  LATIN SMALL LETTER N WITH CEDILLA .. LATIN SMALL LETTER N WITH CEDILLA
     Lu,  -- (16#00147#, 16#00147#)  LATIN CAPITAL LETTER N WITH CARON .. LATIN CAPITAL LETTER N WITH CARON
     Ll,  -- (16#00148#, 16#00149#)  LATIN SMALL LETTER N WITH CARON .. LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
     Lu,  -- (16#0014A#, 16#0014A#)  LATIN CAPITAL LETTER ENG .. LATIN CAPITAL LETTER ENG
     Ll,  -- (16#0014B#, 16#0014B#)  LATIN SMALL LETTER ENG .. LATIN SMALL LETTER ENG
     Lu,  -- (16#0014C#, 16#0014C#)  LATIN CAPITAL LETTER O WITH MACRON .. LATIN CAPITAL LETTER O WITH MACRON
     Ll,  -- (16#0014D#, 16#0014D#)  LATIN SMALL LETTER O WITH MACRON .. LATIN SMALL LETTER O WITH MACRON
     Lu,  -- (16#0014E#, 16#0014E#)  LATIN CAPITAL LETTER O WITH BREVE .. LATIN CAPITAL LETTER O WITH BREVE
     Ll,  -- (16#0014F#, 16#0014F#)  LATIN SMALL LETTER O WITH BREVE .. LATIN SMALL LETTER O WITH BREVE
     Lu,  -- (16#00150#, 16#00150#)  LATIN CAPITAL LETTER O WITH DOUBLE ACUTE .. LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
     Ll,  -- (16#00151#, 16#00151#)  LATIN SMALL LETTER O WITH DOUBLE ACUTE .. LATIN SMALL LETTER O WITH DOUBLE ACUTE
     Lu,  -- (16#00152#, 16#00152#)  LATIN CAPITAL LIGATURE OE .. LATIN CAPITAL LIGATURE OE
     Ll,  -- (16#00153#, 16#00153#)  LATIN SMALL LIGATURE OE .. LATIN SMALL LIGATURE OE
     Lu,  -- (16#00154#, 16#00154#)  LATIN CAPITAL LETTER R WITH ACUTE .. LATIN CAPITAL LETTER R WITH ACUTE
     Ll,  -- (16#00155#, 16#00155#)  LATIN SMALL LETTER R WITH ACUTE .. LATIN SMALL LETTER R WITH ACUTE
     Lu,  -- (16#00156#, 16#00156#)  LATIN CAPITAL LETTER R WITH CEDILLA .. LATIN CAPITAL LETTER R WITH CEDILLA
     Ll,  -- (16#00157#, 16#00157#)  LATIN SMALL LETTER R WITH CEDILLA .. LATIN SMALL LETTER R WITH CEDILLA
     Lu,  -- (16#00158#, 16#00158#)  LATIN CAPITAL LETTER R WITH CARON .. LATIN CAPITAL LETTER R WITH CARON
     Ll,  -- (16#00159#, 16#00159#)  LATIN SMALL LETTER R WITH CARON .. LATIN SMALL LETTER R WITH CARON
     Lu,  -- (16#0015A#, 16#0015A#)  LATIN CAPITAL LETTER S WITH ACUTE .. LATIN CAPITAL LETTER S WITH ACUTE
     Ll,  -- (16#0015B#, 16#0015B#)  LATIN SMALL LETTER S WITH ACUTE .. LATIN SMALL LETTER S WITH ACUTE
     Lu,  -- (16#0015C#, 16#0015C#)  LATIN CAPITAL LETTER S WITH CIRCUMFLEX .. LATIN CAPITAL LETTER S WITH CIRCUMFLEX
     Ll,  -- (16#0015D#, 16#0015D#)  LATIN SMALL LETTER S WITH CIRCUMFLEX .. LATIN SMALL LETTER S WITH CIRCUMFLEX
     Lu,  -- (16#0015E#, 16#0015E#)  LATIN CAPITAL LETTER S WITH CEDILLA .. LATIN CAPITAL LETTER S WITH CEDILLA
     Ll,  -- (16#0015F#, 16#0015F#)  LATIN SMALL LETTER S WITH CEDILLA .. LATIN SMALL LETTER S WITH CEDILLA
     Lu,  -- (16#00160#, 16#00160#)  LATIN CAPITAL LETTER S WITH CARON .. LATIN CAPITAL LETTER S WITH CARON
     Ll,  -- (16#00161#, 16#00161#)  LATIN SMALL LETTER S WITH CARON .. LATIN SMALL LETTER S WITH CARON
     Lu,  -- (16#00162#, 16#00162#)  LATIN CAPITAL LETTER T WITH CEDILLA .. LATIN CAPITAL LETTER T WITH CEDILLA
     Ll,  -- (16#00163#, 16#00163#)  LATIN SMALL LETTER T WITH CEDILLA .. LATIN SMALL LETTER T WITH CEDILLA
     Lu,  -- (16#00164#, 16#00164#)  LATIN CAPITAL LETTER T WITH CARON .. LATIN CAPITAL LETTER T WITH CARON
     Ll,  -- (16#00165#, 16#00165#)  LATIN SMALL LETTER T WITH CARON .. LATIN SMALL LETTER T WITH CARON
     Lu,  -- (16#00166#, 16#00166#)  LATIN CAPITAL LETTER T WITH STROKE .. LATIN CAPITAL LETTER T WITH STROKE
     Ll,  -- (16#00167#, 16#00167#)  LATIN SMALL LETTER T WITH STROKE .. LATIN SMALL LETTER T WITH STROKE
     Lu,  -- (16#00168#, 16#00168#)  LATIN CAPITAL LETTER U WITH TILDE .. LATIN CAPITAL LETTER U WITH TILDE
     Ll,  -- (16#00169#, 16#00169#)  LATIN SMALL LETTER U WITH TILDE .. LATIN SMALL LETTER U WITH TILDE
     Lu,  -- (16#0016A#, 16#0016A#)  LATIN CAPITAL LETTER U WITH MACRON .. LATIN CAPITAL LETTER U WITH MACRON
     Ll,  -- (16#0016B#, 16#0016B#)  LATIN SMALL LETTER U WITH MACRON .. LATIN SMALL LETTER U WITH MACRON
     Lu,  -- (16#0016C#, 16#0016C#)  LATIN CAPITAL LETTER U WITH BREVE .. LATIN CAPITAL LETTER U WITH BREVE
     Ll,  -- (16#0016D#, 16#0016D#)  LATIN SMALL LETTER U WITH BREVE .. LATIN SMALL LETTER U WITH BREVE
     Lu,  -- (16#0016E#, 16#0016E#)  LATIN CAPITAL LETTER U WITH RING ABOVE .. LATIN CAPITAL LETTER U WITH RING ABOVE
     Ll,  -- (16#0016F#, 16#0016F#)  LATIN SMALL LETTER U WITH RING ABOVE .. LATIN SMALL LETTER U WITH RING ABOVE
     Lu,  -- (16#00170#, 16#00170#)  LATIN CAPITAL LETTER U WITH DOUBLE ACUTE .. LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
     Ll,  -- (16#00171#, 16#00171#)  LATIN SMALL LETTER U WITH DOUBLE ACUTE .. LATIN SMALL LETTER U WITH DOUBLE ACUTE
     Lu,  -- (16#00172#, 16#00172#)  LATIN CAPITAL LETTER U WITH OGONEK .. LATIN CAPITAL LETTER U WITH OGONEK
     Ll,  -- (16#00173#, 16#00173#)  LATIN SMALL LETTER U WITH OGONEK .. LATIN SMALL LETTER U WITH OGONEK
     Lu,  -- (16#00174#, 16#00174#)  LATIN CAPITAL LETTER W WITH CIRCUMFLEX .. LATIN CAPITAL LETTER W WITH CIRCUMFLEX
     Ll,  -- (16#00175#, 16#00175#)  LATIN SMALL LETTER W WITH CIRCUMFLEX .. LATIN SMALL LETTER W WITH CIRCUMFLEX
     Lu,  -- (16#00176#, 16#00176#)  LATIN CAPITAL LETTER Y WITH CIRCUMFLEX .. LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
     Ll,  -- (16#00177#, 16#00177#)  LATIN SMALL LETTER Y WITH CIRCUMFLEX .. LATIN SMALL LETTER Y WITH CIRCUMFLEX
     Lu,  -- (16#00178#, 16#00179#)  LATIN CAPITAL LETTER Y WITH DIAERESIS .. LATIN CAPITAL LETTER Z WITH ACUTE
     Ll,  -- (16#0017A#, 16#0017A#)  LATIN SMALL LETTER Z WITH ACUTE .. LATIN SMALL LETTER Z WITH ACUTE
     Lu,  -- (16#0017B#, 16#0017B#)  LATIN CAPITAL LETTER Z WITH DOT ABOVE .. LATIN CAPITAL LETTER Z WITH DOT ABOVE
     Ll,  -- (16#0017C#, 16#0017C#)  LATIN SMALL LETTER Z WITH DOT ABOVE .. LATIN SMALL LETTER Z WITH DOT ABOVE
     Lu,  -- (16#0017D#, 16#0017D#)  LATIN CAPITAL LETTER Z WITH CARON .. LATIN CAPITAL LETTER Z WITH CARON
     Ll,  -- (16#0017E#, 16#00180#)  LATIN SMALL LETTER Z WITH CARON .. LATIN SMALL LETTER B WITH STROKE
     Lu,  -- (16#00181#, 16#00182#)  LATIN CAPITAL LETTER B WITH HOOK .. LATIN CAPITAL LETTER B WITH TOPBAR
     Ll,  -- (16#00183#, 16#00183#)  LATIN SMALL LETTER B WITH TOPBAR .. LATIN SMALL LETTER B WITH TOPBAR
     Lu,  -- (16#00184#, 16#00184#)  LATIN CAPITAL LETTER TONE SIX .. LATIN CAPITAL LETTER TONE SIX
     Ll,  -- (16#00185#, 16#00185#)  LATIN SMALL LETTER TONE SIX .. LATIN SMALL LETTER TONE SIX
     Lu,  -- (16#00186#, 16#00187#)  LATIN CAPITAL LETTER OPEN O .. LATIN CAPITAL LETTER C WITH HOOK
     Ll,  -- (16#00188#, 16#00188#)  LATIN SMALL LETTER C WITH HOOK .. LATIN SMALL LETTER C WITH HOOK
     Lu,  -- (16#00189#, 16#0018B#)  LATIN CAPITAL LETTER AFRICAN D .. LATIN CAPITAL LETTER D WITH TOPBAR
     Ll,  -- (16#0018C#, 16#0018D#)  LATIN SMALL LETTER D WITH TOPBAR .. LATIN SMALL LETTER TURNED DELTA
     Lu,  -- (16#0018E#, 16#00191#)  LATIN CAPITAL LETTER REVERSED E .. LATIN CAPITAL LETTER F WITH HOOK
     Ll,  -- (16#00192#, 16#00192#)  LATIN SMALL LETTER F WITH HOOK .. LATIN SMALL LETTER F WITH HOOK
     Lu,  -- (16#00193#, 16#00194#)  LATIN CAPITAL LETTER G WITH HOOK .. LATIN CAPITAL LETTER GAMMA
     Ll,  -- (16#00195#, 16#00195#)  LATIN SMALL LETTER HV .. LATIN SMALL LETTER HV
     Lu,  -- (16#00196#, 16#00198#)  LATIN CAPITAL LETTER IOTA .. LATIN CAPITAL LETTER K WITH HOOK
     Ll,  -- (16#00199#, 16#0019B#)  LATIN SMALL LETTER K WITH HOOK .. LATIN SMALL LETTER LAMBDA WITH STROKE
     Lu,  -- (16#0019C#, 16#0019D#)  LATIN CAPITAL LETTER TURNED M .. LATIN CAPITAL LETTER N WITH LEFT HOOK
     Ll,  -- (16#0019E#, 16#0019E#)  LATIN SMALL LETTER N WITH LONG RIGHT LEG .. LATIN SMALL LETTER N WITH LONG RIGHT LEG
     Lu,  -- (16#0019F#, 16#001A0#)  LATIN CAPITAL LETTER O WITH MIDDLE TILDE .. LATIN CAPITAL LETTER O WITH HORN
     Ll,  -- (16#001A1#, 16#001A1#)  LATIN SMALL LETTER O WITH HORN .. LATIN SMALL LETTER O WITH HORN
     Lu,  -- (16#001A2#, 16#001A2#)  LATIN CAPITAL LETTER OI .. LATIN CAPITAL LETTER OI
     Ll,  -- (16#001A3#, 16#001A3#)  LATIN SMALL LETTER OI .. LATIN SMALL LETTER OI
     Lu,  -- (16#001A4#, 16#001A4#)  LATIN CAPITAL LETTER P WITH HOOK .. LATIN CAPITAL LETTER P WITH HOOK
     Ll,  -- (16#001A5#, 16#001A5#)  LATIN SMALL LETTER P WITH HOOK .. LATIN SMALL LETTER P WITH HOOK
     Lu,  -- (16#001A6#, 16#001A7#)  LATIN LETTER YR .. LATIN CAPITAL LETTER TONE TWO
     Ll,  -- (16#001A8#, 16#001A8#)  LATIN SMALL LETTER TONE TWO .. LATIN SMALL LETTER TONE TWO
     Lu,  -- (16#001A9#, 16#001A9#)  LATIN CAPITAL LETTER ESH .. LATIN CAPITAL LETTER ESH
     Ll,  -- (16#001AA#, 16#001AB#)  LATIN LETTER REVERSED ESH LOOP .. LATIN SMALL LETTER T WITH PALATAL HOOK
     Lu,  -- (16#001AC#, 16#001AC#)  LATIN CAPITAL LETTER T WITH HOOK .. LATIN CAPITAL LETTER T WITH HOOK
     Ll,  -- (16#001AD#, 16#001AD#)  LATIN SMALL LETTER T WITH HOOK .. LATIN SMALL LETTER T WITH HOOK
     Lu,  -- (16#001AE#, 16#001AF#)  LATIN CAPITAL LETTER T WITH RETROFLEX HOOK .. LATIN CAPITAL LETTER U WITH HORN
     Ll,  -- (16#001B0#, 16#001B0#)  LATIN SMALL LETTER U WITH HORN .. LATIN SMALL LETTER U WITH HORN
     Lu,  -- (16#001B1#, 16#001B3#)  LATIN CAPITAL LETTER UPSILON .. LATIN CAPITAL LETTER Y WITH HOOK
     Ll,  -- (16#001B4#, 16#001B4#)  LATIN SMALL LETTER Y WITH HOOK .. LATIN SMALL LETTER Y WITH HOOK
     Lu,  -- (16#001B5#, 16#001B5#)  LATIN CAPITAL LETTER Z WITH STROKE .. LATIN CAPITAL LETTER Z WITH STROKE
     Ll,  -- (16#001B6#, 16#001B6#)  LATIN SMALL LETTER Z WITH STROKE .. LATIN SMALL LETTER Z WITH STROKE
     Lu,  -- (16#001B7#, 16#001B8#)  LATIN CAPITAL LETTER EZH .. LATIN CAPITAL LETTER EZH REVERSED
     Ll,  -- (16#001B9#, 16#001BA#)  LATIN SMALL LETTER EZH REVERSED .. LATIN SMALL LETTER EZH WITH TAIL
     Lo,  -- (16#001BB#, 16#001BB#)  LATIN LETTER TWO WITH STROKE .. LATIN LETTER TWO WITH STROKE
     Lu,  -- (16#001BC#, 16#001BC#)  LATIN CAPITAL LETTER TONE FIVE .. LATIN CAPITAL LETTER TONE FIVE
     Ll,  -- (16#001BD#, 16#001BF#)  LATIN SMALL LETTER TONE FIVE .. LATIN LETTER WYNN
     Lo,  -- (16#001C0#, 16#001C3#)  LATIN LETTER DENTAL CLICK .. LATIN LETTER RETROFLEX CLICK
     Lu,  -- (16#001C4#, 16#001C4#)  LATIN CAPITAL LETTER DZ WITH CARON .. LATIN CAPITAL LETTER DZ WITH CARON
     Lt,  -- (16#001C5#, 16#001C5#)  LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON .. LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
     Ll,  -- (16#001C6#, 16#001C6#)  LATIN SMALL LETTER DZ WITH CARON .. LATIN SMALL LETTER DZ WITH CARON
     Lu,  -- (16#001C7#, 16#001C7#)  LATIN CAPITAL LETTER LJ .. LATIN CAPITAL LETTER LJ
     Lt,  -- (16#001C8#, 16#001C8#)  LATIN CAPITAL LETTER L WITH SMALL LETTER J .. LATIN CAPITAL LETTER L WITH SMALL LETTER J
     Ll,  -- (16#001C9#, 16#001C9#)  LATIN SMALL LETTER LJ .. LATIN SMALL LETTER LJ
     Lu,  -- (16#001CA#, 16#001CA#)  LATIN CAPITAL LETTER NJ .. LATIN CAPITAL LETTER NJ
     Lt,  -- (16#001CB#, 16#001CB#)  LATIN CAPITAL LETTER N WITH SMALL LETTER J .. LATIN CAPITAL LETTER N WITH SMALL LETTER J
     Ll,  -- (16#001CC#, 16#001CC#)  LATIN SMALL LETTER NJ .. LATIN SMALL LETTER NJ
     Lu,  -- (16#001CD#, 16#001CD#)  LATIN CAPITAL LETTER A WITH CARON .. LATIN CAPITAL LETTER A WITH CARON
     Ll,  -- (16#001CE#, 16#001CE#)  LATIN SMALL LETTER A WITH CARON .. LATIN SMALL LETTER A WITH CARON
     Lu,  -- (16#001CF#, 16#001CF#)  LATIN CAPITAL LETTER I WITH CARON .. LATIN CAPITAL LETTER I WITH CARON
     Ll,  -- (16#001D0#, 16#001D0#)  LATIN SMALL LETTER I WITH CARON .. LATIN SMALL LETTER I WITH CARON
     Lu,  -- (16#001D1#, 16#001D1#)  LATIN CAPITAL LETTER O WITH CARON .. LATIN CAPITAL LETTER O WITH CARON
     Ll,  -- (16#001D2#, 16#001D2#)  LATIN SMALL LETTER O WITH CARON .. LATIN SMALL LETTER O WITH CARON
     Lu,  -- (16#001D3#, 16#001D3#)  LATIN CAPITAL LETTER U WITH CARON .. LATIN CAPITAL LETTER U WITH CARON
     Ll,  -- (16#001D4#, 16#001D4#)  LATIN SMALL LETTER U WITH CARON .. LATIN SMALL LETTER U WITH CARON
     Lu,  -- (16#001D5#, 16#001D5#)  LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
     Ll,  -- (16#001D6#, 16#001D6#)  LATIN SMALL LETTER U WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
     Lu,  -- (16#001D7#, 16#001D7#)  LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE .. LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
     Ll,  -- (16#001D8#, 16#001D8#)  LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
     Lu,  -- (16#001D9#, 16#001D9#)  LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON .. LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
     Ll,  -- (16#001DA#, 16#001DA#)  LATIN SMALL LETTER U WITH DIAERESIS AND CARON .. LATIN SMALL LETTER U WITH DIAERESIS AND CARON
     Lu,  -- (16#001DB#, 16#001DB#)  LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE .. LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
     Ll,  -- (16#001DC#, 16#001DD#)  LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE .. LATIN SMALL LETTER TURNED E
     Lu,  -- (16#001DE#, 16#001DE#)  LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
     Ll,  -- (16#001DF#, 16#001DF#)  LATIN SMALL LETTER A WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
     Lu,  -- (16#001E0#, 16#001E0#)  LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON .. LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
     Ll,  -- (16#001E1#, 16#001E1#)  LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
     Lu,  -- (16#001E2#, 16#001E2#)  LATIN CAPITAL LETTER AE WITH MACRON .. LATIN CAPITAL LETTER AE WITH MACRON
     Ll,  -- (16#001E3#, 16#001E3#)  LATIN SMALL LETTER AE WITH MACRON .. LATIN SMALL LETTER AE WITH MACRON
     Lu,  -- (16#001E4#, 16#001E4#)  LATIN CAPITAL LETTER G WITH STROKE .. LATIN CAPITAL LETTER G WITH STROKE
     Ll,  -- (16#001E5#, 16#001E5#)  LATIN SMALL LETTER G WITH STROKE .. LATIN SMALL LETTER G WITH STROKE
     Lu,  -- (16#001E6#, 16#001E6#)  LATIN CAPITAL LETTER G WITH CARON .. LATIN CAPITAL LETTER G WITH CARON
     Ll,  -- (16#001E7#, 16#001E7#)  LATIN SMALL LETTER G WITH CARON .. LATIN SMALL LETTER G WITH CARON
     Lu,  -- (16#001E8#, 16#001E8#)  LATIN CAPITAL LETTER K WITH CARON .. LATIN CAPITAL LETTER K WITH CARON
     Ll,  -- (16#001E9#, 16#001E9#)  LATIN SMALL LETTER K WITH CARON .. LATIN SMALL LETTER K WITH CARON
     Lu,  -- (16#001EA#, 16#001EA#)  LATIN CAPITAL LETTER O WITH OGONEK .. LATIN CAPITAL LETTER O WITH OGONEK
     Ll,  -- (16#001EB#, 16#001EB#)  LATIN SMALL LETTER O WITH OGONEK .. LATIN SMALL LETTER O WITH OGONEK
     Lu,  -- (16#001EC#, 16#001EC#)  LATIN CAPITAL LETTER O WITH OGONEK AND MACRON .. LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
     Ll,  -- (16#001ED#, 16#001ED#)  LATIN SMALL LETTER O WITH OGONEK AND MACRON .. LATIN SMALL LETTER O WITH OGONEK AND MACRON
     Lu,  -- (16#001EE#, 16#001EE#)  LATIN CAPITAL LETTER EZH WITH CARON .. LATIN CAPITAL LETTER EZH WITH CARON
     Ll,  -- (16#001EF#, 16#001F0#)  LATIN SMALL LETTER EZH WITH CARON .. LATIN SMALL LETTER J WITH CARON
     Lu,  -- (16#001F1#, 16#001F1#)  LATIN CAPITAL LETTER DZ .. LATIN CAPITAL LETTER DZ
     Lt,  -- (16#001F2#, 16#001F2#)  LATIN CAPITAL LETTER D WITH SMALL LETTER Z .. LATIN CAPITAL LETTER D WITH SMALL LETTER Z
     Ll,  -- (16#001F3#, 16#001F3#)  LATIN SMALL LETTER DZ .. LATIN SMALL LETTER DZ
     Lu,  -- (16#001F4#, 16#001F4#)  LATIN CAPITAL LETTER G WITH ACUTE .. LATIN CAPITAL LETTER G WITH ACUTE
     Ll,  -- (16#001F5#, 16#001F5#)  LATIN SMALL LETTER G WITH ACUTE .. LATIN SMALL LETTER G WITH ACUTE
     Lu,  -- (16#001F6#, 16#001F8#)  LATIN CAPITAL LETTER HWAIR .. LATIN CAPITAL LETTER N WITH GRAVE
     Ll,  -- (16#001F9#, 16#001F9#)  LATIN SMALL LETTER N WITH GRAVE .. LATIN SMALL LETTER N WITH GRAVE
     Lu,  -- (16#001FA#, 16#001FA#)  LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE .. LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
     Ll,  -- (16#001FB#, 16#001FB#)  LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE .. LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
     Lu,  -- (16#001FC#, 16#001FC#)  LATIN CAPITAL LETTER AE WITH ACUTE .. LATIN CAPITAL LETTER AE WITH ACUTE
     Ll,  -- (16#001FD#, 16#001FD#)  LATIN SMALL LETTER AE WITH ACUTE .. LATIN SMALL LETTER AE WITH ACUTE
     Lu,  -- (16#001FE#, 16#001FE#)  LATIN CAPITAL LETTER O WITH STROKE AND ACUTE .. LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
     Ll,  -- (16#001FF#, 16#001FF#)  LATIN SMALL LETTER O WITH STROKE AND ACUTE .. LATIN SMALL LETTER O WITH STROKE AND ACUTE
     Lu,  -- (16#00200#, 16#00200#)  LATIN CAPITAL LETTER A WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
     Ll,  -- (16#00201#, 16#00201#)  LATIN SMALL LETTER A WITH DOUBLE GRAVE .. LATIN SMALL LETTER A WITH DOUBLE GRAVE
     Lu,  -- (16#00202#, 16#00202#)  LATIN CAPITAL LETTER A WITH INVERTED BREVE .. LATIN CAPITAL LETTER A WITH INVERTED BREVE
     Ll,  -- (16#00203#, 16#00203#)  LATIN SMALL LETTER A WITH INVERTED BREVE .. LATIN SMALL LETTER A WITH INVERTED BREVE
     Lu,  -- (16#00204#, 16#00204#)  LATIN CAPITAL LETTER E WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
     Ll,  -- (16#00205#, 16#00205#)  LATIN SMALL LETTER E WITH DOUBLE GRAVE .. LATIN SMALL LETTER E WITH DOUBLE GRAVE
     Lu,  -- (16#00206#, 16#00206#)  LATIN CAPITAL LETTER E WITH INVERTED BREVE .. LATIN CAPITAL LETTER E WITH INVERTED BREVE
     Ll,  -- (16#00207#, 16#00207#)  LATIN SMALL LETTER E WITH INVERTED BREVE .. LATIN SMALL LETTER E WITH INVERTED BREVE
     Lu,  -- (16#00208#, 16#00208#)  LATIN CAPITAL LETTER I WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
     Ll,  -- (16#00209#, 16#00209#)  LATIN SMALL LETTER I WITH DOUBLE GRAVE .. LATIN SMALL LETTER I WITH DOUBLE GRAVE
     Lu,  -- (16#0020A#, 16#0020A#)  LATIN CAPITAL LETTER I WITH INVERTED BREVE .. LATIN CAPITAL LETTER I WITH INVERTED BREVE
     Ll,  -- (16#0020B#, 16#0020B#)  LATIN SMALL LETTER I WITH INVERTED BREVE .. LATIN SMALL LETTER I WITH INVERTED BREVE
     Lu,  -- (16#0020C#, 16#0020C#)  LATIN CAPITAL LETTER O WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
     Ll,  -- (16#0020D#, 16#0020D#)  LATIN SMALL LETTER O WITH DOUBLE GRAVE .. LATIN SMALL LETTER O WITH DOUBLE GRAVE
     Lu,  -- (16#0020E#, 16#0020E#)  LATIN CAPITAL LETTER O WITH INVERTED BREVE .. LATIN CAPITAL LETTER O WITH INVERTED BREVE
     Ll,  -- (16#0020F#, 16#0020F#)  LATIN SMALL LETTER O WITH INVERTED BREVE .. LATIN SMALL LETTER O WITH INVERTED BREVE
     Lu,  -- (16#00210#, 16#00210#)  LATIN CAPITAL LETTER R WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
     Ll,  -- (16#00211#, 16#00211#)  LATIN SMALL LETTER R WITH DOUBLE GRAVE .. LATIN SMALL LETTER R WITH DOUBLE GRAVE
     Lu,  -- (16#00212#, 16#00212#)  LATIN CAPITAL LETTER R WITH INVERTED BREVE .. LATIN CAPITAL LETTER R WITH INVERTED BREVE
     Ll,  -- (16#00213#, 16#00213#)  LATIN SMALL LETTER R WITH INVERTED BREVE .. LATIN SMALL LETTER R WITH INVERTED BREVE
     Lu,  -- (16#00214#, 16#00214#)  LATIN CAPITAL LETTER U WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
     Ll,  -- (16#00215#, 16#00215#)  LATIN SMALL LETTER U WITH DOUBLE GRAVE .. LATIN SMALL LETTER U WITH DOUBLE GRAVE
     Lu,  -- (16#00216#, 16#00216#)  LATIN CAPITAL LETTER U WITH INVERTED BREVE .. LATIN CAPITAL LETTER U WITH INVERTED BREVE
     Ll,  -- (16#00217#, 16#00217#)  LATIN SMALL LETTER U WITH INVERTED BREVE .. LATIN SMALL LETTER U WITH INVERTED BREVE
     Lu,  -- (16#00218#, 16#00218#)  LATIN CAPITAL LETTER S WITH COMMA BELOW .. LATIN CAPITAL LETTER S WITH COMMA BELOW
     Ll,  -- (16#00219#, 16#00219#)  LATIN SMALL LETTER S WITH COMMA BELOW .. LATIN SMALL LETTER S WITH COMMA BELOW
     Lu,  -- (16#0021A#, 16#0021A#)  LATIN CAPITAL LETTER T WITH COMMA BELOW .. LATIN CAPITAL LETTER T WITH COMMA BELOW
     Ll,  -- (16#0021B#, 16#0021B#)  LATIN SMALL LETTER T WITH COMMA BELOW .. LATIN SMALL LETTER T WITH COMMA BELOW
     Lu,  -- (16#0021C#, 16#0021C#)  LATIN CAPITAL LETTER YOGH .. LATIN CAPITAL LETTER YOGH
     Ll,  -- (16#0021D#, 16#0021D#)  LATIN SMALL LETTER YOGH .. LATIN SMALL LETTER YOGH
     Lu,  -- (16#0021E#, 16#0021E#)  LATIN CAPITAL LETTER H WITH CARON .. LATIN CAPITAL LETTER H WITH CARON
     Ll,  -- (16#0021F#, 16#0021F#)  LATIN SMALL LETTER H WITH CARON .. LATIN SMALL LETTER H WITH CARON
     Lu,  -- (16#00220#, 16#00220#)  LATIN CAPITAL LETTER N WITH LONG RIGHT LEG .. LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
     Ll,  -- (16#00221#, 16#00221#)  LATIN SMALL LETTER D WITH CURL .. LATIN SMALL LETTER D WITH CURL
     Lu,  -- (16#00222#, 16#00222#)  LATIN CAPITAL LETTER OU .. LATIN CAPITAL LETTER OU
     Ll,  -- (16#00223#, 16#00223#)  LATIN SMALL LETTER OU .. LATIN SMALL LETTER OU
     Lu,  -- (16#00224#, 16#00224#)  LATIN CAPITAL LETTER Z WITH HOOK .. LATIN CAPITAL LETTER Z WITH HOOK
     Ll,  -- (16#00225#, 16#00225#)  LATIN SMALL LETTER Z WITH HOOK .. LATIN SMALL LETTER Z WITH HOOK
     Lu,  -- (16#00226#, 16#00226#)  LATIN CAPITAL LETTER A WITH DOT ABOVE .. LATIN CAPITAL LETTER A WITH DOT ABOVE
     Ll,  -- (16#00227#, 16#00227#)  LATIN SMALL LETTER A WITH DOT ABOVE .. LATIN SMALL LETTER A WITH DOT ABOVE
     Lu,  -- (16#00228#, 16#00228#)  LATIN CAPITAL LETTER E WITH CEDILLA .. LATIN CAPITAL LETTER E WITH CEDILLA
     Ll,  -- (16#00229#, 16#00229#)  LATIN SMALL LETTER E WITH CEDILLA .. LATIN SMALL LETTER E WITH CEDILLA
     Lu,  -- (16#0022A#, 16#0022A#)  LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
     Ll,  -- (16#0022B#, 16#0022B#)  LATIN SMALL LETTER O WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
     Lu,  -- (16#0022C#, 16#0022C#)  LATIN CAPITAL LETTER O WITH TILDE AND MACRON .. LATIN CAPITAL LETTER O WITH TILDE AND MACRON
     Ll,  -- (16#0022D#, 16#0022D#)  LATIN SMALL LETTER O WITH TILDE AND MACRON .. LATIN SMALL LETTER O WITH TILDE AND MACRON
     Lu,  -- (16#0022E#, 16#0022E#)  LATIN CAPITAL LETTER O WITH DOT ABOVE .. LATIN CAPITAL LETTER O WITH DOT ABOVE
     Ll,  -- (16#0022F#, 16#0022F#)  LATIN SMALL LETTER O WITH DOT ABOVE .. LATIN SMALL LETTER O WITH DOT ABOVE
     Lu,  -- (16#00230#, 16#00230#)  LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON .. LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
     Ll,  -- (16#00231#, 16#00231#)  LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
     Lu,  -- (16#00232#, 16#00232#)  LATIN CAPITAL LETTER Y WITH MACRON .. LATIN CAPITAL LETTER Y WITH MACRON
     Ll,  -- (16#00233#, 16#00236#)  LATIN SMALL LETTER Y WITH MACRON .. LATIN SMALL LETTER T WITH CURL
     Ll,  -- (16#00250#, 16#002AF#)  LATIN SMALL LETTER TURNED A .. LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
     Lm,  -- (16#002B0#, 16#002C1#)  MODIFIER LETTER SMALL H .. MODIFIER LETTER REVERSED GLOTTAL STOP
     Sk,  -- (16#002C2#, 16#002C5#)  MODIFIER LETTER LEFT ARROWHEAD .. MODIFIER LETTER DOWN ARROWHEAD
     Lm,  -- (16#002C6#, 16#002D1#)  MODIFIER LETTER CIRCUMFLEX ACCENT .. MODIFIER LETTER HALF TRIANGULAR COLON
     Sk,  -- (16#002D2#, 16#002DF#)  MODIFIER LETTER CENTRED RIGHT HALF RING .. MODIFIER LETTER CROSS ACCENT
     Lm,  -- (16#002E0#, 16#002E4#)  MODIFIER LETTER SMALL GAMMA .. MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
     Sk,  -- (16#002E5#, 16#002ED#)  MODIFIER LETTER EXTRA-HIGH TONE BAR .. MODIFIER LETTER UNASPIRATED
     Lm,  -- (16#002EE#, 16#002EE#)  MODIFIER LETTER DOUBLE APOSTROPHE .. MODIFIER LETTER DOUBLE APOSTROPHE
     Sk,  -- (16#002EF#, 16#002FF#)  MODIFIER LETTER LOW DOWN ARROWHEAD .. MODIFIER LETTER LOW LEFT ARROW
     Mn,  -- (16#00300#, 16#00357#)  COMBINING GRAVE ACCENT .. COMBINING RIGHT HALF RING ABOVE
     Mn,  -- (16#0035D#, 16#0036F#)  COMBINING DOUBLE BREVE .. COMBINING LATIN SMALL LETTER X
     Sk,  -- (16#00374#, 16#00375#)  GREEK NUMERAL SIGN .. GREEK LOWER NUMERAL SIGN
     Lm,  -- (16#0037A#, 16#0037A#)  GREEK YPOGEGRAMMENI .. GREEK YPOGEGRAMMENI
     Po,  -- (16#0037E#, 16#0037E#)  GREEK QUESTION MARK .. GREEK QUESTION MARK
     Sk,  -- (16#00384#, 16#00385#)  GREEK TONOS .. GREEK DIALYTIKA TONOS
     Lu,  -- (16#00386#, 16#00386#)  GREEK CAPITAL LETTER ALPHA WITH TONOS .. GREEK CAPITAL LETTER ALPHA WITH TONOS
     Po,  -- (16#00387#, 16#00387#)  GREEK ANO TELEIA .. GREEK ANO TELEIA
     Lu,  -- (16#00388#, 16#0038A#)  GREEK CAPITAL LETTER EPSILON WITH TONOS .. GREEK CAPITAL LETTER IOTA WITH TONOS
     Lu,  -- (16#0038C#, 16#0038C#)  GREEK CAPITAL LETTER OMICRON WITH TONOS .. GREEK CAPITAL LETTER OMICRON WITH TONOS
     Lu,  -- (16#0038E#, 16#0038F#)  GREEK CAPITAL LETTER UPSILON WITH TONOS .. GREEK CAPITAL LETTER OMEGA WITH TONOS
     Ll,  -- (16#00390#, 16#00390#)  GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS .. GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
     Lu,  -- (16#00391#, 16#003A1#)  GREEK CAPITAL LETTER ALPHA .. GREEK CAPITAL LETTER RHO
     Lu,  -- (16#003A3#, 16#003AB#)  GREEK CAPITAL LETTER SIGMA .. GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
     Ll,  -- (16#003AC#, 16#003CE#)  GREEK SMALL LETTER ALPHA WITH TONOS .. GREEK SMALL LETTER OMEGA WITH TONOS
     Ll,  -- (16#003D0#, 16#003D1#)  GREEK BETA SYMBOL .. GREEK THETA SYMBOL
     Lu,  -- (16#003D2#, 16#003D4#)  GREEK UPSILON WITH HOOK SYMBOL .. GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
     Ll,  -- (16#003D5#, 16#003D7#)  GREEK PHI SYMBOL .. GREEK KAI SYMBOL
     Lu,  -- (16#003D8#, 16#003D8#)  GREEK LETTER ARCHAIC KOPPA .. GREEK LETTER ARCHAIC KOPPA
     Ll,  -- (16#003D9#, 16#003D9#)  GREEK SMALL LETTER ARCHAIC KOPPA .. GREEK SMALL LETTER ARCHAIC KOPPA
     Lu,  -- (16#003DA#, 16#003DA#)  GREEK LETTER STIGMA .. GREEK LETTER STIGMA
     Ll,  -- (16#003DB#, 16#003DB#)  GREEK SMALL LETTER STIGMA .. GREEK SMALL LETTER STIGMA
     Lu,  -- (16#003DC#, 16#003DC#)  GREEK LETTER DIGAMMA .. GREEK LETTER DIGAMMA
     Ll,  -- (16#003DD#, 16#003DD#)  GREEK SMALL LETTER DIGAMMA .. GREEK SMALL LETTER DIGAMMA
     Lu,  -- (16#003DE#, 16#003DE#)  GREEK LETTER KOPPA .. GREEK LETTER KOPPA
     Ll,  -- (16#003DF#, 16#003DF#)  GREEK SMALL LETTER KOPPA .. GREEK SMALL LETTER KOPPA
     Lu,  -- (16#003E0#, 16#003E0#)  GREEK LETTER SAMPI .. GREEK LETTER SAMPI
     Ll,  -- (16#003E1#, 16#003E1#)  GREEK SMALL LETTER SAMPI .. GREEK SMALL LETTER SAMPI
     Lu,  -- (16#003E2#, 16#003E2#)  COPTIC CAPITAL LETTER SHEI .. COPTIC CAPITAL LETTER SHEI
     Ll,  -- (16#003E3#, 16#003E3#)  COPTIC SMALL LETTER SHEI .. COPTIC SMALL LETTER SHEI
     Lu,  -- (16#003E4#, 16#003E4#)  COPTIC CAPITAL LETTER FEI .. COPTIC CAPITAL LETTER FEI
     Ll,  -- (16#003E5#, 16#003E5#)  COPTIC SMALL LETTER FEI .. COPTIC SMALL LETTER FEI
     Lu,  -- (16#003E6#, 16#003E6#)  COPTIC CAPITAL LETTER KHEI .. COPTIC CAPITAL LETTER KHEI
     Ll,  -- (16#003E7#, 16#003E7#)  COPTIC SMALL LETTER KHEI .. COPTIC SMALL LETTER KHEI
     Lu,  -- (16#003E8#, 16#003E8#)  COPTIC CAPITAL LETTER HORI .. COPTIC CAPITAL LETTER HORI
     Ll,  -- (16#003E9#, 16#003E9#)  COPTIC SMALL LETTER HORI .. COPTIC SMALL LETTER HORI
     Lu,  -- (16#003EA#, 16#003EA#)  COPTIC CAPITAL LETTER GANGIA .. COPTIC CAPITAL LETTER GANGIA
     Ll,  -- (16#003EB#, 16#003EB#)  COPTIC SMALL LETTER GANGIA .. COPTIC SMALL LETTER GANGIA
     Lu,  -- (16#003EC#, 16#003EC#)  COPTIC CAPITAL LETTER SHIMA .. COPTIC CAPITAL LETTER SHIMA
     Ll,  -- (16#003ED#, 16#003ED#)  COPTIC SMALL LETTER SHIMA .. COPTIC SMALL LETTER SHIMA
     Lu,  -- (16#003EE#, 16#003EE#)  COPTIC CAPITAL LETTER DEI .. COPTIC CAPITAL LETTER DEI
     Ll,  -- (16#003EF#, 16#003F3#)  COPTIC SMALL LETTER DEI .. GREEK LETTER YOT
     Lu,  -- (16#003F4#, 16#003F4#)  GREEK CAPITAL THETA SYMBOL .. GREEK CAPITAL THETA SYMBOL
     Ll,  -- (16#003F5#, 16#003F5#)  GREEK LUNATE EPSILON SYMBOL .. GREEK LUNATE EPSILON SYMBOL
     Sm,  -- (16#003F6#, 16#003F6#)  GREEK REVERSED LUNATE EPSILON SYMBOL .. GREEK REVERSED LUNATE EPSILON SYMBOL
     Lu,  -- (16#003F7#, 16#003F7#)  GREEK CAPITAL LETTER SHO .. GREEK CAPITAL LETTER SHO
     Ll,  -- (16#003F8#, 16#003F8#)  GREEK SMALL LETTER SHO .. GREEK SMALL LETTER SHO
     Lu,  -- (16#003F9#, 16#003FA#)  GREEK CAPITAL LUNATE SIGMA SYMBOL .. GREEK CAPITAL LETTER SAN
     Ll,  -- (16#003FB#, 16#003FB#)  GREEK SMALL LETTER SAN .. GREEK SMALL LETTER SAN
     Lu,  -- (16#00400#, 16#0042F#)  CYRILLIC CAPITAL LETTER IE WITH GRAVE .. CYRILLIC CAPITAL LETTER YA
     Ll,  -- (16#00430#, 16#0045F#)  CYRILLIC SMALL LETTER A .. CYRILLIC SMALL LETTER DZHE
     Lu,  -- (16#00460#, 16#00460#)  CYRILLIC CAPITAL LETTER OMEGA .. CYRILLIC CAPITAL LETTER OMEGA
     Ll,  -- (16#00461#, 16#00461#)  CYRILLIC SMALL LETTER OMEGA .. CYRILLIC SMALL LETTER OMEGA
     Lu,  -- (16#00462#, 16#00462#)  CYRILLIC CAPITAL LETTER YAT .. CYRILLIC CAPITAL LETTER YAT
     Ll,  -- (16#00463#, 16#00463#)  CYRILLIC SMALL LETTER YAT .. CYRILLIC SMALL LETTER YAT
     Lu,  -- (16#00464#, 16#00464#)  CYRILLIC CAPITAL LETTER IOTIFIED E .. CYRILLIC CAPITAL LETTER IOTIFIED E
     Ll,  -- (16#00465#, 16#00465#)  CYRILLIC SMALL LETTER IOTIFIED E .. CYRILLIC SMALL LETTER IOTIFIED E
     Lu,  -- (16#00466#, 16#00466#)  CYRILLIC CAPITAL LETTER LITTLE YUS .. CYRILLIC CAPITAL LETTER LITTLE YUS
     Ll,  -- (16#00467#, 16#00467#)  CYRILLIC SMALL LETTER LITTLE YUS .. CYRILLIC SMALL LETTER LITTLE YUS
     Lu,  -- (16#00468#, 16#00468#)  CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS .. CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
     Ll,  -- (16#00469#, 16#00469#)  CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS .. CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
     Lu,  -- (16#0046A#, 16#0046A#)  CYRILLIC CAPITAL LETTER BIG YUS .. CYRILLIC CAPITAL LETTER BIG YUS
     Ll,  -- (16#0046B#, 16#0046B#)  CYRILLIC SMALL LETTER BIG YUS .. CYRILLIC SMALL LETTER BIG YUS
     Lu,  -- (16#0046C#, 16#0046C#)  CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS .. CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
     Ll,  -- (16#0046D#, 16#0046D#)  CYRILLIC SMALL LETTER IOTIFIED BIG YUS .. CYRILLIC SMALL LETTER IOTIFIED BIG YUS
     Lu,  -- (16#0046E#, 16#0046E#)  CYRILLIC CAPITAL LETTER KSI .. CYRILLIC CAPITAL LETTER KSI
     Ll,  -- (16#0046F#, 16#0046F#)  CYRILLIC SMALL LETTER KSI .. CYRILLIC SMALL LETTER KSI
     Lu,  -- (16#00470#, 16#00470#)  CYRILLIC CAPITAL LETTER PSI .. CYRILLIC CAPITAL LETTER PSI
     Ll,  -- (16#00471#, 16#00471#)  CYRILLIC SMALL LETTER PSI .. CYRILLIC SMALL LETTER PSI
     Lu,  -- (16#00472#, 16#00472#)  CYRILLIC CAPITAL LETTER FITA .. CYRILLIC CAPITAL LETTER FITA
     Ll,  -- (16#00473#, 16#00473#)  CYRILLIC SMALL LETTER FITA .. CYRILLIC SMALL LETTER FITA
     Lu,  -- (16#00474#, 16#00474#)  CYRILLIC CAPITAL LETTER IZHITSA .. CYRILLIC CAPITAL LETTER IZHITSA
     Ll,  -- (16#00475#, 16#00475#)  CYRILLIC SMALL LETTER IZHITSA .. CYRILLIC SMALL LETTER IZHITSA
     Lu,  -- (16#00476#, 16#00476#)  CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
     Ll,  -- (16#00477#, 16#00477#)  CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
     Lu,  -- (16#00478#, 16#00478#)  CYRILLIC CAPITAL LETTER UK .. CYRILLIC CAPITAL LETTER UK
     Ll,  -- (16#00479#, 16#00479#)  CYRILLIC SMALL LETTER UK .. CYRILLIC SMALL LETTER UK
     Lu,  -- (16#0047A#, 16#0047A#)  CYRILLIC CAPITAL LETTER ROUND OMEGA .. CYRILLIC CAPITAL LETTER ROUND OMEGA
     Ll,  -- (16#0047B#, 16#0047B#)  CYRILLIC SMALL LETTER ROUND OMEGA .. CYRILLIC SMALL LETTER ROUND OMEGA
     Lu,  -- (16#0047C#, 16#0047C#)  CYRILLIC CAPITAL LETTER OMEGA WITH TITLO .. CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
     Ll,  -- (16#0047D#, 16#0047D#)  CYRILLIC SMALL LETTER OMEGA WITH TITLO .. CYRILLIC SMALL LETTER OMEGA WITH TITLO
     Lu,  -- (16#0047E#, 16#0047E#)  CYRILLIC CAPITAL LETTER OT .. CYRILLIC CAPITAL LETTER OT
     Ll,  -- (16#0047F#, 16#0047F#)  CYRILLIC SMALL LETTER OT .. CYRILLIC SMALL LETTER OT
     Lu,  -- (16#00480#, 16#00480#)  CYRILLIC CAPITAL LETTER KOPPA .. CYRILLIC CAPITAL LETTER KOPPA
     Ll,  -- (16#00481#, 16#00481#)  CYRILLIC SMALL LETTER KOPPA .. CYRILLIC SMALL LETTER KOPPA
     So,  -- (16#00482#, 16#00482#)  CYRILLIC THOUSANDS SIGN .. CYRILLIC THOUSANDS SIGN
     Mn,  -- (16#00483#, 16#00486#)  COMBINING CYRILLIC TITLO .. COMBINING CYRILLIC PSILI PNEUMATA
     Me,  -- (16#00488#, 16#00489#)  COMBINING CYRILLIC HUNDRED THOUSANDS SIGN .. COMBINING CYRILLIC MILLIONS SIGN
     Lu,  -- (16#0048A#, 16#0048A#)  CYRILLIC CAPITAL LETTER SHORT I WITH TAIL .. CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
     Ll,  -- (16#0048B#, 16#0048B#)  CYRILLIC SMALL LETTER SHORT I WITH TAIL .. CYRILLIC SMALL LETTER SHORT I WITH TAIL
     Lu,  -- (16#0048C#, 16#0048C#)  CYRILLIC CAPITAL LETTER SEMISOFT SIGN .. CYRILLIC CAPITAL LETTER SEMISOFT SIGN
     Ll,  -- (16#0048D#, 16#0048D#)  CYRILLIC SMALL LETTER SEMISOFT SIGN .. CYRILLIC SMALL LETTER SEMISOFT SIGN
     Lu,  -- (16#0048E#, 16#0048E#)  CYRILLIC CAPITAL LETTER ER WITH TICK .. CYRILLIC CAPITAL LETTER ER WITH TICK
     Ll,  -- (16#0048F#, 16#0048F#)  CYRILLIC SMALL LETTER ER WITH TICK .. CYRILLIC SMALL LETTER ER WITH TICK
     Lu,  -- (16#00490#, 16#00490#)  CYRILLIC CAPITAL LETTER GHE WITH UPTURN .. CYRILLIC CAPITAL LETTER GHE WITH UPTURN
     Ll,  -- (16#00491#, 16#00491#)  CYRILLIC SMALL LETTER GHE WITH UPTURN .. CYRILLIC SMALL LETTER GHE WITH UPTURN
     Lu,  -- (16#00492#, 16#00492#)  CYRILLIC CAPITAL LETTER GHE WITH STROKE .. CYRILLIC CAPITAL LETTER GHE WITH STROKE
     Ll,  -- (16#00493#, 16#00493#)  CYRILLIC SMALL LETTER GHE WITH STROKE .. CYRILLIC SMALL LETTER GHE WITH STROKE
     Lu,  -- (16#00494#, 16#00494#)  CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
     Ll,  -- (16#00495#, 16#00495#)  CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
     Lu,  -- (16#00496#, 16#00496#)  CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
     Ll,  -- (16#00497#, 16#00497#)  CYRILLIC SMALL LETTER ZHE WITH DESCENDER .. CYRILLIC SMALL LETTER ZHE WITH DESCENDER
     Lu,  -- (16#00498#, 16#00498#)  CYRILLIC CAPITAL LETTER ZE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
     Ll,  -- (16#00499#, 16#00499#)  CYRILLIC SMALL LETTER ZE WITH DESCENDER .. CYRILLIC SMALL LETTER ZE WITH DESCENDER
     Lu,  -- (16#0049A#, 16#0049A#)  CYRILLIC CAPITAL LETTER KA WITH DESCENDER .. CYRILLIC CAPITAL LETTER KA WITH DESCENDER
     Ll,  -- (16#0049B#, 16#0049B#)  CYRILLIC SMALL LETTER KA WITH DESCENDER .. CYRILLIC SMALL LETTER KA WITH DESCENDER
     Lu,  -- (16#0049C#, 16#0049C#)  CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE .. CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
     Ll,  -- (16#0049D#, 16#0049D#)  CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
     Lu,  -- (16#0049E#, 16#0049E#)  CYRILLIC CAPITAL LETTER KA WITH STROKE .. CYRILLIC CAPITAL LETTER KA WITH STROKE
     Ll,  -- (16#0049F#, 16#0049F#)  CYRILLIC SMALL LETTER KA WITH STROKE .. CYRILLIC SMALL LETTER KA WITH STROKE
     Lu,  -- (16#004A0#, 16#004A0#)  CYRILLIC CAPITAL LETTER BASHKIR KA .. CYRILLIC CAPITAL LETTER BASHKIR KA
     Ll,  -- (16#004A1#, 16#004A1#)  CYRILLIC SMALL LETTER BASHKIR KA .. CYRILLIC SMALL LETTER BASHKIR KA
     Lu,  -- (16#004A2#, 16#004A2#)  CYRILLIC CAPITAL LETTER EN WITH DESCENDER .. CYRILLIC CAPITAL LETTER EN WITH DESCENDER
     Ll,  -- (16#004A3#, 16#004A3#)  CYRILLIC SMALL LETTER EN WITH DESCENDER .. CYRILLIC SMALL LETTER EN WITH DESCENDER
     Lu,  -- (16#004A4#, 16#004A4#)  CYRILLIC CAPITAL LIGATURE EN GHE .. CYRILLIC CAPITAL LIGATURE EN GHE
     Ll,  -- (16#004A5#, 16#004A5#)  CYRILLIC SMALL LIGATURE EN GHE .. CYRILLIC SMALL LIGATURE EN GHE
     Lu,  -- (16#004A6#, 16#004A6#)  CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK .. CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
     Ll,  -- (16#004A7#, 16#004A7#)  CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
     Lu,  -- (16#004A8#, 16#004A8#)  CYRILLIC CAPITAL LETTER ABKHASIAN HA .. CYRILLIC CAPITAL LETTER ABKHASIAN HA
     Ll,  -- (16#004A9#, 16#004A9#)  CYRILLIC SMALL LETTER ABKHASIAN HA .. CYRILLIC SMALL LETTER ABKHASIAN HA
     Lu,  -- (16#004AA#, 16#004AA#)  CYRILLIC CAPITAL LETTER ES WITH DESCENDER .. CYRILLIC CAPITAL LETTER ES WITH DESCENDER
     Ll,  -- (16#004AB#, 16#004AB#)  CYRILLIC SMALL LETTER ES WITH DESCENDER .. CYRILLIC SMALL LETTER ES WITH DESCENDER
     Lu,  -- (16#004AC#, 16#004AC#)  CYRILLIC CAPITAL LETTER TE WITH DESCENDER .. CYRILLIC CAPITAL LETTER TE WITH DESCENDER
     Ll,  -- (16#004AD#, 16#004AD#)  CYRILLIC SMALL LETTER TE WITH DESCENDER .. CYRILLIC SMALL LETTER TE WITH DESCENDER
     Lu,  -- (16#004AE#, 16#004AE#)  CYRILLIC CAPITAL LETTER STRAIGHT U .. CYRILLIC CAPITAL LETTER STRAIGHT U
     Ll,  -- (16#004AF#, 16#004AF#)  CYRILLIC SMALL LETTER STRAIGHT U .. CYRILLIC SMALL LETTER STRAIGHT U
     Lu,  -- (16#004B0#, 16#004B0#)  CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE .. CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
     Ll,  -- (16#004B1#, 16#004B1#)  CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE .. CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
     Lu,  -- (16#004B2#, 16#004B2#)  CYRILLIC CAPITAL LETTER HA WITH DESCENDER .. CYRILLIC CAPITAL LETTER HA WITH DESCENDER
     Ll,  -- (16#004B3#, 16#004B3#)  CYRILLIC SMALL LETTER HA WITH DESCENDER .. CYRILLIC SMALL LETTER HA WITH DESCENDER
     Lu,  -- (16#004B4#, 16#004B4#)  CYRILLIC CAPITAL LIGATURE TE TSE .. CYRILLIC CAPITAL LIGATURE TE TSE
     Ll,  -- (16#004B5#, 16#004B5#)  CYRILLIC SMALL LIGATURE TE TSE .. CYRILLIC SMALL LIGATURE TE TSE
     Lu,  -- (16#004B6#, 16#004B6#)  CYRILLIC CAPITAL LETTER CHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
     Ll,  -- (16#004B7#, 16#004B7#)  CYRILLIC SMALL LETTER CHE WITH DESCENDER .. CYRILLIC SMALL LETTER CHE WITH DESCENDER
     Lu,  -- (16#004B8#, 16#004B8#)  CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
     Ll,  -- (16#004B9#, 16#004B9#)  CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
     Lu,  -- (16#004BA#, 16#004BA#)  CYRILLIC CAPITAL LETTER SHHA .. CYRILLIC CAPITAL LETTER SHHA
     Ll,  -- (16#004BB#, 16#004BB#)  CYRILLIC SMALL LETTER SHHA .. CYRILLIC SMALL LETTER SHHA
     Lu,  -- (16#004BC#, 16#004BC#)  CYRILLIC CAPITAL LETTER ABKHASIAN CHE .. CYRILLIC CAPITAL LETTER ABKHASIAN CHE
     Ll,  -- (16#004BD#, 16#004BD#)  CYRILLIC SMALL LETTER ABKHASIAN CHE .. CYRILLIC SMALL LETTER ABKHASIAN CHE
     Lu,  -- (16#004BE#, 16#004BE#)  CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
     Ll,  -- (16#004BF#, 16#004BF#)  CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
     Lu,  -- (16#004C0#, 16#004C1#)  CYRILLIC LETTER PALOCHKA .. CYRILLIC CAPITAL LETTER ZHE WITH BREVE
     Ll,  -- (16#004C2#, 16#004C2#)  CYRILLIC SMALL LETTER ZHE WITH BREVE .. CYRILLIC SMALL LETTER ZHE WITH BREVE
     Lu,  -- (16#004C3#, 16#004C3#)  CYRILLIC CAPITAL LETTER KA WITH HOOK .. CYRILLIC CAPITAL LETTER KA WITH HOOK
     Ll,  -- (16#004C4#, 16#004C4#)  CYRILLIC SMALL LETTER KA WITH HOOK .. CYRILLIC SMALL LETTER KA WITH HOOK
     Lu,  -- (16#004C5#, 16#004C5#)  CYRILLIC CAPITAL LETTER EL WITH TAIL .. CYRILLIC CAPITAL LETTER EL WITH TAIL
     Ll,  -- (16#004C6#, 16#004C6#)  CYRILLIC SMALL LETTER EL WITH TAIL .. CYRILLIC SMALL LETTER EL WITH TAIL
     Lu,  -- (16#004C7#, 16#004C7#)  CYRILLIC CAPITAL LETTER EN WITH HOOK .. CYRILLIC CAPITAL LETTER EN WITH HOOK
     Ll,  -- (16#004C8#, 16#004C8#)  CYRILLIC SMALL LETTER EN WITH HOOK .. CYRILLIC SMALL LETTER EN WITH HOOK
     Lu,  -- (16#004C9#, 16#004C9#)  CYRILLIC CAPITAL LETTER EN WITH TAIL .. CYRILLIC CAPITAL LETTER EN WITH TAIL
     Ll,  -- (16#004CA#, 16#004CA#)  CYRILLIC SMALL LETTER EN WITH TAIL .. CYRILLIC SMALL LETTER EN WITH TAIL
     Lu,  -- (16#004CB#, 16#004CB#)  CYRILLIC CAPITAL LETTER KHAKASSIAN CHE .. CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
     Ll,  -- (16#004CC#, 16#004CC#)  CYRILLIC SMALL LETTER KHAKASSIAN CHE .. CYRILLIC SMALL LETTER KHAKASSIAN CHE
     Lu,  -- (16#004CD#, 16#004CD#)  CYRILLIC CAPITAL LETTER EM WITH TAIL .. CYRILLIC CAPITAL LETTER EM WITH TAIL
     Ll,  -- (16#004CE#, 16#004CE#)  CYRILLIC SMALL LETTER EM WITH TAIL .. CYRILLIC SMALL LETTER EM WITH TAIL
     Lu,  -- (16#004D0#, 16#004D0#)  CYRILLIC CAPITAL LETTER A WITH BREVE .. CYRILLIC CAPITAL LETTER A WITH BREVE
     Ll,  -- (16#004D1#, 16#004D1#)  CYRILLIC SMALL LETTER A WITH BREVE .. CYRILLIC SMALL LETTER A WITH BREVE
     Lu,  -- (16#004D2#, 16#004D2#)  CYRILLIC CAPITAL LETTER A WITH DIAERESIS .. CYRILLIC CAPITAL LETTER A WITH DIAERESIS
     Ll,  -- (16#004D3#, 16#004D3#)  CYRILLIC SMALL LETTER A WITH DIAERESIS .. CYRILLIC SMALL LETTER A WITH DIAERESIS
     Lu,  -- (16#004D4#, 16#004D4#)  CYRILLIC CAPITAL LIGATURE A IE .. CYRILLIC CAPITAL LIGATURE A IE
     Ll,  -- (16#004D5#, 16#004D5#)  CYRILLIC SMALL LIGATURE A IE .. CYRILLIC SMALL LIGATURE A IE
     Lu,  -- (16#004D6#, 16#004D6#)  CYRILLIC CAPITAL LETTER IE WITH BREVE .. CYRILLIC CAPITAL LETTER IE WITH BREVE
     Ll,  -- (16#004D7#, 16#004D7#)  CYRILLIC SMALL LETTER IE WITH BREVE .. CYRILLIC SMALL LETTER IE WITH BREVE
     Lu,  -- (16#004D8#, 16#004D8#)  CYRILLIC CAPITAL LETTER SCHWA .. CYRILLIC CAPITAL LETTER SCHWA
     Ll,  -- (16#004D9#, 16#004D9#)  CYRILLIC SMALL LETTER SCHWA .. CYRILLIC SMALL LETTER SCHWA
     Lu,  -- (16#004DA#, 16#004DA#)  CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS .. CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
     Ll,  -- (16#004DB#, 16#004DB#)  CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS .. CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
     Lu,  -- (16#004DC#, 16#004DC#)  CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
     Ll,  -- (16#004DD#, 16#004DD#)  CYRILLIC SMALL LETTER ZHE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
     Lu,  -- (16#004DE#, 16#004DE#)  CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
     Ll,  -- (16#004DF#, 16#004DF#)  CYRILLIC SMALL LETTER ZE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZE WITH DIAERESIS
     Lu,  -- (16#004E0#, 16#004E0#)  CYRILLIC CAPITAL LETTER ABKHASIAN DZE .. CYRILLIC CAPITAL LETTER ABKHASIAN DZE
     Ll,  -- (16#004E1#, 16#004E1#)  CYRILLIC SMALL LETTER ABKHASIAN DZE .. CYRILLIC SMALL LETTER ABKHASIAN DZE
     Lu,  -- (16#004E2#, 16#004E2#)  CYRILLIC CAPITAL LETTER I WITH MACRON .. CYRILLIC CAPITAL LETTER I WITH MACRON
     Ll,  -- (16#004E3#, 16#004E3#)  CYRILLIC SMALL LETTER I WITH MACRON .. CYRILLIC SMALL LETTER I WITH MACRON
     Lu,  -- (16#004E4#, 16#004E4#)  CYRILLIC CAPITAL LETTER I WITH DIAERESIS .. CYRILLIC CAPITAL LETTER I WITH DIAERESIS
     Ll,  -- (16#004E5#, 16#004E5#)  CYRILLIC SMALL LETTER I WITH DIAERESIS .. CYRILLIC SMALL LETTER I WITH DIAERESIS
     Lu,  -- (16#004E6#, 16#004E6#)  CYRILLIC CAPITAL LETTER O WITH DIAERESIS .. CYRILLIC CAPITAL LETTER O WITH DIAERESIS
     Ll,  -- (16#004E7#, 16#004E7#)  CYRILLIC SMALL LETTER O WITH DIAERESIS .. CYRILLIC SMALL LETTER O WITH DIAERESIS
     Lu,  -- (16#004E8#, 16#004E8#)  CYRILLIC CAPITAL LETTER BARRED O .. CYRILLIC CAPITAL LETTER BARRED O
     Ll,  -- (16#004E9#, 16#004E9#)  CYRILLIC SMALL LETTER BARRED O .. CYRILLIC SMALL LETTER BARRED O
     Lu,  -- (16#004EA#, 16#004EA#)  CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS .. CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
     Ll,  -- (16#004EB#, 16#004EB#)  CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS .. CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
     Lu,  -- (16#004EC#, 16#004EC#)  CYRILLIC CAPITAL LETTER E WITH DIAERESIS .. CYRILLIC CAPITAL LETTER E WITH DIAERESIS
     Ll,  -- (16#004ED#, 16#004ED#)  CYRILLIC SMALL LETTER E WITH DIAERESIS .. CYRILLIC SMALL LETTER E WITH DIAERESIS
     Lu,  -- (16#004EE#, 16#004EE#)  CYRILLIC CAPITAL LETTER U WITH MACRON .. CYRILLIC CAPITAL LETTER U WITH MACRON
     Ll,  -- (16#004EF#, 16#004EF#)  CYRILLIC SMALL LETTER U WITH MACRON .. CYRILLIC SMALL LETTER U WITH MACRON
     Lu,  -- (16#004F0#, 16#004F0#)  CYRILLIC CAPITAL LETTER U WITH DIAERESIS .. CYRILLIC CAPITAL LETTER U WITH DIAERESIS
     Ll,  -- (16#004F1#, 16#004F1#)  CYRILLIC SMALL LETTER U WITH DIAERESIS .. CYRILLIC SMALL LETTER U WITH DIAERESIS
     Lu,  -- (16#004F2#, 16#004F2#)  CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE .. CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
     Ll,  -- (16#004F3#, 16#004F3#)  CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE .. CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
     Lu,  -- (16#004F4#, 16#004F4#)  CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
     Ll,  -- (16#004F5#, 16#004F5#)  CYRILLIC SMALL LETTER CHE WITH DIAERESIS .. CYRILLIC SMALL LETTER CHE WITH DIAERESIS
     Lu,  -- (16#004F8#, 16#004F8#)  CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS .. CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
     Ll,  -- (16#004F9#, 16#004F9#)  CYRILLIC SMALL LETTER YERU WITH DIAERESIS .. CYRILLIC SMALL LETTER YERU WITH DIAERESIS
     Lu,  -- (16#00500#, 16#00500#)  CYRILLIC CAPITAL LETTER KOMI DE .. CYRILLIC CAPITAL LETTER KOMI DE
     Ll,  -- (16#00501#, 16#00501#)  CYRILLIC SMALL LETTER KOMI DE .. CYRILLIC SMALL LETTER KOMI DE
     Lu,  -- (16#00502#, 16#00502#)  CYRILLIC CAPITAL LETTER KOMI DJE .. CYRILLIC CAPITAL LETTER KOMI DJE
     Ll,  -- (16#00503#, 16#00503#)  CYRILLIC SMALL LETTER KOMI DJE .. CYRILLIC SMALL LETTER KOMI DJE
     Lu,  -- (16#00504#, 16#00504#)  CYRILLIC CAPITAL LETTER KOMI ZJE .. CYRILLIC CAPITAL LETTER KOMI ZJE
     Ll,  -- (16#00505#, 16#00505#)  CYRILLIC SMALL LETTER KOMI ZJE .. CYRILLIC SMALL LETTER KOMI ZJE
     Lu,  -- (16#00506#, 16#00506#)  CYRILLIC CAPITAL LETTER KOMI DZJE .. CYRILLIC CAPITAL LETTER KOMI DZJE
     Ll,  -- (16#00507#, 16#00507#)  CYRILLIC SMALL LETTER KOMI DZJE .. CYRILLIC SMALL LETTER KOMI DZJE
     Lu,  -- (16#00508#, 16#00508#)  CYRILLIC CAPITAL LETTER KOMI LJE .. CYRILLIC CAPITAL LETTER KOMI LJE
     Ll,  -- (16#00509#, 16#00509#)  CYRILLIC SMALL LETTER KOMI LJE .. CYRILLIC SMALL LETTER KOMI LJE
     Lu,  -- (16#0050A#, 16#0050A#)  CYRILLIC CAPITAL LETTER KOMI NJE .. CYRILLIC CAPITAL LETTER KOMI NJE
     Ll,  -- (16#0050B#, 16#0050B#)  CYRILLIC SMALL LETTER KOMI NJE .. CYRILLIC SMALL LETTER KOMI NJE
     Lu,  -- (16#0050C#, 16#0050C#)  CYRILLIC CAPITAL LETTER KOMI SJE .. CYRILLIC CAPITAL LETTER KOMI SJE
     Ll,  -- (16#0050D#, 16#0050D#)  CYRILLIC SMALL LETTER KOMI SJE .. CYRILLIC SMALL LETTER KOMI SJE
     Lu,  -- (16#0050E#, 16#0050E#)  CYRILLIC CAPITAL LETTER KOMI TJE .. CYRILLIC CAPITAL LETTER KOMI TJE
     Ll,  -- (16#0050F#, 16#0050F#)  CYRILLIC SMALL LETTER KOMI TJE .. CYRILLIC SMALL LETTER KOMI TJE
     Lu,  -- (16#00531#, 16#00556#)  ARMENIAN CAPITAL LETTER AYB .. ARMENIAN CAPITAL LETTER FEH
     Lm,  -- (16#00559#, 16#00559#)  ARMENIAN MODIFIER LETTER LEFT HALF RING .. ARMENIAN MODIFIER LETTER LEFT HALF RING
     Po,  -- (16#0055A#, 16#0055F#)  ARMENIAN APOSTROPHE .. ARMENIAN ABBREVIATION MARK
     Ll,  -- (16#00561#, 16#00587#)  ARMENIAN SMALL LETTER AYB .. ARMENIAN SMALL LIGATURE ECH YIWN
     Po,  -- (16#00589#, 16#00589#)  ARMENIAN FULL STOP .. ARMENIAN FULL STOP
     Pd,  -- (16#0058A#, 16#0058A#)  ARMENIAN HYPHEN .. ARMENIAN HYPHEN
     Mn,  -- (16#00591#, 16#005A1#)  HEBREW ACCENT ETNAHTA .. HEBREW ACCENT PAZER
     Mn,  -- (16#005A3#, 16#005B9#)  HEBREW ACCENT MUNAH .. HEBREW POINT HOLAM
     Mn,  -- (16#005BB#, 16#005BD#)  HEBREW POINT QUBUTS .. HEBREW POINT METEG
     Po,  -- (16#005BE#, 16#005BE#)  HEBREW PUNCTUATION MAQAF .. HEBREW PUNCTUATION MAQAF
     Mn,  -- (16#005BF#, 16#005BF#)  HEBREW POINT RAFE .. HEBREW POINT RAFE
     Po,  -- (16#005C0#, 16#005C0#)  HEBREW PUNCTUATION PASEQ .. HEBREW PUNCTUATION PASEQ
     Mn,  -- (16#005C1#, 16#005C2#)  HEBREW POINT SHIN DOT .. HEBREW POINT SIN DOT
     Po,  -- (16#005C3#, 16#005C3#)  HEBREW PUNCTUATION SOF PASUQ .. HEBREW PUNCTUATION SOF PASUQ
     Mn,  -- (16#005C4#, 16#005C4#)  HEBREW MARK UPPER DOT .. HEBREW MARK UPPER DOT
     Lo,  -- (16#005D0#, 16#005EA#)  HEBREW LETTER ALEF .. HEBREW LETTER TAV
     Lo,  -- (16#005F0#, 16#005F2#)  HEBREW LIGATURE YIDDISH DOUBLE VAV .. HEBREW LIGATURE YIDDISH DOUBLE YOD
     Po,  -- (16#005F3#, 16#005F4#)  HEBREW PUNCTUATION GERESH .. HEBREW PUNCTUATION GERSHAYIM
     Cf,  -- (16#00600#, 16#00603#)  ARABIC NUMBER SIGN .. ARABIC SIGN SAFHA
     Po,  -- (16#0060C#, 16#0060D#)  ARABIC COMMA .. ARABIC DATE SEPARATOR
     So,  -- (16#0060E#, 16#0060F#)  ARABIC POETIC VERSE SIGN .. ARABIC SIGN MISRA
     Mn,  -- (16#00610#, 16#00615#)  ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM .. ARABIC SMALL HIGH TAH
     Po,  -- (16#0061B#, 16#0061B#)  ARABIC SEMICOLON .. ARABIC SEMICOLON
     Po,  -- (16#0061F#, 16#0061F#)  ARABIC QUESTION MARK .. ARABIC QUESTION MARK
     Lo,  -- (16#00621#, 16#0063A#)  ARABIC LETTER HAMZA .. ARABIC LETTER GHAIN
     Lm,  -- (16#00640#, 16#00640#)  ARABIC TATWEEL .. ARABIC TATWEEL
     Lo,  -- (16#00641#, 16#0064A#)  ARABIC LETTER FEH .. ARABIC LETTER YEH
     Mn,  -- (16#0064B#, 16#00658#)  ARABIC FATHATAN .. ARABIC MARK NOON GHUNNA
     Nd,  -- (16#00660#, 16#00669#)  ARABIC-INDIC DIGIT ZERO .. ARABIC-INDIC DIGIT NINE
     Po,  -- (16#0066A#, 16#0066D#)  ARABIC PERCENT SIGN .. ARABIC FIVE POINTED STAR
     Lo,  -- (16#0066E#, 16#0066F#)  ARABIC LETTER DOTLESS BEH .. ARABIC LETTER DOTLESS QAF
     Mn,  -- (16#00670#, 16#00670#)  ARABIC LETTER SUPERSCRIPT ALEF .. ARABIC LETTER SUPERSCRIPT ALEF
     Lo,  -- (16#00671#, 16#006D3#)  ARABIC LETTER ALEF WASLA .. ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
     Po,  -- (16#006D4#, 16#006D4#)  ARABIC FULL STOP .. ARABIC FULL STOP
     Lo,  -- (16#006D5#, 16#006D5#)  ARABIC LETTER AE .. ARABIC LETTER AE
     Mn,  -- (16#006D6#, 16#006DC#)  ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA .. ARABIC SMALL HIGH SEEN
     Cf,  -- (16#006DD#, 16#006DD#)  ARABIC END OF AYAH .. ARABIC END OF AYAH
     Me,  -- (16#006DE#, 16#006DE#)  ARABIC START OF RUB EL HIZB .. ARABIC START OF RUB EL HIZB
     Mn,  -- (16#006DF#, 16#006E4#)  ARABIC SMALL HIGH ROUNDED ZERO .. ARABIC SMALL HIGH MADDA
     Lm,  -- (16#006E5#, 16#006E6#)  ARABIC SMALL WAW .. ARABIC SMALL YEH
     Mn,  -- (16#006E7#, 16#006E8#)  ARABIC SMALL HIGH YEH .. ARABIC SMALL HIGH NOON
     So,  -- (16#006E9#, 16#006E9#)  ARABIC PLACE OF SAJDAH .. ARABIC PLACE OF SAJDAH
     Mn,  -- (16#006EA#, 16#006ED#)  ARABIC EMPTY CENTRE LOW STOP .. ARABIC SMALL LOW MEEM
     Lo,  -- (16#006EE#, 16#006EF#)  ARABIC LETTER DAL WITH INVERTED V .. ARABIC LETTER REH WITH INVERTED V
     Nd,  -- (16#006F0#, 16#006F9#)  EXTENDED ARABIC-INDIC DIGIT ZERO .. EXTENDED ARABIC-INDIC DIGIT NINE
     Lo,  -- (16#006FA#, 16#006FC#)  ARABIC LETTER SHEEN WITH DOT BELOW .. ARABIC LETTER GHAIN WITH DOT BELOW
     So,  -- (16#006FD#, 16#006FE#)  ARABIC SIGN SINDHI AMPERSAND .. ARABIC SIGN SINDHI POSTPOSITION MEN
     Lo,  -- (16#006FF#, 16#006FF#)  ARABIC LETTER HEH WITH INVERTED V .. ARABIC LETTER HEH WITH INVERTED V
     Po,  -- (16#00700#, 16#0070D#)  SYRIAC END OF PARAGRAPH .. SYRIAC HARKLEAN ASTERISCUS
     Cf,  -- (16#0070F#, 16#0070F#)  SYRIAC ABBREVIATION MARK .. SYRIAC ABBREVIATION MARK
     Lo,  -- (16#00710#, 16#00710#)  SYRIAC LETTER ALAPH .. SYRIAC LETTER ALAPH
     Mn,  -- (16#00711#, 16#00711#)  SYRIAC LETTER SUPERSCRIPT ALAPH .. SYRIAC LETTER SUPERSCRIPT ALAPH
     Lo,  -- (16#00712#, 16#0072F#)  SYRIAC LETTER BETH .. SYRIAC LETTER PERSIAN DHALATH
     Mn,  -- (16#00730#, 16#0074A#)  SYRIAC PTHAHA ABOVE .. SYRIAC BARREKH
     Lo,  -- (16#0074D#, 16#0074F#)  SYRIAC LETTER SOGDIAN ZHAIN .. SYRIAC LETTER SOGDIAN FE
     Lo,  -- (16#00780#, 16#007A5#)  THAANA LETTER HAA .. THAANA LETTER WAAVU
     Mn,  -- (16#007A6#, 16#007B0#)  THAANA ABAFILI .. THAANA SUKUN
     Lo,  -- (16#007B1#, 16#007B1#)  THAANA LETTER NAA .. THAANA LETTER NAA
     Mn,  -- (16#00901#, 16#00902#)  DEVANAGARI SIGN CANDRABINDU .. DEVANAGARI SIGN ANUSVARA
     Mc,  -- (16#00903#, 16#00903#)  DEVANAGARI SIGN VISARGA .. DEVANAGARI SIGN VISARGA
     Lo,  -- (16#00904#, 16#00939#)  DEVANAGARI LETTER SHORT A .. DEVANAGARI LETTER HA
     Mn,  -- (16#0093C#, 16#0093C#)  DEVANAGARI SIGN NUKTA .. DEVANAGARI SIGN NUKTA
     Lo,  -- (16#0093D#, 16#0093D#)  DEVANAGARI SIGN AVAGRAHA .. DEVANAGARI SIGN AVAGRAHA
     Mc,  -- (16#0093E#, 16#00940#)  DEVANAGARI VOWEL SIGN AA .. DEVANAGARI VOWEL SIGN II
     Mn,  -- (16#00941#, 16#00948#)  DEVANAGARI VOWEL SIGN U .. DEVANAGARI VOWEL SIGN AI
     Mc,  -- (16#00949#, 16#0094C#)  DEVANAGARI VOWEL SIGN CANDRA O .. DEVANAGARI VOWEL SIGN AU
     Mn,  -- (16#0094D#, 16#0094D#)  DEVANAGARI SIGN VIRAMA .. DEVANAGARI SIGN VIRAMA
     Lo,  -- (16#00950#, 16#00950#)  DEVANAGARI OM .. DEVANAGARI OM
     Mn,  -- (16#00951#, 16#00954#)  DEVANAGARI STRESS SIGN UDATTA .. DEVANAGARI ACUTE ACCENT
     Lo,  -- (16#00958#, 16#00961#)  DEVANAGARI LETTER QA .. DEVANAGARI LETTER VOCALIC LL
     Mn,  -- (16#00962#, 16#00963#)  DEVANAGARI VOWEL SIGN VOCALIC L .. DEVANAGARI VOWEL SIGN VOCALIC LL
     Po,  -- (16#00964#, 16#00965#)  DEVANAGARI DANDA .. DEVANAGARI DOUBLE DANDA
     Nd,  -- (16#00966#, 16#0096F#)  DEVANAGARI DIGIT ZERO .. DEVANAGARI DIGIT NINE
     Po,  -- (16#00970#, 16#00970#)  DEVANAGARI ABBREVIATION SIGN .. DEVANAGARI ABBREVIATION SIGN
     Mn,  -- (16#00981#, 16#00981#)  BENGALI SIGN CANDRABINDU .. BENGALI SIGN CANDRABINDU
     Mc,  -- (16#00982#, 16#00983#)  BENGALI SIGN ANUSVARA .. BENGALI SIGN VISARGA
     Lo,  -- (16#00985#, 16#0098C#)  BENGALI LETTER A .. BENGALI LETTER VOCALIC L
     Lo,  -- (16#0098F#, 16#00990#)  BENGALI LETTER E .. BENGALI LETTER AI
     Lo,  -- (16#00993#, 16#009A8#)  BENGALI LETTER O .. BENGALI LETTER NA
     Lo,  -- (16#009AA#, 16#009B0#)  BENGALI LETTER PA .. BENGALI LETTER RA
     Lo,  -- (16#009B2#, 16#009B2#)  BENGALI LETTER LA .. BENGALI LETTER LA
     Lo,  -- (16#009B6#, 16#009B9#)  BENGALI LETTER SHA .. BENGALI LETTER HA
     Mn,  -- (16#009BC#, 16#009BC#)  BENGALI SIGN NUKTA .. BENGALI SIGN NUKTA
     Lo,  -- (16#009BD#, 16#009BD#)  BENGALI SIGN AVAGRAHA .. BENGALI SIGN AVAGRAHA
     Mc,  -- (16#009BE#, 16#009C0#)  BENGALI VOWEL SIGN AA .. BENGALI VOWEL SIGN II
     Mn,  -- (16#009C1#, 16#009C4#)  BENGALI VOWEL SIGN U .. BENGALI VOWEL SIGN VOCALIC RR
     Mc,  -- (16#009C7#, 16#009C8#)  BENGALI VOWEL SIGN E .. BENGALI VOWEL SIGN AI
     Mc,  -- (16#009CB#, 16#009CC#)  BENGALI VOWEL SIGN O .. BENGALI VOWEL SIGN AU
     Mn,  -- (16#009CD#, 16#009CD#)  BENGALI SIGN VIRAMA .. BENGALI SIGN VIRAMA
     Mc,  -- (16#009D7#, 16#009D7#)  BENGALI AU LENGTH MARK .. BENGALI AU LENGTH MARK
     Lo,  -- (16#009DC#, 16#009DD#)  BENGALI LETTER RRA .. BENGALI LETTER RHA
     Lo,  -- (16#009DF#, 16#009E1#)  BENGALI LETTER YYA .. BENGALI LETTER VOCALIC LL
     Mn,  -- (16#009E2#, 16#009E3#)  BENGALI VOWEL SIGN VOCALIC L .. BENGALI VOWEL SIGN VOCALIC LL
     Nd,  -- (16#009E6#, 16#009EF#)  BENGALI DIGIT ZERO .. BENGALI DIGIT NINE
     Lo,  -- (16#009F0#, 16#009F1#)  BENGALI LETTER RA WITH MIDDLE DIAGONAL .. BENGALI LETTER RA WITH LOWER DIAGONAL
     Sc,  -- (16#009F2#, 16#009F3#)  BENGALI RUPEE MARK .. BENGALI RUPEE SIGN
     No,  -- (16#009F4#, 16#009F9#)  BENGALI CURRENCY NUMERATOR ONE .. BENGALI CURRENCY DENOMINATOR SIXTEEN
     So,  -- (16#009FA#, 16#009FA#)  BENGALI ISSHAR .. BENGALI ISSHAR
     Mn,  -- (16#00A01#, 16#00A02#)  GURMUKHI SIGN ADAK BINDI .. GURMUKHI SIGN BINDI
     Mc,  -- (16#00A03#, 16#00A03#)  GURMUKHI SIGN VISARGA .. GURMUKHI SIGN VISARGA
     Lo,  -- (16#00A05#, 16#00A0A#)  GURMUKHI LETTER A .. GURMUKHI LETTER UU
     Lo,  -- (16#00A0F#, 16#00A10#)  GURMUKHI LETTER EE .. GURMUKHI LETTER AI
     Lo,  -- (16#00A13#, 16#00A28#)  GURMUKHI LETTER OO .. GURMUKHI LETTER NA
     Lo,  -- (16#00A2A#, 16#00A30#)  GURMUKHI LETTER PA .. GURMUKHI LETTER RA
     Lo,  -- (16#00A32#, 16#00A33#)  GURMUKHI LETTER LA .. GURMUKHI LETTER LLA
     Lo,  -- (16#00A35#, 16#00A36#)  GURMUKHI LETTER VA .. GURMUKHI LETTER SHA
     Lo,  -- (16#00A38#, 16#00A39#)  GURMUKHI LETTER SA .. GURMUKHI LETTER HA
     Mn,  -- (16#00A3C#, 16#00A3C#)  GURMUKHI SIGN NUKTA .. GURMUKHI SIGN NUKTA
     Mc,  -- (16#00A3E#, 16#00A40#)  GURMUKHI VOWEL SIGN AA .. GURMUKHI VOWEL SIGN II
     Mn,  -- (16#00A41#, 16#00A42#)  GURMUKHI VOWEL SIGN U .. GURMUKHI VOWEL SIGN UU
     Mn,  -- (16#00A47#, 16#00A48#)  GURMUKHI VOWEL SIGN EE .. GURMUKHI VOWEL SIGN AI
     Mn,  -- (16#00A4B#, 16#00A4D#)  GURMUKHI VOWEL SIGN OO .. GURMUKHI SIGN VIRAMA
     Lo,  -- (16#00A59#, 16#00A5C#)  GURMUKHI LETTER KHHA .. GURMUKHI LETTER RRA
     Lo,  -- (16#00A5E#, 16#00A5E#)  GURMUKHI LETTER FA .. GURMUKHI LETTER FA
     Nd,  -- (16#00A66#, 16#00A6F#)  GURMUKHI DIGIT ZERO .. GURMUKHI DIGIT NINE
     Mn,  -- (16#00A70#, 16#00A71#)  GURMUKHI TIPPI .. GURMUKHI ADDAK
     Lo,  -- (16#00A72#, 16#00A74#)  GURMUKHI IRI .. GURMUKHI EK ONKAR
     Mn,  -- (16#00A81#, 16#00A82#)  GUJARATI SIGN CANDRABINDU .. GUJARATI SIGN ANUSVARA
     Mc,  -- (16#00A83#, 16#00A83#)  GUJARATI SIGN VISARGA .. GUJARATI SIGN VISARGA
     Lo,  -- (16#00A85#, 16#00A8D#)  GUJARATI LETTER A .. GUJARATI VOWEL CANDRA E
     Lo,  -- (16#00A8F#, 16#00A91#)  GUJARATI LETTER E .. GUJARATI VOWEL CANDRA O
     Lo,  -- (16#00A93#, 16#00AA8#)  GUJARATI LETTER O .. GUJARATI LETTER NA
     Lo,  -- (16#00AAA#, 16#00AB0#)  GUJARATI LETTER PA .. GUJARATI LETTER RA
     Lo,  -- (16#00AB2#, 16#00AB3#)  GUJARATI LETTER LA .. GUJARATI LETTER LLA
     Lo,  -- (16#00AB5#, 16#00AB9#)  GUJARATI LETTER VA .. GUJARATI LETTER HA
     Mn,  -- (16#00ABC#, 16#00ABC#)  GUJARATI SIGN NUKTA .. GUJARATI SIGN NUKTA
     Lo,  -- (16#00ABD#, 16#00ABD#)  GUJARATI SIGN AVAGRAHA .. GUJARATI SIGN AVAGRAHA
     Mc,  -- (16#00ABE#, 16#00AC0#)  GUJARATI VOWEL SIGN AA .. GUJARATI VOWEL SIGN II
     Mn,  -- (16#00AC1#, 16#00AC5#)  GUJARATI VOWEL SIGN U .. GUJARATI VOWEL SIGN CANDRA E
     Mn,  -- (16#00AC7#, 16#00AC8#)  GUJARATI VOWEL SIGN E .. GUJARATI VOWEL SIGN AI
     Mc,  -- (16#00AC9#, 16#00AC9#)  GUJARATI VOWEL SIGN CANDRA O .. GUJARATI VOWEL SIGN CANDRA O
     Mc,  -- (16#00ACB#, 16#00ACC#)  GUJARATI VOWEL SIGN O .. GUJARATI VOWEL SIGN AU
     Mn,  -- (16#00ACD#, 16#00ACD#)  GUJARATI SIGN VIRAMA .. GUJARATI SIGN VIRAMA
     Lo,  -- (16#00AD0#, 16#00AD0#)  GUJARATI OM .. GUJARATI OM
     Lo,  -- (16#00AE0#, 16#00AE1#)  GUJARATI LETTER VOCALIC RR .. GUJARATI LETTER VOCALIC LL
     Mn,  -- (16#00AE2#, 16#00AE3#)  GUJARATI VOWEL SIGN VOCALIC L .. GUJARATI VOWEL SIGN VOCALIC LL
     Nd,  -- (16#00AE6#, 16#00AEF#)  GUJARATI DIGIT ZERO .. GUJARATI DIGIT NINE
     Sc,  -- (16#00AF1#, 16#00AF1#)  GUJARATI RUPEE SIGN .. GUJARATI RUPEE SIGN
     Mn,  -- (16#00B01#, 16#00B01#)  ORIYA SIGN CANDRABINDU .. ORIYA SIGN CANDRABINDU
     Mc,  -- (16#00B02#, 16#00B03#)  ORIYA SIGN ANUSVARA .. ORIYA SIGN VISARGA
     Lo,  -- (16#00B05#, 16#00B0C#)  ORIYA LETTER A .. ORIYA LETTER VOCALIC L
     Lo,  -- (16#00B0F#, 16#00B10#)  ORIYA LETTER E .. ORIYA LETTER AI
     Lo,  -- (16#00B13#, 16#00B28#)  ORIYA LETTER O .. ORIYA LETTER NA
     Lo,  -- (16#00B2A#, 16#00B30#)  ORIYA LETTER PA .. ORIYA LETTER RA
     Lo,  -- (16#00B32#, 16#00B33#)  ORIYA LETTER LA .. ORIYA LETTER LLA
     Lo,  -- (16#00B35#, 16#00B39#)  ORIYA LETTER VA .. ORIYA LETTER HA
     Mn,  -- (16#00B3C#, 16#00B3C#)  ORIYA SIGN NUKTA .. ORIYA SIGN NUKTA
     Lo,  -- (16#00B3D#, 16#00B3D#)  ORIYA SIGN AVAGRAHA .. ORIYA SIGN AVAGRAHA
     Mc,  -- (16#00B3E#, 16#00B3E#)  ORIYA VOWEL SIGN AA .. ORIYA VOWEL SIGN AA
     Mn,  -- (16#00B3F#, 16#00B3F#)  ORIYA VOWEL SIGN I .. ORIYA VOWEL SIGN I
     Mc,  -- (16#00B40#, 16#00B40#)  ORIYA VOWEL SIGN II .. ORIYA VOWEL SIGN II
     Mn,  -- (16#00B41#, 16#00B43#)  ORIYA VOWEL SIGN U .. ORIYA VOWEL SIGN VOCALIC R
     Mc,  -- (16#00B47#, 16#00B48#)  ORIYA VOWEL SIGN E .. ORIYA VOWEL SIGN AI
     Mc,  -- (16#00B4B#, 16#00B4C#)  ORIYA VOWEL SIGN O .. ORIYA VOWEL SIGN AU
     Mn,  -- (16#00B4D#, 16#00B4D#)  ORIYA SIGN VIRAMA .. ORIYA SIGN VIRAMA
     Mn,  -- (16#00B56#, 16#00B56#)  ORIYA AI LENGTH MARK .. ORIYA AI LENGTH MARK
     Mc,  -- (16#00B57#, 16#00B57#)  ORIYA AU LENGTH MARK .. ORIYA AU LENGTH MARK
     Lo,  -- (16#00B5C#, 16#00B5D#)  ORIYA LETTER RRA .. ORIYA LETTER RHA
     Lo,  -- (16#00B5F#, 16#00B61#)  ORIYA LETTER YYA .. ORIYA LETTER VOCALIC LL
     Nd,  -- (16#00B66#, 16#00B6F#)  ORIYA DIGIT ZERO .. ORIYA DIGIT NINE
     So,  -- (16#00B70#, 16#00B70#)  ORIYA ISSHAR .. ORIYA ISSHAR
     Lo,  -- (16#00B71#, 16#00B71#)  ORIYA LETTER WA .. ORIYA LETTER WA
     Mn,  -- (16#00B82#, 16#00B82#)  TAMIL SIGN ANUSVARA .. TAMIL SIGN ANUSVARA
     Lo,  -- (16#00B83#, 16#00B83#)  TAMIL SIGN VISARGA .. TAMIL SIGN VISARGA
     Lo,  -- (16#00B85#, 16#00B8A#)  TAMIL LETTER A .. TAMIL LETTER UU
     Lo,  -- (16#00B8E#, 16#00B90#)  TAMIL LETTER E .. TAMIL LETTER AI
     Lo,  -- (16#00B92#, 16#00B95#)  TAMIL LETTER O .. TAMIL LETTER KA
     Lo,  -- (16#00B99#, 16#00B9A#)  TAMIL LETTER NGA .. TAMIL LETTER CA
     Lo,  -- (16#00B9C#, 16#00B9C#)  TAMIL LETTER JA .. TAMIL LETTER JA
     Lo,  -- (16#00B9E#, 16#00B9F#)  TAMIL LETTER NYA .. TAMIL LETTER TTA
     Lo,  -- (16#00BA3#, 16#00BA4#)  TAMIL LETTER NNA .. TAMIL LETTER TA
     Lo,  -- (16#00BA8#, 16#00BAA#)  TAMIL LETTER NA .. TAMIL LETTER PA
     Lo,  -- (16#00BAE#, 16#00BB5#)  TAMIL LETTER MA .. TAMIL LETTER VA
     Lo,  -- (16#00BB7#, 16#00BB9#)  TAMIL LETTER SSA .. TAMIL LETTER HA
     Mc,  -- (16#00BBE#, 16#00BBF#)  TAMIL VOWEL SIGN AA .. TAMIL VOWEL SIGN I
     Mn,  -- (16#00BC0#, 16#00BC0#)  TAMIL VOWEL SIGN II .. TAMIL VOWEL SIGN II
     Mc,  -- (16#00BC1#, 16#00BC2#)  TAMIL VOWEL SIGN U .. TAMIL VOWEL SIGN UU
     Mc,  -- (16#00BC6#, 16#00BC8#)  TAMIL VOWEL SIGN E .. TAMIL VOWEL SIGN AI
     Mc,  -- (16#00BCA#, 16#00BCC#)  TAMIL VOWEL SIGN O .. TAMIL VOWEL SIGN AU
     Mn,  -- (16#00BCD#, 16#00BCD#)  TAMIL SIGN VIRAMA .. TAMIL SIGN VIRAMA
     Mc,  -- (16#00BD7#, 16#00BD7#)  TAMIL AU LENGTH MARK .. TAMIL AU LENGTH MARK
     Nd,  -- (16#00BE7#, 16#00BEF#)  TAMIL DIGIT ONE .. TAMIL DIGIT NINE
     No,  -- (16#00BF0#, 16#00BF2#)  TAMIL NUMBER TEN .. TAMIL NUMBER ONE THOUSAND
     So,  -- (16#00BF3#, 16#00BF8#)  TAMIL DAY SIGN .. TAMIL AS ABOVE SIGN
     Sc,  -- (16#00BF9#, 16#00BF9#)  TAMIL RUPEE SIGN .. TAMIL RUPEE SIGN
     So,  -- (16#00BFA#, 16#00BFA#)  TAMIL NUMBER SIGN .. TAMIL NUMBER SIGN
     Mc,  -- (16#00C01#, 16#00C03#)  TELUGU SIGN CANDRABINDU .. TELUGU SIGN VISARGA
     Lo,  -- (16#00C05#, 16#00C0C#)  TELUGU LETTER A .. TELUGU LETTER VOCALIC L
     Lo,  -- (16#00C0E#, 16#00C10#)  TELUGU LETTER E .. TELUGU LETTER AI
     Lo,  -- (16#00C12#, 16#00C28#)  TELUGU LETTER O .. TELUGU LETTER NA
     Lo,  -- (16#00C2A#, 16#00C33#)  TELUGU LETTER PA .. TELUGU LETTER LLA
     Lo,  -- (16#00C35#, 16#00C39#)  TELUGU LETTER VA .. TELUGU LETTER HA
     Mn,  -- (16#00C3E#, 16#00C40#)  TELUGU VOWEL SIGN AA .. TELUGU VOWEL SIGN II
     Mc,  -- (16#00C41#, 16#00C44#)  TELUGU VOWEL SIGN U .. TELUGU VOWEL SIGN VOCALIC RR
     Mn,  -- (16#00C46#, 16#00C48#)  TELUGU VOWEL SIGN E .. TELUGU VOWEL SIGN AI
     Mn,  -- (16#00C4A#, 16#00C4D#)  TELUGU VOWEL SIGN O .. TELUGU SIGN VIRAMA
     Mn,  -- (16#00C55#, 16#00C56#)  TELUGU LENGTH MARK .. TELUGU AI LENGTH MARK
     Lo,  -- (16#00C60#, 16#00C61#)  TELUGU LETTER VOCALIC RR .. TELUGU LETTER VOCALIC LL
     Nd,  -- (16#00C66#, 16#00C6F#)  TELUGU DIGIT ZERO .. TELUGU DIGIT NINE
     Mc,  -- (16#00C82#, 16#00C83#)  KANNADA SIGN ANUSVARA .. KANNADA SIGN VISARGA
     Lo,  -- (16#00C85#, 16#00C8C#)  KANNADA LETTER A .. KANNADA LETTER VOCALIC L
     Lo,  -- (16#00C8E#, 16#00C90#)  KANNADA LETTER E .. KANNADA LETTER AI
     Lo,  -- (16#00C92#, 16#00CA8#)  KANNADA LETTER O .. KANNADA LETTER NA
     Lo,  -- (16#00CAA#, 16#00CB3#)  KANNADA LETTER PA .. KANNADA LETTER LLA
     Lo,  -- (16#00CB5#, 16#00CB9#)  KANNADA LETTER VA .. KANNADA LETTER HA
     Mn,  -- (16#00CBC#, 16#00CBC#)  KANNADA SIGN NUKTA .. KANNADA SIGN NUKTA
     Lo,  -- (16#00CBD#, 16#00CBD#)  KANNADA SIGN AVAGRAHA .. KANNADA SIGN AVAGRAHA
     Mc,  -- (16#00CBE#, 16#00CBE#)  KANNADA VOWEL SIGN AA .. KANNADA VOWEL SIGN AA
     Mn,  -- (16#00CBF#, 16#00CBF#)  KANNADA VOWEL SIGN I .. KANNADA VOWEL SIGN I
     Mc,  -- (16#00CC0#, 16#00CC4#)  KANNADA VOWEL SIGN II .. KANNADA VOWEL SIGN VOCALIC RR
     Mn,  -- (16#00CC6#, 16#00CC6#)  KANNADA VOWEL SIGN E .. KANNADA VOWEL SIGN E
     Mc,  -- (16#00CC7#, 16#00CC8#)  KANNADA VOWEL SIGN EE .. KANNADA VOWEL SIGN AI
     Mc,  -- (16#00CCA#, 16#00CCB#)  KANNADA VOWEL SIGN O .. KANNADA VOWEL SIGN OO
     Mn,  -- (16#00CCC#, 16#00CCD#)  KANNADA VOWEL SIGN AU .. KANNADA SIGN VIRAMA
     Mc,  -- (16#00CD5#, 16#00CD6#)  KANNADA LENGTH MARK .. KANNADA AI LENGTH MARK
     Lo,  -- (16#00CDE#, 16#00CDE#)  KANNADA LETTER FA .. KANNADA LETTER FA
     Lo,  -- (16#00CE0#, 16#00CE1#)  KANNADA LETTER VOCALIC RR .. KANNADA LETTER VOCALIC LL
     Nd,  -- (16#00CE6#, 16#00CEF#)  KANNADA DIGIT ZERO .. KANNADA DIGIT NINE
     Mc,  -- (16#00D02#, 16#00D03#)  MALAYALAM SIGN ANUSVARA .. MALAYALAM SIGN VISARGA
     Lo,  -- (16#00D05#, 16#00D0C#)  MALAYALAM LETTER A .. MALAYALAM LETTER VOCALIC L
     Lo,  -- (16#00D0E#, 16#00D10#)  MALAYALAM LETTER E .. MALAYALAM LETTER AI
     Lo,  -- (16#00D12#, 16#00D28#)  MALAYALAM LETTER O .. MALAYALAM LETTER NA
     Lo,  -- (16#00D2A#, 16#00D39#)  MALAYALAM LETTER PA .. MALAYALAM LETTER HA
     Mc,  -- (16#00D3E#, 16#00D40#)  MALAYALAM VOWEL SIGN AA .. MALAYALAM VOWEL SIGN II
     Mn,  -- (16#00D41#, 16#00D43#)  MALAYALAM VOWEL SIGN U .. MALAYALAM VOWEL SIGN VOCALIC R
     Mc,  -- (16#00D46#, 16#00D48#)  MALAYALAM VOWEL SIGN E .. MALAYALAM VOWEL SIGN AI
     Mc,  -- (16#00D4A#, 16#00D4C#)  MALAYALAM VOWEL SIGN O .. MALAYALAM VOWEL SIGN AU
     Mn,  -- (16#00D4D#, 16#00D4D#)  MALAYALAM SIGN VIRAMA .. MALAYALAM SIGN VIRAMA
     Mc,  -- (16#00D57#, 16#00D57#)  MALAYALAM AU LENGTH MARK .. MALAYALAM AU LENGTH MARK
     Lo,  -- (16#00D60#, 16#00D61#)  MALAYALAM LETTER VOCALIC RR .. MALAYALAM LETTER VOCALIC LL
     Nd,  -- (16#00D66#, 16#00D6F#)  MALAYALAM DIGIT ZERO .. MALAYALAM DIGIT NINE
     Mc,  -- (16#00D82#, 16#00D83#)  SINHALA SIGN ANUSVARAYA .. SINHALA SIGN VISARGAYA
     Lo,  -- (16#00D85#, 16#00D96#)  SINHALA LETTER AYANNA .. SINHALA LETTER AUYANNA
     Lo,  -- (16#00D9A#, 16#00DB1#)  SINHALA LETTER ALPAPRAANA KAYANNA .. SINHALA LETTER DANTAJA NAYANNA
     Lo,  -- (16#00DB3#, 16#00DBB#)  SINHALA LETTER SANYAKA DAYANNA .. SINHALA LETTER RAYANNA
     Lo,  -- (16#00DBD#, 16#00DBD#)  SINHALA LETTER DANTAJA LAYANNA .. SINHALA LETTER DANTAJA LAYANNA
     Lo,  -- (16#00DC0#, 16#00DC6#)  SINHALA LETTER VAYANNA .. SINHALA LETTER FAYANNA
     Mn,  -- (16#00DCA#, 16#00DCA#)  SINHALA SIGN AL-LAKUNA .. SINHALA SIGN AL-LAKUNA
     Mc,  -- (16#00DCF#, 16#00DD1#)  SINHALA VOWEL SIGN AELA-PILLA .. SINHALA VOWEL SIGN DIGA AEDA-PILLA
     Mn,  -- (16#00DD2#, 16#00DD4#)  SINHALA VOWEL SIGN KETTI IS-PILLA .. SINHALA VOWEL SIGN KETTI PAA-PILLA
     Mn,  -- (16#00DD6#, 16#00DD6#)  SINHALA VOWEL SIGN DIGA PAA-PILLA .. SINHALA VOWEL SIGN DIGA PAA-PILLA
     Mc,  -- (16#00DD8#, 16#00DDF#)  SINHALA VOWEL SIGN GAETTA-PILLA .. SINHALA VOWEL SIGN GAYANUKITTA
     Mc,  -- (16#00DF2#, 16#00DF3#)  SINHALA VOWEL SIGN DIGA GAETTA-PILLA .. SINHALA VOWEL SIGN DIGA GAYANUKITTA
     Po,  -- (16#00DF4#, 16#00DF4#)  SINHALA PUNCTUATION KUNDDALIYA .. SINHALA PUNCTUATION KUNDDALIYA
     Lo,  -- (16#00E01#, 16#00E30#)  THAI CHARACTER KO KAI .. THAI CHARACTER SARA A
     Mn,  -- (16#00E31#, 16#00E31#)  THAI CHARACTER MAI HAN-AKAT .. THAI CHARACTER MAI HAN-AKAT
     Lo,  -- (16#00E32#, 16#00E33#)  THAI CHARACTER SARA AA .. THAI CHARACTER SARA AM
     Mn,  -- (16#00E34#, 16#00E3A#)  THAI CHARACTER SARA I .. THAI CHARACTER PHINTHU
     Sc,  -- (16#00E3F#, 16#00E3F#)  THAI CURRENCY SYMBOL BAHT .. THAI CURRENCY SYMBOL BAHT
     Lo,  -- (16#00E40#, 16#00E45#)  THAI CHARACTER SARA E .. THAI CHARACTER LAKKHANGYAO
     Lm,  -- (16#00E46#, 16#00E46#)  THAI CHARACTER MAIYAMOK .. THAI CHARACTER MAIYAMOK
     Mn,  -- (16#00E47#, 16#00E4E#)  THAI CHARACTER MAITAIKHU .. THAI CHARACTER YAMAKKAN
     Po,  -- (16#00E4F#, 16#00E4F#)  THAI CHARACTER FONGMAN .. THAI CHARACTER FONGMAN
     Nd,  -- (16#00E50#, 16#00E59#)  THAI DIGIT ZERO .. THAI DIGIT NINE
     Po,  -- (16#00E5A#, 16#00E5B#)  THAI CHARACTER ANGKHANKHU .. THAI CHARACTER KHOMUT
     Lo,  -- (16#00E81#, 16#00E82#)  LAO LETTER KO .. LAO LETTER KHO SUNG
     Lo,  -- (16#00E84#, 16#00E84#)  LAO LETTER KHO TAM .. LAO LETTER KHO TAM
     Lo,  -- (16#00E87#, 16#00E88#)  LAO LETTER NGO .. LAO LETTER CO
     Lo,  -- (16#00E8A#, 16#00E8A#)  LAO LETTER SO TAM .. LAO LETTER SO TAM
     Lo,  -- (16#00E8D#, 16#00E8D#)  LAO LETTER NYO .. LAO LETTER NYO
     Lo,  -- (16#00E94#, 16#00E97#)  LAO LETTER DO .. LAO LETTER THO TAM
     Lo,  -- (16#00E99#, 16#00E9F#)  LAO LETTER NO .. LAO LETTER FO SUNG
     Lo,  -- (16#00EA1#, 16#00EA3#)  LAO LETTER MO .. LAO LETTER LO LING
     Lo,  -- (16#00EA5#, 16#00EA5#)  LAO LETTER LO LOOT .. LAO LETTER LO LOOT
     Lo,  -- (16#00EA7#, 16#00EA7#)  LAO LETTER WO .. LAO LETTER WO
     Lo,  -- (16#00EAA#, 16#00EAB#)  LAO LETTER SO SUNG .. LAO LETTER HO SUNG
     Lo,  -- (16#00EAD#, 16#00EB0#)  LAO LETTER O .. LAO VOWEL SIGN A
     Mn,  -- (16#00EB1#, 16#00EB1#)  LAO VOWEL SIGN MAI KAN .. LAO VOWEL SIGN MAI KAN
     Lo,  -- (16#00EB2#, 16#00EB3#)  LAO VOWEL SIGN AA .. LAO VOWEL SIGN AM
     Mn,  -- (16#00EB4#, 16#00EB9#)  LAO VOWEL SIGN I .. LAO VOWEL SIGN UU
     Mn,  -- (16#00EBB#, 16#00EBC#)  LAO VOWEL SIGN MAI KON .. LAO SEMIVOWEL SIGN LO
     Lo,  -- (16#00EBD#, 16#00EBD#)  LAO SEMIVOWEL SIGN NYO .. LAO SEMIVOWEL SIGN NYO
     Lo,  -- (16#00EC0#, 16#00EC4#)  LAO VOWEL SIGN E .. LAO VOWEL SIGN AI
     Lm,  -- (16#00EC6#, 16#00EC6#)  LAO KO LA .. LAO KO LA
     Mn,  -- (16#00EC8#, 16#00ECD#)  LAO TONE MAI EK .. LAO NIGGAHITA
     Nd,  -- (16#00ED0#, 16#00ED9#)  LAO DIGIT ZERO .. LAO DIGIT NINE
     Lo,  -- (16#00EDC#, 16#00EDD#)  LAO HO NO .. LAO HO MO
     Lo,  -- (16#00F00#, 16#00F00#)  TIBETAN SYLLABLE OM .. TIBETAN SYLLABLE OM
     So,  -- (16#00F01#, 16#00F03#)  TIBETAN MARK GTER YIG MGO TRUNCATED A .. TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA
     Po,  -- (16#00F04#, 16#00F12#)  TIBETAN MARK INITIAL YIG MGO MDUN MA .. TIBETAN MARK RGYA GRAM SHAD
     So,  -- (16#00F13#, 16#00F17#)  TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN .. TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS
     Mn,  -- (16#00F18#, 16#00F19#)  TIBETAN ASTROLOGICAL SIGN -KHYUD PA .. TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
     So,  -- (16#00F1A#, 16#00F1F#)  TIBETAN SIGN RDEL DKAR GCIG .. TIBETAN SIGN RDEL DKAR RDEL NAG
     Nd,  -- (16#00F20#, 16#00F29#)  TIBETAN DIGIT ZERO .. TIBETAN DIGIT NINE
     No,  -- (16#00F2A#, 16#00F33#)  TIBETAN DIGIT HALF ONE .. TIBETAN DIGIT HALF ZERO
     So,  -- (16#00F34#, 16#00F34#)  TIBETAN MARK BSDUS RTAGS .. TIBETAN MARK BSDUS RTAGS
     Mn,  -- (16#00F35#, 16#00F35#)  TIBETAN MARK NGAS BZUNG NYI ZLA .. TIBETAN MARK NGAS BZUNG NYI ZLA
     So,  -- (16#00F36#, 16#00F36#)  TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN .. TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN
     Mn,  -- (16#00F37#, 16#00F37#)  TIBETAN MARK NGAS BZUNG SGOR RTAGS .. TIBETAN MARK NGAS BZUNG SGOR RTAGS
     So,  -- (16#00F38#, 16#00F38#)  TIBETAN MARK CHE MGO .. TIBETAN MARK CHE MGO
     Mn,  -- (16#00F39#, 16#00F39#)  TIBETAN MARK TSA -PHRU .. TIBETAN MARK TSA -PHRU
     Ps,  -- (16#00F3A#, 16#00F3A#)  TIBETAN MARK GUG RTAGS GYON .. TIBETAN MARK GUG RTAGS GYON
     Pe,  -- (16#00F3B#, 16#00F3B#)  TIBETAN MARK GUG RTAGS GYAS .. TIBETAN MARK GUG RTAGS GYAS
     Ps,  -- (16#00F3C#, 16#00F3C#)  TIBETAN MARK ANG KHANG GYON .. TIBETAN MARK ANG KHANG GYON
     Pe,  -- (16#00F3D#, 16#00F3D#)  TIBETAN MARK ANG KHANG GYAS .. TIBETAN MARK ANG KHANG GYAS
     Mc,  -- (16#00F3E#, 16#00F3F#)  TIBETAN SIGN YAR TSHES .. TIBETAN SIGN MAR TSHES
     Lo,  -- (16#00F40#, 16#00F47#)  TIBETAN LETTER KA .. TIBETAN LETTER JA
     Lo,  -- (16#00F49#, 16#00F6A#)  TIBETAN LETTER NYA .. TIBETAN LETTER FIXED-FORM RA
     Mn,  -- (16#00F71#, 16#00F7E#)  TIBETAN VOWEL SIGN AA .. TIBETAN SIGN RJES SU NGA RO
     Mc,  -- (16#00F7F#, 16#00F7F#)  TIBETAN SIGN RNAM BCAD .. TIBETAN SIGN RNAM BCAD
     Mn,  -- (16#00F80#, 16#00F84#)  TIBETAN VOWEL SIGN REVERSED I .. TIBETAN MARK HALANTA
     Po,  -- (16#00F85#, 16#00F85#)  TIBETAN MARK PALUTA .. TIBETAN MARK PALUTA
     Mn,  -- (16#00F86#, 16#00F87#)  TIBETAN SIGN LCI RTAGS .. TIBETAN SIGN YANG RTAGS
     Lo,  -- (16#00F88#, 16#00F8B#)  TIBETAN SIGN LCE TSA CAN .. TIBETAN SIGN GRU MED RGYINGS
     Mn,  -- (16#00F90#, 16#00F97#)  TIBETAN SUBJOINED LETTER KA .. TIBETAN SUBJOINED LETTER JA
     Mn,  -- (16#00F99#, 16#00FBC#)  TIBETAN SUBJOINED LETTER NYA .. TIBETAN SUBJOINED LETTER FIXED-FORM RA
     So,  -- (16#00FBE#, 16#00FC5#)  TIBETAN KU RU KHA .. TIBETAN SYMBOL RDO RJE
     Mn,  -- (16#00FC6#, 16#00FC6#)  TIBETAN SYMBOL PADMA GDAN .. TIBETAN SYMBOL PADMA GDAN
     So,  -- (16#00FC7#, 16#00FCC#)  TIBETAN SYMBOL RDO RJE RGYA GRAM .. TIBETAN SYMBOL NOR BU BZHI -KHYIL
     So,  -- (16#00FCF#, 16#00FCF#)  TIBETAN SIGN RDEL NAG GSUM .. TIBETAN SIGN RDEL NAG GSUM
     Lo,  -- (16#01000#, 16#01021#)  MYANMAR LETTER KA .. MYANMAR LETTER A
     Lo,  -- (16#01023#, 16#01027#)  MYANMAR LETTER I .. MYANMAR LETTER E
     Lo,  -- (16#01029#, 16#0102A#)  MYANMAR LETTER O .. MYANMAR LETTER AU
     Mc,  -- (16#0102C#, 16#0102C#)  MYANMAR VOWEL SIGN AA .. MYANMAR VOWEL SIGN AA
     Mn,  -- (16#0102D#, 16#01030#)  MYANMAR VOWEL SIGN I .. MYANMAR VOWEL SIGN UU
     Mc,  -- (16#01031#, 16#01031#)  MYANMAR VOWEL SIGN E .. MYANMAR VOWEL SIGN E
     Mn,  -- (16#01032#, 16#01032#)  MYANMAR VOWEL SIGN AI .. MYANMAR VOWEL SIGN AI
     Mn,  -- (16#01036#, 16#01037#)  MYANMAR SIGN ANUSVARA .. MYANMAR SIGN DOT BELOW
     Mc,  -- (16#01038#, 16#01038#)  MYANMAR SIGN VISARGA .. MYANMAR SIGN VISARGA
     Mn,  -- (16#01039#, 16#01039#)  MYANMAR SIGN VIRAMA .. MYANMAR SIGN VIRAMA
     Nd,  -- (16#01040#, 16#01049#)  MYANMAR DIGIT ZERO .. MYANMAR DIGIT NINE
     Po,  -- (16#0104A#, 16#0104F#)  MYANMAR SIGN LITTLE SECTION .. MYANMAR SYMBOL GENITIVE
     Lo,  -- (16#01050#, 16#01055#)  MYANMAR LETTER SHA .. MYANMAR LETTER VOCALIC LL
     Mc,  -- (16#01056#, 16#01057#)  MYANMAR VOWEL SIGN VOCALIC R .. MYANMAR VOWEL SIGN VOCALIC RR
     Mn,  -- (16#01058#, 16#01059#)  MYANMAR VOWEL SIGN VOCALIC L .. MYANMAR VOWEL SIGN VOCALIC LL
     Lu,  -- (16#010A0#, 16#010C5#)  GEORGIAN CAPITAL LETTER AN .. GEORGIAN CAPITAL LETTER HOE
     Lo,  -- (16#010D0#, 16#010F8#)  GEORGIAN LETTER AN .. GEORGIAN LETTER ELIFI
     Po,  -- (16#010FB#, 16#010FB#)  GEORGIAN PARAGRAPH SEPARATOR .. GEORGIAN PARAGRAPH SEPARATOR
     Lo,  -- (16#01100#, 16#01159#)  HANGUL CHOSEONG KIYEOK .. HANGUL CHOSEONG YEORINHIEUH
     Lo,  -- (16#0115F#, 16#011A2#)  HANGUL CHOSEONG FILLER .. HANGUL JUNGSEONG SSANGARAEA
     Lo,  -- (16#011A8#, 16#011F9#)  HANGUL JONGSEONG KIYEOK .. HANGUL JONGSEONG YEORINHIEUH
     Lo,  -- (16#01200#, 16#01206#)  ETHIOPIC SYLLABLE HA .. ETHIOPIC SYLLABLE HO
     Lo,  -- (16#01208#, 16#01246#)  ETHIOPIC SYLLABLE LA .. ETHIOPIC SYLLABLE QO
     Lo,  -- (16#01248#, 16#01248#)  ETHIOPIC SYLLABLE QWA .. ETHIOPIC SYLLABLE QWA
     Lo,  -- (16#0124A#, 16#0124D#)  ETHIOPIC SYLLABLE QWI .. ETHIOPIC SYLLABLE QWE
     Lo,  -- (16#01250#, 16#01256#)  ETHIOPIC SYLLABLE QHA .. ETHIOPIC SYLLABLE QHO
     Lo,  -- (16#01258#, 16#01258#)  ETHIOPIC SYLLABLE QHWA .. ETHIOPIC SYLLABLE QHWA
     Lo,  -- (16#0125A#, 16#0125D#)  ETHIOPIC SYLLABLE QHWI .. ETHIOPIC SYLLABLE QHWE
     Lo,  -- (16#01260#, 16#01286#)  ETHIOPIC SYLLABLE BA .. ETHIOPIC SYLLABLE XO
     Lo,  -- (16#01288#, 16#01288#)  ETHIOPIC SYLLABLE XWA .. ETHIOPIC SYLLABLE XWA
     Lo,  -- (16#0128A#, 16#0128D#)  ETHIOPIC SYLLABLE XWI .. ETHIOPIC SYLLABLE XWE
     Lo,  -- (16#01290#, 16#012AE#)  ETHIOPIC SYLLABLE NA .. ETHIOPIC SYLLABLE KO
     Lo,  -- (16#012B0#, 16#012B0#)  ETHIOPIC SYLLABLE KWA .. ETHIOPIC SYLLABLE KWA
     Lo,  -- (16#012B2#, 16#012B5#)  ETHIOPIC SYLLABLE KWI .. ETHIOPIC SYLLABLE KWE
     Lo,  -- (16#012B8#, 16#012BE#)  ETHIOPIC SYLLABLE KXA .. ETHIOPIC SYLLABLE KXO
     Lo,  -- (16#012C0#, 16#012C0#)  ETHIOPIC SYLLABLE KXWA .. ETHIOPIC SYLLABLE KXWA
     Lo,  -- (16#012C2#, 16#012C5#)  ETHIOPIC SYLLABLE KXWI .. ETHIOPIC SYLLABLE KXWE
     Lo,  -- (16#012C8#, 16#012CE#)  ETHIOPIC SYLLABLE WA .. ETHIOPIC SYLLABLE WO
     Lo,  -- (16#012D0#, 16#012D6#)  ETHIOPIC SYLLABLE PHARYNGEAL A .. ETHIOPIC SYLLABLE PHARYNGEAL O
     Lo,  -- (16#012D8#, 16#012EE#)  ETHIOPIC SYLLABLE ZA .. ETHIOPIC SYLLABLE YO
     Lo,  -- (16#012F0#, 16#0130E#)  ETHIOPIC SYLLABLE DA .. ETHIOPIC SYLLABLE GO
     Lo,  -- (16#01310#, 16#01310#)  ETHIOPIC SYLLABLE GWA .. ETHIOPIC SYLLABLE GWA
     Lo,  -- (16#01312#, 16#01315#)  ETHIOPIC SYLLABLE GWI .. ETHIOPIC SYLLABLE GWE
     Lo,  -- (16#01318#, 16#0131E#)  ETHIOPIC SYLLABLE GGA .. ETHIOPIC SYLLABLE GGO
     Lo,  -- (16#01320#, 16#01346#)  ETHIOPIC SYLLABLE THA .. ETHIOPIC SYLLABLE TZO
     Lo,  -- (16#01348#, 16#0135A#)  ETHIOPIC SYLLABLE FA .. ETHIOPIC SYLLABLE FYA
     Po,  -- (16#01361#, 16#01368#)  ETHIOPIC WORDSPACE .. ETHIOPIC PARAGRAPH SEPARATOR
     Nd,  -- (16#01369#, 16#01371#)  ETHIOPIC DIGIT ONE .. ETHIOPIC DIGIT NINE
     No,  -- (16#01372#, 16#0137C#)  ETHIOPIC NUMBER TEN .. ETHIOPIC NUMBER TEN THOUSAND
     Lo,  -- (16#013A0#, 16#013F4#)  CHEROKEE LETTER A .. CHEROKEE LETTER YV
     Lo,  -- (16#01401#, 16#0166C#)  CANADIAN SYLLABICS E .. CANADIAN SYLLABICS CARRIER TTSA
     Po,  -- (16#0166D#, 16#0166E#)  CANADIAN SYLLABICS CHI SIGN .. CANADIAN SYLLABICS FULL STOP
     Lo,  -- (16#0166F#, 16#01676#)  CANADIAN SYLLABICS QAI .. CANADIAN SYLLABICS NNGAA
     Zs,  -- (16#01680#, 16#01680#)  OGHAM SPACE MARK .. OGHAM SPACE MARK
     Lo,  -- (16#01681#, 16#0169A#)  OGHAM LETTER BEITH .. OGHAM LETTER PEITH
     Ps,  -- (16#0169B#, 16#0169B#)  OGHAM FEATHER MARK .. OGHAM FEATHER MARK
     Pe,  -- (16#0169C#, 16#0169C#)  OGHAM REVERSED FEATHER MARK .. OGHAM REVERSED FEATHER MARK
     Lo,  -- (16#016A0#, 16#016EA#)  RUNIC LETTER FEHU FEOH FE F .. RUNIC LETTER X
     Po,  -- (16#016EB#, 16#016ED#)  RUNIC SINGLE PUNCTUATION .. RUNIC CROSS PUNCTUATION
     Nl,  -- (16#016EE#, 16#016F0#)  RUNIC ARLAUG SYMBOL .. RUNIC BELGTHOR SYMBOL
     Lo,  -- (16#01700#, 16#0170C#)  TAGALOG LETTER A .. TAGALOG LETTER YA
     Lo,  -- (16#0170E#, 16#01711#)  TAGALOG LETTER LA .. TAGALOG LETTER HA
     Mn,  -- (16#01712#, 16#01714#)  TAGALOG VOWEL SIGN I .. TAGALOG SIGN VIRAMA
     Lo,  -- (16#01720#, 16#01731#)  HANUNOO LETTER A .. HANUNOO LETTER HA
     Mn,  -- (16#01732#, 16#01734#)  HANUNOO VOWEL SIGN I .. HANUNOO SIGN PAMUDPOD
     Po,  -- (16#01735#, 16#01736#)  PHILIPPINE SINGLE PUNCTUATION .. PHILIPPINE DOUBLE PUNCTUATION
     Lo,  -- (16#01740#, 16#01751#)  BUHID LETTER A .. BUHID LETTER HA
     Mn,  -- (16#01752#, 16#01753#)  BUHID VOWEL SIGN I .. BUHID VOWEL SIGN U
     Lo,  -- (16#01760#, 16#0176C#)  TAGBANWA LETTER A .. TAGBANWA LETTER YA
     Lo,  -- (16#0176E#, 16#01770#)  TAGBANWA LETTER LA .. TAGBANWA LETTER SA
     Mn,  -- (16#01772#, 16#01773#)  TAGBANWA VOWEL SIGN I .. TAGBANWA VOWEL SIGN U
     Lo,  -- (16#01780#, 16#017B3#)  KHMER LETTER KA .. KHMER INDEPENDENT VOWEL QAU
     Cf,  -- (16#017B4#, 16#017B5#)  KHMER VOWEL INHERENT AQ .. KHMER VOWEL INHERENT AA
     Mc,  -- (16#017B6#, 16#017B6#)  KHMER VOWEL SIGN AA .. KHMER VOWEL SIGN AA
     Mn,  -- (16#017B7#, 16#017BD#)  KHMER VOWEL SIGN I .. KHMER VOWEL SIGN UA
     Mc,  -- (16#017BE#, 16#017C5#)  KHMER VOWEL SIGN OE .. KHMER VOWEL SIGN AU
     Mn,  -- (16#017C6#, 16#017C6#)  KHMER SIGN NIKAHIT .. KHMER SIGN NIKAHIT
     Mc,  -- (16#017C7#, 16#017C8#)  KHMER SIGN REAHMUK .. KHMER SIGN YUUKALEAPINTU
     Mn,  -- (16#017C9#, 16#017D3#)  KHMER SIGN MUUSIKATOAN .. KHMER SIGN BATHAMASAT
     Po,  -- (16#017D4#, 16#017D6#)  KHMER SIGN KHAN .. KHMER SIGN CAMNUC PII KUUH
     Lm,  -- (16#017D7#, 16#017D7#)  KHMER SIGN LEK TOO .. KHMER SIGN LEK TOO
     Po,  -- (16#017D8#, 16#017DA#)  KHMER SIGN BEYYAL .. KHMER SIGN KOOMUUT
     Sc,  -- (16#017DB#, 16#017DB#)  KHMER CURRENCY SYMBOL RIEL .. KHMER CURRENCY SYMBOL RIEL
     Lo,  -- (16#017DC#, 16#017DC#)  KHMER SIGN AVAKRAHASANYA .. KHMER SIGN AVAKRAHASANYA
     Mn,  -- (16#017DD#, 16#017DD#)  KHMER SIGN ATTHACAN .. KHMER SIGN ATTHACAN
     Nd,  -- (16#017E0#, 16#017E9#)  KHMER DIGIT ZERO .. KHMER DIGIT NINE
     No,  -- (16#017F0#, 16#017F9#)  KHMER SYMBOL LEK ATTAK SON .. KHMER SYMBOL LEK ATTAK PRAM-BUON
     Po,  -- (16#01800#, 16#01805#)  MONGOLIAN BIRGA .. MONGOLIAN FOUR DOTS
     Pd,  -- (16#01806#, 16#01806#)  MONGOLIAN TODO SOFT HYPHEN .. MONGOLIAN TODO SOFT HYPHEN
     Po,  -- (16#01807#, 16#0180A#)  MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER .. MONGOLIAN NIRUGU
     Mn,  -- (16#0180B#, 16#0180D#)  MONGOLIAN FREE VARIATION SELECTOR ONE .. MONGOLIAN FREE VARIATION SELECTOR THREE
     Zs,  -- (16#0180E#, 16#0180E#)  MONGOLIAN VOWEL SEPARATOR .. MONGOLIAN VOWEL SEPARATOR
     Nd,  -- (16#01810#, 16#01819#)  MONGOLIAN DIGIT ZERO .. MONGOLIAN DIGIT NINE
     Lo,  -- (16#01820#, 16#01842#)  MONGOLIAN LETTER A .. MONGOLIAN LETTER CHI
     Lm,  -- (16#01843#, 16#01843#)  MONGOLIAN LETTER TODO LONG VOWEL SIGN .. MONGOLIAN LETTER TODO LONG VOWEL SIGN
     Lo,  -- (16#01844#, 16#01877#)  MONGOLIAN LETTER TODO E .. MONGOLIAN LETTER MANCHU ZHA
     Lo,  -- (16#01880#, 16#018A8#)  MONGOLIAN LETTER ALI GALI ANUSVARA ONE .. MONGOLIAN LETTER MANCHU ALI GALI BHA
     Mn,  -- (16#018A9#, 16#018A9#)  MONGOLIAN LETTER ALI GALI DAGALGA .. MONGOLIAN LETTER ALI GALI DAGALGA
     Lo,  -- (16#01900#, 16#0191C#)  LIMBU VOWEL-CARRIER LETTER .. LIMBU LETTER HA
     Mn,  -- (16#01920#, 16#01922#)  LIMBU VOWEL SIGN A .. LIMBU VOWEL SIGN U
     Mc,  -- (16#01923#, 16#01926#)  LIMBU VOWEL SIGN EE .. LIMBU VOWEL SIGN AU
     Mn,  -- (16#01927#, 16#01928#)  LIMBU VOWEL SIGN E .. LIMBU VOWEL SIGN O
     Mc,  -- (16#01929#, 16#0192B#)  LIMBU SUBJOINED LETTER YA .. LIMBU SUBJOINED LETTER WA
     Mc,  -- (16#01930#, 16#01931#)  LIMBU SMALL LETTER KA .. LIMBU SMALL LETTER NGA
     Mn,  -- (16#01932#, 16#01932#)  LIMBU SMALL LETTER ANUSVARA .. LIMBU SMALL LETTER ANUSVARA
     Mc,  -- (16#01933#, 16#01938#)  LIMBU SMALL LETTER TA .. LIMBU SMALL LETTER LA
     Mn,  -- (16#01939#, 16#0193B#)  LIMBU SIGN MUKPHRENG .. LIMBU SIGN SA-I
     So,  -- (16#01940#, 16#01940#)  LIMBU SIGN LOO .. LIMBU SIGN LOO
     Po,  -- (16#01944#, 16#01945#)  LIMBU EXCLAMATION MARK .. LIMBU QUESTION MARK
     Nd,  -- (16#01946#, 16#0194F#)  LIMBU DIGIT ZERO .. LIMBU DIGIT NINE
     Lo,  -- (16#01950#, 16#0196D#)  TAI LE LETTER KA .. TAI LE LETTER AI
     Lo,  -- (16#01970#, 16#01974#)  TAI LE LETTER TONE-2 .. TAI LE LETTER TONE-6
     So,  -- (16#019E0#, 16#019FF#)  KHMER SYMBOL PATHAMASAT .. KHMER SYMBOL DAP-PRAM ROC
     Ll,  -- (16#01D00#, 16#01D2B#)  LATIN LETTER SMALL CAPITAL A .. CYRILLIC LETTER SMALL CAPITAL EL
     Lm,  -- (16#01D2C#, 16#01D61#)  MODIFIER LETTER CAPITAL A .. MODIFIER LETTER SMALL CHI
     Ll,  -- (16#01D62#, 16#01D6B#)  LATIN SUBSCRIPT SMALL LETTER I .. LATIN SMALL LETTER UE
     Lu,  -- (16#01E00#, 16#01E00#)  LATIN CAPITAL LETTER A WITH RING BELOW .. LATIN CAPITAL LETTER A WITH RING BELOW
     Ll,  -- (16#01E01#, 16#01E01#)  LATIN SMALL LETTER A WITH RING BELOW .. LATIN SMALL LETTER A WITH RING BELOW
     Lu,  -- (16#01E02#, 16#01E02#)  LATIN CAPITAL LETTER B WITH DOT ABOVE .. LATIN CAPITAL LETTER B WITH DOT ABOVE
     Ll,  -- (16#01E03#, 16#01E03#)  LATIN SMALL LETTER B WITH DOT ABOVE .. LATIN SMALL LETTER B WITH DOT ABOVE
     Lu,  -- (16#01E04#, 16#01E04#)  LATIN CAPITAL LETTER B WITH DOT BELOW .. LATIN CAPITAL LETTER B WITH DOT BELOW
     Ll,  -- (16#01E05#, 16#01E05#)  LATIN SMALL LETTER B WITH DOT BELOW .. LATIN SMALL LETTER B WITH DOT BELOW
     Lu,  -- (16#01E06#, 16#01E06#)  LATIN CAPITAL LETTER B WITH LINE BELOW .. LATIN CAPITAL LETTER B WITH LINE BELOW
     Ll,  -- (16#01E07#, 16#01E07#)  LATIN SMALL LETTER B WITH LINE BELOW .. LATIN SMALL LETTER B WITH LINE BELOW
     Lu,  -- (16#01E08#, 16#01E08#)  LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE .. LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
     Ll,  -- (16#01E09#, 16#01E09#)  LATIN SMALL LETTER C WITH CEDILLA AND ACUTE .. LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
     Lu,  -- (16#01E0A#, 16#01E0A#)  LATIN CAPITAL LETTER D WITH DOT ABOVE .. LATIN CAPITAL LETTER D WITH DOT ABOVE
     Ll,  -- (16#01E0B#, 16#01E0B#)  LATIN SMALL LETTER D WITH DOT ABOVE .. LATIN SMALL LETTER D WITH DOT ABOVE
     Lu,  -- (16#01E0C#, 16#01E0C#)  LATIN CAPITAL LETTER D WITH DOT BELOW .. LATIN CAPITAL LETTER D WITH DOT BELOW
     Ll,  -- (16#01E0D#, 16#01E0D#)  LATIN SMALL LETTER D WITH DOT BELOW .. LATIN SMALL LETTER D WITH DOT BELOW
     Lu,  -- (16#01E0E#, 16#01E0E#)  LATIN CAPITAL LETTER D WITH LINE BELOW .. LATIN CAPITAL LETTER D WITH LINE BELOW
     Ll,  -- (16#01E0F#, 16#01E0F#)  LATIN SMALL LETTER D WITH LINE BELOW .. LATIN SMALL LETTER D WITH LINE BELOW
     Lu,  -- (16#01E10#, 16#01E10#)  LATIN CAPITAL LETTER D WITH CEDILLA .. LATIN CAPITAL LETTER D WITH CEDILLA
     Ll,  -- (16#01E11#, 16#01E11#)  LATIN SMALL LETTER D WITH CEDILLA .. LATIN SMALL LETTER D WITH CEDILLA
     Lu,  -- (16#01E12#, 16#01E12#)  LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
     Ll,  -- (16#01E13#, 16#01E13#)  LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
     Lu,  -- (16#01E14#, 16#01E14#)  LATIN CAPITAL LETTER E WITH MACRON AND GRAVE .. LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
     Ll,  -- (16#01E15#, 16#01E15#)  LATIN SMALL LETTER E WITH MACRON AND GRAVE .. LATIN SMALL LETTER E WITH MACRON AND GRAVE
     Lu,  -- (16#01E16#, 16#01E16#)  LATIN CAPITAL LETTER E WITH MACRON AND ACUTE .. LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
     Ll,  -- (16#01E17#, 16#01E17#)  LATIN SMALL LETTER E WITH MACRON AND ACUTE .. LATIN SMALL LETTER E WITH MACRON AND ACUTE
     Lu,  -- (16#01E18#, 16#01E18#)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
     Ll,  -- (16#01E19#, 16#01E19#)  LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
     Lu,  -- (16#01E1A#, 16#01E1A#)  LATIN CAPITAL LETTER E WITH TILDE BELOW .. LATIN CAPITAL LETTER E WITH TILDE BELOW
     Ll,  -- (16#01E1B#, 16#01E1B#)  LATIN SMALL LETTER E WITH TILDE BELOW .. LATIN SMALL LETTER E WITH TILDE BELOW
     Lu,  -- (16#01E1C#, 16#01E1C#)  LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE .. LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
     Ll,  -- (16#01E1D#, 16#01E1D#)  LATIN SMALL LETTER E WITH CEDILLA AND BREVE .. LATIN SMALL LETTER E WITH CEDILLA AND BREVE
     Lu,  -- (16#01E1E#, 16#01E1E#)  LATIN CAPITAL LETTER F WITH DOT ABOVE .. LATIN CAPITAL LETTER F WITH DOT ABOVE
     Ll,  -- (16#01E1F#, 16#01E1F#)  LATIN SMALL LETTER F WITH DOT ABOVE .. LATIN SMALL LETTER F WITH DOT ABOVE
     Lu,  -- (16#01E20#, 16#01E20#)  LATIN CAPITAL LETTER G WITH MACRON .. LATIN CAPITAL LETTER G WITH MACRON
     Ll,  -- (16#01E21#, 16#01E21#)  LATIN SMALL LETTER G WITH MACRON .. LATIN SMALL LETTER G WITH MACRON
     Lu,  -- (16#01E22#, 16#01E22#)  LATIN CAPITAL LETTER H WITH DOT ABOVE .. LATIN CAPITAL LETTER H WITH DOT ABOVE
     Ll,  -- (16#01E23#, 16#01E23#)  LATIN SMALL LETTER H WITH DOT ABOVE .. LATIN SMALL LETTER H WITH DOT ABOVE
     Lu,  -- (16#01E24#, 16#01E24#)  LATIN CAPITAL LETTER H WITH DOT BELOW .. LATIN CAPITAL LETTER H WITH DOT BELOW
     Ll,  -- (16#01E25#, 16#01E25#)  LATIN SMALL LETTER H WITH DOT BELOW .. LATIN SMALL LETTER H WITH DOT BELOW
     Lu,  -- (16#01E26#, 16#01E26#)  LATIN CAPITAL LETTER H WITH DIAERESIS .. LATIN CAPITAL LETTER H WITH DIAERESIS
     Ll,  -- (16#01E27#, 16#01E27#)  LATIN SMALL LETTER H WITH DIAERESIS .. LATIN SMALL LETTER H WITH DIAERESIS
     Lu,  -- (16#01E28#, 16#01E28#)  LATIN CAPITAL LETTER H WITH CEDILLA .. LATIN CAPITAL LETTER H WITH CEDILLA
     Ll,  -- (16#01E29#, 16#01E29#)  LATIN SMALL LETTER H WITH CEDILLA .. LATIN SMALL LETTER H WITH CEDILLA
     Lu,  -- (16#01E2A#, 16#01E2A#)  LATIN CAPITAL LETTER H WITH BREVE BELOW .. LATIN CAPITAL LETTER H WITH BREVE BELOW
     Ll,  -- (16#01E2B#, 16#01E2B#)  LATIN SMALL LETTER H WITH BREVE BELOW .. LATIN SMALL LETTER H WITH BREVE BELOW
     Lu,  -- (16#01E2C#, 16#01E2C#)  LATIN CAPITAL LETTER I WITH TILDE BELOW .. LATIN CAPITAL LETTER I WITH TILDE BELOW
     Ll,  -- (16#01E2D#, 16#01E2D#)  LATIN SMALL LETTER I WITH TILDE BELOW .. LATIN SMALL LETTER I WITH TILDE BELOW
     Lu,  -- (16#01E2E#, 16#01E2E#)  LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE .. LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
     Ll,  -- (16#01E2F#, 16#01E2F#)  LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
     Lu,  -- (16#01E30#, 16#01E30#)  LATIN CAPITAL LETTER K WITH ACUTE .. LATIN CAPITAL LETTER K WITH ACUTE
     Ll,  -- (16#01E31#, 16#01E31#)  LATIN SMALL LETTER K WITH ACUTE .. LATIN SMALL LETTER K WITH ACUTE
     Lu,  -- (16#01E32#, 16#01E32#)  LATIN CAPITAL LETTER K WITH DOT BELOW .. LATIN CAPITAL LETTER K WITH DOT BELOW
     Ll,  -- (16#01E33#, 16#01E33#)  LATIN SMALL LETTER K WITH DOT BELOW .. LATIN SMALL LETTER K WITH DOT BELOW
     Lu,  -- (16#01E34#, 16#01E34#)  LATIN CAPITAL LETTER K WITH LINE BELOW .. LATIN CAPITAL LETTER K WITH LINE BELOW
     Ll,  -- (16#01E35#, 16#01E35#)  LATIN SMALL LETTER K WITH LINE BELOW .. LATIN SMALL LETTER K WITH LINE BELOW
     Lu,  -- (16#01E36#, 16#01E36#)  LATIN CAPITAL LETTER L WITH DOT BELOW .. LATIN CAPITAL LETTER L WITH DOT BELOW
     Ll,  -- (16#01E37#, 16#01E37#)  LATIN SMALL LETTER L WITH DOT BELOW .. LATIN SMALL LETTER L WITH DOT BELOW
     Lu,  -- (16#01E38#, 16#01E38#)  LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON .. LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
     Ll,  -- (16#01E39#, 16#01E39#)  LATIN SMALL LETTER L WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
     Lu,  -- (16#01E3A#, 16#01E3A#)  LATIN CAPITAL LETTER L WITH LINE BELOW .. LATIN CAPITAL LETTER L WITH LINE BELOW
     Ll,  -- (16#01E3B#, 16#01E3B#)  LATIN SMALL LETTER L WITH LINE BELOW .. LATIN SMALL LETTER L WITH LINE BELOW
     Lu,  -- (16#01E3C#, 16#01E3C#)  LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
     Ll,  -- (16#01E3D#, 16#01E3D#)  LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
     Lu,  -- (16#01E3E#, 16#01E3E#)  LATIN CAPITAL LETTER M WITH ACUTE .. LATIN CAPITAL LETTER M WITH ACUTE
     Ll,  -- (16#01E3F#, 16#01E3F#)  LATIN SMALL LETTER M WITH ACUTE .. LATIN SMALL LETTER M WITH ACUTE
     Lu,  -- (16#01E40#, 16#01E40#)  LATIN CAPITAL LETTER M WITH DOT ABOVE .. LATIN CAPITAL LETTER M WITH DOT ABOVE
     Ll,  -- (16#01E41#, 16#01E41#)  LATIN SMALL LETTER M WITH DOT ABOVE .. LATIN SMALL LETTER M WITH DOT ABOVE
     Lu,  -- (16#01E42#, 16#01E42#)  LATIN CAPITAL LETTER M WITH DOT BELOW .. LATIN CAPITAL LETTER M WITH DOT BELOW
     Ll,  -- (16#01E43#, 16#01E43#)  LATIN SMALL LETTER M WITH DOT BELOW .. LATIN SMALL LETTER M WITH DOT BELOW
     Lu,  -- (16#01E44#, 16#01E44#)  LATIN CAPITAL LETTER N WITH DOT ABOVE .. LATIN CAPITAL LETTER N WITH DOT ABOVE
     Ll,  -- (16#01E45#, 16#01E45#)  LATIN SMALL LETTER N WITH DOT ABOVE .. LATIN SMALL LETTER N WITH DOT ABOVE
     Lu,  -- (16#01E46#, 16#01E46#)  LATIN CAPITAL LETTER N WITH DOT BELOW .. LATIN CAPITAL LETTER N WITH DOT BELOW
     Ll,  -- (16#01E47#, 16#01E47#)  LATIN SMALL LETTER N WITH DOT BELOW .. LATIN SMALL LETTER N WITH DOT BELOW
     Lu,  -- (16#01E48#, 16#01E48#)  LATIN CAPITAL LETTER N WITH LINE BELOW .. LATIN CAPITAL LETTER N WITH LINE BELOW
     Ll,  -- (16#01E49#, 16#01E49#)  LATIN SMALL LETTER N WITH LINE BELOW .. LATIN SMALL LETTER N WITH LINE BELOW
     Lu,  -- (16#01E4A#, 16#01E4A#)  LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
     Ll,  -- (16#01E4B#, 16#01E4B#)  LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
     Lu,  -- (16#01E4C#, 16#01E4C#)  LATIN CAPITAL LETTER O WITH TILDE AND ACUTE .. LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
     Ll,  -- (16#01E4D#, 16#01E4D#)  LATIN SMALL LETTER O WITH TILDE AND ACUTE .. LATIN SMALL LETTER O WITH TILDE AND ACUTE
     Lu,  -- (16#01E4E#, 16#01E4E#)  LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS .. LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
     Ll,  -- (16#01E4F#, 16#01E4F#)  LATIN SMALL LETTER O WITH TILDE AND DIAERESIS .. LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
     Lu,  -- (16#01E50#, 16#01E50#)  LATIN CAPITAL LETTER O WITH MACRON AND GRAVE .. LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
     Ll,  -- (16#01E51#, 16#01E51#)  LATIN SMALL LETTER O WITH MACRON AND GRAVE .. LATIN SMALL LETTER O WITH MACRON AND GRAVE
     Lu,  -- (16#01E52#, 16#01E52#)  LATIN CAPITAL LETTER O WITH MACRON AND ACUTE .. LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
     Ll,  -- (16#01E53#, 16#01E53#)  LATIN SMALL LETTER O WITH MACRON AND ACUTE .. LATIN SMALL LETTER O WITH MACRON AND ACUTE
     Lu,  -- (16#01E54#, 16#01E54#)  LATIN CAPITAL LETTER P WITH ACUTE .. LATIN CAPITAL LETTER P WITH ACUTE
     Ll,  -- (16#01E55#, 16#01E55#)  LATIN SMALL LETTER P WITH ACUTE .. LATIN SMALL LETTER P WITH ACUTE
     Lu,  -- (16#01E56#, 16#01E56#)  LATIN CAPITAL LETTER P WITH DOT ABOVE .. LATIN CAPITAL LETTER P WITH DOT ABOVE
     Ll,  -- (16#01E57#, 16#01E57#)  LATIN SMALL LETTER P WITH DOT ABOVE .. LATIN SMALL LETTER P WITH DOT ABOVE
     Lu,  -- (16#01E58#, 16#01E58#)  LATIN CAPITAL LETTER R WITH DOT ABOVE .. LATIN CAPITAL LETTER R WITH DOT ABOVE
     Ll,  -- (16#01E59#, 16#01E59#)  LATIN SMALL LETTER R WITH DOT ABOVE .. LATIN SMALL LETTER R WITH DOT ABOVE
     Lu,  -- (16#01E5A#, 16#01E5A#)  LATIN CAPITAL LETTER R WITH DOT BELOW .. LATIN CAPITAL LETTER R WITH DOT BELOW
     Ll,  -- (16#01E5B#, 16#01E5B#)  LATIN SMALL LETTER R WITH DOT BELOW .. LATIN SMALL LETTER R WITH DOT BELOW
     Lu,  -- (16#01E5C#, 16#01E5C#)  LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON .. LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
     Ll,  -- (16#01E5D#, 16#01E5D#)  LATIN SMALL LETTER R WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
     Lu,  -- (16#01E5E#, 16#01E5E#)  LATIN CAPITAL LETTER R WITH LINE BELOW .. LATIN CAPITAL LETTER R WITH LINE BELOW
     Ll,  -- (16#01E5F#, 16#01E5F#)  LATIN SMALL LETTER R WITH LINE BELOW .. LATIN SMALL LETTER R WITH LINE BELOW
     Lu,  -- (16#01E60#, 16#01E60#)  LATIN CAPITAL LETTER S WITH DOT ABOVE .. LATIN CAPITAL LETTER S WITH DOT ABOVE
     Ll,  -- (16#01E61#, 16#01E61#)  LATIN SMALL LETTER S WITH DOT ABOVE .. LATIN SMALL LETTER S WITH DOT ABOVE
     Lu,  -- (16#01E62#, 16#01E62#)  LATIN CAPITAL LETTER S WITH DOT BELOW .. LATIN CAPITAL LETTER S WITH DOT BELOW
     Ll,  -- (16#01E63#, 16#01E63#)  LATIN SMALL LETTER S WITH DOT BELOW .. LATIN SMALL LETTER S WITH DOT BELOW
     Lu,  -- (16#01E64#, 16#01E64#)  LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
     Ll,  -- (16#01E65#, 16#01E65#)  LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
     Lu,  -- (16#01E66#, 16#01E66#)  LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
     Ll,  -- (16#01E67#, 16#01E67#)  LATIN SMALL LETTER S WITH CARON AND DOT ABOVE .. LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
     Lu,  -- (16#01E68#, 16#01E68#)  LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
     Ll,  -- (16#01E69#, 16#01E69#)  LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
     Lu,  -- (16#01E6A#, 16#01E6A#)  LATIN CAPITAL LETTER T WITH DOT ABOVE .. LATIN CAPITAL LETTER T WITH DOT ABOVE
     Ll,  -- (16#01E6B#, 16#01E6B#)  LATIN SMALL LETTER T WITH DOT ABOVE .. LATIN SMALL LETTER T WITH DOT ABOVE
     Lu,  -- (16#01E6C#, 16#01E6C#)  LATIN CAPITAL LETTER T WITH DOT BELOW .. LATIN CAPITAL LETTER T WITH DOT BELOW
     Ll,  -- (16#01E6D#, 16#01E6D#)  LATIN SMALL LETTER T WITH DOT BELOW .. LATIN SMALL LETTER T WITH DOT BELOW
     Lu,  -- (16#01E6E#, 16#01E6E#)  LATIN CAPITAL LETTER T WITH LINE BELOW .. LATIN CAPITAL LETTER T WITH LINE BELOW
     Ll,  -- (16#01E6F#, 16#01E6F#)  LATIN SMALL LETTER T WITH LINE BELOW .. LATIN SMALL LETTER T WITH LINE BELOW
     Lu,  -- (16#01E70#, 16#01E70#)  LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
     Ll,  -- (16#01E71#, 16#01E71#)  LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
     Lu,  -- (16#01E72#, 16#01E72#)  LATIN CAPITAL LETTER U WITH DIAERESIS BELOW .. LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
     Ll,  -- (16#01E73#, 16#01E73#)  LATIN SMALL LETTER U WITH DIAERESIS BELOW .. LATIN SMALL LETTER U WITH DIAERESIS BELOW
     Lu,  -- (16#01E74#, 16#01E74#)  LATIN CAPITAL LETTER U WITH TILDE BELOW .. LATIN CAPITAL LETTER U WITH TILDE BELOW
     Ll,  -- (16#01E75#, 16#01E75#)  LATIN SMALL LETTER U WITH TILDE BELOW .. LATIN SMALL LETTER U WITH TILDE BELOW
     Lu,  -- (16#01E76#, 16#01E76#)  LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
     Ll,  -- (16#01E77#, 16#01E77#)  LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
     Lu,  -- (16#01E78#, 16#01E78#)  LATIN CAPITAL LETTER U WITH TILDE AND ACUTE .. LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
     Ll,  -- (16#01E79#, 16#01E79#)  LATIN SMALL LETTER U WITH TILDE AND ACUTE .. LATIN SMALL LETTER U WITH TILDE AND ACUTE
     Lu,  -- (16#01E7A#, 16#01E7A#)  LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS .. LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
     Ll,  -- (16#01E7B#, 16#01E7B#)  LATIN SMALL LETTER U WITH MACRON AND DIAERESIS .. LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
     Lu,  -- (16#01E7C#, 16#01E7C#)  LATIN CAPITAL LETTER V WITH TILDE .. LATIN CAPITAL LETTER V WITH TILDE
     Ll,  -- (16#01E7D#, 16#01E7D#)  LATIN SMALL LETTER V WITH TILDE .. LATIN SMALL LETTER V WITH TILDE
     Lu,  -- (16#01E7E#, 16#01E7E#)  LATIN CAPITAL LETTER V WITH DOT BELOW .. LATIN CAPITAL LETTER V WITH DOT BELOW
     Ll,  -- (16#01E7F#, 16#01E7F#)  LATIN SMALL LETTER V WITH DOT BELOW .. LATIN SMALL LETTER V WITH DOT BELOW
     Lu,  -- (16#01E80#, 16#01E80#)  LATIN CAPITAL LETTER W WITH GRAVE .. LATIN CAPITAL LETTER W WITH GRAVE
     Ll,  -- (16#01E81#, 16#01E81#)  LATIN SMALL LETTER W WITH GRAVE .. LATIN SMALL LETTER W WITH GRAVE
     Lu,  -- (16#01E82#, 16#01E82#)  LATIN CAPITAL LETTER W WITH ACUTE .. LATIN CAPITAL LETTER W WITH ACUTE
     Ll,  -- (16#01E83#, 16#01E83#)  LATIN SMALL LETTER W WITH ACUTE .. LATIN SMALL LETTER W WITH ACUTE
     Lu,  -- (16#01E84#, 16#01E84#)  LATIN CAPITAL LETTER W WITH DIAERESIS .. LATIN CAPITAL LETTER W WITH DIAERESIS
     Ll,  -- (16#01E85#, 16#01E85#)  LATIN SMALL LETTER W WITH DIAERESIS .. LATIN SMALL LETTER W WITH DIAERESIS
     Lu,  -- (16#01E86#, 16#01E86#)  LATIN CAPITAL LETTER W WITH DOT ABOVE .. LATIN CAPITAL LETTER W WITH DOT ABOVE
     Ll,  -- (16#01E87#, 16#01E87#)  LATIN SMALL LETTER W WITH DOT ABOVE .. LATIN SMALL LETTER W WITH DOT ABOVE
     Lu,  -- (16#01E88#, 16#01E88#)  LATIN CAPITAL LETTER W WITH DOT BELOW .. LATIN CAPITAL LETTER W WITH DOT BELOW
     Ll,  -- (16#01E89#, 16#01E89#)  LATIN SMALL LETTER W WITH DOT BELOW .. LATIN SMALL LETTER W WITH DOT BELOW
     Lu,  -- (16#01E8A#, 16#01E8A#)  LATIN CAPITAL LETTER X WITH DOT ABOVE .. LATIN CAPITAL LETTER X WITH DOT ABOVE
     Ll,  -- (16#01E8B#, 16#01E8B#)  LATIN SMALL LETTER X WITH DOT ABOVE .. LATIN SMALL LETTER X WITH DOT ABOVE
     Lu,  -- (16#01E8C#, 16#01E8C#)  LATIN CAPITAL LETTER X WITH DIAERESIS .. LATIN CAPITAL LETTER X WITH DIAERESIS
     Ll,  -- (16#01E8D#, 16#01E8D#)  LATIN SMALL LETTER X WITH DIAERESIS .. LATIN SMALL LETTER X WITH DIAERESIS
     Lu,  -- (16#01E8E#, 16#01E8E#)  LATIN CAPITAL LETTER Y WITH DOT ABOVE .. LATIN CAPITAL LETTER Y WITH DOT ABOVE
     Ll,  -- (16#01E8F#, 16#01E8F#)  LATIN SMALL LETTER Y WITH DOT ABOVE .. LATIN SMALL LETTER Y WITH DOT ABOVE
     Lu,  -- (16#01E90#, 16#01E90#)  LATIN CAPITAL LETTER Z WITH CIRCUMFLEX .. LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
     Ll,  -- (16#01E91#, 16#01E91#)  LATIN SMALL LETTER Z WITH CIRCUMFLEX .. LATIN SMALL LETTER Z WITH CIRCUMFLEX
     Lu,  -- (16#01E92#, 16#01E92#)  LATIN CAPITAL LETTER Z WITH DOT BELOW .. LATIN CAPITAL LETTER Z WITH DOT BELOW
     Ll,  -- (16#01E93#, 16#01E93#)  LATIN SMALL LETTER Z WITH DOT BELOW .. LATIN SMALL LETTER Z WITH DOT BELOW
     Lu,  -- (16#01E94#, 16#01E94#)  LATIN CAPITAL LETTER Z WITH LINE BELOW .. LATIN CAPITAL LETTER Z WITH LINE BELOW
     Ll,  -- (16#01E95#, 16#01E9B#)  LATIN SMALL LETTER Z WITH LINE BELOW .. LATIN SMALL LETTER LONG S WITH DOT ABOVE
     Lu,  -- (16#01EA0#, 16#01EA0#)  LATIN CAPITAL LETTER A WITH DOT BELOW .. LATIN CAPITAL LETTER A WITH DOT BELOW
     Ll,  -- (16#01EA1#, 16#01EA1#)  LATIN SMALL LETTER A WITH DOT BELOW .. LATIN SMALL LETTER A WITH DOT BELOW
     Lu,  -- (16#01EA2#, 16#01EA2#)  LATIN CAPITAL LETTER A WITH HOOK ABOVE .. LATIN CAPITAL LETTER A WITH HOOK ABOVE
     Ll,  -- (16#01EA3#, 16#01EA3#)  LATIN SMALL LETTER A WITH HOOK ABOVE .. LATIN SMALL LETTER A WITH HOOK ABOVE
     Lu,  -- (16#01EA4#, 16#01EA4#)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
     Ll,  -- (16#01EA5#, 16#01EA5#)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
     Lu,  -- (16#01EA6#, 16#01EA6#)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
     Ll,  -- (16#01EA7#, 16#01EA7#)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
     Lu,  -- (16#01EA8#, 16#01EA8#)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     Ll,  -- (16#01EA9#, 16#01EA9#)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     Lu,  -- (16#01EAA#, 16#01EAA#)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
     Ll,  -- (16#01EAB#, 16#01EAB#)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
     Lu,  -- (16#01EAC#, 16#01EAC#)  LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     Ll,  -- (16#01EAD#, 16#01EAD#)  LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     Lu,  -- (16#01EAE#, 16#01EAE#)  LATIN CAPITAL LETTER A WITH BREVE AND ACUTE .. LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
     Ll,  -- (16#01EAF#, 16#01EAF#)  LATIN SMALL LETTER A WITH BREVE AND ACUTE .. LATIN SMALL LETTER A WITH BREVE AND ACUTE
     Lu,  -- (16#01EB0#, 16#01EB0#)  LATIN CAPITAL LETTER A WITH BREVE AND GRAVE .. LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
     Ll,  -- (16#01EB1#, 16#01EB1#)  LATIN SMALL LETTER A WITH BREVE AND GRAVE .. LATIN SMALL LETTER A WITH BREVE AND GRAVE
     Lu,  -- (16#01EB2#, 16#01EB2#)  LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
     Ll,  -- (16#01EB3#, 16#01EB3#)  LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
     Lu,  -- (16#01EB4#, 16#01EB4#)  LATIN CAPITAL LETTER A WITH BREVE AND TILDE .. LATIN CAPITAL LETTER A WITH BREVE AND TILDE
     Ll,  -- (16#01EB5#, 16#01EB5#)  LATIN SMALL LETTER A WITH BREVE AND TILDE .. LATIN SMALL LETTER A WITH BREVE AND TILDE
     Lu,  -- (16#01EB6#, 16#01EB6#)  LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW .. LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
     Ll,  -- (16#01EB7#, 16#01EB7#)  LATIN SMALL LETTER A WITH BREVE AND DOT BELOW .. LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
     Lu,  -- (16#01EB8#, 16#01EB8#)  LATIN CAPITAL LETTER E WITH DOT BELOW .. LATIN CAPITAL LETTER E WITH DOT BELOW
     Ll,  -- (16#01EB9#, 16#01EB9#)  LATIN SMALL LETTER E WITH DOT BELOW .. LATIN SMALL LETTER E WITH DOT BELOW
     Lu,  -- (16#01EBA#, 16#01EBA#)  LATIN CAPITAL LETTER E WITH HOOK ABOVE .. LATIN CAPITAL LETTER E WITH HOOK ABOVE
     Ll,  -- (16#01EBB#, 16#01EBB#)  LATIN SMALL LETTER E WITH HOOK ABOVE .. LATIN SMALL LETTER E WITH HOOK ABOVE
     Lu,  -- (16#01EBC#, 16#01EBC#)  LATIN CAPITAL LETTER E WITH TILDE .. LATIN CAPITAL LETTER E WITH TILDE
     Ll,  -- (16#01EBD#, 16#01EBD#)  LATIN SMALL LETTER E WITH TILDE .. LATIN SMALL LETTER E WITH TILDE
     Lu,  -- (16#01EBE#, 16#01EBE#)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
     Ll,  -- (16#01EBF#, 16#01EBF#)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
     Lu,  -- (16#01EC0#, 16#01EC0#)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
     Ll,  -- (16#01EC1#, 16#01EC1#)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
     Lu,  -- (16#01EC2#, 16#01EC2#)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     Ll,  -- (16#01EC3#, 16#01EC3#)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     Lu,  -- (16#01EC4#, 16#01EC4#)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
     Ll,  -- (16#01EC5#, 16#01EC5#)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
     Lu,  -- (16#01EC6#, 16#01EC6#)  LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     Ll,  -- (16#01EC7#, 16#01EC7#)  LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     Lu,  -- (16#01EC8#, 16#01EC8#)  LATIN CAPITAL LETTER I WITH HOOK ABOVE .. LATIN CAPITAL LETTER I WITH HOOK ABOVE
     Ll,  -- (16#01EC9#, 16#01EC9#)  LATIN SMALL LETTER I WITH HOOK ABOVE .. LATIN SMALL LETTER I WITH HOOK ABOVE
     Lu,  -- (16#01ECA#, 16#01ECA#)  LATIN CAPITAL LETTER I WITH DOT BELOW .. LATIN CAPITAL LETTER I WITH DOT BELOW
     Ll,  -- (16#01ECB#, 16#01ECB#)  LATIN SMALL LETTER I WITH DOT BELOW .. LATIN SMALL LETTER I WITH DOT BELOW
     Lu,  -- (16#01ECC#, 16#01ECC#)  LATIN CAPITAL LETTER O WITH DOT BELOW .. LATIN CAPITAL LETTER O WITH DOT BELOW
     Ll,  -- (16#01ECD#, 16#01ECD#)  LATIN SMALL LETTER O WITH DOT BELOW .. LATIN SMALL LETTER O WITH DOT BELOW
     Lu,  -- (16#01ECE#, 16#01ECE#)  LATIN CAPITAL LETTER O WITH HOOK ABOVE .. LATIN CAPITAL LETTER O WITH HOOK ABOVE
     Ll,  -- (16#01ECF#, 16#01ECF#)  LATIN SMALL LETTER O WITH HOOK ABOVE .. LATIN SMALL LETTER O WITH HOOK ABOVE
     Lu,  -- (16#01ED0#, 16#01ED0#)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
     Ll,  -- (16#01ED1#, 16#01ED1#)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
     Lu,  -- (16#01ED2#, 16#01ED2#)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
     Ll,  -- (16#01ED3#, 16#01ED3#)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
     Lu,  -- (16#01ED4#, 16#01ED4#)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     Ll,  -- (16#01ED5#, 16#01ED5#)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     Lu,  -- (16#01ED6#, 16#01ED6#)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
     Ll,  -- (16#01ED7#, 16#01ED7#)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
     Lu,  -- (16#01ED8#, 16#01ED8#)  LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     Ll,  -- (16#01ED9#, 16#01ED9#)  LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     Lu,  -- (16#01EDA#, 16#01EDA#)  LATIN CAPITAL LETTER O WITH HORN AND ACUTE .. LATIN CAPITAL LETTER O WITH HORN AND ACUTE
     Ll,  -- (16#01EDB#, 16#01EDB#)  LATIN SMALL LETTER O WITH HORN AND ACUTE .. LATIN SMALL LETTER O WITH HORN AND ACUTE
     Lu,  -- (16#01EDC#, 16#01EDC#)  LATIN CAPITAL LETTER O WITH HORN AND GRAVE .. LATIN CAPITAL LETTER O WITH HORN AND GRAVE
     Ll,  -- (16#01EDD#, 16#01EDD#)  LATIN SMALL LETTER O WITH HORN AND GRAVE .. LATIN SMALL LETTER O WITH HORN AND GRAVE
     Lu,  -- (16#01EDE#, 16#01EDE#)  LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE .. LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
     Ll,  -- (16#01EDF#, 16#01EDF#)  LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
     Lu,  -- (16#01EE0#, 16#01EE0#)  LATIN CAPITAL LETTER O WITH HORN AND TILDE .. LATIN CAPITAL LETTER O WITH HORN AND TILDE
     Ll,  -- (16#01EE1#, 16#01EE1#)  LATIN SMALL LETTER O WITH HORN AND TILDE .. LATIN SMALL LETTER O WITH HORN AND TILDE
     Lu,  -- (16#01EE2#, 16#01EE2#)  LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW .. LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
     Ll,  -- (16#01EE3#, 16#01EE3#)  LATIN SMALL LETTER O WITH HORN AND DOT BELOW .. LATIN SMALL LETTER O WITH HORN AND DOT BELOW
     Lu,  -- (16#01EE4#, 16#01EE4#)  LATIN CAPITAL LETTER U WITH DOT BELOW .. LATIN CAPITAL LETTER U WITH DOT BELOW
     Ll,  -- (16#01EE5#, 16#01EE5#)  LATIN SMALL LETTER U WITH DOT BELOW .. LATIN SMALL LETTER U WITH DOT BELOW
     Lu,  -- (16#01EE6#, 16#01EE6#)  LATIN CAPITAL LETTER U WITH HOOK ABOVE .. LATIN CAPITAL LETTER U WITH HOOK ABOVE
     Ll,  -- (16#01EE7#, 16#01EE7#)  LATIN SMALL LETTER U WITH HOOK ABOVE .. LATIN SMALL LETTER U WITH HOOK ABOVE
     Lu,  -- (16#01EE8#, 16#01EE8#)  LATIN CAPITAL LETTER U WITH HORN AND ACUTE .. LATIN CAPITAL LETTER U WITH HORN AND ACUTE
     Ll,  -- (16#01EE9#, 16#01EE9#)  LATIN SMALL LETTER U WITH HORN AND ACUTE .. LATIN SMALL LETTER U WITH HORN AND ACUTE
     Lu,  -- (16#01EEA#, 16#01EEA#)  LATIN CAPITAL LETTER U WITH HORN AND GRAVE .. LATIN CAPITAL LETTER U WITH HORN AND GRAVE
     Ll,  -- (16#01EEB#, 16#01EEB#)  LATIN SMALL LETTER U WITH HORN AND GRAVE .. LATIN SMALL LETTER U WITH HORN AND GRAVE
     Lu,  -- (16#01EEC#, 16#01EEC#)  LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE .. LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
     Ll,  -- (16#01EED#, 16#01EED#)  LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
     Lu,  -- (16#01EEE#, 16#01EEE#)  LATIN CAPITAL LETTER U WITH HORN AND TILDE .. LATIN CAPITAL LETTER U WITH HORN AND TILDE
     Ll,  -- (16#01EEF#, 16#01EEF#)  LATIN SMALL LETTER U WITH HORN AND TILDE .. LATIN SMALL LETTER U WITH HORN AND TILDE
     Lu,  -- (16#01EF0#, 16#01EF0#)  LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW .. LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
     Ll,  -- (16#01EF1#, 16#01EF1#)  LATIN SMALL LETTER U WITH HORN AND DOT BELOW .. LATIN SMALL LETTER U WITH HORN AND DOT BELOW
     Lu,  -- (16#01EF2#, 16#01EF2#)  LATIN CAPITAL LETTER Y WITH GRAVE .. LATIN CAPITAL LETTER Y WITH GRAVE
     Ll,  -- (16#01EF3#, 16#01EF3#)  LATIN SMALL LETTER Y WITH GRAVE .. LATIN SMALL LETTER Y WITH GRAVE
     Lu,  -- (16#01EF4#, 16#01EF4#)  LATIN CAPITAL LETTER Y WITH DOT BELOW .. LATIN CAPITAL LETTER Y WITH DOT BELOW
     Ll,  -- (16#01EF5#, 16#01EF5#)  LATIN SMALL LETTER Y WITH DOT BELOW .. LATIN SMALL LETTER Y WITH DOT BELOW
     Lu,  -- (16#01EF6#, 16#01EF6#)  LATIN CAPITAL LETTER Y WITH HOOK ABOVE .. LATIN CAPITAL LETTER Y WITH HOOK ABOVE
     Ll,  -- (16#01EF7#, 16#01EF7#)  LATIN SMALL LETTER Y WITH HOOK ABOVE .. LATIN SMALL LETTER Y WITH HOOK ABOVE
     Lu,  -- (16#01EF8#, 16#01EF8#)  LATIN CAPITAL LETTER Y WITH TILDE .. LATIN CAPITAL LETTER Y WITH TILDE
     Ll,  -- (16#01EF9#, 16#01EF9#)  LATIN SMALL LETTER Y WITH TILDE .. LATIN SMALL LETTER Y WITH TILDE
     Ll,  -- (16#01F00#, 16#01F07#)  GREEK SMALL LETTER ALPHA WITH PSILI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
     Lu,  -- (16#01F08#, 16#01F0F#)  GREEK CAPITAL LETTER ALPHA WITH PSILI .. GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
     Ll,  -- (16#01F10#, 16#01F15#)  GREEK SMALL LETTER EPSILON WITH PSILI .. GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
     Lu,  -- (16#01F18#, 16#01F1D#)  GREEK CAPITAL LETTER EPSILON WITH PSILI .. GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
     Ll,  -- (16#01F20#, 16#01F27#)  GREEK SMALL LETTER ETA WITH PSILI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
     Lu,  -- (16#01F28#, 16#01F2F#)  GREEK CAPITAL LETTER ETA WITH PSILI .. GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
     Ll,  -- (16#01F30#, 16#01F37#)  GREEK SMALL LETTER IOTA WITH PSILI .. GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
     Lu,  -- (16#01F38#, 16#01F3F#)  GREEK CAPITAL LETTER IOTA WITH PSILI .. GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
     Ll,  -- (16#01F40#, 16#01F45#)  GREEK SMALL LETTER OMICRON WITH PSILI .. GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
     Lu,  -- (16#01F48#, 16#01F4D#)  GREEK CAPITAL LETTER OMICRON WITH PSILI .. GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
     Ll,  -- (16#01F50#, 16#01F57#)  GREEK SMALL LETTER UPSILON WITH PSILI .. GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
     Lu,  -- (16#01F59#, 16#01F59#)  GREEK CAPITAL LETTER UPSILON WITH DASIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA
     Lu,  -- (16#01F5B#, 16#01F5B#)  GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
     Lu,  -- (16#01F5D#, 16#01F5D#)  GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
     Lu,  -- (16#01F5F#, 16#01F5F#)  GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
     Ll,  -- (16#01F60#, 16#01F67#)  GREEK SMALL LETTER OMEGA WITH PSILI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
     Lu,  -- (16#01F68#, 16#01F6F#)  GREEK CAPITAL LETTER OMEGA WITH PSILI .. GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
     Ll,  -- (16#01F70#, 16#01F7D#)  GREEK SMALL LETTER ALPHA WITH VARIA .. GREEK SMALL LETTER OMEGA WITH OXIA
     Ll,  -- (16#01F80#, 16#01F87#)  GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     Lt,  -- (16#01F88#, 16#01F8F#)  GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI .. GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
     Ll,  -- (16#01F90#, 16#01F97#)  GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     Lt,  -- (16#01F98#, 16#01F9F#)  GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI .. GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
     Ll,  -- (16#01FA0#, 16#01FA7#)  GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
     Lt,  -- (16#01FA8#, 16#01FAF#)  GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI .. GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
     Ll,  -- (16#01FB0#, 16#01FB4#)  GREEK SMALL LETTER ALPHA WITH VRACHY .. GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
     Ll,  -- (16#01FB6#, 16#01FB7#)  GREEK SMALL LETTER ALPHA WITH PERISPOMENI .. GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
     Lu,  -- (16#01FB8#, 16#01FBB#)  GREEK CAPITAL LETTER ALPHA WITH VRACHY .. GREEK CAPITAL LETTER ALPHA WITH OXIA
     Lt,  -- (16#01FBC#, 16#01FBC#)  GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI .. GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
     Sk,  -- (16#01FBD#, 16#01FBD#)  GREEK KORONIS .. GREEK KORONIS
     Ll,  -- (16#01FBE#, 16#01FBE#)  GREEK PROSGEGRAMMENI .. GREEK PROSGEGRAMMENI
     Sk,  -- (16#01FBF#, 16#01FC1#)  GREEK PSILI .. GREEK DIALYTIKA AND PERISPOMENI
     Ll,  -- (16#01FC2#, 16#01FC4#)  GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
     Ll,  -- (16#01FC6#, 16#01FC7#)  GREEK SMALL LETTER ETA WITH PERISPOMENI .. GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
     Lu,  -- (16#01FC8#, 16#01FCB#)  GREEK CAPITAL LETTER EPSILON WITH VARIA .. GREEK CAPITAL LETTER ETA WITH OXIA
     Lt,  -- (16#01FCC#, 16#01FCC#)  GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI .. GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
     Sk,  -- (16#01FCD#, 16#01FCF#)  GREEK PSILI AND VARIA .. GREEK PSILI AND PERISPOMENI
     Ll,  -- (16#01FD0#, 16#01FD3#)  GREEK SMALL LETTER IOTA WITH VRACHY .. GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
     Ll,  -- (16#01FD6#, 16#01FD7#)  GREEK SMALL LETTER IOTA WITH PERISPOMENI .. GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
     Lu,  -- (16#01FD8#, 16#01FDB#)  GREEK CAPITAL LETTER IOTA WITH VRACHY .. GREEK CAPITAL LETTER IOTA WITH OXIA
     Sk,  -- (16#01FDD#, 16#01FDF#)  GREEK DASIA AND VARIA .. GREEK DASIA AND PERISPOMENI
     Ll,  -- (16#01FE0#, 16#01FE7#)  GREEK SMALL LETTER UPSILON WITH VRACHY .. GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
     Lu,  -- (16#01FE8#, 16#01FEC#)  GREEK CAPITAL LETTER UPSILON WITH VRACHY .. GREEK CAPITAL LETTER RHO WITH DASIA
     Sk,  -- (16#01FED#, 16#01FEF#)  GREEK DIALYTIKA AND VARIA .. GREEK VARIA
     Ll,  -- (16#01FF2#, 16#01FF4#)  GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
     Ll,  -- (16#01FF6#, 16#01FF7#)  GREEK SMALL LETTER OMEGA WITH PERISPOMENI .. GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
     Lu,  -- (16#01FF8#, 16#01FFB#)  GREEK CAPITAL LETTER OMICRON WITH VARIA .. GREEK CAPITAL LETTER OMEGA WITH OXIA
     Lt,  -- (16#01FFC#, 16#01FFC#)  GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI .. GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
     Sk,  -- (16#01FFD#, 16#01FFE#)  GREEK OXIA .. GREEK DASIA
     Zs,  -- (16#02000#, 16#0200B#)  EN QUAD .. ZERO WIDTH SPACE
     Cf,  -- (16#0200C#, 16#0200F#)  ZERO WIDTH NON-JOINER .. RIGHT-TO-LEFT MARK
     Pd,  -- (16#02010#, 16#02015#)  HYPHEN .. HORIZONTAL BAR
     Po,  -- (16#02016#, 16#02017#)  DOUBLE VERTICAL LINE .. DOUBLE LOW LINE
     Pi,  -- (16#02018#, 16#02018#)  LEFT SINGLE QUOTATION MARK .. LEFT SINGLE QUOTATION MARK
     Pf,  -- (16#02019#, 16#02019#)  RIGHT SINGLE QUOTATION MARK .. RIGHT SINGLE QUOTATION MARK
     Ps,  -- (16#0201A#, 16#0201A#)  SINGLE LOW-9 QUOTATION MARK .. SINGLE LOW-9 QUOTATION MARK
     Pi,  -- (16#0201B#, 16#0201C#)  SINGLE HIGH-REVERSED-9 QUOTATION MARK .. LEFT DOUBLE QUOTATION MARK
     Pf,  -- (16#0201D#, 16#0201D#)  RIGHT DOUBLE QUOTATION MARK .. RIGHT DOUBLE QUOTATION MARK
     Ps,  -- (16#0201E#, 16#0201E#)  DOUBLE LOW-9 QUOTATION MARK .. DOUBLE LOW-9 QUOTATION MARK
     Pi,  -- (16#0201F#, 16#0201F#)  DOUBLE HIGH-REVERSED-9 QUOTATION MARK .. DOUBLE HIGH-REVERSED-9 QUOTATION MARK
     Po,  -- (16#02020#, 16#02027#)  DAGGER .. HYPHENATION POINT
     Zl,  -- (16#02028#, 16#02028#)  LINE SEPARATOR .. LINE SEPARATOR
     Zp,  -- (16#02029#, 16#02029#)  PARAGRAPH SEPARATOR .. PARAGRAPH SEPARATOR
     Cf,  -- (16#0202A#, 16#0202E#)  LEFT-TO-RIGHT EMBEDDING .. RIGHT-TO-LEFT OVERRIDE
     Zs,  -- (16#0202F#, 16#0202F#)  NARROW NO-BREAK SPACE .. NARROW NO-BREAK SPACE
     Po,  -- (16#02030#, 16#02038#)  PER MILLE SIGN .. CARET
     Pi,  -- (16#02039#, 16#02039#)  SINGLE LEFT-POINTING ANGLE QUOTATION MARK .. SINGLE LEFT-POINTING ANGLE QUOTATION MARK
     Pf,  -- (16#0203A#, 16#0203A#)  SINGLE RIGHT-POINTING ANGLE QUOTATION MARK .. SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
     Po,  -- (16#0203B#, 16#0203E#)  REFERENCE MARK .. OVERLINE
     Pc,  -- (16#0203F#, 16#02040#)  UNDERTIE .. CHARACTER TIE
     Po,  -- (16#02041#, 16#02043#)  CARET INSERTION POINT .. HYPHEN BULLET
     Sm,  -- (16#02044#, 16#02044#)  FRACTION SLASH .. FRACTION SLASH
     Ps,  -- (16#02045#, 16#02045#)  LEFT SQUARE BRACKET WITH QUILL .. LEFT SQUARE BRACKET WITH QUILL
     Pe,  -- (16#02046#, 16#02046#)  RIGHT SQUARE BRACKET WITH QUILL .. RIGHT SQUARE BRACKET WITH QUILL
     Po,  -- (16#02047#, 16#02051#)  DOUBLE QUESTION MARK .. TWO ASTERISKS ALIGNED VERTICALLY
     Sm,  -- (16#02052#, 16#02052#)  COMMERCIAL MINUS SIGN .. COMMERCIAL MINUS SIGN
     Po,  -- (16#02053#, 16#02053#)  SWUNG DASH .. SWUNG DASH
     Pc,  -- (16#02054#, 16#02054#)  INVERTED UNDERTIE .. INVERTED UNDERTIE
     Po,  -- (16#02057#, 16#02057#)  QUADRUPLE PRIME .. QUADRUPLE PRIME
     Zs,  -- (16#0205F#, 16#0205F#)  MEDIUM MATHEMATICAL SPACE .. MEDIUM MATHEMATICAL SPACE
     Cf,  -- (16#02060#, 16#02063#)  WORD JOINER .. INVISIBLE SEPARATOR
     Cf,  -- (16#0206A#, 16#0206F#)  INHIBIT SYMMETRIC SWAPPING .. NOMINAL DIGIT SHAPES
     No,  -- (16#02070#, 16#02070#)  SUPERSCRIPT ZERO .. SUPERSCRIPT ZERO
     Ll,  -- (16#02071#, 16#02071#)  SUPERSCRIPT LATIN SMALL LETTER I .. SUPERSCRIPT LATIN SMALL LETTER I
     No,  -- (16#02074#, 16#02079#)  SUPERSCRIPT FOUR .. SUPERSCRIPT NINE
     Sm,  -- (16#0207A#, 16#0207C#)  SUPERSCRIPT PLUS SIGN .. SUPERSCRIPT EQUALS SIGN
     Ps,  -- (16#0207D#, 16#0207D#)  SUPERSCRIPT LEFT PARENTHESIS .. SUPERSCRIPT LEFT PARENTHESIS
     Pe,  -- (16#0207E#, 16#0207E#)  SUPERSCRIPT RIGHT PARENTHESIS .. SUPERSCRIPT RIGHT PARENTHESIS
     Ll,  -- (16#0207F#, 16#0207F#)  SUPERSCRIPT LATIN SMALL LETTER N .. SUPERSCRIPT LATIN SMALL LETTER N
     No,  -- (16#02080#, 16#02089#)  SUBSCRIPT ZERO .. SUBSCRIPT NINE
     Sm,  -- (16#0208A#, 16#0208C#)  SUBSCRIPT PLUS SIGN .. SUBSCRIPT EQUALS SIGN
     Ps,  -- (16#0208D#, 16#0208D#)  SUBSCRIPT LEFT PARENTHESIS .. SUBSCRIPT LEFT PARENTHESIS
     Pe,  -- (16#0208E#, 16#0208E#)  SUBSCRIPT RIGHT PARENTHESIS .. SUBSCRIPT RIGHT PARENTHESIS
     Sc,  -- (16#020A0#, 16#020B1#)  EURO-CURRENCY SIGN .. PESO SIGN
     Mn,  -- (16#020D0#, 16#020DC#)  COMBINING LEFT HARPOON ABOVE .. COMBINING FOUR DOTS ABOVE
     Me,  -- (16#020DD#, 16#020E0#)  COMBINING ENCLOSING CIRCLE .. COMBINING ENCLOSING CIRCLE BACKSLASH
     Mn,  -- (16#020E1#, 16#020E1#)  COMBINING LEFT RIGHT ARROW ABOVE .. COMBINING LEFT RIGHT ARROW ABOVE
     Me,  -- (16#020E2#, 16#020E4#)  COMBINING ENCLOSING SCREEN .. COMBINING ENCLOSING UPWARD POINTING TRIANGLE
     Mn,  -- (16#020E5#, 16#020EA#)  COMBINING REVERSE SOLIDUS OVERLAY .. COMBINING LEFTWARDS ARROW OVERLAY
     So,  -- (16#02100#, 16#02101#)  ACCOUNT OF .. ADDRESSED TO THE SUBJECT
     Lu,  -- (16#02102#, 16#02102#)  DOUBLE-STRUCK CAPITAL C .. DOUBLE-STRUCK CAPITAL C
     So,  -- (16#02103#, 16#02106#)  DEGREE CELSIUS .. CADA UNA
     Lu,  -- (16#02107#, 16#02107#)  EULER CONSTANT .. EULER CONSTANT
     So,  -- (16#02108#, 16#02109#)  SCRUPLE .. DEGREE FAHRENHEIT
     Ll,  -- (16#0210A#, 16#0210A#)  SCRIPT SMALL G .. SCRIPT SMALL G
     Lu,  -- (16#0210B#, 16#0210D#)  SCRIPT CAPITAL H .. DOUBLE-STRUCK CAPITAL H
     Ll,  -- (16#0210E#, 16#0210F#)  PLANCK CONSTANT .. PLANCK CONSTANT OVER TWO PI
     Lu,  -- (16#02110#, 16#02112#)  SCRIPT CAPITAL I .. SCRIPT CAPITAL L
     Ll,  -- (16#02113#, 16#02113#)  SCRIPT SMALL L .. SCRIPT SMALL L
     So,  -- (16#02114#, 16#02114#)  L B BAR SYMBOL .. L B BAR SYMBOL
     Lu,  -- (16#02115#, 16#02115#)  DOUBLE-STRUCK CAPITAL N .. DOUBLE-STRUCK CAPITAL N
     So,  -- (16#02116#, 16#02118#)  NUMERO SIGN .. SCRIPT CAPITAL P
     Lu,  -- (16#02119#, 16#0211D#)  DOUBLE-STRUCK CAPITAL P .. DOUBLE-STRUCK CAPITAL R
     So,  -- (16#0211E#, 16#02123#)  PRESCRIPTION TAKE .. VERSICLE
     Lu,  -- (16#02124#, 16#02124#)  DOUBLE-STRUCK CAPITAL Z .. DOUBLE-STRUCK CAPITAL Z
     So,  -- (16#02125#, 16#02125#)  OUNCE SIGN .. OUNCE SIGN
     Lu,  -- (16#02126#, 16#02126#)  OHM SIGN .. OHM SIGN
     So,  -- (16#02127#, 16#02127#)  INVERTED OHM SIGN .. INVERTED OHM SIGN
     Lu,  -- (16#02128#, 16#02128#)  BLACK-LETTER CAPITAL Z .. BLACK-LETTER CAPITAL Z
     So,  -- (16#02129#, 16#02129#)  TURNED GREEK SMALL LETTER IOTA .. TURNED GREEK SMALL LETTER IOTA
     Lu,  -- (16#0212A#, 16#0212D#)  KELVIN SIGN .. BLACK-LETTER CAPITAL C
     So,  -- (16#0212E#, 16#0212E#)  ESTIMATED SYMBOL .. ESTIMATED SYMBOL
     Ll,  -- (16#0212F#, 16#0212F#)  SCRIPT SMALL E .. SCRIPT SMALL E
     Lu,  -- (16#02130#, 16#02131#)  SCRIPT CAPITAL E .. SCRIPT CAPITAL F
     So,  -- (16#02132#, 16#02132#)  TURNED CAPITAL F .. TURNED CAPITAL F
     Lu,  -- (16#02133#, 16#02133#)  SCRIPT CAPITAL M .. SCRIPT CAPITAL M
     Ll,  -- (16#02134#, 16#02134#)  SCRIPT SMALL O .. SCRIPT SMALL O
     Lo,  -- (16#02135#, 16#02138#)  ALEF SYMBOL .. DALET SYMBOL
     Ll,  -- (16#02139#, 16#02139#)  INFORMATION SOURCE .. INFORMATION SOURCE
     So,  -- (16#0213A#, 16#0213B#)  ROTATED CAPITAL Q .. FACSIMILE SIGN
     Ll,  -- (16#0213D#, 16#0213D#)  DOUBLE-STRUCK SMALL GAMMA .. DOUBLE-STRUCK SMALL GAMMA
     Lu,  -- (16#0213E#, 16#0213F#)  DOUBLE-STRUCK CAPITAL GAMMA .. DOUBLE-STRUCK CAPITAL PI
     Sm,  -- (16#02140#, 16#02144#)  DOUBLE-STRUCK N-ARY SUMMATION .. TURNED SANS-SERIF CAPITAL Y
     Lu,  -- (16#02145#, 16#02145#)  DOUBLE-STRUCK ITALIC CAPITAL D .. DOUBLE-STRUCK ITALIC CAPITAL D
     Ll,  -- (16#02146#, 16#02149#)  DOUBLE-STRUCK ITALIC SMALL D .. DOUBLE-STRUCK ITALIC SMALL J
     So,  -- (16#0214A#, 16#0214A#)  PROPERTY LINE .. PROPERTY LINE
     Sm,  -- (16#0214B#, 16#0214B#)  TURNED AMPERSAND .. TURNED AMPERSAND
     No,  -- (16#02153#, 16#0215F#)  VULGAR FRACTION ONE THIRD .. FRACTION NUMERATOR ONE
     Nl,  -- (16#02160#, 16#02183#)  ROMAN NUMERAL ONE .. ROMAN NUMERAL REVERSED ONE HUNDRED
     Sm,  -- (16#02190#, 16#02194#)  LEFTWARDS ARROW .. LEFT RIGHT ARROW
     So,  -- (16#02195#, 16#02199#)  UP DOWN ARROW .. SOUTH WEST ARROW
     Sm,  -- (16#0219A#, 16#0219B#)  LEFTWARDS ARROW WITH STROKE .. RIGHTWARDS ARROW WITH STROKE
     So,  -- (16#0219C#, 16#0219F#)  LEFTWARDS WAVE ARROW .. UPWARDS TWO HEADED ARROW
     Sm,  -- (16#021A0#, 16#021A0#)  RIGHTWARDS TWO HEADED ARROW .. RIGHTWARDS TWO HEADED ARROW
     So,  -- (16#021A1#, 16#021A2#)  DOWNWARDS TWO HEADED ARROW .. LEFTWARDS ARROW WITH TAIL
     Sm,  -- (16#021A3#, 16#021A3#)  RIGHTWARDS ARROW WITH TAIL .. RIGHTWARDS ARROW WITH TAIL
     So,  -- (16#021A4#, 16#021A5#)  LEFTWARDS ARROW FROM BAR .. UPWARDS ARROW FROM BAR
     Sm,  -- (16#021A6#, 16#021A6#)  RIGHTWARDS ARROW FROM BAR .. RIGHTWARDS ARROW FROM BAR
     So,  -- (16#021A7#, 16#021AD#)  DOWNWARDS ARROW FROM BAR .. LEFT RIGHT WAVE ARROW
     Sm,  -- (16#021AE#, 16#021AE#)  LEFT RIGHT ARROW WITH STROKE .. LEFT RIGHT ARROW WITH STROKE
     So,  -- (16#021AF#, 16#021CD#)  DOWNWARDS ZIGZAG ARROW .. LEFTWARDS DOUBLE ARROW WITH STROKE
     Sm,  -- (16#021CE#, 16#021CF#)  LEFT RIGHT DOUBLE ARROW WITH STROKE .. RIGHTWARDS DOUBLE ARROW WITH STROKE
     So,  -- (16#021D0#, 16#021D1#)  LEFTWARDS DOUBLE ARROW .. UPWARDS DOUBLE ARROW
     Sm,  -- (16#021D2#, 16#021D2#)  RIGHTWARDS DOUBLE ARROW .. RIGHTWARDS DOUBLE ARROW
     So,  -- (16#021D3#, 16#021D3#)  DOWNWARDS DOUBLE ARROW .. DOWNWARDS DOUBLE ARROW
     Sm,  -- (16#021D4#, 16#021D4#)  LEFT RIGHT DOUBLE ARROW .. LEFT RIGHT DOUBLE ARROW
     So,  -- (16#021D5#, 16#021F3#)  UP DOWN DOUBLE ARROW .. UP DOWN WHITE ARROW
     Sm,  -- (16#021F4#, 16#022FF#)  RIGHT ARROW WITH SMALL CIRCLE .. Z NOTATION BAG MEMBERSHIP
     So,  -- (16#02300#, 16#02307#)  DIAMETER SIGN .. WAVY LINE
     Sm,  -- (16#02308#, 16#0230B#)  LEFT CEILING .. RIGHT FLOOR
     So,  -- (16#0230C#, 16#0231F#)  BOTTOM RIGHT CROP .. BOTTOM RIGHT CORNER
     Sm,  -- (16#02320#, 16#02321#)  TOP HALF INTEGRAL .. BOTTOM HALF INTEGRAL
     So,  -- (16#02322#, 16#02328#)  FROWN .. KEYBOARD
     Ps,  -- (16#02329#, 16#02329#)  LEFT-POINTING ANGLE BRACKET .. LEFT-POINTING ANGLE BRACKET
     Pe,  -- (16#0232A#, 16#0232A#)  RIGHT-POINTING ANGLE BRACKET .. RIGHT-POINTING ANGLE BRACKET
     So,  -- (16#0232B#, 16#0237B#)  ERASE TO THE LEFT .. NOT CHECK MARK
     Sm,  -- (16#0237C#, 16#0237C#)  RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW .. RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
     So,  -- (16#0237D#, 16#0239A#)  SHOULDERED OPEN BOX .. CLEAR SCREEN SYMBOL
     Sm,  -- (16#0239B#, 16#023B3#)  LEFT PARENTHESIS UPPER HOOK .. SUMMATION BOTTOM
     Ps,  -- (16#023B4#, 16#023B4#)  TOP SQUARE BRACKET .. TOP SQUARE BRACKET
     Pe,  -- (16#023B5#, 16#023B5#)  BOTTOM SQUARE BRACKET .. BOTTOM SQUARE BRACKET
     Po,  -- (16#023B6#, 16#023B6#)  BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET .. BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET
     So,  -- (16#023B7#, 16#023D0#)  RADICAL SYMBOL BOTTOM .. VERTICAL LINE EXTENSION
     So,  -- (16#02400#, 16#02426#)  SYMBOL FOR NULL .. SYMBOL FOR SUBSTITUTE FORM TWO
     So,  -- (16#02440#, 16#0244A#)  OCR HOOK .. OCR DOUBLE BACKSLASH
     No,  -- (16#02460#, 16#0249B#)  CIRCLED DIGIT ONE .. NUMBER TWENTY FULL STOP
     So,  -- (16#0249C#, 16#024E9#)  PARENTHESIZED LATIN SMALL LETTER A .. CIRCLED LATIN SMALL LETTER Z
     No,  -- (16#024EA#, 16#024FF#)  CIRCLED DIGIT ZERO .. NEGATIVE CIRCLED DIGIT ZERO
     So,  -- (16#02500#, 16#025B6#)  BOX DRAWINGS LIGHT HORIZONTAL .. BLACK RIGHT-POINTING TRIANGLE
     Sm,  -- (16#025B7#, 16#025B7#)  WHITE RIGHT-POINTING TRIANGLE .. WHITE RIGHT-POINTING TRIANGLE
     So,  -- (16#025B8#, 16#025C0#)  BLACK RIGHT-POINTING SMALL TRIANGLE .. BLACK LEFT-POINTING TRIANGLE
     Sm,  -- (16#025C1#, 16#025C1#)  WHITE LEFT-POINTING TRIANGLE .. WHITE LEFT-POINTING TRIANGLE
     So,  -- (16#025C2#, 16#025F7#)  BLACK LEFT-POINTING SMALL TRIANGLE .. WHITE CIRCLE WITH UPPER RIGHT QUADRANT
     Sm,  -- (16#025F8#, 16#025FF#)  UPPER LEFT TRIANGLE .. LOWER RIGHT TRIANGLE
     So,  -- (16#02600#, 16#02617#)  BLACK SUN WITH RAYS .. BLACK SHOGI PIECE
     So,  -- (16#02619#, 16#0266E#)  REVERSED ROTATED FLORAL HEART BULLET .. MUSIC NATURAL SIGN
     Sm,  -- (16#0266F#, 16#0266F#)  MUSIC SHARP SIGN .. MUSIC SHARP SIGN
     So,  -- (16#02670#, 16#0267D#)  WEST SYRIAC CROSS .. PARTIALLY-RECYCLED PAPER SYMBOL
     So,  -- (16#02680#, 16#02691#)  DIE FACE-1 .. BLACK FLAG
     So,  -- (16#026A0#, 16#026A1#)  WARNING SIGN .. HIGH VOLTAGE SIGN
     So,  -- (16#02701#, 16#02704#)  UPPER BLADE SCISSORS .. WHITE SCISSORS
     So,  -- (16#02706#, 16#02709#)  TELEPHONE LOCATION SIGN .. ENVELOPE
     So,  -- (16#0270C#, 16#02727#)  VICTORY HAND .. WHITE FOUR POINTED STAR
     So,  -- (16#02729#, 16#0274B#)  STRESS OUTLINED WHITE STAR .. HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
     So,  -- (16#0274D#, 16#0274D#)  SHADOWED WHITE CIRCLE .. SHADOWED WHITE CIRCLE
     So,  -- (16#0274F#, 16#02752#)  LOWER RIGHT DROP-SHADOWED WHITE SQUARE .. UPPER RIGHT SHADOWED WHITE SQUARE
     So,  -- (16#02756#, 16#02756#)  BLACK DIAMOND MINUS WHITE X .. BLACK DIAMOND MINUS WHITE X
     So,  -- (16#02758#, 16#0275E#)  LIGHT VERTICAL BAR .. HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT
     So,  -- (16#02761#, 16#02767#)  CURVED STEM PARAGRAPH SIGN ORNAMENT .. ROTATED FLORAL HEART BULLET
     Ps,  -- (16#02768#, 16#02768#)  MEDIUM LEFT PARENTHESIS ORNAMENT .. MEDIUM LEFT PARENTHESIS ORNAMENT
     Pe,  -- (16#02769#, 16#02769#)  MEDIUM RIGHT PARENTHESIS ORNAMENT .. MEDIUM RIGHT PARENTHESIS ORNAMENT
     Ps,  -- (16#0276A#, 16#0276A#)  MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT .. MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
     Pe,  -- (16#0276B#, 16#0276B#)  MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT .. MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
     Ps,  -- (16#0276C#, 16#0276C#)  MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT .. MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
     Pe,  -- (16#0276D#, 16#0276D#)  MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT .. MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
     Ps,  -- (16#0276E#, 16#0276E#)  HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT .. HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
     Pe,  -- (16#0276F#, 16#0276F#)  HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT .. HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
     Ps,  -- (16#02770#, 16#02770#)  HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT .. HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
     Pe,  -- (16#02771#, 16#02771#)  HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT .. HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
     Ps,  -- (16#02772#, 16#02772#)  LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT .. LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
     Pe,  -- (16#02773#, 16#02773#)  LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT .. LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
     Ps,  -- (16#02774#, 16#02774#)  MEDIUM LEFT CURLY BRACKET ORNAMENT .. MEDIUM LEFT CURLY BRACKET ORNAMENT
     Pe,  -- (16#02775#, 16#02775#)  MEDIUM RIGHT CURLY BRACKET ORNAMENT .. MEDIUM RIGHT CURLY BRACKET ORNAMENT
     No,  -- (16#02776#, 16#02793#)  DINGBAT NEGATIVE CIRCLED DIGIT ONE .. DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN
     So,  -- (16#02794#, 16#02794#)  HEAVY WIDE-HEADED RIGHTWARDS ARROW .. HEAVY WIDE-HEADED RIGHTWARDS ARROW
     So,  -- (16#02798#, 16#027AF#)  HEAVY SOUTH EAST ARROW .. NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
     So,  -- (16#027B1#, 16#027BE#)  NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW .. OPEN-OUTLINED RIGHTWARDS ARROW
     Sm,  -- (16#027D0#, 16#027E5#)  WHITE DIAMOND WITH CENTRED DOT .. WHITE SQUARE WITH RIGHTWARDS TICK
     Ps,  -- (16#027E6#, 16#027E6#)  MATHEMATICAL LEFT WHITE SQUARE BRACKET .. MATHEMATICAL LEFT WHITE SQUARE BRACKET
     Pe,  -- (16#027E7#, 16#027E7#)  MATHEMATICAL RIGHT WHITE SQUARE BRACKET .. MATHEMATICAL RIGHT WHITE SQUARE BRACKET
     Ps,  -- (16#027E8#, 16#027E8#)  MATHEMATICAL LEFT ANGLE BRACKET .. MATHEMATICAL LEFT ANGLE BRACKET
     Pe,  -- (16#027E9#, 16#027E9#)  MATHEMATICAL RIGHT ANGLE BRACKET .. MATHEMATICAL RIGHT ANGLE BRACKET
     Ps,  -- (16#027EA#, 16#027EA#)  MATHEMATICAL LEFT DOUBLE ANGLE BRACKET .. MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
     Pe,  -- (16#027EB#, 16#027EB#)  MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET .. MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
     Sm,  -- (16#027F0#, 16#027FF#)  UPWARDS QUADRUPLE ARROW .. LONG RIGHTWARDS SQUIGGLE ARROW
     So,  -- (16#02800#, 16#028FF#)  BRAILLE PATTERN BLANK .. BRAILLE PATTERN DOTS-12345678
     Sm,  -- (16#02900#, 16#02982#)  RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE .. Z NOTATION TYPE COLON
     Ps,  -- (16#02983#, 16#02983#)  LEFT WHITE CURLY BRACKET .. LEFT WHITE CURLY BRACKET
     Pe,  -- (16#02984#, 16#02984#)  RIGHT WHITE CURLY BRACKET .. RIGHT WHITE CURLY BRACKET
     Ps,  -- (16#02985#, 16#02985#)  LEFT WHITE PARENTHESIS .. LEFT WHITE PARENTHESIS
     Pe,  -- (16#02986#, 16#02986#)  RIGHT WHITE PARENTHESIS .. RIGHT WHITE PARENTHESIS
     Ps,  -- (16#02987#, 16#02987#)  Z NOTATION LEFT IMAGE BRACKET .. Z NOTATION LEFT IMAGE BRACKET
     Pe,  -- (16#02988#, 16#02988#)  Z NOTATION RIGHT IMAGE BRACKET .. Z NOTATION RIGHT IMAGE BRACKET
     Ps,  -- (16#02989#, 16#02989#)  Z NOTATION LEFT BINDING BRACKET .. Z NOTATION LEFT BINDING BRACKET
     Pe,  -- (16#0298A#, 16#0298A#)  Z NOTATION RIGHT BINDING BRACKET .. Z NOTATION RIGHT BINDING BRACKET
     Ps,  -- (16#0298B#, 16#0298B#)  LEFT SQUARE BRACKET WITH UNDERBAR .. LEFT SQUARE BRACKET WITH UNDERBAR
     Pe,  -- (16#0298C#, 16#0298C#)  RIGHT SQUARE BRACKET WITH UNDERBAR .. RIGHT SQUARE BRACKET WITH UNDERBAR
     Ps,  -- (16#0298D#, 16#0298D#)  LEFT SQUARE BRACKET WITH TICK IN TOP CORNER .. LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
     Pe,  -- (16#0298E#, 16#0298E#)  RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER .. RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
     Ps,  -- (16#0298F#, 16#0298F#)  LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER .. LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
     Pe,  -- (16#02990#, 16#02990#)  RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER .. RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
     Ps,  -- (16#02991#, 16#02991#)  LEFT ANGLE BRACKET WITH DOT .. LEFT ANGLE BRACKET WITH DOT
     Pe,  -- (16#02992#, 16#02992#)  RIGHT ANGLE BRACKET WITH DOT .. RIGHT ANGLE BRACKET WITH DOT
     Ps,  -- (16#02993#, 16#02993#)  LEFT ARC LESS-THAN BRACKET .. LEFT ARC LESS-THAN BRACKET
     Pe,  -- (16#02994#, 16#02994#)  RIGHT ARC GREATER-THAN BRACKET .. RIGHT ARC GREATER-THAN BRACKET
     Ps,  -- (16#02995#, 16#02995#)  DOUBLE LEFT ARC GREATER-THAN BRACKET .. DOUBLE LEFT ARC GREATER-THAN BRACKET
     Pe,  -- (16#02996#, 16#02996#)  DOUBLE RIGHT ARC LESS-THAN BRACKET .. DOUBLE RIGHT ARC LESS-THAN BRACKET
     Ps,  -- (16#02997#, 16#02997#)  LEFT BLACK TORTOISE SHELL BRACKET .. LEFT BLACK TORTOISE SHELL BRACKET
     Pe,  -- (16#02998#, 16#02998#)  RIGHT BLACK TORTOISE SHELL BRACKET .. RIGHT BLACK TORTOISE SHELL BRACKET
     Sm,  -- (16#02999#, 16#029D7#)  DOTTED FENCE .. BLACK HOURGLASS
     Ps,  -- (16#029D8#, 16#029D8#)  LEFT WIGGLY FENCE .. LEFT WIGGLY FENCE
     Pe,  -- (16#029D9#, 16#029D9#)  RIGHT WIGGLY FENCE .. RIGHT WIGGLY FENCE
     Ps,  -- (16#029DA#, 16#029DA#)  LEFT DOUBLE WIGGLY FENCE .. LEFT DOUBLE WIGGLY FENCE
     Pe,  -- (16#029DB#, 16#029DB#)  RIGHT DOUBLE WIGGLY FENCE .. RIGHT DOUBLE WIGGLY FENCE
     Sm,  -- (16#029DC#, 16#029FB#)  INCOMPLETE INFINITY .. TRIPLE PLUS
     Ps,  -- (16#029FC#, 16#029FC#)  LEFT-POINTING CURVED ANGLE BRACKET .. LEFT-POINTING CURVED ANGLE BRACKET
     Pe,  -- (16#029FD#, 16#029FD#)  RIGHT-POINTING CURVED ANGLE BRACKET .. RIGHT-POINTING CURVED ANGLE BRACKET
     Sm,  -- (16#029FE#, 16#02AFF#)  TINY .. N-ARY WHITE VERTICAL BAR
     So,  -- (16#02B00#, 16#02B0D#)  NORTH EAST WHITE ARROW .. UP DOWN BLACK ARROW
     So,  -- (16#02E80#, 16#02E99#)  CJK RADICAL REPEAT .. CJK RADICAL RAP
     So,  -- (16#02E9B#, 16#02EF3#)  CJK RADICAL CHOKE .. CJK RADICAL C-SIMPLIFIED TURTLE
     So,  -- (16#02F00#, 16#02FD5#)  KANGXI RADICAL ONE .. KANGXI RADICAL FLUTE
     So,  -- (16#02FF0#, 16#02FFB#)  IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT .. IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID
     Zs,  -- (16#03000#, 16#03000#)  IDEOGRAPHIC SPACE .. IDEOGRAPHIC SPACE
     Po,  -- (16#03001#, 16#03003#)  IDEOGRAPHIC COMMA .. DITTO MARK
     So,  -- (16#03004#, 16#03004#)  JAPANESE INDUSTRIAL STANDARD SYMBOL .. JAPANESE INDUSTRIAL STANDARD SYMBOL
     Lm,  -- (16#03005#, 16#03005#)  IDEOGRAPHIC ITERATION MARK .. IDEOGRAPHIC ITERATION MARK
     Lo,  -- (16#03006#, 16#03006#)  IDEOGRAPHIC CLOSING MARK .. IDEOGRAPHIC CLOSING MARK
     Nl,  -- (16#03007#, 16#03007#)  IDEOGRAPHIC NUMBER ZERO .. IDEOGRAPHIC NUMBER ZERO
     Ps,  -- (16#03008#, 16#03008#)  LEFT ANGLE BRACKET .. LEFT ANGLE BRACKET
     Pe,  -- (16#03009#, 16#03009#)  RIGHT ANGLE BRACKET .. RIGHT ANGLE BRACKET
     Ps,  -- (16#0300A#, 16#0300A#)  LEFT DOUBLE ANGLE BRACKET .. LEFT DOUBLE ANGLE BRACKET
     Pe,  -- (16#0300B#, 16#0300B#)  RIGHT DOUBLE ANGLE BRACKET .. RIGHT DOUBLE ANGLE BRACKET
     Ps,  -- (16#0300C#, 16#0300C#)  LEFT CORNER BRACKET .. LEFT CORNER BRACKET
     Pe,  -- (16#0300D#, 16#0300D#)  RIGHT CORNER BRACKET .. RIGHT CORNER BRACKET
     Ps,  -- (16#0300E#, 16#0300E#)  LEFT WHITE CORNER BRACKET .. LEFT WHITE CORNER BRACKET
     Pe,  -- (16#0300F#, 16#0300F#)  RIGHT WHITE CORNER BRACKET .. RIGHT WHITE CORNER BRACKET
     Ps,  -- (16#03010#, 16#03010#)  LEFT BLACK LENTICULAR BRACKET .. LEFT BLACK LENTICULAR BRACKET
     Pe,  -- (16#03011#, 16#03011#)  RIGHT BLACK LENTICULAR BRACKET .. RIGHT BLACK LENTICULAR BRACKET
     So,  -- (16#03012#, 16#03013#)  POSTAL MARK .. GETA MARK
     Ps,  -- (16#03014#, 16#03014#)  LEFT TORTOISE SHELL BRACKET .. LEFT TORTOISE SHELL BRACKET
     Pe,  -- (16#03015#, 16#03015#)  RIGHT TORTOISE SHELL BRACKET .. RIGHT TORTOISE SHELL BRACKET
     Ps,  -- (16#03016#, 16#03016#)  LEFT WHITE LENTICULAR BRACKET .. LEFT WHITE LENTICULAR BRACKET
     Pe,  -- (16#03017#, 16#03017#)  RIGHT WHITE LENTICULAR BRACKET .. RIGHT WHITE LENTICULAR BRACKET
     Ps,  -- (16#03018#, 16#03018#)  LEFT WHITE TORTOISE SHELL BRACKET .. LEFT WHITE TORTOISE SHELL BRACKET
     Pe,  -- (16#03019#, 16#03019#)  RIGHT WHITE TORTOISE SHELL BRACKET .. RIGHT WHITE TORTOISE SHELL BRACKET
     Ps,  -- (16#0301A#, 16#0301A#)  LEFT WHITE SQUARE BRACKET .. LEFT WHITE SQUARE BRACKET
     Pe,  -- (16#0301B#, 16#0301B#)  RIGHT WHITE SQUARE BRACKET .. RIGHT WHITE SQUARE BRACKET
     Pd,  -- (16#0301C#, 16#0301C#)  WAVE DASH .. WAVE DASH
     Ps,  -- (16#0301D#, 16#0301D#)  REVERSED DOUBLE PRIME QUOTATION MARK .. REVERSED DOUBLE PRIME QUOTATION MARK
     Pe,  -- (16#0301E#, 16#0301F#)  DOUBLE PRIME QUOTATION MARK .. LOW DOUBLE PRIME QUOTATION MARK
     So,  -- (16#03020#, 16#03020#)  POSTAL MARK FACE .. POSTAL MARK FACE
     Nl,  -- (16#03021#, 16#03029#)  HANGZHOU NUMERAL ONE .. HANGZHOU NUMERAL NINE
     Mn,  -- (16#0302A#, 16#0302F#)  IDEOGRAPHIC LEVEL TONE MARK .. HANGUL DOUBLE DOT TONE MARK
     Pd,  -- (16#03030#, 16#03030#)  WAVY DASH .. WAVY DASH
     Lm,  -- (16#03031#, 16#03035#)  VERTICAL KANA REPEAT MARK .. VERTICAL KANA REPEAT MARK LOWER HALF
     So,  -- (16#03036#, 16#03037#)  CIRCLED POSTAL MARK .. IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL
     Nl,  -- (16#03038#, 16#0303A#)  HANGZHOU NUMERAL TEN .. HANGZHOU NUMERAL THIRTY
     Lm,  -- (16#0303B#, 16#0303B#)  VERTICAL IDEOGRAPHIC ITERATION MARK .. VERTICAL IDEOGRAPHIC ITERATION MARK
     Lo,  -- (16#0303C#, 16#0303C#)  MASU MARK .. MASU MARK
     Po,  -- (16#0303D#, 16#0303D#)  PART ALTERNATION MARK .. PART ALTERNATION MARK
     So,  -- (16#0303E#, 16#0303F#)  IDEOGRAPHIC VARIATION INDICATOR .. IDEOGRAPHIC HALF FILL SPACE
     Lo,  -- (16#03041#, 16#03096#)  HIRAGANA LETTER SMALL A .. HIRAGANA LETTER SMALL KE
     Mn,  -- (16#03099#, 16#0309A#)  COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK .. COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
     Sk,  -- (16#0309B#, 16#0309C#)  KATAKANA-HIRAGANA VOICED SOUND MARK .. KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
     Lm,  -- (16#0309D#, 16#0309E#)  HIRAGANA ITERATION MARK .. HIRAGANA VOICED ITERATION MARK
     Lo,  -- (16#0309F#, 16#0309F#)  HIRAGANA DIGRAPH YORI .. HIRAGANA DIGRAPH YORI
     Pd,  -- (16#030A0#, 16#030A0#)  KATAKANA-HIRAGANA DOUBLE HYPHEN .. KATAKANA-HIRAGANA DOUBLE HYPHEN
     Lo,  -- (16#030A1#, 16#030FA#)  KATAKANA LETTER SMALL A .. KATAKANA LETTER VO
     Pc,  -- (16#030FB#, 16#030FB#)  KATAKANA MIDDLE DOT .. KATAKANA MIDDLE DOT
     Lm,  -- (16#030FC#, 16#030FE#)  KATAKANA-HIRAGANA PROLONGED SOUND MARK .. KATAKANA VOICED ITERATION MARK
     Lo,  -- (16#030FF#, 16#030FF#)  KATAKANA DIGRAPH KOTO .. KATAKANA DIGRAPH KOTO
     Lo,  -- (16#03105#, 16#0312C#)  BOPOMOFO LETTER B .. BOPOMOFO LETTER GN
     Lo,  -- (16#03131#, 16#0318E#)  HANGUL LETTER KIYEOK .. HANGUL LETTER ARAEAE
     So,  -- (16#03190#, 16#03191#)  IDEOGRAPHIC ANNOTATION LINKING MARK .. IDEOGRAPHIC ANNOTATION REVERSE MARK
     No,  -- (16#03192#, 16#03195#)  IDEOGRAPHIC ANNOTATION ONE MARK .. IDEOGRAPHIC ANNOTATION FOUR MARK
     So,  -- (16#03196#, 16#0319F#)  IDEOGRAPHIC ANNOTATION TOP MARK .. IDEOGRAPHIC ANNOTATION MAN MARK
     Lo,  -- (16#031A0#, 16#031B7#)  BOPOMOFO LETTER BU .. BOPOMOFO FINAL LETTER H
     Lo,  -- (16#031F0#, 16#031FF#)  KATAKANA LETTER SMALL KU .. KATAKANA LETTER SMALL RO
     So,  -- (16#03200#, 16#0321E#)  PARENTHESIZED HANGUL KIYEOK .. PARENTHESIZED KOREAN CHARACTER O HU
     No,  -- (16#03220#, 16#03229#)  PARENTHESIZED IDEOGRAPH ONE .. PARENTHESIZED IDEOGRAPH TEN
     So,  -- (16#0322A#, 16#03243#)  PARENTHESIZED IDEOGRAPH MOON .. PARENTHESIZED IDEOGRAPH REACH
     So,  -- (16#03250#, 16#03250#)  PARTNERSHIP SIGN .. PARTNERSHIP SIGN
     No,  -- (16#03251#, 16#0325F#)  CIRCLED NUMBER TWENTY ONE .. CIRCLED NUMBER THIRTY FIVE
     So,  -- (16#03260#, 16#0327D#)  CIRCLED HANGUL KIYEOK .. CIRCLED KOREAN CHARACTER JUEUI
     So,  -- (16#0327F#, 16#0327F#)  KOREAN STANDARD SYMBOL .. KOREAN STANDARD SYMBOL
     No,  -- (16#03280#, 16#03289#)  CIRCLED IDEOGRAPH ONE .. CIRCLED IDEOGRAPH TEN
     So,  -- (16#0328A#, 16#032B0#)  CIRCLED IDEOGRAPH MOON .. CIRCLED IDEOGRAPH NIGHT
     No,  -- (16#032B1#, 16#032BF#)  CIRCLED NUMBER THIRTY SIX .. CIRCLED NUMBER FIFTY
     So,  -- (16#032C0#, 16#032FE#)  IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY .. CIRCLED KATAKANA WO
     So,  -- (16#03300#, 16#033FF#)  SQUARE APAATO .. SQUARE GAL
     Lo,  -- (16#03400#, 16#04DB5#)  <CJK Ideograph Extension A, First> .. <CJK Ideograph Extension A, Last>
     So,  -- (16#04DC0#, 16#04DFF#)  HEXAGRAM FOR THE CREATIVE HEAVEN .. HEXAGRAM FOR BEFORE COMPLETION
     Lo,  -- (16#04E00#, 16#09FA5#)  <CJK Ideograph, First> .. <CJK Ideograph, Last>
     Lo,  -- (16#0A000#, 16#0A48C#)  YI SYLLABLE IT .. YI SYLLABLE YYR
     So,  -- (16#0A490#, 16#0A4C6#)  YI RADICAL QOT .. YI RADICAL KE
     Lo,  -- (16#0AC00#, 16#0D7A3#)  <Hangul Syllable, First> .. <Hangul Syllable, Last>
     Cs,  -- (16#0D800#, 16#0F8FF#)  <Non Private Use High Surrogate, First> .. <Private Use, Last>
     Lo,  -- (16#0F900#, 16#0FA2D#)  CJK COMPATIBILITY IDEOGRAPH-F900 .. CJK COMPATIBILITY IDEOGRAPH-FA2D
     Lo,  -- (16#0FA30#, 16#0FA6A#)  CJK COMPATIBILITY IDEOGRAPH-FA30 .. CJK COMPATIBILITY IDEOGRAPH-FA6A
     Ll,  -- (16#0FB00#, 16#0FB06#)  LATIN SMALL LIGATURE FF .. LATIN SMALL LIGATURE ST
     Ll,  -- (16#0FB13#, 16#0FB17#)  ARMENIAN SMALL LIGATURE MEN NOW .. ARMENIAN SMALL LIGATURE MEN XEH
     Lo,  -- (16#0FB1D#, 16#0FB1D#)  HEBREW LETTER YOD WITH HIRIQ .. HEBREW LETTER YOD WITH HIRIQ
     Mn,  -- (16#0FB1E#, 16#0FB1E#)  HEBREW POINT JUDEO-SPANISH VARIKA .. HEBREW POINT JUDEO-SPANISH VARIKA
     Lo,  -- (16#0FB1F#, 16#0FB28#)  HEBREW LIGATURE YIDDISH YOD YOD PATAH .. HEBREW LETTER WIDE TAV
     Sm,  -- (16#0FB29#, 16#0FB29#)  HEBREW LETTER ALTERNATIVE PLUS SIGN .. HEBREW LETTER ALTERNATIVE PLUS SIGN
     Lo,  -- (16#0FB2A#, 16#0FB36#)  HEBREW LETTER SHIN WITH SHIN DOT .. HEBREW LETTER ZAYIN WITH DAGESH
     Lo,  -- (16#0FB38#, 16#0FB3C#)  HEBREW LETTER TET WITH DAGESH .. HEBREW LETTER LAMED WITH DAGESH
     Lo,  -- (16#0FB3E#, 16#0FB3E#)  HEBREW LETTER MEM WITH DAGESH .. HEBREW LETTER MEM WITH DAGESH
     Lo,  -- (16#0FB40#, 16#0FB41#)  HEBREW LETTER NUN WITH DAGESH .. HEBREW LETTER SAMEKH WITH DAGESH
     Lo,  -- (16#0FB43#, 16#0FB44#)  HEBREW LETTER FINAL PE WITH DAGESH .. HEBREW LETTER PE WITH DAGESH
     Lo,  -- (16#0FB46#, 16#0FBB1#)  HEBREW LETTER TSADI WITH DAGESH .. ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
     Lo,  -- (16#0FBD3#, 16#0FD3D#)  ARABIC LETTER NG ISOLATED FORM .. ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
     Ps,  -- (16#0FD3E#, 16#0FD3E#)  ORNATE LEFT PARENTHESIS .. ORNATE LEFT PARENTHESIS
     Pe,  -- (16#0FD3F#, 16#0FD3F#)  ORNATE RIGHT PARENTHESIS .. ORNATE RIGHT PARENTHESIS
     Lo,  -- (16#0FD50#, 16#0FD8F#)  ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM .. ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
     Lo,  -- (16#0FD92#, 16#0FDC7#)  ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM .. ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
     Lo,  -- (16#0FDF0#, 16#0FDFB#)  ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM .. ARABIC LIGATURE JALLAJALALOUHOU
     Sc,  -- (16#0FDFC#, 16#0FDFC#)  RIAL SIGN .. RIAL SIGN
     So,  -- (16#0FDFD#, 16#0FDFD#)  ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM .. ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM
     Mn,  -- (16#0FE00#, 16#0FE0F#)  VARIATION SELECTOR-1 .. VARIATION SELECTOR-16
     Mn,  -- (16#0FE20#, 16#0FE23#)  COMBINING LIGATURE LEFT HALF .. COMBINING DOUBLE TILDE RIGHT HALF
     Po,  -- (16#0FE30#, 16#0FE30#)  PRESENTATION FORM FOR VERTICAL TWO DOT LEADER .. PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
     Pd,  -- (16#0FE31#, 16#0FE32#)  PRESENTATION FORM FOR VERTICAL EM DASH .. PRESENTATION FORM FOR VERTICAL EN DASH
     Pc,  -- (16#0FE33#, 16#0FE34#)  PRESENTATION FORM FOR VERTICAL LOW LINE .. PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
     Ps,  -- (16#0FE35#, 16#0FE35#)  PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS .. PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
     Pe,  -- (16#0FE36#, 16#0FE36#)  PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS .. PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
     Ps,  -- (16#0FE37#, 16#0FE37#)  PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
     Pe,  -- (16#0FE38#, 16#0FE38#)  PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
     Ps,  -- (16#0FE39#, 16#0FE39#)  PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
     Pe,  -- (16#0FE3A#, 16#0FE3A#)  PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
     Ps,  -- (16#0FE3B#, 16#0FE3B#)  PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
     Pe,  -- (16#0FE3C#, 16#0FE3C#)  PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
     Ps,  -- (16#0FE3D#, 16#0FE3D#)  PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
     Pe,  -- (16#0FE3E#, 16#0FE3E#)  PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
     Ps,  -- (16#0FE3F#, 16#0FE3F#)  PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
     Pe,  -- (16#0FE40#, 16#0FE40#)  PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
     Ps,  -- (16#0FE41#, 16#0FE41#)  PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
     Pe,  -- (16#0FE42#, 16#0FE42#)  PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
     Ps,  -- (16#0FE43#, 16#0FE43#)  PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
     Pe,  -- (16#0FE44#, 16#0FE44#)  PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
     Po,  -- (16#0FE45#, 16#0FE46#)  SESAME DOT .. WHITE SESAME DOT
     Ps,  -- (16#0FE47#, 16#0FE47#)  PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET .. PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
     Pe,  -- (16#0FE48#, 16#0FE48#)  PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET .. PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
     Po,  -- (16#0FE49#, 16#0FE4C#)  DASHED OVERLINE .. DOUBLE WAVY OVERLINE
     Pc,  -- (16#0FE4D#, 16#0FE4F#)  DASHED LOW LINE .. WAVY LOW LINE
     Po,  -- (16#0FE50#, 16#0FE52#)  SMALL COMMA .. SMALL FULL STOP
     Po,  -- (16#0FE54#, 16#0FE57#)  SMALL SEMICOLON .. SMALL EXCLAMATION MARK
     Pd,  -- (16#0FE58#, 16#0FE58#)  SMALL EM DASH .. SMALL EM DASH
     Ps,  -- (16#0FE59#, 16#0FE59#)  SMALL LEFT PARENTHESIS .. SMALL LEFT PARENTHESIS
     Pe,  -- (16#0FE5A#, 16#0FE5A#)  SMALL RIGHT PARENTHESIS .. SMALL RIGHT PARENTHESIS
     Ps,  -- (16#0FE5B#, 16#0FE5B#)  SMALL LEFT CURLY BRACKET .. SMALL LEFT CURLY BRACKET
     Pe,  -- (16#0FE5C#, 16#0FE5C#)  SMALL RIGHT CURLY BRACKET .. SMALL RIGHT CURLY BRACKET
     Ps,  -- (16#0FE5D#, 16#0FE5D#)  SMALL LEFT TORTOISE SHELL BRACKET .. SMALL LEFT TORTOISE SHELL BRACKET
     Pe,  -- (16#0FE5E#, 16#0FE5E#)  SMALL RIGHT TORTOISE SHELL BRACKET .. SMALL RIGHT TORTOISE SHELL BRACKET
     Po,  -- (16#0FE5F#, 16#0FE61#)  SMALL NUMBER SIGN .. SMALL ASTERISK
     Sm,  -- (16#0FE62#, 16#0FE62#)  SMALL PLUS SIGN .. SMALL PLUS SIGN
     Pd,  -- (16#0FE63#, 16#0FE63#)  SMALL HYPHEN-MINUS .. SMALL HYPHEN-MINUS
     Sm,  -- (16#0FE64#, 16#0FE66#)  SMALL LESS-THAN SIGN .. SMALL EQUALS SIGN
     Po,  -- (16#0FE68#, 16#0FE68#)  SMALL REVERSE SOLIDUS .. SMALL REVERSE SOLIDUS
     Sc,  -- (16#0FE69#, 16#0FE69#)  SMALL DOLLAR SIGN .. SMALL DOLLAR SIGN
     Po,  -- (16#0FE6A#, 16#0FE6B#)  SMALL PERCENT SIGN .. SMALL COMMERCIAL AT
     Lo,  -- (16#0FE70#, 16#0FE74#)  ARABIC FATHATAN ISOLATED FORM .. ARABIC KASRATAN ISOLATED FORM
     Lo,  -- (16#0FE76#, 16#0FEFC#)  ARABIC FATHA ISOLATED FORM .. ARABIC LIGATURE LAM WITH ALEF FINAL FORM
     Cf,  -- (16#0FEFF#, 16#0FEFF#)  ZERO WIDTH NO-BREAK SPACE .. ZERO WIDTH NO-BREAK SPACE
     Po,  -- (16#0FF01#, 16#0FF03#)  FULLWIDTH EXCLAMATION MARK .. FULLWIDTH NUMBER SIGN
     Sc,  -- (16#0FF04#, 16#0FF04#)  FULLWIDTH DOLLAR SIGN .. FULLWIDTH DOLLAR SIGN
     Po,  -- (16#0FF05#, 16#0FF07#)  FULLWIDTH PERCENT SIGN .. FULLWIDTH APOSTROPHE
     Ps,  -- (16#0FF08#, 16#0FF08#)  FULLWIDTH LEFT PARENTHESIS .. FULLWIDTH LEFT PARENTHESIS
     Pe,  -- (16#0FF09#, 16#0FF09#)  FULLWIDTH RIGHT PARENTHESIS .. FULLWIDTH RIGHT PARENTHESIS
     Po,  -- (16#0FF0A#, 16#0FF0A#)  FULLWIDTH ASTERISK .. FULLWIDTH ASTERISK
     Sm,  -- (16#0FF0B#, 16#0FF0B#)  FULLWIDTH PLUS SIGN .. FULLWIDTH PLUS SIGN
     Po,  -- (16#0FF0C#, 16#0FF0C#)  FULLWIDTH COMMA .. FULLWIDTH COMMA
     Pd,  -- (16#0FF0D#, 16#0FF0D#)  FULLWIDTH HYPHEN-MINUS .. FULLWIDTH HYPHEN-MINUS
     Po,  -- (16#0FF0E#, 16#0FF0F#)  FULLWIDTH FULL STOP .. FULLWIDTH SOLIDUS
     Nd,  -- (16#0FF10#, 16#0FF19#)  FULLWIDTH DIGIT ZERO .. FULLWIDTH DIGIT NINE
     Po,  -- (16#0FF1A#, 16#0FF1B#)  FULLWIDTH COLON .. FULLWIDTH SEMICOLON
     Sm,  -- (16#0FF1C#, 16#0FF1E#)  FULLWIDTH LESS-THAN SIGN .. FULLWIDTH GREATER-THAN SIGN
     Po,  -- (16#0FF1F#, 16#0FF20#)  FULLWIDTH QUESTION MARK .. FULLWIDTH COMMERCIAL AT
     Lu,  -- (16#0FF21#, 16#0FF3A#)  FULLWIDTH LATIN CAPITAL LETTER A .. FULLWIDTH LATIN CAPITAL LETTER Z
     Ps,  -- (16#0FF3B#, 16#0FF3B#)  FULLWIDTH LEFT SQUARE BRACKET .. FULLWIDTH LEFT SQUARE BRACKET
     Po,  -- (16#0FF3C#, 16#0FF3C#)  FULLWIDTH REVERSE SOLIDUS .. FULLWIDTH REVERSE SOLIDUS
     Pe,  -- (16#0FF3D#, 16#0FF3D#)  FULLWIDTH RIGHT SQUARE BRACKET .. FULLWIDTH RIGHT SQUARE BRACKET
     Sk,  -- (16#0FF3E#, 16#0FF3E#)  FULLWIDTH CIRCUMFLEX ACCENT .. FULLWIDTH CIRCUMFLEX ACCENT
     Pc,  -- (16#0FF3F#, 16#0FF3F#)  FULLWIDTH LOW LINE .. FULLWIDTH LOW LINE
     Sk,  -- (16#0FF40#, 16#0FF40#)  FULLWIDTH GRAVE ACCENT .. FULLWIDTH GRAVE ACCENT
     Ll,  -- (16#0FF41#, 16#0FF5A#)  FULLWIDTH LATIN SMALL LETTER A .. FULLWIDTH LATIN SMALL LETTER Z
     Ps,  -- (16#0FF5B#, 16#0FF5B#)  FULLWIDTH LEFT CURLY BRACKET .. FULLWIDTH LEFT CURLY BRACKET
     Sm,  -- (16#0FF5C#, 16#0FF5C#)  FULLWIDTH VERTICAL LINE .. FULLWIDTH VERTICAL LINE
     Pe,  -- (16#0FF5D#, 16#0FF5D#)  FULLWIDTH RIGHT CURLY BRACKET .. FULLWIDTH RIGHT CURLY BRACKET
     Sm,  -- (16#0FF5E#, 16#0FF5E#)  FULLWIDTH TILDE .. FULLWIDTH TILDE
     Ps,  -- (16#0FF5F#, 16#0FF5F#)  FULLWIDTH LEFT WHITE PARENTHESIS .. FULLWIDTH LEFT WHITE PARENTHESIS
     Pe,  -- (16#0FF60#, 16#0FF60#)  FULLWIDTH RIGHT WHITE PARENTHESIS .. FULLWIDTH RIGHT WHITE PARENTHESIS
     Po,  -- (16#0FF61#, 16#0FF61#)  HALFWIDTH IDEOGRAPHIC FULL STOP .. HALFWIDTH IDEOGRAPHIC FULL STOP
     Ps,  -- (16#0FF62#, 16#0FF62#)  HALFWIDTH LEFT CORNER BRACKET .. HALFWIDTH LEFT CORNER BRACKET
     Pe,  -- (16#0FF63#, 16#0FF63#)  HALFWIDTH RIGHT CORNER BRACKET .. HALFWIDTH RIGHT CORNER BRACKET
     Po,  -- (16#0FF64#, 16#0FF64#)  HALFWIDTH IDEOGRAPHIC COMMA .. HALFWIDTH IDEOGRAPHIC COMMA
     Pc,  -- (16#0FF65#, 16#0FF65#)  HALFWIDTH KATAKANA MIDDLE DOT .. HALFWIDTH KATAKANA MIDDLE DOT
     Lo,  -- (16#0FF66#, 16#0FF6F#)  HALFWIDTH KATAKANA LETTER WO .. HALFWIDTH KATAKANA LETTER SMALL TU
     Lm,  -- (16#0FF70#, 16#0FF70#)  HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK .. HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
     Lo,  -- (16#0FF71#, 16#0FF9D#)  HALFWIDTH KATAKANA LETTER A .. HALFWIDTH KATAKANA LETTER N
     Lm,  -- (16#0FF9E#, 16#0FF9F#)  HALFWIDTH KATAKANA VOICED SOUND MARK .. HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
     Lo,  -- (16#0FFA0#, 16#0FFBE#)  HALFWIDTH HANGUL FILLER .. HALFWIDTH HANGUL LETTER HIEUH
     Lo,  -- (16#0FFC2#, 16#0FFC7#)  HALFWIDTH HANGUL LETTER A .. HALFWIDTH HANGUL LETTER E
     Lo,  -- (16#0FFCA#, 16#0FFCF#)  HALFWIDTH HANGUL LETTER YEO .. HALFWIDTH HANGUL LETTER OE
     Lo,  -- (16#0FFD2#, 16#0FFD7#)  HALFWIDTH HANGUL LETTER YO .. HALFWIDTH HANGUL LETTER YU
     Lo,  -- (16#0FFDA#, 16#0FFDC#)  HALFWIDTH HANGUL LETTER EU .. HALFWIDTH HANGUL LETTER I
     Sc,  -- (16#0FFE0#, 16#0FFE1#)  FULLWIDTH CENT SIGN .. FULLWIDTH POUND SIGN
     Sm,  -- (16#0FFE2#, 16#0FFE2#)  FULLWIDTH NOT SIGN .. FULLWIDTH NOT SIGN
     Sk,  -- (16#0FFE3#, 16#0FFE3#)  FULLWIDTH MACRON .. FULLWIDTH MACRON
     So,  -- (16#0FFE4#, 16#0FFE4#)  FULLWIDTH BROKEN BAR .. FULLWIDTH BROKEN BAR
     Sc,  -- (16#0FFE5#, 16#0FFE6#)  FULLWIDTH YEN SIGN .. FULLWIDTH WON SIGN
     So,  -- (16#0FFE8#, 16#0FFE8#)  HALFWIDTH FORMS LIGHT VERTICAL .. HALFWIDTH FORMS LIGHT VERTICAL
     Sm,  -- (16#0FFE9#, 16#0FFEC#)  HALFWIDTH LEFTWARDS ARROW .. HALFWIDTH DOWNWARDS ARROW
     So,  -- (16#0FFED#, 16#0FFEE#)  HALFWIDTH BLACK SQUARE .. HALFWIDTH WHITE CIRCLE
     Cf,  -- (16#0FFF9#, 16#0FFFB#)  INTERLINEAR ANNOTATION ANCHOR .. INTERLINEAR ANNOTATION TERMINATOR
     So,  -- (16#0FFFC#, 16#0FFFD#)  OBJECT REPLACEMENT CHARACTER .. REPLACEMENT CHARACTER
     Lo,  -- (16#10000#, 16#1000B#)  LINEAR B SYLLABLE B008 A .. LINEAR B SYLLABLE B046 JE
     Lo,  -- (16#1000D#, 16#10026#)  LINEAR B SYLLABLE B036 JO .. LINEAR B SYLLABLE B032 QO
     Lo,  -- (16#10028#, 16#1003A#)  LINEAR B SYLLABLE B060 RA .. LINEAR B SYLLABLE B042 WO
     Lo,  -- (16#1003C#, 16#1003D#)  LINEAR B SYLLABLE B017 ZA .. LINEAR B SYLLABLE B074 ZE
     Lo,  -- (16#1003F#, 16#1004D#)  LINEAR B SYLLABLE B020 ZO .. LINEAR B SYLLABLE B091 TWO
     Lo,  -- (16#10050#, 16#1005D#)  LINEAR B SYMBOL B018 .. LINEAR B SYMBOL B089
     Lo,  -- (16#10080#, 16#100FA#)  LINEAR B IDEOGRAM B100 MAN .. LINEAR B IDEOGRAM VESSEL B305
     Po,  -- (16#10100#, 16#10101#)  AEGEAN WORD SEPARATOR LINE .. AEGEAN WORD SEPARATOR DOT
     So,  -- (16#10102#, 16#10102#)  AEGEAN CHECK MARK .. AEGEAN CHECK MARK
     No,  -- (16#10107#, 16#10133#)  AEGEAN NUMBER ONE .. AEGEAN NUMBER NINETY THOUSAND
     So,  -- (16#10137#, 16#1013F#)  AEGEAN WEIGHT BASE UNIT .. AEGEAN MEASURE THIRD SUBUNIT
     Lo,  -- (16#10300#, 16#1031E#)  OLD ITALIC LETTER A .. OLD ITALIC LETTER UU
     No,  -- (16#10320#, 16#10323#)  OLD ITALIC NUMERAL ONE .. OLD ITALIC NUMERAL FIFTY
     Lo,  -- (16#10330#, 16#10349#)  GOTHIC LETTER AHSA .. GOTHIC LETTER OTHAL
     Nl,  -- (16#1034A#, 16#1034A#)  GOTHIC LETTER NINE HUNDRED .. GOTHIC LETTER NINE HUNDRED
     Lo,  -- (16#10380#, 16#1039D#)  UGARITIC LETTER ALPA .. UGARITIC LETTER SSU
     Po,  -- (16#1039F#, 16#1039F#)  UGARITIC WORD DIVIDER .. UGARITIC WORD DIVIDER
     Lu,  -- (16#10400#, 16#10427#)  DESERET CAPITAL LETTER LONG I .. DESERET CAPITAL LETTER EW
     Ll,  -- (16#10428#, 16#1044F#)  DESERET SMALL LETTER LONG I .. DESERET SMALL LETTER EW
     Lo,  -- (16#10450#, 16#1049D#)  SHAVIAN LETTER PEEP .. OSMANYA LETTER OO
     Nd,  -- (16#104A0#, 16#104A9#)  OSMANYA DIGIT ZERO .. OSMANYA DIGIT NINE
     Lo,  -- (16#10800#, 16#10805#)  CYPRIOT SYLLABLE A .. CYPRIOT SYLLABLE JA
     Lo,  -- (16#10808#, 16#10808#)  CYPRIOT SYLLABLE JO .. CYPRIOT SYLLABLE JO
     Lo,  -- (16#1080A#, 16#10835#)  CYPRIOT SYLLABLE KA .. CYPRIOT SYLLABLE WO
     Lo,  -- (16#10837#, 16#10838#)  CYPRIOT SYLLABLE XA .. CYPRIOT SYLLABLE XE
     Lo,  -- (16#1083C#, 16#1083C#)  CYPRIOT SYLLABLE ZA .. CYPRIOT SYLLABLE ZA
     Lo,  -- (16#1083F#, 16#1083F#)  CYPRIOT SYLLABLE ZO .. CYPRIOT SYLLABLE ZO
     So,  -- (16#1D000#, 16#1D0F5#)  BYZANTINE MUSICAL SYMBOL PSILI .. BYZANTINE MUSICAL SYMBOL GORGON NEO KATO
     So,  -- (16#1D100#, 16#1D126#)  MUSICAL SYMBOL SINGLE BARLINE .. MUSICAL SYMBOL DRUM CLEF-2
     So,  -- (16#1D12A#, 16#1D164#)  MUSICAL SYMBOL DOUBLE SHARP .. MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
     Mc,  -- (16#1D165#, 16#1D166#)  MUSICAL SYMBOL COMBINING STEM .. MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
     Mn,  -- (16#1D167#, 16#1D169#)  MUSICAL SYMBOL COMBINING TREMOLO-1 .. MUSICAL SYMBOL COMBINING TREMOLO-3
     So,  -- (16#1D16A#, 16#1D16C#)  MUSICAL SYMBOL FINGERED TREMOLO-1 .. MUSICAL SYMBOL FINGERED TREMOLO-3
     Mc,  -- (16#1D16D#, 16#1D172#)  MUSICAL SYMBOL COMBINING AUGMENTATION DOT .. MUSICAL SYMBOL COMBINING FLAG-5
     Cf,  -- (16#1D173#, 16#1D17A#)  MUSICAL SYMBOL BEGIN BEAM .. MUSICAL SYMBOL END PHRASE
     Mn,  -- (16#1D17B#, 16#1D182#)  MUSICAL SYMBOL COMBINING ACCENT .. MUSICAL SYMBOL COMBINING LOURE
     So,  -- (16#1D183#, 16#1D184#)  MUSICAL SYMBOL ARPEGGIATO UP .. MUSICAL SYMBOL ARPEGGIATO DOWN
     Mn,  -- (16#1D185#, 16#1D18B#)  MUSICAL SYMBOL COMBINING DOIT .. MUSICAL SYMBOL COMBINING TRIPLE TONGUE
     So,  -- (16#1D18C#, 16#1D1A9#)  MUSICAL SYMBOL RINFORZANDO .. MUSICAL SYMBOL DEGREE SLASH
     Mn,  -- (16#1D1AA#, 16#1D1AD#)  MUSICAL SYMBOL COMBINING DOWN BOW .. MUSICAL SYMBOL COMBINING SNAP PIZZICATO
     So,  -- (16#1D1AE#, 16#1D1DD#)  MUSICAL SYMBOL PEDAL MARK .. MUSICAL SYMBOL PES SUBPUNCTIS
     So,  -- (16#1D300#, 16#1D356#)  MONOGRAM FOR EARTH .. TETRAGRAM FOR FOSTERING
     Lu,  -- (16#1D400#, 16#1D419#)  MATHEMATICAL BOLD CAPITAL A .. MATHEMATICAL BOLD CAPITAL Z
     Ll,  -- (16#1D41A#, 16#1D433#)  MATHEMATICAL BOLD SMALL A .. MATHEMATICAL BOLD SMALL Z
     Lu,  -- (16#1D434#, 16#1D44D#)  MATHEMATICAL ITALIC CAPITAL A .. MATHEMATICAL ITALIC CAPITAL Z
     Ll,  -- (16#1D44E#, 16#1D454#)  MATHEMATICAL ITALIC SMALL A .. MATHEMATICAL ITALIC SMALL G
     Ll,  -- (16#1D456#, 16#1D467#)  MATHEMATICAL ITALIC SMALL I .. MATHEMATICAL ITALIC SMALL Z
     Lu,  -- (16#1D468#, 16#1D481#)  MATHEMATICAL BOLD ITALIC CAPITAL A .. MATHEMATICAL BOLD ITALIC CAPITAL Z
     Ll,  -- (16#1D482#, 16#1D49B#)  MATHEMATICAL BOLD ITALIC SMALL A .. MATHEMATICAL BOLD ITALIC SMALL Z
     Lu,  -- (16#1D49C#, 16#1D49C#)  MATHEMATICAL SCRIPT CAPITAL A .. MATHEMATICAL SCRIPT CAPITAL A
     Lu,  -- (16#1D49E#, 16#1D49F#)  MATHEMATICAL SCRIPT CAPITAL C .. MATHEMATICAL SCRIPT CAPITAL D
     Lu,  -- (16#1D4A2#, 16#1D4A2#)  MATHEMATICAL SCRIPT CAPITAL G .. MATHEMATICAL SCRIPT CAPITAL G
     Lu,  -- (16#1D4A5#, 16#1D4A6#)  MATHEMATICAL SCRIPT CAPITAL J .. MATHEMATICAL SCRIPT CAPITAL K
     Lu,  -- (16#1D4A9#, 16#1D4AC#)  MATHEMATICAL SCRIPT CAPITAL N .. MATHEMATICAL SCRIPT CAPITAL Q
     Lu,  -- (16#1D4AE#, 16#1D4B5#)  MATHEMATICAL SCRIPT CAPITAL S .. MATHEMATICAL SCRIPT CAPITAL Z
     Ll,  -- (16#1D4B6#, 16#1D4B9#)  MATHEMATICAL SCRIPT SMALL A .. MATHEMATICAL SCRIPT SMALL D
     Ll,  -- (16#1D4BB#, 16#1D4BB#)  MATHEMATICAL SCRIPT SMALL F .. MATHEMATICAL SCRIPT SMALL F
     Ll,  -- (16#1D4BD#, 16#1D4C3#)  MATHEMATICAL SCRIPT SMALL H .. MATHEMATICAL SCRIPT SMALL N
     Ll,  -- (16#1D4C5#, 16#1D4CF#)  MATHEMATICAL SCRIPT SMALL P .. MATHEMATICAL SCRIPT SMALL Z
     Lu,  -- (16#1D4D0#, 16#1D4E9#)  MATHEMATICAL BOLD SCRIPT CAPITAL A .. MATHEMATICAL BOLD SCRIPT CAPITAL Z
     Ll,  -- (16#1D4EA#, 16#1D503#)  MATHEMATICAL BOLD SCRIPT SMALL A .. MATHEMATICAL BOLD SCRIPT SMALL Z
     Lu,  -- (16#1D504#, 16#1D505#)  MATHEMATICAL FRAKTUR CAPITAL A .. MATHEMATICAL FRAKTUR CAPITAL B
     Lu,  -- (16#1D507#, 16#1D50A#)  MATHEMATICAL FRAKTUR CAPITAL D .. MATHEMATICAL FRAKTUR CAPITAL G
     Lu,  -- (16#1D50D#, 16#1D514#)  MATHEMATICAL FRAKTUR CAPITAL J .. MATHEMATICAL FRAKTUR CAPITAL Q
     Lu,  -- (16#1D516#, 16#1D51C#)  MATHEMATICAL FRAKTUR CAPITAL S .. MATHEMATICAL FRAKTUR CAPITAL Y
     Ll,  -- (16#1D51E#, 16#1D537#)  MATHEMATICAL FRAKTUR SMALL A .. MATHEMATICAL FRAKTUR SMALL Z
     Lu,  -- (16#1D538#, 16#1D539#)  MATHEMATICAL DOUBLE-STRUCK CAPITAL A .. MATHEMATICAL DOUBLE-STRUCK CAPITAL B
     Lu,  -- (16#1D53B#, 16#1D53E#)  MATHEMATICAL DOUBLE-STRUCK CAPITAL D .. MATHEMATICAL DOUBLE-STRUCK CAPITAL G
     Lu,  -- (16#1D540#, 16#1D544#)  MATHEMATICAL DOUBLE-STRUCK CAPITAL I .. MATHEMATICAL DOUBLE-STRUCK CAPITAL M
     Lu,  -- (16#1D546#, 16#1D546#)  MATHEMATICAL DOUBLE-STRUCK CAPITAL O .. MATHEMATICAL DOUBLE-STRUCK CAPITAL O
     Lu,  -- (16#1D54A#, 16#1D550#)  MATHEMATICAL DOUBLE-STRUCK CAPITAL S .. MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
     Ll,  -- (16#1D552#, 16#1D56B#)  MATHEMATICAL DOUBLE-STRUCK SMALL A .. MATHEMATICAL DOUBLE-STRUCK SMALL Z
     Lu,  -- (16#1D56C#, 16#1D585#)  MATHEMATICAL BOLD FRAKTUR CAPITAL A .. MATHEMATICAL BOLD FRAKTUR CAPITAL Z
     Ll,  -- (16#1D586#, 16#1D59F#)  MATHEMATICAL BOLD FRAKTUR SMALL A .. MATHEMATICAL BOLD FRAKTUR SMALL Z
     Lu,  -- (16#1D5A0#, 16#1D5B9#)  MATHEMATICAL SANS-SERIF CAPITAL A .. MATHEMATICAL SANS-SERIF CAPITAL Z
     Ll,  -- (16#1D5BA#, 16#1D5D3#)  MATHEMATICAL SANS-SERIF SMALL A .. MATHEMATICAL SANS-SERIF SMALL Z
     Lu,  -- (16#1D5D4#, 16#1D5ED#)  MATHEMATICAL SANS-SERIF BOLD CAPITAL A .. MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
     Ll,  -- (16#1D5EE#, 16#1D607#)  MATHEMATICAL SANS-SERIF BOLD SMALL A .. MATHEMATICAL SANS-SERIF BOLD SMALL Z
     Lu,  -- (16#1D608#, 16#1D621#)  MATHEMATICAL SANS-SERIF ITALIC CAPITAL A .. MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
     Ll,  -- (16#1D622#, 16#1D63B#)  MATHEMATICAL SANS-SERIF ITALIC SMALL A .. MATHEMATICAL SANS-SERIF ITALIC SMALL Z
     Lu,  -- (16#1D63C#, 16#1D655#)  MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A .. MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
     Ll,  -- (16#1D656#, 16#1D66F#)  MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A .. MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
     Lu,  -- (16#1D670#, 16#1D689#)  MATHEMATICAL MONOSPACE CAPITAL A .. MATHEMATICAL MONOSPACE CAPITAL Z
     Ll,  -- (16#1D68A#, 16#1D6A3#)  MATHEMATICAL MONOSPACE SMALL A .. MATHEMATICAL MONOSPACE SMALL Z
     Lu,  -- (16#1D6A8#, 16#1D6C0#)  MATHEMATICAL BOLD CAPITAL ALPHA .. MATHEMATICAL BOLD CAPITAL OMEGA
     Sm,  -- (16#1D6C1#, 16#1D6C1#)  MATHEMATICAL BOLD NABLA .. MATHEMATICAL BOLD NABLA
     Ll,  -- (16#1D6C2#, 16#1D6DA#)  MATHEMATICAL BOLD SMALL ALPHA .. MATHEMATICAL BOLD SMALL OMEGA
     Sm,  -- (16#1D6DB#, 16#1D6DB#)  MATHEMATICAL BOLD PARTIAL DIFFERENTIAL .. MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
     Ll,  -- (16#1D6DC#, 16#1D6E1#)  MATHEMATICAL BOLD EPSILON SYMBOL .. MATHEMATICAL BOLD PI SYMBOL
     Lu,  -- (16#1D6E2#, 16#1D6FA#)  MATHEMATICAL ITALIC CAPITAL ALPHA .. MATHEMATICAL ITALIC CAPITAL OMEGA
     Sm,  -- (16#1D6FB#, 16#1D6FB#)  MATHEMATICAL ITALIC NABLA .. MATHEMATICAL ITALIC NABLA
     Ll,  -- (16#1D6FC#, 16#1D714#)  MATHEMATICAL ITALIC SMALL ALPHA .. MATHEMATICAL ITALIC SMALL OMEGA
     Sm,  -- (16#1D715#, 16#1D715#)  MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL .. MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
     Ll,  -- (16#1D716#, 16#1D71B#)  MATHEMATICAL ITALIC EPSILON SYMBOL .. MATHEMATICAL ITALIC PI SYMBOL
     Lu,  -- (16#1D71C#, 16#1D734#)  MATHEMATICAL BOLD ITALIC CAPITAL ALPHA .. MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
     Sm,  -- (16#1D735#, 16#1D735#)  MATHEMATICAL BOLD ITALIC NABLA .. MATHEMATICAL BOLD ITALIC NABLA
     Ll,  -- (16#1D736#, 16#1D74E#)  MATHEMATICAL BOLD ITALIC SMALL ALPHA .. MATHEMATICAL BOLD ITALIC SMALL OMEGA
     Sm,  -- (16#1D74F#, 16#1D74F#)  MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL .. MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
     Ll,  -- (16#1D750#, 16#1D755#)  MATHEMATICAL BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL BOLD ITALIC PI SYMBOL
     Lu,  -- (16#1D756#, 16#1D76E#)  MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA .. MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
     Sm,  -- (16#1D76F#, 16#1D76F#)  MATHEMATICAL SANS-SERIF BOLD NABLA .. MATHEMATICAL SANS-SERIF BOLD NABLA
     Ll,  -- (16#1D770#, 16#1D788#)  MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
     Sm,  -- (16#1D789#, 16#1D789#)  MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL .. MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
     Ll,  -- (16#1D78A#, 16#1D78F#)  MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
     Lu,  -- (16#1D790#, 16#1D7A8#)  MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA .. MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
     Sm,  -- (16#1D7A9#, 16#1D7A9#)  MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA .. MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
     Ll,  -- (16#1D7AA#, 16#1D7C2#)  MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
     Sm,  -- (16#1D7C3#, 16#1D7C3#)  MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL .. MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
     Ll,  -- (16#1D7C4#, 16#1D7C9#)  MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
     Nd,  -- (16#1D7CE#, 16#1D7FF#)  MATHEMATICAL BOLD DIGIT ZERO .. MATHEMATICAL MONOSPACE DIGIT NINE
     Lo,  -- (16#20000#, 16#2A6D6#)  <CJK Ideograph Extension B, First> .. <CJK Ideograph Extension B, Last>
     Lo,  -- (16#2F800#, 16#2FA1D#)  CJK COMPATIBILITY IDEOGRAPH-2F800 .. CJK COMPATIBILITY IDEOGRAPH-2FA1D
     Cf,  -- (16#E0001#, 16#E0001#)  LANGUAGE TAG .. LANGUAGE TAG
     Cf,  -- (16#E0020#, 16#E007F#)  TAG SPACE .. CANCEL TAG
     Mn,  -- (16#E0100#, 16#E01EF#)  VARIATION SELECTOR-17 .. VARIATION SELECTOR-256
     Co,  -- (16#F0000#, 16#FFFFD#)  <Plane 15 Private Use, First> .. <Plane 15 Private Use, Last>
     Co); -- (16#100000#, 16#10FFFD#)  <Plane 16 Private Use, First> .. <Plane 16 Private Use, Last>

   --  The following array includes all characters considered digits, i.e.
   --  all characters from the Unicode table with categories:

   --    Number, Decimal Digit (Nd)

   UTF_32_Digits : constant UTF_32_Ranges := (
     (16#00030#, 16#00039#),  -- DIGIT ZERO .. DIGIT NINE
     (16#00660#, 16#00669#),  -- ARABIC-INDIC DIGIT ZERO .. ARABIC-INDIC DIGIT NINE
     (16#006F0#, 16#006F9#),  -- EXTENDED ARABIC-INDIC DIGIT ZERO .. EXTENDED ARABIC-INDIC DIGIT NINE
     (16#00966#, 16#0096F#),  -- DEVANAGARI DIGIT ZERO .. DEVANAGARI DIGIT NINE
     (16#009E6#, 16#009EF#),  -- BENGALI DIGIT ZERO .. BENGALI DIGIT NINE
     (16#00A66#, 16#00A6F#),  -- GURMUKHI DIGIT ZERO .. GURMUKHI DIGIT NINE
     (16#00AE6#, 16#00AEF#),  -- GUJARATI DIGIT ZERO .. GUJARATI DIGIT NINE
     (16#00B66#, 16#00B6F#),  -- ORIYA DIGIT ZERO .. ORIYA DIGIT NINE
     (16#00BE7#, 16#00BEF#),  -- TAMIL DIGIT ONE .. TAMIL DIGIT NINE
     (16#00C66#, 16#00C6F#),  -- TELUGU DIGIT ZERO .. TELUGU DIGIT NINE
     (16#00CE6#, 16#00CEF#),  -- KANNADA DIGIT ZERO .. KANNADA DIGIT NINE
     (16#00D66#, 16#00D6F#),  -- MALAYALAM DIGIT ZERO .. MALAYALAM DIGIT NINE
     (16#00E50#, 16#00E59#),  -- THAI DIGIT ZERO .. THAI DIGIT NINE
     (16#00ED0#, 16#00ED9#),  -- LAO DIGIT ZERO .. LAO DIGIT NINE
     (16#00F20#, 16#00F29#),  -- TIBETAN DIGIT ZERO .. TIBETAN DIGIT NINE
     (16#01040#, 16#01049#),  -- MYANMAR DIGIT ZERO .. MYANMAR DIGIT NINE
     (16#01369#, 16#01371#),  -- ETHIOPIC DIGIT ONE .. ETHIOPIC DIGIT NINE
     (16#017E0#, 16#017E9#),  -- KHMER DIGIT ZERO .. KHMER DIGIT NINE
     (16#01810#, 16#01819#),  -- MONGOLIAN DIGIT ZERO .. MONGOLIAN DIGIT NINE
     (16#01946#, 16#0194F#),  -- LIMBU DIGIT ZERO .. LIMBU DIGIT NINE
     (16#0FF10#, 16#0FF19#),  -- FULLWIDTH DIGIT ZERO .. FULLWIDTH DIGIT NINE
     (16#104A0#, 16#104A9#),  -- OSMANYA DIGIT ZERO .. OSMANYA DIGIT NINE
     (16#1D7CE#, 16#1D7FF#)); -- MATHEMATICAL BOLD DIGIT ZERO .. MATHEMATICAL MONOSPACE DIGIT NINE

   --  The following table includes all characters considered letters, i.e.
   --  all characters from the Unicode table with categories:

   --    Letter, Uppercase (Lu)
   --    Letter, Lowercase (Ll)
   --    Letter, Titlecase (Lt)
   --    Letter, Modifier (Lm)
   --    Letter, Other (Lo)
   --    Number, Letter (Nl)

   UTF_32_Letters : constant UTF_32_Ranges := (
     (16#00041#, 16#0005A#),  -- LATIN CAPITAL LETTER A .. LATIN CAPITAL LETTER Z
     (16#00061#, 16#0007A#),  -- LATIN SMALL LETTER A .. LATIN SMALL LETTER Z
     (16#000AA#, 16#000AA#),  -- FEMININE ORDINAL INDICATOR .. FEMININE ORDINAL INDICATOR
     (16#000B5#, 16#000B5#),  -- MICRO SIGN .. MICRO SIGN
     (16#000BA#, 16#000BA#),  -- MASCULINE ORDINAL INDICATOR .. MASCULINE ORDINAL INDICATOR
     (16#000C0#, 16#000D6#),  -- LATIN CAPITAL LETTER A WITH GRAVE .. LATIN CAPITAL LETTER O WITH DIAERESIS
     (16#000D8#, 16#000F6#),  -- LATIN CAPITAL LETTER O WITH STROKE .. LATIN SMALL LETTER O WITH DIAERESIS
     (16#000F8#, 16#00236#),  -- LATIN SMALL LETTER O WITH STROKE .. LATIN SMALL LETTER T WITH CURL
     (16#00250#, 16#002C1#),  -- LATIN SMALL LETTER TURNED A .. MODIFIER LETTER REVERSED GLOTTAL STOP
     (16#002C6#, 16#002D1#),  -- MODIFIER LETTER CIRCUMFLEX ACCENT .. MODIFIER LETTER HALF TRIANGULAR COLON
     (16#002E0#, 16#002E4#),  -- MODIFIER LETTER SMALL GAMMA .. MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
     (16#002EE#, 16#002EE#),  -- MODIFIER LETTER DOUBLE APOSTROPHE .. MODIFIER LETTER DOUBLE APOSTROPHE
     (16#0037A#, 16#0037A#),  -- GREEK YPOGEGRAMMENI .. GREEK YPOGEGRAMMENI
     (16#00386#, 16#00386#),  -- GREEK CAPITAL LETTER ALPHA WITH TONOS .. GREEK CAPITAL LETTER ALPHA WITH TONOS
     (16#00388#, 16#0038A#),  -- GREEK CAPITAL LETTER EPSILON WITH TONOS .. GREEK CAPITAL LETTER IOTA WITH TONOS
     (16#0038C#, 16#0038C#),  -- GREEK CAPITAL LETTER OMICRON WITH TONOS .. GREEK CAPITAL LETTER OMICRON WITH TONOS
     (16#0038E#, 16#003A1#),  -- GREEK CAPITAL LETTER UPSILON WITH TONOS .. GREEK CAPITAL LETTER RHO
     (16#003A3#, 16#003CE#),  -- GREEK CAPITAL LETTER SIGMA .. GREEK SMALL LETTER OMEGA WITH TONOS
     (16#003D0#, 16#003F5#),  -- GREEK BETA SYMBOL .. GREEK LUNATE EPSILON SYMBOL
     (16#003F7#, 16#003FB#),  -- GREEK CAPITAL LETTER SHO .. GREEK SMALL LETTER SAN
     (16#00400#, 16#00481#),  -- CYRILLIC CAPITAL LETTER IE WITH GRAVE .. CYRILLIC SMALL LETTER KOPPA
     (16#0048A#, 16#004CE#),  -- CYRILLIC CAPITAL LETTER SHORT I WITH TAIL .. CYRILLIC SMALL LETTER EM WITH TAIL
     (16#004D0#, 16#004F5#),  -- CYRILLIC CAPITAL LETTER A WITH BREVE .. CYRILLIC SMALL LETTER CHE WITH DIAERESIS
     (16#004F8#, 16#004F9#),  -- CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS .. CYRILLIC SMALL LETTER YERU WITH DIAERESIS
     (16#00500#, 16#0050F#),  -- CYRILLIC CAPITAL LETTER KOMI DE .. CYRILLIC SMALL LETTER KOMI TJE
     (16#00531#, 16#00556#),  -- ARMENIAN CAPITAL LETTER AYB .. ARMENIAN CAPITAL LETTER FEH
     (16#00559#, 16#00559#),  -- ARMENIAN MODIFIER LETTER LEFT HALF RING .. ARMENIAN MODIFIER LETTER LEFT HALF RING
     (16#00561#, 16#00587#),  -- ARMENIAN SMALL LETTER AYB .. ARMENIAN SMALL LIGATURE ECH YIWN
     (16#005D0#, 16#005EA#),  -- HEBREW LETTER ALEF .. HEBREW LETTER TAV
     (16#005F0#, 16#005F2#),  -- HEBREW LIGATURE YIDDISH DOUBLE VAV .. HEBREW LIGATURE YIDDISH DOUBLE YOD
     (16#00621#, 16#0063A#),  -- ARABIC LETTER HAMZA .. ARABIC LETTER GHAIN
     (16#00640#, 16#0064A#),  -- ARABIC TATWEEL .. ARABIC LETTER YEH
     (16#0066E#, 16#0066F#),  -- ARABIC LETTER DOTLESS BEH .. ARABIC LETTER DOTLESS QAF
     (16#00671#, 16#006D3#),  -- ARABIC LETTER ALEF WASLA .. ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
     (16#006D5#, 16#006D5#),  -- ARABIC LETTER AE .. ARABIC LETTER AE
     (16#006E5#, 16#006E6#),  -- ARABIC SMALL WAW .. ARABIC SMALL YEH
     (16#006EE#, 16#006EF#),  -- ARABIC LETTER DAL WITH INVERTED V .. ARABIC LETTER REH WITH INVERTED V
     (16#006FA#, 16#006FC#),  -- ARABIC LETTER SHEEN WITH DOT BELOW .. ARABIC LETTER GHAIN WITH DOT BELOW
     (16#006FF#, 16#006FF#),  -- ARABIC LETTER HEH WITH INVERTED V .. ARABIC LETTER HEH WITH INVERTED V
     (16#00710#, 16#00710#),  -- SYRIAC LETTER ALAPH .. SYRIAC LETTER ALAPH
     (16#00712#, 16#0072F#),  -- SYRIAC LETTER BETH .. SYRIAC LETTER PERSIAN DHALATH
     (16#0074D#, 16#0074F#),  -- SYRIAC LETTER SOGDIAN ZHAIN .. SYRIAC LETTER SOGDIAN FE
     (16#00780#, 16#007A5#),  -- THAANA LETTER HAA .. THAANA LETTER WAAVU
     (16#007B1#, 16#007B1#),  -- THAANA LETTER NAA .. THAANA LETTER NAA
     (16#00904#, 16#00939#),  -- DEVANAGARI LETTER SHORT A .. DEVANAGARI LETTER HA
     (16#0093D#, 16#0093D#),  -- DEVANAGARI SIGN AVAGRAHA .. DEVANAGARI SIGN AVAGRAHA
     (16#00950#, 16#00950#),  -- DEVANAGARI OM .. DEVANAGARI OM
     (16#00958#, 16#00961#),  -- DEVANAGARI LETTER QA .. DEVANAGARI LETTER VOCALIC LL
     (16#00985#, 16#0098C#),  -- BENGALI LETTER A .. BENGALI LETTER VOCALIC L
     (16#0098F#, 16#00990#),  -- BENGALI LETTER E .. BENGALI LETTER AI
     (16#00993#, 16#009A8#),  -- BENGALI LETTER O .. BENGALI LETTER NA
     (16#009AA#, 16#009B0#),  -- BENGALI LETTER PA .. BENGALI LETTER RA
     (16#009B2#, 16#009B2#),  -- BENGALI LETTER LA .. BENGALI LETTER LA
     (16#009B6#, 16#009B9#),  -- BENGALI LETTER SHA .. BENGALI LETTER HA
     (16#009BD#, 16#009BD#),  -- BENGALI SIGN AVAGRAHA .. BENGALI SIGN AVAGRAHA
     (16#009DC#, 16#009DD#),  -- BENGALI LETTER RRA .. BENGALI LETTER RHA
     (16#009DF#, 16#009E1#),  -- BENGALI LETTER YYA .. BENGALI LETTER VOCALIC LL
     (16#009F0#, 16#009F1#),  -- BENGALI LETTER RA WITH MIDDLE DIAGONAL .. BENGALI LETTER RA WITH LOWER DIAGONAL
     (16#00A05#, 16#00A0A#),  -- GURMUKHI LETTER A .. GURMUKHI LETTER UU
     (16#00A0F#, 16#00A10#),  -- GURMUKHI LETTER EE .. GURMUKHI LETTER AI
     (16#00A13#, 16#00A28#),  -- GURMUKHI LETTER OO .. GURMUKHI LETTER NA
     (16#00A2A#, 16#00A30#),  -- GURMUKHI LETTER PA .. GURMUKHI LETTER RA
     (16#00A32#, 16#00A33#),  -- GURMUKHI LETTER LA .. GURMUKHI LETTER LLA
     (16#00A35#, 16#00A36#),  -- GURMUKHI LETTER VA .. GURMUKHI LETTER SHA
     (16#00A38#, 16#00A39#),  -- GURMUKHI LETTER SA .. GURMUKHI LETTER HA
     (16#00A59#, 16#00A5C#),  -- GURMUKHI LETTER KHHA .. GURMUKHI LETTER RRA
     (16#00A5E#, 16#00A5E#),  -- GURMUKHI LETTER FA .. GURMUKHI LETTER FA
     (16#00A72#, 16#00A74#),  -- GURMUKHI IRI .. GURMUKHI EK ONKAR
     (16#00A85#, 16#00A8D#),  -- GUJARATI LETTER A .. GUJARATI VOWEL CANDRA E
     (16#00A8F#, 16#00A91#),  -- GUJARATI LETTER E .. GUJARATI VOWEL CANDRA O
     (16#00A93#, 16#00AA8#),  -- GUJARATI LETTER O .. GUJARATI LETTER NA
     (16#00AAA#, 16#00AB0#),  -- GUJARATI LETTER PA .. GUJARATI LETTER RA
     (16#00AB2#, 16#00AB3#),  -- GUJARATI LETTER LA .. GUJARATI LETTER LLA
     (16#00AB5#, 16#00AB9#),  -- GUJARATI LETTER VA .. GUJARATI LETTER HA
     (16#00ABD#, 16#00ABD#),  -- GUJARATI SIGN AVAGRAHA .. GUJARATI SIGN AVAGRAHA
     (16#00AD0#, 16#00AD0#),  -- GUJARATI OM .. GUJARATI OM
     (16#00AE0#, 16#00AE1#),  -- GUJARATI LETTER VOCALIC RR .. GUJARATI LETTER VOCALIC LL
     (16#00B05#, 16#00B0C#),  -- ORIYA LETTER A .. ORIYA LETTER VOCALIC L
     (16#00B0F#, 16#00B10#),  -- ORIYA LETTER E .. ORIYA LETTER AI
     (16#00B13#, 16#00B28#),  -- ORIYA LETTER O .. ORIYA LETTER NA
     (16#00B2A#, 16#00B30#),  -- ORIYA LETTER PA .. ORIYA LETTER RA
     (16#00B32#, 16#00B33#),  -- ORIYA LETTER LA .. ORIYA LETTER LLA
     (16#00B35#, 16#00B39#),  -- ORIYA LETTER VA .. ORIYA LETTER HA
     (16#00B3D#, 16#00B3D#),  -- ORIYA SIGN AVAGRAHA .. ORIYA SIGN AVAGRAHA
     (16#00B5C#, 16#00B5D#),  -- ORIYA LETTER RRA .. ORIYA LETTER RHA
     (16#00B5F#, 16#00B61#),  -- ORIYA LETTER YYA .. ORIYA LETTER VOCALIC LL
     (16#00B71#, 16#00B71#),  -- ORIYA LETTER WA .. ORIYA LETTER WA
     (16#00B83#, 16#00B83#),  -- TAMIL SIGN VISARGA .. TAMIL SIGN VISARGA
     (16#00B85#, 16#00B8A#),  -- TAMIL LETTER A .. TAMIL LETTER UU
     (16#00B8E#, 16#00B90#),  -- TAMIL LETTER E .. TAMIL LETTER AI
     (16#00B92#, 16#00B95#),  -- TAMIL LETTER O .. TAMIL LETTER KA
     (16#00B99#, 16#00B9A#),  -- TAMIL LETTER NGA .. TAMIL LETTER CA
     (16#00B9C#, 16#00B9C#),  -- TAMIL LETTER JA .. TAMIL LETTER JA
     (16#00B9E#, 16#00B9F#),  -- TAMIL LETTER NYA .. TAMIL LETTER TTA
     (16#00BA3#, 16#00BA4#),  -- TAMIL LETTER NNA .. TAMIL LETTER TA
     (16#00BA8#, 16#00BAA#),  -- TAMIL LETTER NA .. TAMIL LETTER PA
     (16#00BAE#, 16#00BB5#),  -- TAMIL LETTER MA .. TAMIL LETTER VA
     (16#00BB7#, 16#00BB9#),  -- TAMIL LETTER SSA .. TAMIL LETTER HA
     (16#00C05#, 16#00C0C#),  -- TELUGU LETTER A .. TELUGU LETTER VOCALIC L
     (16#00C0E#, 16#00C10#),  -- TELUGU LETTER E .. TELUGU LETTER AI
     (16#00C12#, 16#00C28#),  -- TELUGU LETTER O .. TELUGU LETTER NA
     (16#00C2A#, 16#00C33#),  -- TELUGU LETTER PA .. TELUGU LETTER LLA
     (16#00C35#, 16#00C39#),  -- TELUGU LETTER VA .. TELUGU LETTER HA
     (16#00C60#, 16#00C61#),  -- TELUGU LETTER VOCALIC RR .. TELUGU LETTER VOCALIC LL
     (16#00C85#, 16#00C8C#),  -- KANNADA LETTER A .. KANNADA LETTER VOCALIC L
     (16#00C8E#, 16#00C90#),  -- KANNADA LETTER E .. KANNADA LETTER AI
     (16#00C92#, 16#00CA8#),  -- KANNADA LETTER O .. KANNADA LETTER NA
     (16#00CAA#, 16#00CB3#),  -- KANNADA LETTER PA .. KANNADA LETTER LLA
     (16#00CB5#, 16#00CB9#),  -- KANNADA LETTER VA .. KANNADA LETTER HA
     (16#00CBD#, 16#00CBD#),  -- KANNADA SIGN AVAGRAHA .. KANNADA SIGN AVAGRAHA
     (16#00CDE#, 16#00CDE#),  -- KANNADA LETTER FA .. KANNADA LETTER FA
     (16#00CE0#, 16#00CE1#),  -- KANNADA LETTER VOCALIC RR .. KANNADA LETTER VOCALIC LL
     (16#00D05#, 16#00D0C#),  -- MALAYALAM LETTER A .. MALAYALAM LETTER VOCALIC L
     (16#00D0E#, 16#00D10#),  -- MALAYALAM LETTER E .. MALAYALAM LETTER AI
     (16#00D12#, 16#00D28#),  -- MALAYALAM LETTER O .. MALAYALAM LETTER NA
     (16#00D2A#, 16#00D39#),  -- MALAYALAM LETTER PA .. MALAYALAM LETTER HA
     (16#00D60#, 16#00D61#),  -- MALAYALAM LETTER VOCALIC RR .. MALAYALAM LETTER VOCALIC LL
     (16#00D85#, 16#00D96#),  -- SINHALA LETTER AYANNA .. SINHALA LETTER AUYANNA
     (16#00D9A#, 16#00DB1#),  -- SINHALA LETTER ALPAPRAANA KAYANNA .. SINHALA LETTER DANTAJA NAYANNA
     (16#00DB3#, 16#00DBB#),  -- SINHALA LETTER SANYAKA DAYANNA .. SINHALA LETTER RAYANNA
     (16#00DBD#, 16#00DBD#),  -- SINHALA LETTER DANTAJA LAYANNA .. SINHALA LETTER DANTAJA LAYANNA
     (16#00DC0#, 16#00DC6#),  -- SINHALA LETTER VAYANNA .. SINHALA LETTER FAYANNA
     (16#00E01#, 16#00E30#),  -- THAI CHARACTER KO KAI .. THAI CHARACTER SARA A
     (16#00E32#, 16#00E33#),  -- THAI CHARACTER SARA AA .. THAI CHARACTER SARA AM
     (16#00E40#, 16#00E46#),  -- THAI CHARACTER SARA E .. THAI CHARACTER MAIYAMOK
     (16#00E81#, 16#00E82#),  -- LAO LETTER KO .. LAO LETTER KHO SUNG
     (16#00E84#, 16#00E84#),  -- LAO LETTER KHO TAM .. LAO LETTER KHO TAM
     (16#00E87#, 16#00E88#),  -- LAO LETTER NGO .. LAO LETTER CO
     (16#00E8A#, 16#00E8A#),  -- LAO LETTER SO TAM .. LAO LETTER SO TAM
     (16#00E8D#, 16#00E8D#),  -- LAO LETTER NYO .. LAO LETTER NYO
     (16#00E94#, 16#00E97#),  -- LAO LETTER DO .. LAO LETTER THO TAM
     (16#00E99#, 16#00E9F#),  -- LAO LETTER NO .. LAO LETTER FO SUNG
     (16#00EA1#, 16#00EA3#),  -- LAO LETTER MO .. LAO LETTER LO LING
     (16#00EA5#, 16#00EA5#),  -- LAO LETTER LO LOOT .. LAO LETTER LO LOOT
     (16#00EA7#, 16#00EA7#),  -- LAO LETTER WO .. LAO LETTER WO
     (16#00EAA#, 16#00EAB#),  -- LAO LETTER SO SUNG .. LAO LETTER HO SUNG
     (16#00EAD#, 16#00EB0#),  -- LAO LETTER O .. LAO VOWEL SIGN A
     (16#00EB2#, 16#00EB3#),  -- LAO VOWEL SIGN AA .. LAO VOWEL SIGN AM
     (16#00EBD#, 16#00EBD#),  -- LAO SEMIVOWEL SIGN NYO .. LAO SEMIVOWEL SIGN NYO
     (16#00EC0#, 16#00EC4#),  -- LAO VOWEL SIGN E .. LAO VOWEL SIGN AI
     (16#00EC6#, 16#00EC6#),  -- LAO KO LA .. LAO KO LA
     (16#00EDC#, 16#00EDD#),  -- LAO HO NO .. LAO HO MO
     (16#00F00#, 16#00F00#),  -- TIBETAN SYLLABLE OM .. TIBETAN SYLLABLE OM
     (16#00F40#, 16#00F47#),  -- TIBETAN LETTER KA .. TIBETAN LETTER JA
     (16#00F49#, 16#00F6A#),  -- TIBETAN LETTER NYA .. TIBETAN LETTER FIXED-FORM RA
     (16#00F88#, 16#00F8B#),  -- TIBETAN SIGN LCE TSA CAN .. TIBETAN SIGN GRU MED RGYINGS
     (16#01000#, 16#01021#),  -- MYANMAR LETTER KA .. MYANMAR LETTER A
     (16#01023#, 16#01027#),  -- MYANMAR LETTER I .. MYANMAR LETTER E
     (16#01029#, 16#0102A#),  -- MYANMAR LETTER O .. MYANMAR LETTER AU
     (16#01050#, 16#01055#),  -- MYANMAR LETTER SHA .. MYANMAR LETTER VOCALIC LL
     (16#010A0#, 16#010C5#),  -- GEORGIAN CAPITAL LETTER AN .. GEORGIAN CAPITAL LETTER HOE
     (16#010D0#, 16#010F8#),  -- GEORGIAN LETTER AN .. GEORGIAN LETTER ELIFI
     (16#01100#, 16#01159#),  -- HANGUL CHOSEONG KIYEOK .. HANGUL CHOSEONG YEORINHIEUH
     (16#0115F#, 16#011A2#),  -- HANGUL CHOSEONG FILLER .. HANGUL JUNGSEONG SSANGARAEA
     (16#011A8#, 16#011F9#),  -- HANGUL JONGSEONG KIYEOK .. HANGUL JONGSEONG YEORINHIEUH
     (16#01200#, 16#01206#),  -- ETHIOPIC SYLLABLE HA .. ETHIOPIC SYLLABLE HO
     (16#01208#, 16#01246#),  -- ETHIOPIC SYLLABLE LA .. ETHIOPIC SYLLABLE QO
     (16#01248#, 16#01248#),  -- ETHIOPIC SYLLABLE QWA .. ETHIOPIC SYLLABLE QWA
     (16#0124A#, 16#0124D#),  -- ETHIOPIC SYLLABLE QWI .. ETHIOPIC SYLLABLE QWE
     (16#01250#, 16#01256#),  -- ETHIOPIC SYLLABLE QHA .. ETHIOPIC SYLLABLE QHO
     (16#01258#, 16#01258#),  -- ETHIOPIC SYLLABLE QHWA .. ETHIOPIC SYLLABLE QHWA
     (16#0125A#, 16#0125D#),  -- ETHIOPIC SYLLABLE QHWI .. ETHIOPIC SYLLABLE QHWE
     (16#01260#, 16#01286#),  -- ETHIOPIC SYLLABLE BA .. ETHIOPIC SYLLABLE XO
     (16#01288#, 16#01288#),  -- ETHIOPIC SYLLABLE XWA .. ETHIOPIC SYLLABLE XWA
     (16#0128A#, 16#0128D#),  -- ETHIOPIC SYLLABLE XWI .. ETHIOPIC SYLLABLE XWE
     (16#01290#, 16#012AE#),  -- ETHIOPIC SYLLABLE NA .. ETHIOPIC SYLLABLE KO
     (16#012B0#, 16#012B0#),  -- ETHIOPIC SYLLABLE KWA .. ETHIOPIC SYLLABLE KWA
     (16#012B2#, 16#012B5#),  -- ETHIOPIC SYLLABLE KWI .. ETHIOPIC SYLLABLE KWE
     (16#012B8#, 16#012BE#),  -- ETHIOPIC SYLLABLE KXA .. ETHIOPIC SYLLABLE KXO
     (16#012C0#, 16#012C0#),  -- ETHIOPIC SYLLABLE KXWA .. ETHIOPIC SYLLABLE KXWA
     (16#012C2#, 16#012C5#),  -- ETHIOPIC SYLLABLE KXWI .. ETHIOPIC SYLLABLE KXWE
     (16#012C8#, 16#012CE#),  -- ETHIOPIC SYLLABLE WA .. ETHIOPIC SYLLABLE WO
     (16#012D0#, 16#012D6#),  -- ETHIOPIC SYLLABLE PHARYNGEAL A .. ETHIOPIC SYLLABLE PHARYNGEAL O
     (16#012D8#, 16#012EE#),  -- ETHIOPIC SYLLABLE ZA .. ETHIOPIC SYLLABLE YO
     (16#012F0#, 16#0130E#),  -- ETHIOPIC SYLLABLE DA .. ETHIOPIC SYLLABLE GO
     (16#01310#, 16#01310#),  -- ETHIOPIC SYLLABLE GWA .. ETHIOPIC SYLLABLE GWA
     (16#01312#, 16#01315#),  -- ETHIOPIC SYLLABLE GWI .. ETHIOPIC SYLLABLE GWE
     (16#01318#, 16#0131E#),  -- ETHIOPIC SYLLABLE GGA .. ETHIOPIC SYLLABLE GGO
     (16#01320#, 16#01346#),  -- ETHIOPIC SYLLABLE THA .. ETHIOPIC SYLLABLE TZO
     (16#01348#, 16#0135A#),  -- ETHIOPIC SYLLABLE FA .. ETHIOPIC SYLLABLE FYA
     (16#013A0#, 16#013F4#),  -- CHEROKEE LETTER A .. CHEROKEE LETTER YV
     (16#01401#, 16#0166C#),  -- CANADIAN SYLLABICS E .. CANADIAN SYLLABICS CARRIER TTSA
     (16#0166F#, 16#01676#),  -- CANADIAN SYLLABICS QAI .. CANADIAN SYLLABICS NNGAA
     (16#01681#, 16#0169A#),  -- OGHAM LETTER BEITH .. OGHAM LETTER PEITH
     (16#016A0#, 16#016EA#),  -- RUNIC LETTER FEHU FEOH FE F .. RUNIC LETTER X
     (16#016EE#, 16#016F0#),  -- RUNIC ARLAUG SYMBOL .. RUNIC BELGTHOR SYMBOL
     (16#01700#, 16#0170C#),  -- TAGALOG LETTER A .. TAGALOG LETTER YA
     (16#0170E#, 16#01711#),  -- TAGALOG LETTER LA .. TAGALOG LETTER HA
     (16#01720#, 16#01731#),  -- HANUNOO LETTER A .. HANUNOO LETTER HA
     (16#01740#, 16#01751#),  -- BUHID LETTER A .. BUHID LETTER HA
     (16#01760#, 16#0176C#),  -- TAGBANWA LETTER A .. TAGBANWA LETTER YA
     (16#0176E#, 16#01770#),  -- TAGBANWA LETTER LA .. TAGBANWA LETTER SA
     (16#01780#, 16#017B3#),  -- KHMER LETTER KA .. KHMER INDEPENDENT VOWEL QAU
     (16#017D7#, 16#017D7#),  -- KHMER SIGN LEK TOO .. KHMER SIGN LEK TOO
     (16#017DC#, 16#017DC#),  -- KHMER SIGN AVAKRAHASANYA .. KHMER SIGN AVAKRAHASANYA
     (16#01820#, 16#01877#),  -- MONGOLIAN LETTER A .. MONGOLIAN LETTER MANCHU ZHA
     (16#01880#, 16#018A8#),  -- MONGOLIAN LETTER ALI GALI ANUSVARA ONE .. MONGOLIAN LETTER MANCHU ALI GALI BHA
     (16#01900#, 16#0191C#),  -- LIMBU VOWEL-CARRIER LETTER .. LIMBU LETTER HA
     (16#01950#, 16#0196D#),  -- TAI LE LETTER KA .. TAI LE LETTER AI
     (16#01970#, 16#01974#),  -- TAI LE LETTER TONE-2 .. TAI LE LETTER TONE-6
     (16#01D00#, 16#01D6B#),  -- LATIN LETTER SMALL CAPITAL A .. LATIN SMALL LETTER UE
     (16#01E00#, 16#01E9B#),  -- LATIN CAPITAL LETTER A WITH RING BELOW .. LATIN SMALL LETTER LONG S WITH DOT ABOVE
     (16#01EA0#, 16#01EF9#),  -- LATIN CAPITAL LETTER A WITH DOT BELOW .. LATIN SMALL LETTER Y WITH TILDE
     (16#01F00#, 16#01F15#),  -- GREEK SMALL LETTER ALPHA WITH PSILI .. GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F18#, 16#01F1D#),  -- GREEK CAPITAL LETTER EPSILON WITH PSILI .. GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F20#, 16#01F45#),  -- GREEK SMALL LETTER ETA WITH PSILI .. GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F48#, 16#01F4D#),  -- GREEK CAPITAL LETTER OMICRON WITH PSILI .. GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F50#, 16#01F57#),  -- GREEK SMALL LETTER UPSILON WITH PSILI .. GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
     (16#01F59#, 16#01F59#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA
     (16#01F5B#, 16#01F5B#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
     (16#01F5D#, 16#01F5D#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
     (16#01F5F#, 16#01F7D#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK SMALL LETTER OMEGA WITH OXIA
     (16#01F80#, 16#01FB4#),  -- GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI .. GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
     (16#01FB6#, 16#01FBC#),  -- GREEK SMALL LETTER ALPHA WITH PERISPOMENI .. GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
     (16#01FBE#, 16#01FBE#),  -- GREEK PROSGEGRAMMENI .. GREEK PROSGEGRAMMENI
     (16#01FC2#, 16#01FC4#),  -- GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI .. GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
     (16#01FC6#, 16#01FCC#),  -- GREEK SMALL LETTER ETA WITH PERISPOMENI .. GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
     (16#01FD0#, 16#01FD3#),  -- GREEK SMALL LETTER IOTA WITH VRACHY .. GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
     (16#01FD6#, 16#01FDB#),  -- GREEK SMALL LETTER IOTA WITH PERISPOMENI .. GREEK CAPITAL LETTER IOTA WITH OXIA
     (16#01FE0#, 16#01FEC#),  -- GREEK SMALL LETTER UPSILON WITH VRACHY .. GREEK CAPITAL LETTER RHO WITH DASIA
     (16#01FF2#, 16#01FF4#),  -- GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI .. GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
     (16#01FF6#, 16#01FFC#),  -- GREEK SMALL LETTER OMEGA WITH PERISPOMENI .. GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
     (16#02071#, 16#02071#),  -- SUPERSCRIPT LATIN SMALL LETTER I .. SUPERSCRIPT LATIN SMALL LETTER I
     (16#0207F#, 16#0207F#),  -- SUPERSCRIPT LATIN SMALL LETTER N .. SUPERSCRIPT LATIN SMALL LETTER N
     (16#02102#, 16#02102#),  -- DOUBLE-STRUCK CAPITAL C .. DOUBLE-STRUCK CAPITAL C
     (16#02107#, 16#02107#),  -- EULER CONSTANT .. EULER CONSTANT
     (16#0210A#, 16#02113#),  -- SCRIPT SMALL G .. SCRIPT SMALL L
     (16#02115#, 16#02115#),  -- DOUBLE-STRUCK CAPITAL N .. DOUBLE-STRUCK CAPITAL N
     (16#02119#, 16#0211D#),  -- DOUBLE-STRUCK CAPITAL P .. DOUBLE-STRUCK CAPITAL R
     (16#02124#, 16#02124#),  -- DOUBLE-STRUCK CAPITAL Z .. DOUBLE-STRUCK CAPITAL Z
     (16#02126#, 16#02126#),  -- OHM SIGN .. OHM SIGN
     (16#02128#, 16#02128#),  -- BLACK-LETTER CAPITAL Z .. BLACK-LETTER CAPITAL Z
     (16#0212A#, 16#0212D#),  -- KELVIN SIGN .. BLACK-LETTER CAPITAL C
     (16#0212F#, 16#02131#),  -- SCRIPT SMALL E .. SCRIPT CAPITAL F
     (16#02133#, 16#02139#),  -- SCRIPT CAPITAL M .. INFORMATION SOURCE
     (16#0213D#, 16#0213F#),  -- DOUBLE-STRUCK SMALL GAMMA .. DOUBLE-STRUCK CAPITAL PI
     (16#02145#, 16#02149#),  -- DOUBLE-STRUCK ITALIC CAPITAL D .. DOUBLE-STRUCK ITALIC SMALL J
     (16#02160#, 16#02183#),  -- ROMAN NUMERAL ONE .. ROMAN NUMERAL REVERSED ONE HUNDRED
     (16#03005#, 16#03007#),  -- IDEOGRAPHIC ITERATION MARK .. IDEOGRAPHIC NUMBER ZERO
     (16#03021#, 16#03029#),  -- HANGZHOU NUMERAL ONE .. HANGZHOU NUMERAL NINE
     (16#03031#, 16#03035#),  -- VERTICAL KANA REPEAT MARK .. VERTICAL KANA REPEAT MARK LOWER HALF
     (16#03038#, 16#0303C#),  -- HANGZHOU NUMERAL TEN .. MASU MARK
     (16#03041#, 16#03096#),  -- HIRAGANA LETTER SMALL A .. HIRAGANA LETTER SMALL KE
     (16#0309D#, 16#0309F#),  -- HIRAGANA ITERATION MARK .. HIRAGANA DIGRAPH YORI
     (16#030A1#, 16#030FA#),  -- KATAKANA LETTER SMALL A .. KATAKANA LETTER VO
     (16#030FC#, 16#030FF#),  -- KATAKANA-HIRAGANA PROLONGED SOUND MARK .. KATAKANA DIGRAPH KOTO
     (16#03105#, 16#0312C#),  -- BOPOMOFO LETTER B .. BOPOMOFO LETTER GN
     (16#03131#, 16#0318E#),  -- HANGUL LETTER KIYEOK .. HANGUL LETTER ARAEAE
     (16#031A0#, 16#031B7#),  -- BOPOMOFO LETTER BU .. BOPOMOFO FINAL LETTER H
     (16#031F0#, 16#031FF#),  -- KATAKANA LETTER SMALL KU .. KATAKANA LETTER SMALL RO
     (16#03400#, 16#04DB5#),  -- <CJK Ideograph Extension A, First> .. <CJK Ideograph Extension A, Last>
     (16#04E00#, 16#09FA5#),  -- <CJK Ideograph, First> .. <CJK Ideograph, Last>
     (16#0A000#, 16#0A48C#),  -- YI SYLLABLE IT .. YI SYLLABLE YYR
     (16#0AC00#, 16#0D7A3#),  -- <Hangul Syllable, First> .. <Hangul Syllable, Last>
     (16#0F900#, 16#0FA2D#),  -- CJK COMPATIBILITY IDEOGRAPH-F900 .. CJK COMPATIBILITY IDEOGRAPH-FA2D
     (16#0FA30#, 16#0FA6A#),  -- CJK COMPATIBILITY IDEOGRAPH-FA30 .. CJK COMPATIBILITY IDEOGRAPH-FA6A
     (16#0FB00#, 16#0FB06#),  -- LATIN SMALL LIGATURE FF .. LATIN SMALL LIGATURE ST
     (16#0FB13#, 16#0FB17#),  -- ARMENIAN SMALL LIGATURE MEN NOW .. ARMENIAN SMALL LIGATURE MEN XEH
     (16#0FB1D#, 16#0FB1D#),  -- HEBREW LETTER YOD WITH HIRIQ .. HEBREW LETTER YOD WITH HIRIQ
     (16#0FB1F#, 16#0FB28#),  -- HEBREW LIGATURE YIDDISH YOD YOD PATAH .. HEBREW LETTER WIDE TAV
     (16#0FB2A#, 16#0FB36#),  -- HEBREW LETTER SHIN WITH SHIN DOT .. HEBREW LETTER ZAYIN WITH DAGESH
     (16#0FB38#, 16#0FB3C#),  -- HEBREW LETTER TET WITH DAGESH .. HEBREW LETTER LAMED WITH DAGESH
     (16#0FB3E#, 16#0FB3E#),  -- HEBREW LETTER MEM WITH DAGESH .. HEBREW LETTER MEM WITH DAGESH
     (16#0FB40#, 16#0FB41#),  -- HEBREW LETTER NUN WITH DAGESH .. HEBREW LETTER SAMEKH WITH DAGESH
     (16#0FB43#, 16#0FB44#),  -- HEBREW LETTER FINAL PE WITH DAGESH .. HEBREW LETTER PE WITH DAGESH
     (16#0FB46#, 16#0FBB1#),  -- HEBREW LETTER TSADI WITH DAGESH .. ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
     (16#0FBD3#, 16#0FD3D#),  -- ARABIC LETTER NG ISOLATED FORM .. ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
     (16#0FD50#, 16#0FD8F#),  -- ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM .. ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
     (16#0FD92#, 16#0FDC7#),  -- ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM .. ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
     (16#0FDF0#, 16#0FDFB#),  -- ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM .. ARABIC LIGATURE JALLAJALALOUHOU
     (16#0FE70#, 16#0FE74#),  -- ARABIC FATHATAN ISOLATED FORM .. ARABIC KASRATAN ISOLATED FORM
     (16#0FE76#, 16#0FEFC#),  -- ARABIC FATHA ISOLATED FORM .. ARABIC LIGATURE LAM WITH ALEF FINAL FORM
     (16#0FF21#, 16#0FF3A#),  -- FULLWIDTH LATIN CAPITAL LETTER A .. FULLWIDTH LATIN CAPITAL LETTER Z
     (16#0FF41#, 16#0FF5A#),  -- FULLWIDTH LATIN SMALL LETTER A .. FULLWIDTH LATIN SMALL LETTER Z
     (16#0FF66#, 16#0FFBE#),  -- HALFWIDTH KATAKANA LETTER WO .. HALFWIDTH HANGUL LETTER HIEUH
     (16#0FFC2#, 16#0FFC7#),  -- HALFWIDTH HANGUL LETTER A .. HALFWIDTH HANGUL LETTER E
     (16#0FFCA#, 16#0FFCF#),  -- HALFWIDTH HANGUL LETTER YEO .. HALFWIDTH HANGUL LETTER OE
     (16#0FFD2#, 16#0FFD7#),  -- HALFWIDTH HANGUL LETTER YO .. HALFWIDTH HANGUL LETTER YU
     (16#0FFDA#, 16#0FFDC#),  -- HALFWIDTH HANGUL LETTER EU .. HALFWIDTH HANGUL LETTER I
     (16#10000#, 16#1000B#),  -- LINEAR B SYLLABLE B008 A .. LINEAR B SYLLABLE B046 JE
     (16#1000D#, 16#10026#),  -- LINEAR B SYLLABLE B036 JO .. LINEAR B SYLLABLE B032 QO
     (16#10028#, 16#1003A#),  -- LINEAR B SYLLABLE B060 RA .. LINEAR B SYLLABLE B042 WO
     (16#1003C#, 16#1003D#),  -- LINEAR B SYLLABLE B017 ZA .. LINEAR B SYLLABLE B074 ZE
     (16#1003F#, 16#1004D#),  -- LINEAR B SYLLABLE B020 ZO .. LINEAR B SYLLABLE B091 TWO
     (16#10050#, 16#1005D#),  -- LINEAR B SYMBOL B018 .. LINEAR B SYMBOL B089
     (16#10080#, 16#100FA#),  -- LINEAR B IDEOGRAM B100 MAN .. LINEAR B IDEOGRAM VESSEL B305
     (16#10300#, 16#1031E#),  -- OLD ITALIC LETTER A .. OLD ITALIC LETTER UU
     (16#10330#, 16#1034A#),  -- GOTHIC LETTER AHSA .. GOTHIC LETTER NINE HUNDRED
     (16#10380#, 16#1039D#),  -- UGARITIC LETTER ALPA .. UGARITIC LETTER SSU
     (16#10400#, 16#1049D#),  -- DESERET CAPITAL LETTER LONG I .. OSMANYA LETTER OO
     (16#10800#, 16#10805#),  -- CYPRIOT SYLLABLE A .. CYPRIOT SYLLABLE JA
     (16#10808#, 16#10808#),  -- CYPRIOT SYLLABLE JO .. CYPRIOT SYLLABLE JO
     (16#1080A#, 16#10835#),  -- CYPRIOT SYLLABLE KA .. CYPRIOT SYLLABLE WO
     (16#10837#, 16#10838#),  -- CYPRIOT SYLLABLE XA .. CYPRIOT SYLLABLE XE
     (16#1083C#, 16#1083C#),  -- CYPRIOT SYLLABLE ZA .. CYPRIOT SYLLABLE ZA
     (16#1083F#, 16#1083F#),  -- CYPRIOT SYLLABLE ZO .. CYPRIOT SYLLABLE ZO
     (16#1D400#, 16#1D454#),  -- MATHEMATICAL BOLD CAPITAL A .. MATHEMATICAL ITALIC SMALL G
     (16#1D456#, 16#1D49C#),  -- MATHEMATICAL ITALIC SMALL I .. MATHEMATICAL SCRIPT CAPITAL A
     (16#1D49E#, 16#1D49F#),  -- MATHEMATICAL SCRIPT CAPITAL C .. MATHEMATICAL SCRIPT CAPITAL D
     (16#1D4A2#, 16#1D4A2#),  -- MATHEMATICAL SCRIPT CAPITAL G .. MATHEMATICAL SCRIPT CAPITAL G
     (16#1D4A5#, 16#1D4A6#),  -- MATHEMATICAL SCRIPT CAPITAL J .. MATHEMATICAL SCRIPT CAPITAL K
     (16#1D4A9#, 16#1D4AC#),  -- MATHEMATICAL SCRIPT CAPITAL N .. MATHEMATICAL SCRIPT CAPITAL Q
     (16#1D4AE#, 16#1D4B9#),  -- MATHEMATICAL SCRIPT CAPITAL S .. MATHEMATICAL SCRIPT SMALL D
     (16#1D4BB#, 16#1D4BB#),  -- MATHEMATICAL SCRIPT SMALL F .. MATHEMATICAL SCRIPT SMALL F
     (16#1D4BD#, 16#1D4C3#),  -- MATHEMATICAL SCRIPT SMALL H .. MATHEMATICAL SCRIPT SMALL N
     (16#1D4C5#, 16#1D505#),  -- MATHEMATICAL SCRIPT SMALL P .. MATHEMATICAL FRAKTUR CAPITAL B
     (16#1D507#, 16#1D50A#),  -- MATHEMATICAL FRAKTUR CAPITAL D .. MATHEMATICAL FRAKTUR CAPITAL G
     (16#1D50D#, 16#1D514#),  -- MATHEMATICAL FRAKTUR CAPITAL J .. MATHEMATICAL FRAKTUR CAPITAL Q
     (16#1D516#, 16#1D51C#),  -- MATHEMATICAL FRAKTUR CAPITAL S .. MATHEMATICAL FRAKTUR CAPITAL Y
     (16#1D51E#, 16#1D539#),  -- MATHEMATICAL FRAKTUR SMALL A .. MATHEMATICAL DOUBLE-STRUCK CAPITAL B
     (16#1D53B#, 16#1D53E#),  -- MATHEMATICAL DOUBLE-STRUCK CAPITAL D .. MATHEMATICAL DOUBLE-STRUCK CAPITAL G
     (16#1D540#, 16#1D544#),  -- MATHEMATICAL DOUBLE-STRUCK CAPITAL I .. MATHEMATICAL DOUBLE-STRUCK CAPITAL M
     (16#1D546#, 16#1D546#),  -- MATHEMATICAL DOUBLE-STRUCK CAPITAL O .. MATHEMATICAL DOUBLE-STRUCK CAPITAL O
     (16#1D54A#, 16#1D550#),  -- MATHEMATICAL DOUBLE-STRUCK CAPITAL S .. MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
     (16#1D552#, 16#1D6A3#),  -- MATHEMATICAL DOUBLE-STRUCK SMALL A .. MATHEMATICAL MONOSPACE SMALL Z
     (16#1D6A8#, 16#1D6C0#),  -- MATHEMATICAL BOLD CAPITAL ALPHA .. MATHEMATICAL BOLD CAPITAL OMEGA
     (16#1D6C2#, 16#1D6DA#),  -- MATHEMATICAL BOLD SMALL ALPHA .. MATHEMATICAL BOLD SMALL OMEGA
     (16#1D6DC#, 16#1D6FA#),  -- MATHEMATICAL BOLD EPSILON SYMBOL .. MATHEMATICAL ITALIC CAPITAL OMEGA
     (16#1D6FC#, 16#1D714#),  -- MATHEMATICAL ITALIC SMALL ALPHA .. MATHEMATICAL ITALIC SMALL OMEGA
     (16#1D716#, 16#1D734#),  -- MATHEMATICAL ITALIC EPSILON SYMBOL .. MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
     (16#1D736#, 16#1D74E#),  -- MATHEMATICAL BOLD ITALIC SMALL ALPHA .. MATHEMATICAL BOLD ITALIC SMALL OMEGA
     (16#1D750#, 16#1D76E#),  -- MATHEMATICAL BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
     (16#1D770#, 16#1D788#),  -- MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
     (16#1D78A#, 16#1D7A8#),  -- MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
     (16#1D7AA#, 16#1D7C2#),  -- MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA .. MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
     (16#1D7C4#, 16#1D7C9#),  -- MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL .. MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
     (16#20000#, 16#2A6D6#),  -- <CJK Ideograph Extension B, First> .. <CJK Ideograph Extension B, Last>
     (16#2F800#, 16#2FA1D#)); -- CJK COMPATIBILITY IDEOGRAPH-2F800 .. CJK COMPATIBILITY IDEOGRAPH-2FA1D

   --  The following table includes all characters considered spaces, i.e.
   --  all characters from the Unicode table with categories:

   --    Separator, Space (Zs)

   UTF_32_Spaces : constant UTF_32_Ranges := (
     (16#00020#, 16#00020#),  -- SPACE .. SPACE
     (16#000A0#, 16#000A0#),  -- NO-BREAK SPACE .. NO-BREAK SPACE
     (16#01680#, 16#01680#),  -- OGHAM SPACE MARK .. OGHAM SPACE MARK
     (16#0180E#, 16#0180E#),  -- MONGOLIAN VOWEL SEPARATOR .. MONGOLIAN VOWEL SEPARATOR
     (16#02000#, 16#0200B#),  -- EN QUAD .. ZERO WIDTH SPACE
     (16#0202F#, 16#0202F#),  -- NARROW NO-BREAK SPACE .. NARROW NO-BREAK SPACE
     (16#0205F#, 16#0205F#),  -- MEDIUM MATHEMATICAL SPACE .. MEDIUM MATHEMATICAL SPACE
     (16#03000#, 16#03000#)); -- IDEOGRAPHIC SPACE .. IDEOGRAPHIC SPACE

   --  The following table includes all characters considered punctuation,
   --  i.e. all characters from the Unicode table with categories:

   --    Punctuation, Connector (Pc)

   UTF_32_Punctuation : constant UTF_32_Ranges := (
     (16#0005F#, 16#0005F#),  -- LOW LINE .. LOW LINE
     (16#0203F#, 16#02040#),  -- UNDERTIE .. CHARACTER TIE
     (16#02054#, 16#02054#),  -- INVERTED UNDERTIE .. INVERTED UNDERTIE
     (16#030FB#, 16#030FB#),  -- KATAKANA MIDDLE DOT .. KATAKANA MIDDLE DOT
     (16#0FE33#, 16#0FE34#),  -- PRESENTATION FORM FOR VERTICAL LOW LINE .. PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
     (16#0FE4D#, 16#0FE4F#),  -- DASHED LOW LINE .. WAVY LOW LINE
     (16#0FF3F#, 16#0FF3F#),  -- FULLWIDTH LOW LINE .. FULLWIDTH LOW LINE
     (16#0FF65#, 16#0FF65#)); -- HALFWIDTH KATAKANA MIDDLE DOT .. HALFWIDTH KATAKANA MIDDLE DOT

   --  The following table includes all characters considered as other format,
   --  i.e. all characters from the Unicode table with categories:

   --    Other, Format (Cf)

   UTF_32_Other_Format : constant UTF_32_Ranges := (
     (16#000AD#, 16#000AD#),  -- SOFT HYPHEN .. SOFT HYPHEN
     (16#00600#, 16#00603#),  -- ARABIC NUMBER SIGN .. ARABIC SIGN SAFHA
     (16#006DD#, 16#006DD#),  -- ARABIC END OF AYAH .. ARABIC END OF AYAH
     (16#0070F#, 16#0070F#),  -- SYRIAC ABBREVIATION MARK .. SYRIAC ABBREVIATION MARK
     (16#017B4#, 16#017B5#),  -- KHMER VOWEL INHERENT AQ .. KHMER VOWEL INHERENT AA
     (16#0200C#, 16#0200F#),  -- ZERO WIDTH NON-JOINER .. RIGHT-TO-LEFT MARK
     (16#0202A#, 16#0202E#),  -- LEFT-TO-RIGHT EMBEDDING .. RIGHT-TO-LEFT OVERRIDE
     (16#02060#, 16#02063#),  -- WORD JOINER .. INVISIBLE SEPARATOR
     (16#0206A#, 16#0206F#),  -- INHIBIT SYMMETRIC SWAPPING .. NOMINAL DIGIT SHAPES
     (16#0FEFF#, 16#0FEFF#),  -- ZERO WIDTH NO-BREAK SPACE .. ZERO WIDTH NO-BREAK SPACE
     (16#0FFF9#, 16#0FFFB#),  -- INTERLINEAR ANNOTATION ANCHOR .. INTERLINEAR ANNOTATION TERMINATOR
     (16#1D173#, 16#1D17A#),  -- MUSICAL SYMBOL BEGIN BEAM .. MUSICAL SYMBOL END PHRASE
     (16#E0001#, 16#E0001#),  -- LANGUAGE TAG .. LANGUAGE TAG
     (16#E0020#, 16#E007F#)); -- TAG SPACE .. CANCEL TAG

   --  The following table includes all characters considered marks i.e.
   --  all characters from the Unicode table with categories:

   --    Mark, Nonspacing (Mn)
   --    Mark, Spacing Combining (Mc)

   UTF_32_Marks : constant UTF_32_Ranges := (
     (16#00300#, 16#00357#),  -- COMBINING GRAVE ACCENT .. COMBINING RIGHT HALF RING ABOVE
     (16#0035D#, 16#0036F#),  -- COMBINING DOUBLE BREVE .. COMBINING LATIN SMALL LETTER X
     (16#00483#, 16#00486#),  -- COMBINING CYRILLIC TITLO .. COMBINING CYRILLIC PSILI PNEUMATA
     (16#00591#, 16#005A1#),  -- HEBREW ACCENT ETNAHTA .. HEBREW ACCENT PAZER
     (16#005A3#, 16#005B9#),  -- HEBREW ACCENT MUNAH .. HEBREW POINT HOLAM
     (16#005BB#, 16#005BD#),  -- HEBREW POINT QUBUTS .. HEBREW POINT METEG
     (16#005BF#, 16#005BF#),  -- HEBREW POINT RAFE .. HEBREW POINT RAFE
     (16#005C1#, 16#005C2#),  -- HEBREW POINT SHIN DOT .. HEBREW POINT SIN DOT
     (16#005C4#, 16#005C4#),  -- HEBREW MARK UPPER DOT .. HEBREW MARK UPPER DOT
     (16#00610#, 16#00615#),  -- ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM .. ARABIC SMALL HIGH TAH
     (16#0064B#, 16#00658#),  -- ARABIC FATHATAN .. ARABIC MARK NOON GHUNNA
     (16#00670#, 16#00670#),  -- ARABIC LETTER SUPERSCRIPT ALEF .. ARABIC LETTER SUPERSCRIPT ALEF
     (16#006D6#, 16#006DC#),  -- ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA .. ARABIC SMALL HIGH SEEN
     (16#006DF#, 16#006E4#),  -- ARABIC SMALL HIGH ROUNDED ZERO .. ARABIC SMALL HIGH MADDA
     (16#006E7#, 16#006E8#),  -- ARABIC SMALL HIGH YEH .. ARABIC SMALL HIGH NOON
     (16#006EA#, 16#006ED#),  -- ARABIC EMPTY CENTRE LOW STOP .. ARABIC SMALL LOW MEEM
     (16#00711#, 16#00711#),  -- SYRIAC LETTER SUPERSCRIPT ALAPH .. SYRIAC LETTER SUPERSCRIPT ALAPH
     (16#00730#, 16#0074A#),  -- SYRIAC PTHAHA ABOVE .. SYRIAC BARREKH
     (16#007A6#, 16#007B0#),  -- THAANA ABAFILI .. THAANA SUKUN
     (16#00901#, 16#00903#),  -- DEVANAGARI SIGN CANDRABINDU .. DEVANAGARI SIGN VISARGA
     (16#0093C#, 16#0093C#),  -- DEVANAGARI SIGN NUKTA .. DEVANAGARI SIGN NUKTA
     (16#0093E#, 16#0094D#),  -- DEVANAGARI VOWEL SIGN AA .. DEVANAGARI SIGN VIRAMA
     (16#00951#, 16#00954#),  -- DEVANAGARI STRESS SIGN UDATTA .. DEVANAGARI ACUTE ACCENT
     (16#00962#, 16#00963#),  -- DEVANAGARI VOWEL SIGN VOCALIC L .. DEVANAGARI VOWEL SIGN VOCALIC LL
     (16#00981#, 16#00983#),  -- BENGALI SIGN CANDRABINDU .. BENGALI SIGN VISARGA
     (16#009BC#, 16#009BC#),  -- BENGALI SIGN NUKTA .. BENGALI SIGN NUKTA
     (16#009BE#, 16#009C4#),  -- BENGALI VOWEL SIGN AA .. BENGALI VOWEL SIGN VOCALIC RR
     (16#009C7#, 16#009C8#),  -- BENGALI VOWEL SIGN E .. BENGALI VOWEL SIGN AI
     (16#009CB#, 16#009CD#),  -- BENGALI VOWEL SIGN O .. BENGALI SIGN VIRAMA
     (16#009D7#, 16#009D7#),  -- BENGALI AU LENGTH MARK .. BENGALI AU LENGTH MARK
     (16#009E2#, 16#009E3#),  -- BENGALI VOWEL SIGN VOCALIC L .. BENGALI VOWEL SIGN VOCALIC LL
     (16#00A01#, 16#00A03#),  -- GURMUKHI SIGN ADAK BINDI .. GURMUKHI SIGN VISARGA
     (16#00A3C#, 16#00A3C#),  -- GURMUKHI SIGN NUKTA .. GURMUKHI SIGN NUKTA
     (16#00A3E#, 16#00A42#),  -- GURMUKHI VOWEL SIGN AA .. GURMUKHI VOWEL SIGN UU
     (16#00A47#, 16#00A48#),  -- GURMUKHI VOWEL SIGN EE .. GURMUKHI VOWEL SIGN AI
     (16#00A4B#, 16#00A4D#),  -- GURMUKHI VOWEL SIGN OO .. GURMUKHI SIGN VIRAMA
     (16#00A70#, 16#00A71#),  -- GURMUKHI TIPPI .. GURMUKHI ADDAK
     (16#00A81#, 16#00A83#),  -- GUJARATI SIGN CANDRABINDU .. GUJARATI SIGN VISARGA
     (16#00ABC#, 16#00ABC#),  -- GUJARATI SIGN NUKTA .. GUJARATI SIGN NUKTA
     (16#00ABE#, 16#00AC5#),  -- GUJARATI VOWEL SIGN AA .. GUJARATI VOWEL SIGN CANDRA E
     (16#00AC7#, 16#00AC9#),  -- GUJARATI VOWEL SIGN E .. GUJARATI VOWEL SIGN CANDRA O
     (16#00ACB#, 16#00ACD#),  -- GUJARATI VOWEL SIGN O .. GUJARATI SIGN VIRAMA
     (16#00AE2#, 16#00AE3#),  -- GUJARATI VOWEL SIGN VOCALIC L .. GUJARATI VOWEL SIGN VOCALIC LL
     (16#00B01#, 16#00B03#),  -- ORIYA SIGN CANDRABINDU .. ORIYA SIGN VISARGA
     (16#00B3C#, 16#00B3C#),  -- ORIYA SIGN NUKTA .. ORIYA SIGN NUKTA
     (16#00B3E#, 16#00B43#),  -- ORIYA VOWEL SIGN AA .. ORIYA VOWEL SIGN VOCALIC R
     (16#00B47#, 16#00B48#),  -- ORIYA VOWEL SIGN E .. ORIYA VOWEL SIGN AI
     (16#00B4B#, 16#00B4D#),  -- ORIYA VOWEL SIGN O .. ORIYA SIGN VIRAMA
     (16#00B56#, 16#00B57#),  -- ORIYA AI LENGTH MARK .. ORIYA AU LENGTH MARK
     (16#00B82#, 16#00B82#),  -- TAMIL SIGN ANUSVARA .. TAMIL SIGN ANUSVARA
     (16#00BBE#, 16#00BC2#),  -- TAMIL VOWEL SIGN AA .. TAMIL VOWEL SIGN UU
     (16#00BC6#, 16#00BC8#),  -- TAMIL VOWEL SIGN E .. TAMIL VOWEL SIGN AI
     (16#00BCA#, 16#00BCD#),  -- TAMIL VOWEL SIGN O .. TAMIL SIGN VIRAMA
     (16#00BD7#, 16#00BD7#),  -- TAMIL AU LENGTH MARK .. TAMIL AU LENGTH MARK
     (16#00C01#, 16#00C03#),  -- TELUGU SIGN CANDRABINDU .. TELUGU SIGN VISARGA
     (16#00C3E#, 16#00C44#),  -- TELUGU VOWEL SIGN AA .. TELUGU VOWEL SIGN VOCALIC RR
     (16#00C46#, 16#00C48#),  -- TELUGU VOWEL SIGN E .. TELUGU VOWEL SIGN AI
     (16#00C4A#, 16#00C4D#),  -- TELUGU VOWEL SIGN O .. TELUGU SIGN VIRAMA
     (16#00C55#, 16#00C56#),  -- TELUGU LENGTH MARK .. TELUGU AI LENGTH MARK
     (16#00C82#, 16#00C83#),  -- KANNADA SIGN ANUSVARA .. KANNADA SIGN VISARGA
     (16#00CBC#, 16#00CBC#),  -- KANNADA SIGN NUKTA .. KANNADA SIGN NUKTA
     (16#00CBE#, 16#00CC4#),  -- KANNADA VOWEL SIGN AA .. KANNADA VOWEL SIGN VOCALIC RR
     (16#00CC6#, 16#00CC8#),  -- KANNADA VOWEL SIGN E .. KANNADA VOWEL SIGN AI
     (16#00CCA#, 16#00CCD#),  -- KANNADA VOWEL SIGN O .. KANNADA SIGN VIRAMA
     (16#00CD5#, 16#00CD6#),  -- KANNADA LENGTH MARK .. KANNADA AI LENGTH MARK
     (16#00D02#, 16#00D03#),  -- MALAYALAM SIGN ANUSVARA .. MALAYALAM SIGN VISARGA
     (16#00D3E#, 16#00D43#),  -- MALAYALAM VOWEL SIGN AA .. MALAYALAM VOWEL SIGN VOCALIC R
     (16#00D46#, 16#00D48#),  -- MALAYALAM VOWEL SIGN E .. MALAYALAM VOWEL SIGN AI
     (16#00D4A#, 16#00D4D#),  -- MALAYALAM VOWEL SIGN O .. MALAYALAM SIGN VIRAMA
     (16#00D57#, 16#00D57#),  -- MALAYALAM AU LENGTH MARK .. MALAYALAM AU LENGTH MARK
     (16#00D82#, 16#00D83#),  -- SINHALA SIGN ANUSVARAYA .. SINHALA SIGN VISARGAYA
     (16#00DCA#, 16#00DCA#),  -- SINHALA SIGN AL-LAKUNA .. SINHALA SIGN AL-LAKUNA
     (16#00DCF#, 16#00DD4#),  -- SINHALA VOWEL SIGN AELA-PILLA .. SINHALA VOWEL SIGN KETTI PAA-PILLA
     (16#00DD6#, 16#00DD6#),  -- SINHALA VOWEL SIGN DIGA PAA-PILLA .. SINHALA VOWEL SIGN DIGA PAA-PILLA
     (16#00DD8#, 16#00DDF#),  -- SINHALA VOWEL SIGN GAETTA-PILLA .. SINHALA VOWEL SIGN GAYANUKITTA
     (16#00DF2#, 16#00DF3#),  -- SINHALA VOWEL SIGN DIGA GAETTA-PILLA .. SINHALA VOWEL SIGN DIGA GAYANUKITTA
     (16#00E31#, 16#00E31#),  -- THAI CHARACTER MAI HAN-AKAT .. THAI CHARACTER MAI HAN-AKAT
     (16#00E34#, 16#00E3A#),  -- THAI CHARACTER SARA I .. THAI CHARACTER PHINTHU
     (16#00E47#, 16#00E4E#),  -- THAI CHARACTER MAITAIKHU .. THAI CHARACTER YAMAKKAN
     (16#00EB1#, 16#00EB1#),  -- LAO VOWEL SIGN MAI KAN .. LAO VOWEL SIGN MAI KAN
     (16#00EB4#, 16#00EB9#),  -- LAO VOWEL SIGN I .. LAO VOWEL SIGN UU
     (16#00EBB#, 16#00EBC#),  -- LAO VOWEL SIGN MAI KON .. LAO SEMIVOWEL SIGN LO
     (16#00EC8#, 16#00ECD#),  -- LAO TONE MAI EK .. LAO NIGGAHITA
     (16#00F18#, 16#00F19#),  -- TIBETAN ASTROLOGICAL SIGN -KHYUD PA .. TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
     (16#00F35#, 16#00F35#),  -- TIBETAN MARK NGAS BZUNG NYI ZLA .. TIBETAN MARK NGAS BZUNG NYI ZLA
     (16#00F37#, 16#00F37#),  -- TIBETAN MARK NGAS BZUNG SGOR RTAGS .. TIBETAN MARK NGAS BZUNG SGOR RTAGS
     (16#00F39#, 16#00F39#),  -- TIBETAN MARK TSA -PHRU .. TIBETAN MARK TSA -PHRU
     (16#00F3E#, 16#00F3F#),  -- TIBETAN SIGN YAR TSHES .. TIBETAN SIGN MAR TSHES
     (16#00F71#, 16#00F84#),  -- TIBETAN VOWEL SIGN AA .. TIBETAN MARK HALANTA
     (16#00F86#, 16#00F87#),  -- TIBETAN SIGN LCI RTAGS .. TIBETAN SIGN YANG RTAGS
     (16#00F90#, 16#00F97#),  -- TIBETAN SUBJOINED LETTER KA .. TIBETAN SUBJOINED LETTER JA
     (16#00F99#, 16#00FBC#),  -- TIBETAN SUBJOINED LETTER NYA .. TIBETAN SUBJOINED LETTER FIXED-FORM RA
     (16#00FC6#, 16#00FC6#),  -- TIBETAN SYMBOL PADMA GDAN .. TIBETAN SYMBOL PADMA GDAN
     (16#0102C#, 16#01032#),  -- MYANMAR VOWEL SIGN AA .. MYANMAR VOWEL SIGN AI
     (16#01036#, 16#01039#),  -- MYANMAR SIGN ANUSVARA .. MYANMAR SIGN VIRAMA
     (16#01056#, 16#01059#),  -- MYANMAR VOWEL SIGN VOCALIC R .. MYANMAR VOWEL SIGN VOCALIC LL
     (16#01712#, 16#01714#),  -- TAGALOG VOWEL SIGN I .. TAGALOG SIGN VIRAMA
     (16#01732#, 16#01734#),  -- HANUNOO VOWEL SIGN I .. HANUNOO SIGN PAMUDPOD
     (16#01752#, 16#01753#),  -- BUHID VOWEL SIGN I .. BUHID VOWEL SIGN U
     (16#01772#, 16#01773#),  -- TAGBANWA VOWEL SIGN I .. TAGBANWA VOWEL SIGN U
     (16#017B6#, 16#017D3#),  -- KHMER VOWEL SIGN AA .. KHMER SIGN BATHAMASAT
     (16#017DD#, 16#017DD#),  -- KHMER SIGN ATTHACAN .. KHMER SIGN ATTHACAN
     (16#0180B#, 16#0180D#),  -- MONGOLIAN FREE VARIATION SELECTOR ONE .. MONGOLIAN FREE VARIATION SELECTOR THREE
     (16#018A9#, 16#018A9#),  -- MONGOLIAN LETTER ALI GALI DAGALGA .. MONGOLIAN LETTER ALI GALI DAGALGA
     (16#01920#, 16#0192B#),  -- LIMBU VOWEL SIGN A .. LIMBU SUBJOINED LETTER WA
     (16#01930#, 16#0193B#),  -- LIMBU SMALL LETTER KA .. LIMBU SIGN SA-I
     (16#020D0#, 16#020DC#),  -- COMBINING LEFT HARPOON ABOVE .. COMBINING FOUR DOTS ABOVE
     (16#020E1#, 16#020E1#),  -- COMBINING LEFT RIGHT ARROW ABOVE .. COMBINING LEFT RIGHT ARROW ABOVE
     (16#020E5#, 16#020EA#),  -- COMBINING REVERSE SOLIDUS OVERLAY .. COMBINING LEFTWARDS ARROW OVERLAY
     (16#0302A#, 16#0302F#),  -- IDEOGRAPHIC LEVEL TONE MARK .. HANGUL DOUBLE DOT TONE MARK
     (16#03099#, 16#0309A#),  -- COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK .. COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
     (16#0FB1E#, 16#0FB1E#),  -- HEBREW POINT JUDEO-SPANISH VARIKA .. HEBREW POINT JUDEO-SPANISH VARIKA
     (16#0FE00#, 16#0FE0F#),  -- VARIATION SELECTOR-1 .. VARIATION SELECTOR-16
     (16#0FE20#, 16#0FE23#),  -- COMBINING LIGATURE LEFT HALF .. COMBINING DOUBLE TILDE RIGHT HALF
     (16#1D165#, 16#1D169#),  -- MUSICAL SYMBOL COMBINING STEM .. MUSICAL SYMBOL COMBINING TREMOLO-3
     (16#1D16D#, 16#1D172#),  -- MUSICAL SYMBOL COMBINING AUGMENTATION DOT .. MUSICAL SYMBOL COMBINING FLAG-5
     (16#1D17B#, 16#1D182#),  -- MUSICAL SYMBOL COMBINING ACCENT .. MUSICAL SYMBOL COMBINING LOURE
     (16#1D185#, 16#1D18B#),  -- MUSICAL SYMBOL COMBINING DOIT .. MUSICAL SYMBOL COMBINING TRIPLE TONGUE
     (16#1D1AA#, 16#1D1AD#),  -- MUSICAL SYMBOL COMBINING DOWN BOW .. MUSICAL SYMBOL COMBINING SNAP PIZZICATO
     (16#E0100#, 16#E01EF#)); -- VARIATION SELECTOR-17 .. VARIATION SELECTOR-256

   --  The following table includes all characters considered non-graphic,
   --  i.e. all characters from the Unicode table with categories:

   --    Other, Control (Cc)
   --    Other, Private Use (Co)
   --    Other, Surrogate (Cs)
   --    Separator, Line (Zl)
   --    Separator, Paragraph (Zp)

   --  Note that characters with relative positions FFFE and FFFF in their
   --  planes are not included in this table (we really don't want to add
   --  32K entries for this purpose). Instead we handle these positions in
   --  a completely different manner.

   --  Note: unassigned characters (category Cn) are deliberately NOT included
   --  in the set of non-graphics, since the idea is that if any of these are
   --  defined in the future, we don't want to have to modify the standard.

   --  Note that Other, Format (Cf) is also quite deliberately not included
   --  in the list of categories above. This means that these characters can
   --  be included in character and string literals.

   UTF_32_Non_Graphic : constant UTF_32_Ranges := (
     (16#00000#, 16#0001F#),  -- <control> .. <control>
     (16#0007F#, 16#0009F#),  -- <control> .. <control>
     (16#02028#, 16#02029#),  -- LINE SEPARATOR .. PARAGRAPH SEPARATOR
     (16#0D800#, 16#0DB7F#),  -- <Non Private Use High Surrogate, First> .. <Non Private Use High Surrogate, Last>
     (16#0DB80#, 16#0DBFF#),  -- <Private Use High Surrogate, First> .. <Private Use High Surrogate, Last>
     (16#0DC00#, 16#0DFFF#),  -- <Low_Surrogate, First> .. <Low Surrogate, Last>
     (16#0E000#, 16#0F8FF#),  -- <Private Use, First> .. <Private Use, Last>
     (16#F0000#, 16#FFFFD#),  -- <Plane 15 Private Use, First> .. <Plane 15 Private Use, Last>
     (16#100000#, 16#10FFFD#)); -- <Plane 16 Private Use, First> .. <Plane 16 Private Use, Last>

   --  The following two tables define the mapping to upper case. The first
   --  table gives the ranges of lower case letters. The corresponding entry
   --  in Uppercase_Adjust shows the amount to be added to (or subtracted from
   --  if the value is negative) the code value to get the corresponding upper
   --  case letter.
   --
   --  An entry is in this table if its 10646 has the string SMALL LETTER
   --  the name, and there is a corresponding entry which has the string
   --  CAPITAL LETTER in its name.

   Lower_Case_Letters : constant UTF_32_Ranges := (
     (16#00061#, 16#0007A#),  -- LATIN SMALL LETTER A .. LATIN SMALL LETTER Z
     (16#000E0#, 16#000F6#),  -- LATIN SMALL LETTER A WITH GRAVE .. LATIN SMALL LETTER O WITH DIAERESIS
     (16#000F8#, 16#000FE#),  -- LATIN SMALL LETTER O WITH STROKE .. LATIN SMALL LETTER THORN
     (16#000FF#, 16#000FF#),  -- LATIN SMALL LETTER Y WITH DIAERESIS .. LATIN SMALL LETTER Y WITH DIAERESIS
     (16#00101#, 16#00101#),  -- LATIN SMALL LETTER A WITH MACRON .. LATIN SMALL LETTER A WITH MACRON
     (16#00103#, 16#00103#),  -- LATIN SMALL LETTER A WITH BREVE .. LATIN SMALL LETTER A WITH BREVE
     (16#00105#, 16#00105#),  -- LATIN SMALL LETTER A WITH OGONEK .. LATIN SMALL LETTER A WITH OGONEK
     (16#00107#, 16#00107#),  -- LATIN SMALL LETTER C WITH ACUTE .. LATIN SMALL LETTER C WITH ACUTE
     (16#00109#, 16#00109#),  -- LATIN SMALL LETTER C WITH CIRCUMFLEX .. LATIN SMALL LETTER C WITH CIRCUMFLEX
     (16#0010B#, 16#0010B#),  -- LATIN SMALL LETTER C WITH DOT ABOVE .. LATIN SMALL LETTER C WITH DOT ABOVE
     (16#0010D#, 16#0010D#),  -- LATIN SMALL LETTER C WITH CARON .. LATIN SMALL LETTER C WITH CARON
     (16#0010F#, 16#0010F#),  -- LATIN SMALL LETTER D WITH CARON .. LATIN SMALL LETTER D WITH CARON
     (16#00111#, 16#00111#),  -- LATIN SMALL LETTER D WITH STROKE .. LATIN SMALL LETTER D WITH STROKE
     (16#00113#, 16#00113#),  -- LATIN SMALL LETTER E WITH MACRON .. LATIN SMALL LETTER E WITH MACRON
     (16#00115#, 16#00115#),  -- LATIN SMALL LETTER E WITH BREVE .. LATIN SMALL LETTER E WITH BREVE
     (16#00117#, 16#00117#),  -- LATIN SMALL LETTER E WITH DOT ABOVE .. LATIN SMALL LETTER E WITH DOT ABOVE
     (16#00119#, 16#00119#),  -- LATIN SMALL LETTER E WITH OGONEK .. LATIN SMALL LETTER E WITH OGONEK
     (16#0011B#, 16#0011B#),  -- LATIN SMALL LETTER E WITH CARON .. LATIN SMALL LETTER E WITH CARON
     (16#0011D#, 16#0011D#),  -- LATIN SMALL LETTER G WITH CIRCUMFLEX .. LATIN SMALL LETTER G WITH CIRCUMFLEX
     (16#0011F#, 16#0011F#),  -- LATIN SMALL LETTER G WITH BREVE .. LATIN SMALL LETTER G WITH BREVE
     (16#00121#, 16#00121#),  -- LATIN SMALL LETTER G WITH DOT ABOVE .. LATIN SMALL LETTER G WITH DOT ABOVE
     (16#00123#, 16#00123#),  -- LATIN SMALL LETTER G WITH CEDILLA .. LATIN SMALL LETTER G WITH CEDILLA
     (16#00125#, 16#00125#),  -- LATIN SMALL LETTER H WITH CIRCUMFLEX .. LATIN SMALL LETTER H WITH CIRCUMFLEX
     (16#00127#, 16#00127#),  -- LATIN SMALL LETTER H WITH STROKE .. LATIN SMALL LETTER H WITH STROKE
     (16#00129#, 16#00129#),  -- LATIN SMALL LETTER I WITH TILDE .. LATIN SMALL LETTER I WITH TILDE
     (16#0012B#, 16#0012B#),  -- LATIN SMALL LETTER I WITH MACRON .. LATIN SMALL LETTER I WITH MACRON
     (16#0012D#, 16#0012D#),  -- LATIN SMALL LETTER I WITH BREVE .. LATIN SMALL LETTER I WITH BREVE
     (16#0012F#, 16#0012F#),  -- LATIN SMALL LETTER I WITH OGONEK .. LATIN SMALL LETTER I WITH OGONEK
     (16#00133#, 16#00133#),  -- LATIN SMALL LETTER I J .. LATIN SMALL LETTER I J
     (16#00135#, 16#00135#),  -- LATIN SMALL LETTER J WITH CIRCUMFLEX .. LATIN SMALL LETTER J WITH CIRCUMFLEX
     (16#00137#, 16#00137#),  -- LATIN SMALL LETTER K WITH CEDILLA .. LATIN SMALL LETTER K WITH CEDILLA
     (16#0013A#, 16#0013A#),  -- LATIN SMALL LETTER L WITH ACUTE .. LATIN SMALL LETTER L WITH ACUTE
     (16#0013C#, 16#0013C#),  -- LATIN SMALL LETTER L WITH CEDILLA .. LATIN SMALL LETTER L WITH CEDILLA
     (16#0013E#, 16#0013E#),  -- LATIN SMALL LETTER L WITH CARON .. LATIN SMALL LETTER L WITH CARON
     (16#00140#, 16#00140#),  -- LATIN SMALL LETTER L WITH MIDDLE DOT .. LATIN SMALL LETTER L WITH MIDDLE DOT
     (16#00142#, 16#00142#),  -- LATIN SMALL LETTER L WITH STROKE .. LATIN SMALL LETTER L WITH STROKE
     (16#00144#, 16#00144#),  -- LATIN SMALL LETTER N WITH ACUTE .. LATIN SMALL LETTER N WITH ACUTE
     (16#00146#, 16#00146#),  -- LATIN SMALL LETTER N WITH CEDILLA .. LATIN SMALL LETTER N WITH CEDILLA
     (16#00148#, 16#00148#),  -- LATIN SMALL LETTER N WITH CARON .. LATIN SMALL LETTER N WITH CARON
     (16#0014B#, 16#0014B#),  -- LATIN SMALL LETTER ENG .. LATIN SMALL LETTER ENG
     (16#0014D#, 16#0014D#),  -- LATIN SMALL LETTER O WITH MACRON .. LATIN SMALL LETTER O WITH MACRON
     (16#0014F#, 16#0014F#),  -- LATIN SMALL LETTER O WITH BREVE .. LATIN SMALL LETTER O WITH BREVE
     (16#00151#, 16#00151#),  -- LATIN SMALL LETTER O WITH DOUBLE ACUTE .. LATIN SMALL LETTER O WITH DOUBLE ACUTE
     (16#00153#, 16#00153#),  -- LATIN SMALL LETTER O E .. LATIN SMALL LETTER O E
     (16#00155#, 16#00155#),  -- LATIN SMALL LETTER R WITH ACUTE .. LATIN SMALL LETTER R WITH ACUTE
     (16#00157#, 16#00157#),  -- LATIN SMALL LETTER R WITH CEDILLA .. LATIN SMALL LETTER R WITH CEDILLA
     (16#00159#, 16#00159#),  -- LATIN SMALL LETTER R WITH CARON .. LATIN SMALL LETTER R WITH CARON
     (16#0015B#, 16#0015B#),  -- LATIN SMALL LETTER S WITH ACUTE .. LATIN SMALL LETTER S WITH ACUTE
     (16#0015D#, 16#0015D#),  -- LATIN SMALL LETTER S WITH CIRCUMFLEX .. LATIN SMALL LETTER S WITH CIRCUMFLEX
     (16#0015F#, 16#0015F#),  -- LATIN SMALL LETTER S WITH CEDILLA .. LATIN SMALL LETTER S WITH CEDILLA
     (16#00161#, 16#00161#),  -- LATIN SMALL LETTER S WITH CARON .. LATIN SMALL LETTER S WITH CARON
     (16#00163#, 16#00163#),  -- LATIN SMALL LETTER T WITH CEDILLA .. LATIN SMALL LETTER T WITH CEDILLA
     (16#00165#, 16#00165#),  -- LATIN SMALL LETTER T WITH CARON .. LATIN SMALL LETTER T WITH CARON
     (16#00167#, 16#00167#),  -- LATIN SMALL LETTER T WITH STROKE .. LATIN SMALL LETTER T WITH STROKE
     (16#00169#, 16#00169#),  -- LATIN SMALL LETTER U WITH TILDE .. LATIN SMALL LETTER U WITH TILDE
     (16#0016B#, 16#0016B#),  -- LATIN SMALL LETTER U WITH MACRON .. LATIN SMALL LETTER U WITH MACRON
     (16#0016D#, 16#0016D#),  -- LATIN SMALL LETTER U WITH BREVE .. LATIN SMALL LETTER U WITH BREVE
     (16#0016F#, 16#0016F#),  -- LATIN SMALL LETTER U WITH RING ABOVE .. LATIN SMALL LETTER U WITH RING ABOVE
     (16#00171#, 16#00171#),  -- LATIN SMALL LETTER U WITH DOUBLE ACUTE .. LATIN SMALL LETTER U WITH DOUBLE ACUTE
     (16#00173#, 16#00173#),  -- LATIN SMALL LETTER U WITH OGONEK .. LATIN SMALL LETTER U WITH OGONEK
     (16#00175#, 16#00175#),  -- LATIN SMALL LETTER W WITH CIRCUMFLEX .. LATIN SMALL LETTER W WITH CIRCUMFLEX
     (16#00177#, 16#00177#),  -- LATIN SMALL LETTER Y WITH CIRCUMFLEX .. LATIN SMALL LETTER Y WITH CIRCUMFLEX
     (16#0017A#, 16#0017A#),  -- LATIN SMALL LETTER Z WITH ACUTE .. LATIN SMALL LETTER Z WITH ACUTE
     (16#0017C#, 16#0017C#),  -- LATIN SMALL LETTER Z WITH DOT ABOVE .. LATIN SMALL LETTER Z WITH DOT ABOVE
     (16#0017E#, 16#0017E#),  -- LATIN SMALL LETTER Z WITH CARON .. LATIN SMALL LETTER Z WITH CARON
     (16#00183#, 16#00183#),  -- LATIN SMALL LETTER B WITH TOPBAR .. LATIN SMALL LETTER B WITH TOPBAR
     (16#00185#, 16#00185#),  -- LATIN SMALL LETTER TONE SIX .. LATIN SMALL LETTER TONE SIX
     (16#00188#, 16#00188#),  -- LATIN SMALL LETTER C WITH HOOK .. LATIN SMALL LETTER C WITH HOOK
     (16#0018C#, 16#0018C#),  -- LATIN SMALL LETTER D WITH TOPBAR .. LATIN SMALL LETTER D WITH TOPBAR
     (16#00192#, 16#00192#),  -- LATIN SMALL LETTER F WITH HOOK .. LATIN SMALL LETTER F WITH HOOK
     (16#00199#, 16#00199#),  -- LATIN SMALL LETTER K WITH HOOK .. LATIN SMALL LETTER K WITH HOOK
     (16#0019E#, 16#0019E#),  -- LATIN SMALL LETTER N WITH LONG RIGHT LEG .. LATIN SMALL LETTER N WITH LONG RIGHT LEG
     (16#001A1#, 16#001A1#),  -- LATIN SMALL LETTER O WITH HORN .. LATIN SMALL LETTER O WITH HORN
     (16#001A3#, 16#001A3#),  -- LATIN SMALL LETTER OI .. LATIN SMALL LETTER OI
     (16#001A5#, 16#001A5#),  -- LATIN SMALL LETTER P WITH HOOK .. LATIN SMALL LETTER P WITH HOOK
     (16#001A8#, 16#001A8#),  -- LATIN SMALL LETTER TONE TWO .. LATIN SMALL LETTER TONE TWO
     (16#001AD#, 16#001AD#),  -- LATIN SMALL LETTER T WITH HOOK .. LATIN SMALL LETTER T WITH HOOK
     (16#001B0#, 16#001B0#),  -- LATIN SMALL LETTER U WITH HORN .. LATIN SMALL LETTER U WITH HORN
     (16#001B4#, 16#001B4#),  -- LATIN SMALL LETTER Y WITH HOOK .. LATIN SMALL LETTER Y WITH HOOK
     (16#001B6#, 16#001B6#),  -- LATIN SMALL LETTER Z WITH STROKE .. LATIN SMALL LETTER Z WITH STROKE
     (16#001B9#, 16#001B9#),  -- LATIN SMALL LETTER EZH REVERSED .. LATIN SMALL LETTER EZH REVERSED
     (16#001BD#, 16#001BD#),  -- LATIN SMALL LETTER TONE FIVE .. LATIN SMALL LETTER TONE FIVE
     (16#001C6#, 16#001C6#),  -- LATIN SMALL LETTER DZ WITH CARON .. LATIN SMALL LETTER DZ WITH CARON
     (16#001C9#, 16#001C9#),  -- LATIN SMALL LETTER LJ .. LATIN SMALL LETTER LJ
     (16#001CC#, 16#001CC#),  -- LATIN SMALL LETTER NJ .. LATIN SMALL LETTER NJ
     (16#001CE#, 16#001CE#),  -- LATIN SMALL LETTER A WITH CARON .. LATIN SMALL LETTER A WITH CARON
     (16#001D0#, 16#001D0#),  -- LATIN SMALL LETTER I WITH CARON .. LATIN SMALL LETTER I WITH CARON
     (16#001D2#, 16#001D2#),  -- LATIN SMALL LETTER O WITH CARON .. LATIN SMALL LETTER O WITH CARON
     (16#001D4#, 16#001D4#),  -- LATIN SMALL LETTER U WITH CARON .. LATIN SMALL LETTER U WITH CARON
     (16#001D6#, 16#001D6#),  -- LATIN SMALL LETTER U WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
     (16#001D8#, 16#001D8#),  -- LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
     (16#001DA#, 16#001DA#),  -- LATIN SMALL LETTER U WITH DIAERESIS AND CARON .. LATIN SMALL LETTER U WITH DIAERESIS AND CARON
     (16#001DC#, 16#001DC#),  -- LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE .. LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
     (16#001DF#, 16#001DF#),  -- LATIN SMALL LETTER A WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
     (16#001E1#, 16#001E1#),  -- LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
     (16#001E3#, 16#001E3#),  -- LATIN SMALL LETTER AE WITH MACRON .. LATIN SMALL LETTER AE WITH MACRON
     (16#001E5#, 16#001E5#),  -- LATIN SMALL LETTER G WITH STROKE .. LATIN SMALL LETTER G WITH STROKE
     (16#001E7#, 16#001E7#),  -- LATIN SMALL LETTER G WITH CARON .. LATIN SMALL LETTER G WITH CARON
     (16#001E9#, 16#001E9#),  -- LATIN SMALL LETTER K WITH CARON .. LATIN SMALL LETTER K WITH CARON
     (16#001EB#, 16#001EB#),  -- LATIN SMALL LETTER O WITH OGONEK .. LATIN SMALL LETTER O WITH OGONEK
     (16#001ED#, 16#001ED#),  -- LATIN SMALL LETTER O WITH OGONEK AND MACRON .. LATIN SMALL LETTER O WITH OGONEK AND MACRON
     (16#001EF#, 16#001EF#),  -- LATIN SMALL LETTER EZH WITH CARON .. LATIN SMALL LETTER EZH WITH CARON
     (16#001F3#, 16#001F3#),  -- LATIN SMALL LETTER DZ .. LATIN SMALL LETTER DZ
     (16#001F5#, 16#001F5#),  -- LATIN SMALL LETTER G WITH ACUTE .. LATIN SMALL LETTER G WITH ACUTE
     (16#001F9#, 16#001F9#),  -- LATIN SMALL LETTER N WITH GRAVE .. LATIN SMALL LETTER N WITH GRAVE
     (16#001FB#, 16#001FB#),  -- LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE .. LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
     (16#001FD#, 16#001FD#),  -- LATIN SMALL LETTER AE WITH ACUTE .. LATIN SMALL LETTER AE WITH ACUTE
     (16#001FF#, 16#001FF#),  -- LATIN SMALL LETTER O WITH STROKE AND ACUTE .. LATIN SMALL LETTER O WITH STROKE AND ACUTE
     (16#00201#, 16#00201#),  -- LATIN SMALL LETTER A WITH DOUBLE GRAVE .. LATIN SMALL LETTER A WITH DOUBLE GRAVE
     (16#00203#, 16#00203#),  -- LATIN SMALL LETTER A WITH INVERTED BREVE .. LATIN SMALL LETTER A WITH INVERTED BREVE
     (16#00205#, 16#00205#),  -- LATIN SMALL LETTER E WITH DOUBLE GRAVE .. LATIN SMALL LETTER E WITH DOUBLE GRAVE
     (16#00207#, 16#00207#),  -- LATIN SMALL LETTER E WITH INVERTED BREVE .. LATIN SMALL LETTER E WITH INVERTED BREVE
     (16#00209#, 16#00209#),  -- LATIN SMALL LETTER I WITH DOUBLE GRAVE .. LATIN SMALL LETTER I WITH DOUBLE GRAVE
     (16#0020B#, 16#0020B#),  -- LATIN SMALL LETTER I WITH INVERTED BREVE .. LATIN SMALL LETTER I WITH INVERTED BREVE
     (16#0020D#, 16#0020D#),  -- LATIN SMALL LETTER O WITH DOUBLE GRAVE .. LATIN SMALL LETTER O WITH DOUBLE GRAVE
     (16#0020F#, 16#0020F#),  -- LATIN SMALL LETTER O WITH INVERTED BREVE .. LATIN SMALL LETTER O WITH INVERTED BREVE
     (16#00211#, 16#00211#),  -- LATIN SMALL LETTER R WITH DOUBLE GRAVE .. LATIN SMALL LETTER R WITH DOUBLE GRAVE
     (16#00213#, 16#00213#),  -- LATIN SMALL LETTER R WITH INVERTED BREVE .. LATIN SMALL LETTER R WITH INVERTED BREVE
     (16#00215#, 16#00215#),  -- LATIN SMALL LETTER U WITH DOUBLE GRAVE .. LATIN SMALL LETTER U WITH DOUBLE GRAVE
     (16#00217#, 16#00217#),  -- LATIN SMALL LETTER U WITH INVERTED BREVE .. LATIN SMALL LETTER U WITH INVERTED BREVE
     (16#00219#, 16#00219#),  -- LATIN SMALL LETTER S WITH COMMA BELOW .. LATIN SMALL LETTER S WITH COMMA BELOW
     (16#0021B#, 16#0021B#),  -- LATIN SMALL LETTER T WITH COMMA BELOW .. LATIN SMALL LETTER T WITH COMMA BELOW
     (16#0021D#, 16#0021D#),  -- LATIN SMALL LETTER YOGH .. LATIN SMALL LETTER YOGH
     (16#0021F#, 16#0021F#),  -- LATIN SMALL LETTER H WITH CARON .. LATIN SMALL LETTER H WITH CARON
     (16#00223#, 16#00223#),  -- LATIN SMALL LETTER OU .. LATIN SMALL LETTER OU
     (16#00225#, 16#00225#),  -- LATIN SMALL LETTER Z WITH HOOK .. LATIN SMALL LETTER Z WITH HOOK
     (16#00227#, 16#00227#),  -- LATIN SMALL LETTER A WITH DOT ABOVE .. LATIN SMALL LETTER A WITH DOT ABOVE
     (16#00229#, 16#00229#),  -- LATIN SMALL LETTER E WITH CEDILLA .. LATIN SMALL LETTER E WITH CEDILLA
     (16#0022B#, 16#0022B#),  -- LATIN SMALL LETTER O WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
     (16#0022D#, 16#0022D#),  -- LATIN SMALL LETTER O WITH TILDE AND MACRON .. LATIN SMALL LETTER O WITH TILDE AND MACRON
     (16#0022F#, 16#0022F#),  -- LATIN SMALL LETTER O WITH DOT ABOVE .. LATIN SMALL LETTER O WITH DOT ABOVE
     (16#00231#, 16#00231#),  -- LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
     (16#00233#, 16#00233#),  -- LATIN SMALL LETTER Y WITH MACRON .. LATIN SMALL LETTER Y WITH MACRON
     (16#00253#, 16#00253#),  -- LATIN SMALL LETTER B WITH HOOK .. LATIN SMALL LETTER B WITH HOOK
     (16#00254#, 16#00254#),  -- LATIN SMALL LETTER OPEN O .. LATIN SMALL LETTER OPEN O
     (16#00257#, 16#00257#),  -- LATIN SMALL LETTER D WITH HOOK .. LATIN SMALL LETTER D WITH HOOK
     (16#00258#, 16#00259#),  -- LATIN SMALL LETTER REVERSED E .. LATIN SMALL LETTER SCHWA
     (16#0025B#, 16#0025B#),  -- LATIN SMALL LETTER OPEN E .. LATIN SMALL LETTER OPEN E
     (16#00260#, 16#00260#),  -- LATIN SMALL LETTER G WITH HOOK .. LATIN SMALL LETTER G WITH HOOK
     (16#00263#, 16#00263#),  -- LATIN SMALL LETTER GAMMA .. LATIN SMALL LETTER GAMMA
     (16#00268#, 16#00268#),  -- LATIN SMALL LETTER I WITH STROKE .. LATIN SMALL LETTER I WITH STROKE
     (16#00269#, 16#00269#),  -- LATIN SMALL LETTER IOTA .. LATIN SMALL LETTER IOTA
     (16#0026F#, 16#0026F#),  -- LATIN SMALL LETTER TURNED M .. LATIN SMALL LETTER TURNED M
     (16#00272#, 16#00272#),  -- LATIN SMALL LETTER N WITH LEFT HOOK .. LATIN SMALL LETTER N WITH LEFT HOOK
     (16#00283#, 16#00283#),  -- LATIN SMALL LETTER ESH .. LATIN SMALL LETTER ESH
     (16#00288#, 16#00288#),  -- LATIN SMALL LETTER T WITH RETROFLEX HOOK .. LATIN SMALL LETTER T WITH RETROFLEX HOOK
     (16#0028A#, 16#0028B#),  -- LATIN SMALL LETTER UPSILON .. LATIN SMALL LETTER V WITH HOOK
     (16#00292#, 16#00292#),  -- LATIN SMALL LETTER EZH .. LATIN SMALL LETTER EZH
     (16#003AC#, 16#003AC#),  -- GREEK SMALL LETTER ALPHA WITH TONOS .. GREEK SMALL LETTER ALPHA WITH TONOS
     (16#003AD#, 16#003AF#),  -- GREEK SMALL LETTER EPSILON WITH TONOS .. GREEK SMALL LETTER IOTA WITH TONOS
     (16#003B1#, 16#003C1#),  -- GREEK SMALL LETTER ALPHA .. GREEK SMALL LETTER RHO
     (16#003C3#, 16#003CB#),  -- GREEK SMALL LETTER SIGMA .. GREEK SMALL LETTER UPSILON WITH DIALYTIKA
     (16#003CC#, 16#003CC#),  -- GREEK SMALL LETTER OMICRON WITH TONOS .. GREEK SMALL LETTER OMICRON WITH TONOS
     (16#003CD#, 16#003CE#),  -- GREEK SMALL LETTER UPSILON WITH TONOS .. GREEK SMALL LETTER OMEGA WITH TONOS
     (16#003DB#, 16#003DB#),  -- GREEK SMALL LETTER STIGMA .. GREEK SMALL LETTER STIGMA
     (16#003DD#, 16#003DD#),  -- GREEK SMALL LETTER DIGAMMA .. GREEK SMALL LETTER DIGAMMA
     (16#003DF#, 16#003DF#),  -- GREEK SMALL LETTER KOPPA .. GREEK SMALL LETTER KOPPA
     (16#003E1#, 16#003E1#),  -- GREEK SMALL LETTER SAMPI .. GREEK SMALL LETTER SAMPI
     (16#003E3#, 16#003E3#),  -- COPTIC SMALL LETTER SHEI .. COPTIC SMALL LETTER SHEI
     (16#003E5#, 16#003E5#),  -- COPTIC SMALL LETTER FEI .. COPTIC SMALL LETTER FEI
     (16#003E7#, 16#003E7#),  -- COPTIC SMALL LETTER KHEI .. COPTIC SMALL LETTER KHEI
     (16#003E9#, 16#003E9#),  -- COPTIC SMALL LETTER HORI .. COPTIC SMALL LETTER HORI
     (16#003EB#, 16#003EB#),  -- COPTIC SMALL LETTER GANGIA .. COPTIC SMALL LETTER GANGIA
     (16#003ED#, 16#003ED#),  -- COPTIC SMALL LETTER SHIMA .. COPTIC SMALL LETTER SHIMA
     (16#003EF#, 16#003EF#),  -- COPTIC SMALL LETTER DEI .. COPTIC SMALL LETTER DEI
     (16#003F8#, 16#003F8#),  -- GREEK SMALL LETTER SHO .. GREEK SMALL LETTER SHO
     (16#003FB#, 16#003FB#),  -- GREEK SMALL LETTER SAN .. GREEK SMALL LETTER SAN
     (16#00430#, 16#0044F#),  -- CYRILLIC SMALL LETTER A .. CYRILLIC SMALL LETTER YA
     (16#00450#, 16#0045F#),  -- CYRILLIC SMALL LETTER IE WITH GRAVE .. CYRILLIC SMALL LETTER DZHE
     (16#00461#, 16#00461#),  -- CYRILLIC SMALL LETTER OMEGA .. CYRILLIC SMALL LETTER OMEGA
     (16#00463#, 16#00463#),  -- CYRILLIC SMALL LETTER YAT .. CYRILLIC SMALL LETTER YAT
     (16#00465#, 16#00465#),  -- CYRILLIC SMALL LETTER IOTIFIED E .. CYRILLIC SMALL LETTER IOTIFIED E
     (16#00467#, 16#00467#),  -- CYRILLIC SMALL LETTER LITTLE YUS .. CYRILLIC SMALL LETTER LITTLE YUS
     (16#00469#, 16#00469#),  -- CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS .. CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
     (16#0046B#, 16#0046B#),  -- CYRILLIC SMALL LETTER BIG YUS .. CYRILLIC SMALL LETTER BIG YUS
     (16#0046D#, 16#0046D#),  -- CYRILLIC SMALL LETTER IOTIFIED BIG YUS .. CYRILLIC SMALL LETTER IOTIFIED BIG YUS
     (16#0046F#, 16#0046F#),  -- CYRILLIC SMALL LETTER KSI .. CYRILLIC SMALL LETTER KSI
     (16#00471#, 16#00471#),  -- CYRILLIC SMALL LETTER PSI .. CYRILLIC SMALL LETTER PSI
     (16#00473#, 16#00473#),  -- CYRILLIC SMALL LETTER FITA .. CYRILLIC SMALL LETTER FITA
     (16#00475#, 16#00475#),  -- CYRILLIC SMALL LETTER IZHITSA .. CYRILLIC SMALL LETTER IZHITSA
     (16#00477#, 16#00477#),  -- CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
     (16#00479#, 16#00479#),  -- CYRILLIC SMALL LETTER UK .. CYRILLIC SMALL LETTER UK
     (16#0047B#, 16#0047B#),  -- CYRILLIC SMALL LETTER ROUND OMEGA .. CYRILLIC SMALL LETTER ROUND OMEGA
     (16#0047D#, 16#0047D#),  -- CYRILLIC SMALL LETTER OMEGA WITH TITLO .. CYRILLIC SMALL LETTER OMEGA WITH TITLO
     (16#0047F#, 16#0047F#),  -- CYRILLIC SMALL LETTER OT .. CYRILLIC SMALL LETTER OT
     (16#00481#, 16#00481#),  -- CYRILLIC SMALL LETTER KOPPA .. CYRILLIC SMALL LETTER KOPPA
     (16#0048B#, 16#0048B#),  -- CYRILLIC SMALL LETTER SHORT I WITH TAIL .. CYRILLIC SMALL LETTER SHORT I WITH TAIL
     (16#0048D#, 16#0048D#),  -- CYRILLIC SMALL LETTER SEMISOFT SIGN .. CYRILLIC SMALL LETTER SEMISOFT SIGN
     (16#0048F#, 16#0048F#),  -- CYRILLIC SMALL LETTER ER WITH TICK .. CYRILLIC SMALL LETTER ER WITH TICK
     (16#00491#, 16#00491#),  -- CYRILLIC SMALL LETTER GHE WITH UPTURN .. CYRILLIC SMALL LETTER GHE WITH UPTURN
     (16#00493#, 16#00493#),  -- CYRILLIC SMALL LETTER GHE WITH STROKE .. CYRILLIC SMALL LETTER GHE WITH STROKE
     (16#00495#, 16#00495#),  -- CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
     (16#00497#, 16#00497#),  -- CYRILLIC SMALL LETTER ZHE WITH DESCENDER .. CYRILLIC SMALL LETTER ZHE WITH DESCENDER
     (16#00499#, 16#00499#),  -- CYRILLIC SMALL LETTER ZE WITH DESCENDER .. CYRILLIC SMALL LETTER ZE WITH DESCENDER
     (16#0049B#, 16#0049B#),  -- CYRILLIC SMALL LETTER KA WITH DESCENDER .. CYRILLIC SMALL LETTER KA WITH DESCENDER
     (16#0049D#, 16#0049D#),  -- CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
     (16#0049F#, 16#0049F#),  -- CYRILLIC SMALL LETTER KA WITH STROKE .. CYRILLIC SMALL LETTER KA WITH STROKE
     (16#004A1#, 16#004A1#),  -- CYRILLIC SMALL LETTER BASHKIR KA .. CYRILLIC SMALL LETTER BASHKIR KA
     (16#004A3#, 16#004A3#),  -- CYRILLIC SMALL LETTER EN WITH DESCENDER .. CYRILLIC SMALL LETTER EN WITH DESCENDER
     (16#004A5#, 16#004A5#),  -- CYRILLIC SMALL LETTER EN GE .. CYRILLIC SMALL LETTER EN GE
     (16#004A7#, 16#004A7#),  -- CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
     (16#004A9#, 16#004A9#),  -- CYRILLIC SMALL LETTER ABKHASIAN HA .. CYRILLIC SMALL LETTER ABKHASIAN HA
     (16#004AB#, 16#004AB#),  -- CYRILLIC SMALL LETTER ES WITH DESCENDER .. CYRILLIC SMALL LETTER ES WITH DESCENDER
     (16#004AD#, 16#004AD#),  -- CYRILLIC SMALL LETTER TE WITH DESCENDER .. CYRILLIC SMALL LETTER TE WITH DESCENDER
     (16#004AF#, 16#004AF#),  -- CYRILLIC SMALL LETTER STRAIGHT U .. CYRILLIC SMALL LETTER STRAIGHT U
     (16#004B1#, 16#004B1#),  -- CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE .. CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
     (16#004B3#, 16#004B3#),  -- CYRILLIC SMALL LETTER HA WITH DESCENDER .. CYRILLIC SMALL LETTER HA WITH DESCENDER
     (16#004B5#, 16#004B5#),  -- CYRILLIC SMALL LETTER TE TSE .. CYRILLIC SMALL LETTER TE TSE
     (16#004B7#, 16#004B7#),  -- CYRILLIC SMALL LETTER CHE WITH DESCENDER .. CYRILLIC SMALL LETTER CHE WITH DESCENDER
     (16#004B9#, 16#004B9#),  -- CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
     (16#004BB#, 16#004BB#),  -- CYRILLIC SMALL LETTER SHHA .. CYRILLIC SMALL LETTER SHHA
     (16#004BD#, 16#004BD#),  -- CYRILLIC SMALL LETTER ABKHASIAN CHE .. CYRILLIC SMALL LETTER ABKHASIAN CHE
     (16#004BF#, 16#004BF#),  -- CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
     (16#004C2#, 16#004C2#),  -- CYRILLIC SMALL LETTER ZHE WITH BREVE .. CYRILLIC SMALL LETTER ZHE WITH BREVE
     (16#004C4#, 16#004C4#),  -- CYRILLIC SMALL LETTER KA WITH HOOK .. CYRILLIC SMALL LETTER KA WITH HOOK
     (16#004C6#, 16#004C6#),  -- CYRILLIC SMALL LETTER EL WITH TAIL .. CYRILLIC SMALL LETTER EL WITH TAIL
     (16#004C8#, 16#004C8#),  -- CYRILLIC SMALL LETTER EN WITH HOOK .. CYRILLIC SMALL LETTER EN WITH HOOK
     (16#004CA#, 16#004CA#),  -- CYRILLIC SMALL LETTER EN WITH TAIL .. CYRILLIC SMALL LETTER EN WITH TAIL
     (16#004CC#, 16#004CC#),  -- CYRILLIC SMALL LETTER KHAKASSIAN CHE .. CYRILLIC SMALL LETTER KHAKASSIAN CHE
     (16#004CE#, 16#004CE#),  -- CYRILLIC SMALL LETTER EM WITH TAIL .. CYRILLIC SMALL LETTER EM WITH TAIL
     (16#004D1#, 16#004D1#),  -- CYRILLIC SMALL LETTER A WITH BREVE .. CYRILLIC SMALL LETTER A WITH BREVE
     (16#004D3#, 16#004D3#),  -- CYRILLIC SMALL LETTER A WITH DIAERESIS .. CYRILLIC SMALL LETTER A WITH DIAERESIS
     (16#004D7#, 16#004D7#),  -- CYRILLIC SMALL LETTER IE WITH BREVE .. CYRILLIC SMALL LETTER IE WITH BREVE
     (16#004D9#, 16#004D9#),  -- CYRILLIC SMALL LETTER SCHWA .. CYRILLIC SMALL LETTER SCHWA
     (16#004DB#, 16#004DB#),  -- CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS .. CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
     (16#004DD#, 16#004DD#),  -- CYRILLIC SMALL LETTER ZHE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
     (16#004DF#, 16#004DF#),  -- CYRILLIC SMALL LETTER ZE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZE WITH DIAERESIS
     (16#004E1#, 16#004E1#),  -- CYRILLIC SMALL LETTER ABKHASIAN DZE .. CYRILLIC SMALL LETTER ABKHASIAN DZE
     (16#004E3#, 16#004E3#),  -- CYRILLIC SMALL LETTER I WITH MACRON .. CYRILLIC SMALL LETTER I WITH MACRON
     (16#004E5#, 16#004E5#),  -- CYRILLIC SMALL LETTER I WITH DIAERESIS .. CYRILLIC SMALL LETTER I WITH DIAERESIS
     (16#004E7#, 16#004E7#),  -- CYRILLIC SMALL LETTER O WITH DIAERESIS .. CYRILLIC SMALL LETTER O WITH DIAERESIS
     (16#004E9#, 16#004E9#),  -- CYRILLIC SMALL LETTER BARRED O .. CYRILLIC SMALL LETTER BARRED O
     (16#004EB#, 16#004EB#),  -- CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS .. CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
     (16#004ED#, 16#004ED#),  -- CYRILLIC SMALL LETTER E WITH DIAERESIS .. CYRILLIC SMALL LETTER E WITH DIAERESIS
     (16#004EF#, 16#004EF#),  -- CYRILLIC SMALL LETTER U WITH MACRON .. CYRILLIC SMALL LETTER U WITH MACRON
     (16#004F1#, 16#004F1#),  -- CYRILLIC SMALL LETTER U WITH DIAERESIS .. CYRILLIC SMALL LETTER U WITH DIAERESIS
     (16#004F3#, 16#004F3#),  -- CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE .. CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
     (16#004F5#, 16#004F5#),  -- CYRILLIC SMALL LETTER CHE WITH DIAERESIS .. CYRILLIC SMALL LETTER CHE WITH DIAERESIS
     (16#004F9#, 16#004F9#),  -- CYRILLIC SMALL LETTER YERU WITH DIAERESIS .. CYRILLIC SMALL LETTER YERU WITH DIAERESIS
     (16#00501#, 16#00501#),  -- CYRILLIC SMALL LETTER KOMI DE .. CYRILLIC SMALL LETTER KOMI DE
     (16#00503#, 16#00503#),  -- CYRILLIC SMALL LETTER KOMI DJE .. CYRILLIC SMALL LETTER KOMI DJE
     (16#00505#, 16#00505#),  -- CYRILLIC SMALL LETTER KOMI ZJE .. CYRILLIC SMALL LETTER KOMI ZJE
     (16#00507#, 16#00507#),  -- CYRILLIC SMALL LETTER KOMI DZJE .. CYRILLIC SMALL LETTER KOMI DZJE
     (16#00509#, 16#00509#),  -- CYRILLIC SMALL LETTER KOMI LJE .. CYRILLIC SMALL LETTER KOMI LJE
     (16#0050B#, 16#0050B#),  -- CYRILLIC SMALL LETTER KOMI NJE .. CYRILLIC SMALL LETTER KOMI NJE
     (16#0050D#, 16#0050D#),  -- CYRILLIC SMALL LETTER KOMI SJE .. CYRILLIC SMALL LETTER KOMI SJE
     (16#0050F#, 16#0050F#),  -- CYRILLIC SMALL LETTER KOMI TJE .. CYRILLIC SMALL LETTER KOMI TJE
     (16#00561#, 16#00586#),  -- ARMENIAN SMALL LETTER AYB .. ARMENIAN SMALL LETTER FEH
     (16#010D0#, 16#010F5#),  -- GEORGIAN SMALL LETTER AN .. GEORGIAN SMALL LETTER HOE
     (16#01E01#, 16#01E01#),  -- LATIN SMALL LETTER A WITH RING BELOW .. LATIN SMALL LETTER A WITH RING BELOW
     (16#01E03#, 16#01E03#),  -- LATIN SMALL LETTER B WITH DOT ABOVE .. LATIN SMALL LETTER B WITH DOT ABOVE
     (16#01E05#, 16#01E05#),  -- LATIN SMALL LETTER B WITH DOT BELOW .. LATIN SMALL LETTER B WITH DOT BELOW
     (16#01E07#, 16#01E07#),  -- LATIN SMALL LETTER B WITH LINE BELOW .. LATIN SMALL LETTER B WITH LINE BELOW
     (16#01E09#, 16#01E09#),  -- LATIN SMALL LETTER C WITH CEDILLA AND ACUTE .. LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
     (16#01E0B#, 16#01E0B#),  -- LATIN SMALL LETTER D WITH DOT ABOVE .. LATIN SMALL LETTER D WITH DOT ABOVE
     (16#01E0D#, 16#01E0D#),  -- LATIN SMALL LETTER D WITH DOT BELOW .. LATIN SMALL LETTER D WITH DOT BELOW
     (16#01E0F#, 16#01E0F#),  -- LATIN SMALL LETTER D WITH LINE BELOW .. LATIN SMALL LETTER D WITH LINE BELOW
     (16#01E11#, 16#01E11#),  -- LATIN SMALL LETTER D WITH CEDILLA .. LATIN SMALL LETTER D WITH CEDILLA
     (16#01E13#, 16#01E13#),  -- LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
     (16#01E15#, 16#01E15#),  -- LATIN SMALL LETTER E WITH MACRON AND GRAVE .. LATIN SMALL LETTER E WITH MACRON AND GRAVE
     (16#01E17#, 16#01E17#),  -- LATIN SMALL LETTER E WITH MACRON AND ACUTE .. LATIN SMALL LETTER E WITH MACRON AND ACUTE
     (16#01E19#, 16#01E19#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
     (16#01E1B#, 16#01E1B#),  -- LATIN SMALL LETTER E WITH TILDE BELOW .. LATIN SMALL LETTER E WITH TILDE BELOW
     (16#01E1D#, 16#01E1D#),  -- LATIN SMALL LETTER E WITH CEDILLA AND BREVE .. LATIN SMALL LETTER E WITH CEDILLA AND BREVE
     (16#01E1F#, 16#01E1F#),  -- LATIN SMALL LETTER F WITH DOT ABOVE .. LATIN SMALL LETTER F WITH DOT ABOVE
     (16#01E21#, 16#01E21#),  -- LATIN SMALL LETTER G WITH MACRON .. LATIN SMALL LETTER G WITH MACRON
     (16#01E23#, 16#01E23#),  -- LATIN SMALL LETTER H WITH DOT ABOVE .. LATIN SMALL LETTER H WITH DOT ABOVE
     (16#01E25#, 16#01E25#),  -- LATIN SMALL LETTER H WITH DOT BELOW .. LATIN SMALL LETTER H WITH DOT BELOW
     (16#01E27#, 16#01E27#),  -- LATIN SMALL LETTER H WITH DIAERESIS .. LATIN SMALL LETTER H WITH DIAERESIS
     (16#01E29#, 16#01E29#),  -- LATIN SMALL LETTER H WITH CEDILLA .. LATIN SMALL LETTER H WITH CEDILLA
     (16#01E2B#, 16#01E2B#),  -- LATIN SMALL LETTER H WITH BREVE BELOW .. LATIN SMALL LETTER H WITH BREVE BELOW
     (16#01E2D#, 16#01E2D#),  -- LATIN SMALL LETTER I WITH TILDE BELOW .. LATIN SMALL LETTER I WITH TILDE BELOW
     (16#01E2F#, 16#01E2F#),  -- LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
     (16#01E31#, 16#01E31#),  -- LATIN SMALL LETTER K WITH ACUTE .. LATIN SMALL LETTER K WITH ACUTE
     (16#01E33#, 16#01E33#),  -- LATIN SMALL LETTER K WITH DOT BELOW .. LATIN SMALL LETTER K WITH DOT BELOW
     (16#01E35#, 16#01E35#),  -- LATIN SMALL LETTER K WITH LINE BELOW .. LATIN SMALL LETTER K WITH LINE BELOW
     (16#01E37#, 16#01E37#),  -- LATIN SMALL LETTER L WITH DOT BELOW .. LATIN SMALL LETTER L WITH DOT BELOW
     (16#01E39#, 16#01E39#),  -- LATIN SMALL LETTER L WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
     (16#01E3B#, 16#01E3B#),  -- LATIN SMALL LETTER L WITH LINE BELOW .. LATIN SMALL LETTER L WITH LINE BELOW
     (16#01E3D#, 16#01E3D#),  -- LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
     (16#01E3F#, 16#01E3F#),  -- LATIN SMALL LETTER M WITH ACUTE .. LATIN SMALL LETTER M WITH ACUTE
     (16#01E41#, 16#01E41#),  -- LATIN SMALL LETTER M WITH DOT ABOVE .. LATIN SMALL LETTER M WITH DOT ABOVE
     (16#01E43#, 16#01E43#),  -- LATIN SMALL LETTER M WITH DOT BELOW .. LATIN SMALL LETTER M WITH DOT BELOW
     (16#01E45#, 16#01E45#),  -- LATIN SMALL LETTER N WITH DOT ABOVE .. LATIN SMALL LETTER N WITH DOT ABOVE
     (16#01E47#, 16#01E47#),  -- LATIN SMALL LETTER N WITH DOT BELOW .. LATIN SMALL LETTER N WITH DOT BELOW
     (16#01E49#, 16#01E49#),  -- LATIN SMALL LETTER N WITH LINE BELOW .. LATIN SMALL LETTER N WITH LINE BELOW
     (16#01E4B#, 16#01E4B#),  -- LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
     (16#01E4D#, 16#01E4D#),  -- LATIN SMALL LETTER O WITH TILDE AND ACUTE .. LATIN SMALL LETTER O WITH TILDE AND ACUTE
     (16#01E4F#, 16#01E4F#),  -- LATIN SMALL LETTER O WITH TILDE AND DIAERESIS .. LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
     (16#01E51#, 16#01E51#),  -- LATIN SMALL LETTER O WITH MACRON AND GRAVE .. LATIN SMALL LETTER O WITH MACRON AND GRAVE
     (16#01E53#, 16#01E53#),  -- LATIN SMALL LETTER O WITH MACRON AND ACUTE .. LATIN SMALL LETTER O WITH MACRON AND ACUTE
     (16#01E55#, 16#01E55#),  -- LATIN SMALL LETTER P WITH ACUTE .. LATIN SMALL LETTER P WITH ACUTE
     (16#01E57#, 16#01E57#),  -- LATIN SMALL LETTER P WITH DOT ABOVE .. LATIN SMALL LETTER P WITH DOT ABOVE
     (16#01E59#, 16#01E59#),  -- LATIN SMALL LETTER R WITH DOT ABOVE .. LATIN SMALL LETTER R WITH DOT ABOVE
     (16#01E5B#, 16#01E5B#),  -- LATIN SMALL LETTER R WITH DOT BELOW .. LATIN SMALL LETTER R WITH DOT BELOW
     (16#01E5D#, 16#01E5D#),  -- LATIN SMALL LETTER R WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
     (16#01E5F#, 16#01E5F#),  -- LATIN SMALL LETTER R WITH LINE BELOW .. LATIN SMALL LETTER R WITH LINE BELOW
     (16#01E61#, 16#01E61#),  -- LATIN SMALL LETTER S WITH DOT ABOVE .. LATIN SMALL LETTER S WITH DOT ABOVE
     (16#01E63#, 16#01E63#),  -- LATIN SMALL LETTER S WITH DOT BELOW .. LATIN SMALL LETTER S WITH DOT BELOW
     (16#01E65#, 16#01E65#),  -- LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
     (16#01E67#, 16#01E67#),  -- LATIN SMALL LETTER S WITH CARON AND DOT ABOVE .. LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
     (16#01E69#, 16#01E69#),  -- LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
     (16#01E6B#, 16#01E6B#),  -- LATIN SMALL LETTER T WITH DOT ABOVE .. LATIN SMALL LETTER T WITH DOT ABOVE
     (16#01E6D#, 16#01E6D#),  -- LATIN SMALL LETTER T WITH DOT BELOW .. LATIN SMALL LETTER T WITH DOT BELOW
     (16#01E6F#, 16#01E6F#),  -- LATIN SMALL LETTER T WITH LINE BELOW .. LATIN SMALL LETTER T WITH LINE BELOW
     (16#01E71#, 16#01E71#),  -- LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
     (16#01E73#, 16#01E73#),  -- LATIN SMALL LETTER U WITH DIAERESIS BELOW .. LATIN SMALL LETTER U WITH DIAERESIS BELOW
     (16#01E75#, 16#01E75#),  -- LATIN SMALL LETTER U WITH TILDE BELOW .. LATIN SMALL LETTER U WITH TILDE BELOW
     (16#01E77#, 16#01E77#),  -- LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
     (16#01E79#, 16#01E79#),  -- LATIN SMALL LETTER U WITH TILDE AND ACUTE .. LATIN SMALL LETTER U WITH TILDE AND ACUTE
     (16#01E7B#, 16#01E7B#),  -- LATIN SMALL LETTER U WITH MACRON AND DIAERESIS .. LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
     (16#01E7D#, 16#01E7D#),  -- LATIN SMALL LETTER V WITH TILDE .. LATIN SMALL LETTER V WITH TILDE
     (16#01E7F#, 16#01E7F#),  -- LATIN SMALL LETTER V WITH DOT BELOW .. LATIN SMALL LETTER V WITH DOT BELOW
     (16#01E81#, 16#01E81#),  -- LATIN SMALL LETTER W WITH GRAVE .. LATIN SMALL LETTER W WITH GRAVE
     (16#01E83#, 16#01E83#),  -- LATIN SMALL LETTER W WITH ACUTE .. LATIN SMALL LETTER W WITH ACUTE
     (16#01E85#, 16#01E85#),  -- LATIN SMALL LETTER W WITH DIAERESIS .. LATIN SMALL LETTER W WITH DIAERESIS
     (16#01E87#, 16#01E87#),  -- LATIN SMALL LETTER W WITH DOT ABOVE .. LATIN SMALL LETTER W WITH DOT ABOVE
     (16#01E89#, 16#01E89#),  -- LATIN SMALL LETTER W WITH DOT BELOW .. LATIN SMALL LETTER W WITH DOT BELOW
     (16#01E8B#, 16#01E8B#),  -- LATIN SMALL LETTER X WITH DOT ABOVE .. LATIN SMALL LETTER X WITH DOT ABOVE
     (16#01E8D#, 16#01E8D#),  -- LATIN SMALL LETTER X WITH DIAERESIS .. LATIN SMALL LETTER X WITH DIAERESIS
     (16#01E8F#, 16#01E8F#),  -- LATIN SMALL LETTER Y WITH DOT ABOVE .. LATIN SMALL LETTER Y WITH DOT ABOVE
     (16#01E91#, 16#01E91#),  -- LATIN SMALL LETTER Z WITH CIRCUMFLEX .. LATIN SMALL LETTER Z WITH CIRCUMFLEX
     (16#01E93#, 16#01E93#),  -- LATIN SMALL LETTER Z WITH DOT BELOW .. LATIN SMALL LETTER Z WITH DOT BELOW
     (16#01E95#, 16#01E95#),  -- LATIN SMALL LETTER Z WITH LINE BELOW .. LATIN SMALL LETTER Z WITH LINE BELOW
     (16#01EA1#, 16#01EA1#),  -- LATIN SMALL LETTER A WITH DOT BELOW .. LATIN SMALL LETTER A WITH DOT BELOW
     (16#01EA3#, 16#01EA3#),  -- LATIN SMALL LETTER A WITH HOOK ABOVE .. LATIN SMALL LETTER A WITH HOOK ABOVE
     (16#01EA5#, 16#01EA5#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
     (16#01EA7#, 16#01EA7#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
     (16#01EA9#, 16#01EA9#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EAB#, 16#01EAB#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
     (16#01EAD#, 16#01EAD#),  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     (16#01EAF#, 16#01EAF#),  -- LATIN SMALL LETTER A WITH BREVE AND ACUTE .. LATIN SMALL LETTER A WITH BREVE AND ACUTE
     (16#01EB1#, 16#01EB1#),  -- LATIN SMALL LETTER A WITH BREVE AND GRAVE .. LATIN SMALL LETTER A WITH BREVE AND GRAVE
     (16#01EB3#, 16#01EB3#),  -- LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
     (16#01EB5#, 16#01EB5#),  -- LATIN SMALL LETTER A WITH BREVE AND TILDE .. LATIN SMALL LETTER A WITH BREVE AND TILDE
     (16#01EB7#, 16#01EB7#),  -- LATIN SMALL LETTER A WITH BREVE AND DOT BELOW .. LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
     (16#01EB9#, 16#01EB9#),  -- LATIN SMALL LETTER E WITH DOT BELOW .. LATIN SMALL LETTER E WITH DOT BELOW
     (16#01EBB#, 16#01EBB#),  -- LATIN SMALL LETTER E WITH HOOK ABOVE .. LATIN SMALL LETTER E WITH HOOK ABOVE
     (16#01EBD#, 16#01EBD#),  -- LATIN SMALL LETTER E WITH TILDE .. LATIN SMALL LETTER E WITH TILDE
     (16#01EBF#, 16#01EBF#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
     (16#01EC1#, 16#01EC1#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
     (16#01EC3#, 16#01EC3#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EC5#, 16#01EC5#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
     (16#01EC7#, 16#01EC7#),  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     (16#01EC9#, 16#01EC9#),  -- LATIN SMALL LETTER I WITH HOOK ABOVE .. LATIN SMALL LETTER I WITH HOOK ABOVE
     (16#01ECB#, 16#01ECB#),  -- LATIN SMALL LETTER I WITH DOT BELOW .. LATIN SMALL LETTER I WITH DOT BELOW
     (16#01ECD#, 16#01ECD#),  -- LATIN SMALL LETTER O WITH DOT BELOW .. LATIN SMALL LETTER O WITH DOT BELOW
     (16#01ECF#, 16#01ECF#),  -- LATIN SMALL LETTER O WITH HOOK ABOVE .. LATIN SMALL LETTER O WITH HOOK ABOVE
     (16#01ED1#, 16#01ED1#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
     (16#01ED3#, 16#01ED3#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
     (16#01ED5#, 16#01ED5#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01ED7#, 16#01ED7#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
     (16#01ED9#, 16#01ED9#),  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     (16#01EDB#, 16#01EDB#),  -- LATIN SMALL LETTER O WITH HORN AND ACUTE .. LATIN SMALL LETTER O WITH HORN AND ACUTE
     (16#01EDD#, 16#01EDD#),  -- LATIN SMALL LETTER O WITH HORN AND GRAVE .. LATIN SMALL LETTER O WITH HORN AND GRAVE
     (16#01EDF#, 16#01EDF#),  -- LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
     (16#01EE1#, 16#01EE1#),  -- LATIN SMALL LETTER O WITH HORN AND TILDE .. LATIN SMALL LETTER O WITH HORN AND TILDE
     (16#01EE3#, 16#01EE3#),  -- LATIN SMALL LETTER O WITH HORN AND DOT BELOW .. LATIN SMALL LETTER O WITH HORN AND DOT BELOW
     (16#01EE5#, 16#01EE5#),  -- LATIN SMALL LETTER U WITH DOT BELOW .. LATIN SMALL LETTER U WITH DOT BELOW
     (16#01EE7#, 16#01EE7#),  -- LATIN SMALL LETTER U WITH HOOK ABOVE .. LATIN SMALL LETTER U WITH HOOK ABOVE
     (16#01EE9#, 16#01EE9#),  -- LATIN SMALL LETTER U WITH HORN AND ACUTE .. LATIN SMALL LETTER U WITH HORN AND ACUTE
     (16#01EEB#, 16#01EEB#),  -- LATIN SMALL LETTER U WITH HORN AND GRAVE .. LATIN SMALL LETTER U WITH HORN AND GRAVE
     (16#01EED#, 16#01EED#),  -- LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
     (16#01EEF#, 16#01EEF#),  -- LATIN SMALL LETTER U WITH HORN AND TILDE .. LATIN SMALL LETTER U WITH HORN AND TILDE
     (16#01EF1#, 16#01EF1#),  -- LATIN SMALL LETTER U WITH HORN AND DOT BELOW .. LATIN SMALL LETTER U WITH HORN AND DOT BELOW
     (16#01EF3#, 16#01EF3#),  -- LATIN SMALL LETTER Y WITH GRAVE .. LATIN SMALL LETTER Y WITH GRAVE
     (16#01EF5#, 16#01EF5#),  -- LATIN SMALL LETTER Y WITH DOT BELOW .. LATIN SMALL LETTER Y WITH DOT BELOW
     (16#01EF7#, 16#01EF7#),  -- LATIN SMALL LETTER Y WITH HOOK ABOVE .. LATIN SMALL LETTER Y WITH HOOK ABOVE
     (16#01EF9#, 16#01EF9#),  -- LATIN SMALL LETTER Y WITH TILDE .. LATIN SMALL LETTER Y WITH TILDE
     (16#01F00#, 16#01F07#),  -- GREEK SMALL LETTER ALPHA WITH PSILI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
     (16#01F10#, 16#01F15#),  -- GREEK SMALL LETTER EPSILON WITH PSILI .. GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F20#, 16#01F27#),  -- GREEK SMALL LETTER ETA WITH PSILI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
     (16#01F30#, 16#01F37#),  -- GREEK SMALL LETTER IOTA WITH PSILI .. GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
     (16#01F40#, 16#01F45#),  -- GREEK SMALL LETTER OMICRON WITH PSILI .. GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F51#, 16#01F51#),  -- GREEK SMALL LETTER UPSILON WITH DASIA .. GREEK SMALL LETTER UPSILON WITH DASIA
     (16#01F53#, 16#01F53#),  -- GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA .. GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
     (16#01F55#, 16#01F55#),  -- GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA .. GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
     (16#01F57#, 16#01F57#),  -- GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
     (16#01F60#, 16#01F67#),  -- GREEK SMALL LETTER OMEGA WITH PSILI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
     (16#01F70#, 16#01F71#),  -- GREEK SMALL LETTER ALPHA WITH VARIA .. GREEK SMALL LETTER ALPHA WITH OXIA
     (16#01F72#, 16#01F75#),  -- GREEK SMALL LETTER EPSILON WITH VARIA .. GREEK SMALL LETTER ETA WITH OXIA
     (16#01F76#, 16#01F77#),  -- GREEK SMALL LETTER IOTA WITH VARIA .. GREEK SMALL LETTER IOTA WITH OXIA
     (16#01F78#, 16#01F79#),  -- GREEK SMALL LETTER OMICRON WITH VARIA .. GREEK SMALL LETTER OMICRON WITH OXIA
     (16#01F7A#, 16#01F7B#),  -- GREEK SMALL LETTER UPSILON WITH VARIA .. GREEK SMALL LETTER UPSILON WITH OXIA
     (16#01F7C#, 16#01F7D#),  -- GREEK SMALL LETTER OMEGA WITH VARIA .. GREEK SMALL LETTER OMEGA WITH OXIA
     (16#01FB0#, 16#01FB1#),  -- GREEK SMALL LETTER ALPHA WITH VRACHY .. GREEK SMALL LETTER ALPHA WITH MACRON
     (16#01FD0#, 16#01FD1#),  -- GREEK SMALL LETTER IOTA WITH VRACHY .. GREEK SMALL LETTER IOTA WITH MACRON
     (16#01FE0#, 16#01FE1#),  -- GREEK SMALL LETTER UPSILON WITH VRACHY .. GREEK SMALL LETTER UPSILON WITH MACRON
     (16#01FE5#, 16#01FE5#),  -- GREEK SMALL LETTER RHO WITH DASIA .. GREEK SMALL LETTER RHO WITH DASIA
     (16#024D0#, 16#024E9#),  -- CIRCLED LATIN SMALL LETTER A .. CIRCLED LATIN SMALL LETTER Z
     (16#0FF41#, 16#0FF5A#),  -- FULLWIDTH LATIN SMALL LETTER A .. FULLWIDTH LATIN SMALL LETTER Z
     (16#10428#, 16#1044F#),  -- DESERET SMALL LETTER LONG I .. DESERET SMALL LETTER EW
     (16#E0061#, 16#E007A#)); -- TAG LATIN SMALL LETTER A .. TAG LATIN SMALL LETTER Z

   Lower_Case_Adjust : constant array (Lower_Case_Letters'Range)
     of UTF_32'Base := (
       -32,  -- LATIN SMALL LETTER A .. LATIN SMALL LETTER Z
       -32,  -- LATIN SMALL LETTER A WITH GRAVE .. LATIN SMALL LETTER O WITH DIAERESIS
       -32,  -- LATIN SMALL LETTER O WITH STROKE .. LATIN SMALL LETTER THORN
       121,  -- LATIN SMALL LETTER Y WITH DIAERESIS .. LATIN SMALL LETTER Y WITH DIAERESIS
        -1,  -- LATIN SMALL LETTER A WITH MACRON .. LATIN SMALL LETTER A WITH MACRON
        -1,  -- LATIN SMALL LETTER A WITH BREVE .. LATIN SMALL LETTER A WITH BREVE
        -1,  -- LATIN SMALL LETTER A WITH OGONEK .. LATIN SMALL LETTER A WITH OGONEK
        -1,  -- LATIN SMALL LETTER C WITH ACUTE .. LATIN SMALL LETTER C WITH ACUTE
        -1,  -- LATIN SMALL LETTER C WITH CIRCUMFLEX .. LATIN SMALL LETTER C WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER C WITH DOT ABOVE .. LATIN SMALL LETTER C WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER C WITH CARON .. LATIN SMALL LETTER C WITH CARON
        -1,  -- LATIN SMALL LETTER D WITH CARON .. LATIN SMALL LETTER D WITH CARON
        -1,  -- LATIN SMALL LETTER D WITH STROKE .. LATIN SMALL LETTER D WITH STROKE
        -1,  -- LATIN SMALL LETTER E WITH MACRON .. LATIN SMALL LETTER E WITH MACRON
        -1,  -- LATIN SMALL LETTER E WITH BREVE .. LATIN SMALL LETTER E WITH BREVE
        -1,  -- LATIN SMALL LETTER E WITH DOT ABOVE .. LATIN SMALL LETTER E WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER E WITH OGONEK .. LATIN SMALL LETTER E WITH OGONEK
        -1,  -- LATIN SMALL LETTER E WITH CARON .. LATIN SMALL LETTER E WITH CARON
        -1,  -- LATIN SMALL LETTER G WITH CIRCUMFLEX .. LATIN SMALL LETTER G WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER G WITH BREVE .. LATIN SMALL LETTER G WITH BREVE
        -1,  -- LATIN SMALL LETTER G WITH DOT ABOVE .. LATIN SMALL LETTER G WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER G WITH CEDILLA .. LATIN SMALL LETTER G WITH CEDILLA
        -1,  -- LATIN SMALL LETTER H WITH CIRCUMFLEX .. LATIN SMALL LETTER H WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER H WITH STROKE .. LATIN SMALL LETTER H WITH STROKE
        -1,  -- LATIN SMALL LETTER I WITH TILDE .. LATIN SMALL LETTER I WITH TILDE
        -1,  -- LATIN SMALL LETTER I WITH MACRON .. LATIN SMALL LETTER I WITH MACRON
        -1,  -- LATIN SMALL LETTER I WITH BREVE .. LATIN SMALL LETTER I WITH BREVE
        -1,  -- LATIN SMALL LETTER I WITH OGONEK .. LATIN SMALL LETTER I WITH OGONEK
        -1,  -- LATIN SMALL LETTER I J .. LATIN SMALL LETTER I J
        -1,  -- LATIN SMALL LETTER J WITH CIRCUMFLEX .. LATIN SMALL LETTER J WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER K WITH CEDILLA .. LATIN SMALL LETTER K WITH CEDILLA
        -1,  -- LATIN SMALL LETTER L WITH ACUTE .. LATIN SMALL LETTER L WITH ACUTE
        -1,  -- LATIN SMALL LETTER L WITH CEDILLA .. LATIN SMALL LETTER L WITH CEDILLA
        -1,  -- LATIN SMALL LETTER L WITH CARON .. LATIN SMALL LETTER L WITH CARON
        -1,  -- LATIN SMALL LETTER L WITH MIDDLE DOT .. LATIN SMALL LETTER L WITH MIDDLE DOT
        -1,  -- LATIN SMALL LETTER L WITH STROKE .. LATIN SMALL LETTER L WITH STROKE
        -1,  -- LATIN SMALL LETTER N WITH ACUTE .. LATIN SMALL LETTER N WITH ACUTE
        -1,  -- LATIN SMALL LETTER N WITH CEDILLA .. LATIN SMALL LETTER N WITH CEDILLA
        -1,  -- LATIN SMALL LETTER N WITH CARON .. LATIN SMALL LETTER N WITH CARON
        -1,  -- LATIN SMALL LETTER ENG .. LATIN SMALL LETTER ENG
        -1,  -- LATIN SMALL LETTER O WITH MACRON .. LATIN SMALL LETTER O WITH MACRON
        -1,  -- LATIN SMALL LETTER O WITH BREVE .. LATIN SMALL LETTER O WITH BREVE
        -1,  -- LATIN SMALL LETTER O WITH DOUBLE ACUTE .. LATIN SMALL LETTER O WITH DOUBLE ACUTE
        -1,  -- LATIN SMALL LETTER O E .. LATIN SMALL LETTER O E
        -1,  -- LATIN SMALL LETTER R WITH ACUTE .. LATIN SMALL LETTER R WITH ACUTE
        -1,  -- LATIN SMALL LETTER R WITH CEDILLA .. LATIN SMALL LETTER R WITH CEDILLA
        -1,  -- LATIN SMALL LETTER R WITH CARON .. LATIN SMALL LETTER R WITH CARON
        -1,  -- LATIN SMALL LETTER S WITH ACUTE .. LATIN SMALL LETTER S WITH ACUTE
        -1,  -- LATIN SMALL LETTER S WITH CIRCUMFLEX .. LATIN SMALL LETTER S WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER S WITH CEDILLA .. LATIN SMALL LETTER S WITH CEDILLA
        -1,  -- LATIN SMALL LETTER S WITH CARON .. LATIN SMALL LETTER S WITH CARON
        -1,  -- LATIN SMALL LETTER T WITH CEDILLA .. LATIN SMALL LETTER T WITH CEDILLA
        -1,  -- LATIN SMALL LETTER T WITH CARON .. LATIN SMALL LETTER T WITH CARON
        -1,  -- LATIN SMALL LETTER T WITH STROKE .. LATIN SMALL LETTER T WITH STROKE
        -1,  -- LATIN SMALL LETTER U WITH TILDE .. LATIN SMALL LETTER U WITH TILDE
        -1,  -- LATIN SMALL LETTER U WITH MACRON .. LATIN SMALL LETTER U WITH MACRON
        -1,  -- LATIN SMALL LETTER U WITH BREVE .. LATIN SMALL LETTER U WITH BREVE
        -1,  -- LATIN SMALL LETTER U WITH RING ABOVE .. LATIN SMALL LETTER U WITH RING ABOVE
        -1,  -- LATIN SMALL LETTER U WITH DOUBLE ACUTE .. LATIN SMALL LETTER U WITH DOUBLE ACUTE
        -1,  -- LATIN SMALL LETTER U WITH OGONEK .. LATIN SMALL LETTER U WITH OGONEK
        -1,  -- LATIN SMALL LETTER W WITH CIRCUMFLEX .. LATIN SMALL LETTER W WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER Y WITH CIRCUMFLEX .. LATIN SMALL LETTER Y WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER Z WITH ACUTE .. LATIN SMALL LETTER Z WITH ACUTE
        -1,  -- LATIN SMALL LETTER Z WITH DOT ABOVE .. LATIN SMALL LETTER Z WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER Z WITH CARON .. LATIN SMALL LETTER Z WITH CARON
        -1,  -- LATIN SMALL LETTER B WITH TOPBAR .. LATIN SMALL LETTER B WITH TOPBAR
        -1,  -- LATIN SMALL LETTER TONE SIX .. LATIN SMALL LETTER TONE SIX
        -1,  -- LATIN SMALL LETTER C WITH HOOK .. LATIN SMALL LETTER C WITH HOOK
        -1,  -- LATIN SMALL LETTER D WITH TOPBAR .. LATIN SMALL LETTER D WITH TOPBAR
        -1,  -- LATIN SMALL LETTER F WITH HOOK .. LATIN SMALL LETTER F WITH HOOK
        -1,  -- LATIN SMALL LETTER K WITH HOOK .. LATIN SMALL LETTER K WITH HOOK
       130,  -- LATIN SMALL LETTER N WITH LONG RIGHT LEG .. LATIN SMALL LETTER N WITH LONG RIGHT LEG
        -1,  -- LATIN SMALL LETTER O WITH HORN .. LATIN SMALL LETTER O WITH HORN
        -1,  -- LATIN SMALL LETTER OI .. LATIN SMALL LETTER OI
        -1,  -- LATIN SMALL LETTER P WITH HOOK .. LATIN SMALL LETTER P WITH HOOK
        -1,  -- LATIN SMALL LETTER TONE TWO .. LATIN SMALL LETTER TONE TWO
        -1,  -- LATIN SMALL LETTER T WITH HOOK .. LATIN SMALL LETTER T WITH HOOK
        -1,  -- LATIN SMALL LETTER U WITH HORN .. LATIN SMALL LETTER U WITH HORN
        -1,  -- LATIN SMALL LETTER Y WITH HOOK .. LATIN SMALL LETTER Y WITH HOOK
        -1,  -- LATIN SMALL LETTER Z WITH STROKE .. LATIN SMALL LETTER Z WITH STROKE
        -1,  -- LATIN SMALL LETTER EZH REVERSED .. LATIN SMALL LETTER EZH REVERSED
        -1,  -- LATIN SMALL LETTER TONE FIVE .. LATIN SMALL LETTER TONE FIVE
        -2,  -- LATIN SMALL LETTER DZ WITH CARON .. LATIN SMALL LETTER DZ WITH CARON
        -2,  -- LATIN SMALL LETTER LJ .. LATIN SMALL LETTER LJ
        -2,  -- LATIN SMALL LETTER NJ .. LATIN SMALL LETTER NJ
        -1,  -- LATIN SMALL LETTER A WITH CARON .. LATIN SMALL LETTER A WITH CARON
        -1,  -- LATIN SMALL LETTER I WITH CARON .. LATIN SMALL LETTER I WITH CARON
        -1,  -- LATIN SMALL LETTER O WITH CARON .. LATIN SMALL LETTER O WITH CARON
        -1,  -- LATIN SMALL LETTER U WITH CARON .. LATIN SMALL LETTER U WITH CARON
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS AND CARON .. LATIN SMALL LETTER U WITH DIAERESIS AND CARON
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE .. LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
        -1,  -- LATIN SMALL LETTER A WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
        -1,  -- LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
        -1,  -- LATIN SMALL LETTER AE WITH MACRON .. LATIN SMALL LETTER AE WITH MACRON
        -1,  -- LATIN SMALL LETTER G WITH STROKE .. LATIN SMALL LETTER G WITH STROKE
        -1,  -- LATIN SMALL LETTER G WITH CARON .. LATIN SMALL LETTER G WITH CARON
        -1,  -- LATIN SMALL LETTER K WITH CARON .. LATIN SMALL LETTER K WITH CARON
        -1,  -- LATIN SMALL LETTER O WITH OGONEK .. LATIN SMALL LETTER O WITH OGONEK
        -1,  -- LATIN SMALL LETTER O WITH OGONEK AND MACRON .. LATIN SMALL LETTER O WITH OGONEK AND MACRON
        -1,  -- LATIN SMALL LETTER EZH WITH CARON .. LATIN SMALL LETTER EZH WITH CARON
        -2,  -- LATIN SMALL LETTER DZ .. LATIN SMALL LETTER DZ
        -1,  -- LATIN SMALL LETTER G WITH ACUTE .. LATIN SMALL LETTER G WITH ACUTE
        -1,  -- LATIN SMALL LETTER N WITH GRAVE .. LATIN SMALL LETTER N WITH GRAVE
        -1,  -- LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE .. LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
        -1,  -- LATIN SMALL LETTER AE WITH ACUTE .. LATIN SMALL LETTER AE WITH ACUTE
        -1,  -- LATIN SMALL LETTER O WITH STROKE AND ACUTE .. LATIN SMALL LETTER O WITH STROKE AND ACUTE
        -1,  -- LATIN SMALL LETTER A WITH DOUBLE GRAVE .. LATIN SMALL LETTER A WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER A WITH INVERTED BREVE .. LATIN SMALL LETTER A WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER E WITH DOUBLE GRAVE .. LATIN SMALL LETTER E WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER E WITH INVERTED BREVE .. LATIN SMALL LETTER E WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER I WITH DOUBLE GRAVE .. LATIN SMALL LETTER I WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER I WITH INVERTED BREVE .. LATIN SMALL LETTER I WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER O WITH DOUBLE GRAVE .. LATIN SMALL LETTER O WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER O WITH INVERTED BREVE .. LATIN SMALL LETTER O WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER R WITH DOUBLE GRAVE .. LATIN SMALL LETTER R WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER R WITH INVERTED BREVE .. LATIN SMALL LETTER R WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER U WITH DOUBLE GRAVE .. LATIN SMALL LETTER U WITH DOUBLE GRAVE
        -1,  -- LATIN SMALL LETTER U WITH INVERTED BREVE .. LATIN SMALL LETTER U WITH INVERTED BREVE
        -1,  -- LATIN SMALL LETTER S WITH COMMA BELOW .. LATIN SMALL LETTER S WITH COMMA BELOW
        -1,  -- LATIN SMALL LETTER T WITH COMMA BELOW .. LATIN SMALL LETTER T WITH COMMA BELOW
        -1,  -- LATIN SMALL LETTER YOGH .. LATIN SMALL LETTER YOGH
        -1,  -- LATIN SMALL LETTER H WITH CARON .. LATIN SMALL LETTER H WITH CARON
        -1,  -- LATIN SMALL LETTER OU .. LATIN SMALL LETTER OU
        -1,  -- LATIN SMALL LETTER Z WITH HOOK .. LATIN SMALL LETTER Z WITH HOOK
        -1,  -- LATIN SMALL LETTER A WITH DOT ABOVE .. LATIN SMALL LETTER A WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER E WITH CEDILLA .. LATIN SMALL LETTER E WITH CEDILLA
        -1,  -- LATIN SMALL LETTER O WITH DIAERESIS AND MACRON .. LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
        -1,  -- LATIN SMALL LETTER O WITH TILDE AND MACRON .. LATIN SMALL LETTER O WITH TILDE AND MACRON
        -1,  -- LATIN SMALL LETTER O WITH DOT ABOVE .. LATIN SMALL LETTER O WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON .. LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
        -1,  -- LATIN SMALL LETTER Y WITH MACRON .. LATIN SMALL LETTER Y WITH MACRON
      -210,  -- LATIN SMALL LETTER B WITH HOOK .. LATIN SMALL LETTER B WITH HOOK
      -206,  -- LATIN SMALL LETTER OPEN O .. LATIN SMALL LETTER OPEN O
      -205,  -- LATIN SMALL LETTER D WITH HOOK .. LATIN SMALL LETTER D WITH HOOK
      -202,  -- LATIN SMALL LETTER REVERSED E .. LATIN SMALL LETTER SCHWA
      -203,  -- LATIN SMALL LETTER OPEN E .. LATIN SMALL LETTER OPEN E
      -205,  -- LATIN SMALL LETTER G WITH HOOK .. LATIN SMALL LETTER G WITH HOOK
      -207,  -- LATIN SMALL LETTER GAMMA .. LATIN SMALL LETTER GAMMA
      -209,  -- LATIN SMALL LETTER I WITH STROKE .. LATIN SMALL LETTER I WITH STROKE
      -211,  -- LATIN SMALL LETTER IOTA .. LATIN SMALL LETTER IOTA
      -211,  -- LATIN SMALL LETTER TURNED M .. LATIN SMALL LETTER TURNED M
      -213,  -- LATIN SMALL LETTER N WITH LEFT HOOK .. LATIN SMALL LETTER N WITH LEFT HOOK
      -218,  -- LATIN SMALL LETTER ESH .. LATIN SMALL LETTER ESH
      -218,  -- LATIN SMALL LETTER T WITH RETROFLEX HOOK .. LATIN SMALL LETTER T WITH RETROFLEX HOOK
      -217,  -- LATIN SMALL LETTER UPSILON .. LATIN SMALL LETTER V WITH HOOK
      -219,  -- LATIN SMALL LETTER EZH .. LATIN SMALL LETTER EZH
       -38,  -- GREEK SMALL LETTER ALPHA WITH TONOS .. GREEK SMALL LETTER ALPHA WITH TONOS
       -37,  -- GREEK SMALL LETTER EPSILON WITH TONOS .. GREEK SMALL LETTER IOTA WITH TONOS
       -32,  -- GREEK SMALL LETTER ALPHA .. GREEK SMALL LETTER RHO
       -32,  -- GREEK SMALL LETTER SIGMA .. GREEK SMALL LETTER UPSILON WITH DIALYTIKA
       -64,  -- GREEK SMALL LETTER OMICRON WITH TONOS .. GREEK SMALL LETTER OMICRON WITH TONOS
       -63,  -- GREEK SMALL LETTER UPSILON WITH TONOS .. GREEK SMALL LETTER OMEGA WITH TONOS
        -1,  -- GREEK SMALL LETTER STIGMA .. GREEK SMALL LETTER STIGMA
        -1,  -- GREEK SMALL LETTER DIGAMMA .. GREEK SMALL LETTER DIGAMMA
        -1,  -- GREEK SMALL LETTER KOPPA .. GREEK SMALL LETTER KOPPA
        -1,  -- GREEK SMALL LETTER SAMPI .. GREEK SMALL LETTER SAMPI
        -1,  -- COPTIC SMALL LETTER SHEI .. COPTIC SMALL LETTER SHEI
        -1,  -- COPTIC SMALL LETTER FEI .. COPTIC SMALL LETTER FEI
        -1,  -- COPTIC SMALL LETTER KHEI .. COPTIC SMALL LETTER KHEI
        -1,  -- COPTIC SMALL LETTER HORI .. COPTIC SMALL LETTER HORI
        -1,  -- COPTIC SMALL LETTER GANGIA .. COPTIC SMALL LETTER GANGIA
        -1,  -- COPTIC SMALL LETTER SHIMA .. COPTIC SMALL LETTER SHIMA
        -1,  -- COPTIC SMALL LETTER DEI .. COPTIC SMALL LETTER DEI
        -1,  -- GREEK SMALL LETTER SHO .. GREEK SMALL LETTER SHO
        -1,  -- GREEK SMALL LETTER SAN .. GREEK SMALL LETTER SAN
       -32,  -- CYRILLIC SMALL LETTER A .. CYRILLIC SMALL LETTER YA
       -80,  -- CYRILLIC SMALL LETTER IE WITH GRAVE .. CYRILLIC SMALL LETTER DZHE
        -1,  -- CYRILLIC SMALL LETTER OMEGA .. CYRILLIC SMALL LETTER OMEGA
        -1,  -- CYRILLIC SMALL LETTER YAT .. CYRILLIC SMALL LETTER YAT
        -1,  -- CYRILLIC SMALL LETTER IOTIFIED E .. CYRILLIC SMALL LETTER IOTIFIED E
        -1,  -- CYRILLIC SMALL LETTER LITTLE YUS .. CYRILLIC SMALL LETTER LITTLE YUS
        -1,  -- CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS .. CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
        -1,  -- CYRILLIC SMALL LETTER BIG YUS .. CYRILLIC SMALL LETTER BIG YUS
        -1,  -- CYRILLIC SMALL LETTER IOTIFIED BIG YUS .. CYRILLIC SMALL LETTER IOTIFIED BIG YUS
        -1,  -- CYRILLIC SMALL LETTER KSI .. CYRILLIC SMALL LETTER KSI
        -1,  -- CYRILLIC SMALL LETTER PSI .. CYRILLIC SMALL LETTER PSI
        -1,  -- CYRILLIC SMALL LETTER FITA .. CYRILLIC SMALL LETTER FITA
        -1,  -- CYRILLIC SMALL LETTER IZHITSA .. CYRILLIC SMALL LETTER IZHITSA
        -1,  -- CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
        -1,  -- CYRILLIC SMALL LETTER UK .. CYRILLIC SMALL LETTER UK
        -1,  -- CYRILLIC SMALL LETTER ROUND OMEGA .. CYRILLIC SMALL LETTER ROUND OMEGA
        -1,  -- CYRILLIC SMALL LETTER OMEGA WITH TITLO .. CYRILLIC SMALL LETTER OMEGA WITH TITLO
        -1,  -- CYRILLIC SMALL LETTER OT .. CYRILLIC SMALL LETTER OT
        -1,  -- CYRILLIC SMALL LETTER KOPPA .. CYRILLIC SMALL LETTER KOPPA
        -1,  -- CYRILLIC SMALL LETTER SHORT I WITH TAIL .. CYRILLIC SMALL LETTER SHORT I WITH TAIL
        -1,  -- CYRILLIC SMALL LETTER SEMISOFT SIGN .. CYRILLIC SMALL LETTER SEMISOFT SIGN
        -1,  -- CYRILLIC SMALL LETTER ER WITH TICK .. CYRILLIC SMALL LETTER ER WITH TICK
        -1,  -- CYRILLIC SMALL LETTER GHE WITH UPTURN .. CYRILLIC SMALL LETTER GHE WITH UPTURN
        -1,  -- CYRILLIC SMALL LETTER GHE WITH STROKE .. CYRILLIC SMALL LETTER GHE WITH STROKE
        -1,  -- CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
        -1,  -- CYRILLIC SMALL LETTER ZHE WITH DESCENDER .. CYRILLIC SMALL LETTER ZHE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER ZE WITH DESCENDER .. CYRILLIC SMALL LETTER ZE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER KA WITH DESCENDER .. CYRILLIC SMALL LETTER KA WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
        -1,  -- CYRILLIC SMALL LETTER KA WITH STROKE .. CYRILLIC SMALL LETTER KA WITH STROKE
        -1,  -- CYRILLIC SMALL LETTER BASHKIR KA .. CYRILLIC SMALL LETTER BASHKIR KA
        -1,  -- CYRILLIC SMALL LETTER EN WITH DESCENDER .. CYRILLIC SMALL LETTER EN WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER EN GE .. CYRILLIC SMALL LETTER EN GE
        -1,  -- CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK .. CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
        -1,  -- CYRILLIC SMALL LETTER ABKHASIAN HA .. CYRILLIC SMALL LETTER ABKHASIAN HA
        -1,  -- CYRILLIC SMALL LETTER ES WITH DESCENDER .. CYRILLIC SMALL LETTER ES WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER TE WITH DESCENDER .. CYRILLIC SMALL LETTER TE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER STRAIGHT U .. CYRILLIC SMALL LETTER STRAIGHT U
        -1,  -- CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE .. CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
        -1,  -- CYRILLIC SMALL LETTER HA WITH DESCENDER .. CYRILLIC SMALL LETTER HA WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER TE TSE .. CYRILLIC SMALL LETTER TE TSE
        -1,  -- CYRILLIC SMALL LETTER CHE WITH DESCENDER .. CYRILLIC SMALL LETTER CHE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
        -1,  -- CYRILLIC SMALL LETTER SHHA .. CYRILLIC SMALL LETTER SHHA
        -1,  -- CYRILLIC SMALL LETTER ABKHASIAN CHE .. CYRILLIC SMALL LETTER ABKHASIAN CHE
        -1,  -- CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
        -1,  -- CYRILLIC SMALL LETTER ZHE WITH BREVE .. CYRILLIC SMALL LETTER ZHE WITH BREVE
        -1,  -- CYRILLIC SMALL LETTER KA WITH HOOK .. CYRILLIC SMALL LETTER KA WITH HOOK
        -1,  -- CYRILLIC SMALL LETTER EL WITH TAIL .. CYRILLIC SMALL LETTER EL WITH TAIL
        -1,  -- CYRILLIC SMALL LETTER EN WITH HOOK .. CYRILLIC SMALL LETTER EN WITH HOOK
        -1,  -- CYRILLIC SMALL LETTER EN WITH TAIL .. CYRILLIC SMALL LETTER EN WITH TAIL
        -1,  -- CYRILLIC SMALL LETTER KHAKASSIAN CHE .. CYRILLIC SMALL LETTER KHAKASSIAN CHE
        -1,  -- CYRILLIC SMALL LETTER EM WITH TAIL .. CYRILLIC SMALL LETTER EM WITH TAIL
        -1,  -- CYRILLIC SMALL LETTER A WITH BREVE .. CYRILLIC SMALL LETTER A WITH BREVE
        -1,  -- CYRILLIC SMALL LETTER A WITH DIAERESIS .. CYRILLIC SMALL LETTER A WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER IE WITH BREVE .. CYRILLIC SMALL LETTER IE WITH BREVE
        -1,  -- CYRILLIC SMALL LETTER SCHWA .. CYRILLIC SMALL LETTER SCHWA
        -1,  -- CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS .. CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER ZHE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER ZE WITH DIAERESIS .. CYRILLIC SMALL LETTER ZE WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER ABKHASIAN DZE .. CYRILLIC SMALL LETTER ABKHASIAN DZE
        -1,  -- CYRILLIC SMALL LETTER I WITH MACRON .. CYRILLIC SMALL LETTER I WITH MACRON
        -1,  -- CYRILLIC SMALL LETTER I WITH DIAERESIS .. CYRILLIC SMALL LETTER I WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER O WITH DIAERESIS .. CYRILLIC SMALL LETTER O WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER BARRED O .. CYRILLIC SMALL LETTER BARRED O
        -1,  -- CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS .. CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER E WITH DIAERESIS .. CYRILLIC SMALL LETTER E WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER U WITH MACRON .. CYRILLIC SMALL LETTER U WITH MACRON
        -1,  -- CYRILLIC SMALL LETTER U WITH DIAERESIS .. CYRILLIC SMALL LETTER U WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE .. CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
        -1,  -- CYRILLIC SMALL LETTER CHE WITH DIAERESIS .. CYRILLIC SMALL LETTER CHE WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER YERU WITH DIAERESIS .. CYRILLIC SMALL LETTER YERU WITH DIAERESIS
        -1,  -- CYRILLIC SMALL LETTER KOMI DE .. CYRILLIC SMALL LETTER KOMI DE
        -1,  -- CYRILLIC SMALL LETTER KOMI DJE .. CYRILLIC SMALL LETTER KOMI DJE
        -1,  -- CYRILLIC SMALL LETTER KOMI ZJE .. CYRILLIC SMALL LETTER KOMI ZJE
        -1,  -- CYRILLIC SMALL LETTER KOMI DZJE .. CYRILLIC SMALL LETTER KOMI DZJE
        -1,  -- CYRILLIC SMALL LETTER KOMI LJE .. CYRILLIC SMALL LETTER KOMI LJE
        -1,  -- CYRILLIC SMALL LETTER KOMI NJE .. CYRILLIC SMALL LETTER KOMI NJE
        -1,  -- CYRILLIC SMALL LETTER KOMI SJE .. CYRILLIC SMALL LETTER KOMI SJE
        -1,  -- CYRILLIC SMALL LETTER KOMI TJE .. CYRILLIC SMALL LETTER KOMI TJE
       -48,  -- ARMENIAN SMALL LETTER AYB .. ARMENIAN SMALL LETTER FEH
       -48,  -- GEORGIAN SMALL LETTER AN .. GEORGIAN SMALL LETTER HOE
        -1,  -- LATIN SMALL LETTER A WITH RING BELOW .. LATIN SMALL LETTER A WITH RING BELOW
        -1,  -- LATIN SMALL LETTER B WITH DOT ABOVE .. LATIN SMALL LETTER B WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER B WITH DOT BELOW .. LATIN SMALL LETTER B WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER B WITH LINE BELOW .. LATIN SMALL LETTER B WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER C WITH CEDILLA AND ACUTE .. LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
        -1,  -- LATIN SMALL LETTER D WITH DOT ABOVE .. LATIN SMALL LETTER D WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER D WITH DOT BELOW .. LATIN SMALL LETTER D WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER D WITH LINE BELOW .. LATIN SMALL LETTER D WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER D WITH CEDILLA .. LATIN SMALL LETTER D WITH CEDILLA
        -1,  -- LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER E WITH MACRON AND GRAVE .. LATIN SMALL LETTER E WITH MACRON AND GRAVE
        -1,  -- LATIN SMALL LETTER E WITH MACRON AND ACUTE .. LATIN SMALL LETTER E WITH MACRON AND ACUTE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER E WITH TILDE BELOW .. LATIN SMALL LETTER E WITH TILDE BELOW
        -1,  -- LATIN SMALL LETTER E WITH CEDILLA AND BREVE .. LATIN SMALL LETTER E WITH CEDILLA AND BREVE
        -1,  -- LATIN SMALL LETTER F WITH DOT ABOVE .. LATIN SMALL LETTER F WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER G WITH MACRON .. LATIN SMALL LETTER G WITH MACRON
        -1,  -- LATIN SMALL LETTER H WITH DOT ABOVE .. LATIN SMALL LETTER H WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER H WITH DOT BELOW .. LATIN SMALL LETTER H WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER H WITH DIAERESIS .. LATIN SMALL LETTER H WITH DIAERESIS
        -1,  -- LATIN SMALL LETTER H WITH CEDILLA .. LATIN SMALL LETTER H WITH CEDILLA
        -1,  -- LATIN SMALL LETTER H WITH BREVE BELOW .. LATIN SMALL LETTER H WITH BREVE BELOW
        -1,  -- LATIN SMALL LETTER I WITH TILDE BELOW .. LATIN SMALL LETTER I WITH TILDE BELOW
        -1,  -- LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE .. LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
        -1,  -- LATIN SMALL LETTER K WITH ACUTE .. LATIN SMALL LETTER K WITH ACUTE
        -1,  -- LATIN SMALL LETTER K WITH DOT BELOW .. LATIN SMALL LETTER K WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER K WITH LINE BELOW .. LATIN SMALL LETTER K WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER L WITH DOT BELOW .. LATIN SMALL LETTER L WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER L WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
        -1,  -- LATIN SMALL LETTER L WITH LINE BELOW .. LATIN SMALL LETTER L WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER M WITH ACUTE .. LATIN SMALL LETTER M WITH ACUTE
        -1,  -- LATIN SMALL LETTER M WITH DOT ABOVE .. LATIN SMALL LETTER M WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER M WITH DOT BELOW .. LATIN SMALL LETTER M WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER N WITH DOT ABOVE .. LATIN SMALL LETTER N WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER N WITH DOT BELOW .. LATIN SMALL LETTER N WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER N WITH LINE BELOW .. LATIN SMALL LETTER N WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER O WITH TILDE AND ACUTE .. LATIN SMALL LETTER O WITH TILDE AND ACUTE
        -1,  -- LATIN SMALL LETTER O WITH TILDE AND DIAERESIS .. LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
        -1,  -- LATIN SMALL LETTER O WITH MACRON AND GRAVE .. LATIN SMALL LETTER O WITH MACRON AND GRAVE
        -1,  -- LATIN SMALL LETTER O WITH MACRON AND ACUTE .. LATIN SMALL LETTER O WITH MACRON AND ACUTE
        -1,  -- LATIN SMALL LETTER P WITH ACUTE .. LATIN SMALL LETTER P WITH ACUTE
        -1,  -- LATIN SMALL LETTER P WITH DOT ABOVE .. LATIN SMALL LETTER P WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER R WITH DOT ABOVE .. LATIN SMALL LETTER R WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER R WITH DOT BELOW .. LATIN SMALL LETTER R WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER R WITH DOT BELOW AND MACRON .. LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
        -1,  -- LATIN SMALL LETTER R WITH LINE BELOW .. LATIN SMALL LETTER R WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER S WITH DOT ABOVE .. LATIN SMALL LETTER S WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER S WITH DOT BELOW .. LATIN SMALL LETTER S WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
        -1,  -- LATIN SMALL LETTER S WITH CARON AND DOT ABOVE .. LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
        -1,  -- LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
        -1,  -- LATIN SMALL LETTER T WITH DOT ABOVE .. LATIN SMALL LETTER T WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER T WITH DOT BELOW .. LATIN SMALL LETTER T WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER T WITH LINE BELOW .. LATIN SMALL LETTER T WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER U WITH DIAERESIS BELOW .. LATIN SMALL LETTER U WITH DIAERESIS BELOW
        -1,  -- LATIN SMALL LETTER U WITH TILDE BELOW .. LATIN SMALL LETTER U WITH TILDE BELOW
        -1,  -- LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW .. LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
        -1,  -- LATIN SMALL LETTER U WITH TILDE AND ACUTE .. LATIN SMALL LETTER U WITH TILDE AND ACUTE
        -1,  -- LATIN SMALL LETTER U WITH MACRON AND DIAERESIS .. LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
        -1,  -- LATIN SMALL LETTER V WITH TILDE .. LATIN SMALL LETTER V WITH TILDE
        -1,  -- LATIN SMALL LETTER V WITH DOT BELOW .. LATIN SMALL LETTER V WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER W WITH GRAVE .. LATIN SMALL LETTER W WITH GRAVE
        -1,  -- LATIN SMALL LETTER W WITH ACUTE .. LATIN SMALL LETTER W WITH ACUTE
        -1,  -- LATIN SMALL LETTER W WITH DIAERESIS .. LATIN SMALL LETTER W WITH DIAERESIS
        -1,  -- LATIN SMALL LETTER W WITH DOT ABOVE .. LATIN SMALL LETTER W WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER W WITH DOT BELOW .. LATIN SMALL LETTER W WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER X WITH DOT ABOVE .. LATIN SMALL LETTER X WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER X WITH DIAERESIS .. LATIN SMALL LETTER X WITH DIAERESIS
        -1,  -- LATIN SMALL LETTER Y WITH DOT ABOVE .. LATIN SMALL LETTER Y WITH DOT ABOVE
        -1,  -- LATIN SMALL LETTER Z WITH CIRCUMFLEX .. LATIN SMALL LETTER Z WITH CIRCUMFLEX
        -1,  -- LATIN SMALL LETTER Z WITH DOT BELOW .. LATIN SMALL LETTER Z WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER Z WITH LINE BELOW .. LATIN SMALL LETTER Z WITH LINE BELOW
        -1,  -- LATIN SMALL LETTER A WITH DOT BELOW .. LATIN SMALL LETTER A WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER A WITH HOOK ABOVE .. LATIN SMALL LETTER A WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
        -1,  -- LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND ACUTE .. LATIN SMALL LETTER A WITH BREVE AND ACUTE
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND GRAVE .. LATIN SMALL LETTER A WITH BREVE AND GRAVE
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND TILDE .. LATIN SMALL LETTER A WITH BREVE AND TILDE
        -1,  -- LATIN SMALL LETTER A WITH BREVE AND DOT BELOW .. LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
        -1,  -- LATIN SMALL LETTER E WITH DOT BELOW .. LATIN SMALL LETTER E WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER E WITH HOOK ABOVE .. LATIN SMALL LETTER E WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER E WITH TILDE .. LATIN SMALL LETTER E WITH TILDE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
        -1,  -- LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
        -1,  -- LATIN SMALL LETTER I WITH HOOK ABOVE .. LATIN SMALL LETTER I WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER I WITH DOT BELOW .. LATIN SMALL LETTER I WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER O WITH DOT BELOW .. LATIN SMALL LETTER O WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER O WITH HOOK ABOVE .. LATIN SMALL LETTER O WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
        -1,  -- LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
        -1,  -- LATIN SMALL LETTER O WITH HORN AND ACUTE .. LATIN SMALL LETTER O WITH HORN AND ACUTE
        -1,  -- LATIN SMALL LETTER O WITH HORN AND GRAVE .. LATIN SMALL LETTER O WITH HORN AND GRAVE
        -1,  -- LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER O WITH HORN AND TILDE .. LATIN SMALL LETTER O WITH HORN AND TILDE
        -1,  -- LATIN SMALL LETTER O WITH HORN AND DOT BELOW .. LATIN SMALL LETTER O WITH HORN AND DOT BELOW
        -1,  -- LATIN SMALL LETTER U WITH DOT BELOW .. LATIN SMALL LETTER U WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER U WITH HOOK ABOVE .. LATIN SMALL LETTER U WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND ACUTE .. LATIN SMALL LETTER U WITH HORN AND ACUTE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND GRAVE .. LATIN SMALL LETTER U WITH HORN AND GRAVE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE .. LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND TILDE .. LATIN SMALL LETTER U WITH HORN AND TILDE
        -1,  -- LATIN SMALL LETTER U WITH HORN AND DOT BELOW .. LATIN SMALL LETTER U WITH HORN AND DOT BELOW
        -1,  -- LATIN SMALL LETTER Y WITH GRAVE .. LATIN SMALL LETTER Y WITH GRAVE
        -1,  -- LATIN SMALL LETTER Y WITH DOT BELOW .. LATIN SMALL LETTER Y WITH DOT BELOW
        -1,  -- LATIN SMALL LETTER Y WITH HOOK ABOVE .. LATIN SMALL LETTER Y WITH HOOK ABOVE
        -1,  -- LATIN SMALL LETTER Y WITH TILDE .. LATIN SMALL LETTER Y WITH TILDE
         8,  -- GREEK SMALL LETTER ALPHA WITH PSILI .. GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
         8,  -- GREEK SMALL LETTER EPSILON WITH PSILI .. GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
         8,  -- GREEK SMALL LETTER ETA WITH PSILI .. GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
         8,  -- GREEK SMALL LETTER IOTA WITH PSILI .. GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
         8,  -- GREEK SMALL LETTER OMICRON WITH PSILI .. GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
         8,  -- GREEK SMALL LETTER UPSILON WITH DASIA .. GREEK SMALL LETTER UPSILON WITH DASIA
         8,  -- GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA .. GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
         8,  -- GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA .. GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
         8,  -- GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
         8,  -- GREEK SMALL LETTER OMEGA WITH PSILI .. GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
        74,  -- GREEK SMALL LETTER ALPHA WITH VARIA .. GREEK SMALL LETTER ALPHA WITH OXIA
        86,  -- GREEK SMALL LETTER EPSILON WITH VARIA .. GREEK SMALL LETTER ETA WITH OXIA
       100,  -- GREEK SMALL LETTER IOTA WITH VARIA .. GREEK SMALL LETTER IOTA WITH OXIA
       128,  -- GREEK SMALL LETTER OMICRON WITH VARIA .. GREEK SMALL LETTER OMICRON WITH OXIA
       112,  -- GREEK SMALL LETTER UPSILON WITH VARIA .. GREEK SMALL LETTER UPSILON WITH OXIA
       126,  -- GREEK SMALL LETTER OMEGA WITH VARIA .. GREEK SMALL LETTER OMEGA WITH OXIA
         8,  -- GREEK SMALL LETTER ALPHA WITH VRACHY .. GREEK SMALL LETTER ALPHA WITH MACRON
         8,  -- GREEK SMALL LETTER IOTA WITH VRACHY .. GREEK SMALL LETTER IOTA WITH MACRON
         8,  -- GREEK SMALL LETTER UPSILON WITH VRACHY .. GREEK SMALL LETTER UPSILON WITH MACRON
         7,  -- GREEK SMALL LETTER RHO WITH DASIA .. GREEK SMALL LETTER RHO WITH DASIA
       -26,  -- CIRCLED LATIN SMALL LETTER A .. CIRCLED LATIN SMALL LETTER Z
       -32,  -- FULLWIDTH LATIN SMALL LETTER A .. FULLWIDTH LATIN SMALL LETTER Z
       -40,  -- DESERET SMALL LETTER LONG I .. DESERET SMALL LETTER EW
       -32); -- TAG LATIN SMALL LETTER A .. TAG LATIN SMALL LETTER Z

   --  The following is a list of the 10646 names for SMALL LETTER entries
   --  that have no matching CAPITAL LETTER entry and are thus not folded

   --  LATIN SMALL LETTER SHARP S
   --  LATIN SMALL LETTER DOTLESS I
   --  LATIN SMALL LETTER KRA
   --  LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
   --  LATIN SMALL LETTER LONG S
   --  LATIN SMALL LETTER B WITH STROKE
   --  LATIN SMALL LETTER TURNED DELTA
   --  LATIN SMALL LETTER HV
   --  LATIN SMALL LETTER L WITH BAR
   --  LATIN SMALL LETTER LAMBDA WITH STROKE
   --  LATIN SMALL LETTER T WITH PALATAL HOOK
   --  LATIN SMALL LETTER EZH WITH TAIL
   --  LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
   --  LATIN CAPITAL LETTER L WITH SMALL LETTER J
   --  LATIN CAPITAL LETTER N WITH SMALL LETTER J
   --  LATIN SMALL LETTER TURNED E
   --  LATIN SMALL LETTER J WITH CARON
   --  LATIN CAPITAL LETTER D WITH SMALL LETTER Z
   --  LATIN SMALL LETTER D WITH CURL
   --  LATIN SMALL LETTER L WITH CURL
   --  LATIN SMALL LETTER N WITH CURL
   --  LATIN SMALL LETTER T WITH CURL
   --  LATIN SMALL LETTER TURNED A
   --  LATIN SMALL LETTER ALPHA
   --  LATIN SMALL LETTER TURNED ALPHA
   --  LATIN SMALL LETTER C WITH CURL
   --  LATIN SMALL LETTER D WITH TAIL
   --  LATIN SMALL LETTER SCHWA WITH HOOK
   --  LATIN SMALL LETTER REVERSED OPEN E
   --  LATIN SMALL LETTER REVERSED OPEN E WITH HOOK
   --  LATIN SMALL LETTER CLOSED REVERSED OPEN E
   --  LATIN SMALL LETTER DOTLESS J WITH STROKE
   --  LATIN SMALL LETTER SCRIPT G
   --  LATIN SMALL LETTER RAMS HORN
   --  LATIN SMALL LETTER TURNED H
   --  LATIN SMALL LETTER H WITH HOOK
   --  LATIN SMALL LETTER HENG WITH HOOK
   --  LATIN SMALL LETTER L WITH MIDDLE TILDE
   --  LATIN SMALL LETTER L WITH BELT
   --  LATIN SMALL LETTER L WITH RETROFLEX HOOK
   --  LATIN SMALL LETTER LEZH
   --  LATIN SMALL LETTER TURNED M WITH LONG LEG
   --  LATIN SMALL LETTER M WITH HOOK
   --  LATIN SMALL LETTER N WITH RETROFLEX HOOK
   --  LATIN SMALL LETTER BARRED O
   --  LATIN SMALL LETTER CLOSED OMEGA
   --  LATIN SMALL LETTER PHI
   --  LATIN SMALL LETTER TURNED R
   --  LATIN SMALL LETTER TURNED R WITH LONG LEG
   --  LATIN SMALL LETTER TURNED R WITH HOOK
   --  LATIN SMALL LETTER R WITH LONG LEG
   --  LATIN SMALL LETTER R WITH TAIL
   --  LATIN SMALL LETTER R WITH FISHHOOK
   --  LATIN SMALL LETTER REVERSED R WITH FISHHOOK
   --  LATIN SMALL LETTER S WITH HOOK
   --  LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK
   --  LATIN SMALL LETTER SQUAT REVERSED ESH
   --  LATIN SMALL LETTER ESH WITH CURL
   --  LATIN SMALL LETTER TURNED T
   --  LATIN SMALL LETTER U BAR
   --  LATIN SMALL LETTER TURNED V
   --  LATIN SMALL LETTER TURNED W
   --  LATIN SMALL LETTER TURNED Y
   --  LATIN SMALL LETTER Z WITH RETROFLEX HOOK
   --  LATIN SMALL LETTER Z WITH CURL
   --  LATIN SMALL LETTER EZH WITH CURL
   --  LATIN SMALL LETTER CLOSED OPEN E
   --  LATIN SMALL LETTER J WITH CROSSED-TAIL
   --  LATIN SMALL LETTER TURNED K
   --  LATIN SMALL LETTER Q WITH HOOK
   --  LATIN SMALL LETTER DZ DIGRAPH
   --  LATIN SMALL LETTER DEZH DIGRAPH
   --  LATIN SMALL LETTER DZ DIGRAPH WITH CURL
   --  LATIN SMALL LETTER TS DIGRAPH
   --  LATIN SMALL LETTER TESH DIGRAPH
   --  LATIN SMALL LETTER TC DIGRAPH WITH CURL
   --  LATIN SMALL LETTER FENG DIGRAPH
   --  LATIN SMALL LETTER LS DIGRAPH
   --  LATIN SMALL LETTER LZ DIGRAPH
   --  LATIN SMALL LETTER TURNED H WITH FISHHOOK
   --  LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
   --  COMBINING LATIN SMALL LETTER A
   --  COMBINING LATIN SMALL LETTER E
   --  COMBINING LATIN SMALL LETTER I
   --  COMBINING LATIN SMALL LETTER O
   --  COMBINING LATIN SMALL LETTER U
   --  COMBINING LATIN SMALL LETTER C
   --  COMBINING LATIN SMALL LETTER D
   --  COMBINING LATIN SMALL LETTER H
   --  COMBINING LATIN SMALL LETTER M
   --  COMBINING LATIN SMALL LETTER R
   --  COMBINING LATIN SMALL LETTER T
   --  COMBINING LATIN SMALL LETTER V
   --  COMBINING LATIN SMALL LETTER X
   --  GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
   --  GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
   --  GREEK SMALL LETTER FINAL SIGMA
   --  GREEK SMALL LETTER CURLED BETA
   --  GREEK SMALL LETTER SCRIPT THETA
   --  GREEK SMALL LETTER SCRIPT PHI
   --  GREEK SMALL LETTER OMEGA PI
   --  GREEK SMALL LETTER ARCHAIC KOPPA
   --  GREEK SMALL LETTER SCRIPT KAPPA
   --  GREEK SMALL LETTER TAILED RHO
   --  GREEK SMALL LETTER LUNATE SIGMA
   --  GEORGIAN SMALL LETTER FI
   --  LIMBU SMALL LETTER KA
   --  LIMBU SMALL LETTER NGA
   --  LIMBU SMALL LETTER ANUSVARA
   --  LIMBU SMALL LETTER TA
   --  LIMBU SMALL LETTER NA
   --  LIMBU SMALL LETTER PA
   --  LIMBU SMALL LETTER MA
   --  LIMBU SMALL LETTER RA
   --  LIMBU SMALL LETTER LA
   --  LATIN SMALL LETTER TURNED AE
   --  LATIN SMALL LETTER TURNED OPEN E
   --  LATIN SMALL LETTER TURNED I
   --  LATIN SMALL LETTER SIDEWAYS O
   --  LATIN SMALL LETTER SIDEWAYS OPEN O
   --  LATIN SMALL LETTER SIDEWAYS O WITH STROKE
   --  LATIN SMALL LETTER TURNED OE
   --  LATIN SMALL LETTER TOP HALF O
   --  LATIN SMALL LETTER BOTTOM HALF O
   --  LATIN SMALL LETTER SIDEWAYS U
   --  LATIN SMALL LETTER SIDEWAYS DIAERESIZED U
   --  LATIN SMALL LETTER SIDEWAYS TURNED M
   --  LATIN SUBSCRIPT SMALL LETTER I
   --  LATIN SUBSCRIPT SMALL LETTER R
   --  LATIN SUBSCRIPT SMALL LETTER U
   --  LATIN SUBSCRIPT SMALL LETTER V
   --  GREEK SUBSCRIPT SMALL LETTER BETA
   --  GREEK SUBSCRIPT SMALL LETTER GAMMA
   --  GREEK SUBSCRIPT SMALL LETTER RHO
   --  GREEK SUBSCRIPT SMALL LETTER PHI
   --  GREEK SUBSCRIPT SMALL LETTER CHI
   --  LATIN SMALL LETTER UE
   --  LATIN SMALL LETTER H WITH LINE BELOW
   --  LATIN SMALL LETTER T WITH DIAERESIS
   --  LATIN SMALL LETTER W WITH RING ABOVE
   --  LATIN SMALL LETTER Y WITH RING ABOVE
   --  LATIN SMALL LETTER A WITH RIGHT HALF RING
   --  LATIN SMALL LETTER LONG S WITH DOT ABOVE
   --  GREEK SMALL LETTER UPSILON WITH PSILI
   --  GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
   --  GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
   --  GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
   --  GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ALPHA WITH PERISPOMENI
   --  GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER ETA WITH PERISPOMENI
   --  GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
   --  GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
   --  GREEK SMALL LETTER IOTA WITH PERISPOMENI
   --  GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
   --  GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
   --  GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
   --  GREEK SMALL LETTER RHO WITH PSILI
   --  GREEK SMALL LETTER UPSILON WITH PERISPOMENI
   --  GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
   --  GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
   --  GREEK SMALL LETTER OMEGA WITH PERISPOMENI
   --  GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
   --  SUPERSCRIPT LATIN SMALL LETTER I
   --  SUPERSCRIPT LATIN SMALL LETTER N
   --  TURNED GREEK SMALL LETTER IOTA
   --  PARENTHESIZED LATIN SMALL LETTER A
   --  PARENTHESIZED LATIN SMALL LETTER B
   --  PARENTHESIZED LATIN SMALL LETTER C
   --  PARENTHESIZED LATIN SMALL LETTER D
   --  PARENTHESIZED LATIN SMALL LETTER E
   --  PARENTHESIZED LATIN SMALL LETTER F
   --  PARENTHESIZED LATIN SMALL LETTER G
   --  PARENTHESIZED LATIN SMALL LETTER H
   --  PARENTHESIZED LATIN SMALL LETTER I
   --  PARENTHESIZED LATIN SMALL LETTER J
   --  PARENTHESIZED LATIN SMALL LETTER K
   --  PARENTHESIZED LATIN SMALL LETTER L
   --  PARENTHESIZED LATIN SMALL LETTER M
   --  PARENTHESIZED LATIN SMALL LETTER N
   --  PARENTHESIZED LATIN SMALL LETTER O
   --  PARENTHESIZED LATIN SMALL LETTER P
   --  PARENTHESIZED LATIN SMALL LETTER Q
   --  PARENTHESIZED LATIN SMALL LETTER R
   --  PARENTHESIZED LATIN SMALL LETTER S
   --  PARENTHESIZED LATIN SMALL LETTER T
   --  PARENTHESIZED LATIN SMALL LETTER U
   --  PARENTHESIZED LATIN SMALL LETTER V
   --  PARENTHESIZED LATIN SMALL LETTER W
   --  PARENTHESIZED LATIN SMALL LETTER X
   --  PARENTHESIZED LATIN SMALL LETTER Y
   --  PARENTHESIZED LATIN SMALL LETTER Z

   --  The following two tables define the mapping to lower case. The first
   --  table gives the ranges of upper case letters. The corresponding entry
   --  in Lower_Case_Adjust shows the amount to be added to (or subtracted from
   --  if the value is negative) the code value to get the corresponding lower
   --  case letter.

   --  An entry is in this table if its 10646 has the string CAPITAL LETTER
   --  the name, and there is a corresponding entry which has the string
   --  SMALL LETTER in its name.

   Upper_Case_Letters : constant UTF_32_Ranges := (
     (16#00041#, 16#0005A#),  -- LATIN CAPITAL LETTER A .. LATIN CAPITAL LETTER Z
     (16#000C0#, 16#000D6#),  -- LATIN CAPITAL LETTER A WITH GRAVE .. LATIN CAPITAL LETTER O WITH DIAERESIS
     (16#000D8#, 16#000DE#),  -- LATIN CAPITAL LETTER O WITH STROKE .. LATIN CAPITAL LETTER THORN
     (16#00100#, 16#00100#),  -- LATIN CAPITAL LETTER A WITH MACRON .. LATIN CAPITAL LETTER A WITH MACRON
     (16#00102#, 16#00102#),  -- LATIN CAPITAL LETTER A WITH BREVE .. LATIN CAPITAL LETTER A WITH BREVE
     (16#00104#, 16#00104#),  -- LATIN CAPITAL LETTER A WITH OGONEK .. LATIN CAPITAL LETTER A WITH OGONEK
     (16#00106#, 16#00106#),  -- LATIN CAPITAL LETTER C WITH ACUTE .. LATIN CAPITAL LETTER C WITH ACUTE
     (16#00108#, 16#00108#),  -- LATIN CAPITAL LETTER C WITH CIRCUMFLEX .. LATIN CAPITAL LETTER C WITH CIRCUMFLEX
     (16#0010A#, 16#0010A#),  -- LATIN CAPITAL LETTER C WITH DOT ABOVE .. LATIN CAPITAL LETTER C WITH DOT ABOVE
     (16#0010C#, 16#0010C#),  -- LATIN CAPITAL LETTER C WITH CARON .. LATIN CAPITAL LETTER C WITH CARON
     (16#0010E#, 16#0010E#),  -- LATIN CAPITAL LETTER D WITH CARON .. LATIN CAPITAL LETTER D WITH CARON
     (16#00110#, 16#00110#),  -- LATIN CAPITAL LETTER D WITH STROKE .. LATIN CAPITAL LETTER D WITH STROKE
     (16#00112#, 16#00112#),  -- LATIN CAPITAL LETTER E WITH MACRON .. LATIN CAPITAL LETTER E WITH MACRON
     (16#00114#, 16#00114#),  -- LATIN CAPITAL LETTER E WITH BREVE .. LATIN CAPITAL LETTER E WITH BREVE
     (16#00116#, 16#00116#),  -- LATIN CAPITAL LETTER E WITH DOT ABOVE .. LATIN CAPITAL LETTER E WITH DOT ABOVE
     (16#00118#, 16#00118#),  -- LATIN CAPITAL LETTER E WITH OGONEK .. LATIN CAPITAL LETTER E WITH OGONEK
     (16#0011A#, 16#0011A#),  -- LATIN CAPITAL LETTER E WITH CARON .. LATIN CAPITAL LETTER E WITH CARON
     (16#0011C#, 16#0011C#),  -- LATIN CAPITAL LETTER G WITH CIRCUMFLEX .. LATIN CAPITAL LETTER G WITH CIRCUMFLEX
     (16#0011E#, 16#0011E#),  -- LATIN CAPITAL LETTER G WITH BREVE .. LATIN CAPITAL LETTER G WITH BREVE
     (16#00120#, 16#00120#),  -- LATIN CAPITAL LETTER G WITH DOT ABOVE .. LATIN CAPITAL LETTER G WITH DOT ABOVE
     (16#00122#, 16#00122#),  -- LATIN CAPITAL LETTER G WITH CEDILLA .. LATIN CAPITAL LETTER G WITH CEDILLA
     (16#00124#, 16#00124#),  -- LATIN CAPITAL LETTER H WITH CIRCUMFLEX .. LATIN CAPITAL LETTER H WITH CIRCUMFLEX
     (16#00126#, 16#00126#),  -- LATIN CAPITAL LETTER H WITH STROKE .. LATIN CAPITAL LETTER H WITH STROKE
     (16#00128#, 16#00128#),  -- LATIN CAPITAL LETTER I WITH TILDE .. LATIN CAPITAL LETTER I WITH TILDE
     (16#0012A#, 16#0012A#),  -- LATIN CAPITAL LETTER I WITH MACRON .. LATIN CAPITAL LETTER I WITH MACRON
     (16#0012C#, 16#0012C#),  -- LATIN CAPITAL LETTER I WITH BREVE .. LATIN CAPITAL LETTER I WITH BREVE
     (16#0012E#, 16#0012E#),  -- LATIN CAPITAL LETTER I WITH OGONEK .. LATIN CAPITAL LETTER I WITH OGONEK
     (16#00132#, 16#00132#),  -- LATIN CAPITAL LETTER I J .. LATIN CAPITAL LETTER I J
     (16#00134#, 16#00134#),  -- LATIN CAPITAL LETTER J WITH CIRCUMFLEX .. LATIN CAPITAL LETTER J WITH CIRCUMFLEX
     (16#00136#, 16#00136#),  -- LATIN CAPITAL LETTER K WITH CEDILLA .. LATIN CAPITAL LETTER K WITH CEDILLA
     (16#00139#, 16#00139#),  -- LATIN CAPITAL LETTER L WITH ACUTE .. LATIN CAPITAL LETTER L WITH ACUTE
     (16#0013B#, 16#0013B#),  -- LATIN CAPITAL LETTER L WITH CEDILLA .. LATIN CAPITAL LETTER L WITH CEDILLA
     (16#0013D#, 16#0013D#),  -- LATIN CAPITAL LETTER L WITH CARON .. LATIN CAPITAL LETTER L WITH CARON
     (16#0013F#, 16#0013F#),  -- LATIN CAPITAL LETTER L WITH MIDDLE DOT .. LATIN CAPITAL LETTER L WITH MIDDLE DOT
     (16#00141#, 16#00141#),  -- LATIN CAPITAL LETTER L WITH STROKE .. LATIN CAPITAL LETTER L WITH STROKE
     (16#00143#, 16#00143#),  -- LATIN CAPITAL LETTER N WITH ACUTE .. LATIN CAPITAL LETTER N WITH ACUTE
     (16#00145#, 16#00145#),  -- LATIN CAPITAL LETTER N WITH CEDILLA .. LATIN CAPITAL LETTER N WITH CEDILLA
     (16#00147#, 16#00147#),  -- LATIN CAPITAL LETTER N WITH CARON .. LATIN CAPITAL LETTER N WITH CARON
     (16#0014A#, 16#0014A#),  -- LATIN CAPITAL LETTER ENG .. LATIN CAPITAL LETTER ENG
     (16#0014C#, 16#0014C#),  -- LATIN CAPITAL LETTER O WITH MACRON .. LATIN CAPITAL LETTER O WITH MACRON
     (16#0014E#, 16#0014E#),  -- LATIN CAPITAL LETTER O WITH BREVE .. LATIN CAPITAL LETTER O WITH BREVE
     (16#00150#, 16#00150#),  -- LATIN CAPITAL LETTER O WITH DOUBLE ACUTE .. LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
     (16#00152#, 16#00152#),  -- LATIN CAPITAL LETTER O E .. LATIN CAPITAL LETTER O E
     (16#00154#, 16#00154#),  -- LATIN CAPITAL LETTER R WITH ACUTE .. LATIN CAPITAL LETTER R WITH ACUTE
     (16#00156#, 16#00156#),  -- LATIN CAPITAL LETTER R WITH CEDILLA .. LATIN CAPITAL LETTER R WITH CEDILLA
     (16#00158#, 16#00158#),  -- LATIN CAPITAL LETTER R WITH CARON .. LATIN CAPITAL LETTER R WITH CARON
     (16#0015A#, 16#0015A#),  -- LATIN CAPITAL LETTER S WITH ACUTE .. LATIN CAPITAL LETTER S WITH ACUTE
     (16#0015C#, 16#0015C#),  -- LATIN CAPITAL LETTER S WITH CIRCUMFLEX .. LATIN CAPITAL LETTER S WITH CIRCUMFLEX
     (16#0015E#, 16#0015E#),  -- LATIN CAPITAL LETTER S WITH CEDILLA .. LATIN CAPITAL LETTER S WITH CEDILLA
     (16#00160#, 16#00160#),  -- LATIN CAPITAL LETTER S WITH CARON .. LATIN CAPITAL LETTER S WITH CARON
     (16#00162#, 16#00162#),  -- LATIN CAPITAL LETTER T WITH CEDILLA .. LATIN CAPITAL LETTER T WITH CEDILLA
     (16#00164#, 16#00164#),  -- LATIN CAPITAL LETTER T WITH CARON .. LATIN CAPITAL LETTER T WITH CARON
     (16#00166#, 16#00166#),  -- LATIN CAPITAL LETTER T WITH STROKE .. LATIN CAPITAL LETTER T WITH STROKE
     (16#00168#, 16#00168#),  -- LATIN CAPITAL LETTER U WITH TILDE .. LATIN CAPITAL LETTER U WITH TILDE
     (16#0016A#, 16#0016A#),  -- LATIN CAPITAL LETTER U WITH MACRON .. LATIN CAPITAL LETTER U WITH MACRON
     (16#0016C#, 16#0016C#),  -- LATIN CAPITAL LETTER U WITH BREVE .. LATIN CAPITAL LETTER U WITH BREVE
     (16#0016E#, 16#0016E#),  -- LATIN CAPITAL LETTER U WITH RING ABOVE .. LATIN CAPITAL LETTER U WITH RING ABOVE
     (16#00170#, 16#00170#),  -- LATIN CAPITAL LETTER U WITH DOUBLE ACUTE .. LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
     (16#00172#, 16#00172#),  -- LATIN CAPITAL LETTER U WITH OGONEK .. LATIN CAPITAL LETTER U WITH OGONEK
     (16#00174#, 16#00174#),  -- LATIN CAPITAL LETTER W WITH CIRCUMFLEX .. LATIN CAPITAL LETTER W WITH CIRCUMFLEX
     (16#00176#, 16#00176#),  -- LATIN CAPITAL LETTER Y WITH CIRCUMFLEX .. LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
     (16#00178#, 16#00178#),  -- LATIN CAPITAL LETTER Y WITH DIAERESIS .. LATIN CAPITAL LETTER Y WITH DIAERESIS
     (16#00179#, 16#00179#),  -- LATIN CAPITAL LETTER Z WITH ACUTE .. LATIN CAPITAL LETTER Z WITH ACUTE
     (16#0017B#, 16#0017B#),  -- LATIN CAPITAL LETTER Z WITH DOT ABOVE .. LATIN CAPITAL LETTER Z WITH DOT ABOVE
     (16#0017D#, 16#0017D#),  -- LATIN CAPITAL LETTER Z WITH CARON .. LATIN CAPITAL LETTER Z WITH CARON
     (16#00181#, 16#00181#),  -- LATIN CAPITAL LETTER B WITH HOOK .. LATIN CAPITAL LETTER B WITH HOOK
     (16#00182#, 16#00182#),  -- LATIN CAPITAL LETTER B WITH TOPBAR .. LATIN CAPITAL LETTER B WITH TOPBAR
     (16#00184#, 16#00184#),  -- LATIN CAPITAL LETTER TONE SIX .. LATIN CAPITAL LETTER TONE SIX
     (16#00186#, 16#00186#),  -- LATIN CAPITAL LETTER OPEN O .. LATIN CAPITAL LETTER OPEN O
     (16#00187#, 16#00187#),  -- LATIN CAPITAL LETTER C WITH HOOK .. LATIN CAPITAL LETTER C WITH HOOK
     (16#0018A#, 16#0018A#),  -- LATIN CAPITAL LETTER D WITH HOOK .. LATIN CAPITAL LETTER D WITH HOOK
     (16#0018B#, 16#0018B#),  -- LATIN CAPITAL LETTER D WITH TOPBAR .. LATIN CAPITAL LETTER D WITH TOPBAR
     (16#0018E#, 16#0018F#),  -- LATIN CAPITAL LETTER REVERSED E .. LATIN CAPITAL LETTER SCHWA
     (16#00190#, 16#00190#),  -- LATIN CAPITAL LETTER OPEN E .. LATIN CAPITAL LETTER OPEN E
     (16#00191#, 16#00191#),  -- LATIN CAPITAL LETTER F WITH HOOK .. LATIN CAPITAL LETTER F WITH HOOK
     (16#00193#, 16#00193#),  -- LATIN CAPITAL LETTER G WITH HOOK .. LATIN CAPITAL LETTER G WITH HOOK
     (16#00194#, 16#00194#),  -- LATIN CAPITAL LETTER GAMMA .. LATIN CAPITAL LETTER GAMMA
     (16#00196#, 16#00196#),  -- LATIN CAPITAL LETTER IOTA .. LATIN CAPITAL LETTER IOTA
     (16#00197#, 16#00197#),  -- LATIN CAPITAL LETTER I WITH STROKE .. LATIN CAPITAL LETTER I WITH STROKE
     (16#00198#, 16#00198#),  -- LATIN CAPITAL LETTER K WITH HOOK .. LATIN CAPITAL LETTER K WITH HOOK
     (16#0019C#, 16#0019C#),  -- LATIN CAPITAL LETTER TURNED M .. LATIN CAPITAL LETTER TURNED M
     (16#0019D#, 16#0019D#),  -- LATIN CAPITAL LETTER N WITH LEFT HOOK .. LATIN CAPITAL LETTER N WITH LEFT HOOK
     (16#001A0#, 16#001A0#),  -- LATIN CAPITAL LETTER O WITH HORN .. LATIN CAPITAL LETTER O WITH HORN
     (16#001A2#, 16#001A2#),  -- LATIN CAPITAL LETTER OI .. LATIN CAPITAL LETTER OI
     (16#001A4#, 16#001A4#),  -- LATIN CAPITAL LETTER P WITH HOOK .. LATIN CAPITAL LETTER P WITH HOOK
     (16#001A7#, 16#001A7#),  -- LATIN CAPITAL LETTER TONE TWO .. LATIN CAPITAL LETTER TONE TWO
     (16#001A9#, 16#001A9#),  -- LATIN CAPITAL LETTER ESH .. LATIN CAPITAL LETTER ESH
     (16#001AC#, 16#001AC#),  -- LATIN CAPITAL LETTER T WITH HOOK .. LATIN CAPITAL LETTER T WITH HOOK
     (16#001AE#, 16#001AE#),  -- LATIN CAPITAL LETTER T WITH RETROFLEX HOOK .. LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
     (16#001AF#, 16#001AF#),  -- LATIN CAPITAL LETTER U WITH HORN .. LATIN CAPITAL LETTER U WITH HORN
     (16#001B1#, 16#001B2#),  -- LATIN CAPITAL LETTER UPSILON .. LATIN CAPITAL LETTER V WITH HOOK
     (16#001B3#, 16#001B3#),  -- LATIN CAPITAL LETTER Y WITH HOOK .. LATIN CAPITAL LETTER Y WITH HOOK
     (16#001B5#, 16#001B5#),  -- LATIN CAPITAL LETTER Z WITH STROKE .. LATIN CAPITAL LETTER Z WITH STROKE
     (16#001B7#, 16#001B7#),  -- LATIN CAPITAL LETTER EZH .. LATIN CAPITAL LETTER EZH
     (16#001B8#, 16#001B8#),  -- LATIN CAPITAL LETTER EZH REVERSED .. LATIN CAPITAL LETTER EZH REVERSED
     (16#001BC#, 16#001BC#),  -- LATIN CAPITAL LETTER TONE FIVE .. LATIN CAPITAL LETTER TONE FIVE
     (16#001C4#, 16#001C4#),  -- LATIN CAPITAL LETTER DZ WITH CARON .. LATIN CAPITAL LETTER DZ WITH CARON
     (16#001C7#, 16#001C7#),  -- LATIN CAPITAL LETTER LJ .. LATIN CAPITAL LETTER LJ
     (16#001CA#, 16#001CA#),  -- LATIN CAPITAL LETTER NJ .. LATIN CAPITAL LETTER NJ
     (16#001CD#, 16#001CD#),  -- LATIN CAPITAL LETTER A WITH CARON .. LATIN CAPITAL LETTER A WITH CARON
     (16#001CF#, 16#001CF#),  -- LATIN CAPITAL LETTER I WITH CARON .. LATIN CAPITAL LETTER I WITH CARON
     (16#001D1#, 16#001D1#),  -- LATIN CAPITAL LETTER O WITH CARON .. LATIN CAPITAL LETTER O WITH CARON
     (16#001D3#, 16#001D3#),  -- LATIN CAPITAL LETTER U WITH CARON .. LATIN CAPITAL LETTER U WITH CARON
     (16#001D5#, 16#001D5#),  -- LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
     (16#001D7#, 16#001D7#),  -- LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE .. LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
     (16#001D9#, 16#001D9#),  -- LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON .. LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
     (16#001DB#, 16#001DB#),  -- LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE .. LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
     (16#001DE#, 16#001DE#),  -- LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
     (16#001E0#, 16#001E0#),  -- LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON .. LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
     (16#001E2#, 16#001E2#),  -- LATIN CAPITAL LETTER AE WITH MACRON .. LATIN CAPITAL LETTER AE WITH MACRON
     (16#001E4#, 16#001E4#),  -- LATIN CAPITAL LETTER G WITH STROKE .. LATIN CAPITAL LETTER G WITH STROKE
     (16#001E6#, 16#001E6#),  -- LATIN CAPITAL LETTER G WITH CARON .. LATIN CAPITAL LETTER G WITH CARON
     (16#001E8#, 16#001E8#),  -- LATIN CAPITAL LETTER K WITH CARON .. LATIN CAPITAL LETTER K WITH CARON
     (16#001EA#, 16#001EA#),  -- LATIN CAPITAL LETTER O WITH OGONEK .. LATIN CAPITAL LETTER O WITH OGONEK
     (16#001EC#, 16#001EC#),  -- LATIN CAPITAL LETTER O WITH OGONEK AND MACRON .. LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
     (16#001EE#, 16#001EE#),  -- LATIN CAPITAL LETTER EZH WITH CARON .. LATIN CAPITAL LETTER EZH WITH CARON
     (16#001F1#, 16#001F1#),  -- LATIN CAPITAL LETTER DZ .. LATIN CAPITAL LETTER DZ
     (16#001F4#, 16#001F4#),  -- LATIN CAPITAL LETTER G WITH ACUTE .. LATIN CAPITAL LETTER G WITH ACUTE
     (16#001F8#, 16#001F8#),  -- LATIN CAPITAL LETTER N WITH GRAVE .. LATIN CAPITAL LETTER N WITH GRAVE
     (16#001FA#, 16#001FA#),  -- LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE .. LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
     (16#001FC#, 16#001FC#),  -- LATIN CAPITAL LETTER AE WITH ACUTE .. LATIN CAPITAL LETTER AE WITH ACUTE
     (16#001FE#, 16#001FE#),  -- LATIN CAPITAL LETTER O WITH STROKE AND ACUTE .. LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
     (16#00200#, 16#00200#),  -- LATIN CAPITAL LETTER A WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
     (16#00202#, 16#00202#),  -- LATIN CAPITAL LETTER A WITH INVERTED BREVE .. LATIN CAPITAL LETTER A WITH INVERTED BREVE
     (16#00204#, 16#00204#),  -- LATIN CAPITAL LETTER E WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
     (16#00206#, 16#00206#),  -- LATIN CAPITAL LETTER E WITH INVERTED BREVE .. LATIN CAPITAL LETTER E WITH INVERTED BREVE
     (16#00208#, 16#00208#),  -- LATIN CAPITAL LETTER I WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
     (16#0020A#, 16#0020A#),  -- LATIN CAPITAL LETTER I WITH INVERTED BREVE .. LATIN CAPITAL LETTER I WITH INVERTED BREVE
     (16#0020C#, 16#0020C#),  -- LATIN CAPITAL LETTER O WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
     (16#0020E#, 16#0020E#),  -- LATIN CAPITAL LETTER O WITH INVERTED BREVE .. LATIN CAPITAL LETTER O WITH INVERTED BREVE
     (16#00210#, 16#00210#),  -- LATIN CAPITAL LETTER R WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
     (16#00212#, 16#00212#),  -- LATIN CAPITAL LETTER R WITH INVERTED BREVE .. LATIN CAPITAL LETTER R WITH INVERTED BREVE
     (16#00214#, 16#00214#),  -- LATIN CAPITAL LETTER U WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
     (16#00216#, 16#00216#),  -- LATIN CAPITAL LETTER U WITH INVERTED BREVE .. LATIN CAPITAL LETTER U WITH INVERTED BREVE
     (16#00218#, 16#00218#),  -- LATIN CAPITAL LETTER S WITH COMMA BELOW .. LATIN CAPITAL LETTER S WITH COMMA BELOW
     (16#0021A#, 16#0021A#),  -- LATIN CAPITAL LETTER T WITH COMMA BELOW .. LATIN CAPITAL LETTER T WITH COMMA BELOW
     (16#0021C#, 16#0021C#),  -- LATIN CAPITAL LETTER YOGH .. LATIN CAPITAL LETTER YOGH
     (16#0021E#, 16#0021E#),  -- LATIN CAPITAL LETTER H WITH CARON .. LATIN CAPITAL LETTER H WITH CARON
     (16#00220#, 16#00220#),  -- LATIN CAPITAL LETTER N WITH LONG RIGHT LEG .. LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
     (16#00222#, 16#00222#),  -- LATIN CAPITAL LETTER OU .. LATIN CAPITAL LETTER OU
     (16#00224#, 16#00224#),  -- LATIN CAPITAL LETTER Z WITH HOOK .. LATIN CAPITAL LETTER Z WITH HOOK
     (16#00226#, 16#00226#),  -- LATIN CAPITAL LETTER A WITH DOT ABOVE .. LATIN CAPITAL LETTER A WITH DOT ABOVE
     (16#00228#, 16#00228#),  -- LATIN CAPITAL LETTER E WITH CEDILLA .. LATIN CAPITAL LETTER E WITH CEDILLA
     (16#0022A#, 16#0022A#),  -- LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
     (16#0022C#, 16#0022C#),  -- LATIN CAPITAL LETTER O WITH TILDE AND MACRON .. LATIN CAPITAL LETTER O WITH TILDE AND MACRON
     (16#0022E#, 16#0022E#),  -- LATIN CAPITAL LETTER O WITH DOT ABOVE .. LATIN CAPITAL LETTER O WITH DOT ABOVE
     (16#00230#, 16#00230#),  -- LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON .. LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
     (16#00232#, 16#00232#),  -- LATIN CAPITAL LETTER Y WITH MACRON .. LATIN CAPITAL LETTER Y WITH MACRON
     (16#00386#, 16#00386#),  -- GREEK CAPITAL LETTER ALPHA WITH TONOS .. GREEK CAPITAL LETTER ALPHA WITH TONOS
     (16#00388#, 16#0038A#),  -- GREEK CAPITAL LETTER EPSILON WITH TONOS .. GREEK CAPITAL LETTER IOTA WITH TONOS
     (16#0038C#, 16#0038C#),  -- GREEK CAPITAL LETTER OMICRON WITH TONOS .. GREEK CAPITAL LETTER OMICRON WITH TONOS
     (16#0038E#, 16#0038F#),  -- GREEK CAPITAL LETTER UPSILON WITH TONOS .. GREEK CAPITAL LETTER OMEGA WITH TONOS
     (16#00391#, 16#003A1#),  -- GREEK CAPITAL LETTER ALPHA .. GREEK CAPITAL LETTER RHO
     (16#003A3#, 16#003AB#),  -- GREEK CAPITAL LETTER SIGMA .. GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
     (16#003DA#, 16#003DA#),  -- GREEK CAPITAL LETTER STIGMA .. GREEK CAPITAL LETTER STIGMA
     (16#003DC#, 16#003DC#),  -- GREEK CAPITAL LETTER DIGAMMA .. GREEK CAPITAL LETTER DIGAMMA
     (16#003DE#, 16#003DE#),  -- GREEK CAPITAL LETTER KOPPA .. GREEK CAPITAL LETTER KOPPA
     (16#003E0#, 16#003E0#),  -- GREEK CAPITAL LETTER SAMPI .. GREEK CAPITAL LETTER SAMPI
     (16#003E2#, 16#003E2#),  -- COPTIC CAPITAL LETTER SHEI .. COPTIC CAPITAL LETTER SHEI
     (16#003E4#, 16#003E4#),  -- COPTIC CAPITAL LETTER FEI .. COPTIC CAPITAL LETTER FEI
     (16#003E6#, 16#003E6#),  -- COPTIC CAPITAL LETTER KHEI .. COPTIC CAPITAL LETTER KHEI
     (16#003E8#, 16#003E8#),  -- COPTIC CAPITAL LETTER HORI .. COPTIC CAPITAL LETTER HORI
     (16#003EA#, 16#003EA#),  -- COPTIC CAPITAL LETTER GANGIA .. COPTIC CAPITAL LETTER GANGIA
     (16#003EC#, 16#003EC#),  -- COPTIC CAPITAL LETTER SHIMA .. COPTIC CAPITAL LETTER SHIMA
     (16#003EE#, 16#003EE#),  -- COPTIC CAPITAL LETTER DEI .. COPTIC CAPITAL LETTER DEI
     (16#003F7#, 16#003F7#),  -- GREEK CAPITAL LETTER SHO .. GREEK CAPITAL LETTER SHO
     (16#003FA#, 16#003FA#),  -- GREEK CAPITAL LETTER SAN .. GREEK CAPITAL LETTER SAN
     (16#00400#, 16#0040F#),  -- CYRILLIC CAPITAL LETTER IE WITH GRAVE .. CYRILLIC CAPITAL LETTER DZHE
     (16#00410#, 16#0042F#),  -- CYRILLIC CAPITAL LETTER A .. CYRILLIC CAPITAL LETTER YA
     (16#00460#, 16#00460#),  -- CYRILLIC CAPITAL LETTER OMEGA .. CYRILLIC CAPITAL LETTER OMEGA
     (16#00462#, 16#00462#),  -- CYRILLIC CAPITAL LETTER YAT .. CYRILLIC CAPITAL LETTER YAT
     (16#00464#, 16#00464#),  -- CYRILLIC CAPITAL LETTER IOTIFIED E .. CYRILLIC CAPITAL LETTER IOTIFIED E
     (16#00466#, 16#00466#),  -- CYRILLIC CAPITAL LETTER LITTLE YUS .. CYRILLIC CAPITAL LETTER LITTLE YUS
     (16#00468#, 16#00468#),  -- CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS .. CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
     (16#0046A#, 16#0046A#),  -- CYRILLIC CAPITAL LETTER BIG YUS .. CYRILLIC CAPITAL LETTER BIG YUS
     (16#0046C#, 16#0046C#),  -- CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS .. CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
     (16#0046E#, 16#0046E#),  -- CYRILLIC CAPITAL LETTER KSI .. CYRILLIC CAPITAL LETTER KSI
     (16#00470#, 16#00470#),  -- CYRILLIC CAPITAL LETTER PSI .. CYRILLIC CAPITAL LETTER PSI
     (16#00472#, 16#00472#),  -- CYRILLIC CAPITAL LETTER FITA .. CYRILLIC CAPITAL LETTER FITA
     (16#00474#, 16#00474#),  -- CYRILLIC CAPITAL LETTER IZHITSA .. CYRILLIC CAPITAL LETTER IZHITSA
     (16#00476#, 16#00476#),  -- CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
     (16#00478#, 16#00478#),  -- CYRILLIC CAPITAL LETTER UK .. CYRILLIC CAPITAL LETTER UK
     (16#0047A#, 16#0047A#),  -- CYRILLIC CAPITAL LETTER ROUND OMEGA .. CYRILLIC CAPITAL LETTER ROUND OMEGA
     (16#0047C#, 16#0047C#),  -- CYRILLIC CAPITAL LETTER OMEGA WITH TITLO .. CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
     (16#0047E#, 16#0047E#),  -- CYRILLIC CAPITAL LETTER OT .. CYRILLIC CAPITAL LETTER OT
     (16#00480#, 16#00480#),  -- CYRILLIC CAPITAL LETTER KOPPA .. CYRILLIC CAPITAL LETTER KOPPA
     (16#0048A#, 16#0048A#),  -- CYRILLIC CAPITAL LETTER SHORT I WITH TAIL .. CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
     (16#0048C#, 16#0048C#),  -- CYRILLIC CAPITAL LETTER SEMISOFT SIGN .. CYRILLIC CAPITAL LETTER SEMISOFT SIGN
     (16#0048E#, 16#0048E#),  -- CYRILLIC CAPITAL LETTER ER WITH TICK .. CYRILLIC CAPITAL LETTER ER WITH TICK
     (16#00490#, 16#00490#),  -- CYRILLIC CAPITAL LETTER GHE WITH UPTURN .. CYRILLIC CAPITAL LETTER GHE WITH UPTURN
     (16#00492#, 16#00492#),  -- CYRILLIC CAPITAL LETTER GHE WITH STROKE .. CYRILLIC CAPITAL LETTER GHE WITH STROKE
     (16#00494#, 16#00494#),  -- CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
     (16#00496#, 16#00496#),  -- CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
     (16#00498#, 16#00498#),  -- CYRILLIC CAPITAL LETTER ZE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
     (16#0049A#, 16#0049A#),  -- CYRILLIC CAPITAL LETTER KA WITH DESCENDER .. CYRILLIC CAPITAL LETTER KA WITH DESCENDER
     (16#0049C#, 16#0049C#),  -- CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE .. CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
     (16#0049E#, 16#0049E#),  -- CYRILLIC CAPITAL LETTER KA WITH STROKE .. CYRILLIC CAPITAL LETTER KA WITH STROKE
     (16#004A0#, 16#004A0#),  -- CYRILLIC CAPITAL LETTER BASHKIR KA .. CYRILLIC CAPITAL LETTER BASHKIR KA
     (16#004A2#, 16#004A2#),  -- CYRILLIC CAPITAL LETTER EN WITH DESCENDER .. CYRILLIC CAPITAL LETTER EN WITH DESCENDER
     (16#004A4#, 16#004A4#),  -- CYRILLIC CAPITAL LETTER EN GE .. CYRILLIC CAPITAL LETTER EN GE
     (16#004A6#, 16#004A6#),  -- CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK .. CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
     (16#004A8#, 16#004A8#),  -- CYRILLIC CAPITAL LETTER ABKHASIAN HA .. CYRILLIC CAPITAL LETTER ABKHASIAN HA
     (16#004AA#, 16#004AA#),  -- CYRILLIC CAPITAL LETTER ES WITH DESCENDER .. CYRILLIC CAPITAL LETTER ES WITH DESCENDER
     (16#004AC#, 16#004AC#),  -- CYRILLIC CAPITAL LETTER TE WITH DESCENDER .. CYRILLIC CAPITAL LETTER TE WITH DESCENDER
     (16#004AE#, 16#004AE#),  -- CYRILLIC CAPITAL LETTER STRAIGHT U .. CYRILLIC CAPITAL LETTER STRAIGHT U
     (16#004B0#, 16#004B0#),  -- CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE .. CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
     (16#004B2#, 16#004B2#),  -- CYRILLIC CAPITAL LETTER HA WITH DESCENDER .. CYRILLIC CAPITAL LETTER HA WITH DESCENDER
     (16#004B4#, 16#004B4#),  -- CYRILLIC CAPITAL LETTER TE TSE .. CYRILLIC CAPITAL LETTER TE TSE
     (16#004B6#, 16#004B6#),  -- CYRILLIC CAPITAL LETTER CHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
     (16#004B8#, 16#004B8#),  -- CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
     (16#004BA#, 16#004BA#),  -- CYRILLIC CAPITAL LETTER SHHA .. CYRILLIC CAPITAL LETTER SHHA
     (16#004BC#, 16#004BC#),  -- CYRILLIC CAPITAL LETTER ABKHASIAN CHE .. CYRILLIC CAPITAL LETTER ABKHASIAN CHE
     (16#004BE#, 16#004BE#),  -- CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
     (16#004C1#, 16#004C1#),  -- CYRILLIC CAPITAL LETTER ZHE WITH BREVE .. CYRILLIC CAPITAL LETTER ZHE WITH BREVE
     (16#004C3#, 16#004C3#),  -- CYRILLIC CAPITAL LETTER KA WITH HOOK .. CYRILLIC CAPITAL LETTER KA WITH HOOK
     (16#004C5#, 16#004C5#),  -- CYRILLIC CAPITAL LETTER EL WITH TAIL .. CYRILLIC CAPITAL LETTER EL WITH TAIL
     (16#004C7#, 16#004C7#),  -- CYRILLIC CAPITAL LETTER EN WITH HOOK .. CYRILLIC CAPITAL LETTER EN WITH HOOK
     (16#004C9#, 16#004C9#),  -- CYRILLIC CAPITAL LETTER EN WITH TAIL .. CYRILLIC CAPITAL LETTER EN WITH TAIL
     (16#004CB#, 16#004CB#),  -- CYRILLIC CAPITAL LETTER KHAKASSIAN CHE .. CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
     (16#004CD#, 16#004CD#),  -- CYRILLIC CAPITAL LETTER EM WITH TAIL .. CYRILLIC CAPITAL LETTER EM WITH TAIL
     (16#004D0#, 16#004D0#),  -- CYRILLIC CAPITAL LETTER A WITH BREVE .. CYRILLIC CAPITAL LETTER A WITH BREVE
     (16#004D2#, 16#004D2#),  -- CYRILLIC CAPITAL LETTER A WITH DIAERESIS .. CYRILLIC CAPITAL LETTER A WITH DIAERESIS
     (16#004D6#, 16#004D6#),  -- CYRILLIC CAPITAL LETTER IE WITH BREVE .. CYRILLIC CAPITAL LETTER IE WITH BREVE
     (16#004D8#, 16#004D8#),  -- CYRILLIC CAPITAL LETTER SCHWA .. CYRILLIC CAPITAL LETTER SCHWA
     (16#004DA#, 16#004DA#),  -- CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS .. CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
     (16#004DC#, 16#004DC#),  -- CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
     (16#004DE#, 16#004DE#),  -- CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
     (16#004E0#, 16#004E0#),  -- CYRILLIC CAPITAL LETTER ABKHASIAN DZE .. CYRILLIC CAPITAL LETTER ABKHASIAN DZE
     (16#004E2#, 16#004E2#),  -- CYRILLIC CAPITAL LETTER I WITH MACRON .. CYRILLIC CAPITAL LETTER I WITH MACRON
     (16#004E4#, 16#004E4#),  -- CYRILLIC CAPITAL LETTER I WITH DIAERESIS .. CYRILLIC CAPITAL LETTER I WITH DIAERESIS
     (16#004E6#, 16#004E6#),  -- CYRILLIC CAPITAL LETTER O WITH DIAERESIS .. CYRILLIC CAPITAL LETTER O WITH DIAERESIS
     (16#004E8#, 16#004E8#),  -- CYRILLIC CAPITAL LETTER BARRED O .. CYRILLIC CAPITAL LETTER BARRED O
     (16#004EA#, 16#004EA#),  -- CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS .. CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
     (16#004EC#, 16#004EC#),  -- CYRILLIC CAPITAL LETTER E WITH DIAERESIS .. CYRILLIC CAPITAL LETTER E WITH DIAERESIS
     (16#004EE#, 16#004EE#),  -- CYRILLIC CAPITAL LETTER U WITH MACRON .. CYRILLIC CAPITAL LETTER U WITH MACRON
     (16#004F0#, 16#004F0#),  -- CYRILLIC CAPITAL LETTER U WITH DIAERESIS .. CYRILLIC CAPITAL LETTER U WITH DIAERESIS
     (16#004F2#, 16#004F2#),  -- CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE .. CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
     (16#004F4#, 16#004F4#),  -- CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
     (16#004F8#, 16#004F8#),  -- CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS .. CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
     (16#00500#, 16#00500#),  -- CYRILLIC CAPITAL LETTER KOMI DE .. CYRILLIC CAPITAL LETTER KOMI DE
     (16#00502#, 16#00502#),  -- CYRILLIC CAPITAL LETTER KOMI DJE .. CYRILLIC CAPITAL LETTER KOMI DJE
     (16#00504#, 16#00504#),  -- CYRILLIC CAPITAL LETTER KOMI ZJE .. CYRILLIC CAPITAL LETTER KOMI ZJE
     (16#00506#, 16#00506#),  -- CYRILLIC CAPITAL LETTER KOMI DZJE .. CYRILLIC CAPITAL LETTER KOMI DZJE
     (16#00508#, 16#00508#),  -- CYRILLIC CAPITAL LETTER KOMI LJE .. CYRILLIC CAPITAL LETTER KOMI LJE
     (16#0050A#, 16#0050A#),  -- CYRILLIC CAPITAL LETTER KOMI NJE .. CYRILLIC CAPITAL LETTER KOMI NJE
     (16#0050C#, 16#0050C#),  -- CYRILLIC CAPITAL LETTER KOMI SJE .. CYRILLIC CAPITAL LETTER KOMI SJE
     (16#0050E#, 16#0050E#),  -- CYRILLIC CAPITAL LETTER KOMI TJE .. CYRILLIC CAPITAL LETTER KOMI TJE
     (16#00531#, 16#00556#),  -- ARMENIAN CAPITAL LETTER AYB .. ARMENIAN CAPITAL LETTER FEH
     (16#010A0#, 16#010C5#),  -- GEORGIAN CAPITAL LETTER AN .. GEORGIAN CAPITAL LETTER HOE
     (16#01E00#, 16#01E00#),  -- LATIN CAPITAL LETTER A WITH RING BELOW .. LATIN CAPITAL LETTER A WITH RING BELOW
     (16#01E02#, 16#01E02#),  -- LATIN CAPITAL LETTER B WITH DOT ABOVE .. LATIN CAPITAL LETTER B WITH DOT ABOVE
     (16#01E04#, 16#01E04#),  -- LATIN CAPITAL LETTER B WITH DOT BELOW .. LATIN CAPITAL LETTER B WITH DOT BELOW
     (16#01E06#, 16#01E06#),  -- LATIN CAPITAL LETTER B WITH LINE BELOW .. LATIN CAPITAL LETTER B WITH LINE BELOW
     (16#01E08#, 16#01E08#),  -- LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE .. LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
     (16#01E0A#, 16#01E0A#),  -- LATIN CAPITAL LETTER D WITH DOT ABOVE .. LATIN CAPITAL LETTER D WITH DOT ABOVE
     (16#01E0C#, 16#01E0C#),  -- LATIN CAPITAL LETTER D WITH DOT BELOW .. LATIN CAPITAL LETTER D WITH DOT BELOW
     (16#01E0E#, 16#01E0E#),  -- LATIN CAPITAL LETTER D WITH LINE BELOW .. LATIN CAPITAL LETTER D WITH LINE BELOW
     (16#01E10#, 16#01E10#),  -- LATIN CAPITAL LETTER D WITH CEDILLA .. LATIN CAPITAL LETTER D WITH CEDILLA
     (16#01E12#, 16#01E12#),  -- LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
     (16#01E14#, 16#01E14#),  -- LATIN CAPITAL LETTER E WITH MACRON AND GRAVE .. LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
     (16#01E16#, 16#01E16#),  -- LATIN CAPITAL LETTER E WITH MACRON AND ACUTE .. LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
     (16#01E18#, 16#01E18#),  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
     (16#01E1A#, 16#01E1A#),  -- LATIN CAPITAL LETTER E WITH TILDE BELOW .. LATIN CAPITAL LETTER E WITH TILDE BELOW
     (16#01E1C#, 16#01E1C#),  -- LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE .. LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
     (16#01E1E#, 16#01E1E#),  -- LATIN CAPITAL LETTER F WITH DOT ABOVE .. LATIN CAPITAL LETTER F WITH DOT ABOVE
     (16#01E20#, 16#01E20#),  -- LATIN CAPITAL LETTER G WITH MACRON .. LATIN CAPITAL LETTER G WITH MACRON
     (16#01E22#, 16#01E22#),  -- LATIN CAPITAL LETTER H WITH DOT ABOVE .. LATIN CAPITAL LETTER H WITH DOT ABOVE
     (16#01E24#, 16#01E24#),  -- LATIN CAPITAL LETTER H WITH DOT BELOW .. LATIN CAPITAL LETTER H WITH DOT BELOW
     (16#01E26#, 16#01E26#),  -- LATIN CAPITAL LETTER H WITH DIAERESIS .. LATIN CAPITAL LETTER H WITH DIAERESIS
     (16#01E28#, 16#01E28#),  -- LATIN CAPITAL LETTER H WITH CEDILLA .. LATIN CAPITAL LETTER H WITH CEDILLA
     (16#01E2A#, 16#01E2A#),  -- LATIN CAPITAL LETTER H WITH BREVE BELOW .. LATIN CAPITAL LETTER H WITH BREVE BELOW
     (16#01E2C#, 16#01E2C#),  -- LATIN CAPITAL LETTER I WITH TILDE BELOW .. LATIN CAPITAL LETTER I WITH TILDE BELOW
     (16#01E2E#, 16#01E2E#),  -- LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE .. LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
     (16#01E30#, 16#01E30#),  -- LATIN CAPITAL LETTER K WITH ACUTE .. LATIN CAPITAL LETTER K WITH ACUTE
     (16#01E32#, 16#01E32#),  -- LATIN CAPITAL LETTER K WITH DOT BELOW .. LATIN CAPITAL LETTER K WITH DOT BELOW
     (16#01E34#, 16#01E34#),  -- LATIN CAPITAL LETTER K WITH LINE BELOW .. LATIN CAPITAL LETTER K WITH LINE BELOW
     (16#01E36#, 16#01E36#),  -- LATIN CAPITAL LETTER L WITH DOT BELOW .. LATIN CAPITAL LETTER L WITH DOT BELOW
     (16#01E38#, 16#01E38#),  -- LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON .. LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
     (16#01E3A#, 16#01E3A#),  -- LATIN CAPITAL LETTER L WITH LINE BELOW .. LATIN CAPITAL LETTER L WITH LINE BELOW
     (16#01E3C#, 16#01E3C#),  -- LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
     (16#01E3E#, 16#01E3E#),  -- LATIN CAPITAL LETTER M WITH ACUTE .. LATIN CAPITAL LETTER M WITH ACUTE
     (16#01E40#, 16#01E40#),  -- LATIN CAPITAL LETTER M WITH DOT ABOVE .. LATIN CAPITAL LETTER M WITH DOT ABOVE
     (16#01E42#, 16#01E42#),  -- LATIN CAPITAL LETTER M WITH DOT BELOW .. LATIN CAPITAL LETTER M WITH DOT BELOW
     (16#01E44#, 16#01E44#),  -- LATIN CAPITAL LETTER N WITH DOT ABOVE .. LATIN CAPITAL LETTER N WITH DOT ABOVE
     (16#01E46#, 16#01E46#),  -- LATIN CAPITAL LETTER N WITH DOT BELOW .. LATIN CAPITAL LETTER N WITH DOT BELOW
     (16#01E48#, 16#01E48#),  -- LATIN CAPITAL LETTER N WITH LINE BELOW .. LATIN CAPITAL LETTER N WITH LINE BELOW
     (16#01E4A#, 16#01E4A#),  -- LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
     (16#01E4C#, 16#01E4C#),  -- LATIN CAPITAL LETTER O WITH TILDE AND ACUTE .. LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
     (16#01E4E#, 16#01E4E#),  -- LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS .. LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
     (16#01E50#, 16#01E50#),  -- LATIN CAPITAL LETTER O WITH MACRON AND GRAVE .. LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
     (16#01E52#, 16#01E52#),  -- LATIN CAPITAL LETTER O WITH MACRON AND ACUTE .. LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
     (16#01E54#, 16#01E54#),  -- LATIN CAPITAL LETTER P WITH ACUTE .. LATIN CAPITAL LETTER P WITH ACUTE
     (16#01E56#, 16#01E56#),  -- LATIN CAPITAL LETTER P WITH DOT ABOVE .. LATIN CAPITAL LETTER P WITH DOT ABOVE
     (16#01E58#, 16#01E58#),  -- LATIN CAPITAL LETTER R WITH DOT ABOVE .. LATIN CAPITAL LETTER R WITH DOT ABOVE
     (16#01E5A#, 16#01E5A#),  -- LATIN CAPITAL LETTER R WITH DOT BELOW .. LATIN CAPITAL LETTER R WITH DOT BELOW
     (16#01E5C#, 16#01E5C#),  -- LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON .. LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
     (16#01E5E#, 16#01E5E#),  -- LATIN CAPITAL LETTER R WITH LINE BELOW .. LATIN CAPITAL LETTER R WITH LINE BELOW
     (16#01E60#, 16#01E60#),  -- LATIN CAPITAL LETTER S WITH DOT ABOVE .. LATIN CAPITAL LETTER S WITH DOT ABOVE
     (16#01E62#, 16#01E62#),  -- LATIN CAPITAL LETTER S WITH DOT BELOW .. LATIN CAPITAL LETTER S WITH DOT BELOW
     (16#01E64#, 16#01E64#),  -- LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
     (16#01E66#, 16#01E66#),  -- LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
     (16#01E68#, 16#01E68#),  -- LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
     (16#01E6A#, 16#01E6A#),  -- LATIN CAPITAL LETTER T WITH DOT ABOVE .. LATIN CAPITAL LETTER T WITH DOT ABOVE
     (16#01E6C#, 16#01E6C#),  -- LATIN CAPITAL LETTER T WITH DOT BELOW .. LATIN CAPITAL LETTER T WITH DOT BELOW
     (16#01E6E#, 16#01E6E#),  -- LATIN CAPITAL LETTER T WITH LINE BELOW .. LATIN CAPITAL LETTER T WITH LINE BELOW
     (16#01E70#, 16#01E70#),  -- LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
     (16#01E72#, 16#01E72#),  -- LATIN CAPITAL LETTER U WITH DIAERESIS BELOW .. LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
     (16#01E74#, 16#01E74#),  -- LATIN CAPITAL LETTER U WITH TILDE BELOW .. LATIN CAPITAL LETTER U WITH TILDE BELOW
     (16#01E76#, 16#01E76#),  -- LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
     (16#01E78#, 16#01E78#),  -- LATIN CAPITAL LETTER U WITH TILDE AND ACUTE .. LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
     (16#01E7A#, 16#01E7A#),  -- LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS .. LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
     (16#01E7C#, 16#01E7C#),  -- LATIN CAPITAL LETTER V WITH TILDE .. LATIN CAPITAL LETTER V WITH TILDE
     (16#01E7E#, 16#01E7E#),  -- LATIN CAPITAL LETTER V WITH DOT BELOW .. LATIN CAPITAL LETTER V WITH DOT BELOW
     (16#01E80#, 16#01E80#),  -- LATIN CAPITAL LETTER W WITH GRAVE .. LATIN CAPITAL LETTER W WITH GRAVE
     (16#01E82#, 16#01E82#),  -- LATIN CAPITAL LETTER W WITH ACUTE .. LATIN CAPITAL LETTER W WITH ACUTE
     (16#01E84#, 16#01E84#),  -- LATIN CAPITAL LETTER W WITH DIAERESIS .. LATIN CAPITAL LETTER W WITH DIAERESIS
     (16#01E86#, 16#01E86#),  -- LATIN CAPITAL LETTER W WITH DOT ABOVE .. LATIN CAPITAL LETTER W WITH DOT ABOVE
     (16#01E88#, 16#01E88#),  -- LATIN CAPITAL LETTER W WITH DOT BELOW .. LATIN CAPITAL LETTER W WITH DOT BELOW
     (16#01E8A#, 16#01E8A#),  -- LATIN CAPITAL LETTER X WITH DOT ABOVE .. LATIN CAPITAL LETTER X WITH DOT ABOVE
     (16#01E8C#, 16#01E8C#),  -- LATIN CAPITAL LETTER X WITH DIAERESIS .. LATIN CAPITAL LETTER X WITH DIAERESIS
     (16#01E8E#, 16#01E8E#),  -- LATIN CAPITAL LETTER Y WITH DOT ABOVE .. LATIN CAPITAL LETTER Y WITH DOT ABOVE
     (16#01E90#, 16#01E90#),  -- LATIN CAPITAL LETTER Z WITH CIRCUMFLEX .. LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
     (16#01E92#, 16#01E92#),  -- LATIN CAPITAL LETTER Z WITH DOT BELOW .. LATIN CAPITAL LETTER Z WITH DOT BELOW
     (16#01E94#, 16#01E94#),  -- LATIN CAPITAL LETTER Z WITH LINE BELOW .. LATIN CAPITAL LETTER Z WITH LINE BELOW
     (16#01EA0#, 16#01EA0#),  -- LATIN CAPITAL LETTER A WITH DOT BELOW .. LATIN CAPITAL LETTER A WITH DOT BELOW
     (16#01EA2#, 16#01EA2#),  -- LATIN CAPITAL LETTER A WITH HOOK ABOVE .. LATIN CAPITAL LETTER A WITH HOOK ABOVE
     (16#01EA4#, 16#01EA4#),  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
     (16#01EA6#, 16#01EA6#),  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
     (16#01EA8#, 16#01EA8#),  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EAA#, 16#01EAA#),  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
     (16#01EAC#, 16#01EAC#),  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
     (16#01EAE#, 16#01EAE#),  -- LATIN CAPITAL LETTER A WITH BREVE AND ACUTE .. LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
     (16#01EB0#, 16#01EB0#),  -- LATIN CAPITAL LETTER A WITH BREVE AND GRAVE .. LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
     (16#01EB2#, 16#01EB2#),  -- LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
     (16#01EB4#, 16#01EB4#),  -- LATIN CAPITAL LETTER A WITH BREVE AND TILDE .. LATIN CAPITAL LETTER A WITH BREVE AND TILDE
     (16#01EB6#, 16#01EB6#),  -- LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW .. LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
     (16#01EB8#, 16#01EB8#),  -- LATIN CAPITAL LETTER E WITH DOT BELOW .. LATIN CAPITAL LETTER E WITH DOT BELOW
     (16#01EBA#, 16#01EBA#),  -- LATIN CAPITAL LETTER E WITH HOOK ABOVE .. LATIN CAPITAL LETTER E WITH HOOK ABOVE
     (16#01EBC#, 16#01EBC#),  -- LATIN CAPITAL LETTER E WITH TILDE .. LATIN CAPITAL LETTER E WITH TILDE
     (16#01EBE#, 16#01EBE#),  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
     (16#01EC0#, 16#01EC0#),  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
     (16#01EC2#, 16#01EC2#),  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01EC4#, 16#01EC4#),  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
     (16#01EC6#, 16#01EC6#),  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
     (16#01EC8#, 16#01EC8#),  -- LATIN CAPITAL LETTER I WITH HOOK ABOVE .. LATIN CAPITAL LETTER I WITH HOOK ABOVE
     (16#01ECA#, 16#01ECA#),  -- LATIN CAPITAL LETTER I WITH DOT BELOW .. LATIN CAPITAL LETTER I WITH DOT BELOW
     (16#01ECC#, 16#01ECC#),  -- LATIN CAPITAL LETTER O WITH DOT BELOW .. LATIN CAPITAL LETTER O WITH DOT BELOW
     (16#01ECE#, 16#01ECE#),  -- LATIN CAPITAL LETTER O WITH HOOK ABOVE .. LATIN CAPITAL LETTER O WITH HOOK ABOVE
     (16#01ED0#, 16#01ED0#),  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
     (16#01ED2#, 16#01ED2#),  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
     (16#01ED4#, 16#01ED4#),  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
     (16#01ED6#, 16#01ED6#),  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
     (16#01ED8#, 16#01ED8#),  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
     (16#01EDA#, 16#01EDA#),  -- LATIN CAPITAL LETTER O WITH HORN AND ACUTE .. LATIN CAPITAL LETTER O WITH HORN AND ACUTE
     (16#01EDC#, 16#01EDC#),  -- LATIN CAPITAL LETTER O WITH HORN AND GRAVE .. LATIN CAPITAL LETTER O WITH HORN AND GRAVE
     (16#01EDE#, 16#01EDE#),  -- LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE .. LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
     (16#01EE0#, 16#01EE0#),  -- LATIN CAPITAL LETTER O WITH HORN AND TILDE .. LATIN CAPITAL LETTER O WITH HORN AND TILDE
     (16#01EE2#, 16#01EE2#),  -- LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW .. LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
     (16#01EE4#, 16#01EE4#),  -- LATIN CAPITAL LETTER U WITH DOT BELOW .. LATIN CAPITAL LETTER U WITH DOT BELOW
     (16#01EE6#, 16#01EE6#),  -- LATIN CAPITAL LETTER U WITH HOOK ABOVE .. LATIN CAPITAL LETTER U WITH HOOK ABOVE
     (16#01EE8#, 16#01EE8#),  -- LATIN CAPITAL LETTER U WITH HORN AND ACUTE .. LATIN CAPITAL LETTER U WITH HORN AND ACUTE
     (16#01EEA#, 16#01EEA#),  -- LATIN CAPITAL LETTER U WITH HORN AND GRAVE .. LATIN CAPITAL LETTER U WITH HORN AND GRAVE
     (16#01EEC#, 16#01EEC#),  -- LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE .. LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
     (16#01EEE#, 16#01EEE#),  -- LATIN CAPITAL LETTER U WITH HORN AND TILDE .. LATIN CAPITAL LETTER U WITH HORN AND TILDE
     (16#01EF0#, 16#01EF0#),  -- LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW .. LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
     (16#01EF2#, 16#01EF2#),  -- LATIN CAPITAL LETTER Y WITH GRAVE .. LATIN CAPITAL LETTER Y WITH GRAVE
     (16#01EF4#, 16#01EF4#),  -- LATIN CAPITAL LETTER Y WITH DOT BELOW .. LATIN CAPITAL LETTER Y WITH DOT BELOW
     (16#01EF6#, 16#01EF6#),  -- LATIN CAPITAL LETTER Y WITH HOOK ABOVE .. LATIN CAPITAL LETTER Y WITH HOOK ABOVE
     (16#01EF8#, 16#01EF8#),  -- LATIN CAPITAL LETTER Y WITH TILDE .. LATIN CAPITAL LETTER Y WITH TILDE
     (16#01F08#, 16#01F0F#),  -- GREEK CAPITAL LETTER ALPHA WITH PSILI .. GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
     (16#01F18#, 16#01F1D#),  -- GREEK CAPITAL LETTER EPSILON WITH PSILI .. GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
     (16#01F28#, 16#01F2F#),  -- GREEK CAPITAL LETTER ETA WITH PSILI .. GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
     (16#01F38#, 16#01F3F#),  -- GREEK CAPITAL LETTER IOTA WITH PSILI .. GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
     (16#01F48#, 16#01F4D#),  -- GREEK CAPITAL LETTER OMICRON WITH PSILI .. GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
     (16#01F59#, 16#01F59#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA
     (16#01F5B#, 16#01F5B#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
     (16#01F5D#, 16#01F5D#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
     (16#01F5F#, 16#01F5F#),  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
     (16#01F68#, 16#01F6F#),  -- GREEK CAPITAL LETTER OMEGA WITH PSILI .. GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
     (16#01FB8#, 16#01FB9#),  -- GREEK CAPITAL LETTER ALPHA WITH VRACHY .. GREEK CAPITAL LETTER ALPHA WITH MACRON
     (16#01FBA#, 16#01FBB#),  -- GREEK CAPITAL LETTER ALPHA WITH VARIA .. GREEK CAPITAL LETTER ALPHA WITH OXIA
     (16#01FC8#, 16#01FCB#),  -- GREEK CAPITAL LETTER EPSILON WITH VARIA .. GREEK CAPITAL LETTER ETA WITH OXIA
     (16#01FD8#, 16#01FD9#),  -- GREEK CAPITAL LETTER IOTA WITH VRACHY .. GREEK CAPITAL LETTER IOTA WITH MACRON
     (16#01FDA#, 16#01FDB#),  -- GREEK CAPITAL LETTER IOTA WITH VARIA .. GREEK CAPITAL LETTER IOTA WITH OXIA
     (16#01FE8#, 16#01FE9#),  -- GREEK CAPITAL LETTER UPSILON WITH VRACHY .. GREEK CAPITAL LETTER UPSILON WITH MACRON
     (16#01FEA#, 16#01FEB#),  -- GREEK CAPITAL LETTER UPSILON WITH VARIA .. GREEK CAPITAL LETTER UPSILON WITH OXIA
     (16#01FEC#, 16#01FEC#),  -- GREEK CAPITAL LETTER RHO WITH DASIA .. GREEK CAPITAL LETTER RHO WITH DASIA
     (16#01FF8#, 16#01FF9#),  -- GREEK CAPITAL LETTER OMICRON WITH VARIA .. GREEK CAPITAL LETTER OMICRON WITH OXIA
     (16#01FFA#, 16#01FFB#),  -- GREEK CAPITAL LETTER OMEGA WITH VARIA .. GREEK CAPITAL LETTER OMEGA WITH OXIA
     (16#024B6#, 16#024CF#),  -- CIRCLED LATIN CAPITAL LETTER A .. CIRCLED LATIN CAPITAL LETTER Z
     (16#0FF21#, 16#0FF3A#),  -- FULLWIDTH LATIN CAPITAL LETTER A .. FULLWIDTH LATIN CAPITAL LETTER Z
     (16#10400#, 16#10427#),  -- DESERET CAPITAL LETTER LONG I .. DESERET CAPITAL LETTER EW
     (16#E0041#, 16#E005A#)); -- TAG LATIN CAPITAL LETTER A .. TAG LATIN CAPITAL LETTER Z

   Upper_Case_Adjust : constant array (Lower_Case_Letters'Range)
     of UTF_32'Base := (
        32,  -- LATIN CAPITAL LETTER A .. LATIN CAPITAL LETTER Z
        32,  -- LATIN CAPITAL LETTER A WITH GRAVE .. LATIN CAPITAL LETTER O WITH DIAERESIS
        32,  -- LATIN CAPITAL LETTER O WITH STROKE .. LATIN CAPITAL LETTER THORN
         1,  -- LATIN CAPITAL LETTER A WITH MACRON .. LATIN CAPITAL LETTER A WITH MACRON
         1,  -- LATIN CAPITAL LETTER A WITH BREVE .. LATIN CAPITAL LETTER A WITH BREVE
         1,  -- LATIN CAPITAL LETTER A WITH OGONEK .. LATIN CAPITAL LETTER A WITH OGONEK
         1,  -- LATIN CAPITAL LETTER C WITH ACUTE .. LATIN CAPITAL LETTER C WITH ACUTE
         1,  -- LATIN CAPITAL LETTER C WITH CIRCUMFLEX .. LATIN CAPITAL LETTER C WITH CIRCUMFLEX
         1,  -- LATIN CAPITAL LETTER C WITH DOT ABOVE .. LATIN CAPITAL LETTER C WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER C WITH CARON .. LATIN CAPITAL LETTER C WITH CARON
         1,  -- LATIN CAPITAL LETTER D WITH CARON .. LATIN CAPITAL LETTER D WITH CARON
         1,  -- LATIN CAPITAL LETTER D WITH STROKE .. LATIN CAPITAL LETTER D WITH STROKE
         1,  -- LATIN CAPITAL LETTER E WITH MACRON .. LATIN CAPITAL LETTER E WITH MACRON
         1,  -- LATIN CAPITAL LETTER E WITH BREVE .. LATIN CAPITAL LETTER E WITH BREVE
         1,  -- LATIN CAPITAL LETTER E WITH DOT ABOVE .. LATIN CAPITAL LETTER E WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER E WITH OGONEK .. LATIN CAPITAL LETTER E WITH OGONEK
         1,  -- LATIN CAPITAL LETTER E WITH CARON .. LATIN CAPITAL LETTER E WITH CARON
         1,  -- LATIN CAPITAL LETTER G WITH CIRCUMFLEX .. LATIN CAPITAL LETTER G WITH CIRCUMFLEX
         1,  -- LATIN CAPITAL LETTER G WITH BREVE .. LATIN CAPITAL LETTER G WITH BREVE
         1,  -- LATIN CAPITAL LETTER G WITH DOT ABOVE .. LATIN CAPITAL LETTER G WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER G WITH CEDILLA .. LATIN CAPITAL LETTER G WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER H WITH CIRCUMFLEX .. LATIN CAPITAL LETTER H WITH CIRCUMFLEX
         1,  -- LATIN CAPITAL LETTER H WITH STROKE .. LATIN CAPITAL LETTER H WITH STROKE
         1,  -- LATIN CAPITAL LETTER I WITH TILDE .. LATIN CAPITAL LETTER I WITH TILDE
         1,  -- LATIN CAPITAL LETTER I WITH MACRON .. LATIN CAPITAL LETTER I WITH MACRON
         1,  -- LATIN CAPITAL LETTER I WITH BREVE .. LATIN CAPITAL LETTER I WITH BREVE
         1,  -- LATIN CAPITAL LETTER I WITH OGONEK .. LATIN CAPITAL LETTER I WITH OGONEK
         1,  -- LATIN CAPITAL LETTER I J .. LATIN CAPITAL LETTER I J
         1,  -- LATIN CAPITAL LETTER J WITH CIRCUMFLEX .. LATIN CAPITAL LETTER J WITH CIRCUMFLEX
         1,  -- LATIN CAPITAL LETTER K WITH CEDILLA .. LATIN CAPITAL LETTER K WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER L WITH ACUTE .. LATIN CAPITAL LETTER L WITH ACUTE
         1,  -- LATIN CAPITAL LETTER L WITH CEDILLA .. LATIN CAPITAL LETTER L WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER L WITH CARON .. LATIN CAPITAL LETTER L WITH CARON
         1,  -- LATIN CAPITAL LETTER L WITH MIDDLE DOT .. LATIN CAPITAL LETTER L WITH MIDDLE DOT
         1,  -- LATIN CAPITAL LETTER L WITH STROKE .. LATIN CAPITAL LETTER L WITH STROKE
         1,  -- LATIN CAPITAL LETTER N WITH ACUTE .. LATIN CAPITAL LETTER N WITH ACUTE
         1,  -- LATIN CAPITAL LETTER N WITH CEDILLA .. LATIN CAPITAL LETTER N WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER N WITH CARON .. LATIN CAPITAL LETTER N WITH CARON
         1,  -- LATIN CAPITAL LETTER ENG .. LATIN CAPITAL LETTER ENG
         1,  -- LATIN CAPITAL LETTER O WITH MACRON .. LATIN CAPITAL LETTER O WITH MACRON
         1,  -- LATIN CAPITAL LETTER O WITH BREVE .. LATIN CAPITAL LETTER O WITH BREVE
         1,  -- LATIN CAPITAL LETTER O WITH DOUBLE ACUTE .. LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
         1,  -- LATIN CAPITAL LETTER O E .. LATIN CAPITAL LETTER O E
         1,  -- LATIN CAPITAL LETTER R WITH ACUTE .. LATIN CAPITAL LETTER R WITH ACUTE
         1,  -- LATIN CAPITAL LETTER R WITH CEDILLA .. LATIN CAPITAL LETTER R WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER R WITH CARON .. LATIN CAPITAL LETTER R WITH CARON
         1,  -- LATIN CAPITAL LETTER S WITH ACUTE .. LATIN CAPITAL LETTER S WITH ACUTE
         1,  -- LATIN CAPITAL LETTER S WITH CIRCUMFLEX .. LATIN CAPITAL LETTER S WITH CIRCUMFLEX
         1,  -- LATIN CAPITAL LETTER S WITH CEDILLA .. LATIN CAPITAL LETTER S WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER S WITH CARON .. LATIN CAPITAL LETTER S WITH CARON
         1,  -- LATIN CAPITAL LETTER T WITH CEDILLA .. LATIN CAPITAL LETTER T WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER T WITH CARON .. LATIN CAPITAL LETTER T WITH CARON
         1,  -- LATIN CAPITAL LETTER T WITH STROKE .. LATIN CAPITAL LETTER T WITH STROKE
         1,  -- LATIN CAPITAL LETTER U WITH TILDE .. LATIN CAPITAL LETTER U WITH TILDE
         1,  -- LATIN CAPITAL LETTER U WITH MACRON .. LATIN CAPITAL LETTER U WITH MACRON
         1,  -- LATIN CAPITAL LETTER U WITH BREVE .. LATIN CAPITAL LETTER U WITH BREVE
         1,  -- LATIN CAPITAL LETTER U WITH RING ABOVE .. LATIN CAPITAL LETTER U WITH RING ABOVE
         1,  -- LATIN CAPITAL LETTER U WITH DOUBLE ACUTE .. LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
         1,  -- LATIN CAPITAL LETTER U WITH OGONEK .. LATIN CAPITAL LETTER U WITH OGONEK
         1,  -- LATIN CAPITAL LETTER W WITH CIRCUMFLEX .. LATIN CAPITAL LETTER W WITH CIRCUMFLEX
         1,  -- LATIN CAPITAL LETTER Y WITH CIRCUMFLEX .. LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
      -121,  -- LATIN CAPITAL LETTER Y WITH DIAERESIS .. LATIN CAPITAL LETTER Y WITH DIAERESIS
         1,  -- LATIN CAPITAL LETTER Z WITH ACUTE .. LATIN CAPITAL LETTER Z WITH ACUTE
         1,  -- LATIN CAPITAL LETTER Z WITH DOT ABOVE .. LATIN CAPITAL LETTER Z WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER Z WITH CARON .. LATIN CAPITAL LETTER Z WITH CARON
       210,  -- LATIN CAPITAL LETTER B WITH HOOK .. LATIN CAPITAL LETTER B WITH HOOK
         1,  -- LATIN CAPITAL LETTER B WITH TOPBAR .. LATIN CAPITAL LETTER B WITH TOPBAR
         1,  -- LATIN CAPITAL LETTER TONE SIX .. LATIN CAPITAL LETTER TONE SIX
       206,  -- LATIN CAPITAL LETTER OPEN O .. LATIN CAPITAL LETTER OPEN O
         1,  -- LATIN CAPITAL LETTER C WITH HOOK .. LATIN CAPITAL LETTER C WITH HOOK
       205,  -- LATIN CAPITAL LETTER D WITH HOOK .. LATIN CAPITAL LETTER D WITH HOOK
         1,  -- LATIN CAPITAL LETTER D WITH TOPBAR .. LATIN CAPITAL LETTER D WITH TOPBAR
       202,  -- LATIN CAPITAL LETTER REVERSED E .. LATIN CAPITAL LETTER SCHWA
       203,  -- LATIN CAPITAL LETTER OPEN E .. LATIN CAPITAL LETTER OPEN E
         1,  -- LATIN CAPITAL LETTER F WITH HOOK .. LATIN CAPITAL LETTER F WITH HOOK
       205,  -- LATIN CAPITAL LETTER G WITH HOOK .. LATIN CAPITAL LETTER G WITH HOOK
       207,  -- LATIN CAPITAL LETTER GAMMA .. LATIN CAPITAL LETTER GAMMA
       211,  -- LATIN CAPITAL LETTER IOTA .. LATIN CAPITAL LETTER IOTA
       209,  -- LATIN CAPITAL LETTER I WITH STROKE .. LATIN CAPITAL LETTER I WITH STROKE
         1,  -- LATIN CAPITAL LETTER K WITH HOOK .. LATIN CAPITAL LETTER K WITH HOOK
       211,  -- LATIN CAPITAL LETTER TURNED M .. LATIN CAPITAL LETTER TURNED M
       213,  -- LATIN CAPITAL LETTER N WITH LEFT HOOK .. LATIN CAPITAL LETTER N WITH LEFT HOOK
         1,  -- LATIN CAPITAL LETTER O WITH HORN .. LATIN CAPITAL LETTER O WITH HORN
         1,  -- LATIN CAPITAL LETTER OI .. LATIN CAPITAL LETTER OI
         1,  -- LATIN CAPITAL LETTER P WITH HOOK .. LATIN CAPITAL LETTER P WITH HOOK
         1,  -- LATIN CAPITAL LETTER TONE TWO .. LATIN CAPITAL LETTER TONE TWO
       218,  -- LATIN CAPITAL LETTER ESH .. LATIN CAPITAL LETTER ESH
         1,  -- LATIN CAPITAL LETTER T WITH HOOK .. LATIN CAPITAL LETTER T WITH HOOK
       218,  -- LATIN CAPITAL LETTER T WITH RETROFLEX HOOK .. LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
         1,  -- LATIN CAPITAL LETTER U WITH HORN .. LATIN CAPITAL LETTER U WITH HORN
       217,  -- LATIN CAPITAL LETTER UPSILON .. LATIN CAPITAL LETTER V WITH HOOK
         1,  -- LATIN CAPITAL LETTER Y WITH HOOK .. LATIN CAPITAL LETTER Y WITH HOOK
         1,  -- LATIN CAPITAL LETTER Z WITH STROKE .. LATIN CAPITAL LETTER Z WITH STROKE
       219,  -- LATIN CAPITAL LETTER EZH .. LATIN CAPITAL LETTER EZH
         1,  -- LATIN CAPITAL LETTER EZH REVERSED .. LATIN CAPITAL LETTER EZH REVERSED
         1,  -- LATIN CAPITAL LETTER TONE FIVE .. LATIN CAPITAL LETTER TONE FIVE
         2,  -- LATIN CAPITAL LETTER DZ WITH CARON .. LATIN CAPITAL LETTER DZ WITH CARON
         2,  -- LATIN CAPITAL LETTER LJ .. LATIN CAPITAL LETTER LJ
         2,  -- LATIN CAPITAL LETTER NJ .. LATIN CAPITAL LETTER NJ
         1,  -- LATIN CAPITAL LETTER A WITH CARON .. LATIN CAPITAL LETTER A WITH CARON
         1,  -- LATIN CAPITAL LETTER I WITH CARON .. LATIN CAPITAL LETTER I WITH CARON
         1,  -- LATIN CAPITAL LETTER O WITH CARON .. LATIN CAPITAL LETTER O WITH CARON
         1,  -- LATIN CAPITAL LETTER U WITH CARON .. LATIN CAPITAL LETTER U WITH CARON
         1,  -- LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
         1,  -- LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE .. LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
         1,  -- LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON .. LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
         1,  -- LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE .. LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
         1,  -- LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
         1,  -- LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON .. LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
         1,  -- LATIN CAPITAL LETTER AE WITH MACRON .. LATIN CAPITAL LETTER AE WITH MACRON
         1,  -- LATIN CAPITAL LETTER G WITH STROKE .. LATIN CAPITAL LETTER G WITH STROKE
         1,  -- LATIN CAPITAL LETTER G WITH CARON .. LATIN CAPITAL LETTER G WITH CARON
         1,  -- LATIN CAPITAL LETTER K WITH CARON .. LATIN CAPITAL LETTER K WITH CARON
         1,  -- LATIN CAPITAL LETTER O WITH OGONEK .. LATIN CAPITAL LETTER O WITH OGONEK
         1,  -- LATIN CAPITAL LETTER O WITH OGONEK AND MACRON .. LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
         1,  -- LATIN CAPITAL LETTER EZH WITH CARON .. LATIN CAPITAL LETTER EZH WITH CARON
         2,  -- LATIN CAPITAL LETTER DZ .. LATIN CAPITAL LETTER DZ
         1,  -- LATIN CAPITAL LETTER G WITH ACUTE .. LATIN CAPITAL LETTER G WITH ACUTE
         1,  -- LATIN CAPITAL LETTER N WITH GRAVE .. LATIN CAPITAL LETTER N WITH GRAVE
         1,  -- LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE .. LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
         1,  -- LATIN CAPITAL LETTER AE WITH ACUTE .. LATIN CAPITAL LETTER AE WITH ACUTE
         1,  -- LATIN CAPITAL LETTER O WITH STROKE AND ACUTE .. LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
         1,  -- LATIN CAPITAL LETTER A WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
         1,  -- LATIN CAPITAL LETTER A WITH INVERTED BREVE .. LATIN CAPITAL LETTER A WITH INVERTED BREVE
         1,  -- LATIN CAPITAL LETTER E WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
         1,  -- LATIN CAPITAL LETTER E WITH INVERTED BREVE .. LATIN CAPITAL LETTER E WITH INVERTED BREVE
         1,  -- LATIN CAPITAL LETTER I WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
         1,  -- LATIN CAPITAL LETTER I WITH INVERTED BREVE .. LATIN CAPITAL LETTER I WITH INVERTED BREVE
         1,  -- LATIN CAPITAL LETTER O WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
         1,  -- LATIN CAPITAL LETTER O WITH INVERTED BREVE .. LATIN CAPITAL LETTER O WITH INVERTED BREVE
         1,  -- LATIN CAPITAL LETTER R WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
         1,  -- LATIN CAPITAL LETTER R WITH INVERTED BREVE .. LATIN CAPITAL LETTER R WITH INVERTED BREVE
         1,  -- LATIN CAPITAL LETTER U WITH DOUBLE GRAVE .. LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
         1,  -- LATIN CAPITAL LETTER U WITH INVERTED BREVE .. LATIN CAPITAL LETTER U WITH INVERTED BREVE
         1,  -- LATIN CAPITAL LETTER S WITH COMMA BELOW .. LATIN CAPITAL LETTER S WITH COMMA BELOW
         1,  -- LATIN CAPITAL LETTER T WITH COMMA BELOW .. LATIN CAPITAL LETTER T WITH COMMA BELOW
         1,  -- LATIN CAPITAL LETTER YOGH .. LATIN CAPITAL LETTER YOGH
         1,  -- LATIN CAPITAL LETTER H WITH CARON .. LATIN CAPITAL LETTER H WITH CARON
      -130,  -- LATIN CAPITAL LETTER N WITH LONG RIGHT LEG .. LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
         1,  -- LATIN CAPITAL LETTER OU .. LATIN CAPITAL LETTER OU
         1,  -- LATIN CAPITAL LETTER Z WITH HOOK .. LATIN CAPITAL LETTER Z WITH HOOK
         1,  -- LATIN CAPITAL LETTER A WITH DOT ABOVE .. LATIN CAPITAL LETTER A WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER E WITH CEDILLA .. LATIN CAPITAL LETTER E WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON .. LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
         1,  -- LATIN CAPITAL LETTER O WITH TILDE AND MACRON .. LATIN CAPITAL LETTER O WITH TILDE AND MACRON
         1,  -- LATIN CAPITAL LETTER O WITH DOT ABOVE .. LATIN CAPITAL LETTER O WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON .. LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
         1,  -- LATIN CAPITAL LETTER Y WITH MACRON .. LATIN CAPITAL LETTER Y WITH MACRON
        38,  -- GREEK CAPITAL LETTER ALPHA WITH TONOS .. GREEK CAPITAL LETTER ALPHA WITH TONOS
        37,  -- GREEK CAPITAL LETTER EPSILON WITH TONOS .. GREEK CAPITAL LETTER IOTA WITH TONOS
        64,  -- GREEK CAPITAL LETTER OMICRON WITH TONOS .. GREEK CAPITAL LETTER OMICRON WITH TONOS
        63,  -- GREEK CAPITAL LETTER UPSILON WITH TONOS .. GREEK CAPITAL LETTER OMEGA WITH TONOS
        32,  -- GREEK CAPITAL LETTER ALPHA .. GREEK CAPITAL LETTER RHO
        32,  -- GREEK CAPITAL LETTER SIGMA .. GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
         1,  -- GREEK CAPITAL LETTER STIGMA .. GREEK CAPITAL LETTER STIGMA
         1,  -- GREEK CAPITAL LETTER DIGAMMA .. GREEK CAPITAL LETTER DIGAMMA
         1,  -- GREEK CAPITAL LETTER KOPPA .. GREEK CAPITAL LETTER KOPPA
         1,  -- GREEK CAPITAL LETTER SAMPI .. GREEK CAPITAL LETTER SAMPI
         1,  -- COPTIC CAPITAL LETTER SHEI .. COPTIC CAPITAL LETTER SHEI
         1,  -- COPTIC CAPITAL LETTER FEI .. COPTIC CAPITAL LETTER FEI
         1,  -- COPTIC CAPITAL LETTER KHEI .. COPTIC CAPITAL LETTER KHEI
         1,  -- COPTIC CAPITAL LETTER HORI .. COPTIC CAPITAL LETTER HORI
         1,  -- COPTIC CAPITAL LETTER GANGIA .. COPTIC CAPITAL LETTER GANGIA
         1,  -- COPTIC CAPITAL LETTER SHIMA .. COPTIC CAPITAL LETTER SHIMA
         1,  -- COPTIC CAPITAL LETTER DEI .. COPTIC CAPITAL LETTER DEI
         1,  -- GREEK CAPITAL LETTER SHO .. GREEK CAPITAL LETTER SHO
         1,  -- GREEK CAPITAL LETTER SAN .. GREEK CAPITAL LETTER SAN
        80,  -- CYRILLIC CAPITAL LETTER IE WITH GRAVE .. CYRILLIC CAPITAL LETTER DZHE
        32,  -- CYRILLIC CAPITAL LETTER A .. CYRILLIC CAPITAL LETTER YA
         1,  -- CYRILLIC CAPITAL LETTER OMEGA .. CYRILLIC CAPITAL LETTER OMEGA
         1,  -- CYRILLIC CAPITAL LETTER YAT .. CYRILLIC CAPITAL LETTER YAT
         1,  -- CYRILLIC CAPITAL LETTER IOTIFIED E .. CYRILLIC CAPITAL LETTER IOTIFIED E
         1,  -- CYRILLIC CAPITAL LETTER LITTLE YUS .. CYRILLIC CAPITAL LETTER LITTLE YUS
         1,  -- CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS .. CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
         1,  -- CYRILLIC CAPITAL LETTER BIG YUS .. CYRILLIC CAPITAL LETTER BIG YUS
         1,  -- CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS .. CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
         1,  -- CYRILLIC CAPITAL LETTER KSI .. CYRILLIC CAPITAL LETTER KSI
         1,  -- CYRILLIC CAPITAL LETTER PSI .. CYRILLIC CAPITAL LETTER PSI
         1,  -- CYRILLIC CAPITAL LETTER FITA .. CYRILLIC CAPITAL LETTER FITA
         1,  -- CYRILLIC CAPITAL LETTER IZHITSA .. CYRILLIC CAPITAL LETTER IZHITSA
         1,  -- CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT .. CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
         1,  -- CYRILLIC CAPITAL LETTER UK .. CYRILLIC CAPITAL LETTER UK
         1,  -- CYRILLIC CAPITAL LETTER ROUND OMEGA .. CYRILLIC CAPITAL LETTER ROUND OMEGA
         1,  -- CYRILLIC CAPITAL LETTER OMEGA WITH TITLO .. CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
         1,  -- CYRILLIC CAPITAL LETTER OT .. CYRILLIC CAPITAL LETTER OT
         1,  -- CYRILLIC CAPITAL LETTER KOPPA .. CYRILLIC CAPITAL LETTER KOPPA
         1,  -- CYRILLIC CAPITAL LETTER SHORT I WITH TAIL .. CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
         1,  -- CYRILLIC CAPITAL LETTER SEMISOFT SIGN .. CYRILLIC CAPITAL LETTER SEMISOFT SIGN
         1,  -- CYRILLIC CAPITAL LETTER ER WITH TICK .. CYRILLIC CAPITAL LETTER ER WITH TICK
         1,  -- CYRILLIC CAPITAL LETTER GHE WITH UPTURN .. CYRILLIC CAPITAL LETTER GHE WITH UPTURN
         1,  -- CYRILLIC CAPITAL LETTER GHE WITH STROKE .. CYRILLIC CAPITAL LETTER GHE WITH STROKE
         1,  -- CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK .. CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
         1,  -- CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER ZE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER KA WITH DESCENDER .. CYRILLIC CAPITAL LETTER KA WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE .. CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
         1,  -- CYRILLIC CAPITAL LETTER KA WITH STROKE .. CYRILLIC CAPITAL LETTER KA WITH STROKE
         1,  -- CYRILLIC CAPITAL LETTER BASHKIR KA .. CYRILLIC CAPITAL LETTER BASHKIR KA
         1,  -- CYRILLIC CAPITAL LETTER EN WITH DESCENDER .. CYRILLIC CAPITAL LETTER EN WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER EN GE .. CYRILLIC CAPITAL LETTER EN GE
         1,  -- CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK .. CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
         1,  -- CYRILLIC CAPITAL LETTER ABKHASIAN HA .. CYRILLIC CAPITAL LETTER ABKHASIAN HA
         1,  -- CYRILLIC CAPITAL LETTER ES WITH DESCENDER .. CYRILLIC CAPITAL LETTER ES WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER TE WITH DESCENDER .. CYRILLIC CAPITAL LETTER TE WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER STRAIGHT U .. CYRILLIC CAPITAL LETTER STRAIGHT U
         1,  -- CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE .. CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
         1,  -- CYRILLIC CAPITAL LETTER HA WITH DESCENDER .. CYRILLIC CAPITAL LETTER HA WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER TE TSE .. CYRILLIC CAPITAL LETTER TE TSE
         1,  -- CYRILLIC CAPITAL LETTER CHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE .. CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
         1,  -- CYRILLIC CAPITAL LETTER SHHA .. CYRILLIC CAPITAL LETTER SHHA
         1,  -- CYRILLIC CAPITAL LETTER ABKHASIAN CHE .. CYRILLIC CAPITAL LETTER ABKHASIAN CHE
         1,  -- CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER .. CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
         1,  -- CYRILLIC CAPITAL LETTER ZHE WITH BREVE .. CYRILLIC CAPITAL LETTER ZHE WITH BREVE
         1,  -- CYRILLIC CAPITAL LETTER KA WITH HOOK .. CYRILLIC CAPITAL LETTER KA WITH HOOK
         1,  -- CYRILLIC CAPITAL LETTER EL WITH TAIL .. CYRILLIC CAPITAL LETTER EL WITH TAIL
         1,  -- CYRILLIC CAPITAL LETTER EN WITH HOOK .. CYRILLIC CAPITAL LETTER EN WITH HOOK
         1,  -- CYRILLIC CAPITAL LETTER EN WITH TAIL .. CYRILLIC CAPITAL LETTER EN WITH TAIL
         1,  -- CYRILLIC CAPITAL LETTER KHAKASSIAN CHE .. CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
         1,  -- CYRILLIC CAPITAL LETTER EM WITH TAIL .. CYRILLIC CAPITAL LETTER EM WITH TAIL
         1,  -- CYRILLIC CAPITAL LETTER A WITH BREVE .. CYRILLIC CAPITAL LETTER A WITH BREVE
         1,  -- CYRILLIC CAPITAL LETTER A WITH DIAERESIS .. CYRILLIC CAPITAL LETTER A WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER IE WITH BREVE .. CYRILLIC CAPITAL LETTER IE WITH BREVE
         1,  -- CYRILLIC CAPITAL LETTER SCHWA .. CYRILLIC CAPITAL LETTER SCHWA
         1,  -- CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS .. CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER ABKHASIAN DZE .. CYRILLIC CAPITAL LETTER ABKHASIAN DZE
         1,  -- CYRILLIC CAPITAL LETTER I WITH MACRON .. CYRILLIC CAPITAL LETTER I WITH MACRON
         1,  -- CYRILLIC CAPITAL LETTER I WITH DIAERESIS .. CYRILLIC CAPITAL LETTER I WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER O WITH DIAERESIS .. CYRILLIC CAPITAL LETTER O WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER BARRED O .. CYRILLIC CAPITAL LETTER BARRED O
         1,  -- CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS .. CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER E WITH DIAERESIS .. CYRILLIC CAPITAL LETTER E WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER U WITH MACRON .. CYRILLIC CAPITAL LETTER U WITH MACRON
         1,  -- CYRILLIC CAPITAL LETTER U WITH DIAERESIS .. CYRILLIC CAPITAL LETTER U WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE .. CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
         1,  -- CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS .. CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS .. CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
         1,  -- CYRILLIC CAPITAL LETTER KOMI DE .. CYRILLIC CAPITAL LETTER KOMI DE
         1,  -- CYRILLIC CAPITAL LETTER KOMI DJE .. CYRILLIC CAPITAL LETTER KOMI DJE
         1,  -- CYRILLIC CAPITAL LETTER KOMI ZJE .. CYRILLIC CAPITAL LETTER KOMI ZJE
         1,  -- CYRILLIC CAPITAL LETTER KOMI DZJE .. CYRILLIC CAPITAL LETTER KOMI DZJE
         1,  -- CYRILLIC CAPITAL LETTER KOMI LJE .. CYRILLIC CAPITAL LETTER KOMI LJE
         1,  -- CYRILLIC CAPITAL LETTER KOMI NJE .. CYRILLIC CAPITAL LETTER KOMI NJE
         1,  -- CYRILLIC CAPITAL LETTER KOMI SJE .. CYRILLIC CAPITAL LETTER KOMI SJE
         1,  -- CYRILLIC CAPITAL LETTER KOMI TJE .. CYRILLIC CAPITAL LETTER KOMI TJE
        48,  -- ARMENIAN CAPITAL LETTER AYB .. ARMENIAN CAPITAL LETTER FEH
        48,  -- GEORGIAN CAPITAL LETTER AN .. GEORGIAN CAPITAL LETTER HOE
         1,  -- LATIN CAPITAL LETTER A WITH RING BELOW .. LATIN CAPITAL LETTER A WITH RING BELOW
         1,  -- LATIN CAPITAL LETTER B WITH DOT ABOVE .. LATIN CAPITAL LETTER B WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER B WITH DOT BELOW .. LATIN CAPITAL LETTER B WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER B WITH LINE BELOW .. LATIN CAPITAL LETTER B WITH LINE BELOW
         1,  -- LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE .. LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
         1,  -- LATIN CAPITAL LETTER D WITH DOT ABOVE .. LATIN CAPITAL LETTER D WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER D WITH DOT BELOW .. LATIN CAPITAL LETTER D WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER D WITH LINE BELOW .. LATIN CAPITAL LETTER D WITH LINE BELOW
         1,  -- LATIN CAPITAL LETTER D WITH CEDILLA .. LATIN CAPITAL LETTER D WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
         1,  -- LATIN CAPITAL LETTER E WITH MACRON AND GRAVE .. LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
         1,  -- LATIN CAPITAL LETTER E WITH MACRON AND ACUTE .. LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
         1,  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
         1,  -- LATIN CAPITAL LETTER E WITH TILDE BELOW .. LATIN CAPITAL LETTER E WITH TILDE BELOW
         1,  -- LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE .. LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
         1,  -- LATIN CAPITAL LETTER F WITH DOT ABOVE .. LATIN CAPITAL LETTER F WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER G WITH MACRON .. LATIN CAPITAL LETTER G WITH MACRON
         1,  -- LATIN CAPITAL LETTER H WITH DOT ABOVE .. LATIN CAPITAL LETTER H WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER H WITH DOT BELOW .. LATIN CAPITAL LETTER H WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER H WITH DIAERESIS .. LATIN CAPITAL LETTER H WITH DIAERESIS
         1,  -- LATIN CAPITAL LETTER H WITH CEDILLA .. LATIN CAPITAL LETTER H WITH CEDILLA
         1,  -- LATIN CAPITAL LETTER H WITH BREVE BELOW .. LATIN CAPITAL LETTER H WITH BREVE BELOW
         1,  -- LATIN CAPITAL LETTER I WITH TILDE BELOW .. LATIN CAPITAL LETTER I WITH TILDE BELOW
         1,  -- LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE .. LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
         1,  -- LATIN CAPITAL LETTER K WITH ACUTE .. LATIN CAPITAL LETTER K WITH ACUTE
         1,  -- LATIN CAPITAL LETTER K WITH DOT BELOW .. LATIN CAPITAL LETTER K WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER K WITH LINE BELOW .. LATIN CAPITAL LETTER K WITH LINE BELOW
         1,  -- LATIN CAPITAL LETTER L WITH DOT BELOW .. LATIN CAPITAL LETTER L WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON .. LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
         1,  -- LATIN CAPITAL LETTER L WITH LINE BELOW .. LATIN CAPITAL LETTER L WITH LINE BELOW
         1,  -- LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
         1,  -- LATIN CAPITAL LETTER M WITH ACUTE .. LATIN CAPITAL LETTER M WITH ACUTE
         1,  -- LATIN CAPITAL LETTER M WITH DOT ABOVE .. LATIN CAPITAL LETTER M WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER M WITH DOT BELOW .. LATIN CAPITAL LETTER M WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER N WITH DOT ABOVE .. LATIN CAPITAL LETTER N WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER N WITH DOT BELOW .. LATIN CAPITAL LETTER N WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER N WITH LINE BELOW .. LATIN CAPITAL LETTER N WITH LINE BELOW
         1,  -- LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
         1,  -- LATIN CAPITAL LETTER O WITH TILDE AND ACUTE .. LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
         1,  -- LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS .. LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
         1,  -- LATIN CAPITAL LETTER O WITH MACRON AND GRAVE .. LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
         1,  -- LATIN CAPITAL LETTER O WITH MACRON AND ACUTE .. LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
         1,  -- LATIN CAPITAL LETTER P WITH ACUTE .. LATIN CAPITAL LETTER P WITH ACUTE
         1,  -- LATIN CAPITAL LETTER P WITH DOT ABOVE .. LATIN CAPITAL LETTER P WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER R WITH DOT ABOVE .. LATIN CAPITAL LETTER R WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER R WITH DOT BELOW .. LATIN CAPITAL LETTER R WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON .. LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
         1,  -- LATIN CAPITAL LETTER R WITH LINE BELOW .. LATIN CAPITAL LETTER R WITH LINE BELOW
         1,  -- LATIN CAPITAL LETTER S WITH DOT ABOVE .. LATIN CAPITAL LETTER S WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER S WITH DOT BELOW .. LATIN CAPITAL LETTER S WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
         1,  -- LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
         1,  -- LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE .. LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
         1,  -- LATIN CAPITAL LETTER T WITH DOT ABOVE .. LATIN CAPITAL LETTER T WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER T WITH DOT BELOW .. LATIN CAPITAL LETTER T WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER T WITH LINE BELOW .. LATIN CAPITAL LETTER T WITH LINE BELOW
         1,  -- LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
         1,  -- LATIN CAPITAL LETTER U WITH DIAERESIS BELOW .. LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
         1,  -- LATIN CAPITAL LETTER U WITH TILDE BELOW .. LATIN CAPITAL LETTER U WITH TILDE BELOW
         1,  -- LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW .. LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
         1,  -- LATIN CAPITAL LETTER U WITH TILDE AND ACUTE .. LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
         1,  -- LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS .. LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
         1,  -- LATIN CAPITAL LETTER V WITH TILDE .. LATIN CAPITAL LETTER V WITH TILDE
         1,  -- LATIN CAPITAL LETTER V WITH DOT BELOW .. LATIN CAPITAL LETTER V WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER W WITH GRAVE .. LATIN CAPITAL LETTER W WITH GRAVE
         1,  -- LATIN CAPITAL LETTER W WITH ACUTE .. LATIN CAPITAL LETTER W WITH ACUTE
         1,  -- LATIN CAPITAL LETTER W WITH DIAERESIS .. LATIN CAPITAL LETTER W WITH DIAERESIS
         1,  -- LATIN CAPITAL LETTER W WITH DOT ABOVE .. LATIN CAPITAL LETTER W WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER W WITH DOT BELOW .. LATIN CAPITAL LETTER W WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER X WITH DOT ABOVE .. LATIN CAPITAL LETTER X WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER X WITH DIAERESIS .. LATIN CAPITAL LETTER X WITH DIAERESIS
         1,  -- LATIN CAPITAL LETTER Y WITH DOT ABOVE .. LATIN CAPITAL LETTER Y WITH DOT ABOVE
         1,  -- LATIN CAPITAL LETTER Z WITH CIRCUMFLEX .. LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
         1,  -- LATIN CAPITAL LETTER Z WITH DOT BELOW .. LATIN CAPITAL LETTER Z WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER Z WITH LINE BELOW .. LATIN CAPITAL LETTER Z WITH LINE BELOW
         1,  -- LATIN CAPITAL LETTER A WITH DOT BELOW .. LATIN CAPITAL LETTER A WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER A WITH HOOK ABOVE .. LATIN CAPITAL LETTER A WITH HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
         1,  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
         1,  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
         1,  -- LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
         1,  -- LATIN CAPITAL LETTER A WITH BREVE AND ACUTE .. LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
         1,  -- LATIN CAPITAL LETTER A WITH BREVE AND GRAVE .. LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
         1,  -- LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE .. LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER A WITH BREVE AND TILDE .. LATIN CAPITAL LETTER A WITH BREVE AND TILDE
         1,  -- LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW .. LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
         1,  -- LATIN CAPITAL LETTER E WITH DOT BELOW .. LATIN CAPITAL LETTER E WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER E WITH HOOK ABOVE .. LATIN CAPITAL LETTER E WITH HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER E WITH TILDE .. LATIN CAPITAL LETTER E WITH TILDE
         1,  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
         1,  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
         1,  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
         1,  -- LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
         1,  -- LATIN CAPITAL LETTER I WITH HOOK ABOVE .. LATIN CAPITAL LETTER I WITH HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER I WITH DOT BELOW .. LATIN CAPITAL LETTER I WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER O WITH DOT BELOW .. LATIN CAPITAL LETTER O WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER O WITH HOOK ABOVE .. LATIN CAPITAL LETTER O WITH HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
         1,  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
         1,  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
         1,  -- LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW .. LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
         1,  -- LATIN CAPITAL LETTER O WITH HORN AND ACUTE .. LATIN CAPITAL LETTER O WITH HORN AND ACUTE
         1,  -- LATIN CAPITAL LETTER O WITH HORN AND GRAVE .. LATIN CAPITAL LETTER O WITH HORN AND GRAVE
         1,  -- LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE .. LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER O WITH HORN AND TILDE .. LATIN CAPITAL LETTER O WITH HORN AND TILDE
         1,  -- LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW .. LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
         1,  -- LATIN CAPITAL LETTER U WITH DOT BELOW .. LATIN CAPITAL LETTER U WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER U WITH HOOK ABOVE .. LATIN CAPITAL LETTER U WITH HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER U WITH HORN AND ACUTE .. LATIN CAPITAL LETTER U WITH HORN AND ACUTE
         1,  -- LATIN CAPITAL LETTER U WITH HORN AND GRAVE .. LATIN CAPITAL LETTER U WITH HORN AND GRAVE
         1,  -- LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE .. LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER U WITH HORN AND TILDE .. LATIN CAPITAL LETTER U WITH HORN AND TILDE
         1,  -- LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW .. LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
         1,  -- LATIN CAPITAL LETTER Y WITH GRAVE .. LATIN CAPITAL LETTER Y WITH GRAVE
         1,  -- LATIN CAPITAL LETTER Y WITH DOT BELOW .. LATIN CAPITAL LETTER Y WITH DOT BELOW
         1,  -- LATIN CAPITAL LETTER Y WITH HOOK ABOVE .. LATIN CAPITAL LETTER Y WITH HOOK ABOVE
         1,  -- LATIN CAPITAL LETTER Y WITH TILDE .. LATIN CAPITAL LETTER Y WITH TILDE
        -8,  -- GREEK CAPITAL LETTER ALPHA WITH PSILI .. GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
        -8,  -- GREEK CAPITAL LETTER EPSILON WITH PSILI .. GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
        -8,  -- GREEK CAPITAL LETTER ETA WITH PSILI .. GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
        -8,  -- GREEK CAPITAL LETTER IOTA WITH PSILI .. GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
        -8,  -- GREEK CAPITAL LETTER OMICRON WITH PSILI .. GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
        -8,  -- GREEK CAPITAL LETTER UPSILON WITH DASIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA
        -8,  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
        -8,  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
        -8,  -- GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI .. GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
        -8,  -- GREEK CAPITAL LETTER OMEGA WITH PSILI .. GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
        -8,  -- GREEK CAPITAL LETTER ALPHA WITH VRACHY .. GREEK CAPITAL LETTER ALPHA WITH MACRON
       -74,  -- GREEK CAPITAL LETTER ALPHA WITH VARIA .. GREEK CAPITAL LETTER ALPHA WITH OXIA
       -86,  -- GREEK CAPITAL LETTER EPSILON WITH VARIA .. GREEK CAPITAL LETTER ETA WITH OXIA
        -8,  -- GREEK CAPITAL LETTER IOTA WITH VRACHY .. GREEK CAPITAL LETTER IOTA WITH MACRON
      -100,  -- GREEK CAPITAL LETTER IOTA WITH VARIA .. GREEK CAPITAL LETTER IOTA WITH OXIA
        -8,  -- GREEK CAPITAL LETTER UPSILON WITH VRACHY .. GREEK CAPITAL LETTER UPSILON WITH MACRON
      -112,  -- GREEK CAPITAL LETTER UPSILON WITH VARIA .. GREEK CAPITAL LETTER UPSILON WITH OXIA
        -7,  -- GREEK CAPITAL LETTER RHO WITH DASIA .. GREEK CAPITAL LETTER RHO WITH DASIA
      -128,  -- GREEK CAPITAL LETTER OMICRON WITH VARIA .. GREEK CAPITAL LETTER OMICRON WITH OXIA
      -126,  -- GREEK CAPITAL LETTER OMEGA WITH VARIA .. GREEK CAPITAL LETTER OMEGA WITH OXIA
        26,  -- CIRCLED LATIN CAPITAL LETTER A .. CIRCLED LATIN CAPITAL LETTER Z
        32,  -- FULLWIDTH LATIN CAPITAL LETTER A .. FULLWIDTH LATIN CAPITAL LETTER Z
        40,  -- DESERET CAPITAL LETTER LONG I .. DESERET CAPITAL LETTER EW
        32); -- TAG LATIN CAPITAL LETTER A .. TAG LATIN CAPITAL LETTER Z

   pragma Warnings (On);
   --  Temporary until pragma Warnings at start can be activated ???

   --  The following is a list of the 10646 names for CAPITAL LETTER entries
   --  that have no matching SMALL LETTER entry and are thus not folded

   --  LATIN CAPITAL LETTER I WITH DOT ABOVE
   --  LATIN CAPITAL LETTER AFRICAN D
   --  LATIN CAPITAL LETTER O WITH MIDDLE TILDE
   --  LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
   --  LATIN CAPITAL LETTER L WITH SMALL LETTER J
   --  LATIN CAPITAL LETTER N WITH SMALL LETTER J
   --  LATIN CAPITAL LETTER D WITH SMALL LETTER Z
   --  LATIN CAPITAL LETTER HWAIR
   --  LATIN CAPITAL LETTER WYNN
   --  GREEK CAPITAL LETTER UPSILON HOOK
   --  GREEK CAPITAL LETTER UPSILON HOOK TONOS
   --  GREEK CAPITAL LETTER UPSILON HOOK DIAERESIS
   --  GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
   --  GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI

   -----------------------
   -- Local Subprograms --
   -----------------------

   function Range_Search (U : UTF_32; R : UTF_32_Ranges) return Natural;
   --  Searches the given ranges (which must be in ascending order by Lo value)
   --  and returns the index of the matching range in R if U matches one of the
   --  ranges. If U matches none of the ranges, returns zero.

   ------------------
   -- Get_Category --
   ------------------

   function Get_Category (U : UTF_32) return Category is
   begin
      --  Deal with FFFE/FFFF cases

      if U mod 16#1_0000# >= 16#FFFE# then
         return Fe;

      --  Otherwise search table

      else
         declare
            Index : constant Integer := Range_Search (U, Unicode_Ranges);
         begin
            if Index = 0 then
               return Cn;
            else
               return Unicode_Categories (Index);
            end if;
         end;
      end if;
   end Get_Category;

   ---------------------
   -- Is_UTF_32_Digit --
   ---------------------

   function Is_UTF_32_Digit (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Digits) /= 0;
   end Is_UTF_32_Digit;

   function Is_UTF_32_Digit (C : Category) return Boolean is
   begin
      return C = Nd;
   end Is_UTF_32_Digit;

    ----------------------
   -- Is_UTF_32_Letter --
   ----------------------

   function Is_UTF_32_Letter (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Letters) /= 0;
   end Is_UTF_32_Letter;

   Letter : constant array (Category) of Boolean :=
                   (Lu => True,
                    Ll => True,
                    Lt => True,
                    Lm => True,
                    Lo => True,
                    Nl => True,
                    others => False);

   function Is_UTF_32_Letter (C : Category) return Boolean is
   begin
      return Letter (C);
   end Is_UTF_32_Letter;

   -------------------------------
   -- Is_UTF_32_Line_Terminator --
   -------------------------------

   function Is_UTF_32_Line_Terminator (U : UTF_32) return Boolean is
   begin
      return U in 10 .. 13     -- Ascii.LF Ascii.VT Ascii.FF Ascii.CR
        or else U = 16#00085#  -- NEL
        or else U = 16#02028#  -- LINE SEPARATOR
        or else U = 16#02029#; -- PARAGRAPH SEPARATOR
   end Is_UTF_32_Line_Terminator;

   --------------------
   -- Is_UTF_32_Mark --
   --------------------

   function Is_UTF_32_Mark (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Marks) /= 0;
   end Is_UTF_32_Mark;

   function Is_UTF_32_Mark (C : Category) return Boolean is
   begin
      return C = Mn or else C = Mc;
   end Is_UTF_32_Mark;

   ---------------------------
   -- Is_UTF_32_Non_Graphic --
   ---------------------------

   function Is_UTF_32_Non_Graphic (U : UTF_32) return Boolean is
   begin
      --  We have to deal with FFFE/FFFF specially

      if U mod 16#1_0000# >= 16#FFFE# then
         return True;

      --  Otherwise we can use the table

      else
         return Range_Search (U, UTF_32_Non_Graphic) /= 0;
      end if;
   end Is_UTF_32_Non_Graphic;

   Non_Graphic : constant array (Category) of Boolean :=
                   (Cc => True,
                    Co => True,
                    Cs => True,
                    Zl => True,
                    Zp => True,
                    Fe => True,
                    others => False);

   function Is_UTF_32_Non_Graphic (C : Category) return Boolean is
   begin
      return Non_Graphic (C);
   end Is_UTF_32_Non_Graphic;

   ---------------------
   -- Is_UTF_32_Other --
   ---------------------

   function Is_UTF_32_Other (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Other_Format) /= 0;
   end Is_UTF_32_Other;

   function Is_UTF_32_Other (C : Category) return Boolean is
   begin
      return C = Cf;
   end Is_UTF_32_Other;

   ---------------------------
   -- Is_UTF_32_Punctuation --
   ---------------------------

   function Is_UTF_32_Punctuation (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Punctuation) /= 0;
   end Is_UTF_32_Punctuation;

   function Is_UTF_32_Punctuation (C : Category) return Boolean is
   begin
      return C = Pc;
   end Is_UTF_32_Punctuation;

   ---------------------
   -- Is_UTF_32_Space --
   ---------------------

   function Is_UTF_32_Space (U : UTF_32) return Boolean is
   begin
      return Range_Search (U, UTF_32_Spaces) /= 0;
   end Is_UTF_32_Space;

   function Is_UTF_32_Space (C : Category) return Boolean is
   begin
      return C = Zs;
   end Is_UTF_32_Space;

   ------------------
   -- Range_Search --
   ------------------

   function Range_Search (U : UTF_32; R : UTF_32_Ranges) return Natural is
      Lo  : Integer;
      Hi  : Integer;
      Mid : Integer;

   begin
      Lo := R'First;
      Hi := R'Last;

      loop
         Mid := (Lo + Hi) / 2;

         if U < R (Mid).Lo then
            Hi := Mid - 1;

            if Hi < Lo then
               return 0;
            end if;

         elsif R (Mid).Hi < U then
            Lo := Mid + 1;

            if Hi < Lo then
               return 0;
            end if;

         else
            return Mid;
         end if;
      end loop;
   end Range_Search;

   --------------------------
   -- UTF_32_To_Lower_Case --
   --------------------------

   function UTF_32_To_Lower_Case (U : UTF_32) return UTF_32 is
      Index : constant Integer := Range_Search (U, Upper_Case_Letters);
   begin
      if Index = 0 then
         return U;
      else
         return U + Upper_Case_Adjust (Index);
      end if;
   end UTF_32_To_Lower_Case;

   --------------------------
   -- UTF_32_To_Upper_Case --
   --------------------------

   function UTF_32_To_Upper_Case (U : UTF_32) return UTF_32 is
      Index : constant Integer := Range_Search (U, Lower_Case_Letters);
   begin
      if Index = 0 then
         return U;
      else
         return U + Lower_Case_Adjust (Index);
      end if;
   end UTF_32_To_Upper_Case;

end System.UTF_32;
