/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.cbutil.CBpbar;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.tree.SmartTree;
import com.pegacat.jxworkbench.JXWCSVFieldBuffer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NameClassPair;
import javax.naming.NamingException;

public class JXWCSVExportUtil {
    private boolean largePathalogicalFile = false;
    private boolean secondPass = false;
    static int MAX_LINES = 10000;
    TreeMap<String, Integer> attributeSize = new TreeMap();
    ArrayList<DXEntry> entries = new ArrayList();
    boolean headerWritten = false;
    ArrayList<String> columnNames = null;
    int[] columnSizes;
    private static Logger log = Logger.getLogger(JXWCSVExportUtil.class.getName());

    public void saveTree(SmartTree tree, DN exportDN, File myFile, CBpbar pbar) throws IOException, NamingException {
        if (tree == null || exportDN == null || pbar == null || pbar.isCanceled()) {
            return;
        }
        FileWriter writer = new FileWriter(myFile);
        DataBroker broker = tree.getDataSource();
        this.readCSVTree(exportDN, writer, broker, pbar);
        this.writeCSVEntries(writer, pbar);
        writer.close();
        if (this.largePathalogicalFile) {
            log.warning("Large Pathalogical File Encountered - starting second pass");
            FileWriter newWriter = this.prepareForSecondPass(writer, myFile, pbar);
            this.readCSVTree(exportDN, newWriter, broker, pbar);
            newWriter.close();
        }
    }

    private void setLargePathalogicalFile(boolean state) {
        this.largePathalogicalFile = state;
        Thread.dumpStack();
    }

    public void saveList(SmartTree tree, DN exportDN, File myFile, CBpbar pbar) throws IOException {
        if (tree == null || exportDN == null || pbar == null || pbar.isCanceled()) {
            return;
        }
        DataBroker broker = tree.getDataSource();
        FileWriter writer = new FileWriter(myFile);
        ArrayList searchNodes = tree.getAllNodes(exportDN);
        pbar.push(searchNodes.size());
        for (DN node : searchNodes) {
            this.readAndStoreEntry(node, writer, broker, pbar);
            pbar.inc();
        }
        this.writeCSVEntries(writer, pbar);
        writer.close();
        if (this.largePathalogicalFile) {
            FileWriter newWriter = this.prepareForSecondPass(writer, myFile, pbar);
            pbar.push(searchNodes.size());
            for (DN node : searchNodes) {
                this.readAndStoreEntry(node, newWriter, broker, pbar);
            }
            newWriter.close();
        }
    }

    public void readCSVTree(DN treeApex, FileWriter writer, DataBroker broker, CBpbar pbar) {
        DXNamingEnumeration children = null;
        try {
            if (!treeApex.isEmpty()) {
                this.readAndStoreEntry(treeApex, writer, broker, pbar);
            }
            children = broker.unthreadedList(treeApex);
        }
        catch (NamingException e) {
            log.warning("error listing " + treeApex + " : " + e.getMessage());
        }
        if (children != null) {
            pbar.push(children.size());
            while (children != null && children.hasMore()) {
                String subDNString = ((NameClassPair)children.next()).getName();
                DN child = new DN(treeApex);
                DN subDN = new DN(subDNString);
                try {
                    child.addChildRDN(subDN.getLowestRDN());
                    this.readCSVTree(child, writer, broker, pbar);
                }
                catch (InvalidNameException e) {
                    log.warning("unexpected error appending " + subDN + " to children of " + child + " : " + e.getMessage());
                }
            }
            pbar.pop();
        }
    }

    private void readAndStoreEntry(DN nodeDN, FileWriter writer, DataBroker broker, CBpbar pbar) {
        try {
            DXEntry entry = broker.unthreadedReadEntry(nodeDN, null);
            if (entry != null) {
                if (this.secondPass) {
                    this.writeCSVEntry(entry, writer);
                    pbar.inc();
                } else {
                    this.scanAttributeNamesAndSizes(entry);
                    this.entries.add(entry);
                    long mem = Runtime.getRuntime().freeMemory();
                    if (this.entries.size() > 1 && mem < 100000L) {
                        log.severe("Forced write due to Memory shortage: " + mem + " (" + (mem < 100000L) + ")");
                        this.writeCSVEntries(writer, pbar);
                        this.entries.clear();
                        System.gc();
                    }
                }
            }
        }
        catch (NamingException e) {
            log.warning("unable to read node " + nodeDN + " : " + e.getMessage());
        }
        catch (Exception e) {
            log.warning("error processing node " + nodeDN + " : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void scanAttributeNamesAndSizes(DXEntry entry) {
        String[] attributeIDs;
        for (String attID : attributeIDs = entry.toIDStringArray()) {
            if (this.attributeSize.containsKey(attID)) {
                int size = entry.get(attID).size();
                if (size <= 1 || this.attributeSize.get(attID) >= size) continue;
                this.attributeSize.put(attID, size);
                continue;
            }
            if (this.headerWritten && !this.largePathalogicalFile) {
                this.setLargePathalogicalFile(true);
            }
            this.attributeSize.put(attID, entry.get(attID).size());
        }
    }

    public void writeCSVEntries(FileWriter writer, CBpbar pbar) throws IOException {
        if (!this.headerWritten) {
            this.writeCSVHeader(writer);
        } else if (this.largePathalogicalFile && !this.secondPass) {
            return;
        }
        pbar.reset(CBIntText.get((String)"writing entries"));
        pbar.push(this.entries.size());
        for (DXEntry entry : this.entries) {
            this.writeCSVEntry(entry, writer);
            pbar.inc();
        }
    }

    public void writeCSVHeader(FileWriter writer) throws IOException {
        writer.write(this.getHeaderString());
        this.headerWritten = true;
    }

    String getHeaderString() {
        StringBuffer header = new StringBuffer();
        header.append("dn");
        String objectClassID = null;
        if (this.attributeSize.containsKey("objectClass")) {
            objectClassID = "objectClass";
        } else if (this.attributeSize.containsKey("objectclass")) {
            objectClassID = "objectclass";
        } else if (this.attributeSize.containsKey("oc")) {
            objectClassID = "oc";
        }
        this.columnNames = new ArrayList<String>(this.attributeSize.keySet());
        this.columnNames.remove(objectClassID);
        if (objectClassID != null) {
            this.columnNames.add(0, objectClassID);
        }
        if (JXWCSVFieldBuffer.binaryHandling == JXWCSVFieldBuffer.binaryHandlingEnum.ignore) {
            for (String att : this.attributeSize.keySet()) {
                if (DXAttribute.isString((String)att)) continue;
                this.columnNames.remove(att);
            }
        }
        this.columnSizes = new int[this.columnNames.size()];
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String attributeName = this.columnNames.get(i);
            if (JXWCSVFieldBuffer.useMultipleColumns) {
                int attributeMaxSize;
                this.columnSizes[i] = attributeMaxSize = this.attributeSize.get(attributeName).intValue();
                for (int j = 0; j < attributeMaxSize; ++j) {
                    header.append(JXWCSVFieldBuffer.columnDelimeter + attributeName);
                }
                continue;
            }
            this.columnSizes[i] = 1;
            header.append(JXWCSVFieldBuffer.columnDelimeter + attributeName);
        }
        header.append("\n");
        return header.toString();
    }

    protected void writeCSVEntry(DXEntry entry, FileWriter writer) throws IOException {
        writer.write(this.formatEntryToCSV(entry));
    }

    String formatEntryToCSV(DXEntry entry) {
        StringBuffer csvLine = new StringBuffer();
        csvLine.append(this.formatValue("dn", entry.getDN().toString()));
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String attributeName = this.columnNames.get(i);
            int maxSize = this.columnSizes[i];
            DXAttribute att = entry.get(attributeName);
            int currentSize = 0;
            if (att != null) {
                att.sort();
                Object[] vals = att.getValues();
                if (i == 0) {
                    vals = this.doSpecialSortForObjectClass(vals);
                }
                for (int j = 0; j < vals.length; ++j) {
                    currentSize = att.size();
                    if (JXWCSVFieldBuffer.useMultipleColumns) {
                        csvLine.append(JXWCSVFieldBuffer.columnDelimeter);
                    } else if (j == 0) {
                        csvLine.append(JXWCSVFieldBuffer.columnDelimeter);
                    } else {
                        csvLine.append(JXWCSVFieldBuffer.multiValuedAttDelimeter);
                    }
                    Object rawValue = vals[j];
                    csvLine.append(this.formatValue(attributeName, rawValue));
                }
            }
            for (int j = currentSize; j < maxSize; ++j) {
                csvLine.append(JXWCSVFieldBuffer.columnDelimeter);
            }
        }
        csvLine.append("\n");
        return csvLine.toString();
    }

    public Object[] doSpecialSortForObjectClass(Object[] vals) {
        if (vals == null || vals.length == 0 || vals.length == 1) {
            return vals;
        }
        for (int i = 0; i < vals.length; ++i) {
            for (int j = i + 1; j < vals.length; ++j) {
                if (((String)vals[j]).length() <= ((String)vals[i]).length()) continue;
                String swap = (String)vals[j];
                vals[j] = vals[i];
                vals[i] = swap;
            }
        }
        return vals;
    }

    public FileWriter prepareForSecondPass(FileWriter writer, File myFile, CBpbar pbar) throws IOException {
        log.severe("large variable file handling triggered - starting second pass while deleting file");
        Thread.dumpStack();
        writer.flush();
        writer.close();
        myFile.delete();
        this.entries.clear();
        System.gc();
        pbar.reset(CBIntText.get((String)"Second Pass Required"));
        this.setLargePathalogicalFile(false);
        this.headerWritten = false;
        this.secondPass = true;
        FileWriter newWriter = new FileWriter(myFile);
        this.writeCSVHeader(newWriter);
        return newWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String formatValue(String attributeName, Object value) {
        JXWCSVFieldBuffer val;
        block10: {
            val = new JXWCSVFieldBuffer();
            if (DXAttribute.isString((String)attributeName)) {
                val = new JXWCSVFieldBuffer(value.toString());
            } else {
                try {
                    byte[] b = (byte[])value;
                    if (b == null) {
                        val.append("null");
                        break block10;
                    }
                    if (b.length == 0) break block10;
                    if (JXWCSVFieldBuffer.binaryHandling == JXWCSVFieldBuffer.binaryHandlingEnum.useBase64) {
                        val.append(new String(CBBase64.encode((byte[])b)));
                        break block10;
                    }
                    if (JXWCSVFieldBuffer.binaryHandling == JXWCSVFieldBuffer.binaryHandlingEnum.useHex) {
                        val.append(CBParse.bytes2Hex((byte[])b));
                    } else if (JXWCSVFieldBuffer.binaryHandling != JXWCSVFieldBuffer.binaryHandlingEnum.ignore) {
                        // empty if block
                    }
                }
                catch (ClassCastException cce) {
                    log.info("parse error - tried to save [" + attributeName + "] value as byte array");
                    val = new JXWCSVFieldBuffer(value.toString());
                }
                catch (Exception e) {
                    log.warning("error trying to save [" + attributeName + "] value as byte array " + e.getMessage());
                    val = new JXWCSVFieldBuffer("error (" + e.getMessage() + ")");
                }
            }
        }
        val.escape();
        return val.toString();
    }
}

