/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSBox;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.SWTBox;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    NSView contentView;
    String text = "";
    boolean ignoreResize;
    int hMargin;
    int vMargin;

    public Group(Composite parent, int style) {
        super(parent, Group.checkStyle(style));
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        NSBox widget = (NSBox)this.view;
        NSRect newRect = new NSRect();
        newRect.x = x;
        newRect.y = y;
        newRect.width = width;
        newRect.height = height;
        NSRect oldRect = widget.frame();
        this.ignoreResize = true;
        widget.setFrameFromContentFrame(newRect);
        newRect = widget.frame();
        widget.setFrame(oldRect);
        this.ignoreResize = false;
        x = (int)Math.ceil(newRect.x) - this.hMargin;
        y = (int)Math.ceil(newRect.y) - this.vMargin;
        width = (int)Math.ceil(newRect.width) + this.hMargin * 2;
        height = (int)Math.ceil(newRect.height) + this.vMargin * 2;
        return super.computeTrim(x, y, width, height);
    }

    @Override
    NSView contentView() {
        return this.contentView;
    }

    @Override
    void createHandle() {
        this.state |= 0x800;
        NSBox widget = (NSBox)new SWTBox().alloc();
        widget.init();
        widget.setTitlePosition(0L);
        NSSize margins = widget.contentViewMargins();
        this.hMargin = (int)margins.width;
        this.vMargin = (int)margins.height;
        widget.setContentViewMargins(new NSSize());
        NSView contentWidget = (NSView)new SWTView().alloc();
        contentWidget.init();
        widget.setContentView(contentWidget);
        this.contentView = contentWidget;
        this.view = widget;
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.boxFont;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.contentView);
        SWTBox box = (SWTBox)this.view;
        this.display.removeWidget(box.titleCell());
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    @Override
    NSView eventView() {
        return this.contentView;
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        NSRect rect = this.contentView.bounds();
        int width = Math.max(0, (int)rect.width - this.hMargin * 2);
        int height = Math.max(0, (int)rect.height - this.vMargin * 2);
        return new Rectangle((int)rect.x + this.hMargin, (int)rect.y + this.vMargin, width, height);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    boolean isTransparent() {
        return true;
    }

    @Override
    float getThemeAlpha() {
        return (this.background != null ? 1.0f : 0.25f) * this.parent.getThemeAlpha();
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.contentView, this);
        SWTBox box = (SWTBox)this.view;
        this.display.addWidget(box.titleCell(), this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.contentView != null) {
            this.contentView.release();
        }
        this.contentView = null;
    }

    @Override
    void resized() {
        if (!this.ignoreResize) {
            super.resized();
        }
    }

    @Override
    void setFont(NSFont font) {
        ((NSBox)this.view).setTitleFont(font);
    }

    @Override
    void setForeground(double[] color) {
        NSColor nsColor = color == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(color[0], color[1], color[2], 1.0);
        NSTextFieldCell cell = new NSTextFieldCell(((NSBox)this.view).titleCell().id);
        cell.setTextColor(nsColor);
    }

    @Override
    void setOrientation() {
        int direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        NSTextFieldCell cell = new NSTextFieldCell(((NSBox)this.view).titleCell().id);
        cell.setBaseWritingDirection(direction);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        NSBox box = (NSBox)this.view;
        box.setTitlePosition(length == 0 ? 0L : 2L);
        box.setTitle(NSString.stringWithCharacters(buffer, length));
    }
}

