/***************************************************************************
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CODONMODEL_H
#define CODONMODEL_H

#include "basem.h"
#include "constant.h"

const int CODON_LENGTH = 3; // condon is a triplet of nucleotides
const int STOP_CODON = -1;
const int MAX_CODON_WITH_STOP = 64;

const int CPG_ABSENT = 0;
const int CPG_PRESENT = 1;
/**
	codon to amino acid map
*/
struct CodonAAMap {
	char name[CODON_LENGTH + 1];
	int amino_acid; // the equivalent amino acid
	char CpG_status; // absent or present
};

/**
	codon nucleotide order in the map
*/
const char codon_nt_order[NUM_BASE] = {'T', 'C', 'A', 'G'};

/**
	the codon-amino acid map
*/
const CodonAAMap codon_aa_map[MAX_CODON_WITH_STOP] = {
	{ "TTT", STATE_F },
	{ "TTC", STATE_F },
	{ "TTA", STATE_L },
	{ "TTG", STATE_L },
	{ "TCT", STATE_S },
	{ "TCC", STATE_S },
	{ "TCA", STATE_S },
	{ "TCG", STATE_S },
	{ "TAT", STATE_Y },
	{ "TAC", STATE_Y },
	{ "TAA", STOP_CODON },
	{ "TAG", STOP_CODON },
	{ "TGT", STATE_C },
	{ "TGC", STATE_C },
	{ "TGA", STOP_CODON },
	{ "TGG", STATE_W },
	{ "CTT", STATE_L },
	{ "CTC", STATE_L },
	{ "CTA", STATE_L },
	{ "CTG", STATE_L },
	{ "CCT", STATE_P },
	{ "CCC", STATE_P },
	{ "CCA", STATE_P },
	{ "CCG", STATE_P },
	{ "CAT", STATE_H },
	{ "CAC", STATE_H },
	{ "CAA", STATE_Q },
	{ "CAG", STATE_Q },
	{ "CGT", STATE_R },
	{ "CGC", STATE_R },
	{ "CGA", STATE_R },
	{ "CGG", STATE_R },
	{ "ATT", STATE_I },
	{ "ATC", STATE_I },
	{ "ATA", STATE_I },
	{ "ATG", STATE_M },
	{ "ACT", STATE_T },
	{ "ACC", STATE_T },
	{ "ACA", STATE_T },
	{ "ACG", STATE_T },
	{ "AAT", STATE_N },
	{ "AAC", STATE_N },
	{ "AAA", STATE_K },
	{ "AAG", STATE_K },
	{ "AGT", STATE_S },
	{ "AGC", STATE_S },
	{ "AGA", STATE_R },
	{ "AGG", STATE_R },
	{ "GTT", STATE_V },
	{ "GTC", STATE_V },
	{ "GTA", STATE_V },
	{ "GTG", STATE_V },
	{ "GCT", STATE_A },
	{ "GCC", STATE_A },
	{ "GCA", STATE_A },
	{ "GCG", STATE_A },
	{ "GAT", STATE_D },
	{ "GAC", STATE_D },
	{ "GAA", STATE_E },
	{ "GAG", STATE_E },
	{ "GGT", STATE_G },
	{ "GGC", STATE_G },
	{ "GGA", STATE_G },
	{ "GGG", STATE_G }	
};

/**
 codon list
*/
extern CodonAAMap codon_list[NUM_CODON];

// index from 64 to 61
extern int codon_index[MAX_CODON_WITH_STOP];

const char 
	CPG_UNCHANGED = 0,
	CPG_GAINED = 1,
	CPG_LOST = 2;
	

struct CodonTransInfo {
	char source, dest; // source and destination nucleotides
	bool is_transition; // true of it is a transition
	bool is_synonymous; // true of it is a synonymous 
	char CpG_status; // 0: unchanged, 1: gained, 2: lost
	char position; // position of substitution, either 1, 2, or 3
};

extern CodonTransInfo codon_trans[NUM_CODON][NUM_CODON];

/**
	Grantham below-diagonal matrix, taken from PAML package
*/
const int grantham_half_matrix[] = {
111,  
111,  85,  
126,  96,  23,  
195, 180, 139, 154,  
 91,  43,  46,  61, 154,  
107,  54,  41,  45, 170,  29,  
 60, 125,  79,  94, 158,  87,  98,  
 86,  29,  68,  81, 174,  24,  41,  98,  
 94,  98, 149, 168, 197, 109, 134, 136,  94,  
 96, 102, 153, 172, 198, 113, 139, 138,  99,   5,  
106,  26,  94, 102, 202,  53,  57, 127,  32, 102, 107,  
 85,  92, 141, 160, 196, 101, 126, 127,  86,  10,  14,  95,  
113,  97, 158, 177, 205, 116, 140, 153, 100,  21,  22, 102,  29,  
 27, 103,  90, 108, 169,  75,  94,  42,  76,  96,  98, 103,  87, 114,  
 99, 109,  46,  66, 112,  68,  80,  55,  89, 142, 144, 121, 135, 155,  73,  
 58,  71,  65,  85, 149,  41,  66,  59,  47,  89,  92,  78,  81, 103,  38,  58,  
148, 101, 174, 191, 215, 130, 152, 184, 115,  61,  61, 110,  67,  40, 147, 177, 129,  
112,  77, 142, 160, 194,  99, 123, 147,  83,  33,  36,  85,  35,  22, 110, 143,  92,  37,  
 65,  96, 133, 152, 191,  96, 121, 109,  84,  30,  32,  97,  22,  50,  68, 123,  70,  88,  55  
};

/**
	build the codon information
*/
void buildCodonInfo();


/**
The Codon based Model

@author Bui Quang Minh
*/
class CodonModel : public BaseM
{
public:
	/**
		constructor
	*/
    CodonModel();

	/**
		all things are inited here
	*/
	virtual void init ();


	/**
		Reinitialize
	*/
	void reInit ();
		
	
	/**
		calculate the rate parameters (not rate matrix)
	*/
	virtual void calcRateParameters();

	
	/**
		compute negative log likelihood
	*/
	virtual double cmpNegLogLi (double value);
	
	/**
		optimize parameters
	*/
	virtual bool optPam ();	
		
	/**
		destructor
	*/
    ~CodonModel();


	/**
		set v parameter (for Codon Goldman Yang model 1994)
	*/
	void setVParm (const double vparm);


	/**
		get V parameter
	*/
	virtual double getVParm ();
		
	
protected:

	/**
		v parameter (used for codon based model by Goldman & Yang 1994)
	*/
	double v_parm;

	
};

#endif
