/***************************************************************************
 *                                                                         *
 *   innd.cpp       (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "innd.h"
#include "ali.h"
#include <iostream>


/*the InNd class contain all necessary information and methods for an in nd
...being specified more
*/

//constructor function for all intializing before using object
InNd::InNd () {
	id_ = -1;
	maxNExNd_ = alignment.getNSeq ();
	setLimit (maxNExNd_);
}

//--------------------------------------------------------------------
//clean all content of this internal node
void InNd::clean () {
	id_ = -1;
	brNoLs_.clean ();
	neiNdNoLs_.clean ();
}

//--------------------------------------------------------------------
//set the indentical number for this in nd
void InNd::setId (const int id) {
	id_ = id;
}

//--------------------------------------------------------------------
//check if this ndNo is an external node
int InNd::isExNd (int ndNo) {
	if (ndNo < maxNExNd_)
		return 1;
	else
		return 0;
}

//--------------------------------------------------------------------
//set the maximum number of external nodes
void InNd::setMaxNExNd(const int maxNExNd) {
	maxNExNd_ = maxNExNd;
}


int InNd::getSibNd (int sibNdNo) {
	if (neiNdNoLs_[1] == sibNdNo)
		return neiNdNoLs_[2];
	else
		return neiNdNoLs_[1];
}

//--------------------------------------------------------------------
//get the maximum number of external nodes
int InNd::getMaxNExNd() {
	return maxNExNd_;
}

//all things is inited here
void InNd::init () {}

//--------------------------------------------------------------------
//get the indentical number of this in nd
int InNd::getId () {
	return id_;
}

//--------------------------------------------------------------------
//add one nei nd of this nd
void InNd::addNeiNd (int neiNdNo) {
	neiNdNoLs_ += neiNdNo;
}

//--------------------------------------------------------------------
//add three nei nds of this nd
void InNd::addNeiNd (int neiNdNo0, int neiNdNo1, int neiNdNo2) {
	neiNdNoLs_ += neiNdNo0;
	neiNdNoLs_ += neiNdNo1;
	neiNdNoLs_ += neiNdNo2;
}

//--------------------------------------------------------------------
//add one br contact this nd and one of it's nei nd
void InNd::addBr (int brNo) {
	brNoLs_ += brNo;
}

//--------------------------------------------------------------------
//add three bres contact this nd and one of it's nei nd
void InNd::addBr (int brNo0, int brNo1, int brNo2) {
	brNoLs_ += brNo0;
	brNoLs_ += brNo1;
	brNoLs_ += brNo2;
}


//--------------------------------------------------------------------
//copy an in nd into this in nd, copy only different information
void InNd::copy (InNd &inNd) {
	this->id_ = inNd.getId ();
	if (id_ == -1)
		return ;

	this->neiNdNoLs_ = inNd.getNeiNd ();
	this->brNoLs_ = inNd.getBr ();
}

//--------------------------------------------------------------------
//return the neighbor node no list
Vec<int> &InNd::getNeiNd () {
	return neiNdNoLs_;
}


//--------------------------------------------------------------------
//return the br list
Vec<int> &InNd::getBr () {
	return brNoLs_;
}

//--------------------------------------------------------------------
//return brNoLs_[index];
int InNd::getBr (const int index) {
	return brNoLs_[index];
}

//--------------------------------------------------------------------
//return neiNdNoLs_[index];
int InNd::getNeiNd (const int index) {
	return neiNdNoLs_[index];
}

//--------------------------------------------------------------------
//return the neighbor node no list satisfying neiNdNoLs[0] < neiNdNoLs[1] ...
void InNd::getOrderNeiNd (Vec<int> &orderNeiNdNoLs) {
	getOrderNeiNd (orderNeiNdNoLs[0], orderNeiNdNoLs[1], orderNeiNdNoLs[2]);
}

//--------------------------------------------------------------------
//return the neighbor node no list satisfying smallNdNo < middleNdNo < greatNdNo
void InNd::getOrderNeiNd (int &smallNeiNdNo, int &midNeiNdNo, int &greatNeiNdNo) {
	smallNeiNdNo = Utl::getMin (neiNdNoLs_[0], neiNdNoLs_[1], neiNdNoLs_[2]);
	midNeiNdNo = Utl::getMid (neiNdNoLs_[0], neiNdNoLs_[1], neiNdNoLs_[2]);
	greatNeiNdNo = Utl::getMax (neiNdNoLs_[0], neiNdNoLs_[1], neiNdNoLs_[2]);
}

//--------------------------------------------------------------------
//get 2 remain neighbor node no of this internal node
void InNd::get2RemNeiNd (const int existNeiNdNo, int &remNeiNdNo1, int &remNeiNdNo2) {
	remNeiNdNo1  = -1;
	remNeiNdNo2  = -1;
	for (int count_ = 0; count_ < 3; count_ ++)
		if (neiNdNoLs_[count_] != existNeiNdNo)
			if (remNeiNdNo1 == -1)
				remNeiNdNo1 = neiNdNoLs_[count_];
			else
				remNeiNdNo2 = neiNdNoLs_[count_];
}

//--------------------------------------------------------------------
//get 2 remain branch no of this internal node
void InNd::get2RemBr (const int existBrNo, int &remBrNo1, int &remBrNo2) {
	remBrNo1  = -1;
	remBrNo2  = -1;
	for (int countBr_ = 0; countBr_ < 3; countBr_ ++)
		if (brNoLs_[countBr_] != existBrNo)
			if (remBrNo1 == -1)
				remBrNo1 = brNoLs_[countBr_];
			else
				remBrNo2 = brNoLs_[countBr_];
}

//--------------------------------------------------------------------
//get 2 remain neighbor nodes, and 2 remain branches no of this internal node
void InNd::get2RemNeiNdBr (const int existNeiNdNo, int &remNeiNdNo1, int &remBrNo1, int &remNeiNdNo2, int &remBrNo2) {
	remNeiNdNo1  = -1;
	remNeiNdNo2  = -1;
	for (int count_ = 0; count_ < 3; count_ ++)
		if (neiNdNoLs_[count_] != existNeiNdNo)
			if (remNeiNdNo1 == -1) {
				remNeiNdNo1 = neiNdNoLs_[count_];
				remBrNo1 = brNoLs_[count_];
			} else {
				remNeiNdNo2 = neiNdNoLs_[count_];
				remBrNo2 = brNoLs_[count_];
			}
}

//--------------------------------------------------------------------
//change the nei of this nd
void InNd::changeNeiNd (int oldNeiNdNo, int newNeiNdNo) {
	neiNdNoLs_.changeItem (oldNeiNdNo, newNeiNdNo);
}

//--------------------------------------------------------------------
//change the br of this nd
void InNd::changeBr (int oldBrNo, int newBrNo) {

	brNoLs_.changeItem (oldBrNo, newBrNo);
}

//--------------------------------------------------------------------
//copy an in nd into this in nd
void InNd::operator = (InNd &inNd) {
	copy(inNd);
}

//--------------------------------------------------------
/*
order the neighbor node and branch list of this liInNd. 
The first neighbor is the parent arccording to artInRoot and artExRoot
*/
void InNd::orderNeiNd (const int parNdNo) {
	for (int count_ = 0; count_ < neiNdNoLs_.getSize (); count_ ++) {
		int neiNdNo_ = neiNdNoLs_[count_];
		if (neiNdNo_ == parNdNo) {//it means that, now neiNdNo_ is the parent node of this internal node
			Utl::swap (neiNdNoLs_[0], neiNdNoLs_[count_]);
			Utl::swap (brNoLs_[0], brNoLs_[count_]);
			break;
		}
	}
}


//--------------------------------------------------------------------
//find the brNo which is company which this neiNdNo
int InNd::findComBr (int neiNdNo) {
	for (int count_ = 0; count_ < neiNdNoLs_.getSize (); count_ ++)
		if (neiNdNoLs_[count_] == neiNdNo)
			return brNoLs_[count_];

	return -1;
}

//--------------------------------------------------------------------
//this function is for the futher
void InNd::setLimit (int maxNExNd) {
	maxNExNd_ = maxNExNd;
	neiNdNoLs_.setLimit (MAX_NUM_NEI_ND);
	brNoLs_.setLimit (MAX_NUM_NEI_ND);
}


//--------------------------------------------------------------------
//release all memory of this class
void InNd::release () {
	brNoLs_.release ();
	neiNdNoLs_.release ();
}

//--------------------------------------------------------------------
//destructor function for all releasing before deleting object
InNd::~InNd () {
	release ();
	//  std::cout << "this is the destructor function of InNd class" << endl;
}
