/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          seq.h  -  description
                             -------------------
    begin                : Thu Feb 20 2003
    copyright            : (C) 2003 by Vinh Le Sy and Arndt von Haeseler
    email                : vinh@cs.uni-duesseldorf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SEQ_H
#define SEQ_H

#include <fstream>
#include "constant.h"
#include "vec.h"


/*
The Seq class contains all information and mothods for DNA seqs and Protein seqs.
...Being specified more
*/
class Seq : public Vec<char> {
public :
	//constructor function
	Seq ();

	//set identification for this seq
	void setId (const int id);

	//get the identification of this seq
	int getId ();

	//all things are inited here
	void init ();

	//read information of this sequence from text file
	int readInput (std::ifstream &in, int nSite_, int isFirstRead);

	//return the number of sites of this sequences
	int getNSite ();

	//copy the input sequence into this one
	void operator = (Seq &seq);

	//--------------------------------------------------------------------
	//write all information of this sequence
	template <class Tout>
	Tout &write (Tout &out) {
		name_.writeItem (out) << " ";
		for (int i = name_.getSize(); i < 10; i++) out << " ";
		writeItem (out) << endl;
		return out;
	}


	//check whether or not the base frequence of this sequence has been cmped
	int isBaseFrqCmped ();

	//return the name of this sequence
	Vec<char> &getName ();

	//release all memmory for this class
	void release ();

	//destructor function
	virtual ~Seq ();

	/********************************************************************************
	********************************************************************************
	********************************************************************************
	********************************************************************************
	********************************************************************************
	********************************************************************************/

private :

	//the identification of this sequence
	int id_;

	//the base frequences of this sequence
	Vec<double> baseFrqArr_;

	Vec<char> name_;


	//get the name of this sequences from the line in the input file
	int getName (const char *aLine, Vec<char> &name);

	//get the content of this sequences from the line in the input file
	int getContent (const char *aLine, int pos);

}
; //end of class

#endif
