/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "treels.h"

//the constructor
TreeLs::TreeLs () {
	nTree_ = 0;
}

//=================================================================
//set the limit for this list
void TreeLs::setLimit (int limit) {
	items_.set (limit, 0);
}

//=================================================================
//clean all content of this quartet puzzle tree list
void TreeLs::clean () {
	nTree_ = 0;
	items_.clean ();
}

//=================================================================
/*it returns index, where the existed quartet puzzle tree is the same
the input quartet puzzle tree
            -1, otherwise */
int TreeLs::find (UrTree &tree) {
	for (int index_ = nTree_ - 1; index_ >= 0; index_ --) {
		if (items_[index_] == tree)
			return index_;
	}
	return -1;
}

int TreeLs::findRank (UrTree &tree) {
	int pos_ = find (tree);
	if (pos_ == -1)
		return -1;
	Vec<int> idArr_ (nTree_, nTree_);
	for (int id_ = 0; id_ < nTree_; id_ ++)
		idArr_[id_] = id_;

	for (int count0_ = 0; count0_ < nTree_; count0_ ++) {
		for (int count1_ = count0_ + 1; count1_ < nTree_; count1_ ++) {
			int id0_ = idArr_[count0_];
			int id1_ = idArr_[count1_];
			if (items_[id0_].getLogLi () < items_[id1_].getLogLi () )
				Utl::swap (idArr_[count0_], idArr_[count1_]);
		}
	}

	for (int count_ = 0; count_ < nTree_; count_ ++)
		if (idArr_[count_] == pos_) {
			return count_;
		}

	return -1;
}

//=================================================================
//add the input tree into this list
void TreeLs::operator += (UrTree &tree) {
	items_ += tree;
	nTree_ ++;
	//  std::cout << nTree_ << " ";
	//  std::cout << "number different quartet puzzle trees is " << nTree_ << endl;
}

//=================================================================
//return items_[index]
UrTree &TreeLs::operator [] (const int index) {
	return items_[index];
}

//=================================================================
//release all memory of this class
void TreeLs::release () {
	int realLimit_ = items_.getLimit ();
	items_.setSize (realLimit_);
	for (int count_ = 0; count_ < realLimit_; count_ ++)
		items_[count_].release ();
	items_.release ();
}

int TreeLs::getSize () {
	return nTree_;
}

//=================================================================
//the constructor
TreeLs::~TreeLs () {
	release ();
}
