/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   Source code here taken from TREE-PUZZLE package               
 * (c) 2003-2004 by Heiko A. Schmidt, Korbinian Strimmer, Arndt von Haeseler
 * (c) 1999-2003 by Heiko A. Schmidt, Korbinian Strimmer,
 *                  M. Vingron, and Arndt von Haeseler
 * (c) 1995-1999 by Korbinian Strimmer and Arndt von Haeseler
 
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "constant.h"
#include "wag.h"
#include "dvec20.h"
#include "dmat20.h"


//this part are taken from PUZZLE-TREE
void WAGM::getData(DMat20 &q, DVec20 &f) {
	if (isMasterProc())
		std::cout <<"Using WAG model" << endl;
	/*
	 * WAG model of amino acid evolution
	 * 
	 * S. Whelan and N. Goldman.  2000.  In prep.
	 * 
	               * presented at the MASAMB-X workshop in Cambridge
	               *
	               * Whelan, S., and N. Goldman.  2000.  
	               * The WAG amino acid rate matrix.
	               * Manuscript in prep.
	 */

	/* Q matrix */
	q[0][1] = 0.610810; q[0][2] = 0.569079;
	q[0][3] = 0.821500; q[0][4] = 1.141050;
	q[0][5] = 1.011980; q[0][6] = 1.756410;
	q[0][7] = 1.572160; q[0][8] = 0.354813;
	q[0][9] = 0.219023; q[0][10] = 0.443935;
	q[0][11] = 1.005440; q[0][12] = 0.989475;
	q[0][13] = 0.233492; q[0][14] = 1.594890;
	q[0][15] = 3.733380; q[0][16] = 2.349220;
	q[0][17] = 0.125227; q[0][18] = 0.268987;
	q[0][19] = 2.221870;

	q[1][2] = 0.711690; q[1][3] = 0.165074;
	q[1][4] = 0.585809; q[1][5] = 3.360330;
	q[1][6] = 0.488649; q[1][7] = 0.650469;
	q[1][8] = 2.362040; q[1][9] = 0.206722;
	q[1][10] = 0.551450; q[1][11] = 5.925170;
	q[1][12] = 0.758446; q[1][13] = 0.116821;
	q[1][14] = 0.753467; q[1][15] = 1.357640;
	q[1][16] = 0.613776; q[1][17] = 1.294610;
	q[1][18] = 0.423612; q[1][19] = 0.280336;

	q[2][3] = 6.013660; q[2][4] = 0.296524;
	q[2][5] = 1.716740; q[2][6] = 1.056790;
	q[2][7] = 1.253910; q[2][8] = 4.378930;
	q[2][9] = 0.615636; q[2][10] = 0.147156;
	q[2][11] = 3.334390; q[2][12] = 0.224747;
	q[2][13] = 0.110793; q[2][14] = 0.217538;
	q[2][15] = 4.394450; q[2][16] = 2.257930;
	q[2][17] = 0.078463; q[2][18] = 1.208560;
	q[2][19] = 0.221176;

	q[3][4] = 0.033379; q[3][5] = 0.691268;
	q[3][6] = 6.833400; q[3][7] = 0.961142;
	q[3][8] = 1.032910; q[3][9] = 0.043523;
	q[3][10] = 0.093930; q[3][11] = 0.533362;
	q[3][12] = 0.116813; q[3][13] = 0.052004;
	q[3][14] = 0.472601; q[3][15] = 1.192810;
	q[3][16] = 0.417372; q[3][17] = 0.146348;
	q[3][18] = 0.363243; q[3][19] = 0.169417;

	q[4][5] = 0.109261; q[4][6] = 0.023920;
	q[4][7] = 0.341086; q[4][8] = 0.275403;
	q[4][9] = 0.189890; q[4][10] = 0.428414;
	q[4][11] = 0.083649; q[4][12] = 0.437393;
	q[4][13] = 0.441300; q[4][14] = 0.122303;
	q[4][15] = 1.560590; q[4][16] = 0.570186;
	q[4][17] = 0.795736; q[4][18] = 0.604634;
	q[4][19] = 1.114570;

	q[5][6] = 6.048790; q[5][7] = 0.366510;
	q[5][8] = 4.749460; q[5][9] = 0.131046;
	q[5][10] = 0.964886; q[5][11] = 4.308310;
	q[5][12] = 1.705070; q[5][13] = 0.110744;
	q[5][14] = 1.036370; q[5][15] = 1.141210;
	q[5][16] = 0.954144; q[5][17] = 0.243615;
	q[5][18] = 0.252457; q[5][19] = 0.333890;

	q[6][7] = 0.630832; q[6][8] = 0.635025;
	q[6][9] = 0.141320; q[6][10] = 0.172579;
	q[6][11] = 2.867580; q[6][12] = 0.353912;
	q[6][13] = 0.092310; q[6][14] = 0.755791;
	q[6][15] = 0.782467; q[6][16] = 0.914814;
	q[6][17] = 0.172682; q[6][18] = 0.217549;
	q[6][19] = 0.655045;

	q[7][8] = 0.276379; q[7][9] = 0.034151;
	q[7][10] = 0.068651; q[7][11] = 0.415992;
	q[7][12] = 0.194220; q[7][13] = 0.055288;
	q[7][14] = 0.273149; q[7][15] = 1.486700;
	q[7][16] = 0.251477; q[7][17] = 0.374321;
	q[7][18] = 0.114187; q[7][19] = 0.209108;

	q[8][9] = 0.152215; q[8][10] = 0.555096;
	q[8][11] = 0.992083; q[8][12] = 0.450867;
	q[8][13] = 0.756080; q[8][14] = 0.771387;
	q[8][15] = 0.822459; q[8][16] = 0.525511;
	q[8][17] = 0.289998; q[8][18] = 4.290350;
	q[8][19] = 0.131869;

	q[9][10] = 3.517820; q[9][11] = 0.360574;
	q[9][12] = 4.714220; q[9][13] = 1.177640;
	q[9][14] = 0.111502; q[9][15] = 0.353443;
	q[9][16] = 1.615050; q[9][17] = 0.234326;
	q[9][18] = 0.468951; q[9][19] = 8.659740;

	q[10][11] = 0.287583; q[10][12] = 5.375250;
	q[10][13] = 2.348200; q[10][14] = 0.462018;
	q[10][15] = 0.382421; q[10][16] = 0.364222;
	q[10][17] = 0.740259; q[10][18] = 0.443205;
	q[10][19] = 1.997370;

	q[11][12] = 1.032220; q[11][13] = 0.098843;
	q[11][14] = 0.619503; q[11][15] = 1.073780;
	q[11][16] = 1.537920; q[11][17] = 0.152232;
	q[11][18] = 0.147411; q[11][19] = 0.342012;

	q[12][13] = 1.320870; q[12][14] = 0.194864;
	q[12][15] = 0.556353; q[12][16] = 1.681970;
	q[12][17] = 0.570369; q[12][18] = 0.473810;
	q[12][19] = 2.282020;

	q[13][14] = 0.179896; q[13][15] = 0.606814;
	q[13][16] = 0.191467; q[13][17] = 1.699780;
	q[13][18] = 7.154480; q[13][19] = 0.725096;

	q[14][15] = 1.786490; q[14][16] = 0.885349;
	q[14][17] = 0.156619; q[14][18] = 0.239607;
	q[14][19] = 0.351250;

	q[15][16] = 4.847130; q[15][17] = 0.578784;
	q[15][18] = 0.872519; q[15][19] = 0.258861;

	q[16][17] = 0.126678; q[16][18] = 0.325490;
	q[16][19] = 1.547670;

	q[17][18] = 2.763540; q[17][19] = 0.409817;

	q[18][19] = 0.347826;

	/* original frequencies */
	f[ 0] = 0.0866;
	f[ 1] = 0.0440;
	f[ 2] = 0.0391;
	f[ 3] = 0.0570;
	f[ 4] = 0.0193;
	f[ 5] = 0.0367;
	f[ 6] = 0.0581;
	f[ 7] = 0.0833;
	f[ 8] = 0.0244;
	f[ 9] = 0.0485;
	f[10] = 0.0862;
	f[11] = 0.0620;
	f[12] = 0.0195;
	f[13] = 0.0384;
	f[14] = 0.0458;
	f[15] = 0.0695;
	f[16] = 0.0610;
	f[17] = 0.0144;
	f[18] = 0.0353;
	f[19] = 0.0709;
} /* wagdata */

