/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
#line 1 "rp2gen_parser.y" /* yacc.c:339  */
 /* BLURB gpl

                           Coda File System
                              Release 5

          Copyright (c) 1987-1999 Carnegie Mellon University
                  Additional copyrights listed below

This  code  is  distributed "AS IS" without warranty of any kind under
the terms of the GNU General Public Licence Version 2, as shown in the
file  LICENSE.  The  technical and financial  contributors to Coda are
listed in the file CREDITS.

                        Additional copyrights

#*/

/*
                         IBM COPYRIGHT NOTICE

                          Copyright (C) 1986
             International Business Machines Corporation
                         All Rights Reserved

This  file  contains  some  code identical to or derived from the 1986
version of the Andrew File System ("AFS"), which is owned by  the  IBM
Corporation.   This  code is provided "AS IS" and IBM does not warrant
that it is free of infringement of  any  intellectual  rights  of  any
third  party.    IBM  disclaims  liability of any kind for any damages
whatsoever resulting directly or indirectly from use of this  software
or  of  any  derivative work.  Carnegie Mellon University has obtained
permission to  modify,  distribute and sublicense this code,  which is
based on Version 2  of  AFS  and  does  not  contain  the features and
enhancements that are part of  Version 3 of  AFS.  Version 3 of AFS is
commercially   available   and  supported  by   Transarc  Corporation,
Pittsburgh, PA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rp2.h"

extern int yydebug;
extern int HeaderOnlyFlag;

extern char *copy();
extern RPC2_TYPE *rpc2_enum_type(), *rpc2_struct_type();
extern ENTRY *make_entry(), *find();
extern ENUM *make_enum();
extern VAR *make_var();
extern PROC *make_proc(), *check_proc();
extern void enter();
extern char *concat();
extern struct subsystem subsystem;
extern void no_storage(char *);
extern void spit_define(char *, char *);
extern void insert(PROC *proc);

/* Structure for handling IDENTIFIER lists */

#define MAX_IDS	100

struct {
    char	*ids[MAX_IDS];
    int		counter;
} id_list;

static char **make_id_array()
{
    register char **array;
    register int i;

    array = (char **) calloc(id_list.counter+1, sizeof(char *));
    if (array == NIL) no_storage("make_id_array");
    array[id_list.counter] = NIL;
    for (i=0, id_list.counter--; id_list.counter>=0; i++, id_list.counter--)
	array[i] = id_list.ids[id_list.counter];
    return array;
}

#define MAX_ENUMS	100

struct {
    ENUM	*enums[MAX_ENUMS];
    int		counter;
} enum_list;

static ENUM **make_enum_array()
{
    register ENUM **array;
    register int i;

    array = (ENUM **) calloc(enum_list.counter+1, sizeof(ENUM *));
    if (array == NIL) no_storage("make_enum_array");
    array[enum_list.counter] = NIL;
    for (i=0, enum_list.counter--; enum_list.counter>=0; i++, enum_list.counter--)
	array[i] = enum_list.enums[enum_list.counter];
    return array;
}

#define MAX_FORMALS	100

struct {
    VAR		*formals[MAX_FORMALS];
    int		counter;
} formal_list;

static VAR **make_formal_array()
{
    register VAR **array;
    register int i;

    array = (VAR **) calloc(formal_list.counter+1, sizeof(VAR *));
    if (array == NIL) no_storage("make_formal_array");
    array[formal_list.counter] = NIL;
    for (i=0, formal_list.counter--; formal_list.counter>=0; i++, formal_list.counter--)
	array[i] = formal_list.formals[formal_list.counter];
    return array;
}

#define MAX_VARS	100

struct {
    VAR		**vars[MAX_VARS];
    int		counter;
} var_list;

static int length(p)
    char **p;
{
    register int len;

    for (len=0; *p!=NIL; p++) len++;
    return len;
}

static VAR **make_var_array()
{
    register int count, i;
    register VAR **array;

    for (i=0, count=0; i<var_list.counter; i++) count += length((char **)var_list.vars[i]);
    array = (VAR **) calloc(count+1, sizeof(VAR *));
    if (array == NIL) no_storage("make_var_array");
    array[count] = NIL;

    /* Transfer to array */
    for (i=0, var_list.counter--; var_list.counter>=0; var_list.counter--) {
	register VAR **v;
	for (v = var_list.vars[var_list.counter]; *v != NIL; v++)
	    array[i++] = *v;
    }
    return array;
}

static char *createsize(name)
    char *name;
{
    return concat(name, "_size_");
}

static char *createmaxsize(name)
    char *name;
{
    return concat(name, "_size_max_");
}

int next_opnum = 1;


#line 239 "rp2gen_parser.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_RP_GEN_PARSER_H_INCLUDED
# define YY_YY_RP_GEN_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    IDENTIFIER = 258,
    NUMBER = 259,
    STRING = 260,
    SUBSYSTEM = 261,
    TIMEOUT = 262,
    DEFINE = 263,
    NEW_CONNECTION = 264,
    TYPEDEF = 265,
    RPC2_STRUCT = 266,
    RPC2_ENUM = 267,
    CLIENT = 268,
    SERVER = 269,
    PREFIX = 270,
    IN = 271,
    OUT = 272
  };
#endif
/* Tokens.  */
#define IDENTIFIER 258
#define NUMBER 259
#define STRING 260
#define SUBSYSTEM 261
#define TIMEOUT 262
#define DEFINE 263
#define NEW_CONNECTION 264
#define TYPEDEF 265
#define RPC2_STRUCT 266
#define RPC2_ENUM 267
#define CLIENT 268
#define SERVER 269
#define PREFIX 270
#define IN 271
#define OUT 272

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 187 "rp2gen_parser.y" /* yacc.c:355  */

    rp2_bool	u_bool;
    MODE	u_mode;
    char	*u_string;
    char	**u_string_array;
    RPC2_TYPE	*u_rpc2_type;
    ENTRY	*u_entry;
    ENUM	*u_enum;
    VAR		*u_var;
    VAR		**u_var_array;
    VAR		***u_var_array_array;
    int         u_int;

#line 327 "rp2gen_parser.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_RP_GEN_PARSER_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 342 "rp2gen_parser.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  9
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   101

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  28
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  36
/* YYNRULES -- Number of rules.  */
#define YYNRULES  61
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  115

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   272

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      19,    20,     2,     2,    23,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    27,    18,
       2,    24,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    25,     2,    26,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    21,     2,    22,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   227,   227,   230,   231,   232,   235,   241,   249,   254,
     261,   263,   266,   270,   274,   278,   280,   284,   285,   288,
     289,   290,   294,   296,   300,   315,   317,   319,   323,   333,
     337,   345,   352,   365,   369,   377,   384,   388,   396,   403,
     407,   409,   413,   417,   421,   434,   437,   442,   470,   493,
     497,   503,   505,   507,   511,   513,   517,   519,   523,   525,
     529,   537
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "IDENTIFIER", "NUMBER", "STRING",
  "SUBSYSTEM", "TIMEOUT", "DEFINE", "NEW_CONNECTION", "TYPEDEF",
  "RPC2_STRUCT", "RPC2_ENUM", "CLIENT", "SERVER", "PREFIX", "IN", "OUT",
  "';'", "'('", "')'", "'{'", "'}'", "','", "'='", "'['", "']'", "':'",
  "$accept", "file", "prefixes", "prefix", "header_line",
  "compatability_stuff", "subsystem_name", "id_number", "protocol_version",
  "default_timeout", "decl_or_proc_list", "decl_or_proc", "define",
  "typedef", "rpc2_type", "type_name", "rpc2_struct", "field_list",
  "field", "identifier_list", "identifier_list2", "rpc2_enum",
  "enum_val_list", "enum_val", "array_spec", "array_spec_var",
  "procedure_description", "opcode_number", "formal_list", "formal",
  "usage", "timeout_override", "new_connection", "DefinedNumber", "String",
  "empty", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,    59,    40,
      41,   123,   125,    44,    61,    91,    93,    58
};
# endif

#define YYPACT_NINF -34

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-34)))

#define YYTABLE_NINF -62

#define yytable_value_is_error(Yytable_value) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int8 yypact[] =
{
      -5,    -1,    13,    24,    23,    -5,   -34,     5,     5,   -34,
       5,    25,   -34,   -34,   -34,    12,    16,     9,   -34,    14,
     -34,   -34,   -34,   -34,   -34,   -34,    18,     9,   -34,   -34,
       9,    15,   -34,   -34,   -34,   -34,    19,     8,    34,     4,
     -34,   -34,   -34,   -34,    35,   -34,    22,   -34,    17,   -34,
      21,    26,    40,   -34,   -34,   -34,    27,   -34,   -34,   -34,
      45,    46,    28,    10,    47,    29,    45,    30,    33,    36,
       9,    38,   -34,    41,   -34,    32,    39,    45,   -34,    37,
      43,   -34,   -34,   -34,    53,   -34,    46,    42,   -34,   -34,
      56,    44,    48,   -34,    62,    47,   -34,   -34,   -34,   -34,
      50,    57,   -34,   -34,    10,   -34,   -34,     9,   -34,    49,
     -34,   -34,    52,   -34,   -34
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
      61,     0,     0,     0,    61,     4,     3,     0,     0,     1,
       0,    61,     9,     5,    60,     0,     0,    61,    12,     0,
      61,    16,     7,     6,    59,    58,     0,     0,    13,    11,
       0,     2,    18,     8,    10,    14,     0,     0,     0,     0,
      17,    20,    19,    21,     0,    46,     0,    45,     0,    28,
       0,     0,     0,    25,    26,    27,     0,    15,    22,    23,
       0,     0,    61,    61,     0,     0,    31,     0,     0,    38,
       0,     0,    41,    51,    52,     0,    61,     0,    49,    35,
       0,    33,    29,    30,     0,    36,     0,     0,    24,    53,
      61,     0,    48,    43,     0,     0,    32,    39,    37,    40,
       0,    61,    55,    42,    61,    50,    34,     0,    56,     0,
      57,    47,     0,    44,    54
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -34,   -34,   -34,    68,   -34,   -34,   -34,   -34,   -34,   -34,
     -34,   -34,   -34,   -34,   -34,   -33,   -34,    11,   -34,   -34,
     -21,   -34,   -11,   -34,   -34,   -34,   -34,   -34,   -26,   -34,
     -34,   -34,   -34,   -25,    -7,     0
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     3,     4,     5,    11,    26,    17,    27,    34,    20,
      31,    40,    41,    42,    52,    64,    54,    65,    66,    80,
      81,    55,    68,    69,    71,    92,    43,    44,    75,    76,
      77,   101,   109,    28,    15,    78
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
       6,    16,    35,    18,    12,    36,    53,    49,     1,     2,
      14,    21,    24,    25,     7,    50,    51,    29,   -61,    37,
      32,    58,    14,    38,     9,    39,    73,    74,     8,    10,
      22,    45,    19,    30,    23,    47,    33,    48,    56,    46,
      57,    59,    60,    62,    94,    87,    63,    61,    49,    67,
      79,    82,    90,    70,    84,    85,    88,    97,    89,    86,
      95,    96,    72,   100,    91,   105,   108,   113,    99,   107,
     103,   104,   114,    13,   106,    98,    93,    83,   111,     0,
       0,     0,   112,     0,     0,     0,     0,     0,     0,     0,
     102,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   110
};

static const yytype_int8 yycheck[] =
{
       0,     8,    27,    10,     4,    30,    39,     3,    13,    14,
       5,    11,     3,     4,    15,    11,    12,    17,     3,     4,
      20,     4,     5,     8,     0,    10,    16,    17,    15,     6,
      18,    31,     7,    19,    18,    27,    18,     3,     3,    20,
      18,    48,    21,     3,    77,    70,    19,    21,     3,     3,
       3,    22,    20,    25,    24,    22,    18,     4,    17,    23,
      23,    18,    62,     7,    25,     3,     9,    18,    26,    19,
      26,    23,    20,     5,    95,    86,    76,    66,   104,    -1,
      -1,    -1,   107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   101
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    13,    14,    29,    30,    31,    63,    15,    15,     0,
       6,    32,    63,    31,     5,    62,    62,    34,    62,     7,
      37,    63,    18,    18,     3,     4,    33,    35,    61,    63,
      19,    38,    63,    18,    36,    61,    61,     4,     8,    10,
      39,    40,    41,    54,    55,    63,    20,    27,     3,     3,
      11,    12,    42,    43,    44,    49,     3,    18,     4,    62,
      21,    21,     3,    19,    43,    45,    46,     3,    50,    51,
      25,    52,    63,    16,    17,    56,    57,    58,    63,     3,
      47,    48,    22,    45,    24,    22,    23,    61,    18,    17,
      20,    25,    53,    63,    43,    23,    18,     4,    50,    26,
       7,    59,    63,    26,    23,     3,    48,    19,     9,    60,
      63,    56,    61,    18,    20
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    28,    29,    30,    30,    30,    31,    31,    32,    32,
      33,    33,    34,    35,    36,    37,    37,    38,    38,    39,
      39,    39,    40,    40,    41,    42,    42,    42,    43,    44,
      45,    45,    46,    47,    48,    48,    49,    50,    50,    51,
      52,    52,    53,    53,    54,    55,    55,    56,    56,    56,
      57,    58,    58,    58,    59,    59,    60,    60,    61,    61,
      62,    63
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     4,     1,     1,     2,     4,     4,     4,     1,
       2,     1,     1,     1,     1,     5,     1,     2,     1,     1,
       1,     1,     3,     3,     5,     1,     1,     1,     1,     4,
       2,     1,     3,     1,     3,     1,     4,     3,     1,     3,
       3,     1,     2,     1,     8,     2,     1,     4,     2,     1,
       3,     1,     1,     2,     4,     1,     1,     1,     1,     1,
       1,     0
};


#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         (-2)
#define YYEOF           0

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;                                                  \
    }                                                           \
while (0)

/* Error token number */
#define YYTERROR        1
#define YYERRCODE       256



/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


# define YY_SYMBOL_PRINT(Title, Type, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Type, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*----------------------------------------.
| Print this symbol's value on YYOUTPUT.  |
`----------------------------------------*/

static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  YYUSE (yytype);
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyoutput, "%s %s (",
             yytype < YYNTOKENS ? "token" : "nterm", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yytype_int16 *yyssp, YYSTYPE *yyvsp, int yyrule)
{
  unsigned long int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       yystos[yyssp[yyi + 1 - yynrhs]],
                       &(yyvsp[(yyi + 1) - (yynrhs)])
                                              );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
yystrlen (const char *yystr)
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            /* Fall through.  */
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULLPTR, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULLPTR, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
{
  YYUSE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yytype);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}




/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        YYSTYPE *yyvs1 = yyvs;
        yytype_int16 *yyss1 = yyss;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * sizeof (*yyssp),
                    &yyvs1, yysize * sizeof (*yyvsp),
                    &yystacksize);

        yyss = yyss1;
        yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yytype_int16 *yyss1 = yyss;
        union yyalloc *yyptr =
          (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
                  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 6:
#line 236 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    extern char *server_prefix;
					    server_prefix = copy((yyvsp[-1].u_string)+1);
					    server_prefix[strlen(server_prefix)-1] = '\0';
					}
#line 1503 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 7:
#line 242 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    extern char *client_prefix;
					    client_prefix = copy((yyvsp[-1].u_string)+1);
					    client_prefix[strlen(client_prefix)-1] = '\0';
					}
#line 1513 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 8:
#line 250 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    subsystem.subsystem_name = copy((yyvsp[-2].u_string)+1);
					    subsystem.subsystem_name[strlen(subsystem.subsystem_name)-1] = '\0';
					}
#line 1522 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 9:
#line 255 "rp2gen_parser.y" /* yacc.c:1646  */
    {
			    printf("NO SUBSYSTEM SPECIFIED: only generating header file\n");
			    HeaderOnlyFlag = 1;
			    }
#line 1531 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 10:
#line 262 "rp2gen_parser.y" /* yacc.c:1646  */
    {}
#line 1537 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 12:
#line 267 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1543 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 13:
#line 271 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1549 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 14:
#line 275 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1555 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 15:
#line 279 "rp2gen_parser.y" /* yacc.c:1646  */
    { subsystem.timeout = (yyvsp[-2].u_string); }
#line 1561 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 16:
#line 281 "rp2gen_parser.y" /* yacc.c:1646  */
    { subsystem.timeout = NIL; }
#line 1567 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 21:
#line 291 "rp2gen_parser.y" /* yacc.c:1646  */
    {}
#line 1573 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 22:
#line 295 "rp2gen_parser.y" /* yacc.c:1646  */
    { if ((yyvsp[-2].u_bool)) spit_define((yyvsp[-1].u_string), (yyvsp[0].u_string)); }
#line 1579 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 23:
#line 297 "rp2gen_parser.y" /* yacc.c:1646  */
    { if ((yyvsp[-2].u_bool)) spit_define((yyvsp[-1].u_string), (yyvsp[0].u_string)); }
#line 1585 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 24:
#line 301 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    extern void spit_type();
					    (yyvsp[-3].u_entry) -> name = (yyvsp[-2].u_string);
					    (yyvsp[-3].u_entry) -> bound = (yyvsp[-1].u_string);
					    if ((yyvsp[-3].u_entry)->bound != NIL && (yyvsp[-3].u_entry)->type->tag != RPC2_BYTE_TAG) {
						printf("RP2GEN: array type unimplemented: %s\n",
						       (yyvsp[-2].u_string));
						exit(1);
					    }
					    enter((yyvsp[-3].u_entry));
					    if ((yyvsp[-4].u_bool)) spit_type((yyvsp[-3].u_entry));
					}
#line 1602 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 25:
#line 316 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_entry) = make_entry((yyvsp[0].u_entry)->type, (yyvsp[0].u_entry)); }
#line 1608 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 26:
#line 318 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_entry) = make_entry((yyvsp[0].u_rpc2_type), NIL); }
#line 1614 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 27:
#line 320 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_entry) = make_entry((yyvsp[0].u_rpc2_type), NIL); }
#line 1620 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 28:
#line 324 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    (yyval.u_entry) = find((yyvsp[0].u_string));
					    if ((yyval.u_entry) == NIL) {
						printf("RP2GEN: can't find type: %s\n", (yyvsp[0].u_string));
						exit(1);
					    }
					}
#line 1632 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 29:
#line 334 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_rpc2_type) = rpc2_struct_type(make_var_array()); }
#line 1638 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 30:
#line 338 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    if (var_list.counter >= MAX_VARS) {
						printf("RP2GEN: too many fields: %d\n", MAX_VARS);
						exit(1);
					    }
					    var_list.vars[var_list.counter++] = (yyvsp[-1].u_var_array);
					}
#line 1650 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 31:
#line 346 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    var_list.vars[0] = (yyvsp[0].u_var_array);
					    var_list.counter = 1;
					}
#line 1659 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 32:
#line 353 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    register char **id;
					    register VAR **p;
					    (yyval.u_var_array) = (VAR **) calloc(length((yyvsp[-1].u_string_array))+1, sizeof(VAR *));
					    if ((yyval.u_var_array) == NIL) no_storage("field");
					    for (id=(yyvsp[-1].u_string_array), p=(yyval.u_var_array); *id!=NIL; id++, p++)
						*p = make_var(*id, NO_MODE, (yyvsp[-2].u_entry));
					    *p = NIL;
					    free((yyvsp[-1].u_string_array));
					}
#line 1674 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 33:
#line 366 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string_array) = make_id_array(); }
#line 1680 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 34:
#line 370 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    if (id_list.counter >= MAX_IDS) {
						printf("RP2GEN: too many identifiers in list: %d\n", MAX_IDS);
						exit(1);
					    }
					    id_list.ids[id_list.counter++] = (yyvsp[-2].u_string);
					}
#line 1692 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 35:
#line 378 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    id_list.ids[0] = (yyvsp[0].u_string);
					    id_list.counter = 1;
					}
#line 1701 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 36:
#line 385 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_rpc2_type) = rpc2_enum_type(make_enum_array()); }
#line 1707 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 37:
#line 389 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    if (enum_list.counter >= MAX_ENUMS) {
						printf("RP2GEN: too many enum values: %d\n", MAX_ENUMS);
						exit(1);
					    }
					    enum_list.enums[enum_list.counter++] = (yyvsp[-2].u_enum);
					}
#line 1719 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 38:
#line 397 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    enum_list.enums[0] = (yyvsp[0].u_enum);
					    enum_list.counter = 1;
					}
#line 1728 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 39:
#line 404 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_enum) = make_enum((yyvsp[-2].u_string), (yyvsp[0].u_string)); }
#line 1734 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 40:
#line 408 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = (yyvsp[-1].u_string); }
#line 1740 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 41:
#line 410 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = NIL; }
#line 1746 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 42:
#line 414 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    (yyval.u_var) = make_var(NIL, NO_MODE, find("RPC2_Unsigned"));
					}
#line 1754 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 43:
#line 418 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_var) = NIL; }
#line 1760 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 44:
#line 422 "rp2gen_parser.y" /* yacc.c:1646  */
    { if ((yyvsp[-1].u_bool) == RP2_FALSE) {
                                            if ((yyvsp[-7].u_int) == -1)
                                                (yyvsp[-7].u_int) = next_opnum;
                                            if ((yyvsp[-7].u_int) < next_opnum) {
                                              printf("RP2GEN: Opcode numbers must be always increasing\n");
                                              exit(1);
                                            }
                                            next_opnum = (yyvsp[-7].u_int) + 1;
                                          }
					  insert(check_proc(make_proc((yyvsp[-7].u_int), (yyvsp[-6].u_string), make_formal_array(), (yyvsp[-2].u_string), (yyvsp[-1].u_bool)))); }
#line 1775 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 45:
#line 435 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_int) = atoi((yyvsp[-1].u_string)); }
#line 1781 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 46:
#line 438 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_int) = -1; }
#line 1787 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 47:
#line 443 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    VAR *maxvarp;
					    if (formal_list.counter >= MAX_FORMALS) {
						printf("RP2GEN: too many formals: %d\n", MAX_FORMALS);
						exit(1);
					    }
					    formal_list.formals[formal_list.counter++] = (yyvsp[-3].u_var);
					    if ((yyvsp[-2].u_var) != NIL) {
						if (formal_list.counter >= MAX_FORMALS) {
						    printf("RP2GEN: too many formals: %d\n", MAX_FORMALS);
						    exit(1);
						}
					        if ((yyvsp[-3].u_var)->type->type->tag != RPC2_STRUCT_TAG) {
						    printf("RP2GEN: array type unimplemented: %s\n", (yyvsp[-3].u_var)->name);
						    exit(1);
					        } 
					        formal_list.formals[formal_list.counter++] = (yyvsp[-2].u_var);
						(yyvsp[-3].u_var)->array = (yyvsp[-2].u_var)->name = createsize((yyvsp[-3].u_var)->name);
						(yyvsp[-2].u_var)->mode = (yyvsp[-3].u_var)->mode;
						if ((yyvsp[-3].u_var)->mode != IN_MODE) { 
						    maxvarp = make_var(NIL, NO_MODE, find("RPC2_Unsigned"));
						    (yyvsp[-3].u_var)->arraymax = maxvarp->name = createmaxsize((yyvsp[-3].u_var)->name);
						    maxvarp->mode = MAX_BOUND;
						    formal_list.formals[formal_list.counter++] = maxvarp;
						}
					    }
					}
#line 1819 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 48:
#line 471 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					    VAR *maxvarp;
					    formal_list.formals[0] = (yyvsp[-1].u_var);
					    formal_list.counter = 1;
					    if ((yyvsp[0].u_var) != NIL) {
					        if ((yyvsp[-1].u_var)->type->type->tag != RPC2_STRUCT_TAG) {
						    printf("RP2GEN: array type unimplemented: %s\n",
						           (yyvsp[-1].u_var)->name);
						    exit(1);
					        } 
					        formal_list.formals[formal_list.counter++] = (yyvsp[0].u_var);
						(yyvsp[-1].u_var)->array = (yyvsp[0].u_var)->name = createsize((yyvsp[-1].u_var)->name);
						(yyvsp[0].u_var)->mode = (yyvsp[-1].u_var)->mode;
						if ((yyvsp[-1].u_var)->mode != IN_MODE) { 
						    maxvarp = make_var(NIL, NO_MODE, find("RPC2_Unsigned"));
						    (yyvsp[-1].u_var)->arraymax = maxvarp->name = createmaxsize((yyvsp[-1].u_var)->name);
						    maxvarp->mode = IN_MODE;
						    formal_list.formals[formal_list.counter++] = maxvarp;
						}
					    }

					}
#line 1846 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 49:
#line 494 "rp2gen_parser.y" /* yacc.c:1646  */
    { formal_list.counter = 0; }
#line 1852 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 50:
#line 498 "rp2gen_parser.y" /* yacc.c:1646  */
    {
					  (yyval.u_var) = make_var((yyvsp[0].u_string), (yyvsp[-2].u_mode), (yyvsp[-1].u_entry));
					}
#line 1860 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 51:
#line 504 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_mode) = IN_MODE; }
#line 1866 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 52:
#line 506 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_mode) = OUT_MODE; }
#line 1872 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 53:
#line 508 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_mode) = IN_OUT_MODE; }
#line 1878 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 54:
#line 512 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = (yyvsp[-1].u_string); }
#line 1884 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 55:
#line 514 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = NIL; }
#line 1890 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 56:
#line 518 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_bool) = RP2_TRUE; }
#line 1896 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 57:
#line 520 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_bool) = RP2_FALSE; }
#line 1902 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 58:
#line 524 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1908 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 59:
#line 526 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1914 "rp2gen_parser.c" /* yacc.c:1646  */
    break;

  case 60:
#line 530 "rp2gen_parser.y" /* yacc.c:1646  */
    { (yyval.u_string) = (yyvsp[0].u_string); }
#line 1920 "rp2gen_parser.c" /* yacc.c:1646  */
    break;


#line 1924 "rp2gen_parser.c" /* yacc.c:1646  */
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYTERROR;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  return yyresult;
}
#line 539 "rp2gen_parser.y" /* yacc.c:1906  */

