/* $Id: stimg.h,v 1.5 2003/05/03 13:41:05 hito Exp $ */
#ifndef __STIMG_API_HEADER__
#define __STIMG_API_HEADER__

#define STIMG_FRAME_RETAIN  1
#define STIMG_FRAME_DISPOSE 2
#define STIMG_FRAME_REVERT  3

typedef struct _STIMG {
  int w, h, rowstride;
  int alpha;
  int x_offset, y_offset, delay_time;
  int action;
  unsigned char *data;
  struct _STIMG *next;
} STIMG;

typedef struct {
  int w, h, n, iterations;
  STIMG *image, *cur_image;
} STIMG_ANIMATION;

STIMG *stimg_new(int w, int h, int alpha);
STIMG *stimg_load(char *file);
STIMG *stimg_copy(const STIMG *image);
STIMG *stimg_resize(const STIMG *image, int w, int h, int aa);
int    stimg_size(char *filename, int *w, int *h);
int    stimg_rotate(STIMG *image, int angle);
int    stimg_flip(STIMG *image);
int    stimg_flop(STIMG *image);
void   stimg_delete(STIMG *image);

unsigned char *stimg_get_data(const STIMG *image);
int stimg_get_has_alpha(const STIMG *image);
int stimg_get_width(const STIMG *image);
int stimg_get_height(const STIMG *image);
int stimg_get_rowstride(const STIMG *image);

STIMG_ANIMATION *stimg_animation_new(void);
STIMG_ANIMATION *stimg_animation_load(char *file);
STIMG_ANIMATION *stimg_animation_resize(const STIMG_ANIMATION *animation,
					int w, int h, int aa);
int  stimg_animation_size(char *filename, int *w, int *h);
void stimg_animation_delete(STIMG_ANIMATION *animation);
int  stimg_animation_add_frame(STIMG_ANIMATION *animation, STIMG *image,
			       int x_ofst, int y_ofst, int delay, int action);

int stimg_animation_get_width(const STIMG_ANIMATION *animation);
int stimg_animation_get_height(const STIMG_ANIMATION *animation);
int stimg_animation_get_num(const STIMG_ANIMATION *animation);
int stimg_animation_get_iterations(const STIMG_ANIMATION *animation);

STIMG *stimg_animation_get_first_image(STIMG_ANIMATION *animation);
STIMG *stimg_animation_get_next_image(STIMG_ANIMATION *animation);
STIMG *stimg_animation_get_nth_image(STIMG_ANIMATION *animation, int n);

int stimg_animation_get_action(const STIMG_ANIMATION *animation);
int stimg_animation_get_x_offset(const STIMG_ANIMATION *animation);
int stimg_animation_get_y_offset(const STIMG_ANIMATION *animation);
int stimg_animation_get_delay(const STIMG_ANIMATION *animation);

#endif
