/*
** Zabbix
** Copyright (C) 2001-2025 Zabbix SIA
**
** Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
** documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
** rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
** permit persons to whom the Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in all copies or substantial portions
** of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
** WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
** COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
** TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
** SOFTWARE.
**/

package container

import (
	"testing"
)

func Test_handler_checkVersion(t *testing.T) {
	t.Parallel()

	type fields struct {
		name string
	}

	type args struct {
		agentProtocolVer  string
		pluginProtocolVer string
	}

	tests := []struct {
		name    string
		fields  fields
		args    args
		wantErr bool
	}{
		{
			"+valid",
			fields{
				"foobar",
			},
			args{
				"1.0.0",
				"1.0.0",
			},
			false,
		},
		{
			"-mismatchVer",
			fields{
				"foobar",
			},
			args{
				"1.0.0",
				"2.0.0",
			},
			true,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			t.Parallel()

			h := &Handler{
				name: tt.fields.name,
			}

			if err := h.checkVersion(tt.args.agentProtocolVer, tt.args.pluginProtocolVer); (err != nil) != tt.wantErr {
				t.Fatalf("handler.checkVersion() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}
