/* 
   Copyright (C) 2012 German A. Arias <german@xelalug.org>

   This file is part of Gemas application

   Gemas is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <AppKit/AppKit.h>
#import <GNUstepGUI/GSTheme.h>

@interface Silver_2_5 : GSTheme
{
}
@end

@implementation Silver_2_5

/*
- (void) drawMenuRect: (NSRect)rect
	       inView: (NSView *)view
	 isHorizontal: (BOOL)horizontal
	    itemCells: (NSArray *)itemCells
{
  int         i = 0;
  int         howMany = [itemCells count];
  NSMenuView *menuView = (NSMenuView *)view;
  NSRect      bounds = [view bounds];

  NSImage *img = [NSImage imageNamed: @"common_Tile"];

  [img drawInRect: bounds
  	 fromRect: NSMakeRect(0, 0, bounds.size.width, bounds.size.height)
  	operation: NSCompositeSourceOver
  	 fraction: 1.0];

  // Draw the menu cells.
  for (i = 0; i < howMany; i++)
    {
      NSRect aRect;
      NSMenuItemCell *aCell;

      aRect = [menuView rectOfItemAtIndex: i];
      aRect.size.width -= 1;

      if (NSIntersectsRect(rect, aRect) == YES)
        {
          aCell = [menuView menuItemCellForItemAtIndex: i];
          [aCell drawWithFrame: aRect inView: menuView];
        }
    }
}
  */

- (void) drawBorderAndBackgroundForMenuItemCell: (NSMenuItemCell *)cell
                                      withFrame: (NSRect)cellFrame
                                         inView: (NSView *)controlView
                                          state: (GSThemeControlState)state
                                   isHorizontal: (BOOL)isHorizontal
{
  if (state == GSThemeHighlightedState ||
      [[cell className] isEqualToString: @"NSPopUpButtonCell"])
    {
      NSString *path = [[[GSTheme theme] bundle] pathForResource: @"MenuItem"
							  ofType: @"tiff"
						     inDirectory: @"ThemeTiles"];

      NSImage *img = [[NSImage alloc] initWithContentsOfFile: path];

      [[NSColor whiteColor] set];
      NSRectFill(cellFrame);

      [img drawInRect: cellFrame
	     fromRect: NSMakeRect(0, 0, cellFrame.size.width, cellFrame.size.height)
	    operation: NSCompositeSourceOver
	     fraction: 1.0];
      [img release];
    }
  else
    {
      cellFrame.size.width -= 1;

      if (!isHorizontal && cellFrame.origin.y == 0)
	{
	  cellFrame.size.height -= 1;
	  cellFrame.origin.y += 1;
	}

      if (isHorizontal)
	{
	  [[cell backgroundColor] set];
	  cellFrame.origin.y += 1;
	}
      else
	{
	  [[NSColor colorWithCalibratedRed: 0.81
				     green: 0.81
				      blue: 0.81
				     alpha: 1.0] set];
	}

      NSRectFill(cellFrame);
    }
}

- (BOOL) menuShouldShowIcon
{
  return NO;
}

- (BOOL) doesProcessEventsForPopUpMenu
{
  return YES;
}

@end
