/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gaussdb.ui.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.ext.postgresql.ui.PostgreConnectionPageAdvanced;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class GaussDBConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Text urlText;
    private Text hostText;
    private Text portText;
    private Text dbText;
    private boolean activated = false;

    public void dispose() {
        super.dispose();
    }

    public Image getImage() {
        DBPDriver driver = this.site.getDriver();
        PostgreServerType serverType = this.getServerType(driver);
        return DBeaverIcons.getImage((DBPImage)serverType.getIcon());
    }

    public void createControl(Composite composite) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.updateUrl();
                this.site.updateButtons();
            }
        };
        Composite mainGroup = new Composite(composite, 0);
        mainGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        mainGroup.setLayoutData((Object)gd);
        Composite addrGroup = UIUtils.createTitledComposite((Composite)mainGroup, (String)UIConnectionMessages.dialog_connection_server_label, (int)4, (int)768);
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GaussDBConnectionPage.this.setupConnectionModeSelection(GaussDBConnectionPage.this.urlText, GaussDBConnectionPage.this.typeURLRadio.getSelection(), GROUP_CONNECTION_ARR);
                GaussDBConnectionPage.this.updateUrl();
            }
        };
        this.createConnectionModeSwitcher(addrGroup, (SelectionListener)typeSwitcher);
        UIUtils.createControlLabel((Composite)addrGroup, (String)UIConnectionMessages.dialog_connection_url_label);
        this.urlText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 355;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.site.updateButtons());
        DBPDriver driver = this.site.getDriver();
        PostgreServerType serverType = this.getServerType(driver);
        Label hostLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)(serverType.isCloudServer() ? PostgreMessages.dialog_setting_connection_cloud_instance : PostgreMessages.dialog_setting_connection_host));
        this.addControlToGroup("connection", new Control[]{hostLabel});
        this.hostText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.hostText);
        this.hostText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{this.hostText});
        if (serverType.needsPort()) {
            Label portLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_port);
            this.addControlToGroup("connection", new Control[]{portLabel});
            this.portText = new Text(addrGroup, 2048);
            gd = new GridData(2);
            gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
            this.portText.setLayoutData((Object)gd);
            this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
            this.portText.addModifyListener(textListener);
            this.addControlToGroup("connection", new Control[]{this.portText});
        } else {
            gd.horizontalSpan = 3;
        }
        Label dbLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_database);
        this.addControlToGroup("connection", new Control[]{dbLabel});
        this.dbText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        UIUtils.setDefaultTextControlWidthHint((Control)this.dbText);
        this.dbText.addModifyListener(textListener);
        this.dbText.setMessage(PostgreMessages.dialog_database_name_hint);
        this.addControlToGroup("connection", new Control[]{this.dbText});
        this.createAuthPanel(mainGroup, 1);
        this.createDriverPanel(mainGroup);
        this.setControl((Control)mainGroup);
    }

    public PostgreServerType getServerType(DBPDriver driver) {
        return PostgreUtils.getServerType((DBPDriver)driver);
    }

    protected boolean isSessionRoleSupported() {
        return true;
    }

    public boolean isComplete() {
        if (this.isCustomURL()) {
            return !CommonUtils.isEmpty((String)this.urlText.getText());
        }
        return super.isComplete() && this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && (this.portText == null || !CommonUtils.isEmpty((String)this.portText.getText()));
    }

    public void loadSettings() {
        boolean useURL;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        DBPDriver driver = this.site.getDriver();
        super.loadSettings();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText(CommonUtils.toString((Object)this.site.getDriver().getDefaultHost(), (String)"localhost"));
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.getSite().isNew()) {
                this.portText.setText(CommonUtils.notEmpty((String)driver.getDefaultPort()));
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                if (this.getSite().isNew()) {
                    databaseName = driver.getDefaultDatabase();
                    if (CommonUtils.isEmpty((String)databaseName)) {
                        databaseName = "postgres";
                    }
                } else {
                    databaseName = "";
                }
            }
            this.dbText.setText(databaseName);
        }
        boolean bl = useURL = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL;
        if (useURL) {
            this.urlText.setText(connectionInfo.getUrl());
        }
        this.setupConnectionModeSelection(this.urlText, useURL, GROUP_CONNECTION_ARR);
        this.updateUrl();
        this.activated = false;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new PostgreConnectionPageAdvanced(null), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    private void updateUrl() {
        DBPDataSourceContainer dataSourceContainer = this.site.getActiveDataSource();
        this.saveSettings(dataSourceContainer);
        this.urlText.setText(dataSourceContainer.getDriver().getConnectionURL(this.site.getActiveDataSource().getConnectionConfiguration()));
    }
}

