/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.file;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.file.FileOpenHandler;
import org.jkiss.dbeaver.model.file.FileTypeAction;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.utils.IOUtils;

public class AbstractFileHandler
implements FileOpenHandler {
    public void openFiles(@NotNull List<Path> fileList, @Nullable DBPDataSourceContainer dataSource, @NotNull FileTypeAction action) throws DBException {
        switch (action) {
            case EXTERNAL_EDITOR: {
                for (Path path : fileList) {
                    if (!IOUtils.isLocalPath((Path)path)) {
                        path = EditorUtils.copyRemoteFileToTempDir(path);
                    }
                    ShellUtils.openExternalFile((Path)path);
                }
                break;
            }
            case INTERNAL_EDITOR: {
                for (Path path : fileList) {
                    EditorUtils.openExternalFileEditor(path, UIUtils.getActiveWorkbenchWindow());
                }
                break;
            }
            case DATABASE: {
                throw new DBException("Unsupported file action: " + String.valueOf(action));
            }
        }
    }

    @NotNull
    public Set<FileTypeAction> supportedActions() {
        return Set.of(FileTypeAction.EXTERNAL_EDITOR, FileTypeAction.INTERNAL_EDITOR);
    }
}

