// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package process_manager

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceProgramOKCode is the HTTP code returned for type ReplaceProgramOK
const ReplaceProgramOKCode int = 200

/*
ReplaceProgramOK Program replaced

swagger:response replaceProgramOK
*/
type ReplaceProgramOK struct {

	/*
	  In: Body
	*/
	Payload *models.Program `json:"body,omitempty"`
}

// NewReplaceProgramOK creates ReplaceProgramOK with default headers values
func NewReplaceProgramOK() *ReplaceProgramOK {

	return &ReplaceProgramOK{}
}

// WithPayload adds the payload to the replace program o k response
func (o *ReplaceProgramOK) WithPayload(payload *models.Program) *ReplaceProgramOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace program o k response
func (o *ReplaceProgramOK) SetPayload(payload *models.Program) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceProgramOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceProgramAcceptedCode is the HTTP code returned for type ReplaceProgramAccepted
const ReplaceProgramAcceptedCode int = 202

/*
ReplaceProgramAccepted Configuration change accepted and reload requested

swagger:response replaceProgramAccepted
*/
type ReplaceProgramAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Program `json:"body,omitempty"`
}

// NewReplaceProgramAccepted creates ReplaceProgramAccepted with default headers values
func NewReplaceProgramAccepted() *ReplaceProgramAccepted {

	return &ReplaceProgramAccepted{}
}

// WithReloadID adds the reloadId to the replace program accepted response
func (o *ReplaceProgramAccepted) WithReloadID(reloadID string) *ReplaceProgramAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace program accepted response
func (o *ReplaceProgramAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace program accepted response
func (o *ReplaceProgramAccepted) WithPayload(payload *models.Program) *ReplaceProgramAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace program accepted response
func (o *ReplaceProgramAccepted) SetPayload(payload *models.Program) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceProgramAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceProgramBadRequestCode is the HTTP code returned for type ReplaceProgramBadRequest
const ReplaceProgramBadRequestCode int = 400

/*
ReplaceProgramBadRequest Bad request

swagger:response replaceProgramBadRequest
*/
type ReplaceProgramBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceProgramBadRequest creates ReplaceProgramBadRequest with default headers values
func NewReplaceProgramBadRequest() *ReplaceProgramBadRequest {

	return &ReplaceProgramBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace program bad request response
func (o *ReplaceProgramBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceProgramBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace program bad request response
func (o *ReplaceProgramBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace program bad request response
func (o *ReplaceProgramBadRequest) WithPayload(payload *models.Error) *ReplaceProgramBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace program bad request response
func (o *ReplaceProgramBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceProgramBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceProgramNotFoundCode is the HTTP code returned for type ReplaceProgramNotFound
const ReplaceProgramNotFoundCode int = 404

/*
ReplaceProgramNotFound The specified resource was not found

swagger:response replaceProgramNotFound
*/
type ReplaceProgramNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceProgramNotFound creates ReplaceProgramNotFound with default headers values
func NewReplaceProgramNotFound() *ReplaceProgramNotFound {

	return &ReplaceProgramNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace program not found response
func (o *ReplaceProgramNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceProgramNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace program not found response
func (o *ReplaceProgramNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace program not found response
func (o *ReplaceProgramNotFound) WithPayload(payload *models.Error) *ReplaceProgramNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace program not found response
func (o *ReplaceProgramNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceProgramNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceProgramDefault General Error

swagger:response replaceProgramDefault
*/
type ReplaceProgramDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceProgramDefault creates ReplaceProgramDefault with default headers values
func NewReplaceProgramDefault(code int) *ReplaceProgramDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceProgramDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace program default response
func (o *ReplaceProgramDefault) WithStatusCode(code int) *ReplaceProgramDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace program default response
func (o *ReplaceProgramDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace program default response
func (o *ReplaceProgramDefault) WithConfigurationVersion(configurationVersion string) *ReplaceProgramDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace program default response
func (o *ReplaceProgramDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace program default response
func (o *ReplaceProgramDefault) WithPayload(payload *models.Error) *ReplaceProgramDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace program default response
func (o *ReplaceProgramDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceProgramDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
