// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllHTTPRequestRuleBackendOKCode is the HTTP code returned for type ReplaceAllHTTPRequestRuleBackendOK
const ReplaceAllHTTPRequestRuleBackendOKCode int = 200

/*
ReplaceAllHTTPRequestRuleBackendOK All HTTP Request Rule lines replaced

swagger:response replaceAllHttpRequestRuleBackendOK
*/
type ReplaceAllHTTPRequestRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload models.HTTPRequestRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPRequestRuleBackendOK creates ReplaceAllHTTPRequestRuleBackendOK with default headers values
func NewReplaceAllHTTPRequestRuleBackendOK() *ReplaceAllHTTPRequestRuleBackendOK {

	return &ReplaceAllHTTPRequestRuleBackendOK{}
}

// WithPayload adds the payload to the replace all Http request rule backend o k response
func (o *ReplaceAllHTTPRequestRuleBackendOK) WithPayload(payload models.HTTPRequestRules) *ReplaceAllHTTPRequestRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http request rule backend o k response
func (o *ReplaceAllHTTPRequestRuleBackendOK) SetPayload(payload models.HTTPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPRequestRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPRequestRuleBackendAcceptedCode is the HTTP code returned for type ReplaceAllHTTPRequestRuleBackendAccepted
const ReplaceAllHTTPRequestRuleBackendAcceptedCode int = 202

/*
ReplaceAllHTTPRequestRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAllHttpRequestRuleBackendAccepted
*/
type ReplaceAllHTTPRequestRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.HTTPRequestRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPRequestRuleBackendAccepted creates ReplaceAllHTTPRequestRuleBackendAccepted with default headers values
func NewReplaceAllHTTPRequestRuleBackendAccepted() *ReplaceAllHTTPRequestRuleBackendAccepted {

	return &ReplaceAllHTTPRequestRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Http request rule backend accepted response
func (o *ReplaceAllHTTPRequestRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceAllHTTPRequestRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Http request rule backend accepted response
func (o *ReplaceAllHTTPRequestRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Http request rule backend accepted response
func (o *ReplaceAllHTTPRequestRuleBackendAccepted) WithPayload(payload models.HTTPRequestRules) *ReplaceAllHTTPRequestRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http request rule backend accepted response
func (o *ReplaceAllHTTPRequestRuleBackendAccepted) SetPayload(payload models.HTTPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPRequestRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPRequestRuleBackendBadRequestCode is the HTTP code returned for type ReplaceAllHTTPRequestRuleBackendBadRequest
const ReplaceAllHTTPRequestRuleBackendBadRequestCode int = 400

/*
ReplaceAllHTTPRequestRuleBackendBadRequest Bad request

swagger:response replaceAllHttpRequestRuleBackendBadRequest
*/
type ReplaceAllHTTPRequestRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPRequestRuleBackendBadRequest creates ReplaceAllHTTPRequestRuleBackendBadRequest with default headers values
func NewReplaceAllHTTPRequestRuleBackendBadRequest() *ReplaceAllHTTPRequestRuleBackendBadRequest {

	return &ReplaceAllHTTPRequestRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Http request rule backend bad request response
func (o *ReplaceAllHTTPRequestRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPRequestRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Http request rule backend bad request response
func (o *ReplaceAllHTTPRequestRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Http request rule backend bad request response
func (o *ReplaceAllHTTPRequestRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceAllHTTPRequestRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http request rule backend bad request response
func (o *ReplaceAllHTTPRequestRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPRequestRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllHTTPRequestRuleBackendDefault General Error

swagger:response replaceAllHttpRequestRuleBackendDefault
*/
type ReplaceAllHTTPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPRequestRuleBackendDefault creates ReplaceAllHTTPRequestRuleBackendDefault with default headers values
func NewReplaceAllHTTPRequestRuleBackendDefault(code int) *ReplaceAllHTTPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllHTTPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all HTTP request rule backend default response
func (o *ReplaceAllHTTPRequestRuleBackendDefault) WithStatusCode(code int) *ReplaceAllHTTPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all HTTP request rule backend default response
func (o *ReplaceAllHTTPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all HTTP request rule backend default response
func (o *ReplaceAllHTTPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all HTTP request rule backend default response
func (o *ReplaceAllHTTPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all HTTP request rule backend default response
func (o *ReplaceAllHTTPRequestRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceAllHTTPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all HTTP request rule backend default response
func (o *ReplaceAllHTTPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
