/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.parsers;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.hampelratte.svdrp.parsers.ChannelLineParser;
import org.hampelratte.svdrp.parsers.ChannelLineParserFactory;
import org.hampelratte.svdrp.responses.highlevel.Channel;
import org.hampelratte.svdrp.responses.highlevel.DVBChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelParser {
    private static transient Logger logger = LoggerFactory.getLogger(ChannelParser.class);

    public static List<Channel> parse(String channelData, boolean validate, boolean ignoreErrors) throws ParseException {
        ArrayList<Channel> list = new ArrayList<Channel>();
        StringTokenizer st = new StringTokenizer(channelData, "\n");
        int lineNumber = 1;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            try {
                ChannelLineParser parser = ChannelLineParserFactory.createChannelParser(line);
                logger.trace("Parsing channels.conf line with {} {}", (Object)parser.getClass().getSimpleName(), (Object)line);
                Channel channel = parser.parse(line);
                if (validate && channel instanceof DVBChannel) {
                    try {
                        ((DVBChannel)channel).validate();
                    }
                    catch (Exception e) {
                        ParseException pe = new ParseException("DVB channel with invalid values on line " + lineNumber + ": [" + line + "]", lineNumber);
                        pe.initCause(e);
                        if (!ignoreErrors) {
                            throw pe;
                        }
                        logger.error(pe.getLocalizedMessage(), (Throwable)e);
                    }
                }
                list.add(channel);
            }
            catch (Exception e) {
                ParseException pe = new ParseException("Unknown channels.conf line format on line " + lineNumber + ": [" + line + "]", lineNumber);
                pe.initCause(e);
                if (!ignoreErrors) {
                    throw pe;
                }
                logger.error(pe.getLocalizedMessage(), (Throwable)e);
            }
            ++lineNumber;
        }
        return list;
    }

    public static List<Channel> parse(String channelData, boolean ignoreErrors) throws ParseException {
        return ChannelParser.parse(channelData, true, ignoreErrors);
    }
}

