// Code generated by 'ccgo -ccgo-export-externs X -ccgo-hide __syscall0,__syscall1,__syscall2,__syscall3,__syscall4,__syscall5,__syscall6 -ccgo-libc -ccgo-long-double-is-double -ccgo-pkgname libc -nostdinc -o ../musl_linux_386.go -Iarch/i386 -Iarch/generic -Iobj/src/internal -Isrc/include -Isrc/internal -Iobj/include -Iinclude copyright.c src/ctype/isalnum.c src/ctype/isalpha.c src/ctype/isdigit.c src/dirent/closedir.c src/dirent/opendir.c src/dirent/readdir.c src/internal/intscan.c src/internal/shgetc.c src/network/freeaddrinfo.c src/network/getaddrinfo.c src/network/gethostbyaddr.c src/network/gethostbyaddr_r.c src/network/gethostbyname.c src/network/gethostbyname2.c src/network/gethostbyname2_r.c src/network/getnameinfo.c src/network/h_errno.c src/network/inet_aton.c src/network/inet_ntop.c src/network/inet_pton.c src/network/lookup_ipliteral.c src/network/lookup_name.c src/network/lookup_serv.c src/stdio/__toread.c src/stdio/__uflow.c src/stdlib/strtol.c src/string/strnlen.c src/string/strspn.c', DO NOT EDIT.

package libc

import (
	"math"
	"reflect"
	"unsafe"
)

var _ = math.Pi
var _ reflect.Kind
var _ unsafe.Pointer

// musl as a whole is licensed under the following standard MIT license:
//
// ----------------------------------------------------------------------
// Copyright © 2005-2020 Rich Felker, et al.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// ----------------------------------------------------------------------
//
// Authors/contributors include:
//
// A. Wilcox
// Ada Worcester
// Alex Dowad
// Alex Suykov
// Alexander Monakov
// Andre McCurdy
// Andrew Kelley
// Anthony G. Basile
// Aric Belsito
// Arvid Picciani
// Bartosz Brachaczek
// Benjamin Peterson
// Bobby Bingham
// Boris Brezillon
// Brent Cook
// Chris Spiegel
// Clément Vasseur
// Daniel Micay
// Daniel Sabogal
// Daurnimator
// David Carlier
// David Edelsohn
// Denys Vlasenko
// Dmitry Ivanov
// Dmitry V. Levin
// Drew DeVault
// Emil Renner Berthing
// Fangrui Song
// Felix Fietkau
// Felix Janda
// Gianluca Anzolin
// Hauke Mehrtens
// He X
// Hiltjo Posthuma
// Isaac Dunham
// Jaydeep Patil
// Jens Gustedt
// Jeremy Huntwork
// Jo-Philipp Wich
// Joakim Sindholt
// John Spencer
// Julien Ramseier
// Justin Cormack
// Kaarle Ritvanen
// Khem Raj
// Kylie McClain
// Leah Neukirchen
// Luca Barbato
// Luka Perkov
// M Farkas-Dyck (Strake)
// Mahesh Bodapati
// Markus Wichmann
// Masanori Ogino
// Michael Clark
// Michael Forney
// Mikhail Kremnyov
// Natanael Copa
// Nicholas J. Kain
// orc
// Pascal Cuoq
// Patrick Oppenlander
// Petr Hosek
// Petr Skocik
// Pierre Carrier
// Reini Urban
// Rich Felker
// Richard Pennington
// Ryan Fairfax
// Samuel Holland
// Segev Finer
// Shiz
// sin
// Solar Designer
// Stefan Kristiansson
// Stefan O'Rear
// Szabolcs Nagy
// Timo Teräs
// Trutz Behn
// Valentin Ochs
// Will Dietz
// William Haddon
// William Pitcock
//
// Portions of this software are derived from third-party works licensed
// under terms compatible with the above MIT license:
//
// The TRE regular expression implementation (src/regex/reg* and
// src/regex/tre*) is Copyright © 2001-2008 Ville Laurikari and licensed
// under a 2-clause BSD license (license text in the source files). The
// included version has been heavily modified by Rich Felker in 2012, in
// the interests of size, simplicity, and namespace cleanliness.
//
// Much of the math library code (src/math/* and src/complex/*) is
// Copyright © 1993,2004 Sun Microsystems or
// Copyright © 2003-2011 David Schultz or
// Copyright © 2003-2009 Steven G. Kargl or
// Copyright © 2003-2009 Bruce D. Evans or
// Copyright © 2008 Stephen L. Moshier or
// Copyright © 2017-2018 Arm Limited
// and labelled as such in comments in the individual source files. All
// have been licensed under extremely permissive terms.
//
// The ARM memcpy code (src/string/arm/memcpy.S) is Copyright © 2008
// The Android Open Source Project and is licensed under a two-clause BSD
// license. It was taken from Bionic libc, used on Android.
//
// The AArch64 memcpy and memset code (src/string/aarch64/*) are
// Copyright © 1999-2019, Arm Limited.
//
// The implementation of DES for crypt (src/crypt/crypt_des.c) is
// Copyright © 1994 David Burren. It is licensed under a BSD license.
//
// The implementation of blowfish crypt (src/crypt/crypt_blowfish.c) was
// originally written by Solar Designer and placed into the public
// domain. The code also comes with a fallback permissive license for use
// in jurisdictions that may not recognize the public domain.
//
// The smoothsort implementation (src/stdlib/qsort.c) is Copyright © 2011
// Valentin Ochs and is licensed under an MIT-style license.
//
// The x86_64 port was written by Nicholas J. Kain and is licensed under
// the standard MIT terms.
//
// The mips and microblaze ports were originally written by Richard
// Pennington for use in the ellcc project. The original code was adapted
// by Rich Felker for build system and code conventions during upstream
// integration. It is licensed under the standard MIT terms.
//
// The mips64 port was contributed by Imagination Technologies and is
// licensed under the standard MIT terms.
//
// The powerpc port was also originally written by Richard Pennington,
// and later supplemented and integrated by John Spencer. It is licensed
// under the standard MIT terms.
//
// All other files which have no copyright comments are original works
// produced specifically for use as part of this library, written either
// by Rich Felker, the main author of the library, or by one or more
// contibutors listed above. Details on authorship of individual files
// can be found in the git version control history of the project. The
// omission of copyright and license comments in each file is in the
// interest of source tree size.
//
// In addition, permission is hereby granted for all public header files
// (include/* and arch/*/bits/*) and crt files intended to be linked into
// applications (crt/*, ldso/dlstart.c, and arch/*/crt_arch.h) to omit
// the copyright notice and permission notice otherwise required by the
// license, and to use these files without any requirement of
// attribution. These files include substantial contributions from:
//
// Bobby Bingham
// John Spencer
// Nicholas J. Kain
// Rich Felker
// Richard Pennington
// Stefan Kristiansson
// Szabolcs Nagy
//
// all of whom have explicitly granted such permission.
//
// This file previously contained text expressing a belief that most of
// the files covered by the above exception were sufficiently trivial not
// to be subject to copyright, resulting in confusion over whether it
// negated the permissions granted in the license. In the spirit of
// permissive licensing, and of not having licensing issues being an
// obstacle to adoption, that text has been removed.
const ( /* copyright.c:194:1: */
	__musl__copyright__ = 0
)

const ( /* nameser.h:117:1: */
	ns_uop_delete = 0
	ns_uop_add    = 1
	ns_uop_max    = 2
)

const ( /* nameser.h:147:1: */
	ns_t_invalid  = 0
	ns_t_a        = 1
	ns_t_ns       = 2
	ns_t_md       = 3
	ns_t_mf       = 4
	ns_t_cname    = 5
	ns_t_soa      = 6
	ns_t_mb       = 7
	ns_t_mg       = 8
	ns_t_mr       = 9
	ns_t_null     = 10
	ns_t_wks      = 11
	ns_t_ptr      = 12
	ns_t_hinfo    = 13
	ns_t_minfo    = 14
	ns_t_mx       = 15
	ns_t_txt      = 16
	ns_t_rp       = 17
	ns_t_afsdb    = 18
	ns_t_x25      = 19
	ns_t_isdn     = 20
	ns_t_rt       = 21
	ns_t_nsap     = 22
	ns_t_nsap_ptr = 23
	ns_t_sig      = 24
	ns_t_key      = 25
	ns_t_px       = 26
	ns_t_gpos     = 27
	ns_t_aaaa     = 28
	ns_t_loc      = 29
	ns_t_nxt      = 30
	ns_t_eid      = 31
	ns_t_nimloc   = 32
	ns_t_srv      = 33
	ns_t_atma     = 34
	ns_t_naptr    = 35
	ns_t_kx       = 36
	ns_t_cert     = 37
	ns_t_a6       = 38
	ns_t_dname    = 39
	ns_t_sink     = 40
	ns_t_opt      = 41
	ns_t_apl      = 42
	ns_t_tkey     = 249
	ns_t_tsig     = 250
	ns_t_ixfr     = 251
	ns_t_axfr     = 252
	ns_t_mailb    = 253
	ns_t_maila    = 254
	ns_t_any      = 255
	ns_t_zxfr     = 256
	ns_t_max      = 65536
)

const ( /* nameser.h:210:1: */
	ns_c_invalid = 0
	ns_c_in      = 1
	ns_c_2       = 2
	ns_c_chaos   = 3
	ns_c_hs      = 4
	ns_c_none    = 254
	ns_c_any     = 255
	ns_c_max     = 65536
)

const ( /* nameser.h:221:1: */
	ns_kt_rsa     = 1
	ns_kt_dh      = 2
	ns_kt_dsa     = 3
	ns_kt_private = 254
)

const ( /* nameser.h:228:1: */
	cert_t_pkix = 1
	cert_t_spki = 2
	cert_t_pgp  = 3
	cert_t_url  = 253
	cert_t_oid  = 254
)

const ( /* nameser.h:28:1: */
	ns_s_qd  = 0
	ns_s_zn  = 0
	ns_s_an  = 1
	ns_s_pr  = 1
	ns_s_ns  = 2
	ns_s_ud  = 2
	ns_s_ar  = 3
	ns_s_max = 4
)

const ( /* nameser.h:75:1: */
	ns_f_qr     = 0
	ns_f_opcode = 1
	ns_f_aa     = 2
	ns_f_tc     = 3
	ns_f_rd     = 4
	ns_f_ra     = 5
	ns_f_z      = 6
	ns_f_ad     = 7
	ns_f_cd     = 8
	ns_f_rcode  = 9
	ns_f_max    = 10
)

const ( /* nameser.h:89:1: */
	ns_o_query  = 0
	ns_o_iquery = 1
	ns_o_status = 2
	ns_o_notify = 4
	ns_o_update = 5
	ns_o_max    = 6
)

const ( /* nameser.h:98:1: */
	ns_r_noerror  = 0
	ns_r_formerr  = 1
	ns_r_servfail = 2
	ns_r_nxdomain = 3
	ns_r_notimpl  = 4
	ns_r_refused  = 5
	ns_r_yxdomain = 6
	ns_r_yxrrset  = 7
	ns_r_nxrrset  = 8
	ns_r_notauth  = 9
	ns_r_notzone  = 10
	ns_r_max      = 11
	ns_r_badvers  = 16
	ns_r_badsig   = 16
	ns_r_badkey   = 17
	ns_r_badtime  = 18
)

type ptrdiff_t = int32 /* <builtin>:3:26 */

type size_t = uint32 /* <builtin>:9:23 */

type wchar_t = int32 /* <builtin>:15:24 */

type locale_t = uintptr /* alltypes.h:366:32 */

func Xisalnum(tls *TLS, c int32) int32 { /* isalnum.c:3:5: */
	return (Bool32((func() int32 {
		if 0 != 0 {
			return Xisalpha(tls, c)
		}
		return (Bool32((((uint32(c)) | uint32(32)) - uint32('a')) < uint32(26)))
	}() != 0) || (func() int32 {
		if 0 != 0 {
			return Xisdigit(tls, c)
		}
		return (Bool32(((uint32(c)) - uint32('0')) < uint32(10)))
	}() != 0)))
}

func X__isalnum_l(tls *TLS, c int32, l locale_t) int32 { /* isalnum.c:8:5: */
	return Xisalnum(tls, c)
}

func Xisalpha(tls *TLS, c int32) int32 { /* isalpha.c:4:5: */
	return (Bool32(((uint32(c) | uint32(32)) - uint32('a')) < uint32(26)))
}

func X__isalpha_l(tls *TLS, c int32, l locale_t) int32 { /* isalpha.c:9:5: */
	return Xisalpha(tls, c)
}

func Xisdigit(tls *TLS, c int32) int32 { /* isdigit.c:4:5: */
	return (Bool32((uint32(c) - uint32('0')) < uint32(10)))
}

func X__isdigit_l(tls *TLS, c int32, l locale_t) int32 { /* isdigit.c:9:5: */
	return Xisdigit(tls, c)
}

type off_t = int64 /* alltypes.h:185:16 */

type ino_t = uint64 /* alltypes.h:190:25 */

type dirent = struct {
	d_ino    ino_t
	d_off    off_t
	d_reclen uint16
	d_type   uint8
	d_name   [256]int8
	_        [1]byte
} /* dirent.h:5:1 */

type __dirstream = struct {
	tell    off_t
	fd      int32
	buf_pos int32
	buf_end int32
	lock    [1]int32
	buf     [2048]int8
} /* dirent.h:20:9 */

type DIR = __dirstream /* dirent.h:20:28 */

type ssize_t = int32 /* alltypes.h:88:15 */

type intptr_t = int32 /* alltypes.h:93:15 */

type pid_t = int32 /* alltypes.h:258:13 */

type uid_t = uint32 /* alltypes.h:268:18 */

type gid_t = uint32 /* alltypes.h:273:18 */

type useconds_t = uint32 /* alltypes.h:283:18 */

type div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:62:35 */
type ldiv_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:63:36 */
type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:64:41 */

func Xclosedir(tls *TLS, dir uintptr) int32 { /* closedir.c:6:5: */
	var ret int32 = Xclose(tls, (*DIR)(unsafe.Pointer(dir)).fd)
	Xfree(tls, dir)
	return ret
}

type mode_t = uint32 /* alltypes.h:175:18 */

type iovec = struct {
	iov_base uintptr
	iov_len  size_t
} /* alltypes.h:378:1 */

type flock = struct {
	l_type   int16
	l_whence int16
	l_start  off_t
	l_len    off_t
	l_pid    pid_t
} /* fcntl.h:24:1 */

type file_handle = struct {
	_            [0]uint32
	handle_bytes uint32
	handle_type  int32
} /* fcntl.h:167:1 */

type f_owner_ex = struct {
	__type int32
	pid    pid_t
} /* fcntl.h:172:1 */

type syscall_arg_t = int32 /* syscall.h:22:14 */

func Xopendir(tls *TLS, name uintptr) uintptr { /* opendir.c:8:5: */
	var fd int32
	var dir uintptr

	if (AssignInt32(&fd, Xopen(tls, name, ((00|0200000)|02000000), 0))) < 0 {
		return uintptr(0)
	}
	if !(int32(AssignUintptr(&dir, Xcalloc(tls, uint32(1), uint32(unsafe.Sizeof(DIR{}))))) != 0) {
		X__syscall1(tls, 6, int32(fd))
		return uintptr(0)
	}
	(*DIR)(unsafe.Pointer(dir)).fd = fd
	return dir
}

type max_align_t = struct {
	__ll int64
	__ld float64
} /* alltypes.h:51:66 */

type dirstream_buf_alignment_check = [1]int8 /* readdir.c:7:14 */

func Xreaddir(tls *TLS, dir uintptr) uintptr { /* readdir.c:10:15: */
	var de uintptr

	if (*DIR)(unsafe.Pointer(dir)).buf_pos >= (*DIR)(unsafe.Pointer(dir)).buf_end {
		var len int32 = int32(X__syscall3(tls, 220, int32((*DIR)(unsafe.Pointer(dir)).fd), int32(dir+24 /* &.buf */), int32(unsafe.Sizeof([2048]int8{}))))
		if len <= 0 {
			if (len < 0) && (len != -2) {
				(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = -len
			}
			return uintptr(0)
		}
		(*DIR)(unsafe.Pointer(dir)).buf_end = len
		(*DIR)(unsafe.Pointer(dir)).buf_pos = 0
	}
	de = ((dir + 24 /* &.buf */) + uintptr((*DIR)(unsafe.Pointer(dir)).buf_pos))
	*(*int32)(unsafe.Pointer(dir + 12 /* &.buf_pos */)) += (int32((*dirent)(unsafe.Pointer(de)).d_reclen))
	(*DIR)(unsafe.Pointer(dir)).tell = (*dirent)(unsafe.Pointer(de)).d_off
	return de
}

func __isspace3(tls *TLS, _c int32) int32 { /* ctype.h:26:21: */
	return (Bool32((_c == ' ') || ((uint32(_c) - uint32('\t')) < uint32(5))))
}

type _IO_FILE = struct {
	flags        uint32
	rpos         uintptr
	rend         uintptr
	close        uintptr
	wend         uintptr
	wpos         uintptr
	mustbezero_1 uintptr
	wbase        uintptr
	read         uintptr
	write        uintptr
	seek         uintptr
	buf          uintptr
	buf_size     size_t
	prev         uintptr
	next         uintptr
	fd           int32
	pipe_pid     int32
	lockcount    int32
	mode         int32
	lock         int32
	lbf          int32
	cookie       uintptr
	off          off_t
	getln_buf    uintptr
	mustbezero_2 uintptr
	shend        uintptr
	shlim        off_t
	shcnt        off_t
	prev_locked  uintptr
	next_locked  uintptr
	locale       uintptr
} /* alltypes.h:343:9 */

type FILE = _IO_FILE /* alltypes.h:343:25 */

type va_list = uintptr /* alltypes.h:349:27 */

type _G_fpos64_t = struct {
	_        [0]uint32
	__opaque [16]int8
} /* stdio.h:54:9 */

type fpos_t = _G_fpos64_t /* stdio.h:58:3 */

// Lookup table for digit values. -1==255>=36 -> invalid
var table = [257]uint8{Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	uint8(0), uint8(1), uint8(2), uint8(3), uint8(4), uint8(5), uint8(6), uint8(7), uint8(8), uint8(9), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), uint8(10), uint8(11), uint8(12), uint8(13), uint8(14), uint8(15), uint8(16), uint8(17), uint8(18), uint8(19), uint8(20), uint8(21), uint8(22), uint8(23), uint8(24),
	uint8(25), uint8(26), uint8(27), uint8(28), uint8(29), uint8(30), uint8(31), uint8(32), uint8(33), uint8(34), uint8(35), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), uint8(10), uint8(11), uint8(12), uint8(13), uint8(14), uint8(15), uint8(16), uint8(17), uint8(18), uint8(19), uint8(20), uint8(21), uint8(22), uint8(23), uint8(24),
	uint8(25), uint8(26), uint8(27), uint8(28), uint8(29), uint8(30), uint8(31), uint8(32), uint8(33), uint8(34), uint8(35), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
} /* intscan.c:7:28 */

func X__intscan(tls *TLS, f uintptr, base uint32, pok int32, lim uint64) uint64 { /* intscan.c:26:20: */
	var val uintptr
	var c int32
	var neg int32
	var x uint32
	var y uint64
	var bs int32
	val = (uintptr(unsafe.Pointer(&table)) + uintptr(1))
	neg = 0
	if !((base > uint32(36)) || (base == uint32(1))) {
		goto __1
	}
	(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = 22
	return uint64(0)
__1:
	;
__2:
	if !(__isspace3(tls, AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}())) != 0) {
		goto __3
	}
	goto __2
__3:
	;
	if !((c == '+') || (c == '-')) {
		goto __4
	}
	neg = -(Bool32(c == '-'))
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
__4:
	;
	if !(((base == uint32(0)) || (base == uint32(16))) && (c == '0')) {
		goto __5
	}
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	if !((c | 32) == 'x') {
		goto __7
	}
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	if !(int32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) >= 16) {
		goto __9
	}
	if (*FILE)(unsafe.Pointer((f))).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	if !(pok != 0) {
		goto __10
	}
	if (*FILE)(unsafe.Pointer((f))).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	goto __11
__10:
	X__shlim(tls, f, int64(0))
__11:
	;
	return uint64(0)
__9:
	;
	base = uint32(16)
	goto __8
__7:
	if !(base == uint32(0)) {
		goto __12
	}
	base = uint32(8)
__12:
	;
__8:
	;
	goto __6
__5:
	if !(base == uint32(0)) {
		goto __13
	}
	base = uint32(10)
__13:
	;
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) >= base) {
		goto __14
	}
	if (*FILE)(unsafe.Pointer((f))).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	X__shlim(tls, f, int64(0))
	(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = 22
	return uint64(0)
__14:
	;
__6:
	;
	if !(base == uint32(10)) {
		goto __15
	}
	x = uint32(0)
__17:
	if !(((uint32(c - '0')) < 10) && (x <= ((0xffffffff / uint32(10)) - uint32(1)))) {
		goto __19
	}
	x = ((x * uint32(10)) + (uint32(c - '0')))
	goto __18
__18:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __17
	goto __19
__19:
	;
	y = uint64(x)
__20:
	if !((((uint32(c - '0')) < 10) && (y <= (((2 * uint64(0x7fffffffffffffff)) + uint64(1)) / uint64(10)))) && ((uint64(10) * y) <= (((2 * uint64(0x7fffffffffffffff)) + uint64(1)) - (uint64(c - '0'))))) {
		goto __22
	}
	y = ((y * uint64(10)) + (uint64(c - '0')))
	goto __21
__21:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __20
	goto __22
__22:
	;
	if !((uint32(c - '0')) >= 10) {
		goto __23
	}
	goto done
__23:
	;
	goto __16
__15:
	if !(!((base & (base - uint32(1))) != 0)) {
		goto __24
	}
	bs = int32(*(*int8)(unsafe.Pointer(ts /* "\x00\x01\x02\x04\a\x03\x06\x05" */ + uintptr((((uint32(0x17) * base) >> 5) & uint32(7))))))
	x = uint32(0)
__26:
	if !((uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) && (x <= (0xffffffff / uint32(32)))) {
		goto __28
	}
	x = ((x << bs) | uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))))
	goto __27
__27:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __26
	goto __28
__28:
	;
	y = uint64(x)
__29:
	if !((uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) && (y <= (uint64(((2 * uint64(0x7fffffffffffffff)) + uint64(1))) >> bs))) {
		goto __31
	}
	y = ((y << bs) | uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c)))))
	goto __30
__30:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __29
	goto __31
__31:
	;
	goto __25
__24:
	x = uint32(0)
__32:
	if !((uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) && (x <= ((0xffffffff / uint32(36)) - uint32(1)))) {
		goto __34
	}
	x = ((x * base) + uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))))
	goto __33
__33:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __32
	goto __34
__34:
	;
	y = uint64(x)
__35:
	if !(((uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) && (y <= (((2 * uint64(0x7fffffffffffffff)) + uint64(1)) / uint64(base)))) && ((uint64(base) * y) <= (((2 * uint64(0x7fffffffffffffff)) + uint64(1)) - uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c))))))) {
		goto __37
	}
	y = ((y * uint64(base)) + uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c)))))
	goto __36
__36:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __35
	goto __37
__37:
	;
__25:
	;
__16:
	;
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) {
		goto __38
	}
__39:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) {
		goto __41
	}
	goto __40
__40:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer((f))).rpos != (*FILE)(unsafe.Pointer((f))).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __39
	goto __41
__41:
	;
	(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = 34
	y = lim
	if !((lim & uint64(1)) != 0) {
		goto __42
	}
	neg = 0
__42:
	;
__38:
	;
done:
	if (*FILE)(unsafe.Pointer((f))).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	if !(y >= lim) {
		goto __43
	}
	if !(!((lim & uint64(1)) != 0) && !(neg != 0)) {
		goto __44
	}
	(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = 34
	return (lim - uint64(1))
	goto __45
__44:
	if !(y > lim) {
		goto __46
	}
	(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = 34
	return lim
__46:
	;
__45:
	;
__43:
	;
	return ((y ^ uint64(neg)) - uint64(neg))
}

// The shcnt field stores the number of bytes read so far, offset by
// the value of buf-rpos at the last function call (__shlim or __shgetc),
// so that between calls the inline shcnt macro can add rpos-buf to get
// the actual count.

func X__shlim(tls *TLS, f uintptr, lim off_t) { /* shgetc.c:8:6: */
	(*FILE)(unsafe.Pointer(f)).shlim = lim
	(*FILE)(unsafe.Pointer(f)).shcnt = (off_t((int32((*FILE)(unsafe.Pointer(f)).buf) - int32((*FILE)(unsafe.Pointer(f)).rpos)) / 1))
	// If lim is nonzero, rend must be a valid pointer.
	if (lim != 0) && ((off_t((int32((*FILE)(unsafe.Pointer(f)).rend) - int32((*FILE)(unsafe.Pointer(f)).rpos)) / 1)) > lim) {
		(*FILE)(unsafe.Pointer(f)).shend = ((*FILE)(unsafe.Pointer(f)).rpos + uintptr(lim))
	} else {
		(*FILE)(unsafe.Pointer(f)).shend = (*FILE)(unsafe.Pointer(f)).rend
	}
}

func X__shgetc(tls *TLS, f uintptr) int32 { /* shgetc.c:19:5: */
	var c int32
	var cnt off_t = ((*FILE)(unsafe.Pointer((f))).shcnt + (off_t((int32((*FILE)(unsafe.Pointer((f))).rpos) - int32((*FILE)(unsafe.Pointer((f))).buf)) / 1)))
	if (((*FILE)(unsafe.Pointer(f)).shlim != 0) && (cnt >= (*FILE)(unsafe.Pointer(f)).shlim)) || ((AssignInt32(&c, X__uflow(tls, f))) < 0) {
		(*FILE)(unsafe.Pointer(f)).shcnt = ((off_t((int32((*FILE)(unsafe.Pointer(f)).buf) - int32((*FILE)(unsafe.Pointer(f)).rpos)) / 1)) + cnt)
		(*FILE)(unsafe.Pointer(f)).shend = (*FILE)(unsafe.Pointer(f)).rpos
		(*FILE)(unsafe.Pointer(f)).shlim = int64(-1)
		return -1
	}
	cnt++
	if ((*FILE)(unsafe.Pointer(f)).shlim != 0) && ((off_t((int32((*FILE)(unsafe.Pointer(f)).rend) - int32((*FILE)(unsafe.Pointer(f)).rpos)) / 1)) > ((*FILE)(unsafe.Pointer(f)).shlim - cnt)) {
		(*FILE)(unsafe.Pointer(f)).shend = ((*FILE)(unsafe.Pointer(f)).rpos + uintptr(((*FILE)(unsafe.Pointer(f)).shlim - cnt)))
	} else {
		(*FILE)(unsafe.Pointer(f)).shend = (*FILE)(unsafe.Pointer(f)).rend
	}
	(*FILE)(unsafe.Pointer(f)).shcnt = ((off_t((int32((*FILE)(unsafe.Pointer(f)).buf) - int32((*FILE)(unsafe.Pointer(f)).rpos)) / 1)) + cnt)
	if (*FILE)(unsafe.Pointer(f)).rpos <= (*FILE)(unsafe.Pointer(f)).buf {
		*(*uint8)(unsafe.Pointer((*FILE)(unsafe.Pointer(f)).rpos + UintptrFromInt32(-1))) = uint8(c)
	}
	return c
}

type uintptr_t = uint32 /* alltypes.h:78:24 */

type int8_t = int8 /* alltypes.h:119:25 */

type int16_t = int16 /* alltypes.h:124:25 */

type int32_t = int32 /* alltypes.h:129:25 */

type int64_t = int64 /* alltypes.h:134:25 */

type intmax_t = int64 /* alltypes.h:139:25 */

type uint8_t = uint8 /* alltypes.h:144:25 */

type uint16_t = uint16 /* alltypes.h:149:25 */

type uint32_t = uint32 /* alltypes.h:154:25 */

type uint64_t = uint64 /* alltypes.h:159:25 */

type uintmax_t = uint64 /* alltypes.h:169:25 */

type int_fast8_t = int8_t   /* stdint.h:22:16 */
type int_fast64_t = int64_t /* stdint.h:23:17 */

type int_least8_t = int8_t   /* stdint.h:25:17 */
type int_least16_t = int16_t /* stdint.h:26:17 */
type int_least32_t = int32_t /* stdint.h:27:17 */
type int_least64_t = int64_t /* stdint.h:28:17 */

type uint_fast8_t = uint8_t   /* stdint.h:30:17 */
type uint_fast64_t = uint64_t /* stdint.h:31:18 */

type uint_least8_t = uint8_t   /* stdint.h:33:18 */
type uint_least16_t = uint16_t /* stdint.h:34:18 */
type uint_least32_t = uint32_t /* stdint.h:35:18 */
type uint_least64_t = uint64_t /* stdint.h:36:18 */

type int_fast16_t = int32_t   /* stdint.h:1:17 */
type int_fast32_t = int32_t   /* stdint.h:2:17 */
type uint_fast16_t = uint32_t /* stdint.h:3:18 */
type uint_fast32_t = uint32_t /* stdint.h:4:18 */

type imaxdiv_t = struct {
	quot intmax_t
	rem  intmax_t
} /* inttypes.h:14:40 */

type socklen_t = uint32 /* alltypes.h:384:18 */

type sa_family_t = uint16 /* alltypes.h:389:24 */

type msghdr = struct {
	msg_name       uintptr
	msg_namelen    socklen_t
	msg_iov        uintptr
	msg_iovlen     int32
	msg_control    uintptr
	msg_controllen socklen_t
	msg_flags      int32
} /* socket.h:22:1 */

type cmsghdr = struct {
	cmsg_len   socklen_t
	cmsg_level int32
	cmsg_type  int32
} /* socket.h:44:1 */

type linger = struct {
	l_onoff  int32
	l_linger int32
} /* socket.h:74:1 */

type sockaddr = struct {
	sa_family sa_family_t
	sa_data   [14]int8
} /* socket.h:367:1 */

type sockaddr_storage = struct {
	ss_family    sa_family_t
	__ss_padding [122]int8
	__ss_align   uint32
} /* socket.h:372:1 */

type in_port_t = uint16_t                 /* in.h:12:18 */
type in_addr_t = uint32_t                 /* in.h:13:18 */
type in_addr = struct{ s_addr in_addr_t } /* in.h:14:1 */

type sockaddr_in = struct {
	sin_family sa_family_t
	sin_port   in_port_t
	sin_addr   struct{ s_addr in_addr_t }
	sin_zero   [8]uint8_t
} /* in.h:16:1 */

type in6_addr = struct {
	__in6_union struct {
		_         [0]uint32
		__s6_addr [16]uint8_t
	}
} /* in.h:23:1 */

type sockaddr_in6 = struct {
	sin6_family   sa_family_t
	sin6_port     in_port_t
	sin6_flowinfo uint32_t
	sin6_addr     struct {
		__in6_union struct {
			_         [0]uint32
			__s6_addr [16]uint8_t
		}
	}
	sin6_scope_id uint32_t
} /* in.h:34:1 */

type ipv6_mreq = struct {
	ipv6mr_multiaddr struct {
		__in6_union struct {
			_         [0]uint32
			__s6_addr [16]uint8_t
		}
	}
	ipv6mr_interface uint32
} /* in.h:42:1 */

type ip_opts = struct {
	ip_dst  struct{ s_addr in_addr_t }
	ip_opts [40]int8
} /* in.h:229:1 */

type ip_mreq = struct {
	imr_multiaddr struct{ s_addr in_addr_t }
	imr_interface struct{ s_addr in_addr_t }
} /* in.h:247:1 */

type ip_mreqn = struct {
	imr_multiaddr struct{ s_addr in_addr_t }
	imr_address   struct{ s_addr in_addr_t }
	imr_ifindex   int32
} /* in.h:252:1 */

type ip_mreq_source = struct {
	imr_multiaddr  struct{ s_addr in_addr_t }
	imr_interface  struct{ s_addr in_addr_t }
	imr_sourceaddr struct{ s_addr in_addr_t }
} /* in.h:258:1 */

type ip_msfilter = struct {
	imsf_multiaddr struct{ s_addr in_addr_t }
	imsf_interface struct{ s_addr in_addr_t }
	imsf_fmode     uint32_t
	imsf_numsrc    uint32_t
	imsf_slist     [1]struct{ s_addr in_addr_t }
} /* in.h:264:1 */

type group_req = struct {
	gr_interface uint32_t
	gr_group     struct {
		ss_family    sa_family_t
		__ss_padding [122]int8
		__ss_align   uint32
	}
} /* in.h:275:1 */

type group_source_req = struct {
	gsr_interface uint32_t
	gsr_group     struct {
		ss_family    sa_family_t
		__ss_padding [122]int8
		__ss_align   uint32
	}
	gsr_source struct {
		ss_family    sa_family_t
		__ss_padding [122]int8
		__ss_align   uint32
	}
} /* in.h:280:1 */

type group_filter = struct {
	gf_interface uint32_t
	gf_group     struct {
		ss_family    sa_family_t
		__ss_padding [122]int8
		__ss_align   uint32
	}
	gf_fmode  uint32_t
	gf_numsrc uint32_t
	gf_slist  [1]struct {
		ss_family    sa_family_t
		__ss_padding [122]int8
		__ss_align   uint32
	}
} /* in.h:286:1 */

type in_pktinfo = struct {
	ipi_ifindex  int32
	ipi_spec_dst struct{ s_addr in_addr_t }
	ipi_addr     struct{ s_addr in_addr_t }
} /* in.h:297:1 */

type in6_pktinfo = struct {
	ipi6_addr struct {
		__in6_union struct {
			_         [0]uint32
			__s6_addr [16]uint8_t
		}
	}
	ipi6_ifindex uint32
} /* in.h:303:1 */

type ip6_mtuinfo = struct {
	ip6m_addr struct {
		sin6_family   sa_family_t
		sin6_port     in_port_t
		sin6_flowinfo uint32_t
		sin6_addr     struct {
			__in6_union struct {
				_         [0]uint32
				__s6_addr [16]uint8_t
			}
		}
		sin6_scope_id uint32_t
	}
	ip6m_mtu uint32_t
} /* in.h:308:1 */

type addrinfo = struct {
	ai_flags     int32
	ai_family    int32
	ai_socktype  int32
	ai_protocol  int32
	ai_addrlen   socklen_t
	ai_addr      uintptr
	ai_canonname uintptr
	ai_next      uintptr
} /* netdb.h:16:1 */

// Legacy functions follow (marked OBsolete in SUS)

type netent = struct {
	n_name     uintptr
	n_aliases  uintptr
	n_addrtype int32
	n_net      uint32_t
} /* netdb.h:62:1 */

type hostent = struct {
	h_name      uintptr
	h_aliases   uintptr
	h_addrtype  int32
	h_length    int32
	h_addr_list uintptr
} /* netdb.h:69:1 */

type servent = struct {
	s_name    uintptr
	s_aliases uintptr
	s_port    int32
	s_proto   uintptr
} /* netdb.h:78:1 */

type protoent = struct {
	p_name    uintptr
	p_aliases uintptr
	p_proto   int32
} /* netdb.h:85:1 */

type aibuf = struct {
	ai struct {
		ai_flags     int32
		ai_family    int32
		ai_socktype  int32
		ai_protocol  int32
		ai_addrlen   socklen_t
		ai_addr      uintptr
		ai_canonname uintptr
		ai_next      uintptr
	}
	sa struct {
		sin struct {
			sin_family sa_family_t
			sin_port   in_port_t
			sin_addr   struct{ s_addr in_addr_t }
			sin_zero   [8]uint8_t
		}
		_ [12]byte
	}
	lock [1]int32
	slot int16
	ref  int16
} /* lookup.h:10:1 */

type sa = struct {
	sin struct {
		sin_family sa_family_t
		sin_port   in_port_t
		sin_addr   struct{ s_addr in_addr_t }
		sin_zero   [8]uint8_t
	}
	_ [12]byte
} /* lookup.h:10:1 */

type address = struct {
	family  int32
	scopeid uint32
	addr    [16]uint8_t
	sortkey int32
} /* lookup.h:20:1 */

type service = struct {
	port     uint16_t
	proto    uint8
	socktype uint8
} /* lookup.h:27:1 */

type resolvconf = struct {
	ns [3]struct {
		family  int32
		scopeid uint32
		addr    [16]uint8_t
		sortkey int32
	}
	nns      uint32
	attempts uint32
	ndots    uint32
	timeout  uint32
} /* lookup.h:34:1 */

func Xfreeaddrinfo(tls *TLS, p uintptr) { /* freeaddrinfo.c:7:6: */
	var cnt size_t
	cnt = size_t(1)
__1:
	if !((*addrinfo)(unsafe.Pointer(p)).ai_next != 0) {
		goto __3
	}
	goto __2
__2:
	cnt++
	p = (*addrinfo)(unsafe.Pointer(p)).ai_next
	goto __1
	goto __3
__3:
	;
	var b uintptr = (p - uintptr((size_t((((uintptr(0) /* &.ai */) - uintptr(0)) / 1)))))
	b -= 68 * (uintptr((*aibuf)(unsafe.Pointer(b)).slot))
	//TODO LOCK(b->lock);
	if !(int32(AssignSubPtrInt16(b+66 /* &.ref */, int16(cnt))) != 0) {
		Xfree(tls, b)
	}
	//TODO else UNLOCK(b->lock);
}

type time_t = int64 /* alltypes.h:108:16 */

type clockid_t = int32 /* alltypes.h:237:13 */

type timespec = struct {
	tv_sec  time_t
	tv_nsec int32
	__12    uint32 /* int : 32 */
} /* alltypes.h:252:1 */

type pthread_t = uintptr /* alltypes.h:296:26 */

type pthread_once_t = int32 /* alltypes.h:302:13 */

type pthread_key_t = uint32 /* alltypes.h:307:18 */

type pthread_spinlock_t = int32 /* alltypes.h:312:13 */

type pthread_mutexattr_t = struct{ __attr uint32 } /* alltypes.h:317:37 */

type pthread_condattr_t = struct{ __attr uint32 } /* alltypes.h:322:37 */

type pthread_barrierattr_t = struct{ __attr uint32 } /* alltypes.h:327:37 */

type pthread_rwlockattr_t = struct{ __attr [2]uint32 } /* alltypes.h:332:40 */

type __sigset_t = struct{ __bits [32]uint32 } /* alltypes.h:372:9 */

type sigset_t = __sigset_t /* alltypes.h:372:71 */

type pthread_attr_t = struct{ __u struct{ __i [9]int32 } } /* alltypes.h:395:147 */

type pthread_mutex_t = struct{ __u struct{ __i [6]int32 } } /* alltypes.h:400:157 */

type pthread_cond_t = struct{ __u struct{ __i [12]int32 } } /* alltypes.h:410:112 */

type pthread_rwlock_t = struct{ __u struct{ __i [8]int32 } } /* alltypes.h:420:139 */

type pthread_barrier_t = struct{ __u struct{ __i [5]int32 } } /* alltypes.h:425:137 */

type sched_param = struct {
	sched_priority int32
	__reserved1    int32
	__reserved2    [4]int32
	__reserved3    int32
} /* sched.h:19:1 */

type timer_t = uintptr /* alltypes.h:232:14 */

type clock_t = int32 /* alltypes.h:242:14 */

type tm = struct {
	tm_sec    int32
	tm_min    int32
	tm_hour   int32
	tm_mday   int32
	tm_mon    int32
	tm_year   int32
	tm_wday   int32
	tm_yday   int32
	tm_isdst  int32
	tm_gmtoff int32
	tm_zone   uintptr
} /* time.h:38:1 */

type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int32
		__12    uint32 /* int : 32 */
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int32
		__12    uint32 /* int : 32 */
	}
} /* time.h:80:1 */

type __ptcb = struct {
	__f    uintptr
	__x    uintptr
	__next uintptr
} /* pthread.h:206:1 */

func __bswap32(tls *TLS, __x uint32_t) uint32_t { /* endian.h:24:26: */
	return ((((__x >> 24) | ((__x >> 8) & uint32_t(0xff00))) | ((__x << 8) & uint32_t(0xff0000))) | (__x << 24))
}

func Xgetaddrinfo(tls *TLS, host uintptr, serv uintptr, hint uintptr, res uintptr) int32 { /* getaddrinfo.c:12:5: */
	bp := tls.Alloc(1608)
	defer tls.Free(1608)

	// var ports [2]service at bp, 8

	// var addrs [48]address at bp+8, 1344

	// var canon [256]int8 at bp+1352, 256

	var outcanon uintptr
	var nservs int32
	var naddrs int32
	var nais int32
	var canon_len int32
	var i int32
	var j int32
	var k int32
	var family int32 = 0
	var flags int32 = 0
	var proto int32 = 0
	var socktype int32 = 0
	var out uintptr

	if !(host != 0) && !(serv != 0) {
		return -2
	}

	if hint != 0 {
		family = (*addrinfo)(unsafe.Pointer(hint)).ai_family
		flags = (*addrinfo)(unsafe.Pointer(hint)).ai_flags
		proto = (*addrinfo)(unsafe.Pointer(hint)).ai_protocol
		socktype = (*addrinfo)(unsafe.Pointer(hint)).ai_socktype

		var mask int32 = ((((((0x01 | 0x02) | 0x04) | 0x08) | 0x10) | 0x20) | 0x400)
		if (flags & mask) != flags {
			return -1
		}

		switch family {
		case 2:
			fallthrough
		case 10:
			fallthrough
		case 0:
			break
			fallthrough
		default:
			return -6
		}
	}

	if (flags & 0x20) != 0 {
		Xabort(tls)
	}

	nservs = X__lookup_serv(tls, bp /* &ports[0] */, serv, proto, socktype, flags)
	if nservs < 0 {
		return nservs
	}

	naddrs = X__lookup_name(tls, bp+8 /* &addrs[0] */, bp+1352 /* &canon[0] */, host, family, flags)
	if naddrs < 0 {
		return naddrs
	}

	nais = (nservs * naddrs)
	canon_len = int32(Xstrlen(tls, bp+1352 /* &canon[0] */))
	out = Xcalloc(tls, uint32(1), (((uint32(nais) * uint32(unsafe.Sizeof(aibuf{}))) + uint32(canon_len)) + uint32(1)))
	if !(out != 0) {
		return -10
	}

	if canon_len != 0 {
		outcanon = (out + uintptr(nais)*68)
		Xmemcpy(tls, outcanon, bp+1352 /* &canon[0] */, (uint32(canon_len + 1)))
	} else {
		outcanon = uintptr(0)
	}

	for k = AssignInt32(&i, 0); i < naddrs; i++ {
		j = 0
	__1:
		if !(j < nservs) {
			goto __3
		}
		{
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*68)).slot = int16(k)
			//TODO out[k].ai = (struct addrinfo){
			//TODO 	.ai_family = addrs[i].family,
			//TODO 	.ai_socktype = ports[j].socktype,
			//TODO 	.ai_protocol = ports[j].proto,
			//TODO 	.ai_addrlen = addrs[i].family == AF_INET
			//TODO 		? sizeof(struct sockaddr_in)
			//TODO 		: sizeof(struct sockaddr_in6),
			//TODO 	.ai_addr = (void *)&out[k].sa,
			//TODO 	.ai_canonname = outcanon };
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*68)).ai.ai_family = (*address)(unsafe.Pointer(bp + 8 /* &addrs */ + uintptr(i)*28)).family
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*68)).ai.ai_socktype = int32((*service)(unsafe.Pointer(bp /* &ports */ + uintptr(j)*4)).socktype)
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*68)).ai.ai_protocol = int32((*service)(unsafe.Pointer(bp /* &ports */ + uintptr(j)*4)).proto)
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*68)).ai.ai_addrlen = func() uint32 {
				if (*address)(unsafe.Pointer(bp+8 /* &addrs */ +uintptr(i)*28)).family == 2 {
					return uint32(unsafe.Sizeof(sockaddr_in{}))
				}
				return uint32(unsafe.Sizeof(sockaddr_in6{}))
			}()
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*68)).ai.ai_addr = (out + uintptr(k)*68 + 32 /* &.sa */)
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*68)).ai.ai_canonname = outcanon
			if k != 0 {
				(*aibuf)(unsafe.Pointer(out + uintptr((k-1))*68)).ai.ai_next = (out + uintptr(k)*68 /* &.ai */)
			}
			switch (*address)(unsafe.Pointer(bp + 8 /* &addrs */ + uintptr(i)*28)).family {
			case 2:
				(*sockaddr_in)(unsafe.Pointer(out + uintptr(k)*68 + 32 /* &.sa */)).sin_family = sa_family_t(2)
				(*sockaddr_in)(unsafe.Pointer(out + uintptr(k)*68 + 32 /* &.sa */)).sin_port = Xhtons(tls, (*service)(unsafe.Pointer(bp /* &ports */ +uintptr(j)*4)).port)
				Xmemcpy(tls, (out + uintptr(k)*68 + 32 /* &.sa */ /* &.sin */ + 4 /* &.sin_addr */), (bp + 8 /* &addrs */ + uintptr(i)*28 + 8 /* &.addr */), uint32(4))
				break
			case 10:
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*68 + 32 /* &.sa */)).sin6_family = sa_family_t(10)
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*68 + 32 /* &.sa */)).sin6_port = Xhtons(tls, (*service)(unsafe.Pointer(bp /* &ports */ +uintptr(j)*4)).port)
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*68 + 32 /* &.sa */)).sin6_scope_id = (*address)(unsafe.Pointer(bp + 8 /* &addrs */ + uintptr(i)*28)).scopeid
				Xmemcpy(tls, (out + uintptr(k)*68 + 32 /* &.sa */ /* &.sin6 */ + 8 /* &.sin6_addr */), (bp + 8 /* &addrs */ + uintptr(i)*28 + 8 /* &.addr */), uint32(16))
				break
			}
		}
		goto __2
	__2:
		j++
		k++
		goto __1
		goto __3
	__3:
	}
	(*aibuf)(unsafe.Pointer(out + uintptr(0)*68)).ref = int16(nais)
	*(*uintptr)(unsafe.Pointer(res)) = (out /* &.ai */)
	return 0
}

type ucred = struct {
	pid pid_t
	uid uid_t
	gid gid_t
} /* socket.h:57:1 */

type mmsghdr = struct {
	msg_hdr struct {
		msg_name       uintptr
		msg_namelen    socklen_t
		msg_iov        uintptr
		msg_iovlen     int32
		msg_control    uintptr
		msg_controllen socklen_t
		msg_flags      int32
	}
	msg_len uint32
} /* socket.h:63:1 */

func Xgethostbyaddr(tls *TLS, a uintptr, l socklen_t, af int32) uintptr { /* gethostbyaddr.c:7:16: */
	bp := tls.Alloc(4)
	defer tls.Free(4)

	var size size_t = size_t(63)
	// var res uintptr at bp, 4

	var err int32
	for ok := true; ok; ok = (err == 34) {
		Xfree(tls, h)
		h = Xmalloc(tls, AssignAddUint32(&size, (size+size_t(1))))
		if !(h != 0) {
			(*(*int32)(unsafe.Pointer(X__h_errno_location(tls)))) = 3
			return uintptr(0)
		}
		err = Xgethostbyaddr_r(tls, a, l, af, h,
			(h + uintptr(1)*20), (size - size_t(unsafe.Sizeof(hostent{}))), bp /* &res */, X__h_errno_location(tls))
	}
	if err != 0 {
		return uintptr(0)
	}
	return h
}

var h uintptr /* gethostbyaddr.c:9:24: */

func Xgethostbyaddr_r(tls *TLS, a uintptr, l socklen_t, af int32, h uintptr, buf uintptr, buflen size_t, res uintptr, err uintptr) int32 { /* gethostbyaddr_r.c:10:5: */
	bp := tls.Alloc(28)
	defer tls.Free(28)

	//TODO union {
	//TODO 	struct sockaddr_in sin;
	//TODO 	struct sockaddr_in6 sin6;
	//TODO } sa = { .sin.sin_family = af };
	*(*struct {
		sin sockaddr_in
		_   [12]byte
	})(unsafe.Pointer(bp /* sa1 */)) = struct {
		sin sockaddr_in
		_   [12]byte
	}{} //TODO-
	(*sockaddr_in)(unsafe.Pointer(bp /* &sa1 */)).sin_family = sa_family_t(af) //TODO-
	var sl socklen_t
	if af == 10 {
		sl = uint32(unsafe.Sizeof(sockaddr_in6{}))
	} else {
		sl = uint32(unsafe.Sizeof(sockaddr_in{}))
	}
	var i int32

	*(*uintptr)(unsafe.Pointer(res)) = uintptr(0)

	// Load address argument into sockaddr structure
	if (af == 10) && (l == socklen_t(16)) {
		Xmemcpy(tls, (bp /* &sa1 */ /* &.sin6 */ + 8 /* &.sin6_addr */), a, uint32(16))
	} else if (af == 2) && (l == socklen_t(4)) {
		Xmemcpy(tls, (bp /* &sa1 */ /* &.sin */ + 4 /* &.sin_addr */), a, uint32(4))
	} else {
		*(*int32)(unsafe.Pointer(err)) = 3
		return 22
	}

	// Align buffer and check for space for pointers and ip address
	i = (int32(uintptr_t(buf) & (uint32(unsafe.Sizeof(uintptr(0))) - uint32(1))))
	if !(i != 0) {
		i = int32(unsafe.Sizeof(uintptr(0)))
	}
	if buflen <= (((uint32(5) * uint32(unsafe.Sizeof(uintptr(0)))) - uint32(i)) + l) {
		return 34
	}
	buf += (uintptr(uint32(unsafe.Sizeof(uintptr(0))) - uint32(i)))
	buflen = buflen - (((uint32(5) * uint32(unsafe.Sizeof(uintptr(0)))) - uint32(i)) + l)

	(*hostent)(unsafe.Pointer(h)).h_addr_list = buf
	buf += (uintptr(uint32(2) * uint32(unsafe.Sizeof(uintptr(0)))))
	(*hostent)(unsafe.Pointer(h)).h_aliases = buf
	buf += (uintptr(uint32(2) * uint32(unsafe.Sizeof(uintptr(0)))))

	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(0)*4)) = buf
	Xmemcpy(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(0)*4)), a, l)
	buf += uintptr(l)
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(1)*4)) = uintptr(0)
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + uintptr(0)*4)) = buf
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + uintptr(1)*4)) = uintptr(0)

	switch Xgetnameinfo(tls, bp /* &sa1 */, sl, buf, buflen, uintptr(0), uint32(0), 0) {
	case -3:
		*(*int32)(unsafe.Pointer(err)) = 2
		return 11
	case -12:
		return 34
	default:
		fallthrough
	case -10:
		fallthrough
	case -11:
		fallthrough
	case -4:
		*(*int32)(unsafe.Pointer(err)) = 3
		return *(*int32)(unsafe.Pointer(X___errno_location(tls)))
	case 0:
		break
	}

	(*hostent)(unsafe.Pointer(h)).h_addrtype = af
	(*hostent)(unsafe.Pointer(h)).h_length = int32(l)
	(*hostent)(unsafe.Pointer(h)).h_name = *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + uintptr(0)*4))
	*(*uintptr)(unsafe.Pointer(res)) = h
	return 0
}

func Xgethostbyname(tls *TLS, name uintptr) uintptr { /* gethostbyname.c:8:16: */
	return Xgethostbyname2(tls, name, 2)
}

func Xgethostbyname2(tls *TLS, name uintptr, af int32) uintptr { /* gethostbyname2.c:8:16: */
	bp := tls.Alloc(4)
	defer tls.Free(4)

	var size size_t = size_t(63)
	// var res uintptr at bp, 4

	var err int32
	for ok := true; ok; ok = (err == 34) {
		Xfree(tls, h1)
		h1 = Xmalloc(tls, AssignAddUint32(&size, (size+size_t(1))))
		if !(h1 != 0) {
			(*(*int32)(unsafe.Pointer(X__h_errno_location(tls)))) = 3
			return uintptr(0)
		}
		err = Xgethostbyname2_r(tls, name, af, h1,
			(h1 + uintptr(1)*20), (size - size_t(unsafe.Sizeof(hostent{}))), bp /* &res */, X__h_errno_location(tls))
	}
	if err != 0 {
		return uintptr(0)
	}
	return h1
}

var h1 uintptr /* gethostbyname2.c:10:24: */

func Xgethostbyname2_r(tls *TLS, name uintptr, af int32, h uintptr, buf uintptr, buflen size_t, res uintptr, err uintptr) int32 { /* gethostbyname2_r.c:11:5: */
	bp := tls.Alloc(1600)
	defer tls.Free(1600)

	// var addrs [48]address at bp, 1344

	// var canon [256]int8 at bp+1344, 256

	var i int32
	var cnt int32
	var align size_t
	var need size_t

	*(*uintptr)(unsafe.Pointer(res)) = uintptr(0)
	cnt = X__lookup_name(tls, bp /* &addrs[0] */, bp+1344 /* &canon[0] */, name, af, 0x02)
	if cnt < 0 {
		switch cnt {
		case -2:
			*(*int32)(unsafe.Pointer(err)) = 1
			return 2
			fallthrough
		case -3:
			*(*int32)(unsafe.Pointer(err)) = 2
			return 11
			fallthrough
		default:
			fallthrough
		case -4:
			*(*int32)(unsafe.Pointer(err)) = 3
			return 74
			fallthrough
		case -10:
			fallthrough
		case -11:
			*(*int32)(unsafe.Pointer(err)) = 3
			return *(*int32)(unsafe.Pointer(X___errno_location(tls)))
		}
	}

	(*hostent)(unsafe.Pointer(h)).h_addrtype = af
	(*hostent)(unsafe.Pointer(h)).h_length = func() int32 {
		if af == 10 {
			return 16
		}
		return 4
	}()

	// Align buffer
	align = (-uintptr_t(buf) & (uint32(unsafe.Sizeof(uintptr(0))) - uint32(1)))

	need = (uint32(4) * uint32(unsafe.Sizeof(uintptr(0))))
	need = need + ((uint32(cnt + 1)) * (uint32(unsafe.Sizeof(uintptr(0))) + uint32((*hostent)(unsafe.Pointer(h)).h_length)))
	need = need + (Xstrlen(tls, name) + size_t(1))
	need = need + (Xstrlen(tls, bp+1344 /* &canon[0] */) + size_t(1))
	need = need + (align)

	if need > buflen {
		return 34
	}

	buf += uintptr(align)
	(*hostent)(unsafe.Pointer(h)).h_aliases = buf
	buf += (uintptr(uint32(3) * uint32(unsafe.Sizeof(uintptr(0)))))
	(*hostent)(unsafe.Pointer(h)).h_addr_list = buf
	buf += (uintptr((uint32(cnt + 1)) * uint32(unsafe.Sizeof(uintptr(0)))))

	for i = 0; i < cnt; i++ {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(i)*4)) = buf
		buf += uintptr((*hostent)(unsafe.Pointer(h)).h_length)
		Xmemcpy(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(i)*4)), bp /* &addrs */ +uintptr(i)*28+8 /* &.addr */, uint32((*hostent)(unsafe.Pointer(h)).h_length))
	}
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(i)*4)) = uintptr(0)

	(*hostent)(unsafe.Pointer(h)).h_name = AssignPtrUintptr((*hostent)(unsafe.Pointer(h)).h_aliases+uintptr(0)*4, buf)
	Xstrcpy(tls, (*hostent)(unsafe.Pointer(h)).h_name, bp+1344 /* &canon[0] */)
	buf += (uintptr(Xstrlen(tls, (*hostent)(unsafe.Pointer(h)).h_name) + size_t(1)))

	if Xstrcmp(tls, (*hostent)(unsafe.Pointer(h)).h_name, name) != 0 {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + uintptr(1)*4)) = buf
		Xstrcpy(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + uintptr(1)*4)), name)
		buf += (uintptr(Xstrlen(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + uintptr(1)*4))) + size_t(1)))
	} else {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + uintptr(1)*4)) = uintptr(0)
	}

	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + uintptr(2)*4)) = uintptr(0)

	*(*uintptr)(unsafe.Pointer(res)) = h
	return 0
}

type if_nameindex = struct {
	if_index uint32
	if_name  uintptr
} /* if.h:12:1 */

type ifaddr = struct {
	ifa_addr struct {
		sa_family sa_family_t
		sa_data   [14]int8
	}
	ifa_ifu struct {
		ifu_broadaddr struct {
			sa_family sa_family_t
			sa_data   [14]int8
		}
	}
	ifa_ifp  uintptr
	ifa_next uintptr
} /* if.h:51:1 */

type ifmap = struct {
	mem_start uint32
	mem_end   uint32
	base_addr uint16
	irq       uint8
	dma       uint8
	port      uint8
	_         [3]byte
} /* if.h:64:1 */

type ifreq = struct {
	ifr_ifrn struct{ ifrn_name [16]int8 }
	ifr_ifru struct {
		_         [0]uint32
		ifru_addr struct {
			sa_family sa_family_t
			sa_data   [14]int8
		}
	}
} /* if.h:76:1 */

type ifconf = struct {
	ifc_len  int32
	ifc_ifcu struct{ ifcu_buf uintptr }
} /* if.h:116:1 */

func __isspace4(tls *TLS, _c int32) int32 { /* ctype.h:26:21: */
	return (Bool32((_c == ' ') || ((uint32(_c) - uint32('\t')) < uint32(5))))
}

type ns_sect = uint32 /* nameser.h:37:3 */

type __ns_msg = struct {
	_msg      uintptr
	_eom      uintptr
	_id       uint16_t
	_flags    uint16_t
	_counts   [4]uint16_t
	_sections [4]uintptr
	_sect     ns_sect
	_rrnum    int32
	_msg_ptr  uintptr
} /* nameser.h:39:9 */

type ns_msg = __ns_msg /* nameser.h:46:3 */

type _ns_flagdata = struct {
	mask  int32
	shift int32
} /* nameser.h:48:1 */

type __ns_rr = struct {
	name     [1025]int8
	_        [1]byte
	__type   uint16_t
	rr_class uint16_t
	_        [2]byte
	ttl      uint32_t
	rdlength uint16_t
	_        [2]byte
	rdata    uintptr
} /* nameser.h:59:9 */

type ns_rr = __ns_rr /* nameser.h:66:3 */

type ns_flag = uint32 /* nameser.h:87:3 */

type ns_opcode = uint32 /* nameser.h:96:3 */

type ns_rcode = uint32 /* nameser.h:115:3 */

type ns_update_operation = uint32 /* nameser.h:121:3 */

type ns_tsig_key1 = struct {
	name [1025]int8
	alg  [1025]int8
	_    [2]byte
	data uintptr
	len  int32
} /* nameser.h:123:1 */

type ns_tsig_key = ns_tsig_key1 /* nameser.h:128:28 */

type ns_tcp_tsig_state1 = struct {
	counter int32
	key     uintptr
	ctx     uintptr
	sig     [512]uint8
	siglen  int32
} /* nameser.h:130:1 */

type ns_tcp_tsig_state = ns_tcp_tsig_state1 /* nameser.h:137:34 */

type ns_type = uint32 /* nameser.h:200:3 */

type ns_class = uint32 /* nameser.h:219:3 */

type ns_key_types = uint32 /* nameser.h:226:3 */

type ns_cert_types = uint32 /* nameser.h:234:3 */

type HEADER = struct {
	_       [0]uint32
	id      uint32 /* unsigned id: 16, unsigned rd: 1, unsigned tc: 1, unsigned aa: 1, unsigned opcode: 4, unsigned qr: 1, unsigned rcode: 4, unsigned cd: 1, unsigned ad: 1, unsigned unused: 1, unsigned ra: 1 */
	qdcount uint32 /* unsigned qdcount: 16, unsigned ancount: 16 */
	nscount uint32 /* unsigned nscount: 16, unsigned arcount: 16 */
} /* nameser.h:353:3 */

// unused; purely for broken apps
type __res_state = struct {
	retrans     int32
	retry       int32
	options     uint32
	nscount     int32
	nsaddr_list [3]struct {
		sin_family sa_family_t
		sin_port   in_port_t
		sin_addr   struct{ s_addr in_addr_t }
		sin_zero   [8]uint8_t
	}
	id        uint16
	_         [2]byte
	dnsrch    [7]uintptr
	defdname  [256]int8
	pfcode    uint32
	ndots     uint32 /* unsigned ndots: 4, unsigned nsort: 4, unsigned ipv6_unavail: 1, unsigned unused: 23 */
	sort_list [10]struct {
		addr struct{ s_addr in_addr_t }
		mask uint32_t
	}
	qhook       uintptr
	rhook       uintptr
	res_h_errno int32
	_vcsock     int32
	_flags      uint32
	_u          struct {
		_   [0]uint32
		pad [52]int8
	}
} /* resolv.h:26:9 */

// unused; purely for broken apps
type res_state = uintptr /* resolv.h:62:3 */

type res_sym = struct {
	number    int32
	name      uintptr
	humanname uintptr
} /* resolv.h:70:1 */

func itoa(tls *TLS, p uintptr, x uint32) uintptr { /* getnameinfo.c:18:13: */
	p += (uintptr(uint32(3) * uint32(unsafe.Sizeof(int32(0)))))
	*(*int8)(unsafe.Pointer(PreDecUintptr(&p, 1))) = int8(0)
	for ok := true; ok; ok = x != 0 {
		*(*int8)(unsafe.Pointer(PreDecUintptr(&p, 1))) = (int8(uint32('0') + (x % uint32(10))))
		x = x / (uint32(10))
	}
	return p
}

func mkptr4(tls *TLS, s uintptr, ip uintptr) { /* getnameinfo.c:28:13: */
	bp := tls.Alloc(32)
	defer tls.Free(32)

	Xsprintf(tls, s, ts+9, /* "%d.%d.%d.%d.in-a..." */
		VaList(bp, int32(*(*uint8)(unsafe.Pointer(ip + uintptr(3)))), int32(*(*uint8)(unsafe.Pointer(ip + uintptr(2)))), int32(*(*uint8)(unsafe.Pointer(ip + uintptr(1)))), int32(*(*uint8)(unsafe.Pointer(ip + uintptr(0))))))
}

func mkptr6(tls *TLS, s uintptr, ip uintptr) { /* getnameinfo.c:34:13: */
	var i int32
	for i = 15; i >= 0; i-- {
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = xdigits[(int32(*(*uint8)(unsafe.Pointer(ip + uintptr(i)))) & 15)]
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = int8('.')
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = xdigits[(int32(*(*uint8)(unsafe.Pointer(ip + uintptr(i)))) >> 4)]
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = int8('.')
	}
	Xstrcpy(tls, s, ts+34 /* "ip6.arpa" */)
}

var xdigits = *(*[17]int8)(unsafe.Pointer(ts + 43 /* "0123456789abcdef" */)) /* getnameinfo.c:36:20 */

func reverse_hosts(tls *TLS, buf uintptr, a uintptr, scopeid uint32, family int32) { /* getnameinfo.c:45:13: */
	bp := tls.Alloc(556)
	defer tls.Free(556)

	// var line [512]int8 at bp+16, 512

	var p uintptr
	var z uintptr
	var _buf [1032]uint8
	_ = _buf
	// var atmp [16]uint8 at bp, 16

	// var iplit address at bp+528, 28

	//TODO FILE _f, *f = __fopen_rb_ca("/etc/hosts", &_f, _buf, sizeof _buf);
	var f uintptr = Xfopen(tls, ts+60 /* "/etc/hosts" */, ts+71 /* "rb" */)
	if !(f != 0) {
		return
	}
	if family == 2 {
		Xmemcpy(tls, (bp /* &atmp[0] */ + uintptr(12)), a, uint32(4))
		Xmemcpy(tls, bp /* &atmp[0] */, ts+74 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff" */, uint32(12))
		a = bp /* &atmp[0] */
	}
	for Xfgets(tls, bp+16 /* &line[0] */, int32(unsafe.Sizeof([512]int8{})), f) != 0 {
		if AssignUintptr(&p, Xstrchr(tls, bp+16 /* &line[0] */, '#')) != 0 {
			*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8('\n')
			*(*int8)(unsafe.Pointer(p)) = int8(0)
		}

		for p = bp + 16; /* &line[0] */ (*(*int8)(unsafe.Pointer(p)) != 0) && !(__isspace4(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0); p++ {
		}
		*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8(0)
		if X__lookup_ipliteral(tls, bp+528 /* &iplit */, bp+16 /* &line[0] */, 0) <= 0 {
			continue
		}

		if (*address)(unsafe.Pointer(bp+528 /* &iplit */)).family == 2 {
			Xmemcpy(tls, ((bp + 528 /* &iplit */ + 8 /* &.addr */) + uintptr(12)), bp+528 /* &iplit */ +8 /* &.addr */, uint32(4))
			Xmemcpy(tls, bp+528 /* &iplit */ +8 /* &.addr */, ts+74 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff" */, uint32(12))
			(*address)(unsafe.Pointer(bp + 528 /* &iplit */)).scopeid = uint32(0)
		}

		if (Xmemcmp(tls, a, bp+528 /* &iplit */ +8 /* &.addr */, uint32(16)) != 0) || ((*address)(unsafe.Pointer(bp+528 /* &iplit */)).scopeid != scopeid) {
			continue
		}

		for ; (*(*int8)(unsafe.Pointer(p)) != 0) && (__isspace4(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0); p++ {
		}
		for z = p; (*(*int8)(unsafe.Pointer(z)) != 0) && !(__isspace4(tls, int32(*(*int8)(unsafe.Pointer(z)))) != 0); z++ {
		}
		*(*int8)(unsafe.Pointer(z)) = int8(0)
		if ((int32(z) - int32(p)) / 1) < 256 {
			Xmemcpy(tls, buf, p, (uint32(((int32(z) - int32(p)) / 1) + 1)))
			break
		}
	}
	//TODO __fclose_ca(f);
	Xfclose(tls, f)
}

func reverse_services(tls *TLS, buf uintptr, port int32, dgram int32) { /* getnameinfo.c:87:13: */
	Xabort(tls) //TODO-
	// unsigned long svport;
	// char line[128], *p, *z;
	// unsigned char _buf[1032];
	// FILE _f, *f = __fopen_rb_ca("/etc/services", &_f, _buf, sizeof _buf);
	// if (!f) return;
	// while (fgets(line, sizeof line, f)) {
	// 	if ((p=strchr(line, '#'))) *p++='\n', *p=0;

	// 	for (p=line; *p && !isspace(*p); p++);
	// 	if (!*p) continue;
	// 	*p++ = 0;
	// 	svport = strtoul(p, &z, 10);

	// 	if (svport != port || z==p) continue;
	// 	if (dgram && strncmp(z, "/udp", 4)) continue;
	// 	if (!dgram && strncmp(z, "/tcp", 4)) continue;
	// 	if (p-line > 32) continue;

	// 	memcpy(buf, line, p-line);
	// 	break;
	// }
	// __fclose_ca(f);
}

func dns_parse_callback(tls *TLS, c uintptr, rr int32, data uintptr, len int32, packet uintptr) int32 { /* getnameinfo.c:114:12: */
	Xabort(tls)
	return int32(0) //TODO-
	// if (rr != RR_PTR) return 0;
	// if (__dn_expand(packet, (const unsigned char *)packet + 512,
	//     data, c, 256) <= 0)
	// 	*(char *)c = 0;
	// return 0;

}

func Xgetnameinfo(tls *TLS, sa1 uintptr, sl socklen_t, node uintptr, nodelen socklen_t, serv uintptr, servlen socklen_t, flags int32) int32 { /* getnameinfo.c:125:5: */
	bp := tls.Alloc(347)
	defer tls.Free(347)

	// var ptr [78]int8 at bp, 78

	// var buf [256]int8 at bp+78, 256

	// var num [13]int8 at bp+334, 13

	var af int32 = int32((*sockaddr)(unsafe.Pointer(sa1)).sa_family)
	var a uintptr
	var scopeid uint32

	switch af {
	case 2:
		a = (sa1 + 4 /* &.sin_addr */)
		if (sl < socklen_t(unsafe.Sizeof(sockaddr_in{}))) {
			return -6
		}
		mkptr4(tls, bp /* &ptr[0] */, a)
		scopeid = uint32(0)
		break
	case 10:
		a = (sa1 + 8 /* &.sin6_addr */)
		if (sl < socklen_t(unsafe.Sizeof(sockaddr_in6{}))) {
			return -6
		}
		if Xmemcmp(tls, a, ts+74 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff" */, uint32(12)) != 0 {
			mkptr6(tls, bp /* &ptr[0] */, a)
		} else {
			mkptr4(tls, bp /* &ptr[0] */, (a + uintptr(12)))
		}
		scopeid = (*sockaddr_in6)(unsafe.Pointer(sa1)).sin6_scope_id
		break
	default:
		return -6
	}

	if (node != 0) && (nodelen != 0) {
		*(*int8)(unsafe.Pointer(bp + 78 /* &buf[0] */ + uintptr(0))) = int8(0)
		if !((flags & 0x01) != 0) {
			reverse_hosts(tls, bp+78 /* &buf[0] */, a, scopeid, af)
		}
		if !(int32(*(*int8)(unsafe.Pointer(bp + 78 /* buf */))) != 0) && !((flags & 0x01) != 0) {
			Xabort(tls)
		}
		if !(int32(*(*int8)(unsafe.Pointer(bp + 78 /* buf */))) != 0) {
			if (flags & 0x08) != 0 {
				return -2
			}
			Xinet_ntop(tls, af, a, bp+78 /* &buf[0] */, uint32(unsafe.Sizeof([256]int8{})))
			if scopeid != 0 {
				Xabort(tls)
			}
		}
		if Xstrlen(tls, bp+78 /* &buf[0] */) >= nodelen {
			return -12
		}
		Xstrcpy(tls, node, bp+78 /* &buf[0] */)
	}

	if (serv != 0) && (servlen != 0) {
		var p uintptr = bp + 78 /* buf */
		var port int32 = int32(Xntohs(tls, (*sockaddr_in)(unsafe.Pointer(sa1)).sin_port))
		*(*int8)(unsafe.Pointer(bp + 78 /* &buf[0] */ + uintptr(0))) = int8(0)
		if !((flags & 0x02) != 0) {
			reverse_services(tls, bp+78 /* &buf[0] */, port, (flags & 0x10))
		}
		if !(int32(*(*int8)(unsafe.Pointer(p))) != 0) {
			p = itoa(tls, bp+334 /* &num[0] */, uint32(port))
		}
		if Xstrlen(tls, p) >= servlen {
			return -12
		}
		Xstrcpy(tls, serv, p)
	}

	return 0
}

var Xh_errno int32 /* h_errno.c:4:5: */

func X__h_errno_location(tls *TLS) uintptr { /* h_errno.c:6:5: */
	return uintptr(unsafe.Pointer(&Xh_errno))
}

func X__inet_aton(tls *TLS, s0 uintptr, dest uintptr) int32 { /* inet_aton.c:7:5: */
	bp := tls.Alloc(20)
	defer tls.Free(20)

	var s uintptr = s0
	var d uintptr = dest
	*(*[4]uint32)(unsafe.Pointer(bp /* a */)) = [4]uint32{uint32(0)}
	// var z uintptr at bp+16, 4

	var i int32

	for i = 0; i < 4; i++ {
		*(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(i)*4)) = Xstrtoul(tls, s, bp+16 /* &z */, 0)
		if ((*(*uintptr)(unsafe.Pointer(bp + 16 /* z */)) == s) || ((*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 16 /* z */)))) != 0) && (int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 16 /* z */))))) != '.'))) || !(func() int32 {
			if 0 != 0 {
				return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(s))))
			}
			return (Bool32(((uint32(*(*int8)(unsafe.Pointer(s)))) - uint32('0')) < uint32(10)))
		}() != 0) {
			return 0
		}
		if !(int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 16 /* z */))))) != 0) {
			break
		}
		s = (*(*uintptr)(unsafe.Pointer(bp + 16 /* z */)) + uintptr(1))
	}
	if i == 4 {
		return 0
	}
	switch i {
	case 0:
		*(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(1)*4)) = (*(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(0)*4)) & uint32(0xffffff))
		AssignShrPtrUint32(bp /* &a */ +uintptr(0)*4, int(uint32(24)))
		fallthrough
	case 1:
		*(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(2)*4)) = (*(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(1)*4)) & uint32(0xffff))
		AssignShrPtrUint32(bp /* &a */ +uintptr(1)*4, int(uint32(16)))
		fallthrough
	case 2:
		*(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(3)*4)) = (*(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(2)*4)) & uint32(0xff))
		AssignShrPtrUint32(bp /* &a */ +uintptr(2)*4, int(uint32(8)))
	}
	for i = 0; i < 4; i++ {
		if *(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(i)*4)) > uint32(255) {
			return 0
		}
		*(*uint8)(unsafe.Pointer(d + uintptr(i))) = uint8(*(*uint32)(unsafe.Pointer(bp /* &a[0] */ + uintptr(i)*4)))
	}
	return 1
}

func Xinet_ntop(tls *TLS, af int32, a0 uintptr, s uintptr, l socklen_t) uintptr { /* inet_ntop.c:7:12: */
	bp := tls.Alloc(276)
	defer tls.Free(276)

	var a uintptr = a0
	var i int32
	var j int32
	var max int32
	var best int32
	// var buf [100]int8 at bp+176, 100

	switch af {
	case 2:
		if socklen_t(Xsnprintf(tls, s, l, ts+87 /* "%d.%d.%d.%d" */, VaList(bp, int32(*(*uint8)(unsafe.Pointer(a + uintptr(0)))), int32(*(*uint8)(unsafe.Pointer(a + uintptr(1)))), int32(*(*uint8)(unsafe.Pointer(a + uintptr(2)))), int32(*(*uint8)(unsafe.Pointer(a + uintptr(3))))))) < l {
			return s
		}
		break
	case 10:
		if Xmemcmp(tls, a, ts+74 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff" */, uint32(12)) != 0 {
			Xsnprintf(tls, bp+176 /* &buf[0] */, uint32(unsafe.Sizeof([100]int8{})),
				ts+99, /* "%x:%x:%x:%x:%x:%..." */
				VaList(bp+32, ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(0)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(1))))), ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(2)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(3))))),
					((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(4)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(5))))), ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(6)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(7))))),
					((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(8)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(9))))), ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(10)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(11))))),
					((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(12)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(13))))), ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(14)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(15)))))))
		} else {
			Xsnprintf(tls, bp+176 /* &buf[0] */, uint32(unsafe.Sizeof([100]int8{})),
				ts+123, /* "%x:%x:%x:%x:%x:%..." */
				VaList(bp+96, ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(0)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(1))))), ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(2)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(3))))),
					((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(4)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(5))))), ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(6)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(7))))),
					((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(8)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(9))))), ((256*int32(*(*uint8)(unsafe.Pointer(a + uintptr(10)))))+int32(*(*uint8)(unsafe.Pointer(a + uintptr(11))))),
					int32(*(*uint8)(unsafe.Pointer(a + uintptr(12)))), int32(*(*uint8)(unsafe.Pointer(a + uintptr(13)))), int32(*(*uint8)(unsafe.Pointer(a + uintptr(14)))), int32(*(*uint8)(unsafe.Pointer(a + uintptr(15))))))
		}
		// Replace longest /(^0|:)[:0]{2,}/ with "::"
		i = AssignInt32(&best, 0)
		max = 2
		for ; *(*int8)(unsafe.Pointer(bp + 176 /* &buf[0] */ + uintptr(i))) != 0; i++ {
			if (i != 0) && (int32(*(*int8)(unsafe.Pointer(bp + 176 /* &buf[0] */ + uintptr(i)))) != ':') {
				continue
			}
			j = int32(Xstrspn(tls, (bp + 176 /* &buf[0] */ + uintptr(i)), ts+153 /* ":0" */))
			if j > max {
				best = i
				max = j
			}
		}
		if max > 3 {
			*(*int8)(unsafe.Pointer(bp + 176 /* &buf[0] */ + uintptr(best))) = AssignPtrInt8(bp+176 /* &buf */ +uintptr((best+1)), int8(':'))
			Xmemmove(tls, ((bp + 176 /* &buf[0] */ + uintptr(best)) + uintptr(2)), ((bp + 176 /* &buf[0] */ + uintptr(best)) + uintptr(max)), (uint32(((i - best) - max) + 1)))
		}
		if Xstrlen(tls, bp+176 /* &buf[0] */) < l {
			Xstrcpy(tls, s, bp+176 /* &buf[0] */)
			return s
		}
		break
	default:
		(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = 97
		return uintptr(0)
	}
	(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = 28
	return uintptr(0)
}

func hexval(tls *TLS, c uint32) int32 { /* inet_pton.c:7:12: */
	if (c - uint32('0')) < uint32(10) {
		return (int32(c - uint32('0')))
	}
	c = c | (uint32(32))
	if (c - uint32('a')) < uint32(6) {
		return (int32((c - uint32('a')) + uint32(10)))
	}
	return -1
}

func Xinet_pton(tls *TLS, af int32, s uintptr, a0 uintptr) int32 { /* inet_pton.c:15:5: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	// var ip [8]uint16_t at bp, 16

	var a uintptr = a0
	var i int32
	var j int32
	var v int32
	var d int32
	var brk int32 = -1
	var need_v4 int32 = 0

	if af == 2 {
		for i = 0; i < 4; i++ {
			for v = AssignInt32(&j, 0); (j < 3) && (func() int32 {
				if 0 != 0 {
					return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))))
				}
				return (Bool32(((uint32(*(*int8)(unsafe.Pointer(s + uintptr(j))))) - uint32('0')) < uint32(10)))
			}() != 0); j++ {
				v = (((10 * v) + int32(*(*int8)(unsafe.Pointer(s + uintptr(j))))) - '0')
			}
			if ((j == 0) || ((j > 1) && (int32(*(*int8)(unsafe.Pointer(s + uintptr(0)))) == '0'))) || (v > 255) {
				return 0
			}
			*(*uint8)(unsafe.Pointer(a + uintptr(i))) = uint8(v)
			if (int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) == 0) && (i == 3) {
				return 1
			}
			if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != '.' {
				return 0
			}
			s += (uintptr(j + 1))
		}
		return 0
	} else if af != 10 {
		(*(*int32)(unsafe.Pointer(X___errno_location(tls)))) = 97
		return -1
	}

	if (int32(*(*int8)(unsafe.Pointer(s))) == ':') && (int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&s, 1)))) != ':') {
		return 0
	}

	for i = 0; ; i++ {
		if (int32(*(*int8)(unsafe.Pointer(s + uintptr(0)))) == ':') && (brk < 0) {
			brk = i
			*(*uint16_t)(unsafe.Pointer(bp /* &ip[0] */ + uintptr((i&7))*2)) = uint16_t(0)
			if !(int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&s, 1)))) != 0) {
				break
			}
			if i == 7 {
				return 0
			}
			continue
		}
		for v = AssignInt32(&j, 0); (j < 4) && ((AssignInt32(&d, hexval(tls, uint32(*(*int8)(unsafe.Pointer(s + uintptr(j))))))) >= 0); j++ {
			v = ((16 * v) + d)
		}
		if j == 0 {
			return 0
		}
		*(*uint16_t)(unsafe.Pointer(bp /* &ip[0] */ + uintptr((i&7))*2)) = uint16_t(v)
		if !(int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != 0) && ((brk >= 0) || (i == 7)) {
			break
		}
		if i == 7 {
			return 0
		}
		if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != ':' {
			if (int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != '.') || ((i < 6) && (brk < 0)) {
				return 0
			}
			need_v4 = 1
			i++
			break
		}
		s += (uintptr(j + 1))
	}
	if brk >= 0 {
		Xmemmove(tls, (((bp /* &ip[0] */ + uintptr(brk)*2) + uintptr(7)*2) - uintptr(i)*2), (bp /* &ip[0] */ + uintptr(brk)*2), (uint32(2 * ((i + 1) - brk))))
		for j = 0; j < (7 - i); j++ {
			*(*uint16_t)(unsafe.Pointer(bp /* &ip[0] */ + uintptr((brk+j))*2)) = uint16_t(0)
		}
	}
	for j = 0; j < 8; j++ {
		*(*uint8)(unsafe.Pointer(PostIncUintptr(&a, 1))) = (uint8(int32(*(*uint16_t)(unsafe.Pointer(bp /* &ip[0] */ + uintptr(j)*2))) >> 8))
		*(*uint8)(unsafe.Pointer(PostIncUintptr(&a, 1))) = uint8(*(*uint16_t)(unsafe.Pointer(bp /* &ip[0] */ + uintptr(j)*2)))
	}
	if (need_v4 != 0) && (Xinet_pton(tls, 2, s, (a-uintptr(4))) <= 0) {
		return 0
	}
	return 1
}

func X__lookup_ipliteral(tls *TLS, buf uintptr, name uintptr, family int32) int32 { /* lookup_ipliteral.c:12:5: */
	bp := tls.Alloc(88)
	defer tls.Free(88)

	// var a4 in_addr at bp, 4

	// var a6 in6_addr at bp+68, 16

	if X__inet_aton(tls, name, bp /* &a4 */) > 0 {
		if family == 10 { // wrong family
			return -2
		}
		Xmemcpy(tls, (buf + uintptr(0)*28 + 8 /* &.addr */), bp /* &a4 */, uint32(unsafe.Sizeof(in_addr{})))
		(*address)(unsafe.Pointer(buf + uintptr(0)*28)).family = 2
		(*address)(unsafe.Pointer(buf + uintptr(0)*28)).scopeid = uint32(0)
		return 1
	}
	// var tmp [64]int8 at bp+4, 64

	var p uintptr = Xstrchr(tls, name, '%')
	// var z uintptr at bp+84, 4

	var scopeid uint64 = uint64(0)
	if (p != 0) && (((int32(p) - int32(name)) / 1) < 64) {
		Xmemcpy(tls, bp+4 /* &tmp[0] */, name, (uint32((int32(p) - int32(name)) / 1)))
		*(*int8)(unsafe.Pointer(bp + 4 /* &tmp[0] */ + uintptr(((int32(p) - int32(name)) / 1)))) = int8(0)
		name = bp + 4 /* &tmp[0] */
	}

	if Xinet_pton(tls, 10, name, bp+68 /* &a6 */) <= 0 {
		return 0
	}
	if family == 2 { // wrong family
		return -2
	}

	Xmemcpy(tls, (buf + uintptr(0)*28 + 8 /* &.addr */), bp+68 /* &a6 */, uint32(unsafe.Sizeof(in6_addr{})))
	(*address)(unsafe.Pointer(buf + uintptr(0)*28)).family = 10
	if p != 0 {
		if func() int32 {
			if 0 != 0 {
				return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&p, 1)))))
			}
			return (Bool32(((uint32(*(*int8)(unsafe.Pointer(PreIncUintptr(&p, 1))))) - uint32('0')) < uint32(10)))
		}() != 0 {
			scopeid = Xstrtoull(tls, p, bp+84 /* &z */, 10)
		} else {
			*(*uintptr)(unsafe.Pointer(bp + 84 /* z */)) = (p - uintptr(1))
		}
		if *(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 84 /* z */)))) != 0 {
			Xabort(tls)
		}
		if scopeid > uint64(0xffffffff) {
			return -2
		}
	}
	(*address)(unsafe.Pointer(buf + uintptr(0)*28)).scopeid = uint32(scopeid)
	return 1
}

func __isspace8(tls *TLS, _c int32) int32 { /* ctype.h:26:21: */
	return (Bool32((_c == ' ') || ((uint32(_c) - uint32('\t')) < uint32(5))))
}

func is_valid_hostname(tls *TLS, host uintptr) int32 { /* lookup_name.c:18:12: */
	var s uintptr
	//TODO if (strnlen(host, 255)-1 >= 254 || mbstowcs(0, host, 0) == -1) return 0;
	if (Xstrnlen(tls, host, uint32(255)) - size_t(1)) >= size_t(254) {
		return 0
	}
	for s = host; (((int32(*(*uint8)(unsafe.Pointer(s))) >= 0x80) || (int32(*(*uint8)(unsafe.Pointer(s))) == '.')) || (int32(*(*uint8)(unsafe.Pointer(s))) == '-')) || (Xisalnum(tls, int32(*(*uint8)(unsafe.Pointer(s)))) != 0); s++ {
	}
	return BoolInt32(!(*(*uint8)(unsafe.Pointer(s)) != 0))
}

var Xzero_struct_address address /* lookup_name.c:27:16: */

func name_from_null(tls *TLS, buf uintptr, name uintptr, family int32, flags int32) int32 { /* lookup_name.c:29:12: */
	var cnt int32 = 0
	if name != 0 {
		return 0
	}
	if (flags & 0x01) != 0 {
		//TODO if (family != AF_INET6)
		//TODO 	buf[cnt++] = (struct address){ .family = AF_INET };
		if family != 10 {
			var x = Xzero_struct_address
			x.family = 2
			*(*address)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*28)) = x
		}
		//TODO if (family != AF_INET)
		//TODO 	buf[cnt++] = (struct address){ .family = AF_INET6 };
		if family != 2 {
			var x = Xzero_struct_address
			x.family = 10
			*(*address)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*28)) = x
		}
	} else {
		Xabort(tls)
	}
	return cnt
}

func name_from_numeric(tls *TLS, buf uintptr, name uintptr, family int32) int32 { /* lookup_name.c:58:12: */
	return X__lookup_ipliteral(tls, buf, name, family)
}

func name_from_hosts(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32) int32 { /* lookup_name.c:63:12: */
	bp := tls.Alloc(512)
	defer tls.Free(512)

	// var line [512]int8 at bp, 512

	var l size_t = Xstrlen(tls, name)
	var cnt int32 = 0
	var badfam int32 = 0
	var _buf [1032]uint8
	_ = _buf
	//TODO FILE _f, *f = __fopen_rb_ca("/etc/hosts", &_f, _buf, sizeof _buf);
	var _f FILE
	_ = _f
	var f uintptr = Xfopen(tls, ts+60 /* "/etc/hosts" */, ts+71 /* "rb" */)
	if !(f != 0) {
		switch *(*int32)(unsafe.Pointer(X___errno_location(tls))) {
		case 2:
			fallthrough
		case 20:
			fallthrough
		case 13:
			return 0
			fallthrough
		default:
			return -11
		}
	}
	for (Xfgets(tls, bp /* &line[0] */, int32(unsafe.Sizeof([512]int8{})), f) != 0) && (cnt < 48) {
		var p uintptr
		var z uintptr

		if AssignUintptr(&p, Xstrchr(tls, bp /* &line[0] */, '#')) != 0 {
			*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8('\n')
			*(*int8)(unsafe.Pointer(p)) = int8(0)
		}
		for p = (bp /* &line[0] */ + uintptr(1)); (AssignUintptr(&p, Xstrstr(tls, p, name)) != 0) && (!(__isspace8(tls, int32(*(*int8)(unsafe.Pointer(p + UintptrFromInt32(-1))))) != 0) || !(__isspace8(tls, int32(*(*int8)(unsafe.Pointer(p + uintptr(l))))) != 0)); p++ {
		}
		if !(p != 0) {
			continue
		}

		// Isolate IP address to parse
		for p = bp; /* &line[0] */ (*(*int8)(unsafe.Pointer(p)) != 0) && !(__isspace8(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0); p++ {
		}
		*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8(0)
		switch name_from_numeric(tls, (buf + uintptr(cnt)*28), bp /* &line[0] */, family) {
		case 1:
			cnt++
			break
		case 0:
			continue
		default:
			badfam = -2
			continue
		}

		// Extract first name as canonical name
		for ; (*(*int8)(unsafe.Pointer(p)) != 0) && (__isspace8(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0); p++ {
		}
		for z = p; (*(*int8)(unsafe.Pointer(z)) != 0) && !(__isspace8(tls, int32(*(*int8)(unsafe.Pointer(z)))) != 0); z++ {
		}
		*(*int8)(unsafe.Pointer(z)) = int8(0)
		if is_valid_hostname(tls, p) != 0 {
			Xmemcpy(tls, canon, p, (uint32(((int32(z) - int32(p)) / 1) + 1)))
		}
	}
	//TODO __fclose_ca(f);
	Xfclose(tls, f)
	if cnt != 0 {
		return cnt
	}
	return badfam
}

type dpc_ctx = struct {
	addrs uintptr
	canon uintptr
	cnt   int32
} /* lookup_name.c:112:1 */

func dns_parse_callback1(tls *TLS, c uintptr, rr int32, data uintptr, len int32, packet uintptr) int32 { /* lookup_name.c:122:12: */
	Xabort(tls)
	return int32(0) //TODO-
	// char tmp[256];
	// struct dpc_ctx *ctx = c;
	// if (ctx->cnt >= MAXADDRS) return -1;
	// switch (rr) {
	// case RR_A:
	// 	if (len != 4) return -1;
	// 	ctx->addrs[ctx->cnt].family = AF_INET;
	// 	ctx->addrs[ctx->cnt].scopeid = 0;
	// 	memcpy(ctx->addrs[ctx->cnt++].addr, data, 4);
	// 	break;
	// case RR_AAAA:
	// 	if (len != 16) return -1;
	// 	ctx->addrs[ctx->cnt].family = AF_INET6;
	// 	ctx->addrs[ctx->cnt].scopeid = 0;
	// 	memcpy(ctx->addrs[ctx->cnt++].addr, data, 16);
	// 	break;
	// case RR_CNAME:
	// 	if (__dn_expand(packet, (const unsigned char *)packet + 512,
	// 	    data, tmp, sizeof tmp) > 0 && is_valid_hostname(tmp))
	// 		strcpy(ctx->canon, tmp);
	// 	break;
	// }
	// return 0;
}

func name_from_dns(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32, conf uintptr) int32 { /* lookup_name.c:150:12: */
	Xabort(tls)
	return int32(0) //TODO-
	// unsigned char qbuf[2][280], abuf[2][512];
	// const unsigned char *qp[2] = { qbuf[0], qbuf[1] };
	// unsigned char *ap[2] = { abuf[0], abuf[1] };
	// int qlens[2], alens[2];
	// int i, nq = 0;
	// struct dpc_ctx ctx = { .addrs = buf, .canon = canon };
	// static const struct { int af; int rr; } afrr[2] = {
	// 	{ .af = AF_INET6, .rr = RR_A },
	// 	{ .af = AF_INET, .rr = RR_AAAA },
	// };

	// for (i=0; i<2; i++) {
	// 	if (family != afrr[i].af) {
	// 		qlens[nq] = __res_mkquery(0, name, 1, afrr[i].rr,
	// 			0, 0, 0, qbuf[nq], sizeof *qbuf);
	// 		if (qlens[nq] == -1)
	// 			return EAI_NONAME;
	// 		qbuf[nq][3] = 0; /* don't need AD flag */
	// 		nq++;
	// 	}
	// }

	// if (__res_msend_rc(nq, qp, qlens, ap, alens, sizeof *abuf, conf) < 0)
	// 	return EAI_SYSTEM;

	// for (i=0; i<nq; i++) {
	// 	if (alens[i] < 4 || (abuf[i][3] & 15) == 2) return EAI_AGAIN;
	// 	if ((abuf[i][3] & 15) == 3) return 0;
	// 	if ((abuf[i][3] & 15) != 0) return EAI_FAIL;
	// }

	// for (i=0; i<nq; i++)
	// 	__dns_parse(abuf[i], alens[i], dns_parse_callback, &ctx);

	// if (ctx.cnt) return ctx.cnt;
	// return EAI_NONAME;
}

func name_from_dns_search(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32) int32 { /* lookup_name.c:191:12: */
	return -1 //TODO-
	Xabort(tls)
	return int32(0) //TODO-
	// char search[256];
	// struct resolvconf conf;
	// size_t l, dots;
	// char *p, *z;

	// if (__get_resolv_conf(&conf, search, sizeof search) < 0) return -1;

	// /* Count dots, suppress search when >=ndots or name ends in
	//  * a dot, which is an explicit request for global scope. */
	// for (dots=l=0; name[l]; l++) if (name[l]=='.') dots++;
	// if (dots >= conf.ndots || name[l-1]=='.') *search = 0;

	// /* Strip final dot for canon, fail if multiple trailing dots. */
	// if (name[l-1]=='.') l--;
	// if (!l || name[l-1]=='.') return EAI_NONAME;

	// /* This can never happen; the caller already checked length. */
	// if (l >= 256) return EAI_NONAME;

	// /* Name with search domain appended is setup in canon[]. This both
	//  * provides the desired default canonical name (if the requested
	//  * name is not a CNAME record) and serves as a buffer for passing
	//  * the full requested name to name_from_dns. */
	// memcpy(canon, name, l);
	// canon[l] = '.';

	// for (p=search; *p; p=z) {
	// 	for (; isspace(*p); p++);
	// 	for (z=p; *z && !isspace(*z); z++);
	// 	if (z==p) break;
	// 	if (z-p < 256 - l - 1) {
	// 		memcpy(canon+l+1, p, z-p);
	// 		canon[z-p+1+l] = 0;
	// 		int cnt = name_from_dns(buf, canon, canon, family, &conf);
	// 		if (cnt) return cnt;
	// 	}
	// }

	// canon[l] = 0;
	// return name_from_dns(buf, canon, name, family, &conf);
}

type policy = struct {
	addr  [16]uint8
	len   uint8
	mask  uint8
	prec  uint8
	label uint8
} /* lookup_name.c:237:14 */

var defpolicy = [6]policy{
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 156 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01" */)), len: uint8(15), mask: uint8(0xff), prec: uint8(50), label: uint8(0)},
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 173 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00" */)), len: uint8(11), mask: uint8(0xff), prec: uint8(35), label: uint8(4)},
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 189 /* " \x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" */)), len: uint8(1), mask: uint8(0xff), prec: uint8(30), label: uint8(2)},
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 205 /* " \x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" */)), len: uint8(3), mask: uint8(0xff), prec: uint8(5), label: uint8(5)},
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 221 /* "\xfc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" */)), len: uint8(0), mask: uint8(0xfe), prec: uint8(3), label: uint8(13)},
	// Last rule must match all addresses to stop loop.
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 237 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" */)), len: uint8(0), mask: uint8(0), prec: uint8(40), label: uint8(1)},
} /* lookup_name.c:241:3 */

func policyof(tls *TLS, a uintptr) uintptr { /* lookup_name.c:259:28: */
	var i int32
	for i = 0; ; i++ {
		if Xmemcmp(tls, a /* &.__in6_union */ /* &.__s6_addr */, uintptr(unsafe.Pointer(&defpolicy))+uintptr(i)*20 /* &.addr */, uint32(defpolicy[i].len)) != 0 {
			continue
		}
		if (int32(*(*uint8_t)(unsafe.Pointer((a /* &.__in6_union */ /* &.__s6_addr */) + uintptr(defpolicy[i].len)))) & int32(defpolicy[i].mask)) !=
			int32(*(*uint8)(unsafe.Pointer((uintptr(unsafe.Pointer(&defpolicy)) + uintptr(i)*20 /* &.addr */) + uintptr(defpolicy[i].len)))) {
			continue
		}
		return (uintptr(unsafe.Pointer(&defpolicy)) + uintptr(i)*20)
	}
	return uintptr(0)
}

func labelof(tls *TLS, a uintptr) int32 { /* lookup_name.c:272:12: */
	return int32((*policy)(unsafe.Pointer(policyof(tls, a))).label)
}

func scopeof(tls *TLS, a uintptr) int32 { /* lookup_name.c:277:12: */
	if int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(0)))) == 0xff {
		return (int32(*(*uint8_t)(unsafe.Pointer((a /* &.__in6_union */ /* &.__s6_addr */) + uintptr(1)))) & 15)
	}
	if ((int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(0))))) == 0xfe) && ((int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(1)))) & 0xc0) == 0x80) {
		return 2
	}
	if ((((((*(*uint32_t)(unsafe.Pointer((a) + uintptr(0)*4)) == uint32_t(0)) && (*(*uint32_t)(unsafe.Pointer((a) + uintptr(1)*4)) == uint32_t(0))) && (*(*uint32_t)(unsafe.Pointer((a) + uintptr(2)*4)) == uint32_t(0))) && (int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(12)))) == 0)) && (int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(13)))) == 0)) && (int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(14)))) == 0)) && (int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(15)))) == 1) {
		return 2
	}
	if ((int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(0))))) == 0xfe) && ((int32(*(*uint8_t)(unsafe.Pointer((a) + uintptr(1)))) & 0xc0) == 0xc0) {
		return 5
	}
	return 14
}

func prefixmatch(tls *TLS, s uintptr, d uintptr) int32 { /* lookup_name.c:286:12: */
	// FIXME: The common prefix length should be limited to no greater
	// than the nominal length of the prefix portion of the source
	// address. However the definition of the source prefix length is
	// not clear and thus this limiting is not yet implemented.
	var i uint32
	for i = uint32(0); (i < uint32(128)) && !(((int32(*(*uint8_t)(unsafe.Pointer((s /* &.__in6_union */ /* &.__s6_addr */) + uintptr((i / uint32(8)))))) ^ int32(*(*uint8_t)(unsafe.Pointer((d /* &.__in6_union */ /* &.__s6_addr */) + uintptr((i / uint32(8))))))) & (int32(128) >> (i % uint32(8)))) != 0); i++ {
	}
	return int32(i)
}

func addrcmp(tls *TLS, _a uintptr, _b uintptr) int32 { /* lookup_name.c:305:12: */
	var a uintptr = _a
	var b uintptr = _b
	return ((*address)(unsafe.Pointer(b)).sortkey - (*address)(unsafe.Pointer(a)).sortkey)
}

func X__lookup_name(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32, flags int32) int32 { /* lookup_name.c:311:5: */
	bp := tls.Alloc(92)
	defer tls.Free(92)

	var cnt int32 = 0
	var i int32
	var j int32
	_ = j

	*(*int8)(unsafe.Pointer(canon)) = int8(0)
	if name != 0 {
		// reject empty name and check len so it fits into temp bufs
		var l size_t = Xstrnlen(tls, name, uint32(255))
		if (l - size_t(1)) >= size_t(254) {
			return -2
		}
		Xmemcpy(tls, canon, name, (l + size_t(1)))
	}

	// Procedurally, a request for v6 addresses with the v4-mapped
	// flag set is like a request for unspecified family, followed
	// by filtering of the results.
	if (flags & 0x08) != 0 {
		if family == 10 {
			family = 0
		} else {
			flags = flags - (0x08)
		}
	}

	// Try each backend until there's at least one result.
	cnt = name_from_null(tls, buf, name, family, flags)
	if !(cnt != 0) {
		cnt = name_from_numeric(tls, buf, name, family)
	}
	if !(cnt != 0) && !((flags & 0x04) != 0) {
		cnt = name_from_hosts(tls, buf, canon, name, family)
		if !(cnt != 0) {
			cnt = name_from_dns_search(tls, buf, canon, name, family)
		}
	}
	if cnt <= 0 {
		if cnt != 0 {
			return cnt
		}
		return -2
	}

	// Filter/transform results for v4-mapped lookup, if requested.
	if (flags & 0x08) != 0 {
		Xabort(tls)
	}

	// No further processing is needed if there are fewer than 2
	// results or if there are only IPv4 results.
	if (cnt < 2) || (family == 2) {
		return cnt
	}
	for i = 0; i < cnt; i++ {
		if (*address)(unsafe.Pointer(buf+uintptr(i)*28)).family != 2 {
			break
		}
	}
	if i == cnt {
		return cnt
	}
	var cs int32
	_ = cs
	//TODO pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, &cs);

	// The following implements a subset of RFC 3484/6724 destination
	// address selection by generating a single 31-bit sort key for
	// each address. Rules 3, 4, and 7 are omitted for having
	// excessive runtime and code size cost and dubious benefit.
	// So far the label/precedence table cannot be customized.
	for i = 0; i < cnt; i++ {
		var family int32 = (*address)(unsafe.Pointer(buf + uintptr(i)*28)).family
		var key int32 = 0
		*(*sockaddr_in6)(unsafe.Pointer(bp + 28 /* sa6 */)) = sockaddr_in6{sin6_family: sa_family_t(0)}
		*(*sockaddr_in6)(unsafe.Pointer(bp /* da6 */)) = sockaddr_in6{sin6_family: sa_family_t(10), sin6_scope_id: (*address)(unsafe.Pointer(buf + uintptr(i)*28)).scopeid, sin6_port: in_port_t(65535)}
		*(*sockaddr_in)(unsafe.Pointer(bp + 72 /* sa4 */)) = sockaddr_in{sin_family: sa_family_t(0)}
		*(*sockaddr_in)(unsafe.Pointer(bp + 56 /* da4 */)) = sockaddr_in{sin_family: sa_family_t(2), sin_port: in_port_t(65535)}
		var sa1 uintptr
		var da uintptr
		// var salen socklen_t at bp+88, 4

		var dalen socklen_t
		if family == 10 {
			Xmemcpy(tls, bp /* &da6 */ +8 /* &.sin6_addr */ /* &.__in6_union */ /* &.__s6_addr */, buf+uintptr(i)*28+8 /* &.addr */, uint32(16))
			da = bp /* &da6 */
			dalen = socklen_t(unsafe.Sizeof(sockaddr_in6{}))
			sa1 = bp + 28 /* &sa6 */
			*(*socklen_t)(unsafe.Pointer(bp + 88 /* salen */)) = socklen_t(unsafe.Sizeof(sockaddr_in6{}))
		} else {
			Xmemcpy(tls, bp+28 /* &sa6 */ +8, /* &.sin6_addr */ /* &.__in6_union */ /* &.__s6_addr */
				ts+74 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff" */, uint32(12))
			Xmemcpy(tls, ((bp /* &da6 */ + 8 /* &.sin6_addr */ /* &.__in6_union */ /* &.__s6_addr */) + uintptr(12)), buf+uintptr(i)*28+8 /* &.addr */, uint32(4))
			Xmemcpy(tls, bp /* &da6 */ +8, /* &.sin6_addr */ /* &.__in6_union */ /* &.__s6_addr */
				ts+74 /* "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff" */, uint32(12))
			Xmemcpy(tls, ((bp /* &da6 */ + 8 /* &.sin6_addr */ /* &.__in6_union */ /* &.__s6_addr */) + uintptr(12)), buf+uintptr(i)*28+8 /* &.addr */, uint32(4))
			Xmemcpy(tls, (bp + 56 /* &da4 */ + 4 /* &.sin_addr */), buf+uintptr(i)*28+8 /* &.addr */, uint32(4))
			da = bp + 56 /* &da4 */
			dalen = socklen_t(unsafe.Sizeof(sockaddr_in{}))
			sa1 = bp + 72 /* &sa4 */
			*(*socklen_t)(unsafe.Pointer(bp + 88 /* salen */)) = socklen_t(unsafe.Sizeof(sockaddr_in{}))
		}
		var dpolicy uintptr = policyof(tls, (bp /* &da6 */ + 8 /* &.sin6_addr */))
		var dscope int32 = scopeof(tls, (bp /* &da6 */ + 8 /* &.sin6_addr */))
		var dlabel int32 = int32((*policy)(unsafe.Pointer(dpolicy)).label)
		var dprec int32 = int32((*policy)(unsafe.Pointer(dpolicy)).prec)
		var prefixlen int32 = 0
		var fd int32 = Xsocket(tls, family, (2 | 02000000), 17)
		if fd >= 0 {
			if !(Xconnect(tls, fd, da, dalen) != 0) {
				key = key | (0x40000000)
				if !(Xgetsockname(tls, fd, sa1, bp+88 /* &salen */) != 0) {
					if family == 2 {
						Xmemcpy(tls,
							((bp + 28 /* &sa6 */ + 8 /* &.sin6_addr */ /* &.__in6_union */ /* &.__s6_addr */) + uintptr(12)),
							(bp + 72 /* &sa4 */ + 4 /* &.sin_addr */), uint32(4))
					}
					if dscope == scopeof(tls, (bp+28 /* &sa6 */ +8 /* &.sin6_addr */)) {
						key = key | (0x20000000)
					}
					if dlabel == labelof(tls, (bp+28 /* &sa6 */ +8 /* &.sin6_addr */)) {
						key = key | (0x10000000)
					}
					prefixlen = prefixmatch(tls, (bp + 28 /* &sa6 */ + 8 /* &.sin6_addr */),
						(bp /* &da6 */ + 8 /* &.sin6_addr */))
				}
			}
			Xclose(tls, fd)
		}
		key = key | (dprec << 20)
		key = key | ((15 - dscope) << 16)
		key = key | (prefixlen << 8)
		key = key | ((48 - i) << 0)
		(*address)(unsafe.Pointer(buf + uintptr(i)*28)).sortkey = key
	}
	Xqsort(tls, buf, uint32(cnt), uint32(unsafe.Sizeof(address{})), *(*uintptr)(unsafe.Pointer(&struct {
		f func(*TLS, uintptr, uintptr) int32
	}{addrcmp})))

	//TODO pthread_setcancelstate(cs, 0);

	return cnt
}

func X__lookup_serv(tls *TLS, buf uintptr, name uintptr, proto int32, socktype int32, flags int32) int32 { /* lookup_serv.c:12:5: */
	bp := tls.Alloc(4)
	defer tls.Free(4)

	var line [128]int8
	_ = line
	var cnt int32 = 0
	var p uintptr
	_ = p
	*(*uintptr)(unsafe.Pointer(bp /* z */)) = ts + 253 /* "" */
	var port uint32 = uint32(0)

	switch socktype {
	case 1:
		switch proto {
		case 0:
			proto = 6
			fallthrough
		case 6:
			break
		default:
			return -8
		}
		break
	case 2:
		switch proto {
		case 0:
			proto = 17
			fallthrough
		case 17:
			break
		default:
			return -8
		}
		fallthrough
	case 0:
		break
	default:
		if name != 0 {
			return -8
		}
		(*service)(unsafe.Pointer(buf + uintptr(0)*4)).port = uint16_t(0)
		(*service)(unsafe.Pointer(buf + uintptr(0)*4)).proto = uint8(proto)
		(*service)(unsafe.Pointer(buf + uintptr(0)*4)).socktype = uint8(socktype)
		return 1
	}

	if name != 0 {
		if !(int32(*(*int8)(unsafe.Pointer(name))) != 0) {
			return -8
		}
		port = Xstrtoul(tls, name, bp /* &z */, 10)
	}
	if !(int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp /* z */))))) != 0) {
		if port > uint32(65535) {
			return -8
		}
		if proto != 17 {
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).port = uint16_t(port)
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).socktype = uint8(1)
			(*service)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*4)).proto = uint8(6)
		}
		if proto != 6 {
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).port = uint16_t(port)
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).socktype = uint8(2)
			(*service)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*4)).proto = uint8(17)
		}
		return cnt
	}

	if (flags & 0x400) != 0 {
		return -2
	}

	var l size_t = Xstrlen(tls, name)
	_ = l

	Xabort(tls) //TODO-
	// unsigned char _buf[1032];
	// FILE _f, *f = __fopen_rb_ca("/etc/services", &_f, _buf, sizeof _buf);
	// if (!f) switch (errno) {
	// case ENOENT:
	// case ENOTDIR:
	// case EACCES:
	// 	return EAI_SERVICE;
	// default:
	// 	return EAI_SYSTEM;
	// }

	Xabort(tls) //TODO-
	// while (fgets(line, sizeof line, f) && cnt < MAXSERVS) {
	// 	if ((p=strchr(line, '#'))) *p++='\n', *p=0;

	// 	/* Find service name */
	// 	for(p=line; (p=strstr(p, name)); p++) {
	// 		if (p>line && !isspace(p[-1])) continue;
	// 		if (p[l] && !isspace(p[l])) continue;
	// 		break;
	// 	}
	// 	if (!p) continue;

	// 	/* Skip past canonical name at beginning of line */
	// 	for (p=line; *p && !isspace(*p); p++);

	// 	port = strtoul(p, &z, 10);
	// 	if (port > 65535 || z==p) continue;
	// 	if (!strncmp(z, "/udp", 4)) {
	// 		if (proto == IPPROTO_TCP) continue;
	// 		buf[cnt].port = port;
	// 		buf[cnt].socktype = SOCK_DGRAM;
	// 		buf[cnt++].proto = IPPROTO_UDP;
	// 	}
	// 	if (!strncmp(z, "/tcp", 4)) {
	// 		if (proto == IPPROTO_UDP) continue;
	// 		buf[cnt].port = port;
	// 		buf[cnt].socktype = SOCK_STREAM;
	// 		buf[cnt++].proto = IPPROTO_TCP;
	// 	}
	// }
	// __fclose_ca(f);
	// return cnt > 0 ? cnt : EAI_SERVICE;
	Xabort(tls)
	return int32(0) //TODO-
}

func X__toread(tls *TLS, f uintptr) int32 { /* __toread.c:3:5: */
	*(*int32)(unsafe.Pointer(f + 72 /* &.mode */)) |= ((*FILE)(unsafe.Pointer(f)).mode - 1)
	if (*FILE)(unsafe.Pointer(f)).wpos != (*FILE)(unsafe.Pointer(f)).wbase {
		(*(*func(*TLS, uintptr, uintptr, size_t) size_t)(unsafe.Pointer((f + 36 /* &.write */))))(tls, f, uintptr(0), uint32(0))
	}
	(*FILE)(unsafe.Pointer(f)).wpos = AssignPtrUintptr(f+28 /* &.wbase */, AssignPtrUintptr(f+16 /* &.wend */, uintptr(0)))
	if ((*FILE)(unsafe.Pointer(f)).flags & uint32(4)) != 0 {
		*(*uint32)(unsafe.Pointer(f /* &.flags */)) |= (uint32(32))
		return -1
	}
	(*FILE)(unsafe.Pointer(f)).rpos = AssignPtrUintptr(f+8 /* &.rend */, ((*FILE)(unsafe.Pointer(f)).buf + uintptr((*FILE)(unsafe.Pointer(f)).buf_size)))
	if ((*FILE)(unsafe.Pointer(f)).flags & uint32(16)) != 0 {
		return -1
	}
	return 0
}

func X__toread_needs_stdio_exit(tls *TLS) { /* __toread.c:16:13: */
	X__builtin_abort(tls) //TODO-
	// __stdio_exit_needed();
}

// This function assumes it will never be called if there is already
// data buffered for reading.

func X__uflow(tls *TLS, f uintptr) int32 { /* __uflow.c:6:5: */
	bp := tls.Alloc(1)
	defer tls.Free(1)

	// var c uint8 at bp, 1

	if !(X__toread(tls, f) != 0) && ((*(*func(*TLS, uintptr, uintptr, size_t) size_t)(unsafe.Pointer((f + 32 /* &.read */))))(tls, f, bp /* &c */, uint32(1)) == size_t(1)) {
		return int32(*(*uint8)(unsafe.Pointer(bp /* c */)))
	}
	return -1
}

func strtox(tls *TLS, s uintptr, p uintptr, base int32, lim uint64) uint64 { /* strtol.c:8:27: */
	bp := tls.Alloc(136)
	defer tls.Free(136)

	// var f FILE at bp, 136

	(*FILE)(unsafe.Pointer(bp /* &f */)).buf = AssignPtrUintptr(bp /* &f */ +4 /* &.rpos */, s)
	(*FILE)(unsafe.Pointer(bp /* &f */)).rend = UintptrFromInt32(-1)
	X__shlim(tls, bp /* &f */, int64(0))
	var y uint64 = X__intscan(tls, bp /* &f */, uint32(base), 1, lim)
	if p != 0 {
		var cnt size_t = (size_t((*FILE)(unsafe.Pointer((bp /* &f */))).shcnt + (off_t((int32((*FILE)(unsafe.Pointer((bp /* &f */))).rpos) - int32((*FILE)(unsafe.Pointer((bp /* &f */))).buf)) / 1))))
		*(*uintptr)(unsafe.Pointer(p)) = (s + uintptr(cnt))
	}
	return y
}

func Xstrtoull(tls *TLS, s uintptr, p uintptr, base int32) uint64 { /* strtol.c:21:20: */
	return strtox(tls, s, p, base, ((2 * uint64(0x7fffffffffffffff)) + uint64(1)))
}

func Xstrtoll(tls *TLS, s uintptr, p uintptr, base int32) int64 { /* strtol.c:26:11: */
	return int64(strtox(tls, s, p, base, (Uint64FromInt64(-0x7fffffffffffffff - int64(1)))))
}

func Xstrtoul(tls *TLS, s uintptr, p uintptr, base int32) uint32 { /* strtol.c:31:15: */
	return uint32(strtox(tls, s, p, base, (uint64((2 * uint32(0x7fffffff)) + uint32(1)))))
}

func Xstrtol(tls *TLS, s uintptr, p uintptr, base int32) int32 { /* strtol.c:36:6: */
	return int32(strtox(tls, s, p, base, (uint64(0 + (Uint32FromInt32(Int32(-Int32(0x7fffffff)) - Int32FromInt32(1)))))))
}

func Xstrtoimax(tls *TLS, s uintptr, p uintptr, base int32) intmax_t { /* strtol.c:41:10: */
	return Xstrtoll(tls, s, p, base)
}

func Xstrtoumax(tls *TLS, s uintptr, p uintptr, base int32) uintmax_t { /* strtol.c:46:11: */
	return Xstrtoull(tls, s, p, base)
}

func Xstrnlen(tls *TLS, s uintptr, n size_t) size_t { /* strnlen.c:3:8: */
	var p uintptr = Xmemchr(tls, s, 0, n)
	if p != 0 {
		return (uint32((int32(p) - int32(s)) / 1))
	}
	return n
}

func Xstrspn(tls *TLS, s uintptr, c uintptr) size_t { /* strspn.c:6:8: */
	bp := tls.Alloc(32)
	defer tls.Free(32)

	var a uintptr = s
	*(*[8]size_t)(unsafe.Pointer(bp /* byteset */)) = [8]size_t{size_t(0)}

	if !(int32(*(*int8)(unsafe.Pointer(c + uintptr(0)))) != 0) {
		return size_t(0)
	}
	if !(int32(*(*int8)(unsafe.Pointer(c + uintptr(1)))) != 0) {
		for ; int32(*(*int8)(unsafe.Pointer(s))) == int32(*(*int8)(unsafe.Pointer(c))); s++ {
		}
		return (size_t((int32(s) - int32(a)) / 1))
	}

	for ; (*(*int8)(unsafe.Pointer(c)) != 0) && (AssignOrPtrUint32(bp /* &byteset */ +uintptr(((size_t(*(*uint8)(unsafe.Pointer(c))))/(uint32(8)*uint32(unsafe.Sizeof(size_t(0))))))*4, (size_t(size_t(1))<<((size_t(*(*uint8)(unsafe.Pointer(c))))%(uint32(8)*uint32(unsafe.Sizeof(size_t(0))))))) != 0); c++ {
	}
	for ; (*(*int8)(unsafe.Pointer(s)) != 0) && ((*(*size_t)(unsafe.Pointer(bp /* &byteset[0] */ + uintptr(((size_t(*(*uint8)(unsafe.Pointer(s))))/(uint32(8)*uint32(unsafe.Sizeof(size_t(0))))))*4)) & (size_t(size_t(1)) << ((size_t(*(*uint8)(unsafe.Pointer(s)))) % (uint32(8) * uint32(unsafe.Sizeof(size_t(0))))))) != 0); s++ {
	}
	return (size_t((int32(s) - int32(a)) / 1))
}

var ts1 = "\x00\x01\x02\x04\a\x03\x06\x05\x00%d.%d.%d.%d.in-addr.arpa\x00ip6.arpa\x000123456789abcdef\x00/etc/hosts\x00rb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00%d.%d.%d.%d\x00%x:%x:%x:%x:%x:%x:%x:%x\x00%x:%x:%x:%x:%x:%x:%d.%d.%d.%d\x00:0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00 \x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
