import { FC, PropsWithChildren } from "react"
import { TIconSizes, TzIndex } from "./src/theme/conventions"

declare global {
  type FCC<P> = FC<PropsWithChildren<P>>
  type Modify<T, R> = Omit<T, keyof R> & R
  type Full<T> = {
    [P in keyof T]-?: T[P]
  }
  interface Number {
    fixDecimals(amountOfDecimals: number): number

    roundToInteger()
  }
}

export {}

declare module "@mantine/core" {
  export interface MantineThemeOther {
    iconSizes: TIconSizes
    zIndexLayers: TzIndex
  }

  export type MantineSizes = {
    xxs: string
    xs: string
    sm: string
    md: string
    lg: string
    xl: string
  }
}
