function _define_property(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _object_spread(target){for(var i=1;i<arguments.length;i++){var source=arguments[i]!=null?arguments[i]:{};var ownKeys=Object.keys(source);if(typeof Object.getOwnPropertySymbols==="function"){ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable}))}ownKeys.forEach(function(key){_define_property(target,key,source[key])})}return target}import{TFilter}from"./types";import{buildDefaultDTOValueTransformMap,transformValueBasedOnControlType}from"./transformHelpers";const EControlType=TFilter.EControlType;export const termMachine=term=>{const termState=_object_spread({},term);const setActive=()=>{termState.active=true;return termMachine(termState)};const setInactive=()=>{termState.active=false;return termMachine(termState)};const setComplete=()=>{termState.completed=true;return termMachine(termState)};const setIncomplete=()=>{termState.completed=false;return termMachine(termState)};const setAttribute=attribute=>{termState.attribute=attribute;return termMachine(termState)};const setSelectedCascadeValue=values=>{termState.selectedCascadeValues=values;return termMachine(termState)};const setAttributeValues=value=>{if(termState.attribute)termState.attribute.values=value;return termMachine(termState)};const setOperator=operator=>{termState.operator=operator;return termMachine(termState)};const setValue=value=>{termState.value=value;return termMachine(termState)};const build=()=>termState;return{build,setIncomplete,setComplete,setActive,setInactive,setAttribute,setSelectedCascadeValue,setAttributeValues,setOperator,setValue}};export const termsMachine=terms=>{const termsState=[...terms];const setAllInactive=()=>{const newTerms=[...termsState].map(term=>termMachine(term).setInactive().build());return termsMachine(newTerms)};const removeAllIncompleted=()=>{const newTerms=[...termsState].filter(term=>term.completed);return termsMachine(newTerms)};const removeSpecificTerm=id=>{const newTerms=[...termsState].filter(term=>term.id!==id);return termsMachine(newTerms)};const getSpecificTerm=id=>{return termsState.find(term=>term.id===id)};const getSpecificTermIndex=id=>{return termsState.findIndex(t=>t.id===id)};const updateSpecificTerm=(id,update)=>{const term=getSpecificTerm(id);if(!term){return termsMachine(termsState)}const termIndex=termsState.findIndex(x=>x.id===id);termsState[termIndex]=update(term);return termsMachine(termsState)};const updateSpecificTermByIndex=(index,update)=>{const term=termsState[index];termsState[index]=update(term);return termsMachine(termsState)};const pushNewTerm=()=>{const newTerms=[...termsState,createEmptyTerm()];return termsMachine(newTerms)};const build=()=>termsState;return{build,getSpecificTerm,removeAllIncompleted,updateSpecificTerm,setAllInactive,pushNewTerm,removeSpecificTerm,getSpecificTermIndex,updateSpecificTermByIndex}};export const prepareValueDeletion=(oldValue,valueToDelete)=>{if(valueToDelete&&Array.isArray(oldValue)&&oldValue.length>1)return oldValue.filter(value=>value!==valueToDelete);return null};export const getCascadeValuesForConfigitem=(configItem,lastVal)=>{var _configItem_cascadeValues;let foundVal;configItem===null||configItem===void 0?void 0:(_configItem_cascadeValues=configItem.cascadeValues)===null||_configItem_cascadeValues===void 0?void 0:_configItem_cascadeValues.find(config=>{const find=values=>{const found=values===null||values===void 0?void 0:values.find(v=>{const found=v.value===lastVal.value;if(found){foundVal=v;return true}return find(v.options)});if(found)return found};if(config.value===lastVal.value){foundVal=config;return config}return find(config.options)});return foundVal};export const prepareValueChange=(currentValue,newValue)=>{if(Array.isArray(currentValue)&&Array.isArray(newValue))return newValue;if(Array.isArray(newValue))return[...newValue];return newValue};export const serializeFilterToRequestDTO=(state,transformConfig)=>{const transform=transformValueBasedOnControlType(buildDefaultDTOValueTransformMap(transformConfig));const buildField=term=>{var _term_attribute,_term_operator,_term_attribute_control,_term_attribute1;const result={name:((_term_attribute=term.attribute)===null||_term_attribute===void 0?void 0:_term_attribute.name.value)||"",operator:((_term_operator=term.operator)===null||_term_operator===void 0?void 0:_term_operator.value)||"",value:transform(((_term_attribute1=term.attribute)===null||_term_attribute1===void 0?void 0:(_term_attribute_control=_term_attribute1.control)===null||_term_attribute_control===void 0?void 0:_term_attribute_control.type)||EControlType.STRING,term)};if(term.selectedCascadeValues&&term.selectedCascadeValues.length>1){result.keys=term.selectedCascadeValues.slice(1,term.selectedCascadeValues.length).map(v=>v.value)}return result};const fields=termsMachine(state.terms).removeAllIncompleted().build().map(buildField);return{operator:state.match==="ALL"?TFilter.DTO.Match.AND:TFilter.DTO.Match.OR,fields}};export const createEmptyTerm=()=>{return{completed:false,attribute:null,selectedCascadeValues:null,operator:null,value:null,active:true,id:Date.now()}};export const capitalize=string=>{return string.charAt(0).toUpperCase()+string.slice(1)};export function parseNumber(value,type){const number=parseFloat(value.replace(",","."));switch(type){case TFilter.EControlType.FLOAT:return number.fixDecimals(1);case TFilter.EControlType.INTEGER:return number.roundToInteger();default:return number}}export const appendValueToCurrentValueArray=(controlType,newValue)=>{if([TFilter.EControlType.STRING,TFilter.EControlType.ENUM,TFilter.EControlType.UUID].includes(controlType)){return newValue}if(Array.isArray(newValue)){return newValue.map(v=>parseNumber(v,controlType))}else{return parseNumber(newValue,controlType)}};export function parseString(input){var _input_match;const regex=/"[^"]+"|[^:]+/g;return((_input_match=input.match(regex))===null||_input_match===void 0?void 0:_input_match.map(match=>match.replace(/"/g,"")))||[]}export const emptyFilterDTO={operator:TFilter.DTO.Match.AND,fields:[]};export const emptyFilterInternal={match:"ALL",terms:[],termsCollapsed:false,edited:false};export const validateFilterDTO=(filterDTO,config)=>{const result=_object_spread({},filterDTO);const availableNames=config.reduce((acc,curr)=>[...acc,curr.name.value],[]);result.fields=filterDTO.fields.reduce((acc,curr)=>{var _config_find;if(!availableNames.includes(curr.name))return acc;const availableOperators=((_config_find=config.find(c=>c.name.value===curr.name))===null||_config_find===void 0?void 0:_config_find.operators.map(o=>o.value))||[];if(!availableOperators.includes(curr.operator))return acc;return[...acc,curr]},[]);return result};
//# sourceMappingURL=libs.js.map