'use client';
'use strict';

var react = require('react');
var react$1 = require('@floating-ui/react');
var hooks = require('@mantine/hooks');

function useFloatingAutoUpdate({
  opened,
  floating,
  position,
  positionDependencies
}) {
  const [delayedUpdate, setDelayedUpdate] = react.useState(0);
  react.useEffect(() => {
    if (floating.refs.reference.current && floating.refs.floating.current && opened) {
      return react$1.autoUpdate(
        floating.refs.reference.current,
        floating.refs.floating.current,
        floating.update
      );
    }
    return void 0;
  }, [
    floating.refs.reference.current,
    floating.refs.floating.current,
    opened,
    delayedUpdate,
    position
  ]);
  hooks.useDidUpdate(() => {
    floating.update();
  }, positionDependencies);
  hooks.useDidUpdate(() => {
    setDelayedUpdate((c) => c + 1);
  }, [opened]);
}

exports.useFloatingAutoUpdate = useFloatingAutoUpdate;
//# sourceMappingURL=use-floating-auto-update.cjs.map
