'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var react = require('react');
var hooks = require('@mantine/hooks');
var getSize = require('../../core/utils/get-size/get-size.cjs');
var createVarsResolver = require('../../core/styles-api/create-vars-resolver/create-vars-resolver.cjs');
require('clsx');
var getThemeColor = require('../../core/MantineProvider/color-functions/get-theme-color/get-theme-color.cjs');
var getContrastColor = require('../../core/MantineProvider/color-functions/get-contrast-color/get-contrast-color.cjs');
require('../../core/MantineProvider/Mantine.context.cjs');
require('../../core/MantineProvider/default-theme.cjs');
require('../../core/MantineProvider/MantineProvider.cjs');
var MantineThemeProvider = require('../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('../../core/MantineProvider/use-props/use-props.cjs');
require('../../core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
var useStyles = require('../../core/styles-api/use-styles/use-styles.cjs');
var Box = require('../../core/Box/Box.cjs');
var factory = require('../../core/factory/factory.cjs');
require('../../core/DirectionProvider/DirectionProvider.cjs');
var FloatingIndicator = require('../FloatingIndicator/FloatingIndicator.cjs');
var SegmentedControl_module = require('./SegmentedControl.module.css.cjs');

const defaultProps = {
  withItemsBorders: true
};
const varsResolver = createVarsResolver.createVarsResolver(
  (theme, { radius, color, transitionDuration, size, transitionTimingFunction }) => ({
    root: {
      "--sc-radius": radius === void 0 ? void 0 : getSize.getRadius(radius),
      "--sc-color": color ? getThemeColor.getThemeColor(color, theme) : void 0,
      "--sc-shadow": color ? void 0 : "var(--mantine-shadow-xs)",
      "--sc-transition-duration": transitionDuration === void 0 ? void 0 : `${transitionDuration}ms`,
      "--sc-transition-timing-function": transitionTimingFunction,
      "--sc-padding": getSize.getSize(size, "sc-padding"),
      "--sc-font-size": getSize.getFontSize(size)
    }
  })
);
const SegmentedControl = factory.factory((_props, ref) => {
  const props = useProps.useProps("SegmentedControl", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    data,
    value,
    defaultValue,
    onChange,
    size,
    name,
    disabled,
    readOnly,
    fullWidth,
    orientation,
    radius,
    color,
    transitionDuration,
    transitionTimingFunction,
    variant,
    autoContrast,
    withItemsBorders,
    mod,
    ...others
  } = props;
  const getStyles = useStyles.useStyles({
    name: "SegmentedControl",
    props,
    classes: SegmentedControl_module,
    className,
    style,
    classNames,
    styles,
    unstyled,
    vars,
    varsResolver
  });
  const theme = MantineThemeProvider.useMantineTheme();
  const _data = data.map(
    (item) => typeof item === "string" ? { label: item, value: item } : item
  );
  const initialized = hooks.useMounted();
  const [parent, setParent] = react.useState(null);
  const [refs, setRefs] = react.useState({});
  const setElementRef = (element, val) => {
    refs[val] = element;
    setRefs(refs);
  };
  const [_value, handleValueChange] = hooks.useUncontrolled({
    value,
    defaultValue,
    finalValue: Array.isArray(data) ? _data.find((item) => !item.disabled)?.value ?? data[0]?.value ?? null : null,
    onChange
  });
  const uuid = hooks.useId(name);
  const controls = _data.map((item) => /* @__PURE__ */ react.createElement(
    Box.Box,
    {
      ...getStyles("control"),
      mod: { active: _value === item.value, orientation },
      key: item.value
    },
    /* @__PURE__ */ react.createElement(
      "input",
      {
        ...getStyles("input"),
        disabled: disabled || item.disabled,
        type: "radio",
        name: uuid,
        value: item.value,
        id: `${uuid}-${item.value}`,
        checked: _value === item.value,
        onChange: () => !readOnly && handleValueChange(item.value),
        "data-focus-ring": theme.focusRing,
        key: `${item.value}-input`
      }
    ),
    /* @__PURE__ */ react.createElement(
      Box.Box,
      {
        component: "label",
        ...getStyles("label"),
        mod: {
          active: _value === item.value && !(disabled || item.disabled),
          disabled: disabled || item.disabled,
          "read-only": readOnly
        },
        htmlFor: `${uuid}-${item.value}`,
        ref: (node) => setElementRef(node, item.value),
        __vars: {
          "--sc-label-color": color !== void 0 ? getContrastColor.getContrastColor({ color, theme, autoContrast }) : void 0
        },
        key: `${item.value}-label`
      },
      /* @__PURE__ */ jsxRuntime.jsx("span", { ...getStyles("innerLabel"), children: item.label })
    )
  ));
  const mergedRef = hooks.useMergedRef(ref, (node) => setParent(node));
  if (data.length === 0) {
    return null;
  }
  return /* @__PURE__ */ jsxRuntime.jsxs(
    Box.Box,
    {
      ...getStyles("root"),
      variant,
      size,
      ref: mergedRef,
      mod: [
        {
          "full-width": fullWidth,
          orientation,
          initialized,
          "with-items-borders": withItemsBorders
        },
        mod
      ],
      ...others,
      role: "radiogroup",
      "data-disabled": disabled,
      children: [
        typeof _value === "string" && /* @__PURE__ */ jsxRuntime.jsx(
          FloatingIndicator.FloatingIndicator,
          {
            target: refs[_value],
            parent,
            component: "span",
            transitionDuration: "var(--sc-transition-duration)",
            ...getStyles("indicator")
          }
        ),
        controls
      ]
    }
  );
});
SegmentedControl.classes = SegmentedControl_module;
SegmentedControl.displayName = "@mantine/core/SegmentedControl";

exports.SegmentedControl = SegmentedControl;
//# sourceMappingURL=SegmentedControl.cjs.map
