'use client';
'use strict';

var react = require('react');
var react$1 = require('@floating-ui/react');
var hooks = require('@mantine/hooks');
var useFloatingAutoUpdate = require('../Floating/use-floating-auto-update.cjs');
require('../Floating/FloatingArrow/FloatingArrow.cjs');
var TooltipGroup_context = require('./TooltipGroup/TooltipGroup.context.cjs');

function useTooltip(settings) {
  const [uncontrolledOpened, setUncontrolledOpened] = react.useState(settings.defaultOpened);
  const controlled = typeof settings.opened === "boolean";
  const opened = controlled ? settings.opened : uncontrolledOpened;
  const withinGroup = TooltipGroup_context.useTooltipGroupContext();
  const uid = hooks.useId();
  const { delay: groupDelay, currentId, setCurrentId } = react$1.useDelayGroupContext();
  const onChange = react.useCallback(
    (_opened) => {
      setUncontrolledOpened(_opened);
      if (_opened) {
        setCurrentId(uid);
      }
    },
    [setCurrentId, uid]
  );
  const {
    x,
    y,
    context,
    refs,
    update,
    placement,
    middlewareData: { arrow: { x: arrowX, y: arrowY } = {} }
  } = react$1.useFloating({
    strategy: settings.strategy,
    placement: settings.position,
    open: opened,
    onOpenChange: onChange,
    middleware: [
      react$1.offset(settings.offset),
      react$1.shift({ padding: 8 }),
      react$1.flip(),
      react$1.arrow({ element: settings.arrowRef, padding: settings.arrowOffset }),
      ...settings.inline ? [react$1.inline()] : []
    ]
  });
  const { getReferenceProps, getFloatingProps } = react$1.useInteractions([
    react$1.useHover(context, {
      enabled: settings.events?.hover,
      delay: withinGroup ? groupDelay : { open: settings.openDelay, close: settings.closeDelay },
      mouseOnly: !settings.events?.touch
    }),
    react$1.useFocus(context, { enabled: settings.events?.focus, visibleOnly: true }),
    react$1.useRole(context, { role: "tooltip" }),
    // Cannot be used with controlled tooltip, page jumps
    react$1.useDismiss(context, { enabled: typeof settings.opened === "undefined" }),
    react$1.useDelayGroup(context, { id: uid })
  ]);
  useFloatingAutoUpdate.useFloatingAutoUpdate({
    opened,
    position: settings.position,
    positionDependencies: settings.positionDependencies,
    floating: { refs, update }
  });
  hooks.useDidUpdate(() => {
    settings.onPositionChange?.(placement);
  }, [placement]);
  const isGroupPhase = opened && currentId && currentId !== uid;
  return {
    x,
    y,
    arrowX,
    arrowY,
    reference: refs.setReference,
    floating: refs.setFloating,
    getFloatingProps,
    getReferenceProps,
    isGroupPhase,
    opened,
    placement
  };
}

exports.useTooltip = useTooltip;
//# sourceMappingURL=use-tooltip.cjs.map
