'use client';
'use strict';

var react = require('react');
var getAllCheckedNodes = require('./get-all-checked-nodes/get-all-checked-nodes.cjs');
var getChildrenNodesValues = require('./get-children-nodes-values/get-children-nodes-values.cjs');
var isNodeChecked = require('./is-node-checked/is-node-checked.cjs');
var isNodeIndeterminate = require('./is-node-indeterminate/is-node-indeterminate.cjs');

function getInitialExpandedState(initialState, data, value, acc = {}) {
  data.forEach((node) => {
    acc[node.value] = node.value in initialState ? initialState[node.value] : node.value === value;
    if (Array.isArray(node.children)) {
      getInitialExpandedState(initialState, node.children, value, acc);
    }
  });
  return acc;
}
function getInitialCheckedState(initialState, data) {
  const acc = [];
  initialState.forEach((node) => acc.push(...getChildrenNodesValues.getChildrenNodesValues(node, data)));
  return acc;
}
function useTree({
  initialSelectedState = [],
  initialCheckedState = [],
  initialExpandedState = {},
  multiple = false
} = {}) {
  const [data, setData] = react.useState([]);
  const [expandedState, setExpandedState] = react.useState(initialExpandedState);
  const [selectedState, setSelectedState] = react.useState(initialSelectedState);
  const [checkedState, setCheckedState] = react.useState(initialCheckedState);
  const [anchorNode, setAnchorNode] = react.useState(null);
  const [hoveredNode, setHoveredNode] = react.useState(null);
  const initialize = react.useCallback(
    (_data) => {
      setExpandedState((current) => getInitialExpandedState(current, _data, selectedState));
      setCheckedState((current) => getInitialCheckedState(current, _data));
      setData(_data);
    },
    [selectedState, checkedState]
  );
  const toggleExpanded = react.useCallback((value) => {
    setExpandedState((current) => ({ ...current, [value]: !current[value] }));
  }, []);
  const collapse = react.useCallback((value) => {
    setExpandedState((current) => ({ ...current, [value]: false }));
  }, []);
  const expand = react.useCallback((value) => {
    setExpandedState((current) => ({ ...current, [value]: true }));
  }, []);
  const expandAllNodes = react.useCallback(() => {
    setExpandedState((current) => {
      const next = { ...current };
      Object.keys(next).forEach((key) => {
        next[key] = true;
      });
      return next;
    });
  }, []);
  const collapseAllNodes = react.useCallback(() => {
    setExpandedState((current) => {
      const next = { ...current };
      Object.keys(next).forEach((key) => {
        next[key] = false;
      });
      return next;
    });
  }, []);
  const toggleSelected = react.useCallback(
    (value) => setSelectedState((current) => {
      if (!multiple) {
        if (current.includes(value)) {
          setAnchorNode(null);
          return [];
        }
        setAnchorNode(value);
        return [value];
      }
      if (current.includes(value)) {
        setAnchorNode(null);
        return current.filter((item) => item !== value);
      }
      setAnchorNode(value);
      return [...current, value];
    }),
    []
  );
  const select = react.useCallback((value) => {
    setAnchorNode(value);
    setSelectedState(
      (current) => multiple ? current.includes(value) ? current : [...current, value] : [value]
    );
  }, []);
  const deselect = react.useCallback((value) => {
    anchorNode === value && setAnchorNode(null);
    setSelectedState((current) => current.filter((item) => item !== value));
  }, []);
  const clearSelected = react.useCallback(() => {
    setSelectedState([]);
    setAnchorNode(null);
  }, []);
  const checkNode = react.useCallback(
    (value) => {
      const checkedNodes = getChildrenNodesValues.getChildrenNodesValues(value, data);
      setCheckedState((current) => Array.from(/* @__PURE__ */ new Set([...current, ...checkedNodes])));
    },
    [data]
  );
  const uncheckNode = react.useCallback(
    (value) => {
      const checkedNodes = getChildrenNodesValues.getChildrenNodesValues(value, data);
      setCheckedState((current) => current.filter((item) => !checkedNodes.includes(item)));
    },
    [data]
  );
  const getCheckedNodes = () => getAllCheckedNodes.getAllCheckedNodes(data, checkedState).result;
  const isNodeChecked$1 = (value) => isNodeChecked.memoizedIsNodeChecked(value, data, checkedState);
  const isNodeIndeterminate$1 = (value) => isNodeIndeterminate.memoizedIsNodeIndeterminate(value, data, checkedState);
  return {
    multiple,
    expandedState,
    selectedState,
    checkedState,
    anchorNode,
    initialize,
    toggleExpanded,
    collapse,
    expand,
    expandAllNodes,
    collapseAllNodes,
    setExpandedState,
    checkNode,
    uncheckNode,
    toggleSelected,
    select,
    deselect,
    clearSelected,
    setSelectedState,
    hoveredNode,
    setHoveredNode,
    getCheckedNodes,
    isNodeChecked: isNodeChecked$1,
    isNodeIndeterminate: isNodeIndeterminate$1
  };
}

exports.useTree = useTree;
//# sourceMappingURL=use-tree.cjs.map
