import { BoxProps, ElementProps, MantineSize, PolymorphicFactory, StyleProp, StylesApiProps } from '../../core';
export type FlexStylesNames = 'root';
export interface FlexProps extends BoxProps, StylesApiProps<FlexFactory>, ElementProps<'div'> {
    /** `gap` CSS property */
    gap?: StyleProp<MantineSize | (string & {}) | number>;
    /** `row-gap` CSS property */
    rowGap?: StyleProp<MantineSize | (string & {}) | number>;
    /** `column-gap` CSS property */
    columnGap?: StyleProp<MantineSize | (string & {}) | number>;
    /** `align-items` CSS property */
    align?: StyleProp<React.CSSProperties['alignItems']>;
    /** `justify-content` CSS property */
    justify?: StyleProp<React.CSSProperties['justifyContent']>;
    /** `flex-wrap` CSS property */
    wrap?: StyleProp<React.CSSProperties['flexWrap']>;
    /** `flex-direction` CSS property */
    direction?: StyleProp<React.CSSProperties['flexDirection']>;
}
export type FlexFactory = PolymorphicFactory<{
    props: FlexProps;
    defaultRef: HTMLDivElement;
    defaultComponent: 'div';
    stylesNames: FlexStylesNames;
}>;
export declare const Flex: (<C = "div">(props: import("../../core").PolymorphicComponentProps<C, FlexProps>) => import("react").ReactElement<any, string | import("react").JSXElementConstructor<any>>) & Omit<import("react").FunctionComponent<(FlexProps & {
    component?: any;
} & Omit<Omit<any, "ref">, "component" | keyof FlexProps> & {
    ref?: any;
    renderRoot?: ((props: any) => any) | undefined;
}) | (FlexProps & {
    component: import("react").ElementType<any, keyof import("react").JSX.IntrinsicElements>;
    renderRoot?: ((props: Record<string, any>) => any) | undefined;
})>, never> & import("../../core/factory/factory").ThemeExtend<{
    props: FlexProps;
    defaultRef: HTMLDivElement;
    defaultComponent: 'div';
    stylesNames: FlexStylesNames;
}> & import("../../core/factory/factory").ComponentClasses<{
    props: FlexProps;
    defaultRef: HTMLDivElement;
    defaultComponent: 'div';
    stylesNames: FlexStylesNames;
}> & import("../../core/factory/polymorphic-factory").PolymorphicComponentWithProps<{
    props: FlexProps;
    defaultRef: HTMLDivElement;
    defaultComponent: 'div';
    stylesNames: FlexStylesNames;
}> & Record<string, never>;
