#!/usr/bin/env python3


"""

""" """

This file is part of csharp-gentoodotnetinfo - .NET information tool for Gentoo.
Copyright (c) 2023, Maciej Barć <xgqt@riseup.net>
Licensed under the GNU GPL v2 License
SPDX-License-Identifier: GPL-2.0-or-later

csharp-gentoodotnetinfo is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

csharp-gentoodotnetinfo is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with csharp-gentoodotnetinfo.  If not, see <https://www.gnu.org/licenses/>.
"""


from os import chdir
from os import path

from subprocess import run
from sys import argv


def main():
    """! Main."""

    script_path = path.realpath(__file__)
    script_root = path.dirname(script_path)

    source_root = path.realpath(path.join(script_root, ".."))
    admin_path = path.join(source_root, "admin")

    dotnet_executable = "dotnet"

    if len(argv) > 1:
        dotnet_executable = argv[1]

    print(f" * Using dotnet executable: {dotnet_executable}")

    print(f" * Entering directory: {source_root}")
    chdir(source_root)

    make_script_path = path.join(admin_path, "make_gentoo_dotnet_info_test.py")

    run(
        [
            "python3",
            make_script_path,
            dotnet_executable,
            "test",
        ],
        check=True,
    )


if __name__ == "__main__":
    main()
