/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;

final class WeakCache<K, P, V> {
    private final ReferenceQueue<K> refQueue = new ReferenceQueue();
    private final ConcurrentMap<Object, ConcurrentMap<Object, Supplier<V>>> map = new ConcurrentHashMap<Object, ConcurrentMap<Object, Supplier<V>>>();
    private final ConcurrentMap<Supplier<V>, Boolean> reverseMap = new ConcurrentHashMap<Supplier<V>, Boolean>();
    private final BiFunction<K, P, ?> subKeyFactory;
    private final BiFunction<K, P, V> valueFactory;

    public WeakCache(BiFunction<K, P, ?> biFunction, BiFunction<K, P, V> biFunction2) {
        this.subKeyFactory = Objects.requireNonNull(biFunction);
        this.valueFactory = Objects.requireNonNull(biFunction2);
    }

    public V get(K k, P p) {
        Object object;
        Objects.requireNonNull(p);
        this.expungeStaleEntries();
        Object object2 = CacheKey.valueOf(k, this.refQueue);
        ConcurrentMap<Object, Supplier<Factory>> concurrentMap = (ConcurrentHashMap)this.map.get(object2);
        if (concurrentMap == null && (object = (ConcurrentMap)this.map.putIfAbsent(object2, concurrentMap = new ConcurrentHashMap())) != null) {
            concurrentMap = object;
        }
        object = Objects.requireNonNull(this.subKeyFactory.apply(k, p));
        Supplier supplier = (Supplier)concurrentMap.get(object);
        Factory factory = null;
        Object t;
        while (supplier == null || (t = supplier.get()) == null) {
            if (factory == null) {
                factory = new Factory(k, p, object, concurrentMap);
            }
            if (supplier == null) {
                supplier = concurrentMap.putIfAbsent(object, factory);
                if (supplier != null) continue;
                supplier = factory;
                continue;
            }
            if (concurrentMap.replace(object, supplier, factory)) {
                supplier = factory;
                continue;
            }
            supplier = (Supplier)concurrentMap.get(object);
        }
        return (V)t;
    }

    public boolean containsValue(V v) {
        Objects.requireNonNull(v);
        this.expungeStaleEntries();
        return this.reverseMap.containsKey(new LookupValue<V>(v));
    }

    public int size() {
        this.expungeStaleEntries();
        return this.reverseMap.size();
    }

    private void expungeStaleEntries() {
        CacheKey cacheKey;
        while ((cacheKey = (CacheKey)this.refQueue.poll()) != null) {
            cacheKey.expungeFrom(this.map, this.reverseMap);
        }
    }

    private static final class CacheKey<K>
    extends WeakReference<K> {
        private static final Object NULL_KEY = new Object();
        private final int hash;

        static <K> Object valueOf(K k, ReferenceQueue<K> referenceQueue) {
            return k == null ? NULL_KEY : new CacheKey<K>(k, referenceQueue);
        }

        private CacheKey(K k, ReferenceQueue<K> referenceQueue) {
            super(k, referenceQueue);
            this.hash = System.identityHashCode(k);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Object t;
            return object == this || object != null && object.getClass() == this.getClass() && (t = this.get()) != null && t == ((CacheKey)object).get();
        }

        void expungeFrom(ConcurrentMap<?, ? extends ConcurrentMap<?, ?>> concurrentMap, ConcurrentMap<?, Boolean> concurrentMap2) {
            ConcurrentMap concurrentMap3 = (ConcurrentMap)concurrentMap.remove(this);
            if (concurrentMap3 != null) {
                for (Object v : concurrentMap3.values()) {
                    concurrentMap2.remove(v);
                }
            }
        }
    }

    private static final class CacheValue<V>
    extends WeakReference<V>
    implements Value<V> {
        private final int hash;

        CacheValue(V v) {
            super(v);
            this.hash = System.identityHashCode(v);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Object t;
            return object == this || object instanceof Value && (t = this.get()) != null && t == ((Value)object).get();
        }
    }

    private static final class LookupValue<V>
    implements Value<V> {
        private final V value;

        LookupValue(V v) {
            this.value = v;
        }

        @Override
        public V get() {
            return this.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Value && this.value == ((Value)object).get();
        }
    }

    private static interface Value<V>
    extends Supplier<V> {
    }

    private final class Factory
    implements Supplier<V> {
        private final K key;
        private final P parameter;
        private final Object subKey;
        private final ConcurrentMap<Object, Supplier<V>> valuesMap;

        Factory(K k, P p, Object object, ConcurrentMap<Object, Supplier<V>> concurrentMap) {
            this.key = k;
            this.parameter = p;
            this.subKey = object;
            this.valuesMap = concurrentMap;
        }

        @Override
        public synchronized V get() {
            Supplier supplier = (Supplier)this.valuesMap.get(this.subKey);
            if (supplier != this) {
                return null;
            }
            Object v = null;
            try {
                v = Objects.requireNonNull(WeakCache.this.valueFactory.apply(this.key, this.parameter));
            }
            finally {
                if (v == null) {
                    this.valuesMap.remove(this.subKey, this);
                }
            }
            assert (v != null);
            CacheValue<Object> cacheValue = new CacheValue<Object>(v);
            WeakCache.this.reverseMap.put(cacheValue, Boolean.TRUE);
            if (!this.valuesMap.replace(this.subKey, this, cacheValue)) {
                throw new AssertionError((Object)"Should not reach here");
            }
            return v;
        }
    }
}

