Prequesites:
Open another terminal and go get the sm2/sm3 crypto library into your gopath.
The code generator disables go modules.
```
GOPATH=your/go/path go get github.com/tjfoc/gmsm/sm2
```

To generalize all the logic related to Boot Policy Manifest and Key Manifest
we use code generation. Therefore it is enough to create structure declarations
and run command from this directory:
```
go run ./common/manifestcodegen/cmd/manifestcodegen/ . ./bootpolicy ./key
```

It will performe the code autogeneration in directories:
* Current directory (`.`), which contains common structures for different manifests;
* Boot Policy Manifest directory (`./bootpolicy`);
* and Key Manifest directory (`./key`).

To check if the files are in the up-to-date state, one may add option `-check`: 
```
go run ./common/manifestcodegen/cmd/manifestcodegen/ -check . ./bootpolicy ./key
```

Or if it is required to debug/trace the behavior of autogenerated code, one
may add option `-trace`:
```
go run ./common/manifestcodegen/cmd/manifestcodegen/ -trace . ./bootpolicy ./key
```

In this case the code will write a verbose log into stdout.

If you need to edit the template, please edit file: `./common/manifestcodegen/cmd/manifestcodegen/template_methods.tpl.go`.

# Field tags

There are few special struct field tags which are recognized by the code
generator:
* `id` -- defines the element Structure ID string (for example `__TXTS__`).
* `version` -- defines the value of `StructVersion` (see document #575623).
* `countType` -- used only for slices and it defines which variable type is
  used to store amount of items of the slice. Arrays in a structure in a Manifest
  is almost always prepended with a count variable, and we automatically map
  it to the real amount of elements of our slice. And to do that we need to know
  the bitsize of the counter, therefore this tag exists.
* `countValue` -- (see also `countType`) sometimes a counter requires special
  transformations before it could be maped into the real amount of elements
  of a slice. `countValue` allows to define a function to calculate the
  real count value.
* `require` -- defines the value required by the document #575623.
* `default` -- defines the default value.
* `prettyValue` -- defines the function which prints the value in a pretty format.
* `rehashValue` -- is used to receive an auto-updated value, for example it could
  be handy to automatically update size-fields.

See also:
```
grep -RIn field.TagGet ./
```