# Code of Conduct

This code of conduct outlines our rules and expectations for everybody
participating in the coreboot community.

## coreboot community etiquette

We have a friendly and productive atmosphere on our mailing lists,
development / code review tools, IRC chat rooms and when we meet in
person.  Our principles evolve around the following:

* It's not the user's fault if something goes wrong.
* Attempt collaboration before conflict.
* People who intentionally insult others (users, developers, corporations,
  other projects, or the coreboot project itself) will be dealt with. See
  policy below.
* We are dealing with hardware with lots of undocumented pitfalls. It is quite
  possible that you did everything right, but coreboot or its tools still
  won't work for you.

Refrain from insulting anyone or the group they belong to. Remember that
people might be sensitive to other things than you are.

Most of our community members are not native English speakers, thus
misunderstandings can (and do) happen. Assume that others are friendly
and may have picked less-than-stellar wording by accident as long as
you possibly can.

## Reporting Issues

If you have a grievance due to conduct in this community, we're sorry
that you have had a bad experience, and we want to hear about it so
we can resolve the situation.

Please contact members of our arbitration team (listed below) promptly
and directly, in person (if available) or by email: They will listen
to you and react in a timely fashion.

If you feel uncomfortable, please don't wait it out, ask for help,
so we can work on setting things right.

For transparency there is no alias or private mailing list address for
you to reach out to, since we want to make sure that you know who will
and who won't read your message.

However since people might be on travel or otherwise be unavailable
at times, please reach out to multiple persons at once, especially
when using email.

The team will treat your messages confidential as far as the law permits.
For the purpose of knowing what law applies, the list provides the usual
country of residence of each team member.

## Unacceptable Behavior

Unacceptable behaviors include: intimidating, harassing, abusive,
discriminatory, derogatory or demeaning speech or actions by any
participant in our community online, at all related events and in
one-on-one communications carried out in the context of community
business. Community event venues may be shared with members of the public;
please be respectful to all patrons of these locations.

Examples of behaviors we do not accept in our community:

* harmful or prejudicial verbal or written comments related to gender,
  sexual orientation, race, religion, disability;
* inappropriate physical contact, and unwelcome sexual advances;
* deliberate intimidation, stalking or following;
* harassing photography or recording;
* sustained disruption of talks or other events.

Using this code of conduct aggressively against other people in the
community might also be harassment. Be considerate when enforcing the code
of conduct and always try to listen to both sides before passing judgment.

## Consequences of Unacceptable Behavior

Unacceptable behavior from any community member, including sponsors and
those with decision-making authority, will not be tolerated.

Anyone asked to stop unacceptable behavior is expected to comply
immediately.

If a community member engages in unacceptable behavior, the community
organizers may take any action they deem appropriate, up to and including
a temporary ban or permanent expulsion from the community without warning
(and without refund in the case of a paid event).

Community organizers can be members of the arbitration team, or organizers
of events and online communities.

## Addressing Grievances

If you feel you have been falsely or unfairly accused of violating this
Code of Conduct, you should notify the arbitration team with a concise
description of your grievance.

## Scope

We expect all community participants (contributors, paid or otherwise;
sponsors; and other guests) to abide by this Code of Conduct in all
community venues, online and in-person, as well as in all one-on-one
communications pertaining to community business.

## Contact info

Our arbitration team consists of the following people
* Stefan Reinauer <stefan.reinauer@coreboot.org> (USA)
* Patrick Georgi <patrick@coreboot.org> (Germany)
* Ronald Minnich <rminnich@coreboot.org> (USA)
* Martin Roth <martin@coreboot.org> (USA)

## License and attribution

This Code of Conduct is distributed under
a [Creative Commons Attribution-ShareAlike
license](http://creativecommons.org/licenses/by-sa/3.0/).  It is based
on the [Citizen Code of Conduct](https://web.archive.org/web/20200330154000/http://citizencodeofconduct.org/)
