// CD_Ctrl.hh for BBCD - a CD player for X11 / BlackBox
// Copyright (c) 2002 Bertrand Duret <bertrand.duret at libertysurf.fr>
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.


#ifndef CD_CTRL_HH__

#include <string>


class CD_Controler
{
public:
  // Constructor for CD_Controler
  CD_Controler(const std::string & deviceName);
  ~CD_Controler();

  bool isDiscPresent(); // Return true if audio disc is in drive.
//  void eject() const; // eject media / open tray
//  void close() const; // close tray

  // Information about playing status (if a CD audio is in drive)
  enum AudioStatus{
    Invalid,
    Play,
    Paused,
    Completed,
    Error,
    NoStatus
  };

  AudioStatus getAudioStatus(); // Return audio status
  inline bool isPlaying()
    { return getAudioStatus() == Play; }
  inline bool isPaused()
    { return getAudioStatus() == Paused; }
  inline bool isActive()
    { AudioStatus as = getAudioStatus();
      return as == Play || as == Paused; }

  // Controling drive
  unsigned int play(); // Start play with first track
  unsigned int playNext(); // Play next track of current playing track
  unsigned int playPrevious(); // Play previous track of current playing track
  void pause(); // Pause or resume play
  void stop(); // Stop play (and drive)


private:
  std::string deviceName;
  int cd_fd; // Not used directly!!!
             // We use getCdFd, which opens device if needed
             // (Internal note: if cd_fd = -1, device is not open)
  int getCdFd();
  void closeCdFd();
};

#endif // CD_CTRL_HH__
