(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.

(* Why3 assumption *)
Definition unit  := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a}(v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

Axiom pointer : Type.
Parameter pointer_WhyType : WhyType pointer.
Existing Instance pointer_WhyType.

Axiom pointer_dec : forall (p1:pointer) (p2:pointer), (p1 = p2) \/
  ~ (p1 = p2).

(* Why3 assumption *)
Definition next  := (map.Map.map pointer pointer).

Parameter null: pointer.

(* Why3 assumption *)
Inductive is_list : (map.Map.map pointer pointer) -> pointer -> Prop :=
  | is_list_null : forall (next1:(map.Map.map pointer pointer)) (p:pointer),
      (p = null) -> (is_list next1 p)
  | is_list_next : forall (next1:(map.Map.map pointer pointer)) (p:pointer),
      (~ (p = null)) -> ((is_list next1 (map.Map.get next1 p)) ->
      (is_list next1 p)).

Axiom ft : forall (a:Type) {a_WT:WhyType a}, Type.
Parameter ft_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ft a).
Existing Instance ft_WhyType.

Parameter in_ft: pointer -> (ft pointer) -> Prop.

Axiom set_eq : forall (ft1:(ft pointer)) (ft2:(ft pointer)),
  (forall (q:pointer), (in_ft q ft1) <-> (in_ft q ft2)) -> (ft1 = ft2).

Parameter list_ft: (map.Map.map pointer pointer) -> pointer -> (ft pointer).

Axiom list_ft_node_null_cor : forall (next1:(map.Map.map pointer pointer))
  (q:pointer) (p:pointer), (q = null) -> ~ (in_ft p (list_ft next1 q)).

Axiom list_ft_node_next1 : forall (next1:(map.Map.map pointer pointer))
  (q:pointer) (p:pointer), (~ (q = null)) -> ((is_list next1
  (map.Map.get next1 q)) -> ((in_ft p (list_ft next1 (map.Map.get next1
  q))) -> (in_ft p (list_ft next1 q)))).

Axiom list_ft_node_next2 : forall (next1:(map.Map.map pointer pointer))
  (q:pointer), (~ (q = null)) -> ((is_list next1 (map.Map.get next1 q)) ->
  (in_ft q (list_ft next1 q))).

Axiom list_ft_node_next_inv : forall (next1:(map.Map.map pointer pointer))
  (q:pointer) (p:pointer), (~ (q = null)) -> ((is_list next1
  (map.Map.get next1 q)) -> ((~ (q = p)) -> ((in_ft p (list_ft next1 q)) ->
  (in_ft p (list_ft next1 (map.Map.get next1 q)))))).

Axiom frame_list : forall (next1:(map.Map.map pointer pointer)) (p:pointer)
  (q:pointer) (v:pointer), (~ (in_ft q (list_ft next1 p))) -> ((is_list next1
  p) -> (is_list (map.Map.set next1 q v) p)).

(* Why3 assumption *)
Definition sep_node_list(next1:(map.Map.map pointer pointer)) (p1:pointer)
  (p2:pointer): Prop := ~ (in_ft p1 (list_ft next1 p2)).

Axiom frame_list_ft : forall (next1:(map.Map.map pointer pointer))
  (p:pointer) (q:pointer) (v:pointer), (~ (in_ft q (list_ft next1 p))) ->
  ((is_list next1 p) -> ((list_ft next1 p) = (list_ft (map.Map.set next1 q v)
  p))).

(* Why3 assumption *)
Definition sep_list_list(next1:(map.Map.map pointer pointer)) (p1:pointer)
  (p2:pointer): Prop := forall (q:pointer), (~ (in_ft q (list_ft next1
  p1))) \/ ~ (in_ft q (list_ft next1 p2)).

Axiom acyclic_list : forall (next1:(map.Map.map pointer pointer))
  (p:pointer), (~ (p = null)) -> ((is_list next1 p) -> (sep_node_list next1 p
  (map.Map.get next1 p))).

(* Why3 assumption *)
Inductive list (a:Type) {a_WT:WhyType a} :=
  | Nil : list a
  | Cons : a -> (list a) -> list a.
Axiom list_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (list a).
Existing Instance list_WhyType.
Implicit Arguments Nil [[a] [a_WT]].
Implicit Arguments Cons [[a] [a_WT]].

(* Why3 assumption *)
Fixpoint infix_plpl {a:Type} {a_WT:WhyType a}(l1:(list a)) (l2:(list
  a)) {struct l1}: (list a) :=
  match l1 with
  | Nil => l2
  | (Cons x1 r1) => (Cons x1 (infix_plpl r1 l2))
  end.

Axiom Append_assoc : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (l3:(list a)), ((infix_plpl l1 (infix_plpl l2
  l3)) = (infix_plpl (infix_plpl l1 l2) l3)).

Axiom Append_l_nil : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  ((infix_plpl l (Nil :(list a))) = l).

(* Why3 assumption *)
Fixpoint length {a:Type} {a_WT:WhyType a}(l:(list a)) {struct l}: Z :=
  match l with
  | Nil => 0%Z
  | (Cons _ r) => (1%Z + (length r))%Z
  end.

Axiom Length_nonnegative : forall {a:Type} {a_WT:WhyType a}, forall (l:(list
  a)), (0%Z <= (length l))%Z.

Axiom Length_nil : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  ((length l) = 0%Z) <-> (l = (Nil :(list a))).

Axiom Append_length : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)), ((length (infix_plpl l1
  l2)) = ((length l1) + (length l2))%Z).

(* Why3 assumption *)
Fixpoint mem {a:Type} {a_WT:WhyType a}(x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Nil => False
  | (Cons y r) => (x = y) \/ (mem x r)
  end.

Axiom mem_append : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (l1:(list
  a)) (l2:(list a)), (mem x (infix_plpl l1 l2)) <-> ((mem x l1) \/ (mem x
  l2)).

Axiom mem_decomp : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (l:(list
  a)), (mem x l) -> exists l1:(list a), exists l2:(list a),
  (l = (infix_plpl l1 (Cons x l2))).

(* Why3 assumption *)
Fixpoint reverse {a:Type} {a_WT:WhyType a}(l:(list a)) {struct l}: (list
  a) :=
  match l with
  | Nil => (Nil :(list a))
  | (Cons x r) => (infix_plpl (reverse r) (Cons x (Nil :(list a))))
  end.

Axiom reverse_append : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (x:a), ((infix_plpl (reverse (Cons x l1))
  l2) = (infix_plpl (reverse l1) (Cons x l2))).

Axiom reverse_reverse : forall {a:Type} {a_WT:WhyType a}, forall (l:(list
  a)), ((reverse (reverse l)) = l).

Axiom Reverse_length : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  ((length (reverse l)) = (length l)).

Parameter model: (map.Map.map pointer pointer) -> pointer -> (list pointer).

Axiom model_def1 : forall (next1:(map.Map.map pointer pointer)) (p:pointer),
  (p = null) -> ((model next1 p) = (Nil :(list pointer))).

Axiom model_def2 : forall (next1:(map.Map.map pointer pointer)) (p:pointer),
  (~ (p = null)) -> ((model next1 p) = (Cons p (model next1
  (map.Map.get next1 p)))).

(* Why3 goal *)
Theorem frame_model : forall (next1:(map.Map.map pointer pointer))
  (p:pointer) (q:pointer) (v:pointer), (is_list next1 p) -> ((~ (in_ft q
  (list_ft next1 p))) -> ((model next1 p) = (model (map.Map.set next1 q v)
  p))).
Proof.
intros.
induction H.
rewrite (model_def1 _ _ H).
rewrite (model_def1 _ _ H).
reflexivity.
rewrite -> (model_def2 _ _ H).
symmetry.
rewrite -> (model_def2 _ _ H).
symmetry.
assert (q<>p) by (intro eq;apply H0;rewrite eq;clear eq;apply (list_ft_node_next2 _ _ H H1)).
rewrite (Map.Select_neq _ _ _ _ H2).
rewrite IHis_list.
reflexivity.
contradict H0.
exact (list_ft_node_next1 _ _ _  H H1 H0).
Qed.


