/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Pair;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class JavacMessager
implements Messager {
    Log log;
    JavacProcessingEnvironment processingEnv;
    int errorCount = 0;
    int warningCount = 0;

    JavacMessager(Context context, JavacProcessingEnvironment javacProcessingEnvironment) {
        this.log = Log.instance(context);
        this.processingEnv = javacProcessingEnvironment;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence) {
        this.printMessage(kind, charSequence, null, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, Element element) {
        this.printMessage(kind, charSequence, element, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, Element element, AnnotationMirror annotationMirror) {
        this.printMessage(kind, charSequence, element, annotationMirror, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence charSequence, Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        JavaFileObject javaFileObject = null;
        JavaFileObject javaFileObject2 = null;
        JCDiagnostic.DiagnosticPosition diagnosticPosition = null;
        JavacElements javacElements = this.processingEnv.getElementUtils();
        Pair<JCTree, JCTree.JCCompilationUnit> pair = javacElements.getTreeAndTopLevel(element, annotationMirror, annotationValue);
        if (pair != null && (javaFileObject2 = ((JCTree.JCCompilationUnit)pair.snd).sourcefile) != null) {
            javaFileObject = this.log.useSource(javaFileObject2);
            diagnosticPosition = ((JCTree)pair.fst).pos();
        }
        try {
            switch (kind) {
                case ERROR: {
                    ++this.errorCount;
                    this.log.error(JCDiagnostic.DiagnosticFlag.MULTIPLE, diagnosticPosition, "proc.messager", charSequence.toString());
                    break;
                }
                case WARNING: {
                    ++this.warningCount;
                    this.log.warning(diagnosticPosition, "proc.messager", charSequence.toString());
                    break;
                }
                case MANDATORY_WARNING: {
                    ++this.warningCount;
                    this.log.mandatoryWarning(diagnosticPosition, "proc.messager", charSequence.toString());
                    break;
                }
                default: {
                    this.log.note(diagnosticPosition, "proc.messager", charSequence.toString());
                }
            }
            if (javaFileObject2 == null) return;
        }
        catch (Throwable throwable) {
            if (javaFileObject2 == null) throw throwable;
            this.log.useSource(javaFileObject);
            throw throwable;
        }
        this.log.useSource(javaFileObject);
    }

    public void printError(String string) {
        this.printMessage(Diagnostic.Kind.ERROR, string);
    }

    public void printWarning(String string) {
        this.printMessage(Diagnostic.Kind.WARNING, string);
    }

    public void printNotice(String string) {
        this.printMessage(Diagnostic.Kind.NOTE, string);
    }

    public boolean errorRaised() {
        return this.errorCount > 0;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public void newRound() {
        this.errorCount = 0;
    }

    public String toString() {
        return "javac Messager";
    }
}

