/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.CatalogResourceResolver;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.FeatureIndex;
import net.sf.saxon.lib.LocalizerFactory;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorReporter;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.XmlProcessingError;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.PackageLibrary;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.type.SchemaType;
import org.xmlresolver.ResolverFeature;

public class ConfigurationReader
implements Receiver {
    private int level = 0;
    private String section = null;
    private String subsection = null;
    private final StringBuilder buffer = new StringBuilder(100);
    protected Configuration targetConfig;
    private ClassLoader classLoader = null;
    private final List<XmlProcessingError> errors = new ArrayList<XmlProcessingError>();
    private PackageLibrary packageLibrary;
    private PackageDetails currentPackage;
    private Configuration baseConfiguration;
    private PipelineConfiguration pipe;
    private final Stack<String> localNameStack = new Stack();
    private String systemId = null;
    private ArrayList<String> catalogFiles = null;
    private static final int OBSOLETE_PROPERTY = -9999;

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public void open() throws XPathException {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void processingInstruction(String name, UnicodeString data, Location location, int properties) throws XPathException {
    }

    @Override
    public void comment(UnicodeString content, Location location, int properties) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBaseConfiguration(Configuration base) {
        this.baseConfiguration = base;
    }

    public Configuration makeConfiguration(Source source) throws XPathException {
        Configuration localConfig = this.baseConfiguration;
        if (localConfig == null) {
            if (this.pipe == null) {
                localConfig = new Configuration();
                this.setPipelineConfiguration(localConfig.makePipelineConfiguration());
            } else {
                localConfig = this.pipe.getConfiguration();
            }
        } else if (this.pipe == null) {
            this.pipe = localConfig.makePipelineConfiguration();
        }
        this.setSystemId(source.getSystemId());
        ActiveSource activeSource = Version.platform.resolveSource(source, localConfig);
        activeSource.deliver(this, new ParseOptions());
        if (!this.errors.isEmpty()) {
            XmlProcessingError foundFatal = null;
            ErrorReporter reporter = this.targetConfig == null ? new StandardErrorReporter() : this.targetConfig.makeErrorReporter();
            for (XmlProcessingError err : this.errors) {
                if (!err.isWarning() && foundFatal == null) {
                    foundFatal = err;
                }
                reporter.report(err.asWarning());
            }
            if (foundFatal != null) {
                throw XPathException.fromXmlProcessingError(foundFatal);
            }
        }
        if (this.baseConfiguration != null) {
            this.targetConfig.importLicenseDetails(this.baseConfiguration);
        }
        return this.targetConfig;
    }

    @Override
    public void endDocument() {
        if (this.targetConfig != null) {
            this.targetConfig.getDefaultXsltCompilerInfo().setPackageLibrary(this.packageLibrary);
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap atts, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        NamespaceUri uri = elemName.getNamespaceUri();
        String localName = elemName.getLocalPart();
        this.localNameStack.push(localName);
        this.buffer.setLength(0);
        if (NamespaceUri.SAXON_CONFIGURATION.equals(uri)) {
            if (this.level == 0) {
                String label;
                String targetEdition;
                String edition;
                if (!"configuration".equals(localName)) {
                    this.error(localName, null, null, "configuration");
                }
                if ((edition = atts.getValue("edition")) == null) {
                    edition = "HE";
                }
                switch (edition) {
                    case "HE": {
                        this.targetConfig = new Configuration();
                        break;
                    }
                    case "PE": {
                        this.targetConfig = Configuration.makeLicensedConfiguration(this.classLoader, "com.saxonica.config.ProfessionalConfiguration");
                        break;
                    }
                    case "EE": {
                        this.targetConfig = Configuration.makeLicensedConfiguration(this.classLoader, "com.saxonica.config.EnterpriseConfiguration");
                        break;
                    }
                    default: {
                        this.error("configuration", "edition", edition, "HE|PE|EE");
                        this.targetConfig = new Configuration();
                    }
                }
                if (this.baseConfiguration != null) {
                    this.targetConfig.setNamePool(this.baseConfiguration.getNamePool());
                    this.targetConfig.setDocumentNumberAllocator(this.baseConfiguration.getDocumentNumberAllocator());
                }
                this.packageLibrary = new PackageLibrary(this.targetConfig.getDefaultXsltCompilerInfo());
                String licenseLoc = atts.getValue("licenseFileLocation");
                if (licenseLoc != null && !edition.equals("HE")) {
                    String base = this.getSystemId();
                    try {
                        URI absoluteLoc = ResolveURI.makeAbsolute(licenseLoc, base);
                        this.targetConfig.setConfigurationProperty("http://saxon.sf.net/feature/licenseFileLocation", absoluteLoc.toString());
                    }
                    catch (Exception err) {
                        XmlProcessingIncident incident = new XmlProcessingIncident("Failed to process license at " + licenseLoc);
                        incident.setCause(err);
                        this.errors.add(incident);
                    }
                }
                if ((targetEdition = atts.getValue("targetEdition")) != null) {
                    this.packageLibrary.getCompilerInfo().setTargetEdition(targetEdition);
                }
                if ((label = atts.getValue("label")) != null) {
                    this.targetConfig.setLabel(label);
                }
                this.targetConfig.getDynamicLoader().setClassLoader(this.classLoader);
            }
            if (this.level == 1) {
                this.section = localName;
                if ("global".equals(localName)) {
                    this.readGlobalElement(atts);
                } else if ("serialization".equals(localName)) {
                    this.readSerializationElement(atts, namespaces);
                } else if ("xquery".equals(localName)) {
                    this.readXQueryElement(atts);
                } else if ("xslt".equals(localName)) {
                    this.readXsltElement(atts);
                } else if (!"xsltPackages".equals(localName)) {
                    if ("xsd".equals(localName)) {
                        this.readXsdElement(atts);
                    } else if ("resources".equals(localName)) {
                        this.catalogFiles = new ArrayList();
                    } else if (!"collations".equals(localName)) {
                        if ("localizations".equals(localName)) {
                            this.readLocalizationsElement(atts);
                        } else {
                            this.error(localName, null, null, null);
                        }
                    }
                }
            } else if (this.level == 2) {
                this.subsection = localName;
                switch (this.section) {
                    case "resources": {
                        if (!"fileExtension".equals(localName)) break;
                        this.readFileExtension(atts);
                        break;
                    }
                    case "collations": {
                        if (!"collation".equals(localName)) {
                            this.error(localName, null, null, "collation");
                            break;
                        }
                        this.readCollation(atts);
                        break;
                    }
                    case "localizations": {
                        if (!"localization".equals(localName)) {
                            this.error(localName, null, null, "localization");
                            break;
                        }
                        this.readLocalization(atts);
                        break;
                    }
                    case "xslt": {
                        if ("extensionElement".equals(localName)) {
                            this.readExtensionElement(atts);
                            break;
                        }
                        this.error(localName, null, null, null);
                        break;
                    }
                    case "xsltPackages": {
                        if (!"package".equals(localName)) break;
                        this.readXsltPackage(atts);
                    }
                }
            } else if (this.level == 3 && "package".equals(this.subsection)) {
                if ("withParam".equals(localName)) {
                    this.readWithParam(atts, namespaces);
                } else {
                    this.error(localName, null, null, null);
                }
            }
        } else {
            XmlProcessingIncident incident = new XmlProcessingIncident("Configuration elements must be in namespace http://saxon.sf.net/ns/configuration");
            this.errors.add(incident);
        }
        ++this.level;
    }

    private void readGlobalElement(AttributeMap atts) {
        Properties props = new Properties();
        for (AttributeInfo a : atts) {
            String name = a.getNodeName().getLocalPart();
            String value = a.getValue();
            if (value.isEmpty() || !a.getNodeName().getNamespaceUri().isEmpty()) continue;
            props.setProperty(name, value);
        }
        props.setProperty("#element", "global");
        this.applyProperty(props, "allowedProtocols", 124, "JN");
        this.applyProperty(props, "allowExternalFunctions", 1, "J");
        this.applyProperty(props, "allowMultiThreading", 2, "JN");
        this.applyProperty(props, "allowOldJavaUriFormat", 3, "J");
        this.applyProperty(props, "allowSyntaxExtensions", 4, "JN");
        this.applyProperty(props, "collationUriResolver", 7, "J");
        this.applyProperty(props, "collectionFinder", 9, "J");
        this.applyProperty(props, "compileWithTracing", 12, "JN");
        this.applyProperty(props, "debugByteCode", -9999, "J");
        this.applyProperty(props, "debugByteCodeDirectory", -9999, "J");
        this.applyProperty(props, "defaultCollation", 17, "JN");
        this.applyProperty(props, "defaultCollection", 18, "JN");
        this.applyProperty(props, "defaultRegexEngine", 21, "J");
        this.applyProperty(props, "displayByteCode", -9999, "J");
        this.applyProperty(props, "dtdValidation", 24, "JN");
        this.applyProperty(props, "dtdValidationRecoverable", 25, "J");
        this.applyProperty(props, "eagerEvaluation", 26, "JN");
        this.applyProperty(props, "entityResolver", 27, "J");
        this.applyProperty(props, "environmentVariableResolver", 29, "J");
        this.applyProperty(props, "errorListener", 30, "J");
        this.applyProperty(props, "expandAttributeDefaults", 31, "JN");
        this.applyProperty(props, "generateByteCode", -9999, "J");
        this.applyProperty(props, "ignoreSAXSourceParser", 34, "J");
        this.applyProperty(props, "lazyConstructionMode", -9999, "JN");
        this.applyProperty(props, "lineNumbering", 38, "JN");
        this.applyProperty(props, "markDefaultedAttributes", 39, "J");
        this.applyProperty(props, "maxCompiledClasses", -9999, "J");
        this.applyProperty(props, "monitorHotSpotByteCode", -9999, "J");
        this.applyProperty(props, "optimizationLevel", 48, "JN");
        this.applyProperty(props, "parser", 63, "J");
        this.applyProperty(props, "preEvaluateDoc", 51, "JN");
        this.applyProperty(props, "recognizeUriQueryParameters", 53, "JN");
        this.applyProperty(props, "regexBacktrackingLimit", 119, "JN");
        this.applyProperty(props, "resourceResolver", 129, "J");
        this.applyProperty(props, "retainNodeForDiagnostics", 125, "JN");
        this.applyProperty(props, "schemaValidation", 61, "JN");
        this.applyProperty(props, "serializerFactory", 62, "J");
        this.applyProperty(props, "sourceResolver", 64, "J");
        this.applyProperty(props, "stableCollectionUri", 65, "JN");
        this.applyProperty(props, "stableUnparsedText", 66, "JN");
        this.applyProperty(props, "standardErrorOutputFile", 67, "JN");
        this.applyProperty(props, "streamability", 68, "JN");
        this.applyProperty(props, "streamingFallback", 70, "JN");
        this.applyProperty(props, "stripSpace", 71, "JN");
        this.applyProperty(props, "styleParser", 72, "J");
        this.applyProperty(props, "suppressEvaluationExpiryWarning", 73, "JN");
        this.applyProperty(props, "suppressXPathWarnings", 74, "JN");
        this.applyProperty(props, "suppressXsltNamespaceCheck", 75, "JN");
        this.applyProperty(props, "thresholdForFunctionInlining", 122, "JN");
        this.applyProperty(props, "thresholdForHotspotByteCode", -9999, "J");
        this.applyProperty(props, "timing", 77, "JN");
        this.applyProperty(props, "traceExternalFunctions", 78, "JN");
        this.applyProperty(props, "traceListener", 80, "J");
        this.applyProperty(props, "traceListenerOutputFile", 81, "JN");
        this.applyProperty(props, "traceOptimizerDecisions", 82, "JN");
        this.applyProperty(props, "treeModel", 84, "JN");
        this.applyProperty(props, "unparsedTextUriResolver", 86, "J");
        this.applyProperty(props, "unparsedTextURIResolver", 86, "J");
        this.applyProperty(props, "uriResolver", 87, "J");
        this.applyProperty(props, "usePiDisableOutputEscaping", 88, "JN");
        this.applyProperty(props, "useTypedValueCache", 89, "JN");
        this.applyProperty(props, "validationComments", 91, "JN");
        this.applyProperty(props, "validationWarnings", 92, "JN");
        this.applyProperty(props, "versionOfXml", 95, "J");
        this.applyProperty(props, "xInclude", 94, "J");
        this.applyProperty(props, "xpathVersionForXsd", 120, "JN");
        this.applyProperty(props, "xpathVersionForXslt", 121, "JN");
        this.applyProperty(props, "zipUriPattern", 127, "JN");
        for (String name : props.stringPropertyNames()) {
            if (name.equals("#element")) continue;
            this.error("global", name, props.getProperty(name), "#unrecognized");
        }
    }

    private void applyProperty(Properties props, String attributeName, int featureCode, String flags) {
        String value = props.getProperty(attributeName);
        if (value != null) {
            if (featureCode == -9999) {
                this.error(props.getProperty("#element"), attributeName, value, "#obsolete");
                props.remove(attributeName);
                return;
            }
            if (!this.checkPlatform(flags)) {
                this.error(props.getProperty("#element"), attributeName, value, "Property " + attributeName + " is not available in SaxonCS");
                return;
            }
            try {
                this.targetConfig.setConfigurationProperty(FeatureIndex.getData((int)featureCode).uri, value);
                props.remove(attributeName);
            }
            catch (IllegalArgumentException e) {
                String message = e.getMessage();
                if (message.startsWith(attributeName)) {
                    message = message.replace(attributeName, "Value");
                }
                if (message.startsWith("Unknown configuration property")) {
                    message = "Property " + attributeName + " is not available in Saxon-" + this.targetConfig.getEditionCode();
                }
                this.error(props.getProperty("#element"), attributeName, value, message);
            }
        }
    }

    private boolean checkPlatform(String flags) {
        return flags.contains("J");
    }

    private void readSerializationElement(AttributeMap atts, NamespaceMap nsMap) {
        Properties props = new Properties();
        for (AttributeInfo a : atts) {
            NamespaceUri uri = a.getNodeName().getNamespaceUri();
            String name = a.getNodeName().getLocalPart();
            String value = a.getValue();
            if (value.isEmpty()) continue;
            try {
                ResultDocument.setSerializationProperty(props, uri, name, value, nsMap, false, this.targetConfig);
            }
            catch (XPathException e) {
                this.errors.add(new XmlProcessingException(e));
            }
        }
        this.targetConfig.setDefaultSerializationProperties(props);
    }

    private void readCollation(AttributeMap atts) {
        Properties props = new Properties();
        String collationUri = null;
        for (AttributeInfo a : atts) {
            NamespaceUri uri = a.getNodeName().getNamespaceUri();
            String name = a.getNodeName().getLocalPart();
            String value = a.getValue();
            if (!uri.isEmpty() || value.isEmpty()) continue;
            if ("uri".equals(name)) {
                collationUri = value;
                continue;
            }
            props.setProperty(name, value);
        }
        if (collationUri == null) {
            this.errors.add(new XmlProcessingIncident("collation specified with no uri"));
        }
        StringCollator collator = null;
        try {
            collator = Version.platform.makeCollation(this.targetConfig, props, collationUri);
        }
        catch (XPathException e) {
            this.errors.add(new XmlProcessingIncident(e.getMessage()));
        }
        this.targetConfig.registerCollation(collationUri, collator);
    }

    private void readLocalizationsElement(AttributeMap atts) {
        for (AttributeInfo a : atts) {
            NamespaceUri uri = a.getNodeName().getNamespaceUri();
            String name = a.getNodeName().getLocalPart();
            String value = a.getValue();
            if (!uri.isEmpty()) continue;
            if ("defaultLanguage".equals(name) && !value.isEmpty()) {
                this.targetConfig.setConfigurationProperty("http://saxon.sf.net/feature/defaultLanguage", value);
            }
            if (!"defaultCountry".equals(name) || value.isEmpty()) continue;
            this.targetConfig.setConfigurationProperty("http://saxon.sf.net/feature/defaultCountry", value);
        }
    }

    private void readLocalization(AttributeMap atts) {
        LocalizerFactory factory;
        String lang = null;
        Properties properties = new Properties();
        for (AttributeInfo a : atts) {
            NamespaceUri uri = a.getNodeName().getNamespaceUri();
            String name = a.getNodeName().getLocalPart();
            String value = a.getValue();
            if (!uri.isEmpty()) continue;
            if ("lang".equals(name) && !value.isEmpty()) {
                lang = value;
                continue;
            }
            if (value.isEmpty()) continue;
            properties.setProperty(name, value);
        }
        if (lang != null && (factory = this.targetConfig.getLocalizerFactory()) != null) {
            factory.setLanguageProperties(lang, properties);
        }
    }

    private void readFileExtension(AttributeMap atts) {
        String extension = atts.getValue("extension");
        String mediaType = atts.getValue("mediaType");
        if (extension == null) {
            this.error("fileExtension", "extension", null, null);
        }
        if (mediaType == null) {
            this.error("fileExtension", "mediaType", null, null);
        }
        this.targetConfig.registerFileExtension(extension, mediaType);
    }

    protected void readExtensionElement(AttributeMap atts) {
        XmlProcessingIncident err = new XmlProcessingIncident("Extension elements are not available in Saxon" + Version.getSoftwarePlatform() + "-" + this.targetConfig.getEditionCode());
        this.errors.add(err);
    }

    protected void readXsltPackage(AttributeMap atts) {
        String name = atts.getValue("name");
        if (name == null) {
            String attName = "exportLocation";
            String location = atts.getValue("exportLocation");
            URI uri = null;
            if (location == null) {
                attName = "sourceLocation";
                location = atts.getValue("sourceLocation");
            }
            if (location == null) {
                this.error("package", attName, null, null);
            }
            try {
                uri = ResolveURI.makeAbsolute(location, this.getSystemId());
            }
            catch (URISyntaxException e) {
                this.error("package", attName, location, "Requires a valid URI.");
            }
            File file = new File(uri);
            try {
                this.packageLibrary.addPackage(file);
            }
            catch (XPathException e) {
                this.error(e);
            }
        } else {
            String priority;
            String exportLoc;
            String version = atts.getValue("version");
            if (version == null) {
                version = "1";
            }
            VersionedPackageName vpn = null;
            PackageDetails details = new PackageDetails();
            try {
                vpn = new VersionedPackageName(name, version);
            }
            catch (XPathException err) {
                this.error("package", "version", version, null);
            }
            details.nameAndVersion = vpn;
            this.currentPackage = details;
            String sourceLoc = atts.getValue("sourceLocation");
            StreamSource source = null;
            if (sourceLoc != null) {
                try {
                    source = new StreamSource(ResolveURI.makeAbsolute(sourceLoc, this.getSystemId()).toString());
                }
                catch (URISyntaxException e) {
                    this.error("package", "sourceLocation", sourceLoc, "Requires a valid URI.");
                }
                details.sourceLocation = source;
            }
            if ((exportLoc = atts.getValue("exportLocation")) != null) {
                try {
                    source = new StreamSource(ResolveURI.makeAbsolute(exportLoc, this.getSystemId()).toString());
                }
                catch (URISyntaxException e) {
                    this.error("package", "exportLocation", exportLoc, "Requires a valid URI.");
                }
                details.exportLocation = source;
            }
            if ((priority = atts.getValue("priority")) != null) {
                try {
                    details.priority = Integer.parseInt(priority);
                }
                catch (NumberFormatException err) {
                    this.error("package", "priority", priority, "Requires an integer.");
                }
            }
            details.baseName = atts.getValue("base");
            details.shortName = atts.getValue("shortName");
            this.packageLibrary.addPackage(details);
        }
    }

    protected void readWithParam(AttributeMap atts, NamespaceMap nsMap) {
        String name;
        if (this.currentPackage.exportLocation != null) {
            this.error("withParam", null, null, "Not allowed when @exportLocation exists");
        }
        if ((name = atts.getValue("name")) == null) {
            this.error("withParam", "name", null, null);
        }
        QNameParser qp = new QNameParser(nsMap).withAcceptEQName(true);
        StructuredQName qName = null;
        try {
            qName = qp.parse(name, NamespaceUri.NULL);
        }
        catch (XPathException e) {
            this.error("withParam", "name", name, "Requires valid QName");
        }
        String select = atts.getValue("select");
        if (select == null) {
            this.error("withParam", "select", null, null);
        }
        IndependentContext env = new IndependentContext(this.targetConfig);
        env.setNamespaceResolver(nsMap);
        XPathParser parser = new XPathParser(env);
        GroundedValue value = null;
        try {
            Expression exp = parser.parse(select, 0, 0, env);
            value = SequenceTool.toGroundedValue(exp.iterate(env.makeEarlyEvaluationContext()));
        }
        catch (XPathException e) {
            this.error(e);
        }
        catch (UncheckedXPathException e) {
            this.error(e.getXPathException());
        }
        if (this.currentPackage.staticParams == null) {
            this.currentPackage.staticParams = new HashMap<StructuredQName, GroundedValue>();
        }
        this.currentPackage.staticParams.put(qName, value);
    }

    private void readXQueryElement(AttributeMap atts) {
        Properties props = new Properties();
        for (AttributeInfo a : atts) {
            NamespaceUri uri = a.getNodeName().getNamespaceUri();
            String name = a.getNodeName().getLocalPart();
            String value = a.getValue();
            if (value.isEmpty() || !uri.isEmpty()) continue;
            props.setProperty(name, value);
        }
        props.setProperty("#element", "xquery");
        this.applyProperty(props, "allowUpdate", 98, "JN");
        this.applyProperty(props, "constructionMode", 99, "JN");
        this.applyProperty(props, "defaultElementNamespace", 100, "JN");
        this.applyProperty(props, "defaultFunctionNamespace", 101, "JN");
        this.applyProperty(props, "emptyLeast", 102, "JN");
        this.applyProperty(props, "inheritNamespaces", 103, "JN");
        this.applyProperty(props, "moduleUriResolver", 43, "J");
        this.applyProperty(props, "multipleModuleImports", 104, "JN");
        this.applyProperty(props, "preserveBoundarySpace", 105, "JN");
        this.applyProperty(props, "preserveNamespaces", 106, "JN");
        this.applyProperty(props, "requiredContextItemType", 107, "JN");
        this.applyProperty(props, "schemaAware", 108, "JN");
        this.applyProperty(props, "staticErrorListener", 109, "J");
        this.applyProperty(props, "version", 110, "JN");
        for (String name : props.stringPropertyNames()) {
            if (name.equals("#element")) continue;
            this.error("xquery", name, props.getProperty(name), "#unrecognized");
        }
    }

    private void readXsltElement(AttributeMap atts) {
        Properties props = new Properties();
        for (AttributeInfo a : atts) {
            NamespaceUri uri = a.getNodeName().getNamespaceUri();
            String name = a.getNodeName().getLocalPart();
            String value = a.getValue();
            if (value.isEmpty() || !uri.isEmpty()) continue;
            props.setProperty(name, value);
        }
        props.setProperty("#element", "xslt");
        this.applyProperty(props, "disableXslEvaluate", 22, "JN");
        this.applyProperty(props, "enableAssertions", 112, "JN");
        this.applyProperty(props, "initialMode", 113, "JN");
        this.applyProperty(props, "initialTemplate", 114, "JN");
        this.applyProperty(props, "messageEmitter", -9999, "J");
        this.applyProperty(props, "outputUriResolver", 50, "J");
        this.applyProperty(props, "recoveryPolicy", -9999, "JN");
        this.applyProperty(props, "resultDocumentThreads", 56, "JN");
        this.applyProperty(props, "schemaAware", 115, "JN");
        this.applyProperty(props, "staticErrorListener", 116, "J");
        this.applyProperty(props, "staticUriResolver", 117, "J");
        this.applyProperty(props, "strictStreamability", 69, "JN");
        this.applyProperty(props, "styleParser", 72, "J");
        this.applyProperty(props, "version", 118, "JN");
        this.applyProperty(props, "versionWarning", -9999, "JN");
        for (String name : props.stringPropertyNames()) {
            if (name.equals("#element")) continue;
            this.error("xslt", name, props.getProperty(name), "#unrecognized");
        }
    }

    private void readXsdElement(AttributeMap atts) {
        Properties props = new Properties();
        for (AttributeInfo a : atts) {
            NamespaceUri uri = a.getNodeName().getNamespaceUri();
            String name = a.getNodeName().getLocalPart();
            String value = a.getValue();
            if (value.isEmpty() || !uri.isEmpty()) continue;
            props.setProperty(name, value);
        }
        props.setProperty("#element", "xsd");
        this.applyProperty(props, "allowUnresolvedSchemaComponents", 126, "JN");
        this.applyProperty(props, "assertionsCanSeeComments", 5, "JN");
        this.applyProperty(props, "implicitSchemaImports", 35, "JN");
        this.applyProperty(props, "multipleSchemaImports", 45, "JN");
        this.applyProperty(props, "occurrenceLimits", 47, "JN");
        this.applyProperty(props, "schemaUriResolver", 59, "J");
        this.applyProperty(props, "thresholdForCompilingTypes", -9999, "JN");
        this.applyProperty(props, "useXsiSchemaLocation", 90, "JN");
        this.applyProperty(props, "version", 111, "JN");
        for (String name : props.stringPropertyNames()) {
            if (name.equals("#element")) continue;
            this.error("xsd", name, props.getProperty(name), "#unrecognized");
        }
    }

    private void error(String element, String attribute, String actual, String required) {
        XmlProcessingIncident err = attribute == null ? new XmlProcessingIncident("Invalid configuration element " + element) : (actual == null ? new XmlProcessingIncident("Missing configuration property " + element + "/@" + attribute) : (required.equals("#unrecognized") ? new XmlProcessingIncident("Unrecognized configuration property " + element + "/@" + attribute) : (required.equals("#obsolete") ? new XmlProcessingIncident("Obsolete configuration property " + element + "/@" + attribute).asWarning() : (required.contains("is not available in") ? new XmlProcessingIncident("Configuration property " + element + "/@" + attribute + ": " + required) : new XmlProcessingIncident("Invalid configuration property " + element + "/@" + attribute + ". Supplied value: '" + actual + "'; required: '" + required + "'")))));
        this.errors.add(err);
    }

    protected void error(XPathException err) {
        this.errors.add(new XmlProcessingException(err));
    }

    protected void errorClass(String element, String attribute, String actual, Class required, Exception cause) {
        XmlProcessingIncident err = new XmlProcessingIncident("Invalid configuration property " + element + (attribute == null ? "" : "/@" + attribute) + ". Supplied value '" + actual + "', required value is the name of a class that implements '" + required.getName() + "'");
        err.setCause(cause);
        this.errors.add(err);
    }

    @Override
    public void endElement() throws XPathException {
        String content;
        String localName = this.localNameStack.pop();
        if (this.level == 3 && "resources".equals(this.section) && !(content = this.buffer.toString()).isEmpty()) {
            if ("externalObjectModel".equals(localName)) {
                try {
                    ExternalObjectModel model = (ExternalObjectModel)this.targetConfig.getInstance(content);
                    this.targetConfig.registerExternalObjectModel(model);
                }
                catch (ClassCastException | XPathException e) {
                    this.errorClass("externalObjectModel", null, content, ExternalObjectModel.class, e);
                }
            } else if ("extensionFunction".equals(localName)) {
                try {
                    ExtensionFunctionDefinition model = (ExtensionFunctionDefinition)this.targetConfig.getInstance(content);
                    this.targetConfig.registerExtensionFunction(model);
                }
                catch (ClassCastException | IllegalArgumentException | XPathException e) {
                    this.errorClass("extensionFunction", null, content, ExtensionFunctionDefinition.class, e);
                }
            } else if ("schemaDocument".equals(localName)) {
                try {
                    Source source = this.getInputSource(content);
                    this.targetConfig.addSchemaSource(source);
                }
                catch (XPathException e) {
                    this.errors.add(new XmlProcessingException(e));
                }
            } else if ("schemaComponentModel".equals(localName)) {
                try {
                    Source source = this.getInputSource(content);
                    this.targetConfig.importComponents(source);
                }
                catch (XPathException e) {
                    this.errors.add(new XmlProcessingException(e));
                }
            } else if ("catalogFile".equals(localName)) {
                URI baseURI = URI.create(this.systemId);
                this.catalogFiles.add(baseURI.resolve(content).toString());
            } else if (!"fileExtension".equals(localName)) {
                this.error(localName, null, null, null);
            }
        }
        if (this.level == 2 && "resources".equals(localName) && this.catalogFiles.size() != 0 && this.targetConfig.getResourceResolver() instanceof CatalogResourceResolver) {
            ((CatalogResourceResolver)this.targetConfig.getResourceResolver()).setFeature(ResolverFeature.CATALOG_FILES, this.catalogFiles);
        }
        --this.level;
        this.buffer.setLength(0);
    }

    private Source getInputSource(String href) throws XPathException {
        try {
            String base = this.getSystemId();
            URI abs = ResolveURI.makeAbsolute(href, base);
            return new StreamSource(abs.toString());
        }
        catch (URISyntaxException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
        this.buffer.append(chars.toString());
    }
}

