#ifndef __LIBCANON_SLIM__
#define __LIBCANON_SLIM__

#if __cplusplus
extern "C"
{
#endif

/* for mac */
#define	FAR
#define WINAPI

#ifndef _BYTE
typedef unsigned char		BYTE; 
#define _BYTE
#endif
#ifndef _WORD
typedef unsigned short 		WORD;
#define _WORD
#endif
typedef	BYTE *				PBYTE;
#ifndef _LPBYTE
typedef	BYTE *				LPBYTE;
#define _LPBYTE
#endif

#if __LP64__
/* Mac/Linux's own code for 64bit */
#ifndef _LONG
typedef int					LONG;
#define _LONG
#endif
#ifndef _DWORD
typedef unsigned int		DWORD;
#define _DWORD
#endif
typedef	LONG *				PLONG;
typedef	LONG *				LPLONG;
#ifndef _LPDWORD
typedef	unsigned int		*LPDWORD;
#define _LPDWORD
#endif
#else
#ifndef _LONG
typedef long				LONG;
#define _LONG
#endif
#ifndef _DWORD
typedef unsigned long		DWORD;
#define _DWORD
#endif
typedef	LONG *				PLONG;
typedef	LONG *				LPLONG;
#ifndef _LPDWORD
typedef	unsigned long		*LPDWORD;
#define _LPDWORD
#endif
#endif /* __LP64__ */

/* slim param */
typedef struct {		 
	BYTE			bXOffset[2];  
	BYTE			bYOffset[2];  
	signed char		bZOffset[2];
	WORD			wFarOffset;					
} COMPPARAM, *PCOMPPARAM, FAR *LPCOMPPARAM;			  

LONG WINAPI lCaptComp(LPBYTE, LPBYTE, LONG, LONG, LONG, int, LPLONG, LPCOMPPARAM);
LONG WINAPI lCaptDecode(    // デコードされたライン数を返す。エラーのとき-1 //
    LPBYTE FAR *,     // 入力バッファアドレスポインタへのポインタ //
    LPBYTE,           // 出力バッファアドレス //
    LONG,             // １ラインのバイト数 //
    LONG,             // ライン数、１以上で実際のライン数以上であること //
    LPLONG,           // 入力バッファサイズへのポインタ //
    int,              // １画素のビット数 //
    LPCOMPPARAM       // 圧縮パラメタ //
);
LONG WINAPI lCaptCompEx(    // 出力されたバイト数を返す //
    LPBYTE,           // 入力バッファアドレス //
    LPBYTE,           // 出力バッファアドレス //
    LONG,             // １ラインのバイト数 //
    LONG,             // ライン数 //
    LONG,             // 出力バッファサイズ //
    int,              // １画素のビット数 //
    LPLONG,           // エンコードされたライン数を格納するアドレス //
    LPCOMPPARAM,      // 圧縮パラメタ //
    LONG,             // コピー長の下限(2を指定すること) //
    LPDWORD           // 未使用(NULLを指定すること) //
);
LONG WINAPI lCaptCompEx2(    // 出力されたバイト数を返す //
    LPBYTE,           // 入力バッファアドレス //
    LPBYTE,           // 出力バッファアドレス //
    LONG,             // １ラインのバイト数 //
    LONG,             // ライン数 //
    LONG,             // 出力バッファサイズ //
    int,              // １画素のビット数 //
    LPLONG,           // エンコードされたライン数を格納するアドレス //
    LPCOMPPARAM,      // 圧縮パラメタ //
    LONG,             // コピー長の下限(2を指定すること) //
    LONG              /* 1ラインの余分なバイト数
                        (上記"1ラインのバイト数"の後ろに続く無効領域の長さ) */
);
DWORD WINAPI FillBlank(LPBYTE, LONG, LONG);

#undef WINAPI
#undef FAR

#if __cplusplus
}
#endif

#endif
