package formats

import (
	"bytes"
	"fmt"
	"strings"
	"testing"
)

var brokenSVG = []byte(`
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<svg
   xmlns:dc="http://purl.org/dc/elements/1.1/"
   xmlns:cc="http://creativecommons.org/ns#"
   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
   xmlns:svg="http://www.w3.org/2000/svg"
   xmlns="http://www.w3.org/2000/svg"
   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
   version="1.1"
   id="svg2"
   width="8.5in"
   height="11in"
   viewBox="0 0 816 1056"
   sodipodi:docname="the_truth.svg"
   inkscape:version="0.92.1 r">
  <metadata
     id="metadata8">
  </metadata>
  <defs
     id="defs6" />
  <sodipodi:namedview
     pagecolor="#ffffff"
     bordercolor="#666666"
     borderopacity="1"
     objecttolerance="10"
     gridtolerance="10"
     guidetolerance="10"
     inkscape:pageopacity="0"
     inkscape:pageshadow="2"
     inkscape:window-width="1920"
     inkscape:window-height="1016"
     id="namedview4"
     showgrid="false"
     units="in"
     inkscape:zoom="0.31508678"
     inkscape:cx="-162.21398"
     inkscape:cy="374.5"
     inkscape:window-x="0"
     inkscape:window-y="27"
     inkscape:window-maximized="1"
     inkscape:current-layer="svg2" />
  <path
     style="fill:#000000;stroke-width:1.40394223"
     d="m 442.57991,1028.4716 c 0,-0.7817 3.31682,-3.6391 7.3707,-6.3496 13.63319,-9.1156 22.73846,-15.9706 36.72247,-27.64734 7.64962,-6.38752 17.12623,-14.05807 21.05913,-17.04565 3.93289,-2.98757 8.48779,-6.93616 10.12196,-8.77464 1.63418,-1.83847 3.45944,-3.34268 4.05613,-3.34268 1.77957,0 18.87188,-15.49026 20.54793,-18.62199 1.06846,-1.99644 -1.44423,-0.79167 -8.09934,3.88339 -10.78865,7.57876 -30.9473,16.75971 -40.1231,18.27348 -3.31527,0.54692 -6.79334,1.61209 -7.72906,2.36702 -1.58949,1.28241 -15.36252,0.8754 -20.0598,-0.59276 -1.15825,-0.36202 -4.00123,-1.12205 -6.31774,-1.68897 -4.7115,-1.15301 -9.30406,-2.92163 -15.20615,-5.85595 -2.18604,-1.08684 -4.5993,-1.97605 -5.36281,-1.97605 -0.76352,0 -4.14296,-1.89532 -7.50988,-4.21183 -3.36692,-2.3165 -6.54209,-4.21182 -7.05594,-4.21182 -0.51384,0 -2.61123,-1.13 -4.66085,-2.5111 -2.04961,-1.3811 -7.20134,-3.68056 -11.44826,-5.10991 -4.24693,-1.42935 -8.32187,-3.14233 -9.05543,-3.80665 -0.73356,-0.6643 -3.57654,-1.22792 -6.31774,-1.25247 -2.7412,-0.0246 -6.21035,-0.97223 -7.70923,-2.10591 -1.49888,-1.1337 -3.98112,-2.06127 -5.51609,-2.06127 -1.53497,0 -5.04692,-0.70687 -7.80433,-1.57082 -9.34185,-2.92696 -24.6578,-8.53722 -26.77458,-9.80754 -1.15826,-0.69511 -3.36946,-1.90347 -4.9138,-2.68527 -1.54434,-0.78178 -4.70321,-2.64744 -7.01971,-4.1459 -2.31651,-1.49847 -6.18841,-3.73589 -8.60423,-4.97206 -2.41581,-1.23615 -5.84275,-3.79141 -7.61542,-5.67833 -1.77266,-1.88691 -3.75014,-3.43075 -4.39439,-3.43075 -4.97215,0 -70.80003,-65.2369 -74.72885,-74.05796 -1.46166,-3.28171 -3.19338,-5.96675 -3.84826,-5.96675 -0.6549,0 -1.19072,-0.89502 -1.19072,-1.98893 0,-1.09389 -0.49845,-2.1995 -1.10764,-2.45689 -1.38679,-0.58593 -14.33573,-27.03298 -14.33573,-29.27945 0,-0.908 -0.90167,-3.64171 -2.00372,-6.07491 -2.38034,-5.25553 -3.2321,-11.56233 -7.13895,-52.86001 -1.84389,-19.49092 -9.1295,-32.96709 -17.31114,-32.0204 l -3.73095,0.4317 0.17065,25.97293 c 0.0939,14.28511 0.88357,30.91489 1.75493,36.95507 0.87136,6.04018 1.58428,23.28266 1.58428,38.31662 0,17.85918 0.68845,30.84228 1.98604,37.45387 1.09233,5.56566 2.37945,13.99897 2.86025,18.74069 0.48083,4.74173 2.1142,12.14928 3.62973,16.46125 1.51554,4.31197 2.75552,8.78939 2.75552,9.94982 0,1.86219 5.37152,14.66912 8.56602,20.42335 9.589,17.27257 13.89246,23.71912 20.13998,30.16955 4.0875,4.22025 8.48431,9.27948 9.77069,11.24276 1.28638,1.96325 5.00114,5.49619 8.25501,7.85095 3.25388,2.35477 9.70677,7.92079 14.33978,12.36895 4.63301,4.44815 9.46398,8.66879 10.73547,9.37919 1.27151,0.71039 7.54556,6.02993 13.94234,11.82119 6.39679,5.79126 16.09664,14.45758 21.55521,19.25878 17.74079,15.6039 20.90873,18.6611 20.13685,19.433 -2.35272,2.3527 -24.95357,-14.7954 -24.95357,-18.9331 0,-0.8292 -0.84618,-1.5075 -1.8804,-1.5075 -1.03421,0 -4.21855,-2.5271 -7.07629,-5.61567 -2.85775,-3.0887 -6.00703,-5.6158 -6.9984,-5.6158 -0.99138,0 -5.69864,-3.94859 -10.4606,-8.77464 -4.76195,-4.82605 -11.6646,-11.43705 -15.33921,-14.6911 -26.36747,-23.34974 -44.52499,-44.07612 -52.62381,-60.06882 -1.17309,-2.31651 -4.1017,-8.00247 -6.50802,-12.63548 -2.40633,-4.63301 -4.75495,-10.63487 -5.2192,-13.33746 -1.04728,-6.09687 -4.38194,-16.06698 -7.40905,-22.1519 -2.07285,-4.16673 -2.45687,-4.374 -4.05491,-2.18857 -0.97085,1.32774 -1.7652,4.44317 -1.7652,6.92319 0,5.22716 -7.57997,28.46704 -11.63373,35.66853 -1.52129,2.70259 -4.3134,10.24242 -6.20469,16.75518 -3.04037,10.46972 -3.36477,13.80359 -2.80043,28.78082 0.35105,9.31669 1.58505,21.67774 2.74223,27.469 1.15718,5.79126 1.90869,10.75083 1.67004,11.02109 -1.4654,1.66016 -3.42861,-2.16277 -3.42861,-6.67642 0,-2.92447 -1.045,-7.41195 -2.32221,-9.97217 -1.8616,-3.7317 -2.30362,-8.77915 -2.22854,-25.44793 0.0981,-21.77954 0.38582,-23.23085 8.86917,-44.73745 5.86413,-14.86644 8.22577,-21.78127 8.27122,-24.218 0.0533,-2.85626 -3.49719,-3.19973 -9.33938,-0.9035 -8.58868,3.37573 -37.34098,6.55529 -40.16336,4.44146 -0.93242,-0.69835 -5.48596,-2.48812 -10.11897,-3.9773 -4.63301,-1.48916 -8.73954,-3.09593 -9.12562,-3.57062 -0.38609,-0.47467 -2.64088,-1.85594 -5.01066,-3.06948 -6.183847,-3.16672 -15.804016,-13.53146 -16.809824,-18.11088 -0.472244,-2.15011 -1.441792,-4.2697 -2.154553,-4.71022 -0.712759,-0.44051 -1.295927,-1.75345 -1.295927,-2.91765 0,-1.16421 -1.737378,-4.3944 -3.860841,-7.17822 -3.465949,-4.54379 -3.870377,-6.2468 -3.954066,-16.65018 -0.05127,-6.37379 -0.796831,-12.4365 -1.656792,-13.47268 -2.285034,-2.7533 -1.172978,-12.03777 2.405581,-20.08403 2.552014,-5.7381 3.010611,-8.83583 2.511862,-16.96719 -0.335579,-5.47112 -1.167767,-10.8412 -1.849306,-11.9335 -1.96082,-3.14264 -2.031157,-5.85738 -0.278804,-10.76067 1.254898,-3.51136 1.233032,-5.66245 -0.09489,-9.33476 -0.949055,-2.62456 -2.118068,-8.97526 -2.597807,-14.11268 -0.786289,-8.42019 -0.540252,-9.7832 2.496475,-13.83029 3.071983,-4.09408 3.368729,-5.82903 3.368729,-19.69559 0,-11.85104 -0.464638,-15.56814 -2.105914,-16.8473 -2.386234,-1.85975 -8.301489,-12.2535 -9.109698,-16.00673 -0.293932,-1.36502 -0.970567,-4.53512 -1.503624,-7.04467 -0.641109,-3.01824 -0.434534,-4.56281 0.610241,-4.56281 0.989207,0 1.579435,-3.05643 1.579435,-8.17891 0,-5.12312 1.319724,-11.95624 3.532297,-18.28911 3.356783,-9.60785 3.525713,-11.55585 3.399797,-39.20415 -0.124488,-27.334 0.769576,-36.73041 4.438072,-46.64321 1.212974,-3.27763 5.468929,-25.91575 8.182153,-43.52221 0.654467,-4.24693 3.785288,-14.35531 6.957378,-22.46308 7.675106,-19.61734 8.017886,-22.00239 4.681536,-32.5741 -7.330517,-23.22789 -7.656389,-34.84585 -1.24896,-44.52812 3.25602,-4.92019 3.75348,-7.11331 3.76099,-16.58083 0.005,-6.93234 0.77337,-12.37693 2.10591,-14.93198 1.17088,-2.24504 2.09727,-7.68995 2.09727,-12.32679 0,-5.69947 1.10128,-10.92201 3.50985,-16.64452 1.93042,-4.58647 3.50986,-10.27857 3.50986,-12.64912 0,-2.37052 1.34276,-6.94207 2.9839,-10.15899 2.58387,-5.06478 2.83585,-7.08067 1.87955,-15.03645 -1.54975,-12.89282 -1.14211,-20.31195 1.38447,-25.19783 2.81034,-5.43459 2.75658,-9.9125 -0.16915,-14.08957 -2.30374,-3.28904 -2.22984,-3.44489 4.21183,-8.88214 7.48683,-6.31945 8.13341,-9.55161 4.15281,-20.75925 -2.29746,-6.46865 -2.29005,-6.89411 0.16747,-9.60965 1.68942,-1.86679 2.36277,-4.26266 1.96317,-6.9853 -0.52775,-3.59576 -0.10093,-4.24542 3.22648,-4.91089 4.91224,-0.98245 10.19081,-7.93277 13.44095,-17.69773 1.93262,-5.80652 3.76189,-8.46402 7.47284,-10.85624 8.66443,-5.58543 8.77809,-5.78983 8.13822,-14.63591 -0.50295,-6.95322 -0.21113,-8.33432 1.90283,-9.00527 2.46448,-0.78219 3.58479,-4.57173 4.3355,-14.66523 0.32447,-4.3625 1.37481,-5.55071 9.49047,-10.73617 15.24582,-9.74125 23.86702,-16.29716 23.86702,-18.14941 0,-2.61979 8.20208,-9.02927 11.55458,-9.02927 1.60353,0 6.17745,-3.000926 10.16426,-6.668725 3.98682,-3.667799 11.11301,-9.98554 15.83597,-14.039423 8.29189,-7.117215 8.87668,-7.370697 17.00462,-7.370697 8.67104,0 11.80757,-1.587269 13.46678,-6.81496 1.0749,-3.386688 6.60546,-5.82052 13.2264,-5.82052 4.90831,0 22.00956,-6.555863 36.8482,-14.125976 5.14721,-2.625905 6.52733,-2.783526 11.69764,-1.335921 5.13792,1.438521 7.67153,1.167757 20.51335,-2.192298 8.05828,-2.108427 18.31478,-4.110631 22.7922,-4.449332 5.92601,-0.448279 8.57937,-1.318091 9.75285,-3.197127 1.14435,-1.832398 2.27711,-2.225389 3.90436,-1.35451 1.26076,0.674749 10.45512,1.193885 20.43191,1.153634 9.97678,-0.04029 22.26606,0.384174 27.30949,0.943126 7.57713,0.839768 9.49688,0.622283 11.05246,-1.252078 2.0856,-2.512986 7.90581,-3.056284 9.26045,-0.864421 1.09915,1.778444 8.52328,1.825097 11.79502,0.07413 1.80643,-0.966769 4.33758,-0.39184 9.27127,2.105913 4.47402,2.265037 9.2169,3.452786 13.91922,3.48575 10.13512,0.07104 20.6898,2.972371 35.00041,9.621062 6.83335,3.174763 14.01325,5.772295 15.95534,5.772295 1.94209,0 6.45954,1.472005 10.03879,3.271115 19.10379,9.60253 30.31879,13.627548 41.4485,14.875695 11.60652,1.301623 13.17015,1.979966 22.68192,9.840035 3.79896,3.139271 7.5749,5.707769 8.391,5.707769 5.88766,0 26.45086,15.186483 35.13795,25.950344 5.74127,7.11379 12.91115,11.76492 18.32683,11.88866 1.62318,0.0371 5.09794,1.64854 7.72168,3.581 2.62373,1.93245 5.87603,3.90147 7.22733,4.37557 1.35129,0.47411 2.4569,1.48152 2.4569,2.23871 0,0.75719 4.10653,5.63034 9.12562,10.82921 8.44658,8.74914 9.12562,9.91711 9.12562,15.6962 0,4.99726 0.77074,6.96674 3.86085,9.86571 7.79263,7.31064 10.04164,10.5611 9.29162,13.42916 -0.4545,1.73801 0.05,3.14642 1.29854,3.62555 1.12297,0.43092 2.49037,3.17482 3.03868,6.09755 0.54831,2.92273 2.5234,7.12818 4.3891,9.34543 3.67112,4.36289 4.29644,6.62382 1.83199,6.62382 -1.01479,0 -1.24631,1.67317 -0.6623,4.78621 0.57868,3.08456 0.0726,6.84888 -1.42344,10.58782 -1.27673,3.19088 -1.95361,6.16933 -1.50417,6.61877 1.90543,1.90543 5.06278,-1.14644 5.92146,-5.72365 0.50947,-2.71567 1.83862,-5.69472 2.95369,-6.62015 1.74993,-1.45232 1.97277,0.41417 1.62836,13.63842 -0.21946,8.42655 0.0406,20.49843 0.5779,26.82639 0.9104,10.72175 0.72685,11.96486 -2.69482,18.25125 -2.01947,3.71022 -5.31121,8.5257 -7.31498,10.70107 l -3.6432,3.9552 v 29.7394 c 0,21.22005 -0.50272,30.61788 -1.75493,32.80598 -2.78077,4.85914 -2.23451,17.79119 0.91585,21.68174 2.31919,2.86405 2.43052,3.76288 0.84571,6.82756 -1.00379,1.94112 -3.21798,4.78988 -4.92043,6.33056 -5.41193,4.89774 -7.46109,10.83427 -8.55756,24.7917 -0.58589,7.45809 -1.97157,15.35527 -3.07929,17.54928 -1.10773,2.19401 -2.37004,8.41153 -2.80515,13.81671 -0.5601,6.95805 -1.8841,11.77912 -4.53441,16.51116 -3.07625,5.49255 -3.66672,8.11946 -3.31353,14.7414 0.36354,6.8159 -0.14817,8.92337 -3.32005,13.67359 -2.06242,3.08868 -4.18093,8.34321 -4.70779,11.67675 -0.99762,6.31197 -3.59285,10.08436 -6.93756,10.08436 -2.37654,0 -4.86292,4.32841 -4.86292,8.46562 0,1.66893 -1.41676,5.02409 -3.14834,7.45587 -2.68368,3.76888 -3.21784,6.59816 -3.61917,19.16995 -0.25894,8.11168 0.24402,18.53915 1.11769,23.17216 0.87368,4.63301 2.16599,12.84608 2.87182,18.25125 1.83557,14.05657 2.05688,15.2829 3.04236,16.85836 1.2753,2.03878 1.79483,55.08624 0.60489,61.76241 -0.55052,3.08867 -1.31201,7.64872 -1.69222,10.13344 -0.3802,2.48473 -1.65925,5.48566 -2.84232,6.66873 -1.18307,1.18307 -1.56527,2.15105 -0.84931,2.15105 1.66426,0 -1.35644,17.43901 -5.10686,29.48279 -8.3434,26.79325 -10.03373,32.6829 -10.03373,34.96067 0,1.37313 -1.334,7.49392 -2.96444,13.60175 -1.63044,6.10782 -3.42475,13.63222 -3.98737,16.72089 -0.5626,3.08868 -2.12595,8.14287 -3.47409,11.23154 -4.13629,9.47642 -8.76611,23.85263 -8.21456,25.5073 0.28752,0.86253 -2.03439,5.52461 -5.15979,10.36021 -3.1254,4.8356 -5.70263,10.11555 -5.72719,11.73321 -0.0246,1.61766 -0.97223,4.16756 -2.10591,5.66644 -1.1337,1.49887 -2.06127,4.12048 -2.06127,5.82578 0,1.7053 -2.5271,6.46379 -5.61577,10.57444 -6.26044,8.33186 -6.46192,9.15944 -3.60469,14.80637 3.0727,6.07274 7.81652,18.85001 7.81652,21.05343 0,1.07963 1.3323,5.89165 2.96067,10.69334 2.68635,7.92143 2.89284,10.8767 2.22859,31.89539 -0.4475,14.16018 -1.54815,26.02701 -2.83141,30.52743 -1.15463,4.04932 -1.80518,8.48724 -1.44565,9.86205 0.35952,1.3748 -0.32653,4.37943 -1.52456,6.67698 -1.19802,2.29755 -2.18212,6.02783 -2.18688,8.28958 -0.004,2.26161 -0.5822,6.05235 -1.28321,8.42362 -0.70101,2.3713 -2.39422,8.1022 -3.76268,12.7352 -3.27095,11.074 -5.83543,16.1453 -8.16436,16.1453 -2.82687,0 -5.47984,-3.7943 -4.12893,-5.9053 2.03096,-3.1734 4.65201,-11.5265 4.67391,-14.8951 0.0112,-1.7882 0.67767,-4.478 1.48009,-5.9773 2.25774,-4.21847 7.95473,-28.47537 10.5273,-44.82333 3.57411,-22.71251 2.93154,-38.46679 -2.29052,-56.15769 -2.39328,-8.10776 -5.238,-15.73879 -6.3216,-16.95785 -1.08359,-1.21906 -1.97018,-2.59941 -1.97018,-3.06747 0,-0.46806 -0.61155,-2.45951 -1.35901,-4.42545 -1.76409,-4.63995 -4.6357,-3.49882 -6.89111,2.73841 -0.96758,2.67578 -2.34163,4.86506 -3.05346,4.86506 -0.71183,0 -2.26773,2.32991 -3.45756,5.1776 -4.00414,9.58325 -13.45768,22.75814 -29.46063,41.05773 -6.43692,7.36068 -17.96538,17.74431 -33.32732,30.01774 -2.11317,1.68831 -5.58792,4.55586 -7.72168,6.37233 -2.13377,1.81647 -8.70605,6.70706 -14.6051,10.86801 -5.89904,4.16088 -11.09135,8.51872 -11.53847,9.68385 -0.44711,1.16513 -2.02364,2.11841 -3.50341,2.11841 -1.47975,0 -3.69909,1.53928 -4.93186,3.42084 -1.23276,1.88144 -3.77744,4.25054 -5.65483,5.26474 -1.87738,1.01407 -9.16383,6.26637 -16.19207,11.67157 -21.81634,16.7782 -25.21441,18.9532 -29.61042,18.9532 -2.30223,0 -4.18586,-0.6396 -4.18586,-1.4214 z m 28.07885,-84.94336 c 2.70259,-0.3848 6.17734,-1.23934 7.72168,-1.89898 1.54434,-0.65963 5.19615,-2.23345 8.11512,-3.49738 4.18151,-1.81061 6.56388,-2.00806 11.23154,-0.93089 10.20547,2.35512 25.23811,1.74222 32.06975,-1.30752 6.93605,-3.09637 16.43724,-12.36923 20.2053,-19.71976 2.68165,-5.23123 10.50766,-15.83279 12.26384,-16.61332 0.57913,-0.25739 1.05296,-1.32699 1.05296,-2.37687 0,-1.0499 3.47475,-5.66206 7.72168,-10.24924 4.24693,-4.58719 7.72168,-8.73137 7.72168,-9.2093 0,-0.47793 2.5271,-3.15205 5.61577,-5.94247 3.08867,-2.79043 5.61577,-5.56587 5.61577,-6.16764 0,-0.60177 4.17163,-5.32781 9.2703,-10.50232 6.75754,-6.85806 8.85054,-9.82795 7.72168,-10.9568 -2.42001,-2.42002 -1.94368,-4.41239 4.18678,-17.51223 3.15447,-6.74059 7.18093,-15.4145 8.94771,-19.27534 1.76677,-3.86084 4.87182,-10.61264 6.90008,-15.004 2.02827,-4.39136 3.68778,-8.3525 3.68778,-8.80254 0,-0.45003 1.46029,-3.17484 3.24508,-6.05513 1.78481,-2.88028 4.13179,-7.43289 5.21552,-10.1169 1.08373,-2.68401 5.40818,-11.21295 9.6099,-18.95323 4.20171,-7.74025 9.21864,-17.23207 11.14874,-21.09291 1.93008,-3.86084 4.24675,-7.96737 5.14815,-9.12562 0.90141,-1.15826 3.10931,-6.84422 4.90647,-12.63548 1.79716,-5.79127 3.76486,-11.79312 4.37265,-13.33745 0.6078,-1.54434 2.52947,-8.80974 4.27039,-16.14534 2.746,-11.57065 3.13823,-16.77808 2.96093,-39.31038 -0.30883,-39.24846 -2.08673,-62.98111 -5.36389,-71.60106 -2.54844,-6.70316 -3.28176,-24.07521 -1.31864,-31.23772 1.01279,-3.69519 0.84034,-3.86084 -4.01928,-3.86084 -3.31983,0 -5.07747,-0.65432 -5.07747,-1.89021 0,-2.32066 -3.73423,-10.1203 -7.31222,-15.27298 -2.52207,-3.63201 -10.57067,-7.06245 -17.25677,-7.35507 -1.54433,-0.0677 -11.33683,0.52511 -21.7611,1.31713 -15.27133,1.16028 -18.95322,1.84912 -18.95322,3.54594 0,1.59791 2.53998,2.34151 10.52956,3.08258 15.27495,1.4168 15.30269,1.42401 25.27097,6.55995 10.72248,5.52451 15.44336,9.51845 15.44336,13.06527 0,3.67968 -2.44636,3.17146 -7.93618,-1.64866 -6.36085,-5.5849 -8.91113,-5.47341 -8.91113,0.38958 0,14.29772 -19.94621,20.50987 -47.03206,14.64792 -18.65747,-4.03787 -21.32006,-4.23164 -26.00845,-1.89277 -3.45393,1.72306 -5.06228,1.83475 -7.8869,0.54777 -3.54202,-1.61386 -3.65364,-2.34775 -1.64194,-10.79687 0.7412,-3.11305 -2.40114,-3.12479 -6.34353,-0.0237 -3.52015,2.76898 -3.74731,3.65071 -3.74731,14.54528 0,6.3787 0.43947,12.03709 0.9766,12.57422 1.12568,1.12568 1.40258,2.11852 2.99059,10.72292 1.83204,9.92669 10.86817,36.96073 18.0668,54.05178 8.21197,19.49694 10.9466,31.53285 7.63013,33.58254 -0.67243,0.41559 -1.60744,2.67984 -2.07782,5.03167 -0.53853,2.69275 -3.69927,6.95319 -8.53616,11.50618 -4.22453,3.97655 -7.35877,7.75144 -6.96496,8.38862 0.39381,0.6372 3.85789,1.15854 7.69797,1.15854 8.90884,0 14.98988,2.57022 21.19317,8.95754 2.71451,2.79504 5.40588,5.08188 5.98085,5.08188 0.57496,0 2.74517,1.21035 4.8227,2.68967 4.3766,3.11643 19.93346,8.63819 21.53985,7.64539 2.09894,-1.29721 1.05269,-5.06819 -3.1226,-11.2548 -2.31651,-3.4324 -4.21183,-6.84083 -4.21183,-7.5743 0,-0.73346 -0.63177,-1.33356 -1.40394,-1.33356 -0.77217,0 -1.40394,-0.9916 -1.40394,-2.20356 0,-1.46387 1.02437,-2.05297 3.05167,-1.75492 3.9711,0.58378 14.46676,15.38795 16.51052,23.2881 0.85259,3.2957 3.84961,8.53739 6.66005,11.6482 4.99062,5.52402 8.50262,14.48529 9.87915,25.2077 0.79408,6.18552 -1.77524,8.67626 -11.97804,11.61172 l -7.46537,2.14787 -4.65349,-4.08583 c -2.55942,-2.2472 -5.14895,-4.08582 -5.75449,-4.08582 -0.60555,0 -9.99875,4.36077 -20.87379,9.69059 -31.68178,15.52715 -44.73816,21.4869 -47.81179,21.82431 -1.58086,0.17352 -4.13187,0.97275 -5.66891,1.77604 -3.04769,1.5928 -19.51436,3.68868 -27.36359,3.48284 -14.40353,-0.3777 -39.5389,-2.92007 -41.06485,-4.15357 -0.96546,-0.78044 -3.9666,-1.23216 -6.66919,-1.00382 -2.70258,0.22834 -5.59948,-0.14933 -6.43755,-0.83926 -0.83805,-0.68993 -5.26047,-2.10308 -9.82759,-3.14033 -9.10776,-2.06848 -10.92489,-4.97271 -4.2314,-6.76282 3.18676,-0.85226 5.47675,-0.26357 10.52957,2.70687 4.80273,2.82344 8.4355,3.82071 14.1788,3.89234 4.24693,0.0529 10.45259,1.17126 13.79036,2.4851 9.20481,3.62327 38.0719,1.96726 59.37553,-3.40615 11.93913,-3.0114 16.33025,-11.98535 8.61375,-17.60352 -6.30914,-4.59352 -6.6987,-4.682 -10.93597,-2.48367 -3.65916,1.89841 -4.58824,1.87388 -9.2873,-0.24511 -4.17625,-1.88322 -7.34324,-2.15568 -15.82177,-1.36117 -8.78733,0.82344 -10.98722,0.60649 -12.86213,-1.26842 -1.5,-1.50002 -3.75201,-2.03252 -6.68656,-1.58108 -2.43365,0.37436 -7.94852,1.05496 -12.25526,1.51242 -7.70862,0.81881 -7.92336,0.74161 -13.80052,-4.96198 -5.81761,-5.6458 -9.95772,-6.55764 -9.95772,-2.19314 0,4.28281 -5.83101,6.44142 -17.40014,6.44142 -12.01896,0 -16.29448,1.96209 -16.29448,7.47774 0,3.31207 3.81797,7.96562 6.53534,7.96562 1.03856,0 1.88831,0.94766 1.88831,2.10591 0,2.75912 -1.50446,2.65747 -8.73708,-0.59026 -18.73283,-8.41177 -22.34454,-9.9393 -23.50057,-9.9393 -0.7008,0 -3.05268,-0.75523 -5.2264,-1.67826 -2.17374,-0.92305 -4.58402,-1.77054 -5.35618,-1.88332 -0.77217,-0.11274 -3.07328,-0.67253 -5.11358,-1.24388 -4.17399,-1.16884 -10.13491,1.34005 -14.41154,6.06566 -1.64093,1.81321 -4.38217,2.95162 -7.10736,2.95162 -13.90026,0 -8.67188,-31.96713 7.42844,-45.41858 3.82159,-3.19285 9.97136,-6.22225 17.33873,-8.54112 6.27919,-1.97637 13.48995,-5.17477 16.02394,-7.10753 2.53397,-1.93275 5.56094,-3.51411 6.72658,-3.51411 1.16564,0 4.20871,-1.19755 6.7624,-2.66121 2.55368,-1.46368 8.2658,-3.08733 12.6936,-3.60812 4.42779,-0.52079 8.41367,-1.53446 8.85749,-2.25259 0.44382,-0.71811 2.20871,-1.30568 3.92195,-1.30568 1.71323,0 4.15793,-1.21807 5.43264,-2.70682 3.18859,-3.724 12.48303,-4.84908 32.45667,-3.92884 11.52345,0.53093 17.63845,0.26504 19.41459,-0.84419 1.97812,-1.23536 3.25394,-1.20634 5.38163,0.12242 1.53386,0.95791 3.75082,1.74167 4.92657,1.74167 1.17576,0 4.18527,1.98142 6.68778,4.40315 5.88777,5.69772 14.39666,9.5666 21.1253,9.60544 5.01145,0.0289 5.52161,-0.3713 8.20433,-6.43604 3.11763,-7.0479 1.92771,-11.09495 -2.24416,-7.6326 -1.35553,1.12499 -3.84677,1.45132 -6.72822,0.88132 -2.51662,-0.49781 -6.36927,-0.87193 -8.56142,-0.83138 -2.19216,0.0406 -8.19401,-2.06592 -13.33745,-4.68106 -8.47329,-4.30816 -10.76236,-4.8167 -24.36963,-5.41389 -9.51091,-0.41741 -15.83928,-1.34075 -17.2578,-2.51801 -3.06927,-2.54728 -0.63469,-4.68913 5.14323,-4.52484 2.52273,0.0717 5.39031,-0.53646 6.37241,-1.35153 3.28276,-2.72445 17.05574,0.19162 29.05056,6.15068 9.13615,4.53888 13.29186,5.76609 21.19231,6.25827 8.39527,0.523 10.63273,0.14181 15.35177,-2.6154 3.0383,-1.77519 7.77661,-6.3651 10.52957,-10.19978 4.33273,-6.03519 4.996,-8.01625 4.93546,-14.7414 -0.0458,-5.08291 -1.42443,-11.16725 -3.98735,-17.59683 -2.15459,-5.40518 -4.69139,-12.35469 -5.63731,-15.44336 -0.94593,-3.08868 -2.56599,-7.51109 -3.60017,-9.8276 -1.03417,-2.3165 -3.00921,-6.73892 -4.38899,-9.82759 -1.37976,-3.08868 -2.94874,-7.5111 -3.4866,-9.8276 -0.53785,-2.3165 -1.4661,-4.8436 -2.06276,-5.61577 -2.70632,-3.50237 -5.72842,-25.04411 -5.81031,-41.4163 -0.0765,-15.29647 0.31082,-18.39641 3.01724,-24.14849 1.70775,-3.62957 4.49692,-8.05199 6.19814,-9.8276 1.70122,-1.7756 4.14293,-4.89695 5.42601,-6.93631 1.28309,-2.03937 6.83906,-6.70365 12.34663,-10.36507 9.26571,-6.15983 10.92262,-6.74725 22.17992,-7.86329 6.69138,-0.66339 15.00914,-1.82438 18.48389,-2.57999 3.47476,-0.7556 10.10839,-1.95666 14.7414,-2.66899 7.52195,-1.15654 13.67692,-2.66772 30.18476,-7.41106 6.30944,-1.81296 11.96648,0.25264 17.12836,6.25414 3.23255,3.75836 4.07814,4.13786 5.27912,2.36926 0.78653,-1.15825 1.04408,-3.05357 0.57236,-4.21182 -5.59762,-13.74423 -6.18638,-16.44913 -5.34771,-24.56899 0.54754,-5.30118 0.0236,-13.39156 -1.41346,-21.8258 -2.34177,-13.74423 -1.74445,-27.60658 1.87258,-43.45752 3.98533,-17.46493 0.55474,-34.41519 -9.22049,-45.55769 -17.46217,-19.90464 -24.59669,-25.99861 -36.03136,-30.77632 -8.89897,-3.71823 -48.05329,-3.37886 -67.60551,0.58598 -18.60977,3.77372 -60.05402,4.95868 -62.68199,1.79217 -1.13931,-1.37279 -0.60844,-2.15043 2.19586,-3.21663 6.16669,-2.34457 6.16851,-5.56428 0.006,-10.87698 -9.00657,-7.76472 -37.41197,-21.16549 -41.67959,-19.66309 -0.95268,0.33538 -3.28308,0.0351 -5.17865,-0.66719 -1.89559,-0.70234 -7.58156,-1.84885 -12.63548,-2.54781 -5.05394,-0.69896 -14.79485,-2.5502 -21.64648,-4.11386 -9.425,-2.15095 -13.86787,-2.53599 -18.25125,-1.5817 -10.27236,2.23632 -27.82238,4.44429 -45.8061,5.76284 -39.45071,2.89252 -51.80543,4.29834 -63.1653,7.18747 -23.39528,5.95009 -31.07723,14.38426 -33.04755,36.28358 -0.59054,6.56343 -1.37293,14.46061 -1.73867,17.54928 -1.62228,13.70027 -0.0863,29.41381 4.10955,42.04473 1.77361,5.33904 3.1498,14.70495 3.81635,25.97293 1.01122,17.09442 0.92826,17.9083 -2.76674,27.14372 -2.09506,5.23651 -6.25154,12.8178 -9.23664,16.84731 -2.98509,4.02952 -7.31043,10.11872 -9.61184,13.53155 -2.30141,3.41281 -7.18532,10.64427 -10.85312,16.06988 -3.6678,5.42562 -6.66873,10.86374 -6.66873,12.08472 0,1.22096 -0.84295,3.46614 -1.87325,4.98923 -1.03028,1.52311 -2.70551,5.92816 -3.72271,9.789 -1.01721,3.86084 -2.64202,8.59915 -3.61071,10.52957 -0.96869,1.93042 -2.80518,6.47071 -4.08108,10.08953 -2.15046,6.0993 -2.15195,6.90431 -0.0204,11.02625 1.88497,3.64511 2.17981,7.52025 1.63581,21.49917 -0.365,9.37893 -1.10922,18.94792 -1.65385,21.26442 -0.54461,2.31651 -1.49431,10.52957 -2.11044,18.25125 -0.61614,7.72168 -1.54633,15.68268 -2.06713,17.69112 -0.52079,2.00842 -0.2613,7.43248 0.57664,12.05346 0.83793,4.62097 1.5516,20.62012 1.5859,35.55369 0.0386,16.83654 0.64538,28.24128 1.59697,30.01934 0.84403,1.5771 2.01398,6.67854 2.59989,11.33656 0.58589,4.658 1.70593,10.99619 2.48895,14.08487 0.78302,3.08867 1.78211,11.61762 2.22019,18.95322 0.91504,15.32158 2.53097,26.61068 5.52645,38.60841 2.93085,11.73881 8.66752,26.45326 10.55908,27.08379 0.86967,0.28988 1.58123,1.20883 1.58123,2.0421 0,1.46612 7.58904,14.08697 10.50014,17.46211 0.78836,0.91402 3.29194,4.23083 5.56353,7.37069 2.27158,3.13988 4.64073,5.70886 5.26479,5.70886 0.62403,0 1.13462,0.6885 1.13462,1.53003 0,3.79586 36.45002,39.46355 51.51251,50.4069 3.7131,2.69767 7.06698,5.2809 7.45306,5.7405 1.53128,1.82287 34.90882,20.80996 42.82024,24.35865 4.63301,2.07815 9.52068,4.37106 10.8615,5.09537 1.34083,0.7243 3.68854,1.31691 5.21715,1.31691 1.52863,0 4.85401,0.88694 7.38975,1.97098 2.53575,1.08404 7.13755,2.65631 10.22622,3.49395 3.08867,0.83762 11.83095,3.48745 19.42729,5.8885 7.59634,2.40105 17.07295,4.88632 21.05913,5.52282 3.98619,0.63651 10.0906,1.87912 13.56536,2.76138 3.47475,0.88223 7.69839,1.34253 9.38584,1.02285 1.68747,-0.31966 3.89868,-0.0299 4.9138,0.64392 1.01513,0.67384 3.42513,0.88875 5.35555,0.47761 1.93042,-0.41115 5.72106,-1.06238 8.42365,-1.44719 z m 29.48279,-110.38417 c -8.82961,-1.25646 -14.46067,-3.17259 -15.11789,-5.14428 -0.41617,-1.24849 4.46386,-1.67839 19.05224,-1.67839 14.6661,0 20.62579,-0.52888 23.63302,-2.09726 2.21173,-1.1535 5.06863,-2.10116 6.34866,-2.10592 4.53396,-0.0168 16.66322,-7.49389 23.65683,-14.58315 5.80414,-5.88353 7.33293,-6.80476 8.43149,-5.08069 1.96355,3.08156 1.73561,3.98872 -1.92097,7.64531 -1.81824,1.81823 -3.66403,4.23922 -4.10179,5.38001 -0.95356,2.48493 -21.26161,15.05353 -24.32316,15.05353 -1.18163,0 -3.21249,0.56285 -4.51301,1.2508 -3.0912,1.63514 -23.07867,2.50794 -31.14542,1.36004 z M 348.51578,727.14626 c 0,-5.06305 6.51192,-14.83362 14.61292,-21.92542 16.32739,-14.29334 30.44018,-22.55104 25.77559,-15.08184 -0.96445,1.54434 -2.27885,2.80789 -2.92087,2.80789 -4.63242,0 -34.65975,30.09829 -34.65975,34.74164 0,0.96847 -0.63178,1.76086 -1.40395,1.76086 -0.77216,0 -1.40394,-1.03641 -1.40394,-2.30313 z m 20.5163,-187.39901 c -7.43399,-1.1444 -12.21892,-4.0419 -6.6748,-4.0419 6.32554,0 1.45581,-2.4723 -6.1047,-3.09927 -5.39029,-0.447 -8.74689,-1.57204 -10.99695,-3.68585 -2.51586,-2.36354 -4.97125,-3.04247 -11.00314,-3.04247 -5.88482,0 -8.35762,-0.65528 -10.21411,-2.70668 -2.35917,-2.60685 -2.2766,-2.79418 2.23931,-5.07953 2.57884,-1.30508 6.58413,-3.78065 8.90064,-5.50125 2.3165,-1.7206 7.68658,-4.20683 11.93351,-5.52493 4.24692,-1.31811 8.81871,-2.99463 10.15953,-3.72559 1.34082,-0.73098 14.18689,-1.32904 28.54682,-1.32904 20.26286,0 25.97814,-0.39295 25.52467,-1.75493 -0.32138,-0.96521 -1.79552,-1.95579 -3.27588,-2.2013 -1.48034,-0.24549 -4.58686,-1.2849 -6.90336,-2.30979 -2.31651,-1.02491 -8.95014,-2.62818 -14.7414,-3.56286 -5.79126,-0.93468 -13.97911,-2.5803 -18.19523,-3.65696 -13.17684,-3.36488 -24.68028,-2.25502 -34.71129,3.34898 -1.68662,0.94227 -4.00457,1.7132 -5.15101,1.7132 -1.14645,0 -3.87301,0.88066 -6.05905,1.957 -2.18604,1.07635 -7.13349,3.35301 -10.99433,5.05925 -3.86084,1.70624 -9.73642,4.93212 -13.05684,7.16863 -7.31487,4.92699 -8.70426,5.04946 -8.70426,0.76717 0,-4.81366 6.10378,-12.43944 22.77997,-28.46027 12.89991,-12.39295 15.71549,-14.43187 22.01673,-15.94351 3.97389,-0.95332 9.2614,-1.39538 11.75002,-0.98235 8.51591,1.41336 12.9492,2.72251 15.05433,4.44553 4.42771,3.62401 18.63534,5.68104 34.74757,5.03084 3.75,-0.15133 30.30763,2.30252 36.81065,3.40121 3.16491,0.5347 7.47021,1.78217 9.56734,2.77215 2.09712,0.98998 7.18051,3.27757 11.29641,5.08353 5.92375,2.59919 8.04519,4.44621 10.17858,8.86181 3.25263,6.73215 3.55405,16.62966 0.5816,19.09658 -2.47925,2.05759 -12.47136,0.87286 -16.8603,-1.99907 -4.27854,-2.7997 -11.91291,-4.19516 -11.91291,-2.17752 0,2.24371 5.8762,8.32749 8.07267,8.35784 0.96521,0.014 1.75493,1.28781 1.75493,2.83215 0,3.95708 -2.96384,3.49282 -9.16554,-1.43568 -5.88604,-4.67762 -10.66147,-6.35726 -14.20668,-4.99684 -2.04134,0.78335 -1.92824,1.30636 0.94357,4.36325 1.7946,1.91026 3.82671,3.47321 4.5158,3.47321 1.95814,0 10.87852,7.17699 12.35927,9.9438 2.78503,5.20388 0.35905,6.73429 -10.23943,6.45948 -11.02663,-0.28591 -14.18145,-2.76363 -6.79669,-5.33797 2.38614,-0.83182 4.33845,-2.31374 4.33845,-3.29316 0,-2.93398 -12.15765,-11.48528 -19.08751,-13.42552 -8.42681,-2.35937 -13.42024,-0.68984 -15.31109,5.11915 -0.77327,2.37563 -2.26315,5.3522 -3.31083,6.61457 -2.51947,3.03577 -11.59161,5.54971 -13.42199,3.71932 -0.75681,-0.75681 -2.46053,-1.37602 -3.78602,-1.37602 -1.3255,0 -3.68123,-1.73738 -5.23496,-3.86084 -2.46986,-3.37553 -2.94421,-3.5532 -3.77352,-1.41343 -1.1071,2.85649 5.13449,10.84111 10.50502,13.43866 4.894,2.36706 22.10079,2.05749 30.90116,-0.55593 6.16335,-1.83032 7.67577,-1.89183 8.63187,-0.35099 0.8248,1.32921 0.0588,2.13277 -2.65504,2.78539 -6.15954,1.48125 -34.10722,2.16629 -41.56156,1.01875 z m -9.28476,-10.58986 c 0,-0.5127 -1.07079,-3.35918 -2.37953,-6.3255 -1.94043,-4.39809 -2.91194,-5.23016 -5.26478,-4.50917 -3.97493,1.21806 -4.04215,1.33956 -3.01187,5.44452 0.50193,1.99982 2.31518,4.2004 4.02946,4.8902 3.81527,1.53519 6.62672,1.7473 6.62672,0.49995 z m 25.00411,-7.74802 c 0.57469,-4.97437 -4.06511,-7.84639 -7.35733,-4.55417 -2.65344,2.65343 -2.8043,5.05221 -0.46489,7.39163 2.94722,2.94721 7.33793,1.3545 7.82222,-2.83746 z m 169.26679,-53.62218 c 0.50904,-1.44916 0.20548,-3.50243 -0.67455,-4.56281 -0.9582,-1.15456 -1.03688,-1.92797 -0.19613,-1.92797 0.77217,0 2.21674,0.97936 3.21017,2.17638 1.49806,1.80505 1.37362,2.58355 -0.72938,4.56281 -2.39459,2.25371 -2.48415,2.23989 -1.61011,-0.24841 z m 7.5458,1.00307 c 2.27774,-0.91909 2.28068,-7.08461 0.004,-7.84358 -1.07926,-0.35976 -0.54059,-1.23163 1.40394,-2.27231 3.05531,-1.63515 3.15514,-1.48711 3.15514,4.67857 0,5.69982 -0.33106,6.35552 -3.15887,6.25629 -1.73738,-0.0609 -2.36915,-0.4295 -1.40394,-0.81897 z m -23.69512,-2.93103 c -1.73551,-2.21295 -1.68898,-2.27066 0.46858,-0.58111 3.21621,2.51856 5.32628,0.94116 5.32628,-3.98171 0,-4.77765 -1.83183,-6.37759 -4.1306,-3.60772 -1.28973,1.55402 -1.09843,2.29268 0.89388,3.4517 2.19986,1.27977 2.22999,1.48022 0.22805,1.51727 -3.17967,0.0588 -4.54662,-4.23524 -2.12051,-6.66135 3.0277,-3.0277 7.93706,0.10754 7.93706,5.0687 0,6.68099 -4.95669,9.44329 -8.60274,4.79422 z m 10.55356,0.45309 c -2.33498,-6.08488 2.81916,-12.8426 7.09105,-9.29724 1.24164,1.03046 1.94163,2.18946 1.55555,2.57554 -0.38608,0.38609 -1.65742,-0.091 -2.8252,-1.06014 -1.73662,-1.44128 -2.28306,-1.34561 -3.00101,0.52531 -0.48277,1.2581 -0.57786,3.85635 -0.21129,5.7739 0.70857,3.70664 -1.31451,4.85626 -2.6091,1.48263 z m -22.90269,-1.3768 c -1.00214,-1.20751 -1.26608,-2.89016 -0.61622,-3.9286 0.62519,-0.99903 1.15341,-2.76408 1.17382,-3.92233 0.051,-2.89189 5.49022,-3.43544 7.70256,-0.76973 1.10728,1.33419 1.22886,2.17367 0.31481,2.17367 -0.81905,0 -1.37024,1.73673 -1.22486,3.85941 0.20197,2.94917 -0.42691,3.95851 -2.66643,4.27958 -1.6119,0.23109 -3.71955,-0.53031 -4.68368,-1.692 z m 6.11216,-0.67214 c 0.42316,-0.68468 -0.11512,-1.97891 -1.19609,-2.87606 -2.18837,-1.81618 -4.42927,0.27076 -2.91742,2.71698 1.0743,1.73825 3.08936,1.81618 4.11351,0.15908 z m 0.0983,-7.17879 c -0.47723,-0.77217 -1.46218,-1.40395 -2.18878,-1.40395 -0.72659,0 -1.32108,0.63178 -1.32108,1.40395 0,0.77216 0.98495,1.40394 2.18878,1.40394 1.20382,0 1.7983,-0.63178 1.32108,-1.40394 z m 52.64783,9.45616 c 0,-0.20427 2.50715,-25.63317 5.57143,-56.50867 3.06429,-30.87549 5.95755,-60.08584 6.42948,-64.91189 0.47194,-4.82605 1.46818,-8.77464 2.21388,-8.77464 0.74625,0 1.0214,2.0514 0.61199,4.56281 -0.40911,2.50955 -1.99862,17.83007 -3.53226,34.0456 -1.53364,16.21554 -4.07053,42.8676 -5.63753,59.22682 -1.56701,16.35922 -2.8491,30.41619 -2.8491,31.23772 0,0.82152 -0.63178,1.49368 -1.40395,1.49368 -0.77216,0 -1.40394,-0.16714 -1.40394,-0.37143 z m 4.63552,-5.59532 c 0.44296,-3.28172 2.14528,-20.18167 3.78295,-37.55546 7.82985,-83.0653 8.40284,-87.81201 10.32381,-85.52349 0.27006,0.32175 -1.55325,20.48587 -4.05182,44.80917 -2.49855,24.3233 -5.33365,53.22696 -6.30019,64.23035 -0.98411,11.20323 -2.37398,20.00618 -3.15873,20.00618 -0.83904,0 -1.0782,-2.3943 -0.59602,-5.96675 z m -75.40926,3.36168 c -0.40829,-0.66062 0.81798,-0.90286 2.72503,-0.53831 2.53062,0.48377 3.46737,0.0497 3.46737,-1.60674 0,-1.24828 -0.78972,-2.28968 -1.75493,-2.31423 -1.00365,-0.0256 -0.61087,-0.91055 0.91748,-2.0673 2.80589,-2.12366 2.38712,-2.53055 -4.07635,-3.96074 -1.75197,-0.38766 -1.12317,-0.68256 1.67207,-0.78417 4.97599,-0.18089 7.07888,1.8191 4.79993,4.56506 -1.06368,1.28165 -1.00105,2.28737 0.21839,3.5068 1.34375,1.34376 1.26147,1.99324 -0.38439,3.03378 -2.6271,1.66091 -6.60682,1.74793 -7.5846,0.16585 z m -11.13928,-2.77026 c -3.20282,-3.53907 -2.91881,-5.40141 1.23917,-8.12583 3.36133,-2.20244 3.67621,-2.18443 5.57113,0.31861 2.68946,3.55257 2.58847,5.28354 -0.46972,8.05116 -3.21184,2.90668 -3.49933,2.89561 -6.34058,-0.24394 z m 5.39817,-3.04832 c 0,-1.80172 -0.78938,-3.53899 -1.75419,-3.86059 -2.15232,-0.71744 -3.76912,3.05509 -2.6071,6.08325 1.23506,3.21854 4.36129,1.62531 4.36129,-2.22266 z m -57.49955,-1.81413 c -2.50424,-3.82194 -1.69678,-7.4155 2.12593,-9.46135 1.98794,-1.06391 3.03365,-0.69314 4.68185,1.66 2.23821,3.19547 1.4471,6.20852 -2.48746,9.47392 -1.7181,1.42588 -2.48456,1.12916 -4.32032,-1.67257 z m 5.9789,-4.22135 c -0.23387,-1.57862 -1.2146,-3.13017 -2.1794,-3.44791 -2.10756,-0.69408 -3.77759,3.04005 -2.66099,5.94986 1.18154,3.07907 5.34815,0.92541 4.84039,-2.50195 z m 5.65576,4.98252 c -2.60006,-3.07729 -1.93523,-6.2156 1.81252,-8.55613 2.47052,-1.54285 3.17606,-1.43435 4.82607,0.74215 2.40762,3.17589 2.53379,6.38946 0.3371,8.58615 -2.34682,2.34682 -4.54608,2.10337 -6.97569,-0.77217 z m 5.5948,-3.61813 c 0.30262,-2.55622 -0.20898,-3.75257 -1.60472,-3.75257 -2.47131,0 -3.97938,3.39308 -2.83431,6.37708 1.24308,3.2394 3.93313,1.64894 4.43903,-2.62451 z m -29.43972,1.25076 c -2.71794,-5.96525 1.99607,-11.57604 6.55028,-7.79637 2.82929,2.34809 2.62805,6.08098 -0.47941,8.89319 -3.41601,3.09145 -4.22953,2.94447 -6.07087,-1.09682 z m 5.68308,-1.9201 c 0.85771,-1.60266 0.86606,-3.27801 0.0227,-4.56281 -1.13026,-1.72192 -1.63379,-1.63641 -3.31546,0.56309 -1.98201,2.5923 -1.53986,6.53226 0.73304,6.53226 0.66238,0 1.81425,-1.13965 2.55971,-2.53254 z m -16.92516,2.70144 c 1.13682,-0.72055 1.69213,-3.02543 1.40394,-5.82718 -0.27084,-2.63322 0.2178,-4.86711 1.13138,-5.17226 1.00702,-0.33636 1.79799,1.84988 2.11604,5.84868 0.47879,6.02001 0.30624,6.38457 -3.01209,6.36431 -2.47474,-0.0152 -2.96152,-0.37547 -1.63927,-1.21355 z m 55.49596,-1.22185 c 0.38843,-1.3513 3.33569,-29.93907 6.5495,-63.52839 5.87485,-61.40144 6.38992,-65.63234 7.81625,-64.20599 0.42749,0.42749 -0.51722,13.94312 -2.09935,30.03472 -1.58213,16.09161 -4.16223,43.1565 -5.73354,60.1442 -3.35456,36.26668 -3.8979,40.01236 -5.80415,40.01236 -0.78921,0 -1.11713,-1.10561 -0.72871,-2.4569 z m 4.41923,-1.40395 c 0.83811,-4.94621 5.34399,-50.63899 9.17205,-93.01117 1.63937,-18.14595 3.2422,-33.25588 3.56183,-33.57762 2.09866,-2.1125 1.72505,5.66398 -2.06225,42.92573 -2.34207,23.04268 -4.92167,49.47707 -5.73245,58.74309 -2.06545,23.60492 -2.84065,28.78082 -4.31057,28.78082 -0.70555,0 -0.98843,-1.73738 -0.62861,-3.86085 z m -69.67097,-2.29863 c 4.53701,-4.68101 4.21597,-7.4081 -0.65219,-5.54001 -1.68146,0.64524 -2.14083,0.42396 -1.44779,-0.69741 1.42138,-2.29984 5.78568,-2.04703 7.86256,0.45545 1.43042,1.72355 1.1479,2.5922 -1.58302,4.86709 -1.82831,1.52301 -3.95597,2.86487 -4.72814,2.98193 -0.77217,0.11709 0.49138,0.6951 2.80789,1.28454 4.09159,1.04114 4.05367,1.07647 -1.32837,1.23784 l -5.54018,0.1661 z m -13.60524,1.66686 c -2.6515,-2.6515 -1.97362,-7.28702 1.37106,-9.37581 2.67187,-1.66861 3.28924,-1.58913 4.9138,0.63259 2.64773,3.62099 2.29752,7.28605 -0.85759,8.97462 -3.38434,1.81124 -3.38465,1.81122 -5.42727,-0.2314 z m 5.71314,-2.87808 c 0.88586,-2.53961 -0.39295,-5.26478 -2.47054,-5.26478 -1.87877,0 -3.78597,4.8852 -2.43473,6.23645 1.39848,1.39848 4.27745,0.8282 4.90527,-0.97167 z m 161.0752,2.63568 c 0,-3.33045 8.43865,-92.29108 9.86845,-104.03368 0.74969,-6.15709 1.36309,-11.68511 1.36309,-12.2845 0,-0.59937 0.97628,-1.08978 2.16952,-1.08978 1.66659,0 1.99451,1.05776 1.41453,4.56281 -0.41526,2.50955 -2.99583,27.30668 -5.73461,55.10474 -5.70807,57.93562 -5.93274,59.66754 -7.74065,59.66754 -0.73718,0 -1.34033,-0.86721 -1.34033,-1.92713 z m 8.9267,-4.03962 c 0.45203,-3.28172 3.0717,-28.39474 5.8215,-55.80671 5.49439,-54.77219 5.6889,-56.15769 7.88411,-56.15769 1.71243,0 1.86443,-1.99525 -5.18737,68.0912 -2.64155,26.25372 -4.80431,48.20787 -4.80613,48.78699 -10e-4,0.57913 -1.02272,1.05296 -2.26865,1.05296 -1.85805,0 -2.11756,-1.07275 -1.44346,-5.96675 z m -24.55901,3.90589 c -0.72227,-0.72227 -0.39133,-4.36552 6.48812,-71.42809 4.33185,-42.22782 5.29744,-48.84894 6.87368,-47.13309 0.62318,0.67837 -11.41738,117.9306 -12.18949,118.70271 -0.28346,0.28347 -0.811,0.21977 -1.17231,-0.14153 z m 4.67447,-2.85294 c 0.0286,-2.3165 0.34326,-3.0942 0.69922,-1.72821 0.35595,1.366 0.33255,3.26132 -0.0521,4.21183 -0.38458,0.95051 -0.67581,-0.16711 -0.6472,-2.48362 z m -19.43358,1.03147 c -1.18722,-0.76032 -0.007,-16.34777 4.48961,-59.29507 3.35511,-32.04498 6.13315,-58.42155 6.17342,-58.61459 0.23979,-1.14976 5.68897,-0.0885 5.68897,1.10798 0,2.22522 -8.34794,88.86095 -9.8701,102.43276 -0.73613,6.56343 -1.34358,12.72323 -1.34993,13.68844 -0.0126,1.9371 -2.62824,2.2839 -5.13197,0.68048 z m 8.48557,-6.29625 c 0.4844,-4.05388 3.09006,-30.38357 5.79033,-58.5104 2.70029,-28.12685 5.21973,-51.44984 5.59877,-51.82888 1.83244,-1.83245 1.81095,2.10338 -0.11035,20.19212 -2.72518,25.65801 -9.01308,91.91429 -9.02155,95.06096 -0.004,1.35129 -0.71118,2.4569 -1.57232,2.4569 -1.06468,0 -1.28386,-2.35867 -0.68495,-7.3707 z m -18.80848,4.95802 c 0,-2.18734 9.59469,-101.92056 10.67432,-110.95566 0.48441,-4.05388 1.52048,-7.3707 2.30236,-7.3707 0.84881,0 1.09975,2.12134 0.62279,5.26479 -0.43935,2.89563 -3.14244,29.27219 -6.00686,58.61459 -2.86444,29.34239 -5.74458,53.94999 -6.40034,54.68355 -0.73805,0.82563 -1.19227,0.73551 -1.19227,-0.23657 z m -10.50272,-5.65999 c 0.41909,-2.89563 3.23543,-29.50132 6.25852,-59.12376 5.05384,-49.5212 7.05209,-63.73931 7.05209,-50.17782 0,5.23785 -9.0659,97.33986 -10.68982,108.59961 -0.47329,3.28171 -1.42804,5.96675 -2.12166,5.96675 -0.69362,0 -0.91824,-2.36915 -0.49913,-5.26478 z m 4.00774,1.40394 c 0.41131,-2.12346 3.06204,-27.86825 5.8905,-57.21065 5.20286,-53.97422 5.68698,-57.86091 7.03875,-56.50914 0.66412,0.66413 -5.68636,71.49162 -9.28362,103.54121 -0.73669,6.56343 -1.34462,12.40734 -1.35096,12.98647 -0.007,0.57912 -0.69348,1.05295 -1.52701,1.05295 -0.8986,0 -1.21107,-1.5716 -0.76766,-3.86084 z m -141.86166,-5.26478 c 2.45937,-25.17794 10.87087,-109.163 11.56528,-115.47425 0.44606,-4.05389 1.26192,-7.3707 1.81305,-7.3707 1.76976,0 -10.80335,127.95735 -12.7605,129.86466 -0.98295,0.95792 -1.17924,-1.2722 -0.61783,-7.01971 z m 3.75059,5.81829 c 0,-1.35574 1.84976,-20.90914 4.11059,-43.45202 2.26082,-22.54287 4.88224,-50.14776 5.82538,-61.3442 0.94314,-11.19644 2.23302,-21.30483 2.86643,-22.46308 1.77041,-3.23742 1.503,5.71361 -0.80342,26.89198 -1.12225,10.30488 -3.71602,37.05759 -5.76393,59.45047 -2.0479,22.39288 -4.28858,41.31451 -4.97927,42.04807 -0.76801,0.81571 -1.25578,0.37631 -1.25578,-1.13122 z m 118.32031,-1.95745 c 0.40707,-2.12346 3.08096,-28.18414 5.94197,-57.91262 5.24554,-54.50564 5.75315,-58.58081 7.12606,-57.2079 0.4156,0.4156 -0.56204,14.563 -2.17251,31.43867 -1.61048,16.87566 -3.85969,40.47553 -4.99826,52.44413 -2.94047,30.91031 -3.55975,35.09856 -5.18972,35.09856 -0.82276,0 -1.12819,-1.66661 -0.70754,-3.86084 z m 4.44693,-2.10591 c 1.24983,-9.36493 4.65699,-43.69649 7.83228,-78.92039 1.59844,-17.73161 3.1926,-32.52565 3.54259,-32.87564 1.95795,-1.95795 1.95829,2.93999 0.001,21.07653 -2.24525,20.81039 -9.19265,92.83095 -9.19265,95.29677 0,0.76422 -0.67048,1.38948 -1.48996,1.38948 -0.94185,0 -1.19703,-2.19499 -0.69366,-5.96675 z m -14.66369,1.66263 c 0,-1.5951 2.5271,-27.85026 5.61577,-58.34478 3.08868,-30.49451 5.61577,-55.72394 5.61577,-56.06538 0,-0.34146 1.58691,-0.62081 3.52645,-0.62081 3.27056,0 3.47277,0.38202 2.78666,5.26478 -0.40688,2.89563 -2.93713,27.37688 -5.62278,54.40276 -5.96325,60.00862 -5.68838,58.26361 -9.17759,58.26361 -1.83743,0 -2.74428,-0.95838 -2.74428,-2.90018 z m -20.44273,-7.2784 c 0.46194,-4.82606 3.03933,-30.78401 5.72752,-57.68434 2.68819,-26.90034 4.88762,-49.80214 4.88762,-50.89291 0,-2.12366 3.57437,-2.74652 4.75925,-0.82933 0.65401,1.0582 -9.34471,103.13216 -11.12957,113.6184 -0.4813,2.82773 -1.59573,4.56282 -2.93067,4.56282 -1.79591,0 -2.01441,-1.45884 -1.31415,-8.77464 z m 5.95599,4.91379 c 0.25867,-2.12346 3.02822,-28.48336 6.15453,-58.57754 3.12633,-30.09419 5.96414,-54.99661 6.30626,-55.33872 0.34211,-0.34212 0.85915,-0.35878 1.149,-0.0371 0.54887,0.60928 -9.6998,105.25239 -11.09175,113.25135 -0.96203,5.52834 -3.18133,6.14703 -2.51804,0.70197 z m 82.01113,1.75493 c -0.31474,-4.63779 8.90876,-91.45979 9.42989,-88.76472 0.43515,2.25042 -7.61073,84.43467 -8.75885,89.46669 -0.28789,1.26184 -0.55686,0.98047 -0.67104,-0.70197 z m -104.02688,-3.29023 c 0,-2.19571 2.52607,-28.25639 5.61349,-57.91262 3.08742,-29.65623 5.61452,-54.71013 5.61577,-55.67534 10e-4,-0.96521 1.04318,-1.75493 2.31541,-1.75493 2.05328,0 2.20926,1.53772 1.38843,13.68844 -1.00194,14.83178 -8.8748,93.63579 -10.09871,101.08384 -0.95379,5.80414 -4.83439,6.26217 -4.83439,0.57061 z m 6.39148,0.1314 c 0.38804,-2.12346 3.15935,-28.39151 6.1585,-58.37344 2.99913,-29.98194 5.82471,-54.88436 6.27909,-55.33872 1.2636,-1.2636 1.01663,4.08581 -1.24738,27.01873 -1.14345,11.58252 -3.3657,34.64227 -4.93832,51.24389 -3.3553,35.42075 -3.91456,39.31039 -5.65218,39.31039 -0.71788,0 -0.98774,-1.73738 -0.59971,-3.86085 z m -21.83321,-2.10591 c 10e-4,-3.80157 7.7626,-82.48192 10.59436,-107.40158 0.57497,-5.0597 1.4662,-7.3707 2.84248,-7.3707 2.68444,0 2.72518,-0.81942 -2.90886,58.48606 -5.74197,60.44145 -5.79881,60.84899 -8.48732,60.84899 -1.36851,0 -2.04175,-1.50536 -2.04066,-4.56281 z m 7.12891,2.33991 c 0.0674,-1.63552 0.40004,-1.96819 0.84821,-0.84822 0.40556,1.01346 0.35569,2.22438 -0.11077,2.69089 -0.46652,0.46652 -0.79834,-0.36269 -0.73738,-1.84267 z m -76.36838,-2.04761 c -2.3459,-3.34923 -1.78004,-6.6849 1.59572,-9.40664 1.75189,-1.41249 2.6479,-1.3045 4.71761,0.56857 3.39639,3.07371 3.22211,4.97268 -0.80347,8.75452 l -3.35846,3.15511 z m 5.35846,-4.15318 c 0,-1.80172 -0.78938,-3.53899 -1.75419,-3.86059 -2.15232,-0.71744 -3.76912,3.05509 -2.6071,6.08325 1.23506,3.21854 4.36129,1.6253 4.36129,-2.22266 z m 47.72811,6.10517 c -0.90057,-0.31513 0.47227,-19.13061 3.80037,-52.08626 2.86563,-28.37609 5.24713,-54.12 5.29221,-57.20867 0.0855,-5.86149 1.99772,-10.44273 3.66344,-8.77701 0.53309,0.53309 -0.70016,18.20447 -2.74056,39.26972 -2.04041,21.06526 -4.3886,46.19764 -5.21822,55.84974 -1.63414,19.01255 -2.61707,23.71539 -4.79724,22.95248 z m 8.10998,-4.70123 c 0,-3.47476 0.2738,-4.89625 0.60843,-3.15887 0.33464,1.73738 0.33464,4.58036 0,6.31774 -0.33463,1.73738 -0.60843,0.31589 -0.60843,-3.15887 z m -18.2507,-3.67055 c 8.63275,-86.70441 11.57271,-111.45272 13.24001,-111.45272 2.40793,0 2.5348,-1.87506 -4.21989,62.36142 -4.5234,43.01716 -6.35221,56.196 -7.868,56.69897 -1.60695,0.53323 -1.82157,-0.88393 -1.15212,-7.60767 z m -6.75272,3.31956 c 0.38687,-1.73737 2.99391,-27.79805 5.79341,-57.91261 2.7995,-30.11457 5.65387,-55.35394 6.34305,-56.0875 1.83804,-1.95642 1.75232,-0.68342 -3.68244,54.68355 -6.07279,61.86708 -6.14887,62.47543 -7.81276,62.47543 -0.73956,0 -1.02815,-1.42149 -0.64126,-3.15887 z m -13.31597,0.70198 c -0.0168,-0.57913 2.63751,-27.11364 5.89851,-58.96558 4.45419,-43.50672 6.38259,-57.91262 7.75224,-57.91262 1.00275,0 1.83695,0.47383 1.85377,1.05296 0.0168,0.57912 -2.63752,27.11363 -5.89851,58.96557 -4.45419,43.50673 -6.38259,57.91262 -7.75225,57.91262 -1.00275,0 -1.83694,-0.47383 -1.85376,-1.05295 z m 7.97252,-10.17859 c 0.41794,-6.56343 1.92432,-21.726 3.34751,-33.69461 1.48212,-12.4643 2.26297,-16.66286 1.82773,-9.8276 -0.41794,6.56343 -1.92431,21.72601 -3.3475,33.69462 -1.48213,12.4643 -2.26297,16.66286 -1.82774,9.82759 z m 47.21335,4.9138 c 0.0112,-3.86084 0.2832,-5.27364 0.6059,-3.13956 0.32271,2.13407 0.31407,5.29294 -0.0191,7.01971 -0.33324,1.72676 -0.59726,-0.0194 -0.58673,-3.88015 z m -15.44337,-8.42365 c 0.0112,-3.86084 0.2832,-5.27364 0.6059,-3.13957 0.32271,2.13408 0.31408,5.29295 -0.0191,7.01971 -0.33324,1.72677 -0.59727,-0.0194 -0.58674,-3.88014 z m 16.86647,-6.31774 c 0,-4.24693 0.2632,-5.98431 0.58487,-3.86084 0.32169,2.12346 0.32169,5.59822 0,7.72168 -0.32167,2.12346 -0.58487,0.38608 -0.58487,-3.86084 z m -15.46253,-7.72168 c 0.0112,-3.86085 0.28321,-5.27365 0.6059,-3.13957 0.32271,2.13408 0.31408,5.29295 -0.0191,7.01971 -0.33324,1.72677 -0.59727,-0.0194 -0.58674,-3.88014 z m 16.86647,-9.12563 c 0,-4.24692 0.2632,-5.9843 0.58487,-3.86084 0.32169,2.12346 0.32169,5.59822 0,7.72168 -0.32167,2.12346 -0.58487,0.38609 -0.58487,-3.86084 z m -15.15536,-7.72168 c 1.04486,-16.54585 6.78555,-68.77346 7.36747,-67.02772 0.55251,1.65754 -6.2907,70.84407 -7.39344,74.7494 -0.32705,1.15825 -0.31537,-2.3165 0.026,-7.72168 z m 16.45141,-6.31774 c -0.0268,-3.47476 0.75125,-12.95137 1.72917,-21.05914 0.97791,-8.10776 1.82459,-12.53018 1.88151,-9.82759 0.0569,2.70259 -0.72122,12.1792 -1.72918,21.05913 -1.00795,8.87994 -1.85463,13.30236 -1.8815,9.8276 z m -44.83742,-21.76111 c 0.0112,-3.86084 0.2832,-5.27364 0.6059,-3.13956 0.32271,2.13407 0.31408,5.29294 -0.0191,7.01971 -0.33324,1.72676 -0.59727,-0.0192 -0.58674,-3.88015 z m 1.42311,-14.74139 c 0,-4.24693 0.26319,-5.9843 0.58486,-3.86084 0.32169,2.12346 0.32169,5.59822 0,7.72168 -0.32167,2.12346 -0.58486,0.38608 -0.58486,-3.86084 z m 160.03025,-3.50986 c 0.0112,-3.86084 0.2832,-5.27364 0.6059,-3.13956 0.32271,2.13407 0.31408,5.29294 -0.0191,7.01971 -0.33324,1.72676 -0.59727,-0.0192 -0.58674,-3.88015 z m -112.39626,-1.40394 c -0.0411,-3.08867 0.41733,-8.77464 1.01868,-12.63548 0.87619,-5.62539 1.10305,-6.04368 1.14211,-2.10591 0.0268,2.70259 -0.4316,8.38855 -1.01868,12.63548 -0.9294,6.72324 -1.07708,6.99553 -1.14211,2.10591 z m -46.2157,-11.23154 c 0.008,-4.63301 0.26998,-6.35907 0.58244,-3.83569 0.31246,2.52337 0.30602,6.31402 -0.0143,8.42365 -0.32035,2.10963 -0.57599,0.0451 -0.56812,-4.58796 z m 225.26745,470.76422 c 2.31508,-6.13333 1.35267,-6.40672 -1.49937,-0.42592 -1.28414,2.69288 -1.85177,4.89616 -1.26138,4.89616 0.59038,0 1.83273,-2.01161 2.76075,-4.47024 z m 5.78422,-15.88692 c -0.0498,-2.17383 -0.49978,-1.8568 -1.99284,1.40394 -2.56458,5.60083 -2.52519,9.41982 0.0507,4.9138 1.10353,-1.93042 1.97749,-4.77341 1.94214,-6.31774 z M 420.81881,749.10458 c 0.47723,-0.77217 -0.11723,-1.40395 -1.32108,-1.40395 -1.20383,0 -2.18878,0.63178 -2.18878,1.40395 0,0.77217 0.59449,1.40394 1.32108,1.40394 0.7266,0 1.71155,-0.63177 2.18878,-1.40394 z m 119.27261,0.10108 c 0.44288,-0.71659 -0.39245,-1.683 -1.85629,-2.1476 -1.46383,-0.4646 -4.1489,-2.13473 -5.96681,-3.71139 -1.94913,-1.69048 -4.4657,-2.57716 -6.1335,-2.16104 -1.55553,0.38807 -5.67121,1.46247 -9.14597,2.38753 -3.47475,0.92505 -7.52406,1.63207 -8.99847,1.57115 -3.64203,-0.15049 -8.11782,2.38924 -7.10333,4.0307 1.0645,1.7224 38.14092,1.75136 39.20437,0.0306 z m 40.65579,0.0948 c 1.14717,-1.85617 -0.44889,-2.77537 -3.45435,-1.98943 -1.49093,0.38989 -2.36473,1.26884 -1.94176,1.95322 0.98288,1.59033 4.42135,1.6134 5.39611,0.0362 z m -93.63956,-2.5085 c 0.32023,-0.96182 -0.90505,-1.5274 -3.04152,-1.40394 -3.62281,0.20936 -4.38463,1.03984 -2.59528,2.82918 1.3977,1.3977 5.00024,0.48682 5.6368,-1.42524 z m 72.70144,0.9087 c 0.47723,-0.77216 0.19863,-1.40394 -0.61911,-1.40394 -0.81774,0 -1.4868,0.63178 -1.4868,1.40394 0,0.77217 0.2786,1.40395 0.61911,1.40395 0.34051,0 1.00957,-0.63178 1.4868,-1.40395 z M 189.57525,693.09628 c 11.01219,-5.6204 10.67434,-4.03733 9.69564,-45.43152 -0.63,-26.6464 -0.27917,-45.34353 1.26716,-67.53128 3.32431,-47.69943 1.63399,-53.96499 -20.14436,-74.66973 -3.28171,-3.11993 -5.96675,-6.39445 -5.96675,-7.2767 0,-0.88226 -3.00093,-3.9842 -6.66873,-6.89321 -3.66779,-2.90901 -9.65545,-8.32139 -13.3059,-12.0275 -6.32741,-6.42389 -6.99683,-6.73839 -14.34278,-6.73839 -7.56324,0 -17.62845,3.43955 -17.62845,6.02412 0,0.71072 -1.47767,3.04834 -3.28371,5.1947 -2.2579,2.68335 -3.85789,7.3518 -5.12171,14.94405 -1.0109,6.07288 -2.69824,12.75948 -3.74965,14.85912 -4.92109,9.82727 -6.06126,34.89907 -1.99715,43.91652 6.01799,13.35274 8.31346,22.86974 9.26104,38.39613 0.36928,6.05076 -0.006,11.50489 -0.90727,13.1891 -1.69102,3.1597 -0.81884,6.93921 5.59094,24.22765 3.43162,9.25576 8.76601,18.13865 16.98569,28.28482 22.94249,28.31965 29.34751,33.61393 41.19037,34.04728 2.15422,0.0789 6.26075,-1.053 9.12562,-2.51516 z m -33.35712,-65.12272 c -1.90708,-0.965 -4.37871,-3.64073 -5.4925,-5.94606 -1.11379,-2.30534 -2.66395,-5.45507 -3.44479,-6.99941 -1.96515,-3.88665 -3.89956,-12.65813 -4.71474,-21.37871 -0.6883,-7.36324 2.7126,-20.03759 5.37667,-20.03759 0.66727,0 1.21321,-0.65107 1.21321,-1.44683 0,-0.79575 2.21121,-3.3883 4.9138,-5.7612 2.70259,-2.37292 4.9138,-5.05619 4.9138,-5.96284 0,-1.5539 3.02833,-4.71948 6.66498,-6.96705 3.22217,-1.99142 8.34817,0.67113 10.67136,5.54292 3.15742,6.62119 2.9137,9.92868 -0.91655,12.43837 -2.65543,1.7399 -4.03058,1.81977 -7.67125,0.44558 -7.28103,-2.74829 -11.54177,-0.31058 -15.26688,8.7347 -6.20897,15.07653 -3.46904,26.77788 9.56921,40.86692 4.78944,5.17545 8.72441,5.13149 14.01243,-0.15653 2.3165,-2.3165 4.795,-4.21183 5.50776,-4.21183 2.89893,0 1.01764,5.60036 -3.0236,9.00083 -3.43989,2.89448 -5.79859,3.63044 -11.58252,3.61396 -3.99463,-0.0112 -8.82331,-0.81024 -10.73039,-1.77523 z M 126.43592,592.916 c 0.42306,-14.97639 0.0634,-19.83366 -1.84538,-24.91998 -7.71437,-20.55673 -9.39086,-39.89191 -4.71575,-54.38751 1.55378,-4.81766 3.41719,-9.12533 4.14089,-9.57261 0.7237,-0.44727 2.22109,-2.97981 3.32752,-5.62787 2.8744,-6.87942 7.51964,-8.64512 15.10272,-5.7407 6.02865,2.30907 19.02767,12.93715 17.58621,14.37861 -0.42315,0.42314 -4.03379,-0.88487 -8.02365,-2.90668 -5.92278,-3.0013 -8.38088,-3.50708 -13.3922,-2.75559 -7.54238,1.13106 -10.32737,4.05274 -12.95896,13.59504 -4.84194,17.55721 -4.78489,28.70255 0.23546,45.9976 3.68113,12.68145 3.78928,13.09068 5.19422,19.6552 0.74366,3.47475 0.98592,9.16072 0.53835,12.63548 -0.98707,7.66311 -3.84608,18.25125 -4.92821,18.25125 -0.43269,0 -0.55024,-8.37101 -0.26122,-18.60224 z m 5.87275,-43.68386 c 0,-1.05412 1.16244,-3.42327 2.58319,-5.26478 3.65354,-4.73556 5.84047,-11.8765 5.84047,-19.07079 0,-8.82322 3.23996,-14.46218 8.3095,-14.46218 2.21406,0 4.36551,0.8859 4.78101,1.96865 0.94263,2.45648 -0.18285,3.64712 -3.44751,3.64712 -3.36171,0 -5.27253,3.89513 -5.21487,10.63029 0.0562,6.56733 -1.89101,12.06362 -6.80345,19.20348 -3.73156,5.42355 -6.04834,6.70605 -6.04834,3.34821 z m -30.88673,135.9102 c 0,-1.20382 -0.63177,-1.79831 -1.40394,-1.32108 -0.772167,0.47723 -1.403941,1.46218 -1.403941,2.18878 0,0.72659 0.631774,1.32108 1.403941,1.32108 0.77217,0 1.40394,-0.98495 1.40394,-2.18878 z M 583.3398,533.24845 c -0.66257,-9.42779 -1.21336,-11.58252 -2.96074,-11.58252 -1.29835,0 -3.12889,16.6696 -2.04277,18.60224 0.32544,0.57912 1.71203,1.05295 3.08128,1.05295 2.16057,0 2.41459,-1.06676 1.92223,-8.07267 z m 24.12373,4.9524 c 2.68796,-3.83761 2.81614,-9.52005 0.29258,-12.97122 -2.88596,-3.94679 -4.95947,-1.50047 -4.10812,4.84678 0.43069,3.21102 0.0792,6.41198 -0.82343,7.49961 -1.53185,1.84578 -0.84057,3.7451 1.36309,3.7451 0.59969,0 2.07383,-1.40412 3.27588,-3.12027 z m 16.12453,1.06629 c 2.18459,-1.1297 4.34285,-3.0205 4.79616,-4.20179 1.54338,-4.02198 -9.08528,-10.97886 -13.03961,-8.53494 -0.81605,0.50435 -1.48374,4.03859 -1.48374,7.85386 0,6.05692 0.36502,6.93685 2.8776,6.93685 1.58268,0 4.66499,-0.9243 6.84959,-2.05398 z m -48.89616,-3.59512 c -0.30829,-1.13991 -0.85383,-3.80996 -1.2123,-5.93342 -0.35845,-2.12346 -1.43545,-3.86084 -2.39331,-3.86084 -2.59936,0 -9.46945,6.82716 -8.82267,8.76753 1.24497,3.7349 13.43306,4.74179 12.42828,1.02673 z m 99.15826,-27.48979 c -0.46652,-0.46652 -1.67743,-0.51638 -2.6909,-0.11077 -1.11996,0.44817 -0.7873,0.78084 0.84822,0.8482 1.47998,0.0609 2.30919,-0.27086 1.84268,-0.73737 z m 6.69797,-27.23063 c 0.47722,-0.77216 0.19863,-1.40394 -0.61911,-1.40394 -0.81774,0 -1.48681,0.63178 -1.48681,1.40394 0,0.77217 0.2786,1.40395 0.61911,1.40395 0.34052,0 1.00958,-0.63178 1.48681,-1.40395 z m 17.24469,-18.0184 c 0.41946,-1.27267 -0.41006,-1.72269 -2.58794,-1.40394 -1.76291,0.25801 -3.48307,1.31201 -3.8226,2.34219 -0.41946,1.27268 0.41006,1.7227 2.58794,1.40395 1.7629,-0.25802 3.48307,-1.31202 3.8226,-2.3422 z M 149.15598,419.88012 c 0,-1.15826 0.70913,-2.10592 1.57585,-2.10592 1.09871,0 1.05408,-0.62868 -0.14742,-2.07641 -2.45805,-2.96176 -7.04545,-0.33753 -6.05185,3.46198 0.85458,3.26794 4.62342,3.85514 4.62342,0.72035 z m 23.60697,-3.15887 c -0.29845,-1.57375 -1.9756,-2.59457 -4.66575,-2.83988 l -4.19983,-0.38299 3.3144,2.83988 c 4.07414,3.49085 6.16796,3.6353 5.55118,0.38299 z m -29.69423,-43.2656 c 1.11073,-2.89451 -1.80046,-5.91694 -3.78636,-3.93104 -1.6078,1.60779 -0.39472,6.13132 1.64423,6.13132 0.71379,0 1.67775,-0.99013 2.14213,-2.20028 z M 717.7526,246.22605 c 0,-1.84533 -3.19086,-0.68982 -3.89041,1.40885 -0.34197,1.02593 0.29987,1.3397 1.66718,0.81501 1.22278,-0.46923 2.22323,-1.46996 2.22323,-2.22386 z m 10.52956,-2.54069 c 0.47723,-0.77217 -0.11723,-1.40394 -1.32108,-1.40394 -1.20382,0 -2.18877,0.63177 -2.18877,1.40394 0,0.77217 0.59448,1.40394 1.32108,1.40394 0.7266,0 1.71155,-0.63177 2.18877,-1.40394 z m -9.12562,-13.38472 c 0,-1.54715 2.71803,-2.98341 10.27705,-5.43062 3.80053,-1.23041 2.54774,-7.03143 -1.64674,-7.62513 -5.94557,-0.84155 -18.39488,14.80397 -14.711,18.48787 1.20002,1.2 6.08069,-3.16008 6.08069,-5.43212 z m 7.43469,-22.22488 c 7.10001,2.3893 10.81656,1.64498 10.81656,-2.16626 0,-5.57782 -6.58933,-7.56641 -10.8998,-3.28945 -1.3619,1.35129 -4.20488,3.23307 -6.31774,4.18173 -2.11288,0.94865 -3.8416,2.4428 -3.8416,3.32033 0,0.99597 1.34295,0.71559 3.57385,-0.74616 2.33509,-1.53002 4.64659,-1.98068 6.66873,-1.30019 z m 3.07785,-13.55594 c -0.78707,-1.27349 -1.3088,-1.23465 -2.17175,0.16162 -1.4802,2.39505 -0.026,4.74812 1.80373,2.91848 0.77217,-0.77217 0.93776,-2.15821 0.36802,-3.0801 z M 602.30759,103.55437 c 0.84231,-2.5269 -2.05958,-1.99591 -3.03886,0.55605 -0.5247,1.36731 -0.21093,2.00915 0.815,1.66718 0.91748,-0.30582 1.91822,-1.30628 2.22386,-2.22323 z"
     id="path3682"
     inkscape:connector-curvature="0" />
</svg>
`)

func TestSVG(t *testing.T) {
	_, err := xmlEncoding{}.NewDecoder(bytes.NewBuffer(brokenSVG)).MarshalJSONBytes()
	if err != nil {
		t.Fatal(err)
	}
}

func TestXMLEscapeSequences(t *testing.T) {
	table := []struct {
		xml  string
		json string
	}{
		{`<p>me &amp; you</p>`, `{"p":"me & you"}`},
	}

	for _, row := range table {
		t.Run(row.xml, func(t *testing.T) {
			jsonBytes, err := xmlEncoding{}.NewDecoder(strings.NewReader(row.xml)).MarshalJSONBytes()
			if err != nil {
				t.Fatal(err)
			}

			if string(jsonBytes) != row.json {
				t.Fatal(fmt.Sprintf("incorrect JSON value:\nexpected: %s\ngot:     %s", row.json, string(jsonBytes)))
			}

			var buf bytes.Buffer
			err = xmlEncoding{}.NewEncoder(&buf).UnmarshalJSONBytes(jsonBytes, false, false)
			if err != nil {
				t.Fatal(err)
			}

			xmlString := strings.TrimSpace(buf.String())
			if xmlString != row.xml {
				t.Fatal(fmt.Sprintf("incorrect XML value:\nexpected: %#v\ngot:      %#v", row.xml, xmlString))
			}
		})
	}
}
