/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni;

import net.sf.clipsrules.jni.CLIPSType;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.PrimitiveValue;

public class InstanceAddressValue
extends PrimitiveValue {
    private Environment owner;
    private Long value;

    public InstanceAddressValue(long l, Environment environment) {
        this.value = l;
        this.owner = environment;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public CLIPSType getCLIPSType() {
        return CLIPSType.INSTANCE_ADDRESS;
    }

    public Environment getEnvironment() {
        return this.owner;
    }

    public long getInstanceAddress() {
        return this.getValue();
    }

    public PrimitiveValue getSlotValue(String string) {
        return Environment.directGetSlot(this, string);
    }

    public String getInstanceName() {
        return Environment.getInstanceName(this);
    }

    @Override
    public String toString() {
        return "<Instance-" + this.getInstanceName() + ">";
    }

    @Override
    public void retain() {
        this.owner.retainInstance(this);
    }

    @Override
    public void release() {
        this.owner.releaseInstance(this);
    }

    @Override
    public boolean isInstanceAddress() {
        return true;
    }
}

