/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import net.sf.clipsrules.jni.Activation;
import net.sf.clipsrules.jni.Agenda;
import net.sf.clipsrules.jni.Focus;
import net.sf.clipsrules.jni.FocusStack;
import net.sf.clipsrules.jni.examples.ide.ActivationTableModel;
import net.sf.clipsrules.jni.examples.ide.FocusStackTableModel;

public class AgendaBrowserFrame
extends JInternalFrame
implements ActionListener,
ListSelectionListener {
    private JFrame browserFrame;
    private JButton resetButton = null;
    private JButton runButton = null;
    private JButton stepButton = null;
    private JButton haltRulesButton = null;
    private JTable focusStackTable;
    private JTable activationTable;
    private FocusStackTableModel focusStackModel;
    private ActivationTableModel activationModel;
    private JScrollPane focusStackPane;
    private JScrollPane activationPane;
    private JSplitPane contentPane;
    private static int agendaCount = 1;
    private FocusStack focusStack = null;
    private HashMap<Focus, Agenda> agendaMap = new HashMap();
    private int agendaChangeIndex = -1;
    public static final String RESET_ACTION = "Reset";
    public static final String RUN_ACTION = "Run";
    public static final String STEP_ACTION = "Step";
    public static final String HALT_RULES_ACTION = "HaltRules";
    public static final String BROWSER_SELECTION_ACTION = "BrowserSelectionAction";
    private ActionListener actionTarget = null;

    AgendaBrowserFrame(Font font) {
        this(new FocusStack(), new HashMap<Focus, Agenda>(), font);
    }

    AgendaBrowserFrame(FocusStack focusStack, HashMap<Focus, Agenda> hashMap, Font font) {
        super("Agenda #" + agendaCount++, true, true, true, true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setSize(600, 200);
        this.setMinimumSize(new Dimension(450, 100));
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(600, 40));
        jPanel.setLayout(new FlowLayout(0));
        this.resetButton = new JButton(RESET_ACTION);
        this.resetButton.setEnabled(false);
        this.resetButton.setActionCommand(RESET_ACTION);
        this.resetButton.addActionListener(this);
        jPanel.add(this.resetButton);
        this.runButton = new JButton(RUN_ACTION);
        this.runButton.setEnabled(false);
        this.runButton.setActionCommand(RUN_ACTION);
        this.runButton.addActionListener(this);
        jPanel.add(this.runButton);
        this.stepButton = new JButton(STEP_ACTION);
        this.stepButton.setEnabled(false);
        this.stepButton.setActionCommand(STEP_ACTION);
        this.stepButton.addActionListener(this);
        jPanel.add(this.stepButton);
        this.haltRulesButton = new JButton("Halt Rules");
        this.haltRulesButton.setEnabled(false);
        this.haltRulesButton.setActionCommand(HALT_RULES_ACTION);
        this.haltRulesButton.addActionListener(this);
        jPanel.add(this.haltRulesButton);
        this.getContentPane().add(jPanel);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this.focusStackModel = new FocusStackTableModel();
        this.focusStackTable = new JTable(this.focusStackModel);
        this.focusStackTable.setSelectionMode(0);
        this.focusStackTable.getSelectionModel().addListSelectionListener(this);
        this.focusStackTable.getTableHeader().setReorderingAllowed(false);
        this.focusStackTable.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        this.focusStackPane = new JScrollPane(this.focusStackTable);
        this.activationModel = new ActivationTableModel();
        this.activationTable = new JTable(this.activationModel);
        this.activationTable.setSelectionMode(0);
        this.activationTable.getSelectionModel().addListSelectionListener(this);
        this.activationTable.getTableHeader().setReorderingAllowed(false);
        this.activationPane = new JScrollPane(this.activationTable);
        this.activationTable.getColumnModel().getColumn(0).setMinWidth(65);
        this.activationTable.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.activationTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.activationTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.activationTable.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        this.activationTable.getColumnModel().getColumn(1).setCellRenderer(defaultTableCellRenderer);
        this.activationTable.getColumnModel().getColumn(2).setCellRenderer(defaultTableCellRenderer);
        this.contentPane = new JSplitPane(1, this.focusStackPane, this.activationPane);
        this.contentPane.setOneTouchExpandable(true);
        this.contentPane.setDividerLocation(125);
        this.contentPane.setDividerSize(15);
        this.contentPane.setPreferredSize(new Dimension(600, 160));
        this.contentPane.setAlignmentX(0.5f);
        this.getContentPane().add(this.contentPane);
        this.assignData(focusStack, hashMap);
        this.assignFont(font);
        this.pack();
    }

    public void assignFont(Font font) {
        FontMetrics fontMetrics = this.focusStackTable.getFontMetrics(font);
        int n = fontMetrics.getHeight() + 2;
        this.focusStackTable.setFont(font);
        this.focusStackTable.setRowHeight(n);
        this.focusStackTable.getTableHeader().setFont(font);
        this.activationTable.setFont(font);
        this.activationTable.setRowHeight(n);
        this.activationTable.getTableHeader().setFont(font);
    }

    public void setActionTarget(ActionListener actionListener) {
        this.actionTarget = actionListener;
    }

    public void updateButtonsDriver(boolean bl) {
        if (bl) {
            this.resetButton.setEnabled(false);
            this.runButton.setEnabled(false);
            this.stepButton.setEnabled(false);
            this.haltRulesButton.setEnabled(true);
        } else {
            this.resetButton.setEnabled(true);
            this.runButton.setEnabled(true);
            this.stepButton.setEnabled(true);
            this.haltRulesButton.setEnabled(false);
        }
    }

    public void updateButtons(final boolean bl) {
        if (EventQueue.isDispatchThread()) {
            this.updateButtonsDriver(bl);
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AgendaBrowserFrame.this.updateButtonsDriver(bl);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void assignData(FocusStack focusStack, HashMap<Focus, Agenda> hashMap) {
        this.focusStack = focusStack;
        this.agendaMap = hashMap;
        this.focusStackModel.setStack(this.focusStack);
        if (this.focusStack.size() == 0) {
            this.activationModel.setAgenda(null);
        } else {
            this.activationModel.setAgenda(this.agendaMap.get(this.focusStack.get(0)));
        }
        if (this.focusStack.size() != 0) {
            this.focusStackTable.setRowSelectionInterval(0, 0);
            if (this.agendaMap.get(this.focusStack.get(0)).size() != 0) {
                this.activationTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    public String selectedActivationRule() {
        int n = this.focusStackTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        int n2 = this.activationTable.getSelectedRow();
        if (n2 == -1) {
            return null;
        }
        Focus focus = this.focusStack.get(n);
        Agenda agenda = this.agendaMap.get(focus);
        Activation activation = agenda.get(n2);
        return focus.getModuleName() + "::" + activation.getRuleName();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource().equals(this.focusStackTable.getSelectionModel())) {
            int n = this.focusStackTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            if (this.focusStack.size() == 0) {
                this.activationModel.setAgenda(null);
            } else {
                Agenda agenda = this.agendaMap.get(this.focusStack.get(n));
                this.activationModel.setAgenda(agenda);
                if (this.agendaMap.get(this.focusStack.get(n)).size() != 0) {
                    this.activationTable.setRowSelectionInterval(0, 0);
                }
            }
        }
        this.actionPerformed(new ActionEvent(this, 2000, BROWSER_SELECTION_ACTION));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.actionTarget == null) {
            return;
        }
        try {
            this.actionTarget.actionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

