/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sf.clipsrules.jni.Agenda;
import net.sf.clipsrules.jni.Focus;
import net.sf.clipsrules.jni.FocusStack;
import net.sf.clipsrules.jni.examples.ide.AgendaBrowserFrame;
import net.sf.clipsrules.jni.examples.ide.CLIPSIDE;
import net.sf.clipsrules.jni.examples.ide.ConstructInspectorFrame;

public class AgendaBrowserManager
implements ActionListener {
    private List<AgendaBrowserFrame> browsers = new ArrayList<AgendaBrowserFrame>();
    private FocusStack focusStack;
    private HashMap<Focus, Agenda> agendaMap;
    private CLIPSIDE ide;

    AgendaBrowserManager(CLIPSIDE cLIPSIDE) {
        this.ide = cLIPSIDE;
        this.focusStack = new FocusStack();
        this.agendaMap = new HashMap();
    }

    public void createBrowser(Font font) {
        AgendaBrowserFrame agendaBrowserFrame = new AgendaBrowserFrame(font);
        agendaBrowserFrame.addInternalFrameListener(this.ide);
        agendaBrowserFrame.setActionTarget(this);
        this.browsers.add(agendaBrowserFrame);
        agendaBrowserFrame.updateButtons(this.ide.getDialogWindow().isExecuting());
        this.ide.getPlacer().placeInternalFrame(agendaBrowserFrame);
        this.ide.getDesktopPane().add(agendaBrowserFrame);
        agendaBrowserFrame.setVisible(true);
        if (!this.ide.getDialogWindow().isExecuting()) {
            if (this.browsers.size() == 1) {
                this.fetchData();
            }
            this.assignData(agendaBrowserFrame);
        }
    }

    public void removeBrowser(AgendaBrowserFrame agendaBrowserFrame) {
        this.browsers.remove(agendaBrowserFrame);
    }

    private synchronized void fetchData() {
        this.focusStack = this.ide.getEnvironment().getFocusStack();
        this.agendaMap = new HashMap();
        for (Focus focus : this.focusStack) {
            Agenda agenda = this.ide.getEnvironment().getAgenda(focus);
            this.agendaMap.put(focus, agenda);
        }
    }

    private synchronized void assignData(AgendaBrowserFrame agendaBrowserFrame) {
        agendaBrowserFrame.assignData(this.focusStack, this.agendaMap);
    }

    private void updateBrowser(final AgendaBrowserFrame agendaBrowserFrame) {
        if (EventQueue.isDispatchThread()) {
            this.assignData(agendaBrowserFrame);
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AgendaBrowserManager.this.assignData(agendaBrowserFrame);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateAllBrowsers() {
        if (this.browsers.size() == 0) {
            return;
        }
        this.fetchData();
        for (AgendaBrowserFrame agendaBrowserFrame : this.browsers) {
            this.updateBrowser(agendaBrowserFrame);
        }
    }

    public void assignFontAllBrowsers(Font font) {
        if (this.browsers.size() == 0) {
            return;
        }
        for (AgendaBrowserFrame agendaBrowserFrame : this.browsers) {
            agendaBrowserFrame.assignFont(font);
        }
    }

    public void updateAgendaBrowserButtons(boolean bl) {
        if (this.browsers.size() == 0) {
            return;
        }
        for (AgendaBrowserFrame agendaBrowserFrame : this.browsers) {
            agendaBrowserFrame.updateButtons(bl);
        }
    }

    public String browserSelectionText(AgendaBrowserFrame agendaBrowserFrame) {
        String string = agendaBrowserFrame.selectedActivationRule();
        if (string == null) {
            return "";
        }
        return this.ide.getEnvironment().getDefruleText(string);
    }

    public void browserSelection(ActionEvent actionEvent) {
        ConstructInspectorFrame constructInspectorFrame = this.ide.getConstructInspector();
        if (constructInspectorFrame == null) {
            return;
        }
        AgendaBrowserFrame agendaBrowserFrame = (AgendaBrowserFrame)actionEvent.getSource();
        constructInspectorFrame.setText(this.browserSelectionText(agendaBrowserFrame));
    }

    public void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (actionEvent.getActionCommand().equals("Reset")) {
            this.reset();
        } else if (actionEvent.getActionCommand().equals("Run")) {
            this.run();
        } else if (actionEvent.getActionCommand().equals("Step")) {
            this.step();
        } else if (actionEvent.getActionCommand().equals("HaltRules")) {
            this.haltRules();
        } else if (actionEvent.getActionCommand().equals("BrowserSelectionAction")) {
            this.browserSelection(actionEvent);
        }
    }

    public void reset() {
        this.ide.getDialogWindow().replaceCommand("(reset)\n");
    }

    public void run() {
        this.ide.getDialogWindow().replaceCommand("(run)\n");
    }

    public void step() {
        this.ide.getDialogWindow().replaceCommand("(run 1)\n");
    }

    public void haltRules() {
        this.ide.getDialogWindow().haltRules();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

