/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sf.clipsrules.jni.examples.ide.CLIPSIDE;
import net.sf.clipsrules.jni.examples.ide.DialogFrame;
import net.sf.clipsrules.jni.examples.ide.FontPreferencesDialog;
import net.sf.clipsrules.jni.examples.ide.IDEPreferences;
import net.sf.clipsrules.jni.examples.ide.TextFrame;

public class EditMenu
extends JMenu
implements MenuListener {
    private UndoAction undoAction;
    private RedoAction redoAction;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private SetFontsAction setFontsAction;
    private JMenuItem jmiUndo;
    private JMenuItem jmiRedo;
    private JMenuItem jmiCut;
    private JMenuItem jmiCopy;
    private JMenuItem jmiPaste;
    private JMenuItem jmiSetFonts;
    private CLIPSIDE ide;

    EditMenu(CLIPSIDE cLIPSIDE) {
        super("Edit");
        this.ide = cLIPSIDE;
        this.addMenuListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(90, 128);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(90, 192);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(88, 128);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(67, 128);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(86, 128);
        this.undoAction = new UndoAction("Undo");
        this.redoAction = new RedoAction("Redo");
        this.cutAction = new CutAction("Cut");
        this.copyAction = new CopyAction("Copy");
        this.pasteAction = new PasteAction("Paste");
        this.setFontsAction = new SetFontsAction("Set Fonts...");
        this.jmiUndo = new JMenuItem(this.undoAction);
        this.jmiUndo.setAccelerator(keyStroke);
        this.add(this.jmiUndo);
        this.jmiRedo = new JMenuItem(this.redoAction);
        this.jmiRedo.setAccelerator(keyStroke2);
        this.add(this.jmiRedo);
        this.addSeparator();
        this.jmiCut = new JMenuItem(this.cutAction);
        this.jmiCut.setAccelerator(keyStroke3);
        this.add(this.jmiCut);
        this.jmiCopy = new JMenuItem(this.copyAction);
        this.jmiCopy.setAccelerator(keyStroke4);
        this.add(this.jmiCopy);
        this.jmiPaste = new JMenuItem(this.pasteAction);
        this.jmiPaste.setAccelerator(keyStroke5);
        this.add(this.jmiPaste);
        this.addSeparator();
        this.jmiSetFonts = new JMenuItem(this.setFontsAction);
        this.add(this.jmiSetFonts);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem == null) continue;
            jMenuItem.setEnabled(true);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        JInternalFrame jInternalFrame = this.ide.getDesktopPane().getSelectedFrame();
        if (jInternalFrame == null || jInternalFrame.isIcon()) {
            this.jmiUndo.setEnabled(false);
            this.jmiRedo.setEnabled(false);
            this.jmiCut.setEnabled(false);
            this.jmiCopy.setEnabled(false);
            this.jmiPaste.setEnabled(false);
            return;
        }
        if (jInternalFrame instanceof DialogFrame) {
            DialogFrame dialogFrame = (DialogFrame)jInternalFrame;
            this.jmiUndo.setEnabled(false);
            this.jmiRedo.setEnabled(false);
            if (dialogFrame.hasCuttableSelection()) {
                this.jmiCut.setEnabled(true);
            } else {
                this.jmiCut.setEnabled(false);
            }
            if (dialogFrame.hasSelection()) {
                this.jmiCopy.setEnabled(true);
            } else {
                this.jmiCopy.setEnabled(false);
            }
            if (dialogFrame.hasPasteableSelection()) {
                this.jmiPaste.setEnabled(true);
            } else {
                this.jmiPaste.setEnabled(false);
            }
        } else if (jInternalFrame instanceof TextFrame) {
            TextFrame textFrame = (TextFrame)jInternalFrame;
            if (textFrame.canUndo()) {
                this.jmiUndo.setEnabled(true);
            } else {
                this.jmiUndo.setEnabled(false);
            }
            if (textFrame.canRedo()) {
                this.jmiRedo.setEnabled(true);
            } else {
                this.jmiRedo.setEnabled(false);
            }
            if (textFrame.hasSelection()) {
                this.jmiCopy.setEnabled(true);
                this.jmiCut.setEnabled(true);
            } else {
                this.jmiCopy.setEnabled(false);
                this.jmiCut.setEnabled(false);
            }
            this.jmiPaste.setEnabled(true);
        } else {
            this.jmiUndo.setEnabled(false);
            this.jmiRedo.setEnabled(false);
            this.jmiCut.setEnabled(false);
            this.jmiCopy.setEnabled(false);
            this.jmiPaste.setEnabled(false);
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem == null) continue;
            jMenuItem.setEnabled(true);
        }
    }

    class SetFontsAction
    extends AbstractAction {
        public SetFontsAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IDEPreferences iDEPreferences = EditMenu.this.ide.getPreferences();
            Font font = iDEPreferences.getDialogFont();
            Font font2 = iDEPreferences.getEditorFont();
            Font font3 = iDEPreferences.getBrowserFont();
            HashMap<String, Font> hashMap = new HashMap<String, Font>();
            hashMap.put("dialog", font);
            hashMap.put("editor", font2);
            hashMap.put("browser", font3);
            FontPreferencesDialog fontPreferencesDialog = new FontPreferencesDialog((Frame)EditMenu.this.ide, "Font Preferences", hashMap);
            fontPreferencesDialog.showDialog(hashMap);
            font = hashMap.get("dialog");
            font2 = hashMap.get("editor");
            font3 = hashMap.get("browser");
            iDEPreferences.setDialogFont(font);
            iDEPreferences.saveDialogFont(font);
            EditMenu.this.ide.getDialogWindow().setFont(font);
            iDEPreferences.setEditorFont(font2);
            iDEPreferences.saveEditorFont(font2);
            EditMenu.this.ide.assignEditorFont(font2);
            iDEPreferences.setBrowserFont(font3);
            iDEPreferences.saveBrowserFont(font3);
            EditMenu.this.ide.assignBrowserFont(font3);
        }
    }

    class PasteAction
    extends AbstractAction {
        public PasteAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = EditMenu.this.ide.getDesktopPane().getSelectedFrame();
            if (jInternalFrame != null && !jInternalFrame.isIcon()) {
                if (jInternalFrame instanceof DialogFrame) {
                    DialogFrame dialogFrame = (DialogFrame)jInternalFrame;
                    if (dialogFrame.hasPasteableSelection()) {
                        dialogFrame.paste();
                    }
                } else if (jInternalFrame instanceof TextFrame) {
                    TextFrame textFrame = (TextFrame)jInternalFrame;
                    textFrame.paste();
                }
            }
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = EditMenu.this.ide.getDesktopPane().getSelectedFrame();
            if (jInternalFrame != null && !jInternalFrame.isIcon()) {
                TextFrame textFrame;
                if (jInternalFrame instanceof DialogFrame) {
                    DialogFrame dialogFrame = (DialogFrame)jInternalFrame;
                    if (dialogFrame.hasSelection()) {
                        dialogFrame.copy();
                    }
                } else if (jInternalFrame instanceof TextFrame && (textFrame = (TextFrame)jInternalFrame).hasSelection()) {
                    textFrame.copy();
                }
            }
        }
    }

    class CutAction
    extends AbstractAction {
        public CutAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = EditMenu.this.ide.getDesktopPane().getSelectedFrame();
            if (jInternalFrame != null && !jInternalFrame.isIcon()) {
                TextFrame textFrame;
                if (jInternalFrame instanceof DialogFrame) {
                    DialogFrame dialogFrame = (DialogFrame)jInternalFrame;
                    if (dialogFrame.hasCuttableSelection()) {
                        dialogFrame.cut();
                    }
                } else if (jInternalFrame instanceof TextFrame && (textFrame = (TextFrame)jInternalFrame).hasSelection()) {
                    textFrame.cut();
                }
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextFrame textFrame;
            JInternalFrame jInternalFrame = EditMenu.this.ide.getDesktopPane().getSelectedFrame();
            if (jInternalFrame != null && !jInternalFrame.isIcon() && jInternalFrame instanceof TextFrame && (textFrame = (TextFrame)jInternalFrame).canRedo()) {
                textFrame.redo();
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextFrame textFrame;
            JInternalFrame jInternalFrame = EditMenu.this.ide.getDesktopPane().getSelectedFrame();
            if (jInternalFrame != null && !jInternalFrame.isIcon() && jInternalFrame instanceof TextFrame && (textFrame = (TextFrame)jInternalFrame).canUndo()) {
                textFrame.undo();
            }
        }
    }
}

