/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.clipsrules.jni.FactInstance;
import net.sf.clipsrules.jni.SlotValue;

class SlotValueTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Slot", "Value"};
    private FactInstance item;

    public SlotValueTableModel() {
        this(null);
    }

    public SlotValueTableModel(FactInstance factInstance) {
        this.item = factInstance;
    }

    public void setItem(FactInstance factInstance) {
        this.item = factInstance;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.item == null) {
            return 0;
        }
        List<SlotValue> list = this.item.getSlotValues();
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public SlotValue getSlotValue(int n) {
        return this.item.getSlotValues().get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.item.getSlotValues().get(n).getSlotName();
        }
        return this.item.getSlotValues().get(n).getSlotValue();
    }

    public Class getColumnClass(int n) {
        return String.class;
    }
}

