/*===================== begin_copyright_notice ==================================

* Copyright (c) 2024, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.

======================= end_copyright_notice ==================================*/
//!
//! \file     mhw_vebox_hwcmd_xe2_lpm.h
//! \brief    Auto-generated constructors for MHW and states.
//! \details  This file may not be included outside of XE2_LPM as other components
//!           should use MHW interface to interact with MHW commands and states.
//!

// DO NOT EDIT

#ifndef __MHW_VEBOX_HWCMD_XE2_LPM_BASE_NEXT_H__
#define __MHW_VEBOX_HWCMD_XE2_LPM_BASE_NEXT_H__

#pragma once
#include <cstdint>
#include <cstddef>
#include "media_class_trace.h"


#pragma pack(1)

namespace mhw
{
namespace vebox
{
namespace xe2_lpm_base_next
{
class Cmd
{
public:
    // Internal Macros
    #define __CODEGEN_MAX(_a, _b) (((_a) > (_b)) ? (_a) : (_b))
    #define __CODEGEN_BITFIELD(l, h) (h) - (l) + 1
    #define __CODEGEN_OP_LENGTH_BIAS 2
    #define __CODEGEN_OP_LENGTH(x) (uint32_t)((__CODEGEN_MAX(x, __CODEGEN_OP_LENGTH_BIAS)) - __CODEGEN_OP_LENGTH_BIAS)

    static uint32_t GetOpLength(uint32_t uiLength) { return __CODEGEN_OP_LENGTH(uiLength); }

    //!
    //! \brief VEBOX_STD_STE_STATE
    //! \details
    //!     This state structure contains the state used by the STD/STE function.
    //!     
    struct VEBOX_STD_STE_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 StdEnable                                        : __CODEGEN_BITFIELD( 0,  0)    ; //!< STD Enable
                uint32_t                 SteEnable                                        : __CODEGEN_BITFIELD( 1,  1)    ; //!< STE Enable
                uint32_t                 OutputControl                                    : __CODEGEN_BITFIELD( 2,  2)    ; //!< OUTPUT_CONTROL
                uint32_t                 Reserved3                                        : __CODEGEN_BITFIELD( 3,  3)    ; //!< Reserved
                uint32_t                 SatMax                                           : __CODEGEN_BITFIELD( 4,  9)    ; //!< SAT_MAX
                uint32_t                 HueMax                                           : __CODEGEN_BITFIELD(10, 15)    ; //!< HUE_MAX
                uint32_t                 UMid                                             : __CODEGEN_BITFIELD(16, 23)    ; //!< U_MID
                uint32_t                 VMid                                             : __CODEGEN_BITFIELD(24, 31)    ; //!< V_MID
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 SinA                                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< SINA
                uint32_t                 Reserved40                                       : __CODEGEN_BITFIELD( 8,  9)    ; //!< Reserved
                uint32_t                 CosA                                             : __CODEGEN_BITFIELD(10, 17)    ; //!< COSA
                uint32_t                 HsMargin                                         : __CODEGEN_BITFIELD(18, 20)    ; //!< HS_MARGIN
                uint32_t                 DiamondDu                                        : __CODEGEN_BITFIELD(21, 27)    ; //!< DIAMOND_DU
                uint32_t                 DiamondMargin                                    : __CODEGEN_BITFIELD(28, 30)    ; //!< DIAMOND_MARGIN
                uint32_t                 StdScoreOutput                                   : __CODEGEN_BITFIELD(31, 31)    ; //!< STD Score Output
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 DiamondDv                                        : __CODEGEN_BITFIELD( 0,  6)    ; //!< DIAMOND_DV
                uint32_t                 DiamondTh                                        : __CODEGEN_BITFIELD( 7, 12)    ; //!< DIAMOND_TH
                uint32_t                 DiamondAlpha                                     : __CODEGEN_BITFIELD(13, 20)    ; //!< DIAMOND_ALPHA
                uint32_t                 Reserved85                                       : __CODEGEN_BITFIELD(21, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 Reserved96                                       : __CODEGEN_BITFIELD( 0,  6)    ; //!< Reserved
                uint32_t                 VyStdEnable                                      : __CODEGEN_BITFIELD( 7,  7)    ; //!< VY_STD_Enable
                uint32_t                 YPoint1                                          : __CODEGEN_BITFIELD( 8, 15)    ; //!< Y_POINT_1
                uint32_t                 YPoint2                                          : __CODEGEN_BITFIELD(16, 23)    ; //!< Y_POINT_2
                uint32_t                 YPoint3                                          : __CODEGEN_BITFIELD(24, 31)    ; //!< Y_POINT_3
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 YPoint4                                          : __CODEGEN_BITFIELD( 0,  7)    ; //!< Y_POINT_4
                uint32_t                 YSlope1                                          : __CODEGEN_BITFIELD( 8, 12)    ; //!< Y_SLOPE_1
                uint32_t                 YSlope2                                          : __CODEGEN_BITFIELD(13, 17)    ; //!< Y_SLOPE_2
                uint32_t                 Reserved146                                      : __CODEGEN_BITFIELD(18, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 InvMarginVyl                                     : __CODEGEN_BITFIELD( 0, 15)    ; //!< INV_Margin_VYL
                uint32_t                 InvSkinTypesMargin                               : __CODEGEN_BITFIELD(16, 31)    ; //!< INV_SKIN_TYPES_MARGIN
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 InvMarginVyu                                     : __CODEGEN_BITFIELD( 0, 15)    ; //!< INV_MARGIN_VYU
                uint32_t                 P0L                                              : __CODEGEN_BITFIELD(16, 23)    ; //!< P0L
                uint32_t                 P1L                                              : __CODEGEN_BITFIELD(24, 31)    ; //!< P1L
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 P2L                                              : __CODEGEN_BITFIELD( 0,  7)    ; //!< P2L
                uint32_t                 P3L                                              : __CODEGEN_BITFIELD( 8, 15)    ; //!< P3L
                uint32_t                 B0L                                              : __CODEGEN_BITFIELD(16, 23)    ; //!< B0L
                uint32_t                 B1L                                              : __CODEGEN_BITFIELD(24, 31)    ; //!< B1L
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 B2L                                              : __CODEGEN_BITFIELD( 0,  7)    ; //!< B2L
                uint32_t                 B3L                                              : __CODEGEN_BITFIELD( 8, 15)    ; //!< B3L
                uint32_t                 S0L                                              : __CODEGEN_BITFIELD(16, 26)    ; //!< S0L
                uint32_t                 Reserved283                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 S1L                                              : __CODEGEN_BITFIELD( 0, 10)    ; //!< S1L
                uint32_t                 S2L                                              : __CODEGEN_BITFIELD(11, 21)    ; //!< S2L
                uint32_t                 Reserved310                                      : __CODEGEN_BITFIELD(22, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 S3L                                              : __CODEGEN_BITFIELD( 0, 10)    ; //!< S3L
                uint32_t                 P0U                                              : __CODEGEN_BITFIELD(11, 18)    ; //!< P0U
                uint32_t                 P1U                                              : __CODEGEN_BITFIELD(19, 26)    ; //!< P1U
                uint32_t                 Reserved347                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 P2U                                              : __CODEGEN_BITFIELD( 0,  7)    ; //!< P2U
                uint32_t                 P3U                                              : __CODEGEN_BITFIELD( 8, 15)    ; //!< P3U
                uint32_t                 B0U                                              : __CODEGEN_BITFIELD(16, 23)    ; //!< B0U
                uint32_t                 B1U                                              : __CODEGEN_BITFIELD(24, 31)    ; //!< B1U
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                uint32_t                 B2U                                              : __CODEGEN_BITFIELD( 0,  7)    ; //!< B2U
                uint32_t                 B3U                                              : __CODEGEN_BITFIELD( 8, 15)    ; //!< B3U
                uint32_t                 S0U                                              : __CODEGEN_BITFIELD(16, 26)    ; //!< S0U
                uint32_t                 Reserved411                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                uint32_t                 S1U                                              : __CODEGEN_BITFIELD( 0, 10)    ; //!< S1U
                uint32_t                 S2U                                              : __CODEGEN_BITFIELD(11, 21)    ; //!< S2U
                uint32_t                 Reserved438                                      : __CODEGEN_BITFIELD(22, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                uint32_t                 S3U                                              : __CODEGEN_BITFIELD( 0, 10)    ; //!< S3U
                uint32_t                 SkinTypesEnable                                  : __CODEGEN_BITFIELD(11, 11)    ; //!< SKIN_TYPES_ENABLE
                uint32_t                 SkinTypesThresh                                  : __CODEGEN_BITFIELD(12, 19)    ; //!< SKIN_TYPES_THRESH
                uint32_t                 SkinTypesMargin                                  : __CODEGEN_BITFIELD(20, 27)    ; //!< SKIN_TYPES_MARGIN
                uint32_t                 Reserved476                                      : __CODEGEN_BITFIELD(28, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                uint32_t                 Satp1                                            : __CODEGEN_BITFIELD( 0,  6)    ; //!< SATP1
                uint32_t                 Satp2                                            : __CODEGEN_BITFIELD( 7, 13)    ; //!< SATP2
                uint32_t                 Satp3                                            : __CODEGEN_BITFIELD(14, 20)    ; //!< SATP3
                uint32_t                 Satb1                                            : __CODEGEN_BITFIELD(21, 30)    ; //!< SATB1
                uint32_t                 Reserved511                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                uint32_t                 Satb2                                            : __CODEGEN_BITFIELD( 0,  9)    ; //!< SATB2
                uint32_t                 Satb3                                            : __CODEGEN_BITFIELD(10, 19)    ; //!< SATB3
                uint32_t                 Sats0                                            : __CODEGEN_BITFIELD(20, 30)    ; //!< SATS0
                uint32_t                 Reserved543                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                uint32_t                 Sats1                                            : __CODEGEN_BITFIELD( 0, 10)    ; //!< SATS1
                uint32_t                 Sats2                                            : __CODEGEN_BITFIELD(11, 21)    ; //!< SATS2
                uint32_t                 Reserved566                                      : __CODEGEN_BITFIELD(22, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                uint32_t                 Sats3                                            : __CODEGEN_BITFIELD( 0, 10)    ; //!< SATS3
                uint32_t                 Huep1                                            : __CODEGEN_BITFIELD(11, 17)    ; //!< HUEP1
                uint32_t                 Huep2                                            : __CODEGEN_BITFIELD(18, 24)    ; //!< HUEP2
                uint32_t                 Huep3                                            : __CODEGEN_BITFIELD(25, 31)    ; //!< HUEP3
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                uint32_t                 Hueb1                                            : __CODEGEN_BITFIELD( 0,  9)    ; //!< HUEB1
                uint32_t                 Hueb2                                            : __CODEGEN_BITFIELD(10, 19)    ; //!< HUEB2
                uint32_t                 Hueb3                                            : __CODEGEN_BITFIELD(20, 29)    ; //!< HUEB3
                uint32_t                 Reserved638                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                uint32_t                 Hues0                                            : __CODEGEN_BITFIELD( 0, 10)    ; //!< HUES0
                uint32_t                 Hues1                                            : __CODEGEN_BITFIELD(11, 21)    ; //!< HUES1
                uint32_t                 Reserved662                                      : __CODEGEN_BITFIELD(22, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                uint32_t                 Hues2                                            : __CODEGEN_BITFIELD( 0, 10)    ; //!< HUES2
                uint32_t                 Hues3                                            : __CODEGEN_BITFIELD(11, 21)    ; //!< HUES3
                uint32_t                 Reserved694                                      : __CODEGEN_BITFIELD(22, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                uint32_t                 Satp1Dark                                        : __CODEGEN_BITFIELD( 0,  6)    ; //!< SATP1_DARK
                uint32_t                 Satp2Dark                                        : __CODEGEN_BITFIELD( 7, 13)    ; //!< SATP2_DARK
                uint32_t                 Satp3Dark                                        : __CODEGEN_BITFIELD(14, 20)    ; //!< SATP3_DARK
                uint32_t                 Satb1Dark                                        : __CODEGEN_BITFIELD(21, 30)    ; //!< SATB1_DARK
                uint32_t                 Reserved735                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW22;
        union
        {
            struct
            {
                uint32_t                 Satb2Dark                                        : __CODEGEN_BITFIELD( 0,  9)    ; //!< SATB2_DARK
                uint32_t                 Satb3Dark                                        : __CODEGEN_BITFIELD(10, 19)    ; //!< SATB3_DARK
                uint32_t                 Sats0Dark                                        : __CODEGEN_BITFIELD(20, 30)    ; //!< SATS0_DARK
                uint32_t                 Reserved767                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW23;
        union
        {
            struct
            {
                uint32_t                 Sats1Dark                                        : __CODEGEN_BITFIELD( 0, 10)    ; //!< SATS1_DARK
                uint32_t                 Sats2Dark                                        : __CODEGEN_BITFIELD(11, 21)    ; //!< SATS2_DARK
                uint32_t                 Reserved790                                      : __CODEGEN_BITFIELD(22, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW24;
        union
        {
            struct
            {
                uint32_t                 Sats3Dark                                        : __CODEGEN_BITFIELD( 0, 10)    ; //!< SATS3_DARK
                uint32_t                 Huep1Dark                                        : __CODEGEN_BITFIELD(11, 17)    ; //!< HUEP1_DARK
                uint32_t                 Huep2Dark                                        : __CODEGEN_BITFIELD(18, 24)    ; //!< HUEP2_DARK
                uint32_t                 Huep3Dark                                        : __CODEGEN_BITFIELD(25, 31)    ; //!< HUEP3_DARK
            };
            uint32_t                     Value;
        } DW25;
        union
        {
            struct
            {
                uint32_t                 Hueb1Dark                                        : __CODEGEN_BITFIELD( 0,  9)    ; //!< HUEB1_DARK
                uint32_t                 Hueb2Dark                                        : __CODEGEN_BITFIELD(10, 19)    ; //!< HUEB2_DARK
                uint32_t                 Hueb3Dark                                        : __CODEGEN_BITFIELD(20, 29)    ; //!< HUEB3_DARK
                uint32_t                 Reserved862                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW26;
        union
        {
            struct
            {
                uint32_t                 Hues0Dark                                        : __CODEGEN_BITFIELD( 0, 10)    ; //!< HUES0_DARK
                uint32_t                 Hues1Dark                                        : __CODEGEN_BITFIELD(11, 21)    ; //!< HUES1_DARK
                uint32_t                 Reserved886                                      : __CODEGEN_BITFIELD(22, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW27;
        union
        {
            struct
            {
                uint32_t                 Hues2Dark                                        : __CODEGEN_BITFIELD( 0, 10)    ; //!< HUES2_DARK
                uint32_t                 Hues3Dark                                        : __CODEGEN_BITFIELD(11, 21)    ; //!< HUES3_DARK
                uint32_t                 Reserved918                                      : __CODEGEN_BITFIELD(22, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW28;

        //! \name Local enumerations

        enum OUTPUT_CONTROL
        {
            OUTPUT_CONTROL_OUTPUTPIXELS                                      = 0, //!< No additional details
            OUTPUT_CONTROL_OUTPUTSTDDECISIONS                                = 1, //!< No additional details
        };

        //! \brief SAT_MAX
        //! \details
        //!     Rectangle half length.
        enum SAT_MAX
        {
            SAT_MAX_UNNAMED31                                                = 31, //!< No additional details
        };

        //! \brief HUE_MAX
        //! \details
        //!     Rectangle half width.
        enum HUE_MAX
        {
            HUE_MAX_UNNAMED14                                                = 14, //!< No additional details
        };

        //! \brief U_MID
        //! \details
        //!     Rectangle middle-point U coordinate.
        enum U_MID
        {
            U_MID_UNNAMED110                                                 = 110, //!< No additional details
        };

        //! \brief V_MID
        //! \details
        //!     Rectangle middle-point V coordinate.
        enum V_MID
        {
            V_MID_UNNAMED154                                                 = 154, //!< No additional details
        };

        //! \brief SINA
        //! \details
        //!     The default is 101/128
        enum SINA
        {
            SINA_UNNAMED101                                                = 101, //!< No additional details
        };

        //! \brief COSA
        //! \details
        //!     The default is 79/128
        enum COSA
        {
            COSA_UNNAMED79                                                 = 79, //!< No additional details
        };

        //! \brief HS_MARGIN
        //! \details
        //!     Defines rectangle margin.
        enum HS_MARGIN
        {
            HS_MARGIN_UNNAMED3                                               = 3, //!< No additional details
        };

        //! \brief DIAMOND_DU
        //! \details
        //!     Rhombus center shift in the sat-direction, relative to the rectangle
        //!     center.
        enum DIAMOND_DU
        {
            DIAMOND_DU_UNNAMED0                                              = 0, //!< No additional details
        };

        enum DIAMOND_MARGIN
        {
            DIAMOND_MARGIN_UNNAMED4                                          = 4, //!< No additional details
        };

        //! \brief DIAMOND_DV
        //! \details
        //!     Rhombus center shift in the hue-direction, relative to the rectangle
        //!     center.
        enum DIAMOND_DV
        {
            DIAMOND_DV_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief DIAMOND_TH
        //! \details
        //!     Half length of the rhombus axis in the sat-direction.
        enum DIAMOND_TH
        {
            DIAMOND_TH_UNNAMED35                                             = 35, //!< No additional details
        };

        //! \brief DIAMOND_ALPHA
        //! \details
        //!     1/tan()The default is 100/64
        enum DIAMOND_ALPHA
        {
            DIAMOND_ALPHA_UNNAMED100                                         = 100, //!< No additional details
        };

        //! \brief Y_POINT_1
        //! \details
        //!     First point of the Y piecewise linear membership function.
        enum Y_POINT_1
        {
            Y_POINT_1_UNNAMED46                                              = 46, //!< No additional details
        };

        //! \brief Y_POINT_2
        //! \details
        //!     Second point of the Y piecewise linear membership function.
        enum Y_POINT_2
        {
            Y_POINT_2_UNNAMED47                                              = 47, //!< No additional details
        };

        //! \brief Y_POINT_3
        //! \details
        //!     Third point of the Y piecewise linear membership function.
        enum Y_POINT_3
        {
            Y_POINT_3_UNNAMED254                                             = 254, //!< No additional details
        };

        //! \brief Y_POINT_4
        //! \details
        //!     Fourth point of the Y piecewise linear membership function.
        enum Y_POINT_4
        {
            Y_POINT_4_UNNAMED255                                             = 255, //!< No additional details
        };

        //! \brief Y_SLOPE_1
        //! \details
        //!     Slope between points Y1 and Y2.
        enum Y_SLOPE_1
        {
            Y_SLOPE_1_UNNAMED31                                              = 31, //!< No additional details
        };

        //! \brief Y_SLOPE_2
        //! \details
        //!     Slope between points Y3 and Y4.
        enum Y_SLOPE_2
        {
            Y_SLOPE_2_UNNAMED31                                              = 31, //!< No additional details
        };

        //! \brief INV_SKIN_TYPES_MARGIN
        //! \details
        //!     1/(2* Skin_types_margin)
        enum INV_SKIN_TYPES_MARGIN
        {
            INV_SKIN_TYPES_MARGIN_SKINTYPEMARGIN                             = 20, //!< No additional details
            INV_SKIN_TYPES_MARGIN_UNNAMED1638                                = 1638, //!< No additional details
        };

        //! \brief INV_MARGIN_VYU
        //! \details
        //!     1 / Margin_VYU = 1600/65536
        enum INV_MARGIN_VYU
        {
            INV_MARGIN_VYU_UNNAMED1600                                       = 1600, //!< No additional details
        };

        //! \brief P0L
        //! \details
        //!     Y Point 0 of the lower part of the detection PWLF.
        enum P0L
        {
            P0L_UNNAMED46                                                    = 46, //!< No additional details
        };

        //! \brief P1L
        //! \details
        //!     Y Point 1 of the lower part of the detection PWLF.
        enum P1L
        {
            P1L_UNNAMED216                                                   = 216, //!< No additional details
        };

        //! \brief P2L
        //! \details
        //!     Y Point 2 of the lower part of the detection PWLF.
        enum P2L
        {
            P2L_UNNAMED236                                                   = 236, //!< No additional details
        };

        //! \brief P3L
        //! \details
        //!     Y Point 3 of the lower part of the detection PWLF.
        enum P3L
        {
            P3L_UNNAMED236                                                   = 236, //!< No additional details
        };

        //! \brief B0L
        //! \details
        //!     V Bias 0 of the lower part of the detection PWLF.
        enum B0L
        {
            B0L_UNNAMED133                                                   = 133, //!< No additional details
        };

        //! \brief B1L
        //! \details
        //!     V Bias 1 of the lower part of the detection PWLF.
        enum B1L
        {
            B1L_UNNAMED130                                                   = 130, //!< No additional details
        };

        //! \brief B2L
        //! \details
        //!     V Bias 2 of the lower part of the detection PWLF.
        enum B2L
        {
            B2L_UNNAMED130                                                   = 130, //!< No additional details
        };

        //! \brief B3L
        //! \details
        //!     V Bias 3 of the lower part of the detection PWLF.
        enum B3L
        {
            B3L_UNNAMED130                                                   = 130, //!< No additional details
        };

        //! \brief S0L
        //! \details
        //!     Slope 0 of the lower part of the detection PWLF.
        enum S0L
        {
            S0L_UNNAMED2043                                                  = 2043, //!< No additional details
        };

        //! \brief S1L
        //! \details
        //!     Slope 1 of the lower part of the detection PWLF.
        enum S1L
        {
            S1L_UNNAMED0                                                     = 0, //!< No additional details
        };

        //! \brief S2L
        //! \details
        //!     The default is 0/256
        enum S2L
        {
            S2L_UNNAMED0                                                     = 0, //!< No additional details
        };

        //! \brief S3L
        //! \details
        //!     Slope 3 of the lower part of the detection PWLF.
        enum S3L
        {
            S3L_UNNAMED0                                                     = 0, //!< No additional details
        };

        //! \brief P0U
        //! \details
        //!     Y Point 0 of the upper part of the detection PWLF.
        enum P0U
        {
            P0U_UNNAMED46                                                    = 46, //!< No additional details
        };

        //! \brief P1U
        //! \details
        //!     Y Point 1 of the upper part of the detection PWLF.
        enum P1U
        {
            P1U_UNNAMED66                                                    = 66, //!< No additional details
        };

        //! \brief P2U
        //! \details
        //!     Y Point 2 of the upper part of the detection PWLF.
        enum P2U
        {
            P2U_UNNAMED150                                                   = 150, //!< No additional details
        };

        //! \brief P3U
        //! \details
        //!     Y Point 3 of the upper part of the detection PWLF.
        enum P3U
        {
            P3U_UNNAMED236                                                   = 236, //!< No additional details
        };

        //! \brief B0U
        //! \details
        //!     V Bias 0 of the upper part of the detection PWLF.
        enum B0U
        {
            B0U_UNNAMED143                                                   = 143, //!< No additional details
        };

        //! \brief B1U
        //! \details
        //!     V Bias 1 of the upper part of the detection PWLF.
        enum B1U
        {
            B1U_UNNAMED163                                                   = 163, //!< No additional details
        };

        //! \brief B2U
        //! \details
        //!     V Bias 2 of the upper part of the detection PWLF.
        enum B2U
        {
            B2U_UNNAMED200                                                   = 200, //!< No additional details
        };

        //! \brief B3U
        //! \details
        //!     V Bias 3 of the upper part of the detection PWLF.
        enum B3U
        {
            B3U_UNNAMED140                                                   = 140, //!< No additional details
            B3U_UNNAMED200                                                   = 200, //!< No additional details
        };

        //! \brief S0U
        //! \details
        //!     Slope 0 of the upper part of the detection PWLF.
        enum S0U
        {
            S0U_UNNAMED256                                                   = 256, //!< No additional details
        };

        //! \brief S1U
        //! \details
        //!     Slope 1 of the upper part of the detection PWLF.
        enum S1U
        {
            S1U_UNNAMED113                                                   = 113, //!< No additional details
        };

        //! \brief S2U
        //! \details
        //!     Slope 2 of the upper part of the detection PWLF.
        enum S2U
        {
            S2U_UNNAMED1869                                                  = 1869, //!< No additional details
        };

        //! \brief S3U
        //! \details
        //!     Slope 3 of the upper part of the detection PWLF.
        enum S3U
        {
            S3U_UNNAMED0                                                     = 0, //!< No additional details
        };

        //! \brief SKIN_TYPES_ENABLE
        //! \details
        //!     Treat differently bright and dark skin types
        enum SKIN_TYPES_ENABLE
        {
            SKIN_TYPES_ENABLE_DISABLE                                        = 0, //!< No additional details
        };

        //! \brief SKIN_TYPES_THRESH
        //! \details
        //!     Skin types Y marginRestrict Skin_types_thresh >= Skin_types_margin
        //!     > 0Restrict (Skin_types_thresh + Skin_types_margin) <= 255
        enum SKIN_TYPES_THRESH
        {
            SKIN_TYPES_THRESH_UNNAMED120                                     = 120, //!< No additional details
        };

        //! \brief SKIN_TYPES_MARGIN
        //! \details
        //!     Skin types Y marginRestrict Skin_types_thresh >= Skin_types_margin
        //!     > 0Restrict (Skin_types_thresh + Skin_types_margin) <= 255
        enum SKIN_TYPES_MARGIN
        {
            SKIN_TYPES_MARGIN_UNNAMED20                                      = 20, //!< No additional details
        };

        //! \brief SATP1
        //! \details
        //!     First point for the saturation PWLF (bright skin). 
        //!     The default numerical valueis -6/64.
        enum SATP1
        {
            SATP1_UNNAMED122                                                 = 122, //!< No additional details
        };

        //! \brief SATP2
        //! \details
        //!     Second point for the saturation PWLF (bright skin).
        enum SATP2
        {
            SATP2_UNNAMED6                                                   = 6, //!< No additional details
        };

        //! \brief SATP3
        //! \details
        //!     Third point for the saturation PWLF (bright skin).
        enum SATP3
        {
            SATP3_UNNAMED31                                                  = 31, //!< No additional details
        };

        //! \brief SATB1
        //! \details
        //!     First bias for the saturation PWLF (bright skin).
        enum SATB1
        {
            SATB1_UNNAMED1016                                                = 1016, //!< No additional details
        };

        //! \brief SATB2
        //! \details
        //!     Second bias for the saturation PWLF (bright skin)
        enum SATB2
        {
            SATB2_UNNAMED8                                                   = 8, //!< No additional details
        };

        //! \brief SATB3
        //! \details
        //!     Third bias for the saturation PWLF (bright skin)
        enum SATB3
        {
            SATB3_UNNAMED124                                                 = 124, //!< No additional details
        };

        //! \brief SATS0
        //! \details
        //!     Zeroth slope for the saturation PWLF (bright skin)
        enum SATS0
        {
            SATS0_UNNAMED297                                                 = 297, //!< No additional details
        };

        //! \brief SATS1
        //! \details
        //!     First slope for the saturation PWLF (bright skin)
        enum SATS1
        {
            SATS1_UNNAMED85                                                  = 85, //!< No additional details
        };

        //! \brief SATS2
        //! \details
        //!     Second slope for the saturation PWLF (bright skin)
        enum SATS2
        {
            SATS2_UNNAMED297                                                 = 297, //!< No additional details
        };

        //! \brief SATS3
        //! \details
        //!     Third slope for the saturation PWLF (bright skin)
        enum SATS3
        {
            SATS3_UNNAMED256                                                 = 256, //!< No additional details
        };

        //! \brief HUEP1
        //! \details
        //!     First point for the hue PWLF (bright skin)
        enum HUEP1
        {
            HUEP1_6                                                          = 122, //!< No additional details
        };

        //! \brief HUEP2
        //! \details
        //!     Second point for the hue PWLF (bright skin)
        enum HUEP2
        {
            HUEP2_UNNAMED6                                                   = 6, //!< No additional details
        };

        //! \brief HUEP3
        //! \details
        //!     Third point for the hue PWLF (bright skin)
        enum HUEP3
        {
            HUEP3_UNNAMED14                                                  = 14, //!< No additional details
        };

        //! \brief HUEB1
        //! \details
        //!     First bias for the hue PWLF (bright skin)
        enum HUEB1
        {
            HUEB1_UNNAMED8                                                   = 8, //!< No additional details
            HUEB1_UNNAMED248                                                 = 248, //!< No additional details
        };

        //! \brief HUEB2
        //! \details
        //!     Second bias for the hue PWLF (bright skin)
        enum HUEB2
        {
            HUEB2_UNNAMED8                                                   = 8, //!< No additional details
        };

        //! \brief HUEB3
        //! \details
        //!     Third bias for the hue PWLF (bright skin)
        enum HUEB3
        {
            HUEB3_UNNAMED56                                                  = 56, //!< No additional details
        };

        //! \brief HUES0
        //! \details
        //!     Zeroth slope for the hue PWLF (bright skin)
        enum HUES0
        {
            HUES0_UNNAMED384                                                 = 384, //!< No additional details
        };

        //! \brief HUES1
        //! \details
        //!     First slope for the hue PWLF (bright skin)
        enum HUES1
        {
            HUES1_UNNAMED85                                                  = 85, //!< No additional details
        };

        //! \brief HUES2
        //! \details
        //!     Second slope for the hue PWLF (bright skin)
        enum HUES2
        {
            HUES2_UNNAMED384                                                 = 384, //!< No additional details
        };

        //! \brief HUES3
        //! \details
        //!     Third slope for the hue PWLF (bright skin)
        enum HUES3
        {
            HUES3_UNNAMED256                                                 = 256, //!< No additional details
        };

        //! \brief SATP1_DARK
        //! \details
        //!     First point for the saturation PWLF (dark skin) Default Value: -5
        enum SATP1_DARK
        {
            SATP1_DARK_UNNAMED123                                            = 123, //!< No additional details
        };

        //! \brief SATP2_DARK
        //! \details
        //!     Second point for the saturation PWLF (dark skin)
        enum SATP2_DARK
        {
            SATP2_DARK_UNNAMED31                                             = 31, //!< No additional details
        };

        //! \brief SATP3_DARK
        //! \details
        //!     Third point for the saturation PWLF (dark skin)
        enum SATP3_DARK
        {
            SATP3_DARK_UNNAMED31                                             = 31, //!< No additional details
        };

        //! \brief SATB1_DARK
        //! \details
        //!     First bias for the saturation PWLF (dark skin)
        enum SATB1_DARK
        {
            SATB1_DARK_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief SATB2_DARK
        //! \details
        //!     Second bias for the saturation PWLF (dark skin)
        enum SATB2_DARK
        {
            SATB2_DARK_UNNAMED124                                            = 124, //!< No additional details
        };

        //! \brief SATB3_DARK
        //! \details
        //!     Third bias for the saturation PWLF (dark skin)
        enum SATB3_DARK
        {
            SATB3_DARK_UNNAMED124                                            = 124, //!< No additional details
        };

        //! \brief SATS0_DARK
        //! \details
        //!     Zeroth slope for the saturation PWLF (dark skin)
        enum SATS0_DARK
        {
            SATS0_DARK_UNNAMED397                                            = 397, //!< No additional details
        };

        //! \brief SATS1_DARK
        //! \details
        //!     First slope for the saturation PWLF (dark skin)
        enum SATS1_DARK
        {
            SATS1_DARK_UNNAMED189                                            = 189, //!< No additional details
        };

        //! \brief SATS2_DARK
        //! \details
        //!     Second slope for the saturation PWLF (dark skin)
        enum SATS2_DARK
        {
            SATS2_DARK_UNNAMED256                                            = 256, //!< No additional details
        };

        //! \brief SATS3_DARK
        //! \details
        //!     Third slope for the saturation PWLF (dark skin)
        enum SATS3_DARK
        {
            SATS3_DARK_UNNAMED256                                            = 256, //!< No additional details
        };

        //! \brief HUEP1_DARK
        //! \details
        //!     First point for the hue PWLF (dark skin).
        enum HUEP1_DARK
        {
            HUEP1_DARK_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief HUEP2_DARK
        //! \details
        //!     Second point for the hue PWLF (dark skin).
        enum HUEP2_DARK
        {
            HUEP2_DARK_UNNAMED2                                              = 2, //!< No additional details
        };

        //! \brief HUEP3_DARK
        //! \details
        //!     Third point for the hue PWLF (dark skin).
        enum HUEP3_DARK
        {
            HUEP3_DARK_UNNAMED14                                             = 14, //!< No additional details
        };

        //! \brief HUEB1_DARK
        //! \details
        //!     First bias for the hue PWLF (dark skin).
        enum HUEB1_DARK
        {
            HUEB1_DARK_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief HUEB2_DARK
        //! \details
        //!     Second bias for the hue PWLF (dark skin).
        enum HUEB2_DARK
        {
            HUEB2_DARK_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief HUEB3_DARK
        //! \details
        //!     Third bias for the hue PWLF (dark skin).
        enum HUEB3_DARK
        {
            HUEB3_DARK_UNNAMED56                                             = 56, //!< No additional details
        };

        //! \brief HUES0_DARK
        //! \details
        //!     Zeroth slope for the hue PWLF (dark skin).
        enum HUES0_DARK
        {
            HUES0_DARK_UNNAMED256                                            = 256, //!< No additional details
            HUES0_DARK_UNNAMED299                                            = 299, //!< No additional details
        };

        //! \brief HUES1_DARK
        //! \details
        //!     First slope for the hue PWLF (dark skin).
        enum HUES1_DARK
        {
            HUES1_DARK_UNNAMED256                                            = 256, //!< No additional details
        };

        //! \brief HUES2_DARK
        //! \details
        //!     Second slope for the hue PWLF (dark skin).
        enum HUES2_DARK
        {
            HUES2_DARK_UNNAMED299                                            = 299, //!< No additional details
        };

        //! \brief HUES3_DARK
        //! \details
        //!     Third slope for the hue PWLF (dark skin).
        enum HUES3_DARK
        {
            HUES3_DARK_UNNAMED256                                            = 256, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_STD_STE_STATE_CMD();

        static const size_t dwSize = 29;
        static const size_t byteSize = 116;
    };

    //!
    //! \brief VEBOX_TCC_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for TCC
    //!     state.
    //!     
    struct VEBOX_TCC_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 Reserved0                                        : __CODEGEN_BITFIELD( 0,  6)    ; //!< Reserved
                uint32_t                 TccEnable                                        : __CODEGEN_BITFIELD( 7,  7)    ; //!< TCC Enable
                uint32_t                 Satfactor1                                       : __CODEGEN_BITFIELD( 8, 15)    ; //!< SATFACTOR1
                uint32_t                 Satfactor2                                       : __CODEGEN_BITFIELD(16, 23)    ; //!< SATFACTOR2
                uint32_t                 Satfactor3                                       : __CODEGEN_BITFIELD(24, 31)    ; //!< SATFACTOR3
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 Reserved32                                       : __CODEGEN_BITFIELD( 0,  7)    ; //!< Reserved
                uint32_t                 Satfactor4                                       : __CODEGEN_BITFIELD( 8, 15)    ; //!< SATFACTOR4
                uint32_t                 Satfactor5                                       : __CODEGEN_BITFIELD(16, 23)    ; //!< SATFACTOR5
                uint32_t                 Satfactor6                                       : __CODEGEN_BITFIELD(24, 31)    ; //!< SATFACTOR6
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 Basecolor1                                       : __CODEGEN_BITFIELD( 0,  9)    ; //!< BASECOLOR1
                uint32_t                 Basecolor2                                       : __CODEGEN_BITFIELD(10, 19)    ; //!< BASECOLOR2
                uint32_t                 Basecolor3                                       : __CODEGEN_BITFIELD(20, 29)    ; //!< BASECOLOR3
                uint32_t                 Reserved94                                       : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 Basecolo4                                        : __CODEGEN_BITFIELD( 0,  9)    ; //!< BASECOLO4
                uint32_t                 Basecolor5                                       : __CODEGEN_BITFIELD(10, 19)    ; //!< BASECOLOR5
                uint32_t                 Basecolor6                                       : __CODEGEN_BITFIELD(20, 29)    ; //!< BASECOLOR6
                uint32_t                 Reserved126                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 Colortransitslope2                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< COLORTRANSITSLOPE2
                uint32_t                 Colortransitslope23                              : __CODEGEN_BITFIELD(16, 31)    ; //!< COLORTRANSITSLOPE23
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 Colortransitslope34                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< COLORTRANSITSLOPE34
                uint32_t                 Colortransitslope45                              : __CODEGEN_BITFIELD(16, 31)    ; //!< COLORTRANSITSLOPE45
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 Colortransitslope56                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< COLORTRANSITSLOPE56
                uint32_t                 Colortransitslope61                              : __CODEGEN_BITFIELD(16, 31)    ; //!< COLORTRANSITSLOPE61
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 Reserved224                                      : __CODEGEN_BITFIELD( 0,  1)    ; //!< Reserved
                uint32_t                 Colorbias1                                       : __CODEGEN_BITFIELD( 2, 11)    ; //!< COLORBIAS1
                uint32_t                 Colorbias2                                       : __CODEGEN_BITFIELD(12, 21)    ; //!< COLORBIAS2
                uint32_t                 Colorbias3                                       : __CODEGEN_BITFIELD(22, 31)    ; //!< COLORBIAS3
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 Reserved256                                      : __CODEGEN_BITFIELD( 0,  1)    ; //!< Reserved
                uint32_t                 Colorbias4                                       : __CODEGEN_BITFIELD( 2, 11)    ; //!< COLORBIAS4
                uint32_t                 Colorbias5                                       : __CODEGEN_BITFIELD(12, 21)    ; //!< COLORBIAS5
                uint32_t                 Colorbias6                                       : __CODEGEN_BITFIELD(22, 31)    ; //!< COLORBIAS6
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 SteSlopeBits                                     : __CODEGEN_BITFIELD( 0,  2)    ; //!< STE_SLOPE_BITS
                uint32_t                 Reserved291                                      : __CODEGEN_BITFIELD( 3,  7)    ; //!< Reserved
                uint32_t                 SteThreshold                                     : __CODEGEN_BITFIELD( 8, 12)    ; //!< STE_THRESHOLD
                uint32_t                 Reserved301                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 UvThresholdBits                                  : __CODEGEN_BITFIELD(16, 18)    ; //!< UV_THRESHOLD_BITS
                uint32_t                 Reserved307                                      : __CODEGEN_BITFIELD(19, 23)    ; //!< Reserved
                uint32_t                 UvThreshold                                      : __CODEGEN_BITFIELD(24, 30)    ; //!< UV_THRESHOLD
                uint32_t                 Reserved319                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 Uvmaxcolor                                       : __CODEGEN_BITFIELD( 0,  8)    ; //!< UVMAXCOLOR
                uint32_t                 Reserved329                                      : __CODEGEN_BITFIELD( 9, 15)    ; //!< Reserved
                uint32_t                 InvUvmaxcolor                                    : __CODEGEN_BITFIELD(16, 31)    ; //!< INV_UVMAXCOLOR
            };
            uint32_t                     Value;
        } DW10;

        //! \name Local enumerations

        //! \brief SATFACTOR1
        //! \details
        //!     The saturation factor for magenta.
        enum SATFACTOR1
        {
            SATFACTOR1_UNNAMED160                                            = 160, //!< No additional details
            SATFACTOR1_UNNAMED220                                            = 220, //!< No additional details
        };

        //! \brief SATFACTOR2
        //! \details
        //!     The saturation factor for red.
        enum SATFACTOR2
        {
            SATFACTOR2_UNNAMED160                                            = 160, //!< No additional details
            SATFACTOR2_UNNAMED220                                            = 220, //!< No additional details
        };

        //! \brief SATFACTOR3
        //! \details
        //!     The saturation factor for yellow.
        enum SATFACTOR3
        {
            SATFACTOR3_UNNAMED160                                            = 160, //!< No additional details
            SATFACTOR3_UNNAMED220                                            = 220, //!< No additional details
        };

        //! \brief SATFACTOR4
        //! \details
        //!     The saturation factor for green.
        enum SATFACTOR4
        {
            SATFACTOR4_UNNAMED160                                            = 160, //!< No additional details
            SATFACTOR4_UNNAMED220                                            = 220, //!< No additional details
        };

        //! \brief SATFACTOR5
        //! \details
        //!     The saturation factor for cyan.
        enum SATFACTOR5
        {
            SATFACTOR5_UNNAMED160                                            = 160, //!< No additional details
            SATFACTOR5_UNNAMED220                                            = 220, //!< No additional details
        };

        //! \brief SATFACTOR6
        //! \details
        //!     The saturation factor for blue.
        enum SATFACTOR6
        {
            SATFACTOR6_UNNAMED160                                            = 160, //!< No additional details
            SATFACTOR6_UNNAMED220                                            = 220, //!< No additional details
        };

        //! \brief BASECOLOR1
        //! \details
        //!     Base Color 1
        enum BASECOLOR1
        {
            BASECOLOR1_UNNAMED145                                            = 145, //!< No additional details
        };

        //! \brief BASECOLOR2
        //! \details
        //!     Base Color 2 - this value must be greater than BaseColor1
        enum BASECOLOR2
        {
            BASECOLOR2_UNNAMED307                                            = 307, //!< No additional details
        };

        //! \brief BASECOLOR3
        //! \details
        //!     Base Color 3 - this value must be greater than BaseColor2
        enum BASECOLOR3
        {
            BASECOLOR3_UNNAMED483                                            = 483, //!< No additional details
        };

        //! \brief BASECOLO4
        //! \details
        //!     Base Color 4 - this value must be greater than BaseColor3
        enum BASECOLO4
        {
            BASECOLO4_UNNAMED657                                             = 657, //!< No additional details
        };

        //! \brief BASECOLOR5
        //! \details
        //!     Base Color 5 - this value must be greater than BaseColor4
        enum BASECOLOR5
        {
            BASECOLOR5_UNNAMED819                                            = 819, //!< No additional details
        };

        //! \brief BASECOLOR6
        //! \details
        //!     Base Color 6 - this value must be greater than BaseColor5
        enum BASECOLOR6
        {
            BASECOLOR6_UNNAMED995                                            = 995, //!< No additional details
        };

        //! \brief COLORTRANSITSLOPE2
        //! \details
        //!     The calculation result of 1 / (BC2 - BC1) [1/57]
        enum COLORTRANSITSLOPE2
        {
            COLORTRANSITSLOPE2_UNNAMED405                                    = 405, //!< No additional details
        };

        //! \brief COLORTRANSITSLOPE23
        //! \details
        //!     The calculation result of 1 / (BC3 - BC2) [1/62]
        enum COLORTRANSITSLOPE23
        {
            COLORTRANSITSLOPE23_UNNAMED744                                   = 744, //!< No additional details
        };

        //! \brief COLORTRANSITSLOPE34
        //! \details
        //!     The calculation result of 1 / (BC4 - BC3) [1/61]
        enum COLORTRANSITSLOPE34
        {
            COLORTRANSITSLOPE34_UNNAMED1131                                  = 1131, //!< No additional details
        };

        //! \brief COLORTRANSITSLOPE45
        //! \details
        //!     The calculation result of 1 / (BC5 - BC4) [1/57]
        enum COLORTRANSITSLOPE45
        {
            COLORTRANSITSLOPE45_UNNAMED407                                   = 407, //!< No additional details
        };

        //! \brief COLORTRANSITSLOPE56
        //! \details
        //!     The calculation result of 1 / (BC6 - BC5) [1/62]
        enum COLORTRANSITSLOPE56
        {
            COLORTRANSITSLOPE56_UNNAMED372                                   = 372, //!< No additional details
        };

        //! \brief COLORTRANSITSLOPE61
        //! \details
        //!     The calculation result of 1 / (BC1 - BC6) [1/62]
        enum COLORTRANSITSLOPE61
        {
            COLORTRANSITSLOPE61_UNNAMED377                                   = 377, //!< No additional details
        };

        //! \brief COLORBIAS1
        //! \details
        //!     Color bias for BaseColor1.
        enum COLORBIAS1
        {
            COLORBIAS1_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief COLORBIAS2
        //! \details
        //!     Color bias for BaseColor2.
        enum COLORBIAS2
        {
            COLORBIAS2_UNNAMED150                                            = 150, //!< No additional details
        };

        //! \brief COLORBIAS3
        //! \details
        //!     Color bias for BaseColor3.
        enum COLORBIAS3
        {
            COLORBIAS3_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief COLORBIAS4
        //! \details
        //!     Color bias for BaseColor4.
        enum COLORBIAS4
        {
            COLORBIAS4_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief COLORBIAS5
        //! \details
        //!     Color bias for BaseColor5.
        enum COLORBIAS5
        {
            COLORBIAS5_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief COLORBIAS6
        //! \details
        //!     Color bias for BaseColor6.
        enum COLORBIAS6
        {
            COLORBIAS6_UNNAMED0                                              = 0, //!< No additional details
        };

        //! \brief STE_SLOPE_BITS
        //! \details
        //!     Skin tone pixels enhancement slope bits.
        enum STE_SLOPE_BITS
        {
            STE_SLOPE_BITS_UNNAMED0                                          = 0, //!< No additional details
        };

        //! \brief STE_THRESHOLD
        //! \details
        //!     Skin tone pixels enhancement threshold.
        enum STE_THRESHOLD
        {
            STE_THRESHOLD_UNNAMED0                                           = 0, //!< No additional details
        };

        //! \brief UV_THRESHOLD_BITS
        //! \details
        //!     Low UV transition width bits.
        enum UV_THRESHOLD_BITS
        {
            UV_THRESHOLD_BITS_UNNAMED3                                       = 3, //!< No additional details
        };

        //! \brief UV_THRESHOLD
        //! \details
        //!     Low UV threshold.
        enum UV_THRESHOLD
        {
            UV_THRESHOLD_UNNAMED3                                            = 3, //!< No additional details
        };

        //! \brief UVMAXCOLOR
        //! \details
        //!     The maximum absolute value of the legal UV pixels.  Used for the SFs2
        //!     calculation.
        enum UVMAXCOLOR
        {
            UVMAXCOLOR_UNNAMED448                                            = 448, //!< No additional details
        };

        //! \brief INV_UVMAXCOLOR
        //! \details
        //!     1 / UVMaxColor.  Used for the SFs2 calculation.
        enum INV_UVMAXCOLOR
        {
            INV_UVMAXCOLOR_UNNAMED146                                        = 146, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_TCC_STATE_CMD();

        static const size_t dwSize = 11;
        static const size_t byteSize = 44;
    };

    //!
    //! \brief VEBOX_PROCAMP_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for ProcAmp
    //!     state.
    //!     
    struct VEBOX_PROCAMP_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 ProcampEnable                                    : __CODEGEN_BITFIELD( 0,  0)    ; //!< PROCAMP_ENABLE
                uint32_t                 Brightness                                       : __CODEGEN_BITFIELD( 1, 12)    ; //!< BRIGHTNESS
                uint32_t                 Reserved13                                       : __CODEGEN_BITFIELD(13, 16)    ; //!< Reserved
                uint32_t                 Contrast                                         : __CODEGEN_BITFIELD(17, 27)    ; //!< CONTRAST
                uint32_t                 Reserved28                                       : __CODEGEN_BITFIELD(28, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 SinCS                                            : __CODEGEN_BITFIELD( 0, 15)    ; //!< SIN_C_S
                uint32_t                 CosCS                                            : __CODEGEN_BITFIELD(16, 31)    ; //!< COS_C_S
            };
            uint32_t                     Value;
        } DW1;

        //! \name Local enumerations

        enum PROCAMP_ENABLE
        {
            PROCAMP_ENABLE_UNNAMED1                                          = 1, //!< No additional details
        };

        //! \brief BRIGHTNESS
        //! \details
        //!     Brightness magnitude.
        enum BRIGHTNESS
        {
            BRIGHTNESS_OR00                                                  = 0, //!< No additional details
        };

        //! \brief CONTRAST
        //! \details
        //!     Contrast magnitude.
        enum CONTRAST
        {
            CONTRAST_10INFIXEDPOINTU47                                       = 128, //!< No additional details
        };

        //! \brief SIN_C_S
        //! \details
        //!     UV multiplication sine factor.
        enum SIN_C_S
        {
            SIN_C_S_UNNAMED0                                                 = 0, //!< No additional details
        };

        //! \brief COS_C_S
        //! \details
        //!     UV multiplication cosine factor.
        enum COS_C_S
        {
            COS_C_S_UNNAMED256                                               = 256, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_PROCAMP_STATE_CMD();

        static const size_t dwSize = 2;
        static const size_t byteSize = 8;
    };

    //!
    //! \brief VEBOX_ACE_LACE_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for ACE
    //!     state.
    //!     
    struct VEBOX_ACE_LACE_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 AceEnable                                        : __CODEGEN_BITFIELD( 0,  0)    ; //!< ACE Enable
                uint32_t                 Reserved1                                        : __CODEGEN_BITFIELD( 1,  1)    ; //!< Reserved
                uint32_t                 SkinThreshold                                    : __CODEGEN_BITFIELD( 2,  6)    ; //!< SKIN_THRESHOLD
                uint32_t                 Reserved7                                        : __CODEGEN_BITFIELD( 7, 10)    ; //!< Reserved
                uint32_t                 LacePwlfCalculationMode                          : __CODEGEN_BITFIELD(11, 11)    ; //!< LACE_PWLF_CALCULATION_MODE
                uint32_t                 LaceHistogramEnable                              : __CODEGEN_BITFIELD(12, 12)    ; //!< LACE_HISTOGRAM_ENABLE
                uint32_t                 LaceHistogramSize                                : __CODEGEN_BITFIELD(13, 13)    ; //!< LACE_HISTOGRAM_SIZE
                uint32_t                 LaceSingleHistogramSet                           : __CODEGEN_BITFIELD(14, 15)    ; //!< LACE_SINGLE_HISTOGRAM_SET
                uint32_t                 MinAceLuma                                       : __CODEGEN_BITFIELD(16, 31)    ; //!< Min_ACE_luma
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 Ymin                                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< YMIN
                uint32_t                 Y1                                               : __CODEGEN_BITFIELD( 8, 15)    ; //!< Y1
                uint32_t                 Y2                                               : __CODEGEN_BITFIELD(16, 23)    ; //!< Y2
                uint32_t                 Y3                                               : __CODEGEN_BITFIELD(24, 31)    ; //!< Y3
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 Y4                                               : __CODEGEN_BITFIELD( 0,  7)    ; //!< Y4
                uint32_t                 Y5                                               : __CODEGEN_BITFIELD( 8, 15)    ; //!< Y5
                uint32_t                 Y6                                               : __CODEGEN_BITFIELD(16, 23)    ; //!< Y6
                uint32_t                 Y7                                               : __CODEGEN_BITFIELD(24, 31)    ; //!< Y7
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 Y8                                               : __CODEGEN_BITFIELD( 0,  7)    ; //!< Y8
                uint32_t                 Y9                                               : __CODEGEN_BITFIELD( 8, 15)    ; //!< Y9
                uint32_t                 Y10                                              : __CODEGEN_BITFIELD(16, 23)    ; //!< Y10
                uint32_t                 Ymax                                             : __CODEGEN_BITFIELD(24, 31)    ; //!< YMAX
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 B1                                               : __CODEGEN_BITFIELD( 0,  7)    ; //!< B1
                uint32_t                 B2                                               : __CODEGEN_BITFIELD( 8, 15)    ; //!< B2
                uint32_t                 B3                                               : __CODEGEN_BITFIELD(16, 23)    ; //!< B3
                uint32_t                 B4                                               : __CODEGEN_BITFIELD(24, 31)    ; //!< B4
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 B5                                               : __CODEGEN_BITFIELD( 0,  7)    ; //!< B5
                uint32_t                 B6                                               : __CODEGEN_BITFIELD( 8, 15)    ; //!< B6
                uint32_t                 B7                                               : __CODEGEN_BITFIELD(16, 23)    ; //!< B7
                uint32_t                 B8                                               : __CODEGEN_BITFIELD(24, 31)    ; //!< B8
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 B9                                               : __CODEGEN_BITFIELD( 0,  7)    ; //!< B9
                uint32_t                 B10                                              : __CODEGEN_BITFIELD( 8, 15)    ; //!< B10
                uint32_t                 Reserved208                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 S0                                               : __CODEGEN_BITFIELD( 0, 10)    ; //!< S0
                uint32_t                 Reserved235                                      : __CODEGEN_BITFIELD(11, 15)    ; //!< Reserved
                uint32_t                 S1                                               : __CODEGEN_BITFIELD(16, 26)    ; //!< S1
                uint32_t                 Reserved251                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 S2                                               : __CODEGEN_BITFIELD( 0, 10)    ; //!< S2
                uint32_t                 Reserved267                                      : __CODEGEN_BITFIELD(11, 15)    ; //!< Reserved
                uint32_t                 S3                                               : __CODEGEN_BITFIELD(16, 26)    ; //!< S3
                uint32_t                 Reserved283                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 S4                                               : __CODEGEN_BITFIELD( 0, 10)    ; //!< S4
                uint32_t                 Reserved299                                      : __CODEGEN_BITFIELD(11, 15)    ; //!< Reserved
                uint32_t                 S5                                               : __CODEGEN_BITFIELD(16, 26)    ; //!< S5
                uint32_t                 Reserved315                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 S6                                               : __CODEGEN_BITFIELD( 0, 10)    ; //!< S6
                uint32_t                 Reserved331                                      : __CODEGEN_BITFIELD(11, 15)    ; //!< Reserved
                uint32_t                 S7                                               : __CODEGEN_BITFIELD(16, 26)    ; //!< S7
                uint32_t                 Reserved347                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 S8                                               : __CODEGEN_BITFIELD( 0, 10)    ; //!< S8
                uint32_t                 Reserved363                                      : __CODEGEN_BITFIELD(11, 15)    ; //!< Reserved
                uint32_t                 S9                                               : __CODEGEN_BITFIELD(16, 26)    ; //!< S9
                uint32_t                 Reserved379                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                uint32_t                 S10                                              : __CODEGEN_BITFIELD( 0, 10)    ; //!< S10
                uint32_t                 Reserved395                                      : __CODEGEN_BITFIELD(11, 15)    ; //!< Reserved
                uint32_t                 MaxAceLuma                                       : __CODEGEN_BITFIELD(16, 31)    ; //!< Max_ACE_luma
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                uint32_t                 LaceYOffset                                      : __CODEGEN_BITFIELD( 0, 15)    ; //!< LACE Y Offset
                uint32_t                 Reserved432                                      : __CODEGEN_BITFIELD(16, 30)    ; //!< Reserved
                uint32_t                 LaceColorCorrectionEnable                        : __CODEGEN_BITFIELD(31, 31)    ; //!< LACE Color Correction Enable
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                uint32_t                 LaceUOffset                                      : __CODEGEN_BITFIELD( 0, 15)    ; //!< LACE U Offset
                uint32_t                 LaceVOffset                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< LACE V Offset
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint0                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 0
                uint32_t                 LaceGammaCurveBias0                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 0
                uint32_t                 LaceGammaCurveSlope0                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 0
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint1                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 1
                uint32_t                 LaceGammaCurveBias1                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 1
                uint32_t                 LaceGammaCurveSlope1                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 1
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint2                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 2
                uint32_t                 LaceGammaCurveBias2                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 2
                uint32_t                 LaceGammaCurveSlope2                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 2
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint3                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 3
                uint32_t                 LaceGammaCurveBias3                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 3
                uint32_t                 LaceGammaCurveSlope3                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 3
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint4                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 4
                uint32_t                 LaceGammaCurveBias4                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 4
                uint32_t                 LaceGammaCurveSlope4                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 4
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint5                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 5
                uint32_t                 LaceGammaCurveBias5                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 5
                uint32_t                 LaceGammaCurveSlope5                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 5
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint6                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 6
                uint32_t                 LaceGammaCurveBias6                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 6
                uint32_t                 LaceGammaCurveSlope6                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 6
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint7                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 7
                uint32_t                 LaceGammaCurveBias7                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 7
                uint32_t                 LaceGammaCurveSlope7                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 7
            };
            uint32_t                     Value;
        } DW22;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint8                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 8
                uint32_t                 LaceGammaCurveBias8                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 8
                uint32_t                 LaceGammaCurveSlope8                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 8
            };
            uint32_t                     Value;
        } DW23;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint9                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 9
                uint32_t                 LaceGammaCurveBias9                              : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 9
                uint32_t                 LaceGammaCurveSlope9                             : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 9
            };
            uint32_t                     Value;
        } DW24;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint10                            : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 10
                uint32_t                 LaceGammaCurveBias10                             : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 10
                uint32_t                 LaceGammaCurveSlope10                            : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 10
            };
            uint32_t                     Value;
        } DW25;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint11                            : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 11
                uint32_t                 LaceGammaCurveBias11                             : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 11
                uint32_t                 LaceGammaCurveSlope11                            : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 11
            };
            uint32_t                     Value;
        } DW26;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint12                            : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 12
                uint32_t                 LaceGammaCurveBias12                             : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 12
                uint32_t                 LaceGammaCurveSlope12                            : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 12
            };
            uint32_t                     Value;
        } DW27;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint13                            : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 13
                uint32_t                 LaceGammaCurveBias13                             : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 13
                uint32_t                 LaceGammaCurveSlope13                            : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 13
            };
            uint32_t                     Value;
        } DW28;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint14                            : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 14
                uint32_t                 LaceGammaCurveBias14                             : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 14
                uint32_t                 LaceGammaCurveSlope14                            : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 14
            };
            uint32_t                     Value;
        } DW29;
        union
        {
            struct
            {
                uint32_t                 LaceGammaCurvePoint15                            : __CODEGEN_BITFIELD( 0,  7)    ; //!< LACE gamma curve point 15
                uint32_t                 LaceGammaCurveBias15                             : __CODEGEN_BITFIELD( 8, 20)    ; //!< LACE gamma curve bias 15
                uint32_t                 LaceGammaCurveSlope15                            : __CODEGEN_BITFIELD(21, 31)    ; //!< LACE gamma curve slope 15
            };
            uint32_t                     Value;
        } DW30;

        //! \name Local enumerations

        //! \brief SKIN_THRESHOLD
        //! \details
        //!     Used for Y analysis (min/max) for pixels which are higher than skin
        //!     threshold.
        enum SKIN_THRESHOLD
        {
            SKIN_THRESHOLD_UNNAMED26                                         = 26, //!< No additional details
        };

        //! \brief LACE_PWLF_CALCULATION_MODE
        //! \details
        //!     0 - External calculated LACE PWLF used, e.g. software calculated.
        //!       1 - VEBOX internal calculated LACE PWLF used.
        enum LACE_PWLF_CALCULATION_MODE
        {
            LACE_PWLF_CALCULATION_MODE_UNNAMED0                              = 0, //!< No additional details
        };

        //! \brief LACE_HISTOGRAM_ENABLE
        //! \details
        //!     This bit enables the collection of LACE histogram data. If this bit is 0
        //!     then only the ACE histogram will be collected.
        enum LACE_HISTOGRAM_ENABLE
        {
            LACE_HISTOGRAM_ENABLE_UNNAMED0                                   = 0, //!< No additional details
        };

        enum LACE_HISTOGRAM_SIZE
        {
            LACE_HISTOGRAM_SIZE_128_BINHISTOGRAM                             = 0, //!< No additional details
            LACE_HISTOGRAM_SIZE_256_BINHISTOGRAM                             = 1, //!< No additional details
        };

        //! \brief LACE_SINGLE_HISTOGRAM_SET
        //! \details
        //!     This bit tells LACE which frames will be included in the histogram when
        //!     the Deinterlacer is enabled.
        enum LACE_SINGLE_HISTOGRAM_SET
        {
            LACE_SINGLE_HISTOGRAM_SET_CURRENT                                = 0, //!< The histogram includes only the current frame.
            LACE_SINGLE_HISTOGRAM_SET_PREVIOUS                               = 1, //!< The histogram includes only the previous frame.
            LACE_SINGLE_HISTOGRAM_SET_CURRENTPREVIOUS                        = 2, //!< The histogram includes pixels from both the current and previous frame.
            LACE_SINGLE_HISTOGRAM_SET_PREVIOUSCURRENT                        = 3, //!< The histogram includes the previous frame followed by the current frame.
        };

        //! \brief YMIN
        //! \details
        //!     The value of the y_pixel for point 0 in PWL.
        enum YMIN
        {
            YMIN_UNNAMED16                                                   = 16, //!< No additional details
        };

        //! \brief Y1
        //! \details
        //!     The value of the y_pixel for point 1 in PWL.
        enum Y1
        {
            Y1_UNNAMED36                                                     = 36, //!< No additional details
        };

        //! \brief Y2
        //! \details
        //!     The value of the y_pixel for point 2 in PWL.
        enum Y2
        {
            Y2_UNNAMED56                                                     = 56, //!< No additional details
        };

        //! \brief Y3
        //! \details
        //!     The value of the y_pixel for point 3 in PWL.
        enum Y3
        {
            Y3_UNNAMED76                                                     = 76, //!< No additional details
        };

        //! \brief Y4
        //! \details
        //!     The value of the y_pixel for point 4 in PWL.
        enum Y4
        {
            Y4_UNNAMED96                                                     = 96, //!< No additional details
        };

        //! \brief Y5
        //! \details
        //!     The value of the y_pixel for point 5 in PWL.
        enum Y5
        {
            Y5_UNNAMED116                                                    = 116, //!< No additional details
        };

        //! \brief Y6
        //! \details
        //!     The value of the y_pixel for point 6 in PWL.
        enum Y6
        {
            Y6_UNNAMED136                                                    = 136, //!< No additional details
        };

        //! \brief Y7
        //! \details
        //!     The value of the y_pixel for point 7 in PWL.
        enum Y7
        {
            Y7_UNNAMED156                                                    = 156, //!< No additional details
        };

        //! \brief Y8
        //! \details
        //!     The value of the y_pixel for point 8 in PWL.
        enum Y8
        {
            Y8_UNNAMED176                                                    = 176, //!< No additional details
        };

        //! \brief Y9
        //! \details
        //!     The value of the y_pixel for point 9 in PWL.
        enum Y9
        {
            Y9_UNNAMED196                                                    = 196, //!< No additional details
        };

        //! \brief Y10
        //! \details
        //!     The value of the y_pixel for point 10 in PWL.
        enum Y10
        {
            Y10_UNNAMED216                                                   = 216, //!< No additional details
        };

        //! \brief YMAX
        //! \details
        //!     The value of the y_pixel for point 11 in PWL.
        enum YMAX
        {
            YMAX_UNNAMED235                                                  = 235, //!< No additional details
        };

        //! \brief B1
        //! \details
        //!     The value of the bias for point 1 in PWL.
        enum B1
        {
            B1_UNNAMED36                                                     = 36, //!< No additional details
        };

        //! \brief B2
        //! \details
        //!     The value of the bias for point 2 in PWL.
        enum B2
        {
            B2_UNNAMED56                                                     = 56, //!< No additional details
        };

        //! \brief B3
        //! \details
        //!     The value of the bias for point 3 in PWL.
        enum B3
        {
            B3_UNNAMED76                                                     = 76, //!< No additional details
        };

        //! \brief B4
        //! \details
        //!     The value of the bias for point 4 in PWL.
        enum B4
        {
            B4_UNNAMED96                                                     = 96, //!< No additional details
        };

        //! \brief B5
        //! \details
        //!     The value of the bias for point 5 in PWL.
        enum B5
        {
            B5_UNNAMED116                                                    = 116, //!< No additional details
        };

        //! \brief B6
        //! \details
        //!     The value of the bias for point 6 in PWL.
        enum B6
        {
            B6_UNNAMED136                                                    = 136, //!< No additional details
        };

        //! \brief B7
        //! \details
        //!     The value of the bias for point 7 in PWL.
        enum B7
        {
            B7_UNNAMED156                                                    = 156, //!< No additional details
        };

        //! \brief B8
        //! \details
        //!     The value of the bias for point 8 in PWL.
        enum B8
        {
            B8_UNNAMED176                                                    = 176, //!< No additional details
        };

        //! \brief B9
        //! \details
        //!     The value of the bias for point 9 in PWL.
        enum B9
        {
            B9_UNNAMED196                                                    = 196, //!< No additional details
        };

        //! \brief B10
        //! \details
        //!     The value of the bias for point 10 in PWL.
        enum B10
        {
            B10_UNNAMED216                                                   = 216, //!< No additional details
        };

        //! \brief S0
        //! \details
        //!     The value of the slope for point 0 in PWL
        enum S0
        {
            S0_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S1
        //! \details
        //!     The value of the slope for point 1 in PWL
        enum S1
        {
            S1_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S2
        //! \details
        //!     The value of the slope for point 2 in PWL
        enum S2
        {
            S2_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S3
        //! \details
        //!     The value of the slope for point 3 in PWL
        enum S3
        {
            S3_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S4
        //! \details
        //!     The value of the slope for point 4 in PWL
        enum S4
        {
            S4_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S5
        //! \details
        //!     The value of the slope for point 5 in PWL
        enum S5
        {
            S5_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S6
        //! \details
        //!     The default is 1024/1024
        enum S6
        {
            S6_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S7
        //! \details
        //!     The value of the slope for point 7 in PWL
        enum S7
        {
            S7_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S8
        //! \details
        //!     The value of the slope for point 8 in PWL
        enum S8
        {
            S8_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S9
        //! \details
        //!     The value of the slope for point 9 in PWL
        enum S9
        {
            S9_UNNAMED1024                                                   = 1024, //!< No additional details
        };

        //! \brief S10
        //! \details
        //!     The value of the slope for point 10 in PWL.
        enum S10
        {
            S10_UNNAMED1024                                                  = 1024, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_ACE_LACE_STATE_CMD();

        static const size_t dwSize = 31;
        static const size_t byteSize = 124;
    };

    //!
    //! \brief VEBOX_ALPHA_AOI_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for Fixed
    //!     Alpha State and Area of Interest State.
    //!     
    struct VEBOX_ALPHA_AOI_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 ColorPipeAlpha                                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< Color Pipe Alpha
                uint32_t                 AlphaFromStateSelect                             : __CODEGEN_BITFIELD(16, 16)    ; //!< ALPHA_FROM_STATE_SELECT
                uint32_t                 FullImageHistogram                               : __CODEGEN_BITFIELD(17, 17)    ; //!< FULL_IMAGE_HISTOGRAM
                uint32_t                 DisableHistogram                                 : __CODEGEN_BITFIELD(18, 18)    ; //!< Disable histogram
                uint32_t                 Reserved19                                       : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 AoiMinX                                          : __CODEGEN_BITFIELD( 0, 13)    ; //!< AOI_MIN_X
                uint32_t                 Reserved46                                       : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 AoiMaxX                                          : __CODEGEN_BITFIELD(16, 29)    ; //!< AOI_MAX_X
                uint32_t                 Reserved62                                       : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 AoiMinY                                          : __CODEGEN_BITFIELD( 0, 13)    ; //!< AOI_MIN_Y
                uint32_t                 Reserved78                                       : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 AoiMaxY                                          : __CODEGEN_BITFIELD(16, 29)    ; //!< AOI_MAX_Y
                uint32_t                 Reserved94                                       : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW2;

        //! \name Local enumerations

        //! \brief ALPHA_FROM_STATE_SELECT
        //! \details
        //!     If the input format does not have alpha available and the output format
        //!     provides alpha, this bit should be set to 1. This
        //!     should be 0 when Alpha Plane Enable is 1.
        enum ALPHA_FROM_STATE_SELECT
        {
            ALPHA_FROM_STATE_SELECT_ALPHAISTAKENFROMMESSAGE                  = 0, //!< No additional details
            ALPHA_FROM_STATE_SELECT_ALPHAISTAKENFROMSTATE                    = 1, //!< No additional details
        };

        //! \brief FULL_IMAGE_HISTOGRAM
        //! \details
        //!     Used to ignore the area of interest for a histogram across the full
        //!     image. This applies to all statistics that are affected by AOI (Area of
        //!     Interest).
        enum FULL_IMAGE_HISTOGRAM
        {
            FULL_IMAGE_HISTOGRAM_UNNAMED0                                    = 0, //!< No additional details
        };

        //! \brief AOI_MIN_X
        //! \details
        //!     This value must be a multiple of 4.
        enum AOI_MIN_X
        {
            AOI_MIN_X_UNNAMED0                                               = 0, //!< No additional details
        };

        //! \brief AOI_MAX_X
        //! \details
        //!     Area of Interest Minimum X - The ACE histogram and Skin Tone Detection
        //!     statistic gathering will occur within the MinX/MinY to MaxX/MaxY area
        //!     (inclusive).AOI must intersect the frame such that
        //!     at least 1 pixel is in the AOI.
        enum AOI_MAX_X
        {
            AOI_MAX_X_UNNAMED0                                               = 0, //!< No additional details
        };

        //! \brief AOI_MIN_Y
        //! \details
        //!     This value must be a multiple of 4.
        enum AOI_MIN_Y
        {
            AOI_MIN_Y_UNNAMED0                                               = 0, //!< No additional details
        };

        //! \brief AOI_MAX_Y
        //! \details
        //!     This value must be a multiple of 4 minus 1.
        enum AOI_MAX_Y
        {
            AOI_MAX_Y_UNNAMED0                                               = 0, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_ALPHA_AOI_STATE_CMD();

        static const size_t dwSize = 3;
        static const size_t byteSize = 12;
    };

    //!
    //! \brief VEBOX_CAPTURE_PIPE_STATE
    //! \details
    //!     This command  contains variables for controlling Demosaic and the White
    //!     Balance Statistics.
    //!     
    struct VEBOX_CAPTURE_PIPE_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 GoodPixelNeighborThreshold                       : __CODEGEN_BITFIELD( 0,  5)    ; //!< GOOD_PIXEL_NEIGHBOR_THRESHOLD
                uint32_t                 Reserved6                                        : __CODEGEN_BITFIELD( 6,  7)    ; //!< Reserved
                uint32_t                 AverageColorThreshold                            : __CODEGEN_BITFIELD( 8, 15)    ; //!< AVERAGE_COLOR_THRESHOLD
                uint32_t                 GreenImbalanceThreshold                          : __CODEGEN_BITFIELD(16, 19)    ; //!< GREEN_IMBALANCE_THRESHOLD
                uint32_t                 ShiftMinCost                                     : __CODEGEN_BITFIELD(20, 22)    ; //!< SHIFT_MIN_COST
                uint32_t                 Reserved23                                       : __CODEGEN_BITFIELD(23, 23)    ; //!< Reserved
                uint32_t                 GoodPixelThreshold                               : __CODEGEN_BITFIELD(24, 29)    ; //!< GOOD_PIXEL_THRESHOLD
                uint32_t                 DirmapScale                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< DIRMAP_SCALE
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 BadColorThreshold3                               : __CODEGEN_BITFIELD( 0,  3)    ; //!< BAD_COLOR_THRESHOLD_3
                uint32_t                 NumberBigPixelThreshold                          : __CODEGEN_BITFIELD( 4,  7)    ; //!< NUMBER_BIG_PIXEL_THRESHOLD
                uint32_t                 BadColorThreshold2                               : __CODEGEN_BITFIELD( 8, 15)    ; //!< BAD_COLOR_THRESHOLD_2
                uint32_t                 BadColorThreshold1                               : __CODEGEN_BITFIELD(16, 23)    ; //!< BAD_COLOR_THRESHOLD_1
                uint32_t                 GoodIntesityThreshold                            : __CODEGEN_BITFIELD(24, 27)    ; //!< GOOD_INTESITY_THRESHOLD
                uint32_t                 ScaleForMinCost                                  : __CODEGEN_BITFIELD(28, 31)    ; //!< SCALE_FOR_MIN_COST
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 WhiteBalanceCorrectionEnable                     : __CODEGEN_BITFIELD( 0,  0)    ; //!< White Balance Correction Enable
                uint32_t                 BlackPointCorrectionEnable                       : __CODEGEN_BITFIELD( 1,  1)    ; //!< Black Point Correction Enable
                uint32_t                 VignetteCorrectionFormat                         : __CODEGEN_BITFIELD( 2,  2)    ; //!< VIGNETTE_CORRECTION_FORMAT
                uint32_t                 RgbHistogramEnable                               : __CODEGEN_BITFIELD( 3,  3)    ; //!< RGB Histogram Enable
                uint32_t                 BlackPointOffsetGreenBottomMsb                   : __CODEGEN_BITFIELD( 4,  4)    ; //!< Black Point Offset Green Bottom MSB
                uint32_t                 BlackPointOffsetBlueMsb                          : __CODEGEN_BITFIELD( 5,  5)    ; //!< Black Point Offset Blue MSB
                uint32_t                 BlackPointOffsetGreenTopMsb                      : __CODEGEN_BITFIELD( 6,  6)    ; //!< Black Point Offset Green Top MSB
                uint32_t                 BlackPointOffsetRedMsb                           : __CODEGEN_BITFIELD( 7,  7)    ; //!< Black Point Offset Red MSB
                uint32_t                 UvThresholdValue                                 : __CODEGEN_BITFIELD( 8, 15)    ; //!< UV_THRESHOLD_VALUE
                uint32_t                 YOutlierValue                                    : __CODEGEN_BITFIELD(16, 23)    ; //!< Y_OUTLIER_VALUE
                uint32_t                 YBrightValue                                     : __CODEGEN_BITFIELD(24, 31)    ; //!< Y_BRIGHT_VALUE
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 BlackPointOffsetGreenTop                         : __CODEGEN_BITFIELD( 0, 15)    ; //!< BLACK_POINT_OFFSET_GREEN_TOP
                uint32_t                 BlackPointOffsetRed                              : __CODEGEN_BITFIELD(16, 31)    ; //!< BLACK_POINT_OFFSET_RED
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 BlackPointOffsetGreenBottom                      : __CODEGEN_BITFIELD( 0, 15)    ; //!< BLACK_POINT_OFFSET_GREEN_BOTTOM
                uint32_t                 BlackPointOffsetBlue                             : __CODEGEN_BITFIELD(16, 31)    ; //!< BLACK_POINT_OFFSET_BLUE
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 WhiteBalanceGreenTopCorrection                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< White Balance Green Top Correction
                uint32_t                 WhiteBalanceRedCorrection                        : __CODEGEN_BITFIELD(16, 31)    ; //!< White Balance Red Correction
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 WhiteBalanceGreenBottomCorrection                : __CODEGEN_BITFIELD( 0, 15)    ; //!< White Balance Green Bottom Correction
                uint32_t                 WhiteBalanceBlueCorrection                       : __CODEGEN_BITFIELD(16, 31)    ; //!< White Balance Blue Correction
            };
            uint32_t                     Value;
        } DW6;

        //! \name Local enumerations

        //! \brief GOOD_PIXEL_NEIGHBOR_THRESHOLD
        //! \details
        //!     Number of comparisons with neighbor pixels which pass before a pixel is
        //!     considered good.
        enum GOOD_PIXEL_NEIGHBOR_THRESHOLD
        {
            GOOD_PIXEL_NEIGHBOR_THRESHOLD_UNNAMED35                          = 35, //!< No additional details
        };

        //! \brief AVERAGE_COLOR_THRESHOLD
        //! \details
        //!     The threshold between two colors in a pixel for the Avg interpolation to
        //!     be considered.
        enum AVERAGE_COLOR_THRESHOLD
        {
            AVERAGE_COLOR_THRESHOLD_UNNAMED255                               = 255, //!< No additional details
        };

        enum GREEN_IMBALANCE_THRESHOLD
        {
            GREEN_IMBALANCE_THRESHOLD_UNNAMED1                               = 1, //!< No additional details
        };

        //! \brief SHIFT_MIN_COST
        //! \details
        //!     The amount to shift the H2/V2 versions of min_cost.
        enum SHIFT_MIN_COST
        {
            SHIFT_MIN_COST_UNNAMED1                                          = 1, //!< No additional details
        };

        //! \brief GOOD_PIXEL_THRESHOLD
        //! \details
        //!     The difference threshold between adjacent pixels for a pixel to be
        //!     considered "good".
        enum GOOD_PIXEL_THRESHOLD
        {
            GOOD_PIXEL_THRESHOLD_UNNAMED5                                    = 5, //!< No additional details
        };

        enum DIRMAP_SCALE
        {
            DIRMAP_SCALE_UNNAMED2                                            = 2, //!< No additional details
        };

        //! \brief BAD_COLOR_THRESHOLD_3
        //! \details
        //!     Color value threshold used during the bad pixel check.
        enum BAD_COLOR_THRESHOLD_3
        {
            BAD_COLOR_THRESHOLD_3_UNNAMED10                                  = 10, //!< No additional details
        };

        //! \brief NUMBER_BIG_PIXEL_THRESHOLD
        //! \details
        //!     Number of comparisons with neighbor pixels which pass before a pixel is
        //!     considered good.
        enum NUMBER_BIG_PIXEL_THRESHOLD
        {
            NUMBER_BIG_PIXEL_THRESHOLD_UNNAMED10                             = 10, //!< No additional details
        };

        //! \brief BAD_COLOR_THRESHOLD_2
        //! \details
        //!     Color value threshold used during the bad pixel check.
        enum BAD_COLOR_THRESHOLD_2
        {
            BAD_COLOR_THRESHOLD_2_UNNAMED175                                 = 175, //!< No additional details
        };

        //! \brief BAD_COLOR_THRESHOLD_1
        //! \details
        //!     Color value threshold used during the bad pixel check.
        enum BAD_COLOR_THRESHOLD_1
        {
            BAD_COLOR_THRESHOLD_1_UNNAMED100                                 = 100, //!< No additional details
        };

        enum GOOD_INTESITY_THRESHOLD
        {
            GOOD_INTESITY_THRESHOLD_UNNAMED10                                = 10, //!< No additional details
        };

        //! \brief SCALE_FOR_MIN_COST
        //! \details
        //!     The amount to scale the min_cost difference during the confidence check.
        enum SCALE_FOR_MIN_COST
        {
            SCALE_FOR_MIN_COST_UNNAMED10                                     = 10, //!< No additional details
        };

        //! \brief VIGNETTE_CORRECTION_FORMAT
        //! \details
        //!     Defines what shift should be assumed for the Vignette Correction
        //!     input values:
        enum VIGNETTE_CORRECTION_FORMAT
        {
            VIGNETTE_CORRECTION_FORMAT_U88                                   = 0, //!< No additional details
            VIGNETTE_CORRECTION_FORMAT_U412                                  = 1, //!< No additional details
        };

        //! \brief UV_THRESHOLD_VALUE
        //! \details
        //!     The value denotes the maximum threshold of the ratio between U+V to Y
        //!     can have to be considered a gray point.
        enum UV_THRESHOLD_VALUE
        {
            UV_THRESHOLD_VALUE_UNNAMED64                                     = 64, //!< 0.25 * 255 = 64
        };

        //! \brief Y_OUTLIER_VALUE
        //! \details
        //!     The outlier threshold percentile in the Y histogram. Any pixel with Y
        //!     value above this either clipped or an outlier in the image. These points
        //!     will not be included in the white patch calculation.
        enum Y_OUTLIER_VALUE
        {
            Y_OUTLIER_VALUE_UNNAMED253                                       = 253, //!< No additional details
        };

        //! \brief Y_BRIGHT_VALUE
        //! \details
        //!     The whitepoint threshold percentile in the Y histogram. Any pixel with Y
        //!     value above this could be a whitepoint. This is the
        //!     larger of the calculated Ybright value and the Ythreshold value, which
        //!     is the minimum Y required to be considered a white point.
        enum Y_BRIGHT_VALUE
        {
            Y_BRIGHT_VALUE_UNNAMED230                                        = 230, //!< No additional details
        };

        //! \brief BLACK_POINT_OFFSET_GREEN_TOP
        //! \details
        //!     Value subtracted from the top Green pixels of Bayer pattern (X=1, Y=0
        //!     for Bayer Pattern #1) - combined with MSB to form a 2's complement
        //!     signed number.
        enum BLACK_POINT_OFFSET_GREEN_TOP
        {
            BLACK_POINT_OFFSET_GREEN_TOP_UNNAMED0                            = 0, //!< No additional details
        };

        //! \brief BLACK_POINT_OFFSET_RED
        //! \details
        //!     Value subtracted from Red pixels of Bayer pattern - combined with MSB to
        //!     form a 2's complement signed number.
        enum BLACK_POINT_OFFSET_RED
        {
            BLACK_POINT_OFFSET_RED_UNNAMED0                                  = 0, //!< No additional details
        };

        //! \brief BLACK_POINT_OFFSET_GREEN_BOTTOM
        //! \details
        //!     Value subtracted from the bottom Green pixels of Bayer pattern (X=0, Y=1
        //!     for Bayer Pattern #1) - combined with MSB to form a 2's complement
        //!     signed number.
        enum BLACK_POINT_OFFSET_GREEN_BOTTOM
        {
            BLACK_POINT_OFFSET_GREEN_BOTTOM_UNNAMED0                         = 0, //!< No additional details
        };

        //! \brief BLACK_POINT_OFFSET_BLUE
        //! \details
        //!     Value subtracted from Blue pixels of Bayer pattern - Combine with MSB to
        //!     form a 2's complement signed number.
        enum BLACK_POINT_OFFSET_BLUE
        {
            BLACK_POINT_OFFSET_BLUE_UNNAMED0                                 = 0, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_CAPTURE_PIPE_STATE_CMD();

        static const size_t dwSize = 7;
        static const size_t byteSize = 28;
    };

    //!
    //! \brief VEBOX_CCM_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for the
    //!     Color Correction Matrix State.
    //!     
    struct VEBOX_CCM_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 C1                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C1
                uint32_t                 Reserved27                                       : __CODEGEN_BITFIELD(27, 30)    ; //!< Reserved
                uint32_t                 ColorCorrectionMatrixEnable                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Color Correction Matrix Enable
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 C0                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C0
                uint32_t                 Reserved59                                       : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 C3                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C3
                uint32_t                 Reserved91                                       : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 C2                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C2
                uint32_t                 Reserved123                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 C5                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C5
                uint32_t                 Reserved155                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 C4                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C4
                uint32_t                 Reserved187                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 C7                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C7
                uint32_t                 Reserved219                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 C6                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C6
                uint32_t                 Reserved251                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 C8                                               : __CODEGEN_BITFIELD( 0, 26)    ; //!< C8
                uint32_t                 Reserved283                                      : __CODEGEN_BITFIELD(27, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 OffsetInR                                                                        ; //!< OFFSET_IN_R
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 OffsetInG                                                                        ; //!< OFFSET_IN_G
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 OffsetInB                                                                        ; //!< OFFSET_IN_B
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                uint32_t                 OffsetOutR                                                                       ; //!< OFFSET_OUT_R
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                uint32_t                 OffsetOutG                                                                       ; //!< OFFSET_OUT_G
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                uint32_t                 OffsetOutB                                                                       ; //!< OFFSET_OUT_B
            };
            uint32_t                     Value;
        } DW14;

        //! \name Local enumerations

        //! \brief C1
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C1
        {
            C1_1825665536                                                    = 18256, //!< No additional details
        };

        //! \brief C0
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C0
        {
            C0_4467265536                                                    = 44672, //!< No additional details
        };

        //! \brief C3
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C3
        {
            C3_113665536                                                     = 1136, //!< No additional details
        };

        //! \brief C2
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C2
        {
            C2_54465536                                                      = 544, //!< No additional details
        };

        //! \brief C5
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C5
        {
            C5_83265536                                                      = 33553600, //!< No additional details
        };

        //! \brief C4
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C4
        {
            C4_5380865536                                                    = 53808, //!< No additional details
        };

        //! \brief C7
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C7
        {
            C7_268865536                                                     = 2688, //!< No additional details
        };

        //! \brief C6
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C6
        {
            C6_19265536                                                      = 33554240, //!< No additional details
        };

        //! \brief C8
        //! \details
        //!     Coefficient of 3x3 Transform matrix. In HDR mode, bits [26:22] form the
        //!     signed integer portion and bits [21:0] form the fraction portion of the
        //!     coefficient. In non-HDR mode, bits [26:22] form the signed integer
        //!     portion and bits [21:6] form the fraction portion of the coefficient.
        enum C8
        {
            C8_5494465536                                                    = 54944, //!< No additional details
        };

        //! \brief OFFSET_IN_R
        //! \details
        //!     The input offset for red component.In HDR mode, the range of the value
        //!     is -2^31to 2^31-1. In non-HDR mode,the range of the
        //!     value is -2^16to 2^16-1
        enum OFFSET_IN_R
        {
            OFFSET_IN_R_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_IN_G
        //! \details
        //!     The input offset for green component.In HDR mode, the range of the value
        //!     is -2^31to 2^31-1. In non-HDR mode,the range of the
        //!     value is -2^16to 2^16-1
        enum OFFSET_IN_G
        {
            OFFSET_IN_G_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_IN_B
        //! \details
        //!     The input offset for blue component.In HDR mode, the range of the value
        //!     is -2^31to 2^31-1. In non-HDR mode,the range of the
        //!     value is -2^16to 2^16-1
        enum OFFSET_IN_B
        {
            OFFSET_IN_B_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_R
        //! \details
        //!     The output offset for red component.In HDR mode, the range of the value
        //!     is -2^31to 2^31-1. In non-HDR mode,the range of the
        //!     value is -2^16to 2^16-1
        enum OFFSET_OUT_R
        {
            OFFSET_OUT_R_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_G
        //! \details
        //!     The output offset for green component.In HDR mode, the range of the
        //!     value is -2^31to 2^31-1. In non-HDR mode,the range
        //!     of the value is -2^16to 2^16-1
        enum OFFSET_OUT_G
        {
            OFFSET_OUT_G_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_B
        //! \details
        //!     The output offset for blue component.In HDR mode, the range of the value
        //!     is -2^31to 2^31-1. In non-HDR mode,the range of the
        //!     value is -2^16to 2^16-1
        enum OFFSET_OUT_B
        {
            OFFSET_OUT_B_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_CCM_STATE_CMD();

        static const size_t dwSize = 15;
        static const size_t byteSize = 60;
    };

    //!
    //! \brief VEBOX_CSC_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for CSC
    //!     state.
    //!     
    struct VEBOX_CSC_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 C0                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C0
                uint32_t                 Reserved19                                       : __CODEGEN_BITFIELD(19, 30)    ; //!< Reserved
                uint32_t                 TransformEnable                                  : __CODEGEN_BITFIELD(31, 31)    ; //!< Transform Enable
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 C1                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C1
                uint32_t                 Reserved51                                       : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 C2                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C2
                uint32_t                 Reserved83                                       : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 C3                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C3
                uint32_t                 Reserved115                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 C4                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C4
                uint32_t                 Reserved147                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 C5                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C5
                uint32_t                 Reserved179                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 C6                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C6
                uint32_t                 Reserved211                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 C7                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C7
                uint32_t                 Reserved243                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 C8                                               : __CODEGEN_BITFIELD( 0, 18)    ; //!< C8
                uint32_t                 Reserved275                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 OffsetIn1                                        : __CODEGEN_BITFIELD( 0, 15)    ; //!< OFFSET_IN_1
                uint32_t                 OffsetOut1                                       : __CODEGEN_BITFIELD(16, 31)    ; //!< OFFSET_OUT_1
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 OffsetIn2                                        : __CODEGEN_BITFIELD( 0, 15)    ; //!< OFFSET_IN_2
                uint32_t                 OffsetOut2                                       : __CODEGEN_BITFIELD(16, 31)    ; //!< OFFSET_OUT_2
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 OffsetIn3                                        : __CODEGEN_BITFIELD( 0, 15)    ; //!< OFFSET_IN_3
                uint32_t                 OffsetOut3                                       : __CODEGEN_BITFIELD(16, 31)    ; //!< OFFSET_OUT_3
            };
            uint32_t                     Value;
        } DW11;

        //! \name Local enumerations

        //! \brief C0
        //! \details
        //!     Transform coefficient.
        enum C0
        {
            C0_OR10                                                          = 65536, //!< No additional details
        };

        //! \brief C1
        //! \details
        //!     Transform coefficient.
        enum C1
        {
            C1_UNNAMED0                                                      = 0, //!< No additional details
        };

        //! \brief C2
        //! \details
        //!     Transform coefficient.
        enum C2
        {
            C2_UNNAMED0                                                      = 0, //!< No additional details
        };

        //! \brief C3
        //! \details
        //!     Transform coefficient.
        enum C3
        {
            C3_UNNAMED0                                                      = 0, //!< No additional details
        };

        //! \brief C4
        //! \details
        //!     Transform coefficient.
        enum C4
        {
            C4_OR10                                                          = 65536, //!< No additional details
        };

        //! \brief C5
        //! \details
        //!     Transform coefficient.
        enum C5
        {
            C5_UNNAMED0                                                      = 0, //!< No additional details
        };

        //! \brief C6
        //! \details
        //!     Transform coefficient.
        enum C6
        {
            C6_UNNAMED0                                                      = 0, //!< No additional details
        };

        //! \brief C7
        //! \details
        //!     Transform coefficient.
        enum C7
        {
            C7_UNNAMED0                                                      = 0, //!< No additional details
        };

        //! \brief C8
        //! \details
        //!     Transform coefficient. The offset value is multiplied by 2 before being
        //!     added to the output.
        enum C8
        {
            C8_OR10                                                          = 65536, //!< No additional details
        };

        //! \brief OFFSET_IN_1
        //! \details
        //!     Offset in for Y/R. The offset value is multiplied by 2 before being
        //!     added to the output.
        enum OFFSET_IN_1
        {
            OFFSET_IN_1_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_1
        //! \details
        //!     Offset in for Y/R. The offset value is multiplied by 2 before being
        //!     added to the output.
        enum OFFSET_OUT_1
        {
            OFFSET_OUT_1_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \brief OFFSET_IN_2
        //! \details
        //!     Offset out for U/G. The offset value is multiplied by 2 before being
        //!     added to the output.
        enum OFFSET_IN_2
        {
            OFFSET_IN_2_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_2
        //! \details
        //!     Offset out for U/G. The offset value is multiplied by 2 before being
        //!     added to the output.
        enum OFFSET_OUT_2
        {
            OFFSET_OUT_2_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \brief OFFSET_IN_3
        //! \details
        //!     Offset out for V/B. The offset value is multiplied by 2 before being
        //!     added to the output.
        enum OFFSET_IN_3
        {
            OFFSET_IN_3_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_3
        //! \details
        //!     Offset out for V/B. The offset value is multiplied by 2 before being
        //!     added to the output.
        enum OFFSET_OUT_3
        {
            OFFSET_OUT_3_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_CSC_STATE_CMD();

        static const size_t dwSize = 12;
        static const size_t byteSize = 48;
    };

    //!
    //! \brief VEBOX_DNDI_STATE
    //! \details
    //!     This state table is used by the Denoise and Deinterlacer functions
    //!     
    struct VEBOX_DNDI_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 DenoiseMaximumHistory                            : __CODEGEN_BITFIELD( 0,  7)    ; //!< Denoise Maximum History
                uint32_t                 Reserved8                                        : __CODEGEN_BITFIELD( 8, 16)    ; //!< Reserved
                uint32_t                 DenoiseStadThreshold                             : __CODEGEN_BITFIELD(17, 31)    ; //!< Denoise STAD Threshold
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 DenoiseAsdThreshold                              : __CODEGEN_BITFIELD( 0, 11)    ; //!< Denoise ASD Threshold
                uint32_t                 Reserved44                                       : __CODEGEN_BITFIELD(12, 22)    ; //!< Reserved
                uint32_t                 DenoiseMovingPixelThreshold                      : __CODEGEN_BITFIELD(23, 27)    ; //!< Denoise Moving Pixel Threshold
                uint32_t                 DenoiseHistoryIncrease                           : __CODEGEN_BITFIELD(28, 31)    ; //!< DENOISE_HISTORY_INCREASE
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 Reserved64                                       : __CODEGEN_BITFIELD( 0,  4)    ; //!< Reserved
                uint32_t                 InitialDenoiseHistory                            : __CODEGEN_BITFIELD( 5, 10)    ; //!< INITIAL_DENOISE_HISTORY
                uint32_t                 Reserved75                                       : __CODEGEN_BITFIELD(11, 19)    ; //!< Reserved
                uint32_t                 TemporalDifferenceThreshold                      : __CODEGEN_BITFIELD(20, 31)    ; //!< Temporal Difference Threshold
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 Reserved96                                       : __CODEGEN_BITFIELD( 0,  1)    ; //!< Reserved
                uint32_t                 HotPixelCountLuma                                : __CODEGEN_BITFIELD( 2,  9)    ; //!< Hot Pixel Count Luma
                uint32_t                 ProgressiveDn                                    : __CODEGEN_BITFIELD(10, 10)    ; //!< PROGRESSIVE_DN
                uint32_t                 TemporalGneEnable                                : __CODEGEN_BITFIELD(11, 11)    ; //!< TEMPORAL_GNE_ENABLE
                uint32_t                 Reserved108                                      : __CODEGEN_BITFIELD(12, 19)    ; //!< Reserved
                uint32_t                 LowTemporalDifferenceThreshold                   : __CODEGEN_BITFIELD(20, 31)    ; //!< Low Temporal Difference Threshold
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 BlockNoiseEstimateNoiseThreshold                 : __CODEGEN_BITFIELD( 0, 11)    ; //!< Block Noise Estimate Noise Threshold
                uint32_t                 HotPixelThresholdLuma                            : __CODEGEN_BITFIELD(12, 19)    ; //!< Hot Pixel Threshold Luma
                uint32_t                 DenoiseThresholdForSumOfComplexityMeasureLuma    : __CODEGEN_BITFIELD(20, 31)    ; //!< Denoise Threshold for Sum of Complexity Measure Luma
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 HotPixelCountChromaU                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< Hot Pixel Count Chroma U
                uint32_t                 HotPixelThresholdChromaU                         : __CODEGEN_BITFIELD( 8, 15)    ; //!< Hot Pixel Threshold Chroma U
                uint32_t                 Reserved176                                      : __CODEGEN_BITFIELD(16, 16)    ; //!< Reserved
                uint32_t                 ChromaDenoiseStadThreshold                       : __CODEGEN_BITFIELD(17, 31)    ; //!< Chroma Denoise STAD Threshold
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 ChromaDenoiseEnable                              : __CODEGEN_BITFIELD( 0,  0)    ; //!< CHROMA_DENOISE_ENABLE
                uint32_t                 BlockNoiseEstimateEdgeThreshold                  : __CODEGEN_BITFIELD( 1, 11)    ; //!< BLOCK_NOISE_ESTIMATE_EDGE_THRESHOLD
                uint32_t                 Reserved204                                      : __CODEGEN_BITFIELD(12, 19)    ; //!< Reserved
                uint32_t                 ChromaTemporalDifferenceThreshold                : __CODEGEN_BITFIELD(20, 31)    ; //!< Chroma Temporal Difference Threshold
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 HotPixelCountChromaV                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< Hot Pixel Count Chroma V
                uint32_t                 HotPixelThresholdChromaV                         : __CODEGEN_BITFIELD( 8, 15)    ; //!< Hot Pixel Threshold Chroma V
                uint32_t                 Reserved240                                      : __CODEGEN_BITFIELD(16, 19)    ; //!< Reserved
                uint32_t                 ChromaLowTemporalDifferenceThreshold             : __CODEGEN_BITFIELD(20, 31)    ; //!< Chroma Low Temporal Difference Threshold
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 ChromaDenoiseThresholdForSumOfComplexityMeasure  : __CODEGEN_BITFIELD( 0, 11)    ; //!< Chroma Denoise Threshold for Sum of Complexity Measure
                uint32_t                 ChromaDenoiseAsdThreshold                        : __CODEGEN_BITFIELD(12, 23)    ; //!< Chroma Denoise ASD Threshold
                uint32_t                 ChromaDenoiseMovingPixelThreshold                : __CODEGEN_BITFIELD(24, 28)    ; //!< Chroma Denoise Moving Pixel Threshold
                uint32_t                 Reserved285                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 DnyWr040                                         : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnY_Wr0[4:0]
                uint32_t                 DnyWr140                                         : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnY_Wr1[4:0]
                uint32_t                 DnyWr240                                         : __CODEGEN_BITFIELD(10, 14)    ; //!< DnY_Wr2[4:0]
                uint32_t                 DnyWr340                                         : __CODEGEN_BITFIELD(15, 19)    ; //!< DnY_Wr3[4:0]
                uint32_t                 DnyWr440                                         : __CODEGEN_BITFIELD(20, 24)    ; //!< DnY_Wr4[4:0]
                uint32_t                 DnyWr540                                         : __CODEGEN_BITFIELD(25, 29)    ; //!< DnY_Wr5[4:0]
                uint32_t                 Reserved318                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 DnyThmin120                                      : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnY_thmin[12:0]
                uint32_t                 Reserved333                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnyThmax120                                      : __CODEGEN_BITFIELD(16, 28)    ; //!< DnY_thmax[12:0]
                uint32_t                 Reserved349                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 DnyDynThmin120                                   : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnY_dyn_thmin[12:0]
                uint32_t                 Reserved365                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnyPrt5120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnY_prt5[12:0]
                uint32_t                 Reserved381                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                uint32_t                 DnyPrt3120                                       : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnY_prt3[12:0]
                uint32_t                 Reserved397                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnyPrt4120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnY_prt4[12:0]
                uint32_t                 Reserved413                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                uint32_t                 DnyPrt1120                                       : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnY_prt1[12:0]
                uint32_t                 Reserved429                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnyPrt2120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnY_prt2[12:0]
                uint32_t                 Reserved445                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                uint32_t                 DnyWd2040                                        : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnY_wd20[4:0]
                uint32_t                 DnyWd2140                                        : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnY_wd21[4:0]
                uint32_t                 DnyWd2240                                        : __CODEGEN_BITFIELD(10, 14)    ; //!< DnY_wd22[4:0]
                uint32_t                 Reserved463                                      : __CODEGEN_BITFIELD(15, 15)    ; //!< Reserved
                uint32_t                 DnyPrt0120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnY_prt0[12:0]
                uint32_t                 Reserved477                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                uint32_t                 DnyWd0040                                        : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnY_wd00[4:0]
                uint32_t                 DnyWd0140                                        : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnY_wd01[4:0]
                uint32_t                 DnyWd0240                                        : __CODEGEN_BITFIELD(10, 14)    ; //!< DnY_wd02[4:0]
                uint32_t                 DnyWd1040                                        : __CODEGEN_BITFIELD(15, 19)    ; //!< DnY_wd10[4:0]
                uint32_t                 DnyWd1140                                        : __CODEGEN_BITFIELD(20, 24)    ; //!< DnY_wd11[4:0]
                uint32_t                 DnyWd1240                                        : __CODEGEN_BITFIELD(25, 29)    ; //!< DnY_wd12[4:0]
                uint32_t                 Reserved510                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                uint32_t                 DnuWr040                                         : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnU_Wr0[4:0]
                uint32_t                 DnuWr140                                         : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnU_Wr1[4:0]
                uint32_t                 DnuWr240                                         : __CODEGEN_BITFIELD(10, 14)    ; //!< DnU_Wr2[4:0]
                uint32_t                 DnuWr340                                         : __CODEGEN_BITFIELD(15, 19)    ; //!< DnU_Wr3[4:0]
                uint32_t                 DnuWr440                                         : __CODEGEN_BITFIELD(20, 24)    ; //!< DnU_Wr4[4:0]
                uint32_t                 DnuWr540                                         : __CODEGEN_BITFIELD(25, 29)    ; //!< DnU_Wr5[4:0]
                uint32_t                 Reserved542                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                uint32_t                 DnuThmin120                                      : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnU_thmin[12:0]
                uint32_t                 Reserved557                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnuThmax120                                      : __CODEGEN_BITFIELD(16, 28)    ; //!< DnU_thmax[12:0]
                uint32_t                 Reserved573                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                uint32_t                 DnuDynThmin120                                   : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnU_dyn_thmin[12:0]
                uint32_t                 Reserved589                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnuPrt5120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnU_prt5[12:0]
                uint32_t                 Reserved605                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                uint32_t                 DnuPrt3120                                       : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnU_prt3[12:0]
                uint32_t                 Reserved621                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnuPrt4120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnU_prt4[12:0]
                uint32_t                 Reserved637                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                uint32_t                 DnuPrt1120                                       : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnU_prt1[12:0]
                uint32_t                 Reserved653                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnuPrt2120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnU_prt2[12:0]
                uint32_t                 Reserved669                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                uint32_t                 DnuWd2040                                        : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnU_wd20[4:0]
                uint32_t                 DnuWd2140                                        : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnU_wd21[4:0]
                uint32_t                 DnuWd2240                                        : __CODEGEN_BITFIELD(10, 14)    ; //!< DnU_wd22[4:0]
                uint32_t                 Reserved687                                      : __CODEGEN_BITFIELD(15, 15)    ; //!< Reserved
                uint32_t                 DnuPrt0120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnU_prt0[12:0]
                uint32_t                 Reserved701                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                uint32_t                 DnuWd0040                                        : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnU_wd00[4:0]
                uint32_t                 DnuWd0140                                        : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnU_wd01[4:0]
                uint32_t                 DnuWd0240                                        : __CODEGEN_BITFIELD(10, 14)    ; //!< DnU_wd02[4:0]
                uint32_t                 DnuWd1040                                        : __CODEGEN_BITFIELD(15, 19)    ; //!< DnU_wd10[4:0]
                uint32_t                 DnuWd1140                                        : __CODEGEN_BITFIELD(20, 24)    ; //!< DnU_wd11[4:0]
                uint32_t                 DnuWd1240                                        : __CODEGEN_BITFIELD(25, 29)    ; //!< DnU_wd12[4:0]
                uint32_t                 Reserved734                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW22;
        union
        {
            struct
            {
                uint32_t                 DnvWr040                                         : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnV_Wr0[4:0]
                uint32_t                 DnvWr5140                                        : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnV_Wr51[4:0]
                uint32_t                 DnvWr240                                         : __CODEGEN_BITFIELD(10, 14)    ; //!< DnV_Wr2[4:0]
                uint32_t                 DnvWr340                                         : __CODEGEN_BITFIELD(15, 19)    ; //!< DnV_Wr3[4:0]
                uint32_t                 DnvWr440                                         : __CODEGEN_BITFIELD(20, 24)    ; //!< DnV_Wr4[4:0]
                uint32_t                 DnvWr540                                         : __CODEGEN_BITFIELD(25, 29)    ; //!< DnV_Wr5[4:0]
                uint32_t                 Reserved766                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW23;
        union
        {
            struct
            {
                uint32_t                 DnvThmin120                                      : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnV_thmin[12:0]
                uint32_t                 Reserved781                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnvThmax120                                      : __CODEGEN_BITFIELD(16, 28)    ; //!< DnV_thmax[12:0]
                uint32_t                 Reserved797                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW24;
        union
        {
            struct
            {
                uint32_t                 DnvDynThmin120                                   : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnV_dyn_thmin[12:0]
                uint32_t                 Reserved813                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnvPrt5120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnV_prt5[12:0]
                uint32_t                 Reserved829                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW25;
        union
        {
            struct
            {
                uint32_t                 DnvPrt3120                                       : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnV_prt3[12:0]
                uint32_t                 Reserved845                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnvPrt4120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnV_prt4[12:0]
                uint32_t                 Reserved861                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW26;
        union
        {
            struct
            {
                uint32_t                 DnvPrt1120                                       : __CODEGEN_BITFIELD( 0, 12)    ; //!< DnV_prt1[12:0]
                uint32_t                 Reserved877                                      : __CODEGEN_BITFIELD(13, 15)    ; //!< Reserved
                uint32_t                 DnvPrt2120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnV_prt2[12:0]
                uint32_t                 Reserved893                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW27;
        union
        {
            struct
            {
                uint32_t                 DnvWd2040                                        : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnV_wd20[4:0]
                uint32_t                 DnvWd2140                                        : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnV_wd21[4:0]
                uint32_t                 DnvWd2240                                        : __CODEGEN_BITFIELD(10, 14)    ; //!< DnV_wd22[4:0]
                uint32_t                 Reserved911                                      : __CODEGEN_BITFIELD(15, 15)    ; //!< Reserved
                uint32_t                 DnvPrt0120                                       : __CODEGEN_BITFIELD(16, 28)    ; //!< DnV_prt0[12:0]
                uint32_t                 Reserved925                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW28;
        union
        {
            struct
            {
                uint32_t                 DnvWd0040                                        : __CODEGEN_BITFIELD( 0,  4)    ; //!< DnV_wd00[4:0]
                uint32_t                 DnvWd0140                                        : __CODEGEN_BITFIELD( 5,  9)    ; //!< DnV_wd01[4:0]
                uint32_t                 DnvWd0240                                        : __CODEGEN_BITFIELD(10, 14)    ; //!< DnV_wd02[4:0]
                uint32_t                 DnvWd1040                                        : __CODEGEN_BITFIELD(15, 19)    ; //!< DnV_wd10[4:0]
                uint32_t                 DnvWd1140                                        : __CODEGEN_BITFIELD(20, 24)    ; //!< DnV_wd11[4:0]
                uint32_t                 DnvWd1240                                        : __CODEGEN_BITFIELD(25, 29)    ; //!< DnV_wd12[4:0]
                uint32_t                 Reserved958                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW29;
        union
        {
            struct
            {
                uint32_t                 Reserved960                                      : __CODEGEN_BITFIELD( 0,  6)    ; //!< Reserved
                uint32_t                 ValidPixelThreshold                              : __CODEGEN_BITFIELD( 7, 16)    ; //!< VALID_PIXEL_THRESHOLD
                uint32_t                 EightDirectionEdgeThreshold                      : __CODEGEN_BITFIELD(17, 31)    ; //!< EIGHT_DIRECTION_EDGE_THRESHOLD
            };
            uint32_t                     Value;
        } DW30;
        union
        {
            struct
            {
                uint32_t                 SmallSobelCountThreshold                         : __CODEGEN_BITFIELD( 0,  5)    ; //!< Small Sobel Count Threshold
                uint32_t                 LargeSobelThreshold                              : __CODEGEN_BITFIELD( 6, 18)    ; //!< LARGE_SOBEL_THRESHOLD
                uint32_t                 SmallSobelThreshold                              : __CODEGEN_BITFIELD(19, 31)    ; //!< SMALL_SOBEL_THRESHOLD
            };
            uint32_t                     Value;
        } DW31;
        union
        {
            struct
            {
                uint32_t                 Reserved1024                                     : __CODEGEN_BITFIELD( 0,  5)    ; //!< Reserved
                uint32_t                 BlockSigmaDiffThreshold                          : __CODEGEN_BITFIELD( 6, 19)    ; //!< BLOCK_SIGMA_DIFF_THRESHOLD
                uint32_t                 LargeSobelCountThreshold                         : __CODEGEN_BITFIELD(20, 25)    ; //!< Large Sobel Count Threshold
                uint32_t                 MedianSobelCountThreshold                        : __CODEGEN_BITFIELD(26, 31)    ; //!< Median Sobel Count Threshold
            };
            uint32_t                     Value;
        } DW32;
        union
        {
            struct
            {
                uint32_t                 Reserved1056                                     : __CODEGEN_BITFIELD( 0, 18)    ; //!< Reserved
                uint32_t                 MaxSobelThreshold                                : __CODEGEN_BITFIELD(19, 31)    ; //!< MAX_SOBEL_THRESHOLD
            };
            uint32_t                     Value;
        } DW33;
        union
        {
            struct
            {
                uint32_t                 SmoothMvThreshold                                : __CODEGEN_BITFIELD( 0,  1)    ; //!< Smooth MV Threshold
                uint32_t                 SadTightThreshold                                : __CODEGEN_BITFIELD( 2,  5)    ; //!< SAD_TIGHT_THRESHOLD
                uint32_t                 ContentAdaptiveThresholdSlope                    : __CODEGEN_BITFIELD( 6,  9)    ; //!< CONTENT_ADAPTIVE_THRESHOLD_SLOPE
                uint32_t                 StmmC2                                           : __CODEGEN_BITFIELD(10, 12)    ; //!< STMM C2
                uint32_t                 SignBitForSmoothMvThreshold                      : __CODEGEN_BITFIELD(13, 13)    ; //!< Sign bit for Smooth MV Threshold
                uint32_t                 SignBitForMaximumStmm                            : __CODEGEN_BITFIELD(14, 14)    ; //!< Sign bit for Maximum STMM
                uint32_t                 SignBitForMinimumStmm                            : __CODEGEN_BITFIELD(15, 15)    ; //!< Sign bit for Minimum STMM
                uint32_t                 Reserved1104                                     : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW34;
        union
        {
            struct
            {
                uint32_t                 MaximumStmm                                      : __CODEGEN_BITFIELD( 0,  7)    ; //!< Maximum STMM
                uint32_t                 MultiplierForVecm                                : __CODEGEN_BITFIELD( 8, 13)    ; //!< Multiplier for VECM
                uint32_t                 Reserved1134                                     : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 BlendingConstantAcrossTimeForSmallValuesOfStmm   : __CODEGEN_BITFIELD(16, 23)    ; //!< Blending constant across time for small values of STMM
                uint32_t                 BlendingConstantAcrossTimeForLargeValuesOfStmm   : __CODEGEN_BITFIELD(24, 30)    ; //!< Blending constant across time for large values of STMM
                uint32_t                 StmmBlendingConstantSelect                       : __CODEGEN_BITFIELD(31, 31)    ; //!< STMM_BLENDING_CONSTANT_SELECT
            };
            uint32_t                     Value;
        } DW35;
        union
        {
            struct
            {
                uint32_t                 FmdTemporalDifferenceThreshold                   : __CODEGEN_BITFIELD( 0,  7)    ; //!< FMD Temporal Difference Threshold
                uint32_t                 LumatdmWt                                        : __CODEGEN_BITFIELD( 8, 11)    ; //!< LUMATDM_WT
                uint32_t                 ChromatdmWt                                      : __CODEGEN_BITFIELD(12, 15)    ; //!< CHROMATDM_WT
                uint32_t                 StmmOutputShift                                  : __CODEGEN_BITFIELD(16, 19)    ; //!< STMM Output Shift
                uint32_t                 StmmShiftUp                                      : __CODEGEN_BITFIELD(20, 21)    ; //!< STMM_SHIFT_UP
                uint32_t                 StmmShiftDown                                    : __CODEGEN_BITFIELD(22, 23)    ; //!< STMM_SHIFT_DOWN
                uint32_t                 MinimumStmm                                      : __CODEGEN_BITFIELD(24, 31)    ; //!< Minimum STMM
            };
            uint32_t                     Value;
        } DW36;
        union
        {
            struct
            {
                uint32_t                 CoringThresholdForSvcm                           : __CODEGEN_BITFIELD( 0,  7)    ; //!< CORING_THRESHOLD_FOR_SVCM
                uint32_t                 DeltabitValueForSvcm                             : __CODEGEN_BITFIELD( 8, 11)    ; //!< DELTABIT_VALUE_FOR_SVCM
                uint32_t                 Reserved1196                                     : __CODEGEN_BITFIELD(12, 15)    ; //!< Reserved
                uint32_t                 CoringThresholdForShcm                           : __CODEGEN_BITFIELD(16, 23)    ; //!< CORING_THRESHOLD_FOR_SHCM
                uint32_t                 DeltabitValueForShcm                             : __CODEGEN_BITFIELD(24, 27)    ; //!< DELTABIT_VALUE_FOR_SHCM
                uint32_t                 Reserved1212                                     : __CODEGEN_BITFIELD(28, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW37;
        union
        {
            struct
            {
                uint32_t                 Reserved1216                                     : __CODEGEN_BITFIELD( 0,  2)    ; //!< Reserved
                uint32_t                 DnDiTopFirst                                     : __CODEGEN_BITFIELD( 3,  3)    ; //!< DNDI_TOP_FIRST
                uint32_t                 Reserved1220                                     : __CODEGEN_BITFIELD( 4,  6)    ; //!< Reserved
                uint32_t                 McdiEnable                                       : __CODEGEN_BITFIELD( 7,  7)    ; //!< MCDI Enable
                uint32_t                 FmdTearThreshold                                 : __CODEGEN_BITFIELD( 8, 13)    ; //!< FMD Tear Threshold
                uint32_t                 CatThreshold                                     : __CODEGEN_BITFIELD(14, 15)    ; //!< CAT_THRESHOLD
                uint32_t                 Fmd2VerticalDifferenceThreshold                  : __CODEGEN_BITFIELD(16, 23)    ; //!< FMD #2 Vertical Difference Threshold
                uint32_t                 Fmd1VerticalDifferenceThreshold                  : __CODEGEN_BITFIELD(24, 31)    ; //!< FMD #1 Vertical Difference Threshold
            };
            uint32_t                     Value;
        } DW38;
        union
        {
            struct
            {
                uint32_t                 SadTha                                           : __CODEGEN_BITFIELD( 0,  3)    ; //!< SAD_THA
                uint32_t                 SadThb                                           : __CODEGEN_BITFIELD( 4,  7)    ; //!< SAD_THB
                uint32_t                 ProgressiveCadenceReconstructionFor1StFieldOfCurrentFrame : __CODEGEN_BITFIELD( 8,  9)    ; //!< PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME
                uint32_t                 McPixelConsistencyThreshold                      : __CODEGEN_BITFIELD(10, 15)    ; //!< MC_PIXEL_CONSISTENCY_THRESHOLD
                uint32_t                 ProgressiveCadenceReconstructionForSecondFieldOfPreviousFrame : __CODEGEN_BITFIELD(16, 17)    ; //!< PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME
                uint32_t                 Reserved1266                                     : __CODEGEN_BITFIELD(18, 18)    ; //!< Reserved
                uint32_t                 NeighborPixelThreshold                           : __CODEGEN_BITFIELD(19, 22)    ; //!< NEIGHBOR_PIXEL_THRESHOLD
                uint32_t                 ChromaSmallerWindowForTdm                        : __CODEGEN_BITFIELD(23, 23)    ; //!< Chroma Smaller Window for TDM
                uint32_t                 LumaSmallerWindowForTdm                          : __CODEGEN_BITFIELD(24, 24)    ; //!< Luma Smaller Window for TDM
                uint32_t                 Fastercovergence                                 : __CODEGEN_BITFIELD(25, 25)    ; //!< FASTERCOVERGENCE
                uint32_t                 Reserved1274                                     : __CODEGEN_BITFIELD(26, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW39;
        union
        {
            struct
            {
                uint32_t                 SadWt0                                           : __CODEGEN_BITFIELD( 0,  7)    ; //!< SAD_WT0
                uint32_t                 SadWt1                                           : __CODEGEN_BITFIELD( 8, 15)    ; //!< SAD_WT1
                uint32_t                 SadWt2                                           : __CODEGEN_BITFIELD(16, 23)    ; //!< SAD_WT2
                uint32_t                 SadWt3                                           : __CODEGEN_BITFIELD(24, 31)    ; //!< SAD_WT3
            };
            uint32_t                     Value;
        } DW40;
        union
        {
            struct
            {
                uint32_t                 SadWt4                                           : __CODEGEN_BITFIELD( 0,  7)    ; //!< SAD_WT4
                uint32_t                 SadWt6                                           : __CODEGEN_BITFIELD( 8, 15)    ; //!< SAD_WT6
                uint32_t                 CoringThresholdForLumaSadCalculation             : __CODEGEN_BITFIELD(16, 23)    ; //!< CORING_THRESHOLD_FOR_LUMA_SAD_CALCULATION
                uint32_t                 CoringThresholdForChromaSadCalculation           : __CODEGEN_BITFIELD(24, 31)    ; //!< CORING_THRESHOLD_FOR_CHROMA_SAD_CALCULATION
            };
            uint32_t                     Value;
        } DW41;
        union
        {
            struct
            {
                uint32_t                 ParDiffcheckslackthreshold                       : __CODEGEN_BITFIELD( 0,  7)    ; //!< PAR_DIFFCHECKSLACKTHRESHOLD
                uint32_t                 ParTearinghighthreshold                          : __CODEGEN_BITFIELD( 8, 15)    ; //!< PAR_TEARINGHIGHTHRESHOLD
                uint32_t                 ParTearinglowthreshold                           : __CODEGEN_BITFIELD(16, 23)    ; //!< PAR_TEARINGLOWTHRESHOLD
                uint32_t                 ParDirectioncheckth                              : __CODEGEN_BITFIELD(24, 26)    ; //!< PAR_DIRECTIONCHECKTH
                uint32_t                 ParSyntheticcontentcheck                         : __CODEGEN_BITFIELD(27, 27)    ; //!< PAR_SYNTHETICCONTENTCHECK
                uint32_t                 ParLocalcheck                                    : __CODEGEN_BITFIELD(28, 28)    ; //!< PAR_LOCALCHECK
                uint32_t                 ParUsesyntheticcontentmedian                     : __CODEGEN_BITFIELD(29, 29)    ; //!< PAR_USESYNTHETICCONTENTMEDIAN
                uint32_t                 BypassDeflicker                                  : __CODEGEN_BITFIELD(30, 30)    ; //!< Bypass Deflicker
                uint32_t                 Reserved1375                                     : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW42;
        union
        {
            struct
            {
                uint32_t                 Lpfwtlut0                                        : __CODEGEN_BITFIELD( 0,  7)    ; //!< LPFWTLUT0
                uint32_t                 Lpfwtlut1                                        : __CODEGEN_BITFIELD( 8, 15)    ; //!< LPFWTLUT1
                uint32_t                 Lpfwtlut2                                        : __CODEGEN_BITFIELD(16, 23)    ; //!< LPFWTLUT2
                uint32_t                 Lpfwtlut3                                        : __CODEGEN_BITFIELD(24, 31)    ; //!< LPFWTLUT3
            };
            uint32_t                     Value;
        } DW43;
        union
        {
            struct
            {
                uint32_t                 Lpfwtlut4                                        : __CODEGEN_BITFIELD( 0,  7)    ; //!< LPFWTLUT4
                uint32_t                 Lpfwtlut5                                        : __CODEGEN_BITFIELD( 8, 15)    ; //!< LPFWTLUT5
                uint32_t                 Lpfwtlut6                                        : __CODEGEN_BITFIELD(16, 23)    ; //!< LPFWTLUT6
                uint32_t                 Lpfwtlut7                                        : __CODEGEN_BITFIELD(24, 31)    ; //!< LPFWTLUT7
            };
            uint32_t                     Value;
        } DW44;
        union
        {
            struct
            {
                uint32_t                 TdmUvThreshold                                   : __CODEGEN_BITFIELD( 0,  6)    ; //!< TDM_UV_THRESHOLD
                uint32_t                 HvUvThreshold                                    : __CODEGEN_BITFIELD( 7, 12)    ; //!< HV_UV_THRESHOLD
                uint32_t                 TdmHarmonicFactorSynthetic                       : __CODEGEN_BITFIELD(13, 15)    ; //!< TDM_HARMONIC_FACTOR_SYNTHETIC
                uint32_t                 TdmHarmonicFactorNatural                         : __CODEGEN_BITFIELD(16, 18)    ; //!< TDM_HARMONIC_FACTOR_NATURAL
                uint32_t                 SynthticFrame                                    : __CODEGEN_BITFIELD(19, 19)    ; //!< SYNTHTIC_FRAME
                uint32_t                 SyntheticContentThreshold                        : __CODEGEN_BITFIELD(20, 31)    ; //!< SYNTHETIC_CONTENT_THRESHOLD
            };
            uint32_t                     Value;
        } DW45;
        union
        {
            struct
            {
                uint32_t                 SvcmHarmonicFactorSynthetic                      : __CODEGEN_BITFIELD( 0,  2)    ; //!< SVCM_HARMONIC_FACTOR_SYNTHETIC
                uint32_t                 ShcmHarmonicFactorSynthetic                      : __CODEGEN_BITFIELD( 3,  5)    ; //!< SHCM_HARMONIC_FACTOR_SYNTHETIC
                uint32_t                 SvcmHarmonicFactorNatural                        : __CODEGEN_BITFIELD( 6,  8)    ; //!< SVCM_HARMONIC_FACTOR_NATURAL
                uint32_t                 ShcmHarmonicFactorNatural                        : __CODEGEN_BITFIELD( 9, 11)    ; //!< SHCM_HARMONIC_FACTOR_NATURAL
                uint32_t                 HarmonicCounterThreshold                         : __CODEGEN_BITFIELD(12, 15)    ; //!< HARMONIC_COUNTER_THRESHOLD
                uint32_t                 MaxHarmonicCounterThreshold                      : __CODEGEN_BITFIELD(16, 20)    ; //!< MAX_HARMONIC_COUNTER_THRESHOLD
                uint32_t                 NaturalContentThreshold                          : __CODEGEN_BITFIELD(21, 28)    ; //!< NATURAL_CONTENT_THRESHOLD
                uint32_t                 Reserved1501                                     : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW46;
        union
        {
            struct
            {
                uint32_t                 MaximumValue                                                                     ; //!< MAXIMUM_VALUE
            };
            uint32_t                     Value;
        } DW47;
        union
        {
            struct
            {
                uint32_t                 ShiftingValue                                    : __CODEGEN_BITFIELD( 0,  5)    ; //!< SHIFTING_VALUE
                uint32_t                 HvYThreshold                                     : __CODEGEN_BITFIELD( 6, 11)    ; //!< HV_Y_THRESHOLD
                uint32_t                 NumInlinerNumeratorThreshold                     : __CODEGEN_BITFIELD(12, 15)    ; //!< NUM_INLINER_NUMERATOR_THRESHOLD
                uint32_t                 NumInlinerDenominatorThreshold                   : __CODEGEN_BITFIELD(16, 19)    ; //!< NUM_INLINER_DENOMINATOR_THRESHOLD
                uint32_t                 Reserved1556                                     : __CODEGEN_BITFIELD(20, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW48;
        union
        {
            struct
            {
                uint32_t                 LumaStadTh                                       : __CODEGEN_BITFIELD( 0, 13)    ; //!< LUMA_STAD_TH
                uint32_t                 Reserved1582                                     : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 ChromaStadTh                                     : __CODEGEN_BITFIELD(16, 29)    ; //!< CHROMA_STAD_TH
                uint32_t                 Reserved1598                                     : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW49;
        union
        {
            struct
            {
                uint32_t                 LumaUniformityLowTh1                             : __CODEGEN_BITFIELD( 0,  7)    ; //!< LUMA_UNIFORMITY_LOW_TH1
                uint32_t                 LumaUniformityLowTh2                             : __CODEGEN_BITFIELD( 8, 15)    ; //!< LUMA_UNIFORMITY_LOW_TH2
                uint32_t                 LumaUniformityHighTh1                            : __CODEGEN_BITFIELD(16, 23)    ; //!< LUMA_UNIFORMITY_HIGH_TH1
                uint32_t                 LumaUniformityHighTh2                            : __CODEGEN_BITFIELD(24, 31)    ; //!< LUMA_UNIFORMITY_HIGH_TH2
            };
            uint32_t                     Value;
        } DW50;
        union
        {
            struct
            {
                uint32_t                 ChromaUniformityLowTh1                           : __CODEGEN_BITFIELD( 0,  7)    ; //!< CHROMA_UNIFORMITY_LOW_TH1
                uint32_t                 ChromaUniformityLowTh2                           : __CODEGEN_BITFIELD( 8, 15)    ; //!< CHROMA_UNIFORMITY_LOW_TH2
                uint32_t                 ChromaUniformityHighTh1                          : __CODEGEN_BITFIELD(16, 23)    ; //!< CHROMA_UNIFORMITY_HIGH_TH1
                uint32_t                 ChromaUniformityHighTh2                          : __CODEGEN_BITFIELD(24, 31)    ; //!< CHROMA_UNIFORMITY_HIGH_TH2
            };
            uint32_t                     Value;
        } DW51;
        union
        {
            struct
            {
                uint32_t                 _4X4TemporalGneThresholdCount                    : __CODEGEN_BITFIELD( 0, 17)    ; //!< 4x4 temporal GNE threshold count
                uint32_t                 Reserved1682                                     : __CODEGEN_BITFIELD(18, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW52;

        //! \name Local enumerations

        //! \brief DENOISE_HISTORY_INCREASE
        //! \details
        //!     style="color: rgb(35, 35, 35); font-family: Arial, sans-serif;
        //!     font-size: 13.3333330154419px; line-height: 16.6666660308838px;">Amount
        //!     that denoise_history is increased by. MAX:15
        enum DENOISE_HISTORY_INCREASE
        {
            DENOISE_HISTORY_INCREASE_UNNAMED8                                = 8, //!< No additional details
            DENOISE_HISTORY_INCREASE_UNNAMED15                               = 15, //!< Maximum Allowed
        };

        //! \brief INITIAL_DENOISE_HISTORY
        //! \details
        //!     Initial value for Denoise history for both Luma and Chroma
        enum INITIAL_DENOISE_HISTORY
        {
            INITIAL_DENOISE_HISTORY_UNNAMED32                                = 32, //!< No additional details
        };

        //! \brief PROGRESSIVE_DN
        //! \details
        //!     Indicates that the denoise algorithm should assume progressive input
        //!     when filtering neighboring pixels.   This bit must be set
        //!     if the input to Denoise is RGB.
        enum PROGRESSIVE_DN
        {
            PROGRESSIVE_DN_UNNAMED0                                          = 0, //!< DN assumes interlaced video and filters alternate lines together
            PROGRESSIVE_DN_UNNAMED1                                          = 1, //!< DN assumes progressive video and filters neighboring lines together
        };

        //! \brief TEMPORAL_GNE_ENABLE
        //! \details
        //!     This bit must be set to 1 to enable the temporal GNE (Global Noise
        //!     Estimation) estimation logic.
        enum TEMPORAL_GNE_ENABLE
        {
            TEMPORAL_GNE_ENABLE_UNNAMED1                                     = 1, //!< No additional details
        };

        enum CHROMA_DENOISE_ENABLE
        {
            CHROMA_DENOISE_ENABLE_UNNAMED0                                   = 0, //!< The U and V channels will be passed to the next stage after DN unchanged.
            CHROMA_DENOISE_ENABLE_UNNAMED1                                   = 1, //!< The U and V chroma channels will be denoise filtered.
        };

        //! \brief BLOCK_NOISE_ESTIMATE_EDGE_THRESHOLD
        //! \details
        //!     Threshold for detecting an edge in block noise estimate.
        enum BLOCK_NOISE_ESTIMATE_EDGE_THRESHOLD
        {
            BLOCK_NOISE_ESTIMATE_EDGE_THRESHOLD_UNNAMED80                    = 80, //!< No additional details
        };

        enum VALID_PIXEL_THRESHOLD
        {
            VALID_PIXEL_THRESHOLD_UNNAMED480                                 = 480, //!< No additional details
        };

        //! \brief EIGHT_DIRECTION_EDGE_THRESHOLD
        //! \details
        //!     Threshold to determine an edge in eight directional edge detector
        enum EIGHT_DIRECTION_EDGE_THRESHOLD
        {
            EIGHT_DIRECTION_EDGE_THRESHOLD_UNNAMED1024                       = 1024, //!< No additional details
        };

        //! \brief LARGE_SOBEL_THRESHOLD
        //! \details
        //!     Threshold for strong Sobel response
        enum LARGE_SOBEL_THRESHOLD
        {
            LARGE_SOBEL_THRESHOLD_UNNAMED2400                                = 2400, //!< No additional details
        };

        //! \brief SMALL_SOBEL_THRESHOLD
        //! \details
        //!     Threshold for weak Sobel response
        enum SMALL_SOBEL_THRESHOLD
        {
            SMALL_SOBEL_THRESHOLD_UNNAMED480                                 = 480, //!< No additional details
        };

        //! \brief BLOCK_SIGMA_DIFF_THRESHOLD
        //! \details
        //!     Threshold for the difference between maximum and minimum sigma within a
        //!     block
        enum BLOCK_SIGMA_DIFF_THRESHOLD
        {
            BLOCK_SIGMA_DIFF_THRESHOLD_UNNAMED480                            = 480, //!< No additional details
        };

        enum MAX_SOBEL_THRESHOLD
        {
            MAX_SOBEL_THRESHOLD_UNNAMED1440                                  = 1440, //!< No additional details
        };

        enum SAD_TIGHT_THRESHOLD
        {
            SAD_TIGHT_THRESHOLD_UNNAMED5                                     = 5, //!< No additional details
        };

        //! \brief CONTENT_ADAPTIVE_THRESHOLD_SLOPE
        //! \details
        //!     Determines the slope of the Content Adaptive Threshold.
        enum CONTENT_ADAPTIVE_THRESHOLD_SLOPE
        {
            CONTENT_ADAPTIVE_THRESHOLD_SLOPE_UNNAMED9                        = 9, //!< CAT_slope value = 10
        };

        enum STMM_BLENDING_CONSTANT_SELECT
        {
            STMM_BLENDING_CONSTANT_SELECT_UNNAMED0                           = 0, //!< Use the blending constant for small values of STMM for stmm_md_th
            STMM_BLENDING_CONSTANT_SELECT_UNNAMED1                           = 1, //!< Use the blending constant for large values of STMM for stmm_md_th
        };

        enum LUMATDM_WT
        {
            LUMATDM_WT_UNNAMED4                                              = 4, //!< No additional details
        };

        enum CHROMATDM_WT
        {
            CHROMATDM_WT_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \brief STMM_SHIFT_UP
        //! \details
        //!     Amount to shift STMM up (set range).
        enum STMM_SHIFT_UP
        {
            STMM_SHIFT_UP_SHIFTBY6                                           = 0, //!< No additional details
            STMM_SHIFT_UP_SHIFTBY7                                           = 1, //!< No additional details
            STMM_SHIFT_UP_SHIFTBY8                                           = 2, //!< No additional details
        };

        //! \brief STMM_SHIFT_DOWN
        //! \details
        //!     Amount to shift STMM down (quantize to fewer bits)
        enum STMM_SHIFT_DOWN
        {
            STMM_SHIFT_DOWN_SHIFTBY4                                         = 0, //!< No additional details
            STMM_SHIFT_DOWN_SHIFTBY5                                         = 1, //!< No additional details
            STMM_SHIFT_DOWN_SHIFTBY6                                         = 2, //!< No additional details
        };

        enum CORING_THRESHOLD_FOR_SVCM
        {
            CORING_THRESHOLD_FOR_SVCM_UNNAMED255                             = 255, //!< No additional details
        };

        enum DELTABIT_VALUE_FOR_SVCM
        {
            DELTABIT_VALUE_FOR_SVCM_UNNAMED5                                 = 5, //!< No additional details
        };

        enum CORING_THRESHOLD_FOR_SHCM
        {
            CORING_THRESHOLD_FOR_SHCM_UNNAMED255                             = 255, //!< No additional details
        };

        enum DELTABIT_VALUE_FOR_SHCM
        {
            DELTABIT_VALUE_FOR_SHCM_UNNAMED5                                 = 5, //!< No additional details
        };

        //! \brief DNDI_TOP_FIRST
        //! \details
        //!     Indicates the top field is first in sequence, otherwise bottom is first.
        enum DNDI_TOP_FIRST
        {
            DNDI_TOP_FIRST_UNNAMED0                                          = 0, //!< Bottom field occurs first in sequence
            DNDI_TOP_FIRST_UNNAMED1                                          = 1, //!< Top field occurs first in sequence
        };

        enum CAT_THRESHOLD
        {
            CAT_THRESHOLD_UNNAMED0                                           = 0, //!< No additional details
        };

        enum SAD_THA
        {
            SAD_THA_UNNAMED5                                                 = 5, //!< No additional details
        };

        enum SAD_THB
        {
            SAD_THB_UNNAMED10                                                = 10, //!< No additional details
        };

        //! \brief PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME
        //! \details
        //!     Deflicker can be enabled only in De-interlace mode and not if either
        //!     fields are in Cadence construction mode.
        enum PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME
        {
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME_DEINTERLACE = 0, //!< No additional details
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME_PUTTOGETHERWITHPREVIOUSFIELDINSEQUENCE = 1, //!< 2^nd field of previous frame
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_1ST_FIELD_OF_CURRENT_FRAME_PUTTOGETHERWITHNEXTFIELDINSEQUENCE = 2, //!< 2^nd field of current frame
        };

        enum MC_PIXEL_CONSISTENCY_THRESHOLD
        {
            MC_PIXEL_CONSISTENCY_THRESHOLD_UNNAMED25                         = 25, //!< No additional details
        };

        //! \brief PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME
        //! \details
        //!     Deflicker can be enabled only in De-interlace mode and not in Cadence
        //!     construction mode.
        enum PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME
        {
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME_DEINTERLACE = 0, //!< No additional details
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME_PUTTOGETHERWITHPREVIOUSFIELDINSEQUENCE = 1, //!< 1^st field of previous frame
            PROGRESSIVE_CADENCE_RECONSTRUCTION_FOR_2ND_FIELD_OF_PREVIOUS_FRAME_PUTTOGETHERWITHNEXTFIELDINSEQUENCE = 2, //!< 1^st field of current frame
        };

        enum NEIGHBOR_PIXEL_THRESHOLD
        {
            NEIGHBOR_PIXEL_THRESHOLD_UNNAMED10                               = 10, //!< No additional details
        };

        //! \brief FASTERCOVERGENCE
        //! \details
        //!     For synthetic content faster convergence to current STMM value is
        //!     preferred.
        enum FASTERCOVERGENCE
        {
            FASTERCOVERGENCE_UNNAMED0                                        = 0, //!< No additional details
        };

        enum SAD_WT0
        {
            SAD_WT0_DEFAULTFORNATURALANDSYNTHETIC                            = 0, //!< No additional details
        };

        enum SAD_WT1
        {
            SAD_WT1_DEFAULTFORSYNTHETIC                                      = 12, //!< No additional details
            SAD_WT1_DEFAULTFORNATURAL                                        = 166, //!< No additional details
        };

        enum SAD_WT2
        {
            SAD_WT2_DEFAULTFORSYNTHETIC                                      = 25, //!< No additional details
            SAD_WT2_DEFAULTFORNATURAL                                        = 179, //!< No additional details
        };

        enum SAD_WT3
        {
            SAD_WT3_DEFAULTFORSYNTHETIC                                      = 38, //!< No additional details
            SAD_WT3_DEFAULTFORNATURAL                                        = 192, //!< No additional details
        };

        enum SAD_WT4
        {
            SAD_WT4_DEFAULTFORSYNTHETIC                                      = 90, //!< No additional details
            SAD_WT4_DEFAULTFORNATURAL                                        = 218, //!< No additional details
        };

        enum SAD_WT6
        {
            SAD_WT6_DEFAULTFORSYNTHETIC                                      = 64, //!< No additional details
            SAD_WT6_DEFAULTFORNATURAL                                        = 217, //!< No additional details
        };

        enum CORING_THRESHOLD_FOR_LUMA_SAD_CALCULATION
        {
            CORING_THRESHOLD_FOR_LUMA_SAD_CALCULATION_UNNAMED0               = 0, //!< No additional details
        };

        enum CORING_THRESHOLD_FOR_CHROMA_SAD_CALCULATION
        {
            CORING_THRESHOLD_FOR_CHROMA_SAD_CALCULATION_UNNAMED0             = 0, //!< No additional details
        };

        enum PAR_DIFFCHECKSLACKTHRESHOLD
        {
            PAR_DIFFCHECKSLACKTHRESHOLD_UNNAMED15                            = 15, //!< No additional details
        };

        enum PAR_TEARINGHIGHTHRESHOLD
        {
            PAR_TEARINGHIGHTHRESHOLD_UNNAMED100                              = 100, //!< No additional details
        };

        enum PAR_TEARINGLOWTHRESHOLD
        {
            PAR_TEARINGLOWTHRESHOLD_UNNAMED20                                = 20, //!< No additional details
        };

        enum PAR_DIRECTIONCHECKTH
        {
            PAR_DIRECTIONCHECKTH_UNNAMED3                                    = 3, //!< No additional details
        };

        enum PAR_SYNTHETICCONTENTCHECK
        {
            PAR_SYNTHETICCONTENTCHECK_UNNAMED0                               = 0, //!< No additional details
        };

        enum PAR_LOCALCHECK
        {
            PAR_LOCALCHECK_UNNAMED1                                          = 1, //!< No additional details
        };

        enum PAR_USESYNTHETICCONTENTMEDIAN
        {
            PAR_USESYNTHETICCONTENTMEDIAN_UNNAMED0                           = 0, //!< No additional details
        };

        enum LPFWTLUT0
        {
            LPFWTLUT0_UNNAMED0                                               = 0, //!< No additional details
        };

        enum LPFWTLUT1
        {
            LPFWTLUT1_UNNAMED0                                               = 0, //!< No additional details
        };

        enum LPFWTLUT2
        {
            LPFWTLUT2_UNNAMED0                                               = 0, //!< No additional details
        };

        enum LPFWTLUT3
        {
            LPFWTLUT3_UNNAMED0                                               = 0, //!< No additional details
        };

        enum LPFWTLUT4
        {
            LPFWTLUT4_UNNAMED32                                              = 32, //!< No additional details
        };

        enum LPFWTLUT5
        {
            LPFWTLUT5_UNNAMED64                                              = 64, //!< No additional details
        };

        enum LPFWTLUT6
        {
            LPFWTLUT6_UNNAMED128                                             = 128, //!< No additional details
        };

        enum LPFWTLUT7
        {
            LPFWTLUT7_UNNAMED255                                             = 255, //!< No additional details
        };

        enum TDM_UV_THRESHOLD
        {
            TDM_UV_THRESHOLD_UNNAMED100                                      = 100, //!< No additional details
        };

        enum HV_UV_THRESHOLD
        {
            HV_UV_THRESHOLD_UNNAMED30                                        = 30, //!< No additional details
        };

        enum TDM_HARMONIC_FACTOR_SYNTHETIC
        {
            TDM_HARMONIC_FACTOR_SYNTHETIC_UNNAMED4                           = 4, //!< No additional details
        };

        enum TDM_HARMONIC_FACTOR_NATURAL
        {
            TDM_HARMONIC_FACTOR_NATURAL_UNNAMED4                             = 4, //!< No additional details
        };

        enum SYNTHTIC_FRAME
        {
            SYNTHTIC_FRAME_UNNAMED0                                          = 0, //!< No additional details
        };

        enum SYNTHETIC_CONTENT_THRESHOLD
        {
            SYNTHETIC_CONTENT_THRESHOLD_UNNAMED1500                          = 1500, //!< No additional details
        };

        enum SVCM_HARMONIC_FACTOR_SYNTHETIC
        {
            SVCM_HARMONIC_FACTOR_SYNTHETIC_UNNAMED4                          = 4, //!< No additional details
        };

        enum SHCM_HARMONIC_FACTOR_SYNTHETIC
        {
            SHCM_HARMONIC_FACTOR_SYNTHETIC_UNNAMED4                          = 4, //!< No additional details
        };

        enum SVCM_HARMONIC_FACTOR_NATURAL
        {
            SVCM_HARMONIC_FACTOR_NATURAL_UNNAMED6                            = 6, //!< No additional details
        };

        enum SHCM_HARMONIC_FACTOR_NATURAL
        {
            SHCM_HARMONIC_FACTOR_NATURAL_UNNAMED6                            = 6, //!< No additional details
        };

        enum HARMONIC_COUNTER_THRESHOLD
        {
            HARMONIC_COUNTER_THRESHOLD_UNNAMED8                              = 8, //!< No additional details
        };

        enum MAX_HARMONIC_COUNTER_THRESHOLD
        {
            MAX_HARMONIC_COUNTER_THRESHOLD_UNNAMED15                         = 15, //!< No additional details
        };

        enum NATURAL_CONTENT_THRESHOLD
        {
            NATURAL_CONTENT_THRESHOLD_UNNAMED200                             = 200, //!< No additional details
        };

        enum MAXIMUM_VALUE
        {
            MAXIMUM_VALUE_UNNAMED67108863                                    = 67108863, //!< No additional details
        };

        enum SHIFTING_VALUE
        {
            SHIFTING_VALUE_UNNAMED32                                         = 32, //!< No additional details
        };

        enum HV_Y_THRESHOLD
        {
            HV_Y_THRESHOLD_UNNAMED50                                         = 50, //!< No additional details
        };

        enum NUM_INLINER_NUMERATOR_THRESHOLD
        {
            NUM_INLINER_NUMERATOR_THRESHOLD_UNNAMED3                         = 3, //!< No additional details
        };

        enum NUM_INLINER_DENOMINATOR_THRESHOLD
        {
            NUM_INLINER_DENOMINATOR_THRESHOLD_UNNAMED4                       = 4, //!< No additional details
        };

        enum LUMA_STAD_TH
        {
            LUMA_STAD_TH_UNNAMED3200                                         = 3200, //!< No additional details
        };

        enum CHROMA_STAD_TH
        {
            CHROMA_STAD_TH_UNNAMED1600                                       = 1600, //!< No additional details
        };

        enum LUMA_UNIFORMITY_LOW_TH1
        {
            LUMA_UNIFORMITY_LOW_TH1_UNNAMED1                                 = 1, //!< No additional details
        };

        enum LUMA_UNIFORMITY_LOW_TH2
        {
            LUMA_UNIFORMITY_LOW_TH2_UNNAMED2                                 = 2, //!< No additional details
        };

        enum LUMA_UNIFORMITY_HIGH_TH1
        {
            LUMA_UNIFORMITY_HIGH_TH1_UNNAMED15                               = 15, //!< No additional details
        };

        enum LUMA_UNIFORMITY_HIGH_TH2
        {
            LUMA_UNIFORMITY_HIGH_TH2_UNNAMED50                               = 50, //!< No additional details
        };

        enum CHROMA_UNIFORMITY_LOW_TH1
        {
            CHROMA_UNIFORMITY_LOW_TH1_UNNAMED1                               = 1, //!< No additional details
        };

        enum CHROMA_UNIFORMITY_LOW_TH2
        {
            CHROMA_UNIFORMITY_LOW_TH2_UNNAMED2                               = 2, //!< No additional details
        };

        enum CHROMA_UNIFORMITY_HIGH_TH1
        {
            CHROMA_UNIFORMITY_HIGH_TH1_UNNAMED15                             = 15, //!< No additional details
        };

        enum CHROMA_UNIFORMITY_HIGH_TH2
        {
            CHROMA_UNIFORMITY_HIGH_TH2_UNNAMED30                             = 30, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_DNDI_STATE_CMD();

        static const size_t dwSize = 53;
        static const size_t byteSize = 212;
    };

    //!
    //! \brief VEBOX_FRONT_END_CSC_STATE
    //! \details
    //!     This state structure contains the IECP State Table Contents for
    //!     Front-end CSC state.
    //!     
    struct VEBOX_FRONT_END_CSC_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 FecscC0TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C0_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved19                                       : __CODEGEN_BITFIELD(19, 30)    ; //!< Reserved
                uint32_t                 FrontEndCscTransformEnable                       : __CODEGEN_BITFIELD(31, 31)    ; //!< Front End CSC Transform Enable
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 FecscC1TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C1_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved51                                       : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 FecscC2TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C2_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved83                                       : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 FecscC3TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C3_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved115                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 FecscC4TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C4_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved147                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 FecscC5TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C5_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved179                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 FecscC6TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C6_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved211                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 FecscC7TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C7_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved243                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 FecscC8TransformCoefficient                      : __CODEGEN_BITFIELD( 0, 18)    ; //!< FECSC_C8_TRANSFORM_COEFFICIENT
                uint32_t                 Reserved275                                      : __CODEGEN_BITFIELD(19, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 FecScOffsetIn1OffsetInForYR                      : __CODEGEN_BITFIELD( 0, 15)    ; //!< FEC_SC_OFFSET_IN_1_OFFSET_IN_FOR_YR
                uint32_t                 FecScOffsetOut1OffsetOutForYR                    : __CODEGEN_BITFIELD(16, 31)    ; //!< FEC_SC_OFFSET_OUT_1_OFFSET_OUT_FOR_YR
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 FecScOffsetIn2OffsetOutForUG                     : __CODEGEN_BITFIELD( 0, 15)    ; //!< FEC_SC_OFFSET_IN_2_OFFSET_OUT_FOR_UG
                uint32_t                 FecScOffsetOut2OffsetOutForUG                    : __CODEGEN_BITFIELD(16, 31)    ; //!< FEC_SC_OFFSET_OUT_2_OFFSET_OUT_FOR_UG
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 FecScOffsetIn3OffsetOutForVB                     : __CODEGEN_BITFIELD( 0, 15)    ; //!< FEC_SC_OFFSET_IN_3_OFFSET_OUT_FOR_VB
                uint32_t                 FecScOffsetOut3OffsetOutForVB                    : __CODEGEN_BITFIELD(16, 31)    ; //!< FEC_SC_OFFSET_OUT_3_OFFSET_OUT_FOR_VB
            };
            uint32_t                     Value;
        } DW11;

        //! \name Local enumerations

        enum FECSC_C0_TRANSFORM_COEFFICIENT
        {
            FECSC_C0_TRANSFORM_COEFFICIENT_OR10                              = 65536, //!< No additional details
        };

        enum FECSC_C1_TRANSFORM_COEFFICIENT
        {
            FECSC_C1_TRANSFORM_COEFFICIENT_OR00                              = 0, //!< No additional details
        };

        enum FECSC_C2_TRANSFORM_COEFFICIENT
        {
            FECSC_C2_TRANSFORM_COEFFICIENT_OR00                              = 0, //!< No additional details
        };

        enum FECSC_C3_TRANSFORM_COEFFICIENT
        {
            FECSC_C3_TRANSFORM_COEFFICIENT_OR00                              = 0, //!< No additional details
        };

        enum FECSC_C4_TRANSFORM_COEFFICIENT
        {
            FECSC_C4_TRANSFORM_COEFFICIENT_OR10                              = 65536, //!< No additional details
        };

        enum FECSC_C5_TRANSFORM_COEFFICIENT
        {
            FECSC_C5_TRANSFORM_COEFFICIENT_OR00                              = 0, //!< No additional details
        };

        enum FECSC_C6_TRANSFORM_COEFFICIENT
        {
            FECSC_C6_TRANSFORM_COEFFICIENT_OR00                              = 0, //!< No additional details
        };

        enum FECSC_C7_TRANSFORM_COEFFICIENT
        {
            FECSC_C7_TRANSFORM_COEFFICIENT_OR00                              = 0, //!< No additional details
        };

        enum FECSC_C8_TRANSFORM_COEFFICIENT
        {
            FECSC_C8_TRANSFORM_COEFFICIENT_OR10                              = 65536, //!< No additional details
        };

        //! \brief FEC_SC_OFFSET_IN_1_OFFSET_IN_FOR_YR
        //! \details
        //!     The offset value is multiplied by 2 before being added to the output.
        enum FEC_SC_OFFSET_IN_1_OFFSET_IN_FOR_YR
        {
            FEC_SC_OFFSET_IN_1_OFFSET_IN_FOR_YR_UNNAMED0                     = 0, //!< No additional details
        };

        //! \brief FEC_SC_OFFSET_OUT_1_OFFSET_OUT_FOR_YR
        //! \details
        //!     The offset value is multiplied by 2 before being added to the output.
        enum FEC_SC_OFFSET_OUT_1_OFFSET_OUT_FOR_YR
        {
            FEC_SC_OFFSET_OUT_1_OFFSET_OUT_FOR_YR_UNNAMED0                   = 0, //!< No additional details
        };

        //! \brief FEC_SC_OFFSET_IN_2_OFFSET_OUT_FOR_UG
        //! \details
        //!     The offset value is multiplied by 2 before being added to the output.
        enum FEC_SC_OFFSET_IN_2_OFFSET_OUT_FOR_UG
        {
            FEC_SC_OFFSET_IN_2_OFFSET_OUT_FOR_UG_UNNAMED0                    = 0, //!< No additional details
        };

        //! \brief FEC_SC_OFFSET_OUT_2_OFFSET_OUT_FOR_UG
        //! \details
        //!     The offset value is multiplied by 2 before being added to the output.
        enum FEC_SC_OFFSET_OUT_2_OFFSET_OUT_FOR_UG
        {
            FEC_SC_OFFSET_OUT_2_OFFSET_OUT_FOR_UG_UNNAMED0                   = 0, //!< No additional details
        };

        //! \brief FEC_SC_OFFSET_IN_3_OFFSET_OUT_FOR_VB
        //! \details
        //!     The offset value is multiplied by 2 before being added to the output.
        enum FEC_SC_OFFSET_IN_3_OFFSET_OUT_FOR_VB
        {
            FEC_SC_OFFSET_IN_3_OFFSET_OUT_FOR_VB_UNNAMED0                    = 0, //!< No additional details
        };

        //! \brief FEC_SC_OFFSET_OUT_3_OFFSET_OUT_FOR_VB
        //! \details
        //!     The offset value is multiplied by 2 before being added to the output.
        enum FEC_SC_OFFSET_OUT_3_OFFSET_OUT_FOR_VB
        {
            FEC_SC_OFFSET_OUT_3_OFFSET_OUT_FOR_VB_UNNAMED0                   = 0, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_FRONT_END_CSC_STATE_CMD();

        static const size_t dwSize = 12;
        static const size_t byteSize = 48;
    };

    //!
    //! \brief VEBOX_GAMUT_CONTROL_STATE
    //! \details
    //!     
    //!     
    struct VEBOX_GAMUT_CONTROL_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 C1                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C1
                uint32_t                 Reserved21                                       : __CODEGEN_BITFIELD(21, 21)    ; //!< Reserved
                uint32_t                 GlobalModeEnable                                 : __CODEGEN_BITFIELD(22, 22)    ; //!< GLOBAL_MODE_ENABLE
                uint32_t                 AR                                               : __CODEGEN_BITFIELD(23, 31)    ; //!< AR
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 C0                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C0
                uint32_t                 Reserved53                                       : __CODEGEN_BITFIELD(21, 21)    ; //!< Reserved
                uint32_t                 CmW                                              : __CODEGEN_BITFIELD(22, 31)    ; //!< CM(w)
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 C3                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C3
                uint32_t                 Reserved85                                       : __CODEGEN_BITFIELD(21, 21)    ; //!< Reserved
                uint32_t                 CmS                                              : __CODEGEN_BITFIELD(22, 31)    ; //!< CM(s)
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 C2                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C2
                uint32_t                 Reserved117                                      : __CODEGEN_BITFIELD(21, 24)    ; //!< Reserved
                uint32_t                 AG                                               : __CODEGEN_BITFIELD(25, 31)    ; //!< A(g)
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 C5                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C5
                uint32_t                 Reserved149                                      : __CODEGEN_BITFIELD(21, 24)    ; //!< Reserved
                uint32_t                 AB                                               : __CODEGEN_BITFIELD(25, 31)    ; //!< A(b)
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 C4                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C4
                uint32_t                 Reserved181                                      : __CODEGEN_BITFIELD(21, 21)    ; //!< Reserved
                uint32_t                 RS                                               : __CODEGEN_BITFIELD(22, 31)    ; //!< R(s)
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 C7                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C7
                uint32_t                 Reserved213                                      : __CODEGEN_BITFIELD(21, 23)    ; //!< Reserved
                uint32_t                 CmI                                              : __CODEGEN_BITFIELD(24, 31)    ; //!< CM(i)
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 C6                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C6
                uint32_t                 Reserved245                                      : __CODEGEN_BITFIELD(21, 23)    ; //!< Reserved
                uint32_t                 RI                                               : __CODEGEN_BITFIELD(24, 31)    ; //!< R(i)
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 C8                                               : __CODEGEN_BITFIELD( 0, 20)    ; //!< C8
                uint32_t                 Reserved277                                      : __CODEGEN_BITFIELD(21, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 OffsetInR                                        : __CODEGEN_BITFIELD( 0, 16)    ; //!< OFFSET_IN_R
                uint32_t                 Reserved305                                      : __CODEGEN_BITFIELD(17, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 OffsetInG                                        : __CODEGEN_BITFIELD( 0, 16)    ; //!< OFFSET_IN_G
                uint32_t                 Reserved337                                      : __CODEGEN_BITFIELD(17, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 OffsetInB                                        : __CODEGEN_BITFIELD( 0, 16)    ; //!< OFFSET_IN_B
                uint32_t                 Reserved369                                      : __CODEGEN_BITFIELD(17, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                uint32_t                 OffsetOutR                                       : __CODEGEN_BITFIELD( 0, 16)    ; //!< OFFSET_OUT_R
                uint32_t                 Reserved401                                      : __CODEGEN_BITFIELD(17, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                uint32_t                 OffsetOutG                                       : __CODEGEN_BITFIELD( 0, 16)    ; //!< OFFSET_OUT_G
                uint32_t                 Reserved433                                      : __CODEGEN_BITFIELD(17, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                uint32_t                 OffsetOutB                                       : __CODEGEN_BITFIELD( 0, 16)    ; //!< OFFSET_OUT_B
                uint32_t                 Reserved465                                      : __CODEGEN_BITFIELD(17, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                uint32_t                 D1Out                                            : __CODEGEN_BITFIELD( 0,  9)    ; //!< D1OUT
                uint32_t                 DOutDefault                                      : __CODEGEN_BITFIELD(10, 19)    ; //!< DOUT_DEFAULT
                uint32_t                 DInDefault                                       : __CODEGEN_BITFIELD(20, 29)    ; //!< DINDEFAULT
                uint32_t                 Fullrangemappingenable                           : __CODEGEN_BITFIELD(30, 30)    ; //!< FULLRANGEMAPPINGENABLE
                uint32_t                 Reserved511                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                uint32_t                 D1In                                             : __CODEGEN_BITFIELD( 0,  9)    ; //!< D1IN
                uint32_t                 Reserved522                                      : __CODEGEN_BITFIELD(10, 27)    ; //!< Reserved
                uint32_t                 Compressionlineshift                             : __CODEGEN_BITFIELD(28, 30)    ; //!< COMPRESSIONLINESHIFT
                uint32_t                 Xvyccdecencenable                                : __CODEGEN_BITFIELD(31, 31)    ; //!< XVYCCDECENCENABLE
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                uint32_t                 CpiOverride                                      : __CODEGEN_BITFIELD( 0,  0)    ; //!< CPI_OVERRIDE
                uint32_t                 Reserved545                                      : __CODEGEN_BITFIELD( 1, 10)    ; //!< Reserved
                uint32_t                 Basicmodescalingfactor                           : __CODEGEN_BITFIELD(11, 24)    ; //!< BasicModeScalingFactor
                uint32_t                 Reserved569                                      : __CODEGEN_BITFIELD(25, 28)    ; //!< Reserved
                uint32_t                 Lumachormaonlycorrection                         : __CODEGEN_BITFIELD(29, 29)    ; //!< LUMACHORMAONLYCORRECTION
                uint32_t                 GccBasicmodeselection                            : __CODEGEN_BITFIELD(30, 31)    ; //!< GCC_BASICMODESELECTION
            };
            uint32_t                     Value;
        } DW17;

        //! \name Local enumerations

        //! \brief C1
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C1
        {
            C1_1825665536                                                    = 18256, //!< No additional details
        };

        //! \brief GLOBAL_MODE_ENABLE
        //! \details
        //!     The gain factor derived from state CM(w).
        enum GLOBAL_MODE_ENABLE
        {
            GLOBAL_MODE_ENABLE_ADVANCEMODE                                   = 0, //!< No additional details
            GLOBAL_MODE_ENABLE_BASICMODE                                     = 1, //!< No additional details
        };

        //! \brief AR
        //! \details
        //!     Gain_factor_R (default: 436, preferred range: 256-511).
        enum AR
        {
            AR_UNNAMED436                                                    = 436, //!< No additional details
        };

        //! \brief C0
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C0
        {
            C0_4467265536                                                    = 44672, //!< No additional details
        };

        //! \brief C3
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C3
        {
            C3_113665536                                                     = 1136, //!< No additional details
        };

        //! \brief C2
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C2
        {
            C2_54465536                                                      = 544, //!< No additional details
        };

        //! \brief C5
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C5
        {
            C5_83265536                                                      = 2096320, //!< No additional details
        };

        //! \brief C4
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C4
        {
            C4_5380865536                                                    = 53808, //!< No additional details
        };

        //! \brief C7
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C7
        {
            C7_268865536                                                     = 2688, //!< No additional details
        };

        //! \brief C6
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C6
        {
            C6_19265536                                                      = 2096960, //!< No additional details
        };

        //! \brief C8
        //! \details
        //!     Coefficient of 3x3 Transform matrix.
        enum C8
        {
            C8_5494465536                                                    = 54944, //!< No additional details
        };

        //! \brief OFFSET_IN_R
        //! \details
        //!     The input offset for red component.
        enum OFFSET_IN_R
        {
            OFFSET_IN_R_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_IN_G
        //! \details
        //!     The input offset for green component.
        enum OFFSET_IN_G
        {
            OFFSET_IN_G_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_IN_B
        //! \details
        //!     The input offset for blue component.
        enum OFFSET_IN_B
        {
            OFFSET_IN_B_UNNAMED0                                             = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_R
        //! \details
        //!     The output offset for red component.
        enum OFFSET_OUT_R
        {
            OFFSET_OUT_R_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_G
        //! \details
        //!     The output offset for green component.
        enum OFFSET_OUT_G
        {
            OFFSET_OUT_G_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \brief OFFSET_OUT_B
        //! \details
        //!     The output offset for blue component.
        enum OFFSET_OUT_B
        {
            OFFSET_OUT_B_UNNAMED0                                            = 0, //!< No additional details
        };

        //! \brief D1OUT
        //! \details
        //!     OuterTriangleMappingLengthBelow.
        enum D1OUT
        {
            D1OUT_UNNAMED287                                                 = 287, //!< No additional details
        };

        //! \brief DOUT_DEFAULT
        //! \details
        //!     OuterTriangleMappingLength.
        enum DOUT_DEFAULT
        {
            DOUT_DEFAULT_UNNAMED164                                          = 164, //!< No additional details
        };

        //! \brief DINDEFAULT
        //! \details
        //!     InnerTriangleMappingLength.
        enum DINDEFAULT
        {
            DINDEFAULT_UNNAMED205                                            = 205, //!< No additional details
        };

        enum FULLRANGEMAPPINGENABLE
        {
            FULLRANGEMAPPINGENABLE_BASICMODE                                 = 0, //!< No additional details
            FULLRANGEMAPPINGENABLE_ADVANCEMODE                               = 1, //!< No additional details
        };

        //! \brief D1IN
        //! \details
        //!     InnerTriangleMappingLengthBelow.
        enum D1IN
        {
            D1IN_UNNAMED820                                                  = 820, //!< No additional details
        };

        //! \brief COMPRESSIONLINESHIFT
        //! \details
        //!     .
        enum COMPRESSIONLINESHIFT
        {
            COMPRESSIONLINESHIFT_UNNAMED0                                    = 0, //!< No additional details
            COMPRESSIONLINESHIFT_UNNAMED3                                    = 3, //!< No additional details
            COMPRESSIONLINESHIFT_UNNAMED4                                    = 4, //!< No additional details
        };

        //! \brief XVYCCDECENCENABLE
        //! \details
        //!     This bit is valid only when ColorGamutCompressionnEnable is on.
        enum XVYCCDECENCENABLE
        {
            XVYCCDECENCENABLE_TODISABLEBOTHXVYCCDECODEANDXVYCCENCODE         = 0, //!< No additional details
            XVYCCDECENCENABLE_BOTHXVYCCDECODEANDXVYCCENCODEAREENABLED        = 1, //!< No additional details
        };

        enum CPI_OVERRIDE
        {
            CPI_OVERRIDE_UNNAMED0                                            = 0, //!< No additional details
            CPI_OVERRIDE_OVERRIDECPICALCULATION                              = 1, //!< No additional details
        };

        enum LUMACHORMAONLYCORRECTION
        {
            LUMACHORMAONLYCORRECTION_LUMAONLYCORRECTION                      = 0, //!< No additional details
            LUMACHORMAONLYCORRECTION_CHORMAONLYCORRECTION                    = 1, //!< No additional details
        };

        enum GCC_BASICMODESELECTION
        {
            GCC_BASICMODESELECTION_DEFAULT                                   = 0, //!< No additional details
            GCC_BASICMODESELECTION_SCALINGFACTOR                             = 1, //!< Used along with Dword66 Bits 28:11
            GCC_BASICMODESELECTION_SINGLEAXISGAMMACORRECTION                 = 2, //!< Used along with Dword67 Bit 29
            GCC_BASICMODESELECTION_SCALINGFACTORWITHFIXEDLUMA                = 3, //!< Used along with Dword37 Bits 28:11
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_GAMUT_CONTROL_STATE_CMD();

        static const size_t dwSize = 18;
        static const size_t byteSize = 72;
    };

    //!
    //! \brief VEBOX_IECP_STATE
    //! \details
    //!     
    //!     
    struct VEBOX_IECP_STATE_CMD
    {
        VEBOX_STD_STE_STATE_CMD                  StdSteState;                                                             //!< DW0..28, STD/STE State
        VEBOX_ACE_LACE_STATE_CMD                 AceState;                                                                //!< DW29..59, ACE State
        VEBOX_TCC_STATE_CMD                      TccState;                                                                //!< DW60..70, TCC State
        VEBOX_PROCAMP_STATE_CMD                  ProcampState;                                                            //!< DW71..72, ProcAmp State
        VEBOX_CSC_STATE_CMD                      CscState;                                                                //!< DW73..84, CSC State
        VEBOX_ALPHA_AOI_STATE_CMD                AlphaAoiState;                                                           //!< DW85..87, Alpha/AOI State
        VEBOX_CCM_STATE_CMD                      CcmState;                                                                //!< DW88..102, CCM State
        VEBOX_FRONT_END_CSC_STATE_CMD            FrontEndCsc;                                                             //!< DW103..114, Front-end CSC
        VEBOX_GAMUT_CONTROL_STATE_CMD            GamutState;                                                              //!< DW115..132, Gamut_STATE

        //! \name Local enumerations

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_IECP_STATE_CMD();

        static const size_t dwSize = 133;
        static const size_t byteSize = 532;
    };

    //!
    //! \brief VEBOX_Ch_Dir_Filter_Coefficient
    //! \details
    //!     
    //!     
    struct VEBOX_Ch_Dir_Filter_Coefficient_CMD
    {
        union
        {
            struct
            {
                uint32_t                 FilterCoefficient0                               : __CODEGEN_BITFIELD( 0,  7)    ; //!< Filter Coefficient[0]
                uint32_t                 FilterCoefficient1                               : __CODEGEN_BITFIELD( 8, 15)    ; //!< Filter Coefficient[1]
                uint32_t                 FilterCoefficient2                               : __CODEGEN_BITFIELD(16, 23)    ; //!< Filter Coefficient[2]
                uint32_t                 FilterCoefficient3                               : __CODEGEN_BITFIELD(24, 31)    ; //!< Filter Coefficient[3]
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 FilterCoefficient4                               : __CODEGEN_BITFIELD( 0,  7)    ; //!< Filter Coefficient[4]
                uint32_t                 FilterCoefficient5                               : __CODEGEN_BITFIELD( 8, 15)    ; //!< Filter Coefficient[5]
                uint32_t                 FilterCoefficient6                               : __CODEGEN_BITFIELD(16, 23)    ; //!< Filter Coefficient[6]
                uint32_t                 FilterCoefficient7                               : __CODEGEN_BITFIELD(24, 31)    ; //!< Filter Coefficient[7]
            };
            uint32_t                     Value;
        } DW1;

        //! \name Local enumerations

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_Ch_Dir_Filter_Coefficient_CMD();

        static const size_t dwSize = 2;
        static const size_t byteSize = 8;
    };

    //!
    //! \brief VEBOX_STATE
    //! \details
    //!     This command controls the internal functions of the VEBOX. This command
    //!     has a set of indirect state buffers:
    //!     
    //!     DN/DI state
    //!     
    //!     IECP general state
    //!     
    //!     IECP Gamut Expansion/Compression state
    //!     
    //!     IECP Gamut Vertex Table state
    //!     
    //!     IECP Shaper Table state
    //!     
    //!     Capture Pipe state
    //!     
    //!     
    //!     
    //!     [DevSKL+]: Adds the LACE LUT Table as an indirect state buffer.
    //!     
    struct VEBOX_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 DwordLength                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< DWORD_LENGTH
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; //!< Reserved
                uint32_t                 SubopcodeB                                       : __CODEGEN_BITFIELD(16, 20)    ; //!< SUBOPCODE_B
                uint32_t                 SubopcodeA                                       : __CODEGEN_BITFIELD(21, 23)    ; //!< SUBOPCODE_A
                uint32_t                 CommandOpcode                                    : __CODEGEN_BITFIELD(24, 26)    ; //!< COMMAND_OPCODE
                uint32_t                 Pipeline                                         : __CODEGEN_BITFIELD(27, 28)    ; //!< PIPELINE
                uint32_t                 CommandType                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< COMMAND_TYPE
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 ColorGamutExpansionEnable                        : __CODEGEN_BITFIELD( 0,  0)    ; //!< Color Gamut Expansion Enable
                uint32_t                 ColorGamutCompressionEnable                      : __CODEGEN_BITFIELD( 1,  1)    ; //!< Color Gamut Compression Enable
                uint32_t                 GlobalIecpEnable                                 : __CODEGEN_BITFIELD( 2,  2)    ; //!< Global IECP Enable
                uint32_t                 DnEnable                                         : __CODEGEN_BITFIELD( 3,  3)    ; //!< DN_ENABLE
                uint32_t                 DiEnable                                         : __CODEGEN_BITFIELD( 4,  4)    ; //!< DI_ENABLE
                uint32_t                 DnDiFirstFrame                                   : __CODEGEN_BITFIELD( 5,  5)    ; //!< DNDI_FIRST_FRAME
                uint32_t                 Reserved38                                       : __CODEGEN_BITFIELD( 6,  7)    ; //!< Reserved
                uint32_t                 DiOutputFrames                                   : __CODEGEN_BITFIELD( 8,  9)    ; //!< DI_OUTPUT_FRAMES
                uint32_t                 DemosaicEnable                                   : __CODEGEN_BITFIELD(10, 10)    ; //!< Demosaic Enable
                uint32_t                 VignetteEnable                                   : __CODEGEN_BITFIELD(11, 11)    ; //!< Vignette Enable
                uint32_t                 AlphaPlaneEnable                                 : __CODEGEN_BITFIELD(12, 12)    ; //!< Alpha Plane Enable 
                uint32_t                 HotPixelFilteringEnable                          : __CODEGEN_BITFIELD(13, 13)    ; //!< Hot Pixel Filtering Enable
                uint32_t                 Reserved46                                       : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 LaceCorrectionEnable                             : __CODEGEN_BITFIELD(16, 16)    ; //!< LACE Correction Enable
                uint32_t                 DisableEncoderStatistics                         : __CODEGEN_BITFIELD(17, 17)    ; //!< Disable Encoder Statistics
                uint32_t                 DisableTemporalDenoiseFilter                     : __CODEGEN_BITFIELD(18, 18)    ; //!< Disable Temporal Denoise Filter
                uint32_t                 SinglePipeEnable                                 : __CODEGEN_BITFIELD(19, 19)    ; //!< SINGLE_PIPE_ENABLE
                uint32_t                 ScalarMode                                       : __CODEGEN_BITFIELD(20, 20)    ; //!< Scalar Mode
                uint32_t                 ForwardGammaCorrectionEnable                     : __CODEGEN_BITFIELD(21, 21)    ; //!< Forward Gamma Correction Enable
                uint32_t                 GamutExpansionPosition                           : __CODEGEN_BITFIELD(22, 22)    ; //!< GAMUT_EXPANSION_POSITION
                uint32_t                 HdrEnable                                        : __CODEGEN_BITFIELD(23, 23)    ; //!< HDR Enable
                uint32_t                 Fp16ModeEnable                                   : __CODEGEN_BITFIELD(24, 24)    ; //!< FP16 mode enable
                uint32_t                 StateSurfaceControlBits                          : __CODEGEN_BITFIELD(25, 31)    ; //!< State Surface Control Bits
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 Reserved64                                       : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint32_t                 DnDiStatePointerLow                              : __CODEGEN_BITFIELD(12, 31)    ; //!< DN/DI State Pointer Low
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 DnDiStatePointerHigh                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< DN/DI State Pointer High
                uint32_t                 Reserved112                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 Reserved128                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint32_t                 IecpStatePointerLow                              : __CODEGEN_BITFIELD(12, 31)    ; //!< IECP State Pointer Low
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 IecpStatePointerHigh                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< IECP State Pointer High
                uint32_t                 Reserved176                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 Reserved192                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint32_t                 GamutHdrStatePointerLow                          : __CODEGEN_BITFIELD(12, 31)    ; //!< Gamut/HDR State Pointer Low
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 GamutHdrStatePointerHigh                         : __CODEGEN_BITFIELD( 0, 15)    ; //!< Gamut/HDR State Pointer High
                uint32_t                 Reserved240                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 Reserved256                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint32_t                 VertexTableStatePointerLow                       : __CODEGEN_BITFIELD(12, 31)    ; //!< Vertex Table State Pointer Low
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 VertexTableStatePointerHigh                      : __CODEGEN_BITFIELD( 0, 15)    ; //!< Vertex Table State Pointer High
                uint32_t                 Reserved304                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 Reserved320                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint32_t                 CapturePipeStatePointerLow                       : __CODEGEN_BITFIELD(12, 31)    ; //!< Capture Pipe State Pointer Low
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 CapturePipeStatePointerHigh                      : __CODEGEN_BITFIELD( 0, 15)    ; //!< Capture Pipe State Pointer High
                uint32_t                 Reserved368                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                uint32_t                 Reserved384                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint32_t                 LaceLutTableStatePointerLow                      : __CODEGEN_BITFIELD(12, 31)    ; //!< LACE LUT Table State Pointer Low
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                uint32_t                 LaceLutTableStatePointerHigh                     : __CODEGEN_BITFIELD( 0, 15)    ; //!< LACE LUT Table State Pointer High
                uint32_t                 Reserved432                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 ArbitrationPriorityControlForLaceLut             : __CODEGEN_BITFIELD(30, 31)    ; //!< ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                uint64_t                 Reserved448                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint64_t                 GammaCorrectionValuesAddress                     : __CODEGEN_BITFIELD(12, 63)    ; //!< Gamma Correction Values Address
            };
            uint32_t                     Value[2];
        } DW14_15;
        union
        {
            struct
            {
                uint32_t                 Reserved512                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint32_t                 Lut3DStatePointerLow                             : __CODEGEN_BITFIELD(12, 31)    ; //!< 3D LUT State Pointer Low
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                uint32_t                 Lut3DStatePointerHigh                            : __CODEGEN_BITFIELD( 0, 15)    ; //!< 3D LUT State Pointer High
                uint32_t                 Lut3DMocsTable                                   : __CODEGEN_BITFIELD(16, 21)    ; //!< 3D LUT MOCS table
                uint32_t                 ChannelMappingSwapForLut3D                       : __CODEGEN_BITFIELD(22, 22)    ; //!< Channel mapping swap for 3D LUT
                uint32_t                 Reserved567                                      : __CODEGEN_BITFIELD(23, 28)    ; //!< Reserved
                uint32_t                 EncDataControlFor3DLUT                           : __CODEGEN_BITFIELD(29, 29)    ; //!< Enc data control - For 3D LUT
                uint32_t                 ArbitrationPriorityControlForLut3D               : __CODEGEN_BITFIELD(30, 31)    ; //!< ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                uint32_t                 ChromaUpsamplingCoSitedHorizontalOffset          : __CODEGEN_BITFIELD( 0,  1)    ; //!< CHROMA_UPSAMPLING_CO_SITED_HORIZONTAL_OFFSET
                uint32_t                 ChromaUpsamplingCoSitedVerticalOffset            : __CODEGEN_BITFIELD( 2,  4)    ; //!< CHROMA_UPSAMPLING_CO_SITED_VERTICAL_OFFSET
                uint32_t                 ChromaDownsamplingCoSitedHorizontalOffset        : __CODEGEN_BITFIELD( 5,  6)    ; //!< CHROMA_DOWNSAMPLING_CO_SITED_HORIZONTAL_OFFSET
                uint32_t                 ChromaDownsamplingCoSitedVerticalOffset          : __CODEGEN_BITFIELD( 7,  9)    ; //!< CHROMA_DOWNSAMPLING_CO_SITED_VERTICAL_OFFSET
                uint32_t                 BypassChromaUpsampling                           : __CODEGEN_BITFIELD(10, 10)    ; //!< BYPASS_CHROMA_UPSAMPLING
                uint32_t                 BypassChromaDownsampling                         : __CODEGEN_BITFIELD(11, 11)    ; //!< BYPASS_CHROMA_DOWNSAMPLING
                uint32_t                 FrameStatisticsId                                : __CODEGEN_BITFIELD(12, 13)    ; //!< Frame statistics ID
                uint32_t                 Reserved590                                      : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 _1DLutSize                                       : __CODEGEN_BITFIELD(16, 16)    ; //!< _1D_LUT_SIZE
                uint32_t                 OffsetFor45X45X453Dlut                           : __CODEGEN_BITFIELD(17, 17)    ; //!< OFFSET_FOR_45X45X45_3DLUT
                uint32_t                 RoundAndDitheringEnable                          : __CODEGEN_BITFIELD(18, 19)    ; //!< ROUND_AND_DITHERING_ENABLE
                uint32_t                 ColorUpsamplingBitDepth                          : __CODEGEN_BITFIELD(20, 21)    ; //!< COLOR_UPSAMPLING_BIT_DEPTH
                uint32_t                 ColorUpsamplingFilterOptions                     : __CODEGEN_BITFIELD(22, 22)    ; //!< COLOR_UPSAMPLING_FILTER_OPTIONS
                uint32_t                 Reserved599                                      : __CODEGEN_BITFIELD(23, 28)    ; //!< Reserved
                uint32_t                 Lut3DSize                                        : __CODEGEN_BITFIELD(29, 30)    ; //!< _3D_LUT_SIZE
                uint32_t                 Lut3DEnable                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< _3D_LUT_ENABLE
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                uint32_t                 RPixelValueForLetterbox                          : __CODEGEN_BITFIELD( 0, 15)    ; //!< R-pixel value for letterbox
                uint32_t                 GPixelValueForLetterbox                          : __CODEGEN_BITFIELD(16, 31)    ; //!< G-pixel value for letterbox
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                uint32_t                 BPixelValueForLetterbox                          : __CODEGEN_BITFIELD( 0, 15)    ; //!< B-pixel value for letterbox
                uint32_t                 Reserved656                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                uint32_t                 Reserved672                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< Reserved
                uint32_t                 VeboxShaper1KLookupStatePointerLow               : __CODEGEN_BITFIELD(12, 31)    ; //!< VEBOX SHAPER 1K LOOKUP State Pointer Low
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                uint32_t                 VeboxShaper1KLookupStatePointerHigh              : __CODEGEN_BITFIELD( 0, 15)    ; //!< VEBOX SHAPER 1K LOOKUP State Pointer High
                uint32_t                 Reserved720                                      : __CODEGEN_BITFIELD(16, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW22;

        //! \name Local enumerations

        enum SUBOPCODE_B
        {
            SUBOPCODE_B_UNNAMED2                                             = 2, //!< No additional details
        };

        enum SUBOPCODE_A
        {
            SUBOPCODE_A_UNNAMED0                                             = 0, //!< No additional details
        };

        enum COMMAND_OPCODE
        {
            COMMAND_OPCODE_VEBOX                                             = 4, //!< No additional details
        };

        enum PIPELINE
        {
            PIPELINE_MEDIA                                                   = 2, //!< No additional details
        };

        enum COMMAND_TYPE
        {
            COMMAND_TYPE_PARALLELVIDEOPIPE                                   = 3, //!< No additional details
        };

        //! \brief DN_ENABLE
        //! \details
        //!     Denoise is bypassed if this is low - BNE is still calculated and output,
        //!     but the denoised fields are not. VDI does not read in the denoised
        //!     previous frame but uses the pointer for the original previous frame.
        enum DN_ENABLE
        {
            DN_ENABLE_DONOTDENOISEFRAME                                      = 0, //!< No additional details
            DN_ENABLE_DENOISEFRAME                                           = 1, //!< No additional details
        };

        //! \brief DI_ENABLE
        //! \details
        //!     Deinterlacer is bypassed if this is disabled:  the output is the same as
        //!     the input (same as a 2:2 cadence). FMD and STMM are not calculated and
        //!     the values in the response message are 0.
        enum DI_ENABLE
        {
            DI_ENABLE_DONOTCALCULATEDI                                       = 0, //!< No additional details
            DI_ENABLE_CALCULATEDI                                            = 1, //!< No additional details
        };

        //! \brief DNDI_FIRST_FRAME
        //! \details
        //!     Indicates that this is the first frame of the stream, so previous clean
        //!     is not available.
        enum DNDI_FIRST_FRAME
        {
            DNDI_FIRST_FRAME_NOTFIRSTFIELD_PREVIOUSCLEANSURFACESTATEISVALID  = 0, //!< No additional details
            DNDI_FIRST_FRAME_FIRSTFIELD_PREVIOUSCLEANSURFACESTATEISINVALID   = 1, //!< No additional details
        };

        //! \brief DI_OUTPUT_FRAMES
        //! \details
        //!     Indicates which frames to output in DI mode.
        enum DI_OUTPUT_FRAMES
        {
            DI_OUTPUT_FRAMES_OUTPUTBOTHFRAMES                                = 0, //!< No additional details
            DI_OUTPUT_FRAMES_OUTPUTPREVIOUSFRAMEONLY                         = 1, //!< No additional details
            DI_OUTPUT_FRAMES_OUTPUTCURRENTFRAMEONLY                          = 2, //!< No additional details
        };

        //! \brief SINGLE_PIPE_ENABLE
        //! \details
        //!     Indicates that the Capture Pipe features that only exist in a single
        //!     pipe can be enabled.
        enum SINGLE_PIPE_ENABLE
        {
            SINGLE_PIPE_ENABLE_DEFAULT                                       = 0, //!< No additional details
            SINGLE_PIPE_ENABLE_ENABLE                                        = 1, //!< No additional details
        };

        //! \brief GAMUT_EXPANSION_POSITION
        //! \details
        //!     If Gamut Expansion is enabled, it can be configured either in front
        //!     or backend of the IECP pipe using this bit.
        enum GAMUT_EXPANSION_POSITION
        {
            GAMUT_EXPANSION_POSITION_GAMUTEXPANSIONATTHEBACKENDOFIECPPIPE    = 0, //!< No additional details
            GAMUT_EXPANSION_POSITION_GAMUTEXPANSIONATTHEFRONTOFIECPPIPE      = 1, //!< No additional details
        };

        //! \brief ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT
        {
            ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_HIGHESTPRIORITY        = 0, //!< No additional details
            ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_SECONDHIGHESTPRIORITY  = 1, //!< No additional details
            ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_THIRDHIGHESTPRIORITY   = 2, //!< No additional details
            ARBITRATION_PRIORITY_CONTROL_FOR_LACE_LUT_LOWESTPRIORITY         = 3, //!< No additional details
        };

        //! \brief ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT
        {
            ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_HIGHESTPRIORITY          = 0, //!< No additional details
            ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_SECONDHIGHESTPRIORITY    = 1, //!< No additional details
            ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_THIRDHIGHESTPRIORITY     = 2, //!< No additional details
            ARBITRATION_PRIORITY_CONTROL_FOR_3D_LUT_LOWESTPRIORITY           = 3, //!< No additional details
        };

        enum CHROMA_UPSAMPLING_CO_SITED_HORIZONTAL_OFFSET
        {
            CHROMA_UPSAMPLING_CO_SITED_HORIZONTAL_OFFSET_UNNAMED0            = 0, //!< No additional details
        };

        enum CHROMA_UPSAMPLING_CO_SITED_VERTICAL_OFFSET
        {
            CHROMA_UPSAMPLING_CO_SITED_VERTICAL_OFFSET_UNNAMED0              = 0, //!< No additional details
        };

        enum CHROMA_DOWNSAMPLING_CO_SITED_HORIZONTAL_OFFSET
        {
            CHROMA_DOWNSAMPLING_CO_SITED_HORIZONTAL_OFFSET_UNNAMED0          = 0, //!< No additional details
        };

        enum CHROMA_DOWNSAMPLING_CO_SITED_VERTICAL_OFFSET
        {
            CHROMA_DOWNSAMPLING_CO_SITED_VERTICAL_OFFSET_UNNAMED0            = 0, //!< No additional details
        };

        //! \brief BYPASS_CHROMA_UPSAMPLING
        //! \details
        //!     When enabled will replicate chroma samples at odd position and not
        //!     use the co-sited offsets.
        enum BYPASS_CHROMA_UPSAMPLING
        {
            BYPASS_CHROMA_UPSAMPLING_UNNAMED0                                = 0, //!< No additional details
        };

        //! \brief BYPASS_CHROMA_DOWNSAMPLING
        //! \details
        //!     When enabled will drop chroma samples at odd position and not use the
        //!     co-sited offsets.
        enum BYPASS_CHROMA_DOWNSAMPLING
        {
            BYPASS_CHROMA_DOWNSAMPLING_UNNAMED0                              = 0, //!< No additional details
        };

        //! \brief _1D_LUT_SIZE
        //! \details
        //!     Bit to select the size of 1DLUT
        enum _1D_LUT_SIZE
        {
            _1D_LUT_SIZE_1DLUTSIZE_4K                                        = 0, //!< No additional details
            _1D_LUT_SIZE_1DLUTSIZE_1K                                        = 1, //!< No additional details
        };

        //! \brief OFFSET_FOR_45X45X45_3DLUT
        //! \details
        //!     This bit is to enable an offset of 1024 in the 45x45x45 look 3D LUT
        //!     table indexing operation defined<span
        //!     style="line-height:107%"><span
        //!     style="font-family:&quot;Calibri&quot;,sans-serif">min(0,
        //!     (((ABS(X-offset))>>9)*21846)>>16)
        enum OFFSET_FOR_45X45X45_3DLUT
        {
            OFFSET_FOR_45X45X45_3DLUT_OFFSETVALUE0                           = 0, //!< No additional details
            OFFSET_FOR_45X45X45_3DLUT_OFFSETVALUE1024                        = 1, //!< No additional details
        };

        //! \brief ROUND_AND_DITHERING_ENABLE
        //! \details
        //!     This bit enables dithering logic
        enum ROUND_AND_DITHERING_ENABLE
        {
            ROUND_AND_DITHERING_ENABLE_NOROUNDINGANDNODITHERING              = 0, //!< No additional details
            ROUND_AND_DITHERING_ENABLE_ROUNDING                              = 1, //!< No additional details
            ROUND_AND_DITHERING_ENABLE_DITHERING                             = 2, //!< No additional details
        };

        //! \brief COLOR_UPSAMPLING_BIT_DEPTH
        //! \details
        //!     Specifies the bit depth of the input data for color upsampling operation
        enum COLOR_UPSAMPLING_BIT_DEPTH
        {
            COLOR_UPSAMPLING_BIT_DEPTH_16_BIT                                = 0, //!< No additional details
            COLOR_UPSAMPLING_BIT_DEPTH_12_BIT                                = 1, //!< No additional details
            COLOR_UPSAMPLING_BIT_DEPTH_10_BIT                                = 2, //!< No additional details
        };

        //! \brief COLOR_UPSAMPLING_FILTER_OPTIONS
        //! \details
        //!     Specifies the filter options for color upsampling in the VCUS unit.
        enum COLOR_UPSAMPLING_FILTER_OPTIONS
        {
            COLOR_UPSAMPLING_FILTER_OPTIONS_2_TAPFILTER                      = 0, //!< No additional details
            COLOR_UPSAMPLING_FILTER_OPTIONS_4_TAPFILTER                      = 1, //!< No additional details
        };

        enum _3D_LUT_SIZE
        {
            _3D_LUT_SIZE_33X33X33                                            = 0, //!< No additional details
            _3D_LUT_SIZE_17X17X17                                            = 1, //!< No additional details
            _3D_LUT_SIZE_65X65X65                                            = 2, //!< No additional details
            _3D_LUT_SIZE_45X45X45                                            = 3, //!< No additional details
        };

        //! \brief _3D_LUT_ENABLE
        //! \details
        //!     3D LUT is required only if this is enabled.
        enum _3D_LUT_ENABLE
        {
            _3D_LUT_ENABLE_UNNAMED0                                          = 0, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_STATE_CMD();

        static const size_t dwSize = 23;
        static const size_t byteSize = 92;
    };

    //!
    //! \brief VEBOX_SURFACE_STATE
    //! \details
    //!     The input and output data containers accessed are called "surfaces".
    //!     Surface state is sent to VEBOXvia an inline state command rather than
    //!     using binding tables. SURFACE_STATE contains the parametersdefining each
    //!     surface to be accessed, including its size, format, and offsets to its
    //!     subsurfaces.The surface's base address is in the execution command.
    //!     Despite having multiple input and outputsurfaces, we limit the number of
    //!     surface states to one for input surfaces and one for output surfaces.The
    //!     other surfaces are derived from the input/output surface states.
    //!     
    //!     The Current Frame Input surface uses the Input SURFACE_STATE
    //!     
    //!     The Previous Denoised Input surface uses the Input SURFACE_STATE.  (For
    //!     16-bit Bayer pattern inputs this will be 16-bit.)
    //!     
    //!     The Current Denoised Output surface uses the Input SURFACE_STATE.  (For
    //!     16-bit Bayer pattern inputs this will be 16-bit.)
    //!     
    //!     The STMM/Noise History Input surface uses the Input SURFACE_STATEwith
    //!     Tile-Y and Width/Height a multiple of 4.
    //!     
    //!     The STMM/Noise History Output surface uses the Input SURFACE_STATEwith
    //!     Tile-Y and Width/Height a multiple of 4.
    //!     
    //!     The Current Deinterlaced/IECP Frame Output surface uses the Output
    //!     SURFACE_STATE.
    //!     
    //!     The Previous Deinterlaced/IECP Frame Output surface uses the Output
    //!     SURFACE_STATE.
    //!     
    //!     The FMD per block output / per Frame Output surface uses the Linear
    //!     SURFACE_STATE (see note below).
    //!     
    //!     The Alpha surface uses the Linear A8 SURFACE_STATE with
    //!     Width/Heightequal to Input Surface. Pitch is width rounded to next 64.
    //!     
    //!     The Skin Score surface uses the Output SURFACE_STATE.
    //!     
    //!     The STMM height is the same as the Input Surface height except when the
    //!     inputSurface Format is Bayer Pattern and the Bayer Pattern Offset is 10
    //!     or 11, in which case the height is the input height + 4.  For Bayer
    //!     pattern inputs when the Bayer Pattern Offset is 10 or 11, the
    //!     CurrentDenoised Output/Previous Denoised Input will also have a height
    //!     which is the input height + 4.For Bayer pattern inputs only the Current
    //!     Denoised Output/Previous Denoised Input are in Tile-Y.
    //!     
    //!     The linear surface for FMD statistics is linear (not tiled). The height
    //!     of the per block statisticsis (Input Height +3)/4 - the Input Surface
    //!     height in pixels is rounded up to the next even 4 anddivided by 4. The
    //!     width of the per block section in bytes is equal to the width of the
    //!     Input Surfacein pixels rounded up to the next 16 bytes. The pitch of the
    //!     per block section in bytes is equal tothe width of the Input Surface in
    //!     pixels rounded up to the next 64 bytes.
    //!     
    //!     The STMM surfaces must be identical to the Input surface except for the
    //!     tiling mode mustbe Tile-Y and the pitch is specified in DW7. The pitch
    //!     for the Current Denoised Output/Previous DenoisedInput is specified in
    //!     DW7. The width and height must be a multiple of 4 rounded up from the
    //!     input height.
    //!     
    //!     The Vignette Correction surface uses the Linear 16-bit SURFACE_STATE
    //!     with :  Width=(Ceil(Image Width / 4) +1) * 4  Height= Ceil(Image Height
    //!     / 4) +1  Pitch in bytes is (vignette width *2) rounded to the next 64
    //!     
    //!     VEBOX may write to memory between the surface width and the surface
    //!     pitch for output surfaces.
    //!     
    //!     VEBOX can support a frame level X/Y offset which allows processing of 2
    //!     side-by-side framesfor certain 3D video formats.
    //!     
    //!     The X/Y Offset for Frame state applies only to the Current Frame Input
    //!     and theCurrent Deinterlaced/IECP Frame Output and Previous
    //!     Deinterlaced/IECP Frame Output. The statisticssurfaces, the denoise
    //!     feedback surfaces and the alpha/vignette surfaces have no X/Y offsets.
    //!     
    //!     For 8bit Alpha input, when converted to 16bit output, the 8 bit alpha
    //!     value isreplicated to both the upper and lower 8 bits to form the 16 bit
    //!     alpha value.
    //!     
    //!     Skin Score Output Surface uses the same tiling format as the Output
    //!     surface.
    //!     
    struct VEBOX_SURFACE_STATE_CMD
    {
        union
        {
            struct
            {
                uint32_t                 DwordLength                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< DWORD_LENGTH
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; //!< Reserved
                uint32_t                 SubopcodeB                                       : __CODEGEN_BITFIELD(16, 20)    ; //!< SUBOPCODE_B
                uint32_t                 SubopcodeA                                       : __CODEGEN_BITFIELD(21, 23)    ; //!< SUBOPCODE_A
                uint32_t                 MediaCommandOpcode                               : __CODEGEN_BITFIELD(24, 26)    ; //!< MEDIA_COMMAND_OPCODE
                uint32_t                 MediaCommandPipeline                             : __CODEGEN_BITFIELD(27, 28)    ; //!< MEDIA_COMMAND_PIPELINE
                uint32_t                 CommandType                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< COMMAND_TYPE
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 SurfaceIdentification                            : __CODEGEN_BITFIELD( 0,  0)    ; //!< SURFACE_IDENTIFICATION
                uint32_t                 Reserved33                                       : __CODEGEN_BITFIELD( 1, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 Reserved64                                       : __CODEGEN_BITFIELD( 0,  3)    ; //!< Reserved
                uint32_t                 Width                                            : __CODEGEN_BITFIELD( 4, 17)    ; //!< Width
                uint32_t                 Height                                           : __CODEGEN_BITFIELD(18, 31)    ; //!< Height
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 TileMode                                         : __CODEGEN_BITFIELD( 0,  1)    ; //!< TILE_MODE
                uint32_t                 HalfPitchForChroma                               : __CODEGEN_BITFIELD( 2,  2)    ; //!< Half Pitch for Chroma
                uint32_t                 SurfacePitch                                     : __CODEGEN_BITFIELD( 3, 19)    ; //!< Surface Pitch
                uint32_t                 InterleaveChroma                                 : __CODEGEN_BITFIELD(20, 20)    ; //!< Interleave Chroma
                uint32_t                 Reserved117                                      : __CODEGEN_BITFIELD(21, 21)    ; //!< Reserved
                uint32_t                 BayerInputAlignment                              : __CODEGEN_BITFIELD(22, 23)    ; //!< BAYER_INPUT_ALIGNMENT
                uint32_t                 BayerPatternFormat                               : __CODEGEN_BITFIELD(24, 24)    ; //!< BAYER_PATTERN_FORMAT
                uint32_t                 BayerPatternOffset                               : __CODEGEN_BITFIELD(25, 26)    ; //!< BAYER_PATTERN_OFFSET
                uint32_t                 SurfaceFormat                                    : __CODEGEN_BITFIELD(27, 31)    ; //!< SURFACE_FORMAT
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 YOffsetForU                                      : __CODEGEN_BITFIELD( 0, 14)    ; //!< Y Offset for U
                uint32_t                 Reserved143                                      : __CODEGEN_BITFIELD(15, 15)    ; //!< Reserved
                uint32_t                 XOffsetForU                                      : __CODEGEN_BITFIELD(16, 28)    ; //!< X Offset for U
                uint32_t                 Reserved157                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 YOffsetForV                                      : __CODEGEN_BITFIELD( 0, 14)    ; //!< Y Offset for V
                uint32_t                 Reserved175                                      : __CODEGEN_BITFIELD(15, 15)    ; //!< Reserved
                uint32_t                 XOffsetForV                                      : __CODEGEN_BITFIELD(16, 28)    ; //!< X Offset for V
                uint32_t                 Reserved189                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 YOffsetForFrame                                  : __CODEGEN_BITFIELD( 0, 14)    ; //!< Y Offset for Frame
                uint32_t                 Reserved207                                      : __CODEGEN_BITFIELD(15, 15)    ; //!< Reserved
                uint32_t                 XOffsetForFrame                                  : __CODEGEN_BITFIELD(16, 30)    ; //!< X Offset for Frame
                uint32_t                 Reserved223                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 DerivedSurfacePitch                              : __CODEGEN_BITFIELD( 0, 16)    ; //!< Derived Surface Pitch
                uint32_t                 Reserved241                                      : __CODEGEN_BITFIELD(17, 26)    ; //!< Reserved
                uint32_t                 CompressionFormat                                : __CODEGEN_BITFIELD(27, 30)    ; //!< COMPRESSION_FORMAT
                uint32_t                 Reserved255                                      : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 SurfacePitchForSkinScoreOutputSurfaces           : __CODEGEN_BITFIELD( 0, 16)    ; //!< Surface Pitch for Skin Score Output Surfaces
                uint32_t                 Reserved273                                      : __CODEGEN_BITFIELD(17, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW8;

        //! \name Local enumerations

        enum SUBOPCODE_B
        {
            SUBOPCODE_B_VEBOX                                                = 0, //!< No additional details
        };

        enum SUBOPCODE_A
        {
            SUBOPCODE_A_VEBOX                                                = 0, //!< No additional details
        };

        enum MEDIA_COMMAND_OPCODE
        {
            MEDIA_COMMAND_OPCODE_VEBOX                                       = 4, //!< No additional details
        };

        enum MEDIA_COMMAND_PIPELINE
        {
            MEDIA_COMMAND_PIPELINE_MEDIA                                     = 2, //!< No additional details
        };

        enum COMMAND_TYPE
        {
            COMMAND_TYPE_PARALLELVIDEOPIPE                                   = 3, //!< No additional details
        };

        //! \brief SURFACE_IDENTIFICATION
        //! \details
        //!     Specifies which set of surfaces this command refers to:
        enum SURFACE_IDENTIFICATION
        {
            SURFACE_IDENTIFICATION_INPUTSURFACEANDDENOISEDCURRENTOUTPUTSURFACE = 0, //!< No additional details
            SURFACE_IDENTIFICATION_OUTPUTSURFACE_ALLEXCEPTTHEDENOISEDCURRENTOUTPUTSURFACE = 1, //!< No additional details
        };

        //! \brief TILE_MODE
        //! \details
        //!     Indicates the Tile Mode for the Surface.
        enum TILE_MODE
        {
            TILE_MODE_LINEAR                                                 = 0, //!< No additional details
            TILE_MODE_TILES_64K                                              = 1, //!< No additional details
            TILE_MODE_XMAJOR                                                 = 2, //!< No additional details
            TILE_MODE_TILEF                                                  = 3, //!< No additional details
        };

        //! \brief BAYER_INPUT_ALIGNMENT
        //! \details
        //!     style="margin-left:3.0pt;">Valid only Bayer Pattern Format is 16bit
        //!     input
        enum BAYER_INPUT_ALIGNMENT
        {
            BAYER_INPUT_ALIGNMENT_MSBALIGNEDDATA                             = 0, //!< No additional details
            BAYER_INPUT_ALIGNMENT_10BITLSBALIGNEDDATA                        = 1, //!< No additional details
            BAYER_INPUT_ALIGNMENT_12BITLSBALIGNEDDATA                        = 2, //!< No additional details
            BAYER_INPUT_ALIGNMENT_14BITLSBALIGNEDDATA                        = 3, //!< No additional details
        };

        //! \brief BAYER_PATTERN_FORMAT
        //! \details
        //!     Specifies the format of the Bayer Pattern:
        enum BAYER_PATTERN_FORMAT
        {
            BAYER_PATTERN_FORMAT_8_BITINPUTATA8_BITSTRIDE                    = 0, //!< No additional details
            BAYER_PATTERN_FORMAT_16_BITINPUTATA16_BITSTRIDE                  = 1, //!< No additional details
        };

        //! \brief BAYER_PATTERN_OFFSET
        //! \details
        //!     Specifies the starting pixel offset for the Bayer pattern used for
        //!     Capture Pipe.
        enum BAYER_PATTERN_OFFSET
        {
            BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISBLUE                          = 0, //!< No additional details
            BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISRED                           = 1, //!< No additional details
            BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISGREEN_PIXELATX1_Y0ISRED       = 2, //!< No additional details
            BAYER_PATTERN_OFFSET_PIXELATX0_Y0ISGREEN_PIXELATX1_Y0ISBLUE      = 3, //!< No additional details
        };

        //! \brief SURFACE_FORMAT
        //! \details
        //!     Specifies the format of the surface.  All of the Y and G channels will
        //!     use table 0 and all of the Cr/Cb/R/B channels will use table 1.
        enum SURFACE_FORMAT
        {
            SURFACE_FORMAT_YCRCBNORMAL                                       = 0, //!< No additional details
            SURFACE_FORMAT_YCRCBSWAPUVY                                      = 1, //!< No additional details
            SURFACE_FORMAT_YCRCBSWAPUV                                       = 2, //!< No additional details
            SURFACE_FORMAT_YCRCBSWAPY                                        = 3, //!< No additional details
            SURFACE_FORMAT_PLANAR4208                                        = 4, //!< NV12 with Interleave Chroma set
            SURFACE_FORMAT_PACKED444A8                                       = 5, //!< No additional details
            SURFACE_FORMAT_PACKED42216                                       = 6, //!< No additional details
            SURFACE_FORMAT_R10G10B10A2UNORMR10G10B10A2UNORMSRGB              = 7, //!< Restriction : Valid format only for when IECP is enabled and in output state only. Not supported in HSB mode.
            SURFACE_FORMAT_R8G8B8A8UNORMR8G8B8A8UNORMSRGB                    = 8, //!< No additional details
            SURFACE_FORMAT_PACKED44416                                       = 9, //!< No additional details
            SURFACE_FORMAT_PLANAR42216                                       = 10, //!< No additional details
            SURFACE_FORMAT_Y8UNORM                                           = 11, //!< No additional details
            SURFACE_FORMAT_PLANAR42016                                       = 12, //!< No additional details
            SURFACE_FORMAT_R16G16B16A16                                      = 13, //!< No additional details
            SURFACE_FORMAT_BAYERPATTERN                                      = 14, //!< No additional details
            SURFACE_FORMAT_Y16UNORM                                          = 15, //!< No additional details
            SURFACE_FORMAT_PACKED44410                                       = 16, //!< No additional details
            SURFACE_FORMAT_B8G8R8A8UNORM                                     = 17, //!< No additional details
        };

        //! \brief COMPRESSION_FORMAT
        //! \details
        //!     Specifies the 5 bit compression format
        enum
        {
            COMPRESSION_FORMAT_CMFR8                                         = 0, //!< Single 8bit channel format
            COMPRESSION_FORMAT_CMFR8G8                                       = 1, //!< Two 8bit channel format
            COMPRESSION_FORMAT_CMFR8G8B8A8                                   = 2, //!< Four 8bit channel format
            COMPRESSION_FORMAT_CMFR10G10B10A2                                = 3, //!< Three 10bit channels and One 2bit channel
            COMPRESSION_FORMAT_CMFR11G11B10                                  = 4, //!< Two 11bit channels and One 10bit channel
            COMPRESSION_FORMAT_CMFR16                                        = 5, //!< Single 16bit channel format
            COMPRESSION_FORMAT_CMFR16G16                                     = 6, //!< Two 16bit channel format
            COMPRESSION_FORMAT_CMFR16G16B16A16                               = 7, //!< Four 16bit channels
            COMPRESSION_FORMAT_CMFR32                                        = 8, //!< Single 32bit channel
            COMPRESSION_FORMAT_CMFR32G32                                     = 9, //!< Two 32bit channels
            COMPRESSION_FORMAT_CMFR32G32B32A32                               = 10, //!< Four 32bit channels
            COMPRESSION_FORMAT_CMFY16U16Y16V16                               = 11, //!< Packed YUV 16/12/10 bit per channel
            COMPRESSION_FORMAT_CMFML8                                        = 15, //!< Machine Learning format / Generic data
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_SURFACE_STATE_CMD();

        static const size_t dwSize = 9;
        static const size_t byteSize = 36;
    };

    //!
    //! \brief VEBOX_TILING_CONVERT
    //! \details
    //!     This command takes the input surface and writes directly to the output
    //!     surface at high speed.  The surface format and width/height of the input
    //!     and output must be the same, only the tiling mode and pitch can change.
    //!     
    struct VEBOX_TILING_CONVERT_CMD
    {
        union
        {
            struct
            {
                uint32_t                 DwordLength                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< DWORD_LENGTH
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; //!< Reserved
                uint32_t                 SubopcodeB                                       : __CODEGEN_BITFIELD(16, 20)    ; //!< SUBOPCODE_B
                uint32_t                 SubopcodeA                                       : __CODEGEN_BITFIELD(21, 23)    ; //!< SUBOPCODE_A
                uint32_t                 CommandOpcode                                    : __CODEGEN_BITFIELD(24, 26)    ; //!< COMMAND_OPCODE
                uint32_t                 Pipeline                                         : __CODEGEN_BITFIELD(27, 28)    ; //!< PIPELINE
                uint32_t                 CommandType                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< COMMAND_TYPE
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint64_t                 InputSurfaceControlBits                          : __CODEGEN_BITFIELD( 0, 10)    ; //!< Input Surface Control Bits
                uint64_t                 Reserved43                                       : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint64_t                 InputAddress                                     : __CODEGEN_BITFIELD(12, 63)    ; //!< Input Address
            };
            uint32_t                     Value[2];
        } DW1_2;
        union
        {
            struct
            {
                uint64_t                 OutputSurfaceControlBits                         : __CODEGEN_BITFIELD( 0, 10)    ; //!< Output Surface Control Bits
                uint64_t                 Reserved107                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint64_t                 OutputAddress                                    : __CODEGEN_BITFIELD(12, 63)    ; //!< Output Address
            };
            uint32_t                     Value[2];
        } DW3_4;

        //! \name Local enumerations

        enum SUBOPCODE_B
        {
            SUBOPCODE_B_UNNAMED1                                             = 1, //!< No additional details
        };

        enum SUBOPCODE_A
        {
            SUBOPCODE_A_UNNAMED0                                             = 0, //!< No additional details
        };

        enum COMMAND_OPCODE
        {
            COMMAND_OPCODE_VEBOX                                             = 4, //!< No additional details
        };

        enum PIPELINE
        {
            PIPELINE_MEDIA                                                   = 2, //!< No additional details
        };

        enum COMMAND_TYPE
        {
            COMMAND_TYPE_PARALLELVIDEOPIPE                                   = 3, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_TILING_CONVERT_CMD();

        static const size_t dwSize = 5;
        static const size_t byteSize = 20;
    };

    //!
    //! \brief VEBOX_VERTEX_TABLE_ENTRY
    //! \details
    //!     
    //!     
    struct VEBOX_VERTEX_TABLE_ENTRY_CMD
    {
        union
        {
            struct
            {
                uint32_t                 VertexTableEntry0Cv12Bits                        : __CODEGEN_BITFIELD( 0, 11)    ; //!< Vertex table entry 0 - Cv (12 bits)
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; //!< Reserved
                uint32_t                 VertexTableEntry0Lv12Bits                        : __CODEGEN_BITFIELD(16, 27)    ; //!< Vertex table entry 0 - Lv (12 bits)
                uint32_t                 Reserved28                                       : __CODEGEN_BITFIELD(28, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW0;

        //! \name Local enumerations

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_VERTEX_TABLE_ENTRY_CMD();

        static const size_t dwSize = 1;
        static const size_t byteSize = 4;
    };

    //!
    //! \brief VEBOX_VERTEX_TABLE
    //! \details
    //!     
    //!     
    struct VEBOX_VERTEX_TABLE_CMD
    {
        VEBOX_VERTEX_TABLE_ENTRY_CMD             Vertextableentry[512];                                                   //!< DW0..511, VertexTableEntry

        //! \name Local enumerations

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEBOX_VERTEX_TABLE_CMD();

        static const size_t dwSize = 512;
        static const size_t byteSize = 2048;
    };

    //!
    //! \brief VEB_DI_IECP
    //! \details
    //!     The VEB_DI_IECP command causes the VEBOX to start processing the frames
    //!     specified by VEB_SURFACE_STATE using the parameters specified by
    //!     VEB_DI_STATE and VEB_IECP_STATE.  The processing can start and end at
    //!     any 64 pixel column in the frame. If Starting X and Ending X are used to
    //!     split the frame into sections, it should not be split into more than 4
    //!     sections.Each VEB_DI_IECP command should be preceded by a VEB_STATE
    //!     command and the input/output VEB_SURFACE_STATE commands.
    //!     
    //!     When DI is enabled, only the Current Frame skin scores are outputted to
    //!     the Skin Score Output surface.
    //!     
    struct VEB_DI_IECP_CMD
    {
        union
        {
            struct
            {
                uint32_t                 DwordLength                                      : __CODEGEN_BITFIELD( 0, 11)    ; //!< DWORD_LENGTH
                uint32_t                 Reserved12                                       : __CODEGEN_BITFIELD(12, 15)    ; //!< Reserved
                uint32_t                 Subopb                                           : __CODEGEN_BITFIELD(16, 20)    ; //!< SUBOPB
                uint32_t                 Subopa                                           : __CODEGEN_BITFIELD(21, 23)    ; //!< SUBOPA
                uint32_t                 Opcode                                           : __CODEGEN_BITFIELD(24, 26)    ; //!< OPCODE
                uint32_t                 Pipeline                                         : __CODEGEN_BITFIELD(27, 28)    ; //!< PIPELINE
                uint32_t                 CommandType                                      : __CODEGEN_BITFIELD(29, 31)    ; //!< COMMAND_TYPE
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 EndingX                                          : __CODEGEN_BITFIELD( 0, 13)    ; //!< Ending X
                uint32_t                 Reserved46                                       : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 StartingX                                        : __CODEGEN_BITFIELD(16, 29)    ; //!< Starting X
                uint32_t                 SplitWorkloadEnable                              : __CODEGEN_BITFIELD(30, 30)    ; //!< SPLIT_WORKLOAD_ENABLE
                uint32_t                 Reserved63                                       : __CODEGEN_BITFIELD(31, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 CurrentFrameSurfaceControlBitsReserved0          : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved71                                       : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved75                                       : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 CurrentFrameInputAddress                         : __CODEGEN_BITFIELD(12, 31)    ; //!< Current Frame Input Address
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 CurrentFrameInputAddressHigh                     : __CODEGEN_BITFIELD( 0, 15)    ; //!< Current Frame Input Address High
                uint32_t                 Reserved112                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 CurrentFrameInputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 PreviousFrameSurfaceControlBitsReserved0         : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved135                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved139                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 PreviousFrameInputAddress                        : __CODEGEN_BITFIELD(12, 31)    ; //!< Previous Frame Input Address
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 PreviousFrameInputAddressHigh                    : __CODEGEN_BITFIELD( 0, 15)    ; //!< Previous Frame Input Address High
                uint32_t                 Reserved176                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 PreviousFrameInputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 StmmInputSurfaceControlBitsReserved0             : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved199                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved203                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 StmmInputAddress                                 : __CODEGEN_BITFIELD(12, 31)    ; //!< STMM Input Address
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 StmmInputAddressHigh                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< STMM Input Address High
                uint32_t                 Reserved240                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 StmmInputSurfaceArbitrationPriorityControl       : __CODEGEN_BITFIELD(30, 31)    ; //!< STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 StmmOutputSurfaceControlBitsReserved0            : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved263                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved267                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 StmmOutputAddress                                : __CODEGEN_BITFIELD(12, 31)    ; //!< STMM Output Address
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 StmmOutputAddressHigh                            : __CODEGEN_BITFIELD( 0, 15)    ; //!< STMM Output Address High
                uint32_t                 Reserved304                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 StmmOutputSurfaceArbitrationPriorityControl      : __CODEGEN_BITFIELD(30, 31)    ; //!< STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 DenoisedCurrentOutputSurfaceControlBitsReserved0 : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved327                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved331                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 DenoisedCurrentFrameOutputAddress                : __CODEGEN_BITFIELD(12, 31)    ; //!< Denoised Current Frame Output Address
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 DenoisedCurrentFrameOutputAddressHigh            : __CODEGEN_BITFIELD( 0, 15)    ; //!< Denoised Current Frame Output Address High
                uint32_t                 Reserved368                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 DenoisedCurrentOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                uint32_t                 CurrentFrameOutputSurfaceControlBitsReserved0    : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved391                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved395                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 CurrentFrameOutputAddress                        : __CODEGEN_BITFIELD(12, 31)    ; //!< Current Frame Output Address
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                uint32_t                 CurrentFrameOutputAddressHigh                    : __CODEGEN_BITFIELD( 0, 15)    ; //!< Current Frame Output Address High
                uint32_t                 Reserved432                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 CurrentFrameOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                uint32_t                 PreviousFrameOutputSurfaceControlBitsReserved0   : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved455                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved459                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 PreviousFrameOutputAddress                       : __CODEGEN_BITFIELD(12, 31)    ; //!< Previous Frame Output Address
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                uint32_t                 PreviousFrameOutputAddressHigh                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< Previous Frame Output Address High
                uint32_t                 Reserved496                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 PreviousFrameOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                uint32_t                 StatisticsOutputSurfaceControlBitsReserved0      : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved519                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved523                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 StatisticsOutputAddress                          : __CODEGEN_BITFIELD(12, 31)    ; //!< Statistics Output Address
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                uint32_t                 StatisticsOutputAddressHigh                      : __CODEGEN_BITFIELD( 0, 15)    ; //!< Statistics Output Address High
                uint32_t                 Reserved560                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 StatisticsOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                uint32_t                 AlphaVignetteControlBitsReserved0                : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved583                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved587                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 AlphaVignetteCorrectionAddress                   : __CODEGEN_BITFIELD(12, 31)    ; //!< Alpha/Vignette Correction Address
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                uint32_t                 AlphaVignetteCorrectionAddressHigh               : __CODEGEN_BITFIELD( 0, 15)    ; //!< Alpha/Vignette Correction Address High
                uint32_t                 Reserved624                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 AlphaVignetteCorrectionSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                uint32_t                 LaceAceRgbHistogramControlBitsReserved0          : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved647                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved651                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 LaceAceRgbHistogramOutputAddress                 : __CODEGEN_BITFIELD(12, 31)    ; //!< LACE/ACE/RGB Histogram Output Address
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                uint32_t                 LaceAceRgbHistogramOutputAddressHigh             : __CODEGEN_BITFIELD( 0, 15)    ; //!< LACE/ACE/RGB Histogram Output Address High
                uint32_t                 Reserved688                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 LaceAceRgbHistogramSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                uint32_t                 SkinScoreOutputControlBitsReserved0              : __CODEGEN_BITFIELD( 0,  0)    ; //!< Sub-structure
                uint32_t                 IndexToMemoryObjectControlStateMocsTables        : __CODEGEN_BITFIELD( 1,  6)    ; //!< Index to Memory Object Control State (MOCS) Tables
                uint32_t                 Reserved711                                      : __CODEGEN_BITFIELD( 7,  8)    ; //!< Reserved
                uint32_t                 TiledResourceModeForOutputFrameSurfaceBaseAddress : __CODEGEN_BITFIELD( 9, 10)    ; //!< TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
                uint32_t                 Reserved715                                      : __CODEGEN_BITFIELD(11, 11)    ; //!< Reserved
                uint32_t                 SkinScoreOutputAddress                           : __CODEGEN_BITFIELD(12, 31)    ; //!< Skin Score Output Address
            };
            uint32_t                     Value;
        } DW22;
        union
        {
            struct
            {
                uint32_t                 SkinScoreOutputAddressHigh                       : __CODEGEN_BITFIELD( 0, 15)    ; //!< Skin Score Output Address High
                uint32_t                 Reserved752                                      : __CODEGEN_BITFIELD(16, 29)    ; //!< Reserved
                uint32_t                 SkinScoreOutputSurfaceArbitrationPriorityControl : __CODEGEN_BITFIELD(30, 31)    ; //!< SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
            };
            uint32_t                     Value;
        } DW23;
        union
        {
            struct
            {
                uint32_t                 OutputEndingX                                    : __CODEGEN_BITFIELD( 0, 13)    ; //!< Output Ending X
                uint32_t                 Reserved782                                      : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 OutputStartingX                                  : __CODEGEN_BITFIELD(16, 29)    ; //!< Output Starting X
                uint32_t                 Reserved798                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW24;
        union
        {
            struct
            {
                uint32_t                 ChickenBitForDisablingLumaOverfetchOptimization  : __CODEGEN_BITFIELD( 0,  0)    ; //!< Chicken bit for disabling luma overfetch optimization
                uint32_t                 Reserved1                                        : __CODEGEN_BITFIELD(1, 1);
                uint32_t                 Reserved2                                        : __CODEGEN_BITFIELD(2, 2);
                uint32_t                 ChickenBitForDisablingDnPerformanceFixInVcwVdnForMtl : __CODEGEN_BITFIELD( 3,  3)    ; //!< Chicken bit for disabling DN performance fix in VCW/VDN for MTL
                uint32_t                 ChickenBitForDisablingTile64FixForDg2StmmOutputAndDenoisedOutputInBayerFormat : __CODEGEN_BITFIELD( 4,  4)    ; //!< Chicken bit for disabling tile64 fix for DG2 STMM output and Denoised output in bayer format
                uint32_t                 Reserved805                                      : __CODEGEN_BITFIELD( 5, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW25;
        union
        {
            struct
            {
                uint32_t                 EndingY                                          : __CODEGEN_BITFIELD( 0, 13)    ; //!< Ending Y
                uint32_t                 Reserved846                                      : __CODEGEN_BITFIELD(14, 15)    ; //!< Reserved
                uint32_t                 StartingY                                        : __CODEGEN_BITFIELD(16, 29)    ; //!< Starting Y
                uint32_t                 Reserved862                                      : __CODEGEN_BITFIELD(30, 31)    ; //!< Reserved
            };
            uint32_t                     Value;
        } DW26;

        //! \name Local enumerations

        enum SUBOPB
        {
            SUBOPB_VEBDIIECP                                                 = 3, //!< No additional details
        };

        enum SUBOPA
        {
            SUBOPA_VEBDIIECP                                                 = 0, //!< No additional details
        };

        enum OPCODE
        {
            OPCODE_VEBOX                                                     = 4, //!< No additional details
        };

        enum PIPELINE
        {
            PIPELINE_MEDIA                                                   = 2, //!< No additional details
        };

        enum COMMAND_TYPE
        {
            COMMAND_TYPE_PARALLELVIDEOPIPE                                   = 3, //!< No additional details
        };

        //! \brief SPLIT_WORKLOAD_ENABLE
        //! \details
        //!     When this bit is enabled, VEBOX output is based on "Output Starting X"
        //!     and "Output Ending X" in DWORD: 24 to support split workload. DWORD 24
        //!     is ignored when this bit is not set.
        enum SPLIT_WORKLOAD_ENABLE
        {
            SPLIT_WORKLOAD_ENABLE_UNNAMED0                                   = 0, //!< No additional details
        };

        //! \brief TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
        //! \details
        //!     For Media Surfaces:This field specifies the
        //!     tiled resource mode.
        enum TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS
        {
            TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS_TRMODENONE = 0, //!< No tiled resource
            TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS_TRMODETILEYF = 1, //!< 4KB tiled resources
            TILED_RESOURCE_MODE_FOR_OUTPUT_FRAME_SURFACE_BASE_ADDRESS_TRMODETILEYS = 2, //!< 64KB tiled resources
        };

        //! \brief CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            CURRENT_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \brief PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            PREVIOUS_FRAME_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \brief STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY  = 0, //!< No additional details
            STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            STMM_INPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY   = 3, //!< No additional details
        };

        //! \brief STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            STMM_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY  = 3, //!< No additional details
        };

        //! \brief DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            DENOISED_CURRENT_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \brief CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            CURRENT_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \brief PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            PREVIOUS_FRAME_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \brief STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            STATISTICS_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \brief ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            ALPHAVIGNETTE_CORRECTION_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \brief LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            LACEACERGB_HISTOGRAM_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \brief SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        //! \details
        //!     This field controls the priority of arbitration used in the GAC/GAM
        //!     pipeline for this surface.
        enum SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL
        {
            SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_HIGHESTPRIORITY = 0, //!< No additional details
            SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_SECONDHIGHESTPRIORITY = 1, //!< No additional details
            SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_THIRDHIGHESTPRIORITY = 2, //!< No additional details
            SKIN_SCORE_OUTPUT_SURFACE_ARBITRATION_PRIORITY_CONTROL_LOWESTPRIORITY = 3, //!< No additional details
        };

        //! \name Initializations

        //! \brief Explicit member initialization function
        VEB_DI_IECP_CMD();

        static const size_t dwSize = 27;
        static const size_t byteSize = 108;
    };

    //!
    //! \brief Gamut_Expansion_Gamma_Correction
    //! \details
    //!     The default values follow the pattern suggested by incomplete table
    //!     below.
    //!     
    struct Gamut_Expansion_Gamma_Correction_CMD
    {
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue0                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_0
                uint32_t                 InverseBChGammaCorrectedValue0                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_0
            };
            uint32_t                     Value;
        } DW0;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue0                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_0
                uint32_t                 InverseRChGammaCorrectedValue0                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_0
            };
            uint32_t                     Value;
        } DW1;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue0                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_0
                uint32_t                 ForwardBChGammaCorrectedValue0                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_0
            };
            uint32_t                     Value;
        } DW2;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue0                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_0
                uint32_t                 ForwardRChGammaCorrectedValue0                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_0
            };
            uint32_t                     Value;
        } DW3;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue1                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_1
                uint32_t                 InverseBChGammaCorrectedValue1                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_1
            };
            uint32_t                     Value;
        } DW4;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue1                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_1
                uint32_t                 InverseRChGammaCorrectedValue1                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_1
            };
            uint32_t                     Value;
        } DW5;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue1                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_1
                uint32_t                 ForwardBChGammaCorrectedValue1                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_1
            };
            uint32_t                     Value;
        } DW6;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue1                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_1
                uint32_t                 ForwardRChGammaCorrectedValue1                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_1
            };
            uint32_t                     Value;
        } DW7;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue2                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_2
                uint32_t                 InverseBChGammaCorrectedValue2                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_2
            };
            uint32_t                     Value;
        } DW8;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue2                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_2
                uint32_t                 InverseRChGammaCorrectedValue2                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_2
            };
            uint32_t                     Value;
        } DW9;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue2                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_2
                uint32_t                 ForwardBChGammaCorrectedValue2                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_2
            };
            uint32_t                     Value;
        } DW10;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue2                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_2
                uint32_t                 ForwardRChGammaCorrectedValue2                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_2
            };
            uint32_t                     Value;
        } DW11;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue3                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_3
                uint32_t                 InverseBChGammaCorrectedValue3                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_3
            };
            uint32_t                     Value;
        } DW12;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue3                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_3
                uint32_t                 InverseRChGammaCorrectedValue3                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_3
            };
            uint32_t                     Value;
        } DW13;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue3                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_3
                uint32_t                 ForwardBChGammaCorrectedValue3                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_3
            };
            uint32_t                     Value;
        } DW14;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue3                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_3
                uint32_t                 ForwardRChGammaCorrectedValue3                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_3
            };
            uint32_t                     Value;
        } DW15;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue4                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_4
                uint32_t                 InverseBChGammaCorrectedValue4                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_4
            };
            uint32_t                     Value;
        } DW16;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue4                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_4
                uint32_t                 InverseRChGammaCorrectedValue4                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_4
            };
            uint32_t                     Value;
        } DW17;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue4                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_4
                uint32_t                 ForwardBChGammaCorrectedValue4                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_4
            };
            uint32_t                     Value;
        } DW18;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue4                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_4
                uint32_t                 ForwardRChGammaCorrectedValue4                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_4
            };
            uint32_t                     Value;
        } DW19;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue5                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_5
                uint32_t                 InverseBChGammaCorrectedValue5                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_5
            };
            uint32_t                     Value;
        } DW20;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue5                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_5
                uint32_t                 InverseRChGammaCorrectedValue5                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_5
            };
            uint32_t                     Value;
        } DW21;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue5                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_5
                uint32_t                 ForwardBChGammaCorrectedValue5                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_5
            };
            uint32_t                     Value;
        } DW22;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue5                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_5
                uint32_t                 ForwardRChGammaCorrectedValue5                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_5
            };
            uint32_t                     Value;
        } DW23;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue6                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_6
                uint32_t                 InverseBChGammaCorrectedValue6                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_6
            };
            uint32_t                     Value;
        } DW24;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue6                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_6
                uint32_t                 InverseRChGammaCorrectedValue6                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_6
            };
            uint32_t                     Value;
        } DW25;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue6                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_6
                uint32_t                 ForwardBChGammaCorrectedValue6                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_6
            };
            uint32_t                     Value;
        } DW26;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue6                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_6
                uint32_t                 ForwardRChGammaCorrectedValue6                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_6
            };
            uint32_t                     Value;
        } DW27;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue7                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_7
                uint32_t                 InverseBChGammaCorrectedValue7                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_7
            };
            uint32_t                     Value;
        } DW28;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue7                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_7
                uint32_t                 InverseRChGammaCorrectedValue7                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_7
            };
            uint32_t                     Value;
        } DW29;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue7                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_7
                uint32_t                 ForwardBChGammaCorrectedValue7                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_7
            };
            uint32_t                     Value;
        } DW30;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue7                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_7
                uint32_t                 ForwardRChGammaCorrectedValue7                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_7
            };
            uint32_t                     Value;
        } DW31;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue8                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_8
                uint32_t                 InverseBChGammaCorrectedValue8                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_8
            };
            uint32_t                     Value;
        } DW32;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue8                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_8
                uint32_t                 InverseRChGammaCorrectedValue8                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_8
            };
            uint32_t                     Value;
        } DW33;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue8                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_8
                uint32_t                 ForwardBChGammaCorrectedValue8                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_8
            };
            uint32_t                     Value;
        } DW34;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue8                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_8
                uint32_t                 ForwardRChGammaCorrectedValue8                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_8
            };
            uint32_t                     Value;
        } DW35;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue9                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_9
                uint32_t                 InverseBChGammaCorrectedValue9                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_9
            };
            uint32_t                     Value;
        } DW36;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue9                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_9
                uint32_t                 InverseRChGammaCorrectedValue9                   : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_9
            };
            uint32_t                     Value;
        } DW37;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue9                   : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_9
                uint32_t                 ForwardBChGammaCorrectedValue9                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_9
            };
            uint32_t                     Value;
        } DW38;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue9                               : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_9
                uint32_t                 ForwardRChGammaCorrectedValue9                   : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_9
            };
            uint32_t                     Value;
        } DW39;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue10                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_10
                uint32_t                 InverseBChGammaCorrectedValue10                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_10
            };
            uint32_t                     Value;
        } DW40;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue10                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_10
                uint32_t                 InverseRChGammaCorrectedValue10                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_10
            };
            uint32_t                     Value;
        } DW41;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue10                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_10
                uint32_t                 ForwardBChGammaCorrectedValue10                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_10
            };
            uint32_t                     Value;
        } DW42;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue10                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_10
                uint32_t                 ForwardRChGammaCorrectedValue10                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_10
            };
            uint32_t                     Value;
        } DW43;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue11                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_11
                uint32_t                 InverseBChGammaCorrectedValue11                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_11
            };
            uint32_t                     Value;
        } DW44;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue11                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_11
                uint32_t                 InverseRChGammaCorrectedValue11                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_11
            };
            uint32_t                     Value;
        } DW45;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue11                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_11
                uint32_t                 ForwardBChGammaCorrectedValue11                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_11
            };
            uint32_t                     Value;
        } DW46;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue11                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_11
                uint32_t                 ForwardRChGammaCorrectedValue11                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_11
            };
            uint32_t                     Value;
        } DW47;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue12                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_12
                uint32_t                 InverseBChGammaCorrectedValue12                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_12
            };
            uint32_t                     Value;
        } DW48;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue12                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_12
                uint32_t                 InverseRChGammaCorrectedValue12                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_12
            };
            uint32_t                     Value;
        } DW49;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue12                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_12
                uint32_t                 ForwardBChGammaCorrectedValue12                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_12
            };
            uint32_t                     Value;
        } DW50;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue12                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_12
                uint32_t                 ForwardRChGammaCorrectedValue12                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_12
            };
            uint32_t                     Value;
        } DW51;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue13                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_13
                uint32_t                 InverseBChGammaCorrectedValue13                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_13
            };
            uint32_t                     Value;
        } DW52;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue13                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_13
                uint32_t                 InverseRChGammaCorrectedValue13                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_13
            };
            uint32_t                     Value;
        } DW53;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue13                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_13
                uint32_t                 ForwardBChGammaCorrectedValue13                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_13
            };
            uint32_t                     Value;
        } DW54;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue13                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_13
                uint32_t                 ForwardRChGammaCorrectedValue13                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_13
            };
            uint32_t                     Value;
        } DW55;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue14                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_14
                uint32_t                 InverseBChGammaCorrectedValue14                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_14
            };
            uint32_t                     Value;
        } DW56;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue14                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_14
                uint32_t                 InverseRChGammaCorrectedValue14                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_14
            };
            uint32_t                     Value;
        } DW57;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue14                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_14
                uint32_t                 ForwardBChGammaCorrectedValue14                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_14
            };
            uint32_t                     Value;
        } DW58;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue14                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_14
                uint32_t                 ForwardRChGammaCorrectedValue14                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_14
            };
            uint32_t                     Value;
        } DW59;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue15                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_15
                uint32_t                 InverseBChGammaCorrectedValue15                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_15
            };
            uint32_t                     Value;
        } DW60;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue15                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_15
                uint32_t                 InverseRChGammaCorrectedValue15                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_15
            };
            uint32_t                     Value;
        } DW61;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue15                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_15
                uint32_t                 ForwardBChGammaCorrectedValue15                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_15
            };
            uint32_t                     Value;
        } DW62;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue15                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_15
                uint32_t                 ForwardRChGammaCorrectedValue15                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_15
            };
            uint32_t                     Value;
        } DW63;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue16                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_16
                uint32_t                 InverseBChGammaCorrectedValue16                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_16
            };
            uint32_t                     Value;
        } DW64;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue16                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_16
                uint32_t                 InverseRChGammaCorrectedValue16                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_16
            };
            uint32_t                     Value;
        } DW65;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue16                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_16
                uint32_t                 ForwardBChGammaCorrectedValue16                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_16
            };
            uint32_t                     Value;
        } DW66;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue16                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_16
                uint32_t                 ForwardRChGammaCorrectedValue16                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_16
            };
            uint32_t                     Value;
        } DW67;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue17                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_17
                uint32_t                 InverseBChGammaCorrectedValue17                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_17
            };
            uint32_t                     Value;
        } DW68;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue17                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_17
                uint32_t                 InverseRChGammaCorrectedValue17                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_17
            };
            uint32_t                     Value;
        } DW69;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue17                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_17
                uint32_t                 ForwardBChGammaCorrectedValue17                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_17
            };
            uint32_t                     Value;
        } DW70;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue17                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_17
                uint32_t                 ForwardRChGammaCorrectedValue17                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_17
            };
            uint32_t                     Value;
        } DW71;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue18                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_18
                uint32_t                 InverseBChGammaCorrectedValue18                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_18
            };
            uint32_t                     Value;
        } DW72;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue18                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_18
                uint32_t                 InverseRChGammaCorrectedValue18                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_18
            };
            uint32_t                     Value;
        } DW73;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue18                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_18
                uint32_t                 ForwardBChGammaCorrectedValue18                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_18
            };
            uint32_t                     Value;
        } DW74;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue18                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_18
                uint32_t                 ForwardRChGammaCorrectedValue18                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_18
            };
            uint32_t                     Value;
        } DW75;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue19                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_19
                uint32_t                 InverseBChGammaCorrectedValue19                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_19
            };
            uint32_t                     Value;
        } DW76;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue19                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_19
                uint32_t                 InverseRChGammaCorrectedValue19                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_19
            };
            uint32_t                     Value;
        } DW77;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue19                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_19
                uint32_t                 ForwardBChGammaCorrectedValue19                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_19
            };
            uint32_t                     Value;
        } DW78;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue19                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_19
                uint32_t                 ForwardRChGammaCorrectedValue19                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_19
            };
            uint32_t                     Value;
        } DW79;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue20                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_20
                uint32_t                 InverseBChGammaCorrectedValue20                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_20
            };
            uint32_t                     Value;
        } DW80;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue20                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_20
                uint32_t                 InverseRChGammaCorrectedValue20                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_20
            };
            uint32_t                     Value;
        } DW81;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue20                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_20
                uint32_t                 ForwardBChGammaCorrectedValue20                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_20
            };
            uint32_t                     Value;
        } DW82;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue20                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_20
                uint32_t                 ForwardRChGammaCorrectedValue20                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_20
            };
            uint32_t                     Value;
        } DW83;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue21                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_21
                uint32_t                 InverseBChGammaCorrectedValue21                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_21
            };
            uint32_t                     Value;
        } DW84;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue21                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_21
                uint32_t                 InverseRChGammaCorrectedValue21                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_21
            };
            uint32_t                     Value;
        } DW85;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue21                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_21
                uint32_t                 ForwardBChGammaCorrectedValue21                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_21
            };
            uint32_t                     Value;
        } DW86;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue21                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_21
                uint32_t                 ForwardRChGammaCorrectedValue21                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_21
            };
            uint32_t                     Value;
        } DW87;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue22                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_22
                uint32_t                 InverseBChGammaCorrectedValue22                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_22
            };
            uint32_t                     Value;
        } DW88;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue22                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_22
                uint32_t                 InverseRChGammaCorrectedValue22                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_22
            };
            uint32_t                     Value;
        } DW89;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue22                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_22
                uint32_t                 ForwardBChGammaCorrectedValue22                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_22
            };
            uint32_t                     Value;
        } DW90;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue22                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_22
                uint32_t                 ForwardRChGammaCorrectedValue22                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_22
            };
            uint32_t                     Value;
        } DW91;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue23                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_23
                uint32_t                 InverseBChGammaCorrectedValue23                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_23
            };
            uint32_t                     Value;
        } DW92;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue23                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_23
                uint32_t                 InverseRChGammaCorrectedValue23                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_23
            };
            uint32_t                     Value;
        } DW93;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue23                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_23
                uint32_t                 ForwardBChGammaCorrectedValue23                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_23
            };
            uint32_t                     Value;
        } DW94;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue23                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_23
                uint32_t                 ForwardRChGammaCorrectedValue23                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_23
            };
            uint32_t                     Value;
        } DW95;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue24                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_24
                uint32_t                 InverseBChGammaCorrectedValue24                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_24
            };
            uint32_t                     Value;
        } DW96;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue24                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_24
                uint32_t                 InverseRChGammaCorrectedValue24                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_24
            };
            uint32_t                     Value;
        } DW97;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue24                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_24
                uint32_t                 ForwardBChGammaCorrectedValue24                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_24
            };
            uint32_t                     Value;
        } DW98;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue24                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_24
                uint32_t                 ForwardRChGammaCorrectedValue24                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_24
            };
            uint32_t                     Value;
        } DW99;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue25                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_25
                uint32_t                 InverseBChGammaCorrectedValue25                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_25
            };
            uint32_t                     Value;
        } DW100;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue25                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_25
                uint32_t                 InverseRChGammaCorrectedValue25                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_25
            };
            uint32_t                     Value;
        } DW101;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue25                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_25
                uint32_t                 ForwardBChGammaCorrectedValue25                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_25
            };
            uint32_t                     Value;
        } DW102;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue25                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_25
                uint32_t                 ForwardRChGammaCorrectedValue25                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_25
            };
            uint32_t                     Value;
        } DW103;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue26                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_26
                uint32_t                 InverseBChGammaCorrectedValue26                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_26
            };
            uint32_t                     Value;
        } DW104;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue26                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_26
                uint32_t                 InverseRChGammaCorrectedValue26                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_26
            };
            uint32_t                     Value;
        } DW105;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue26                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_26
                uint32_t                 ForwardBChGammaCorrectedValue26                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_26
            };
            uint32_t                     Value;
        } DW106;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue26                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_26
                uint32_t                 ForwardRChGammaCorrectedValue26                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_26
            };
            uint32_t                     Value;
        } DW107;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue27                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_27
                uint32_t                 InverseBChGammaCorrectedValue27                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_27
            };
            uint32_t                     Value;
        } DW108;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue27                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_27
                uint32_t                 InverseRChGammaCorrectedValue27                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_27
            };
            uint32_t                     Value;
        } DW109;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue27                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_27
                uint32_t                 ForwardBChGammaCorrectedValue27                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_27
            };
            uint32_t                     Value;
        } DW110;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue27                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_27
                uint32_t                 ForwardRChGammaCorrectedValue27                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_27
            };
            uint32_t                     Value;
        } DW111;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue28                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_28
                uint32_t                 InverseBChGammaCorrectedValue28                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_28
            };
            uint32_t                     Value;
        } DW112;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue28                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_28
                uint32_t                 InverseRChGammaCorrectedValue28                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_28
            };
            uint32_t                     Value;
        } DW113;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue28                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_28
                uint32_t                 ForwardBChGammaCorrectedValue28                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_28
            };
            uint32_t                     Value;
        } DW114;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue28                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_28
                uint32_t                 ForwardRChGammaCorrectedValue28                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_28
            };
            uint32_t                     Value;
        } DW115;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue29                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_29
                uint32_t                 InverseBChGammaCorrectedValue29                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_29
            };
            uint32_t                     Value;
        } DW116;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue29                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_29
                uint32_t                 InverseRChGammaCorrectedValue29                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_29
            };
            uint32_t                     Value;
        } DW117;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue29                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_29
                uint32_t                 ForwardBChGammaCorrectedValue29                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_29
            };
            uint32_t                     Value;
        } DW118;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue29                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_29
                uint32_t                 ForwardRChGammaCorrectedValue29                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_29
            };
            uint32_t                     Value;
        } DW119;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue30                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_30
                uint32_t                 InverseBChGammaCorrectedValue30                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_30
            };
            uint32_t                     Value;
        } DW120;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue30                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_30
                uint32_t                 InverseRChGammaCorrectedValue30                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_30
            };
            uint32_t                     Value;
        } DW121;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue30                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_30
                uint32_t                 ForwardBChGammaCorrectedValue30                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_30
            };
            uint32_t                     Value;
        } DW122;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue30                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_30
                uint32_t                 ForwardRChGammaCorrectedValue30                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_30
            };
            uint32_t                     Value;
        } DW123;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue31                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_31
                uint32_t                 InverseBChGammaCorrectedValue31                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_31
            };
            uint32_t                     Value;
        } DW124;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue31                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_31
                uint32_t                 InverseRChGammaCorrectedValue31                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_31
            };
            uint32_t                     Value;
        } DW125;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue31                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_31
                uint32_t                 ForwardBChGammaCorrectedValue31                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_31
            };
            uint32_t                     Value;
        } DW126;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue31                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_31
                uint32_t                 ForwardRChGammaCorrectedValue31                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_31
            };
            uint32_t                     Value;
        } DW127;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue32                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_32
                uint32_t                 InverseBChGammaCorrectedValue32                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_32
            };
            uint32_t                     Value;
        } DW128;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue32                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_32
                uint32_t                 InverseRChGammaCorrectedValue32                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_32
            };
            uint32_t                     Value;
        } DW129;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue32                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_32
                uint32_t                 ForwardBChGammaCorrectedValue32                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_32
            };
            uint32_t                     Value;
        } DW130;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue32                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_32
                uint32_t                 ForwardRChGammaCorrectedValue32                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_32
            };
            uint32_t                     Value;
        } DW131;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue33                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_33
                uint32_t                 InverseBChGammaCorrectedValue33                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_33
            };
            uint32_t                     Value;
        } DW132;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue33                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_33
                uint32_t                 InverseRChGammaCorrectedValue33                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_33
            };
            uint32_t                     Value;
        } DW133;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue33                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_33
                uint32_t                 ForwardBChGammaCorrectedValue33                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_33
            };
            uint32_t                     Value;
        } DW134;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue33                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_33
                uint32_t                 ForwardRChGammaCorrectedValue33                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_33
            };
            uint32_t                     Value;
        } DW135;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue34                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_34
                uint32_t                 InverseBChGammaCorrectedValue34                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_34
            };
            uint32_t                     Value;
        } DW136;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue34                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_34
                uint32_t                 InverseRChGammaCorrectedValue34                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_34
            };
            uint32_t                     Value;
        } DW137;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue34                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_34
                uint32_t                 ForwardBChGammaCorrectedValue34                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_34
            };
            uint32_t                     Value;
        } DW138;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue34                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_34
                uint32_t                 ForwardRChGammaCorrectedValue34                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_34
            };
            uint32_t                     Value;
        } DW139;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue35                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_35
                uint32_t                 InverseBChGammaCorrectedValue35                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_35
            };
            uint32_t                     Value;
        } DW140;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue35                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_35
                uint32_t                 InverseRChGammaCorrectedValue35                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_35
            };
            uint32_t                     Value;
        } DW141;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue35                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_35
                uint32_t                 ForwardBChGammaCorrectedValue35                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_35
            };
            uint32_t                     Value;
        } DW142;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue35                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_35
                uint32_t                 ForwardRChGammaCorrectedValue35                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_35
            };
            uint32_t                     Value;
        } DW143;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue36                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_36
                uint32_t                 InverseBChGammaCorrectedValue36                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_36
            };
            uint32_t                     Value;
        } DW144;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue36                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_36
                uint32_t                 InverseRChGammaCorrectedValue36                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_36
            };
            uint32_t                     Value;
        } DW145;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue36                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_36
                uint32_t                 ForwardBChGammaCorrectedValue36                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_36
            };
            uint32_t                     Value;
        } DW146;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue36                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_36
                uint32_t                 ForwardRChGammaCorrectedValue36                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_36
            };
            uint32_t                     Value;
        } DW147;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue37                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_37
                uint32_t                 InverseBChGammaCorrectedValue37                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_37
            };
            uint32_t                     Value;
        } DW148;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue37                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_37
                uint32_t                 InverseRChGammaCorrectedValue37                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_37
            };
            uint32_t                     Value;
        } DW149;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue37                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_37
                uint32_t                 ForwardBChGammaCorrectedValue37                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_37
            };
            uint32_t                     Value;
        } DW150;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue37                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_37
                uint32_t                 ForwardRChGammaCorrectedValue37                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_37
            };
            uint32_t                     Value;
        } DW151;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue38                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_38
                uint32_t                 InverseBChGammaCorrectedValue38                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_38
            };
            uint32_t                     Value;
        } DW152;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue38                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_38
                uint32_t                 InverseRChGammaCorrectedValue38                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_38
            };
            uint32_t                     Value;
        } DW153;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue38                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_38
                uint32_t                 ForwardBChGammaCorrectedValue38                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_38
            };
            uint32_t                     Value;
        } DW154;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue38                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_38
                uint32_t                 ForwardRChGammaCorrectedValue38                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_38
            };
            uint32_t                     Value;
        } DW155;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue39                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_39
                uint32_t                 InverseBChGammaCorrectedValue39                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_39
            };
            uint32_t                     Value;
        } DW156;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue39                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_39
                uint32_t                 InverseRChGammaCorrectedValue39                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_39
            };
            uint32_t                     Value;
        } DW157;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue39                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_39
                uint32_t                 ForwardBChGammaCorrectedValue39                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_39
            };
            uint32_t                     Value;
        } DW158;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue39                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_39
                uint32_t                 ForwardRChGammaCorrectedValue39                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_39
            };
            uint32_t                     Value;
        } DW159;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue40                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_40
                uint32_t                 InverseBChGammaCorrectedValue40                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_40
            };
            uint32_t                     Value;
        } DW160;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue40                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_40
                uint32_t                 InverseRChGammaCorrectedValue40                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_40
            };
            uint32_t                     Value;
        } DW161;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue40                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_40
                uint32_t                 ForwardBChGammaCorrectedValue40                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_40
            };
            uint32_t                     Value;
        } DW162;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue40                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_40
                uint32_t                 ForwardRChGammaCorrectedValue40                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_40
            };
            uint32_t                     Value;
        } DW163;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue41                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_41
                uint32_t                 InverseBChGammaCorrectedValue41                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_41
            };
            uint32_t                     Value;
        } DW164;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue41                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_41
                uint32_t                 InverseRChGammaCorrectedValue41                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_41
            };
            uint32_t                     Value;
        } DW165;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue41                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_41
                uint32_t                 ForwardBChGammaCorrectedValue41                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_41
            };
            uint32_t                     Value;
        } DW166;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue41                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_41
                uint32_t                 ForwardRChGammaCorrectedValue41                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_41
            };
            uint32_t                     Value;
        } DW167;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue42                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_42
                uint32_t                 InverseBChGammaCorrectedValue42                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_42
            };
            uint32_t                     Value;
        } DW168;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue42                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_42
                uint32_t                 InverseRChGammaCorrectedValue42                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_42
            };
            uint32_t                     Value;
        } DW169;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue42                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_42
                uint32_t                 ForwardBChGammaCorrectedValue42                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_42
            };
            uint32_t                     Value;
        } DW170;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue42                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_42
                uint32_t                 ForwardRChGammaCorrectedValue42                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_42
            };
            uint32_t                     Value;
        } DW171;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue43                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_43
                uint32_t                 InverseBChGammaCorrectedValue43                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_43
            };
            uint32_t                     Value;
        } DW172;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue43                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_43
                uint32_t                 InverseRChGammaCorrectedValue43                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_43
            };
            uint32_t                     Value;
        } DW173;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue43                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_43
                uint32_t                 ForwardBChGammaCorrectedValue43                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_43
            };
            uint32_t                     Value;
        } DW174;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue43                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_43
                uint32_t                 ForwardRChGammaCorrectedValue43                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_43
            };
            uint32_t                     Value;
        } DW175;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue44                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_44
                uint32_t                 InverseBChGammaCorrectedValue44                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_44
            };
            uint32_t                     Value;
        } DW176;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue44                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_44
                uint32_t                 InverseRChGammaCorrectedValue44                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_44
            };
            uint32_t                     Value;
        } DW177;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue44                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_44
                uint32_t                 ForwardBChGammaCorrectedValue44                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_44
            };
            uint32_t                     Value;
        } DW178;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue44                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_44
                uint32_t                 ForwardRChGammaCorrectedValue44                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_44
            };
            uint32_t                     Value;
        } DW179;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue45                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_45
                uint32_t                 InverseBChGammaCorrectedValue45                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_45
            };
            uint32_t                     Value;
        } DW180;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue45                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_45
                uint32_t                 InverseRChGammaCorrectedValue45                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_45
            };
            uint32_t                     Value;
        } DW181;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue45                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_45
                uint32_t                 ForwardBChGammaCorrectedValue45                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_45
            };
            uint32_t                     Value;
        } DW182;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue45                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_45
                uint32_t                 ForwardRChGammaCorrectedValue45                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_45
            };
            uint32_t                     Value;
        } DW183;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue46                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_46
                uint32_t                 InverseBChGammaCorrectedValue46                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_46
            };
            uint32_t                     Value;
        } DW184;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue46                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_46
                uint32_t                 InverseRChGammaCorrectedValue46                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_46
            };
            uint32_t                     Value;
        } DW185;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue46                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_46
                uint32_t                 ForwardBChGammaCorrectedValue46                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_46
            };
            uint32_t                     Value;
        } DW186;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue46                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_46
                uint32_t                 ForwardRChGammaCorrectedValue46                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_46
            };
            uint32_t                     Value;
        } DW187;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue47                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_47
                uint32_t                 InverseBChGammaCorrectedValue47                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_47
            };
            uint32_t                     Value;
        } DW188;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue47                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_47
                uint32_t                 InverseRChGammaCorrectedValue47                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_47
            };
            uint32_t                     Value;
        } DW189;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue47                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_47
                uint32_t                 ForwardBChGammaCorrectedValue47                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_47
            };
            uint32_t                     Value;
        } DW190;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue47                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_47
                uint32_t                 ForwardRChGammaCorrectedValue47                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_47
            };
            uint32_t                     Value;
        } DW191;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue48                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_48
                uint32_t                 InverseBChGammaCorrectedValue48                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_48
            };
            uint32_t                     Value;
        } DW192;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue48                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_48
                uint32_t                 InverseRChGammaCorrectedValue48                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_48
            };
            uint32_t                     Value;
        } DW193;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue48                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_48
                uint32_t                 ForwardBChGammaCorrectedValue48                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_48
            };
            uint32_t                     Value;
        } DW194;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue48                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_48
                uint32_t                 ForwardRChGammaCorrectedValue48                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_48
            };
            uint32_t                     Value;
        } DW195;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue49                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_49
                uint32_t                 InverseBChGammaCorrectedValue49                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_49
            };
            uint32_t                     Value;
        } DW196;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue49                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_49
                uint32_t                 InverseRChGammaCorrectedValue49                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_49
            };
            uint32_t                     Value;
        } DW197;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue49                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_49
                uint32_t                 ForwardBChGammaCorrectedValue49                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_49
            };
            uint32_t                     Value;
        } DW198;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue49                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_49
                uint32_t                 ForwardRChGammaCorrectedValue49                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_49
            };
            uint32_t                     Value;
        } DW199;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue50                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_50
                uint32_t                 InverseBChGammaCorrectedValue50                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_50
            };
            uint32_t                     Value;
        } DW200;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue50                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_50
                uint32_t                 InverseRChGammaCorrectedValue50                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_50
            };
            uint32_t                     Value;
        } DW201;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue50                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_50
                uint32_t                 ForwardBChGammaCorrectedValue50                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_50
            };
            uint32_t                     Value;
        } DW202;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue50                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_50
                uint32_t                 ForwardRChGammaCorrectedValue50                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_50
            };
            uint32_t                     Value;
        } DW203;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue51                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_51
                uint32_t                 InverseBChGammaCorrectedValue51                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_51
            };
            uint32_t                     Value;
        } DW204;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue51                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_51
                uint32_t                 InverseRChGammaCorrectedValue51                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_51
            };
            uint32_t                     Value;
        } DW205;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue51                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_51
                uint32_t                 ForwardBChGammaCorrectedValue51                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_51
            };
            uint32_t                     Value;
        } DW206;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue51                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_51
                uint32_t                 ForwardRChGammaCorrectedValue51                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_51
            };
            uint32_t                     Value;
        } DW207;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue52                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_52
                uint32_t                 InverseBChGammaCorrectedValue52                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_52
            };
            uint32_t                     Value;
        } DW208;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue52                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_52
                uint32_t                 InverseRChGammaCorrectedValue52                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_52
            };
            uint32_t                     Value;
        } DW209;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue52                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_52
                uint32_t                 ForwardBChGammaCorrectedValue52                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_52
            };
            uint32_t                     Value;
        } DW210;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue52                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_52
                uint32_t                 ForwardRChGammaCorrectedValue52                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_52
            };
            uint32_t                     Value;
        } DW211;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue53                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_53
                uint32_t                 InverseBChGammaCorrectedValue53                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_53
            };
            uint32_t                     Value;
        } DW212;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue53                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_53
                uint32_t                 InverseRChGammaCorrectedValue53                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_53
            };
            uint32_t                     Value;
        } DW213;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue53                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_53
                uint32_t                 ForwardBChGammaCorrectedValue53                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_53
            };
            uint32_t                     Value;
        } DW214;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue53                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_53
                uint32_t                 ForwardRChGammaCorrectedValue53                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_53
            };
            uint32_t                     Value;
        } DW215;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue54                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_54
                uint32_t                 InverseBChGammaCorrectedValue54                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_54
            };
            uint32_t                     Value;
        } DW216;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue54                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_54
                uint32_t                 InverseRChGammaCorrectedValue54                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_54
            };
            uint32_t                     Value;
        } DW217;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue54                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_54
                uint32_t                 ForwardBChGammaCorrectedValue54                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_54
            };
            uint32_t                     Value;
        } DW218;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue54                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_54
                uint32_t                 ForwardRChGammaCorrectedValue54                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_54
            };
            uint32_t                     Value;
        } DW219;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue55                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_55
                uint32_t                 InverseBChGammaCorrectedValue55                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_55
            };
            uint32_t                     Value;
        } DW220;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue55                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_55
                uint32_t                 InverseRChGammaCorrectedValue55                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_55
            };
            uint32_t                     Value;
        } DW221;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue55                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_55
                uint32_t                 ForwardBChGammaCorrectedValue55                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_55
            };
            uint32_t                     Value;
        } DW222;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue55                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_55
                uint32_t                 ForwardRChGammaCorrectedValue55                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_55
            };
            uint32_t                     Value;
        } DW223;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue56                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_56
                uint32_t                 InverseBChGammaCorrectedValue56                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_56
            };
            uint32_t                     Value;
        } DW224;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue56                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_56
                uint32_t                 InverseRChGammaCorrectedValue56                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_56
            };
            uint32_t                     Value;
        } DW225;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue56                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_56
                uint32_t                 ForwardBChGammaCorrectedValue56                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_56
            };
            uint32_t                     Value;
        } DW226;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue56                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_56
                uint32_t                 ForwardRChGammaCorrectedValue56                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_56
            };
            uint32_t                     Value;
        } DW227;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue57                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_57
                uint32_t                 InverseBChGammaCorrectedValue57                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_57
            };
            uint32_t                     Value;
        } DW228;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue57                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_57
                uint32_t                 InverseRChGammaCorrectedValue57                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_57
            };
            uint32_t                     Value;
        } DW229;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue57                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_57
                uint32_t                 ForwardBChGammaCorrectedValue57                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_57
            };
            uint32_t                     Value;
        } DW230;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue57                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_57
                uint32_t                 ForwardRChGammaCorrectedValue57                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_57
            };
            uint32_t                     Value;
        } DW231;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue58                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_58
                uint32_t                 InverseBChGammaCorrectedValue58                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_58
            };
            uint32_t                     Value;
        } DW232;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue58                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_58
                uint32_t                 InverseRChGammaCorrectedValue58                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_58
            };
            uint32_t                     Value;
        } DW233;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue58                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_58
                uint32_t                 ForwardBChGammaCorrectedValue58                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_58
            };
            uint32_t                     Value;
        } DW234;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue58                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_58
                uint32_t                 ForwardRChGammaCorrectedValue58                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_58
            };
            uint32_t                     Value;
        } DW235;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue59                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_59
                uint32_t                 InverseBChGammaCorrectedValue59                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_59
            };
            uint32_t                     Value;
        } DW236;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue59                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_59
                uint32_t                 InverseRChGammaCorrectedValue59                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_59
            };
            uint32_t                     Value;
        } DW237;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue59                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_59
                uint32_t                 ForwardBChGammaCorrectedValue59                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_59
            };
            uint32_t                     Value;
        } DW238;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue59                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_59
                uint32_t                 ForwardRChGammaCorrectedValue59                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_59
            };
            uint32_t                     Value;
        } DW239;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue60                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_60
                uint32_t                 InverseBChGammaCorrectedValue60                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_60
            };
            uint32_t                     Value;
        } DW240;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue60                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_60
                uint32_t                 InverseRChGammaCorrectedValue60                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_60
            };
            uint32_t                     Value;
        } DW241;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue60                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_60
                uint32_t                 ForwardBChGammaCorrectedValue60                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_60
            };
            uint32_t                     Value;
        } DW242;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue60                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_60
                uint32_t                 ForwardRChGammaCorrectedValue60                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_60
            };
            uint32_t                     Value;
        } DW243;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue61                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_61
                uint32_t                 InverseBChGammaCorrectedValue61                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_61
            };
            uint32_t                     Value;
        } DW244;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue61                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_61
                uint32_t                 InverseRChGammaCorrectedValue61                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_61
            };
            uint32_t                     Value;
        } DW245;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue61                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_61
                uint32_t                 ForwardBChGammaCorrectedValue61                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_61
            };
            uint32_t                     Value;
        } DW246;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue61                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_61
                uint32_t                 ForwardRChGammaCorrectedValue61                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_61
            };
            uint32_t                     Value;
        } DW247;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue62                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_62
                uint32_t                 InverseBChGammaCorrectedValue62                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_62
            };
            uint32_t                     Value;
        } DW248;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue62                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_62
                uint32_t                 InverseRChGammaCorrectedValue62                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_62
            };
            uint32_t                     Value;
        } DW249;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue62                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_62
                uint32_t                 ForwardBChGammaCorrectedValue62                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_62
            };
            uint32_t                     Value;
        } DW250;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue62                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_62
                uint32_t                 ForwardRChGammaCorrectedValue62                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_62
            };
            uint32_t                     Value;
        } DW251;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue63                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_63
                uint32_t                 InverseBChGammaCorrectedValue63                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_63
            };
            uint32_t                     Value;
        } DW252;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue63                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_63
                uint32_t                 InverseRChGammaCorrectedValue63                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_63
            };
            uint32_t                     Value;
        } DW253;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue63                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_63
                uint32_t                 ForwardBChGammaCorrectedValue63                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_63
            };
            uint32_t                     Value;
        } DW254;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue63                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_63
                uint32_t                 ForwardRChGammaCorrectedValue63                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_63
            };
            uint32_t                     Value;
        } DW255;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue64                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_64
                uint32_t                 InverseBChGammaCorrectedValue64                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_64
            };
            uint32_t                     Value;
        } DW256;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue64                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_64
                uint32_t                 InverseRChGammaCorrectedValue64                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_64
            };
            uint32_t                     Value;
        } DW257;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue64                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_64
                uint32_t                 ForwardBChGammaCorrectedValue64                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_64
            };
            uint32_t                     Value;
        } DW258;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue64                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_64
                uint32_t                 ForwardRChGammaCorrectedValue64                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_64
            };
            uint32_t                     Value;
        } DW259;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue65                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_65
                uint32_t                 InverseBChGammaCorrectedValue65                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_65
            };
            uint32_t                     Value;
        } DW260;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue65                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_65
                uint32_t                 InverseRChGammaCorrectedValue65                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_65
            };
            uint32_t                     Value;
        } DW261;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue65                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_65
                uint32_t                 ForwardBChGammaCorrectedValue65                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_65
            };
            uint32_t                     Value;
        } DW262;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue65                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_65
                uint32_t                 ForwardRChGammaCorrectedValue65                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_65
            };
            uint32_t                     Value;
        } DW263;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue66                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_66
                uint32_t                 InverseBChGammaCorrectedValue66                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_66
            };
            uint32_t                     Value;
        } DW264;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue66                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_66
                uint32_t                 InverseRChGammaCorrectedValue66                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_66
            };
            uint32_t                     Value;
        } DW265;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue66                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_66
                uint32_t                 ForwardBChGammaCorrectedValue66                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_66
            };
            uint32_t                     Value;
        } DW266;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue66                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_66
                uint32_t                 ForwardRChGammaCorrectedValue66                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_66
            };
            uint32_t                     Value;
        } DW267;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue67                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_67
                uint32_t                 InverseBChGammaCorrectedValue67                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_67
            };
            uint32_t                     Value;
        } DW268;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue67                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_67
                uint32_t                 InverseRChGammaCorrectedValue67                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_67
            };
            uint32_t                     Value;
        } DW269;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue67                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_67
                uint32_t                 ForwardBChGammaCorrectedValue67                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_67
            };
            uint32_t                     Value;
        } DW270;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue67                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_67
                uint32_t                 ForwardRChGammaCorrectedValue67                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_67
            };
            uint32_t                     Value;
        } DW271;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue68                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_68
                uint32_t                 InverseBChGammaCorrectedValue68                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_68
            };
            uint32_t                     Value;
        } DW272;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue68                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_68
                uint32_t                 InverseRChGammaCorrectedValue68                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_68
            };
            uint32_t                     Value;
        } DW273;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue68                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_68
                uint32_t                 ForwardBChGammaCorrectedValue68                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_68
            };
            uint32_t                     Value;
        } DW274;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue68                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_68
                uint32_t                 ForwardRChGammaCorrectedValue68                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_68
            };
            uint32_t                     Value;
        } DW275;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue69                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_69
                uint32_t                 InverseBChGammaCorrectedValue69                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_69
            };
            uint32_t                     Value;
        } DW276;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue69                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_69
                uint32_t                 InverseRChGammaCorrectedValue69                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_69
            };
            uint32_t                     Value;
        } DW277;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue69                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_69
                uint32_t                 ForwardBChGammaCorrectedValue69                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_69
            };
            uint32_t                     Value;
        } DW278;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue69                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_69
                uint32_t                 ForwardRChGammaCorrectedValue69                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_69
            };
            uint32_t                     Value;
        } DW279;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue70                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_70
                uint32_t                 InverseBChGammaCorrectedValue70                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_70
            };
            uint32_t                     Value;
        } DW280;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue70                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_70
                uint32_t                 InverseRChGammaCorrectedValue70                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_70
            };
            uint32_t                     Value;
        } DW281;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue70                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_70
                uint32_t                 ForwardBChGammaCorrectedValue70                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_70
            };
            uint32_t                     Value;
        } DW282;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue70                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_70
                uint32_t                 ForwardRChGammaCorrectedValue70                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_70
            };
            uint32_t                     Value;
        } DW283;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue71                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_71
                uint32_t                 InverseBChGammaCorrectedValue71                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_71
            };
            uint32_t                     Value;
        } DW284;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue71                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_71
                uint32_t                 InverseRChGammaCorrectedValue71                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_71
            };
            uint32_t                     Value;
        } DW285;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue71                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_71
                uint32_t                 ForwardBChGammaCorrectedValue71                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_71
            };
            uint32_t                     Value;
        } DW286;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue71                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_71
                uint32_t                 ForwardRChGammaCorrectedValue71                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_71
            };
            uint32_t                     Value;
        } DW287;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue72                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_72
                uint32_t                 InverseBChGammaCorrectedValue72                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_72
            };
            uint32_t                     Value;
        } DW288;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue72                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_72
                uint32_t                 InverseRChGammaCorrectedValue72                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_72
            };
            uint32_t                     Value;
        } DW289;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue72                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_72
                uint32_t                 ForwardBChGammaCorrectedValue72                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_72
            };
            uint32_t                     Value;
        } DW290;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue72                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_72
                uint32_t                 ForwardRChGammaCorrectedValue72                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_72
            };
            uint32_t                     Value;
        } DW291;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue73                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_73
                uint32_t                 InverseBChGammaCorrectedValue73                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_73
            };
            uint32_t                     Value;
        } DW292;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue73                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_73
                uint32_t                 InverseRChGammaCorrectedValue73                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_73
            };
            uint32_t                     Value;
        } DW293;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue73                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_73
                uint32_t                 ForwardBChGammaCorrectedValue73                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_73
            };
            uint32_t                     Value;
        } DW294;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue73                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_73
                uint32_t                 ForwardRChGammaCorrectedValue73                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_73
            };
            uint32_t                     Value;
        } DW295;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue74                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_74
                uint32_t                 InverseBChGammaCorrectedValue74                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_74
            };
            uint32_t                     Value;
        } DW296;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue74                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_74
                uint32_t                 InverseRChGammaCorrectedValue74                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_74
            };
            uint32_t                     Value;
        } DW297;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue74                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_74
                uint32_t                 ForwardBChGammaCorrectedValue74                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_74
            };
            uint32_t                     Value;
        } DW298;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue74                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_74
                uint32_t                 ForwardRChGammaCorrectedValue74                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_74
            };
            uint32_t                     Value;
        } DW299;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue75                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_75
                uint32_t                 InverseBChGammaCorrectedValue75                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_75
            };
            uint32_t                     Value;
        } DW300;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue75                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_75
                uint32_t                 InverseRChGammaCorrectedValue75                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_75
            };
            uint32_t                     Value;
        } DW301;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue75                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_75
                uint32_t                 ForwardBChGammaCorrectedValue75                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_75
            };
            uint32_t                     Value;
        } DW302;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue75                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_75
                uint32_t                 ForwardRChGammaCorrectedValue75                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_75
            };
            uint32_t                     Value;
        } DW303;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue76                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_76
                uint32_t                 InverseBChGammaCorrectedValue76                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_76
            };
            uint32_t                     Value;
        } DW304;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue76                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_76
                uint32_t                 InverseRChGammaCorrectedValue76                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_76
            };
            uint32_t                     Value;
        } DW305;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue76                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_76
                uint32_t                 ForwardBChGammaCorrectedValue76                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_76
            };
            uint32_t                     Value;
        } DW306;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue76                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_76
                uint32_t                 ForwardRChGammaCorrectedValue76                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_76
            };
            uint32_t                     Value;
        } DW307;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue77                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_77
                uint32_t                 InverseBChGammaCorrectedValue77                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_77
            };
            uint32_t                     Value;
        } DW308;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue77                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_77
                uint32_t                 InverseRChGammaCorrectedValue77                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_77
            };
            uint32_t                     Value;
        } DW309;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue77                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_77
                uint32_t                 ForwardBChGammaCorrectedValue77                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_77
            };
            uint32_t                     Value;
        } DW310;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue77                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_77
                uint32_t                 ForwardRChGammaCorrectedValue77                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_77
            };
            uint32_t                     Value;
        } DW311;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue78                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_78
                uint32_t                 InverseBChGammaCorrectedValue78                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_78
            };
            uint32_t                     Value;
        } DW312;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue78                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_78
                uint32_t                 InverseRChGammaCorrectedValue78                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_78
            };
            uint32_t                     Value;
        } DW313;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue78                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_78
                uint32_t                 ForwardBChGammaCorrectedValue78                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_78
            };
            uint32_t                     Value;
        } DW314;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue78                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_78
                uint32_t                 ForwardRChGammaCorrectedValue78                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_78
            };
            uint32_t                     Value;
        } DW315;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue79                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_79
                uint32_t                 InverseBChGammaCorrectedValue79                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_79
            };
            uint32_t                     Value;
        } DW316;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue79                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_79
                uint32_t                 InverseRChGammaCorrectedValue79                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_79
            };
            uint32_t                     Value;
        } DW317;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue79                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_79
                uint32_t                 ForwardBChGammaCorrectedValue79                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_79
            };
            uint32_t                     Value;
        } DW318;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue79                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_79
                uint32_t                 ForwardRChGammaCorrectedValue79                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_79
            };
            uint32_t                     Value;
        } DW319;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue80                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_80
                uint32_t                 InverseBChGammaCorrectedValue80                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_80
            };
            uint32_t                     Value;
        } DW320;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue80                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_80
                uint32_t                 InverseRChGammaCorrectedValue80                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_80
            };
            uint32_t                     Value;
        } DW321;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue80                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_80
                uint32_t                 ForwardBChGammaCorrectedValue80                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_80
            };
            uint32_t                     Value;
        } DW322;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue80                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_80
                uint32_t                 ForwardRChGammaCorrectedValue80                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_80
            };
            uint32_t                     Value;
        } DW323;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue81                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_81
                uint32_t                 InverseBChGammaCorrectedValue81                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_81
            };
            uint32_t                     Value;
        } DW324;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue81                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_81
                uint32_t                 InverseRChGammaCorrectedValue81                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_81
            };
            uint32_t                     Value;
        } DW325;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue81                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_81
                uint32_t                 ForwardBChGammaCorrectedValue81                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_81
            };
            uint32_t                     Value;
        } DW326;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue81                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_81
                uint32_t                 ForwardRChGammaCorrectedValue81                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_81
            };
            uint32_t                     Value;
        } DW327;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue82                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_82
                uint32_t                 InverseBChGammaCorrectedValue82                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_82
            };
            uint32_t                     Value;
        } DW328;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue82                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_82
                uint32_t                 InverseRChGammaCorrectedValue82                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_82
            };
            uint32_t                     Value;
        } DW329;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue82                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_82
                uint32_t                 ForwardBChGammaCorrectedValue82                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_82
            };
            uint32_t                     Value;
        } DW330;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue82                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_82
                uint32_t                 ForwardRChGammaCorrectedValue82                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_82
            };
            uint32_t                     Value;
        } DW331;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue83                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_83
                uint32_t                 InverseBChGammaCorrectedValue83                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_83
            };
            uint32_t                     Value;
        } DW332;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue83                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_83
                uint32_t                 InverseRChGammaCorrectedValue83                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_83
            };
            uint32_t                     Value;
        } DW333;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue83                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_83
                uint32_t                 ForwardBChGammaCorrectedValue83                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_83
            };
            uint32_t                     Value;
        } DW334;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue83                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_83
                uint32_t                 ForwardRChGammaCorrectedValue83                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_83
            };
            uint32_t                     Value;
        } DW335;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue84                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_84
                uint32_t                 InverseBChGammaCorrectedValue84                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_84
            };
            uint32_t                     Value;
        } DW336;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue84                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_84
                uint32_t                 InverseRChGammaCorrectedValue84                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_84
            };
            uint32_t                     Value;
        } DW337;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue84                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_84
                uint32_t                 ForwardBChGammaCorrectedValue84                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_84
            };
            uint32_t                     Value;
        } DW338;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue84                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_84
                uint32_t                 ForwardRChGammaCorrectedValue84                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_84
            };
            uint32_t                     Value;
        } DW339;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue85                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_85
                uint32_t                 InverseBChGammaCorrectedValue85                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_85
            };
            uint32_t                     Value;
        } DW340;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue85                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_85
                uint32_t                 InverseRChGammaCorrectedValue85                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_85
            };
            uint32_t                     Value;
        } DW341;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue85                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_85
                uint32_t                 ForwardBChGammaCorrectedValue85                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_85
            };
            uint32_t                     Value;
        } DW342;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue85                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_85
                uint32_t                 ForwardRChGammaCorrectedValue85                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_85
            };
            uint32_t                     Value;
        } DW343;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue86                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_86
                uint32_t                 InverseBChGammaCorrectedValue86                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_86
            };
            uint32_t                     Value;
        } DW344;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue86                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_86
                uint32_t                 InverseRChGammaCorrectedValue86                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_86
            };
            uint32_t                     Value;
        } DW345;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue86                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_86
                uint32_t                 ForwardBChGammaCorrectedValue86                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_86
            };
            uint32_t                     Value;
        } DW346;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue86                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_86
                uint32_t                 ForwardRChGammaCorrectedValue86                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_86
            };
            uint32_t                     Value;
        } DW347;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue87                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_87
                uint32_t                 InverseBChGammaCorrectedValue87                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_87
            };
            uint32_t                     Value;
        } DW348;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue87                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_87
                uint32_t                 InverseRChGammaCorrectedValue87                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_87
            };
            uint32_t                     Value;
        } DW349;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue87                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_87
                uint32_t                 ForwardBChGammaCorrectedValue87                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_87
            };
            uint32_t                     Value;
        } DW350;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue87                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_87
                uint32_t                 ForwardRChGammaCorrectedValue87                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_87
            };
            uint32_t                     Value;
        } DW351;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue88                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_88
                uint32_t                 InverseBChGammaCorrectedValue88                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_88
            };
            uint32_t                     Value;
        } DW352;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue88                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_88
                uint32_t                 InverseRChGammaCorrectedValue88                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_88
            };
            uint32_t                     Value;
        } DW353;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue88                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_88
                uint32_t                 ForwardBChGammaCorrectedValue88                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_88
            };
            uint32_t                     Value;
        } DW354;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue88                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_88
                uint32_t                 ForwardRChGammaCorrectedValue88                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_88
            };
            uint32_t                     Value;
        } DW355;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue89                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_89
                uint32_t                 InverseBChGammaCorrectedValue89                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_89
            };
            uint32_t                     Value;
        } DW356;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue89                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_89
                uint32_t                 InverseRChGammaCorrectedValue89                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_89
            };
            uint32_t                     Value;
        } DW357;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue89                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_89
                uint32_t                 ForwardBChGammaCorrectedValue89                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_89
            };
            uint32_t                     Value;
        } DW358;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue89                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_89
                uint32_t                 ForwardRChGammaCorrectedValue89                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_89
            };
            uint32_t                     Value;
        } DW359;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue90                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_90
                uint32_t                 InverseBChGammaCorrectedValue90                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_90
            };
            uint32_t                     Value;
        } DW360;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue90                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_90
                uint32_t                 InverseRChGammaCorrectedValue90                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_90
            };
            uint32_t                     Value;
        } DW361;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue90                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_90
                uint32_t                 ForwardBChGammaCorrectedValue90                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_90
            };
            uint32_t                     Value;
        } DW362;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue90                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_90
                uint32_t                 ForwardRChGammaCorrectedValue90                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_90
            };
            uint32_t                     Value;
        } DW363;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue91                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_91
                uint32_t                 InverseBChGammaCorrectedValue91                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_91
            };
            uint32_t                     Value;
        } DW364;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue91                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_91
                uint32_t                 InverseRChGammaCorrectedValue91                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_91
            };
            uint32_t                     Value;
        } DW365;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue91                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_91
                uint32_t                 ForwardBChGammaCorrectedValue91                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_91
            };
            uint32_t                     Value;
        } DW366;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue91                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_91
                uint32_t                 ForwardRChGammaCorrectedValue91                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_91
            };
            uint32_t                     Value;
        } DW367;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue92                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_92
                uint32_t                 InverseBChGammaCorrectedValue92                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_92
            };
            uint32_t                     Value;
        } DW368;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue92                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_92
                uint32_t                 InverseRChGammaCorrectedValue92                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_92
            };
            uint32_t                     Value;
        } DW369;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue92                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_92
                uint32_t                 ForwardBChGammaCorrectedValue92                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_92
            };
            uint32_t                     Value;
        } DW370;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue92                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_92
                uint32_t                 ForwardRChGammaCorrectedValue92                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_92
            };
            uint32_t                     Value;
        } DW371;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue93                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_93
                uint32_t                 InverseBChGammaCorrectedValue93                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_93
            };
            uint32_t                     Value;
        } DW372;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue93                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_93
                uint32_t                 InverseRChGammaCorrectedValue93                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_93
            };
            uint32_t                     Value;
        } DW373;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue93                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_93
                uint32_t                 ForwardBChGammaCorrectedValue93                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_93
            };
            uint32_t                     Value;
        } DW374;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue93                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_93
                uint32_t                 ForwardRChGammaCorrectedValue93                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_93
            };
            uint32_t                     Value;
        } DW375;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue94                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_94
                uint32_t                 InverseBChGammaCorrectedValue94                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_94
            };
            uint32_t                     Value;
        } DW376;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue94                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_94
                uint32_t                 InverseRChGammaCorrectedValue94                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_94
            };
            uint32_t                     Value;
        } DW377;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue94                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_94
                uint32_t                 ForwardBChGammaCorrectedValue94                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_94
            };
            uint32_t                     Value;
        } DW378;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue94                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_94
                uint32_t                 ForwardRChGammaCorrectedValue94                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_94
            };
            uint32_t                     Value;
        } DW379;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue95                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_95
                uint32_t                 InverseBChGammaCorrectedValue95                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_95
            };
            uint32_t                     Value;
        } DW380;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue95                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_95
                uint32_t                 InverseRChGammaCorrectedValue95                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_95
            };
            uint32_t                     Value;
        } DW381;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue95                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_95
                uint32_t                 ForwardBChGammaCorrectedValue95                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_95
            };
            uint32_t                     Value;
        } DW382;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue95                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_95
                uint32_t                 ForwardRChGammaCorrectedValue95                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_95
            };
            uint32_t                     Value;
        } DW383;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue96                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_96
                uint32_t                 InverseBChGammaCorrectedValue96                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_96
            };
            uint32_t                     Value;
        } DW384;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue96                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_96
                uint32_t                 InverseRChGammaCorrectedValue96                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_96
            };
            uint32_t                     Value;
        } DW385;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue96                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_96
                uint32_t                 ForwardBChGammaCorrectedValue96                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_96
            };
            uint32_t                     Value;
        } DW386;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue96                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_96
                uint32_t                 ForwardRChGammaCorrectedValue96                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_96
            };
            uint32_t                     Value;
        } DW387;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue97                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_97
                uint32_t                 InverseBChGammaCorrectedValue97                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_97
            };
            uint32_t                     Value;
        } DW388;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue97                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_97
                uint32_t                 InverseRChGammaCorrectedValue97                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_97
            };
            uint32_t                     Value;
        } DW389;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue97                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_97
                uint32_t                 ForwardBChGammaCorrectedValue97                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_97
            };
            uint32_t                     Value;
        } DW390;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue97                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_97
                uint32_t                 ForwardRChGammaCorrectedValue97                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_97
            };
            uint32_t                     Value;
        } DW391;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue98                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_98
                uint32_t                 InverseBChGammaCorrectedValue98                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_98
            };
            uint32_t                     Value;
        } DW392;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue98                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_98
                uint32_t                 InverseRChGammaCorrectedValue98                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_98
            };
            uint32_t                     Value;
        } DW393;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue98                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_98
                uint32_t                 ForwardBChGammaCorrectedValue98                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_98
            };
            uint32_t                     Value;
        } DW394;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue98                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_98
                uint32_t                 ForwardRChGammaCorrectedValue98                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_98
            };
            uint32_t                     Value;
        } DW395;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue99                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_99
                uint32_t                 InverseBChGammaCorrectedValue99                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_99
            };
            uint32_t                     Value;
        } DW396;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue99                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_99
                uint32_t                 InverseRChGammaCorrectedValue99                  : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_99
            };
            uint32_t                     Value;
        } DW397;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue99                  : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_99
                uint32_t                 ForwardBChGammaCorrectedValue99                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_99
            };
            uint32_t                     Value;
        } DW398;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue99                              : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_99
                uint32_t                 ForwardRChGammaCorrectedValue99                  : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_99
            };
            uint32_t                     Value;
        } DW399;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue100                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_100
                uint32_t                 InverseBChGammaCorrectedValue100                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_100
            };
            uint32_t                     Value;
        } DW400;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue100                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_100
                uint32_t                 InverseRChGammaCorrectedValue100                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_100
            };
            uint32_t                     Value;
        } DW401;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue100                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_100
                uint32_t                 ForwardBChGammaCorrectedValue100                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_100
            };
            uint32_t                     Value;
        } DW402;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue100                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_100
                uint32_t                 ForwardRChGammaCorrectedValue100                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_100
            };
            uint32_t                     Value;
        } DW403;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue101                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_101
                uint32_t                 InverseBChGammaCorrectedValue101                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_101
            };
            uint32_t                     Value;
        } DW404;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue101                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_101
                uint32_t                 InverseRChGammaCorrectedValue101                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_101
            };
            uint32_t                     Value;
        } DW405;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue101                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_101
                uint32_t                 ForwardBChGammaCorrectedValue101                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_101
            };
            uint32_t                     Value;
        } DW406;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue101                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_101
                uint32_t                 ForwardRChGammaCorrectedValue101                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_101
            };
            uint32_t                     Value;
        } DW407;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue102                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_102
                uint32_t                 InverseBChGammaCorrectedValue102                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_102
            };
            uint32_t                     Value;
        } DW408;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue102                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_102
                uint32_t                 InverseRChGammaCorrectedValue102                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_102
            };
            uint32_t                     Value;
        } DW409;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue102                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_102
                uint32_t                 ForwardBChGammaCorrectedValue102                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_102
            };
            uint32_t                     Value;
        } DW410;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue102                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_102
                uint32_t                 ForwardRChGammaCorrectedValue102                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_102
            };
            uint32_t                     Value;
        } DW411;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue103                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_103
                uint32_t                 InverseBChGammaCorrectedValue103                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_103
            };
            uint32_t                     Value;
        } DW412;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue103                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_103
                uint32_t                 InverseRChGammaCorrectedValue103                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_103
            };
            uint32_t                     Value;
        } DW413;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue103                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_103
                uint32_t                 ForwardBChGammaCorrectedValue103                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_103
            };
            uint32_t                     Value;
        } DW414;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue103                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_103
                uint32_t                 ForwardRChGammaCorrectedValue103                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_103
            };
            uint32_t                     Value;
        } DW415;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue104                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_104
                uint32_t                 InverseBChGammaCorrectedValue104                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_104
            };
            uint32_t                     Value;
        } DW416;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue104                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_104
                uint32_t                 InverseRChGammaCorrectedValue104                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_104
            };
            uint32_t                     Value;
        } DW417;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue104                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_104
                uint32_t                 ForwardBChGammaCorrectedValue104                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_104
            };
            uint32_t                     Value;
        } DW418;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue104                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_104
                uint32_t                 ForwardRChGammaCorrectedValue104                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_104
            };
            uint32_t                     Value;
        } DW419;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue105                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_105
                uint32_t                 InverseBChGammaCorrectedValue105                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_105
            };
            uint32_t                     Value;
        } DW420;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue105                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_105
                uint32_t                 InverseRChGammaCorrectedValue105                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_105
            };
            uint32_t                     Value;
        } DW421;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue105                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_105
                uint32_t                 ForwardBChGammaCorrectedValue105                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_105
            };
            uint32_t                     Value;
        } DW422;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue105                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_105
                uint32_t                 ForwardRChGammaCorrectedValue105                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_105
            };
            uint32_t                     Value;
        } DW423;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue106                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_106
                uint32_t                 InverseBChGammaCorrectedValue106                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_106
            };
            uint32_t                     Value;
        } DW424;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue106                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_106
                uint32_t                 InverseRChGammaCorrectedValue106                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_106
            };
            uint32_t                     Value;
        } DW425;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue106                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_106
                uint32_t                 ForwardBChGammaCorrectedValue106                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_106
            };
            uint32_t                     Value;
        } DW426;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue106                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_106
                uint32_t                 ForwardRChGammaCorrectedValue106                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_106
            };
            uint32_t                     Value;
        } DW427;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue107                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_107
                uint32_t                 InverseBChGammaCorrectedValue107                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_107
            };
            uint32_t                     Value;
        } DW428;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue107                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_107
                uint32_t                 InverseRChGammaCorrectedValue107                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_107
            };
            uint32_t                     Value;
        } DW429;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue107                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_107
                uint32_t                 ForwardBChGammaCorrectedValue107                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_107
            };
            uint32_t                     Value;
        } DW430;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue107                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_107
                uint32_t                 ForwardRChGammaCorrectedValue107                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_107
            };
            uint32_t                     Value;
        } DW431;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue108                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_108
                uint32_t                 InverseBChGammaCorrectedValue108                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_108
            };
            uint32_t                     Value;
        } DW432;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue108                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_108
                uint32_t                 InverseRChGammaCorrectedValue108                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_108
            };
            uint32_t                     Value;
        } DW433;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue108                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_108
                uint32_t                 ForwardBChGammaCorrectedValue108                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_108
            };
            uint32_t                     Value;
        } DW434;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue108                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_108
                uint32_t                 ForwardRChGammaCorrectedValue108                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_108
            };
            uint32_t                     Value;
        } DW435;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue109                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_109
                uint32_t                 InverseBChGammaCorrectedValue109                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_109
            };
            uint32_t                     Value;
        } DW436;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue109                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_109
                uint32_t                 InverseRChGammaCorrectedValue109                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_109
            };
            uint32_t                     Value;
        } DW437;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue109                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_109
                uint32_t                 ForwardBChGammaCorrectedValue109                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_109
            };
            uint32_t                     Value;
        } DW438;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue109                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_109
                uint32_t                 ForwardRChGammaCorrectedValue109                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_109
            };
            uint32_t                     Value;
        } DW439;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue110                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_110
                uint32_t                 InverseBChGammaCorrectedValue110                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_110
            };
            uint32_t                     Value;
        } DW440;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue110                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_110
                uint32_t                 InverseRChGammaCorrectedValue110                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_110
            };
            uint32_t                     Value;
        } DW441;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue110                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_110
                uint32_t                 ForwardBChGammaCorrectedValue110                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_110
            };
            uint32_t                     Value;
        } DW442;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue110                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_110
                uint32_t                 ForwardRChGammaCorrectedValue110                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_110
            };
            uint32_t                     Value;
        } DW443;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue111                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_111
                uint32_t                 InverseBChGammaCorrectedValue111                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_111
            };
            uint32_t                     Value;
        } DW444;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue111                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_111
                uint32_t                 InverseRChGammaCorrectedValue111                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_111
            };
            uint32_t                     Value;
        } DW445;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue111                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_111
                uint32_t                 ForwardBChGammaCorrectedValue111                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_111
            };
            uint32_t                     Value;
        } DW446;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue111                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_111
                uint32_t                 ForwardRChGammaCorrectedValue111                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_111
            };
            uint32_t                     Value;
        } DW447;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue112                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_112
                uint32_t                 InverseBChGammaCorrectedValue112                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_112
            };
            uint32_t                     Value;
        } DW448;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue112                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_112
                uint32_t                 InverseRChGammaCorrectedValue112                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_112
            };
            uint32_t                     Value;
        } DW449;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue112                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_112
                uint32_t                 ForwardBChGammaCorrectedValue112                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_112
            };
            uint32_t                     Value;
        } DW450;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue112                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_112
                uint32_t                 ForwardRChGammaCorrectedValue112                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_112
            };
            uint32_t                     Value;
        } DW451;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue113                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_113
                uint32_t                 InverseBChGammaCorrectedValue113                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_113
            };
            uint32_t                     Value;
        } DW452;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue113                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_113
                uint32_t                 InverseRChGammaCorrectedValue113                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_113
            };
            uint32_t                     Value;
        } DW453;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue113                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_113
                uint32_t                 ForwardBChGammaCorrectedValue113                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_113
            };
            uint32_t                     Value;
        } DW454;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue113                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_113
                uint32_t                 ForwardRChGammaCorrectedValue113                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_113
            };
            uint32_t                     Value;
        } DW455;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue114                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_114
                uint32_t                 InverseBChGammaCorrectedValue114                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_114
            };
            uint32_t                     Value;
        } DW456;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue114                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_114
                uint32_t                 InverseRChGammaCorrectedValue114                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_114
            };
            uint32_t                     Value;
        } DW457;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue114                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_114
                uint32_t                 ForwardBChGammaCorrectedValue114                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_114
            };
            uint32_t                     Value;
        } DW458;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue114                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_114
                uint32_t                 ForwardRChGammaCorrectedValue114                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_114
            };
            uint32_t                     Value;
        } DW459;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue115                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_115
                uint32_t                 InverseBChGammaCorrectedValue115                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_115
            };
            uint32_t                     Value;
        } DW460;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue115                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_115
                uint32_t                 InverseRChGammaCorrectedValue115                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_115
            };
            uint32_t                     Value;
        } DW461;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue115                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_115
                uint32_t                 ForwardBChGammaCorrectedValue115                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_115
            };
            uint32_t                     Value;
        } DW462;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue115                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_115
                uint32_t                 ForwardRChGammaCorrectedValue115                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_115
            };
            uint32_t                     Value;
        } DW463;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue116                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_116
                uint32_t                 InverseBChGammaCorrectedValue116                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_116
            };
            uint32_t                     Value;
        } DW464;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue116                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_116
                uint32_t                 InverseRChGammaCorrectedValue116                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_116
            };
            uint32_t                     Value;
        } DW465;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue116                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_116
                uint32_t                 ForwardBChGammaCorrectedValue116                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_116
            };
            uint32_t                     Value;
        } DW466;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue116                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_116
                uint32_t                 ForwardRChGammaCorrectedValue116                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_116
            };
            uint32_t                     Value;
        } DW467;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue117                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_117
                uint32_t                 InverseBChGammaCorrectedValue117                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_117
            };
            uint32_t                     Value;
        } DW468;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue117                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_117
                uint32_t                 InverseRChGammaCorrectedValue117                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_117
            };
            uint32_t                     Value;
        } DW469;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue117                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_117
                uint32_t                 ForwardBChGammaCorrectedValue117                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_117
            };
            uint32_t                     Value;
        } DW470;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue117                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_117
                uint32_t                 ForwardRChGammaCorrectedValue117                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_117
            };
            uint32_t                     Value;
        } DW471;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue118                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_118
                uint32_t                 InverseBChGammaCorrectedValue118                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_118
            };
            uint32_t                     Value;
        } DW472;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue118                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_118
                uint32_t                 InverseRChGammaCorrectedValue118                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_118
            };
            uint32_t                     Value;
        } DW473;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue118                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_118
                uint32_t                 ForwardBChGammaCorrectedValue118                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_118
            };
            uint32_t                     Value;
        } DW474;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue118                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_118
                uint32_t                 ForwardRChGammaCorrectedValue118                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_118
            };
            uint32_t                     Value;
        } DW475;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue119                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_119
                uint32_t                 InverseBChGammaCorrectedValue119                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_119
            };
            uint32_t                     Value;
        } DW476;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue119                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_119
                uint32_t                 InverseRChGammaCorrectedValue119                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_119
            };
            uint32_t                     Value;
        } DW477;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue119                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_119
                uint32_t                 ForwardBChGammaCorrectedValue119                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_119
            };
            uint32_t                     Value;
        } DW478;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue119                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_119
                uint32_t                 ForwardRChGammaCorrectedValue119                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_119
            };
            uint32_t                     Value;
        } DW479;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue120                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_120
                uint32_t                 InverseBChGammaCorrectedValue120                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_120
            };
            uint32_t                     Value;
        } DW480;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue120                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_120
                uint32_t                 InverseRChGammaCorrectedValue120                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_120
            };
            uint32_t                     Value;
        } DW481;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue120                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_120
                uint32_t                 ForwardBChGammaCorrectedValue120                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_120
            };
            uint32_t                     Value;
        } DW482;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue120                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_120
                uint32_t                 ForwardRChGammaCorrectedValue120                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_120
            };
            uint32_t                     Value;
        } DW483;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue121                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_121
                uint32_t                 InverseBChGammaCorrectedValue121                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_121
            };
            uint32_t                     Value;
        } DW484;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue121                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_121
                uint32_t                 InverseRChGammaCorrectedValue121                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_121
            };
            uint32_t                     Value;
        } DW485;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue121                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_121
                uint32_t                 ForwardBChGammaCorrectedValue121                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_121
            };
            uint32_t                     Value;
        } DW486;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue121                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_121
                uint32_t                 ForwardRChGammaCorrectedValue121                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_121
            };
            uint32_t                     Value;
        } DW487;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue122                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_122
                uint32_t                 InverseBChGammaCorrectedValue122                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_122
            };
            uint32_t                     Value;
        } DW488;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue122                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_122
                uint32_t                 InverseRChGammaCorrectedValue122                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_122
            };
            uint32_t                     Value;
        } DW489;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue122                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_122
                uint32_t                 ForwardBChGammaCorrectedValue122                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_122
            };
            uint32_t                     Value;
        } DW490;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue122                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_122
                uint32_t                 ForwardRChGammaCorrectedValue122                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_122
            };
            uint32_t                     Value;
        } DW491;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue123                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_123
                uint32_t                 InverseBChGammaCorrectedValue123                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_123
            };
            uint32_t                     Value;
        } DW492;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue123                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_123
                uint32_t                 InverseRChGammaCorrectedValue123                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_123
            };
            uint32_t                     Value;
        } DW493;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue123                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_123
                uint32_t                 ForwardBChGammaCorrectedValue123                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_123
            };
            uint32_t                     Value;
        } DW494;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue123                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_123
                uint32_t                 ForwardRChGammaCorrectedValue123                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_123
            };
            uint32_t                     Value;
        } DW495;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue124                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_124
                uint32_t                 InverseBChGammaCorrectedValue124                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_124
            };
            uint32_t                     Value;
        } DW496;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue124                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_124
                uint32_t                 InverseRChGammaCorrectedValue124                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_124
            };
            uint32_t                     Value;
        } DW497;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue124                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_124
                uint32_t                 ForwardBChGammaCorrectedValue124                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_124
            };
            uint32_t                     Value;
        } DW498;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue124                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_124
                uint32_t                 ForwardRChGammaCorrectedValue124                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_124
            };
            uint32_t                     Value;
        } DW499;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue125                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_125
                uint32_t                 InverseBChGammaCorrectedValue125                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_125
            };
            uint32_t                     Value;
        } DW500;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue125                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_125
                uint32_t                 InverseRChGammaCorrectedValue125                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_125
            };
            uint32_t                     Value;
        } DW501;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue125                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_125
                uint32_t                 ForwardBChGammaCorrectedValue125                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_125
            };
            uint32_t                     Value;
        } DW502;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue125                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_125
                uint32_t                 ForwardRChGammaCorrectedValue125                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_125
            };
            uint32_t                     Value;
        } DW503;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue126                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_126
                uint32_t                 InverseBChGammaCorrectedValue126                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_126
            };
            uint32_t                     Value;
        } DW504;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue126                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_126
                uint32_t                 InverseRChGammaCorrectedValue126                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_126
            };
            uint32_t                     Value;
        } DW505;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue126                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_126
                uint32_t                 ForwardBChGammaCorrectedValue126                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_126
            };
            uint32_t                     Value;
        } DW506;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue126                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_126
                uint32_t                 ForwardRChGammaCorrectedValue126                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_126
            };
            uint32_t                     Value;
        } DW507;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue127                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_127
                uint32_t                 InverseBChGammaCorrectedValue127                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_127
            };
            uint32_t                     Value;
        } DW508;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue127                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_127
                uint32_t                 InverseRChGammaCorrectedValue127                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_127
            };
            uint32_t                     Value;
        } DW509;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue127                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_127
                uint32_t                 ForwardBChGammaCorrectedValue127                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_127
            };
            uint32_t                     Value;
        } DW510;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue127                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_127
                uint32_t                 ForwardRChGammaCorrectedValue127                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_127
            };
            uint32_t                     Value;
        } DW511;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue128                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_128
                uint32_t                 InverseBChGammaCorrectedValue128                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_128
            };
            uint32_t                     Value;
        } DW512;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue128                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_128
                uint32_t                 InverseRChGammaCorrectedValue128                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_128
            };
            uint32_t                     Value;
        } DW513;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue128                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_128
                uint32_t                 ForwardBChGammaCorrectedValue128                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_128
            };
            uint32_t                     Value;
        } DW514;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue128                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_128
                uint32_t                 ForwardRChGammaCorrectedValue128                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_128
            };
            uint32_t                     Value;
        } DW515;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue129                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_129
                uint32_t                 InverseBChGammaCorrectedValue129                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_129
            };
            uint32_t                     Value;
        } DW516;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue129                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_129
                uint32_t                 InverseRChGammaCorrectedValue129                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_129
            };
            uint32_t                     Value;
        } DW517;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue129                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_129
                uint32_t                 ForwardBChGammaCorrectedValue129                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_129
            };
            uint32_t                     Value;
        } DW518;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue129                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_129
                uint32_t                 ForwardRChGammaCorrectedValue129                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_129
            };
            uint32_t                     Value;
        } DW519;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue130                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_130
                uint32_t                 InverseBChGammaCorrectedValue130                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_130
            };
            uint32_t                     Value;
        } DW520;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue130                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_130
                uint32_t                 InverseRChGammaCorrectedValue130                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_130
            };
            uint32_t                     Value;
        } DW521;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue130                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_130
                uint32_t                 ForwardBChGammaCorrectedValue130                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_130
            };
            uint32_t                     Value;
        } DW522;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue130                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_130
                uint32_t                 ForwardRChGammaCorrectedValue130                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_130
            };
            uint32_t                     Value;
        } DW523;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue131                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_131
                uint32_t                 InverseBChGammaCorrectedValue131                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_131
            };
            uint32_t                     Value;
        } DW524;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue131                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_131
                uint32_t                 InverseRChGammaCorrectedValue131                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_131
            };
            uint32_t                     Value;
        } DW525;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue131                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_131
                uint32_t                 ForwardBChGammaCorrectedValue131                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_131
            };
            uint32_t                     Value;
        } DW526;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue131                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_131
                uint32_t                 ForwardRChGammaCorrectedValue131                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_131
            };
            uint32_t                     Value;
        } DW527;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue132                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_132
                uint32_t                 InverseBChGammaCorrectedValue132                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_132
            };
            uint32_t                     Value;
        } DW528;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue132                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_132
                uint32_t                 InverseRChGammaCorrectedValue132                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_132
            };
            uint32_t                     Value;
        } DW529;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue132                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_132
                uint32_t                 ForwardBChGammaCorrectedValue132                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_132
            };
            uint32_t                     Value;
        } DW530;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue132                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_132
                uint32_t                 ForwardRChGammaCorrectedValue132                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_132
            };
            uint32_t                     Value;
        } DW531;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue133                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_133
                uint32_t                 InverseBChGammaCorrectedValue133                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_133
            };
            uint32_t                     Value;
        } DW532;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue133                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_133
                uint32_t                 InverseRChGammaCorrectedValue133                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_133
            };
            uint32_t                     Value;
        } DW533;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue133                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_133
                uint32_t                 ForwardBChGammaCorrectedValue133                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_133
            };
            uint32_t                     Value;
        } DW534;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue133                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_133
                uint32_t                 ForwardRChGammaCorrectedValue133                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_133
            };
            uint32_t                     Value;
        } DW535;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue134                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_134
                uint32_t                 InverseBChGammaCorrectedValue134                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_134
            };
            uint32_t                     Value;
        } DW536;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue134                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_134
                uint32_t                 InverseRChGammaCorrectedValue134                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_134
            };
            uint32_t                     Value;
        } DW537;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue134                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_134
                uint32_t                 ForwardBChGammaCorrectedValue134                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_134
            };
            uint32_t                     Value;
        } DW538;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue134                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_134
                uint32_t                 ForwardRChGammaCorrectedValue134                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_134
            };
            uint32_t                     Value;
        } DW539;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue135                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_135
                uint32_t                 InverseBChGammaCorrectedValue135                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_135
            };
            uint32_t                     Value;
        } DW540;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue135                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_135
                uint32_t                 InverseRChGammaCorrectedValue135                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_135
            };
            uint32_t                     Value;
        } DW541;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue135                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_135
                uint32_t                 ForwardBChGammaCorrectedValue135                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_135
            };
            uint32_t                     Value;
        } DW542;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue135                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_135
                uint32_t                 ForwardRChGammaCorrectedValue135                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_135
            };
            uint32_t                     Value;
        } DW543;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue136                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_136
                uint32_t                 InverseBChGammaCorrectedValue136                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_136
            };
            uint32_t                     Value;
        } DW544;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue136                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_136
                uint32_t                 InverseRChGammaCorrectedValue136                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_136
            };
            uint32_t                     Value;
        } DW545;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue136                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_136
                uint32_t                 ForwardBChGammaCorrectedValue136                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_136
            };
            uint32_t                     Value;
        } DW546;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue136                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_136
                uint32_t                 ForwardRChGammaCorrectedValue136                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_136
            };
            uint32_t                     Value;
        } DW547;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue137                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_137
                uint32_t                 InverseBChGammaCorrectedValue137                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_137
            };
            uint32_t                     Value;
        } DW548;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue137                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_137
                uint32_t                 InverseRChGammaCorrectedValue137                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_137
            };
            uint32_t                     Value;
        } DW549;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue137                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_137
                uint32_t                 ForwardBChGammaCorrectedValue137                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_137
            };
            uint32_t                     Value;
        } DW550;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue137                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_137
                uint32_t                 ForwardRChGammaCorrectedValue137                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_137
            };
            uint32_t                     Value;
        } DW551;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue138                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_138
                uint32_t                 InverseBChGammaCorrectedValue138                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_138
            };
            uint32_t                     Value;
        } DW552;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue138                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_138
                uint32_t                 InverseRChGammaCorrectedValue138                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_138
            };
            uint32_t                     Value;
        } DW553;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue138                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_138
                uint32_t                 ForwardBChGammaCorrectedValue138                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_138
            };
            uint32_t                     Value;
        } DW554;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue138                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_138
                uint32_t                 ForwardRChGammaCorrectedValue138                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_138
            };
            uint32_t                     Value;
        } DW555;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue139                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_139
                uint32_t                 InverseBChGammaCorrectedValue139                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_139
            };
            uint32_t                     Value;
        } DW556;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue139                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_139
                uint32_t                 InverseRChGammaCorrectedValue139                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_139
            };
            uint32_t                     Value;
        } DW557;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue139                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_139
                uint32_t                 ForwardBChGammaCorrectedValue139                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_139
            };
            uint32_t                     Value;
        } DW558;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue139                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_139
                uint32_t                 ForwardRChGammaCorrectedValue139                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_139
            };
            uint32_t                     Value;
        } DW559;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue140                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_140
                uint32_t                 InverseBChGammaCorrectedValue140                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_140
            };
            uint32_t                     Value;
        } DW560;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue140                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_140
                uint32_t                 InverseRChGammaCorrectedValue140                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_140
            };
            uint32_t                     Value;
        } DW561;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue140                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_140
                uint32_t                 ForwardBChGammaCorrectedValue140                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_140
            };
            uint32_t                     Value;
        } DW562;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue140                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_140
                uint32_t                 ForwardRChGammaCorrectedValue140                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_140
            };
            uint32_t                     Value;
        } DW563;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue141                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_141
                uint32_t                 InverseBChGammaCorrectedValue141                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_141
            };
            uint32_t                     Value;
        } DW564;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue141                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_141
                uint32_t                 InverseRChGammaCorrectedValue141                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_141
            };
            uint32_t                     Value;
        } DW565;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue141                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_141
                uint32_t                 ForwardBChGammaCorrectedValue141                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_141
            };
            uint32_t                     Value;
        } DW566;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue141                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_141
                uint32_t                 ForwardRChGammaCorrectedValue141                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_141
            };
            uint32_t                     Value;
        } DW567;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue142                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_142
                uint32_t                 InverseBChGammaCorrectedValue142                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_142
            };
            uint32_t                     Value;
        } DW568;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue142                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_142
                uint32_t                 InverseRChGammaCorrectedValue142                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_142
            };
            uint32_t                     Value;
        } DW569;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue142                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_142
                uint32_t                 ForwardBChGammaCorrectedValue142                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_142
            };
            uint32_t                     Value;
        } DW570;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue142                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_142
                uint32_t                 ForwardRChGammaCorrectedValue142                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_142
            };
            uint32_t                     Value;
        } DW571;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue143                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_143
                uint32_t                 InverseBChGammaCorrectedValue143                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_143
            };
            uint32_t                     Value;
        } DW572;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue143                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_143
                uint32_t                 InverseRChGammaCorrectedValue143                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_143
            };
            uint32_t                     Value;
        } DW573;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue143                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_143
                uint32_t                 ForwardBChGammaCorrectedValue143                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_143
            };
            uint32_t                     Value;
        } DW574;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue143                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_143
                uint32_t                 ForwardRChGammaCorrectedValue143                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_143
            };
            uint32_t                     Value;
        } DW575;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue144                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_144
                uint32_t                 InverseBChGammaCorrectedValue144                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_144
            };
            uint32_t                     Value;
        } DW576;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue144                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_144
                uint32_t                 InverseRChGammaCorrectedValue144                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_144
            };
            uint32_t                     Value;
        } DW577;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue144                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_144
                uint32_t                 ForwardBChGammaCorrectedValue144                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_144
            };
            uint32_t                     Value;
        } DW578;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue144                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_144
                uint32_t                 ForwardRChGammaCorrectedValue144                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_144
            };
            uint32_t                     Value;
        } DW579;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue145                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_145
                uint32_t                 InverseBChGammaCorrectedValue145                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_145
            };
            uint32_t                     Value;
        } DW580;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue145                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_145
                uint32_t                 InverseRChGammaCorrectedValue145                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_145
            };
            uint32_t                     Value;
        } DW581;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue145                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_145
                uint32_t                 ForwardBChGammaCorrectedValue145                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_145
            };
            uint32_t                     Value;
        } DW582;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue145                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_145
                uint32_t                 ForwardRChGammaCorrectedValue145                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_145
            };
            uint32_t                     Value;
        } DW583;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue146                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_146
                uint32_t                 InverseBChGammaCorrectedValue146                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_146
            };
            uint32_t                     Value;
        } DW584;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue146                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_146
                uint32_t                 InverseRChGammaCorrectedValue146                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_146
            };
            uint32_t                     Value;
        } DW585;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue146                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_146
                uint32_t                 ForwardBChGammaCorrectedValue146                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_146
            };
            uint32_t                     Value;
        } DW586;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue146                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_146
                uint32_t                 ForwardRChGammaCorrectedValue146                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_146
            };
            uint32_t                     Value;
        } DW587;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue147                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_147
                uint32_t                 InverseBChGammaCorrectedValue147                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_147
            };
            uint32_t                     Value;
        } DW588;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue147                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_147
                uint32_t                 InverseRChGammaCorrectedValue147                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_147
            };
            uint32_t                     Value;
        } DW589;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue147                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_147
                uint32_t                 ForwardBChGammaCorrectedValue147                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_147
            };
            uint32_t                     Value;
        } DW590;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue147                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_147
                uint32_t                 ForwardRChGammaCorrectedValue147                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_147
            };
            uint32_t                     Value;
        } DW591;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue148                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_148
                uint32_t                 InverseBChGammaCorrectedValue148                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_148
            };
            uint32_t                     Value;
        } DW592;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue148                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_148
                uint32_t                 InverseRChGammaCorrectedValue148                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_148
            };
            uint32_t                     Value;
        } DW593;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue148                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_148
                uint32_t                 ForwardBChGammaCorrectedValue148                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_148
            };
            uint32_t                     Value;
        } DW594;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue148                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_148
                uint32_t                 ForwardRChGammaCorrectedValue148                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_148
            };
            uint32_t                     Value;
        } DW595;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue149                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_149
                uint32_t                 InverseBChGammaCorrectedValue149                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_149
            };
            uint32_t                     Value;
        } DW596;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue149                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_149
                uint32_t                 InverseRChGammaCorrectedValue149                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_149
            };
            uint32_t                     Value;
        } DW597;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue149                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_149
                uint32_t                 ForwardBChGammaCorrectedValue149                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_149
            };
            uint32_t                     Value;
        } DW598;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue149                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_149
                uint32_t                 ForwardRChGammaCorrectedValue149                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_149
            };
            uint32_t                     Value;
        } DW599;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue150                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_150
                uint32_t                 InverseBChGammaCorrectedValue150                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_150
            };
            uint32_t                     Value;
        } DW600;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue150                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_150
                uint32_t                 InverseRChGammaCorrectedValue150                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_150
            };
            uint32_t                     Value;
        } DW601;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue150                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_150
                uint32_t                 ForwardBChGammaCorrectedValue150                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_150
            };
            uint32_t                     Value;
        } DW602;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue150                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_150
                uint32_t                 ForwardRChGammaCorrectedValue150                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_150
            };
            uint32_t                     Value;
        } DW603;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue151                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_151
                uint32_t                 InverseBChGammaCorrectedValue151                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_151
            };
            uint32_t                     Value;
        } DW604;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue151                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_151
                uint32_t                 InverseRChGammaCorrectedValue151                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_151
            };
            uint32_t                     Value;
        } DW605;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue151                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_151
                uint32_t                 ForwardBChGammaCorrectedValue151                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_151
            };
            uint32_t                     Value;
        } DW606;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue151                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_151
                uint32_t                 ForwardRChGammaCorrectedValue151                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_151
            };
            uint32_t                     Value;
        } DW607;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue152                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_152
                uint32_t                 InverseBChGammaCorrectedValue152                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_152
            };
            uint32_t                     Value;
        } DW608;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue152                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_152
                uint32_t                 InverseRChGammaCorrectedValue152                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_152
            };
            uint32_t                     Value;
        } DW609;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue152                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_152
                uint32_t                 ForwardBChGammaCorrectedValue152                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_152
            };
            uint32_t                     Value;
        } DW610;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue152                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_152
                uint32_t                 ForwardRChGammaCorrectedValue152                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_152
            };
            uint32_t                     Value;
        } DW611;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue153                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_153
                uint32_t                 InverseBChGammaCorrectedValue153                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_153
            };
            uint32_t                     Value;
        } DW612;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue153                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_153
                uint32_t                 InverseRChGammaCorrectedValue153                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_153
            };
            uint32_t                     Value;
        } DW613;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue153                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_153
                uint32_t                 ForwardBChGammaCorrectedValue153                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_153
            };
            uint32_t                     Value;
        } DW614;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue153                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_153
                uint32_t                 ForwardRChGammaCorrectedValue153                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_153
            };
            uint32_t                     Value;
        } DW615;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue154                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_154
                uint32_t                 InverseBChGammaCorrectedValue154                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_154
            };
            uint32_t                     Value;
        } DW616;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue154                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_154
                uint32_t                 InverseRChGammaCorrectedValue154                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_154
            };
            uint32_t                     Value;
        } DW617;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue154                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_154
                uint32_t                 ForwardBChGammaCorrectedValue154                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_154
            };
            uint32_t                     Value;
        } DW618;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue154                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_154
                uint32_t                 ForwardRChGammaCorrectedValue154                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_154
            };
            uint32_t                     Value;
        } DW619;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue155                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_155
                uint32_t                 InverseBChGammaCorrectedValue155                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_155
            };
            uint32_t                     Value;
        } DW620;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue155                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_155
                uint32_t                 InverseRChGammaCorrectedValue155                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_155
            };
            uint32_t                     Value;
        } DW621;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue155                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_155
                uint32_t                 ForwardBChGammaCorrectedValue155                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_155
            };
            uint32_t                     Value;
        } DW622;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue155                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_155
                uint32_t                 ForwardRChGammaCorrectedValue155                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_155
            };
            uint32_t                     Value;
        } DW623;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue156                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_156
                uint32_t                 InverseBChGammaCorrectedValue156                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_156
            };
            uint32_t                     Value;
        } DW624;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue156                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_156
                uint32_t                 InverseRChGammaCorrectedValue156                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_156
            };
            uint32_t                     Value;
        } DW625;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue156                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_156
                uint32_t                 ForwardBChGammaCorrectedValue156                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_156
            };
            uint32_t                     Value;
        } DW626;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue156                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_156
                uint32_t                 ForwardRChGammaCorrectedValue156                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_156
            };
            uint32_t                     Value;
        } DW627;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue157                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_157
                uint32_t                 InverseBChGammaCorrectedValue157                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_157
            };
            uint32_t                     Value;
        } DW628;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue157                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_157
                uint32_t                 InverseRChGammaCorrectedValue157                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_157
            };
            uint32_t                     Value;
        } DW629;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue157                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_157
                uint32_t                 ForwardBChGammaCorrectedValue157                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_157
            };
            uint32_t                     Value;
        } DW630;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue157                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_157
                uint32_t                 ForwardRChGammaCorrectedValue157                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_157
            };
            uint32_t                     Value;
        } DW631;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue158                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_158
                uint32_t                 InverseBChGammaCorrectedValue158                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_158
            };
            uint32_t                     Value;
        } DW632;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue158                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_158
                uint32_t                 InverseRChGammaCorrectedValue158                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_158
            };
            uint32_t                     Value;
        } DW633;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue158                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_158
                uint32_t                 ForwardBChGammaCorrectedValue158                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_158
            };
            uint32_t                     Value;
        } DW634;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue158                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_158
                uint32_t                 ForwardRChGammaCorrectedValue158                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_158
            };
            uint32_t                     Value;
        } DW635;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue159                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_159
                uint32_t                 InverseBChGammaCorrectedValue159                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_159
            };
            uint32_t                     Value;
        } DW636;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue159                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_159
                uint32_t                 InverseRChGammaCorrectedValue159                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_159
            };
            uint32_t                     Value;
        } DW637;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue159                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_159
                uint32_t                 ForwardBChGammaCorrectedValue159                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_159
            };
            uint32_t                     Value;
        } DW638;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue159                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_159
                uint32_t                 ForwardRChGammaCorrectedValue159                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_159
            };
            uint32_t                     Value;
        } DW639;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue160                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_160
                uint32_t                 InverseBChGammaCorrectedValue160                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_160
            };
            uint32_t                     Value;
        } DW640;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue160                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_160
                uint32_t                 InverseRChGammaCorrectedValue160                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_160
            };
            uint32_t                     Value;
        } DW641;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue160                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_160
                uint32_t                 ForwardBChGammaCorrectedValue160                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_160
            };
            uint32_t                     Value;
        } DW642;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue160                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_160
                uint32_t                 ForwardRChGammaCorrectedValue160                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_160
            };
            uint32_t                     Value;
        } DW643;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue161                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_161
                uint32_t                 InverseBChGammaCorrectedValue161                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_161
            };
            uint32_t                     Value;
        } DW644;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue161                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_161
                uint32_t                 InverseRChGammaCorrectedValue161                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_161
            };
            uint32_t                     Value;
        } DW645;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue161                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_161
                uint32_t                 ForwardBChGammaCorrectedValue161                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_161
            };
            uint32_t                     Value;
        } DW646;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue161                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_161
                uint32_t                 ForwardRChGammaCorrectedValue161                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_161
            };
            uint32_t                     Value;
        } DW647;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue162                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_162
                uint32_t                 InverseBChGammaCorrectedValue162                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_162
            };
            uint32_t                     Value;
        } DW648;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue162                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_162
                uint32_t                 InverseRChGammaCorrectedValue162                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_162
            };
            uint32_t                     Value;
        } DW649;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue162                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_162
                uint32_t                 ForwardBChGammaCorrectedValue162                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_162
            };
            uint32_t                     Value;
        } DW650;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue162                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_162
                uint32_t                 ForwardRChGammaCorrectedValue162                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_162
            };
            uint32_t                     Value;
        } DW651;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue163                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_163
                uint32_t                 InverseBChGammaCorrectedValue163                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_163
            };
            uint32_t                     Value;
        } DW652;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue163                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_163
                uint32_t                 InverseRChGammaCorrectedValue163                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_163
            };
            uint32_t                     Value;
        } DW653;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue163                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_163
                uint32_t                 ForwardBChGammaCorrectedValue163                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_163
            };
            uint32_t                     Value;
        } DW654;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue163                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_163
                uint32_t                 ForwardRChGammaCorrectedValue163                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_163
            };
            uint32_t                     Value;
        } DW655;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue164                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_164
                uint32_t                 InverseBChGammaCorrectedValue164                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_164
            };
            uint32_t                     Value;
        } DW656;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue164                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_164
                uint32_t                 InverseRChGammaCorrectedValue164                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_164
            };
            uint32_t                     Value;
        } DW657;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue164                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_164
                uint32_t                 ForwardBChGammaCorrectedValue164                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_164
            };
            uint32_t                     Value;
        } DW658;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue164                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_164
                uint32_t                 ForwardRChGammaCorrectedValue164                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_164
            };
            uint32_t                     Value;
        } DW659;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue165                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_165
                uint32_t                 InverseBChGammaCorrectedValue165                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_165
            };
            uint32_t                     Value;
        } DW660;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue165                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_165
                uint32_t                 InverseRChGammaCorrectedValue165                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_165
            };
            uint32_t                     Value;
        } DW661;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue165                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_165
                uint32_t                 ForwardBChGammaCorrectedValue165                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_165
            };
            uint32_t                     Value;
        } DW662;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue165                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_165
                uint32_t                 ForwardRChGammaCorrectedValue165                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_165
            };
            uint32_t                     Value;
        } DW663;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue166                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_166
                uint32_t                 InverseBChGammaCorrectedValue166                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_166
            };
            uint32_t                     Value;
        } DW664;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue166                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_166
                uint32_t                 InverseRChGammaCorrectedValue166                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_166
            };
            uint32_t                     Value;
        } DW665;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue166                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_166
                uint32_t                 ForwardBChGammaCorrectedValue166                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_166
            };
            uint32_t                     Value;
        } DW666;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue166                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_166
                uint32_t                 ForwardRChGammaCorrectedValue166                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_166
            };
            uint32_t                     Value;
        } DW667;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue167                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_167
                uint32_t                 InverseBChGammaCorrectedValue167                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_167
            };
            uint32_t                     Value;
        } DW668;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue167                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_167
                uint32_t                 InverseRChGammaCorrectedValue167                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_167
            };
            uint32_t                     Value;
        } DW669;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue167                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_167
                uint32_t                 ForwardBChGammaCorrectedValue167                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_167
            };
            uint32_t                     Value;
        } DW670;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue167                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_167
                uint32_t                 ForwardRChGammaCorrectedValue167                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_167
            };
            uint32_t                     Value;
        } DW671;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue168                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_168
                uint32_t                 InverseBChGammaCorrectedValue168                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_168
            };
            uint32_t                     Value;
        } DW672;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue168                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_168
                uint32_t                 InverseRChGammaCorrectedValue168                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_168
            };
            uint32_t                     Value;
        } DW673;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue168                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_168
                uint32_t                 ForwardBChGammaCorrectedValue168                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_168
            };
            uint32_t                     Value;
        } DW674;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue168                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_168
                uint32_t                 ForwardRChGammaCorrectedValue168                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_168
            };
            uint32_t                     Value;
        } DW675;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue169                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_169
                uint32_t                 InverseBChGammaCorrectedValue169                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_169
            };
            uint32_t                     Value;
        } DW676;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue169                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_169
                uint32_t                 InverseRChGammaCorrectedValue169                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_169
            };
            uint32_t                     Value;
        } DW677;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue169                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_169
                uint32_t                 ForwardBChGammaCorrectedValue169                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_169
            };
            uint32_t                     Value;
        } DW678;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue169                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_169
                uint32_t                 ForwardRChGammaCorrectedValue169                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_169
            };
            uint32_t                     Value;
        } DW679;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue170                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_170
                uint32_t                 InverseBChGammaCorrectedValue170                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_170
            };
            uint32_t                     Value;
        } DW680;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue170                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_170
                uint32_t                 InverseRChGammaCorrectedValue170                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_170
            };
            uint32_t                     Value;
        } DW681;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue170                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_170
                uint32_t                 ForwardBChGammaCorrectedValue170                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_170
            };
            uint32_t                     Value;
        } DW682;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue170                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_170
                uint32_t                 ForwardRChGammaCorrectedValue170                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_170
            };
            uint32_t                     Value;
        } DW683;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue171                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_171
                uint32_t                 InverseBChGammaCorrectedValue171                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_171
            };
            uint32_t                     Value;
        } DW684;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue171                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_171
                uint32_t                 InverseRChGammaCorrectedValue171                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_171
            };
            uint32_t                     Value;
        } DW685;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue171                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_171
                uint32_t                 ForwardBChGammaCorrectedValue171                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_171
            };
            uint32_t                     Value;
        } DW686;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue171                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_171
                uint32_t                 ForwardRChGammaCorrectedValue171                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_171
            };
            uint32_t                     Value;
        } DW687;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue172                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_172
                uint32_t                 InverseBChGammaCorrectedValue172                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_172
            };
            uint32_t                     Value;
        } DW688;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue172                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_172
                uint32_t                 InverseRChGammaCorrectedValue172                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_172
            };
            uint32_t                     Value;
        } DW689;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue172                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_172
                uint32_t                 ForwardBChGammaCorrectedValue172                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_172
            };
            uint32_t                     Value;
        } DW690;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue172                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_172
                uint32_t                 ForwardRChGammaCorrectedValue172                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_172
            };
            uint32_t                     Value;
        } DW691;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue173                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_173
                uint32_t                 InverseBChGammaCorrectedValue173                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_173
            };
            uint32_t                     Value;
        } DW692;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue173                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_173
                uint32_t                 InverseRChGammaCorrectedValue173                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_173
            };
            uint32_t                     Value;
        } DW693;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue173                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_173
                uint32_t                 ForwardBChGammaCorrectedValue173                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_173
            };
            uint32_t                     Value;
        } DW694;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue173                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_173
                uint32_t                 ForwardRChGammaCorrectedValue173                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_173
            };
            uint32_t                     Value;
        } DW695;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue174                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_174
                uint32_t                 InverseBChGammaCorrectedValue174                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_174
            };
            uint32_t                     Value;
        } DW696;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue174                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_174
                uint32_t                 InverseRChGammaCorrectedValue174                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_174
            };
            uint32_t                     Value;
        } DW697;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue174                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_174
                uint32_t                 ForwardBChGammaCorrectedValue174                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_174
            };
            uint32_t                     Value;
        } DW698;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue174                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_174
                uint32_t                 ForwardRChGammaCorrectedValue174                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_174
            };
            uint32_t                     Value;
        } DW699;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue175                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_175
                uint32_t                 InverseBChGammaCorrectedValue175                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_175
            };
            uint32_t                     Value;
        } DW700;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue175                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_175
                uint32_t                 InverseRChGammaCorrectedValue175                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_175
            };
            uint32_t                     Value;
        } DW701;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue175                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_175
                uint32_t                 ForwardBChGammaCorrectedValue175                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_175
            };
            uint32_t                     Value;
        } DW702;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue175                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_175
                uint32_t                 ForwardRChGammaCorrectedValue175                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_175
            };
            uint32_t                     Value;
        } DW703;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue176                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_176
                uint32_t                 InverseBChGammaCorrectedValue176                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_176
            };
            uint32_t                     Value;
        } DW704;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue176                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_176
                uint32_t                 InverseRChGammaCorrectedValue176                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_176
            };
            uint32_t                     Value;
        } DW705;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue176                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_176
                uint32_t                 ForwardBChGammaCorrectedValue176                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_176
            };
            uint32_t                     Value;
        } DW706;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue176                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_176
                uint32_t                 ForwardRChGammaCorrectedValue176                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_176
            };
            uint32_t                     Value;
        } DW707;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue177                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_177
                uint32_t                 InverseBChGammaCorrectedValue177                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_177
            };
            uint32_t                     Value;
        } DW708;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue177                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_177
                uint32_t                 InverseRChGammaCorrectedValue177                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_177
            };
            uint32_t                     Value;
        } DW709;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue177                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_177
                uint32_t                 ForwardBChGammaCorrectedValue177                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_177
            };
            uint32_t                     Value;
        } DW710;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue177                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_177
                uint32_t                 ForwardRChGammaCorrectedValue177                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_177
            };
            uint32_t                     Value;
        } DW711;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue178                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_178
                uint32_t                 InverseBChGammaCorrectedValue178                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_178
            };
            uint32_t                     Value;
        } DW712;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue178                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_178
                uint32_t                 InverseRChGammaCorrectedValue178                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_178
            };
            uint32_t                     Value;
        } DW713;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue178                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_178
                uint32_t                 ForwardBChGammaCorrectedValue178                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_178
            };
            uint32_t                     Value;
        } DW714;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue178                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_178
                uint32_t                 ForwardRChGammaCorrectedValue178                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_178
            };
            uint32_t                     Value;
        } DW715;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue179                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_179
                uint32_t                 InverseBChGammaCorrectedValue179                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_179
            };
            uint32_t                     Value;
        } DW716;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue179                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_179
                uint32_t                 InverseRChGammaCorrectedValue179                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_179
            };
            uint32_t                     Value;
        } DW717;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue179                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_179
                uint32_t                 ForwardBChGammaCorrectedValue179                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_179
            };
            uint32_t                     Value;
        } DW718;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue179                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_179
                uint32_t                 ForwardRChGammaCorrectedValue179                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_179
            };
            uint32_t                     Value;
        } DW719;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue180                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_180
                uint32_t                 InverseBChGammaCorrectedValue180                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_180
            };
            uint32_t                     Value;
        } DW720;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue180                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_180
                uint32_t                 InverseRChGammaCorrectedValue180                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_180
            };
            uint32_t                     Value;
        } DW721;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue180                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_180
                uint32_t                 ForwardBChGammaCorrectedValue180                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_180
            };
            uint32_t                     Value;
        } DW722;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue180                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_180
                uint32_t                 ForwardRChGammaCorrectedValue180                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_180
            };
            uint32_t                     Value;
        } DW723;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue181                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_181
                uint32_t                 InverseBChGammaCorrectedValue181                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_181
            };
            uint32_t                     Value;
        } DW724;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue181                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_181
                uint32_t                 InverseRChGammaCorrectedValue181                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_181
            };
            uint32_t                     Value;
        } DW725;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue181                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_181
                uint32_t                 ForwardBChGammaCorrectedValue181                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_181
            };
            uint32_t                     Value;
        } DW726;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue181                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_181
                uint32_t                 ForwardRChGammaCorrectedValue181                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_181
            };
            uint32_t                     Value;
        } DW727;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue182                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_182
                uint32_t                 InverseBChGammaCorrectedValue182                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_182
            };
            uint32_t                     Value;
        } DW728;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue182                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_182
                uint32_t                 InverseRChGammaCorrectedValue182                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_182
            };
            uint32_t                     Value;
        } DW729;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue182                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_182
                uint32_t                 ForwardBChGammaCorrectedValue182                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_182
            };
            uint32_t                     Value;
        } DW730;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue182                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_182
                uint32_t                 ForwardRChGammaCorrectedValue182                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_182
            };
            uint32_t                     Value;
        } DW731;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue183                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_183
                uint32_t                 InverseBChGammaCorrectedValue183                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_183
            };
            uint32_t                     Value;
        } DW732;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue183                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_183
                uint32_t                 InverseRChGammaCorrectedValue183                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_183
            };
            uint32_t                     Value;
        } DW733;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue183                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_183
                uint32_t                 ForwardBChGammaCorrectedValue183                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_183
            };
            uint32_t                     Value;
        } DW734;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue183                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_183
                uint32_t                 ForwardRChGammaCorrectedValue183                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_183
            };
            uint32_t                     Value;
        } DW735;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue184                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_184
                uint32_t                 InverseBChGammaCorrectedValue184                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_184
            };
            uint32_t                     Value;
        } DW736;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue184                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_184
                uint32_t                 InverseRChGammaCorrectedValue184                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_184
            };
            uint32_t                     Value;
        } DW737;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue184                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_184
                uint32_t                 ForwardBChGammaCorrectedValue184                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_184
            };
            uint32_t                     Value;
        } DW738;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue184                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_184
                uint32_t                 ForwardRChGammaCorrectedValue184                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_184
            };
            uint32_t                     Value;
        } DW739;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue185                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_185
                uint32_t                 InverseBChGammaCorrectedValue185                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_185
            };
            uint32_t                     Value;
        } DW740;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue185                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_185
                uint32_t                 InverseRChGammaCorrectedValue185                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_185
            };
            uint32_t                     Value;
        } DW741;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue185                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_185
                uint32_t                 ForwardBChGammaCorrectedValue185                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_185
            };
            uint32_t                     Value;
        } DW742;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue185                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_185
                uint32_t                 ForwardRChGammaCorrectedValue185                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_185
            };
            uint32_t                     Value;
        } DW743;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue186                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_186
                uint32_t                 InverseBChGammaCorrectedValue186                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_186
            };
            uint32_t                     Value;
        } DW744;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue186                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_186
                uint32_t                 InverseRChGammaCorrectedValue186                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_186
            };
            uint32_t                     Value;
        } DW745;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue186                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_186
                uint32_t                 ForwardBChGammaCorrectedValue186                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_186
            };
            uint32_t                     Value;
        } DW746;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue186                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_186
                uint32_t                 ForwardRChGammaCorrectedValue186                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_186
            };
            uint32_t                     Value;
        } DW747;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue187                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_187
                uint32_t                 InverseBChGammaCorrectedValue187                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_187
            };
            uint32_t                     Value;
        } DW748;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue187                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_187
                uint32_t                 InverseRChGammaCorrectedValue187                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_187
            };
            uint32_t                     Value;
        } DW749;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue187                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_187
                uint32_t                 ForwardBChGammaCorrectedValue187                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_187
            };
            uint32_t                     Value;
        } DW750;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue187                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_187
                uint32_t                 ForwardRChGammaCorrectedValue187                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_187
            };
            uint32_t                     Value;
        } DW751;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue188                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_188
                uint32_t                 InverseBChGammaCorrectedValue188                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_188
            };
            uint32_t                     Value;
        } DW752;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue188                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_188
                uint32_t                 InverseRChGammaCorrectedValue188                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_188
            };
            uint32_t                     Value;
        } DW753;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue188                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_188
                uint32_t                 ForwardBChGammaCorrectedValue188                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_188
            };
            uint32_t                     Value;
        } DW754;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue188                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_188
                uint32_t                 ForwardRChGammaCorrectedValue188                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_188
            };
            uint32_t                     Value;
        } DW755;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue189                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_189
                uint32_t                 InverseBChGammaCorrectedValue189                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_189
            };
            uint32_t                     Value;
        } DW756;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue189                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_189
                uint32_t                 InverseRChGammaCorrectedValue189                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_189
            };
            uint32_t                     Value;
        } DW757;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue189                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_189
                uint32_t                 ForwardBChGammaCorrectedValue189                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_189
            };
            uint32_t                     Value;
        } DW758;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue189                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_189
                uint32_t                 ForwardRChGammaCorrectedValue189                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_189
            };
            uint32_t                     Value;
        } DW759;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue190                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_190
                uint32_t                 InverseBChGammaCorrectedValue190                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_190
            };
            uint32_t                     Value;
        } DW760;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue190                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_190
                uint32_t                 InverseRChGammaCorrectedValue190                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_190
            };
            uint32_t                     Value;
        } DW761;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue190                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_190
                uint32_t                 ForwardBChGammaCorrectedValue190                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_190
            };
            uint32_t                     Value;
        } DW762;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue190                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_190
                uint32_t                 ForwardRChGammaCorrectedValue190                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_190
            };
            uint32_t                     Value;
        } DW763;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue191                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_191
                uint32_t                 InverseBChGammaCorrectedValue191                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_191
            };
            uint32_t                     Value;
        } DW764;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue191                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_191
                uint32_t                 InverseRChGammaCorrectedValue191                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_191
            };
            uint32_t                     Value;
        } DW765;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue191                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_191
                uint32_t                 ForwardBChGammaCorrectedValue191                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_191
            };
            uint32_t                     Value;
        } DW766;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue191                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_191
                uint32_t                 ForwardRChGammaCorrectedValue191                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_191
            };
            uint32_t                     Value;
        } DW767;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue192                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_192
                uint32_t                 InverseBChGammaCorrectedValue192                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_192
            };
            uint32_t                     Value;
        } DW768;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue192                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_192
                uint32_t                 InverseRChGammaCorrectedValue192                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_192
            };
            uint32_t                     Value;
        } DW769;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue192                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_192
                uint32_t                 ForwardBChGammaCorrectedValue192                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_192
            };
            uint32_t                     Value;
        } DW770;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue192                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_192
                uint32_t                 ForwardRChGammaCorrectedValue192                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_192
            };
            uint32_t                     Value;
        } DW771;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue193                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_193
                uint32_t                 InverseBChGammaCorrectedValue193                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_193
            };
            uint32_t                     Value;
        } DW772;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue193                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_193
                uint32_t                 InverseRChGammaCorrectedValue193                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_193
            };
            uint32_t                     Value;
        } DW773;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue193                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_193
                uint32_t                 ForwardBChGammaCorrectedValue193                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_193
            };
            uint32_t                     Value;
        } DW774;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue193                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_193
                uint32_t                 ForwardRChGammaCorrectedValue193                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_193
            };
            uint32_t                     Value;
        } DW775;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue194                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_194
                uint32_t                 InverseBChGammaCorrectedValue194                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_194
            };
            uint32_t                     Value;
        } DW776;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue194                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_194
                uint32_t                 InverseRChGammaCorrectedValue194                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_194
            };
            uint32_t                     Value;
        } DW777;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue194                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_194
                uint32_t                 ForwardBChGammaCorrectedValue194                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_194
            };
            uint32_t                     Value;
        } DW778;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue194                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_194
                uint32_t                 ForwardRChGammaCorrectedValue194                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_194
            };
            uint32_t                     Value;
        } DW779;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue195                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_195
                uint32_t                 InverseBChGammaCorrectedValue195                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_195
            };
            uint32_t                     Value;
        } DW780;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue195                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_195
                uint32_t                 InverseRChGammaCorrectedValue195                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_195
            };
            uint32_t                     Value;
        } DW781;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue195                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_195
                uint32_t                 ForwardBChGammaCorrectedValue195                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_195
            };
            uint32_t                     Value;
        } DW782;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue195                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_195
                uint32_t                 ForwardRChGammaCorrectedValue195                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_195
            };
            uint32_t                     Value;
        } DW783;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue196                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_196
                uint32_t                 InverseBChGammaCorrectedValue196                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_196
            };
            uint32_t                     Value;
        } DW784;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue196                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_196
                uint32_t                 InverseRChGammaCorrectedValue196                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_196
            };
            uint32_t                     Value;
        } DW785;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue196                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_196
                uint32_t                 ForwardBChGammaCorrectedValue196                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_196
            };
            uint32_t                     Value;
        } DW786;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue196                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_196
                uint32_t                 ForwardRChGammaCorrectedValue196                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_196
            };
            uint32_t                     Value;
        } DW787;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue197                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_197
                uint32_t                 InverseBChGammaCorrectedValue197                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_197
            };
            uint32_t                     Value;
        } DW788;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue197                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_197
                uint32_t                 InverseRChGammaCorrectedValue197                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_197
            };
            uint32_t                     Value;
        } DW789;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue197                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_197
                uint32_t                 ForwardBChGammaCorrectedValue197                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_197
            };
            uint32_t                     Value;
        } DW790;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue197                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_197
                uint32_t                 ForwardRChGammaCorrectedValue197                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_197
            };
            uint32_t                     Value;
        } DW791;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue198                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_198
                uint32_t                 InverseBChGammaCorrectedValue198                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_198
            };
            uint32_t                     Value;
        } DW792;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue198                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_198
                uint32_t                 InverseRChGammaCorrectedValue198                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_198
            };
            uint32_t                     Value;
        } DW793;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue198                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_198
                uint32_t                 ForwardBChGammaCorrectedValue198                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_198
            };
            uint32_t                     Value;
        } DW794;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue198                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_198
                uint32_t                 ForwardRChGammaCorrectedValue198                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_198
            };
            uint32_t                     Value;
        } DW795;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue199                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_199
                uint32_t                 InverseBChGammaCorrectedValue199                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_199
            };
            uint32_t                     Value;
        } DW796;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue199                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_199
                uint32_t                 InverseRChGammaCorrectedValue199                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_199
            };
            uint32_t                     Value;
        } DW797;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue199                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_199
                uint32_t                 ForwardBChGammaCorrectedValue199                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_199
            };
            uint32_t                     Value;
        } DW798;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue199                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_199
                uint32_t                 ForwardRChGammaCorrectedValue199                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_199
            };
            uint32_t                     Value;
        } DW799;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue200                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_200
                uint32_t                 InverseBChGammaCorrectedValue200                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_200
            };
            uint32_t                     Value;
        } DW800;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue200                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_200
                uint32_t                 InverseRChGammaCorrectedValue200                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_200
            };
            uint32_t                     Value;
        } DW801;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue200                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_200
                uint32_t                 ForwardBChGammaCorrectedValue200                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_200
            };
            uint32_t                     Value;
        } DW802;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue200                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_200
                uint32_t                 ForwardRChGammaCorrectedValue200                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_200
            };
            uint32_t                     Value;
        } DW803;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue201                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_201
                uint32_t                 InverseBChGammaCorrectedValue201                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_201
            };
            uint32_t                     Value;
        } DW804;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue201                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_201
                uint32_t                 InverseRChGammaCorrectedValue201                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_201
            };
            uint32_t                     Value;
        } DW805;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue201                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_201
                uint32_t                 ForwardBChGammaCorrectedValue201                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_201
            };
            uint32_t                     Value;
        } DW806;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue201                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_201
                uint32_t                 ForwardRChGammaCorrectedValue201                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_201
            };
            uint32_t                     Value;
        } DW807;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue202                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_202
                uint32_t                 InverseBChGammaCorrectedValue202                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_202
            };
            uint32_t                     Value;
        } DW808;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue202                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_202
                uint32_t                 InverseRChGammaCorrectedValue202                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_202
            };
            uint32_t                     Value;
        } DW809;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue202                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_202
                uint32_t                 ForwardBChGammaCorrectedValue202                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_202
            };
            uint32_t                     Value;
        } DW810;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue202                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_202
                uint32_t                 ForwardRChGammaCorrectedValue202                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_202
            };
            uint32_t                     Value;
        } DW811;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue203                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_203
                uint32_t                 InverseBChGammaCorrectedValue203                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_203
            };
            uint32_t                     Value;
        } DW812;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue203                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_203
                uint32_t                 InverseRChGammaCorrectedValue203                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_203
            };
            uint32_t                     Value;
        } DW813;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue203                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_203
                uint32_t                 ForwardBChGammaCorrectedValue203                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_203
            };
            uint32_t                     Value;
        } DW814;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue203                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_203
                uint32_t                 ForwardRChGammaCorrectedValue203                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_203
            };
            uint32_t                     Value;
        } DW815;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue204                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_204
                uint32_t                 InverseBChGammaCorrectedValue204                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_204
            };
            uint32_t                     Value;
        } DW816;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue204                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_204
                uint32_t                 InverseRChGammaCorrectedValue204                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_204
            };
            uint32_t                     Value;
        } DW817;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue204                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_204
                uint32_t                 ForwardBChGammaCorrectedValue204                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_204
            };
            uint32_t                     Value;
        } DW818;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue204                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_204
                uint32_t                 ForwardRChGammaCorrectedValue204                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_204
            };
            uint32_t                     Value;
        } DW819;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue205                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_205
                uint32_t                 InverseBChGammaCorrectedValue205                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_205
            };
            uint32_t                     Value;
        } DW820;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue205                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_205
                uint32_t                 InverseRChGammaCorrectedValue205                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_205
            };
            uint32_t                     Value;
        } DW821;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue205                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_205
                uint32_t                 ForwardBChGammaCorrectedValue205                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_205
            };
            uint32_t                     Value;
        } DW822;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue205                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_205
                uint32_t                 ForwardRChGammaCorrectedValue205                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_205
            };
            uint32_t                     Value;
        } DW823;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue206                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_206
                uint32_t                 InverseBChGammaCorrectedValue206                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_206
            };
            uint32_t                     Value;
        } DW824;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue206                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_206
                uint32_t                 InverseRChGammaCorrectedValue206                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_206
            };
            uint32_t                     Value;
        } DW825;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue206                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_206
                uint32_t                 ForwardBChGammaCorrectedValue206                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_206
            };
            uint32_t                     Value;
        } DW826;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue206                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_206
                uint32_t                 ForwardRChGammaCorrectedValue206                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_206
            };
            uint32_t                     Value;
        } DW827;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue207                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_207
                uint32_t                 InverseBChGammaCorrectedValue207                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_207
            };
            uint32_t                     Value;
        } DW828;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue207                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_207
                uint32_t                 InverseRChGammaCorrectedValue207                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_207
            };
            uint32_t                     Value;
        } DW829;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue207                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_207
                uint32_t                 ForwardBChGammaCorrectedValue207                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_207
            };
            uint32_t                     Value;
        } DW830;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue207                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_207
                uint32_t                 ForwardRChGammaCorrectedValue207                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_207
            };
            uint32_t                     Value;
        } DW831;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue208                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_208
                uint32_t                 InverseBChGammaCorrectedValue208                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_208
            };
            uint32_t                     Value;
        } DW832;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue208                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_208
                uint32_t                 InverseRChGammaCorrectedValue208                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_208
            };
            uint32_t                     Value;
        } DW833;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue208                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_208
                uint32_t                 ForwardBChGammaCorrectedValue208                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_208
            };
            uint32_t                     Value;
        } DW834;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue208                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_208
                uint32_t                 ForwardRChGammaCorrectedValue208                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_208
            };
            uint32_t                     Value;
        } DW835;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue209                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_209
                uint32_t                 InverseBChGammaCorrectedValue209                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_209
            };
            uint32_t                     Value;
        } DW836;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue209                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_209
                uint32_t                 InverseRChGammaCorrectedValue209                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_209
            };
            uint32_t                     Value;
        } DW837;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue209                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_209
                uint32_t                 ForwardBChGammaCorrectedValue209                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_209
            };
            uint32_t                     Value;
        } DW838;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue209                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_209
                uint32_t                 ForwardRChGammaCorrectedValue209                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_209
            };
            uint32_t                     Value;
        } DW839;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue210                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_210
                uint32_t                 InverseBChGammaCorrectedValue210                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_210
            };
            uint32_t                     Value;
        } DW840;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue210                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_210
                uint32_t                 InverseRChGammaCorrectedValue210                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_210
            };
            uint32_t                     Value;
        } DW841;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue210                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_210
                uint32_t                 ForwardBChGammaCorrectedValue210                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_210
            };
            uint32_t                     Value;
        } DW842;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue210                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_210
                uint32_t                 ForwardRChGammaCorrectedValue210                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_210
            };
            uint32_t                     Value;
        } DW843;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue211                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_211
                uint32_t                 InverseBChGammaCorrectedValue211                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_211
            };
            uint32_t                     Value;
        } DW844;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue211                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_211
                uint32_t                 InverseRChGammaCorrectedValue211                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_211
            };
            uint32_t                     Value;
        } DW845;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue211                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_211
                uint32_t                 ForwardBChGammaCorrectedValue211                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_211
            };
            uint32_t                     Value;
        } DW846;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue211                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_211
                uint32_t                 ForwardRChGammaCorrectedValue211                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_211
            };
            uint32_t                     Value;
        } DW847;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue212                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_212
                uint32_t                 InverseBChGammaCorrectedValue212                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_212
            };
            uint32_t                     Value;
        } DW848;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue212                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_212
                uint32_t                 InverseRChGammaCorrectedValue212                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_212
            };
            uint32_t                     Value;
        } DW849;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue212                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_212
                uint32_t                 ForwardBChGammaCorrectedValue212                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_212
            };
            uint32_t                     Value;
        } DW850;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue212                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_212
                uint32_t                 ForwardRChGammaCorrectedValue212                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_212
            };
            uint32_t                     Value;
        } DW851;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue213                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_213
                uint32_t                 InverseBChGammaCorrectedValue213                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_213
            };
            uint32_t                     Value;
        } DW852;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue213                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_213
                uint32_t                 InverseRChGammaCorrectedValue213                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_213
            };
            uint32_t                     Value;
        } DW853;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue213                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_213
                uint32_t                 ForwardBChGammaCorrectedValue213                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_213
            };
            uint32_t                     Value;
        } DW854;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue213                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_213
                uint32_t                 ForwardRChGammaCorrectedValue213                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_213
            };
            uint32_t                     Value;
        } DW855;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue214                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_214
                uint32_t                 InverseBChGammaCorrectedValue214                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_214
            };
            uint32_t                     Value;
        } DW856;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue214                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_214
                uint32_t                 InverseRChGammaCorrectedValue214                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_214
            };
            uint32_t                     Value;
        } DW857;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue214                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_214
                uint32_t                 ForwardBChGammaCorrectedValue214                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_214
            };
            uint32_t                     Value;
        } DW858;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue214                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_214
                uint32_t                 ForwardRChGammaCorrectedValue214                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_214
            };
            uint32_t                     Value;
        } DW859;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue215                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_215
                uint32_t                 InverseBChGammaCorrectedValue215                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_215
            };
            uint32_t                     Value;
        } DW860;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue215                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_215
                uint32_t                 InverseRChGammaCorrectedValue215                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_215
            };
            uint32_t                     Value;
        } DW861;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue215                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_215
                uint32_t                 ForwardBChGammaCorrectedValue215                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_215
            };
            uint32_t                     Value;
        } DW862;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue215                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_215
                uint32_t                 ForwardRChGammaCorrectedValue215                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_215
            };
            uint32_t                     Value;
        } DW863;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue216                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_216
                uint32_t                 InverseBChGammaCorrectedValue216                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_216
            };
            uint32_t                     Value;
        } DW864;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue216                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_216
                uint32_t                 InverseRChGammaCorrectedValue216                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_216
            };
            uint32_t                     Value;
        } DW865;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue216                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_216
                uint32_t                 ForwardBChGammaCorrectedValue216                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_216
            };
            uint32_t                     Value;
        } DW866;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue216                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_216
                uint32_t                 ForwardRChGammaCorrectedValue216                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_216
            };
            uint32_t                     Value;
        } DW867;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue217                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_217
                uint32_t                 InverseBChGammaCorrectedValue217                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_217
            };
            uint32_t                     Value;
        } DW868;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue217                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_217
                uint32_t                 InverseRChGammaCorrectedValue217                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_217
            };
            uint32_t                     Value;
        } DW869;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue217                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_217
                uint32_t                 ForwardBChGammaCorrectedValue217                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_217
            };
            uint32_t                     Value;
        } DW870;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue217                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_217
                uint32_t                 ForwardRChGammaCorrectedValue217                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_217
            };
            uint32_t                     Value;
        } DW871;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue218                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_218
                uint32_t                 InverseBChGammaCorrectedValue218                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_218
            };
            uint32_t                     Value;
        } DW872;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue218                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_218
                uint32_t                 InverseRChGammaCorrectedValue218                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_218
            };
            uint32_t                     Value;
        } DW873;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue218                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_218
                uint32_t                 ForwardBChGammaCorrectedValue218                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_218
            };
            uint32_t                     Value;
        } DW874;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue218                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_218
                uint32_t                 ForwardRChGammaCorrectedValue218                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_218
            };
            uint32_t                     Value;
        } DW875;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue219                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_219
                uint32_t                 InverseBChGammaCorrectedValue219                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_219
            };
            uint32_t                     Value;
        } DW876;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue219                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_219
                uint32_t                 InverseRChGammaCorrectedValue219                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_219
            };
            uint32_t                     Value;
        } DW877;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue219                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_219
                uint32_t                 ForwardBChGammaCorrectedValue219                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_219
            };
            uint32_t                     Value;
        } DW878;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue219                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_219
                uint32_t                 ForwardRChGammaCorrectedValue219                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_219
            };
            uint32_t                     Value;
        } DW879;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue220                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_220
                uint32_t                 InverseBChGammaCorrectedValue220                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_220
            };
            uint32_t                     Value;
        } DW880;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue220                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_220
                uint32_t                 InverseRChGammaCorrectedValue220                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_220
            };
            uint32_t                     Value;
        } DW881;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue220                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_220
                uint32_t                 ForwardBChGammaCorrectedValue220                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_220
            };
            uint32_t                     Value;
        } DW882;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue220                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_220
                uint32_t                 ForwardRChGammaCorrectedValue220                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_220
            };
            uint32_t                     Value;
        } DW883;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue221                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_221
                uint32_t                 InverseBChGammaCorrectedValue221                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_221
            };
            uint32_t                     Value;
        } DW884;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue221                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_221
                uint32_t                 InverseRChGammaCorrectedValue221                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_221
            };
            uint32_t                     Value;
        } DW885;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue221                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_221
                uint32_t                 ForwardBChGammaCorrectedValue221                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_221
            };
            uint32_t                     Value;
        } DW886;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue221                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_221
                uint32_t                 ForwardRChGammaCorrectedValue221                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_221
            };
            uint32_t                     Value;
        } DW887;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue222                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_222
                uint32_t                 InverseBChGammaCorrectedValue222                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_222
            };
            uint32_t                     Value;
        } DW888;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue222                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_222
                uint32_t                 InverseRChGammaCorrectedValue222                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_222
            };
            uint32_t                     Value;
        } DW889;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue222                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_222
                uint32_t                 ForwardBChGammaCorrectedValue222                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_222
            };
            uint32_t                     Value;
        } DW890;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue222                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_222
                uint32_t                 ForwardRChGammaCorrectedValue222                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_222
            };
            uint32_t                     Value;
        } DW891;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue223                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_223
                uint32_t                 InverseBChGammaCorrectedValue223                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_223
            };
            uint32_t                     Value;
        } DW892;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue223                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_223
                uint32_t                 InverseRChGammaCorrectedValue223                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_223
            };
            uint32_t                     Value;
        } DW893;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue223                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_223
                uint32_t                 ForwardBChGammaCorrectedValue223                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_223
            };
            uint32_t                     Value;
        } DW894;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue223                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_223
                uint32_t                 ForwardRChGammaCorrectedValue223                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_223
            };
            uint32_t                     Value;
        } DW895;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue224                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_224
                uint32_t                 InverseBChGammaCorrectedValue224                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_224
            };
            uint32_t                     Value;
        } DW896;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue224                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_224
                uint32_t                 InverseRChGammaCorrectedValue224                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_224
            };
            uint32_t                     Value;
        } DW897;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue224                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_224
                uint32_t                 ForwardBChGammaCorrectedValue224                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_224
            };
            uint32_t                     Value;
        } DW898;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue224                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_224
                uint32_t                 ForwardRChGammaCorrectedValue224                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_224
            };
            uint32_t                     Value;
        } DW899;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue225                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_225
                uint32_t                 InverseBChGammaCorrectedValue225                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_225
            };
            uint32_t                     Value;
        } DW900;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue225                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_225
                uint32_t                 InverseRChGammaCorrectedValue225                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_225
            };
            uint32_t                     Value;
        } DW901;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue225                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_225
                uint32_t                 ForwardBChGammaCorrectedValue225                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_225
            };
            uint32_t                     Value;
        } DW902;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue225                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_225
                uint32_t                 ForwardRChGammaCorrectedValue225                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_225
            };
            uint32_t                     Value;
        } DW903;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue226                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_226
                uint32_t                 InverseBChGammaCorrectedValue226                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_226
            };
            uint32_t                     Value;
        } DW904;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue226                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_226
                uint32_t                 InverseRChGammaCorrectedValue226                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_226
            };
            uint32_t                     Value;
        } DW905;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue226                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_226
                uint32_t                 ForwardBChGammaCorrectedValue226                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_226
            };
            uint32_t                     Value;
        } DW906;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue226                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_226
                uint32_t                 ForwardRChGammaCorrectedValue226                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_226
            };
            uint32_t                     Value;
        } DW907;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue227                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_227
                uint32_t                 InverseBChGammaCorrectedValue227                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_227
            };
            uint32_t                     Value;
        } DW908;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue227                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_227
                uint32_t                 InverseRChGammaCorrectedValue227                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_227
            };
            uint32_t                     Value;
        } DW909;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue227                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_227
                uint32_t                 ForwardBChGammaCorrectedValue227                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_227
            };
            uint32_t                     Value;
        } DW910;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue227                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_227
                uint32_t                 ForwardRChGammaCorrectedValue227                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_227
            };
            uint32_t                     Value;
        } DW911;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue228                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_228
                uint32_t                 InverseBChGammaCorrectedValue228                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_228
            };
            uint32_t                     Value;
        } DW912;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue228                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_228
                uint32_t                 InverseRChGammaCorrectedValue228                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_228
            };
            uint32_t                     Value;
        } DW913;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue228                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_228
                uint32_t                 ForwardBChGammaCorrectedValue228                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_228
            };
            uint32_t                     Value;
        } DW914;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue228                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_228
                uint32_t                 ForwardRChGammaCorrectedValue228                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_228
            };
            uint32_t                     Value;
        } DW915;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue229                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_229
                uint32_t                 InverseBChGammaCorrectedValue229                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_229
            };
            uint32_t                     Value;
        } DW916;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue229                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_229
                uint32_t                 InverseRChGammaCorrectedValue229                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_229
            };
            uint32_t                     Value;
        } DW917;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue229                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_229
                uint32_t                 ForwardBChGammaCorrectedValue229                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_229
            };
            uint32_t                     Value;
        } DW918;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue229                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_229
                uint32_t                 ForwardRChGammaCorrectedValue229                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_229
            };
            uint32_t                     Value;
        } DW919;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue230                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_230
                uint32_t                 InverseBChGammaCorrectedValue230                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_230
            };
            uint32_t                     Value;
        } DW920;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue230                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_230
                uint32_t                 InverseRChGammaCorrectedValue230                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_230
            };
            uint32_t                     Value;
        } DW921;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue230                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_230
                uint32_t                 ForwardBChGammaCorrectedValue230                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_230
            };
            uint32_t                     Value;
        } DW922;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue230                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_230
                uint32_t                 ForwardRChGammaCorrectedValue230                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_230
            };
            uint32_t                     Value;
        } DW923;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue231                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_231
                uint32_t                 InverseBChGammaCorrectedValue231                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_231
            };
            uint32_t                     Value;
        } DW924;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue231                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_231
                uint32_t                 InverseRChGammaCorrectedValue231                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_231
            };
            uint32_t                     Value;
        } DW925;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue231                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_231
                uint32_t                 ForwardBChGammaCorrectedValue231                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_231
            };
            uint32_t                     Value;
        } DW926;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue231                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_231
                uint32_t                 ForwardRChGammaCorrectedValue231                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_231
            };
            uint32_t                     Value;
        } DW927;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue232                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_232
                uint32_t                 InverseBChGammaCorrectedValue232                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_232
            };
            uint32_t                     Value;
        } DW928;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue232                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_232
                uint32_t                 InverseRChGammaCorrectedValue232                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_232
            };
            uint32_t                     Value;
        } DW929;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue232                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_232
                uint32_t                 ForwardBChGammaCorrectedValue232                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_232
            };
            uint32_t                     Value;
        } DW930;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue232                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_232
                uint32_t                 ForwardRChGammaCorrectedValue232                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_232
            };
            uint32_t                     Value;
        } DW931;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue233                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_233
                uint32_t                 InverseBChGammaCorrectedValue233                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_233
            };
            uint32_t                     Value;
        } DW932;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue233                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_233
                uint32_t                 InverseRChGammaCorrectedValue233                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_233
            };
            uint32_t                     Value;
        } DW933;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue233                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_233
                uint32_t                 ForwardBChGammaCorrectedValue233                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_233
            };
            uint32_t                     Value;
        } DW934;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue233                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_233
                uint32_t                 ForwardRChGammaCorrectedValue233                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_233
            };
            uint32_t                     Value;
        } DW935;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue234                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_234
                uint32_t                 InverseBChGammaCorrectedValue234                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_234
            };
            uint32_t                     Value;
        } DW936;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue234                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_234
                uint32_t                 InverseRChGammaCorrectedValue234                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_234
            };
            uint32_t                     Value;
        } DW937;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue234                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_234
                uint32_t                 ForwardBChGammaCorrectedValue234                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_234
            };
            uint32_t                     Value;
        } DW938;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue234                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_234
                uint32_t                 ForwardRChGammaCorrectedValue234                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_234
            };
            uint32_t                     Value;
        } DW939;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue235                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_235
                uint32_t                 InverseBChGammaCorrectedValue235                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_235
            };
            uint32_t                     Value;
        } DW940;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue235                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_235
                uint32_t                 InverseRChGammaCorrectedValue235                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_235
            };
            uint32_t                     Value;
        } DW941;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue235                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_235
                uint32_t                 ForwardBChGammaCorrectedValue235                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_235
            };
            uint32_t                     Value;
        } DW942;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue235                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_235
                uint32_t                 ForwardRChGammaCorrectedValue235                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_235
            };
            uint32_t                     Value;
        } DW943;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue236                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_236
                uint32_t                 InverseBChGammaCorrectedValue236                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_236
            };
            uint32_t                     Value;
        } DW944;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue236                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_236
                uint32_t                 InverseRChGammaCorrectedValue236                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_236
            };
            uint32_t                     Value;
        } DW945;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue236                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_236
                uint32_t                 ForwardBChGammaCorrectedValue236                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_236
            };
            uint32_t                     Value;
        } DW946;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue236                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_236
                uint32_t                 ForwardRChGammaCorrectedValue236                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_236
            };
            uint32_t                     Value;
        } DW947;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue237                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_237
                uint32_t                 InverseBChGammaCorrectedValue237                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_237
            };
            uint32_t                     Value;
        } DW948;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue237                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_237
                uint32_t                 InverseRChGammaCorrectedValue237                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_237
            };
            uint32_t                     Value;
        } DW949;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue237                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_237
                uint32_t                 ForwardBChGammaCorrectedValue237                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_237
            };
            uint32_t                     Value;
        } DW950;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue237                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_237
                uint32_t                 ForwardRChGammaCorrectedValue237                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_237
            };
            uint32_t                     Value;
        } DW951;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue238                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_238
                uint32_t                 InverseBChGammaCorrectedValue238                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_238
            };
            uint32_t                     Value;
        } DW952;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue238                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_238
                uint32_t                 InverseRChGammaCorrectedValue238                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_238
            };
            uint32_t                     Value;
        } DW953;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue238                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_238
                uint32_t                 ForwardBChGammaCorrectedValue238                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_238
            };
            uint32_t                     Value;
        } DW954;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue238                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_238
                uint32_t                 ForwardRChGammaCorrectedValue238                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_238
            };
            uint32_t                     Value;
        } DW955;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue239                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_239
                uint32_t                 InverseBChGammaCorrectedValue239                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_239
            };
            uint32_t                     Value;
        } DW956;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue239                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_239
                uint32_t                 InverseRChGammaCorrectedValue239                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_239
            };
            uint32_t                     Value;
        } DW957;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue239                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_239
                uint32_t                 ForwardBChGammaCorrectedValue239                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_239
            };
            uint32_t                     Value;
        } DW958;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue239                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_239
                uint32_t                 ForwardRChGammaCorrectedValue239                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_239
            };
            uint32_t                     Value;
        } DW959;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue240                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_240
                uint32_t                 InverseBChGammaCorrectedValue240                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_240
            };
            uint32_t                     Value;
        } DW960;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue240                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_240
                uint32_t                 InverseRChGammaCorrectedValue240                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_240
            };
            uint32_t                     Value;
        } DW961;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue240                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_240
                uint32_t                 ForwardBChGammaCorrectedValue240                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_240
            };
            uint32_t                     Value;
        } DW962;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue240                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_240
                uint32_t                 ForwardRChGammaCorrectedValue240                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_240
            };
            uint32_t                     Value;
        } DW963;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue241                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_241
                uint32_t                 InverseBChGammaCorrectedValue241                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_241
            };
            uint32_t                     Value;
        } DW964;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue241                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_241
                uint32_t                 InverseRChGammaCorrectedValue241                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_241
            };
            uint32_t                     Value;
        } DW965;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue241                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_241
                uint32_t                 ForwardBChGammaCorrectedValue241                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_241
            };
            uint32_t                     Value;
        } DW966;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue241                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_241
                uint32_t                 ForwardRChGammaCorrectedValue241                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_241
            };
            uint32_t                     Value;
        } DW967;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue242                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_242
                uint32_t                 InverseBChGammaCorrectedValue242                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_242
            };
            uint32_t                     Value;
        } DW968;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue242                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_242
                uint32_t                 InverseRChGammaCorrectedValue242                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_242
            };
            uint32_t                     Value;
        } DW969;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue242                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_242
                uint32_t                 ForwardBChGammaCorrectedValue242                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_242
            };
            uint32_t                     Value;
        } DW970;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue242                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_242
                uint32_t                 ForwardRChGammaCorrectedValue242                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_242
            };
            uint32_t                     Value;
        } DW971;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue243                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_243
                uint32_t                 InverseBChGammaCorrectedValue243                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_243
            };
            uint32_t                     Value;
        } DW972;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue243                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_243
                uint32_t                 InverseRChGammaCorrectedValue243                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_243
            };
            uint32_t                     Value;
        } DW973;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue243                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_243
                uint32_t                 ForwardBChGammaCorrectedValue243                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_243
            };
            uint32_t                     Value;
        } DW974;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue243                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_243
                uint32_t                 ForwardRChGammaCorrectedValue243                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_243
            };
            uint32_t                     Value;
        } DW975;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue244                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_244
                uint32_t                 InverseBChGammaCorrectedValue244                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_244
            };
            uint32_t                     Value;
        } DW976;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue244                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_244
                uint32_t                 InverseRChGammaCorrectedValue244                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_244
            };
            uint32_t                     Value;
        } DW977;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue244                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_244
                uint32_t                 ForwardBChGammaCorrectedValue244                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_244
            };
            uint32_t                     Value;
        } DW978;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue244                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_244
                uint32_t                 ForwardRChGammaCorrectedValue244                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_244
            };
            uint32_t                     Value;
        } DW979;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue245                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_245
                uint32_t                 InverseBChGammaCorrectedValue245                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_245
            };
            uint32_t                     Value;
        } DW980;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue245                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_245
                uint32_t                 InverseRChGammaCorrectedValue245                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_245
            };
            uint32_t                     Value;
        } DW981;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue245                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_245
                uint32_t                 ForwardBChGammaCorrectedValue245                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_245
            };
            uint32_t                     Value;
        } DW982;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue245                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_245
                uint32_t                 ForwardRChGammaCorrectedValue245                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_245
            };
            uint32_t                     Value;
        } DW983;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue246                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_246
                uint32_t                 InverseBChGammaCorrectedValue246                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_246
            };
            uint32_t                     Value;
        } DW984;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue246                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_246
                uint32_t                 InverseRChGammaCorrectedValue246                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_246
            };
            uint32_t                     Value;
        } DW985;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue246                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_246
                uint32_t                 ForwardBChGammaCorrectedValue246                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_246
            };
            uint32_t                     Value;
        } DW986;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue246                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_246
                uint32_t                 ForwardRChGammaCorrectedValue246                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_246
            };
            uint32_t                     Value;
        } DW987;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue247                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_247
                uint32_t                 InverseBChGammaCorrectedValue247                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_247
            };
            uint32_t                     Value;
        } DW988;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue247                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_247
                uint32_t                 InverseRChGammaCorrectedValue247                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_247
            };
            uint32_t                     Value;
        } DW989;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue247                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_247
                uint32_t                 ForwardBChGammaCorrectedValue247                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_247
            };
            uint32_t                     Value;
        } DW990;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue247                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_247
                uint32_t                 ForwardRChGammaCorrectedValue247                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_247
            };
            uint32_t                     Value;
        } DW991;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue248                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_248
                uint32_t                 InverseBChGammaCorrectedValue248                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_248
            };
            uint32_t                     Value;
        } DW992;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue248                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_248
                uint32_t                 InverseRChGammaCorrectedValue248                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_248
            };
            uint32_t                     Value;
        } DW993;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue248                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_248
                uint32_t                 ForwardBChGammaCorrectedValue248                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_248
            };
            uint32_t                     Value;
        } DW994;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue248                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_248
                uint32_t                 ForwardRChGammaCorrectedValue248                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_248
            };
            uint32_t                     Value;
        } DW995;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue249                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_249
                uint32_t                 InverseBChGammaCorrectedValue249                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_249
            };
            uint32_t                     Value;
        } DW996;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue249                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_249
                uint32_t                 InverseRChGammaCorrectedValue249                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_249
            };
            uint32_t                     Value;
        } DW997;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue249                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_249
                uint32_t                 ForwardBChGammaCorrectedValue249                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_249
            };
            uint32_t                     Value;
        } DW998;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue249                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_249
                uint32_t                 ForwardRChGammaCorrectedValue249                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_249
            };
            uint32_t                     Value;
        } DW999;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue250                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_250
                uint32_t                 InverseBChGammaCorrectedValue250                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_250
            };
            uint32_t                     Value;
        } DW1000;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue250                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_250
                uint32_t                 InverseRChGammaCorrectedValue250                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_250
            };
            uint32_t                     Value;
        } DW1001;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue250                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_250
                uint32_t                 ForwardBChGammaCorrectedValue250                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_250
            };
            uint32_t                     Value;
        } DW1002;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue250                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_250
                uint32_t                 ForwardRChGammaCorrectedValue250                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_250
            };
            uint32_t                     Value;
        } DW1003;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue251                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_251
                uint32_t                 InverseBChGammaCorrectedValue251                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_251
            };
            uint32_t                     Value;
        } DW1004;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue251                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_251
                uint32_t                 InverseRChGammaCorrectedValue251                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_251
            };
            uint32_t                     Value;
        } DW1005;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue251                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_251
                uint32_t                 ForwardBChGammaCorrectedValue251                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_251
            };
            uint32_t                     Value;
        } DW1006;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue251                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_251
                uint32_t                 ForwardRChGammaCorrectedValue251                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_251
            };
            uint32_t                     Value;
        } DW1007;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue252                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_252
                uint32_t                 InverseBChGammaCorrectedValue252                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_252
            };
            uint32_t                     Value;
        } DW1008;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue252                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_252
                uint32_t                 InverseRChGammaCorrectedValue252                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_252
            };
            uint32_t                     Value;
        } DW1009;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue252                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_252
                uint32_t                 ForwardBChGammaCorrectedValue252                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_252
            };
            uint32_t                     Value;
        } DW1010;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue252                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_252
                uint32_t                 ForwardRChGammaCorrectedValue252                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_252
            };
            uint32_t                     Value;
        } DW1011;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue253                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_253
                uint32_t                 InverseBChGammaCorrectedValue253                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_253
            };
            uint32_t                     Value;
        } DW1012;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue253                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_253
                uint32_t                 InverseRChGammaCorrectedValue253                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_253
            };
            uint32_t                     Value;
        } DW1013;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue253                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_253
                uint32_t                 ForwardBChGammaCorrectedValue253                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_253
            };
            uint32_t                     Value;
        } DW1014;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue253                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_253
                uint32_t                 ForwardRChGammaCorrectedValue253                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_253
            };
            uint32_t                     Value;
        } DW1015;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue254                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_254
                uint32_t                 InverseBChGammaCorrectedValue254                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_254
            };
            uint32_t                     Value;
        } DW1016;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue254                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_254
                uint32_t                 InverseRChGammaCorrectedValue254                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_254
            };
            uint32_t                     Value;
        } DW1017;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue254                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_254
                uint32_t                 ForwardBChGammaCorrectedValue254                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_254
            };
            uint32_t                     Value;
        } DW1018;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue254                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_254
                uint32_t                 ForwardRChGammaCorrectedValue254                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_254
            };
            uint32_t                     Value;
        } DW1019;
        union
        {
            struct
            {
                uint32_t                 InverseGChGammaCorrectedValue255                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_G_CH_GAMMA_CORRECTED_VALUE_255
                uint32_t                 InverseBChGammaCorrectedValue255                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_B_CH_GAMMA_CORRECTED_VALUE_255
            };
            uint32_t                     Value;
        } DW1020;
        union
        {
            struct
            {
                uint32_t                 InversePixelValue255                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< INVERSE_PIXEL_VALUE_255
                uint32_t                 InverseRChGammaCorrectedValue255                 : __CODEGEN_BITFIELD(16, 31)    ; //!< INVERSE_R_CH_GAMMA_CORRECTED_VALUE_255
            };
            uint32_t                     Value;
        } DW1021;
        union
        {
            struct
            {
                uint32_t                 ForwardGChGammaCorrectedValue255                 : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_G_CH_GAMMA_CORRECTED_VALUE_255
                uint32_t                 ForwardBChGammaCorrectedValue255                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_B_CH_GAMMA_CORRECTED_VALUE_255
            };
            uint32_t                     Value;
        } DW1022;
        union
        {
            struct
            {
                uint32_t                 ForwardPixelValue255                             : __CODEGEN_BITFIELD( 0, 15)    ; //!< FORWARD_PIXEL_VALUE_255
                uint32_t                 ForwardRChGammaCorrectedValue255                 : __CODEGEN_BITFIELD(16, 31)    ; //!< FORWARD_R_CH_GAMMA_CORRECTED_VALUE_255
            };
            uint32_t                     Value;
        } DW1023;

        //! \name Local enumerations

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_0
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_0
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_0
        {
            INVERSE_PIXEL_VALUE_0_UNNAMED0                                   = 0, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_0
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_0
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_0
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_0
        {
            FORWARD_PIXEL_VALUE_0_UNNAMED0                                   = 0, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_0
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_0_UNNAMED0                    = 0, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_1
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_1
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_1
        {
            INVERSE_PIXEL_VALUE_1_UNNAMED256                                 = 256, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_1
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_1
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_1
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_1
        {
            FORWARD_PIXEL_VALUE_1_UNNAMED256                                 = 256, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_1
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_1_UNNAMED256                  = 256, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_2
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_2
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_2
        {
            INVERSE_PIXEL_VALUE_2_UNNAMED512                                 = 512, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_2
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_2
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_2
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_2
        {
            FORWARD_PIXEL_VALUE_2_UNNAMED512                                 = 512, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_2
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_2_UNNAMED512                  = 512, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_3
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_3
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_3
        {
            INVERSE_PIXEL_VALUE_3_UNNAMED768                                 = 768, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_3
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_3
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_3
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_3
        {
            FORWARD_PIXEL_VALUE_3_UNNAMED768                                 = 768, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_3
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_3_UNNAMED768                  = 768, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_4
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_4
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_4
        {
            INVERSE_PIXEL_VALUE_4_UNNAMED1024                                = 1024, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_4
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_4
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_4
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_4
        {
            FORWARD_PIXEL_VALUE_4_UNNAMED1024                                = 1024, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_4
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_4_UNNAMED1024                 = 1024, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_5
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_5
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_5
        {
            INVERSE_PIXEL_VALUE_5_UNNAMED1280                                = 1280, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_5
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_5
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_5
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_5
        {
            FORWARD_PIXEL_VALUE_5_UNNAMED1280                                = 1280, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_5
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_5_UNNAMED1280                 = 1280, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_6
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_6
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_6
        {
            INVERSE_PIXEL_VALUE_6_UNNAMED1536                                = 1536, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_6
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_6
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_6
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_6
        {
            FORWARD_PIXEL_VALUE_6_UNNAMED1536                                = 1536, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_6
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_6_UNNAMED1536                 = 1536, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_7
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_7
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_7
        {
            INVERSE_PIXEL_VALUE_7_UNNAMED1792                                = 1792, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_7
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_7
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_7
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_7
        {
            FORWARD_PIXEL_VALUE_7_UNNAMED1792                                = 1792, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_7
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_7_UNNAMED1792                 = 1792, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_8
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_8
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_8
        {
            INVERSE_PIXEL_VALUE_8_UNNAMED2048                                = 2048, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_8
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_8
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_8
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_8
        {
            FORWARD_PIXEL_VALUE_8_UNNAMED2048                                = 2048, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_8
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_8_UNNAMED2048                 = 2048, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_9
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_9
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_9
        {
            INVERSE_PIXEL_VALUE_9_UNNAMED2304                                = 2304, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_9
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_9
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_9
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_9
        {
            FORWARD_PIXEL_VALUE_9_UNNAMED2304                                = 2304, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_9
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_9_UNNAMED2304                 = 2304, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_10
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_10
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_10
        {
            INVERSE_PIXEL_VALUE_10_UNNAMED2560                               = 2560, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_10
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_10
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_10
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_10
        {
            FORWARD_PIXEL_VALUE_10_UNNAMED2560                               = 2560, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_10
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_10_UNNAMED2560                = 2560, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_11
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_11
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_11
        {
            INVERSE_PIXEL_VALUE_11_UNNAMED2816                               = 2816, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_11
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_11
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_11
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_11
        {
            FORWARD_PIXEL_VALUE_11_UNNAMED2816                               = 2816, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_11
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_11_UNNAMED2816                = 2816, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_12
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_12
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_12
        {
            INVERSE_PIXEL_VALUE_12_UNNAMED3072                               = 3072, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_12
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_12
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_12
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_12
        {
            FORWARD_PIXEL_VALUE_12_UNNAMED3072                               = 3072, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_12
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_12_UNNAMED3072                = 3072, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_13
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_13
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_13
        {
            INVERSE_PIXEL_VALUE_13_UNNAMED3328                               = 3328, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_13
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_13
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_13
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_13
        {
            FORWARD_PIXEL_VALUE_13_UNNAMED3328                               = 3328, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_13
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_13_UNNAMED3328                = 3328, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_14
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_14
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_14
        {
            INVERSE_PIXEL_VALUE_14_UNNAMED3584                               = 3584, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_14
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_14
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_14
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_14
        {
            FORWARD_PIXEL_VALUE_14_UNNAMED3584                               = 3584, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_14
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_14_UNNAMED3584                = 3584, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_15
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_15
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_15
        {
            INVERSE_PIXEL_VALUE_15_UNNAMED3840                               = 3840, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_15
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_15
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_15
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_15
        {
            FORWARD_PIXEL_VALUE_15_UNNAMED3840                               = 3840, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_15
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_15_UNNAMED3840                = 3840, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_16
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_16
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_16
        {
            INVERSE_PIXEL_VALUE_16_UNNAMED4096                               = 4096, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_16
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_16
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_16
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_16
        {
            FORWARD_PIXEL_VALUE_16_UNNAMED4096                               = 4096, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_16
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_16_UNNAMED4096                = 4096, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_17
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_17
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_17
        {
            INVERSE_PIXEL_VALUE_17_UNNAMED4352                               = 4352, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_17
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_17
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_17
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_17
        {
            FORWARD_PIXEL_VALUE_17_UNNAMED4352                               = 4352, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_17
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_17_UNNAMED4352                = 4352, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_18
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_18
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_18
        {
            INVERSE_PIXEL_VALUE_18_UNNAMED4608                               = 4608, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_18
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_18
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_18
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_18
        {
            FORWARD_PIXEL_VALUE_18_UNNAMED4608                               = 4608, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_18
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_18_UNNAMED4608                = 4608, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_19
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_19
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_19
        {
            INVERSE_PIXEL_VALUE_19_UNNAMED4864                               = 4864, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_19
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_19
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_19
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_19
        {
            FORWARD_PIXEL_VALUE_19_UNNAMED4864                               = 4864, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_19
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_19_UNNAMED4864                = 4864, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_20
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_20
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_20
        {
            INVERSE_PIXEL_VALUE_20_UNNAMED5120                               = 5120, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_20
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_20
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_20
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_20
        {
            FORWARD_PIXEL_VALUE_20_UNNAMED5120                               = 5120, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_20
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_20_UNNAMED5120                = 5120, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_21
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_21
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_21
        {
            INVERSE_PIXEL_VALUE_21_UNNAMED5376                               = 5376, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_21
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_21
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_21
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_21
        {
            FORWARD_PIXEL_VALUE_21_UNNAMED5376                               = 5376, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_21
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_21_UNNAMED5376                = 5376, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_22
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_22
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_22
        {
            INVERSE_PIXEL_VALUE_22_UNNAMED5632                               = 5632, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_22
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_22
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_22
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_22
        {
            FORWARD_PIXEL_VALUE_22_UNNAMED5632                               = 5632, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_22
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_22_UNNAMED5632                = 5632, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_23
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_23
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_23
        {
            INVERSE_PIXEL_VALUE_23_UNNAMED5888                               = 5888, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_23
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_23
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_23
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_23
        {
            FORWARD_PIXEL_VALUE_23_UNNAMED5888                               = 5888, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_23
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_23_UNNAMED5888                = 5888, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_24
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_24
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_24
        {
            INVERSE_PIXEL_VALUE_24_UNNAMED6144                               = 6144, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_24
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_24
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_24
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_24
        {
            FORWARD_PIXEL_VALUE_24_UNNAMED6144                               = 6144, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_24
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_24_UNNAMED6144                = 6144, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_25
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_25
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_25
        {
            INVERSE_PIXEL_VALUE_25_UNNAMED6400                               = 6400, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_25
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_25
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_25
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_25
        {
            FORWARD_PIXEL_VALUE_25_UNNAMED6400                               = 6400, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_25
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_25_UNNAMED6400                = 6400, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_26
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_26
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_26
        {
            INVERSE_PIXEL_VALUE_26_UNNAMED6656                               = 6656, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_26
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_26
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_26
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_26
        {
            FORWARD_PIXEL_VALUE_26_UNNAMED6656                               = 6656, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_26
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_26_UNNAMED6656                = 6656, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_27
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_27
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_27
        {
            INVERSE_PIXEL_VALUE_27_UNNAMED6912                               = 6912, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_27
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_27
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_27
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_27
        {
            FORWARD_PIXEL_VALUE_27_UNNAMED6912                               = 6912, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_27
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_27_UNNAMED6912                = 6912, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_28
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_28
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_28
        {
            INVERSE_PIXEL_VALUE_28_UNNAMED7168                               = 7168, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_28
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_28
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_28
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_28
        {
            FORWARD_PIXEL_VALUE_28_UNNAMED7168                               = 7168, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_28
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_28_UNNAMED7168                = 7168, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_29
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_29
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_29
        {
            INVERSE_PIXEL_VALUE_29_UNNAMED7424                               = 7424, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_29
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_29
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_29
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_29
        {
            FORWARD_PIXEL_VALUE_29_UNNAMED7424                               = 7424, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_29
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_29_UNNAMED7424                = 7424, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_30
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_30
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_30
        {
            INVERSE_PIXEL_VALUE_30_UNNAMED7680                               = 7680, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_30
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_30
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_30
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_30
        {
            FORWARD_PIXEL_VALUE_30_UNNAMED7680                               = 7680, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_30
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_30_UNNAMED7680                = 7680, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_31
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_31
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_31
        {
            INVERSE_PIXEL_VALUE_31_UNNAMED7936                               = 7936, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_31
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_31
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_31
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_31
        {
            FORWARD_PIXEL_VALUE_31_UNNAMED7936                               = 7936, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_31
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_31_UNNAMED7936                = 7936, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_32
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_32
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_32
        {
            INVERSE_PIXEL_VALUE_32_UNNAMED8192                               = 8192, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_32
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_32
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_32
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_32
        {
            FORWARD_PIXEL_VALUE_32_UNNAMED8192                               = 8192, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_32
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_32_UNNAMED8192                = 8192, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_33
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_33
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_33
        {
            INVERSE_PIXEL_VALUE_33_UNNAMED8448                               = 8448, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_33
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_33
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_33
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_33
        {
            FORWARD_PIXEL_VALUE_33_UNNAMED8448                               = 8448, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_33
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_33_UNNAMED8448                = 8448, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_34
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_34
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_34
        {
            INVERSE_PIXEL_VALUE_34_UNNAMED8704                               = 8704, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_34
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_34
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_34
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_34
        {
            FORWARD_PIXEL_VALUE_34_UNNAMED8704                               = 8704, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_34
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_34_UNNAMED8704                = 8704, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_35
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_35
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_35
        {
            INVERSE_PIXEL_VALUE_35_UNNAMED8960                               = 8960, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_35
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_35
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_35
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_35
        {
            FORWARD_PIXEL_VALUE_35_UNNAMED8960                               = 8960, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_35
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_35_UNNAMED8960                = 8960, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_36
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_36
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_36
        {
            INVERSE_PIXEL_VALUE_36_UNNAMED9216                               = 9216, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_36
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_36
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_36
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_36
        {
            FORWARD_PIXEL_VALUE_36_UNNAMED9216                               = 9216, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_36
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_36_UNNAMED9216                = 9216, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_37
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_37
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_37
        {
            INVERSE_PIXEL_VALUE_37_UNNAMED9472                               = 9472, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_37
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_37
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_37
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_37
        {
            FORWARD_PIXEL_VALUE_37_UNNAMED9472                               = 9472, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_37
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_37_UNNAMED9472                = 9472, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_38
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_38
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_38
        {
            INVERSE_PIXEL_VALUE_38_UNNAMED9728                               = 9728, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_38
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_38
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_38
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_38
        {
            FORWARD_PIXEL_VALUE_38_UNNAMED9728                               = 9728, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_38
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_38_UNNAMED9728                = 9728, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_39
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_39
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_39
        {
            INVERSE_PIXEL_VALUE_39_UNNAMED9984                               = 9984, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_39
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_39
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_39
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_39
        {
            FORWARD_PIXEL_VALUE_39_UNNAMED9984                               = 9984, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_39
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_39_UNNAMED9984                = 9984, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_40
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_40
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_40
        {
            INVERSE_PIXEL_VALUE_40_UNNAMED10240                              = 10240, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_40
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_40
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_40
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_40
        {
            FORWARD_PIXEL_VALUE_40_UNNAMED10240                              = 10240, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_40
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_40_UNNAMED10240               = 10240, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_41
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_41
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_41
        {
            INVERSE_PIXEL_VALUE_41_UNNAMED10496                              = 10496, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_41
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_41
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_41
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_41
        {
            FORWARD_PIXEL_VALUE_41_UNNAMED10496                              = 10496, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_41
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_41_UNNAMED10496               = 10496, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_42
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_42
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_42
        {
            INVERSE_PIXEL_VALUE_42_UNNAMED10752                              = 10752, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_42
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_42
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_42
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_42
        {
            FORWARD_PIXEL_VALUE_42_UNNAMED10752                              = 10752, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_42
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_42_UNNAMED10752               = 10752, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_43
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_43
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_43
        {
            INVERSE_PIXEL_VALUE_43_UNNAMED11008                              = 11008, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_43
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_43
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_43
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_43
        {
            FORWARD_PIXEL_VALUE_43_UNNAMED11008                              = 11008, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_43
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_43_UNNAMED11008               = 11008, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_44
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_44
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_44
        {
            INVERSE_PIXEL_VALUE_44_UNNAMED11264                              = 11264, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_44
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_44
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_44
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_44
        {
            FORWARD_PIXEL_VALUE_44_UNNAMED11264                              = 11264, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_44
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_44_UNNAMED11264               = 11264, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_45
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_45
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_45
        {
            INVERSE_PIXEL_VALUE_45_UNNAMED11520                              = 11520, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_45
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_45
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_45
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_45
        {
            FORWARD_PIXEL_VALUE_45_UNNAMED11520                              = 11520, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_45
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_45_UNNAMED11520               = 11520, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_46
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_46
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_46
        {
            INVERSE_PIXEL_VALUE_46_UNNAMED11776                              = 11776, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_46
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_46
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_46
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_46
        {
            FORWARD_PIXEL_VALUE_46_UNNAMED11776                              = 11776, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_46
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_46_UNNAMED11776               = 11776, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_47
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_47
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_47
        {
            INVERSE_PIXEL_VALUE_47_UNNAMED12032                              = 12032, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_47
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_47
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_47
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_47
        {
            FORWARD_PIXEL_VALUE_47_UNNAMED12032                              = 12032, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_47
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_47_UNNAMED12032               = 12032, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_48
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_48
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_48
        {
            INVERSE_PIXEL_VALUE_48_UNNAMED12288                              = 12288, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_48
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_48
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_48
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_48
        {
            FORWARD_PIXEL_VALUE_48_UNNAMED12288                              = 12288, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_48
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_48_UNNAMED12288               = 12288, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_49
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_49
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_49
        {
            INVERSE_PIXEL_VALUE_49_UNNAMED12544                              = 12544, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_49
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_49
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_49
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_49
        {
            FORWARD_PIXEL_VALUE_49_UNNAMED12544                              = 12544, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_49
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_49_UNNAMED12544               = 12544, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_50
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_50
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_50
        {
            INVERSE_PIXEL_VALUE_50_UNNAMED12800                              = 12800, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_50
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_50
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_50
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_50
        {
            FORWARD_PIXEL_VALUE_50_UNNAMED12800                              = 12800, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_50
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_50_UNNAMED12800               = 12800, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_51
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_51
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_51
        {
            INVERSE_PIXEL_VALUE_51_UNNAMED13056                              = 13056, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_51
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_51
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_51
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_51
        {
            FORWARD_PIXEL_VALUE_51_UNNAMED13056                              = 13056, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_51
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_51_UNNAMED13056               = 13056, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_52
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_52
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_52
        {
            INVERSE_PIXEL_VALUE_52_UNNAMED13312                              = 13312, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_52
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_52
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_52
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_52
        {
            FORWARD_PIXEL_VALUE_52_UNNAMED13312                              = 13312, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_52
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_52_UNNAMED13312               = 13312, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_53
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_53
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_53
        {
            INVERSE_PIXEL_VALUE_53_UNNAMED13568                              = 13568, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_53
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_53
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_53
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_53
        {
            FORWARD_PIXEL_VALUE_53_UNNAMED13568                              = 13568, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_53
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_53_UNNAMED13568               = 13568, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_54
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_54
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_54
        {
            INVERSE_PIXEL_VALUE_54_UNNAMED13824                              = 13824, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_54
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_54
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_54
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_54
        {
            FORWARD_PIXEL_VALUE_54_UNNAMED13824                              = 13824, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_54
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_54_UNNAMED13824               = 13824, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_55
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_55
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_55
        {
            INVERSE_PIXEL_VALUE_55_UNNAMED14080                              = 14080, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_55
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_55
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_55
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_55
        {
            FORWARD_PIXEL_VALUE_55_UNNAMED14080                              = 14080, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_55
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_55_UNNAMED14080               = 14080, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_56
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_56
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_56
        {
            INVERSE_PIXEL_VALUE_56_UNNAMED14336                              = 14336, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_56
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_56
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_56
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_56
        {
            FORWARD_PIXEL_VALUE_56_UNNAMED14336                              = 14336, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_56
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_56_UNNAMED14336               = 14336, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_57
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_57
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_57
        {
            INVERSE_PIXEL_VALUE_57_UNNAMED14592                              = 14592, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_57
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_57
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_57
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_57
        {
            FORWARD_PIXEL_VALUE_57_UNNAMED14592                              = 14592, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_57
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_57_UNNAMED14592               = 14592, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_58
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_58
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_58
        {
            INVERSE_PIXEL_VALUE_58_UNNAMED14848                              = 14848, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_58
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_58
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_58
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_58
        {
            FORWARD_PIXEL_VALUE_58_UNNAMED14848                              = 14848, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_58
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_58_UNNAMED14848               = 14848, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_59
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_59
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_59
        {
            INVERSE_PIXEL_VALUE_59_UNNAMED15104                              = 15104, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_59
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_59
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_59
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_59
        {
            FORWARD_PIXEL_VALUE_59_UNNAMED15104                              = 15104, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_59
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_59_UNNAMED15104               = 15104, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_60
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_60
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_60
        {
            INVERSE_PIXEL_VALUE_60_UNNAMED15360                              = 15360, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_60
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_60
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_60
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_60
        {
            FORWARD_PIXEL_VALUE_60_UNNAMED15360                              = 15360, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_60
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_60_UNNAMED15360               = 15360, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_61
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_61
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_61
        {
            INVERSE_PIXEL_VALUE_61_UNNAMED15616                              = 15616, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_61
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_61
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_61
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_61
        {
            FORWARD_PIXEL_VALUE_61_UNNAMED15616                              = 15616, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_61
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_61_UNNAMED15616               = 15616, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_62
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_62
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_62
        {
            INVERSE_PIXEL_VALUE_62_UNNAMED15872                              = 15872, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_62
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_62
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_62
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_62
        {
            FORWARD_PIXEL_VALUE_62_UNNAMED15872                              = 15872, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_62
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_62_UNNAMED15872               = 15872, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_63
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_63
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_63
        {
            INVERSE_PIXEL_VALUE_63_UNNAMED16128                              = 16128, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_63
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_63
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_63
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_63
        {
            FORWARD_PIXEL_VALUE_63_UNNAMED16128                              = 16128, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_63
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_63_UNNAMED16128               = 16128, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_64
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_64
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_64
        {
            INVERSE_PIXEL_VALUE_64_UNNAMED16384                              = 16384, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_64
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_64
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_64
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_64
        {
            FORWARD_PIXEL_VALUE_64_UNNAMED16384                              = 16384, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_64
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_64_UNNAMED16384               = 16384, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_65
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_65
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_65
        {
            INVERSE_PIXEL_VALUE_65_UNNAMED16640                              = 16640, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_65
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_65
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_65
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_65
        {
            FORWARD_PIXEL_VALUE_65_UNNAMED16640                              = 16640, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_65
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_65_UNNAMED16640               = 16640, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_66
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_66
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_66
        {
            INVERSE_PIXEL_VALUE_66_UNNAMED16896                              = 16896, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_66
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_66
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_66
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_66
        {
            FORWARD_PIXEL_VALUE_66_UNNAMED16896                              = 16896, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_66
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_66_UNNAMED16896               = 16896, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_67
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_67
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_67
        {
            INVERSE_PIXEL_VALUE_67_UNNAMED17152                              = 17152, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_67
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_67
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_67
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_67
        {
            FORWARD_PIXEL_VALUE_67_UNNAMED17152                              = 17152, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_67
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_67_UNNAMED17152               = 17152, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_68
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_68
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_68
        {
            INVERSE_PIXEL_VALUE_68_UNNAMED17408                              = 17408, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_68
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_68
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_68
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_68
        {
            FORWARD_PIXEL_VALUE_68_UNNAMED17408                              = 17408, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_68
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_68_UNNAMED17408               = 17408, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_69
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_69
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_69
        {
            INVERSE_PIXEL_VALUE_69_UNNAMED17664                              = 17664, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_69
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_69
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_69
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_69
        {
            FORWARD_PIXEL_VALUE_69_UNNAMED17664                              = 17664, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_69
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_69_UNNAMED17664               = 17664, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_70
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_70
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_70
        {
            INVERSE_PIXEL_VALUE_70_UNNAMED17920                              = 17920, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_70
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_70
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_70
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_70
        {
            FORWARD_PIXEL_VALUE_70_UNNAMED17920                              = 17920, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_70
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_70_UNNAMED17920               = 17920, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_71
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_71
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_71
        {
            INVERSE_PIXEL_VALUE_71_UNNAMED18176                              = 18176, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_71
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_71
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_71
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_71
        {
            FORWARD_PIXEL_VALUE_71_UNNAMED18176                              = 18176, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_71
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_71_UNNAMED18176               = 18176, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_72
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_72
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_72
        {
            INVERSE_PIXEL_VALUE_72_UNNAMED18432                              = 18432, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_72
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_72
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_72
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_72
        {
            FORWARD_PIXEL_VALUE_72_UNNAMED18432                              = 18432, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_72
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_72_UNNAMED18432               = 18432, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_73
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_73
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_73
        {
            INVERSE_PIXEL_VALUE_73_UNNAMED18688                              = 18688, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_73
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_73
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_73
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_73
        {
            FORWARD_PIXEL_VALUE_73_UNNAMED18688                              = 18688, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_73
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_73_UNNAMED18688               = 18688, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_74
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_74
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_74
        {
            INVERSE_PIXEL_VALUE_74_UNNAMED18944                              = 18944, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_74
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_74
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_74
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_74
        {
            FORWARD_PIXEL_VALUE_74_UNNAMED18944                              = 18944, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_74
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_74_UNNAMED18944               = 18944, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_75
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_75
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_75
        {
            INVERSE_PIXEL_VALUE_75_UNNAMED19200                              = 19200, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_75
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_75
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_75
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_75
        {
            FORWARD_PIXEL_VALUE_75_UNNAMED19200                              = 19200, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_75
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_75_UNNAMED19200               = 19200, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_76
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_76
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_76
        {
            INVERSE_PIXEL_VALUE_76_UNNAMED19456                              = 19456, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_76
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_76
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_76
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_76
        {
            FORWARD_PIXEL_VALUE_76_UNNAMED19456                              = 19456, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_76
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_76_UNNAMED19456               = 19456, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_77
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_77
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_77
        {
            INVERSE_PIXEL_VALUE_77_UNNAMED19712                              = 19712, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_77
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_77
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_77
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_77
        {
            FORWARD_PIXEL_VALUE_77_UNNAMED19712                              = 19712, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_77
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_77_UNNAMED19712               = 19712, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_78
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_78
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_78
        {
            INVERSE_PIXEL_VALUE_78_UNNAMED19968                              = 19968, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_78
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_78
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_78
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_78
        {
            FORWARD_PIXEL_VALUE_78_UNNAMED19968                              = 19968, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_78
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_78_UNNAMED19968               = 19968, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_79
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_79
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_79
        {
            INVERSE_PIXEL_VALUE_79_UNNAMED20224                              = 20224, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_79
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_79
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_79
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_79
        {
            FORWARD_PIXEL_VALUE_79_UNNAMED20224                              = 20224, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_79
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_79_UNNAMED20224               = 20224, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_80
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_80
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_80
        {
            INVERSE_PIXEL_VALUE_80_UNNAMED20480                              = 20480, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_80
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_80
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_80
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_80
        {
            FORWARD_PIXEL_VALUE_80_UNNAMED20480                              = 20480, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_80
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_80_UNNAMED20480               = 20480, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_81
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_81
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_81
        {
            INVERSE_PIXEL_VALUE_81_UNNAMED20736                              = 20736, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_81
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_81
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_81
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_81
        {
            FORWARD_PIXEL_VALUE_81_UNNAMED20736                              = 20736, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_81
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_81_UNNAMED20736               = 20736, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_82
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_82
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_82
        {
            INVERSE_PIXEL_VALUE_82_UNNAMED20992                              = 20992, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_82
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_82
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_82
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_82
        {
            FORWARD_PIXEL_VALUE_82_UNNAMED20992                              = 20992, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_82
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_82_UNNAMED20992               = 20992, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_83
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_83
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_83
        {
            INVERSE_PIXEL_VALUE_83_UNNAMED21248                              = 21248, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_83
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_83
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_83
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_83
        {
            FORWARD_PIXEL_VALUE_83_UNNAMED21248                              = 21248, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_83
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_83_UNNAMED21248               = 21248, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_84
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_84
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_84
        {
            INVERSE_PIXEL_VALUE_84_UNNAMED21504                              = 21504, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_84
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_84
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_84
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_84
        {
            FORWARD_PIXEL_VALUE_84_UNNAMED21504                              = 21504, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_84
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_84_UNNAMED21504               = 21504, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_85
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_85
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_85
        {
            INVERSE_PIXEL_VALUE_85_UNNAMED21760                              = 21760, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_85
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_85
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_85
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_85
        {
            FORWARD_PIXEL_VALUE_85_UNNAMED21760                              = 21760, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_85
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_85_UNNAMED21760               = 21760, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_86
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_86
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_86
        {
            INVERSE_PIXEL_VALUE_86_UNNAMED22016                              = 22016, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_86
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_86
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_86
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_86
        {
            FORWARD_PIXEL_VALUE_86_UNNAMED22016                              = 22016, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_86
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_86_UNNAMED22016               = 22016, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_87
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_87
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_87
        {
            INVERSE_PIXEL_VALUE_87_UNNAMED22272                              = 22272, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_87
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_87
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_87
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_87
        {
            FORWARD_PIXEL_VALUE_87_UNNAMED22272                              = 22272, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_87
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_87_UNNAMED22272               = 22272, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_88
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_88
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_88
        {
            INVERSE_PIXEL_VALUE_88_UNNAMED22528                              = 22528, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_88
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_88
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_88
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_88
        {
            FORWARD_PIXEL_VALUE_88_UNNAMED22528                              = 22528, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_88
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_88_UNNAMED22528               = 22528, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_89
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_89
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_89
        {
            INVERSE_PIXEL_VALUE_89_UNNAMED22784                              = 22784, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_89
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_89
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_89
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_89
        {
            FORWARD_PIXEL_VALUE_89_UNNAMED22784                              = 22784, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_89
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_89_UNNAMED22784               = 22784, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_90
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_90
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_90
        {
            INVERSE_PIXEL_VALUE_90_UNNAMED23040                              = 23040, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_90
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_90
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_90
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_90
        {
            FORWARD_PIXEL_VALUE_90_UNNAMED23040                              = 23040, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_90
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_90_UNNAMED23040               = 23040, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_91
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_91
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_91
        {
            INVERSE_PIXEL_VALUE_91_UNNAMED23296                              = 23296, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_91
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_91
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_91
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_91
        {
            FORWARD_PIXEL_VALUE_91_UNNAMED23296                              = 23296, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_91
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_91_UNNAMED23296               = 23296, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_92
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_92
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_92
        {
            INVERSE_PIXEL_VALUE_92_UNNAMED23552                              = 23552, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_92
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_92
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_92
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_92
        {
            FORWARD_PIXEL_VALUE_92_UNNAMED23552                              = 23552, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_92
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_92_UNNAMED23552               = 23552, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_93
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_93
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_93
        {
            INVERSE_PIXEL_VALUE_93_UNNAMED23808                              = 23808, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_93
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_93
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_93
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_93
        {
            FORWARD_PIXEL_VALUE_93_UNNAMED23808                              = 23808, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_93
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_93_UNNAMED23808               = 23808, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_94
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_94
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_94
        {
            INVERSE_PIXEL_VALUE_94_UNNAMED24064                              = 24064, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_94
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_94
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_94
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_94
        {
            FORWARD_PIXEL_VALUE_94_UNNAMED24064                              = 24064, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_94
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_94_UNNAMED24064               = 24064, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_95
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_95
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_95
        {
            INVERSE_PIXEL_VALUE_95_UNNAMED24320                              = 24320, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_95
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_95
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_95
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_95
        {
            FORWARD_PIXEL_VALUE_95_UNNAMED24320                              = 24320, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_95
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_95_UNNAMED24320               = 24320, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_96
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_96
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_96
        {
            INVERSE_PIXEL_VALUE_96_UNNAMED24576                              = 24576, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_96
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_96
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_96
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_96
        {
            FORWARD_PIXEL_VALUE_96_UNNAMED24576                              = 24576, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_96
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_96_UNNAMED24576               = 24576, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_97
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_97
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_97
        {
            INVERSE_PIXEL_VALUE_97_UNNAMED24832                              = 24832, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_97
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_97
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_97
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_97
        {
            FORWARD_PIXEL_VALUE_97_UNNAMED24832                              = 24832, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_97
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_97_UNNAMED24832               = 24832, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_98
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_98
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_98
        {
            INVERSE_PIXEL_VALUE_98_UNNAMED25088                              = 25088, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_98
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_98
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_98
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_98
        {
            FORWARD_PIXEL_VALUE_98_UNNAMED25088                              = 25088, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_98
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_98_UNNAMED25088               = 25088, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_99
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_99
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_99
        {
            INVERSE_PIXEL_VALUE_99_UNNAMED25344                              = 25344, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_99
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_99
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_99
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_99
        {
            FORWARD_PIXEL_VALUE_99_UNNAMED25344                              = 25344, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_99
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_99_UNNAMED25344               = 25344, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_100
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_100
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_100
        {
            INVERSE_PIXEL_VALUE_100_UNNAMED25600                             = 25600, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_100
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_100
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_100
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_100
        {
            FORWARD_PIXEL_VALUE_100_UNNAMED25600                             = 25600, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_100
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_100_UNNAMED25600              = 25600, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_101
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_101
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_101
        {
            INVERSE_PIXEL_VALUE_101_UNNAMED25856                             = 25856, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_101
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_101
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_101
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_101
        {
            FORWARD_PIXEL_VALUE_101_UNNAMED25856                             = 25856, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_101
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_101_UNNAMED25856              = 25856, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_102
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_102
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_102
        {
            INVERSE_PIXEL_VALUE_102_UNNAMED26112                             = 26112, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_102
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_102
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_102
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_102
        {
            FORWARD_PIXEL_VALUE_102_UNNAMED26112                             = 26112, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_102
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_102_UNNAMED26112              = 26112, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_103
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_103
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_103
        {
            INVERSE_PIXEL_VALUE_103_UNNAMED26368                             = 26368, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_103
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_103
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_103
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_103
        {
            FORWARD_PIXEL_VALUE_103_UNNAMED26368                             = 26368, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_103
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_103_UNNAMED26368              = 26368, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_104
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_104
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_104
        {
            INVERSE_PIXEL_VALUE_104_UNNAMED26624                             = 26624, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_104
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_104
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_104
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_104
        {
            FORWARD_PIXEL_VALUE_104_UNNAMED26624                             = 26624, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_104
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_104_UNNAMED26624              = 26624, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_105
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_105
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_105
        {
            INVERSE_PIXEL_VALUE_105_UNNAMED26880                             = 26880, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_105
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_105
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_105
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_105
        {
            FORWARD_PIXEL_VALUE_105_UNNAMED26880                             = 26880, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_105
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_105_UNNAMED26880              = 26880, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_106
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_106
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_106
        {
            INVERSE_PIXEL_VALUE_106_UNNAMED27136                             = 27136, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_106
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_106
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_106
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_106
        {
            FORWARD_PIXEL_VALUE_106_UNNAMED27136                             = 27136, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_106
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_106_UNNAMED27136              = 27136, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_107
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_107
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_107
        {
            INVERSE_PIXEL_VALUE_107_UNNAMED27392                             = 27392, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_107
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_107
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_107
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_107
        {
            FORWARD_PIXEL_VALUE_107_UNNAMED27392                             = 27392, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_107
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_107_UNNAMED27392              = 27392, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_108
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_108
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_108
        {
            INVERSE_PIXEL_VALUE_108_UNNAMED27648                             = 27648, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_108
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_108
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_108
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_108
        {
            FORWARD_PIXEL_VALUE_108_UNNAMED27648                             = 27648, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_108
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_108_UNNAMED27648              = 27648, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_109
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_109
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_109
        {
            INVERSE_PIXEL_VALUE_109_UNNAMED27904                             = 27904, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_109
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_109
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_109
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_109
        {
            FORWARD_PIXEL_VALUE_109_UNNAMED27904                             = 27904, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_109
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_109_UNNAMED27904              = 27904, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_110
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_110
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_110
        {
            INVERSE_PIXEL_VALUE_110_UNNAMED28160                             = 28160, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_110
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_110
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_110
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_110
        {
            FORWARD_PIXEL_VALUE_110_UNNAMED28160                             = 28160, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_110
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_110_UNNAMED28160              = 28160, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_111
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_111
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_111
        {
            INVERSE_PIXEL_VALUE_111_UNNAMED28416                             = 28416, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_111
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_111
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_111
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_111
        {
            FORWARD_PIXEL_VALUE_111_UNNAMED28416                             = 28416, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_111
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_111_UNNAMED28416              = 28416, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_112
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_112
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_112
        {
            INVERSE_PIXEL_VALUE_112_UNNAMED28672                             = 28672, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_112
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_112
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_112
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_112
        {
            FORWARD_PIXEL_VALUE_112_UNNAMED28672                             = 28672, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_112
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_112_UNNAMED28672              = 28672, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_113
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_113
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_113
        {
            INVERSE_PIXEL_VALUE_113_UNNAMED28928                             = 28928, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_113
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_113
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_113
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_113
        {
            FORWARD_PIXEL_VALUE_113_UNNAMED28928                             = 28928, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_113
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_113_UNNAMED28928              = 28928, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_114
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_114
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_114
        {
            INVERSE_PIXEL_VALUE_114_UNNAMED29184                             = 29184, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_114
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_114
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_114
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_114
        {
            FORWARD_PIXEL_VALUE_114_UNNAMED29184                             = 29184, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_114
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_114_UNNAMED29184              = 29184, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_115
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_115
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_115
        {
            INVERSE_PIXEL_VALUE_115_UNNAMED29440                             = 29440, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_115
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_115
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_115
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_115
        {
            FORWARD_PIXEL_VALUE_115_UNNAMED29440                             = 29440, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_115
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_115_UNNAMED29440              = 29440, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_116
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_116
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_116
        {
            INVERSE_PIXEL_VALUE_116_UNNAMED29696                             = 29696, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_116
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_116
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_116
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_116
        {
            FORWARD_PIXEL_VALUE_116_UNNAMED29696                             = 29696, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_116
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_116_UNNAMED29696              = 29696, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_117
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_117
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_117
        {
            INVERSE_PIXEL_VALUE_117_UNNAMED29952                             = 29952, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_117
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_117
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_117
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_117
        {
            FORWARD_PIXEL_VALUE_117_UNNAMED29952                             = 29952, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_117
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_117_UNNAMED29952              = 29952, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_118
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_118
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_118
        {
            INVERSE_PIXEL_VALUE_118_UNNAMED30208                             = 30208, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_118
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_118
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_118
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_118
        {
            FORWARD_PIXEL_VALUE_118_UNNAMED30208                             = 30208, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_118
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_118_UNNAMED30208              = 30208, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_119
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_119
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_119
        {
            INVERSE_PIXEL_VALUE_119_UNNAMED30464                             = 30464, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_119
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_119
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_119
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_119
        {
            FORWARD_PIXEL_VALUE_119_UNNAMED30464                             = 30464, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_119
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_119_UNNAMED30464              = 30464, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_120
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_120
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_120
        {
            INVERSE_PIXEL_VALUE_120_UNNAMED30720                             = 30720, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_120
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_120
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_120
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_120
        {
            FORWARD_PIXEL_VALUE_120_UNNAMED30720                             = 30720, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_120
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_120_UNNAMED30720              = 30720, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_121
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_121
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_121
        {
            INVERSE_PIXEL_VALUE_121_UNNAMED30976                             = 30976, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_121
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_121
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_121
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_121
        {
            FORWARD_PIXEL_VALUE_121_UNNAMED30976                             = 30976, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_121
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_121_UNNAMED30976              = 30976, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_122
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_122
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_122
        {
            INVERSE_PIXEL_VALUE_122_UNNAMED31232                             = 31232, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_122
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_122
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_122
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_122
        {
            FORWARD_PIXEL_VALUE_122_UNNAMED31232                             = 31232, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_122
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_122_UNNAMED31232              = 31232, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_123
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_123
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_123
        {
            INVERSE_PIXEL_VALUE_123_UNNAMED31488                             = 31488, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_123
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_123
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_123
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_123
        {
            FORWARD_PIXEL_VALUE_123_UNNAMED31488                             = 31488, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_123
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_123_UNNAMED31488              = 31488, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_124
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_124
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_124
        {
            INVERSE_PIXEL_VALUE_124_UNNAMED31744                             = 31744, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_124
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_124
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_124
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_124
        {
            FORWARD_PIXEL_VALUE_124_UNNAMED31744                             = 31744, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_124
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_124_UNNAMED31744              = 31744, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_125
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_125
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_125
        {
            INVERSE_PIXEL_VALUE_125_UNNAMED32000                             = 32000, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_125
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_125
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_125
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_125
        {
            FORWARD_PIXEL_VALUE_125_UNNAMED32000                             = 32000, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_125
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_125_UNNAMED32000              = 32000, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_126
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_126
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_126
        {
            INVERSE_PIXEL_VALUE_126_UNNAMED32256                             = 32256, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_126
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_126
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_126
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_126
        {
            FORWARD_PIXEL_VALUE_126_UNNAMED32256                             = 32256, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_126
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_126_UNNAMED32256              = 32256, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_127
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_127
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_127
        {
            INVERSE_PIXEL_VALUE_127_UNNAMED32512                             = 32512, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_127
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_127
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_127
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_127
        {
            FORWARD_PIXEL_VALUE_127_UNNAMED32512                             = 32512, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_127
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_127_UNNAMED32512              = 32512, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_128
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_128
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_128
        {
            INVERSE_PIXEL_VALUE_128_UNNAMED32768                             = 32768, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_128
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_128
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_128
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_128
        {
            FORWARD_PIXEL_VALUE_128_UNNAMED32768                             = 32768, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_128
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_128_UNNAMED32768              = 32768, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_129
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_129
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_129
        {
            INVERSE_PIXEL_VALUE_129_UNNAMED33024                             = 33024, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_129
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_129
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_129
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_129
        {
            FORWARD_PIXEL_VALUE_129_UNNAMED33024                             = 33024, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_129
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_129_UNNAMED33024              = 33024, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_130
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_130
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_130
        {
            INVERSE_PIXEL_VALUE_130_UNNAMED33280                             = 33280, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_130
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_130
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_130
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_130
        {
            FORWARD_PIXEL_VALUE_130_UNNAMED33280                             = 33280, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_130
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_130_UNNAMED33280              = 33280, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_131
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_131
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_131
        {
            INVERSE_PIXEL_VALUE_131_UNNAMED33536                             = 33536, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_131
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_131
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_131
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_131
        {
            FORWARD_PIXEL_VALUE_131_UNNAMED33536                             = 33536, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_131
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_131_UNNAMED33536              = 33536, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_132
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_132
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_132
        {
            INVERSE_PIXEL_VALUE_132_UNNAMED33792                             = 33792, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_132
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_132
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_132
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_132
        {
            FORWARD_PIXEL_VALUE_132_UNNAMED33792                             = 33792, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_132
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_132_UNNAMED33792              = 33792, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_133
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_133
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_133
        {
            INVERSE_PIXEL_VALUE_133_UNNAMED34048                             = 34048, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_133
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_133
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_133
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_133
        {
            FORWARD_PIXEL_VALUE_133_UNNAMED34048                             = 34048, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_133
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_133_UNNAMED34048              = 34048, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_134
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_134
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_134
        {
            INVERSE_PIXEL_VALUE_134_UNNAMED34304                             = 34304, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_134
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_134
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_134
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_134
        {
            FORWARD_PIXEL_VALUE_134_UNNAMED34304                             = 34304, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_134
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_134_UNNAMED34304              = 34304, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_135
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_135
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_135
        {
            INVERSE_PIXEL_VALUE_135_UNNAMED34560                             = 34560, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_135
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_135
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_135
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_135
        {
            FORWARD_PIXEL_VALUE_135_UNNAMED34560                             = 34560, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_135
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_135_UNNAMED34560              = 34560, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_136
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_136
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_136
        {
            INVERSE_PIXEL_VALUE_136_UNNAMED34816                             = 34816, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_136
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_136
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_136
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_136
        {
            FORWARD_PIXEL_VALUE_136_UNNAMED34816                             = 34816, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_136
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_136_UNNAMED34816              = 34816, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_137
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_137
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_137
        {
            INVERSE_PIXEL_VALUE_137_UNNAMED35072                             = 35072, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_137
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_137
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_137
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_137
        {
            FORWARD_PIXEL_VALUE_137_UNNAMED35072                             = 35072, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_137
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_137_UNNAMED35072              = 35072, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_138
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_138
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_138
        {
            INVERSE_PIXEL_VALUE_138_UNNAMED35328                             = 35328, //!< No additional details
        };

        enum INVERSE_R_CH_GAMMA_CORRECTED_VALUE_138
        {
            INVERSE_R_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, //!< No additional details
        };

        enum FORWARD_G_CH_GAMMA_CORRECTED_VALUE_138
        {
            FORWARD_G_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, //!< No additional details
        };

        enum FORWARD_B_CH_GAMMA_CORRECTED_VALUE_138
        {
            FORWARD_B_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, //!< No additional details
        };

        enum FORWARD_PIXEL_VALUE_138
        {
            FORWARD_PIXEL_VALUE_138_UNNAMED35328                             = 35328, //!< No additional details
        };

        enum FORWARD_R_CH_GAMMA_CORRECTED_VALUE_138
        {
            FORWARD_R_CH_GAMMA_CORRECTED_VALUE_138_UNNAMED35328              = 35328, //!< No additional details
        };

        enum INVERSE_G_CH_GAMMA_CORRECTED_VALUE_139
        {
            INVERSE_G_CH_GAMMA_CORRECTED_VALUE_139_UNNAMED35584              = 35584, //!< No additional details
        };

        enum INVERSE_B_CH_GAMMA_CORRECTED_VALUE_139
        {
            INVERSE_B_CH_GAMMA_CORRECTED_VALUE_139_UNNAMED35584              = 35584, //!< No additional details
        };

        enum INVERSE_PIXEL_VALUE_139
        {
            INVERSE_PIXEL_VALUE_