/* This file is part of OpenBubbles.
 *
 * OpenBubbles is an SDL clone of Bubbles.
 * Copyright (C) 2004  Benny Sperisen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * button.h contains declarations for buttons.
 *
 * Written by:
 *  Benny Sperisen
 *  lasindi@gmail.com
 *  www.freewebs.com/lasindi
 *****************************************************************************/

#ifndef BUTTON_H
#define BUTTON_H

#include "SDL.h"
#include "SDL_image.h"
#include <iostream>
#include <cstdlib>
#include <list>
using namespace std;

#include "screen.h"

enum STATES {NORMAL,HILIGHT,PRESSED};

class button
{
public:
  button(int x,int y,string image,char *name=NULL,
	 string image_hilight="",string image_pressed="");
  virtual void draw();
  bool within(int x,int y); /* Returns true if point (x,y) is on top of the
                             * button. */
  char state() const;
  char* name() const;
  virtual void setState(char state);
  virtual void freeSurfaces();
protected:
  SDL_Surface* _image;
  SDL_Surface* _image_hilight;
  SDL_Surface* _image_pressed;
  int _x;
  int _y;
  char* _name;
  char _state;
  int _w;
  int _h;
};

class checkbox: public button
{
public:
  checkbox(int x,int y,char *name,bool check=false);
  void draw();
  void setState(char state);
  bool checked() const;
  void freeSurfaces();
private:
  bool _checked;
  SDL_Surface* _image_unchecked;
  SDL_Surface* _unchecked_hilight;
};

// Should contain all of the buttons on the screen.
extern list<button*> buttons;
// Should contain all of the checkboxes on the screen.
extern list<checkbox*> checkboxes;
// Stores previous state of left mouse button.
extern char prevclickstate;

// Update the buttons as necessary. If one has been clicked, return its name.
char* handleButtons();

// Draw all of the buttons in buttons.
void drawButtons();

// Returns whether a checkbox with name is checked or not.
bool isChecked(string name);

#endif
