/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.features.command.completers.InstalledRepoNameCompleter;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="feature", name="list", description="Lists all existing features available from the defined repositories.")
@Service
public class ListFeaturesCommand
extends FeaturesCommandSupport {
    @Option(name="-i", aliases={"--installed"}, description="Display a list of all installed features only", required=false, multiValued=false)
    boolean onlyInstalled;
    @Option(name="-r", aliases={"--required"}, description="Display a list of all required features only", required=false, multiValued=false)
    boolean onlyRequired;
    @Option(name="-s", aliases={"--show-hidden"}, description="Display hidden features", required=false, multiValued=false)
    boolean showHidden;
    @Option(name="-b", aliases={"--show-blacklisted"}, description="Display blacklisted features", required=false, multiValued=false)
    boolean showBlacklisted;
    @Option(name="-o", aliases={"--ordered"}, description="Display a list using alphabetical order ", required=false, multiValued=false)
    boolean ordered;
    @Option(name="--repository", description="Only list features from that repository", required=false, multiValued=false)
    @Completion(value=InstalledRepoNameCompleter.class)
    String repository;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    @Override
    protected void doExecute(FeaturesService featuresService) throws Exception {
        boolean needsLegend = false;
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Version");
        table.column("Required");
        table.column("State");
        table.column("Repository");
        table.column("Description").maxSize(50);
        if (this.showBlacklisted) {
            table.column("Blacklisted");
        }
        table.emptyTableText(this.onlyInstalled ? "No features installed" : "No features available");
        if (this.repository != null) {
            List<Feature> features = Arrays.asList(featuresService.getRepository(this.repository).getFeatures());
            this.populateTable(featuresService, this.repository, features, table);
            needsLegend = this.isInstalledViaDeployDir(this.repository);
        } else {
            Repository[] repos;
            for (Repository r : repos = featuresService.listRepositories()) {
                String repoName = r.getName();
                this.populateTable(featuresService, repoName, Arrays.asList(r.getFeatures()), table);
                needsLegend = this.isInstalledViaDeployDir(repoName);
            }
        }
        table.print(System.out, !this.noFormat);
        if (needsLegend) {
            System.out.println("* Installed via deploy directory");
        }
    }

    private boolean isInstalledViaDeployDir(String st) {
        return st != null && st.length() > 1 && st.charAt(st.length() - 1) == '*';
    }

    private void populateTable(FeaturesService featuresService, String repositoryName, List<Feature> features, ShellTable table) {
        if (this.ordered) {
            features.sort(new FeatureComparator());
        }
        for (Feature f : features) {
            if (this.onlyInstalled && !featuresService.isInstalled(f) || this.onlyRequired && !featuresService.isRequired(f) || !this.showBlacklisted && f.isBlacklisted() || !this.showHidden && f.isHidden()) continue;
            Row row = table.addRow();
            row.addContent(new Object[]{f.getName(), f.getVersion(), featuresService.isRequired(f) ? "x" : "", featuresService.getState(f.getId()), repositoryName, f.getDescription()});
            if (!this.showBlacklisted) continue;
            row.addContent(new Object[]{f.isBlacklisted() ? "yes" : "no"});
        }
    }

    class FeatureComparator
    implements Comparator<Feature> {
        FeatureComparator() {
        }

        @Override
        public int compare(Feature o1, Feature o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

