/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.chartpart.ChartZoom;
import org.knowm.xchart.internal.chartpart.ToolTips;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public abstract class PlotContent_<ST extends Styler, S extends Series>
implements ChartPart {
    final Chart<ST, S> chart;
    ToolTips toolTips;
    ChartZoom chartZoom;
    static final BasicStroke ERROR_BAR_STROKE = new BasicStroke(1.0f, 0, 2);

    PlotContent_(Chart<ST, S> chart) {
        this.chart = chart;
    }

    protected abstract void doPaint(Graphics2D var1);

    @Override
    public void paint(Graphics2D g) {
        Rectangle2D bounds = this.getBounds();
        if (bounds.getWidth() < 30.0) {
            return;
        }
        Shape saveClip = g.getClip();
        if (saveClip != null) {
            g.setClip(bounds.createIntersection(saveClip.getBounds2D()));
        } else {
            g.setClip(bounds);
        }
        if (((Styler)this.chart.getStyler()).isToolTipsEnabled() && this.toolTips != null) {
            this.toolTips.clearData();
        }
        this.doPaint(g);
        if (((Styler)this.chart.getStyler()).isToolTipsEnabled() && this.toolTips != null) {
            this.toolTips.paint(g);
        }
        if (this.chart instanceof XYChart && ((XYStyler)this.chart.getStyler()).isZoomEnabled()) {
            this.chartZoom.paint(g);
        }
        g.setClip(saveClip);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.chart.getPlot().getBounds();
    }

    void closePath(Graphics2D g, Path2D.Double path, double previousX, Rectangle2D bounds, double yTopMargin) {
        if (path != null) {
            double yBottomOfArea = this.getBounds().getY() + this.getBounds().getHeight() - yTopMargin;
            path.lineTo(previousX, yBottomOfArea);
            path.closePath();
            g.fill(path);
        }
    }

    public void setToolTips(ToolTips toolTips) {
        this.toolTips = toolTips;
    }

    public void setChartZoom(ChartZoom chartZoom) {
        this.chartZoom = chartZoom;
    }
}

