package confidentialledgerapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/confidentialledger/mgmt/2020-12-01-preview/confidentialledger"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result confidentialledger.ResourceProviderOperationListPage, err error)
	ListComplete(ctx context.Context) (result confidentialledger.ResourceProviderOperationListIterator, err error)
}

var _ OperationsClientAPI = (*confidentialledger.OperationsClient)(nil)

// LedgerClientAPI contains the set of methods on the LedgerClient type.
type LedgerClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, ledgerName string, confidentialLedger confidentialledger.Model) (result confidentialledger.LedgerCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, ledgerName string) (result confidentialledger.LedgerDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, ledgerName string) (result confidentialledger.Model, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, filter string) (result confidentialledger.ListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, filter string) (result confidentialledger.ListIterator, err error)
	ListBySubscription(ctx context.Context, filter string) (result confidentialledger.ListPage, err error)
	ListBySubscriptionComplete(ctx context.Context, filter string) (result confidentialledger.ListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, ledgerName string, confidentialLedger confidentialledger.Model) (result confidentialledger.LedgerUpdateFuture, err error)
}

var _ LedgerClientAPI = (*confidentialledger.LedgerClient)(nil)
