package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExtractPhone invokes the address_purification.ExtractPhone API synchronously
func (client *Client) ExtractPhone(request *ExtractPhoneRequest) (response *ExtractPhoneResponse, err error) {
	response = CreateExtractPhoneResponse()
	err = client.DoAction(request, response)
	return
}

// ExtractPhoneWithChan invokes the address_purification.ExtractPhone API asynchronously
func (client *Client) ExtractPhoneWithChan(request *ExtractPhoneRequest) (<-chan *ExtractPhoneResponse, <-chan error) {
	responseChan := make(chan *ExtractPhoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExtractPhone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExtractPhoneWithCallback invokes the address_purification.ExtractPhone API asynchronously
func (client *Client) ExtractPhoneWithCallback(request *ExtractPhoneRequest, callback func(response *ExtractPhoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExtractPhoneResponse
		var err error
		defer close(result)
		response, err = client.ExtractPhone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExtractPhoneRequest is the request struct for api ExtractPhone
type ExtractPhoneRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// ExtractPhoneResponse is the response struct for api ExtractPhone
type ExtractPhoneResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateExtractPhoneRequest creates a request to invoke ExtractPhone API
func CreateExtractPhoneRequest() (request *ExtractPhoneRequest) {
	request = &ExtractPhoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "ExtractPhone", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExtractPhoneResponse creates a response to parse from ExtractPhone response
func CreateExtractPhoneResponse() (response *ExtractPhoneResponse) {
	response = &ExtractPhoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
