package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWhiteListStrategyCount invokes the aegis.DescribeWhiteListStrategyCount API synchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategycount.html
func (client *Client) DescribeWhiteListStrategyCount(request *DescribeWhiteListStrategyCountRequest) (response *DescribeWhiteListStrategyCountResponse, err error) {
	response = CreateDescribeWhiteListStrategyCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWhiteListStrategyCountWithChan invokes the aegis.DescribeWhiteListStrategyCount API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategycount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWhiteListStrategyCountWithChan(request *DescribeWhiteListStrategyCountRequest) (<-chan *DescribeWhiteListStrategyCountResponse, <-chan error) {
	responseChan := make(chan *DescribeWhiteListStrategyCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWhiteListStrategyCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWhiteListStrategyCountWithCallback invokes the aegis.DescribeWhiteListStrategyCount API asynchronously
// api document: https://help.aliyun.com/api/aegis/describewhiteliststrategycount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeWhiteListStrategyCountWithCallback(request *DescribeWhiteListStrategyCountRequest, callback func(response *DescribeWhiteListStrategyCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWhiteListStrategyCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeWhiteListStrategyCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWhiteListStrategyCountRequest is the request struct for api DescribeWhiteListStrategyCount
type DescribeWhiteListStrategyCountRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeWhiteListStrategyCountResponse is the response struct for api DescribeWhiteListStrategyCount
type DescribeWhiteListStrategyCountResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	StrategyCount int    `json:"StrategyCount" xml:"StrategyCount"`
}

// CreateDescribeWhiteListStrategyCountRequest creates a request to invoke DescribeWhiteListStrategyCount API
func CreateDescribeWhiteListStrategyCountRequest() (request *DescribeWhiteListStrategyCountRequest) {
	request = &DescribeWhiteListStrategyCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeWhiteListStrategyCount", "vipaegis", "openAPI")
	return
}

// CreateDescribeWhiteListStrategyCountResponse creates a response to parse from DescribeWhiteListStrategyCount response
func CreateDescribeWhiteListStrategyCountResponse() (response *DescribeWhiteListStrategyCountResponse) {
	response = &DescribeWhiteListStrategyCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
