package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemovePersonalNumbersFromUser invokes the ccc.RemovePersonalNumbersFromUser API synchronously
func (client *Client) RemovePersonalNumbersFromUser(request *RemovePersonalNumbersFromUserRequest) (response *RemovePersonalNumbersFromUserResponse, err error) {
	response = CreateRemovePersonalNumbersFromUserResponse()
	err = client.DoAction(request, response)
	return
}

// RemovePersonalNumbersFromUserWithChan invokes the ccc.RemovePersonalNumbersFromUser API asynchronously
func (client *Client) RemovePersonalNumbersFromUserWithChan(request *RemovePersonalNumbersFromUserRequest) (<-chan *RemovePersonalNumbersFromUserResponse, <-chan error) {
	responseChan := make(chan *RemovePersonalNumbersFromUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemovePersonalNumbersFromUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemovePersonalNumbersFromUserWithCallback invokes the ccc.RemovePersonalNumbersFromUser API asynchronously
func (client *Client) RemovePersonalNumbersFromUserWithCallback(request *RemovePersonalNumbersFromUserRequest, callback func(response *RemovePersonalNumbersFromUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemovePersonalNumbersFromUserResponse
		var err error
		defer close(result)
		response, err = client.RemovePersonalNumbersFromUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemovePersonalNumbersFromUserRequest is the request struct for api RemovePersonalNumbersFromUser
type RemovePersonalNumbersFromUserRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	NumberList string `position:"Query" name:"NumberList"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// RemovePersonalNumbersFromUserResponse is the response struct for api RemovePersonalNumbersFromUser
type RemovePersonalNumbersFromUserResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateRemovePersonalNumbersFromUserRequest creates a request to invoke RemovePersonalNumbersFromUser API
func CreateRemovePersonalNumbersFromUserRequest() (request *RemovePersonalNumbersFromUserRequest) {
	request = &RemovePersonalNumbersFromUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "RemovePersonalNumbersFromUser", "", "")
	request.Method = requests.POST
	return
}

// CreateRemovePersonalNumbersFromUserResponse creates a response to parse from RemovePersonalNumbersFromUser response
func CreateRemovePersonalNumbersFromUserResponse() (response *RemovePersonalNumbersFromUserResponse) {
	response = &RemovePersonalNumbersFromUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
